#ifndef SDS_FIVISITOR_HEADER
#define SDS_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class sds_fi_tclOutput {
public:
   sds_fi_tclOutput();
   virtual ~sds_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class sds_fi_tclFileOutput : public sds_fi_tclOutput 
{
public:
   sds_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   sds_fi_tclFileOutput(); //lint !e1704
   sds_fi_tclFileOutput& operator=(const sds_fi_tclFileOutput& coRef);
   sds_fi_tclFileOutput(const sds_fi_tclFileOutput& coRef); //lint !e1704
};

class sds_fi_tclMemOutput : public sds_fi_tclOutput
{
public:
   sds_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~sds_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   sds_fi_tclMemOutput(); //lint !e1704
   sds_fi_tclMemOutput(const sds_fi_tclMemOutput& coRef); //lint !e1704
   sds_fi_tclMemOutput& operator=(const sds_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL sds_fi_tclVisitorBase {
public:

   // --Konstruktor
   sds_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~sds_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitF32(sds_fi_tclF32& oF32);
   virtual tVoid vVisitF64(sds_fi_tclF64& oF64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(sds_fi_tclList& oList);
   virtual tVoid vVisit_e8_BinContainerTypes(sds_fi_tcl_e8_BinContainerTypes& oe8_BinContainerTypes);

   virtual tVoid vVisit_BinContainer(sds_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& oe16_ISO639_3_SDSLanguageCode);

   virtual tVoid vVisit_e8_Slot(sds_fi_tcl_e8_Slot& oe8_Slot);

   virtual tVoid vVisit_e8_Domain(sds_fi_tcl_e8_Domain& oe8_Domain);

   virtual tVoid vVisit_e8_ConnectedDeviceUpdateStatus(sds_fi_tcl_e8_ConnectedDeviceUpdateStatus& oe8_ConnectedDeviceUpdateStatus);

   virtual tVoid vVisit_e8_PromptSetting(sds_fi_tcl_e8_PromptSetting& oe8_PromptSetting);

   virtual tVoid vVisit_e8_WordType(sds_fi_tcl_e8_WordType& oe8_WordType);

   virtual tVoid vVisit_e8_NDSFeatureType(sds_fi_tcl_e8_NDSFeatureType& oe8_NDSFeatureType);

   virtual tVoid vVisit_e32_SSE_ASR_Mode(sds_fi_tcl_e32_SSE_ASR_Mode& oe32_SSE_ASR_Mode);

   virtual tVoid vVisit_e8_SDSDestinationType(sds_fi_tcl_e8_SDSDestinationType& oe8_SDSDestinationType);

   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_ConnectedDeviceStatus(sds_fi_tcl_ConnectedDeviceStatus& oConnectedDeviceStatus);

   virtual tVoid vVisit_NDSLanguageID(sds_fi_tcl_NDSLanguageID& oNDSLanguageID);

   virtual tVoid vVisit_NDSID(sds_fi_tcl_NDSID& oNDSID);

   virtual tVoid vVisit_StreetAvailability(sds_fi_tcl_StreetAvailability& oStreetAvailability);

   virtual tVoid vVisit_PhonemeForLanguage(sds_fi_tcl_PhonemeForLanguage& oPhonemeForLanguage);

   virtual tVoid vVisit_StringAndPhoneme(sds_fi_tcl_StringAndPhoneme& oStringAndPhoneme);

   virtual tVoid vVisit_StatePhoneme(sds_fi_tcl_StatePhoneme& oStatePhoneme);

   virtual tVoid vVisit_CountryPhoneme(sds_fi_tcl_CountryPhoneme& oCountryPhoneme);

   virtual tVoid vVisit_CityId(sds_fi_tcl_CityId& oCityId);

   virtual tVoid vVisit_ECNR_ASR_Mode_Status(sds_fi_tcl_ECNR_ASR_Mode_Status& oECNR_ASR_Mode_Status);

   virtual tVoid vVisit_Reserved(sds_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(sds_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(sds_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(sds_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(sds_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(sds_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(sds_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(sds_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(sds_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(sds_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(sds_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(sds_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(sds_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(sds_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(sds_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(sds_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(sds_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(sds_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(sds_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(sds_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(sds_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(sds_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(sds_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(sds_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(sds_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(sds_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(sds_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(sds_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(sds_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(sds_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(sds_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(sds_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(sds_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(sds_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(sds_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_SDSLanguageID(sds_fi_tcl_SDSLanguageID& oSDSLanguageID);

   virtual tVoid vVisit_e16_ISOLanguageCode(sds_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(sds_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(sds_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(sds_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(sds_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(sds_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(sds_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(sds_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(sds_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(sds_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_e16_SelectionCriterionType(sds_fi_tcl_e16_SelectionCriterionType& oe16_SelectionCriterionType);

   virtual tVoid vVisit_e8_LocationDescriptionDataType(sds_fi_tcl_e8_LocationDescriptionDataType& oe8_LocationDescriptionDataType);

   virtual tVoid vVisit_b8_LocationDescriptorStatus(sds_fi_tcl_b8_LocationDescriptorStatus& ob8_LocationDescriptorStatus);

   virtual tVoid vVisit_LocationDescriptor(sds_fi_tcl_LocationDescriptor& oLocationDescriptor);

   virtual tVoid vVisit_LocationDescription(sds_fi_tcl_LocationDescription& oLocationDescription);

   virtual tVoid vVisit_StringPosition(sds_fi_tcl_StringPosition& oStringPosition);

   virtual tVoid vVisit_StringID(sds_fi_tcl_StringID& oStringID);

   virtual tVoid vVisit_FLIString(sds_fi_tcl_FLIString& oFLIString);

   virtual tVoid vVisit_b8_PositionStatus(sds_fi_tcl_b8_PositionStatus& ob8_PositionStatus);

   virtual tVoid vVisit_ListOfPositions(sds_fi_tcl_ListOfPositions& oListOfPositions);

   virtual tVoid vVisit_b16_PositionReliability(sds_fi_tcl_b16_PositionReliability& ob16_PositionReliability);

   virtual tVoid vVisit_PositionHeadingSpeed(sds_fi_tcl_PositionHeadingSpeed& oPositionHeadingSpeed);

   virtual tVoid vVisit_u32_DataSetId(sds_fi_tcl_u32_DataSetId& ou32_DataSetId);

   virtual tVoid vVisit_u32_MediaId(sds_fi_tcl_u32_MediaId& ou32_MediaId);

   virtual tVoid vVisit_NavClusterDesc(sds_fi_tcl_NavClusterDesc& oNavClusterDesc);

   virtual tVoid vVisit_e8_NavDataLevel(sds_fi_tcl_e8_NavDataLevel& oe8_NavDataLevel);

   virtual tVoid vVisit_e8_NavOneCellDirection(sds_fi_tcl_e8_NavOneCellDirection& oe8_NavOneCellDirection);

   virtual tVoid vVisit_NavOneCellDesc(sds_fi_tcl_NavOneCellDesc& oNavOneCellDesc);

   virtual tVoid vVisit_e8_SideInfo(sds_fi_tcl_e8_SideInfo& oe8_SideInfo);

   virtual tVoid vVisit_s32_EMU(sds_fi_tcl_s32_EMU& os32_EMU);

   virtual tVoid vVisit_NavZeroCellDesc(sds_fi_tcl_NavZeroCellDesc& oNavZeroCellDesc);

   virtual tVoid vVisit_NavOneCell(sds_fi_tcl_NavOneCell& oNavOneCell);

   virtual tVoid vVisit_e8_NavOneCellCategory(sds_fi_tcl_e8_NavOneCellCategory& oe8_NavOneCellCategory);

   virtual tVoid vVisit_e8_NavLocationDescType(sds_fi_tcl_e8_NavLocationDescType& oe8_NavLocationDescType);

   virtual tVoid vVisit_NavLocationDesc(sds_fi_tcl_NavLocationDesc& oNavLocationDesc);

#ifndef FI_S_EXTERNAL_FI
   virtual tVoid vVisit_NavLocationBinContainer(sds_fi_tcl_NavLocationBinContainer& oNavLocationBinContainer);

#endif // FI_S_EXTERNAL_FI
   virtual tVoid vVisit_e8_NavIndexZFDestinationType(sds_fi_tcl_e8_NavIndexZFDestinationType& oe8_NavIndexZFDestinationType);

   virtual tVoid vVisit_e8_NavLocationNavDataType(sds_fi_tcl_e8_NavLocationNavDataType& oe8_NavLocationNavDataType);

   virtual tVoid vVisit_NavLocationDataDesc(sds_fi_tcl_NavLocationDataDesc& oNavLocationDataDesc);

   virtual tVoid vVisit_NavSpotDestinationOneCellProperty(sds_fi_tcl_NavSpotDestinationOneCellProperty& oNavSpotDestinationOneCellProperty);

   virtual tVoid vVisit_NavSpotDestinationOneCellDesc(sds_fi_tcl_NavSpotDestinationOneCellDesc& oNavSpotDestinationOneCellDesc);

   virtual tVoid vVisit_NavSpotDestinationOneCellListSet(sds_fi_tcl_NavSpotDestinationOneCellListSet& oNavSpotDestinationOneCellListSet);

   virtual tVoid vVisit_NavStreetDestinationOneCellProperty(sds_fi_tcl_NavStreetDestinationOneCellProperty& oNavStreetDestinationOneCellProperty);

   virtual tVoid vVisit_NavStreetDestinationOneCellDesc(sds_fi_tcl_NavStreetDestinationOneCellDesc& oNavStreetDestinationOneCellDesc);

   virtual tVoid vVisit_NavStreetDestinationOneCellListSet(sds_fi_tcl_NavStreetDestinationOneCellListSet& oNavStreetDestinationOneCellListSet);

   virtual tVoid vVisit_e8_NavIntersectionType(sds_fi_tcl_e8_NavIntersectionType& oe8_NavIntersectionType);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellProperty(sds_fi_tcl_NavIntersectionDestinationZeroCellProperty& oNavIntersectionDestinationZeroCellProperty);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellDesc(sds_fi_tcl_NavIntersectionDestinationZeroCellDesc& oNavIntersectionDestinationZeroCellDesc);

   virtual tVoid vVisit_NavIntersectionDestinationZeroCellListSet(sds_fi_tcl_NavIntersectionDestinationZeroCellListSet& oNavIntersectionDestinationZeroCellListSet);

   virtual tVoid vVisit_NavAreaDescriptionCircle(sds_fi_tcl_NavAreaDescriptionCircle& oNavAreaDescriptionCircle);

   virtual tVoid vVisit_NavAreaDescriptionPolygon(sds_fi_tcl_NavAreaDescriptionPolygon& oNavAreaDescriptionPolygon);

   virtual tVoid vVisit_u64_tPVoid(sds_fi_tcl_u64_tPVoid& ou64_tPVoid);

   virtual tVoid vVisit_e8_VDLCategoryName(sds_fi_tcl_e8_VDLCategoryName& oe8_VDLCategoryName);

   virtual tVoid vVisit_e8_SDSLocationType(sds_fi_tcl_e8_SDSLocationType& oe8_SDSLocationType);

   virtual tVoid vVisit_e8_ListType(sds_fi_tcl_e8_ListType& oe8_ListType);

   virtual tVoid vVisit_CurrentCountry(sds_fi_tcl_CurrentCountry& oCurrentCountry);

   virtual tVoid vVisit_CurrentState(sds_fi_tcl_CurrentState& oCurrentState);

   virtual tVoid vVisit_CurrentCity(sds_fi_tcl_CurrentCity& oCurrentCity);

   virtual tVoid vVisit_NameID(sds_fi_tcl_NameID& oNameID);

   virtual tVoid vVisit_SDSDestinationEntry(sds_fi_tcl_SDSDestinationEntry& oSDSDestinationEntry);

   virtual tVoid vVisit_SDSIDTranscriptionsEntry(sds_fi_tcl_SDSIDTranscriptionsEntry& oSDSIDTranscriptionsEntry);

   virtual tVoid vVisit_e8_AudioSourceID(sds_fi_tcl_e8_AudioSourceID& oe8_AudioSourceID);

   virtual tVoid vVisit_e8SequenceCategory(sds_fi_tcl_e8SequenceCategory& oe8SequenceCategory);

   virtual tVoid vVisit_e8_TextStyleOption(sds_fi_tcl_e8_TextStyleOption& oe8_TextStyleOption);

   virtual tVoid vVisit_e8_StatusInfoOption(sds_fi_tcl_e8_StatusInfoOption& oe8_StatusInfoOption);

   virtual tVoid vVisit_e8_BufferingOption(sds_fi_tcl_e8_BufferingOption& oe8_BufferingOption);

   virtual tVoid vVisit_e8_PromptAbortOption(sds_fi_tcl_e8_PromptAbortOption& oe8_PromptAbortOption);

   virtual tVoid vVisit_e8_TTSStatus(sds_fi_tcl_e8_TTSStatus& oe8_TTSStatus);

   virtual tVoid vVisit_e8_JobStatus(sds_fi_tcl_e8_JobStatus& oe8_JobStatus);

   virtual tVoid vVisit_e8_ReleaseTypeTTS(sds_fi_tcl_e8_ReleaseTypeTTS& oe8_ReleaseTypeTTS);

   virtual tVoid vVisit_e8_TTSTunType(sds_fi_tcl_e8_TTSTunType& oe8_TTSTunType);

   virtual tVoid vVisit_e8_TunSrc(sds_fi_tcl_e8_TunSrc& oe8_TunSrc);

   virtual tVoid vVisit_e8_TTSDomain(sds_fi_tcl_e8_TTSDomain& oe8_TTSDomain);

   virtual tVoid vVisit_Phoneme(sds_fi_tcl_Phoneme& oPhoneme);

   virtual tVoid vVisit_SpeakProgress(sds_fi_tcl_SpeakProgress& oSpeakProgress);

   virtual tVoid vVisit_FileLocation(sds_fi_tcl_FileLocation& oFileLocation);

   virtual tVoid vVisit_BufferingProgress(sds_fi_tcl_BufferingProgress& oBufferingProgress);

   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& oe8_VoiceGender);

   virtual tVoid vVisit_TTSVersionInfo(sds_fi_tcl_TTSVersionInfo& oTTSVersionInfo);

   virtual tVoid vVisit_TTSPhonemeResult(sds_fi_tcl_TTSPhonemeResult& oTTSPhonemeResult);

   virtual tVoid vVisit_TTSTuningFile(sds_fi_tcl_TTSTuningFile& oTTSTuningFile);

   virtual tVoid vVisit_TTSVoiceInfo(sds_fi_tcl_TTSVoiceInfo& oTTSVoiceInfo);

   virtual tVoid vVisit_e8_PathType(sds_fi_tcl_e8_PathType& oe8_PathType);

   virtual tVoid vVisit_VoiceType(sds_fi_tcl_VoiceType& oVoiceType);

   virtual tVoid vVisit_e8_DataCarrier(sds_fi_tcl_e8_DataCarrier& oe8_DataCarrier);

   virtual tVoid vVisit_e8_UserWordUsage(sds_fi_tcl_e8_UserWordUsage& oe8_UserWordUsage);

   virtual tVoid vVisit_e8_CountryType(sds_fi_tcl_e8_CountryType& oe8_CountryType);

   virtual tVoid vVisit_e8_StorageDevice(sds_fi_tcl_e8_StorageDevice& oe8_StorageDevice);

   virtual tVoid vVisit_e8_FileAvailability(sds_fi_tcl_e8_FileAvailability& oe8_FileAvailability);

   virtual tVoid vVisit_e8_FileType(sds_fi_tcl_e8_FileType& oe8_FileType);

   virtual tVoid vVisit_e8_FileAccessMode(sds_fi_tcl_e8_FileAccessMode& oe8_FileAccessMode);

   virtual tVoid vVisit_e8_FileAccessResult(sds_fi_tcl_e8_FileAccessResult& oe8_FileAccessResult);

   virtual tVoid vVisit_e8_ContextType(sds_fi_tcl_e8_ContextType& oe8_ContextType);

   virtual tVoid vVisit_e8_DestinationCategory(sds_fi_tcl_e8_DestinationCategory& oe8_DestinationCategory);

   virtual tVoid vVisit_e8_ReleaseTypeSDP(sds_fi_tcl_e8_ReleaseTypeSDP& oe8_ReleaseTypeSDP);

   virtual tVoid vVisit_e8_UwCategories(sds_fi_tcl_e8_UwCategories& oe8_UwCategories);

   virtual tVoid vVisit_e8_TTSFileType(sds_fi_tcl_e8_TTSFileType& oe8_TTSFileType);

   virtual tVoid vVisit_e8_ContextFileType(sds_fi_tcl_e8_ContextFileType& oe8_ContextFileType);

   virtual tVoid vVisit_e8_SemBufferFileType(sds_fi_tcl_e8_SemBufferFileType& oe8_SemBufferFileType);

   virtual tVoid vVisit_e8_TranscriptionFileType(sds_fi_tcl_e8_TranscriptionFileType& oe8_TranscriptionFileType);

   virtual tVoid vVisit_e8_CountrySupportType(sds_fi_tcl_e8_CountrySupportType& oe8_CountrySupportType);

   virtual tVoid vVisit_e8_TTSEngineType(sds_fi_tcl_e8_TTSEngineType& oe8_TTSEngineType);

   virtual tVoid vVisit_AvailableLanguage(sds_fi_tcl_AvailableLanguage& oAvailableLanguage);

   virtual tVoid vVisit_AvailableTTSVoices(sds_fi_tcl_AvailableTTSVoices& oAvailableTTSVoices);

   virtual tVoid vVisit_VoiceDescription(sds_fi_tcl_VoiceDescription& oVoiceDescription);

   virtual tVoid vVisit_DictionaryGroup(sds_fi_tcl_DictionaryGroup& oDictionaryGroup);

   virtual tVoid vVisit_AvailableCountry(sds_fi_tcl_AvailableCountry& oAvailableCountry);

   virtual tVoid vVisit_TTSTunningFile(sds_fi_tcl_TTSTunningFile& oTTSTunningFile);

   virtual tVoid vVisit_TTSVoiceFile(sds_fi_tcl_TTSVoiceFile& oTTSVoiceFile);

   virtual tVoid vVisit_ContextFile(sds_fi_tcl_ContextFile& oContextFile);

   virtual tVoid vVisit_SemBufferFile(sds_fi_tcl_SemBufferFile& oSemBufferFile);

   virtual tVoid vVisit_ConnectDevice(sds_fi_tcl_ConnectDevice& oConnectDevice);

   virtual tVoid vVisit_DynamicContextFile(sds_fi_tcl_DynamicContextFile& oDynamicContextFile);

   virtual tVoid vVisit_TranscriptionFile(sds_fi_tcl_TranscriptionFile& oTranscriptionFile);

   virtual tVoid vVisit_UserAudioFile(sds_fi_tcl_UserAudioFile& oUserAudioFile);

   virtual tVoid vVisit_e8_SpeechSupportInfoType(sds_fi_tcl_e8_SpeechSupportInfoType& oe8_SpeechSupportInfoType);

   virtual tVoid vVisit_SpeakerInfoType(sds_fi_tcl_SpeakerInfoType& oSpeakerInfoType);

   virtual tVoid vVisit_I2SNameIDs(sds_fi_tcl_I2SNameIDs& oI2SNameIDs);

   virtual tVoid vVisit_DynamicCtxStatus(sds_fi_tcl_DynamicCtxStatus& oDynamicCtxStatus);

   virtual tVoid vVisit_DynamicDataContextMetaFile(sds_fi_tcl_DynamicDataContextMetaFile& oDynamicDataContextMetaFile);

   virtual tVoid vVisit_CityWithStreets(sds_fi_tcl_CityWithStreets& oCityWithStreets);

   virtual tVoid vVisit_WordWithPhoneme(sds_fi_tcl_WordWithPhoneme& oWordWithPhoneme);

   virtual tVoid vVisit_VcData(sds_fi_tcl_VcData& oVcData);

   virtual tVoid vVisit_BlobData(sds_fi_tcl_BlobData& oBlobData);

   virtual tVoid vVisit_e8_SDNLocation(sds_fi_tcl_e8_SDNLocation& oe8_SDNLocation);

   virtual tVoid vVisit_e8_AddressType(sds_fi_tcl_e8_AddressType& oe8_AddressType);

   virtual tVoid vVisit_e8_SettingsType(sds_fi_tcl_e8_SettingsType& oe8_SettingsType);

   virtual tVoid vVisit_e8_RecogStatus(sds_fi_tcl_e8_RecogStatus& oe8_RecogStatus);

   virtual tVoid vVisit_e8_DataCategory(sds_fi_tcl_e8_DataCategory& oe8_DataCategory);

   virtual tVoid vVisit_RecogFromFile(sds_fi_tcl_RecogFromFile& oRecogFromFile);

   virtual tVoid vVisit_RecogToFile(sds_fi_tcl_RecogToFile& oRecogToFile);

   virtual tVoid vVisit_REC_Settings(sds_fi_tcl_REC_Settings& oREC_Settings);

   virtual tVoid vVisit_e8_WUWStatus(sds_fi_tcl_e8_WUWStatus& oe8_WUWStatus);

   virtual tVoid vVisit_u32_FrontEndParam(sds_fi_tcl_u32_FrontEndParam& ou32_FrontEndParam);

   virtual tVoid vVisit_u32_RecParam(sds_fi_tcl_u32_RecParam& ou32_RecParam);

   virtual tVoid vVisit_u32_ContextParam(sds_fi_tcl_u32_ContextParam& ou32_ContextParam);

   virtual tVoid vVisit_e8RecogAbnormalEvents(sds_fi_tcl_e8RecogAbnormalEvents& oe8RecogAbnormalEvents);

   virtual tVoid vVisit_e8_RecogResultType(sds_fi_tcl_e8_RecogResultType& oe8_RecogResultType);

   virtual tVoid vVisit_e8_RecResultInterfaceType(sds_fi_tcl_e8_RecResultInterfaceType& oe8_RecResultInterfaceType);

   virtual tVoid vVisit_e8_USWTrainingType(sds_fi_tcl_e8_USWTrainingType& oe8_USWTrainingType);

   virtual tVoid vVisit_RecogNBestResultWordInfo(sds_fi_tcl_RecogNBestResultWordInfo& oRecogNBestResultWordInfo);

   virtual tVoid vVisit_SemConfig(sds_fi_tcl_SemConfig& oSemConfig);

   virtual tVoid vVisit_SemResultSlotInfo(sds_fi_tcl_SemResultSlotInfo& oSemResultSlotInfo);

   virtual tVoid vVisit_SemResultInterpretations(sds_fi_tcl_SemResultInterpretations& oSemResultInterpretations);

   virtual tVoid vVisit_RecogNBestResult(sds_fi_tcl_RecogNBestResult& oRecogNBestResult);

   virtual tVoid vVisit_RecogSemResult(sds_fi_tcl_RecogSemResult& oRecogSemResult);

   virtual tVoid vVisit_RecogNaviNBestResult(sds_fi_tcl_RecogNaviNBestResult& oRecogNaviNBestResult);

   virtual tVoid vVisit_FrontEndParameter(sds_fi_tcl_FrontEndParameter& oFrontEndParameter);

   virtual tVoid vVisit_RecParameter(sds_fi_tcl_RecParameter& oRecParameter);

   virtual tVoid vVisit_ContextParameter(sds_fi_tcl_ContextParameter& oContextParameter);

   virtual tVoid vVisit_e8_VoconComponent(sds_fi_tcl_e8_VoconComponent& oe8_VoconComponent);

   virtual tVoid vVisit_e8_VoconComponentStatus(sds_fi_tcl_e8_VoconComponentStatus& oe8_VoconComponentStatus);

   virtual tVoid vVisit_e8_PrompterStatus(sds_fi_tcl_e8_PrompterStatus& oe8_PrompterStatus);

   virtual tVoid vVisit_e8_ReleaseTypePP(sds_fi_tcl_e8_ReleaseTypePP& oe8_ReleaseTypePP);

   virtual tVoid vVisit_e8_VarType(sds_fi_tcl_e8_VarType& oe8_VarType);

   virtual tVoid vVisit_e16_OrderingType(sds_fi_tcl_e16_OrderingType& oe16_OrderingType);

   virtual tVoid vVisit_e16_SpeechAppDictType(sds_fi_tcl_e16_SpeechAppDictType& oe16_SpeechAppDictType);

   virtual tVoid vVisit_e8_PPJobStatus(sds_fi_tcl_e8_PPJobStatus& oe8_PPJobStatus);

   virtual tVoid vVisit_e8_DlgAppID(sds_fi_tcl_e8_DlgAppID& oe8_DlgAppID);

   virtual tVoid vVisit_e8_PromptLength(sds_fi_tcl_e8_PromptLength& oe8_PromptLength);

   virtual tVoid vVisit_PromptListStatus(sds_fi_tcl_PromptListStatus& oPromptListStatus);

   virtual tVoid vVisit_PhraseVariable(sds_fi_tcl_PhraseVariable& oPhraseVariable);

   virtual tVoid vVisit_PlayProgress(sds_fi_tcl_PlayProgress& oPlayProgress);

   virtual tVoid vVisit_e8_SD_Format(sds_fi_tcl_e8_SD_Format& oe8_SD_Format);

   virtual tVoid vVisit_u16_SD_SampleFrequency(sds_fi_tcl_u16_SD_SampleFrequency& ou16_SD_SampleFrequency);

   virtual tVoid vVisit_SD_Settings(sds_fi_tcl_SD_Settings& oSD_Settings);

   virtual tVoid vVisit_e8_AudioMode(sds_fi_tcl_e8_AudioMode& oe8_AudioMode);

   virtual tVoid vVisit_e8_SDSTestCase(sds_fi_tcl_e8_SDSTestCase& oe8_SDSTestCase);

   virtual tVoid vVisit_e8_PushButtonOption(sds_fi_tcl_e8_PushButtonOption& oe8_PushButtonOption);

   virtual tVoid vVisit_e8_Application(sds_fi_tcl_e8_Application& oe8_Application);

   virtual tVoid vVisit_e8_ListeningStatus(sds_fi_tcl_e8_ListeningStatus& oe8_ListeningStatus);

   virtual tVoid vVisit_e8_PopUp_UpdateType(sds_fi_tcl_e8_PopUp_UpdateType& oe8_PopUp_UpdateType);

   virtual tVoid vVisit_e8_GEN_SelectionType(sds_fi_tcl_e8_GEN_SelectionType& oe8_GEN_SelectionType);

   virtual tVoid vVisit_e8_TUN_Status(sds_fi_tcl_e8_TUN_Status& oe8_TUN_Status);

   virtual tVoid vVisit_e8_TUN_Band(sds_fi_tcl_e8_TUN_Band& oe8_TUN_Band);

   virtual tVoid vVisit_e8_TUN_MemBank(sds_fi_tcl_e8_TUN_MemBank& oe8_TUN_MemBank);

   virtual tVoid vVisit_e8_TUN_Setting(sds_fi_tcl_e8_TUN_Setting& oe8_TUN_Setting);

   virtual tVoid vVisit_e8_PHN_Status(sds_fi_tcl_e8_PHN_Status& oe8_PHN_Status);

   virtual tVoid vVisit_e8_PHN_HWType(sds_fi_tcl_e8_PHN_HWType& oe8_PHN_HWType);

   virtual tVoid vVisit_e8_PHN_MenuType(sds_fi_tcl_e8_PHN_MenuType& oe8_PHN_MenuType);

   virtual tVoid vVisit_e8_PHN_Setting(sds_fi_tcl_e8_PHN_Setting& oe8_PHN_Setting);

   virtual tVoid vVisit_e8_PHN_ListType(sds_fi_tcl_e8_PHN_ListType& oe8_PHN_ListType);

   virtual tVoid vVisit_e8_PHN_NumberType(sds_fi_tcl_e8_PHN_NumberType& oe8_PHN_NumberType);

   virtual tVoid vVisit_e8_NAV_Status(sds_fi_tcl_e8_NAV_Status& oe8_NAV_Status);

   virtual tVoid vVisit_e8_NAV_MenuType(sds_fi_tcl_e8_NAV_MenuType& oe8_NAV_MenuType);

   virtual tVoid vVisit_e8_NAV_NavUnit(sds_fi_tcl_e8_NAV_NavUnit& oe8_NAV_NavUnit);

   virtual tVoid vVisit_e8_NAV_ZoomLevel(sds_fi_tcl_e8_NAV_ZoomLevel& oe8_NAV_ZoomLevel);

   virtual tVoid vVisit_e8_NAV_RouteCriteria(sds_fi_tcl_e8_NAV_RouteCriteria& oe8_NAV_RouteCriteria);

   virtual tVoid vVisit_e8_NAV_Setting(sds_fi_tcl_e8_NAV_Setting& oe8_NAV_Setting);

   virtual tVoid vVisit_e8_NAV_MapMode(sds_fi_tcl_e8_NAV_MapMode& oe8_NAV_MapMode);

   virtual tVoid vVisit_e8_NAV_ListType(sds_fi_tcl_e8_NAV_ListType& oe8_NAV_ListType);

   virtual tVoid vVisit_e8_CDA_Slot(sds_fi_tcl_e8_CDA_Slot& oe8_CDA_Slot);

   virtual tVoid vVisit_e8_ProgressInfo(sds_fi_tcl_e8_ProgressInfo& oe8_ProgressInfo);

   virtual tVoid vVisit_e8_VoiceControlStatus(sds_fi_tcl_e8_VoiceControlStatus& oe8_VoiceControlStatus);

   virtual tVoid vVisit_e8_Sentence(sds_fi_tcl_e8_Sentence& oe8_Sentence);

   virtual tVoid vVisit_Userword(sds_fi_tcl_Userword& oUserword);

   virtual tVoid vVisit_Progress(sds_fi_tcl_Progress& oProgress);

   virtual tVoid vVisit_VR_Speaker(sds_fi_tcl_VR_Speaker& oVR_Speaker);

   virtual tVoid vVisit_LanguageAndSpeaker(sds_fi_tcl_LanguageAndSpeaker& oLanguageAndSpeaker);

   virtual tVoid vVisit_CountryType(sds_fi_tcl_CountryType& oCountryType);

   virtual tVoid vVisit_HomeDestCountry(sds_fi_tcl_HomeDestCountry& oHomeDestCountry);

   virtual tVoid vVisit_DestEntry(sds_fi_tcl_DestEntry& oDestEntry);

   virtual tVoid vVisit_PhoneEntry(sds_fi_tcl_PhoneEntry& oPhoneEntry);

   virtual tVoid vVisit_e8_AudioChannelAdvice(sds_fi_tcl_e8_AudioChannelAdvice& oe8_AudioChannelAdvice);

   virtual tVoid vVisit_e8_VoiceCategory(sds_fi_tcl_e8_VoiceCategory& oe8_VoiceCategory);

   virtual tVoid vVisit_e8_CatStatus(sds_fi_tcl_e8_CatStatus& oe8_CatStatus);

   virtual tVoid vVisit_AudioChannelAdvice(sds_fi_tcl_AudioChannelAdvice& oAudioChannelAdvice);

   virtual tVoid vVisit_b8_AudioOutputLocation(sds_fi_tcl_b8_AudioOutputLocation& ob8_AudioOutputLocation);

   virtual tVoid vVisit_b8_AudioFormat(sds_fi_tcl_b8_AudioFormat& ob8_AudioFormat);

   virtual tVoid vVisit_InstancesPerCategory(sds_fi_tcl_InstancesPerCategory& oInstancesPerCategory);

   virtual tVoid vVisit_InstancesPerCategoryList(sds_fi_tcl_InstancesPerCategoryList& oInstancesPerCategoryList);

   virtual tVoid vVisit_b16_RequestAddInfo(sds_fi_tcl_b16_RequestAddInfo& ob16_RequestAddInfo);

   virtual tVoid vVisit_ChannelRequestStatus(sds_fi_tcl_ChannelRequestStatus& oChannelRequestStatus);

   virtual tVoid vVisit_ChannelRequestStatusList(sds_fi_tcl_ChannelRequestStatusList& oChannelRequestStatusList);

   virtual tVoid vVisit_e8_TSStatus(sds_fi_tcl_e8_TSStatus& oe8_TSStatus);

   virtual tVoid vVisit_e8_DeviceContextStatus(sds_fi_tcl_e8_DeviceContextStatus& oe8_DeviceContextStatus);

   virtual tVoid vVisit_e8_DynamicDataStatus(sds_fi_tcl_e8_DynamicDataStatus& oe8_DynamicDataStatus);

   virtual tVoid vVisit_e8_Category(sds_fi_tcl_e8_Category& oe8_Category);

   virtual tVoid vVisit_e8_ContextUpdateStatus(sds_fi_tcl_e8_ContextUpdateStatus& oe8_ContextUpdateStatus);

   virtual tVoid vVisit_WordTransMap(sds_fi_tcl_WordTransMap& oWordTransMap);

   virtual tVoid vVisit_DynamicDataStatus(sds_fi_tcl_DynamicDataStatus& oDynamicDataStatus);

   virtual tVoid vVisit_IdTransMap(sds_fi_tcl_IdTransMap& oIdTransMap);

   virtual tVoid vVisit_e8_DeviceContextAvailability(sds_fi_tcl_e8_DeviceContextAvailability& oe8_DeviceContextAvailability);

   virtual tVoid vVisit_ContextOverFlowStatus(sds_fi_tcl_ContextOverFlowStatus& oContextOverFlowStatus);

   virtual tVoid vVisit_SlotAvailabilty(sds_fi_tcl_SlotAvailabilty& oSlotAvailabilty);

   virtual tVoid vVisit_WordSlot(sds_fi_tcl_WordSlot& oWordSlot);

   virtual tVoid vVisit_WordTransSlot(sds_fi_tcl_WordTransSlot& oWordTransSlot);

   virtual tVoid vVisit_WordInfo(sds_fi_tcl_WordInfo& oWordInfo);

   virtual tVoid vVisit_ListElements(sds_fi_tcl_ListElements& oListElements);

   virtual tVoid vVisit_ListEntries(sds_fi_tcl_ListEntries& oListEntries);

   virtual tVoid vVisit_ListContextStatus(sds_fi_tcl_ListContextStatus& oListContextStatus);

   virtual tVoid vVisit_WordPhonemeMap(sds_fi_tcl_WordPhonemeMap& oWordPhonemeMap);

   virtual tVoid vVisit_e8_MPL_Status(sds_fi_tcl_e8_MPL_Status& oe8_MPL_Status);

   virtual tVoid vVisit_e8_MPL_SourceType(sds_fi_tcl_e8_MPL_SourceType& oe8_MPL_SourceType);

   virtual tVoid vVisit_e8_MPL_MenuType(sds_fi_tcl_e8_MPL_MenuType& oe8_MPL_MenuType);

   virtual tVoid vVisit_e8_DeviceStatus(sds_fi_tcl_e8_DeviceStatus& oe8_DeviceStatus);

   virtual tVoid vVisit_e8_SDS2HMI_PHN_Status(sds_fi_tcl_e8_SDS2HMI_PHN_Status& oe8_SDS2HMI_PHN_Status);

   virtual tVoid vVisit_e8_SDS2HMI_PHN_MenuType(sds_fi_tcl_e8_SDS2HMI_PHN_MenuType& oe8_SDS2HMI_PHN_MenuType);

   virtual tVoid vVisit_e8_SDS2HMI_TUN_Status(sds_fi_tcl_e8_SDS2HMI_TUN_Status& oe8_SDS2HMI_TUN_Status);

   virtual tVoid vVisit_e8_SDS2HMI_TUN_Band(sds_fi_tcl_e8_SDS2HMI_TUN_Band& oe8_SDS2HMI_TUN_Band);

   virtual tVoid vVisit_e8_NDS_SDN_Status(sds_fi_tcl_e8_NDS_SDN_Status& oe8_NDS_SDN_Status);

   virtual tVoid vVisit_DeviceStatus(sds_fi_tcl_DeviceStatus& oDeviceStatus);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
