/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_TRANSCRIPTIONSERVICE_FI message types

fi_tclMessageBase* sds_transcriptionservicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgInformPausestateMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgInformPausestateMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetLanguageMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetLanguageMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgInformLanguageMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgInformLanguageMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgReleaseDataMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgReleaseDataMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCreateListContextMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgCreateListContextMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODSTART:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart;

      case sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODRESULT:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSStatusGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSStatusUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSRELUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSStatusRelUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSSTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSStatusStatus;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSRELUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus;

      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgDynamicDataStatusGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSRELUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSSTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgContextOverflowGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgContextOverflowUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWRELUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWSTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgContextOverflowStatus;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSRELUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSSTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGEGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgLanguageGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGESTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgLanguageStatus;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgListContextStatusGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgListContextStatusUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSRELUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSSTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgListContextStatusStatus;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSGET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSRELUPREG:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSET:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet;

      case sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSTATUS:
         return OSAL_NEW sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_transcriptionservicefifi messages

// common functions

tU16 sds_transcriptionservicefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_TRANSCRIPTIONSERVICEFI_C_U16_SERVICE_ID;
}

tU16 sds_transcriptionservicefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_transcriptionservicefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_transcriptionservicefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_transcriptionservicefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_transcriptionservicefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   stWords = coRef.stWords;
   e8Slot = coRef.e8Slot;
   u8NumofTrans = coRef.u8NumofTrans;
}
sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   stWords = coRef.stWords;
   e8Slot = coRef.e8Slot;
   u8NumofTrans = coRef.u8NumofTrans;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < stWords.size(); ++u32Idx)
         stWords[u32Idx].vDestroy();
   stWords.clear();
   }
}

sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart()

:e8Slot()
,u8NumofTrans(0)
 {}

tS32 sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODSTART;
}


sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::~sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < stWords.size(); ++u32ListIdx)
      u32DynamicSize += stWords[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < stWords.size(); ++u32Idx)
      {
         stWords[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      stWords.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> stWords[u32Idx]);
      }
   }
   (tVoid) (oIn >> e8Slot);
   (tVoid) (oIn >> u8NumofTrans);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)stWords.size());
   {
      for (tU32 u32Idx = 0; u32Idx < stWords.size(); ++u32Idx)
         (tVoid) (oOut << stWords[u32Idx]);
   }
   (tVoid) (oOut << e8Slot);
   (tVoid) (oOut << u8NumofTrans);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart::operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (stWords.size() == roRef.stWords.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < stWords.size()); ++u32Idx)
            bResult = bResult && (stWords[u32Idx] == roRef.stWords[u32Idx]);
      }
   bResult = bResult && (e8Slot == roRef.e8Slot);
   bResult = bResult && (u8NumofTrans == roRef.u8NumofTrans);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   WordTranscriptionsMap = coRef.WordTranscriptionsMap;
}
sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   WordTranscriptionsMap = coRef.WordTranscriptionsMap;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < WordTranscriptionsMap.size(); ++u32Idx)
         WordTranscriptionsMap[u32Idx].vDestroy();
   WordTranscriptionsMap.clear();
   }
}

sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult()

 {}

tS32 sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::~sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < WordTranscriptionsMap.size(); ++u32ListIdx)
      u32DynamicSize += WordTranscriptionsMap[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < WordTranscriptionsMap.size(); ++u32Idx)
      {
         WordTranscriptionsMap[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      WordTranscriptionsMap.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> WordTranscriptionsMap[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)WordTranscriptionsMap.size());
   {
      for (tU32 u32Idx = 0; u32Idx < WordTranscriptionsMap.size(); ++u32Idx)
         (tVoid) (oOut << WordTranscriptionsMap[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult::operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (WordTranscriptionsMap.size() == roRef.WordTranscriptionsMap.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < WordTranscriptionsMap.size()); ++u32Idx)
            bResult = bResult && (WordTranscriptionsMap[u32Idx] == roRef.WordTranscriptionsMap[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart::sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart()
 {}

tS32 sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART;
}


sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart::~sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodStart()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult::sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult::~sds_transcriptionservicefi_tclMsgDoUpRegToPropertiesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart(const sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   e8Domain = coRef.e8Domain;
   szSlot = coRef.szSlot;
}
sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::operator=(const sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Domain = coRef.e8Domain;
   szSlot = coRef.szSlot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::vDestroy()
{
   szSlot.vDestroy();
}

sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart()
:e8Domain()
,szSlot()
 {}

tS32 sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::~sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+szSlot.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Domain);
   (tVoid) (oIn >> szSlot);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Domain);
   (tVoid) (oOut << szSlot);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart::operator==(const sds_transcriptionservicefi_tclMsgConfigurePronounceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Domain == roRef.e8Domain);
   bResult = bResult && (szSlot == roRef.szSlot);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult::sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONFIGUREPRONOUNCEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult::~sds_transcriptionservicefi_tclMsgConfigurePronounceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart(const sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
   poComponent = coRef.poComponent;
}
sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::operator=(const sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   poComponent = coRef.poComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart()
:e8VoconComponent()
,poComponent()
 {}

tS32 sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODSTART;
}


sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::~sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   (tVoid) (oIn >> poComponent);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   (tVoid) (oOut << poComponent);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart::operator==(const sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   bResult = bResult && (poComponent == roRef.poComponent);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult::sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult::~sds_transcriptionservicefi_tclMsgVoconComponentInitializedMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart(const sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
}
sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::operator=(const sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart()
:e8VoconComponent()
 {}

tS32 sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODSTART;
}


sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::~sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart::operator==(const sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult::sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult::~sds_transcriptionservicefi_tclMsgVoconComponentUnInitializedMethodResult()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart::sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart()
 {}

tS32 sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART;
}


sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart::~sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodStart()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult::sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult::~sds_transcriptionservicefi_tclMsgReInitializeVoconComponentMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart(const sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   e8Domain = coRef.e8Domain;
   strSlotType = coRef.strSlotType;
   u32ChunkStatus = coRef.u32ChunkStatus;
   u32TotalItems = coRef.u32TotalItems;
}
sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::operator=(const sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   e8Domain = coRef.e8Domain;
   strSlotType = coRef.strSlotType;
   u32ChunkStatus = coRef.u32ChunkStatus;
   u32TotalItems = coRef.u32TotalItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::vDestroy()
{
   strSlotType.vDestroy();
}

sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart()
:u32DeviceId(0)
,e8Domain()
,strSlotType()
,u32ChunkStatus(0)
,u32TotalItems(0)
 {}

tS32 sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::~sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+strSlotType.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> e8Domain);
   (tVoid) (oIn >> strSlotType);
   (tVoid) (oIn >> u32ChunkStatus);
   (tVoid) (oIn >> u32TotalItems);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << e8Domain);
   (tVoid) (oOut << strSlotType);
   (tVoid) (oOut << u32ChunkStatus);
   (tVoid) (oOut << u32TotalItems);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart::operator==(const sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (e8Domain == roRef.e8Domain);
   bResult = bResult && (strSlotType == roRef.strSlotType);
   bResult = bResult && (u32ChunkStatus == roRef.u32ChunkStatus);
   bResult = bResult && (u32TotalItems == roRef.u32TotalItems);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult::sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RESUMECONTEXTUPDATEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult::~sds_transcriptionservicefi_tclMsgResumeContextUpdateMethodResult()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgInformPausestateMethodStart::sds_transcriptionservicefi_tclMsgInformPausestateMethodStart()
 {}

tS32 sds_transcriptionservicefi_tclMsgInformPausestateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgInformPausestateMethodStart::~sds_transcriptionservicefi_tclMsgInformPausestateMethodStart()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgInformPausestateMethodResult::sds_transcriptionservicefi_tclMsgInformPausestateMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgInformPausestateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_INFORMPAUSESTATEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgInformPausestateMethodResult::~sds_transcriptionservicefi_tclMsgInformPausestateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::sds_transcriptionservicefi_tclMsgSetLanguageMethodStart(const sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::operator=(const sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::sds_transcriptionservicefi_tclMsgSetLanguageMethodStart()
:Language()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::~sds_transcriptionservicefi_tclMsgSetLanguageMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgSetLanguageMethodStart::operator==(const sds_transcriptionservicefi_tclMsgSetLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgSetLanguageMethodResult::sds_transcriptionservicefi_tclMsgSetLanguageMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgSetLanguageMethodResult::~sds_transcriptionservicefi_tclMsgSetLanguageMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::sds_transcriptionservicefi_tclMsgInformLanguageMethodStart(const sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::operator=(const sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::sds_transcriptionservicefi_tclMsgInformLanguageMethodStart()
:Language()
 {}

tS32 sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::~sds_transcriptionservicefi_tclMsgInformLanguageMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgInformLanguageMethodStart::operator==(const sds_transcriptionservicefi_tclMsgInformLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgInformLanguageMethodResult::sds_transcriptionservicefi_tclMsgInformLanguageMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgInformLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_INFORMLANGUAGEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgInformLanguageMethodResult::~sds_transcriptionservicefi_tclMsgInformLanguageMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart(const sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::operator=(const sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart()
:Language()
 {}

tS32 sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODSTART;
}


sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::~sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart::operator==(const sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult::sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CREATETSRESOURCESMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult::~sds_transcriptionservicefi_tclMsgCreateTSResourcesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart(const sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   bOnError = coRef.bOnError;
}
sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::operator=(const sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bOnError = coRef.bOnError;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart()
:bOnError(0)
 {}

tS32 sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODSTART;
}


sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::~sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bOnError);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bOnError);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart::operator==(const sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bOnError == roRef.bOnError);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult::sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CLOSETSRESOURCESMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult::~sds_transcriptionservicefi_tclMsgCloseTSResourcesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   stWordSlots = coRef.stWordSlots;
   u8NumofTrans = coRef.u8NumofTrans;
}
sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& coRef)
{
   if (this == &coRef) return *this;
   stWordSlots = coRef.stWordSlots;
   u8NumofTrans = coRef.u8NumofTrans;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < stWordSlots.size(); ++u32Idx)
         stWordSlots[u32Idx].vDestroy();
   stWordSlots.clear();
   }
}

sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart()

:u8NumofTrans(0)
 {}

tS32 sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODSTART;
}


sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::~sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < stWordSlots.size(); ++u32ListIdx)
      u32DynamicSize += stWordSlots[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < stWordSlots.size(); ++u32Idx)
      {
         stWordSlots[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      stWordSlots.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> stWordSlots[u32Idx]);
      }
   }
   (tVoid) (oIn >> u8NumofTrans);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)stWordSlots.size());
   {
      for (tU32 u32Idx = 0; u32Idx < stWordSlots.size(); ++u32Idx)
         (tVoid) (oOut << stWordSlots[u32Idx]);
   }
   (tVoid) (oOut << u8NumofTrans);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart::operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (stWordSlots.size() == roRef.stWordSlots.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < stWordSlots.size()); ++u32Idx)
            bResult = bResult && (stWordSlots[u32Idx] == roRef.stWordSlots[u32Idx]);
      }
   bResult = bResult && (u8NumofTrans == roRef.u8NumofTrans);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   stWordTransSlot = coRef.stWordTransSlot;
}
sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& coRef)
{
   if (this == &coRef) return *this;
   stWordTransSlot = coRef.stWordTransSlot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < stWordTransSlot.size(); ++u32Idx)
         stWordTransSlot[u32Idx].vDestroy();
   stWordTransSlot.clear();
   }
}

sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult()

 {}

tS32 sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSTTSMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::~sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < stWordTransSlot.size(); ++u32ListIdx)
      u32DynamicSize += stWordTransSlot[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < stWordTransSlot.size(); ++u32Idx)
      {
         stWordTransSlot[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      stWordTransSlot.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> stWordTransSlot[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)stWordTransSlot.size());
   {
      for (tU32 u32Idx = 0; u32Idx < stWordTransSlot.size(); ++u32Idx)
         (tVoid) (oOut << stWordTransSlot[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult::operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsTTSMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (stWordTransSlot.size() == roRef.stWordTransSlot.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < stWordTransSlot.size()); ++u32Idx)
            bResult = bResult && (stWordTransSlot[u32Idx] == roRef.stWordTransSlot[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgReleaseDataMethodStart::sds_transcriptionservicefi_tclMsgReleaseDataMethodStart()
 {}

tS32 sds_transcriptionservicefi_tclMsgReleaseDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODSTART;
}


sds_transcriptionservicefi_tclMsgReleaseDataMethodStart::~sds_transcriptionservicefi_tclMsgReleaseDataMethodStart()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgReleaseDataMethodResult::sds_transcriptionservicefi_tclMsgReleaseDataMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgReleaseDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgReleaseDataMethodResult::~sds_transcriptionservicefi_tclMsgReleaseDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart(const sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   e8Domain = coRef.e8Domain;
}
sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::operator=(const sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   e8Domain = coRef.e8Domain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart()
:u32DeviceId(0)
,e8Domain()
 {}

tS32 sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::~sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> e8Domain);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << e8Domain);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart::operator==(const sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (e8Domain == roRef.e8Domain);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult::sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_HANDLENEWDEVICEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult::~sds_transcriptionservicefi_tclMsgHandleNewDeviceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart(const sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
}
sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::operator=(const sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart()
:e8VoconComponent()
 {}

tS32 sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODSTART;
}


sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::~sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart::operator==(const sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult::sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult::~sds_transcriptionservicefi_tclMsgConfirmVoconActivityStopMethodResult()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart::sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart()
 {}

tS32 sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODSTART;
}


sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart::~sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodStart()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult::sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGECHANGESUCCESSMETHODRESULT;
}


sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult::~sds_transcriptionservicefi_tclMsglanguagechangesuccessMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   e8ListType = coRef.e8ListType;
   u32PageNumber = coRef.u32PageNumber;
   ListEntries = coRef.ListEntries;
}
sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   e8ListType = coRef.e8ListType;
   u32PageNumber = coRef.u32PageNumber;
   ListEntries = coRef.ListEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < ListEntries.size(); ++u32Idx)
         ListEntries[u32Idx].vDestroy();
   ListEntries.clear();
   }
}

sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart()
:LanguageID()
,CountryCode()
,e8ListType()
,u32PageNumber(0)

 {}

tS32 sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODSTART;
}


sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::~sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListEntries.size(); ++u32ListIdx)
      u32DynamicSize += ListEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+15;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> e8ListType);
   (tVoid) (oIn >> u32PageNumber);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListEntries.size(); ++u32Idx)
      {
         ListEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListEntries[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << e8ListType);
   (tVoid) (oOut << u32PageNumber);
   (tVoid) (oOut << (tU32)ListEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListEntries.size(); ++u32Idx)
         (tVoid) (oOut << ListEntries[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart::operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (e8ListType == roRef.e8ListType);
   bResult = bResult && (u32PageNumber == roRef.u32PageNumber);
      bResult = bResult && (ListEntries.size() == roRef.ListEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListEntries.size()); ++u32Idx)
            bResult = bResult && (ListEntries[u32Idx] == roRef.ListEntries[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   IDTranscriptionsMap = coRef.IDTranscriptionsMap;
   u32PageNumber = coRef.u32PageNumber;
}
sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::operator=(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   IDTranscriptionsMap = coRef.IDTranscriptionsMap;
   u32PageNumber = coRef.u32PageNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < IDTranscriptionsMap.size(); ++u32Idx)
         IDTranscriptionsMap[u32Idx].vDestroy();
   IDTranscriptionsMap.clear();
   }
}

sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult()

:u32PageNumber(0)
 {}

tS32 sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_GETTRANSCRIPTIONSFORLISTMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::~sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IDTranscriptionsMap.size(); ++u32ListIdx)
      u32DynamicSize += IDTranscriptionsMap[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IDTranscriptionsMap.size(); ++u32Idx)
      {
         IDTranscriptionsMap[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IDTranscriptionsMap.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IDTranscriptionsMap[u32Idx]);
      }
   }
   (tVoid) (oIn >> u32PageNumber);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)IDTranscriptionsMap.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IDTranscriptionsMap.size(); ++u32Idx)
         (tVoid) (oOut << IDTranscriptionsMap[u32Idx]);
   }
   (tVoid) (oOut << u32PageNumber);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult::operator==(const sds_transcriptionservicefi_tclMsgGetTranscriptionsForListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (IDTranscriptionsMap.size() == roRef.IDTranscriptionsMap.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IDTranscriptionsMap.size()); ++u32Idx)
            bResult = bResult && (IDTranscriptionsMap[u32Idx] == roRef.IDTranscriptionsMap[u32Idx]);
      }
   bResult = bResult && (u32PageNumber == roRef.u32PageNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart(const sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   szTraceCmd = coRef.szTraceCmd;
}
sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::operator=(const sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szTraceCmd = coRef.szTraceCmd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::vDestroy()
{
   szTraceCmd.vDestroy();
}

sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart()
:szTraceCmd()
 {}

tS32 sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::~sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szTraceCmd.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szTraceCmd);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szTraceCmd);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart::operator==(const sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szTraceCmd == roRef.szTraceCmd);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult::sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDPHONEUPDATEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult::~sds_transcriptionservicefi_tclMsgTraceCmdPhoneUpdateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart(const sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   szTraceCmd = coRef.szTraceCmd;
}
sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::operator=(const sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szTraceCmd = coRef.szTraceCmd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::vDestroy()
{
   szTraceCmd.vDestroy();
}

sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart()
:szTraceCmd()
 {}

tS32 sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::~sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szTraceCmd.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szTraceCmd);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szTraceCmd);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart::operator==(const sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szTraceCmd == roRef.szTraceCmd);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult::sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDMEDIAUPDATEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult::~sds_transcriptionservicefi_tclMsgTraceCmdMediaUpdateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart(const sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   szTraceCmd = coRef.szTraceCmd;
}
sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::operator=(const sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szTraceCmd = coRef.szTraceCmd;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::vDestroy()
{
   szTraceCmd.vDestroy();
}

sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart()
:szTraceCmd()
 {}

tS32 sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODSTART;
}


sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::~sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szTraceCmd.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szTraceCmd);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szTraceCmd);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart::operator==(const sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szTraceCmd == roRef.szTraceCmd);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult::sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TRACECMDTUNERUPDATEMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult::~sds_transcriptionservicefi_tclMsgTraceCmdTunerUpdateMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart(const sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   szDBPath = coRef.szDBPath;
}
sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::operator=(const sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDBPath = coRef.szDBPath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::vDestroy()
{
   szDBPath.vDestroy();
}

sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart()
:szDBPath()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODSTART;
}


sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::~sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDBPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDBPath);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDBPath);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart::operator==(const sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDBPath == roRef.szDBPath);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult::sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETPHONEDBPATHMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult::~sds_transcriptionservicefi_tclMsgSetPhoneDBPathMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart(const sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   szDBPath = coRef.szDBPath;
}
sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::operator=(const sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szDBPath = coRef.szDBPath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::vDestroy()
{
   szDBPath.vDestroy();
}

sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart()
:szDBPath()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODSTART;
}


sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::~sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szDBPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szDBPath);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szDBPath);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart::operator==(const sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szDBPath == roRef.szDBPath);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult::sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETMEDIADBPATHMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult::~sds_transcriptionservicefi_tclMsgSetMediaDBPathMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart(const sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   szDBPath = coRef.szDBPath;
}
sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::operator=(const sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   szDBPath = coRef.szDBPath;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::vDestroy()
{
   szDBPath.vDestroy();
}

sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart()
:u32DeviceId(0)
,szDBPath()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODSTART;
}


sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::~sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+szDBPath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> szDBPath);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << szDBPath);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart::operator==(const sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (szDBPath == roRef.szDBPath);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult::sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_SETTUNERDBPATHMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult::~sds_transcriptionservicefi_tclMsgSetTunerDBPathMethodResult()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart::sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart()
 {}

tS32 sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODSTART;
}


sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart::~sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodStart()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult::sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_FREEEXCESSHEAPMEMORYMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult::~sds_transcriptionservicefi_tclMsgFreeExcessHeapMemoryMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart(const sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   bTraceHeap = coRef.bTraceHeap;
}
sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::operator=(const sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bTraceHeap = coRef.bTraceHeap;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart()
:bTraceHeap(0)
 {}

tS32 sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODSTART;
}


sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::~sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart()
{}

tU32 sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTraceHeap);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTraceHeap);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart::operator==(const sds_transcriptionservicefi_tclMsgLogHeapStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTraceHeap == roRef.bTraceHeap);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult::sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LOGHEAPSTATUSMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult::~sds_transcriptionservicefi_tclMsgLogHeapStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart(const sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   CountryStateList = coRef.CountryStateList;
}
sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::operator=(const sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CountryStateList = coRef.CountryStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         CountryStateList[u32Idx].vDestroy();
   CountryStateList.clear();
   }
}

sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart()

 {}

tS32 sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODSTART;
}


sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::~sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CountryStateList.size(); ++u32ListIdx)
      u32DynamicSize += CountryStateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
      {
         CountryStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CountryStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CountryStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CountryStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         (tVoid) (oOut << CountryStateList[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart::operator==(const sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CountryStateList.size() == roRef.CountryStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryStateList.size()); ++u32Idx)
            bResult = bResult && (CountryStateList[u32Idx] == roRef.CountryStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult::sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CREATECOUNTRYSTATELISTMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult::~sds_transcriptionservicefi_tclMsgCreateCountryStateListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::sds_transcriptionservicefi_tclMsgCreateListContextMethodStart(const sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   e8Domain = coRef.e8Domain;
   e8WordType = coRef.e8WordType;
   IsPhonemeAvailable = coRef.IsPhonemeAvailable;
   stWordPhonemeMap = coRef.stWordPhonemeMap;
}
sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::operator=(const sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Domain = coRef.e8Domain;
   e8WordType = coRef.e8WordType;
   IsPhonemeAvailable = coRef.IsPhonemeAvailable;
   stWordPhonemeMap = coRef.stWordPhonemeMap;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < stWordPhonemeMap.size(); ++u32Idx)
         stWordPhonemeMap[u32Idx].vDestroy();
   stWordPhonemeMap.clear();
   }
}

sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::sds_transcriptionservicefi_tclMsgCreateListContextMethodStart()
:e8Domain()
,e8WordType()
,IsPhonemeAvailable(0)

 {}

tS32 sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODSTART;
}


sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::~sds_transcriptionservicefi_tclMsgCreateListContextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < stWordPhonemeMap.size(); ++u32ListIdx)
      u32DynamicSize += stWordPhonemeMap[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Domain);
   (tVoid) (oIn >> e8WordType);
   (tVoid) (oIn >> IsPhonemeAvailable);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < stWordPhonemeMap.size(); ++u32Idx)
      {
         stWordPhonemeMap[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      stWordPhonemeMap.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> stWordPhonemeMap[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Domain);
   (tVoid) (oOut << e8WordType);
   (tVoid) (oOut << IsPhonemeAvailable);
   (tVoid) (oOut << (tU32)stWordPhonemeMap.size());
   {
      for (tU32 u32Idx = 0; u32Idx < stWordPhonemeMap.size(); ++u32Idx)
         (tVoid) (oOut << stWordPhonemeMap[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgCreateListContextMethodStart::operator==(const sds_transcriptionservicefi_tclMsgCreateListContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Domain == roRef.e8Domain);
   bResult = bResult && (e8WordType == roRef.e8WordType);
   bResult = bResult && (IsPhonemeAvailable == roRef.IsPhonemeAvailable);
      bResult = bResult && (stWordPhonemeMap.size() == roRef.stWordPhonemeMap.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < stWordPhonemeMap.size()); ++u32Idx)
            bResult = bResult && (stWordPhonemeMap[u32Idx] == roRef.stWordPhonemeMap[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgCreateListContextMethodResult::sds_transcriptionservicefi_tclMsgCreateListContextMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgCreateListContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CREATELISTCONTEXTMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgCreateListContextMethodResult::~sds_transcriptionservicefi_tclMsgCreateListContextMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart(const sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   ListContextStatus = coRef.ListContextStatus;
}
sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::operator=(const sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListContextStatus = coRef.ListContextStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListContextStatus.size(); ++u32Idx)
         ListContextStatus[u32Idx].vDestroy();
   ListContextStatus.clear();
   }
}

sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart()

 {}

tS32 sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODSTART;
}


sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::~sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ListContextStatus.size()*3;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListContextStatus.size(); ++u32Idx)
      {
         ListContextStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListContextStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListContextStatus[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListContextStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListContextStatus.size(); ++u32Idx)
         (tVoid) (oOut << ListContextStatus[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart::operator==(const sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListContextStatus.size() == roRef.ListContextStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListContextStatus.size()); ++u32Idx)
            bResult = bResult && (ListContextStatus[u32Idx] == roRef.ListContextStatus[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult::sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult()
 {}

tS32 sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_UPDATELISTCONTEXTPROPERTYMETHODRESULT;
}


sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult::~sds_transcriptionservicefi_tclMsgUpdateListContextPropertyMethodResult()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgTSStatusGet::sds_transcriptionservicefi_tclMsgTSStatusGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSStatusGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSGET;
}


sds_transcriptionservicefi_tclMsgTSStatusGet::~sds_transcriptionservicefi_tclMsgTSStatusGet()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgTSStatusUpReg::sds_transcriptionservicefi_tclMsgTSStatusUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSUPREG;
}


sds_transcriptionservicefi_tclMsgTSStatusUpReg::~sds_transcriptionservicefi_tclMsgTSStatusUpReg()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgTSStatusRelUpReg::sds_transcriptionservicefi_tclMsgTSStatusRelUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSRELUPREG;
}


sds_transcriptionservicefi_tclMsgTSStatusRelUpReg::~sds_transcriptionservicefi_tclMsgTSStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgTSStatusStatus::sds_transcriptionservicefi_tclMsgTSStatusStatus(const sds_transcriptionservicefi_tclMsgTSStatusStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   TSStatus = coRef.TSStatus;
}
sds_transcriptionservicefi_tclMsgTSStatusStatus& sds_transcriptionservicefi_tclMsgTSStatusStatus::operator=(const sds_transcriptionservicefi_tclMsgTSStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TSStatus = coRef.TSStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgTSStatusStatus::sds_transcriptionservicefi_tclMsgTSStatusStatus()
:TSStatus()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSSTATUSSTATUS;
}


sds_transcriptionservicefi_tclMsgTSStatusStatus::~sds_transcriptionservicefi_tclMsgTSStatusStatus()
{}

tU32 sds_transcriptionservicefi_tclMsgTSStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgTSStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TSStatus);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgTSStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TSStatus);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgTSStatusStatus::operator==(const sds_transcriptionservicefi_tclMsgTSStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TSStatus == roRef.TSStatus);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet::sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSGET;
}


sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet::~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusGet()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg::sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSUPREG;
}


sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg::~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusUpReg()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg::sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSRELUPREG;
}


sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg::~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   ConnectedDeviceStatus = coRef.ConnectedDeviceStatus;
   MediaState = coRef.MediaState;
   e8Slot = coRef.e8Slot;
}
sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::operator=(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   ConnectedDeviceStatus = coRef.ConnectedDeviceStatus;
   MediaState = coRef.MediaState;
   e8Slot = coRef.e8Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
         ConnectedDeviceStatus[u32Idx].vDestroy();
   ConnectedDeviceStatus.clear();
   }
   {
   e8Slot.clear();
   }
}

sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus()

:MediaState(0)

 {}

tS32 sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSTATUS;
}


sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::~sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+ConnectedDeviceStatus.size()*6+e8Slot.size()*1;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
      {
         ConnectedDeviceStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ConnectedDeviceStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ConnectedDeviceStatus[u32Idx]);
      }
   }
   (tVoid) (oIn >> MediaState);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      e8Slot.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> e8Slot[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ConnectedDeviceStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
         (tVoid) (oOut << ConnectedDeviceStatus[u32Idx]);
   }
   (tVoid) (oOut << MediaState);
   (tVoid) (oOut << (tU32)e8Slot.size());
   {
      for (tU32 u32Idx = 0; u32Idx < e8Slot.size(); ++u32Idx)
         (tVoid) (oOut << e8Slot[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus::operator==(const sds_transcriptionservicefi_tclMsgConnectedDeviceStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ConnectedDeviceStatus.size() == roRef.ConnectedDeviceStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ConnectedDeviceStatus.size()); ++u32Idx)
            bResult = bResult && (ConnectedDeviceStatus[u32Idx] == roRef.ConnectedDeviceStatus[u32Idx]);
      }
   bResult = bResult && (MediaState == roRef.MediaState);
      bResult = bResult && (e8Slot.size() == roRef.e8Slot.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < e8Slot.size()); ++u32Idx)
            bResult = bResult && (e8Slot[u32Idx] == roRef.e8Slot[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgDynamicDataStatusGet::sds_transcriptionservicefi_tclMsgDynamicDataStatusGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgDynamicDataStatusGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSGET;
}


sds_transcriptionservicefi_tclMsgDynamicDataStatusGet::~sds_transcriptionservicefi_tclMsgDynamicDataStatusGet()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg::sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSUPREG;
}


sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg::~sds_transcriptionservicefi_tclMsgDynamicDataStatusUpReg()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg::sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSRELUPREG;
}


sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg::~sds_transcriptionservicefi_tclMsgDynamicDataStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus(const sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   DynamicDataStatus = coRef.DynamicDataStatus;
   e8FSGSlots = coRef.e8FSGSlots;
   e8SLMSlots = coRef.e8SLMSlots;
}
sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::operator=(const sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DynamicDataStatus = coRef.DynamicDataStatus;
   e8FSGSlots = coRef.e8FSGSlots;
   e8SLMSlots = coRef.e8SLMSlots;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DynamicDataStatus.size(); ++u32Idx)
         DynamicDataStatus[u32Idx].vDestroy();
   DynamicDataStatus.clear();
   }
   {
   e8FSGSlots.clear();
   }
   {
   e8SLMSlots.clear();
   }
}

sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus()



 {}

tS32 sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_DYNAMICDATASTATUSSTATUS;
}


sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::~sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DynamicDataStatus.size(); ++u32ListIdx)
      u32DynamicSize += DynamicDataStatus[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+e8FSGSlots.size()*1+e8SLMSlots.size()*1;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DynamicDataStatus.size(); ++u32Idx)
      {
         DynamicDataStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DynamicDataStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DynamicDataStatus[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      e8FSGSlots.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> e8FSGSlots[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      e8SLMSlots.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> e8SLMSlots[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DynamicDataStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DynamicDataStatus.size(); ++u32Idx)
         (tVoid) (oOut << DynamicDataStatus[u32Idx]);
   }
   (tVoid) (oOut << (tU32)e8FSGSlots.size());
   {
      for (tU32 u32Idx = 0; u32Idx < e8FSGSlots.size(); ++u32Idx)
         (tVoid) (oOut << e8FSGSlots[u32Idx]);
   }
   (tVoid) (oOut << (tU32)e8SLMSlots.size());
   {
      for (tU32 u32Idx = 0; u32Idx < e8SLMSlots.size(); ++u32Idx)
         (tVoid) (oOut << e8SLMSlots[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus::operator==(const sds_transcriptionservicefi_tclMsgDynamicDataStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DynamicDataStatus.size() == roRef.DynamicDataStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DynamicDataStatus.size()); ++u32Idx)
            bResult = bResult && (DynamicDataStatus[u32Idx] == roRef.DynamicDataStatus[u32Idx]);
      }
      bResult = bResult && (e8FSGSlots.size() == roRef.e8FSGSlots.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < e8FSGSlots.size()); ++u32Idx)
            bResult = bResult && (e8FSGSlots[u32Idx] == roRef.e8FSGSlots[u32Idx]);
      }
      bResult = bResult && (e8SLMSlots.size() == roRef.e8SLMSlots.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < e8SLMSlots.size()); ++u32Idx)
            bResult = bResult && (e8SLMSlots[u32Idx] == roRef.e8SLMSlots[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgContextOverflowGet::sds_transcriptionservicefi_tclMsgContextOverflowGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgContextOverflowGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWGET;
}


sds_transcriptionservicefi_tclMsgContextOverflowGet::~sds_transcriptionservicefi_tclMsgContextOverflowGet()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgContextOverflowUpReg::sds_transcriptionservicefi_tclMsgContextOverflowUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgContextOverflowUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWUPREG;
}


sds_transcriptionservicefi_tclMsgContextOverflowUpReg::~sds_transcriptionservicefi_tclMsgContextOverflowUpReg()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg::sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWRELUPREG;
}


sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg::~sds_transcriptionservicefi_tclMsgContextOverflowRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgContextOverflowStatus::sds_transcriptionservicefi_tclMsgContextOverflowStatus(const sds_transcriptionservicefi_tclMsgContextOverflowStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   ContextOverflow = coRef.ContextOverflow;
}
sds_transcriptionservicefi_tclMsgContextOverflowStatus& sds_transcriptionservicefi_tclMsgContextOverflowStatus::operator=(const sds_transcriptionservicefi_tclMsgContextOverflowStatus& coRef)
{
   if (this == &coRef) return *this;
   ContextOverflow = coRef.ContextOverflow;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgContextOverflowStatus::sds_transcriptionservicefi_tclMsgContextOverflowStatus()
:ContextOverflow()
 {}

tS32 sds_transcriptionservicefi_tclMsgContextOverflowStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_CONTEXTOVERFLOWSTATUS;
}


sds_transcriptionservicefi_tclMsgContextOverflowStatus::~sds_transcriptionservicefi_tclMsgContextOverflowStatus()
{}

tU32 sds_transcriptionservicefi_tclMsgContextOverflowStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgContextOverflowStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContextOverflow);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgContextOverflowStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContextOverflow);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgContextOverflowStatus::operator==(const sds_transcriptionservicefi_tclMsgContextOverflowStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContextOverflow == roRef.ContextOverflow);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet::sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSGET;
}


sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet::~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusGet()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg::sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSUPREG;
}


sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg::~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusUpReg()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg::sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSRELUPREG;
}


sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg::~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   VoconAsrStatus = coRef.VoconAsrStatus;
   VoconPronStatus = coRef.VoconPronStatus;
}
sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::operator=(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   VoconAsrStatus = coRef.VoconAsrStatus;
   VoconPronStatus = coRef.VoconPronStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus()
:VoconAsrStatus()
,VoconPronStatus()
 {}

tS32 sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_TSVOCONCOMPONENTSSTATUSSTATUS;
}


sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::~sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus()
{}

tU32 sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoconAsrStatus);
   (tVoid) (oIn >> VoconPronStatus);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoconAsrStatus);
   (tVoid) (oOut << VoconPronStatus);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus::operator==(const sds_transcriptionservicefi_tclMsgTSVoconComponentsStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoconAsrStatus == roRef.VoconAsrStatus);
   bResult = bResult && (VoconPronStatus == roRef.VoconPronStatus);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgLanguageGet::sds_transcriptionservicefi_tclMsgLanguageGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgLanguageGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGEGET;
}


sds_transcriptionservicefi_tclMsgLanguageGet::~sds_transcriptionservicefi_tclMsgLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgLanguageStatus::sds_transcriptionservicefi_tclMsgLanguageStatus(const sds_transcriptionservicefi_tclMsgLanguageStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_transcriptionservicefi_tclMsgLanguageStatus& sds_transcriptionservicefi_tclMsgLanguageStatus::operator=(const sds_transcriptionservicefi_tclMsgLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_transcriptionservicefi_tclMsgLanguageStatus::sds_transcriptionservicefi_tclMsgLanguageStatus()
:Language()
 {}

tS32 sds_transcriptionservicefi_tclMsgLanguageStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LANGUAGESTATUS;
}


sds_transcriptionservicefi_tclMsgLanguageStatus::~sds_transcriptionservicefi_tclMsgLanguageStatus()
{}

tU32 sds_transcriptionservicefi_tclMsgLanguageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgLanguageStatus::operator==(const sds_transcriptionservicefi_tclMsgLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgListContextStatusGet::sds_transcriptionservicefi_tclMsgListContextStatusGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgListContextStatusGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSGET;
}


sds_transcriptionservicefi_tclMsgListContextStatusGet::~sds_transcriptionservicefi_tclMsgListContextStatusGet()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgListContextStatusUpReg::sds_transcriptionservicefi_tclMsgListContextStatusUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgListContextStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSUPREG;
}


sds_transcriptionservicefi_tclMsgListContextStatusUpReg::~sds_transcriptionservicefi_tclMsgListContextStatusUpReg()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg::sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSRELUPREG;
}


sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg::~sds_transcriptionservicefi_tclMsgListContextStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgListContextStatusStatus::sds_transcriptionservicefi_tclMsgListContextStatusStatus(const sds_transcriptionservicefi_tclMsgListContextStatusStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   ListContextStatus = coRef.ListContextStatus;
}
sds_transcriptionservicefi_tclMsgListContextStatusStatus& sds_transcriptionservicefi_tclMsgListContextStatusStatus::operator=(const sds_transcriptionservicefi_tclMsgListContextStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   ListContextStatus = coRef.ListContextStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgListContextStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListContextStatus.size(); ++u32Idx)
         ListContextStatus[u32Idx].vDestroy();
   ListContextStatus.clear();
   }
}

sds_transcriptionservicefi_tclMsgListContextStatusStatus::sds_transcriptionservicefi_tclMsgListContextStatusStatus()

 {}

tS32 sds_transcriptionservicefi_tclMsgListContextStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_LISTCONTEXTSTATUSSTATUS;
}


sds_transcriptionservicefi_tclMsgListContextStatusStatus::~sds_transcriptionservicefi_tclMsgListContextStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgListContextStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ListContextStatus.size()*3;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgListContextStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListContextStatus.size(); ++u32Idx)
      {
         ListContextStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListContextStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListContextStatus[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgListContextStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListContextStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListContextStatus.size(); ++u32Idx)
         (tVoid) (oOut << ListContextStatus[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgListContextStatusStatus::operator==(const sds_transcriptionservicefi_tclMsgListContextStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListContextStatus.size() == roRef.ListContextStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListContextStatus.size()); ++u32Idx)
            bResult = bResult && (ListContextStatus[u32Idx] == roRef.ListContextStatus[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet::sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet()
 {}

tS32 sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSGET;
}


sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet::~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusGet()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg::sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSUPREG;
}


sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg::~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusUpReg()
{}

//=============================================================================

sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg::sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg()
 {}

tS32 sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSRELUPREG;
}


sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg::~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   DeviceContextStatus = coRef.DeviceContextStatus;
}
sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::operator=(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& coRef)
{
   if (this == &coRef) return *this;
   DeviceContextStatus = coRef.DeviceContextStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceContextStatus.size(); ++u32Idx)
         DeviceContextStatus[u32Idx].vDestroy();
   DeviceContextStatus.clear();
   }
}

sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet()

 {}

tS32 sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSET;
}


sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceContextStatus.size(); ++u32ListIdx)
      u32DynamicSize += DeviceContextStatus[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceContextStatus.size(); ++u32Idx)
      {
         DeviceContextStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceContextStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceContextStatus[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DeviceContextStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceContextStatus.size(); ++u32Idx)
         (tVoid) (oOut << DeviceContextStatus[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet::operator==(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DeviceContextStatus.size() == roRef.DeviceContextStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceContextStatus.size()); ++u32Idx)
            bResult = bResult && (DeviceContextStatus[u32Idx] == roRef.DeviceContextStatus[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& coRef)
   : sds_transcriptionservicefi_tclMsgBaseMessage(coRef)
{
   DeviceContextStatus = coRef.DeviceContextStatus;
}
sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::operator=(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceContextStatus = coRef.DeviceContextStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceContextStatus.size(); ++u32Idx)
         DeviceContextStatus[u32Idx].vDestroy();
   DeviceContextStatus.clear();
   }
}

sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus()

 {}

tS32 sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_transcriptionservicefi_tclToken::EN_MSG_RECCTXLOADEDSTATUSSTATUS;
}


sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::~sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceContextStatus.size(); ++u32ListIdx)
      u32DynamicSize += DeviceContextStatus[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceContextStatus.size(); ++u32Idx)
      {
         DeviceContextStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceContextStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceContextStatus[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DeviceContextStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceContextStatus.size(); ++u32Idx)
         (tVoid) (oOut << DeviceContextStatus[u32Idx]);
   }
   return oOut;
}

tBool sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus::operator==(const sds_transcriptionservicefi_tclMsgRECCtxLoadedStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DeviceContextStatus.size() == roRef.DeviceContextStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceContextStatus.size()); ++u32Idx)
            bResult = bResult && (DeviceContextStatus[u32Idx] == roRef.DeviceContextStatus[u32Idx]);
      }
   return bResult;
}

