/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_TEST_BASEAPPFITYPES_HEADER
#define SDS_TEST_BASEAPPFITYPES_HEADER


class sds_test_baseappfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_TEST_BASEAPP_FI message types

fi_tclMessageBase* sds_test_baseappfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_test_baseappfi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_test_baseappfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& operator=(const sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& coRef);
   sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart(const sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   virtual ~sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult();

   virtual ~sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& operator=(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& coRef);
   sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 CommdCntVal;
   tU16 DontAnswer;
   tU16 SendCounter;
   virtual ~sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& operator=(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& coRef);
   sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 RetCommdCnt;
   virtual ~sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSetPptyMethodMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSetPptyMethodMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& operator=(const sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& coRef);
   sds_test_baseappfi_tclMsgSetPptyMethodMethodStart(const sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 PropertyVal;
   virtual ~sds_test_baseappfi_tclMsgSetPptyMethodMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSetPptyMethodMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSetPptyMethodMethodResult();

   virtual ~sds_test_baseappfi_tclMsgSetPptyMethodMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgSetPptyMethodMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSendToServerMethodMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSendToServerMethodMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& operator=(const sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& coRef);
   sds_test_baseappfi_tclMsgSendToServerMethodMethodStart(const sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   tBool BlockingCall;
   virtual ~sds_test_baseappfi_tclMsgSendToServerMethodMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSendToServerMethodMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSendToServerMethodMethodResult();

   virtual ~sds_test_baseappfi_tclMsgSendToServerMethodMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgSendToServerMethodMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& operator=(const sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& coRef);
   sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart(const sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   virtual ~sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult();

   virtual ~sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSendBlockMessageMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSendBlockMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& operator=(const sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& coRef);
   sds_test_baseappfi_tclMsgSendBlockMessageMethodStart(const sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   tBool BlockingCall;
   virtual ~sds_test_baseappfi_tclMsgSendBlockMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgSendBlockMessageMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgSendBlockMessageMethodResult();

   virtual ~sds_test_baseappfi_tclMsgSendBlockMessageMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgSendBlockMessageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& operator=(const sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& coRef);
   sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart(const sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ServerTimeOutVal;
   virtual ~sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult();

   virtual ~sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestAudioMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestAudioMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgTestAudioMethodStart& operator=(const sds_test_baseappfi_tclMsgTestAudioMethodStart& coRef);
   sds_test_baseappfi_tclMsgTestAudioMethodStart(const sds_test_baseappfi_tclMsgTestAudioMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   virtual ~sds_test_baseappfi_tclMsgTestAudioMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgTestAudioMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestAudioMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestAudioMethodResult();

   virtual ~sds_test_baseappfi_tclMsgTestAudioMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgTestAudioMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& operator=(const sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& coRef);
   sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart(const sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   virtual ~sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult();

   virtual ~sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestSDPMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestSDPMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgTestSDPMethodStart& operator=(const sds_test_baseappfi_tclMsgTestSDPMethodStart& coRef);
   sds_test_baseappfi_tclMsgTestSDPMethodStart(const sds_test_baseappfi_tclMsgTestSDPMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   virtual ~sds_test_baseappfi_tclMsgTestSDPMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgTestSDPMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestSDPMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestSDPMethodResult();

   virtual ~sds_test_baseappfi_tclMsgTestSDPMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgTestSDPMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestTTSMethodStart : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestTTSMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgTestTTSMethodStart& operator=(const sds_test_baseappfi_tclMsgTestTTSMethodStart& coRef);
   sds_test_baseappfi_tclMsgTestTTSMethodStart(const sds_test_baseappfi_tclMsgTestTTSMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 MsgTimeOutVal;
   virtual ~sds_test_baseappfi_tclMsgTestTTSMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgTestTTSMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestTTSMethodResult : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestTTSMethodResult();

   virtual ~sds_test_baseappfi_tclMsgTestTTSMethodResult();

   inline tBool operator==(const sds_test_baseappfi_tclMsgTestTTSMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestPrpty1Get : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestPrpty1Get();

   virtual ~sds_test_baseappfi_tclMsgTestPrpty1Get();

   inline tBool operator==(const sds_test_baseappfi_tclMsgTestPrpty1Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestPrpty1Status : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestPrpty1Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgTestPrpty1Status& operator=(const sds_test_baseappfi_tclMsgTestPrpty1Status& coRef);
   sds_test_baseappfi_tclMsgTestPrpty1Status(const sds_test_baseappfi_tclMsgTestPrpty1Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TestPrpty1;
   virtual ~sds_test_baseappfi_tclMsgTestPrpty1Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgTestPrpty1Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestPrpty2Get : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestPrpty2Get();

   virtual ~sds_test_baseappfi_tclMsgTestPrpty2Get();

   inline tBool operator==(const sds_test_baseappfi_tclMsgTestPrpty2Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestPrpty2Set : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestPrpty2Set();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgTestPrpty2Set& operator=(const sds_test_baseappfi_tclMsgTestPrpty2Set& coRef);
   sds_test_baseappfi_tclMsgTestPrpty2Set(const sds_test_baseappfi_tclMsgTestPrpty2Set& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TestPrpty2;
   virtual ~sds_test_baseappfi_tclMsgTestPrpty2Set();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgTestPrpty2Set& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_test_baseappfi_tclMsgTestPrpty2Status : public sds_test_baseappfi_tclMsgBaseMessage
{
public:

   sds_test_baseappfi_tclMsgTestPrpty2Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_test_baseappfi_tclMsgTestPrpty2Status& operator=(const sds_test_baseappfi_tclMsgTestPrpty2Status& coRef);
   sds_test_baseappfi_tclMsgTestPrpty2Status(const sds_test_baseappfi_tclMsgTestPrpty2Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 TestPrpty2;
   virtual ~sds_test_baseappfi_tclMsgTestPrpty2Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_test_baseappfi_tclMsgTestPrpty2Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
