/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_TEST_BASEAPP_FI message types

fi_tclMessageBase* sds_test_baseappfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_test_baseappfi_tclToken::EN_MSG_MSGBETWEENTHREADSMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_MSGBETWEENTHREADSMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_COMMDCOUNTEROVFMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_COMMDCOUNTEROVFMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_SETPPTYMETHODMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgSetPptyMethodMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_SETPPTYMETHODMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgSetPptyMethodMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_SENDTOSERVERMETHODMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgSendToServerMethodMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_SENDTOSERVERMETHODMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgSendToServerMethodMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_SENDTOTHREADMETHODMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_SENDTOTHREADMETHODMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_SENDBLOCKMESSAGEMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgSendBlockMessageMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_SENDBLOCKMESSAGEMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgSendBlockMessageMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_BASEAPPSERVERMESGMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_BASEAPPSERVERMESGMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTAUDIOMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestAudioMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTAUDIOMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestAudioMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTCRITICALSECTIONMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTCRITICALSECTIONMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTSDPMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestSDPMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTSDPMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestSDPMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTTTSMETHODSTART:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestTTSMethodStart;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTTTSMETHODRESULT:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestTTSMethodResult;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY1GET:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestPrpty1Get;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY1STATUS:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestPrpty1Status;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY2GET:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestPrpty2Get;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY2SET:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestPrpty2Set;

      case sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY2STATUS:
         return OSAL_NEW sds_test_baseappfi_tclMsgTestPrpty2Status;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_test_baseappfifi messages

// common functions

tU16 sds_test_baseappfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_TEST_BASEAPPFI_C_U16_SERVICE_ID;
}

tU16 sds_test_baseappfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_test_baseappfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_test_baseappfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_test_baseappfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_test_baseappfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_test_baseappfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart(const sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
}
sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::operator=(const sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart()
:MsgTimeOutVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_MSGBETWEENTHREADSMETHODSTART;
}


sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::~sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart::operator==(const sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult::sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_MSGBETWEENTHREADSMETHODRESULT;
}


sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult::~sds_test_baseappfi_tclMsgMsgBetweenThreadsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   CommdCntVal = coRef.CommdCntVal;
   DontAnswer = coRef.DontAnswer;
   SendCounter = coRef.SendCounter;
}
sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::operator=(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CommdCntVal = coRef.CommdCntVal;
   DontAnswer = coRef.DontAnswer;
   SendCounter = coRef.SendCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart()
:CommdCntVal(0)
,DontAnswer(0)
,SendCounter(0)
 {}

tS32 sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_COMMDCOUNTEROVFMETHODSTART;
}


sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::~sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CommdCntVal);
   (tVoid) (oIn >> DontAnswer);
   (tVoid) (oIn >> SendCounter);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CommdCntVal);
   (tVoid) (oOut << DontAnswer);
   (tVoid) (oOut << SendCounter);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart::operator==(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CommdCntVal == roRef.CommdCntVal);
   bResult = bResult && (DontAnswer == roRef.DontAnswer);
   bResult = bResult && (SendCounter == roRef.SendCounter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   RetCommdCnt = coRef.RetCommdCnt;
}
sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::operator=(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RetCommdCnt = coRef.RetCommdCnt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult()
:RetCommdCnt(0)
 {}

tS32 sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_COMMDCOUNTEROVFMETHODRESULT;
}


sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::~sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult()
{}

tU32 sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RetCommdCnt);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RetCommdCnt);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult::operator==(const sds_test_baseappfi_tclMsgCommdCounterOvfMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RetCommdCnt == roRef.RetCommdCnt);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::sds_test_baseappfi_tclMsgSetPptyMethodMethodStart(const sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   PropertyVal = coRef.PropertyVal;
}
sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::operator=(const sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PropertyVal = coRef.PropertyVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::sds_test_baseappfi_tclMsgSetPptyMethodMethodStart()
:PropertyVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SETPPTYMETHODMETHODSTART;
}


sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::~sds_test_baseappfi_tclMsgSetPptyMethodMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PropertyVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PropertyVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgSetPptyMethodMethodStart::operator==(const sds_test_baseappfi_tclMsgSetPptyMethodMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PropertyVal == roRef.PropertyVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgSetPptyMethodMethodResult::sds_test_baseappfi_tclMsgSetPptyMethodMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgSetPptyMethodMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SETPPTYMETHODMETHODRESULT;
}


sds_test_baseappfi_tclMsgSetPptyMethodMethodResult::~sds_test_baseappfi_tclMsgSetPptyMethodMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::sds_test_baseappfi_tclMsgSendToServerMethodMethodStart(const sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   BlockingCall = coRef.BlockingCall;
}
sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::operator=(const sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   BlockingCall = coRef.BlockingCall;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::sds_test_baseappfi_tclMsgSendToServerMethodMethodStart()
:MsgTimeOutVal(0)
,BlockingCall(0)
 {}

tS32 sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SENDTOSERVERMETHODMETHODSTART;
}


sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::~sds_test_baseappfi_tclMsgSendToServerMethodMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   (tVoid) (oIn >> BlockingCall);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   (tVoid) (oOut << BlockingCall);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgSendToServerMethodMethodStart::operator==(const sds_test_baseappfi_tclMsgSendToServerMethodMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   bResult = bResult && (BlockingCall == roRef.BlockingCall);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgSendToServerMethodMethodResult::sds_test_baseappfi_tclMsgSendToServerMethodMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgSendToServerMethodMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SENDTOSERVERMETHODMETHODRESULT;
}


sds_test_baseappfi_tclMsgSendToServerMethodMethodResult::~sds_test_baseappfi_tclMsgSendToServerMethodMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart(const sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
}
sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::operator=(const sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart()
:MsgTimeOutVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SENDTOTHREADMETHODMETHODSTART;
}


sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::~sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart::operator==(const sds_test_baseappfi_tclMsgSendToThreadMethodMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult::sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SENDTOTHREADMETHODMETHODRESULT;
}


sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult::~sds_test_baseappfi_tclMsgSendToThreadMethodMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::sds_test_baseappfi_tclMsgSendBlockMessageMethodStart(const sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   BlockingCall = coRef.BlockingCall;
}
sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::operator=(const sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   BlockingCall = coRef.BlockingCall;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::sds_test_baseappfi_tclMsgSendBlockMessageMethodStart()
:MsgTimeOutVal(0)
,BlockingCall(0)
 {}

tS32 sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SENDBLOCKMESSAGEMETHODSTART;
}


sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::~sds_test_baseappfi_tclMsgSendBlockMessageMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   (tVoid) (oIn >> BlockingCall);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   (tVoid) (oOut << BlockingCall);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgSendBlockMessageMethodStart::operator==(const sds_test_baseappfi_tclMsgSendBlockMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   bResult = bResult && (BlockingCall == roRef.BlockingCall);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgSendBlockMessageMethodResult::sds_test_baseappfi_tclMsgSendBlockMessageMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgSendBlockMessageMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_SENDBLOCKMESSAGEMETHODRESULT;
}


sds_test_baseappfi_tclMsgSendBlockMessageMethodResult::~sds_test_baseappfi_tclMsgSendBlockMessageMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart(const sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   ServerTimeOutVal = coRef.ServerTimeOutVal;
}
sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::operator=(const sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ServerTimeOutVal = coRef.ServerTimeOutVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart()
:ServerTimeOutVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_BASEAPPSERVERMESGMETHODSTART;
}


sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::~sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServerTimeOutVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServerTimeOutVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart::operator==(const sds_test_baseappfi_tclMsgBaseAppServerMesgMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServerTimeOutVal == roRef.ServerTimeOutVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult::sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_BASEAPPSERVERMESGMETHODRESULT;
}


sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult::~sds_test_baseappfi_tclMsgBaseAppServerMesgMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgTestAudioMethodStart::sds_test_baseappfi_tclMsgTestAudioMethodStart(const sds_test_baseappfi_tclMsgTestAudioMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
}
sds_test_baseappfi_tclMsgTestAudioMethodStart& sds_test_baseappfi_tclMsgTestAudioMethodStart::operator=(const sds_test_baseappfi_tclMsgTestAudioMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgTestAudioMethodStart::sds_test_baseappfi_tclMsgTestAudioMethodStart()
:MsgTimeOutVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgTestAudioMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTAUDIOMETHODSTART;
}


sds_test_baseappfi_tclMsgTestAudioMethodStart::~sds_test_baseappfi_tclMsgTestAudioMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgTestAudioMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgTestAudioMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgTestAudioMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgTestAudioMethodStart::operator==(const sds_test_baseappfi_tclMsgTestAudioMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgTestAudioMethodResult::sds_test_baseappfi_tclMsgTestAudioMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgTestAudioMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTAUDIOMETHODRESULT;
}


sds_test_baseappfi_tclMsgTestAudioMethodResult::~sds_test_baseappfi_tclMsgTestAudioMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart(const sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
}
sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::operator=(const sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart()
:MsgTimeOutVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTCRITICALSECTIONMETHODSTART;
}


sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::~sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart::operator==(const sds_test_baseappfi_tclMsgTestCriticalSectionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult::sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTCRITICALSECTIONMETHODRESULT;
}


sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult::~sds_test_baseappfi_tclMsgTestCriticalSectionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgTestSDPMethodStart::sds_test_baseappfi_tclMsgTestSDPMethodStart(const sds_test_baseappfi_tclMsgTestSDPMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
}
sds_test_baseappfi_tclMsgTestSDPMethodStart& sds_test_baseappfi_tclMsgTestSDPMethodStart::operator=(const sds_test_baseappfi_tclMsgTestSDPMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgTestSDPMethodStart::sds_test_baseappfi_tclMsgTestSDPMethodStart()
:MsgTimeOutVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgTestSDPMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTSDPMETHODSTART;
}


sds_test_baseappfi_tclMsgTestSDPMethodStart::~sds_test_baseappfi_tclMsgTestSDPMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgTestSDPMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgTestSDPMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgTestSDPMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgTestSDPMethodStart::operator==(const sds_test_baseappfi_tclMsgTestSDPMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgTestSDPMethodResult::sds_test_baseappfi_tclMsgTestSDPMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgTestSDPMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTSDPMETHODRESULT;
}


sds_test_baseappfi_tclMsgTestSDPMethodResult::~sds_test_baseappfi_tclMsgTestSDPMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgTestTTSMethodStart::sds_test_baseappfi_tclMsgTestTTSMethodStart(const sds_test_baseappfi_tclMsgTestTTSMethodStart& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   MsgTimeOutVal = coRef.MsgTimeOutVal;
}
sds_test_baseappfi_tclMsgTestTTSMethodStart& sds_test_baseappfi_tclMsgTestTTSMethodStart::operator=(const sds_test_baseappfi_tclMsgTestTTSMethodStart& coRef)
{
   if (this == &coRef) return *this;
   MsgTimeOutVal = coRef.MsgTimeOutVal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgTestTTSMethodStart::sds_test_baseappfi_tclMsgTestTTSMethodStart()
:MsgTimeOutVal(0)
 {}

tS32 sds_test_baseappfi_tclMsgTestTTSMethodStart::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTTTSMETHODSTART;
}


sds_test_baseappfi_tclMsgTestTTSMethodStart::~sds_test_baseappfi_tclMsgTestTTSMethodStart()
{}

tU32 sds_test_baseappfi_tclMsgTestTTSMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgTestTTSMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MsgTimeOutVal);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgTestTTSMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MsgTimeOutVal);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgTestTTSMethodStart::operator==(const sds_test_baseappfi_tclMsgTestTTSMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MsgTimeOutVal == roRef.MsgTimeOutVal);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgTestTTSMethodResult::sds_test_baseappfi_tclMsgTestTTSMethodResult()
 {}

tS32 sds_test_baseappfi_tclMsgTestTTSMethodResult::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTTTSMETHODRESULT;
}


sds_test_baseappfi_tclMsgTestTTSMethodResult::~sds_test_baseappfi_tclMsgTestTTSMethodResult()
{}

//=============================================================================

sds_test_baseappfi_tclMsgTestPrpty1Get::sds_test_baseappfi_tclMsgTestPrpty1Get()
 {}

tS32 sds_test_baseappfi_tclMsgTestPrpty1Get::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY1GET;
}


sds_test_baseappfi_tclMsgTestPrpty1Get::~sds_test_baseappfi_tclMsgTestPrpty1Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgTestPrpty1Status::sds_test_baseappfi_tclMsgTestPrpty1Status(const sds_test_baseappfi_tclMsgTestPrpty1Status& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   TestPrpty1 = coRef.TestPrpty1;
}
sds_test_baseappfi_tclMsgTestPrpty1Status& sds_test_baseappfi_tclMsgTestPrpty1Status::operator=(const sds_test_baseappfi_tclMsgTestPrpty1Status& coRef)
{
   if (this == &coRef) return *this;
   TestPrpty1 = coRef.TestPrpty1;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgTestPrpty1Status::sds_test_baseappfi_tclMsgTestPrpty1Status()
:TestPrpty1(0)
 {}

tS32 sds_test_baseappfi_tclMsgTestPrpty1Status::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY1STATUS;
}


sds_test_baseappfi_tclMsgTestPrpty1Status::~sds_test_baseappfi_tclMsgTestPrpty1Status()
{}

tU32 sds_test_baseappfi_tclMsgTestPrpty1Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgTestPrpty1Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestPrpty1);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgTestPrpty1Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestPrpty1);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgTestPrpty1Status::operator==(const sds_test_baseappfi_tclMsgTestPrpty1Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestPrpty1 == roRef.TestPrpty1);
   return bResult;
}

//=============================================================================

sds_test_baseappfi_tclMsgTestPrpty2Get::sds_test_baseappfi_tclMsgTestPrpty2Get()
 {}

tS32 sds_test_baseappfi_tclMsgTestPrpty2Get::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY2GET;
}


sds_test_baseappfi_tclMsgTestPrpty2Get::~sds_test_baseappfi_tclMsgTestPrpty2Get()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgTestPrpty2Set::sds_test_baseappfi_tclMsgTestPrpty2Set(const sds_test_baseappfi_tclMsgTestPrpty2Set& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   TestPrpty2 = coRef.TestPrpty2;
}
sds_test_baseappfi_tclMsgTestPrpty2Set& sds_test_baseappfi_tclMsgTestPrpty2Set::operator=(const sds_test_baseappfi_tclMsgTestPrpty2Set& coRef)
{
   if (this == &coRef) return *this;
   TestPrpty2 = coRef.TestPrpty2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgTestPrpty2Set::sds_test_baseappfi_tclMsgTestPrpty2Set()
:TestPrpty2(0)
 {}

tS32 sds_test_baseappfi_tclMsgTestPrpty2Set::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY2SET;
}


sds_test_baseappfi_tclMsgTestPrpty2Set::~sds_test_baseappfi_tclMsgTestPrpty2Set()
{}

tU32 sds_test_baseappfi_tclMsgTestPrpty2Set::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgTestPrpty2Set::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestPrpty2);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgTestPrpty2Set::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestPrpty2);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgTestPrpty2Set::operator==(const sds_test_baseappfi_tclMsgTestPrpty2Set& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestPrpty2 == roRef.TestPrpty2);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_test_baseappfi_tclMsgTestPrpty2Status::sds_test_baseappfi_tclMsgTestPrpty2Status(const sds_test_baseappfi_tclMsgTestPrpty2Status& coRef)
   : sds_test_baseappfi_tclMsgBaseMessage(coRef)
{
   TestPrpty2 = coRef.TestPrpty2;
}
sds_test_baseappfi_tclMsgTestPrpty2Status& sds_test_baseappfi_tclMsgTestPrpty2Status::operator=(const sds_test_baseappfi_tclMsgTestPrpty2Status& coRef)
{
   if (this == &coRef) return *this;
   TestPrpty2 = coRef.TestPrpty2;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_test_baseappfi_tclMsgTestPrpty2Status::sds_test_baseappfi_tclMsgTestPrpty2Status()
:TestPrpty2(0)
 {}

tS32 sds_test_baseappfi_tclMsgTestPrpty2Status::s32GetTypeId() const
{
   return (tS32) sds_test_baseappfi_tclToken::EN_MSG_TESTPRPTY2STATUS;
}


sds_test_baseappfi_tclMsgTestPrpty2Status::~sds_test_baseappfi_tclMsgTestPrpty2Status()
{}

tU32 sds_test_baseappfi_tclMsgTestPrpty2Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_test_baseappfi_tclMsgTestPrpty2Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestPrpty2);
   return oIn;
}

fi_tclOutContext& sds_test_baseappfi_tclMsgTestPrpty2Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestPrpty2);
   return oOut;
}

tBool sds_test_baseappfi_tclMsgTestPrpty2Status::operator==(const sds_test_baseappfi_tclMsgTestPrpty2Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestPrpty2 == roRef.TestPrpty2);
   return bResult;
}

