#ifndef __SDS_TEST_BASEAPPFIDEBUGVISITOR_H__
#define __SDS_TEST_BASEAPPFIDEBUGVISITOR_H__

class MY_DECL sds_test_baseappfi_tclPrintVisitor : public sds_test_baseappfi_tclVisitorBase {

private:
   /* default constructor */ sds_test_baseappfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_test_baseappfi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(sds_test_baseappfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_test_baseappfi_tclRandomInitVisitor : public sds_test_baseappfi_tclVisitorBase {
public:

   sds_test_baseappfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
	tU32 u32ListSize;
};

#endif
