/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_SPEECHDP_FI message types

fi_tclMessageBase* sds_speechdpfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_speechdpfi_tclToken::EN_MSG_GETDATACARRIERINFOMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDATACARRIERINFOMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_SETUSERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgSetUserMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_SETUSERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgSetUserMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgReleaseDataMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgReleaseDataMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODRESULTFIRST:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODRESULTMIDDLE:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODRESULTLAST:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast;

      case sds_speechdpfi_tclToken::EN_MSG_GETSDSLANGUAGEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSDSLanguageMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETSDSLANGUAGEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSDSLanguageMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODRESULTFIRST:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODRESULTMIDDLE:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODRESULTLAST:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast;

      case sds_speechdpfi_tclToken::EN_MSG_GETSDSCOUNTRYMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSDSCountryMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETSDSCOUNTRYMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSDSCountryMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSCOUNTRIESMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSCOUNTRIESMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEASRLANGUAGESMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEASRLANGUAGESMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETASRLANGUAGEMODELMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETASRLANGUAGEMODELMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETCMDCTRLDATAMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETCMDCTRLDATAMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_NEWUSERWORDMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgNewUserWordMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_NEWUSERWORDMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgNewUserWordMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_CHANGEUSERWORDMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgChangeUserWordMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_CHANGEUSERWORDMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgChangeUserWordMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDDATAMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserWordDataMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDDATAMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserWordDataMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOFILEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOFILEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDSMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteUserWordsMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDSMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteUserWordsMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDCATEGORIESMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDCATEGORIESMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETASRAUDIOFILEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetASRAudioFileMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETASRAUDIOFILEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetASRAudioFileMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEASRAUDIOFILEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEASRAUDIOFILEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPOICATMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPOICATMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONCONTEXTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDestinationContextMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONCONTEXTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDestinationContextMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSPELLTREEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSPELLTREEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETSPECIALCONTEXTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSpecialContextMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETSPECIALCONTEXTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSpecialContextMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GROUPDESTINATIONDICTIONARIESMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GROUPDESTINATIONDICTIONARIESMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPROMPTVOICESMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPROMPTVOICESMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETPROMPTVOICEDATAMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETPROMPTVOICEDATAMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLETTSVOICESMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLETTSVOICESMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETSPEECHDIALOGMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSpeechDialogMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETSPEECHDIALOGMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSpeechDialogMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_ACCESSCOMPLETEDMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgAccessCompletedMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_ACCESSCOMPLETEDMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgAccessCompletedMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETVOCALIZERDATAMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVocalizerDataMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETVOCALIZERDATAMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVocalizerDataMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETVOCONDATAMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVoconDataMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETVOCONDATAMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVoconDataMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETCONTEXTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetContextMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETCONTEXTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetContextMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETSEMBUFFERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSemBufferMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETSEMBUFFERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetSemBufferMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_CHECKDYNAMICCONTEXTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgCheckDynamicContextMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_CHECKDYNAMICCONTEXTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgCheckDynamicContextMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDynamicContextMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDynamicContextMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_CREATEDYNAMICCONTEXTFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_CREATEDYNAMICCONTEXTFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_COMMITDYNAMICCONTEXTFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_COMMITDYNAMICCONTEXTFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_ROLLBACKDYNAMICCONTEXTFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_ROLLBACKDYNAMICCONTEXTFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEOLDDYNAMICCONTEXTFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEOLDDYNAMICCONTEXTFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDATAMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDATAMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONBUFFERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONBUFFERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDICTIONARYMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDICTIONARYMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONRULESETMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONRULESETMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETDATAPATHMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDataPathMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDATAPATHMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDataPathMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETSTRINGFROMIDMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetStringFromIDMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETSTRINGFROMIDMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetStringFromIDMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMIDMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMIDMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetIDFromStringMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetIDFromStringMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSUPPORTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDestinationSupportMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSUPPORTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDestinationSupportMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEUSERWORDSMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEUSERWORDSMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDCONTEXTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserwordContextMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDCONTEXTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserwordContextMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserwordAudioMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetUserwordAudioMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_CREATEUSERWORDFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_CREATEUSERWORDFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_COMMITUSERWORDFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_COMMITUSERWORDFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_ROLLBACKUSERWORDFOLDERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_ROLLBACKUSERWORDFOLDERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteUserwordMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteUserwordMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSSPEAKERSMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSSPEAKERSMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETCLCDICTIONARYFORSLOTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETCLCDICTIONARYFORSLOTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETSTATENAMEFROMSTATESHORTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETSTATENAMEFROMSTATESHORTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGWITHCONSTRAINMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGWITHCONSTRAINMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTLISTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDynamicContextListMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTLISTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDynamicContextListMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETCITYSTREETSAVAILABILITYMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETCITYSTREETSAVAILABILITYMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGOPTIONMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGOPTIONMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGLISTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGLISTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETVDESUPPORTEDLANGUAGESFORCOUNTRYMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETVDESUPPORTEDLANGUAGESFORCOUNTRYMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETDEFAULTSDSLANGUAGEANDSPEAKERMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETDEFAULTSDSLANGUAGEANDSPEAKERMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETVCDATAFILESMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVcDataFilesMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETVCDATAFILESMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVcDataFilesMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETWUWORDCONTEXTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetWUWordContextMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETWUWORDCONTEXTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetWUWordContextMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_SENDMESSAGETOSDS2HMIMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_SENDMESSAGETOSDS2HMIMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEDYNAMICCONTEXTLISTMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_DELETEDYNAMICCONTEXTLISTMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETNAVIADDRESSTYPEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETNAVIADDRESSTYPEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETNAVIURIDSFORCOUNTRYSTATEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETNAVIURIDSFORCOUNTRYSTATEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETVOCONCONFIGURATIONMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETVOCONCONFIGURATIONMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_GETNUMERICCOUNTRYCODEMETHODSTART:
         return OSAL_NEW sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart;

      case sds_speechdpfi_tclToken::EN_MSG_GETNUMERICCOUNTRYCODEMETHODRESULT:
         return OSAL_NEW sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult;

      case sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDGET:
         return OSAL_NEW sds_speechdpfi_tclMsgDataCarrierInsertedGet;

      case sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgDataCarrierInsertedUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDRELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDSTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgDataCarrierInsertedStatus;

      case sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYGET:
         return OSAL_NEW sds_speechdpfi_tclMsgConsistencyCheckReadyGet;

      case sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYRELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYSTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgConsistencyCheckReadyStatus;

      case sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONGET:
         return OSAL_NEW sds_speechdpfi_tclMsgSDPSWVersionGet;

      case sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgSDPSWVersionUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONRELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgSDPSWVersionRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONSTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgSDPSWVersionStatus;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETEGET:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadCompleteGet;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETEUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadCompleteUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETERELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadCompleteRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETESTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgDownloadCompleteStatus;

      case sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETEGET:
         return OSAL_NEW sds_speechdpfi_tclMsgLanguageDownloadCompleteGet;

      case sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETEUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETERELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETESTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus;

      case sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETEGET:
         return OSAL_NEW sds_speechdpfi_tclMsgCountryDownloadCompleteGet;

      case sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETEUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETERELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETESTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgCountryDownloadCompleteStatus;

      case sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDGET:
         return OSAL_NEW sds_speechdpfi_tclMsgSDNLocationFoundGet;

      case sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgSDNLocationFoundUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDRELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDSTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgSDNLocationFoundStatus;

      case sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTGET:
         return OSAL_NEW sds_speechdpfi_tclMsgUpdateCountryStateListGet;

      case sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTRELUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg;

      case sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTSTATUS:
         return OSAL_NEW sds_speechdpfi_tclMsgUpdateCountryStateListStatus;

      case sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTUPREG:
         return OSAL_NEW sds_speechdpfi_tclMsgUpdateCountryStateListUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_speechdpfifi messages

// common functions

tU16 sds_speechdpfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_SPEECHDPFI_C_U16_SERVICE_ID;
}

tU16 sds_speechdpfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_speechdpfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_speechdpfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_speechdpfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_speechdpfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_speechdpfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_speechdpfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart::sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDATACARRIERINFOMETHODSTART;
}


sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart::~sds_speechdpfi_tclMsgGetDataCarrierInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult(const sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DataCarrierType = coRef.DataCarrierType;
   MajorVersion_SBS_NAV = coRef.MajorVersion_SBS_NAV;
   MinorVersion_SBS_NAV = coRef.MinorVersion_SBS_NAV;
   BoschCreateDate_SBS_NAV = coRef.BoschCreateDate_SBS_NAV;
   MajorVersion_SBS_ASR = coRef.MajorVersion_SBS_ASR;
   MinorVersion_SBS_ASR = coRef.MinorVersion_SBS_ASR;
   BoschCreateDate_SBS_ASR = coRef.BoschCreateDate_SBS_ASR;
   MajorVersion_SBS_TTS = coRef.MajorVersion_SBS_TTS;
   MinorVersion_SBS_TTS = coRef.MinorVersion_SBS_TTS;
   BoschCreateDate_SBS_TTS = coRef.BoschCreateDate_SBS_TTS;
   MajorVersion_SBS_BAS = coRef.MajorVersion_SBS_BAS;
   MinorVersion_SBS_BAS = coRef.MinorVersion_SBS_BAS;
   BoschCreateDate_SBS_BAS = coRef.BoschCreateDate_SBS_BAS;
   MajorVersion_SpeechData = coRef.MajorVersion_SpeechData;
   MinorVersion_SpeechData = coRef.MinorVersion_SpeechData;
   BoschCreateDate_SpeechData = coRef.BoschCreateDate_SpeechData;
   MajorVersion_NaviData = coRef.MajorVersion_NaviData;
   MinorVersion_NaviData = coRef.MinorVersion_NaviData;
   BoschCreateDate_NaviData = coRef.BoschCreateDate_NaviData;
}
sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::operator=(const sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DataCarrierType = coRef.DataCarrierType;
   MajorVersion_SBS_NAV = coRef.MajorVersion_SBS_NAV;
   MinorVersion_SBS_NAV = coRef.MinorVersion_SBS_NAV;
   BoschCreateDate_SBS_NAV = coRef.BoschCreateDate_SBS_NAV;
   MajorVersion_SBS_ASR = coRef.MajorVersion_SBS_ASR;
   MinorVersion_SBS_ASR = coRef.MinorVersion_SBS_ASR;
   BoschCreateDate_SBS_ASR = coRef.BoschCreateDate_SBS_ASR;
   MajorVersion_SBS_TTS = coRef.MajorVersion_SBS_TTS;
   MinorVersion_SBS_TTS = coRef.MinorVersion_SBS_TTS;
   BoschCreateDate_SBS_TTS = coRef.BoschCreateDate_SBS_TTS;
   MajorVersion_SBS_BAS = coRef.MajorVersion_SBS_BAS;
   MinorVersion_SBS_BAS = coRef.MinorVersion_SBS_BAS;
   BoschCreateDate_SBS_BAS = coRef.BoschCreateDate_SBS_BAS;
   MajorVersion_SpeechData = coRef.MajorVersion_SpeechData;
   MinorVersion_SpeechData = coRef.MinorVersion_SpeechData;
   BoschCreateDate_SpeechData = coRef.BoschCreateDate_SpeechData;
   MajorVersion_NaviData = coRef.MajorVersion_NaviData;
   MinorVersion_NaviData = coRef.MinorVersion_NaviData;
   BoschCreateDate_NaviData = coRef.BoschCreateDate_NaviData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::vDestroy()
{
   BoschCreateDate_SBS_NAV.vDestroy();
   BoschCreateDate_SBS_ASR.vDestroy();
   BoschCreateDate_SBS_TTS.vDestroy();
   BoschCreateDate_SBS_BAS.vDestroy();
   BoschCreateDate_SpeechData.vDestroy();
   BoschCreateDate_NaviData.vDestroy();
}

sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult()
:DataCarrierType()
,MajorVersion_SBS_NAV(0)
,MinorVersion_SBS_NAV(0)
,BoschCreateDate_SBS_NAV()
,MajorVersion_SBS_ASR(0)
,MinorVersion_SBS_ASR(0)
,BoschCreateDate_SBS_ASR()
,MajorVersion_SBS_TTS(0)
,MinorVersion_SBS_TTS(0)
,BoschCreateDate_SBS_TTS()
,MajorVersion_SBS_BAS(0)
,MinorVersion_SBS_BAS(0)
,BoschCreateDate_SBS_BAS()
,MajorVersion_SpeechData(0)
,MinorVersion_SpeechData(0)
,BoschCreateDate_SpeechData()
,MajorVersion_NaviData(0)
,MinorVersion_NaviData(0)
,BoschCreateDate_NaviData()
 {}

tS32 sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDATACARRIERINFOMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::~sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 25+BoschCreateDate_SBS_NAV.u32GetSize(u16MajorVersion)+BoschCreateDate_SBS_ASR.u32GetSize(u16MajorVersion)+BoschCreateDate_SBS_TTS.u32GetSize(u16MajorVersion)+BoschCreateDate_SBS_BAS.u32GetSize(u16MajorVersion)+BoschCreateDate_SpeechData.u32GetSize(u16MajorVersion)+BoschCreateDate_NaviData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataCarrierType);
   (tVoid) (oIn >> MajorVersion_SBS_NAV);
   (tVoid) (oIn >> MinorVersion_SBS_NAV);
   (tVoid) (oIn >> BoschCreateDate_SBS_NAV);
   (tVoid) (oIn >> MajorVersion_SBS_ASR);
   (tVoid) (oIn >> MinorVersion_SBS_ASR);
   (tVoid) (oIn >> BoschCreateDate_SBS_ASR);
   (tVoid) (oIn >> MajorVersion_SBS_TTS);
   (tVoid) (oIn >> MinorVersion_SBS_TTS);
   (tVoid) (oIn >> BoschCreateDate_SBS_TTS);
   (tVoid) (oIn >> MajorVersion_SBS_BAS);
   (tVoid) (oIn >> MinorVersion_SBS_BAS);
   (tVoid) (oIn >> BoschCreateDate_SBS_BAS);
   (tVoid) (oIn >> MajorVersion_SpeechData);
   (tVoid) (oIn >> MinorVersion_SpeechData);
   (tVoid) (oIn >> BoschCreateDate_SpeechData);
   (tVoid) (oIn >> MajorVersion_NaviData);
   (tVoid) (oIn >> MinorVersion_NaviData);
   (tVoid) (oIn >> BoschCreateDate_NaviData);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataCarrierType);
   (tVoid) (oOut << MajorVersion_SBS_NAV);
   (tVoid) (oOut << MinorVersion_SBS_NAV);
   (tVoid) (oOut << BoschCreateDate_SBS_NAV);
   (tVoid) (oOut << MajorVersion_SBS_ASR);
   (tVoid) (oOut << MinorVersion_SBS_ASR);
   (tVoid) (oOut << BoschCreateDate_SBS_ASR);
   (tVoid) (oOut << MajorVersion_SBS_TTS);
   (tVoid) (oOut << MinorVersion_SBS_TTS);
   (tVoid) (oOut << BoschCreateDate_SBS_TTS);
   (tVoid) (oOut << MajorVersion_SBS_BAS);
   (tVoid) (oOut << MinorVersion_SBS_BAS);
   (tVoid) (oOut << BoschCreateDate_SBS_BAS);
   (tVoid) (oOut << MajorVersion_SpeechData);
   (tVoid) (oOut << MinorVersion_SpeechData);
   (tVoid) (oOut << BoschCreateDate_SpeechData);
   (tVoid) (oOut << MajorVersion_NaviData);
   (tVoid) (oOut << MinorVersion_NaviData);
   (tVoid) (oOut << BoschCreateDate_NaviData);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult::operator==(const sds_speechdpfi_tclMsgGetDataCarrierInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataCarrierType == roRef.DataCarrierType);
   bResult = bResult && (MajorVersion_SBS_NAV == roRef.MajorVersion_SBS_NAV);
   bResult = bResult && (MinorVersion_SBS_NAV == roRef.MinorVersion_SBS_NAV);
   bResult = bResult && (BoschCreateDate_SBS_NAV == roRef.BoschCreateDate_SBS_NAV);
   bResult = bResult && (MajorVersion_SBS_ASR == roRef.MajorVersion_SBS_ASR);
   bResult = bResult && (MinorVersion_SBS_ASR == roRef.MinorVersion_SBS_ASR);
   bResult = bResult && (BoschCreateDate_SBS_ASR == roRef.BoschCreateDate_SBS_ASR);
   bResult = bResult && (MajorVersion_SBS_TTS == roRef.MajorVersion_SBS_TTS);
   bResult = bResult && (MinorVersion_SBS_TTS == roRef.MinorVersion_SBS_TTS);
   bResult = bResult && (BoschCreateDate_SBS_TTS == roRef.BoschCreateDate_SBS_TTS);
   bResult = bResult && (MajorVersion_SBS_BAS == roRef.MajorVersion_SBS_BAS);
   bResult = bResult && (MinorVersion_SBS_BAS == roRef.MinorVersion_SBS_BAS);
   bResult = bResult && (BoschCreateDate_SBS_BAS == roRef.BoschCreateDate_SBS_BAS);
   bResult = bResult && (MajorVersion_SpeechData == roRef.MajorVersion_SpeechData);
   bResult = bResult && (MinorVersion_SpeechData == roRef.MinorVersion_SpeechData);
   bResult = bResult && (BoschCreateDate_SpeechData == roRef.BoschCreateDate_SpeechData);
   bResult = bResult && (MajorVersion_NaviData == roRef.MajorVersion_NaviData);
   bResult = bResult && (MinorVersion_NaviData == roRef.MinorVersion_NaviData);
   bResult = bResult && (BoschCreateDate_NaviData == roRef.BoschCreateDate_NaviData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgSetUserMethodStart::sds_speechdpfi_tclMsgSetUserMethodStart(const sds_speechdpfi_tclMsgSetUserMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   UserID = coRef.UserID;
}
sds_speechdpfi_tclMsgSetUserMethodStart& sds_speechdpfi_tclMsgSetUserMethodStart::operator=(const sds_speechdpfi_tclMsgSetUserMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UserID = coRef.UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgSetUserMethodStart::sds_speechdpfi_tclMsgSetUserMethodStart()
:UserID(0)
 {}

tS32 sds_speechdpfi_tclMsgSetUserMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SETUSERMETHODSTART;
}


sds_speechdpfi_tclMsgSetUserMethodStart::~sds_speechdpfi_tclMsgSetUserMethodStart()
{}

tU32 sds_speechdpfi_tclMsgSetUserMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgSetUserMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgSetUserMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgSetUserMethodStart::operator==(const sds_speechdpfi_tclMsgSetUserMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserID == roRef.UserID);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgSetUserMethodResult::sds_speechdpfi_tclMsgSetUserMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgSetUserMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SETUSERMETHODRESULT;
}


sds_speechdpfi_tclMsgSetUserMethodResult::~sds_speechdpfi_tclMsgSetUserMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgReleaseDataMethodStart::sds_speechdpfi_tclMsgReleaseDataMethodStart(const sds_speechdpfi_tclMsgReleaseDataMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ReleaseType = coRef.ReleaseType;
}
sds_speechdpfi_tclMsgReleaseDataMethodStart& sds_speechdpfi_tclMsgReleaseDataMethodStart::operator=(const sds_speechdpfi_tclMsgReleaseDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ReleaseType = coRef.ReleaseType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgReleaseDataMethodStart::sds_speechdpfi_tclMsgReleaseDataMethodStart()
:ReleaseType()
 {}

tS32 sds_speechdpfi_tclMsgReleaseDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART;
}


sds_speechdpfi_tclMsgReleaseDataMethodStart::~sds_speechdpfi_tclMsgReleaseDataMethodStart()
{}

tU32 sds_speechdpfi_tclMsgReleaseDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgReleaseDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReleaseType);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgReleaseDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReleaseType);
   return oOut;
}

tBool sds_speechdpfi_tclMsgReleaseDataMethodStart::operator==(const sds_speechdpfi_tclMsgReleaseDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReleaseType == roRef.ReleaseType);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgReleaseDataMethodResult::sds_speechdpfi_tclMsgReleaseDataMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgReleaseDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT;
}


sds_speechdpfi_tclMsgReleaseDataMethodResult::~sds_speechdpfi_tclMsgReleaseDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DownloadASR = coRef.DownloadASR;
   DownloadTTS = coRef.DownloadTTS;
   DownloadPromptCC = coRef.DownloadPromptCC;
   LanguageID = coRef.LanguageID;
   TTSVoice = coRef.TTSVoice;
   PromptVoice = coRef.PromptVoice;
   UserWordUsage = coRef.UserWordUsage;
}
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DownloadASR = coRef.DownloadASR;
   DownloadTTS = coRef.DownloadTTS;
   DownloadPromptCC = coRef.DownloadPromptCC;
   LanguageID = coRef.LanguageID;
   TTSVoice = coRef.TTSVoice;
   PromptVoice = coRef.PromptVoice;
   UserWordUsage = coRef.UserWordUsage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   TTSVoice.vDestroy(); 
   PromptVoice.vDestroy(); 
}

sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart()
:DownloadASR(0)
,DownloadTTS(0)
,DownloadPromptCC(0)
,LanguageID()
,TTSVoice()
,PromptVoice()
,UserWordUsage()
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODSTART;
}


sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+TTSVoice.u32GetSize(u16MajorVersion)+PromptVoice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DownloadASR);
   (tVoid) (oIn >> DownloadTTS);
   (tVoid) (oIn >> DownloadPromptCC);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> TTSVoice);
   (tVoid) (oIn >> PromptVoice);
   (tVoid) (oIn >> UserWordUsage);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DownloadASR);
   (tVoid) (oOut << DownloadTTS);
   (tVoid) (oOut << DownloadPromptCC);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << TTSVoice);
   (tVoid) (oOut << PromptVoice);
   (tVoid) (oOut << UserWordUsage);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart::operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DownloadASR == roRef.DownloadASR);
   bResult = bResult && (DownloadTTS == roRef.DownloadTTS);
   bResult = bResult && (DownloadPromptCC == roRef.DownloadPromptCC);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (TTSVoice == roRef.TTSVoice);
   bResult = bResult && (PromptVoice == roRef.PromptVoice);
   bResult = bResult && (UserWordUsage == roRef.UserWordUsage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst()
:Progress(0)
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODRESULTFIRST;
}


sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst()
{}

tU32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst::operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle()
:Progress(0)
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODRESULTMIDDLE;
}


sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle()
{}

tU32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle::operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::operator=(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast()
:Progress(0)
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSLANGUAGEMETHODRESULTLAST;
}


sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::~sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast()
{}

tU32 sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast::operator==(const sds_speechdpfi_tclMsgDownloadSDSLanguageMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgGetSDSLanguageMethodStart::sds_speechdpfi_tclMsgGetSDSLanguageMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetSDSLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSDSLANGUAGEMETHODSTART;
}


sds_speechdpfi_tclMsgGetSDSLanguageMethodStart::~sds_speechdpfi_tclMsgGetSDSLanguageMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::sds_speechdpfi_tclMsgGetSDSLanguageMethodResult(const sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   TTSVoice = coRef.TTSVoice;
   PromptVoice = coRef.PromptVoice;
   MajorVersion_SBS_ASR = coRef.MajorVersion_SBS_ASR;
   MinorVersion_SBS_ASR = coRef.MinorVersion_SBS_ASR;
   BoschCreateDate_SBS_ASR = coRef.BoschCreateDate_SBS_ASR;
   MajorVersion_SBS_TTS = coRef.MajorVersion_SBS_TTS;
   MinorVersion_SBS_TTS = coRef.MinorVersion_SBS_TTS;
   BoschCreateDate_SBS_TTS = coRef.BoschCreateDate_SBS_TTS;
   MajorVersion_SBS_BAS = coRef.MajorVersion_SBS_BAS;
   MinorVersion_SBS_BAS = coRef.MinorVersion_SBS_BAS;
   BoschCreateDate_SBS_BAS = coRef.BoschCreateDate_SBS_BAS;
}
sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::operator=(const sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   TTSVoice = coRef.TTSVoice;
   PromptVoice = coRef.PromptVoice;
   MajorVersion_SBS_ASR = coRef.MajorVersion_SBS_ASR;
   MinorVersion_SBS_ASR = coRef.MinorVersion_SBS_ASR;
   BoschCreateDate_SBS_ASR = coRef.BoschCreateDate_SBS_ASR;
   MajorVersion_SBS_TTS = coRef.MajorVersion_SBS_TTS;
   MinorVersion_SBS_TTS = coRef.MinorVersion_SBS_TTS;
   BoschCreateDate_SBS_TTS = coRef.BoschCreateDate_SBS_TTS;
   MajorVersion_SBS_BAS = coRef.MajorVersion_SBS_BAS;
   MinorVersion_SBS_BAS = coRef.MinorVersion_SBS_BAS;
   BoschCreateDate_SBS_BAS = coRef.BoschCreateDate_SBS_BAS;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::vDestroy()
{
   LanguageID.vDestroy(); 
   TTSVoice.vDestroy(); 
   PromptVoice.vDestroy(); 
   BoschCreateDate_SBS_ASR.vDestroy();
   BoschCreateDate_SBS_TTS.vDestroy();
   BoschCreateDate_SBS_BAS.vDestroy();
}

sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::sds_speechdpfi_tclMsgGetSDSLanguageMethodResult()
:LanguageID()
,TTSVoice()
,PromptVoice()
,MajorVersion_SBS_ASR(0)
,MinorVersion_SBS_ASR(0)
,BoschCreateDate_SBS_ASR()
,MajorVersion_SBS_TTS(0)
,MinorVersion_SBS_TTS(0)
,BoschCreateDate_SBS_TTS()
,MajorVersion_SBS_BAS(0)
,MinorVersion_SBS_BAS(0)
,BoschCreateDate_SBS_BAS()
 {}

tS32 sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSDSLANGUAGEMETHODRESULT;
}


sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::~sds_speechdpfi_tclMsgGetSDSLanguageMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 16+TTSVoice.u32GetSize(u16MajorVersion)+PromptVoice.u32GetSize(u16MajorVersion)+BoschCreateDate_SBS_ASR.u32GetSize(u16MajorVersion)+BoschCreateDate_SBS_TTS.u32GetSize(u16MajorVersion)+BoschCreateDate_SBS_BAS.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> TTSVoice);
   (tVoid) (oIn >> PromptVoice);
   (tVoid) (oIn >> MajorVersion_SBS_ASR);
   (tVoid) (oIn >> MinorVersion_SBS_ASR);
   (tVoid) (oIn >> BoschCreateDate_SBS_ASR);
   (tVoid) (oIn >> MajorVersion_SBS_TTS);
   (tVoid) (oIn >> MinorVersion_SBS_TTS);
   (tVoid) (oIn >> BoschCreateDate_SBS_TTS);
   (tVoid) (oIn >> MajorVersion_SBS_BAS);
   (tVoid) (oIn >> MinorVersion_SBS_BAS);
   (tVoid) (oIn >> BoschCreateDate_SBS_BAS);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << TTSVoice);
   (tVoid) (oOut << PromptVoice);
   (tVoid) (oOut << MajorVersion_SBS_ASR);
   (tVoid) (oOut << MinorVersion_SBS_ASR);
   (tVoid) (oOut << BoschCreateDate_SBS_ASR);
   (tVoid) (oOut << MajorVersion_SBS_TTS);
   (tVoid) (oOut << MinorVersion_SBS_TTS);
   (tVoid) (oOut << BoschCreateDate_SBS_TTS);
   (tVoid) (oOut << MajorVersion_SBS_BAS);
   (tVoid) (oOut << MinorVersion_SBS_BAS);
   (tVoid) (oOut << BoschCreateDate_SBS_BAS);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSDSLanguageMethodResult::operator==(const sds_speechdpfi_tclMsgGetSDSLanguageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (TTSVoice == roRef.TTSVoice);
   bResult = bResult && (PromptVoice == roRef.PromptVoice);
   bResult = bResult && (MajorVersion_SBS_ASR == roRef.MajorVersion_SBS_ASR);
   bResult = bResult && (MinorVersion_SBS_ASR == roRef.MinorVersion_SBS_ASR);
   bResult = bResult && (BoschCreateDate_SBS_ASR == roRef.BoschCreateDate_SBS_ASR);
   bResult = bResult && (MajorVersion_SBS_TTS == roRef.MajorVersion_SBS_TTS);
   bResult = bResult && (MinorVersion_SBS_TTS == roRef.MinorVersion_SBS_TTS);
   bResult = bResult && (BoschCreateDate_SBS_TTS == roRef.BoschCreateDate_SBS_TTS);
   bResult = bResult && (MajorVersion_SBS_BAS == roRef.MajorVersion_SBS_BAS);
   bResult = bResult && (MinorVersion_SBS_BAS == roRef.MinorVersion_SBS_BAS);
   bResult = bResult && (BoschCreateDate_SBS_BAS == roRef.BoschCreateDate_SBS_BAS);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   CountryType = coRef.CountryType;
   Country = coRef.Country;
   State = coRef.State;
}
sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   CountryType = coRef.CountryType;
   Country = coRef.Country;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   State.vDestroy();
}

sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart()
:LanguageID()
,CountryType()
,Country()
,State()
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODSTART;
}


sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::~sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+State.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryType);
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryType);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart::operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryType == roRef.CountryType);
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst()
:Progress(0)
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODRESULTFIRST;
}


sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::~sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst()
{}

tU32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst::operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle()
:Progress(0)
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODRESULTMIDDLE;
}


sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::~sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle()
{}

tU32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle::operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultMiddle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Progress = coRef.Progress;
}
sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::operator=(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   Progress = coRef.Progress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast()
:Progress(0)
 {}

tS32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADSDSCOUNTRYMETHODRESULTLAST;
}


sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::~sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast()
{}

tU32 sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Progress);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Progress);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast::operator==(const sds_speechdpfi_tclMsgDownloadSDSCountryMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Progress == roRef.Progress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSDSCountryMethodStart::sds_speechdpfi_tclMsgGetSDSCountryMethodStart(const sds_speechdpfi_tclMsgGetSDSCountryMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CountryType = coRef.CountryType;
}
sds_speechdpfi_tclMsgGetSDSCountryMethodStart& sds_speechdpfi_tclMsgGetSDSCountryMethodStart::operator=(const sds_speechdpfi_tclMsgGetSDSCountryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CountryType = coRef.CountryType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetSDSCountryMethodStart::sds_speechdpfi_tclMsgGetSDSCountryMethodStart()
:CountryType()
 {}

tS32 sds_speechdpfi_tclMsgGetSDSCountryMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSDSCOUNTRYMETHODSTART;
}


sds_speechdpfi_tclMsgGetSDSCountryMethodStart::~sds_speechdpfi_tclMsgGetSDSCountryMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetSDSCountryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSDSCountryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryType);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSDSCountryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryType);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSDSCountryMethodStart::operator==(const sds_speechdpfi_tclMsgGetSDSCountryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryType == roRef.CountryType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSDSCountryMethodResult::sds_speechdpfi_tclMsgGetSDSCountryMethodResult(const sds_speechdpfi_tclMsgGetSDSCountryMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
   MajorVersion_SBS_NAV = coRef.MajorVersion_SBS_NAV;
   MinorVersion_SBS_NAV = coRef.MinorVersion_SBS_NAV;
   BoschCreateDate = coRef.BoschCreateDate;
}
sds_speechdpfi_tclMsgGetSDSCountryMethodResult& sds_speechdpfi_tclMsgGetSDSCountryMethodResult::operator=(const sds_speechdpfi_tclMsgGetSDSCountryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   State = coRef.State;
   MajorVersion_SBS_NAV = coRef.MajorVersion_SBS_NAV;
   MinorVersion_SBS_NAV = coRef.MinorVersion_SBS_NAV;
   BoschCreateDate = coRef.BoschCreateDate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetSDSCountryMethodResult::vDestroy()
{
   LanguageID.vDestroy(); 
   State.vDestroy();
   BoschCreateDate.vDestroy();
}

sds_speechdpfi_tclMsgGetSDSCountryMethodResult::sds_speechdpfi_tclMsgGetSDSCountryMethodResult()
:LanguageID()
,CountryCode()
,State()
,MajorVersion_SBS_NAV(0)
,MinorVersion_SBS_NAV(0)
,BoschCreateDate()
 {}

tS32 sds_speechdpfi_tclMsgGetSDSCountryMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSDSCOUNTRYMETHODRESULT;
}


sds_speechdpfi_tclMsgGetSDSCountryMethodResult::~sds_speechdpfi_tclMsgGetSDSCountryMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetSDSCountryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+State.u32GetSize(u16MajorVersion)+BoschCreateDate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSDSCountryMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> MajorVersion_SBS_NAV);
   (tVoid) (oIn >> MinorVersion_SBS_NAV);
   (tVoid) (oIn >> BoschCreateDate);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSDSCountryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << State);
   (tVoid) (oOut << MajorVersion_SBS_NAV);
   (tVoid) (oOut << MinorVersion_SBS_NAV);
   (tVoid) (oOut << BoschCreateDate);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSDSCountryMethodResult::operator==(const sds_speechdpfi_tclMsgGetSDSCountryMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (MajorVersion_SBS_NAV == roRef.MajorVersion_SBS_NAV);
   bResult = bResult && (MinorVersion_SBS_NAV == roRef.MinorVersion_SBS_NAV);
   bResult = bResult && (BoschCreateDate == roRef.BoschCreateDate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StorageDevice = coRef.StorageDevice;
}
sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::operator=(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StorageDevice = coRef.StorageDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart()
:StorageDevice()
 {}

tS32 sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSCOUNTRIESMETHODSTART;
}


sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::~sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StorageDevice);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StorageDevice);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart::operator==(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StorageDevice == roRef.StorageDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   AvailableCountries = coRef.AvailableCountries;
}
sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::operator=(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailableCountries = coRef.AvailableCountries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableCountries.size(); ++u32Idx)
         AvailableCountries[u32Idx].vDestroy();
   AvailableCountries.clear();
   }
}

sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSCOUNTRIESMETHODRESULT;
}


sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::~sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailableCountries.size(); ++u32ListIdx)
      u32DynamicSize += AvailableCountries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableCountries.size(); ++u32Idx)
      {
         AvailableCountries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableCountries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableCountries[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableCountries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableCountries.size(); ++u32Idx)
         (tVoid) (oOut << AvailableCountries[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult::operator==(const sds_speechdpfi_tclMsgGetAvailableSDSCountriesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableCountries.size() == roRef.AvailableCountries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableCountries.size()); ++u32Idx)
            bResult = bResult && (AvailableCountries[u32Idx] == roRef.AvailableCountries[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart::sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEASRLANGUAGESMETHODSTART;
}


sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart::~sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult(const sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   AvailableASRLanguages = coRef.AvailableASRLanguages;
}
sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::operator=(const sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailableASRLanguages = coRef.AvailableASRLanguages;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableASRLanguages.size(); ++u32Idx)
         AvailableASRLanguages[u32Idx].vDestroy();
   AvailableASRLanguages.clear();
   }
}

sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEASRLANGUAGESMETHODRESULT;
}


sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::~sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+AvailableASRLanguages.size()*5;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableASRLanguages.size(); ++u32Idx)
      {
         AvailableASRLanguages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableASRLanguages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableASRLanguages[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableASRLanguages.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableASRLanguages.size(); ++u32Idx)
         (tVoid) (oOut << AvailableASRLanguages[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult::operator==(const sds_speechdpfi_tclMsgGetAvailableASRLanguagesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableASRLanguages.size() == roRef.AvailableASRLanguages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableASRLanguages.size()); ++u32Idx)
            bResult = bResult && (AvailableASRLanguages[u32Idx] == roRef.AvailableASRLanguages[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
}
sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::operator=(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart()
:LanguageID()
 {}

tS32 sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETASRLANGUAGEMODELMETHODSTART;
}


sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::~sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart::operator==(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FrontendFile = coRef.FrontendFile;
   BackendFile = coRef.BackendFile;
   DDG2PFileName = coRef.DDG2PFileName;
}
sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::operator=(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FrontendFile = coRef.FrontendFile;
   BackendFile = coRef.BackendFile;
   DDG2PFileName = coRef.DDG2PFileName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::vDestroy()
{
   FrontendFile.vDestroy();
   BackendFile.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < DDG2PFileName.size(); ++u32Idx)
         DDG2PFileName[u32Idx].vDestroy();
   DDG2PFileName.clear();
   }
}

sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult()
:FrontendFile()
,BackendFile()

 {}

tS32 sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETASRLANGUAGEMODELMETHODRESULT;
}


sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::~sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DDG2PFileName.size(); ++u32ListIdx)
      u32DynamicSize += DDG2PFileName[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+FrontendFile.u32GetSize(u16MajorVersion)+BackendFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FrontendFile);
   (tVoid) (oIn >> BackendFile);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DDG2PFileName.size(); ++u32Idx)
      {
         DDG2PFileName[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DDG2PFileName.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DDG2PFileName[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FrontendFile);
   (tVoid) (oOut << BackendFile);
   (tVoid) (oOut << (tU32)DDG2PFileName.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DDG2PFileName.size(); ++u32Idx)
         (tVoid) (oOut << DDG2PFileName[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult::operator==(const sds_speechdpfi_tclMsgGetASRLanguageModelMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FrontendFile == roRef.FrontendFile);
   bResult = bResult && (BackendFile == roRef.BackendFile);
      bResult = bResult && (DDG2PFileName.size() == roRef.DDG2PFileName.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DDG2PFileName.size()); ++u32Idx)
            bResult = bResult && (DDG2PFileName[u32Idx] == roRef.DDG2PFileName[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileAccessMode = coRef.FileAccessMode;
   FileType = coRef.FileType;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   LogicalName = coRef.LogicalName;
}
sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::operator=(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileAccessMode = coRef.FileAccessMode;
   FileType = coRef.FileType;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   LogicalName = coRef.LogicalName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   LogicalName.vDestroy();
}

sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart()
:FileAccessMode()
,FileType()
,LanguageID()
,UserID(0)
,LogicalName()
 {}

tS32 sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCMDCTRLDATAMETHODSTART;
}


sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::~sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+LogicalName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileAccessMode);
   (tVoid) (oIn >> FileType);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> LogicalName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileAccessMode);
   (tVoid) (oOut << FileType);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << LogicalName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart::operator==(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileAccessMode == roRef.FileAccessMode);
   bResult = bResult && (FileType == roRef.FileType);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (LogicalName == roRef.LogicalName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   FileName = coRef.FileName;
}
sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::operator=(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   FileName = coRef.FileName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::vDestroy()
{
   FileName.vDestroy();
}

sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult()
:Cookie(0)
,FileName()
 {}

tS32 sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCMDCTRLDATAMETHODRESULT;
}


sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::~sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+FileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> FileName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << FileName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult::operator==(const sds_speechdpfi_tclMsgGetCmdCtrlDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (FileName == roRef.FileName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgNewUserWordMethodStart::sds_speechdpfi_tclMsgNewUserWordMethodStart(const sds_speechdpfi_tclMsgNewUserWordMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
}
sds_speechdpfi_tclMsgNewUserWordMethodStart& sds_speechdpfi_tclMsgNewUserWordMethodStart::operator=(const sds_speechdpfi_tclMsgNewUserWordMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgNewUserWordMethodStart::sds_speechdpfi_tclMsgNewUserWordMethodStart()
:FileAccessMode()
,LanguageID()
,UserID(0)
,UserWordCategory()
 {}

tS32 sds_speechdpfi_tclMsgNewUserWordMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_NEWUSERWORDMETHODSTART;
}


sds_speechdpfi_tclMsgNewUserWordMethodStart::~sds_speechdpfi_tclMsgNewUserWordMethodStart()
{}

tU32 sds_speechdpfi_tclMsgNewUserWordMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds_speechdpfi_tclMsgNewUserWordMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileAccessMode);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> UserWordCategory);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgNewUserWordMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileAccessMode);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << UserWordCategory);
   return oOut;
}

tBool sds_speechdpfi_tclMsgNewUserWordMethodStart::operator==(const sds_speechdpfi_tclMsgNewUserWordMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileAccessMode == roRef.FileAccessMode);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (UserWordCategory == roRef.UserWordCategory);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgNewUserWordMethodResult::sds_speechdpfi_tclMsgNewUserWordMethodResult(const sds_speechdpfi_tclMsgNewUserWordMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   Grammar = coRef.Grammar;
   Dictionary = coRef.Dictionary;
   LabelFile = coRef.LabelFile;
   UserWordAudioFile = coRef.UserWordAudioFile;
   UserWordIndex = coRef.UserWordIndex;
}
sds_speechdpfi_tclMsgNewUserWordMethodResult& sds_speechdpfi_tclMsgNewUserWordMethodResult::operator=(const sds_speechdpfi_tclMsgNewUserWordMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   Grammar = coRef.Grammar;
   Dictionary = coRef.Dictionary;
   LabelFile = coRef.LabelFile;
   UserWordAudioFile = coRef.UserWordAudioFile;
   UserWordIndex = coRef.UserWordIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgNewUserWordMethodResult::vDestroy()
{
   Grammar.vDestroy();
   Dictionary.vDestroy();
   LabelFile.vDestroy();
   UserWordAudioFile.vDestroy();
}

sds_speechdpfi_tclMsgNewUserWordMethodResult::sds_speechdpfi_tclMsgNewUserWordMethodResult()
:Cookie(0)
,Grammar()
,Dictionary()
,LabelFile()
,UserWordAudioFile()
,UserWordIndex(0)
 {}

tS32 sds_speechdpfi_tclMsgNewUserWordMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_NEWUSERWORDMETHODRESULT;
}


sds_speechdpfi_tclMsgNewUserWordMethodResult::~sds_speechdpfi_tclMsgNewUserWordMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgNewUserWordMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Grammar.u32GetSize(u16MajorVersion)+Dictionary.u32GetSize(u16MajorVersion)+LabelFile.u32GetSize(u16MajorVersion)+UserWordAudioFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgNewUserWordMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> Grammar);
   (tVoid) (oIn >> Dictionary);
   (tVoid) (oIn >> LabelFile);
   (tVoid) (oIn >> UserWordAudioFile);
   (tVoid) (oIn >> UserWordIndex);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgNewUserWordMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << Grammar);
   (tVoid) (oOut << Dictionary);
   (tVoid) (oOut << LabelFile);
   (tVoid) (oOut << UserWordAudioFile);
   (tVoid) (oOut << UserWordIndex);
   return oOut;
}

tBool sds_speechdpfi_tclMsgNewUserWordMethodResult::operator==(const sds_speechdpfi_tclMsgNewUserWordMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (Grammar == roRef.Grammar);
   bResult = bResult && (Dictionary == roRef.Dictionary);
   bResult = bResult && (LabelFile == roRef.LabelFile);
   bResult = bResult && (UserWordAudioFile == roRef.UserWordAudioFile);
   bResult = bResult && (UserWordIndex == roRef.UserWordIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgChangeUserWordMethodStart::sds_speechdpfi_tclMsgChangeUserWordMethodStart(const sds_speechdpfi_tclMsgChangeUserWordMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
   UserWordIndex = coRef.UserWordIndex;
}
sds_speechdpfi_tclMsgChangeUserWordMethodStart& sds_speechdpfi_tclMsgChangeUserWordMethodStart::operator=(const sds_speechdpfi_tclMsgChangeUserWordMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
   UserWordIndex = coRef.UserWordIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgChangeUserWordMethodStart::sds_speechdpfi_tclMsgChangeUserWordMethodStart()
:FileAccessMode()
,LanguageID()
,UserID(0)
,UserWordCategory()
,UserWordIndex(0)
 {}

tS32 sds_speechdpfi_tclMsgChangeUserWordMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CHANGEUSERWORDMETHODSTART;
}


sds_speechdpfi_tclMsgChangeUserWordMethodStart::~sds_speechdpfi_tclMsgChangeUserWordMethodStart()
{}

tU32 sds_speechdpfi_tclMsgChangeUserWordMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds_speechdpfi_tclMsgChangeUserWordMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileAccessMode);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> UserWordCategory);
   (tVoid) (oIn >> UserWordIndex);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgChangeUserWordMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileAccessMode);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << UserWordCategory);
   (tVoid) (oOut << UserWordIndex);
   return oOut;
}

tBool sds_speechdpfi_tclMsgChangeUserWordMethodStart::operator==(const sds_speechdpfi_tclMsgChangeUserWordMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileAccessMode == roRef.FileAccessMode);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (UserWordCategory == roRef.UserWordCategory);
   bResult = bResult && (UserWordIndex == roRef.UserWordIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgChangeUserWordMethodResult::sds_speechdpfi_tclMsgChangeUserWordMethodResult(const sds_speechdpfi_tclMsgChangeUserWordMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   Grammar = coRef.Grammar;
   Dictionary = coRef.Dictionary;
   LabelFile = coRef.LabelFile;
   UserWordAudioFile = coRef.UserWordAudioFile;
}
sds_speechdpfi_tclMsgChangeUserWordMethodResult& sds_speechdpfi_tclMsgChangeUserWordMethodResult::operator=(const sds_speechdpfi_tclMsgChangeUserWordMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   Grammar = coRef.Grammar;
   Dictionary = coRef.Dictionary;
   LabelFile = coRef.LabelFile;
   UserWordAudioFile = coRef.UserWordAudioFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgChangeUserWordMethodResult::vDestroy()
{
   Grammar.vDestroy();
   Dictionary.vDestroy();
   LabelFile.vDestroy();
   UserWordAudioFile.vDestroy();
}

sds_speechdpfi_tclMsgChangeUserWordMethodResult::sds_speechdpfi_tclMsgChangeUserWordMethodResult()
:Cookie(0)
,Grammar()
,Dictionary()
,LabelFile()
,UserWordAudioFile()
 {}

tS32 sds_speechdpfi_tclMsgChangeUserWordMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CHANGEUSERWORDMETHODRESULT;
}


sds_speechdpfi_tclMsgChangeUserWordMethodResult::~sds_speechdpfi_tclMsgChangeUserWordMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgChangeUserWordMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Grammar.u32GetSize(u16MajorVersion)+Dictionary.u32GetSize(u16MajorVersion)+LabelFile.u32GetSize(u16MajorVersion)+UserWordAudioFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgChangeUserWordMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> Grammar);
   (tVoid) (oIn >> Dictionary);
   (tVoid) (oIn >> LabelFile);
   (tVoid) (oIn >> UserWordAudioFile);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgChangeUserWordMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << Grammar);
   (tVoid) (oOut << Dictionary);
   (tVoid) (oOut << LabelFile);
   (tVoid) (oOut << UserWordAudioFile);
   return oOut;
}

tBool sds_speechdpfi_tclMsgChangeUserWordMethodResult::operator==(const sds_speechdpfi_tclMsgChangeUserWordMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (Grammar == roRef.Grammar);
   bResult = bResult && (Dictionary == roRef.Dictionary);
   bResult = bResult && (LabelFile == roRef.LabelFile);
   bResult = bResult && (UserWordAudioFile == roRef.UserWordAudioFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserWordDataMethodStart::sds_speechdpfi_tclMsgGetUserWordDataMethodStart(const sds_speechdpfi_tclMsgGetUserWordDataMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
}
sds_speechdpfi_tclMsgGetUserWordDataMethodStart& sds_speechdpfi_tclMsgGetUserWordDataMethodStart::operator=(const sds_speechdpfi_tclMsgGetUserWordDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetUserWordDataMethodStart::sds_speechdpfi_tclMsgGetUserWordDataMethodStart()
:FileAccessMode()
,LanguageID()
,UserID(0)
 {}

tS32 sds_speechdpfi_tclMsgGetUserWordDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDDATAMETHODSTART;
}


sds_speechdpfi_tclMsgGetUserWordDataMethodStart::~sds_speechdpfi_tclMsgGetUserWordDataMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetUserWordDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserWordDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileAccessMode);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> UserID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserWordDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileAccessMode);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << UserID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserWordDataMethodStart::operator==(const sds_speechdpfi_tclMsgGetUserWordDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileAccessMode == roRef.FileAccessMode);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (UserID == roRef.UserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserWordDataMethodResult::sds_speechdpfi_tclMsgGetUserWordDataMethodResult(const sds_speechdpfi_tclMsgGetUserWordDataMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Grammar = coRef.Grammar;
   LabelFile = coRef.LabelFile;
}
sds_speechdpfi_tclMsgGetUserWordDataMethodResult& sds_speechdpfi_tclMsgGetUserWordDataMethodResult::operator=(const sds_speechdpfi_tclMsgGetUserWordDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Grammar = coRef.Grammar;
   LabelFile = coRef.LabelFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetUserWordDataMethodResult::vDestroy()
{
   Grammar.vDestroy();
   LabelFile.vDestroy();
}

sds_speechdpfi_tclMsgGetUserWordDataMethodResult::sds_speechdpfi_tclMsgGetUserWordDataMethodResult()
:Grammar()
,LabelFile()
 {}

tS32 sds_speechdpfi_tclMsgGetUserWordDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDDATAMETHODRESULT;
}


sds_speechdpfi_tclMsgGetUserWordDataMethodResult::~sds_speechdpfi_tclMsgGetUserWordDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetUserWordDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Grammar.u32GetSize(u16MajorVersion)+LabelFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserWordDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Grammar);
   (tVoid) (oIn >> LabelFile);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserWordDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Grammar);
   (tVoid) (oOut << LabelFile);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserWordDataMethodResult::operator==(const sds_speechdpfi_tclMsgGetUserWordDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Grammar == roRef.Grammar);
   bResult = bResult && (LabelFile == roRef.LabelFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
   UserWordIndex = coRef.UserWordIndex;
}
sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::operator=(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
   UserWordIndex = coRef.UserWordIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart()
:FileAccessMode()
,LanguageID()
,UserID(0)
,UserWordCategory()
,UserWordIndex(0)
 {}

tS32 sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOFILEMETHODSTART;
}


sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::~sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileAccessMode);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> UserWordCategory);
   (tVoid) (oIn >> UserWordIndex);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileAccessMode);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << UserWordCategory);
   (tVoid) (oOut << UserWordIndex);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart::operator==(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileAccessMode == roRef.FileAccessMode);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (UserWordCategory == roRef.UserWordCategory);
   bResult = bResult && (UserWordIndex == roRef.UserWordIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   UserWordAudioFiles = coRef.UserWordAudioFiles;
}
sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::operator=(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   UserWordAudioFiles = coRef.UserWordAudioFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UserWordAudioFiles.size(); ++u32Idx)
         UserWordAudioFiles[u32Idx].vDestroy();
   UserWordAudioFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOFILEMETHODRESULT;
}


sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::~sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UserWordAudioFiles.size(); ++u32ListIdx)
      u32DynamicSize += UserWordAudioFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UserWordAudioFiles.size(); ++u32Idx)
      {
         UserWordAudioFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      UserWordAudioFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> UserWordAudioFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)UserWordAudioFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < UserWordAudioFiles.size(); ++u32Idx)
         (tVoid) (oOut << UserWordAudioFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult::operator==(const sds_speechdpfi_tclMsgGetUserWordAudioFileMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (UserWordAudioFiles.size() == roRef.UserWordAudioFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UserWordAudioFiles.size()); ++u32Idx)
            bResult = bResult && (UserWordAudioFiles[u32Idx] == roRef.UserWordAudioFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::sds_speechdpfi_tclMsgDeleteUserWordsMethodStart(const sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
   UserWordIndex = coRef.UserWordIndex;
}
sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::operator=(const sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileAccessMode = coRef.FileAccessMode;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   UserWordCategory = coRef.UserWordCategory;
   UserWordIndex = coRef.UserWordIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::sds_speechdpfi_tclMsgDeleteUserWordsMethodStart()
:FileAccessMode()
,LanguageID()
,UserID(0)
,UserWordCategory()
,UserWordIndex(0)
 {}

tS32 sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDSMETHODSTART;
}


sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::~sds_speechdpfi_tclMsgDeleteUserWordsMethodStart()
{}

tU32 sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileAccessMode);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> UserID);
   (tVoid) (oIn >> UserWordCategory);
   (tVoid) (oIn >> UserWordIndex);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileAccessMode);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << UserID);
   (tVoid) (oOut << UserWordCategory);
   (tVoid) (oOut << UserWordIndex);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteUserWordsMethodStart::operator==(const sds_speechdpfi_tclMsgDeleteUserWordsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileAccessMode == roRef.FileAccessMode);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (UserID == roRef.UserID);
   bResult = bResult && (UserWordCategory == roRef.UserWordCategory);
   bResult = bResult && (UserWordIndex == roRef.UserWordIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::sds_speechdpfi_tclMsgDeleteUserWordsMethodResult(const sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   Grammar = coRef.Grammar;
   LabelFile = coRef.LabelFile;
   Dictionary = coRef.Dictionary;
}
sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::operator=(const sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   Grammar = coRef.Grammar;
   LabelFile = coRef.LabelFile;
   Dictionary = coRef.Dictionary;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::vDestroy()
{
   Grammar.vDestroy();
   LabelFile.vDestroy();
   Dictionary.vDestroy();
}

sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::sds_speechdpfi_tclMsgDeleteUserWordsMethodResult()
:Cookie(0)
,Grammar()
,LabelFile()
,Dictionary()
 {}

tS32 sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDSMETHODRESULT;
}


sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::~sds_speechdpfi_tclMsgDeleteUserWordsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Grammar.u32GetSize(u16MajorVersion)+LabelFile.u32GetSize(u16MajorVersion)+Dictionary.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> Grammar);
   (tVoid) (oIn >> LabelFile);
   (tVoid) (oIn >> Dictionary);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << Grammar);
   (tVoid) (oOut << LabelFile);
   (tVoid) (oOut << Dictionary);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteUserWordsMethodResult::operator==(const sds_speechdpfi_tclMsgDeleteUserWordsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (Grammar == roRef.Grammar);
   bResult = bResult && (LabelFile == roRef.LabelFile);
   bResult = bResult && (Dictionary == roRef.Dictionary);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart(const sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
}
sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::operator=(const sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   UserID = coRef.UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart()
:LanguageID()
,UserID(0)
 {}

tS32 sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDCATEGORIESMETHODSTART;
}


sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::~sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart()
{}

tU32 sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> UserID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << UserID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart::operator==(const sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (UserID == roRef.UserID);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult::sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDCATEGORIESMETHODRESULT;
}


sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult::~sds_speechdpfi_tclMsgDeleteUserWordCategoriesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::sds_speechdpfi_tclMsgGetASRAudioFileMethodStart(const sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileAccessMode = coRef.FileAccessMode;
   FileID = coRef.FileID;
   StorageDevice = coRef.StorageDevice;
}
sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::operator=(const sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileAccessMode = coRef.FileAccessMode;
   FileID = coRef.FileID;
   StorageDevice = coRef.StorageDevice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::sds_speechdpfi_tclMsgGetASRAudioFileMethodStart()
:FileAccessMode()
,FileID(0)
,StorageDevice()
 {}

tS32 sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETASRAUDIOFILEMETHODSTART;
}


sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::~sds_speechdpfi_tclMsgGetASRAudioFileMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileAccessMode);
   (tVoid) (oIn >> FileID);
   (tVoid) (oIn >> StorageDevice);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileAccessMode);
   (tVoid) (oOut << FileID);
   (tVoid) (oOut << StorageDevice);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetASRAudioFileMethodStart::operator==(const sds_speechdpfi_tclMsgGetASRAudioFileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileAccessMode == roRef.FileAccessMode);
   bResult = bResult && (FileID == roRef.FileID);
   bResult = bResult && (StorageDevice == roRef.StorageDevice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::sds_speechdpfi_tclMsgGetASRAudioFileMethodResult(const sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   FileName = coRef.FileName;
   FileAvailability = coRef.FileAvailability;
}
sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::operator=(const sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   FileName = coRef.FileName;
   FileAvailability = coRef.FileAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::vDestroy()
{
   FileName.vDestroy();
}

sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::sds_speechdpfi_tclMsgGetASRAudioFileMethodResult()
:Cookie(0)
,FileName()
,FileAvailability()
 {}

tS32 sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETASRAUDIOFILEMETHODRESULT;
}


sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::~sds_speechdpfi_tclMsgGetASRAudioFileMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+FileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> FileName);
   (tVoid) (oIn >> FileAvailability);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << FileName);
   (tVoid) (oOut << FileAvailability);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetASRAudioFileMethodResult::operator==(const sds_speechdpfi_tclMsgGetASRAudioFileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (FileName == roRef.FileName);
   bResult = bResult && (FileAvailability == roRef.FileAvailability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart(const sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileID = coRef.FileID;
}
sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::operator=(const sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileID = coRef.FileID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart()
:FileID(0)
 {}

tS32 sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEASRAUDIOFILEMETHODSTART;
}


sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::~sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart()
{}

tU32 sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart::operator==(const sds_speechdpfi_tclMsgDeleteASRAudioFileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileID == roRef.FileID);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult::sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEASRAUDIOFILEMETHODRESULT;
}


sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult::~sds_speechdpfi_tclMsgDeleteASRAudioFileMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileType = coRef.FileType;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   State = coRef.State;
}
sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::operator=(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileType = coRef.FileType;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   State.vDestroy();
}

sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart()
:FileType()
,LanguageID()
,Country()
,State()
 {}

tS32 sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPOICATMETHODSTART;
}


sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::~sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+State.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileType);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileType);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart::operator==(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileType == roRef.FileType);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Category = coRef.Category;
}
sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::operator=(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Category = coRef.Category;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::vDestroy()
{
   {
   Category.clear();
   }
}

sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPOICATMETHODRESULT;
}


sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::~sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Category.size()*2;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Category.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Category[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Category.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Category.size(); ++u32Idx)
         (tVoid) (oOut << Category[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult::operator==(const sds_speechdpfi_tclMsgGetAvailablePoiCatMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Category.size() == roRef.Category.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Category.size()); ++u32Idx)
            bResult = bResult && (Category[u32Idx] == roRef.Category[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDestinationContextMethodStart::sds_speechdpfi_tclMsgGetDestinationContextMethodStart(const sds_speechdpfi_tclMsgGetDestinationContextMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   StateName = coRef.StateName;
   LogicalName = coRef.LogicalName;
   AcmodVersion = coRef.AcmodVersion;
}
sds_speechdpfi_tclMsgGetDestinationContextMethodStart& sds_speechdpfi_tclMsgGetDestinationContextMethodStart::operator=(const sds_speechdpfi_tclMsgGetDestinationContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   StateName = coRef.StateName;
   LogicalName = coRef.LogicalName;
   AcmodVersion = coRef.AcmodVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDestinationContextMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   Country.vDestroy(); 
   StateName.vDestroy(); 
   LogicalName.vDestroy();
   AcmodVersion.vDestroy();
}

sds_speechdpfi_tclMsgGetDestinationContextMethodStart::sds_speechdpfi_tclMsgGetDestinationContextMethodStart()
:LanguageID()
,Country()
,StateName()
,LogicalName()
,AcmodVersion()
 {}

tS32 sds_speechdpfi_tclMsgGetDestinationContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONCONTEXTMETHODSTART;
}


sds_speechdpfi_tclMsgGetDestinationContextMethodStart::~sds_speechdpfi_tclMsgGetDestinationContextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDestinationContextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Country.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion)+LogicalName.u32GetSize(u16MajorVersion)+AcmodVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDestinationContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> StateName);
   (tVoid) (oIn >> LogicalName);
   (tVoid) (oIn >> AcmodVersion);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDestinationContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << StateName);
   (tVoid) (oOut << LogicalName);
   (tVoid) (oOut << AcmodVersion);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDestinationContextMethodStart::operator==(const sds_speechdpfi_tclMsgGetDestinationContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (StateName == roRef.StateName);
   bResult = bResult && (LogicalName == roRef.LogicalName);
   bResult = bResult && (AcmodVersion == roRef.AcmodVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDestinationContextMethodResult::sds_speechdpfi_tclMsgGetDestinationContextMethodResult(const sds_speechdpfi_tclMsgGetDestinationContextMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileName = coRef.FileName;
   Data = coRef.Data;
}
sds_speechdpfi_tclMsgGetDestinationContextMethodResult& sds_speechdpfi_tclMsgGetDestinationContextMethodResult::operator=(const sds_speechdpfi_tclMsgGetDestinationContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FileName = coRef.FileName;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDestinationContextMethodResult::vDestroy()
{
   FileName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         Data[u32Idx].vDestroy();
   Data.clear();
   }
}

sds_speechdpfi_tclMsgGetDestinationContextMethodResult::sds_speechdpfi_tclMsgGetDestinationContextMethodResult()
:FileName()

 {}

tS32 sds_speechdpfi_tclMsgGetDestinationContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONCONTEXTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDestinationContextMethodResult::~sds_speechdpfi_tclMsgGetDestinationContextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDestinationContextMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Data.size(); ++u32ListIdx)
      u32DynamicSize += Data[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+FileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDestinationContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileName);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
      {
         Data[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Data.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Data[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDestinationContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileName);
   (tVoid) (oOut << (tU32)Data.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         (tVoid) (oOut << Data[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDestinationContextMethodResult::operator==(const sds_speechdpfi_tclMsgGetDestinationContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileName == roRef.FileName);
      bResult = bResult && (Data.size() == roRef.Data.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Data.size()); ++u32Idx)
            bResult = bResult && (Data[u32Idx] == roRef.Data[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   CountryName = coRef.CountryName;
   CountryCode = coRef.CountryCode;
   StateName = coRef.StateName;
   StateShort = coRef.StateShort;
   LogicalName = coRef.LogicalName;
}
sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::operator=(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   CountryName = coRef.CountryName;
   CountryCode = coRef.CountryCode;
   StateName = coRef.StateName;
   StateShort = coRef.StateShort;
   LogicalName = coRef.LogicalName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   CountryName.vDestroy();
   StateName.vDestroy();
   StateShort.vDestroy();
   LogicalName.vDestroy();
}

sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart()
:LanguageID()
,CountryName()
,CountryCode()
,StateName()
,StateShort()
,LogicalName()
 {}

tS32 sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSPELLTREEMETHODSTART;
}


sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::~sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+CountryName.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion)+StateShort.u32GetSize(u16MajorVersion)+LogicalName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryName);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> StateName);
   (tVoid) (oIn >> StateShort);
   (tVoid) (oIn >> LogicalName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << StateName);
   (tVoid) (oOut << StateShort);
   (tVoid) (oOut << LogicalName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart::operator==(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryName == roRef.CountryName);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (StateName == roRef.StateName);
   bResult = bResult && (StateShort == roRef.StateShort);
   bResult = bResult && (LogicalName == roRef.LogicalName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileName = coRef.FileName;
}
sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::operator=(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FileName = coRef.FileName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::vDestroy()
{
   FileName.vDestroy();
}

sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult()
:FileName()
 {}

tS32 sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSPELLTREEMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::~sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult::operator==(const sds_speechdpfi_tclMsgGetDestinationSpelltreeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileName == roRef.FileName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSpecialContextMethodStart::sds_speechdpfi_tclMsgGetSpecialContextMethodStart(const sds_speechdpfi_tclMsgGetSpecialContextMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   ContextType = coRef.ContextType;
   AlphabetRange = coRef.AlphabetRange;
   State = coRef.State;
}
sds_speechdpfi_tclMsgGetSpecialContextMethodStart& sds_speechdpfi_tclMsgGetSpecialContextMethodStart::operator=(const sds_speechdpfi_tclMsgGetSpecialContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   ContextType = coRef.ContextType;
   AlphabetRange = coRef.AlphabetRange;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetSpecialContextMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < AlphabetRange.size(); ++u32Idx)
         AlphabetRange[u32Idx].vDestroy();
   AlphabetRange.clear();
   }
   State.vDestroy();
}

sds_speechdpfi_tclMsgGetSpecialContextMethodStart::sds_speechdpfi_tclMsgGetSpecialContextMethodStart()
:LanguageID()
,Country()
,ContextType()

,State()
 {}

tS32 sds_speechdpfi_tclMsgGetSpecialContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSPECIALCONTEXTMETHODSTART;
}


sds_speechdpfi_tclMsgGetSpecialContextMethodStart::~sds_speechdpfi_tclMsgGetSpecialContextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetSpecialContextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AlphabetRange.size(); ++u32ListIdx)
      u32DynamicSize += AlphabetRange[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11+State.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSpecialContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> ContextType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AlphabetRange.size(); ++u32Idx)
      {
         AlphabetRange[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AlphabetRange.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AlphabetRange[u32Idx]);
      }
   }
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSpecialContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << ContextType);
   (tVoid) (oOut << (tU32)AlphabetRange.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AlphabetRange.size(); ++u32Idx)
         (tVoid) (oOut << AlphabetRange[u32Idx]);
   }
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSpecialContextMethodStart::operator==(const sds_speechdpfi_tclMsgGetSpecialContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (ContextType == roRef.ContextType);
      bResult = bResult && (AlphabetRange.size() == roRef.AlphabetRange.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AlphabetRange.size()); ++u32Idx)
            bResult = bResult && (AlphabetRange[u32Idx] == roRef.AlphabetRange[u32Idx]);
      }
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSpecialContextMethodResult::sds_speechdpfi_tclMsgGetSpecialContextMethodResult(const sds_speechdpfi_tclMsgGetSpecialContextMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FileNames = coRef.FileNames;
}
sds_speechdpfi_tclMsgGetSpecialContextMethodResult& sds_speechdpfi_tclMsgGetSpecialContextMethodResult::operator=(const sds_speechdpfi_tclMsgGetSpecialContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FileNames = coRef.FileNames;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetSpecialContextMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FileNames.size(); ++u32Idx)
         FileNames[u32Idx].vDestroy();
   FileNames.clear();
   }
}

sds_speechdpfi_tclMsgGetSpecialContextMethodResult::sds_speechdpfi_tclMsgGetSpecialContextMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetSpecialContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSPECIALCONTEXTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetSpecialContextMethodResult::~sds_speechdpfi_tclMsgGetSpecialContextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetSpecialContextMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FileNames.size(); ++u32ListIdx)
      u32DynamicSize += FileNames[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSpecialContextMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FileNames.size(); ++u32Idx)
      {
         FileNames[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FileNames.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FileNames[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSpecialContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FileNames.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FileNames.size(); ++u32Idx)
         (tVoid) (oOut << FileNames[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSpecialContextMethodResult::operator==(const sds_speechdpfi_tclMsgGetSpecialContextMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FileNames.size() == roRef.FileNames.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FileNames.size()); ++u32Idx)
            bResult = bResult && (FileNames[u32Idx] == roRef.FileNames[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DestinationCategory = coRef.DestinationCategory;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   NameList = coRef.NameList;
   State = coRef.State;
}
sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::operator=(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DestinationCategory = coRef.DestinationCategory;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   NameList = coRef.NameList;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < NameList.size(); ++u32Idx)
         NameList[u32Idx].vDestroy();
   NameList.clear();
   }
   State.vDestroy();
}

sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart()
:DestinationCategory()
,LanguageID()
,Country()

,State()
 {}

tS32 sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GROUPDESTINATIONDICTIONARIESMETHODSTART;
}


sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::~sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < NameList.size(); ++u32ListIdx)
      u32DynamicSize += NameList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+State.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DestinationCategory);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NameList.size(); ++u32Idx)
      {
         NameList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NameList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NameList[u32Idx]);
      }
   }
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DestinationCategory);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << (tU32)NameList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NameList.size(); ++u32Idx)
         (tVoid) (oOut << NameList[u32Idx]);
   }
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart::operator==(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DestinationCategory == roRef.DestinationCategory);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
      bResult = bResult && (NameList.size() == roRef.NameList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NameList.size()); ++u32Idx)
            bResult = bResult && (NameList[u32Idx] == roRef.NameList[u32Idx]);
      }
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DictionaryGroup = coRef.DictionaryGroup;
}
sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::operator=(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DictionaryGroup = coRef.DictionaryGroup;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DictionaryGroup.size(); ++u32Idx)
         DictionaryGroup[u32Idx].vDestroy();
   DictionaryGroup.clear();
   }
}

sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GROUPDESTINATIONDICTIONARIESMETHODRESULT;
}


sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::~sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DictionaryGroup.size(); ++u32ListIdx)
      u32DynamicSize += DictionaryGroup[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DictionaryGroup.size(); ++u32Idx)
      {
         DictionaryGroup[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DictionaryGroup.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DictionaryGroup[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DictionaryGroup.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DictionaryGroup.size(); ++u32Idx)
         (tVoid) (oOut << DictionaryGroup[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult::operator==(const sds_speechdpfi_tclMsgGroupDestinationDictionariesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DictionaryGroup.size() == roRef.DictionaryGroup.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DictionaryGroup.size()); ++u32Idx)
            bResult = bResult && (DictionaryGroup[u32Idx] == roRef.DictionaryGroup[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart::sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPROMPTVOICESMETHODSTART;
}


sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart::~sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult(const sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   AvailablePromptVoices = coRef.AvailablePromptVoices;
}
sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::operator=(const sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailablePromptVoices = coRef.AvailablePromptVoices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailablePromptVoices.size(); ++u32Idx)
         AvailablePromptVoices[u32Idx].vDestroy();
   AvailablePromptVoices.clear();
   }
}

sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEPROMPTVOICESMETHODRESULT;
}


sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::~sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailablePromptVoices.size(); ++u32ListIdx)
      u32DynamicSize += AvailablePromptVoices[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailablePromptVoices.size(); ++u32Idx)
      {
         AvailablePromptVoices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailablePromptVoices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailablePromptVoices[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailablePromptVoices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailablePromptVoices.size(); ++u32Idx)
         (tVoid) (oOut << AvailablePromptVoices[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult::operator==(const sds_speechdpfi_tclMsgGetAvailablePromptVoicesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailablePromptVoices.size() == roRef.AvailablePromptVoices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailablePromptVoices.size()); ++u32Idx)
            bResult = bResult && (AvailablePromptVoices[u32Idx] == roRef.AvailablePromptVoices[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   PromptVoice = coRef.PromptVoice;
}
sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::operator=(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PromptVoice = coRef.PromptVoice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::vDestroy()
{
   PromptVoice.vDestroy(); 
}

sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart()
:PromptVoice()
 {}

tS32 sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPROMPTVOICEDATAMETHODSTART;
}


sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::~sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+PromptVoice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PromptVoice);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PromptVoice);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart::operator==(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PromptVoice == roRef.PromptVoice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   SentenceTables = coRef.SentenceTables;
   DataPackages = coRef.DataPackages;
   CommonFile = coRef.CommonFile;
}
sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::operator=(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SentenceTables = coRef.SentenceTables;
   DataPackages = coRef.DataPackages;
   CommonFile = coRef.CommonFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SentenceTables.size(); ++u32Idx)
         SentenceTables[u32Idx].vDestroy();
   SentenceTables.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < DataPackages.size(); ++u32Idx)
         DataPackages[u32Idx].vDestroy();
   DataPackages.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < CommonFile.size(); ++u32Idx)
         CommonFile[u32Idx].vDestroy();
   CommonFile.clear();
   }
}

sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult()



 {}

tS32 sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPROMPTVOICEDATAMETHODRESULT;
}


sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::~sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SentenceTables.size(); ++u32ListIdx)
      u32DynamicSize += SentenceTables[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < DataPackages.size(); ++u32ListIdx)
      u32DynamicSize += DataPackages[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < CommonFile.size(); ++u32ListIdx)
      u32DynamicSize += CommonFile[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SentenceTables.size(); ++u32Idx)
      {
         SentenceTables[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SentenceTables.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SentenceTables[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataPackages.size(); ++u32Idx)
      {
         DataPackages[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DataPackages.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DataPackages[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CommonFile.size(); ++u32Idx)
      {
         CommonFile[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CommonFile.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CommonFile[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SentenceTables.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SentenceTables.size(); ++u32Idx)
         (tVoid) (oOut << SentenceTables[u32Idx]);
   }
   (tVoid) (oOut << (tU32)DataPackages.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DataPackages.size(); ++u32Idx)
         (tVoid) (oOut << DataPackages[u32Idx]);
   }
   (tVoid) (oOut << (tU32)CommonFile.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CommonFile.size(); ++u32Idx)
         (tVoid) (oOut << CommonFile[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult::operator==(const sds_speechdpfi_tclMsgGetPromptVoiceDataMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SentenceTables.size() == roRef.SentenceTables.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SentenceTables.size()); ++u32Idx)
            bResult = bResult && (SentenceTables[u32Idx] == roRef.SentenceTables[u32Idx]);
      }
      bResult = bResult && (DataPackages.size() == roRef.DataPackages.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataPackages.size()); ++u32Idx)
            bResult = bResult && (DataPackages[u32Idx] == roRef.DataPackages[u32Idx]);
      }
      bResult = bResult && (CommonFile.size() == roRef.CommonFile.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CommonFile.size()); ++u32Idx)
            bResult = bResult && (CommonFile[u32Idx] == roRef.CommonFile[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart::sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLETTSVOICESMETHODSTART;
}


sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart::~sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult(const sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   AvailableTTSVoices = coRef.AvailableTTSVoices;
}
sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::operator=(const sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailableTTSVoices = coRef.AvailableTTSVoices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableTTSVoices.size(); ++u32Idx)
         AvailableTTSVoices[u32Idx].vDestroy();
   AvailableTTSVoices.clear();
   }
}

sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLETTSVOICESMETHODRESULT;
}


sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::~sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailableTTSVoices.size(); ++u32ListIdx)
      u32DynamicSize += AvailableTTSVoices[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableTTSVoices.size(); ++u32Idx)
      {
         AvailableTTSVoices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableTTSVoices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableTTSVoices[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableTTSVoices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableTTSVoices.size(); ++u32Idx)
         (tVoid) (oOut << AvailableTTSVoices[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult::operator==(const sds_speechdpfi_tclMsgGetAvailableTTSVoicesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableTTSVoices.size() == roRef.AvailableTTSVoices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableTTSVoices.size()); ++u32Idx)
            bResult = bResult && (AvailableTTSVoices[u32Idx] == roRef.AvailableTTSVoices[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::sds_speechdpfi_tclMsgGetSpeechDialogMethodStart(const sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
}
sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::operator=(const sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::sds_speechdpfi_tclMsgGetSpeechDialogMethodStart()
:LanguageID()
 {}

tS32 sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSPEECHDIALOGMETHODSTART;
}


sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::~sds_speechdpfi_tclMsgGetSpeechDialogMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSpeechDialogMethodStart::operator==(const sds_speechdpfi_tclMsgGetSpeechDialogMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::sds_speechdpfi_tclMsgGetSpeechDialogMethodResult(const sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DialogFile = coRef.DialogFile;
}
sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::operator=(const sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DialogFile = coRef.DialogFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::vDestroy()
{
   DialogFile.vDestroy();
}

sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::sds_speechdpfi_tclMsgGetSpeechDialogMethodResult()
:DialogFile()
 {}

tS32 sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSPEECHDIALOGMETHODRESULT;
}


sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::~sds_speechdpfi_tclMsgGetSpeechDialogMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DialogFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DialogFile);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DialogFile);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSpeechDialogMethodResult::operator==(const sds_speechdpfi_tclMsgGetSpeechDialogMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DialogFile == roRef.DialogFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgAccessCompletedMethodStart::sds_speechdpfi_tclMsgAccessCompletedMethodStart(const sds_speechdpfi_tclMsgAccessCompletedMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   FileAccessResult = coRef.FileAccessResult;
}
sds_speechdpfi_tclMsgAccessCompletedMethodStart& sds_speechdpfi_tclMsgAccessCompletedMethodStart::operator=(const sds_speechdpfi_tclMsgAccessCompletedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   FileAccessResult = coRef.FileAccessResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgAccessCompletedMethodStart::sds_speechdpfi_tclMsgAccessCompletedMethodStart()
:Cookie(0)
,FileAccessResult()
 {}

tS32 sds_speechdpfi_tclMsgAccessCompletedMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_ACCESSCOMPLETEDMETHODSTART;
}


sds_speechdpfi_tclMsgAccessCompletedMethodStart::~sds_speechdpfi_tclMsgAccessCompletedMethodStart()
{}

tU32 sds_speechdpfi_tclMsgAccessCompletedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_speechdpfi_tclMsgAccessCompletedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> FileAccessResult);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgAccessCompletedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << FileAccessResult);
   return oOut;
}

tBool sds_speechdpfi_tclMsgAccessCompletedMethodStart::operator==(const sds_speechdpfi_tclMsgAccessCompletedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (FileAccessResult == roRef.FileAccessResult);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgAccessCompletedMethodResult::sds_speechdpfi_tclMsgAccessCompletedMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgAccessCompletedMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_ACCESSCOMPLETEDMETHODRESULT;
}


sds_speechdpfi_tclMsgAccessCompletedMethodResult::~sds_speechdpfi_tclMsgAccessCompletedMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::sds_speechdpfi_tclMsgGetVocalizerDataMethodStart(const sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   TTSVoice = coRef.TTSVoice;
}
sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::operator=(const sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TTSVoice = coRef.TTSVoice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::vDestroy()
{
   TTSVoice.vDestroy(); 
}

sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::sds_speechdpfi_tclMsgGetVocalizerDataMethodStart()
:TTSVoice()
 {}

tS32 sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVOCALIZERDATAMETHODSTART;
}


sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::~sds_speechdpfi_tclMsgGetVocalizerDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TTSVoice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TTSVoice);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TTSVoice);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVocalizerDataMethodStart::operator==(const sds_speechdpfi_tclMsgGetVocalizerDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TTSVoice == roRef.TTSVoice);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::sds_speechdpfi_tclMsgGetVocalizerDataMethodResult(const sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   TTSTunningFiles = coRef.TTSTunningFiles;
   TTSVoiceFiles = coRef.TTSVoiceFiles;
   TTSEngine = coRef.TTSEngine;
}
sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::operator=(const sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TTSTunningFiles = coRef.TTSTunningFiles;
   TTSVoiceFiles = coRef.TTSVoiceFiles;
   TTSEngine = coRef.TTSEngine;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TTSTunningFiles.size(); ++u32Idx)
         TTSTunningFiles[u32Idx].vDestroy();
   TTSTunningFiles.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < TTSVoiceFiles.size(); ++u32Idx)
         TTSVoiceFiles[u32Idx].vDestroy();
   TTSVoiceFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::sds_speechdpfi_tclMsgGetVocalizerDataMethodResult()


:TTSEngine()
 {}

tS32 sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVOCALIZERDATAMETHODRESULT;
}


sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::~sds_speechdpfi_tclMsgGetVocalizerDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TTSTunningFiles.size(); ++u32ListIdx)
      u32DynamicSize += TTSTunningFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < TTSVoiceFiles.size(); ++u32ListIdx)
      u32DynamicSize += TTSVoiceFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TTSTunningFiles.size(); ++u32Idx)
      {
         TTSTunningFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TTSTunningFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TTSTunningFiles[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TTSVoiceFiles.size(); ++u32Idx)
      {
         TTSVoiceFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TTSVoiceFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TTSVoiceFiles[u32Idx]);
      }
   }
   (tVoid) (oIn >> TTSEngine);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TTSTunningFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TTSTunningFiles.size(); ++u32Idx)
         (tVoid) (oOut << TTSTunningFiles[u32Idx]);
   }
   (tVoid) (oOut << (tU32)TTSVoiceFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TTSVoiceFiles.size(); ++u32Idx)
         (tVoid) (oOut << TTSVoiceFiles[u32Idx]);
   }
   (tVoid) (oOut << TTSEngine);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVocalizerDataMethodResult::operator==(const sds_speechdpfi_tclMsgGetVocalizerDataMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TTSTunningFiles.size() == roRef.TTSTunningFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TTSTunningFiles.size()); ++u32Idx)
            bResult = bResult && (TTSTunningFiles[u32Idx] == roRef.TTSTunningFiles[u32Idx]);
      }
      bResult = bResult && (TTSVoiceFiles.size() == roRef.TTSVoiceFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TTSVoiceFiles.size()); ++u32Idx)
            bResult = bResult && (TTSVoiceFiles[u32Idx] == roRef.TTSVoiceFiles[u32Idx]);
      }
   bResult = bResult && (TTSEngine == roRef.TTSEngine);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVoconDataMethodStart::sds_speechdpfi_tclMsgGetVoconDataMethodStart(const sds_speechdpfi_tclMsgGetVoconDataMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
}
sds_speechdpfi_tclMsgGetVoconDataMethodStart& sds_speechdpfi_tclMsgGetVoconDataMethodStart::operator=(const sds_speechdpfi_tclMsgGetVoconDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetVoconDataMethodStart::sds_speechdpfi_tclMsgGetVoconDataMethodStart()
:LanguageID()
 {}

tS32 sds_speechdpfi_tclMsgGetVoconDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVOCONDATAMETHODSTART;
}


sds_speechdpfi_tclMsgGetVoconDataMethodStart::~sds_speechdpfi_tclMsgGetVoconDataMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetVoconDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVoconDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVoconDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVoconDataMethodStart::operator==(const sds_speechdpfi_tclMsgGetVoconDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVoconDataMethodResult::sds_speechdpfi_tclMsgGetVoconDataMethodResult(const sds_speechdpfi_tclMsgGetVoconDataMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ConfigFile = coRef.ConfigFile;
   LanguageModel = coRef.LanguageModel;
   SessionData_LM = coRef.SessionData_LM;
   SessionData_FE = coRef.SessionData_FE;
}
sds_speechdpfi_tclMsgGetVoconDataMethodResult& sds_speechdpfi_tclMsgGetVoconDataMethodResult::operator=(const sds_speechdpfi_tclMsgGetVoconDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ConfigFile = coRef.ConfigFile;
   LanguageModel = coRef.LanguageModel;
   SessionData_LM = coRef.SessionData_LM;
   SessionData_FE = coRef.SessionData_FE;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVoconDataMethodResult::vDestroy()
{
   ConfigFile.vDestroy();
   LanguageModel.vDestroy();
   SessionData_LM.vDestroy();
   SessionData_FE.vDestroy();
}

sds_speechdpfi_tclMsgGetVoconDataMethodResult::sds_speechdpfi_tclMsgGetVoconDataMethodResult()
:ConfigFile()
,LanguageModel()
,SessionData_LM()
,SessionData_FE()
 {}

tS32 sds_speechdpfi_tclMsgGetVoconDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVOCONDATAMETHODRESULT;
}


sds_speechdpfi_tclMsgGetVoconDataMethodResult::~sds_speechdpfi_tclMsgGetVoconDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVoconDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ConfigFile.u32GetSize(u16MajorVersion)+LanguageModel.u32GetSize(u16MajorVersion)+SessionData_LM.u32GetSize(u16MajorVersion)+SessionData_FE.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVoconDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigFile);
   (tVoid) (oIn >> LanguageModel);
   (tVoid) (oIn >> SessionData_LM);
   (tVoid) (oIn >> SessionData_FE);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVoconDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigFile);
   (tVoid) (oOut << LanguageModel);
   (tVoid) (oOut << SessionData_LM);
   (tVoid) (oOut << SessionData_FE);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVoconDataMethodResult::operator==(const sds_speechdpfi_tclMsgGetVoconDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigFile == roRef.ConfigFile);
   bResult = bResult && (LanguageModel == roRef.LanguageModel);
   bResult = bResult && (SessionData_LM == roRef.SessionData_LM);
   bResult = bResult && (SessionData_FE == roRef.SessionData_FE);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetContextMethodStart::sds_speechdpfi_tclMsgGetContextMethodStart(const sds_speechdpfi_tclMsgGetContextMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   LogicalName = coRef.LogicalName;
}
sds_speechdpfi_tclMsgGetContextMethodStart& sds_speechdpfi_tclMsgGetContextMethodStart::operator=(const sds_speechdpfi_tclMsgGetContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   LogicalName = coRef.LogicalName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetContextMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   LogicalName.vDestroy();
}

sds_speechdpfi_tclMsgGetContextMethodStart::sds_speechdpfi_tclMsgGetContextMethodStart()
:LanguageID()
,LogicalName()
 {}

tS32 sds_speechdpfi_tclMsgGetContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCONTEXTMETHODSTART;
}


sds_speechdpfi_tclMsgGetContextMethodStart::~sds_speechdpfi_tclMsgGetContextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetContextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+LogicalName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> LogicalName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << LogicalName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetContextMethodStart::operator==(const sds_speechdpfi_tclMsgGetContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (LogicalName == roRef.LogicalName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetContextMethodResult::sds_speechdpfi_tclMsgGetContextMethodResult(const sds_speechdpfi_tclMsgGetContextMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ContextFiles = coRef.ContextFiles;
}
sds_speechdpfi_tclMsgGetContextMethodResult& sds_speechdpfi_tclMsgGetContextMethodResult::operator=(const sds_speechdpfi_tclMsgGetContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ContextFiles = coRef.ContextFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetContextMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ContextFiles.size(); ++u32Idx)
         ContextFiles[u32Idx].vDestroy();
   ContextFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetContextMethodResult::sds_speechdpfi_tclMsgGetContextMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCONTEXTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetContextMethodResult::~sds_speechdpfi_tclMsgGetContextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetContextMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ContextFiles.size(); ++u32ListIdx)
      u32DynamicSize += ContextFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetContextMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ContextFiles.size(); ++u32Idx)
      {
         ContextFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ContextFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContextFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContextFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContextFiles.size(); ++u32Idx)
         (tVoid) (oOut << ContextFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetContextMethodResult::operator==(const sds_speechdpfi_tclMsgGetContextMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContextFiles.size() == roRef.ContextFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContextFiles.size()); ++u32Idx)
            bResult = bResult && (ContextFiles[u32Idx] == roRef.ContextFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSemBufferMethodStart::sds_speechdpfi_tclMsgGetSemBufferMethodStart(const sds_speechdpfi_tclMsgGetSemBufferMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   LogicalName = coRef.LogicalName;
}
sds_speechdpfi_tclMsgGetSemBufferMethodStart& sds_speechdpfi_tclMsgGetSemBufferMethodStart::operator=(const sds_speechdpfi_tclMsgGetSemBufferMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   LogicalName = coRef.LogicalName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetSemBufferMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   LogicalName.vDestroy();
}

sds_speechdpfi_tclMsgGetSemBufferMethodStart::sds_speechdpfi_tclMsgGetSemBufferMethodStart()
:LanguageID()
,LogicalName()
 {}

tS32 sds_speechdpfi_tclMsgGetSemBufferMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSEMBUFFERMETHODSTART;
}


sds_speechdpfi_tclMsgGetSemBufferMethodStart::~sds_speechdpfi_tclMsgGetSemBufferMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetSemBufferMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+LogicalName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSemBufferMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> LogicalName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSemBufferMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << LogicalName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSemBufferMethodStart::operator==(const sds_speechdpfi_tclMsgGetSemBufferMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (LogicalName == roRef.LogicalName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetSemBufferMethodResult::sds_speechdpfi_tclMsgGetSemBufferMethodResult(const sds_speechdpfi_tclMsgGetSemBufferMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   BufferFiles = coRef.BufferFiles;
}
sds_speechdpfi_tclMsgGetSemBufferMethodResult& sds_speechdpfi_tclMsgGetSemBufferMethodResult::operator=(const sds_speechdpfi_tclMsgGetSemBufferMethodResult& coRef)
{
   if (this == &coRef) return *this;
   BufferFiles = coRef.BufferFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetSemBufferMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BufferFiles.size(); ++u32Idx)
         BufferFiles[u32Idx].vDestroy();
   BufferFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetSemBufferMethodResult::sds_speechdpfi_tclMsgGetSemBufferMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetSemBufferMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSEMBUFFERMETHODRESULT;
}


sds_speechdpfi_tclMsgGetSemBufferMethodResult::~sds_speechdpfi_tclMsgGetSemBufferMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetSemBufferMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BufferFiles.size(); ++u32ListIdx)
      u32DynamicSize += BufferFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetSemBufferMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BufferFiles.size(); ++u32Idx)
      {
         BufferFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BufferFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BufferFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetSemBufferMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)BufferFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BufferFiles.size(); ++u32Idx)
         (tVoid) (oOut << BufferFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetSemBufferMethodResult::operator==(const sds_speechdpfi_tclMsgGetSemBufferMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (BufferFiles.size() == roRef.BufferFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BufferFiles.size()); ++u32Idx)
            bResult = bResult && (BufferFiles[u32Idx] == roRef.BufferFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::sds_speechdpfi_tclMsgCheckDynamicContextMethodStart(const sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   Devices = coRef.Devices;
}
sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::operator=(const sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   Devices = coRef.Devices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         Devices[u32Idx].vDestroy();
   Devices.clear();
   }
}

sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::sds_speechdpfi_tclMsgCheckDynamicContextMethodStart()
:LanguageID()
,DomainID()

 {}

tS32 sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CHECKDYNAMICCONTEXTMETHODSTART;
}


sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::~sds_speechdpfi_tclMsgCheckDynamicContextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+Devices.size()*12;
}

fi_tclInContext& sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> DomainID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
      {
         Devices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Devices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Devices[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << (tU32)Devices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         (tVoid) (oOut << Devices[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgCheckDynamicContextMethodStart::operator==(const sds_speechdpfi_tclMsgCheckDynamicContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (DomainID == roRef.DomainID);
      bResult = bResult && (Devices.size() == roRef.Devices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Devices.size()); ++u32Idx)
            bResult = bResult && (Devices[u32Idx] == roRef.Devices[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::sds_speechdpfi_tclMsgCheckDynamicContextMethodResult(const sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Devices = coRef.Devices;
}
sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::operator=(const sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Devices = coRef.Devices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         Devices[u32Idx].vDestroy();
   Devices.clear();
   }
}

sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::sds_speechdpfi_tclMsgCheckDynamicContextMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CHECKDYNAMICCONTEXTMETHODRESULT;
}


sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::~sds_speechdpfi_tclMsgCheckDynamicContextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Devices.size()*12;
}

fi_tclInContext& sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
      {
         Devices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Devices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Devices[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Devices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         (tVoid) (oOut << Devices[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgCheckDynamicContextMethodResult::operator==(const sds_speechdpfi_tclMsgCheckDynamicContextMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Devices.size() == roRef.Devices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Devices.size()); ++u32Idx)
            bResult = bResult && (Devices[u32Idx] == roRef.Devices[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDynamicContextMethodStart::sds_speechdpfi_tclMsgGetDynamicContextMethodStart(const sds_speechdpfi_tclMsgGetDynamicContextMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   DeviceID = coRef.DeviceID;
}
sds_speechdpfi_tclMsgGetDynamicContextMethodStart& sds_speechdpfi_tclMsgGetDynamicContextMethodStart::operator=(const sds_speechdpfi_tclMsgGetDynamicContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   DeviceID = coRef.DeviceID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetDynamicContextMethodStart::sds_speechdpfi_tclMsgGetDynamicContextMethodStart()
:LanguageID()
,DomainID()
,DeviceID(0)
 {}

tS32 sds_speechdpfi_tclMsgGetDynamicContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTMETHODSTART;
}


sds_speechdpfi_tclMsgGetDynamicContextMethodStart::~sds_speechdpfi_tclMsgGetDynamicContextMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetDynamicContextMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDynamicContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> DeviceID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDynamicContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << DeviceID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDynamicContextMethodStart::operator==(const sds_speechdpfi_tclMsgGetDynamicContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (DeviceID == roRef.DeviceID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDynamicContextMethodResult::sds_speechdpfi_tclMsgGetDynamicContextMethodResult(const sds_speechdpfi_tclMsgGetDynamicContextMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DeviceMetaFile = coRef.DeviceMetaFile;
}
sds_speechdpfi_tclMsgGetDynamicContextMethodResult& sds_speechdpfi_tclMsgGetDynamicContextMethodResult::operator=(const sds_speechdpfi_tclMsgGetDynamicContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceMetaFile = coRef.DeviceMetaFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDynamicContextMethodResult::vDestroy()
{
   DeviceMetaFile.vDestroy();
}

sds_speechdpfi_tclMsgGetDynamicContextMethodResult::sds_speechdpfi_tclMsgGetDynamicContextMethodResult()
:DeviceMetaFile()
 {}

tS32 sds_speechdpfi_tclMsgGetDynamicContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDynamicContextMethodResult::~sds_speechdpfi_tclMsgGetDynamicContextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDynamicContextMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DeviceMetaFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDynamicContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceMetaFile);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDynamicContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceMetaFile);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDynamicContextMethodResult::operator==(const sds_speechdpfi_tclMsgGetDynamicContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceMetaFile == roRef.DeviceMetaFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StorageLocation = coRef.StorageLocation;
}
sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::operator=(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StorageLocation = coRef.StorageLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart()
:StorageLocation()
 {}

tS32 sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CREATEDYNAMICCONTEXTFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::~sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart()
{}

tU32 sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StorageLocation);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StorageLocation);
   return oOut;
}

tBool sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart::operator==(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StorageLocation == roRef.StorageLocation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FolderName = coRef.FolderName;
   FreeSpace = coRef.FreeSpace;
   Cookie = coRef.Cookie;
}
sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::operator=(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FolderName = coRef.FolderName;
   FreeSpace = coRef.FreeSpace;
   Cookie = coRef.Cookie;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::vDestroy()
{
   FolderName.vDestroy();
}

sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult()
:FolderName()
,FreeSpace(0)
,Cookie(0)
 {}

tS32 sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CREATEDYNAMICCONTEXTFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::~sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+FolderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FolderName);
   (tVoid) (oIn >> FreeSpace);
   (tVoid) (oIn >> Cookie);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FolderName);
   (tVoid) (oOut << FreeSpace);
   (tVoid) (oOut << Cookie);
   return oOut;
}

tBool sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult::operator==(const sds_speechdpfi_tclMsgCreateDynamicContextFolderMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FolderName == roRef.FolderName);
   bResult = bResult && (FreeSpace == roRef.FreeSpace);
   bResult = bResult && (Cookie == roRef.Cookie);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   MetafileName = coRef.MetafileName;
}
sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::operator=(const sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   MetafileName = coRef.MetafileName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::vDestroy()
{
   MetafileName.vDestroy();
}

sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart()
:Cookie(0)
,MetafileName()
 {}

tS32 sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COMMITDYNAMICCONTEXTFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::~sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+MetafileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> MetafileName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << MetafileName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart::operator==(const sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (MetafileName == roRef.MetafileName);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult::sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COMMITDYNAMICCONTEXTFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult::~sds_speechdpfi_tclMsgCommitDynamicContextFolderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
}
sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::operator=(const sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart()
:Cookie(0)
 {}

tS32 sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_ROLLBACKDYNAMICCONTEXTFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::~sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart()
{}

tU32 sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   return oOut;
}

tBool sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart::operator==(const sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult::sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_ROLLBACKDYNAMICCONTEXTFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult::~sds_speechdpfi_tclMsgRollbackDynamicContextFolderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   NeededSpace = coRef.NeededSpace;
   DomainID = coRef.DomainID;
   StorageLocation = coRef.StorageLocation;
}
sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::operator=(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NeededSpace = coRef.NeededSpace;
   DomainID = coRef.DomainID;
   StorageLocation = coRef.StorageLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart()
:NeededSpace(0)
,DomainID()
,StorageLocation()
 {}

tS32 sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEOLDDYNAMICCONTEXTFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::~sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart()
{}

tU32 sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NeededSpace);
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> StorageLocation);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NeededSpace);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << StorageLocation);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart::operator==(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NeededSpace == roRef.NeededSpace);
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (StorageLocation == roRef.StorageLocation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FreeSpace = coRef.FreeSpace;
}
sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::operator=(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FreeSpace = coRef.FreeSpace;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult()
:FreeSpace(0)
 {}

tS32 sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEOLDDYNAMICCONTEXTFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::~sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult()
{}

tU32 sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FreeSpace);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FreeSpace);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult::operator==(const sds_speechdpfi_tclMsgDeleteOldDynamicContextFolderMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FreeSpace == roRef.FreeSpace);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteFolderMethodStart::sds_speechdpfi_tclMsgDeleteFolderMethodStart(const sds_speechdpfi_tclMsgDeleteFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FolderName = coRef.FolderName;
}
sds_speechdpfi_tclMsgDeleteFolderMethodStart& sds_speechdpfi_tclMsgDeleteFolderMethodStart::operator=(const sds_speechdpfi_tclMsgDeleteFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FolderName = coRef.FolderName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgDeleteFolderMethodStart::vDestroy()
{
   FolderName.vDestroy();
}

sds_speechdpfi_tclMsgDeleteFolderMethodStart::sds_speechdpfi_tclMsgDeleteFolderMethodStart()
:FolderName()
 {}

tS32 sds_speechdpfi_tclMsgDeleteFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgDeleteFolderMethodStart::~sds_speechdpfi_tclMsgDeleteFolderMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgDeleteFolderMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FolderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FolderName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FolderName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteFolderMethodStart::operator==(const sds_speechdpfi_tclMsgDeleteFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FolderName == roRef.FolderName);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgDeleteFolderMethodResult::sds_speechdpfi_tclMsgDeleteFolderMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgDeleteFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgDeleteFolderMethodResult::~sds_speechdpfi_tclMsgDeleteFolderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
}
sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::operator=(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart()
:LanguageID()
 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDATAMETHODSTART;
}


sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::~sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart::operator==(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ConfigFile = coRef.ConfigFile;
   LanguageModelFile = coRef.LanguageModelFile;
}
sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::operator=(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ConfigFile = coRef.ConfigFile;
   LanguageModelFile = coRef.LanguageModelFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::vDestroy()
{
   ConfigFile.vDestroy();
   LanguageModelFile.vDestroy();
}

sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult()
:ConfigFile()
,LanguageModelFile()
 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDATAMETHODRESULT;
}


sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::~sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ConfigFile.u32GetSize(u16MajorVersion)+LanguageModelFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigFile);
   (tVoid) (oIn >> LanguageModelFile);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigFile);
   (tVoid) (oOut << LanguageModelFile);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult::operator==(const sds_speechdpfi_tclMsgGetTranscriptionDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigFile == roRef.ConfigFile);
   bResult = bResult && (LanguageModelFile == roRef.LanguageModelFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   LogicalName = coRef.LogicalName;
}
sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::operator=(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   LogicalName = coRef.LogicalName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   LogicalName.vDestroy();
}

sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart()
:LanguageID()
,LogicalName()
 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONBUFFERMETHODSTART;
}


sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::~sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+LogicalName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> LogicalName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << LogicalName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart::operator==(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (LogicalName == roRef.LogicalName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Files = coRef.Files;
}
sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::operator=(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Files = coRef.Files;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Files.size(); ++u32Idx)
         Files[u32Idx].vDestroy();
   Files.clear();
   }
}

sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONBUFFERMETHODRESULT;
}


sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::~sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Files.size(); ++u32ListIdx)
      u32DynamicSize += Files[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Files.size(); ++u32Idx)
      {
         Files[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Files.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Files[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Files.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Files.size(); ++u32Idx)
         (tVoid) (oOut << Files[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult::operator==(const sds_speechdpfi_tclMsgGetTranscriptionBufferMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Files.size() == roRef.Files.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Files.size()); ++u32Idx)
            bResult = bResult && (Files[u32Idx] == roRef.Files[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   SlotName = coRef.SlotName;
}
sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::operator=(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   SlotName = coRef.SlotName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   SlotName.vDestroy();
}

sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart()
:LanguageID()
,SlotName()
 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDICTIONARYMETHODSTART;
}


sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::~sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+SlotName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> SlotName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << SlotName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart::operator==(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (SlotName == roRef.SlotName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DictionaryFiles = coRef.DictionaryFiles;
}
sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::operator=(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DictionaryFiles = coRef.DictionaryFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DictionaryFiles.size(); ++u32Idx)
         DictionaryFiles[u32Idx].vDestroy();
   DictionaryFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONDICTIONARYMETHODRESULT;
}


sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::~sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DictionaryFiles.size(); ++u32ListIdx)
      u32DynamicSize += DictionaryFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DictionaryFiles.size(); ++u32Idx)
      {
         DictionaryFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DictionaryFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DictionaryFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DictionaryFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DictionaryFiles.size(); ++u32Idx)
         (tVoid) (oOut << DictionaryFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult::operator==(const sds_speechdpfi_tclMsgGetTranscriptionDictionaryMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DictionaryFiles.size() == roRef.DictionaryFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DictionaryFiles.size()); ++u32Idx)
            bResult = bResult && (DictionaryFiles[u32Idx] == roRef.DictionaryFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   SlotName = coRef.SlotName;
}
sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::operator=(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   SlotName = coRef.SlotName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   SlotName.vDestroy();
}

sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart()
:LanguageID()
,SlotName()
 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONRULESETMETHODSTART;
}


sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::~sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+SlotName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> SlotName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << SlotName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart::operator==(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (SlotName == roRef.SlotName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   RulesetFiles = coRef.RulesetFiles;
}
sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::operator=(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RulesetFiles = coRef.RulesetFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RulesetFiles.size(); ++u32Idx)
         RulesetFiles[u32Idx].vDestroy();
   RulesetFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETTRANSCRIPTIONRULESETMETHODRESULT;
}


sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::~sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RulesetFiles.size(); ++u32ListIdx)
      u32DynamicSize += RulesetFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RulesetFiles.size(); ++u32Idx)
      {
         RulesetFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RulesetFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RulesetFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RulesetFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RulesetFiles.size(); ++u32Idx)
         (tVoid) (oOut << RulesetFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult::operator==(const sds_speechdpfi_tclMsgGetTranscriptionRulesetMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RulesetFiles.size() == roRef.RulesetFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RulesetFiles.size()); ++u32Idx)
            bResult = bResult && (RulesetFiles[u32Idx] == roRef.RulesetFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDataPathMethodStart::sds_speechdpfi_tclMsgGetDataPathMethodStart(const sds_speechdpfi_tclMsgGetDataPathMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Type = coRef.Type;
}
sds_speechdpfi_tclMsgGetDataPathMethodStart& sds_speechdpfi_tclMsgGetDataPathMethodStart::operator=(const sds_speechdpfi_tclMsgGetDataPathMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetDataPathMethodStart::sds_speechdpfi_tclMsgGetDataPathMethodStart()
:Type()
 {}

tS32 sds_speechdpfi_tclMsgGetDataPathMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDATAPATHMETHODSTART;
}


sds_speechdpfi_tclMsgGetDataPathMethodStart::~sds_speechdpfi_tclMsgGetDataPathMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetDataPathMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDataPathMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDataPathMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDataPathMethodStart::operator==(const sds_speechdpfi_tclMsgGetDataPathMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDataPathMethodResult::sds_speechdpfi_tclMsgGetDataPathMethodResult(const sds_speechdpfi_tclMsgGetDataPathMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Path = coRef.Path;
}
sds_speechdpfi_tclMsgGetDataPathMethodResult& sds_speechdpfi_tclMsgGetDataPathMethodResult::operator=(const sds_speechdpfi_tclMsgGetDataPathMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Path = coRef.Path;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDataPathMethodResult::vDestroy()
{
   Path.vDestroy();
}

sds_speechdpfi_tclMsgGetDataPathMethodResult::sds_speechdpfi_tclMsgGetDataPathMethodResult()
:Path()
 {}

tS32 sds_speechdpfi_tclMsgGetDataPathMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDATAPATHMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDataPathMethodResult::~sds_speechdpfi_tclMsgGetDataPathMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDataPathMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Path.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDataPathMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Path);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDataPathMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Path);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDataPathMethodResult::operator==(const sds_speechdpfi_tclMsgGetDataPathMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Path == roRef.Path);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetStringFromIDMethodStart::sds_speechdpfi_tclMsgGetStringFromIDMethodStart(const sds_speechdpfi_tclMsgGetStringFromIDMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   IDs = coRef.IDs;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
}
sds_speechdpfi_tclMsgGetStringFromIDMethodStart& sds_speechdpfi_tclMsgGetStringFromIDMethodStart::operator=(const sds_speechdpfi_tclMsgGetStringFromIDMethodStart& coRef)
{
   if (this == &coRef) return *this;
   IDs = coRef.IDs;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetStringFromIDMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < IDs.size(); ++u32Idx)
         IDs[u32Idx].vDestroy();
   IDs.clear();
   }
   LanguageID.vDestroy(); 
   CountryName.vDestroy();
}

sds_speechdpfi_tclMsgGetStringFromIDMethodStart::sds_speechdpfi_tclMsgGetStringFromIDMethodStart()

:LanguageID()
,CountryCode()
,CountryName()
 {}

tS32 sds_speechdpfi_tclMsgGetStringFromIDMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSTRINGFROMIDMETHODSTART;
}


sds_speechdpfi_tclMsgGetStringFromIDMethodStart::~sds_speechdpfi_tclMsgGetStringFromIDMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetStringFromIDMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IDs.size(); ++u32ListIdx)
      u32DynamicSize += IDs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10+CountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetStringFromIDMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IDs.size(); ++u32Idx)
      {
         IDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IDs[u32Idx]);
      }
   }
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> CountryName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetStringFromIDMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)IDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IDs.size(); ++u32Idx)
         (tVoid) (oOut << IDs[u32Idx]);
   }
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << CountryName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetStringFromIDMethodStart::operator==(const sds_speechdpfi_tclMsgGetStringFromIDMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (IDs.size() == roRef.IDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IDs.size()); ++u32Idx)
            bResult = bResult && (IDs[u32Idx] == roRef.IDs[u32Idx]);
      }
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (CountryName == roRef.CountryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetStringFromIDMethodResult::sds_speechdpfi_tclMsgGetStringFromIDMethodResult(const sds_speechdpfi_tclMsgGetStringFromIDMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StringsAndTypes = coRef.StringsAndTypes;
}
sds_speechdpfi_tclMsgGetStringFromIDMethodResult& sds_speechdpfi_tclMsgGetStringFromIDMethodResult::operator=(const sds_speechdpfi_tclMsgGetStringFromIDMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StringsAndTypes = coRef.StringsAndTypes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetStringFromIDMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringsAndTypes.size(); ++u32Idx)
         StringsAndTypes[u32Idx].vDestroy();
   StringsAndTypes.clear();
   }
}

sds_speechdpfi_tclMsgGetStringFromIDMethodResult::sds_speechdpfi_tclMsgGetStringFromIDMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetStringFromIDMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSTRINGFROMIDMETHODRESULT;
}


sds_speechdpfi_tclMsgGetStringFromIDMethodResult::~sds_speechdpfi_tclMsgGetStringFromIDMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetStringFromIDMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringsAndTypes.size(); ++u32ListIdx)
      u32DynamicSize += StringsAndTypes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetStringFromIDMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringsAndTypes.size(); ++u32Idx)
      {
         StringsAndTypes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringsAndTypes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringsAndTypes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetStringFromIDMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringsAndTypes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringsAndTypes.size(); ++u32Idx)
         (tVoid) (oOut << StringsAndTypes[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetStringFromIDMethodResult::operator==(const sds_speechdpfi_tclMsgGetStringFromIDMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringsAndTypes.size() == roRef.StringsAndTypes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringsAndTypes.size()); ++u32Idx)
            bResult = bResult && (StringsAndTypes[u32Idx] == roRef.StringsAndTypes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ID = coRef.ID;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
}
sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::operator=(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::vDestroy()
{
   ID.vDestroy(); 
   LanguageID.vDestroy(); 
   Country.vDestroy(); 
}

sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart()
:ID()
,LanguageID()
,Country()
 {}

tS32 sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMIDMETHODSTART;
}


sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::~sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 28+Country.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart::operator==(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Phoneme = coRef.Phoneme;
}
sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::operator=(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Phoneme = coRef.Phoneme;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::vDestroy()
{
   Phoneme.vDestroy();
}

sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult()
:Phoneme()
 {}

tS32 sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMIDMETHODRESULT;
}


sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::~sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Phoneme.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Phoneme);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Phoneme);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult::operator==(const sds_speechdpfi_tclMsgGetPhonemeFromIDMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Phoneme == roRef.Phoneme);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StringAndType = coRef.StringAndType;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
}
sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StringAndType = coRef.StringAndType;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::vDestroy()
{
   StringAndType.vDestroy(); 
   LanguageID.vDestroy(); 
   CountryName.vDestroy();
}

sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart()
:StringAndType()
,LanguageID()
,CountryCode()
,CountryName()
 {}

tS32 sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGMETHODSTART;
}


sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::~sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+StringAndType.u32GetSize(u16MajorVersion)+CountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StringAndType);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> CountryName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StringAndType);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << CountryName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart::operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StringAndType == roRef.StringAndType);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (CountryName == roRef.CountryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Phoneme = coRef.Phoneme;
}
sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Phoneme = coRef.Phoneme;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::vDestroy()
{
   Phoneme.vDestroy();
}

sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult()
:Phoneme()
 {}

tS32 sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGMETHODRESULT;
}


sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::~sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Phoneme.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Phoneme);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Phoneme);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult::operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Phoneme == roRef.Phoneme);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetIDFromStringMethodStart::sds_speechdpfi_tclMsgGetIDFromStringMethodStart(const sds_speechdpfi_tclMsgGetIDFromStringMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StringAndTypes = coRef.StringAndTypes;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
}
sds_speechdpfi_tclMsgGetIDFromStringMethodStart& sds_speechdpfi_tclMsgGetIDFromStringMethodStart::operator=(const sds_speechdpfi_tclMsgGetIDFromStringMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StringAndTypes = coRef.StringAndTypes;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetIDFromStringMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringAndTypes.size(); ++u32Idx)
         StringAndTypes[u32Idx].vDestroy();
   StringAndTypes.clear();
   }
   LanguageID.vDestroy(); 
   CountryName.vDestroy();
}

sds_speechdpfi_tclMsgGetIDFromStringMethodStart::sds_speechdpfi_tclMsgGetIDFromStringMethodStart()

:LanguageID()
,CountryCode()
,CountryName()
 {}

tS32 sds_speechdpfi_tclMsgGetIDFromStringMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGMETHODSTART;
}


sds_speechdpfi_tclMsgGetIDFromStringMethodStart::~sds_speechdpfi_tclMsgGetIDFromStringMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetIDFromStringMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringAndTypes.size(); ++u32ListIdx)
      u32DynamicSize += StringAndTypes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10+CountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetIDFromStringMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringAndTypes.size(); ++u32Idx)
      {
         StringAndTypes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringAndTypes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringAndTypes[u32Idx]);
      }
   }
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> CountryName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetIDFromStringMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringAndTypes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringAndTypes.size(); ++u32Idx)
         (tVoid) (oOut << StringAndTypes[u32Idx]);
   }
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << CountryName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetIDFromStringMethodStart::operator==(const sds_speechdpfi_tclMsgGetIDFromStringMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringAndTypes.size() == roRef.StringAndTypes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringAndTypes.size()); ++u32Idx)
            bResult = bResult && (StringAndTypes[u32Idx] == roRef.StringAndTypes[u32Idx]);
      }
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (CountryName == roRef.CountryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetIDFromStringMethodResult::sds_speechdpfi_tclMsgGetIDFromStringMethodResult(const sds_speechdpfi_tclMsgGetIDFromStringMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   IDs = coRef.IDs;
}
sds_speechdpfi_tclMsgGetIDFromStringMethodResult& sds_speechdpfi_tclMsgGetIDFromStringMethodResult::operator=(const sds_speechdpfi_tclMsgGetIDFromStringMethodResult& coRef)
{
   if (this == &coRef) return *this;
   IDs = coRef.IDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetIDFromStringMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < IDs.size(); ++u32Idx)
         IDs[u32Idx].vDestroy();
   IDs.clear();
   }
}

sds_speechdpfi_tclMsgGetIDFromStringMethodResult::sds_speechdpfi_tclMsgGetIDFromStringMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetIDFromStringMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGMETHODRESULT;
}


sds_speechdpfi_tclMsgGetIDFromStringMethodResult::~sds_speechdpfi_tclMsgGetIDFromStringMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetIDFromStringMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < IDs.size(); ++u32ListIdx)
      u32DynamicSize += IDs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetIDFromStringMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IDs.size(); ++u32Idx)
      {
         IDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetIDFromStringMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)IDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IDs.size(); ++u32Idx)
         (tVoid) (oOut << IDs[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetIDFromStringMethodResult::operator==(const sds_speechdpfi_tclMsgGetIDFromStringMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (IDs.size() == roRef.IDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IDs.size()); ++u32Idx)
            bResult = bResult && (IDs[u32Idx] == roRef.IDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::sds_speechdpfi_tclMsgGetDestinationSupportMethodStart(const sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   State = coRef.State;
}
sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::operator=(const sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   Country.vDestroy(); 
   State.vDestroy(); 
}

sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::sds_speechdpfi_tclMsgGetDestinationSupportMethodStart()
:LanguageID()
,Country()
,State()
 {}

tS32 sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSUPPORTMETHODSTART;
}


sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::~sds_speechdpfi_tclMsgGetDestinationSupportMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Country.u32GetSize(u16MajorVersion)+State.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDestinationSupportMethodStart::operator==(const sds_speechdpfi_tclMsgGetDestinationSupportMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::sds_speechdpfi_tclMsgGetDestinationSupportMethodResult(const sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CountrySupported = coRef.CountrySupported;
   CountryHasProvinces = coRef.CountryHasProvinces;
   StateSupported = coRef.StateSupported;
   RegionSupported = coRef.RegionSupported;
   POICategorySupported = coRef.POICategorySupported;
   POINameSupported = coRef.POINameSupported;
   POIBrandNameSupported = coRef.POIBrandNameSupported;
}
sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::operator=(const sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CountrySupported = coRef.CountrySupported;
   CountryHasProvinces = coRef.CountryHasProvinces;
   StateSupported = coRef.StateSupported;
   RegionSupported = coRef.RegionSupported;
   POICategorySupported = coRef.POICategorySupported;
   POINameSupported = coRef.POINameSupported;
   POIBrandNameSupported = coRef.POIBrandNameSupported;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::sds_speechdpfi_tclMsgGetDestinationSupportMethodResult()
:CountrySupported()
,CountryHasProvinces(0)
,StateSupported()
,RegionSupported()
,POICategorySupported(0)
,POINameSupported(0)
,POIBrandNameSupported(0)
 {}

tS32 sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDESTINATIONSUPPORTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::~sds_speechdpfi_tclMsgGetDestinationSupportMethodResult()
{}

tU32 sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountrySupported);
   (tVoid) (oIn >> CountryHasProvinces);
   (tVoid) (oIn >> StateSupported);
   (tVoid) (oIn >> RegionSupported);
   (tVoid) (oIn >> POICategorySupported);
   (tVoid) (oIn >> POINameSupported);
   (tVoid) (oIn >> POIBrandNameSupported);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountrySupported);
   (tVoid) (oOut << CountryHasProvinces);
   (tVoid) (oOut << StateSupported);
   (tVoid) (oOut << RegionSupported);
   (tVoid) (oOut << POICategorySupported);
   (tVoid) (oOut << POINameSupported);
   (tVoid) (oOut << POIBrandNameSupported);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDestinationSupportMethodResult::operator==(const sds_speechdpfi_tclMsgGetDestinationSupportMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountrySupported == roRef.CountrySupported);
   bResult = bResult && (CountryHasProvinces == roRef.CountryHasProvinces);
   bResult = bResult && (StateSupported == roRef.StateSupported);
   bResult = bResult && (RegionSupported == roRef.RegionSupported);
   bResult = bResult && (POICategorySupported == roRef.POICategorySupported);
   bResult = bResult && (POINameSupported == roRef.POINameSupported);
   bResult = bResult && (POIBrandNameSupported == roRef.POIBrandNameSupported);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
}
sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::operator=(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart()
:LanguageID()
,DomainID()
,ProfileID(0)
 {}

tS32 sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEUSERWORDSMETHODSTART;
}


sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::~sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> ProfileID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << ProfileID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart::operator==(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (ProfileID == roRef.ProfileID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Userwords = coRef.Userwords;
}
sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::operator=(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Userwords = coRef.Userwords;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::vDestroy()
{
   {
   Userwords.clear();
   }
}

sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLEUSERWORDSMETHODRESULT;
}


sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::~sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Userwords.size()*4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Userwords.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Userwords[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Userwords.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Userwords.size(); ++u32Idx)
         (tVoid) (oOut << Userwords[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult::operator==(const sds_speechdpfi_tclMsgGetAvailableUserwordsMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Userwords.size() == roRef.Userwords.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Userwords.size()); ++u32Idx)
            bResult = bResult && (Userwords[u32Idx] == roRef.Userwords[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserwordContextMethodStart::sds_speechdpfi_tclMsgGetUserwordContextMethodStart(const sds_speechdpfi_tclMsgGetUserwordContextMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
}
sds_speechdpfi_tclMsgGetUserwordContextMethodStart& sds_speechdpfi_tclMsgGetUserwordContextMethodStart::operator=(const sds_speechdpfi_tclMsgGetUserwordContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetUserwordContextMethodStart::sds_speechdpfi_tclMsgGetUserwordContextMethodStart()
:LanguageID()
,DomainID()
,ProfileID(0)
 {}

tS32 sds_speechdpfi_tclMsgGetUserwordContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDCONTEXTMETHODSTART;
}


sds_speechdpfi_tclMsgGetUserwordContextMethodStart::~sds_speechdpfi_tclMsgGetUserwordContextMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetUserwordContextMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserwordContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> ProfileID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserwordContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << ProfileID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserwordContextMethodStart::operator==(const sds_speechdpfi_tclMsgGetUserwordContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (ProfileID == roRef.ProfileID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserwordContextMethodResult::sds_speechdpfi_tclMsgGetUserwordContextMethodResult(const sds_speechdpfi_tclMsgGetUserwordContextMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ContextFile = coRef.ContextFile;
}
sds_speechdpfi_tclMsgGetUserwordContextMethodResult& sds_speechdpfi_tclMsgGetUserwordContextMethodResult::operator=(const sds_speechdpfi_tclMsgGetUserwordContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ContextFile = coRef.ContextFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetUserwordContextMethodResult::vDestroy()
{
   ContextFile.vDestroy();
}

sds_speechdpfi_tclMsgGetUserwordContextMethodResult::sds_speechdpfi_tclMsgGetUserwordContextMethodResult()
:ContextFile()
 {}

tS32 sds_speechdpfi_tclMsgGetUserwordContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDCONTEXTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetUserwordContextMethodResult::~sds_speechdpfi_tclMsgGetUserwordContextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetUserwordContextMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ContextFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserwordContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContextFile);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserwordContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContextFile);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserwordContextMethodResult::operator==(const sds_speechdpfi_tclMsgGetUserwordContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContextFile == roRef.ContextFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::sds_speechdpfi_tclMsgGetUserwordAudioMethodStart(const sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   UserwordID = coRef.UserwordID;
}
sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::operator=(const sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   UserwordID = coRef.UserwordID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
   UserwordID.clear();
   }
}

sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::sds_speechdpfi_tclMsgGetUserwordAudioMethodStart()
:LanguageID()
,DomainID()
,ProfileID(0)

 {}

tS32 sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOMETHODSTART;
}


sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::~sds_speechdpfi_tclMsgGetUserwordAudioMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+UserwordID.size()*4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> ProfileID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      UserwordID.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> UserwordID[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << ProfileID);
   (tVoid) (oOut << (tU32)UserwordID.size());
   {
      for (tU32 u32Idx = 0; u32Idx < UserwordID.size(); ++u32Idx)
         (tVoid) (oOut << UserwordID[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserwordAudioMethodStart::operator==(const sds_speechdpfi_tclMsgGetUserwordAudioMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (ProfileID == roRef.ProfileID);
      bResult = bResult && (UserwordID.size() == roRef.UserwordID.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UserwordID.size()); ++u32Idx)
            bResult = bResult && (UserwordID[u32Idx] == roRef.UserwordID[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::sds_speechdpfi_tclMsgGetUserwordAudioMethodResult(const sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   AudioFiles = coRef.AudioFiles;
}
sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::operator=(const sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AudioFiles = coRef.AudioFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AudioFiles.size(); ++u32Idx)
         AudioFiles[u32Idx].vDestroy();
   AudioFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::sds_speechdpfi_tclMsgGetUserwordAudioMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETUSERWORDAUDIOMETHODRESULT;
}


sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::~sds_speechdpfi_tclMsgGetUserwordAudioMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AudioFiles.size(); ++u32ListIdx)
      u32DynamicSize += AudioFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AudioFiles.size(); ++u32Idx)
      {
         AudioFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AudioFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AudioFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AudioFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AudioFiles.size(); ++u32Idx)
         (tVoid) (oOut << AudioFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetUserwordAudioMethodResult::operator==(const sds_speechdpfi_tclMsgGetUserwordAudioMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AudioFiles.size() == roRef.AudioFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AudioFiles.size()); ++u32Idx)
            bResult = bResult && (AudioFiles[u32Idx] == roRef.AudioFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
}
sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::operator=(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart()
:LanguageID()
 {}

tS32 sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CREATEUSERWORDFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::~sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart()
{}

tU32 sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart::operator==(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FolderName = coRef.FolderName;
   FreeSpace = coRef.FreeSpace;
   Cookie = coRef.Cookie;
}
sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::operator=(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FolderName = coRef.FolderName;
   FreeSpace = coRef.FreeSpace;
   Cookie = coRef.Cookie;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::vDestroy()
{
   FolderName.vDestroy();
}

sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult()
:FolderName()
,FreeSpace(0)
,Cookie(0)
 {}

tS32 sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CREATEUSERWORDFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::~sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+FolderName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FolderName);
   (tVoid) (oIn >> FreeSpace);
   (tVoid) (oIn >> Cookie);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FolderName);
   (tVoid) (oOut << FreeSpace);
   (tVoid) (oOut << Cookie);
   return oOut;
}

tBool sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult::operator==(const sds_speechdpfi_tclMsgCreateUserwordFolderMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FolderName == roRef.FolderName);
   bResult = bResult && (FreeSpace == roRef.FreeSpace);
   bResult = bResult && (Cookie == roRef.Cookie);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart(const sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
   MetafileName = coRef.MetafileName;
}
sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::operator=(const sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   MetafileName = coRef.MetafileName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::vDestroy()
{
   MetafileName.vDestroy();
}

sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart()
:Cookie(0)
,MetafileName()
 {}

tS32 sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COMMITUSERWORDFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::~sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+MetafileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   (tVoid) (oIn >> MetafileName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   (tVoid) (oOut << MetafileName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart::operator==(const sds_speechdpfi_tclMsgCommitUserwordFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   bResult = bResult && (MetafileName == roRef.MetafileName);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult::sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COMMITUSERWORDFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult::~sds_speechdpfi_tclMsgCommitUserwordFolderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart(const sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Cookie = coRef.Cookie;
}
sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::operator=(const sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Cookie = coRef.Cookie;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart()
:Cookie(0)
 {}

tS32 sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_ROLLBACKUSERWORDFOLDERMETHODSTART;
}


sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::~sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart()
{}

tU32 sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Cookie);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Cookie);
   return oOut;
}

tBool sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart::operator==(const sds_speechdpfi_tclMsgRollbackUserwordFolderMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Cookie == roRef.Cookie);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult::sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_ROLLBACKUSERWORDFOLDERMETHODRESULT;
}


sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult::~sds_speechdpfi_tclMsgRollbackUserwordFolderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteUserwordMethodStart::sds_speechdpfi_tclMsgDeleteUserwordMethodStart(const sds_speechdpfi_tclMsgDeleteUserwordMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
}
sds_speechdpfi_tclMsgDeleteUserwordMethodStart& sds_speechdpfi_tclMsgDeleteUserwordMethodStart::operator=(const sds_speechdpfi_tclMsgDeleteUserwordMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDeleteUserwordMethodStart::sds_speechdpfi_tclMsgDeleteUserwordMethodStart()
:LanguageID()
,DomainID()
,ProfileID(0)
 {}

tS32 sds_speechdpfi_tclMsgDeleteUserwordMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDMETHODSTART;
}


sds_speechdpfi_tclMsgDeleteUserwordMethodStart::~sds_speechdpfi_tclMsgDeleteUserwordMethodStart()
{}

tU32 sds_speechdpfi_tclMsgDeleteUserwordMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteUserwordMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> ProfileID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteUserwordMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << ProfileID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteUserwordMethodStart::operator==(const sds_speechdpfi_tclMsgDeleteUserwordMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (ProfileID == roRef.ProfileID);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgDeleteUserwordMethodResult::sds_speechdpfi_tclMsgDeleteUserwordMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgDeleteUserwordMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEUSERWORDMETHODRESULT;
}


sds_speechdpfi_tclMsgDeleteUserwordMethodResult::~sds_speechdpfi_tclMsgDeleteUserwordMethodResult()
{}

//=============================================================================

sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart::sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSSPEAKERSMETHODSTART;
}


sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart::~sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult(const sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   AvailableSDSSpeakers = coRef.AvailableSDSSpeakers;
}
sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::operator=(const sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AvailableSDSSpeakers = coRef.AvailableSDSSpeakers;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableSDSSpeakers.size(); ++u32Idx)
         AvailableSDSSpeakers[u32Idx].vDestroy();
   AvailableSDSSpeakers.clear();
   }
}

sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETAVAILABLESDSSPEAKERSMETHODRESULT;
}


sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::~sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailableSDSSpeakers.size(); ++u32ListIdx)
      u32DynamicSize += AvailableSDSSpeakers[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableSDSSpeakers.size(); ++u32Idx)
      {
         AvailableSDSSpeakers[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableSDSSpeakers.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableSDSSpeakers[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableSDSSpeakers.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableSDSSpeakers.size(); ++u32Idx)
         (tVoid) (oOut << AvailableSDSSpeakers[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult::operator==(const sds_speechdpfi_tclMsgGetAvailableSDSSpeakersMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableSDSSpeakers.size() == roRef.AvailableSDSSpeakers.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableSDSSpeakers.size()); ++u32Idx)
            bResult = bResult && (AvailableSDSSpeakers[u32Idx] == roRef.AvailableSDSSpeakers[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   SlotName = coRef.SlotName;
}
sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::operator=(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   SlotName = coRef.SlotName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   SlotName.vDestroy();
}

sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart()
:LanguageID()
,SlotName()
 {}

tS32 sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCLCDICTIONARYFORSLOTMETHODSTART;
}


sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::~sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+SlotName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> SlotName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << SlotName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart::operator==(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (SlotName == roRef.SlotName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CLCDictionaryFiles = coRef.CLCDictionaryFiles;
}
sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::operator=(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CLCDictionaryFiles = coRef.CLCDictionaryFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CLCDictionaryFiles.size(); ++u32Idx)
         CLCDictionaryFiles[u32Idx].vDestroy();
   CLCDictionaryFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCLCDICTIONARYFORSLOTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::~sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CLCDictionaryFiles.size(); ++u32ListIdx)
      u32DynamicSize += CLCDictionaryFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CLCDictionaryFiles.size(); ++u32Idx)
      {
         CLCDictionaryFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CLCDictionaryFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CLCDictionaryFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CLCDictionaryFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CLCDictionaryFiles.size(); ++u32Idx)
         (tVoid) (oOut << CLCDictionaryFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult::operator==(const sds_speechdpfi_tclMsgGetCLCDictionaryForSlotMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CLCDictionaryFiles.size() == roRef.CLCDictionaryFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CLCDictionaryFiles.size()); ++u32Idx)
            bResult = bResult && (CLCDictionaryFiles[u32Idx] == roRef.CLCDictionaryFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StateShort = coRef.StateShort;
}
sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::operator=(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StateShort = coRef.StateShort;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StateShort.size(); ++u32Idx)
         StateShort[u32Idx].vDestroy();
   StateShort.clear();
   }
}

sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart()

 {}

tS32 sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSTATENAMEFROMSTATESHORTMETHODSTART;
}


sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::~sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StateShort.size(); ++u32ListIdx)
      u32DynamicSize += StateShort[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StateShort.size(); ++u32Idx)
      {
         StateShort[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StateShort.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StateShort[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StateShort.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StateShort.size(); ++u32Idx)
         (tVoid) (oOut << StateShort[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart::operator==(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StateShort.size() == roRef.StateShort.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateShort.size()); ++u32Idx)
            bResult = bResult && (StateShort[u32Idx] == roRef.StateShort[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StateName = coRef.StateName;
}
sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::operator=(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StateName = coRef.StateName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StateName.size(); ++u32Idx)
         StateName[u32Idx].vDestroy();
   StateName.clear();
   }
}

sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETSTATENAMEFROMSTATESHORTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::~sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StateName.size(); ++u32ListIdx)
      u32DynamicSize += StateName[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StateName.size(); ++u32Idx)
      {
         StateName[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StateName.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StateName[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StateName.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StateName.size(); ++u32Idx)
         (tVoid) (oOut << StateName[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult::operator==(const sds_speechdpfi_tclMsgGetStatenameFromStateshortMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StateName.size() == roRef.StateName.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateName.size()); ++u32Idx)
            bResult = bResult && (StateName[u32Idx] == roRef.StateName[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CountryCode = coRef.CountryCode;
   LanguageID = coRef.LanguageID;
}
sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart()
:CountryCode()
,LanguageID()
 {}

tS32 sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGMETHODSTART;
}


sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::~sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart::operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   MappingCountryName = coRef.MappingCountryName;
}
sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MappingCountryName = coRef.MappingCountryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::vDestroy()
{
   MappingCountryName.vDestroy();
}

sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult()
:MappingCountryName()
 {}

tS32 sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGMETHODRESULT;
}


sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::~sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MappingCountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MappingCountryName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MappingCountryName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult::operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MappingCountryName == roRef.MappingCountryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FindCity = coRef.FindCity;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   BelongingState = coRef.BelongingState;
}
sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::operator=(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FindCity = coRef.FindCity;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   BelongingState = coRef.BelongingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::vDestroy()
{
   FindCity.vDestroy(); 
   LanguageID.vDestroy(); 
   CountryName.vDestroy();
   BelongingState.vDestroy(); 
}

sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart()
:FindCity()
,LanguageID()
,CountryCode()
,CountryName()
,BelongingState()
 {}

tS32 sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGWITHCONSTRAINMETHODSTART;
}


sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::~sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+FindCity.u32GetSize(u16MajorVersion)+CountryName.u32GetSize(u16MajorVersion)+BelongingState.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FindCity);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> CountryName);
   (tVoid) (oIn >> BelongingState);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FindCity);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << BelongingState);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart::operator==(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FindCity == roRef.FindCity);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (CountryName == roRef.CountryName);
   bResult = bResult && (BelongingState == roRef.BelongingState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   IDs = coRef.IDs;
}
sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::operator=(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& coRef)
{
   if (this == &coRef) return *this;
   IDs = coRef.IDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::vDestroy()
{
   {
   IDs.clear();
   }
}

sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETIDFROMSTRINGWITHCONSTRAINMETHODRESULT;
}


sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::~sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+IDs.size()*4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      IDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)IDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IDs.size(); ++u32Idx)
         (tVoid) (oOut << IDs[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult::operator==(const sds_speechdpfi_tclMsgGetIDFromStringWithConstrainMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (IDs.size() == roRef.IDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IDs.size()); ++u32Idx)
            bResult = bResult && (IDs[u32Idx] == roRef.IDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::sds_speechdpfi_tclMsgGetDynamicContextListMethodStart(const sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainDeviceIDs = coRef.DomainDeviceIDs;
}
sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::operator=(const sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainDeviceIDs = coRef.DomainDeviceIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < DomainDeviceIDs.size(); ++u32Idx)
         DomainDeviceIDs[u32Idx].vDestroy();
   DomainDeviceIDs.clear();
   }
}

sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::sds_speechdpfi_tclMsgGetDynamicContextListMethodStart()
:LanguageID()

 {}

tS32 sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTLISTMETHODSTART;
}


sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::~sds_speechdpfi_tclMsgGetDynamicContextListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+DomainDeviceIDs.size()*5;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DomainDeviceIDs.size(); ++u32Idx)
      {
         DomainDeviceIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DomainDeviceIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DomainDeviceIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << (tU32)DomainDeviceIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DomainDeviceIDs.size(); ++u32Idx)
         (tVoid) (oOut << DomainDeviceIDs[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDynamicContextListMethodStart::operator==(const sds_speechdpfi_tclMsgGetDynamicContextListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
      bResult = bResult && (DomainDeviceIDs.size() == roRef.DomainDeviceIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DomainDeviceIDs.size()); ++u32Idx)
            bResult = bResult && (DomainDeviceIDs[u32Idx] == roRef.DomainDeviceIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::sds_speechdpfi_tclMsgGetDynamicContextListMethodResult(const sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DeviceMetaFiles = coRef.DeviceMetaFiles;
}
sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::operator=(const sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceMetaFiles = coRef.DeviceMetaFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceMetaFiles.size(); ++u32Idx)
         DeviceMetaFiles[u32Idx].vDestroy();
   DeviceMetaFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::sds_speechdpfi_tclMsgGetDynamicContextListMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDYNAMICCONTEXTLISTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::~sds_speechdpfi_tclMsgGetDynamicContextListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceMetaFiles.size(); ++u32ListIdx)
      u32DynamicSize += DeviceMetaFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceMetaFiles.size(); ++u32Idx)
      {
         DeviceMetaFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceMetaFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceMetaFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DeviceMetaFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceMetaFiles.size(); ++u32Idx)
         (tVoid) (oOut << DeviceMetaFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDynamicContextListMethodResult::operator==(const sds_speechdpfi_tclMsgGetDynamicContextListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DeviceMetaFiles.size() == roRef.DeviceMetaFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceMetaFiles.size()); ++u32Idx)
            bResult = bResult && (DeviceMetaFiles[u32Idx] == roRef.DeviceMetaFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   CityIDs = coRef.CityIDs;
}
sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::operator=(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   CityIDs = coRef.CityIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < CityIDs.size(); ++u32Idx)
         CityIDs[u32Idx].vDestroy();
   CityIDs.clear();
   }
}

sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart()
:LanguageID()

 {}

tS32 sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCITYSTREETSAVAILABILITYMETHODSTART;
}


sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::~sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CityIDs.size(); ++u32ListIdx)
      u32DynamicSize += CityIDs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CityIDs.size(); ++u32Idx)
      {
         CityIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CityIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CityIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << (tU32)CityIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CityIDs.size(); ++u32Idx)
         (tVoid) (oOut << CityIDs[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart::operator==(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
      bResult = bResult && (CityIDs.size() == roRef.CityIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CityIDs.size()); ++u32Idx)
            bResult = bResult && (CityIDs[u32Idx] == roRef.CityIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   StreetsAvailability = coRef.StreetsAvailability;
}
sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::operator=(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StreetsAvailability = coRef.StreetsAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StreetsAvailability.size(); ++u32Idx)
         StreetsAvailability[u32Idx].vDestroy();
   StreetsAvailability.clear();
   }
}

sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCITYSTREETSAVAILABILITYMETHODRESULT;
}


sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::~sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+StreetsAvailability.size()*5;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StreetsAvailability.size(); ++u32Idx)
      {
         StreetsAvailability[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StreetsAvailability.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StreetsAvailability[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StreetsAvailability.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StreetsAvailability.size(); ++u32Idx)
         (tVoid) (oOut << StreetsAvailability[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult::operator==(const sds_speechdpfi_tclMsgGetCityStreetsAvailabilityMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StreetsAvailability.size() == roRef.StreetsAvailability.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StreetsAvailability.size()); ++u32Idx)
            bResult = bResult && (StreetsAvailability[u32Idx] == roRef.StreetsAvailability[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CountryCode = coRef.CountryCode;
   LanguageID = coRef.LanguageID;
   OnlyLanguageCodeMatch = coRef.OnlyLanguageCodeMatch;
}
sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CountryCode = coRef.CountryCode;
   LanguageID = coRef.LanguageID;
   OnlyLanguageCodeMatch = coRef.OnlyLanguageCodeMatch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart()
:CountryCode()
,LanguageID()
,OnlyLanguageCodeMatch(0)
 {}

tS32 sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGOPTIONMETHODSTART;
}


sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::~sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> OnlyLanguageCodeMatch);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << OnlyLanguageCodeMatch);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart::operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (OnlyLanguageCodeMatch == roRef.OnlyLanguageCodeMatch);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   MappingCountryName = coRef.MappingCountryName;
}
sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::operator=(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   MappingCountryName = coRef.MappingCountryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::vDestroy()
{
   MappingCountryName.vDestroy();
}

sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult()
:MappingCountryName()
 {}

tS32 sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETCOUNTRYNAMEMAPPINGOPTIONMETHODRESULT;
}


sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::~sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MappingCountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MappingCountryName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MappingCountryName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult::operator==(const sds_speechdpfi_tclMsgGetCountryNameMappingOptionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MappingCountryName == roRef.MappingCountryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DestinationList = coRef.DestinationList;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
}
sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DestinationList = coRef.DestinationList;
   LanguageID = coRef.LanguageID;
   CountryCode = coRef.CountryCode;
   CountryName = coRef.CountryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationList.size(); ++u32Idx)
         DestinationList[u32Idx].vDestroy();
   DestinationList.clear();
   }
   LanguageID.vDestroy(); 
   CountryName.vDestroy();
}

sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart()

:LanguageID()
,CountryCode()
,CountryName()
 {}

tS32 sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGLISTMETHODSTART;
}


sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::~sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DestinationList.size(); ++u32ListIdx)
      u32DynamicSize += DestinationList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10+CountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DestinationList.size(); ++u32Idx)
      {
         DestinationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DestinationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DestinationList[u32Idx]);
      }
   }
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> CountryCode);
   (tVoid) (oIn >> CountryName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DestinationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationList.size(); ++u32Idx)
         (tVoid) (oOut << DestinationList[u32Idx]);
   }
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << CountryCode);
   (tVoid) (oOut << CountryName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart::operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DestinationList.size() == roRef.DestinationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DestinationList.size()); ++u32Idx)
            bResult = bResult && (DestinationList[u32Idx] == roRef.DestinationList[u32Idx]);
      }
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (CountryCode == roRef.CountryCode);
   bResult = bResult && (CountryName == roRef.CountryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   PhonemeList = coRef.PhonemeList;
}
sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::operator=(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   PhonemeList = coRef.PhonemeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
}

sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETPHONEMEFROMSTRINGLISTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::~sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult::operator==(const sds_speechdpfi_tclMsgGetPhonemeFromStringListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Country = coRef.Country;
}
sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::operator=(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::vDestroy()
{
   Country.vDestroy(); 
}

sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart()
:Country()
 {}

tS32 sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVDESUPPORTEDLANGUAGESFORCOUNTRYMETHODSTART;
}


sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::~sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Country.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart::operator==(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   SupportedLanguageList = coRef.SupportedLanguageList;
}
sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::operator=(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SupportedLanguageList = coRef.SupportedLanguageList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedLanguageList.size(); ++u32Idx)
         SupportedLanguageList[u32Idx].vDestroy();
   SupportedLanguageList.clear();
   }
}

sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVDESUPPORTEDLANGUAGESFORCOUNTRYMETHODRESULT;
}


sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::~sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+SupportedLanguageList.size()*4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SupportedLanguageList.size(); ++u32Idx)
      {
         SupportedLanguageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SupportedLanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SupportedLanguageList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SupportedLanguageList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SupportedLanguageList.size(); ++u32Idx)
         (tVoid) (oOut << SupportedLanguageList[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult::operator==(const sds_speechdpfi_tclMsgGetVDESupportedLanguagesForCountryMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SupportedLanguageList.size() == roRef.SupportedLanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SupportedLanguageList.size()); ++u32Idx)
            bResult = bResult && (SupportedLanguageList[u32Idx] == roRef.SupportedLanguageList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart::sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDEFAULTSDSLANGUAGEANDSPEAKERMETHODSTART;
}


sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart::~sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult(const sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DefaultLanguageID = coRef.DefaultLanguageID;
   DefaultSDSSpeaker = coRef.DefaultSDSSpeaker;
}
sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::operator=(const sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefaultLanguageID = coRef.DefaultLanguageID;
   DefaultSDSSpeaker = coRef.DefaultSDSSpeaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::vDestroy()
{
   DefaultLanguageID.vDestroy(); 
   DefaultSDSSpeaker.vDestroy();
}

sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult()
:DefaultLanguageID()
,DefaultSDSSpeaker()
 {}

tS32 sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETDEFAULTSDSLANGUAGEANDSPEAKERMETHODRESULT;
}


sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::~sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+DefaultSDSSpeaker.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefaultLanguageID);
   (tVoid) (oIn >> DefaultSDSSpeaker);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefaultLanguageID);
   (tVoid) (oOut << DefaultSDSSpeaker);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult::operator==(const sds_speechdpfi_tclMsgGetDefaultSDSLanguageAndSpeakerMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefaultLanguageID == roRef.DefaultLanguageID);
   bResult = bResult && (DefaultSDSSpeaker == roRef.DefaultSDSSpeaker);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::sds_speechdpfi_tclMsgGetVcDataFilesMethodStart(const sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   SectionList = coRef.SectionList;
}
sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::operator=(const sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SectionList = coRef.SectionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SectionList.size(); ++u32Idx)
         SectionList[u32Idx].vDestroy();
   SectionList.clear();
   }
}

sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::sds_speechdpfi_tclMsgGetVcDataFilesMethodStart()

 {}

tS32 sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVCDATAFILESMETHODSTART;
}


sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::~sds_speechdpfi_tclMsgGetVcDataFilesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SectionList.size(); ++u32ListIdx)
      u32DynamicSize += SectionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SectionList.size(); ++u32Idx)
      {
         SectionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SectionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SectionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SectionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SectionList.size(); ++u32Idx)
         (tVoid) (oOut << SectionList[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVcDataFilesMethodStart::operator==(const sds_speechdpfi_tclMsgGetVcDataFilesMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SectionList.size() == roRef.SectionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SectionList.size()); ++u32Idx)
            bResult = bResult && (SectionList[u32Idx] == roRef.SectionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::sds_speechdpfi_tclMsgGetVcDataFilesMethodResult(const sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DataFiles = coRef.DataFiles;
}
sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::operator=(const sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DataFiles = coRef.DataFiles;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DataFiles.size(); ++u32Idx)
         DataFiles[u32Idx].vDestroy();
   DataFiles.clear();
   }
}

sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::sds_speechdpfi_tclMsgGetVcDataFilesMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVCDATAFILESMETHODRESULT;
}


sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::~sds_speechdpfi_tclMsgGetVcDataFilesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DataFiles.size(); ++u32ListIdx)
      u32DynamicSize += DataFiles[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DataFiles.size(); ++u32Idx)
      {
         DataFiles[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DataFiles.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DataFiles[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DataFiles.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DataFiles.size(); ++u32Idx)
         (tVoid) (oOut << DataFiles[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVcDataFilesMethodResult::operator==(const sds_speechdpfi_tclMsgGetVcDataFilesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DataFiles.size() == roRef.DataFiles.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataFiles.size()); ++u32Idx)
            bResult = bResult && (DataFiles[u32Idx] == roRef.DataFiles[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetWUWordContextMethodStart::sds_speechdpfi_tclMsgGetWUWordContextMethodStart(const sds_speechdpfi_tclMsgGetWUWordContextMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DeviceID = coRef.DeviceID;
   WUWDomainID = coRef.WUWDomainID;
}
sds_speechdpfi_tclMsgGetWUWordContextMethodStart& sds_speechdpfi_tclMsgGetWUWordContextMethodStart::operator=(const sds_speechdpfi_tclMsgGetWUWordContextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DeviceID = coRef.DeviceID;
   WUWDomainID = coRef.WUWDomainID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetWUWordContextMethodStart::sds_speechdpfi_tclMsgGetWUWordContextMethodStart()
:LanguageID()
,DeviceID(0)
,WUWDomainID()
 {}

tS32 sds_speechdpfi_tclMsgGetWUWordContextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETWUWORDCONTEXTMETHODSTART;
}


sds_speechdpfi_tclMsgGetWUWordContextMethodStart::~sds_speechdpfi_tclMsgGetWUWordContextMethodStart()
{}

tU32 sds_speechdpfi_tclMsgGetWUWordContextMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetWUWordContextMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> DeviceID);
   (tVoid) (oIn >> WUWDomainID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetWUWordContextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << DeviceID);
   (tVoid) (oOut << WUWDomainID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetWUWordContextMethodStart::operator==(const sds_speechdpfi_tclMsgGetWUWordContextMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (DeviceID == roRef.DeviceID);
   bResult = bResult && (WUWDomainID == roRef.WUWDomainID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetWUWordContextMethodResult::sds_speechdpfi_tclMsgGetWUWordContextMethodResult(const sds_speechdpfi_tclMsgGetWUWordContextMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DynamicWUWMetaFile = coRef.DynamicWUWMetaFile;
   StaticWUWContext = coRef.StaticWUWContext;
}
sds_speechdpfi_tclMsgGetWUWordContextMethodResult& sds_speechdpfi_tclMsgGetWUWordContextMethodResult::operator=(const sds_speechdpfi_tclMsgGetWUWordContextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DynamicWUWMetaFile = coRef.DynamicWUWMetaFile;
   StaticWUWContext = coRef.StaticWUWContext;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetWUWordContextMethodResult::vDestroy()
{
   DynamicWUWMetaFile.vDestroy();
   StaticWUWContext.vDestroy();
}

sds_speechdpfi_tclMsgGetWUWordContextMethodResult::sds_speechdpfi_tclMsgGetWUWordContextMethodResult()
:DynamicWUWMetaFile()
,StaticWUWContext()
 {}

tS32 sds_speechdpfi_tclMsgGetWUWordContextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETWUWORDCONTEXTMETHODRESULT;
}


sds_speechdpfi_tclMsgGetWUWordContextMethodResult::~sds_speechdpfi_tclMsgGetWUWordContextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetWUWordContextMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+DynamicWUWMetaFile.u32GetSize(u16MajorVersion)+StaticWUWContext.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetWUWordContextMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DynamicWUWMetaFile);
   (tVoid) (oIn >> StaticWUWContext);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetWUWordContextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DynamicWUWMetaFile);
   (tVoid) (oOut << StaticWUWContext);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetWUWordContextMethodResult::operator==(const sds_speechdpfi_tclMsgGetWUWordContextMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DynamicWUWMetaFile == roRef.DynamicWUWMetaFile);
   bResult = bResult && (StaticWUWContext == roRef.StaticWUWContext);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart(const sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   FunctionID = coRef.FunctionID;
}
sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::operator=(const sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FunctionID = coRef.FunctionID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart()
:FunctionID(0)
 {}

tS32 sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SENDMESSAGETOSDS2HMIMETHODSTART;
}


sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::~sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart()
{}

tU32 sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FunctionID);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FunctionID);
   return oOut;
}

tBool sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart::operator==(const sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FunctionID == roRef.FunctionID);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult::sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SENDMESSAGETOSDS2HMIMETHODRESULT;
}


sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult::~sds_speechdpfi_tclMsgSendMessageToSDS2HMIMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart(const sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   u8CmdValue = coRef.u8CmdValue;
   szStringParam = coRef.szStringParam;
}
sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::operator=(const sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8CmdValue = coRef.u8CmdValue;
   szStringParam = coRef.szStringParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::vDestroy()
{
   {
   u8CmdValue.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < szStringParam.size(); ++u32Idx)
         szStringParam[u32Idx].vDestroy();
   szStringParam.clear();
   }
}

sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart()


 {}

tS32 sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODSTART;
}


sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::~sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < szStringParam.size(); ++u32ListIdx)
      u32DynamicSize += szStringParam[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+u8CmdValue.size()*1;
}

fi_tclInContext& sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u8CmdValue.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u8CmdValue[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < szStringParam.size(); ++u32Idx)
      {
         szStringParam[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      szStringParam.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> szStringParam[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)u8CmdValue.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u8CmdValue.size(); ++u32Idx)
         (tVoid) (oOut << u8CmdValue[u32Idx]);
   }
   (tVoid) (oOut << (tU32)szStringParam.size());
   {
      for (tU32 u32Idx = 0; u32Idx < szStringParam.size(); ++u32Idx)
         (tVoid) (oOut << szStringParam[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart::operator==(const sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (u8CmdValue.size() == roRef.u8CmdValue.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u8CmdValue.size()); ++u32Idx)
            bResult = bResult && (u8CmdValue[u32Idx] == roRef.u8CmdValue[u32Idx]);
      }
      bResult = bResult && (szStringParam.size() == roRef.szStringParam.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < szStringParam.size()); ++u32Idx)
            bResult = bResult && (szStringParam[u32Idx] == roRef.szStringParam[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult::sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODRESULT;
}


sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult::~sds_speechdpfi_tclMsgExecuteReceivedTTFIsCommandMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart(const sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   DomainDeviceIDs = coRef.DomainDeviceIDs;
   StorageLocation = coRef.StorageLocation;
}
sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::operator=(const sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   DomainDeviceIDs = coRef.DomainDeviceIDs;
   StorageLocation = coRef.StorageLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < DomainDeviceIDs.size(); ++u32Idx)
         DomainDeviceIDs[u32Idx].vDestroy();
   DomainDeviceIDs.clear();
   }
}

sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart()
:LanguageID()

,StorageLocation()
 {}

tS32 sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEDYNAMICCONTEXTLISTMETHODSTART;
}


sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::~sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+DomainDeviceIDs.size()*5;
}

fi_tclInContext& sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DomainDeviceIDs.size(); ++u32Idx)
      {
         DomainDeviceIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DomainDeviceIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DomainDeviceIDs[u32Idx]);
      }
   }
   (tVoid) (oIn >> StorageLocation);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << (tU32)DomainDeviceIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DomainDeviceIDs.size(); ++u32Idx)
         (tVoid) (oOut << DomainDeviceIDs[u32Idx]);
   }
   (tVoid) (oOut << StorageLocation);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart::operator==(const sds_speechdpfi_tclMsgDeleteDynamicContextListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
      bResult = bResult && (DomainDeviceIDs.size() == roRef.DomainDeviceIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DomainDeviceIDs.size()); ++u32Idx)
            bResult = bResult && (DomainDeviceIDs[u32Idx] == roRef.DomainDeviceIDs[u32Idx]);
      }
   bResult = bResult && (StorageLocation == roRef.StorageLocation);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult::sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult()
 {}

tS32 sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DELETEDYNAMICCONTEXTLISTMETHODRESULT;
}


sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult::~sds_speechdpfi_tclMsgDeleteDynamicContextListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   StateName = coRef.StateName;
}
sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::operator=(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   StateName = coRef.StateName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   Country.vDestroy(); 
   StateName.vDestroy(); 
}

sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart()
:LanguageID()
,Country()
,StateName()
 {}

tS32 sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETNAVIADDRESSTYPEMETHODSTART;
}


sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::~sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Country.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> StateName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << StateName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart::operator==(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (StateName == roRef.StateName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   TypeList = coRef.TypeList;
}
sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::operator=(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TypeList = coRef.TypeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::vDestroy()
{
   {
   TypeList.clear();
   }
}

sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult()

 {}

tS32 sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETNAVIADDRESSTYPEMETHODRESULT;
}


sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::~sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+TypeList.size()*1;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TypeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TypeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TypeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TypeList.size(); ++u32Idx)
         (tVoid) (oOut << TypeList[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult::operator==(const sds_speechdpfi_tclMsgGetNaviAddressTypeMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TypeList.size() == roRef.TypeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TypeList.size()); ++u32Idx)
            bResult = bResult && (TypeList[u32Idx] == roRef.TypeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   StateName = coRef.StateName;
}
sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::operator=(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageID = coRef.LanguageID;
   Country = coRef.Country;
   StateName = coRef.StateName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::vDestroy()
{
   LanguageID.vDestroy(); 
   Country.vDestroy(); 
   StateName.vDestroy(); 
}

sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart()
:LanguageID()
,Country()
,StateName()
 {}

tS32 sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETNAVIURIDSFORCOUNTRYSTATEMETHODSTART;
}


sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::~sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Country.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> StateName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Country);
   (tVoid) (oOut << StateName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart::operator==(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (StateName == roRef.StateName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CountryURIds = coRef.CountryURIds;
   StateURIds = coRef.StateURIds;
}
sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::operator=(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CountryURIds = coRef.CountryURIds;
   StateURIds = coRef.StateURIds;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::vDestroy()
{
   CountryURIds.vDestroy(); 
   StateURIds.vDestroy(); 
}

sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult()
:CountryURIds()
,StateURIds()
 {}

tS32 sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETNAVIURIDSFORCOUNTRYSTATEMETHODRESULT;
}


sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::~sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CountryURIds.u32GetSize(u16MajorVersion)+StateURIds.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryURIds);
   (tVoid) (oIn >> StateURIds);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryURIds);
   (tVoid) (oOut << StateURIds);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult::operator==(const sds_speechdpfi_tclMsgGetNaviURIDsForCountryStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryURIds == roRef.CountryURIds);
   bResult = bResult && (StateURIds == roRef.StateURIds);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart::sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart()
 {}

tS32 sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVOCONCONFIGURATIONMETHODSTART;
}


sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart::~sds_speechdpfi_tclMsgGetVoconConfigurationMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult(const sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ConfigFile = coRef.ConfigFile;
}
sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::operator=(const sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ConfigFile = coRef.ConfigFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::vDestroy()
{
   ConfigFile.vDestroy();
}

sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult()
:ConfigFile()
 {}

tS32 sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETVOCONCONFIGURATIONMETHODRESULT;
}


sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::~sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ConfigFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConfigFile);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConfigFile);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult::operator==(const sds_speechdpfi_tclMsgGetVoconConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConfigFile == roRef.ConfigFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Country = coRef.Country;
   CountryName = coRef.CountryName;
}
sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::operator=(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   CountryName = coRef.CountryName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::vDestroy()
{
   Country.vDestroy(); 
   CountryName.vDestroy();
}

sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart()
:Country()
,CountryName()
 {}

tS32 sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETNUMERICCOUNTRYCODEMETHODSTART;
}


sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::~sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 24+CountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> CountryName);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   (tVoid) (oOut << CountryName);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart::operator==(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (CountryName == roRef.CountryName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   ISOCountrycode = coRef.ISOCountrycode;
}
sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::operator=(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ISOCountrycode = coRef.ISOCountrycode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult()
:ISOCountrycode()
 {}

tS32 sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_GETNUMERICCOUNTRYCODEMETHODRESULT;
}


sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::~sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult()
{}

tU32 sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISOCountrycode);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISOCountrycode);
   return oOut;
}

tBool sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult::operator==(const sds_speechdpfi_tclMsgGetNumericCountryCodeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISOCountrycode == roRef.ISOCountrycode);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgDataCarrierInsertedGet::sds_speechdpfi_tclMsgDataCarrierInsertedGet()
 {}

tS32 sds_speechdpfi_tclMsgDataCarrierInsertedGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDGET;
}


sds_speechdpfi_tclMsgDataCarrierInsertedGet::~sds_speechdpfi_tclMsgDataCarrierInsertedGet()
{}

//=============================================================================

sds_speechdpfi_tclMsgDataCarrierInsertedUpReg::sds_speechdpfi_tclMsgDataCarrierInsertedUpReg()
 {}

tS32 sds_speechdpfi_tclMsgDataCarrierInsertedUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDUPREG;
}


sds_speechdpfi_tclMsgDataCarrierInsertedUpReg::~sds_speechdpfi_tclMsgDataCarrierInsertedUpReg()
{}

//=============================================================================

sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg::sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDRELUPREG;
}


sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg::~sds_speechdpfi_tclMsgDataCarrierInsertedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDataCarrierInsertedStatus::sds_speechdpfi_tclMsgDataCarrierInsertedStatus(const sds_speechdpfi_tclMsgDataCarrierInsertedStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   DataCarrierInserted = coRef.DataCarrierInserted;
}
sds_speechdpfi_tclMsgDataCarrierInsertedStatus& sds_speechdpfi_tclMsgDataCarrierInsertedStatus::operator=(const sds_speechdpfi_tclMsgDataCarrierInsertedStatus& coRef)
{
   if (this == &coRef) return *this;
   DataCarrierInserted = coRef.DataCarrierInserted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDataCarrierInsertedStatus::sds_speechdpfi_tclMsgDataCarrierInsertedStatus()
:DataCarrierInserted(0)
 {}

tS32 sds_speechdpfi_tclMsgDataCarrierInsertedStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DATACARRIERINSERTEDSTATUS;
}


sds_speechdpfi_tclMsgDataCarrierInsertedStatus::~sds_speechdpfi_tclMsgDataCarrierInsertedStatus()
{}

tU32 sds_speechdpfi_tclMsgDataCarrierInsertedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgDataCarrierInsertedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataCarrierInserted);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDataCarrierInsertedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataCarrierInserted);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDataCarrierInsertedStatus::operator==(const sds_speechdpfi_tclMsgDataCarrierInsertedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataCarrierInserted == roRef.DataCarrierInserted);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgConsistencyCheckReadyGet::sds_speechdpfi_tclMsgConsistencyCheckReadyGet()
 {}

tS32 sds_speechdpfi_tclMsgConsistencyCheckReadyGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYGET;
}


sds_speechdpfi_tclMsgConsistencyCheckReadyGet::~sds_speechdpfi_tclMsgConsistencyCheckReadyGet()
{}

//=============================================================================

sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg::sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg()
 {}

tS32 sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYUPREG;
}


sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg::~sds_speechdpfi_tclMsgConsistencyCheckReadyUpReg()
{}

//=============================================================================

sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg::sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYRELUPREG;
}


sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg::~sds_speechdpfi_tclMsgConsistencyCheckReadyRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::sds_speechdpfi_tclMsgConsistencyCheckReadyStatus(const sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Complete = coRef.Complete;
}
sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::operator=(const sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& coRef)
{
   if (this == &coRef) return *this;
   Complete = coRef.Complete;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::sds_speechdpfi_tclMsgConsistencyCheckReadyStatus()
:Complete(0)
 {}

tS32 sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_CONSISTENCYCHECKREADYSTATUS;
}


sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::~sds_speechdpfi_tclMsgConsistencyCheckReadyStatus()
{}

tU32 sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Complete);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Complete);
   return oOut;
}

tBool sds_speechdpfi_tclMsgConsistencyCheckReadyStatus::operator==(const sds_speechdpfi_tclMsgConsistencyCheckReadyStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Complete == roRef.Complete);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgSDPSWVersionGet::sds_speechdpfi_tclMsgSDPSWVersionGet()
 {}

tS32 sds_speechdpfi_tclMsgSDPSWVersionGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONGET;
}


sds_speechdpfi_tclMsgSDPSWVersionGet::~sds_speechdpfi_tclMsgSDPSWVersionGet()
{}

//=============================================================================

sds_speechdpfi_tclMsgSDPSWVersionUpReg::sds_speechdpfi_tclMsgSDPSWVersionUpReg()
 {}

tS32 sds_speechdpfi_tclMsgSDPSWVersionUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONUPREG;
}


sds_speechdpfi_tclMsgSDPSWVersionUpReg::~sds_speechdpfi_tclMsgSDPSWVersionUpReg()
{}

//=============================================================================

sds_speechdpfi_tclMsgSDPSWVersionRelUpReg::sds_speechdpfi_tclMsgSDPSWVersionRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgSDPSWVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONRELUPREG;
}


sds_speechdpfi_tclMsgSDPSWVersionRelUpReg::~sds_speechdpfi_tclMsgSDPSWVersionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgSDPSWVersionStatus::sds_speechdpfi_tclMsgSDPSWVersionStatus(const sds_speechdpfi_tclMsgSDPSWVersionStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   SWVersion = coRef.SWVersion;
}
sds_speechdpfi_tclMsgSDPSWVersionStatus& sds_speechdpfi_tclMsgSDPSWVersionStatus::operator=(const sds_speechdpfi_tclMsgSDPSWVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   SWVersion = coRef.SWVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgSDPSWVersionStatus::vDestroy()
{
   SWVersion.vDestroy();
}

sds_speechdpfi_tclMsgSDPSWVersionStatus::sds_speechdpfi_tclMsgSDPSWVersionStatus()
:SWVersion()
 {}

tS32 sds_speechdpfi_tclMsgSDPSWVersionStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDPSWVERSIONSTATUS;
}


sds_speechdpfi_tclMsgSDPSWVersionStatus::~sds_speechdpfi_tclMsgSDPSWVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgSDPSWVersionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+SWVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_speechdpfi_tclMsgSDPSWVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SWVersion);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgSDPSWVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SWVersion);
   return oOut;
}

tBool sds_speechdpfi_tclMsgSDPSWVersionStatus::operator==(const sds_speechdpfi_tclMsgSDPSWVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SWVersion == roRef.SWVersion);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgDownloadCompleteGet::sds_speechdpfi_tclMsgDownloadCompleteGet()
 {}

tS32 sds_speechdpfi_tclMsgDownloadCompleteGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETEGET;
}


sds_speechdpfi_tclMsgDownloadCompleteGet::~sds_speechdpfi_tclMsgDownloadCompleteGet()
{}

//=============================================================================

sds_speechdpfi_tclMsgDownloadCompleteUpReg::sds_speechdpfi_tclMsgDownloadCompleteUpReg()
 {}

tS32 sds_speechdpfi_tclMsgDownloadCompleteUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETEUPREG;
}


sds_speechdpfi_tclMsgDownloadCompleteUpReg::~sds_speechdpfi_tclMsgDownloadCompleteUpReg()
{}

//=============================================================================

sds_speechdpfi_tclMsgDownloadCompleteRelUpReg::sds_speechdpfi_tclMsgDownloadCompleteRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgDownloadCompleteRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETERELUPREG;
}


sds_speechdpfi_tclMsgDownloadCompleteRelUpReg::~sds_speechdpfi_tclMsgDownloadCompleteRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgDownloadCompleteStatus::sds_speechdpfi_tclMsgDownloadCompleteStatus(const sds_speechdpfi_tclMsgDownloadCompleteStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Complete = coRef.Complete;
}
sds_speechdpfi_tclMsgDownloadCompleteStatus& sds_speechdpfi_tclMsgDownloadCompleteStatus::operator=(const sds_speechdpfi_tclMsgDownloadCompleteStatus& coRef)
{
   if (this == &coRef) return *this;
   Complete = coRef.Complete;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgDownloadCompleteStatus::sds_speechdpfi_tclMsgDownloadCompleteStatus()
:Complete(0)
 {}

tS32 sds_speechdpfi_tclMsgDownloadCompleteStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_DOWNLOADCOMPLETESTATUS;
}


sds_speechdpfi_tclMsgDownloadCompleteStatus::~sds_speechdpfi_tclMsgDownloadCompleteStatus()
{}

tU32 sds_speechdpfi_tclMsgDownloadCompleteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgDownloadCompleteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Complete);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgDownloadCompleteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Complete);
   return oOut;
}

tBool sds_speechdpfi_tclMsgDownloadCompleteStatus::operator==(const sds_speechdpfi_tclMsgDownloadCompleteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Complete == roRef.Complete);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgLanguageDownloadCompleteGet::sds_speechdpfi_tclMsgLanguageDownloadCompleteGet()
 {}

tS32 sds_speechdpfi_tclMsgLanguageDownloadCompleteGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETEGET;
}


sds_speechdpfi_tclMsgLanguageDownloadCompleteGet::~sds_speechdpfi_tclMsgLanguageDownloadCompleteGet()
{}

//=============================================================================

sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg::sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg()
 {}

tS32 sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETEUPREG;
}


sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg::~sds_speechdpfi_tclMsgLanguageDownloadCompleteUpReg()
{}

//=============================================================================

sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg::sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETERELUPREG;
}


sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg::~sds_speechdpfi_tclMsgLanguageDownloadCompleteRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus(const sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Complete = coRef.Complete;
}
sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::operator=(const sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& coRef)
{
   if (this == &coRef) return *this;
   Complete = coRef.Complete;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus()
:Complete(0)
 {}

tS32 sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_LANGUAGEDOWNLOADCOMPLETESTATUS;
}


sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::~sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus()
{}

tU32 sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Complete);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Complete);
   return oOut;
}

tBool sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus::operator==(const sds_speechdpfi_tclMsgLanguageDownloadCompleteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Complete == roRef.Complete);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgCountryDownloadCompleteGet::sds_speechdpfi_tclMsgCountryDownloadCompleteGet()
 {}

tS32 sds_speechdpfi_tclMsgCountryDownloadCompleteGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETEGET;
}


sds_speechdpfi_tclMsgCountryDownloadCompleteGet::~sds_speechdpfi_tclMsgCountryDownloadCompleteGet()
{}

//=============================================================================

sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg::sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg()
 {}

tS32 sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETEUPREG;
}


sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg::~sds_speechdpfi_tclMsgCountryDownloadCompleteUpReg()
{}

//=============================================================================

sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg::sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETERELUPREG;
}


sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg::~sds_speechdpfi_tclMsgCountryDownloadCompleteRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::sds_speechdpfi_tclMsgCountryDownloadCompleteStatus(const sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   Complete = coRef.Complete;
}
sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::operator=(const sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& coRef)
{
   if (this == &coRef) return *this;
   Complete = coRef.Complete;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::sds_speechdpfi_tclMsgCountryDownloadCompleteStatus()
:Complete(0)
 {}

tS32 sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_COUNTRYDOWNLOADCOMPLETESTATUS;
}


sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::~sds_speechdpfi_tclMsgCountryDownloadCompleteStatus()
{}

tU32 sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Complete);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Complete);
   return oOut;
}

tBool sds_speechdpfi_tclMsgCountryDownloadCompleteStatus::operator==(const sds_speechdpfi_tclMsgCountryDownloadCompleteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Complete == roRef.Complete);
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgSDNLocationFoundGet::sds_speechdpfi_tclMsgSDNLocationFoundGet()
 {}

tS32 sds_speechdpfi_tclMsgSDNLocationFoundGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDGET;
}


sds_speechdpfi_tclMsgSDNLocationFoundGet::~sds_speechdpfi_tclMsgSDNLocationFoundGet()
{}

//=============================================================================

sds_speechdpfi_tclMsgSDNLocationFoundUpReg::sds_speechdpfi_tclMsgSDNLocationFoundUpReg()
 {}

tS32 sds_speechdpfi_tclMsgSDNLocationFoundUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDUPREG;
}


sds_speechdpfi_tclMsgSDNLocationFoundUpReg::~sds_speechdpfi_tclMsgSDNLocationFoundUpReg()
{}

//=============================================================================

sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg::sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDRELUPREG;
}


sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg::~sds_speechdpfi_tclMsgSDNLocationFoundRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgSDNLocationFoundStatus::sds_speechdpfi_tclMsgSDNLocationFoundStatus(const sds_speechdpfi_tclMsgSDNLocationFoundStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   SDNLocation = coRef.SDNLocation;
}
sds_speechdpfi_tclMsgSDNLocationFoundStatus& sds_speechdpfi_tclMsgSDNLocationFoundStatus::operator=(const sds_speechdpfi_tclMsgSDNLocationFoundStatus& coRef)
{
   if (this == &coRef) return *this;
   SDNLocation = coRef.SDNLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_speechdpfi_tclMsgSDNLocationFoundStatus::sds_speechdpfi_tclMsgSDNLocationFoundStatus()
:SDNLocation()
 {}

tS32 sds_speechdpfi_tclMsgSDNLocationFoundStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_SDNLOCATIONFOUNDSTATUS;
}


sds_speechdpfi_tclMsgSDNLocationFoundStatus::~sds_speechdpfi_tclMsgSDNLocationFoundStatus()
{}

tU32 sds_speechdpfi_tclMsgSDNLocationFoundStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_speechdpfi_tclMsgSDNLocationFoundStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SDNLocation);
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgSDNLocationFoundStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SDNLocation);
   return oOut;
}

tBool sds_speechdpfi_tclMsgSDNLocationFoundStatus::operator==(const sds_speechdpfi_tclMsgSDNLocationFoundStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SDNLocation == roRef.SDNLocation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgUpdateCountryStateListGet::sds_speechdpfi_tclMsgUpdateCountryStateListGet(const sds_speechdpfi_tclMsgUpdateCountryStateListGet& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CountryStateList = coRef.CountryStateList;
}
sds_speechdpfi_tclMsgUpdateCountryStateListGet& sds_speechdpfi_tclMsgUpdateCountryStateListGet::operator=(const sds_speechdpfi_tclMsgUpdateCountryStateListGet& coRef)
{
   if (this == &coRef) return *this;
   CountryStateList = coRef.CountryStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgUpdateCountryStateListGet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         CountryStateList[u32Idx].vDestroy();
   CountryStateList.clear();
   }
}

sds_speechdpfi_tclMsgUpdateCountryStateListGet::sds_speechdpfi_tclMsgUpdateCountryStateListGet()

 {}

tS32 sds_speechdpfi_tclMsgUpdateCountryStateListGet::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTGET;
}


sds_speechdpfi_tclMsgUpdateCountryStateListGet::~sds_speechdpfi_tclMsgUpdateCountryStateListGet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgUpdateCountryStateListGet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CountryStateList.size(); ++u32ListIdx)
      u32DynamicSize += CountryStateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgUpdateCountryStateListGet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
      {
         CountryStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CountryStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CountryStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgUpdateCountryStateListGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CountryStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         (tVoid) (oOut << CountryStateList[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgUpdateCountryStateListGet::operator==(const sds_speechdpfi_tclMsgUpdateCountryStateListGet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CountryStateList.size() == roRef.CountryStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryStateList.size()); ++u32Idx)
            bResult = bResult && (CountryStateList[u32Idx] == roRef.CountryStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg::sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg()
 {}

tS32 sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTRELUPREG;
}


sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg::~sds_speechdpfi_tclMsgUpdateCountryStateListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_speechdpfi_tclMsgUpdateCountryStateListStatus::sds_speechdpfi_tclMsgUpdateCountryStateListStatus(const sds_speechdpfi_tclMsgUpdateCountryStateListStatus& coRef)
   : sds_speechdpfi_tclMsgBaseMessage(coRef)
{
   CountryStateList = coRef.CountryStateList;
}
sds_speechdpfi_tclMsgUpdateCountryStateListStatus& sds_speechdpfi_tclMsgUpdateCountryStateListStatus::operator=(const sds_speechdpfi_tclMsgUpdateCountryStateListStatus& coRef)
{
   if (this == &coRef) return *this;
   CountryStateList = coRef.CountryStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_speechdpfi_tclMsgUpdateCountryStateListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         CountryStateList[u32Idx].vDestroy();
   CountryStateList.clear();
   }
}

sds_speechdpfi_tclMsgUpdateCountryStateListStatus::sds_speechdpfi_tclMsgUpdateCountryStateListStatus()

 {}

tS32 sds_speechdpfi_tclMsgUpdateCountryStateListStatus::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTSTATUS;
}


sds_speechdpfi_tclMsgUpdateCountryStateListStatus::~sds_speechdpfi_tclMsgUpdateCountryStateListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_speechdpfi_tclMsgUpdateCountryStateListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CountryStateList.size(); ++u32ListIdx)
      u32DynamicSize += CountryStateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_speechdpfi_tclMsgUpdateCountryStateListStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
      {
         CountryStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CountryStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CountryStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_speechdpfi_tclMsgUpdateCountryStateListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CountryStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         (tVoid) (oOut << CountryStateList[u32Idx]);
   }
   return oOut;
}

tBool sds_speechdpfi_tclMsgUpdateCountryStateListStatus::operator==(const sds_speechdpfi_tclMsgUpdateCountryStateListStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CountryStateList.size() == roRef.CountryStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryStateList.size()); ++u32Idx)
            bResult = bResult && (CountryStateList[u32Idx] == roRef.CountryStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_speechdpfi_tclMsgUpdateCountryStateListUpReg::sds_speechdpfi_tclMsgUpdateCountryStateListUpReg()
 {}

tS32 sds_speechdpfi_tclMsgUpdateCountryStateListUpReg::s32GetTypeId() const
{
   return (tS32) sds_speechdpfi_tclToken::EN_MSG_UPDATECOUNTRYSTATELISTUPREG;
}


sds_speechdpfi_tclMsgUpdateCountryStateListUpReg::~sds_speechdpfi_tclMsgUpdateCountryStateListUpReg()
{}

