#ifndef __SDS_SPEECHDPFIDEBUGVISITOR_H__
#define __SDS_SPEECHDPFIDEBUGVISITOR_H__

class MY_DECL sds_speechdpfi_tclPrintVisitor : public sds_speechdpfi_tclVisitorBase {

private:
   /* default constructor */ sds_speechdpfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_speechdpfi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tBool bDoExpand_BinContainer(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Domain(sds_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_NDSFeatureType(sds_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tVoid vVisit_e8_SDSDestinationType(sds_fi_tcl_e8_SDSDestinationType& o_e8_SDSDestinationType);
   virtual tBool bDoExpand_SDSLanguageID(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NDSID(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_StatePhoneme(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CountryPhoneme(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_SelectionCriterionType(sds_fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_SDSLocationType(sds_fi_tcl_e8_SDSLocationType& o_e8_SDSLocationType);
   virtual tBool bDoExpand_CurrentCountry(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurrentState(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurrentCity(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NameID(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDSDestinationEntry(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PathType(sds_fi_tcl_e8_PathType& o_e8_PathType);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tVoid vVisit_e8_DataCarrier(sds_fi_tcl_e8_DataCarrier& o_e8_DataCarrier);
   virtual tVoid vVisit_e8_UserWordUsage(sds_fi_tcl_e8_UserWordUsage& o_e8_UserWordUsage);
   virtual tVoid vVisit_e8_CountryType(sds_fi_tcl_e8_CountryType& o_e8_CountryType);
   virtual tVoid vVisit_e8_StorageDevice(sds_fi_tcl_e8_StorageDevice& o_e8_StorageDevice);
   virtual tVoid vVisit_e8_FileAvailability(sds_fi_tcl_e8_FileAvailability& o_e8_FileAvailability);
   virtual tVoid vVisit_e8_FileType(sds_fi_tcl_e8_FileType& o_e8_FileType);
   virtual tVoid vVisit_e8_FileAccessMode(sds_fi_tcl_e8_FileAccessMode& o_e8_FileAccessMode);
   virtual tVoid vVisit_e8_FileAccessResult(sds_fi_tcl_e8_FileAccessResult& o_e8_FileAccessResult);
   virtual tVoid vVisit_e8_ContextType(sds_fi_tcl_e8_ContextType& o_e8_ContextType);
   virtual tVoid vVisit_e8_ReleaseTypeSDP(sds_fi_tcl_e8_ReleaseTypeSDP& o_e8_ReleaseTypeSDP);
   virtual tVoid vVisit_e8_UwCategories(sds_fi_tcl_e8_UwCategories& o_e8_UwCategories);
   virtual tVoid vVisit_e8_TTSFileType(sds_fi_tcl_e8_TTSFileType& o_e8_TTSFileType);
   virtual tVoid vVisit_e8_ContextFileType(sds_fi_tcl_e8_ContextFileType& o_e8_ContextFileType);
   virtual tVoid vVisit_e8_SemBufferFileType(sds_fi_tcl_e8_SemBufferFileType& o_e8_SemBufferFileType);
   virtual tVoid vVisit_e8_TranscriptionFileType(sds_fi_tcl_e8_TranscriptionFileType& o_e8_TranscriptionFileType);
   virtual tVoid vVisit_e8_CountrySupportType(sds_fi_tcl_e8_CountrySupportType& o_e8_CountrySupportType);
   virtual tVoid vVisit_e8_TTSEngineType(sds_fi_tcl_e8_TTSEngineType& o_e8_TTSEngineType);
   virtual tBool bDoExpand_AvailableLanguage(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VoiceType(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VoiceDescription(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DictionaryGroup(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_AvailableCountry(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TTSTunningFile(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TTSVoiceFile(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ContextFile(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SemBufferFile(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ConnectDevice(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_TranscriptionFile(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_UserAudioFile(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SpeechSupportInfoType(sds_fi_tcl_e8_SpeechSupportInfoType& o_e8_SpeechSupportInfoType);
   virtual tBool bDoExpand_SpeakerInfoType(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DynamicCtxStatus(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_DynamicDataContextMetaFile(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CityWithStreets(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_WordWithPhoneme(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_VcData(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_BlobData(sds_speechdpfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SDNLocation(sds_fi_tcl_e8_SDNLocation& o_e8_SDNLocation);
   virtual tVoid vVisit_e8_AddressType(sds_fi_tcl_e8_AddressType& o_e8_AddressType);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_speechdpfi_tclRandomInitVisitor : public sds_speechdpfi_tclVisitorBase {
public:

   sds_speechdpfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Domain(sds_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_NDSFeatureType(sds_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tVoid vVisit_e8_SDSDestinationType(sds_fi_tcl_e8_SDSDestinationType& o_e8_SDSDestinationType);
   virtual tVoid vVisit_e16_SelectionCriterionType(sds_fi_tcl_e16_SelectionCriterionType& o_e16_SelectionCriterionType);
   virtual tVoid vVisit_e8_SDSLocationType(sds_fi_tcl_e8_SDSLocationType& o_e8_SDSLocationType);
   virtual tVoid vVisit_e8_PathType(sds_fi_tcl_e8_PathType& o_e8_PathType);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tVoid vVisit_e8_DataCarrier(sds_fi_tcl_e8_DataCarrier& o_e8_DataCarrier);
   virtual tVoid vVisit_e8_UserWordUsage(sds_fi_tcl_e8_UserWordUsage& o_e8_UserWordUsage);
   virtual tVoid vVisit_e8_CountryType(sds_fi_tcl_e8_CountryType& o_e8_CountryType);
   virtual tVoid vVisit_e8_StorageDevice(sds_fi_tcl_e8_StorageDevice& o_e8_StorageDevice);
   virtual tVoid vVisit_e8_FileAvailability(sds_fi_tcl_e8_FileAvailability& o_e8_FileAvailability);
   virtual tVoid vVisit_e8_FileType(sds_fi_tcl_e8_FileType& o_e8_FileType);
   virtual tVoid vVisit_e8_FileAccessMode(sds_fi_tcl_e8_FileAccessMode& o_e8_FileAccessMode);
   virtual tVoid vVisit_e8_FileAccessResult(sds_fi_tcl_e8_FileAccessResult& o_e8_FileAccessResult);
   virtual tVoid vVisit_e8_ContextType(sds_fi_tcl_e8_ContextType& o_e8_ContextType);
   virtual tVoid vVisit_e8_ReleaseTypeSDP(sds_fi_tcl_e8_ReleaseTypeSDP& o_e8_ReleaseTypeSDP);
   virtual tVoid vVisit_e8_UwCategories(sds_fi_tcl_e8_UwCategories& o_e8_UwCategories);
   virtual tVoid vVisit_e8_TTSFileType(sds_fi_tcl_e8_TTSFileType& o_e8_TTSFileType);
   virtual tVoid vVisit_e8_ContextFileType(sds_fi_tcl_e8_ContextFileType& o_e8_ContextFileType);
   virtual tVoid vVisit_e8_SemBufferFileType(sds_fi_tcl_e8_SemBufferFileType& o_e8_SemBufferFileType);
   virtual tVoid vVisit_e8_TranscriptionFileType(sds_fi_tcl_e8_TranscriptionFileType& o_e8_TranscriptionFileType);
   virtual tVoid vVisit_e8_CountrySupportType(sds_fi_tcl_e8_CountrySupportType& o_e8_CountrySupportType);
   virtual tVoid vVisit_e8_TTSEngineType(sds_fi_tcl_e8_TTSEngineType& o_e8_TTSEngineType);
   virtual tVoid vVisit_e8_SpeechSupportInfoType(sds_fi_tcl_e8_SpeechSupportInfoType& o_e8_SpeechSupportInfoType);
   virtual tVoid vVisit_e8_SDNLocation(sds_fi_tcl_e8_SDNLocation& o_e8_SDNLocation);
   virtual tVoid vVisit_e8_AddressType(sds_fi_tcl_e8_AddressType& o_e8_AddressType);
	tU32 u32ListSize;
};

#endif
