#include "precompiled.hh"

tBool sds_rec_voconservicefi_tclDescription::bInitMessage(sds_rec_voconservicefi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case sds_rec_voconservicefi_tclToken::EN_LAST_TOKEN:
   case sds_rec_voconservicefi_tclToken::EN_LIST:
   case sds_rec_voconservicefi_tclToken::EN_END_OF_STRUCT:
   case sds_rec_voconservicefi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
   break;
      // include the expansions for the messages
   case sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENT,sds_rec_voconservicefi_tclSemanticDomain::EN_MSG_E8VOCONCOMPONENT)) && bResult;
   } break;
   case sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODRESULT:
   {
      bResult = oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_U64_TPVOID,sds_rec_voconservicefi_tclSemanticDomain::EN_MSG_POCOMPONENT)) && bResult;
   } break;
   case sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODSTART:
   {
      bResult = oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENT,sds_rec_voconservicefi_tclSemanticDomain::EN_MSG_E8VOCONCOMPONENT)) && bResult;
   } break;
   case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS,sds_rec_voconservicefi_tclSemanticDomain::EN_MSG_VOCONPRONSTATUS)) && bResult;
      bResult = oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS,sds_rec_voconservicefi_tclSemanticDomain::EN_MSG_VOCONSEMSTATUS)) && bResult;
      bResult = oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS,sds_rec_voconservicefi_tclSemanticDomain::EN_MSG_VOCONASRSTATUS)) && bResult;
   } break;
   case sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODRESULT:
   case sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART:
   case sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT:
   case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSGET:
   case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSUPREG:
   case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSRELUPREG:
   case sds_rec_voconservicefi_tclToken::EN_BINCONTAINER:
   case sds_rec_voconservicefi_tclToken::EN_U64_TPVOID:
   case sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENT:
   case sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS:
   case sds_rec_voconservicefi_tclToken::EN_U8:   
   case sds_rec_voconservicefi_tclToken::EN_S8:   
   case sds_rec_voconservicefi_tclToken::EN_U16:   
   case sds_rec_voconservicefi_tclToken::EN_S16:   
   case sds_rec_voconservicefi_tclToken::EN_U24:   
   case sds_rec_voconservicefi_tclToken::EN_S24:   
   case sds_rec_voconservicefi_tclToken::EN_U32:   
   case sds_rec_voconservicefi_tclToken::EN_S32:   
   case sds_rec_voconservicefi_tclToken::EN_U64:   
   case sds_rec_voconservicefi_tclToken::EN_S64:   
   case sds_rec_voconservicefi_tclToken::EN_F32:   
   case sds_rec_voconservicefi_tclToken::EN_F64:   
   case sds_rec_voconservicefi_tclToken::EN_BOOL:   
   case sds_rec_voconservicefi_tclToken::EN_STRING:   
   case sds_rec_voconservicefi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(enMsgToken,sds_rec_voconservicefi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool sds_rec_voconservicefi_tclDescription::bDoIt(sds_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool sds_rec_voconservicefi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      sds_rec_voconservicefi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      sds_rec_voconservicefi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      sds_rec_voconservicefi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == sds_rec_voconservicefi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(sds_rec_voconservicefi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case sds_rec_voconservicefi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == sds_rec_voconservicefi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_LIST: 
      {
         sds_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_rec_voconservicefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            sds_rec_voconservicefi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case sds_rec_voconservicefi_tclToken::EN_U8: 
      {
         sds_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case sds_rec_voconservicefi_tclToken::EN_U16: 
      {
         sds_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_U24: 
      {
         sds_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_U32: 
      {
         sds_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_U64: 
      {
         sds_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_S8: 
      {
         sds_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_S16: 
      {
         sds_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_S24: 
      {
         sds_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_S32: 
      {
         sds_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_S64: 
      {
         sds_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_F32: 
      {
         sds_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_F64: 
      {
         sds_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_BOOL: 
      {
         sds_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_STRING: 
      {
         sds_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         sds_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODSTART:
      case sds_rec_voconservicefi_tclToken::EN_MSG_GETVOCONBASECOMPONENTMETHODRESULT:
      case sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODSTART:
      case sds_rec_voconservicefi_tclToken::EN_MSG_CLOSEVOCONOBJECTSMETHODRESULT:
      case sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODSTART:
      case sds_rec_voconservicefi_tclToken::EN_MSG_REINITIALIZEVOCONCOMPONENTMETHODRESULT:
      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSGET:
      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSUPREG:
      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSRELUPREG:
      case sds_rec_voconservicefi_tclToken::EN_MSG_VOCONCOMPONENTSSTATUSSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case sds_rec_voconservicefi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_END_OF_STRUCT,sds_rec_voconservicefi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_U8,sds_rec_voconservicefi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(sds_rec_voconservicefi_tclKnot(sds_rec_voconservicefi_tclToken::EN_LIST,sds_rec_voconservicefi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         sds_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case sds_rec_voconservicefi_tclToken::EN_U64_TPVOID:
      {
         sds_fi_tcl_u64_tPVoid o_u64_tPVoid;
         if (!bDoIt(o_u64_tPVoid))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENT:
      {
         sds_fi_tcl_e8_VoconComponent o_e8_VoconComponent;
         if (!bDoIt(o_e8_VoconComponent))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_E8_VOCONCOMPONENTSTATUS:
      {
         sds_fi_tcl_e8_VoconComponentStatus o_e8_VoconComponentStatus;
         if (!bDoIt(o_e8_VoconComponentStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case sds_rec_voconservicefi_tclToken::EN_UNKNOWN:
      case sds_rec_voconservicefi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

