/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS_REC_RECOGSERVICEFITYPES_HEADER
#define SDS_REC_RECOGSERVICEFITYPES_HEADER


class sds_rec_recogservicefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for SDS_REC_RECOGSERVICE_FI message types

fi_tclMessageBase* sds_rec_recogservicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds_rec_recogservicefi_tclMsgBaseMessage : public sds_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds_rec_recogservicefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds_rec_recogservicefi_tclMsgSetLanguageMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& operator=(const sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgSetLanguageMethodStart(const sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_rec_recogservicefi_tclMsgSetLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetLanguageMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetLanguageMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgSetLanguageMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgSetLanguageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetUserMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetUserMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgSetUserMethodStart& operator=(const sds_rec_recogservicefi_tclMsgSetUserMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgSetUserMethodStart(const sds_rec_recogservicefi_tclMsgSetUserMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_Domain DomainID;
   tU32 ProfileID;
   virtual ~sds_rec_recogservicefi_tclMsgSetUserMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgSetUserMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetUserMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetUserMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgSetUserMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgSetUserMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& operator=(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDoSemClassification;
   tBool bFromVectors;
   virtual ~sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst();

   virtual ~sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& operator=(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& coRef);
   sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_RecogResultType ResultType;
   std::vector<sds_fi_tcl_RecogNBestResult, std::allocator<sds_fi_tcl_RecogNBestResult> > RecogNBestResults;
   std::vector<sds_fi_tcl_RecogSemResult, std::allocator<sds_fi_tcl_RecogSemResult> > RecogSEMResults;
   std::vector<sds_fi_tcl_RecogNaviNBestResult, std::allocator<sds_fi_tcl_RecogNaviNBestResult> > RecogNaviResults;
   std::vector<sds_fi_tcl_e8RecogAbnormalEvents, std::allocator<sds_fi_tcl_e8RecogAbnormalEvents> > arrAbnormalEvents;
   tS32 AudioSNR;
   tU32 BeginofListeningTime;
   tU32 BeginofSpeechTime;
   tU32 EndofSpeechTime;
   tU32 Latency;
   sds_fi_tclString szJSONResult;
   virtual ~sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& operator=(const sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart(const sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szConfiguration;
   sds_fi_tclString szCloudConfiguration;
   std::vector<sds_fi_tcl_SDSDestinationEntry, std::allocator<sds_fi_tcl_SDSDestinationEntry> > LocationList;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > arrDynamicRules;
   sds_fi_tcl_e8_VDLCategoryName VDLCategory;
   tU32 u32PageNumber;
   std::vector<sds_fi_tcl_SDSIDTranscriptionsEntry, std::allocator<sds_fi_tcl_SDSIDTranscriptionsEntry> > IDTranscriptionsEntry;
   virtual ~sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& operator=(const sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart(const sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szConfiguration;
   sds_fi_tclString szCloudConfiguration;
   std::vector<sds_fi_tcl_SDSDestinationEntry, std::allocator<sds_fi_tcl_SDSDestinationEntry> > LocationList;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > arrDynamicRules;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > arrDynRegions;
   virtual ~sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& operator=(const sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart(const sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_Domain DomainID;
   tU32 ProfileID;
   tU32 UserWrdID;
   virtual ~sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast();

   virtual ~sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& operator=(const sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart(const sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_CurrentCountry Country;
   sds_fi_tcl_CurrentState StateName;
   virtual ~sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgReleaseDataMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgReleaseDataMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgReleaseDataMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgReleaseDataMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgReleaseDataMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgReleaseDataMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgReleaseDataMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgReleaseDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& operator=(const sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart(const sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szContextName;
   sds_fi_tclString szContextFilePath;
   std::vector<sds_fi_tcl_FrontEndParameter, std::allocator<sds_fi_tcl_FrontEndParameter> > FxParameters;
   std::vector<sds_fi_tcl_RecParameter, std::allocator<sds_fi_tcl_RecParameter> > RecParameters;
   std::vector<sds_fi_tcl_ContextParameter, std::allocator<sds_fi_tcl_ContextParameter> > CtxParameters;
   virtual ~sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& operator=(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UserWrdID;
   sds_fi_tcl_e8_Domain DomainID;
   tU32 ProfileID;
   sds_fi_tcl_e8_USWTrainingType UserWordTrainType;
   virtual ~sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst();

   virtual ~sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& operator=(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& coRef);
   sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_RecogResultType ResultType;
   virtual ~sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& operator=(const sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart(const sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bCommit;
   virtual ~sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& operator=(const sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart(const sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_DynamicDataStatus, std::allocator<sds_fi_tcl_DynamicDataStatus> > DynamicDataStatus;
   virtual ~sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& operator=(const sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& coRef);
   sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult(const sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tclString szVoconEngineVersionInfo;
   sds_fi_tclString szAcModVersionInfo;
   virtual ~sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& operator=(const sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart(const sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& operator=(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > szTextStrings;
   sds_fi_tcl_SDSLanguageID LanguageID;
   sds_fi_tcl_e8_DataCategory e8DataCategory;
   sds_fi_tcl_e16_ISOCountryCode e16CountryCode;
   virtual ~sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& operator=(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& coRef);
   sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_Phoneme, std::allocator<sds_fi_tcl_Phoneme> > Phonemes;
   virtual ~sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& operator=(const sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart(const sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Mode_Enable;
   sds_fi_tcl_e32_SSE_ASR_Mode Mode_Status;
   virtual ~sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& operator=(const sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart(const sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 m_u32SSEDataSize;
   std::vector<tU8, std::allocator<tU8> > m_arru8SSEAudioTypeData;
   virtual ~sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& operator=(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_SemConfig, std::allocator<sds_fi_tcl_SemConfig> > SemConfigs;
   virtual ~sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& operator=(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& coRef);
   sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_RecogSemResult, std::allocator<sds_fi_tcl_RecogSemResult> > SemResults;
   virtual ~sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& operator=(const sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart(const sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   sds_fi_tcl_u64_tPVoid poComponent;
   virtual ~sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& operator=(const sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart(const sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   virtual ~sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& operator=(const sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart(const sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& operator=(const sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart(const sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_VoconComponent e8VoconComponent;
   virtual ~sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& operator=(const sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef);
   sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart(const sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > tU8TTFValue;
   std::vector<sds_fi_tclString, std::allocator<sds_fi_tclString> > szTTFStringParam;
   virtual ~sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart();

   virtual ~sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult();

   virtual ~sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgLanguageGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgLanguageGet();

   virtual ~sds_rec_recogservicefi_tclMsgLanguageGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgLanguageGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgLanguageStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgLanguageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgLanguageStatus& operator=(const sds_rec_recogservicefi_tclMsgLanguageStatus& coRef);
   sds_rec_recogservicefi_tclMsgLanguageStatus(const sds_rec_recogservicefi_tclMsgLanguageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_SDSLanguageID Language;
   virtual ~sds_rec_recogservicefi_tclMsgLanguageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgLanguageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecogStatusGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecogStatusGet();

   virtual ~sds_rec_recogservicefi_tclMsgRecogStatusGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgRecogStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecogStatusSet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecogStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecogStatusSet& operator=(const sds_rec_recogservicefi_tclMsgRecogStatusSet& coRef);
   sds_rec_recogservicefi_tclMsgRecogStatusSet(const sds_rec_recogservicefi_tclMsgRecogStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_RecogStatus RecogStatus;
   virtual ~sds_rec_recogservicefi_tclMsgRecogStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecogStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecogStatusStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecogStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecogStatusStatus& operator=(const sds_rec_recogservicefi_tclMsgRecogStatusStatus& coRef);
   sds_rec_recogservicefi_tclMsgRecogStatusStatus(const sds_rec_recogservicefi_tclMsgRecogStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_RecogStatus RecogStatus;
   virtual ~sds_rec_recogservicefi_tclMsgRecogStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecogStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecognizeFromFileGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecognizeFromFileGet();

   virtual ~sds_rec_recogservicefi_tclMsgRecognizeFromFileGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgRecognizeFromFileGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& operator=(const sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& coRef);
   sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus(const sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_RecogFromFile RecogFromFile;
   virtual ~sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecognizeFromFileSet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecognizeFromFileSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& operator=(const sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& coRef);
   sds_rec_recogservicefi_tclMsgRecognizeFromFileSet(const sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_RecogFromFile RecogFromFile;
   virtual ~sds_rec_recogservicefi_tclMsgRecognizeFromFileSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecognizeToFileGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecognizeToFileGet();

   virtual ~sds_rec_recogservicefi_tclMsgRecognizeToFileGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgRecognizeToFileGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecognizeToFileStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecognizeToFileStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& operator=(const sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& coRef);
   sds_rec_recogservicefi_tclMsgRecognizeToFileStatus(const sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_RecogToFile RecogToFile;
   virtual ~sds_rec_recogservicefi_tclMsgRecognizeToFileStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecognizeToFileSet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecognizeToFileSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecognizeToFileSet& operator=(const sds_rec_recogservicefi_tclMsgRecognizeToFileSet& coRef);
   sds_rec_recogservicefi_tclMsgRecognizeToFileSet(const sds_rec_recogservicefi_tclMsgRecognizeToFileSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_RecogToFile RecogToFile;
   virtual ~sds_rec_recogservicefi_tclMsgRecognizeToFileSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecognizeToFileSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecogSettingsGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecogSettingsGet();

   virtual ~sds_rec_recogservicefi_tclMsgRecogSettingsGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgRecogSettingsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecogSettingsSet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecogSettingsSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecogSettingsSet& operator=(const sds_rec_recogservicefi_tclMsgRecogSettingsSet& coRef);
   sds_rec_recogservicefi_tclMsgRecogSettingsSet(const sds_rec_recogservicefi_tclMsgRecogSettingsSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_REC_Settings, std::allocator<sds_fi_tcl_REC_Settings> > Settings;
   virtual ~sds_rec_recogservicefi_tclMsgRecogSettingsSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecogSettingsSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgRecogSettingsStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgRecogSettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgRecogSettingsStatus& operator=(const sds_rec_recogservicefi_tclMsgRecogSettingsStatus& coRef);
   sds_rec_recogservicefi_tclMsgRecogSettingsStatus(const sds_rec_recogservicefi_tclMsgRecogSettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_REC_Settings, std::allocator<sds_fi_tcl_REC_Settings> > Settings;
   virtual ~sds_rec_recogservicefi_tclMsgRecogSettingsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgRecogSettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgWUWStatusGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgWUWStatusGet();

   virtual ~sds_rec_recogservicefi_tclMsgWUWStatusGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgWUWStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgWUWStatusSet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgWUWStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgWUWStatusSet& operator=(const sds_rec_recogservicefi_tclMsgWUWStatusSet& coRef);
   sds_rec_recogservicefi_tclMsgWUWStatusSet(const sds_rec_recogservicefi_tclMsgWUWStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_WUWStatus WUWStatus;
   virtual ~sds_rec_recogservicefi_tclMsgWUWStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgWUWStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgWUWStatusStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgWUWStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgWUWStatusStatus& operator=(const sds_rec_recogservicefi_tclMsgWUWStatusStatus& coRef);
   sds_rec_recogservicefi_tclMsgWUWStatusStatus(const sds_rec_recogservicefi_tclMsgWUWStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds_fi_tcl_e8_WUWStatus RecogStatus;
   virtual ~sds_rec_recogservicefi_tclMsgWUWStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgWUWStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet();

   virtual ~sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& operator=(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& coRef);
   sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnableTest;
   virtual ~sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& operator=(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& coRef);
   sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bEnableTest;
   virtual ~sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgTest_RecogResultsGet : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgTest_RecogResultsGet();

   virtual ~sds_rec_recogservicefi_tclMsgTest_RecogResultsGet();

   inline tBool operator==(const sds_rec_recogservicefi_tclMsgTest_RecogResultsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus : public sds_rec_recogservicefi_tclMsgBaseMessage
{
public:

   sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& operator=(const sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& coRef);
   sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus(const sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds_fi_tcl_RecogNBestResult, std::allocator<sds_fi_tcl_RecogNBestResult> > RecogNBestResults;
   std::vector<sds_fi_tcl_RecogSemResult, std::allocator<sds_fi_tcl_RecogSemResult> > RecogSEMResults;
   std::vector<sds_fi_tcl_RecogNaviNBestResult, std::allocator<sds_fi_tcl_RecogNaviNBestResult> > RecogNaviResults;
   tS32 AudioSNR;
   tU32 BeginofListeningTime;
   tU32 BeginofSpeechTime;
   tU32 EndofSpeechTime;
   std::vector<sds_fi_tcl_e8RecogAbnormalEvents, std::allocator<sds_fi_tcl_e8RecogAbnormalEvents> > arrAbnormalEvents;
   virtual ~sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
