/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_REC_RECOGSERVICE_FI message types

fi_tclMessageBase* sds_rec_recogservicefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_rec_recogservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetLanguageMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetLanguageMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETUSERMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetUserMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETUSERMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetUserMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTRECOGNITIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTRECOGNITIONMETHODRESULTFIRST:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTRECOGNITIONMETHODRESULTLAST:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STOPRECOGNITIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STOPRECOGNITIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGSESSIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGSESSIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATERECOGCONFIGURATIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATERECOGCONFIGURATIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATENAVICONFIGURATIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATENAVICONFIGURATIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_DELETEUSERWORDSMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_DELETEUSERWORDSMETHODRESULTLAST:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast;

      case sds_rec_recogservicefi_tclToken::EN_MSG_UPDATENAVICONTEXTSMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_UPDATENAVICONTEXTSMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgReleaseDataMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgReleaseDataMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATEINTERNETAPPRECOGCONFIGURATIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATEINTERNETAPPRECOGCONFIGURATIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTUSERWORDTRAININGMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTUSERWORDTRAININGMETHODRESULTFIRST:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTUSERWORDTRAININGMETHODRESULTLAST:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast;

      case sds_rec_recogservicefi_tclToken::EN_MSG_COMMITTRAINEDUSERWORDMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_COMMITTRAINEDUSERWORDMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CREATEDEVICECONTEXTSMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CREATEDEVICECONTEXTSMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RESETCURRENTSPEAKERADAPTIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RESETCURRENTSPEAKERADAPTIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTWUWRECOGNITIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STARTWUWRECOGNITIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STOPWUWRECOGNITIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_STOPWUWRECOGNITIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_GETVOCONENGINEINFORMATIONMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_GETVOCONENGINEINFORMATIONMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETDESTINATIONLANGUAGEMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETDESTINATIONLANGUAGEMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_GETPHONEMEFROMTEXTMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_GETPHONEMEFROMTEXTMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETECNRASRMODESTATUSMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETECNRASRMODESTATUSMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETSSEAUDIOTYPEDATAMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_SETSSEAUDIOTYPEDATAMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLASSIFYSEMTOPICSMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLASSIFYSEMTOPICSMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CREATERECOGRESOURCESMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CREATERECOGRESOURCESMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_WORKAFTERCCASTATUSREACHEDNORMALORDIAGNOSEMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_WORKAFTERCCASTATUSREACHEDNORMALORDIAGNOSEMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_PRINTDYNAMICDEVICESTATUSMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_PRINTDYNAMICDEVICESTATUSMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMNOCONTEXTCREATIONACTIVITYMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMNOCONTEXTCREATIONACTIVITYMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_PRINTHEAPSTATISTICSMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_PRINTHEAPSTATISTICSMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_FREEHEAPRESOURCESMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_FREEHEAPRESOURCESMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESFORDESTLANGMETHODSTART:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart;

      case sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESFORDESTLANGMETHODRESULT:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult;

      case sds_rec_recogservicefi_tclToken::EN_MSG_LANGUAGEGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgLanguageGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_LANGUAGESTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgLanguageStatus;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSTATUSGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecogStatusGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSTATUSSET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecogStatusSet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSTATUSSTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecogStatusStatus;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZEFROMFILEGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecognizeFromFileGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZEFROMFILESTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZEFROMFILESET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecognizeFromFileSet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZETOFILEGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecognizeToFileGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZETOFILESTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecognizeToFileStatus;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZETOFILESET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecognizeToFileSet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSETTINGSGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecogSettingsGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSETTINGSSET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecogSettingsSet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSETTINGSSTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgRecogSettingsStatus;

      case sds_rec_recogservicefi_tclToken::EN_MSG_WUWSTATUSGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgWUWStatusGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_WUWSTATUSSET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgWUWStatusSet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_WUWSTATUSSTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgWUWStatusStatus;

      case sds_rec_recogservicefi_tclToken::EN_MSG_TEST_INTERFACEENABLEGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_TEST_INTERFACEENABLESTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus;

      case sds_rec_recogservicefi_tclToken::EN_MSG_TEST_INTERFACEENABLESET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_TEST_RECOGRESULTSGET:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgTest_RecogResultsGet;

      case sds_rec_recogservicefi_tclToken::EN_MSG_TEST_RECOGRESULTSSTATUS:
         return OSAL_NEW sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_rec_recogservicefifi messages

// common functions

tU16 sds_rec_recogservicefi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_REC_RECOGSERVICEFI_C_U16_SERVICE_ID;
}

tU16 sds_rec_recogservicefi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_rec_recogservicefi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_rec_recogservicefi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_rec_recogservicefi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_rec_recogservicefi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::sds_rec_recogservicefi_tclMsgSetLanguageMethodStart(const sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::operator=(const sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::sds_rec_recogservicefi_tclMsgSetLanguageMethodStart()
:Language()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODSTART;
}


sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::~sds_rec_recogservicefi_tclMsgSetLanguageMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgSetLanguageMethodStart::operator==(const sds_rec_recogservicefi_tclMsgSetLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgSetLanguageMethodResult::sds_rec_recogservicefi_tclMsgSetLanguageMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETLANGUAGEMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgSetLanguageMethodResult::~sds_rec_recogservicefi_tclMsgSetLanguageMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgSetUserMethodStart::sds_rec_recogservicefi_tclMsgSetUserMethodStart(const sds_rec_recogservicefi_tclMsgSetUserMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
}
sds_rec_recogservicefi_tclMsgSetUserMethodStart& sds_rec_recogservicefi_tclMsgSetUserMethodStart::operator=(const sds_rec_recogservicefi_tclMsgSetUserMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgSetUserMethodStart::sds_rec_recogservicefi_tclMsgSetUserMethodStart()
:DomainID()
,ProfileID(0)
 {}

tS32 sds_rec_recogservicefi_tclMsgSetUserMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETUSERMETHODSTART;
}


sds_rec_recogservicefi_tclMsgSetUserMethodStart::~sds_rec_recogservicefi_tclMsgSetUserMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgSetUserMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgSetUserMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> ProfileID);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgSetUserMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << ProfileID);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgSetUserMethodStart::operator==(const sds_rec_recogservicefi_tclMsgSetUserMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (ProfileID == roRef.ProfileID);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgSetUserMethodResult::sds_rec_recogservicefi_tclMsgSetUserMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetUserMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETUSERMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgSetUserMethodResult::~sds_rec_recogservicefi_tclMsgSetUserMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   bDoSemClassification = coRef.bDoSemClassification;
   bFromVectors = coRef.bFromVectors;
}
sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::operator=(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bDoSemClassification = coRef.bDoSemClassification;
   bFromVectors = coRef.bFromVectors;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart()
:bDoSemClassification(TRUE)
,bFromVectors(FALSE)
 {}

tS32 sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTRECOGNITIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::~sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDoSemClassification);
   (tVoid) (oIn >> bFromVectors);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDoSemClassification);
   (tVoid) (oOut << bFromVectors);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart::operator==(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDoSemClassification == roRef.bDoSemClassification);
   bResult = bResult && (bFromVectors == roRef.bFromVectors);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst::sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst()
 {}

tS32 sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTRECOGNITIONMETHODRESULTFIRST;
}


sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst::~sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultFirst()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   ResultType = coRef.ResultType;
   RecogNBestResults = coRef.RecogNBestResults;
   RecogSEMResults = coRef.RecogSEMResults;
   RecogNaviResults = coRef.RecogNaviResults;
   arrAbnormalEvents = coRef.arrAbnormalEvents;
   AudioSNR = coRef.AudioSNR;
   BeginofListeningTime = coRef.BeginofListeningTime;
   BeginofSpeechTime = coRef.BeginofSpeechTime;
   EndofSpeechTime = coRef.EndofSpeechTime;
   Latency = coRef.Latency;
   szJSONResult = coRef.szJSONResult;
}
sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::operator=(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   ResultType = coRef.ResultType;
   RecogNBestResults = coRef.RecogNBestResults;
   RecogSEMResults = coRef.RecogSEMResults;
   RecogNaviResults = coRef.RecogNaviResults;
   arrAbnormalEvents = coRef.arrAbnormalEvents;
   AudioSNR = coRef.AudioSNR;
   BeginofListeningTime = coRef.BeginofListeningTime;
   BeginofSpeechTime = coRef.BeginofSpeechTime;
   EndofSpeechTime = coRef.EndofSpeechTime;
   Latency = coRef.Latency;
   szJSONResult = coRef.szJSONResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNBestResults.size(); ++u32Idx)
         RecogNBestResults[u32Idx].vDestroy();
   RecogNBestResults.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < RecogSEMResults.size(); ++u32Idx)
         RecogSEMResults[u32Idx].vDestroy();
   RecogSEMResults.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNaviResults.size(); ++u32Idx)
         RecogNaviResults[u32Idx].vDestroy();
   RecogNaviResults.clear();
   }
   {
   arrAbnormalEvents.clear();
   }
   szJSONResult.vDestroy();
}

sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast()
:ResultType()




,AudioSNR(0)
,BeginofListeningTime(0)
,BeginofSpeechTime(0)
,EndofSpeechTime(0)
,Latency(0)
,szJSONResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTRECOGNITIONMETHODRESULTLAST;
}


sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::~sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RecogNBestResults.size(); ++u32ListIdx)
      u32DynamicSize += RecogNBestResults[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RecogSEMResults.size(); ++u32ListIdx)
      u32DynamicSize += RecogSEMResults[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RecogNaviResults.size(); ++u32ListIdx)
      u32DynamicSize += RecogNaviResults[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+37+arrAbnormalEvents.size()*1+szJSONResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResultType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RecogNBestResults.size(); ++u32Idx)
      {
         RecogNBestResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RecogNBestResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RecogNBestResults[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RecogSEMResults.size(); ++u32Idx)
      {
         RecogSEMResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RecogSEMResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RecogSEMResults[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RecogNaviResults.size(); ++u32Idx)
      {
         RecogNaviResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RecogNaviResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RecogNaviResults[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      arrAbnormalEvents.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arrAbnormalEvents[u32Idx]);
      }
   }
   (tVoid) (oIn >> AudioSNR);
   (tVoid) (oIn >> BeginofListeningTime);
   (tVoid) (oIn >> BeginofSpeechTime);
   (tVoid) (oIn >> EndofSpeechTime);
   (tVoid) (oIn >> Latency);
   (tVoid) (oIn >> szJSONResult);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResultType);
   (tVoid) (oOut << (tU32)RecogNBestResults.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNBestResults.size(); ++u32Idx)
         (tVoid) (oOut << RecogNBestResults[u32Idx]);
   }
   (tVoid) (oOut << (tU32)RecogSEMResults.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RecogSEMResults.size(); ++u32Idx)
         (tVoid) (oOut << RecogSEMResults[u32Idx]);
   }
   (tVoid) (oOut << (tU32)RecogNaviResults.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNaviResults.size(); ++u32Idx)
         (tVoid) (oOut << RecogNaviResults[u32Idx]);
   }
   (tVoid) (oOut << (tU32)arrAbnormalEvents.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arrAbnormalEvents.size(); ++u32Idx)
         (tVoid) (oOut << arrAbnormalEvents[u32Idx]);
   }
   (tVoid) (oOut << AudioSNR);
   (tVoid) (oOut << BeginofListeningTime);
   (tVoid) (oOut << BeginofSpeechTime);
   (tVoid) (oOut << EndofSpeechTime);
   (tVoid) (oOut << Latency);
   (tVoid) (oOut << szJSONResult);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast::operator==(const sds_rec_recogservicefi_tclMsgStartRecognitionMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResultType == roRef.ResultType);
      bResult = bResult && (RecogNBestResults.size() == roRef.RecogNBestResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RecogNBestResults.size()); ++u32Idx)
            bResult = bResult && (RecogNBestResults[u32Idx] == roRef.RecogNBestResults[u32Idx]);
      }
      bResult = bResult && (RecogSEMResults.size() == roRef.RecogSEMResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RecogSEMResults.size()); ++u32Idx)
            bResult = bResult && (RecogSEMResults[u32Idx] == roRef.RecogSEMResults[u32Idx]);
      }
      bResult = bResult && (RecogNaviResults.size() == roRef.RecogNaviResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RecogNaviResults.size()); ++u32Idx)
            bResult = bResult && (RecogNaviResults[u32Idx] == roRef.RecogNaviResults[u32Idx]);
      }
      bResult = bResult && (arrAbnormalEvents.size() == roRef.arrAbnormalEvents.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arrAbnormalEvents.size()); ++u32Idx)
            bResult = bResult && (arrAbnormalEvents[u32Idx] == roRef.arrAbnormalEvents[u32Idx]);
      }
   bResult = bResult && (AudioSNR == roRef.AudioSNR);
   bResult = bResult && (BeginofListeningTime == roRef.BeginofListeningTime);
   bResult = bResult && (BeginofSpeechTime == roRef.BeginofSpeechTime);
   bResult = bResult && (EndofSpeechTime == roRef.EndofSpeechTime);
   bResult = bResult && (Latency == roRef.Latency);
   bResult = bResult && (szJSONResult == roRef.szJSONResult);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart::sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STOPRECOGNITIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart::~sds_rec_recogservicefi_tclMsgStopRecognitionMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult::sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STOPRECOGNITIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult::~sds_rec_recogservicefi_tclMsgStopRecognitionMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart::sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGSESSIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart::~sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult::sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGSESSIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult::~sds_rec_recogservicefi_tclMsgCloseRecogSessionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart(const sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   szConfiguration = coRef.szConfiguration;
   szCloudConfiguration = coRef.szCloudConfiguration;
   LocationList = coRef.LocationList;
   arrDynamicRules = coRef.arrDynamicRules;
   VDLCategory = coRef.VDLCategory;
   u32PageNumber = coRef.u32PageNumber;
   IDTranscriptionsEntry = coRef.IDTranscriptionsEntry;
}
sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::operator=(const sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szConfiguration = coRef.szConfiguration;
   szCloudConfiguration = coRef.szCloudConfiguration;
   LocationList = coRef.LocationList;
   arrDynamicRules = coRef.arrDynamicRules;
   VDLCategory = coRef.VDLCategory;
   u32PageNumber = coRef.u32PageNumber;
   IDTranscriptionsEntry = coRef.IDTranscriptionsEntry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::vDestroy()
{
   szConfiguration.vDestroy();
   szCloudConfiguration.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         LocationList[u32Idx].vDestroy();
   LocationList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < arrDynamicRules.size(); ++u32Idx)
         arrDynamicRules[u32Idx].vDestroy();
   arrDynamicRules.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < IDTranscriptionsEntry.size(); ++u32Idx)
         IDTranscriptionsEntry[u32Idx].vDestroy();
   IDTranscriptionsEntry.clear();
   }
}

sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart()
:szConfiguration()
,szCloudConfiguration()


,VDLCategory()
,u32PageNumber(0)

 {}

tS32 sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATERECOGCONFIGURATIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::~sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LocationList.size(); ++u32ListIdx)
      u32DynamicSize += LocationList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < arrDynamicRules.size(); ++u32ListIdx)
      u32DynamicSize += arrDynamicRules[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < IDTranscriptionsEntry.size(); ++u32ListIdx)
      u32DynamicSize += IDTranscriptionsEntry[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+17+szConfiguration.u32GetSize(u16MajorVersion)+szCloudConfiguration.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szConfiguration);
   (tVoid) (oIn >> szCloudConfiguration);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
      {
         LocationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LocationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LocationList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arrDynamicRules.size(); ++u32Idx)
      {
         arrDynamicRules[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arrDynamicRules.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arrDynamicRules[u32Idx]);
      }
   }
   (tVoid) (oIn >> VDLCategory);
   (tVoid) (oIn >> u32PageNumber);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IDTranscriptionsEntry.size(); ++u32Idx)
      {
         IDTranscriptionsEntry[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IDTranscriptionsEntry.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IDTranscriptionsEntry[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szConfiguration);
   (tVoid) (oOut << szCloudConfiguration);
   (tVoid) (oOut << (tU32)LocationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         (tVoid) (oOut << LocationList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)arrDynamicRules.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arrDynamicRules.size(); ++u32Idx)
         (tVoid) (oOut << arrDynamicRules[u32Idx]);
   }
   (tVoid) (oOut << VDLCategory);
   (tVoid) (oOut << u32PageNumber);
   (tVoid) (oOut << (tU32)IDTranscriptionsEntry.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IDTranscriptionsEntry.size(); ++u32Idx)
         (tVoid) (oOut << IDTranscriptionsEntry[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart::operator==(const sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szConfiguration == roRef.szConfiguration);
   bResult = bResult && (szCloudConfiguration == roRef.szCloudConfiguration);
      bResult = bResult && (LocationList.size() == roRef.LocationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LocationList.size()); ++u32Idx)
            bResult = bResult && (LocationList[u32Idx] == roRef.LocationList[u32Idx]);
      }
      bResult = bResult && (arrDynamicRules.size() == roRef.arrDynamicRules.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arrDynamicRules.size()); ++u32Idx)
            bResult = bResult && (arrDynamicRules[u32Idx] == roRef.arrDynamicRules[u32Idx]);
      }
   bResult = bResult && (VDLCategory == roRef.VDLCategory);
   bResult = bResult && (u32PageNumber == roRef.u32PageNumber);
      bResult = bResult && (IDTranscriptionsEntry.size() == roRef.IDTranscriptionsEntry.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IDTranscriptionsEntry.size()); ++u32Idx)
            bResult = bResult && (IDTranscriptionsEntry[u32Idx] == roRef.IDTranscriptionsEntry[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult::sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATERECOGCONFIGURATIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult::~sds_rec_recogservicefi_tclMsgActivateRecogConfigurationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart(const sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   szConfiguration = coRef.szConfiguration;
   szCloudConfiguration = coRef.szCloudConfiguration;
   LocationList = coRef.LocationList;
   arrDynamicRules = coRef.arrDynamicRules;
   arrDynRegions = coRef.arrDynRegions;
}
sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::operator=(const sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szConfiguration = coRef.szConfiguration;
   szCloudConfiguration = coRef.szCloudConfiguration;
   LocationList = coRef.LocationList;
   arrDynamicRules = coRef.arrDynamicRules;
   arrDynRegions = coRef.arrDynRegions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::vDestroy()
{
   szConfiguration.vDestroy();
   szCloudConfiguration.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         LocationList[u32Idx].vDestroy();
   LocationList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < arrDynamicRules.size(); ++u32Idx)
         arrDynamicRules[u32Idx].vDestroy();
   arrDynamicRules.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < arrDynRegions.size(); ++u32Idx)
         arrDynRegions[u32Idx].vDestroy();
   arrDynRegions.clear();
   }
}

sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart()
:szConfiguration()
,szCloudConfiguration()



 {}

tS32 sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATENAVICONFIGURATIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::~sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LocationList.size(); ++u32ListIdx)
      u32DynamicSize += LocationList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < arrDynamicRules.size(); ++u32ListIdx)
      u32DynamicSize += arrDynamicRules[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < arrDynRegions.size(); ++u32ListIdx)
      u32DynamicSize += arrDynRegions[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+12+szConfiguration.u32GetSize(u16MajorVersion)+szCloudConfiguration.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szConfiguration);
   (tVoid) (oIn >> szCloudConfiguration);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
      {
         LocationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LocationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LocationList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arrDynamicRules.size(); ++u32Idx)
      {
         arrDynamicRules[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arrDynamicRules.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arrDynamicRules[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arrDynRegions.size(); ++u32Idx)
      {
         arrDynRegions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arrDynRegions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arrDynRegions[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szConfiguration);
   (tVoid) (oOut << szCloudConfiguration);
   (tVoid) (oOut << (tU32)LocationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         (tVoid) (oOut << LocationList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)arrDynamicRules.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arrDynamicRules.size(); ++u32Idx)
         (tVoid) (oOut << arrDynamicRules[u32Idx]);
   }
   (tVoid) (oOut << (tU32)arrDynRegions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arrDynRegions.size(); ++u32Idx)
         (tVoid) (oOut << arrDynRegions[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart::operator==(const sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szConfiguration == roRef.szConfiguration);
   bResult = bResult && (szCloudConfiguration == roRef.szCloudConfiguration);
      bResult = bResult && (LocationList.size() == roRef.LocationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LocationList.size()); ++u32Idx)
            bResult = bResult && (LocationList[u32Idx] == roRef.LocationList[u32Idx]);
      }
      bResult = bResult && (arrDynamicRules.size() == roRef.arrDynamicRules.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arrDynamicRules.size()); ++u32Idx)
            bResult = bResult && (arrDynamicRules[u32Idx] == roRef.arrDynamicRules[u32Idx]);
      }
      bResult = bResult && (arrDynRegions.size() == roRef.arrDynRegions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arrDynRegions.size()); ++u32Idx)
            bResult = bResult && (arrDynRegions[u32Idx] == roRef.arrDynRegions[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult::sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATENAVICONFIGURATIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult::~sds_rec_recogservicefi_tclMsgActivateNaviConfigurationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart(const sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   UserWrdID = coRef.UserWrdID;
}
sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::operator=(const sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   UserWrdID = coRef.UserWrdID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart()
:DomainID()
,ProfileID(0)
,UserWrdID(0)
 {}

tS32 sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_DELETEUSERWORDSMETHODSTART;
}


sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::~sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> ProfileID);
   (tVoid) (oIn >> UserWrdID);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << ProfileID);
   (tVoid) (oOut << UserWrdID);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart::operator==(const sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (ProfileID == roRef.ProfileID);
   bResult = bResult && (UserWrdID == roRef.UserWrdID);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast::sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast()
 {}

tS32 sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_DELETEUSERWORDSMETHODRESULTLAST;
}


sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast::~sds_rec_recogservicefi_tclMsgDeleteUserWordsMethodResultLast()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart(const sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Country = coRef.Country;
   StateName = coRef.StateName;
}
sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::operator=(const sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   StateName = coRef.StateName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::vDestroy()
{
   Country.vDestroy(); 
   StateName.vDestroy(); 
}

sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart()
:Country()
,StateName()
 {}

tS32 sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_UPDATENAVICONTEXTSMETHODSTART;
}


sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::~sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Country.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> StateName);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   (tVoid) (oOut << StateName);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart::operator==(const sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (StateName == roRef.StateName);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult::sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_UPDATENAVICONTEXTSMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult::~sds_rec_recogservicefi_tclMsgUpdateNaviContextsMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgReleaseDataMethodStart::sds_rec_recogservicefi_tclMsgReleaseDataMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgReleaseDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RELEASEDATAMETHODSTART;
}


sds_rec_recogservicefi_tclMsgReleaseDataMethodStart::~sds_rec_recogservicefi_tclMsgReleaseDataMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgReleaseDataMethodResult::sds_rec_recogservicefi_tclMsgReleaseDataMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgReleaseDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgReleaseDataMethodResult::~sds_rec_recogservicefi_tclMsgReleaseDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart(const sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   szContextName = coRef.szContextName;
   szContextFilePath = coRef.szContextFilePath;
   FxParameters = coRef.FxParameters;
   RecParameters = coRef.RecParameters;
   CtxParameters = coRef.CtxParameters;
}
sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::operator=(const sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szContextName = coRef.szContextName;
   szContextFilePath = coRef.szContextFilePath;
   FxParameters = coRef.FxParameters;
   RecParameters = coRef.RecParameters;
   CtxParameters = coRef.CtxParameters;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::vDestroy()
{
   szContextName.vDestroy();
   szContextFilePath.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < FxParameters.size(); ++u32Idx)
         FxParameters[u32Idx].vDestroy();
   FxParameters.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < RecParameters.size(); ++u32Idx)
         RecParameters[u32Idx].vDestroy();
   RecParameters.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < CtxParameters.size(); ++u32Idx)
         CtxParameters[u32Idx].vDestroy();
   CtxParameters.clear();
   }
}

sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart()
:szContextName()
,szContextFilePath()



 {}

tS32 sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATEINTERNETAPPRECOGCONFIGURATIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::~sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+szContextName.u32GetSize(u16MajorVersion)+szContextFilePath.u32GetSize(u16MajorVersion)+FxParameters.size()*8+RecParameters.size()*8+CtxParameters.size()*8;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szContextName);
   (tVoid) (oIn >> szContextFilePath);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FxParameters.size(); ++u32Idx)
      {
         FxParameters[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FxParameters.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FxParameters[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RecParameters.size(); ++u32Idx)
      {
         RecParameters[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RecParameters.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RecParameters[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CtxParameters.size(); ++u32Idx)
      {
         CtxParameters[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CtxParameters.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CtxParameters[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szContextName);
   (tVoid) (oOut << szContextFilePath);
   (tVoid) (oOut << (tU32)FxParameters.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FxParameters.size(); ++u32Idx)
         (tVoid) (oOut << FxParameters[u32Idx]);
   }
   (tVoid) (oOut << (tU32)RecParameters.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RecParameters.size(); ++u32Idx)
         (tVoid) (oOut << RecParameters[u32Idx]);
   }
   (tVoid) (oOut << (tU32)CtxParameters.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CtxParameters.size(); ++u32Idx)
         (tVoid) (oOut << CtxParameters[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart::operator==(const sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szContextName == roRef.szContextName);
   bResult = bResult && (szContextFilePath == roRef.szContextFilePath);
      bResult = bResult && (FxParameters.size() == roRef.FxParameters.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FxParameters.size()); ++u32Idx)
            bResult = bResult && (FxParameters[u32Idx] == roRef.FxParameters[u32Idx]);
      }
      bResult = bResult && (RecParameters.size() == roRef.RecParameters.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RecParameters.size()); ++u32Idx)
            bResult = bResult && (RecParameters[u32Idx] == roRef.RecParameters[u32Idx]);
      }
      bResult = bResult && (CtxParameters.size() == roRef.CtxParameters.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CtxParameters.size()); ++u32Idx)
            bResult = bResult && (CtxParameters[u32Idx] == roRef.CtxParameters[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult::sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_ACTIVATEINTERNETAPPRECOGCONFIGURATIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult::~sds_rec_recogservicefi_tclMsgActivateInternetAppRecogConfigurationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   UserWrdID = coRef.UserWrdID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   UserWordTrainType = coRef.UserWordTrainType;
}
sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::operator=(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UserWrdID = coRef.UserWrdID;
   DomainID = coRef.DomainID;
   ProfileID = coRef.ProfileID;
   UserWordTrainType = coRef.UserWordTrainType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart()
:UserWrdID(0)
,DomainID()
,ProfileID(0)
,UserWordTrainType()
 {}

tS32 sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTUSERWORDTRAININGMETHODSTART;
}


sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::~sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserWrdID);
   (tVoid) (oIn >> DomainID);
   (tVoid) (oIn >> ProfileID);
   (tVoid) (oIn >> UserWordTrainType);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserWrdID);
   (tVoid) (oOut << DomainID);
   (tVoid) (oOut << ProfileID);
   (tVoid) (oOut << UserWordTrainType);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart::operator==(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserWrdID == roRef.UserWrdID);
   bResult = bResult && (DomainID == roRef.DomainID);
   bResult = bResult && (ProfileID == roRef.ProfileID);
   bResult = bResult && (UserWordTrainType == roRef.UserWordTrainType);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst::sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst()
 {}

tS32 sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTUSERWORDTRAININGMETHODRESULTFIRST;
}


sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst::~sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultFirst()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   ResultType = coRef.ResultType;
}
sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::operator=(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   ResultType = coRef.ResultType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast()
:ResultType()
 {}

tS32 sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTUSERWORDTRAININGMETHODRESULTLAST;
}


sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::~sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast()
{}

tU32 sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResultType);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResultType);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast::operator==(const sds_rec_recogservicefi_tclMsgStartUserWordTrainingMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResultType == roRef.ResultType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart(const sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   bCommit = coRef.bCommit;
}
sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::operator=(const sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bCommit = coRef.bCommit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart()
:bCommit(0)
 {}

tS32 sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_COMMITTRAINEDUSERWORDMETHODSTART;
}


sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::~sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bCommit);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bCommit);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart::operator==(const sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bCommit == roRef.bCommit);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult::sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_COMMITTRAINEDUSERWORDMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult::~sds_rec_recogservicefi_tclMsgCommitTrainedUserWordMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart(const sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   DynamicDataStatus = coRef.DynamicDataStatus;
}
sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::operator=(const sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DynamicDataStatus = coRef.DynamicDataStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DynamicDataStatus.size(); ++u32Idx)
         DynamicDataStatus[u32Idx].vDestroy();
   DynamicDataStatus.clear();
   }
}

sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart()

 {}

tS32 sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CREATEDEVICECONTEXTSMETHODSTART;
}


sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::~sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DynamicDataStatus.size(); ++u32ListIdx)
      u32DynamicSize += DynamicDataStatus[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DynamicDataStatus.size(); ++u32Idx)
      {
         DynamicDataStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DynamicDataStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DynamicDataStatus[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DynamicDataStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DynamicDataStatus.size(); ++u32Idx)
         (tVoid) (oOut << DynamicDataStatus[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart::operator==(const sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DynamicDataStatus.size() == roRef.DynamicDataStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DynamicDataStatus.size()); ++u32Idx)
            bResult = bResult && (DynamicDataStatus[u32Idx] == roRef.DynamicDataStatus[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult::sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CREATEDEVICECONTEXTSMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult::~sds_rec_recogservicefi_tclMsgCreateDeviceContextsMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart::sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RESETCURRENTSPEAKERADAPTIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart::~sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult::sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RESETCURRENTSPEAKERADAPTIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult::~sds_rec_recogservicefi_tclMsgResetCurrentSpeakerAdaptionMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart::sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTWUWRECOGNITIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart::~sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult::sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STARTWUWRECOGNITIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult::~sds_rec_recogservicefi_tclMsgStartWUWRecognitionMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart::sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STOPWUWRECOGNITIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart::~sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult::sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_STOPWUWRECOGNITIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult::~sds_rec_recogservicefi_tclMsgStopWUWRecognitionMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart::sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_GETVOCONENGINEINFORMATIONMETHODSTART;
}


sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart::~sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult(const sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   szVoconEngineVersionInfo = coRef.szVoconEngineVersionInfo;
   szAcModVersionInfo = coRef.szAcModVersionInfo;
}
sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::operator=(const sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   szVoconEngineVersionInfo = coRef.szVoconEngineVersionInfo;
   szAcModVersionInfo = coRef.szAcModVersionInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::vDestroy()
{
   szVoconEngineVersionInfo.vDestroy();
   szAcModVersionInfo.vDestroy();
}

sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult()
:szVoconEngineVersionInfo()
,szAcModVersionInfo()
 {}

tS32 sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_GETVOCONENGINEINFORMATIONMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::~sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+szVoconEngineVersionInfo.u32GetSize(u16MajorVersion)+szAcModVersionInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> szVoconEngineVersionInfo);
   (tVoid) (oIn >> szAcModVersionInfo);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << szVoconEngineVersionInfo);
   (tVoid) (oOut << szAcModVersionInfo);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult::operator==(const sds_rec_recogservicefi_tclMsgGetVoconEngineInformationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (szVoconEngineVersionInfo == roRef.szVoconEngineVersionInfo);
   bResult = bResult && (szAcModVersionInfo == roRef.szAcModVersionInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart(const sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::operator=(const sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart()
:Language()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETDESTINATIONLANGUAGEMETHODSTART;
}


sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::~sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart::operator==(const sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult::sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETDESTINATIONLANGUAGEMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult::~sds_rec_recogservicefi_tclMsgSetDestinationLanguageMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   szTextStrings = coRef.szTextStrings;
   LanguageID = coRef.LanguageID;
   e8DataCategory = coRef.e8DataCategory;
   e16CountryCode = coRef.e16CountryCode;
}
sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::operator=(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& coRef)
{
   if (this == &coRef) return *this;
   szTextStrings = coRef.szTextStrings;
   LanguageID = coRef.LanguageID;
   e8DataCategory = coRef.e8DataCategory;
   e16CountryCode = coRef.e16CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < szTextStrings.size(); ++u32Idx)
         szTextStrings[u32Idx].vDestroy();
   szTextStrings.clear();
   }
   LanguageID.vDestroy(); 
}

sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart()

:LanguageID()
,e8DataCategory()
,e16CountryCode()
 {}

tS32 sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_GETPHONEMEFROMTEXTMETHODSTART;
}


sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::~sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < szTextStrings.size(); ++u32ListIdx)
      u32DynamicSize += szTextStrings[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < szTextStrings.size(); ++u32Idx)
      {
         szTextStrings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      szTextStrings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> szTextStrings[u32Idx]);
      }
   }
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> e8DataCategory);
   (tVoid) (oIn >> e16CountryCode);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)szTextStrings.size());
   {
      for (tU32 u32Idx = 0; u32Idx < szTextStrings.size(); ++u32Idx)
         (tVoid) (oOut << szTextStrings[u32Idx]);
   }
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << e8DataCategory);
   (tVoid) (oOut << e16CountryCode);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart::operator==(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (szTextStrings.size() == roRef.szTextStrings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < szTextStrings.size()); ++u32Idx)
            bResult = bResult && (szTextStrings[u32Idx] == roRef.szTextStrings[u32Idx]);
      }
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (e8DataCategory == roRef.e8DataCategory);
   bResult = bResult && (e16CountryCode == roRef.e16CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Phonemes = coRef.Phonemes;
}
sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::operator=(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Phonemes = coRef.Phonemes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Phonemes.size(); ++u32Idx)
         Phonemes[u32Idx].vDestroy();
   Phonemes.clear();
   }
}

sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult()

 {}

tS32 sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_GETPHONEMEFROMTEXTMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::~sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Phonemes.size(); ++u32ListIdx)
      u32DynamicSize += Phonemes[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Phonemes.size(); ++u32Idx)
      {
         Phonemes[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Phonemes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Phonemes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Phonemes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Phonemes.size(); ++u32Idx)
         (tVoid) (oOut << Phonemes[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult::operator==(const sds_rec_recogservicefi_tclMsgGetPhonemeFromTextMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Phonemes.size() == roRef.Phonemes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Phonemes.size()); ++u32Idx)
            bResult = bResult && (Phonemes[u32Idx] == roRef.Phonemes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart(const sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Mode_Enable = coRef.Mode_Enable;
   Mode_Status = coRef.Mode_Status;
}
sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::operator=(const sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Mode_Enable = coRef.Mode_Enable;
   Mode_Status = coRef.Mode_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart()
:Mode_Enable(0)
,Mode_Status()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETECNRASRMODESTATUSMETHODSTART;
}


sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::~sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode_Enable);
   (tVoid) (oIn >> Mode_Status);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode_Enable);
   (tVoid) (oOut << Mode_Status);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart::operator==(const sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode_Enable == roRef.Mode_Enable);
   bResult = bResult && (Mode_Status == roRef.Mode_Status);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult::sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETECNRASRMODESTATUSMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult::~sds_rec_recogservicefi_tclMsgSetEcnrAsrModeStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart(const sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   m_u32SSEDataSize = coRef.m_u32SSEDataSize;
   m_arru8SSEAudioTypeData = coRef.m_arru8SSEAudioTypeData;
}
sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::operator=(const sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   m_u32SSEDataSize = coRef.m_u32SSEDataSize;
   m_arru8SSEAudioTypeData = coRef.m_arru8SSEAudioTypeData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::vDestroy()
{
   {
   m_arru8SSEAudioTypeData.clear();
   }
}

sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart()
:m_u32SSEDataSize(0)

 {}

tS32 sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETSSEAUDIOTYPEDATAMETHODSTART;
}


sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::~sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+m_arru8SSEAudioTypeData.size()*1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> m_u32SSEDataSize);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      m_arru8SSEAudioTypeData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> m_arru8SSEAudioTypeData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << m_u32SSEDataSize);
   (tVoid) (oOut << (tU32)m_arru8SSEAudioTypeData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < m_arru8SSEAudioTypeData.size(); ++u32Idx)
         (tVoid) (oOut << m_arru8SSEAudioTypeData[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart::operator==(const sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (m_u32SSEDataSize == roRef.m_u32SSEDataSize);
      bResult = bResult && (m_arru8SSEAudioTypeData.size() == roRef.m_arru8SSEAudioTypeData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < m_arru8SSEAudioTypeData.size()); ++u32Idx)
            bResult = bResult && (m_arru8SSEAudioTypeData[u32Idx] == roRef.m_arru8SSEAudioTypeData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult::sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_SETSSEAUDIOTYPEDATAMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult::~sds_rec_recogservicefi_tclMsgSetSSEAudioTypeDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   SemConfigs = coRef.SemConfigs;
}
sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::operator=(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SemConfigs = coRef.SemConfigs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SemConfigs.size(); ++u32Idx)
         SemConfigs[u32Idx].vDestroy();
   SemConfigs.clear();
   }
}

sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart()

 {}

tS32 sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLASSIFYSEMTOPICSMETHODSTART;
}


sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::~sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SemConfigs.size(); ++u32ListIdx)
      u32DynamicSize += SemConfigs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SemConfigs.size(); ++u32Idx)
      {
         SemConfigs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SemConfigs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SemConfigs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SemConfigs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SemConfigs.size(); ++u32Idx)
         (tVoid) (oOut << SemConfigs[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart::operator==(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SemConfigs.size() == roRef.SemConfigs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SemConfigs.size()); ++u32Idx)
            bResult = bResult && (SemConfigs[u32Idx] == roRef.SemConfigs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   SemResults = coRef.SemResults;
}
sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::operator=(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SemResults = coRef.SemResults;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SemResults.size(); ++u32Idx)
         SemResults[u32Idx].vDestroy();
   SemResults.clear();
   }
}

sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult()

 {}

tS32 sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLASSIFYSEMTOPICSMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::~sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SemResults.size(); ++u32ListIdx)
      u32DynamicSize += SemResults[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SemResults.size(); ++u32Idx)
      {
         SemResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SemResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SemResults[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SemResults.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SemResults.size(); ++u32Idx)
         (tVoid) (oOut << SemResults[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult::operator==(const sds_rec_recogservicefi_tclMsgClassifySemTopicsMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SemResults.size() == roRef.SemResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SemResults.size()); ++u32Idx)
            bResult = bResult && (SemResults[u32Idx] == roRef.SemResults[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart(const sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
   poComponent = coRef.poComponent;
}
sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::operator=(const sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   poComponent = coRef.poComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart()
:e8VoconComponent()
,poComponent()
 {}

tS32 sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODSTART;
}


sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::~sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   (tVoid) (oIn >> poComponent);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   (tVoid) (oOut << poComponent);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart::operator==(const sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   bResult = bResult && (poComponent == roRef.poComponent);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult::sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTINITIALIZEDMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult::~sds_rec_recogservicefi_tclMsgVoconComponentInitializedMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart(const sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
}
sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::operator=(const sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart()
:e8VoconComponent()
 {}

tS32 sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODSTART;
}


sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::~sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart::operator==(const sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult::sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_VOCONCOMPONENTUNINITIALIZEDMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult::~sds_rec_recogservicefi_tclMsgVoconComponentUnInitializedMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart(const sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::operator=(const sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart()
:Language()
 {}

tS32 sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CREATERECOGRESOURCESMETHODSTART;
}


sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::~sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart::operator==(const sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult::sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CREATERECOGRESOURCESMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult::~sds_rec_recogservicefi_tclMsgCreateRecogResourcesMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart::sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESMETHODSTART;
}


sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart::~sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult::sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult::~sds_rec_recogservicefi_tclMsgCloseRecogResourcesMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart::sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_WORKAFTERCCASTATUSREACHEDNORMALORDIAGNOSEMETHODSTART;
}


sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart::~sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult::sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_WORKAFTERCCASTATUSREACHEDNORMALORDIAGNOSEMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult::~sds_rec_recogservicefi_tclMsgWorkAfterCCAStatusReachedNormalOrDiagnoseMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart::sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODSTART;
}


sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart::~sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult::sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_DOUPREGTOPROPERTIESMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult::~sds_rec_recogservicefi_tclMsgDoUpRegToPropertiesMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart(const sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   e8VoconComponent = coRef.e8VoconComponent;
}
sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::operator=(const sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VoconComponent = coRef.e8VoconComponent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart()
:e8VoconComponent()
 {}

tS32 sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODSTART;
}


sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::~sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart()
{}

tU32 sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VoconComponent);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VoconComponent);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart::operator==(const sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VoconComponent == roRef.e8VoconComponent);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult::sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMVOCONACTIVITYSTOPMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult::~sds_rec_recogservicefi_tclMsgConfirmVoconActivityStopMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart::sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_PRINTDYNAMICDEVICESTATUSMETHODSTART;
}


sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart::~sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult::sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_PRINTDYNAMICDEVICESTATUSMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult::~sds_rec_recogservicefi_tclMsgPrintDynamicDeviceStatusMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart::sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMNOCONTEXTCREATIONACTIVITYMETHODSTART;
}


sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart::~sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult::sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CONFIRMNOCONTEXTCREATIONACTIVITYMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult::~sds_rec_recogservicefi_tclMsgConfirmNoContextCreationActivityMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart(const sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   tU8TTFValue = coRef.tU8TTFValue;
   szTTFStringParam = coRef.szTTFStringParam;
}
sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::operator=(const sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tU8TTFValue = coRef.tU8TTFValue;
   szTTFStringParam = coRef.szTTFStringParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::vDestroy()
{
   {
   tU8TTFValue.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < szTTFStringParam.size(); ++u32Idx)
         szTTFStringParam[u32Idx].vDestroy();
   szTTFStringParam.clear();
   }
}

sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart()


 {}

tS32 sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODSTART;
}


sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::~sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < szTTFStringParam.size(); ++u32ListIdx)
      u32DynamicSize += szTTFStringParam[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+tU8TTFValue.size()*1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tU8TTFValue.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tU8TTFValue[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < szTTFStringParam.size(); ++u32Idx)
      {
         szTTFStringParam[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      szTTFStringParam.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> szTTFStringParam[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tU8TTFValue.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tU8TTFValue.size(); ++u32Idx)
         (tVoid) (oOut << tU8TTFValue[u32Idx]);
   }
   (tVoid) (oOut << (tU32)szTTFStringParam.size());
   {
      for (tU32 u32Idx = 0; u32Idx < szTTFStringParam.size(); ++u32Idx)
         (tVoid) (oOut << szTTFStringParam[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart::operator==(const sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tU8TTFValue.size() == roRef.tU8TTFValue.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tU8TTFValue.size()); ++u32Idx)
            bResult = bResult && (tU8TTFValue[u32Idx] == roRef.tU8TTFValue[u32Idx]);
      }
      bResult = bResult && (szTTFStringParam.size() == roRef.szTTFStringParam.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < szTTFStringParam.size()); ++u32Idx)
            bResult = bResult && (szTTFStringParam[u32Idx] == roRef.szTTFStringParam[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult::sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_EXECUTERECEIVEDTTFISCOMMANDMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult::~sds_rec_recogservicefi_tclMsgExecuteReceivedTTFIsCommandMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart::sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_PRINTHEAPSTATISTICSMETHODSTART;
}


sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart::~sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult::sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_PRINTHEAPSTATISTICSMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult::~sds_rec_recogservicefi_tclMsgPrintHeapStatisticsMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart::sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_FREEHEAPRESOURCESMETHODSTART;
}


sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart::~sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult::sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_FREEHEAPRESOURCESMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult::~sds_rec_recogservicefi_tclMsgFreeHeapResourcesMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart::sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart()
 {}

tS32 sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESFORDESTLANGMETHODSTART;
}


sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart::~sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodStart()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult::sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult()
 {}

tS32 sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_CLOSERECOGRESOURCESFORDESTLANGMETHODRESULT;
}


sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult::~sds_rec_recogservicefi_tclMsgCloseRecogResourcesForDestLangMethodResult()
{}

//=============================================================================

sds_rec_recogservicefi_tclMsgLanguageGet::sds_rec_recogservicefi_tclMsgLanguageGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgLanguageGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_LANGUAGEGET;
}


sds_rec_recogservicefi_tclMsgLanguageGet::~sds_rec_recogservicefi_tclMsgLanguageGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgLanguageStatus::sds_rec_recogservicefi_tclMsgLanguageStatus(const sds_rec_recogservicefi_tclMsgLanguageStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Language = coRef.Language;
}
sds_rec_recogservicefi_tclMsgLanguageStatus& sds_rec_recogservicefi_tclMsgLanguageStatus::operator=(const sds_rec_recogservicefi_tclMsgLanguageStatus& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgLanguageStatus::sds_rec_recogservicefi_tclMsgLanguageStatus()
:Language()
 {}

tS32 sds_rec_recogservicefi_tclMsgLanguageStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_LANGUAGESTATUS;
}


sds_rec_recogservicefi_tclMsgLanguageStatus::~sds_rec_recogservicefi_tclMsgLanguageStatus()
{}

tU32 sds_rec_recogservicefi_tclMsgLanguageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgLanguageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgLanguageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgLanguageStatus::operator==(const sds_rec_recogservicefi_tclMsgLanguageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgRecogStatusGet::sds_rec_recogservicefi_tclMsgRecogStatusGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecogStatusGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSTATUSGET;
}


sds_rec_recogservicefi_tclMsgRecogStatusGet::~sds_rec_recogservicefi_tclMsgRecogStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecogStatusSet::sds_rec_recogservicefi_tclMsgRecogStatusSet(const sds_rec_recogservicefi_tclMsgRecogStatusSet& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogStatus = coRef.RecogStatus;
}
sds_rec_recogservicefi_tclMsgRecogStatusSet& sds_rec_recogservicefi_tclMsgRecogStatusSet::operator=(const sds_rec_recogservicefi_tclMsgRecogStatusSet& coRef)
{
   if (this == &coRef) return *this;
   RecogStatus = coRef.RecogStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgRecogStatusSet::sds_rec_recogservicefi_tclMsgRecogStatusSet()
:RecogStatus()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecogStatusSet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSTATUSSET;
}


sds_rec_recogservicefi_tclMsgRecogStatusSet::~sds_rec_recogservicefi_tclMsgRecogStatusSet()
{}

tU32 sds_rec_recogservicefi_tclMsgRecogStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecogStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecogStatus);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecogStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecogStatus);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecogStatusSet::operator==(const sds_rec_recogservicefi_tclMsgRecogStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecogStatus == roRef.RecogStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecogStatusStatus::sds_rec_recogservicefi_tclMsgRecogStatusStatus(const sds_rec_recogservicefi_tclMsgRecogStatusStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogStatus = coRef.RecogStatus;
}
sds_rec_recogservicefi_tclMsgRecogStatusStatus& sds_rec_recogservicefi_tclMsgRecogStatusStatus::operator=(const sds_rec_recogservicefi_tclMsgRecogStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   RecogStatus = coRef.RecogStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgRecogStatusStatus::sds_rec_recogservicefi_tclMsgRecogStatusStatus()
:RecogStatus()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecogStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSTATUSSTATUS;
}


sds_rec_recogservicefi_tclMsgRecogStatusStatus::~sds_rec_recogservicefi_tclMsgRecogStatusStatus()
{}

tU32 sds_rec_recogservicefi_tclMsgRecogStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecogStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecogStatus);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecogStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecogStatus);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecogStatusStatus::operator==(const sds_rec_recogservicefi_tclMsgRecogStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecogStatus == roRef.RecogStatus);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgRecognizeFromFileGet::sds_rec_recogservicefi_tclMsgRecognizeFromFileGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecognizeFromFileGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZEFROMFILEGET;
}


sds_rec_recogservicefi_tclMsgRecognizeFromFileGet::~sds_rec_recogservicefi_tclMsgRecognizeFromFileGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus(const sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogFromFile = coRef.RecogFromFile;
}
sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::operator=(const sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& coRef)
{
   if (this == &coRef) return *this;
   RecogFromFile = coRef.RecogFromFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::vDestroy()
{
   RecogFromFile.vDestroy(); 
}

sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus()
:RecogFromFile()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZEFROMFILESTATUS;
}


sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::~sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RecogFromFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecogFromFile);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecogFromFile);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus::operator==(const sds_rec_recogservicefi_tclMsgRecognizeFromFileStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecogFromFile == roRef.RecogFromFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::sds_rec_recogservicefi_tclMsgRecognizeFromFileSet(const sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogFromFile = coRef.RecogFromFile;
}
sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::operator=(const sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& coRef)
{
   if (this == &coRef) return *this;
   RecogFromFile = coRef.RecogFromFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::vDestroy()
{
   RecogFromFile.vDestroy(); 
}

sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::sds_rec_recogservicefi_tclMsgRecognizeFromFileSet()
:RecogFromFile()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZEFROMFILESET;
}


sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::~sds_rec_recogservicefi_tclMsgRecognizeFromFileSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RecogFromFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecogFromFile);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecogFromFile);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecognizeFromFileSet::operator==(const sds_rec_recogservicefi_tclMsgRecognizeFromFileSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecogFromFile == roRef.RecogFromFile);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgRecognizeToFileGet::sds_rec_recogservicefi_tclMsgRecognizeToFileGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecognizeToFileGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZETOFILEGET;
}


sds_rec_recogservicefi_tclMsgRecognizeToFileGet::~sds_rec_recogservicefi_tclMsgRecognizeToFileGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::sds_rec_recogservicefi_tclMsgRecognizeToFileStatus(const sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogToFile = coRef.RecogToFile;
}
sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::operator=(const sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& coRef)
{
   if (this == &coRef) return *this;
   RecogToFile = coRef.RecogToFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::vDestroy()
{
   RecogToFile.vDestroy(); 
}

sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::sds_rec_recogservicefi_tclMsgRecognizeToFileStatus()
:RecogToFile()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZETOFILESTATUS;
}


sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::~sds_rec_recogservicefi_tclMsgRecognizeToFileStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RecogToFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecogToFile);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecogToFile);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecognizeToFileStatus::operator==(const sds_rec_recogservicefi_tclMsgRecognizeToFileStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecogToFile == roRef.RecogToFile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecognizeToFileSet::sds_rec_recogservicefi_tclMsgRecognizeToFileSet(const sds_rec_recogservicefi_tclMsgRecognizeToFileSet& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogToFile = coRef.RecogToFile;
}
sds_rec_recogservicefi_tclMsgRecognizeToFileSet& sds_rec_recogservicefi_tclMsgRecognizeToFileSet::operator=(const sds_rec_recogservicefi_tclMsgRecognizeToFileSet& coRef)
{
   if (this == &coRef) return *this;
   RecogToFile = coRef.RecogToFile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgRecognizeToFileSet::vDestroy()
{
   RecogToFile.vDestroy(); 
}

sds_rec_recogservicefi_tclMsgRecognizeToFileSet::sds_rec_recogservicefi_tclMsgRecognizeToFileSet()
:RecogToFile()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecognizeToFileSet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGNIZETOFILESET;
}


sds_rec_recogservicefi_tclMsgRecognizeToFileSet::~sds_rec_recogservicefi_tclMsgRecognizeToFileSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgRecognizeToFileSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+RecogToFile.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecognizeToFileSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecogToFile);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecognizeToFileSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecogToFile);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecognizeToFileSet::operator==(const sds_rec_recogservicefi_tclMsgRecognizeToFileSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecogToFile == roRef.RecogToFile);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgRecogSettingsGet::sds_rec_recogservicefi_tclMsgRecogSettingsGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgRecogSettingsGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSETTINGSGET;
}


sds_rec_recogservicefi_tclMsgRecogSettingsGet::~sds_rec_recogservicefi_tclMsgRecogSettingsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecogSettingsSet::sds_rec_recogservicefi_tclMsgRecogSettingsSet(const sds_rec_recogservicefi_tclMsgRecogSettingsSet& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Settings = coRef.Settings;
}
sds_rec_recogservicefi_tclMsgRecogSettingsSet& sds_rec_recogservicefi_tclMsgRecogSettingsSet::operator=(const sds_rec_recogservicefi_tclMsgRecogSettingsSet& coRef)
{
   if (this == &coRef) return *this;
   Settings = coRef.Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgRecogSettingsSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         Settings[u32Idx].vDestroy();
   Settings.clear();
   }
}

sds_rec_recogservicefi_tclMsgRecogSettingsSet::sds_rec_recogservicefi_tclMsgRecogSettingsSet()

 {}

tS32 sds_rec_recogservicefi_tclMsgRecogSettingsSet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSETTINGSSET;
}


sds_rec_recogservicefi_tclMsgRecogSettingsSet::~sds_rec_recogservicefi_tclMsgRecogSettingsSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgRecogSettingsSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Settings.size()*2;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecogSettingsSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
      {
         Settings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Settings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Settings[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecogSettingsSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Settings.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         (tVoid) (oOut << Settings[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecogSettingsSet::operator==(const sds_rec_recogservicefi_tclMsgRecogSettingsSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Settings.size() == roRef.Settings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Settings.size()); ++u32Idx)
            bResult = bResult && (Settings[u32Idx] == roRef.Settings[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgRecogSettingsStatus::sds_rec_recogservicefi_tclMsgRecogSettingsStatus(const sds_rec_recogservicefi_tclMsgRecogSettingsStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   Settings = coRef.Settings;
}
sds_rec_recogservicefi_tclMsgRecogSettingsStatus& sds_rec_recogservicefi_tclMsgRecogSettingsStatus::operator=(const sds_rec_recogservicefi_tclMsgRecogSettingsStatus& coRef)
{
   if (this == &coRef) return *this;
   Settings = coRef.Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgRecogSettingsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         Settings[u32Idx].vDestroy();
   Settings.clear();
   }
}

sds_rec_recogservicefi_tclMsgRecogSettingsStatus::sds_rec_recogservicefi_tclMsgRecogSettingsStatus()

 {}

tS32 sds_rec_recogservicefi_tclMsgRecogSettingsStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_RECOGSETTINGSSTATUS;
}


sds_rec_recogservicefi_tclMsgRecogSettingsStatus::~sds_rec_recogservicefi_tclMsgRecogSettingsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgRecogSettingsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Settings.size()*2;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgRecogSettingsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
      {
         Settings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Settings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Settings[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgRecogSettingsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Settings.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         (tVoid) (oOut << Settings[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgRecogSettingsStatus::operator==(const sds_rec_recogservicefi_tclMsgRecogSettingsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Settings.size() == roRef.Settings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Settings.size()); ++u32Idx)
            bResult = bResult && (Settings[u32Idx] == roRef.Settings[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgWUWStatusGet::sds_rec_recogservicefi_tclMsgWUWStatusGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgWUWStatusGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_WUWSTATUSGET;
}


sds_rec_recogservicefi_tclMsgWUWStatusGet::~sds_rec_recogservicefi_tclMsgWUWStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgWUWStatusSet::sds_rec_recogservicefi_tclMsgWUWStatusSet(const sds_rec_recogservicefi_tclMsgWUWStatusSet& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   WUWStatus = coRef.WUWStatus;
}
sds_rec_recogservicefi_tclMsgWUWStatusSet& sds_rec_recogservicefi_tclMsgWUWStatusSet::operator=(const sds_rec_recogservicefi_tclMsgWUWStatusSet& coRef)
{
   if (this == &coRef) return *this;
   WUWStatus = coRef.WUWStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgWUWStatusSet::sds_rec_recogservicefi_tclMsgWUWStatusSet()
:WUWStatus()
 {}

tS32 sds_rec_recogservicefi_tclMsgWUWStatusSet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_WUWSTATUSSET;
}


sds_rec_recogservicefi_tclMsgWUWStatusSet::~sds_rec_recogservicefi_tclMsgWUWStatusSet()
{}

tU32 sds_rec_recogservicefi_tclMsgWUWStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgWUWStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WUWStatus);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgWUWStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WUWStatus);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgWUWStatusSet::operator==(const sds_rec_recogservicefi_tclMsgWUWStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WUWStatus == roRef.WUWStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgWUWStatusStatus::sds_rec_recogservicefi_tclMsgWUWStatusStatus(const sds_rec_recogservicefi_tclMsgWUWStatusStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogStatus = coRef.RecogStatus;
}
sds_rec_recogservicefi_tclMsgWUWStatusStatus& sds_rec_recogservicefi_tclMsgWUWStatusStatus::operator=(const sds_rec_recogservicefi_tclMsgWUWStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   RecogStatus = coRef.RecogStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgWUWStatusStatus::sds_rec_recogservicefi_tclMsgWUWStatusStatus()
:RecogStatus()
 {}

tS32 sds_rec_recogservicefi_tclMsgWUWStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_WUWSTATUSSTATUS;
}


sds_rec_recogservicefi_tclMsgWUWStatusStatus::~sds_rec_recogservicefi_tclMsgWUWStatusStatus()
{}

tU32 sds_rec_recogservicefi_tclMsgWUWStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgWUWStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecogStatus);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgWUWStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecogStatus);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgWUWStatusStatus::operator==(const sds_rec_recogservicefi_tclMsgWUWStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecogStatus == roRef.RecogStatus);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet::sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_TEST_INTERFACEENABLEGET;
}


sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet::~sds_rec_recogservicefi_tclMsgTest_InterfaceEnableGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   bEnableTest = coRef.bEnableTest;
}
sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::operator=(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& coRef)
{
   if (this == &coRef) return *this;
   bEnableTest = coRef.bEnableTest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus()
:bEnableTest(0)
 {}

tS32 sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_TEST_INTERFACEENABLESTATUS;
}


sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::~sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus()
{}

tU32 sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnableTest);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnableTest);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus::operator==(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnableTest == roRef.bEnableTest);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   bEnableTest = coRef.bEnableTest;
}
sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::operator=(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& coRef)
{
   if (this == &coRef) return *this;
   bEnableTest = coRef.bEnableTest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet()
:bEnableTest(0)
 {}

tS32 sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_TEST_INTERFACEENABLESET;
}


sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::~sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet()
{}

tU32 sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bEnableTest);
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bEnableTest);
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet::operator==(const sds_rec_recogservicefi_tclMsgTest_InterfaceEnableSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bEnableTest == roRef.bEnableTest);
   return bResult;
}

//=============================================================================

sds_rec_recogservicefi_tclMsgTest_RecogResultsGet::sds_rec_recogservicefi_tclMsgTest_RecogResultsGet()
 {}

tS32 sds_rec_recogservicefi_tclMsgTest_RecogResultsGet::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_TEST_RECOGRESULTSGET;
}


sds_rec_recogservicefi_tclMsgTest_RecogResultsGet::~sds_rec_recogservicefi_tclMsgTest_RecogResultsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus(const sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& coRef)
   : sds_rec_recogservicefi_tclMsgBaseMessage(coRef)
{
   RecogNBestResults = coRef.RecogNBestResults;
   RecogSEMResults = coRef.RecogSEMResults;
   RecogNaviResults = coRef.RecogNaviResults;
   AudioSNR = coRef.AudioSNR;
   BeginofListeningTime = coRef.BeginofListeningTime;
   BeginofSpeechTime = coRef.BeginofSpeechTime;
   EndofSpeechTime = coRef.EndofSpeechTime;
   arrAbnormalEvents = coRef.arrAbnormalEvents;
}
sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::operator=(const sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& coRef)
{
   if (this == &coRef) return *this;
   RecogNBestResults = coRef.RecogNBestResults;
   RecogSEMResults = coRef.RecogSEMResults;
   RecogNaviResults = coRef.RecogNaviResults;
   AudioSNR = coRef.AudioSNR;
   BeginofListeningTime = coRef.BeginofListeningTime;
   BeginofSpeechTime = coRef.BeginofSpeechTime;
   EndofSpeechTime = coRef.EndofSpeechTime;
   arrAbnormalEvents = coRef.arrAbnormalEvents;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNBestResults.size(); ++u32Idx)
         RecogNBestResults[u32Idx].vDestroy();
   RecogNBestResults.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < RecogSEMResults.size(); ++u32Idx)
         RecogSEMResults[u32Idx].vDestroy();
   RecogSEMResults.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNaviResults.size(); ++u32Idx)
         RecogNaviResults[u32Idx].vDestroy();
   RecogNaviResults.clear();
   }
   {
   arrAbnormalEvents.clear();
   }
}

sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus()



:AudioSNR(0)
,BeginofListeningTime(0)
,BeginofSpeechTime(0)
,EndofSpeechTime(0)

 {}

tS32 sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::s32GetTypeId() const
{
   return (tS32) sds_rec_recogservicefi_tclToken::EN_MSG_TEST_RECOGRESULTSSTATUS;
}


sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::~sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RecogNBestResults.size(); ++u32ListIdx)
      u32DynamicSize += RecogNBestResults[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RecogSEMResults.size(); ++u32ListIdx)
      u32DynamicSize += RecogSEMResults[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RecogNaviResults.size(); ++u32ListIdx)
      u32DynamicSize += RecogNaviResults[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+32+arrAbnormalEvents.size()*1;
}

fi_tclInContext& sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RecogNBestResults.size(); ++u32Idx)
      {
         RecogNBestResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RecogNBestResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RecogNBestResults[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RecogSEMResults.size(); ++u32Idx)
      {
         RecogSEMResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RecogSEMResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RecogSEMResults[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RecogNaviResults.size(); ++u32Idx)
      {
         RecogNaviResults[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RecogNaviResults.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RecogNaviResults[u32Idx]);
      }
   }
   (tVoid) (oIn >> AudioSNR);
   (tVoid) (oIn >> BeginofListeningTime);
   (tVoid) (oIn >> BeginofSpeechTime);
   (tVoid) (oIn >> EndofSpeechTime);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      arrAbnormalEvents.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arrAbnormalEvents[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RecogNBestResults.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNBestResults.size(); ++u32Idx)
         (tVoid) (oOut << RecogNBestResults[u32Idx]);
   }
   (tVoid) (oOut << (tU32)RecogSEMResults.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RecogSEMResults.size(); ++u32Idx)
         (tVoid) (oOut << RecogSEMResults[u32Idx]);
   }
   (tVoid) (oOut << (tU32)RecogNaviResults.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RecogNaviResults.size(); ++u32Idx)
         (tVoid) (oOut << RecogNaviResults[u32Idx]);
   }
   (tVoid) (oOut << AudioSNR);
   (tVoid) (oOut << BeginofListeningTime);
   (tVoid) (oOut << BeginofSpeechTime);
   (tVoid) (oOut << EndofSpeechTime);
   (tVoid) (oOut << (tU32)arrAbnormalEvents.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arrAbnormalEvents.size(); ++u32Idx)
         (tVoid) (oOut << arrAbnormalEvents[u32Idx]);
   }
   return oOut;
}

tBool sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus::operator==(const sds_rec_recogservicefi_tclMsgTest_RecogResultsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RecogNBestResults.size() == roRef.RecogNBestResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RecogNBestResults.size()); ++u32Idx)
            bResult = bResult && (RecogNBestResults[u32Idx] == roRef.RecogNBestResults[u32Idx]);
      }
      bResult = bResult && (RecogSEMResults.size() == roRef.RecogSEMResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RecogSEMResults.size()); ++u32Idx)
            bResult = bResult && (RecogSEMResults[u32Idx] == roRef.RecogSEMResults[u32Idx]);
      }
      bResult = bResult && (RecogNaviResults.size() == roRef.RecogNaviResults.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RecogNaviResults.size()); ++u32Idx)
            bResult = bResult && (RecogNaviResults[u32Idx] == roRef.RecogNaviResults[u32Idx]);
      }
   bResult = bResult && (AudioSNR == roRef.AudioSNR);
   bResult = bResult && (BeginofListeningTime == roRef.BeginofListeningTime);
   bResult = bResult && (BeginofSpeechTime == roRef.BeginofSpeechTime);
   bResult = bResult && (EndofSpeechTime == roRef.EndofSpeechTime);
      bResult = bResult && (arrAbnormalEvents.size() == roRef.arrAbnormalEvents.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arrAbnormalEvents.size()); ++u32Idx)
            bResult = bResult && (arrAbnormalEvents[u32Idx] == roRef.arrAbnormalEvents[u32Idx]);
      }
   return bResult;
}

