#ifndef __SDS_REC_RECOGSERVICEFIDEBUGVISITOR_H__
#define __SDS_REC_RECOGSERVICEFIDEBUGVISITOR_H__

class MY_DECL sds_rec_recogservicefi_tclPrintVisitor : public sds_rec_recogservicefi_tclVisitorBase {

private:
   /* default constructor */ sds_rec_recogservicefi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_rec_recogservicefi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tBool bDoExpand_BinContainer(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Domain(sds_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_NDSFeatureType(sds_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tVoid vVisit_e32_SSE_ASR_Mode(sds_fi_tcl_e32_SSE_ASR_Mode& o_e32_SSE_ASR_Mode);
   virtual tVoid vVisit_e8_SDSDestinationType(sds_fi_tcl_e8_SDSDestinationType& o_e8_SDSDestinationType);
   virtual tBool bDoExpand_SDSLanguageID(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_NDSID(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SettingsType(sds_fi_tcl_e8_SettingsType& o_e8_SettingsType);
   virtual tVoid vVisit_e8_RecogStatus(sds_fi_tcl_e8_RecogStatus& o_e8_RecogStatus);
   virtual tVoid vVisit_e8_DataCategory(sds_fi_tcl_e8_DataCategory& o_e8_DataCategory);
   virtual tBool bDoExpand_RecogFromFile(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RecogToFile(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_REC_Settings(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_WUWStatus(sds_fi_tcl_e8_WUWStatus& o_e8_WUWStatus);
   virtual tVoid vVisit_u32_FrontEndParam(sds_fi_tcl_u32_FrontEndParam& o_u32_FrontEndParam);
   virtual tVoid vVisit_u32_RecParam(sds_fi_tcl_u32_RecParam& o_u32_RecParam);
   virtual tVoid vVisit_u32_ContextParam(sds_fi_tcl_u32_ContextParam& o_u32_ContextParam);
   virtual tVoid vVisit_e8RecogAbnormalEvents(sds_fi_tcl_e8RecogAbnormalEvents& o_e8RecogAbnormalEvents);
   virtual tVoid vVisit_e8_RecogResultType(sds_fi_tcl_e8_RecogResultType& o_e8_RecogResultType);
   virtual tVoid vVisit_e8_USWTrainingType(sds_fi_tcl_e8_USWTrainingType& o_e8_USWTrainingType);
   virtual tBool bDoExpand_RecogNBestResultWordInfo(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SemConfig(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SemResultSlotInfo(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SemResultInterpretations(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RecogNBestResult(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RecogSemResult(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SDSLocationType(sds_fi_tcl_e8_SDSLocationType& o_e8_SDSLocationType);
   virtual tBool bDoExpand_FrontEndParameter(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RecParameter(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_ContextParameter(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_VoconComponent(sds_fi_tcl_e8_VoconComponent& o_e8_VoconComponent);
   virtual tVoid vVisit_u64_tPVoid(sds_fi_tcl_u64_tPVoid& o_u64_tPVoid);
   virtual tVoid vVisit_e8_VDLCategoryName(sds_fi_tcl_e8_VDLCategoryName& o_e8_VDLCategoryName);
   virtual tBool bDoExpand_NameID(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurrentCountry(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_CurrentState(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDSDestinationEntry(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_RecogNaviNBestResult(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_SDSIDTranscriptionsEntry(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Phoneme(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_DynamicDataStatus(sds_fi_tcl_e8_DynamicDataStatus& o_e8_DynamicDataStatus);
   virtual tBool bDoExpand_DynamicDataStatus(sds_rec_recogservicefi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_rec_recogservicefi_tclRandomInitVisitor : public sds_rec_recogservicefi_tclVisitorBase {
public:

   sds_rec_recogservicefi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_Domain(sds_fi_tcl_e8_Domain& o_e8_Domain);
   virtual tVoid vVisit_e8_NDSFeatureType(sds_fi_tcl_e8_NDSFeatureType& o_e8_NDSFeatureType);
   virtual tVoid vVisit_e32_SSE_ASR_Mode(sds_fi_tcl_e32_SSE_ASR_Mode& o_e32_SSE_ASR_Mode);
   virtual tVoid vVisit_e8_SDSDestinationType(sds_fi_tcl_e8_SDSDestinationType& o_e8_SDSDestinationType);
   virtual tVoid vVisit_e8_SettingsType(sds_fi_tcl_e8_SettingsType& o_e8_SettingsType);
   virtual tVoid vVisit_e8_RecogStatus(sds_fi_tcl_e8_RecogStatus& o_e8_RecogStatus);
   virtual tVoid vVisit_e8_DataCategory(sds_fi_tcl_e8_DataCategory& o_e8_DataCategory);
   virtual tVoid vVisit_e8_WUWStatus(sds_fi_tcl_e8_WUWStatus& o_e8_WUWStatus);
   virtual tVoid vVisit_u32_FrontEndParam(sds_fi_tcl_u32_FrontEndParam& o_u32_FrontEndParam);
   virtual tVoid vVisit_u32_RecParam(sds_fi_tcl_u32_RecParam& o_u32_RecParam);
   virtual tVoid vVisit_u32_ContextParam(sds_fi_tcl_u32_ContextParam& o_u32_ContextParam);
   virtual tVoid vVisit_e8RecogAbnormalEvents(sds_fi_tcl_e8RecogAbnormalEvents& o_e8RecogAbnormalEvents);
   virtual tVoid vVisit_e8_RecogResultType(sds_fi_tcl_e8_RecogResultType& o_e8_RecogResultType);
   virtual tVoid vVisit_e8_USWTrainingType(sds_fi_tcl_e8_USWTrainingType& o_e8_USWTrainingType);
   virtual tVoid vVisit_e8_SDSLocationType(sds_fi_tcl_e8_SDSLocationType& o_e8_SDSLocationType);
   virtual tVoid vVisit_e8_VoconComponent(sds_fi_tcl_e8_VoconComponent& o_e8_VoconComponent);
   virtual tVoid vVisit_u64_tPVoid(sds_fi_tcl_u64_tPVoid& o_u64_tPVoid);
   virtual tVoid vVisit_e8_VDLCategoryName(sds_fi_tcl_e8_VDLCategoryName& o_e8_VDLCategoryName);
   virtual tVoid vVisit_e8_DynamicDataStatus(sds_fi_tcl_e8_DynamicDataStatus& o_e8_DynamicDataStatus);
	tU32 u32ListSize;
};

#endif
