/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_PROMPTPLAYER_FI message types

fi_tclMessageBase* sds_promptplayerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgSetSpeakerMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgSetSpeakerMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgReleaseDataMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgReleaseDataMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgPlayMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTFIRST:
         return OSAL_NEW sds_promptplayerfi_tclMsgPlayMethodResultFirst;

      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTMIDDLE:
         return OSAL_NEW sds_promptplayerfi_tclMsgPlayMethodResultMiddle;

      case sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTLAST:
         return OSAL_NEW sds_promptplayerfi_tclMsgPlayMethodResultLast;

      case sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgStopMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgStopMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgPauseMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgPauseMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgResumeMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgResumeMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgtesttestMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgtesttestMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgSet2DefaultMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgSet2DefaultMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgVoiceAdviceMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgVoiceAdviceMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODSTART:
         return OSAL_NEW sds_promptplayerfi_tclMsgInitializeMethodStart;

      case sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODRESULT:
         return OSAL_NEW sds_promptplayerfi_tclMsgInitializeMethodResult;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataMemoryGet;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataMemoryStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataFormatGet;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataFormatUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataFormatStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataSettingsGet;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataSettingsStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterStatusGet;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterStatusUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterStatusRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterStatusStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterSWVersionGet;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterSWVersionUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgPrompterSWVersionStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeakerGet;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeakerUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeakerRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEAKERSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeakerStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableSpeakersGet;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableSpeakersUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableSpeakersStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataCustomerGet;

      case sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgSpeechDataCustomerStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgDlgApplicationsGet;

      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgDlgApplicationsUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgDlgApplicationsStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptLengthGet;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptLengthUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHRELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptLengthRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSET:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptLengthSet;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptLengthStatus;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEGET:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptListFlagUpdateGet;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATERELUPREG:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESET:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptListFlagUpdateSet;

      case sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESTATUS:
         return OSAL_NEW sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_promptplayerfifi messages

// common functions

tU16 sds_promptplayerfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_PROMPTPLAYERFI_C_U16_SERVICE_ID;
}

tU16 sds_promptplayerfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_promptplayerfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_promptplayerfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_promptplayerfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_promptplayerfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_promptplayerfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSetSpeakerMethodStart::sds_promptplayerfi_tclMsgSetSpeakerMethodStart(const sds_promptplayerfi_tclMsgSetSpeakerMethodStart& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   Speaker = coRef.Speaker;
}
sds_promptplayerfi_tclMsgSetSpeakerMethodStart& sds_promptplayerfi_tclMsgSetSpeakerMethodStart::operator=(const sds_promptplayerfi_tclMsgSetSpeakerMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Speaker = coRef.Speaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgSetSpeakerMethodStart::vDestroy()
{
   Speaker.vDestroy(); 
}

sds_promptplayerfi_tclMsgSetSpeakerMethodStart::sds_promptplayerfi_tclMsgSetSpeakerMethodStart()
:Speaker()
 {}

tS32 sds_promptplayerfi_tclMsgSetSpeakerMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODSTART;
}


sds_promptplayerfi_tclMsgSetSpeakerMethodStart::~sds_promptplayerfi_tclMsgSetSpeakerMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgSetSpeakerMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Speaker.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_promptplayerfi_tclMsgSetSpeakerMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Speaker);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSetSpeakerMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Speaker);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSetSpeakerMethodStart::operator==(const sds_promptplayerfi_tclMsgSetSpeakerMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Speaker == roRef.Speaker);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgSetSpeakerMethodResult::sds_promptplayerfi_tclMsgSetSpeakerMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgSetSpeakerMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SETSPEAKERMETHODRESULT;
}


sds_promptplayerfi_tclMsgSetSpeakerMethodResult::~sds_promptplayerfi_tclMsgSetSpeakerMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   FileName = coRef.FileName;
   StartAddress = coRef.StartAddress;
   NoOfBytes = coRef.NoOfBytes;
}
sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::operator=(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   FileName = coRef.FileName;
   StartAddress = coRef.StartAddress;
   NoOfBytes = coRef.NoOfBytes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::vDestroy()
{
   FileName.vDestroy();
}

sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart()
:FileName()
,StartAddress(0)
,NoOfBytes(0)
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODSTART;
}


sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::~sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+FileName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FileName);
   (tVoid) (oIn >> StartAddress);
   (tVoid) (oIn >> NoOfBytes);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FileName);
   (tVoid) (oOut << StartAddress);
   (tVoid) (oOut << NoOfBytes);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart::operator==(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FileName == roRef.FileName);
   bResult = bResult && (StartAddress == roRef.StartAddress);
   bResult = bResult && (NoOfBytes == roRef.NoOfBytes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   SD_Contents = coRef.SD_Contents;
}
sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::operator=(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SD_Contents = coRef.SD_Contents;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::vDestroy()
{
   {
   SD_Contents.clear();
   }
}

sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult()

 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACONTENTSMETHODRESULT;
}


sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::~sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+SD_Contents.size()*1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SD_Contents.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SD_Contents[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SD_Contents.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SD_Contents.size(); ++u32Idx)
         (tVoid) (oOut << SD_Contents[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult::operator==(const sds_promptplayerfi_tclMsgSpeechDataContentsMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SD_Contents.size() == roRef.SD_Contents.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SD_Contents.size()); ++u32Idx)
            bResult = bResult && (SD_Contents[u32Idx] == roRef.SD_Contents[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgReleaseDataMethodStart::sds_promptplayerfi_tclMsgReleaseDataMethodStart(const sds_promptplayerfi_tclMsgReleaseDataMethodStart& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   ReleaseType = coRef.ReleaseType;
}
sds_promptplayerfi_tclMsgReleaseDataMethodStart& sds_promptplayerfi_tclMsgReleaseDataMethodStart::operator=(const sds_promptplayerfi_tclMsgReleaseDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ReleaseType = coRef.ReleaseType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgReleaseDataMethodStart::sds_promptplayerfi_tclMsgReleaseDataMethodStart()
:ReleaseType()
 {}

tS32 sds_promptplayerfi_tclMsgReleaseDataMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODSTART;
}


sds_promptplayerfi_tclMsgReleaseDataMethodStart::~sds_promptplayerfi_tclMsgReleaseDataMethodStart()
{}

tU32 sds_promptplayerfi_tclMsgReleaseDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgReleaseDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReleaseType);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgReleaseDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReleaseType);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgReleaseDataMethodStart::operator==(const sds_promptplayerfi_tclMsgReleaseDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReleaseType == roRef.ReleaseType);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgReleaseDataMethodResult::sds_promptplayerfi_tclMsgReleaseDataMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgReleaseDataMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_RELEASEDATAMETHODRESULT;
}


sds_promptplayerfi_tclMsgReleaseDataMethodResult::~sds_promptplayerfi_tclMsgReleaseDataMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart(const sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   DlgApplication = coRef.DlgApplication;
}
sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::operator=(const sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DlgApplication = coRef.DlgApplication;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart()
:DlgApplication()
 {}

tS32 sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODSTART;
}


sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::~sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart()
{}

tU32 sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DlgApplication);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DlgApplication);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart::operator==(const sds_promptplayerfi_tclMsgSetDlgApplicationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DlgApplication == roRef.DlgApplication);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult::sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SETDLGAPPLICATIONMETHODRESULT;
}


sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult::~sds_promptplayerfi_tclMsgSetDlgApplicationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPlayMethodStart::sds_promptplayerfi_tclMsgPlayMethodStart(const sds_promptplayerfi_tclMsgPlayMethodStart& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   SentenceID = coRef.SentenceID;
   PhraseVariables = coRef.PhraseVariables;
}
sds_promptplayerfi_tclMsgPlayMethodStart& sds_promptplayerfi_tclMsgPlayMethodStart::operator=(const sds_promptplayerfi_tclMsgPlayMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SentenceID = coRef.SentenceID;
   PhraseVariables = coRef.PhraseVariables;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgPlayMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PhraseVariables.size(); ++u32Idx)
         PhraseVariables[u32Idx].vDestroy();
   PhraseVariables.clear();
   }
}

sds_promptplayerfi_tclMsgPlayMethodStart::sds_promptplayerfi_tclMsgPlayMethodStart()
:SentenceID(0)

 {}

tS32 sds_promptplayerfi_tclMsgPlayMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODSTART;
}


sds_promptplayerfi_tclMsgPlayMethodStart::~sds_promptplayerfi_tclMsgPlayMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgPlayMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhraseVariables.size(); ++u32ListIdx)
      u32DynamicSize += PhraseVariables[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& sds_promptplayerfi_tclMsgPlayMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SentenceID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhraseVariables.size(); ++u32Idx)
      {
         PhraseVariables[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhraseVariables.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhraseVariables[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPlayMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SentenceID);
   (tVoid) (oOut << (tU32)PhraseVariables.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhraseVariables.size(); ++u32Idx)
         (tVoid) (oOut << PhraseVariables[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPlayMethodStart::operator==(const sds_promptplayerfi_tclMsgPlayMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SentenceID == roRef.SentenceID);
      bResult = bResult && (PhraseVariables.size() == roRef.PhraseVariables.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhraseVariables.size()); ++u32Idx)
            bResult = bResult && (PhraseVariables[u32Idx] == roRef.PhraseVariables[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPlayMethodResultFirst::sds_promptplayerfi_tclMsgPlayMethodResultFirst(const sds_promptplayerfi_tclMsgPlayMethodResultFirst& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PlayProgress = coRef.PlayProgress;
}
sds_promptplayerfi_tclMsgPlayMethodResultFirst& sds_promptplayerfi_tclMsgPlayMethodResultFirst::operator=(const sds_promptplayerfi_tclMsgPlayMethodResultFirst& coRef)
{
   if (this == &coRef) return *this;
   PlayProgress = coRef.PlayProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgPlayMethodResultFirst::vDestroy()
{
   PlayProgress.vDestroy(); 
}

sds_promptplayerfi_tclMsgPlayMethodResultFirst::sds_promptplayerfi_tclMsgPlayMethodResultFirst()
:PlayProgress()
 {}

tS32 sds_promptplayerfi_tclMsgPlayMethodResultFirst::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTFIRST;
}


sds_promptplayerfi_tclMsgPlayMethodResultFirst::~sds_promptplayerfi_tclMsgPlayMethodResultFirst()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgPlayMethodResultFirst::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+PlayProgress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_promptplayerfi_tclMsgPlayMethodResultFirst::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PlayProgress);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPlayMethodResultFirst::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PlayProgress);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPlayMethodResultFirst::operator==(const sds_promptplayerfi_tclMsgPlayMethodResultFirst& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PlayProgress == roRef.PlayProgress);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPlayMethodResultMiddle::sds_promptplayerfi_tclMsgPlayMethodResultMiddle(const sds_promptplayerfi_tclMsgPlayMethodResultMiddle& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PlayProgress = coRef.PlayProgress;
}
sds_promptplayerfi_tclMsgPlayMethodResultMiddle& sds_promptplayerfi_tclMsgPlayMethodResultMiddle::operator=(const sds_promptplayerfi_tclMsgPlayMethodResultMiddle& coRef)
{
   if (this == &coRef) return *this;
   PlayProgress = coRef.PlayProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgPlayMethodResultMiddle::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PlayProgress.size(); ++u32Idx)
         PlayProgress[u32Idx].vDestroy();
   PlayProgress.clear();
   }
}

sds_promptplayerfi_tclMsgPlayMethodResultMiddle::sds_promptplayerfi_tclMsgPlayMethodResultMiddle()

 {}

tS32 sds_promptplayerfi_tclMsgPlayMethodResultMiddle::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTMIDDLE;
}


sds_promptplayerfi_tclMsgPlayMethodResultMiddle::~sds_promptplayerfi_tclMsgPlayMethodResultMiddle()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgPlayMethodResultMiddle::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PlayProgress.size(); ++u32ListIdx)
      u32DynamicSize += PlayProgress[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_promptplayerfi_tclMsgPlayMethodResultMiddle::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PlayProgress.size(); ++u32Idx)
      {
         PlayProgress[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PlayProgress.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PlayProgress[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPlayMethodResultMiddle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PlayProgress.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PlayProgress.size(); ++u32Idx)
         (tVoid) (oOut << PlayProgress[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPlayMethodResultMiddle::operator==(const sds_promptplayerfi_tclMsgPlayMethodResultMiddle& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PlayProgress.size() == roRef.PlayProgress.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PlayProgress.size()); ++u32Idx)
            bResult = bResult && (PlayProgress[u32Idx] == roRef.PlayProgress[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPlayMethodResultLast::sds_promptplayerfi_tclMsgPlayMethodResultLast(const sds_promptplayerfi_tclMsgPlayMethodResultLast& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PlayProgress = coRef.PlayProgress;
}
sds_promptplayerfi_tclMsgPlayMethodResultLast& sds_promptplayerfi_tclMsgPlayMethodResultLast::operator=(const sds_promptplayerfi_tclMsgPlayMethodResultLast& coRef)
{
   if (this == &coRef) return *this;
   PlayProgress = coRef.PlayProgress;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgPlayMethodResultLast::vDestroy()
{
   PlayProgress.vDestroy(); 
}

sds_promptplayerfi_tclMsgPlayMethodResultLast::sds_promptplayerfi_tclMsgPlayMethodResultLast()
:PlayProgress()
 {}

tS32 sds_promptplayerfi_tclMsgPlayMethodResultLast::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PLAYMETHODRESULTLAST;
}


sds_promptplayerfi_tclMsgPlayMethodResultLast::~sds_promptplayerfi_tclMsgPlayMethodResultLast()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgPlayMethodResultLast::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+PlayProgress.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_promptplayerfi_tclMsgPlayMethodResultLast::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PlayProgress);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPlayMethodResultLast::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PlayProgress);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPlayMethodResultLast::operator==(const sds_promptplayerfi_tclMsgPlayMethodResultLast& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PlayProgress == roRef.PlayProgress);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgStopMethodStart::sds_promptplayerfi_tclMsgStopMethodStart()
 {}

tS32 sds_promptplayerfi_tclMsgStopMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODSTART;
}


sds_promptplayerfi_tclMsgStopMethodStart::~sds_promptplayerfi_tclMsgStopMethodStart()
{}

//=============================================================================

sds_promptplayerfi_tclMsgStopMethodResult::sds_promptplayerfi_tclMsgStopMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgStopMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_STOPMETHODRESULT;
}


sds_promptplayerfi_tclMsgStopMethodResult::~sds_promptplayerfi_tclMsgStopMethodResult()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPauseMethodStart::sds_promptplayerfi_tclMsgPauseMethodStart()
 {}

tS32 sds_promptplayerfi_tclMsgPauseMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODSTART;
}


sds_promptplayerfi_tclMsgPauseMethodStart::~sds_promptplayerfi_tclMsgPauseMethodStart()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPauseMethodResult::sds_promptplayerfi_tclMsgPauseMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgPauseMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PAUSEMETHODRESULT;
}


sds_promptplayerfi_tclMsgPauseMethodResult::~sds_promptplayerfi_tclMsgPauseMethodResult()
{}

//=============================================================================

sds_promptplayerfi_tclMsgResumeMethodStart::sds_promptplayerfi_tclMsgResumeMethodStart()
 {}

tS32 sds_promptplayerfi_tclMsgResumeMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODSTART;
}


sds_promptplayerfi_tclMsgResumeMethodStart::~sds_promptplayerfi_tclMsgResumeMethodStart()
{}

//=============================================================================

sds_promptplayerfi_tclMsgResumeMethodResult::sds_promptplayerfi_tclMsgResumeMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgResumeMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_RESUMEMETHODRESULT;
}


sds_promptplayerfi_tclMsgResumeMethodResult::~sds_promptplayerfi_tclMsgResumeMethodResult()
{}

//=============================================================================

sds_promptplayerfi_tclMsgtesttestMethodStart::sds_promptplayerfi_tclMsgtesttestMethodStart()
 {}

tS32 sds_promptplayerfi_tclMsgtesttestMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODSTART;
}


sds_promptplayerfi_tclMsgtesttestMethodStart::~sds_promptplayerfi_tclMsgtesttestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgtesttestMethodResult::sds_promptplayerfi_tclMsgtesttestMethodResult(const sds_promptplayerfi_tclMsgtesttestMethodResult& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   abctest = coRef.abctest;
}
sds_promptplayerfi_tclMsgtesttestMethodResult& sds_promptplayerfi_tclMsgtesttestMethodResult::operator=(const sds_promptplayerfi_tclMsgtesttestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   abctest = coRef.abctest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgtesttestMethodResult::sds_promptplayerfi_tclMsgtesttestMethodResult()
:abctest(0)
 {}

tS32 sds_promptplayerfi_tclMsgtesttestMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_TESTTESTMETHODRESULT;
}


sds_promptplayerfi_tclMsgtesttestMethodResult::~sds_promptplayerfi_tclMsgtesttestMethodResult()
{}

tU32 sds_promptplayerfi_tclMsgtesttestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_promptplayerfi_tclMsgtesttestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> abctest);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgtesttestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << abctest);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgtesttestMethodResult::operator==(const sds_promptplayerfi_tclMsgtesttestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (abctest == roRef.abctest);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgSet2DefaultMethodStart::sds_promptplayerfi_tclMsgSet2DefaultMethodStart()
 {}

tS32 sds_promptplayerfi_tclMsgSet2DefaultMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODSTART;
}


sds_promptplayerfi_tclMsgSet2DefaultMethodStart::~sds_promptplayerfi_tclMsgSet2DefaultMethodStart()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSet2DefaultMethodResult::sds_promptplayerfi_tclMsgSet2DefaultMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgSet2DefaultMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SET2DEFAULTMETHODRESULT;
}


sds_promptplayerfi_tclMsgSet2DefaultMethodResult::~sds_promptplayerfi_tclMsgSet2DefaultMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::sds_promptplayerfi_tclMsgVoiceAdviceMethodStart(const sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   AudioChannelAdvice = coRef.AudioChannelAdvice;
}
sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::operator=(const sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AudioChannelAdvice = coRef.AudioChannelAdvice;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::vDestroy()
{
   AudioChannelAdvice.vDestroy(); 
}

sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::sds_promptplayerfi_tclMsgVoiceAdviceMethodStart()
:AudioChannelAdvice()
 {}

tS32 sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODSTART;
}


sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::~sds_promptplayerfi_tclMsgVoiceAdviceMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+AudioChannelAdvice.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioChannelAdvice);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioChannelAdvice);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgVoiceAdviceMethodStart::operator==(const sds_promptplayerfi_tclMsgVoiceAdviceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioChannelAdvice == roRef.AudioChannelAdvice);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgVoiceAdviceMethodResult::sds_promptplayerfi_tclMsgVoiceAdviceMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgVoiceAdviceMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_VOICEADVICEMETHODRESULT;
}


sds_promptplayerfi_tclMsgVoiceAdviceMethodResult::~sds_promptplayerfi_tclMsgVoiceAdviceMethodResult()
{}

//=============================================================================

sds_promptplayerfi_tclMsgInitializeMethodStart::sds_promptplayerfi_tclMsgInitializeMethodStart()
 {}

tS32 sds_promptplayerfi_tclMsgInitializeMethodStart::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODSTART;
}


sds_promptplayerfi_tclMsgInitializeMethodStart::~sds_promptplayerfi_tclMsgInitializeMethodStart()
{}

//=============================================================================

sds_promptplayerfi_tclMsgInitializeMethodResult::sds_promptplayerfi_tclMsgInitializeMethodResult()
 {}

tS32 sds_promptplayerfi_tclMsgInitializeMethodResult::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_INITIALIZEMETHODRESULT;
}


sds_promptplayerfi_tclMsgInitializeMethodResult::~sds_promptplayerfi_tclMsgInitializeMethodResult()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataMemoryGet::sds_promptplayerfi_tclMsgSpeechDataMemoryGet()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataMemoryGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYGET;
}


sds_promptplayerfi_tclMsgSpeechDataMemoryGet::~sds_promptplayerfi_tclMsgSpeechDataMemoryGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg::sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYUPREG;
}


sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg::~sds_promptplayerfi_tclMsgSpeechDataMemoryUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg::sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYRELUPREG;
}


sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg::~sds_promptplayerfi_tclMsgSpeechDataMemoryRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::sds_promptplayerfi_tclMsgSpeechDataMemoryStatus(const sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   SD_MB_Size = coRef.SD_MB_Size;
}
sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::operator=(const sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_MB_Size = coRef.SD_MB_Size;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::sds_promptplayerfi_tclMsgSpeechDataMemoryStatus()
:SD_MB_Size(0)
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAMEMORYSTATUS;
}


sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::~sds_promptplayerfi_tclMsgSpeechDataMemoryStatus()
{}

tU32 sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_MB_Size);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_MB_Size);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSpeechDataMemoryStatus::operator==(const sds_promptplayerfi_tclMsgSpeechDataMemoryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_MB_Size == roRef.SD_MB_Size);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataFormatGet::sds_promptplayerfi_tclMsgSpeechDataFormatGet()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataFormatGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATGET;
}


sds_promptplayerfi_tclMsgSpeechDataFormatGet::~sds_promptplayerfi_tclMsgSpeechDataFormatGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataFormatUpReg::sds_promptplayerfi_tclMsgSpeechDataFormatUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataFormatUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATUPREG;
}


sds_promptplayerfi_tclMsgSpeechDataFormatUpReg::~sds_promptplayerfi_tclMsgSpeechDataFormatUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg::sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATRELUPREG;
}


sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg::~sds_promptplayerfi_tclMsgSpeechDataFormatRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSpeechDataFormatStatus::sds_promptplayerfi_tclMsgSpeechDataFormatStatus(const sds_promptplayerfi_tclMsgSpeechDataFormatStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   SD_Format = coRef.SD_Format;
}
sds_promptplayerfi_tclMsgSpeechDataFormatStatus& sds_promptplayerfi_tclMsgSpeechDataFormatStatus::operator=(const sds_promptplayerfi_tclMsgSpeechDataFormatStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_Format = coRef.SD_Format;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgSpeechDataFormatStatus::sds_promptplayerfi_tclMsgSpeechDataFormatStatus()
:SD_Format()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataFormatStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATAFORMATSTATUS;
}


sds_promptplayerfi_tclMsgSpeechDataFormatStatus::~sds_promptplayerfi_tclMsgSpeechDataFormatStatus()
{}

tU32 sds_promptplayerfi_tclMsgSpeechDataFormatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgSpeechDataFormatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_Format);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSpeechDataFormatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_Format);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSpeechDataFormatStatus::operator==(const sds_promptplayerfi_tclMsgSpeechDataFormatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_Format == roRef.SD_Format);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataSettingsGet::sds_promptplayerfi_tclMsgSpeechDataSettingsGet()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataSettingsGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSGET;
}


sds_promptplayerfi_tclMsgSpeechDataSettingsGet::~sds_promptplayerfi_tclMsgSpeechDataSettingsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::sds_promptplayerfi_tclMsgSpeechDataSettingsStatus(const sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   SD_Settings = coRef.SD_Settings;
}
sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::operator=(const sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_Settings = coRef.SD_Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::sds_promptplayerfi_tclMsgSpeechDataSettingsStatus()
:SD_Settings()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATASETTINGSSTATUS;
}


sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::~sds_promptplayerfi_tclMsgSpeechDataSettingsStatus()
{}

tU32 sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SD_Settings);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SD_Settings);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSpeechDataSettingsStatus::operator==(const sds_promptplayerfi_tclMsgSpeechDataSettingsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SD_Settings == roRef.SD_Settings);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgPrompterStatusGet::sds_promptplayerfi_tclMsgPrompterStatusGet()
 {}

tS32 sds_promptplayerfi_tclMsgPrompterStatusGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSGET;
}


sds_promptplayerfi_tclMsgPrompterStatusGet::~sds_promptplayerfi_tclMsgPrompterStatusGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPrompterStatusUpReg::sds_promptplayerfi_tclMsgPrompterStatusUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPrompterStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSUPREG;
}


sds_promptplayerfi_tclMsgPrompterStatusUpReg::~sds_promptplayerfi_tclMsgPrompterStatusUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPrompterStatusRelUpReg::sds_promptplayerfi_tclMsgPrompterStatusRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPrompterStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSRELUPREG;
}


sds_promptplayerfi_tclMsgPrompterStatusRelUpReg::~sds_promptplayerfi_tclMsgPrompterStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPrompterStatusStatus::sds_promptplayerfi_tclMsgPrompterStatusStatus(const sds_promptplayerfi_tclMsgPrompterStatusStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PP_Status = coRef.PP_Status;
   PromptID = coRef.PromptID;
}
sds_promptplayerfi_tclMsgPrompterStatusStatus& sds_promptplayerfi_tclMsgPrompterStatusStatus::operator=(const sds_promptplayerfi_tclMsgPrompterStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   PP_Status = coRef.PP_Status;
   PromptID = coRef.PromptID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgPrompterStatusStatus::sds_promptplayerfi_tclMsgPrompterStatusStatus()
:PP_Status()
,PromptID(0)
 {}

tS32 sds_promptplayerfi_tclMsgPrompterStatusStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSTATUSSTATUS;
}


sds_promptplayerfi_tclMsgPrompterStatusStatus::~sds_promptplayerfi_tclMsgPrompterStatusStatus()
{}

tU32 sds_promptplayerfi_tclMsgPrompterStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds_promptplayerfi_tclMsgPrompterStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PP_Status);
   (tVoid) (oIn >> PromptID);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPrompterStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PP_Status);
   (tVoid) (oOut << PromptID);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPrompterStatusStatus::operator==(const sds_promptplayerfi_tclMsgPrompterStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PP_Status == roRef.PP_Status);
   bResult = bResult && (PromptID == roRef.PromptID);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgPrompterSWVersionGet::sds_promptplayerfi_tclMsgPrompterSWVersionGet()
 {}

tS32 sds_promptplayerfi_tclMsgPrompterSWVersionGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONGET;
}


sds_promptplayerfi_tclMsgPrompterSWVersionGet::~sds_promptplayerfi_tclMsgPrompterSWVersionGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPrompterSWVersionUpReg::sds_promptplayerfi_tclMsgPrompterSWVersionUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPrompterSWVersionUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONUPREG;
}


sds_promptplayerfi_tclMsgPrompterSWVersionUpReg::~sds_promptplayerfi_tclMsgPrompterSWVersionUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg::sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONRELUPREG;
}


sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg::~sds_promptplayerfi_tclMsgPrompterSWVersionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPrompterSWVersionStatus::sds_promptplayerfi_tclMsgPrompterSWVersionStatus(const sds_promptplayerfi_tclMsgPrompterSWVersionStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   sPPVersion = coRef.sPPVersion;
}
sds_promptplayerfi_tclMsgPrompterSWVersionStatus& sds_promptplayerfi_tclMsgPrompterSWVersionStatus::operator=(const sds_promptplayerfi_tclMsgPrompterSWVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   sPPVersion = coRef.sPPVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgPrompterSWVersionStatus::vDestroy()
{
   sPPVersion.vDestroy();
}

sds_promptplayerfi_tclMsgPrompterSWVersionStatus::sds_promptplayerfi_tclMsgPrompterSWVersionStatus()
:sPPVersion()
 {}

tS32 sds_promptplayerfi_tclMsgPrompterSWVersionStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTERSWVERSIONSTATUS;
}


sds_promptplayerfi_tclMsgPrompterSWVersionStatus::~sds_promptplayerfi_tclMsgPrompterSWVersionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgPrompterSWVersionStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sPPVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_promptplayerfi_tclMsgPrompterSWVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPPVersion);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPrompterSWVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPPVersion);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPrompterSWVersionStatus::operator==(const sds_promptplayerfi_tclMsgPrompterSWVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPPVersion == roRef.sPPVersion);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgSpeakerGet::sds_promptplayerfi_tclMsgSpeakerGet()
 {}

tS32 sds_promptplayerfi_tclMsgSpeakerGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEAKERGET;
}


sds_promptplayerfi_tclMsgSpeakerGet::~sds_promptplayerfi_tclMsgSpeakerGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSpeakerUpReg::sds_promptplayerfi_tclMsgSpeakerUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgSpeakerUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEAKERUPREG;
}


sds_promptplayerfi_tclMsgSpeakerUpReg::~sds_promptplayerfi_tclMsgSpeakerUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgSpeakerRelUpReg::sds_promptplayerfi_tclMsgSpeakerRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgSpeakerRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEAKERRELUPREG;
}


sds_promptplayerfi_tclMsgSpeakerRelUpReg::~sds_promptplayerfi_tclMsgSpeakerRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSpeakerStatus::sds_promptplayerfi_tclMsgSpeakerStatus(const sds_promptplayerfi_tclMsgSpeakerStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   Speaker = coRef.Speaker;
}
sds_promptplayerfi_tclMsgSpeakerStatus& sds_promptplayerfi_tclMsgSpeakerStatus::operator=(const sds_promptplayerfi_tclMsgSpeakerStatus& coRef)
{
   if (this == &coRef) return *this;
   Speaker = coRef.Speaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgSpeakerStatus::vDestroy()
{
   Speaker.vDestroy(); 
}

sds_promptplayerfi_tclMsgSpeakerStatus::sds_promptplayerfi_tclMsgSpeakerStatus()
:Speaker()
 {}

tS32 sds_promptplayerfi_tclMsgSpeakerStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEAKERSTATUS;
}


sds_promptplayerfi_tclMsgSpeakerStatus::~sds_promptplayerfi_tclMsgSpeakerStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgSpeakerStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Speaker.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_promptplayerfi_tclMsgSpeakerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Speaker);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSpeakerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Speaker);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSpeakerStatus::operator==(const sds_promptplayerfi_tclMsgSpeakerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Speaker == roRef.Speaker);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgAvailableSpeakersGet::sds_promptplayerfi_tclMsgAvailableSpeakersGet()
 {}

tS32 sds_promptplayerfi_tclMsgAvailableSpeakersGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSGET;
}


sds_promptplayerfi_tclMsgAvailableSpeakersGet::~sds_promptplayerfi_tclMsgAvailableSpeakersGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgAvailableSpeakersUpReg::sds_promptplayerfi_tclMsgAvailableSpeakersUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgAvailableSpeakersUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSUPREG;
}


sds_promptplayerfi_tclMsgAvailableSpeakersUpReg::~sds_promptplayerfi_tclMsgAvailableSpeakersUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg::sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSRELUPREG;
}


sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg::~sds_promptplayerfi_tclMsgAvailableSpeakersRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgAvailableSpeakersStatus::sds_promptplayerfi_tclMsgAvailableSpeakersStatus(const sds_promptplayerfi_tclMsgAvailableSpeakersStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   AvailableSpeakers = coRef.AvailableSpeakers;
}
sds_promptplayerfi_tclMsgAvailableSpeakersStatus& sds_promptplayerfi_tclMsgAvailableSpeakersStatus::operator=(const sds_promptplayerfi_tclMsgAvailableSpeakersStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailableSpeakers = coRef.AvailableSpeakers;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgAvailableSpeakersStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableSpeakers.size(); ++u32Idx)
         AvailableSpeakers[u32Idx].vDestroy();
   AvailableSpeakers.clear();
   }
}

sds_promptplayerfi_tclMsgAvailableSpeakersStatus::sds_promptplayerfi_tclMsgAvailableSpeakersStatus()

 {}

tS32 sds_promptplayerfi_tclMsgAvailableSpeakersStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLESPEAKERSSTATUS;
}


sds_promptplayerfi_tclMsgAvailableSpeakersStatus::~sds_promptplayerfi_tclMsgAvailableSpeakersStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgAvailableSpeakersStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailableSpeakers.size(); ++u32ListIdx)
      u32DynamicSize += AvailableSpeakers[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_promptplayerfi_tclMsgAvailableSpeakersStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableSpeakers.size(); ++u32Idx)
      {
         AvailableSpeakers[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableSpeakers.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableSpeakers[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgAvailableSpeakersStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableSpeakers.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableSpeakers.size(); ++u32Idx)
         (tVoid) (oOut << AvailableSpeakers[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgAvailableSpeakersStatus::operator==(const sds_promptplayerfi_tclMsgAvailableSpeakersStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableSpeakers.size() == roRef.AvailableSpeakers.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableSpeakers.size()); ++u32Idx)
            bResult = bResult && (AvailableSpeakers[u32Idx] == roRef.AvailableSpeakers[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgSpeechDataCustomerGet::sds_promptplayerfi_tclMsgSpeechDataCustomerGet()
 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataCustomerGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERGET;
}


sds_promptplayerfi_tclMsgSpeechDataCustomerGet::~sds_promptplayerfi_tclMsgSpeechDataCustomerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::sds_promptplayerfi_tclMsgSpeechDataCustomerStatus(const sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   SD_CustomerIDs = coRef.SD_CustomerIDs;
}
sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::operator=(const sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& coRef)
{
   if (this == &coRef) return *this;
   SD_CustomerIDs = coRef.SD_CustomerIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::vDestroy()
{
   {
   SD_CustomerIDs.clear();
   }
}

sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::sds_promptplayerfi_tclMsgSpeechDataCustomerStatus()

 {}

tS32 sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_SPEECHDATACUSTOMERSTATUS;
}


sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::~sds_promptplayerfi_tclMsgSpeechDataCustomerStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+SD_CustomerIDs.size()*4;
}

fi_tclInContext& sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SD_CustomerIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SD_CustomerIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SD_CustomerIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SD_CustomerIDs.size(); ++u32Idx)
         (tVoid) (oOut << SD_CustomerIDs[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgSpeechDataCustomerStatus::operator==(const sds_promptplayerfi_tclMsgSpeechDataCustomerStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SD_CustomerIDs.size() == roRef.SD_CustomerIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SD_CustomerIDs.size()); ++u32Idx)
            bResult = bResult && (SD_CustomerIDs[u32Idx] == roRef.SD_CustomerIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet::sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet()
 {}

tS32 sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSGET;
}


sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet::~sds_promptplayerfi_tclMsgAvailableDlgApplicationsGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg::sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSUPREG;
}


sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg::~sds_promptplayerfi_tclMsgAvailableDlgApplicationsUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg::sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSRELUPREG;
}


sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg::~sds_promptplayerfi_tclMsgAvailableDlgApplicationsRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   AvailableDlgApps = coRef.AvailableDlgApps;
}
sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::operator=(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& coRef)
{
   if (this == &coRef) return *this;
   AvailableDlgApps = coRef.AvailableDlgApps;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::vDestroy()
{
   {
   AvailableDlgApps.clear();
   }
}

sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus()

 {}

tS32 sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_AVAILABLEDLGAPPLICATIONSSTATUS;
}


sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::~sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+AvailableDlgApps.size()*1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      AvailableDlgApps.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableDlgApps[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableDlgApps.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableDlgApps.size(); ++u32Idx)
         (tVoid) (oOut << AvailableDlgApps[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus::operator==(const sds_promptplayerfi_tclMsgAvailableDlgApplicationsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableDlgApps.size() == roRef.AvailableDlgApps.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableDlgApps.size()); ++u32Idx)
            bResult = bResult && (AvailableDlgApps[u32Idx] == roRef.AvailableDlgApps[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgDlgApplicationsGet::sds_promptplayerfi_tclMsgDlgApplicationsGet()
 {}

tS32 sds_promptplayerfi_tclMsgDlgApplicationsGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSGET;
}


sds_promptplayerfi_tclMsgDlgApplicationsGet::~sds_promptplayerfi_tclMsgDlgApplicationsGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgDlgApplicationsUpReg::sds_promptplayerfi_tclMsgDlgApplicationsUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgDlgApplicationsUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSUPREG;
}


sds_promptplayerfi_tclMsgDlgApplicationsUpReg::~sds_promptplayerfi_tclMsgDlgApplicationsUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg::sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSRELUPREG;
}


sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg::~sds_promptplayerfi_tclMsgDlgApplicationsRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgDlgApplicationsStatus::sds_promptplayerfi_tclMsgDlgApplicationsStatus(const sds_promptplayerfi_tclMsgDlgApplicationsStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   DlgApps = coRef.DlgApps;
}
sds_promptplayerfi_tclMsgDlgApplicationsStatus& sds_promptplayerfi_tclMsgDlgApplicationsStatus::operator=(const sds_promptplayerfi_tclMsgDlgApplicationsStatus& coRef)
{
   if (this == &coRef) return *this;
   DlgApps = coRef.DlgApps;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgDlgApplicationsStatus::vDestroy()
{
   {
   DlgApps.clear();
   }
}

sds_promptplayerfi_tclMsgDlgApplicationsStatus::sds_promptplayerfi_tclMsgDlgApplicationsStatus()

 {}

tS32 sds_promptplayerfi_tclMsgDlgApplicationsStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_DLGAPPLICATIONSSTATUS;
}


sds_promptplayerfi_tclMsgDlgApplicationsStatus::~sds_promptplayerfi_tclMsgDlgApplicationsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgDlgApplicationsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+DlgApps.size()*1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgDlgApplicationsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DlgApps.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DlgApps[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgDlgApplicationsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DlgApps.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DlgApps.size(); ++u32Idx)
         (tVoid) (oOut << DlgApps[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgDlgApplicationsStatus::operator==(const sds_promptplayerfi_tclMsgDlgApplicationsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DlgApps.size() == roRef.DlgApps.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DlgApps.size()); ++u32Idx)
            bResult = bResult && (DlgApps[u32Idx] == roRef.DlgApps[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgPromptLengthGet::sds_promptplayerfi_tclMsgPromptLengthGet()
 {}

tS32 sds_promptplayerfi_tclMsgPromptLengthGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHGET;
}


sds_promptplayerfi_tclMsgPromptLengthGet::~sds_promptplayerfi_tclMsgPromptLengthGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPromptLengthUpReg::sds_promptplayerfi_tclMsgPromptLengthUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPromptLengthUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHUPREG;
}


sds_promptplayerfi_tclMsgPromptLengthUpReg::~sds_promptplayerfi_tclMsgPromptLengthUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPromptLengthRelUpReg::sds_promptplayerfi_tclMsgPromptLengthRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPromptLengthRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHRELUPREG;
}


sds_promptplayerfi_tclMsgPromptLengthRelUpReg::~sds_promptplayerfi_tclMsgPromptLengthRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPromptLengthSet::sds_promptplayerfi_tclMsgPromptLengthSet(const sds_promptplayerfi_tclMsgPromptLengthSet& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PromptLength = coRef.PromptLength;
   SetDefault = coRef.SetDefault;
}
sds_promptplayerfi_tclMsgPromptLengthSet& sds_promptplayerfi_tclMsgPromptLengthSet::operator=(const sds_promptplayerfi_tclMsgPromptLengthSet& coRef)
{
   if (this == &coRef) return *this;
   PromptLength = coRef.PromptLength;
   SetDefault = coRef.SetDefault;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgPromptLengthSet::sds_promptplayerfi_tclMsgPromptLengthSet()
:PromptLength()
,SetDefault(0)
 {}

tS32 sds_promptplayerfi_tclMsgPromptLengthSet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSET;
}


sds_promptplayerfi_tclMsgPromptLengthSet::~sds_promptplayerfi_tclMsgPromptLengthSet()
{}

tU32 sds_promptplayerfi_tclMsgPromptLengthSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds_promptplayerfi_tclMsgPromptLengthSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PromptLength);
   (tVoid) (oIn >> SetDefault);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPromptLengthSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PromptLength);
   (tVoid) (oOut << SetDefault);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPromptLengthSet::operator==(const sds_promptplayerfi_tclMsgPromptLengthSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PromptLength == roRef.PromptLength);
   bResult = bResult && (SetDefault == roRef.SetDefault);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPromptLengthStatus::sds_promptplayerfi_tclMsgPromptLengthStatus(const sds_promptplayerfi_tclMsgPromptLengthStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PromptLength = coRef.PromptLength;
}
sds_promptplayerfi_tclMsgPromptLengthStatus& sds_promptplayerfi_tclMsgPromptLengthStatus::operator=(const sds_promptplayerfi_tclMsgPromptLengthStatus& coRef)
{
   if (this == &coRef) return *this;
   PromptLength = coRef.PromptLength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_promptplayerfi_tclMsgPromptLengthStatus::sds_promptplayerfi_tclMsgPromptLengthStatus()
:PromptLength()
 {}

tS32 sds_promptplayerfi_tclMsgPromptLengthStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLENGTHSTATUS;
}


sds_promptplayerfi_tclMsgPromptLengthStatus::~sds_promptplayerfi_tclMsgPromptLengthStatus()
{}

tU32 sds_promptplayerfi_tclMsgPromptLengthStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds_promptplayerfi_tclMsgPromptLengthStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PromptLength);
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPromptLengthStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PromptLength);
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPromptLengthStatus::operator==(const sds_promptplayerfi_tclMsgPromptLengthStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PromptLength == roRef.PromptLength);
   return bResult;
}

//=============================================================================

sds_promptplayerfi_tclMsgPromptListFlagUpdateGet::sds_promptplayerfi_tclMsgPromptListFlagUpdateGet()
 {}

tS32 sds_promptplayerfi_tclMsgPromptListFlagUpdateGet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEGET;
}


sds_promptplayerfi_tclMsgPromptListFlagUpdateGet::~sds_promptplayerfi_tclMsgPromptListFlagUpdateGet()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg::sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATEUPREG;
}


sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg::~sds_promptplayerfi_tclMsgPromptListFlagUpdateUpReg()
{}

//=============================================================================

sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg::sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg()
 {}

tS32 sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATERELUPREG;
}


sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg::~sds_promptplayerfi_tclMsgPromptListFlagUpdateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::sds_promptplayerfi_tclMsgPromptListFlagUpdateSet(const sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PromptListFlags = coRef.PromptListFlags;
}
sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::operator=(const sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& coRef)
{
   if (this == &coRef) return *this;
   PromptListFlags = coRef.PromptListFlags;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PromptListFlags.size(); ++u32Idx)
         PromptListFlags[u32Idx].vDestroy();
   PromptListFlags.clear();
   }
}

sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::sds_promptplayerfi_tclMsgPromptListFlagUpdateSet()

 {}

tS32 sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESET;
}


sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::~sds_promptplayerfi_tclMsgPromptListFlagUpdateSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PromptListFlags.size(); ++u32ListIdx)
      u32DynamicSize += PromptListFlags[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PromptListFlags.size(); ++u32Idx)
      {
         PromptListFlags[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PromptListFlags.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PromptListFlags[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PromptListFlags.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PromptListFlags.size(); ++u32Idx)
         (tVoid) (oOut << PromptListFlags[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPromptListFlagUpdateSet::operator==(const sds_promptplayerfi_tclMsgPromptListFlagUpdateSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PromptListFlags.size() == roRef.PromptListFlags.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PromptListFlags.size()); ++u32Idx)
            bResult = bResult && (PromptListFlags[u32Idx] == roRef.PromptListFlags[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus(const sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& coRef)
   : sds_promptplayerfi_tclMsgBaseMessage(coRef)
{
   PromptListFlags = coRef.PromptListFlags;
}
sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::operator=(const sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& coRef)
{
   if (this == &coRef) return *this;
   PromptListFlags = coRef.PromptListFlags;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PromptListFlags.size(); ++u32Idx)
         PromptListFlags[u32Idx].vDestroy();
   PromptListFlags.clear();
   }
}

sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus()

 {}

tS32 sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::s32GetTypeId() const
{
   return (tS32) sds_promptplayerfi_tclToken::EN_MSG_PROMPTLISTFLAGUPDATESTATUS;
}


sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::~sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PromptListFlags.size(); ++u32ListIdx)
      u32DynamicSize += PromptListFlags[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PromptListFlags.size(); ++u32Idx)
      {
         PromptListFlags[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PromptListFlags.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PromptListFlags[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PromptListFlags.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PromptListFlags.size(); ++u32Idx)
         (tVoid) (oOut << PromptListFlags[u32Idx]);
   }
   return oOut;
}

tBool sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus::operator==(const sds_promptplayerfi_tclMsgPromptListFlagUpdateStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PromptListFlags.size() == roRef.PromptListFlags.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PromptListFlags.size()); ++u32Idx)
            bResult = bResult && (PromptListFlags[u32Idx] == roRef.PromptListFlags[u32Idx]);
      }
   return bResult;
}

