#ifndef __SDS_PROMPTPLAYERFIDEBUGVISITOR_H__
#define __SDS_PROMPTPLAYERFIDEBUGVISITOR_H__

class MY_DECL sds_promptplayerfi_tclPrintVisitor : public sds_promptplayerfi_tclVisitorBase {

private:
   /* default constructor */ sds_promptplayerfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_promptplayerfi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_PromptSetting(sds_fi_tcl_e8_PromptSetting& o_e8_PromptSetting);
   virtual tBool bDoExpand_SDSLanguageID(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tBool bDoExpand_VoiceType(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AudioChannelAdvice(sds_fi_tcl_e8_AudioChannelAdvice& o_e8_AudioChannelAdvice);
   virtual tBool bDoExpand_AudioChannelAdvice(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_PrompterStatus(sds_fi_tcl_e8_PrompterStatus& o_e8_PrompterStatus);
   virtual tVoid vVisit_e8_ReleaseTypePP(sds_fi_tcl_e8_ReleaseTypePP& o_e8_ReleaseTypePP);
   virtual tVoid vVisit_e8_VarType(sds_fi_tcl_e8_VarType& o_e8_VarType);
   virtual tVoid vVisit_e8_PPJobStatus(sds_fi_tcl_e8_PPJobStatus& o_e8_PPJobStatus);
   virtual tVoid vVisit_e8_DlgAppID(sds_fi_tcl_e8_DlgAppID& o_e8_DlgAppID);
   virtual tBool bDoExpand_PromptListStatus(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PhraseVariable(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_PlayProgress(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SD_Format(sds_fi_tcl_e8_SD_Format& o_e8_SD_Format);
   virtual tVoid vVisit_u16_SD_SampleFrequency(sds_fi_tcl_u16_SD_SampleFrequency& o_u16_SD_SampleFrequency);
   virtual tBool bDoExpand_SD_Settings(sds_promptplayerfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_promptplayerfi_tclRandomInitVisitor : public sds_promptplayerfi_tclVisitorBase {
public:

   sds_promptplayerfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e16_ISOCountryCode(sds_fi_tcl_e16_ISOCountryCode& o_e16_ISOCountryCode);
   virtual tVoid vVisit_e16_ISO639_3_SDSLanguageCode(sds_fi_tcl_e16_ISO639_3_SDSLanguageCode& o_e16_ISO639_3_SDSLanguageCode);
   virtual tVoid vVisit_e8_PromptSetting(sds_fi_tcl_e8_PromptSetting& o_e8_PromptSetting);
   virtual tVoid vVisit_e8_VoiceGender(sds_fi_tcl_e8_VoiceGender& o_e8_VoiceGender);
   virtual tVoid vVisit_e8_AudioChannelAdvice(sds_fi_tcl_e8_AudioChannelAdvice& o_e8_AudioChannelAdvice);
   virtual tVoid vVisit_e8_PrompterStatus(sds_fi_tcl_e8_PrompterStatus& o_e8_PrompterStatus);
   virtual tVoid vVisit_e8_ReleaseTypePP(sds_fi_tcl_e8_ReleaseTypePP& o_e8_ReleaseTypePP);
   virtual tVoid vVisit_e8_VarType(sds_fi_tcl_e8_VarType& o_e8_VarType);
   virtual tVoid vVisit_e8_PPJobStatus(sds_fi_tcl_e8_PPJobStatus& o_e8_PPJobStatus);
   virtual tVoid vVisit_e8_DlgAppID(sds_fi_tcl_e8_DlgAppID& o_e8_DlgAppID);
   virtual tVoid vVisit_e8_SD_Format(sds_fi_tcl_e8_SD_Format& o_e8_SD_Format);
   virtual tVoid vVisit_u16_SD_SampleFrequency(sds_fi_tcl_u16_SD_SampleFrequency& o_u16_SD_SampleFrequency);
	tU32 u32ListSize;
};

#endif
