/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for SDS_MSTTESTCOMPONENT_FI message types

fi_tclMessageBase* sds_msttestcomponentfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds_msttestcomponentfi_tclToken::EN_MSG_SETMEDIASTATUSMETHODSTART:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart;

      case sds_msttestcomponentfi_tclToken::EN_MSG_SETMEDIASTATUSMETHODRESULT:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult;

      case sds_msttestcomponentfi_tclToken::EN_MSG_SETPHONESTATUSMETHODSTART:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart;

      case sds_msttestcomponentfi_tclToken::EN_MSG_SETPHONESTATUSMETHODRESULT:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult;

      case sds_msttestcomponentfi_tclToken::EN_MSG_SETTUNERSTATUSMETHODSTART:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart;

      case sds_msttestcomponentfi_tclToken::EN_MSG_SETTUNERSTATUSMETHODRESULT:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult;

      case sds_msttestcomponentfi_tclToken::EN_MSG_SETVDLSTATUSMETHODSTART:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart;

      case sds_msttestcomponentfi_tclToken::EN_MSG_SETVDLSTATUSMETHODRESULT:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult;

      case sds_msttestcomponentfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETMETHODSTART:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart;

      case sds_msttestcomponentfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETMETHODRESULT:
         return OSAL_NEW sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds_msttestcomponentfifi messages

// common functions

tU16 sds_msttestcomponentfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS_MSTTESTCOMPONENTFI_C_U16_SERVICE_ID;
}

tU16 sds_msttestcomponentfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds_msttestcomponentfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds_msttestcomponentfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds_msttestcomponentfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds_msttestcomponentfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds_msttestcomponentfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds_msttestcomponentfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& coRef)
   : sds_msttestcomponentfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceType = coRef.SourceType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
}
sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::operator=(const sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceType = coRef.SourceType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         DeviceList[u32Idx].vDestroy();
   DeviceList.clear();
   }
}

sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart()
:Status()
,MenuType()
,SourceType()
,SourceId(0)

 {}

tS32 sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETMEDIASTATUSMETHODSTART;
}


sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::~sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11;
}

fi_tclInContext& sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> MenuType);
   (tVoid) (oIn >> SourceType);
   (tVoid) (oIn >> SourceId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
      {
         DeviceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << MenuType);
   (tVoid) (oOut << SourceType);
   (tVoid) (oOut << SourceId);
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   return oOut;
}

tBool sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart::operator==(const sds_msttestcomponentfi_tclMsgSetMediaStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (MenuType == roRef.MenuType);
   bResult = bResult && (SourceType == roRef.SourceType);
   bResult = bResult && (SourceId == roRef.SourceId);
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult::sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult()
 {}

tS32 sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETMEDIASTATUSMETHODRESULT;
}


sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult::~sds_msttestcomponentfi_tclMsgSetMediaStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& coRef)
   : sds_msttestcomponentfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
}
sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::operator=(const sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         DeviceList[u32Idx].vDestroy();
   DeviceList.clear();
   }
}

sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart()
:Status()
,MenuType()
,SourceId(0)

 {}

tS32 sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETPHONESTATUSMETHODSTART;
}


sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::~sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

fi_tclInContext& sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> MenuType);
   (tVoid) (oIn >> SourceId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
      {
         DeviceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << MenuType);
   (tVoid) (oOut << SourceId);
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   return oOut;
}

tBool sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart::operator==(const sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (MenuType == roRef.MenuType);
   bResult = bResult && (SourceId == roRef.SourceId);
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult::sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult()
 {}

tS32 sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETPHONESTATUSMETHODRESULT;
}


sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult::~sds_msttestcomponentfi_tclMsgSetPhoneStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& coRef)
   : sds_msttestcomponentfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   Band = coRef.Band;
   PresetNr = coRef.PresetNr;
   StationName = coRef.StationName;
   DeviceList = coRef.DeviceList;
}
sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::operator=(const sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   Band = coRef.Band;
   PresetNr = coRef.PresetNr;
   StationName = coRef.StationName;
   DeviceList = coRef.DeviceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::vDestroy()
{
   StationName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         DeviceList[u32Idx].vDestroy();
   DeviceList.clear();
   }
}

sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart()
:Status()
,Band()
,PresetNr(0)
,StationName()

 {}

tS32 sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETTUNERSTATUSMETHODSTART;
}


sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::~sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+StationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> PresetNr);
   (tVoid) (oIn >> StationName);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
      {
         DeviceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << Band);
   (tVoid) (oOut << PresetNr);
   (tVoid) (oOut << StationName);
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   return oOut;
}

tBool sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart::operator==(const sds_msttestcomponentfi_tclMsgSetTunerStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (PresetNr == roRef.PresetNr);
   bResult = bResult && (StationName == roRef.StationName);
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult::sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult()
 {}

tS32 sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETTUNERSTATUSMETHODRESULT;
}


sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult::~sds_msttestcomponentfi_tclMsgSetTunerStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart(const sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& coRef)
   : sds_msttestcomponentfi_tclMsgBaseMessage(coRef)
{
   Slots = coRef.Slots;
}
sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::operator=(const sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Slots = coRef.Slots;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
         Slots[u32Idx].vDestroy();
   Slots.clear();
   }
}

sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart()

 {}

tS32 sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETVDLSTATUSMETHODSTART;
}


sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::~sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Slots.size(); ++u32ListIdx)
      u32DynamicSize += Slots[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
      {
         Slots[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Slots.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Slots[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Slots.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
         (tVoid) (oOut << Slots[u32Idx]);
   }
   return oOut;
}

tBool sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart::operator==(const sds_msttestcomponentfi_tclMsgSetVDLStatusMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Slots.size() == roRef.Slots.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Slots.size()); ++u32Idx)
            bResult = bResult && (Slots[u32Idx] == roRef.Slots[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult::sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult()
 {}

tS32 sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_SETVDLSTATUSMETHODRESULT;
}


sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult::~sds_msttestcomponentfi_tclMsgSetVDLStatusMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart(const sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& coRef)
   : sds_msttestcomponentfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   DataSetId = coRef.DataSetId;
}
sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::operator=(const sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   DataSetId = coRef.DataSetId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart()
:Status()
,DataSetId(0)
 {}

tS32 sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETMETHODSTART;
}


sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::~sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart()
{}

tU32 sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> DataSetId);
   return oIn;
}

fi_tclOutContext& sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << DataSetId);
   return oOut;
}

tBool sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart::operator==(const sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (DataSetId == roRef.DataSetId);
   return bResult;
}

//=============================================================================

sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult::sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult()
 {}

tS32 sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult::s32GetTypeId() const
{
   return (tS32) sds_msttestcomponentfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETMETHODRESULT;
}


sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult::~sds_msttestcomponentfi_tclMsgNavDataActiveDataSetMethodResult()
{}

