#ifndef __SDS_MSTTESTCOMPONENTFIDEBUGVISITOR_H__
#define __SDS_MSTTESTCOMPONENTFIDEBUGVISITOR_H__

class MY_DECL sds_msttestcomponentfi_tclPrintVisitor : public sds_msttestcomponentfi_tclVisitorBase {

private:
   /* default constructor */ sds_msttestcomponentfi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   sds_msttestcomponentfi_tclPrintVisitor(sds_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(sds_msttestcomponentfi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MPL_Status(sds_fi_tcl_e8_MPL_Status& o_e8_MPL_Status);
   virtual tVoid vVisit_e8_MPL_SourceType(sds_fi_tcl_e8_MPL_SourceType& o_e8_MPL_SourceType);
   virtual tVoid vVisit_e8_MPL_MenuType(sds_fi_tcl_e8_MPL_MenuType& o_e8_MPL_MenuType);
   virtual tVoid vVisit_e8_DeviceStatus(sds_fi_tcl_e8_DeviceStatus& o_e8_DeviceStatus);
   virtual tVoid vVisit_e8_SDS2HMI_PHN_Status(sds_fi_tcl_e8_SDS2HMI_PHN_Status& o_e8_SDS2HMI_PHN_Status);
   virtual tVoid vVisit_e8_SDS2HMI_PHN_MenuType(sds_fi_tcl_e8_SDS2HMI_PHN_MenuType& o_e8_SDS2HMI_PHN_MenuType);
   virtual tVoid vVisit_e8_SDS2HMI_TUN_Status(sds_fi_tcl_e8_SDS2HMI_TUN_Status& o_e8_SDS2HMI_TUN_Status);
   virtual tVoid vVisit_e8_SDS2HMI_TUN_Band(sds_fi_tcl_e8_SDS2HMI_TUN_Band& o_e8_SDS2HMI_TUN_Band);
   virtual tVoid vVisit_e8_NDS_SDN_Status(sds_fi_tcl_e8_NDS_SDN_Status& o_e8_NDS_SDN_Status);
   virtual tBool bDoExpand_DeviceStatus(sds_msttestcomponentfi_tclSemanticDomain::tenType enSemantic);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   sds_fi_tclOutput* poOutput;
};


class MY_DECL sds_msttestcomponentfi_tclRandomInitVisitor : public sds_msttestcomponentfi_tclVisitorBase {
public:

   sds_msttestcomponentfi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(sds_fi_tclU8& oU8);
   virtual tVoid vVisitS8(sds_fi_tclS8& oS8);
   virtual tVoid vVisitU16(sds_fi_tclU16& oU16);
   virtual tVoid vVisitS16(sds_fi_tclS16& oS16);
   virtual tVoid vVisitU24(sds_fi_tclU24& oU24);
   virtual tVoid vVisitS24(sds_fi_tclS24& oS24);
   virtual tVoid vVisitU32(sds_fi_tclU32& oU32);
   virtual tVoid vVisitS32(sds_fi_tclS32& oS32);
   virtual tVoid vVisitU64(sds_fi_tclU64& oU64);
   virtual tVoid vVisitS64(sds_fi_tclS64& oS64);
   virtual tVoid vVisitBool(sds_fi_tclBool& oBool);
   virtual tVoid vVisitString(sds_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(sds_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(sds_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_MPL_Status(sds_fi_tcl_e8_MPL_Status& o_e8_MPL_Status);
   virtual tVoid vVisit_e8_MPL_SourceType(sds_fi_tcl_e8_MPL_SourceType& o_e8_MPL_SourceType);
   virtual tVoid vVisit_e8_MPL_MenuType(sds_fi_tcl_e8_MPL_MenuType& o_e8_MPL_MenuType);
   virtual tVoid vVisit_e8_DeviceStatus(sds_fi_tcl_e8_DeviceStatus& o_e8_DeviceStatus);
   virtual tVoid vVisit_e8_SDS2HMI_PHN_Status(sds_fi_tcl_e8_SDS2HMI_PHN_Status& o_e8_SDS2HMI_PHN_Status);
   virtual tVoid vVisit_e8_SDS2HMI_PHN_MenuType(sds_fi_tcl_e8_SDS2HMI_PHN_MenuType& o_e8_SDS2HMI_PHN_MenuType);
   virtual tVoid vVisit_e8_SDS2HMI_TUN_Status(sds_fi_tcl_e8_SDS2HMI_TUN_Status& o_e8_SDS2HMI_TUN_Status);
   virtual tVoid vVisit_e8_SDS2HMI_TUN_Band(sds_fi_tcl_e8_SDS2HMI_TUN_Band& o_e8_SDS2HMI_TUN_Band);
   virtual tVoid vVisit_e8_NDS_SDN_Status(sds_fi_tcl_e8_NDS_SDN_Status& o_e8_NDS_SDN_Status);
	tU32 u32ListSize;
};

#endif
