/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 sds2hmi_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 sds2hmi_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 sds2hmi_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 sds2hmi_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 sds2hmi_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 sds2hmi_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 sds2hmi_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 sds2hmi_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 sds2hmi_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 sds2hmi_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 sds2hmi_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 sds2hmi_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& sds2hmi_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 sds2hmi_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid sds2hmi_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tclString::~sds2hmi_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

sds2hmi_fi_tclString& sds2hmi_fi_tclString::operator=(const sds2hmi_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

sds2hmi_fi_tclString::sds2hmi_fi_tclString(const sds2hmi_fi_tclString& coRef):sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& sds2hmi_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool sds2hmi_fi_tclString::operator==(const sds2hmi_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 sds2hmi_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
sds2hmi_fi_tclString& sds2hmi_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
sds2hmi_fi_tclString::sds2hmi_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool sds2hmi_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

sds2hmi_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

sds2hmi_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool sds2hmi_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar sds2hmi_FI_C_U8_NULLCHAR = '\0';

tChar* sds2hmi_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* sds2hmi_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* sds2hmi_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& sds2hmi_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return sds2hmi_FI_C_U8_NULLCHAR;
}

tChar& sds2hmi_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return sds2hmi_FI_C_U8_NULLCHAR;
}

tChar& sds2hmi_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return sds2hmi_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool sds2hmi_fi_tclString::bSet(const sds2hmi_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool sds2hmi_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString sds2hmi_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& sds2hmi_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool sds2hmi_fi_tclList::operator==(const sds2hmi_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 sds2hmi_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& sds2hmi_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid sds2hmi_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tclMultiLanguageString::~sds2hmi_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

sds2hmi_fi_tclMultiLanguageString& sds2hmi_fi_tclMultiLanguageString::operator=(const sds2hmi_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

sds2hmi_fi_tclMultiLanguageString::sds2hmi_fi_tclMultiLanguageString(const sds2hmi_fi_tclMultiLanguageString& coRef):sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& sds2hmi_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool sds2hmi_fi_tclMultiLanguageString::operator==(const sds2hmi_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 sds2hmi_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
sds2hmi_fi_tclMultiLanguageString& sds2hmi_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
sds2hmi_fi_tclMultiLanguageString::sds2hmi_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool sds2hmi_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

sds2hmi_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

sds2hmi_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool sds2hmi_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* sds2hmi_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* sds2hmi_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* sds2hmi_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& sds2hmi_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return sds2hmi_FI_C_U8_NULLCHAR;
}

tChar& sds2hmi_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return sds2hmi_FI_C_U8_NULLCHAR;
}

tChar& sds2hmi_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return sds2hmi_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool sds2hmi_fi_tclMultiLanguageString::bSet(const sds2hmi_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool sds2hmi_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString sds2hmi_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_BinContainerTypes::sds2hmi_fi_tcl_e8_BinContainerTypes():enType(FI_EN_T_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_BinContainerTypes::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_BINCONTAINERTYPES;
}


sds2hmi_fi_tcl_e8_BinContainerTypes::~sds2hmi_fi_tcl_e8_BinContainerTypes()
{}

tU32 sds2hmi_fi_tcl_e8_BinContainerTypes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_BinContainerTypes::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_BinContainerTypes::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_BinContainerTypes::tenType enData = enType;
   if ((enData == FI_EN_T_GRAPHICALWEATHERSHAPEBINCONTAINER) && !(29 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_MAPROUTEBINCONTAINER) && !(15 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_BinContainer::sds2hmi_fi_tcl_BinContainer(const sds2hmi_fi_tcl_BinContainer& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
sds2hmi_fi_tcl_BinContainer& sds2hmi_fi_tcl_BinContainer::operator=(const sds2hmi_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

sds2hmi_fi_tcl_BinContainer::sds2hmi_fi_tcl_BinContainer()

 {}

tS32 sds2hmi_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_BINCONTAINER;
}


sds2hmi_fi_tcl_BinContainer::~sds2hmi_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ContainerDataList.size()*1;
}

fi_tclInContext& sds2hmi_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_BinContainer::operator==(const sds2hmi_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_fi_tcl_Reserved::sds2hmi_fi_tcl_Reserved()
 {}

tS32 sds2hmi_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_RESERVED;
}


sds2hmi_fi_tcl_Reserved::~sds2hmi_fi_tcl_Reserved()
{}

tU32 sds2hmi_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& sds2hmi_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u8_Percent::sds2hmi_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sds2hmi_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U8_PERCENT;
}


sds2hmi_fi_tcl_u8_Percent::~sds2hmi_fi_tcl_u8_Percent()
{}

tU32 sds2hmi_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_PerThousand::sds2hmi_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


sds2hmi_fi_tcl_s16_PerThousand::~sds2hmi_fi_tcl_s16_PerThousand()
{}

tU32 sds2hmi_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u16_IndexInReferenceList::sds2hmi_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds2hmi_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


sds2hmi_fi_tcl_u16_IndexInReferenceList::~sds2hmi_fi_tcl_u16_IndexInReferenceList()
{}

tU32 sds2hmi_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u16_ErrorCode::sds2hmi_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds2hmi_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U16_ERRORCODE;
}


sds2hmi_fi_tcl_u16_ErrorCode::~sds2hmi_fi_tcl_u16_ErrorCode()
{}

tU32 sds2hmi_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u16_RPM::sds2hmi_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds2hmi_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U16_RPM;
}


sds2hmi_fi_tcl_u16_RPM::~sds2hmi_fi_tcl_u16_RPM()
{}

tU32 sds2hmi_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Kilogram::sds2hmi_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_KILOGRAM;
}


sds2hmi_fi_tcl_s32_Kilogram::~sds2hmi_fi_tcl_s32_Kilogram()
{}

tU32 sds2hmi_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Pound::sds2hmi_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_POUND;
}


sds2hmi_fi_tcl_s32_Pound::~sds2hmi_fi_tcl_s32_Pound()
{}

tU32 sds2hmi_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_Meter::sds2hmi_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_METER;
}


sds2hmi_fi_tcl_s16_Meter::~sds2hmi_fi_tcl_s16_Meter()
{}

tU32 sds2hmi_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Meter::sds2hmi_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_METER;
}


sds2hmi_fi_tcl_s32_Meter::~sds2hmi_fi_tcl_s32_Meter()
{}

tU32 sds2hmi_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Yards::sds2hmi_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_YARDS;
}


sds2hmi_fi_tcl_s32_Yards::~sds2hmi_fi_tcl_s32_Yards()
{}

tU32 sds2hmi_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Foot::sds2hmi_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_FOOT;
}


sds2hmi_fi_tcl_s32_Foot::~sds2hmi_fi_tcl_s32_Foot()
{}

tU32 sds2hmi_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Centimeter::sds2hmi_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_CENTIMETER;
}


sds2hmi_fi_tcl_s32_Centimeter::~sds2hmi_fi_tcl_s32_Centimeter()
{}

tU32 sds2hmi_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Inch::sds2hmi_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_INCH;
}


sds2hmi_fi_tcl_s32_Inch::~sds2hmi_fi_tcl_s32_Inch()
{}

tU32 sds2hmi_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Millimeter::sds2hmi_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_MILLIMETER;
}


sds2hmi_fi_tcl_s32_Millimeter::~sds2hmi_fi_tcl_s32_Millimeter()
{}

tU32 sds2hmi_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Microliter::sds2hmi_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_MICROLITER;
}


sds2hmi_fi_tcl_s32_Microliter::~sds2hmi_fi_tcl_s32_Microliter()
{}

tU32 sds2hmi_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Second::sds2hmi_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_SECOND;
}


sds2hmi_fi_tcl_s32_Second::~sds2hmi_fi_tcl_s32_Second()
{}

tU32 sds2hmi_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u16_MilliSecond::sds2hmi_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds2hmi_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U16_MILLISECOND;
}


sds2hmi_fi_tcl_u16_MilliSecond::~sds2hmi_fi_tcl_u16_MilliSecond()
{}

tU32 sds2hmi_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_MilliSecond::sds2hmi_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_MILLISECOND;
}


sds2hmi_fi_tcl_s32_MilliSecond::~sds2hmi_fi_tcl_s32_MilliSecond()
{}

tU32 sds2hmi_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_POSIXTime::sds2hmi_fi_tcl_POSIXTime(const sds2hmi_fi_tcl_POSIXTime& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
sds2hmi_fi_tcl_POSIXTime& sds2hmi_fi_tcl_POSIXTime::operator=(const sds2hmi_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_POSIXTime::sds2hmi_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 sds2hmi_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_POSIXTIME;
}


sds2hmi_fi_tcl_POSIXTime::~sds2hmi_fi_tcl_POSIXTime()
{}

tU32 sds2hmi_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool sds2hmi_fi_tcl_POSIXTime::operator==(const sds2hmi_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_DST_State::sds2hmi_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 sds2hmi_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_DST_STATE;
}


sds2hmi_fi_tcl_e8_DST_State::~sds2hmi_fi_tcl_e8_DST_State()
{}

tU32 sds2hmi_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_TimeZoneElement::sds2hmi_fi_tcl_TimeZoneElement(const sds2hmi_fi_tcl_TimeZoneElement& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
sds2hmi_fi_tcl_TimeZoneElement& sds2hmi_fi_tcl_TimeZoneElement::operator=(const sds2hmi_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

sds2hmi_fi_tcl_TimeZoneElement::sds2hmi_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 sds2hmi_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


sds2hmi_fi_tcl_TimeZoneElement::~sds2hmi_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+DST_TimeDomain.size()*1;
}

fi_tclInContext& sds2hmi_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_TimeZoneElement::operator==(const sds2hmi_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_KmPerHour::sds2hmi_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_KMPERHOUR;
}


sds2hmi_fi_tcl_s16_KmPerHour::~sds2hmi_fi_tcl_s16_KmPerHour()
{}

tU32 sds2hmi_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_MilesPerHour::sds2hmi_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


sds2hmi_fi_tcl_s16_MilesPerHour::~sds2hmi_fi_tcl_s16_MilesPerHour()
{}

tU32 sds2hmi_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_Knot::sds2hmi_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_KNOT;
}


sds2hmi_fi_tcl_s16_Knot::~sds2hmi_fi_tcl_s16_Knot()
{}

tU32 sds2hmi_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_CentimeterSecond::sds2hmi_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


sds2hmi_fi_tcl_s16_CentimeterSecond::~sds2hmi_fi_tcl_s16_CentimeterSecond()
{}

tU32 sds2hmi_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_Kelvin::sds2hmi_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_KELVIN;
}


sds2hmi_fi_tcl_s16_Kelvin::~sds2hmi_fi_tcl_s16_Kelvin()
{}

tU32 sds2hmi_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_Fahrenheit::sds2hmi_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


sds2hmi_fi_tcl_s16_Fahrenheit::~sds2hmi_fi_tcl_s16_Fahrenheit()
{}

tU32 sds2hmi_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Pascal::sds2hmi_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_PASCAL;
}


sds2hmi_fi_tcl_s32_Pascal::~sds2hmi_fi_tcl_s32_Pascal()
{}

tU32 sds2hmi_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Watt::sds2hmi_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_WATT;
}


sds2hmi_fi_tcl_s32_Watt::~sds2hmi_fi_tcl_s32_Watt()
{}

tU32 sds2hmi_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_FIVersion::sds2hmi_fi_tcl_FIVersion(const sds2hmi_fi_tcl_FIVersion& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
sds2hmi_fi_tcl_FIVersion& sds2hmi_fi_tcl_FIVersion::operator=(const sds2hmi_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_FIVersion::sds2hmi_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 sds2hmi_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_FIVERSION;
}


sds2hmi_fi_tcl_FIVersion::~sds2hmi_fi_tcl_FIVersion()
{}

tU32 sds2hmi_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds2hmi_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool sds2hmi_fi_tcl_FIVersion::operator==(const sds2hmi_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Longitude::sds2hmi_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_LONGITUDE;
}


sds2hmi_fi_tcl_s32_Longitude::~sds2hmi_fi_tcl_s32_Longitude()
{}

tU32 sds2hmi_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_Latitude::sds2hmi_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_LATITUDE;
}


sds2hmi_fi_tcl_s32_Latitude::~sds2hmi_fi_tcl_s32_Latitude()
{}

tU32 sds2hmi_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_PositionWGS84::sds2hmi_fi_tcl_PositionWGS84(const sds2hmi_fi_tcl_PositionWGS84& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
sds2hmi_fi_tcl_PositionWGS84& sds2hmi_fi_tcl_PositionWGS84::operator=(const sds2hmi_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_PositionWGS84::sds2hmi_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 sds2hmi_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_POSITIONWGS84;
}


sds2hmi_fi_tcl_PositionWGS84::~sds2hmi_fi_tcl_PositionWGS84()
{}

tU32 sds2hmi_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds2hmi_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool sds2hmi_fi_tcl_PositionWGS84::operator==(const sds2hmi_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_RectangleWGS84::sds2hmi_fi_tcl_RectangleWGS84(const sds2hmi_fi_tcl_RectangleWGS84& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
sds2hmi_fi_tcl_RectangleWGS84& sds2hmi_fi_tcl_RectangleWGS84::operator=(const sds2hmi_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_RectangleWGS84::sds2hmi_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 sds2hmi_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_RECTANGLEWGS84;
}


sds2hmi_fi_tcl_RectangleWGS84::~sds2hmi_fi_tcl_RectangleWGS84()
{}

tU32 sds2hmi_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& sds2hmi_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool sds2hmi_fi_tcl_RectangleWGS84::operator==(const sds2hmi_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e16_ISOCountryCode::sds2hmi_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 sds2hmi_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


sds2hmi_fi_tcl_e16_ISOCountryCode::~sds2hmi_fi_tcl_e16_ISOCountryCode()
{}

tU32 sds2hmi_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e16_ISOLanguageCode::sds2hmi_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 sds2hmi_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


sds2hmi_fi_tcl_e16_ISOLanguageCode::~sds2hmi_fi_tcl_e16_ISOLanguageCode()
{}

tU32 sds2hmi_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_LanguageID::sds2hmi_fi_tcl_LanguageID(const sds2hmi_fi_tcl_LanguageID& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
sds2hmi_fi_tcl_LanguageID& sds2hmi_fi_tcl_LanguageID::operator=(const sds2hmi_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_LanguageID::sds2hmi_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 sds2hmi_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_LANGUAGEID;
}


sds2hmi_fi_tcl_LanguageID::~sds2hmi_fi_tcl_LanguageID()
{}

tU32 sds2hmi_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool sds2hmi_fi_tcl_LanguageID::operator==(const sds2hmi_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u8_DirectionAbsolute::sds2hmi_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sds2hmi_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


sds2hmi_fi_tcl_u8_DirectionAbsolute::~sds2hmi_fi_tcl_u8_DirectionAbsolute()
{}

tU32 sds2hmi_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u8_DirectionRelative::sds2hmi_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 sds2hmi_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


sds2hmi_fi_tcl_u8_DirectionRelative::~sds2hmi_fi_tcl_u8_DirectionRelative()
{}

tU32 sds2hmi_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_CentiDegree::sds2hmi_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


sds2hmi_fi_tcl_s16_CentiDegree::~sds2hmi_fi_tcl_s16_CentiDegree()
{}

tU32 sds2hmi_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_Degree::sds2hmi_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_DEGREE;
}


sds2hmi_fi_tcl_s16_Degree::~sds2hmi_fi_tcl_s16_Degree()
{}

tU32 sds2hmi_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree::sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree::~sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree::sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree::~sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_FuelType::sds2hmi_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_FUELTYPE;
}


sds2hmi_fi_tcl_e8_FuelType::~sds2hmi_fi_tcl_e8_FuelType()
{}

tU32 sds2hmi_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_DistTimeFuel::sds2hmi_fi_tcl_DistTimeFuel(const sds2hmi_fi_tcl_DistTimeFuel& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
sds2hmi_fi_tcl_DistTimeFuel& sds2hmi_fi_tcl_DistTimeFuel::operator=(const sds2hmi_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_DistTimeFuel::sds2hmi_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 sds2hmi_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_DISTTIMEFUEL;
}


sds2hmi_fi_tcl_DistTimeFuel::~sds2hmi_fi_tcl_DistTimeFuel()
{}

tU32 sds2hmi_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sds2hmi_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool sds2hmi_fi_tcl_DistTimeFuel::operator==(const sds2hmi_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode::sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode():enType(FI_EN_ISO_639_3_INVALID) {}

tS32 sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E16_ISO639_3_SDSLANGUAGECODE;
}


sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode::~sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode()
{}

tU32 sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Slot::sds2hmi_fi_tcl_e8_Slot():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_Slot::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SLOT;
}


sds2hmi_fi_tcl_e8_Slot::~sds2hmi_fi_tcl_e8_Slot()
{}

tU32 sds2hmi_fi_tcl_e8_Slot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Slot::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Slot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Domain::sds2hmi_fi_tcl_e8_Domain():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_Domain::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_DOMAIN;
}


sds2hmi_fi_tcl_e8_Domain::~sds2hmi_fi_tcl_e8_Domain()
{}

tU32 sds2hmi_fi_tcl_e8_Domain::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Domain::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Domain::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus():enType(FI_EN_DEVICEUNAVAILABLE) {}

tS32 sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_CONNECTEDDEVICEUPDATESTATUS;
}


sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::~sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus()
{}

tU32 sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PromptSetting::sds2hmi_fi_tcl_e8_PromptSetting():enType(FI_EN_SHORT) {}

tS32 sds2hmi_fi_tcl_e8_PromptSetting::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PROMPTSETTING;
}


sds2hmi_fi_tcl_e8_PromptSetting::~sds2hmi_fi_tcl_e8_PromptSetting()
{}

tU32 sds2hmi_fi_tcl_e8_PromptSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PromptSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PromptSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_WordType::sds2hmi_fi_tcl_e8_WordType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_WordType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_WORDTYPE;
}


sds2hmi_fi_tcl_e8_WordType::~sds2hmi_fi_tcl_e8_WordType()
{}

tU32 sds2hmi_fi_tcl_e8_WordType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_WordType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_WordType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NDSFeatureType::sds2hmi_fi_tcl_e8_NDSFeatureType():enType(FI_EN_NAMEOBJECT) {}

tS32 sds2hmi_fi_tcl_e8_NDSFeatureType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NDSFEATURETYPE;
}


sds2hmi_fi_tcl_e8_NDSFeatureType::~sds2hmi_fi_tcl_e8_NDSFeatureType()
{}

tU32 sds2hmi_fi_tcl_e8_NDSFeatureType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NDSFeatureType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NDSFeatureType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e32_SSE_ASR_Mode::sds2hmi_fi_tcl_e32_SSE_ASR_Mode():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e32_SSE_ASR_Mode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E32_SSE_ASR_MODE;
}


sds2hmi_fi_tcl_e32_SSE_ASR_Mode::~sds2hmi_fi_tcl_e32_SSE_ASR_Mode()
{}

tU32 sds2hmi_fi_tcl_e32_SSE_ASR_Mode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_e32_SSE_ASR_Mode::oRead(fi_tclInContext& oIn)
{
   tU32 u32Value;
   (tVoid) (oIn >> u32Value);
   enType = (tenType)u32Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e32_SSE_ASR_Mode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU32)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SDSDestinationType::sds2hmi_fi_tcl_e8_SDSDestinationType():enType(FI_EN_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_SDSDestinationType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SDSDESTINATIONTYPE;
}


sds2hmi_fi_tcl_e8_SDSDestinationType::~sds2hmi_fi_tcl_e8_SDSDestinationType()
{}

tU32 sds2hmi_fi_tcl_e8_SDSDestinationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SDSDestinationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SDSDestinationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SDSLanguageID::sds2hmi_fi_tcl_SDSLanguageID(const sds2hmi_fi_tcl_SDSLanguageID& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ISO639_3_SDSLanguageCode = coRef.ISO639_3_SDSLanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
sds2hmi_fi_tcl_SDSLanguageID& sds2hmi_fi_tcl_SDSLanguageID::operator=(const sds2hmi_fi_tcl_SDSLanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_3_SDSLanguageCode = coRef.ISO639_3_SDSLanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_SDSLanguageID::sds2hmi_fi_tcl_SDSLanguageID()
:ISO639_3_SDSLanguageCode()
,ISO3166_CountryCode()
 {}

tS32 sds2hmi_fi_tcl_SDSLanguageID::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SDSLANGUAGEID;
}


sds2hmi_fi_tcl_SDSLanguageID::~sds2hmi_fi_tcl_SDSLanguageID()
{}

tU32 sds2hmi_fi_tcl_SDSLanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_SDSLanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_3_SDSLanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SDSLanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_3_SDSLanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool sds2hmi_fi_tcl_SDSLanguageID::operator==(const sds2hmi_fi_tcl_SDSLanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_3_SDSLanguageCode == roRef.ISO639_3_SDSLanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_ConnectedDeviceStatus::sds2hmi_fi_tcl_ConnectedDeviceStatus(const sds2hmi_fi_tcl_ConnectedDeviceStatus& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   u32DeviceId = coRef.u32DeviceId;
   tenDomain = coRef.tenDomain;
   UpdateStatus = coRef.UpdateStatus;
}
sds2hmi_fi_tcl_ConnectedDeviceStatus& sds2hmi_fi_tcl_ConnectedDeviceStatus::operator=(const sds2hmi_fi_tcl_ConnectedDeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceId = coRef.u32DeviceId;
   tenDomain = coRef.tenDomain;
   UpdateStatus = coRef.UpdateStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_ConnectedDeviceStatus::sds2hmi_fi_tcl_ConnectedDeviceStatus()
:u32DeviceId(0)
,tenDomain()
,UpdateStatus()
 {}

tS32 sds2hmi_fi_tcl_ConnectedDeviceStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_CONNECTEDDEVICESTATUS;
}


sds2hmi_fi_tcl_ConnectedDeviceStatus::~sds2hmi_fi_tcl_ConnectedDeviceStatus()
{}

tU32 sds2hmi_fi_tcl_ConnectedDeviceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds2hmi_fi_tcl_ConnectedDeviceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceId);
   (tVoid) (oIn >> tenDomain);
   (tVoid) (oIn >> UpdateStatus);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_ConnectedDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceId);
   (tVoid) (oOut << tenDomain);
   (tVoid) (oOut << UpdateStatus);
   return oOut;
}

tBool sds2hmi_fi_tcl_ConnectedDeviceStatus::operator==(const sds2hmi_fi_tcl_ConnectedDeviceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceId == roRef.u32DeviceId);
   bResult = bResult && (tenDomain == roRef.tenDomain);
   bResult = bResult && (UpdateStatus == roRef.UpdateStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NDSLanguageID::sds2hmi_fi_tcl_NDSLanguageID(const sds2hmi_fi_tcl_NDSLanguageID& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   LanguageCode = coRef.LanguageCode;
   ISO_CountryCode = coRef.ISO_CountryCode;
   ISO_LanguageCode = coRef.ISO_LanguageCode;
   ScriptCode = coRef.ScriptCode;
}
sds2hmi_fi_tcl_NDSLanguageID& sds2hmi_fi_tcl_NDSLanguageID::operator=(const sds2hmi_fi_tcl_NDSLanguageID& coRef)
{
   if (this == &coRef) return *this;
   LanguageCode = coRef.LanguageCode;
   ISO_CountryCode = coRef.ISO_CountryCode;
   ISO_LanguageCode = coRef.ISO_LanguageCode;
   ScriptCode = coRef.ScriptCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NDSLanguageID::vDestroy()
{
   ISO_CountryCode.vDestroy();
   ISO_LanguageCode.vDestroy();
   ScriptCode.vDestroy();
}

sds2hmi_fi_tcl_NDSLanguageID::sds2hmi_fi_tcl_NDSLanguageID()
:LanguageCode(0)
,ISO_CountryCode()
,ISO_LanguageCode()
,ScriptCode()
 {}

tS32 sds2hmi_fi_tcl_NDSLanguageID::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NDSLANGUAGEID;
}


sds2hmi_fi_tcl_NDSLanguageID::~sds2hmi_fi_tcl_NDSLanguageID()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NDSLanguageID::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ISO_CountryCode.u32GetSize(u16MajorVersion)+ISO_LanguageCode.u32GetSize(u16MajorVersion)+ScriptCode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_NDSLanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LanguageCode);
   (tVoid) (oIn >> ISO_CountryCode);
   (tVoid) (oIn >> ISO_LanguageCode);
   (tVoid) (oIn >> ScriptCode);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NDSLanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LanguageCode);
   (tVoid) (oOut << ISO_CountryCode);
   (tVoid) (oOut << ISO_LanguageCode);
   (tVoid) (oOut << ScriptCode);
   return oOut;
}

tBool sds2hmi_fi_tcl_NDSLanguageID::operator==(const sds2hmi_fi_tcl_NDSLanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LanguageCode == roRef.LanguageCode);
   bResult = bResult && (ISO_CountryCode == roRef.ISO_CountryCode);
   bResult = bResult && (ISO_LanguageCode == roRef.ISO_LanguageCode);
   bResult = bResult && (ScriptCode == roRef.ScriptCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NDSID::sds2hmi_fi_tcl_NDSID(const sds2hmi_fi_tcl_NDSID& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   u16UpdateRegionId = coRef.u16UpdateRegionId;
   u32ProductId = coRef.u32ProductId;
   u8SupplierId = coRef.u8SupplierId;
   u32NDSId = coRef.u32NDSId;
   eNDSFeatureType = coRef.eNDSFeatureType;
   POIRootRegionID = coRef.POIRootRegionID;
   GlobalXRefId = coRef.GlobalXRefId;
}
sds2hmi_fi_tcl_NDSID& sds2hmi_fi_tcl_NDSID::operator=(const sds2hmi_fi_tcl_NDSID& coRef)
{
   if (this == &coRef) return *this;
   u16UpdateRegionId = coRef.u16UpdateRegionId;
   u32ProductId = coRef.u32ProductId;
   u8SupplierId = coRef.u8SupplierId;
   u32NDSId = coRef.u32NDSId;
   eNDSFeatureType = coRef.eNDSFeatureType;
   POIRootRegionID = coRef.POIRootRegionID;
   GlobalXRefId = coRef.GlobalXRefId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NDSID::sds2hmi_fi_tcl_NDSID()
:u16UpdateRegionId(0)
,u32ProductId(0)
,u8SupplierId(0)
,u32NDSId(0)
,eNDSFeatureType()
,POIRootRegionID(0)
,GlobalXRefId(0)
 {}

tS32 sds2hmi_fi_tcl_NDSID::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NDSID;
}


sds2hmi_fi_tcl_NDSID::~sds2hmi_fi_tcl_NDSID()
{}

tU32 sds2hmi_fi_tcl_NDSID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& sds2hmi_fi_tcl_NDSID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16UpdateRegionId);
   (tVoid) (oIn >> u32ProductId);
   (tVoid) (oIn >> u8SupplierId);
   (tVoid) (oIn >> u32NDSId);
   (tVoid) (oIn >> eNDSFeatureType);
   (tVoid) (oIn >> POIRootRegionID);
   (tVoid) (oIn >> GlobalXRefId);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NDSID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16UpdateRegionId);
   (tVoid) (oOut << u32ProductId);
   (tVoid) (oOut << u8SupplierId);
   (tVoid) (oOut << u32NDSId);
   (tVoid) (oOut << eNDSFeatureType);
   (tVoid) (oOut << POIRootRegionID);
   (tVoid) (oOut << GlobalXRefId);
   return oOut;
}

tBool sds2hmi_fi_tcl_NDSID::operator==(const sds2hmi_fi_tcl_NDSID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16UpdateRegionId == roRef.u16UpdateRegionId);
   bResult = bResult && (u32ProductId == roRef.u32ProductId);
   bResult = bResult && (u8SupplierId == roRef.u8SupplierId);
   bResult = bResult && (u32NDSId == roRef.u32NDSId);
   bResult = bResult && (eNDSFeatureType == roRef.eNDSFeatureType);
   bResult = bResult && (POIRootRegionID == roRef.POIRootRegionID);
   bResult = bResult && (GlobalXRefId == roRef.GlobalXRefId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StreetAvailability::sds2hmi_fi_tcl_StreetAvailability(const sds2hmi_fi_tcl_StreetAvailability& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   City_Id = coRef.City_Id;
   Availability = coRef.Availability;
}
sds2hmi_fi_tcl_StreetAvailability& sds2hmi_fi_tcl_StreetAvailability::operator=(const sds2hmi_fi_tcl_StreetAvailability& coRef)
{
   if (this == &coRef) return *this;
   City_Id = coRef.City_Id;
   Availability = coRef.Availability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_StreetAvailability::sds2hmi_fi_tcl_StreetAvailability()
:City_Id()
,Availability(0)
 {}

tS32 sds2hmi_fi_tcl_StreetAvailability::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STREETAVAILABILITY;
}


sds2hmi_fi_tcl_StreetAvailability::~sds2hmi_fi_tcl_StreetAvailability()
{}

tU32 sds2hmi_fi_tcl_StreetAvailability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 25;
}

fi_tclInContext& sds2hmi_fi_tcl_StreetAvailability::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> City_Id);
   (tVoid) (oIn >> Availability);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StreetAvailability::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << City_Id);
   (tVoid) (oOut << Availability);
   return oOut;
}

tBool sds2hmi_fi_tcl_StreetAvailability::operator==(const sds2hmi_fi_tcl_StreetAvailability& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (City_Id == roRef.City_Id);
   bResult = bResult && (Availability == roRef.Availability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_PhonemeForLanguage::sds2hmi_fi_tcl_PhonemeForLanguage(const sds2hmi_fi_tcl_PhonemeForLanguage& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Language = coRef.Language;
   Phoneme = coRef.Phoneme;
}
sds2hmi_fi_tcl_PhonemeForLanguage& sds2hmi_fi_tcl_PhonemeForLanguage::operator=(const sds2hmi_fi_tcl_PhonemeForLanguage& coRef)
{
   if (this == &coRef) return *this;
   Language = coRef.Language;
   Phoneme = coRef.Phoneme;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_PhonemeForLanguage::vDestroy()
{
   Language.vDestroy(); 
   Phoneme.vDestroy();
}

sds2hmi_fi_tcl_PhonemeForLanguage::sds2hmi_fi_tcl_PhonemeForLanguage()
:Language()
,Phoneme()
 {}

tS32 sds2hmi_fi_tcl_PhonemeForLanguage::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_PHONEMEFORLANGUAGE;
}


sds2hmi_fi_tcl_PhonemeForLanguage::~sds2hmi_fi_tcl_PhonemeForLanguage()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_PhonemeForLanguage::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Language.u32GetSize(u16MajorVersion)+Phoneme.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_PhonemeForLanguage::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Language);
   (tVoid) (oIn >> Phoneme);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_PhonemeForLanguage::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Language);
   (tVoid) (oOut << Phoneme);
   return oOut;
}

tBool sds2hmi_fi_tcl_PhonemeForLanguage::operator==(const sds2hmi_fi_tcl_PhonemeForLanguage& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Language == roRef.Language);
   bResult = bResult && (Phoneme == roRef.Phoneme);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringAndPhoneme::sds2hmi_fi_tcl_StringAndPhoneme(const sds2hmi_fi_tcl_StringAndPhoneme& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   NDSId = coRef.NDSId;
   OrthographyList = coRef.OrthographyList;
   PhonemeAndLanguageList = coRef.PhonemeAndLanguageList;
   DestItemtype = coRef.DestItemtype;
}
sds2hmi_fi_tcl_StringAndPhoneme& sds2hmi_fi_tcl_StringAndPhoneme::operator=(const sds2hmi_fi_tcl_StringAndPhoneme& coRef)
{
   if (this == &coRef) return *this;
   NDSId = coRef.NDSId;
   OrthographyList = coRef.OrthographyList;
   PhonemeAndLanguageList = coRef.PhonemeAndLanguageList;
   DestItemtype = coRef.DestItemtype;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringAndPhoneme::vDestroy()
{
   NDSId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         OrthographyList[u32Idx].vDestroy();
   OrthographyList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeAndLanguageList.size(); ++u32Idx)
         PhonemeAndLanguageList[u32Idx].vDestroy();
   PhonemeAndLanguageList.clear();
   }
}

sds2hmi_fi_tcl_StringAndPhoneme::sds2hmi_fi_tcl_StringAndPhoneme()
:NDSId()


,DestItemtype()
 {}

tS32 sds2hmi_fi_tcl_StringAndPhoneme::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGANDPHONEME;
}


sds2hmi_fi_tcl_StringAndPhoneme::~sds2hmi_fi_tcl_StringAndPhoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringAndPhoneme::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < OrthographyList.size(); ++u32ListIdx)
      u32DynamicSize += OrthographyList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < PhonemeAndLanguageList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeAndLanguageList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+33;
}

fi_tclInContext& sds2hmi_fi_tcl_StringAndPhoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NDSId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
      {
         OrthographyList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OrthographyList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OrthographyList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeAndLanguageList.size(); ++u32Idx)
      {
         PhonemeAndLanguageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeAndLanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeAndLanguageList[u32Idx]);
      }
   }
   (tVoid) (oIn >> DestItemtype);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringAndPhoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NDSId);
   (tVoid) (oOut << (tU32)OrthographyList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         (tVoid) (oOut << OrthographyList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)PhonemeAndLanguageList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeAndLanguageList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeAndLanguageList[u32Idx]);
   }
   (tVoid) (oOut << DestItemtype);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringAndPhoneme::operator==(const sds2hmi_fi_tcl_StringAndPhoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NDSId == roRef.NDSId);
      bResult = bResult && (OrthographyList.size() == roRef.OrthographyList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OrthographyList.size()); ++u32Idx)
            bResult = bResult && (OrthographyList[u32Idx] == roRef.OrthographyList[u32Idx]);
      }
      bResult = bResult && (PhonemeAndLanguageList.size() == roRef.PhonemeAndLanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeAndLanguageList.size()); ++u32Idx)
            bResult = bResult && (PhonemeAndLanguageList[u32Idx] == roRef.PhonemeAndLanguageList[u32Idx]);
      }
   bResult = bResult && (DestItemtype == roRef.DestItemtype);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StatePhoneme::sds2hmi_fi_tcl_StatePhoneme(const sds2hmi_fi_tcl_StatePhoneme& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   StateId = coRef.StateId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
}
sds2hmi_fi_tcl_StatePhoneme& sds2hmi_fi_tcl_StatePhoneme::operator=(const sds2hmi_fi_tcl_StatePhoneme& coRef)
{
   if (this == &coRef) return *this;
   StateId = coRef.StateId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StatePhoneme::vDestroy()
{
   StateId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         OrthographyList[u32Idx].vDestroy();
   OrthographyList.clear();
   }
}

sds2hmi_fi_tcl_StatePhoneme::sds2hmi_fi_tcl_StatePhoneme()
:StateId()


 {}

tS32 sds2hmi_fi_tcl_StatePhoneme::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STATEPHONEME;
}


sds2hmi_fi_tcl_StatePhoneme::~sds2hmi_fi_tcl_StatePhoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StatePhoneme::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < OrthographyList.size(); ++u32ListIdx)
      u32DynamicSize += OrthographyList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+32;
}

fi_tclInContext& sds2hmi_fi_tcl_StatePhoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StateId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
      {
         OrthographyList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OrthographyList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OrthographyList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StatePhoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StateId);
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)OrthographyList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         (tVoid) (oOut << OrthographyList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_StatePhoneme::operator==(const sds2hmi_fi_tcl_StatePhoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StateId == roRef.StateId);
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
      bResult = bResult && (OrthographyList.size() == roRef.OrthographyList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OrthographyList.size()); ++u32Idx)
            bResult = bResult && (OrthographyList[u32Idx] == roRef.OrthographyList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_CountryPhoneme::sds2hmi_fi_tcl_CountryPhoneme(const sds2hmi_fi_tcl_CountryPhoneme& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   CountryId = coRef.CountryId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
   StateList = coRef.StateList;
   CountryCode = coRef.CountryCode;
}
sds2hmi_fi_tcl_CountryPhoneme& sds2hmi_fi_tcl_CountryPhoneme::operator=(const sds2hmi_fi_tcl_CountryPhoneme& coRef)
{
   if (this == &coRef) return *this;
   CountryId = coRef.CountryId;
   PhonemeList = coRef.PhonemeList;
   OrthographyList = coRef.OrthographyList;
   StateList = coRef.StateList;
   CountryCode = coRef.CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_CountryPhoneme::vDestroy()
{
   CountryId.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         OrthographyList[u32Idx].vDestroy();
   OrthographyList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < StateList.size(); ++u32Idx)
         StateList[u32Idx].vDestroy();
   StateList.clear();
   }
}

sds2hmi_fi_tcl_CountryPhoneme::sds2hmi_fi_tcl_CountryPhoneme()
:CountryId()



,CountryCode()
 {}

tS32 sds2hmi_fi_tcl_CountryPhoneme::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_COUNTRYPHONEME;
}


sds2hmi_fi_tcl_CountryPhoneme::~sds2hmi_fi_tcl_CountryPhoneme()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_CountryPhoneme::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < OrthographyList.size(); ++u32ListIdx)
      u32DynamicSize += OrthographyList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < StateList.size(); ++u32ListIdx)
      u32DynamicSize += StateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+38;
}

fi_tclInContext& sds2hmi_fi_tcl_CountryPhoneme::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
      {
         OrthographyList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      OrthographyList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> OrthographyList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StateList.size(); ++u32Idx)
      {
         StateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StateList[u32Idx]);
      }
   }
   (tVoid) (oIn >> CountryCode);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_CountryPhoneme::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryId);
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)OrthographyList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < OrthographyList.size(); ++u32Idx)
         (tVoid) (oOut << OrthographyList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)StateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StateList.size(); ++u32Idx)
         (tVoid) (oOut << StateList[u32Idx]);
   }
   (tVoid) (oOut << CountryCode);
   return oOut;
}

tBool sds2hmi_fi_tcl_CountryPhoneme::operator==(const sds2hmi_fi_tcl_CountryPhoneme& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryId == roRef.CountryId);
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
      bResult = bResult && (OrthographyList.size() == roRef.OrthographyList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < OrthographyList.size()); ++u32Idx)
            bResult = bResult && (OrthographyList[u32Idx] == roRef.OrthographyList[u32Idx]);
      }
      bResult = bResult && (StateList.size() == roRef.StateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateList.size()); ++u32Idx)
            bResult = bResult && (StateList[u32Idx] == roRef.StateList[u32Idx]);
      }
   bResult = bResult && (CountryCode == roRef.CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_CityId::sds2hmi_fi_tcl_CityId(const sds2hmi_fi_tcl_CityId& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   City_ID_ = coRef.City_ID_;
}
sds2hmi_fi_tcl_CityId& sds2hmi_fi_tcl_CityId::operator=(const sds2hmi_fi_tcl_CityId& coRef)
{
   if (this == &coRef) return *this;
   City_ID_ = coRef.City_ID_;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_CityId::sds2hmi_fi_tcl_CityId()
:City_ID_()
 {}

tS32 sds2hmi_fi_tcl_CityId::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_CITYID;
}


sds2hmi_fi_tcl_CityId::~sds2hmi_fi_tcl_CityId()
{}

tU32 sds2hmi_fi_tcl_CityId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& sds2hmi_fi_tcl_CityId::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> City_ID_);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_CityId::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << City_ID_);
   return oOut;
}

tBool sds2hmi_fi_tcl_CityId::operator==(const sds2hmi_fi_tcl_CityId& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (City_ID_ == roRef.City_ID_);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::sds2hmi_fi_tcl_ECNR_ASR_Mode_Status(const sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Mode_Enable = coRef.Mode_Enable;
   Mode_Status = coRef.Mode_Status;
}
sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::operator=(const sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& coRef)
{
   if (this == &coRef) return *this;
   Mode_Enable = coRef.Mode_Enable;
   Mode_Status = coRef.Mode_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::sds2hmi_fi_tcl_ECNR_ASR_Mode_Status()
:Mode_Enable(0)
,Mode_Status()
 {}

tS32 sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_ECNR_ASR_MODE_STATUS;
}


sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::~sds2hmi_fi_tcl_ECNR_ASR_Mode_Status()
{}

tU32 sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode_Enable);
   (tVoid) (oIn >> Mode_Status);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode_Enable);
   (tVoid) (oOut << Mode_Status);
   return oOut;
}

tBool sds2hmi_fi_tcl_ECNR_ASR_Mode_Status::operator==(const sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode_Enable == roRef.Mode_Enable);
   bResult = bResult && (Mode_Status == roRef.Mode_Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e16_SelectionCriterionType::sds2hmi_fi_tcl_e16_SelectionCriterionType():enType(FI_EN_RESERVED) {}

tS32 sds2hmi_fi_tcl_e16_SelectionCriterionType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E16_SELECTIONCRITERIONTYPE;
}


sds2hmi_fi_tcl_e16_SelectionCriterionType::~sds2hmi_fi_tcl_e16_SelectionCriterionType()
{}

tU32 sds2hmi_fi_tcl_e16_SelectionCriterionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_e16_SelectionCriterionType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e16_SelectionCriterionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_LocationDescriptionDataType::sds2hmi_fi_tcl_e8_LocationDescriptionDataType():enType(FI_EN_T_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_LocationDescriptionDataType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_LOCATIONDESCRIPTIONDATATYPE;
}


sds2hmi_fi_tcl_e8_LocationDescriptionDataType::~sds2hmi_fi_tcl_e8_LocationDescriptionDataType()
{}

tU32 sds2hmi_fi_tcl_e8_LocationDescriptionDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_LocationDescriptionDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_LocationDescriptionDataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_LocationDescriptorStatus::sds2hmi_fi_tcl_b8_LocationDescriptorStatus():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_LocationDescriptorStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_LOCATIONDESCRIPTORSTATUS;
}


sds2hmi_fi_tcl_b8_LocationDescriptorStatus::~sds2hmi_fi_tcl_b8_LocationDescriptorStatus()
{}

tU32 sds2hmi_fi_tcl_b8_LocationDescriptorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_LocationDescriptorStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_LocationDescriptorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_LocationDescriptor::sds2hmi_fi_tcl_LocationDescriptor(const sds2hmi_fi_tcl_LocationDescriptor& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   if  (coRef.poDataData)
   {
      switch(DataType.enType)
      {
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         poDataData = OSAL_NEW sds2hmi_fi_tclString((const sds2hmi_fi_tclString&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_StringID((const sds2hmi_fi_tcl_StringID&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_PositionHeadingSpeed((const sds2hmi_fi_tcl_PositionHeadingSpeed&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_PositionWGS84((const sds2hmi_fi_tcl_PositionWGS84&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         if (coRef.poDataData->s32GetTypeId() == (tS32)sds2hmi_typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER)
         {
            poDataData = OSAL_NEW sds2hmi_fi_tcl_NavLocationBinContainer((const sds2hmi_fi_tcl_NavLocationBinContainer&)*coRef.poDataData);
         }
         else
         {
            poDataData = OSAL_NEW sds2hmi_fi_tcl_BinContainer((const sds2hmi_fi_tcl_BinContainer&)*coRef.poDataData);
         }
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_StringPosition((const sds2hmi_fi_tcl_StringPosition&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_FLIString((const sds2hmi_fi_tcl_FLIString&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_ListOfPositions((const sds2hmi_fi_tcl_ListOfPositions&)*coRef.poDataData);
         break;
      default:
         poDataData = OSAL_NULL;
      }
   }
   else
   {
      poDataData = OSAL_NULL;
   }
   Status = coRef.Status;
}
sds2hmi_fi_tcl_LocationDescriptor& sds2hmi_fi_tcl_LocationDescriptor::operator=(const sds2hmi_fi_tcl_LocationDescriptor& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   OSAL_DELETE poDataData;
   DataType = coRef.DataType;
   if  (coRef.poDataData)
   {
      switch(DataType.enType)
      {
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         poDataData = OSAL_NEW sds2hmi_fi_tclString((const sds2hmi_fi_tclString&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_StringID((const sds2hmi_fi_tcl_StringID&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_PositionHeadingSpeed((const sds2hmi_fi_tcl_PositionHeadingSpeed&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_PositionWGS84((const sds2hmi_fi_tcl_PositionWGS84&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         if (coRef.poDataData->s32GetTypeId() == (tS32)sds2hmi_typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER)
         {
            poDataData = OSAL_NEW sds2hmi_fi_tcl_NavLocationBinContainer((const sds2hmi_fi_tcl_NavLocationBinContainer&)*coRef.poDataData);
         }
         else
         {
            poDataData = OSAL_NEW sds2hmi_fi_tcl_BinContainer((const sds2hmi_fi_tcl_BinContainer&)*coRef.poDataData);
         }
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_StringPosition((const sds2hmi_fi_tcl_StringPosition&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_FLIString((const sds2hmi_fi_tcl_FLIString&)*coRef.poDataData);
         break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         poDataData = OSAL_NEW sds2hmi_fi_tcl_ListOfPositions((const sds2hmi_fi_tcl_ListOfPositions&)*coRef.poDataData);
         break;
      default:
         poDataData = OSAL_NULL;
      }
   }
   else
   {
      poDataData = OSAL_NULL;
   }
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_LocationDescriptor::vDestroy()
{
   if (poDataData)
   {
      poDataData->vDestroy();
      OSAL_DELETE poDataData;
      poDataData = OSAL_NULL;
   }
}

sds2hmi_fi_tcl_LocationDescriptor::sds2hmi_fi_tcl_LocationDescriptor()
:SelectionCriterion()
,poDataData(0)
,Status()
 {}

tS32 sds2hmi_fi_tcl_LocationDescriptor::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_LOCATIONDESCRIPTOR;
}


sds2hmi_fi_tcl_LocationDescriptor::~sds2hmi_fi_tcl_LocationDescriptor()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_LocationDescriptor::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+(poDataData?poDataData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds2hmi_fi_tcl_LocationDescriptor::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionCriterion);
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poDataData;
#else
   if (poDataData)
   {
      poDataData->vDestroy();
      OSAL_DELETE poDataData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> DataType);
   switch(DataType.enType)
   {
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_Reserved;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
      poDataData = OSAL_NEW sds2hmi_fi_tclString;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_StringID;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_PositionHeadingSpeed;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_PositionWGS84;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_BinContainer;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_StringPosition;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_FLIString;
      break;
   case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
      poDataData = OSAL_NEW sds2hmi_fi_tcl_ListOfPositions;
      break;
   default:
      oIn.Invalidate();
      poDataData = OSAL_NULL;
   }
   if (poDataData && oIn.bIsValid())
      poDataData->oRead(oIn);
   else
      oIn.Invalidate();
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_LocationDescriptor::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionCriterion);
   (tVoid) (oOut << DataType);
   if (poDataData)
   {
      (tVoid) poDataData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   (tVoid) (oOut << Status);
   return oOut;
}

tBool sds2hmi_fi_tcl_LocationDescriptor::operator==(const sds2hmi_fi_tcl_LocationDescriptor& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionCriterion == roRef.SelectionCriterion);
   bResult = bResult && (DataType == roRef.DataType);
   if (bResult && poDataData && roRef.poDataData) 
   {
      switch (DataType.enType)
      {
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds2hmi_fi_tcl_Reserved*)poDataData == *(const sds2hmi_fi_tcl_Reserved*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_TSTRING:
         bResult = bResult && (*(const sds2hmi_fi_tclString*)poDataData == *(const sds2hmi_fi_tclString*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGID:
         bResult = bResult && (*(const sds2hmi_fi_tcl_StringID*)poDataData == *(const sds2hmi_fi_tcl_StringID*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONHEADINGSPEED:
         bResult = bResult && (*(const sds2hmi_fi_tcl_PositionHeadingSpeed*)poDataData == *(const sds2hmi_fi_tcl_PositionHeadingSpeed*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_POSITIONWGS84:
         bResult = bResult && (*(const sds2hmi_fi_tcl_PositionWGS84*)poDataData == *(const sds2hmi_fi_tcl_PositionWGS84*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_NAVLOCATIONBINCONTAINER:
         bResult = bResult && (*(const sds2hmi_fi_tcl_BinContainer*)poDataData == *(const sds2hmi_fi_tcl_BinContainer*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION:
         bResult = bResult && (*(const sds2hmi_fi_tcl_StringPosition*)poDataData == *(const sds2hmi_fi_tcl_StringPosition*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_FLISTRING:
         bResult = bResult && (*(const sds2hmi_fi_tcl_FLIString*)poDataData == *(const sds2hmi_fi_tcl_FLIString*)roRef.poDataData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_LISTOFPOSITIONS:
         bResult = bResult && (*(const sds2hmi_fi_tcl_ListOfPositions*)poDataData == *(const sds2hmi_fi_tcl_ListOfPositions*)roRef.poDataData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poDataData == roRef.poDataData);
   }
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_LocationDescription::sds2hmi_fi_tcl_LocationDescription(const sds2hmi_fi_tcl_LocationDescription& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Descriptors = coRef.Descriptors;
}
sds2hmi_fi_tcl_LocationDescription& sds2hmi_fi_tcl_LocationDescription::operator=(const sds2hmi_fi_tcl_LocationDescription& coRef)
{
   if (this == &coRef) return *this;
   Descriptors = coRef.Descriptors;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_LocationDescription::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
         Descriptors[u32Idx].vDestroy();
   Descriptors.clear();
   }
}

sds2hmi_fi_tcl_LocationDescription::sds2hmi_fi_tcl_LocationDescription()

 {}

tS32 sds2hmi_fi_tcl_LocationDescription::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_LOCATIONDESCRIPTION;
}


sds2hmi_fi_tcl_LocationDescription::~sds2hmi_fi_tcl_LocationDescription()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_LocationDescription::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Descriptors.size(); ++u32ListIdx)
      u32DynamicSize += Descriptors[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_LocationDescription::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
      {
         Descriptors[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Descriptors.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Descriptors[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_LocationDescription::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Descriptors.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Descriptors.size(); ++u32Idx)
         (tVoid) (oOut << Descriptors[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_LocationDescription::operator==(const sds2hmi_fi_tcl_LocationDescription& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Descriptors.size() == roRef.Descriptors.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Descriptors.size()); ++u32Idx)
            bResult = bResult && (Descriptors[u32Idx] == roRef.Descriptors[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringPosition::sds2hmi_fi_tcl_StringPosition(const sds2hmi_fi_tcl_StringPosition& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
   Position = coRef.Position;
}
sds2hmi_fi_tcl_StringPosition& sds2hmi_fi_tcl_StringPosition::operator=(const sds2hmi_fi_tcl_StringPosition& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   Position = coRef.Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringPosition::vDestroy()
{
   String.vDestroy();
   Position.vDestroy(); 
}

sds2hmi_fi_tcl_StringPosition::sds2hmi_fi_tcl_StringPosition()
:String()
,Position()
 {}

tS32 sds2hmi_fi_tcl_StringPosition::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGPOSITION;
}


sds2hmi_fi_tcl_StringPosition::~sds2hmi_fi_tcl_StringPosition()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringPosition::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringPosition::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> String);
   (tVoid) (oIn >> Position);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringPosition::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << String);
   (tVoid) (oOut << Position);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringPosition::operator==(const sds2hmi_fi_tcl_StringPosition& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (String == roRef.String);
   bResult = bResult && (Position == roRef.Position);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringID::sds2hmi_fi_tcl_StringID(const sds2hmi_fi_tcl_StringID& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
   ID = coRef.ID;
}
sds2hmi_fi_tcl_StringID& sds2hmi_fi_tcl_StringID::operator=(const sds2hmi_fi_tcl_StringID& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   ID = coRef.ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringID::vDestroy()
{
   String.vDestroy();
}

sds2hmi_fi_tcl_StringID::sds2hmi_fi_tcl_StringID()
:String()
,ID(0)
 {}

tS32 sds2hmi_fi_tcl_StringID::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGID;
}


sds2hmi_fi_tcl_StringID::~sds2hmi_fi_tcl_StringID()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringID::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> String);
   (tVoid) (oIn >> ID);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << String);
   (tVoid) (oOut << ID);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringID::operator==(const sds2hmi_fi_tcl_StringID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (String == roRef.String);
   bResult = bResult && (ID == roRef.ID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_FLIString::sds2hmi_fi_tcl_FLIString(const sds2hmi_fi_tcl_FLIString& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   String = coRef.String;
}
sds2hmi_fi_tcl_FLIString& sds2hmi_fi_tcl_FLIString::operator=(const sds2hmi_fi_tcl_FLIString& coRef)
{
   if (this == &coRef) return *this;
   String = coRef.String;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_FLIString::vDestroy()
{
   String.vDestroy();
}

sds2hmi_fi_tcl_FLIString::sds2hmi_fi_tcl_FLIString()
:String()
 {}

tS32 sds2hmi_fi_tcl_FLIString::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_FLISTRING;
}


sds2hmi_fi_tcl_FLIString::~sds2hmi_fi_tcl_FLIString()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_FLIString::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_FLIString::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> String);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_FLIString::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << String);
   return oOut;
}

tBool sds2hmi_fi_tcl_FLIString::operator==(const sds2hmi_fi_tcl_FLIString& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (String == roRef.String);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_PositionStatus::sds2hmi_fi_tcl_b8_PositionStatus():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_PositionStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_POSITIONSTATUS;
}


sds2hmi_fi_tcl_b8_PositionStatus::~sds2hmi_fi_tcl_b8_PositionStatus()
{}

tU32 sds2hmi_fi_tcl_b8_PositionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_PositionStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_PositionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_ListOfPositions::sds2hmi_fi_tcl_ListOfPositions(const sds2hmi_fi_tcl_ListOfPositions& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Positions = coRef.Positions;
   PositionStati = coRef.PositionStati;
   ID = coRef.ID;
   CurrentPosition = coRef.CurrentPosition;
}
sds2hmi_fi_tcl_ListOfPositions& sds2hmi_fi_tcl_ListOfPositions::operator=(const sds2hmi_fi_tcl_ListOfPositions& coRef)
{
   if (this == &coRef) return *this;
   Positions = coRef.Positions;
   PositionStati = coRef.PositionStati;
   ID = coRef.ID;
   CurrentPosition = coRef.CurrentPosition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_ListOfPositions::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         Positions[u32Idx].vDestroy();
   Positions.clear();
   }
   {
   PositionStati.clear();
   }
   CurrentPosition.vDestroy(); 
}

sds2hmi_fi_tcl_ListOfPositions::sds2hmi_fi_tcl_ListOfPositions()


:ID(0)
,CurrentPosition()
 {}

tS32 sds2hmi_fi_tcl_ListOfPositions::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_LISTOFPOSITIONS;
}


sds2hmi_fi_tcl_ListOfPositions::~sds2hmi_fi_tcl_ListOfPositions()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_ListOfPositions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20+Positions.size()*8+PositionStati.size()*1;
}

fi_tclInContext& sds2hmi_fi_tcl_ListOfPositions::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
      {
         Positions[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Positions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Positions[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PositionStati.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PositionStati[u32Idx]);
      }
   }
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> CurrentPosition);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_ListOfPositions::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Positions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Positions.size(); ++u32Idx)
         (tVoid) (oOut << Positions[u32Idx]);
   }
   (tVoid) (oOut << (tU32)PositionStati.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PositionStati.size(); ++u32Idx)
         (tVoid) (oOut << PositionStati[u32Idx]);
   }
   (tVoid) (oOut << ID);
   (tVoid) (oOut << CurrentPosition);
   return oOut;
}

tBool sds2hmi_fi_tcl_ListOfPositions::operator==(const sds2hmi_fi_tcl_ListOfPositions& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Positions.size() == roRef.Positions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Positions.size()); ++u32Idx)
            bResult = bResult && (Positions[u32Idx] == roRef.Positions[u32Idx]);
      }
      bResult = bResult && (PositionStati.size() == roRef.PositionStati.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionStati.size()); ++u32Idx)
            bResult = bResult && (PositionStati[u32Idx] == roRef.PositionStati[u32Idx]);
      }
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (CurrentPosition == roRef.CurrentPosition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_FilterAttributeType::sds2hmi_fi_tcl_e8_FilterAttributeType():enType(FI_EN_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_FilterAttributeType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_FILTERATTRIBUTETYPE;
}


sds2hmi_fi_tcl_e8_FilterAttributeType::~sds2hmi_fi_tcl_e8_FilterAttributeType()
{}

tU32 sds2hmi_fi_tcl_e8_FilterAttributeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_FilterAttributeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_FilterAttributeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_FilterAttribute::sds2hmi_fi_tcl_FilterAttribute(const sds2hmi_fi_tcl_FilterAttribute& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Type = coRef.Type;
   Code = coRef.Code;
   Name = coRef.Name;
}
sds2hmi_fi_tcl_FilterAttribute& sds2hmi_fi_tcl_FilterAttribute::operator=(const sds2hmi_fi_tcl_FilterAttribute& coRef)
{
   if (this == &coRef) return *this;
   Type = coRef.Type;
   Code = coRef.Code;
   Name = coRef.Name;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_FilterAttribute::vDestroy()
{
   Name.vDestroy();
}

sds2hmi_fi_tcl_FilterAttribute::sds2hmi_fi_tcl_FilterAttribute()
:Type()
,Code(0)
,Name()
 {}

tS32 sds2hmi_fi_tcl_FilterAttribute::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_FILTERATTRIBUTE;
}


sds2hmi_fi_tcl_FilterAttribute::~sds2hmi_fi_tcl_FilterAttribute()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_FilterAttribute::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_FilterAttribute::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Type);
   (tVoid) (oIn >> Code);
   (tVoid) (oIn >> Name);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_FilterAttribute::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Type);
   (tVoid) (oOut << Code);
   (tVoid) (oOut << Name);
   return oOut;
}

tBool sds2hmi_fi_tcl_FilterAttribute::operator==(const sds2hmi_fi_tcl_FilterAttribute& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Type == roRef.Type);
   bResult = bResult && (Code == roRef.Code);
   bResult = bResult && (Name == roRef.Name);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e16_MenuItemType::sds2hmi_fi_tcl_e16_MenuItemType():enType(FI_EN_RESERVED) {}

tS32 sds2hmi_fi_tcl_e16_MenuItemType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E16_MENUITEMTYPE;
}


sds2hmi_fi_tcl_e16_MenuItemType::~sds2hmi_fi_tcl_e16_MenuItemType()
{}

tU32 sds2hmi_fi_tcl_e16_MenuItemType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_e16_MenuItemType::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e16_MenuItemType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_LocationValueListType::sds2hmi_fi_tcl_e8_LocationValueListType():enType(FI_EN_T_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_LocationValueListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_LOCATIONVALUELISTTYPE;
}


sds2hmi_fi_tcl_e8_LocationValueListType::~sds2hmi_fi_tcl_e8_LocationValueListType()
{}

tU32 sds2hmi_fi_tcl_e8_LocationValueListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_LocationValueListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_LocationValueListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_ListResultOptions::sds2hmi_fi_tcl_b8_ListResultOptions():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_ListResultOptions::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_LISTRESULTOPTIONS;
}


sds2hmi_fi_tcl_b8_ListResultOptions::~sds2hmi_fi_tcl_b8_ListResultOptions()
{}

tU32 sds2hmi_fi_tcl_b8_ListResultOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_ListResultOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_ListResultOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_ListGetOptions::sds2hmi_fi_tcl_b8_ListGetOptions():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_ListGetOptions::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_LISTGETOPTIONS;
}


sds2hmi_fi_tcl_b8_ListGetOptions::~sds2hmi_fi_tcl_b8_ListGetOptions()
{}

tU32 sds2hmi_fi_tcl_b8_ListGetOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_ListGetOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_ListGetOptions::oWrite(fi_tclOutContext& oOut) const
{
   tU8 temp = u8Value;
   if (!(17 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_INCLUDEALLEXONYMS;
   if (!(26 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U8_BIT_MAPGROUPINATTRIBUTES;
   return oOut << temp;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_LocationValueListUnion::sds2hmi_fi_tcl_LocationValueListUnion(const sds2hmi_fi_tcl_LocationValueListUnion& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ValueListType = coRef.ValueListType;
   if  (coRef.poValueListData)
   {
      switch(ValueListType.enType)
      {
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringList((const sds2hmi_fi_tcl_StringList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringDescriptionList((const sds2hmi_fi_tcl_StringDescriptionList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringIDList((const sds2hmi_fi_tcl_StringIDList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_PositionWGS84List((const sds2hmi_fi_tcl_PositionWGS84List&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringPositionList((const sds2hmi_fi_tcl_StringPositionList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringPositionDescriptionList((const sds2hmi_fi_tcl_StringPositionDescriptionList&)*coRef.poValueListData);
         break;
      default:
         poValueListData = OSAL_NULL;
      }
   }
   else
   {
      poValueListData = OSAL_NULL;
   }
}
sds2hmi_fi_tcl_LocationValueListUnion& sds2hmi_fi_tcl_LocationValueListUnion::operator=(const sds2hmi_fi_tcl_LocationValueListUnion& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poValueListData;
   ValueListType = coRef.ValueListType;
   if  (coRef.poValueListData)
   {
      switch(ValueListType.enType)
      {
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringList((const sds2hmi_fi_tcl_StringList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringDescriptionList((const sds2hmi_fi_tcl_StringDescriptionList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringIDList((const sds2hmi_fi_tcl_StringIDList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_PositionWGS84List((const sds2hmi_fi_tcl_PositionWGS84List&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringPositionList((const sds2hmi_fi_tcl_StringPositionList&)*coRef.poValueListData);
         break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
         poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringPositionDescriptionList((const sds2hmi_fi_tcl_StringPositionDescriptionList&)*coRef.poValueListData);
         break;
      default:
         poValueListData = OSAL_NULL;
      }
   }
   else
   {
      poValueListData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_LocationValueListUnion::vDestroy()
{
   if (poValueListData)
   {
      poValueListData->vDestroy();
      OSAL_DELETE poValueListData;
      poValueListData = OSAL_NULL;
   }
}

sds2hmi_fi_tcl_LocationValueListUnion::sds2hmi_fi_tcl_LocationValueListUnion()
:poValueListData(0)
 {}

tS32 sds2hmi_fi_tcl_LocationValueListUnion::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_LOCATIONVALUELISTUNION;
}


sds2hmi_fi_tcl_LocationValueListUnion::~sds2hmi_fi_tcl_LocationValueListUnion()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_LocationValueListUnion::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poValueListData?poValueListData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds2hmi_fi_tcl_LocationValueListUnion::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poValueListData;
#else
   if (poValueListData)
   {
      poValueListData->vDestroy();
      OSAL_DELETE poValueListData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> ValueListType);
   switch(ValueListType.enType)
   {
   case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
      poValueListData = OSAL_NEW sds2hmi_fi_tcl_Reserved;
      break;
   case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
      poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringList;
      break;
   case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
      poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringDescriptionList;
      break;
   case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
      poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringIDList;
      break;
   case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
      poValueListData = OSAL_NEW sds2hmi_fi_tcl_PositionWGS84List;
      break;
   case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
      poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringPositionList;
      break;
   case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
      poValueListData = OSAL_NEW sds2hmi_fi_tcl_StringPositionDescriptionList;
      break;
   default:
      oIn.Invalidate();
      poValueListData = OSAL_NULL;
   }
   if (poValueListData && oIn.bIsValid())
      poValueListData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_LocationValueListUnion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ValueListType);
   if (poValueListData)
   {
      (tVoid) poValueListData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_LocationValueListUnion::operator==(const sds2hmi_fi_tcl_LocationValueListUnion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ValueListType == roRef.ValueListType);
   if (bResult && poValueListData && roRef.poValueListData) 
   {
      switch (ValueListType.enType)
      {
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds2hmi_fi_tcl_Reserved*)poValueListData == *(const sds2hmi_fi_tcl_Reserved*)roRef.poValueListData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGLIST:
         bResult = bResult && (*(const sds2hmi_fi_tcl_StringList*)poValueListData == *(const sds2hmi_fi_tcl_StringList*)roRef.poValueListData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGDESCRIPTIONLIST:
         bResult = bResult && (*(const sds2hmi_fi_tcl_StringDescriptionList*)poValueListData == *(const sds2hmi_fi_tcl_StringDescriptionList*)roRef.poValueListData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGIDLIST:
         bResult = bResult && (*(const sds2hmi_fi_tcl_StringIDList*)poValueListData == *(const sds2hmi_fi_tcl_StringIDList*)roRef.poValueListData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_POSITIONWGS84LIST:
         bResult = bResult && (*(const sds2hmi_fi_tcl_PositionWGS84List*)poValueListData == *(const sds2hmi_fi_tcl_PositionWGS84List*)roRef.poValueListData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONLIST:
         bResult = bResult && (*(const sds2hmi_fi_tcl_StringPositionList*)poValueListData == *(const sds2hmi_fi_tcl_StringPositionList*)roRef.poValueListData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_LocationValueListType::FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST:
         bResult = bResult && (*(const sds2hmi_fi_tcl_StringPositionDescriptionList*)poValueListData == *(const sds2hmi_fi_tcl_StringPositionDescriptionList*)roRef.poValueListData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poValueListData == roRef.poValueListData);
   }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b16_ElementProperties::sds2hmi_fi_tcl_b16_ElementProperties():u16Value(0)
{}

tS32 sds2hmi_fi_tcl_b16_ElementProperties::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B16_ELEMENTPROPERTIES;
}


sds2hmi_fi_tcl_b16_ElementProperties::~sds2hmi_fi_tcl_b16_ElementProperties()
{}

tU32 sds2hmi_fi_tcl_b16_ElementProperties::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_b16_ElementProperties::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b16_ElementProperties::oWrite(fi_tclOutContext& oOut) const
{
   tU16 temp = u16Value;
   if (!(6 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U16_BIT_ISBASENAME;
   if (!(15 <= oOut.u16GetMajorVersion()))
      temp &= ~FI_C_U16_BIT_ISUSERPOIDATASET;
   return oOut << temp;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringElement::sds2hmi_fi_tcl_StringElement(const sds2hmi_fi_tcl_StringElement& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   String = coRef.String;
}
sds2hmi_fi_tcl_StringElement& sds2hmi_fi_tcl_StringElement::operator=(const sds2hmi_fi_tcl_StringElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   String = coRef.String;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringElement::vDestroy()
{
   String.vDestroy();
}

sds2hmi_fi_tcl_StringElement::sds2hmi_fi_tcl_StringElement()
:Properties()
,String()
 {}

tS32 sds2hmi_fi_tcl_StringElement::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGELEMENT;
}


sds2hmi_fi_tcl_StringElement::~sds2hmi_fi_tcl_StringElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Properties);
   (tVoid) (oIn >> String);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Properties);
   (tVoid) (oOut << String);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringElement::operator==(const sds2hmi_fi_tcl_StringElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Properties == roRef.Properties);
   bResult = bResult && (String == roRef.String);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringList::sds2hmi_fi_tcl_StringList(const sds2hmi_fi_tcl_StringList& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   StringList = coRef.StringList;
}
sds2hmi_fi_tcl_StringList& sds2hmi_fi_tcl_StringList::operator=(const sds2hmi_fi_tcl_StringList& coRef)
{
   if (this == &coRef) return *this;
   StringList = coRef.StringList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         StringList[u32Idx].vDestroy();
   StringList.clear();
   }
}

sds2hmi_fi_tcl_StringList::sds2hmi_fi_tcl_StringList()

 {}

tS32 sds2hmi_fi_tcl_StringList::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGLIST;
}


sds2hmi_fi_tcl_StringList::~sds2hmi_fi_tcl_StringList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringList.size(); ++u32ListIdx)
      u32DynamicSize += StringList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_StringList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
      {
         StringList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         (tVoid) (oOut << StringList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_StringList::operator==(const sds2hmi_fi_tcl_StringList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringList.size() == roRef.StringList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringList.size()); ++u32Idx)
            bResult = bResult && (StringList[u32Idx] == roRef.StringList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringDescriptionElement::sds2hmi_fi_tcl_StringDescriptionElement(const sds2hmi_fi_tcl_StringDescriptionElement& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   ElementString = coRef.ElementString;
   DescriptionString = coRef.DescriptionString;
}
sds2hmi_fi_tcl_StringDescriptionElement& sds2hmi_fi_tcl_StringDescriptionElement::operator=(const sds2hmi_fi_tcl_StringDescriptionElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   ElementString = coRef.ElementString;
   DescriptionString = coRef.DescriptionString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringDescriptionElement::vDestroy()
{
   ElementString.vDestroy();
   DescriptionString.vDestroy();
}

sds2hmi_fi_tcl_StringDescriptionElement::sds2hmi_fi_tcl_StringDescriptionElement()
:Properties()
,ElementString()
,DescriptionString()
 {}

tS32 sds2hmi_fi_tcl_StringDescriptionElement::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGDESCRIPTIONELEMENT;
}


sds2hmi_fi_tcl_StringDescriptionElement::~sds2hmi_fi_tcl_StringDescriptionElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringDescriptionElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ElementString.u32GetSize(u16MajorVersion)+DescriptionString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringDescriptionElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Properties);
   (tVoid) (oIn >> ElementString);
   (tVoid) (oIn >> DescriptionString);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringDescriptionElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Properties);
   (tVoid) (oOut << ElementString);
   (tVoid) (oOut << DescriptionString);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringDescriptionElement::operator==(const sds2hmi_fi_tcl_StringDescriptionElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Properties == roRef.Properties);
   bResult = bResult && (ElementString == roRef.ElementString);
   bResult = bResult && (DescriptionString == roRef.DescriptionString);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringDescriptionList::sds2hmi_fi_tcl_StringDescriptionList(const sds2hmi_fi_tcl_StringDescriptionList& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   StringDescriptionList = coRef.StringDescriptionList;
}
sds2hmi_fi_tcl_StringDescriptionList& sds2hmi_fi_tcl_StringDescriptionList::operator=(const sds2hmi_fi_tcl_StringDescriptionList& coRef)
{
   if (this == &coRef) return *this;
   StringDescriptionList = coRef.StringDescriptionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringDescriptionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringDescriptionList.size(); ++u32Idx)
         StringDescriptionList[u32Idx].vDestroy();
   StringDescriptionList.clear();
   }
}

sds2hmi_fi_tcl_StringDescriptionList::sds2hmi_fi_tcl_StringDescriptionList()

 {}

tS32 sds2hmi_fi_tcl_StringDescriptionList::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGDESCRIPTIONLIST;
}


sds2hmi_fi_tcl_StringDescriptionList::~sds2hmi_fi_tcl_StringDescriptionList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringDescriptionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringDescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += StringDescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_StringDescriptionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringDescriptionList.size(); ++u32Idx)
      {
         StringDescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringDescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringDescriptionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringDescriptionList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringDescriptionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringDescriptionList.size(); ++u32Idx)
         (tVoid) (oOut << StringDescriptionList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_StringDescriptionList::operator==(const sds2hmi_fi_tcl_StringDescriptionList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringDescriptionList.size() == roRef.StringDescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringDescriptionList.size()); ++u32Idx)
            bResult = bResult && (StringDescriptionList[u32Idx] == roRef.StringDescriptionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringIDElement::sds2hmi_fi_tcl_StringIDElement(const sds2hmi_fi_tcl_StringIDElement& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   StringID = coRef.StringID;
}
sds2hmi_fi_tcl_StringIDElement& sds2hmi_fi_tcl_StringIDElement::operator=(const sds2hmi_fi_tcl_StringIDElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   StringID = coRef.StringID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringIDElement::vDestroy()
{
   StringID.vDestroy(); 
}

sds2hmi_fi_tcl_StringIDElement::sds2hmi_fi_tcl_StringIDElement()
:Properties()
,StringID()
 {}

tS32 sds2hmi_fi_tcl_StringIDElement::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGIDELEMENT;
}


sds2hmi_fi_tcl_StringIDElement::~sds2hmi_fi_tcl_StringIDElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringIDElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+StringID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringIDElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Properties);
   (tVoid) (oIn >> StringID);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringIDElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Properties);
   (tVoid) (oOut << StringID);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringIDElement::operator==(const sds2hmi_fi_tcl_StringIDElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Properties == roRef.Properties);
   bResult = bResult && (StringID == roRef.StringID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringIDList::sds2hmi_fi_tcl_StringIDList(const sds2hmi_fi_tcl_StringIDList& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   StringIDList = coRef.StringIDList;
}
sds2hmi_fi_tcl_StringIDList& sds2hmi_fi_tcl_StringIDList::operator=(const sds2hmi_fi_tcl_StringIDList& coRef)
{
   if (this == &coRef) return *this;
   StringIDList = coRef.StringIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringIDList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringIDList.size(); ++u32Idx)
         StringIDList[u32Idx].vDestroy();
   StringIDList.clear();
   }
}

sds2hmi_fi_tcl_StringIDList::sds2hmi_fi_tcl_StringIDList()

 {}

tS32 sds2hmi_fi_tcl_StringIDList::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGIDLIST;
}


sds2hmi_fi_tcl_StringIDList::~sds2hmi_fi_tcl_StringIDList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringIDList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringIDList.size(); ++u32ListIdx)
      u32DynamicSize += StringIDList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_StringIDList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringIDList.size(); ++u32Idx)
      {
         StringIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringIDList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringIDList.size(); ++u32Idx)
         (tVoid) (oOut << StringIDList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_StringIDList::operator==(const sds2hmi_fi_tcl_StringIDList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringIDList.size() == roRef.StringIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringIDList.size()); ++u32Idx)
            bResult = bResult && (StringIDList[u32Idx] == roRef.StringIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_PositionWGS84Element::sds2hmi_fi_tcl_PositionWGS84Element(const sds2hmi_fi_tcl_PositionWGS84Element& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   PositionWGS84 = coRef.PositionWGS84;
}
sds2hmi_fi_tcl_PositionWGS84Element& sds2hmi_fi_tcl_PositionWGS84Element::operator=(const sds2hmi_fi_tcl_PositionWGS84Element& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   PositionWGS84 = coRef.PositionWGS84;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_PositionWGS84Element::sds2hmi_fi_tcl_PositionWGS84Element()
:Properties()
,PositionWGS84()
 {}

tS32 sds2hmi_fi_tcl_PositionWGS84Element::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_POSITIONWGS84ELEMENT;
}


sds2hmi_fi_tcl_PositionWGS84Element::~sds2hmi_fi_tcl_PositionWGS84Element()
{}

tU32 sds2hmi_fi_tcl_PositionWGS84Element::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds2hmi_fi_tcl_PositionWGS84Element::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Properties);
   (tVoid) (oIn >> PositionWGS84);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_PositionWGS84Element::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Properties);
   (tVoid) (oOut << PositionWGS84);
   return oOut;
}

tBool sds2hmi_fi_tcl_PositionWGS84Element::operator==(const sds2hmi_fi_tcl_PositionWGS84Element& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Properties == roRef.Properties);
   bResult = bResult && (PositionWGS84 == roRef.PositionWGS84);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_PositionWGS84List::sds2hmi_fi_tcl_PositionWGS84List(const sds2hmi_fi_tcl_PositionWGS84List& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   PositionWGS84List = coRef.PositionWGS84List;
}
sds2hmi_fi_tcl_PositionWGS84List& sds2hmi_fi_tcl_PositionWGS84List::operator=(const sds2hmi_fi_tcl_PositionWGS84List& coRef)
{
   if (this == &coRef) return *this;
   PositionWGS84List = coRef.PositionWGS84List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_PositionWGS84List::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PositionWGS84List.size(); ++u32Idx)
         PositionWGS84List[u32Idx].vDestroy();
   PositionWGS84List.clear();
   }
}

sds2hmi_fi_tcl_PositionWGS84List::sds2hmi_fi_tcl_PositionWGS84List()

 {}

tS32 sds2hmi_fi_tcl_PositionWGS84List::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_POSITIONWGS84LIST;
}


sds2hmi_fi_tcl_PositionWGS84List::~sds2hmi_fi_tcl_PositionWGS84List()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_PositionWGS84List::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+PositionWGS84List.size()*10;
}

fi_tclInContext& sds2hmi_fi_tcl_PositionWGS84List::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PositionWGS84List.size(); ++u32Idx)
      {
         PositionWGS84List[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PositionWGS84List.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PositionWGS84List[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_PositionWGS84List::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PositionWGS84List.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PositionWGS84List.size(); ++u32Idx)
         (tVoid) (oOut << PositionWGS84List[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_PositionWGS84List::operator==(const sds2hmi_fi_tcl_PositionWGS84List& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PositionWGS84List.size() == roRef.PositionWGS84List.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PositionWGS84List.size()); ++u32Idx)
            bResult = bResult && (PositionWGS84List[u32Idx] == roRef.PositionWGS84List[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringPositionElement::sds2hmi_fi_tcl_StringPositionElement(const sds2hmi_fi_tcl_StringPositionElement& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   StringPosition = coRef.StringPosition;
}
sds2hmi_fi_tcl_StringPositionElement& sds2hmi_fi_tcl_StringPositionElement::operator=(const sds2hmi_fi_tcl_StringPositionElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   StringPosition = coRef.StringPosition;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringPositionElement::vDestroy()
{
   StringPosition.vDestroy(); 
}

sds2hmi_fi_tcl_StringPositionElement::sds2hmi_fi_tcl_StringPositionElement()
:Properties()
,StringPosition()
 {}

tS32 sds2hmi_fi_tcl_StringPositionElement::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGPOSITIONELEMENT;
}


sds2hmi_fi_tcl_StringPositionElement::~sds2hmi_fi_tcl_StringPositionElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringPositionElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+StringPosition.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringPositionElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Properties);
   (tVoid) (oIn >> StringPosition);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringPositionElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Properties);
   (tVoid) (oOut << StringPosition);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringPositionElement::operator==(const sds2hmi_fi_tcl_StringPositionElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Properties == roRef.Properties);
   bResult = bResult && (StringPosition == roRef.StringPosition);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringPositionList::sds2hmi_fi_tcl_StringPositionList(const sds2hmi_fi_tcl_StringPositionList& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   StringPositionList = coRef.StringPositionList;
}
sds2hmi_fi_tcl_StringPositionList& sds2hmi_fi_tcl_StringPositionList::operator=(const sds2hmi_fi_tcl_StringPositionList& coRef)
{
   if (this == &coRef) return *this;
   StringPositionList = coRef.StringPositionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringPositionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionList.size(); ++u32Idx)
         StringPositionList[u32Idx].vDestroy();
   StringPositionList.clear();
   }
}

sds2hmi_fi_tcl_StringPositionList::sds2hmi_fi_tcl_StringPositionList()

 {}

tS32 sds2hmi_fi_tcl_StringPositionList::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGPOSITIONLIST;
}


sds2hmi_fi_tcl_StringPositionList::~sds2hmi_fi_tcl_StringPositionList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringPositionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringPositionList.size(); ++u32ListIdx)
      u32DynamicSize += StringPositionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_StringPositionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringPositionList.size(); ++u32Idx)
      {
         StringPositionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringPositionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringPositionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringPositionList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringPositionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionList.size(); ++u32Idx)
         (tVoid) (oOut << StringPositionList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_StringPositionList::operator==(const sds2hmi_fi_tcl_StringPositionList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringPositionList.size() == roRef.StringPositionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringPositionList.size()); ++u32Idx)
            bResult = bResult && (StringPositionList[u32Idx] == roRef.StringPositionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringPositionDescriptionElement::sds2hmi_fi_tcl_StringPositionDescriptionElement(const sds2hmi_fi_tcl_StringPositionDescriptionElement& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Properties = coRef.Properties;
   ElementStringPosition = coRef.ElementStringPosition;
   DescriptionString = coRef.DescriptionString;
}
sds2hmi_fi_tcl_StringPositionDescriptionElement& sds2hmi_fi_tcl_StringPositionDescriptionElement::operator=(const sds2hmi_fi_tcl_StringPositionDescriptionElement& coRef)
{
   if (this == &coRef) return *this;
   Properties = coRef.Properties;
   ElementStringPosition = coRef.ElementStringPosition;
   DescriptionString = coRef.DescriptionString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringPositionDescriptionElement::vDestroy()
{
   ElementStringPosition.vDestroy(); 
   DescriptionString.vDestroy();
}

sds2hmi_fi_tcl_StringPositionDescriptionElement::sds2hmi_fi_tcl_StringPositionDescriptionElement()
:Properties()
,ElementStringPosition()
,DescriptionString()
 {}

tS32 sds2hmi_fi_tcl_StringPositionDescriptionElement::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGPOSITIONDESCRIPTIONELEMENT;
}


sds2hmi_fi_tcl_StringPositionDescriptionElement::~sds2hmi_fi_tcl_StringPositionDescriptionElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringPositionDescriptionElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ElementStringPosition.u32GetSize(u16MajorVersion)+DescriptionString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringPositionDescriptionElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Properties);
   (tVoid) (oIn >> ElementStringPosition);
   (tVoid) (oIn >> DescriptionString);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringPositionDescriptionElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Properties);
   (tVoid) (oOut << ElementStringPosition);
   (tVoid) (oOut << DescriptionString);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringPositionDescriptionElement::operator==(const sds2hmi_fi_tcl_StringPositionDescriptionElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Properties == roRef.Properties);
   bResult = bResult && (ElementStringPosition == roRef.ElementStringPosition);
   bResult = bResult && (DescriptionString == roRef.DescriptionString);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringPositionDescriptionList::sds2hmi_fi_tcl_StringPositionDescriptionList(const sds2hmi_fi_tcl_StringPositionDescriptionList& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   StringPositionDescriptionList = coRef.StringPositionDescriptionList;
}
sds2hmi_fi_tcl_StringPositionDescriptionList& sds2hmi_fi_tcl_StringPositionDescriptionList::operator=(const sds2hmi_fi_tcl_StringPositionDescriptionList& coRef)
{
   if (this == &coRef) return *this;
   StringPositionDescriptionList = coRef.StringPositionDescriptionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringPositionDescriptionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionDescriptionList.size(); ++u32Idx)
         StringPositionDescriptionList[u32Idx].vDestroy();
   StringPositionDescriptionList.clear();
   }
}

sds2hmi_fi_tcl_StringPositionDescriptionList::sds2hmi_fi_tcl_StringPositionDescriptionList()

 {}

tS32 sds2hmi_fi_tcl_StringPositionDescriptionList::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGPOSITIONDESCRIPTIONLIST;
}


sds2hmi_fi_tcl_StringPositionDescriptionList::~sds2hmi_fi_tcl_StringPositionDescriptionList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringPositionDescriptionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringPositionDescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += StringPositionDescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_StringPositionDescriptionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringPositionDescriptionList.size(); ++u32Idx)
      {
         StringPositionDescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringPositionDescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringPositionDescriptionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringPositionDescriptionList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringPositionDescriptionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringPositionDescriptionList.size(); ++u32Idx)
         (tVoid) (oOut << StringPositionDescriptionList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_StringPositionDescriptionList::operator==(const sds2hmi_fi_tcl_StringPositionDescriptionList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringPositionDescriptionList.size() == roRef.StringPositionDescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringPositionDescriptionList.size()); ++u32Idx)
            bResult = bResult && (StringPositionDescriptionList[u32Idx] == roRef.StringPositionDescriptionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_CriterionStatus::sds2hmi_fi_tcl_b8_CriterionStatus():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_CriterionStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_CRITERIONSTATUS;
}


sds2hmi_fi_tcl_b8_CriterionStatus::~sds2hmi_fi_tcl_b8_CriterionStatus()
{}

tU32 sds2hmi_fi_tcl_b8_CriterionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_CriterionStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_CriterionStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_ListSortOptions::sds2hmi_fi_tcl_b8_ListSortOptions():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_ListSortOptions::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_LISTSORTOPTIONS;
}


sds2hmi_fi_tcl_b8_ListSortOptions::~sds2hmi_fi_tcl_b8_ListSortOptions()
{}

tU32 sds2hmi_fi_tcl_b8_ListSortOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_ListSortOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_ListSortOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SelectionCriterionDescription::sds2hmi_fi_tcl_SelectionCriterionDescription(const sds2hmi_fi_tcl_SelectionCriterionDescription& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   Description = coRef.Description;
}
sds2hmi_fi_tcl_SelectionCriterionDescription& sds2hmi_fi_tcl_SelectionCriterionDescription::operator=(const sds2hmi_fi_tcl_SelectionCriterionDescription& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   Description = coRef.Description;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_SelectionCriterionDescription::vDestroy()
{
   Description.vDestroy();
}

sds2hmi_fi_tcl_SelectionCriterionDescription::sds2hmi_fi_tcl_SelectionCriterionDescription()
:SelectionCriterion()
,Description()
 {}

tS32 sds2hmi_fi_tcl_SelectionCriterionDescription::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SELECTIONCRITERIONDESCRIPTION;
}


sds2hmi_fi_tcl_SelectionCriterionDescription::~sds2hmi_fi_tcl_SelectionCriterionDescription()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_SelectionCriterionDescription::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Description.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_SelectionCriterionDescription::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionCriterion);
   (tVoid) (oIn >> Description);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SelectionCriterionDescription::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionCriterion);
   (tVoid) (oOut << Description);
   return oOut;
}

tBool sds2hmi_fi_tcl_SelectionCriterionDescription::operator==(const sds2hmi_fi_tcl_SelectionCriterionDescription& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionCriterion == roRef.SelectionCriterion);
   bResult = bResult && (Description == roRef.Description);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_CriteriaGetOptions::sds2hmi_fi_tcl_b8_CriteriaGetOptions():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_CriteriaGetOptions::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_CRITERIAGETOPTIONS;
}


sds2hmi_fi_tcl_b8_CriteriaGetOptions::~sds2hmi_fi_tcl_b8_CriteriaGetOptions()
{}

tU32 sds2hmi_fi_tcl_b8_CriteriaGetOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_CriteriaGetOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_CriteriaGetOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SelectableCriterion::sds2hmi_fi_tcl_SelectableCriterion(const sds2hmi_fi_tcl_SelectableCriterion& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   SortOption = coRef.SortOption;
   AttributesAvailable = coRef.AttributesAvailable;
   Status = coRef.Status;
   NumOfPOI = coRef.NumOfPOI;
}
sds2hmi_fi_tcl_SelectableCriterion& sds2hmi_fi_tcl_SelectableCriterion::operator=(const sds2hmi_fi_tcl_SelectableCriterion& coRef)
{
   if (this == &coRef) return *this;
   SelectionCriterion = coRef.SelectionCriterion;
   DataType = coRef.DataType;
   SortOption = coRef.SortOption;
   AttributesAvailable = coRef.AttributesAvailable;
   Status = coRef.Status;
   NumOfPOI = coRef.NumOfPOI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_SelectableCriterion::sds2hmi_fi_tcl_SelectableCriterion()
:SelectionCriterion()
,DataType()
,SortOption()
,AttributesAvailable(0)
,Status()
,NumOfPOI(0)
 {}

tS32 sds2hmi_fi_tcl_SelectableCriterion::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SELECTABLECRITERION;
}


sds2hmi_fi_tcl_SelectableCriterion::~sds2hmi_fi_tcl_SelectableCriterion()
{}

tU32 sds2hmi_fi_tcl_SelectableCriterion::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (13 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (19 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+5;
}

fi_tclInContext& sds2hmi_fi_tcl_SelectableCriterion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionCriterion);
   (tVoid) (oIn >> DataType);
   (tVoid) (oIn >> SortOption);
   (tVoid) (oIn >> AttributesAvailable);
   if (13 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> Status);
   }
   if (19 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> NumOfPOI);
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SelectableCriterion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionCriterion);
   (tVoid) (oOut << DataType);
   (tVoid) (oOut << SortOption);
   (tVoid) (oOut << AttributesAvailable);
   if (13 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << Status);
   }
   if (19 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << NumOfPOI);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_SelectableCriterion::operator==(const sds2hmi_fi_tcl_SelectableCriterion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionCriterion == roRef.SelectionCriterion);
   bResult = bResult && (DataType == roRef.DataType);
   bResult = bResult && (SortOption == roRef.SortOption);
   bResult = bResult && (AttributesAvailable == roRef.AttributesAvailable);
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (NumOfPOI == roRef.NumOfPOI);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TransformMode::sds2hmi_fi_tcl_e8_TransformMode():enType(FI_EN_RESOLVENAME) {}

tS32 sds2hmi_fi_tcl_e8_TransformMode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TRANSFORMMODE;
}


sds2hmi_fi_tcl_e8_TransformMode::~sds2hmi_fi_tcl_e8_TransformMode()
{}

tU32 sds2hmi_fi_tcl_e8_TransformMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TransformMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TransformMode::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_TransformMode::tenType enData = enType;
   if ((enData == FI_EN_ASSIGNADDRESSPARTS) && !(19 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_GETNAVINFO;
   }
   if ((enData == FI_EN_GETADDRESSINFOFORPOSITION) && !(15 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_RESOLVENAMEANDGETNAVINFO;
   }
   if ((enData == FI_EN_GETEDITABLEADDRESSFORPOSITION) && !(15 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_RESOLVENAMEANDGETNAVINFO;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b16_PositionReliability::sds2hmi_fi_tcl_b16_PositionReliability():u16Value(0)
{}

tS32 sds2hmi_fi_tcl_b16_PositionReliability::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B16_POSITIONRELIABILITY;
}


sds2hmi_fi_tcl_b16_PositionReliability::~sds2hmi_fi_tcl_b16_PositionReliability()
{}

tU32 sds2hmi_fi_tcl_b16_PositionReliability::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_b16_PositionReliability::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b16_PositionReliability::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_PositionHeadingSpeed::sds2hmi_fi_tcl_PositionHeadingSpeed(const sds2hmi_fi_tcl_PositionHeadingSpeed& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   PositionWGS84 = coRef.PositionWGS84;
   PositionReliability = coRef.PositionReliability;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
}
sds2hmi_fi_tcl_PositionHeadingSpeed& sds2hmi_fi_tcl_PositionHeadingSpeed::operator=(const sds2hmi_fi_tcl_PositionHeadingSpeed& coRef)
{
   if (this == &coRef) return *this;
   PositionWGS84 = coRef.PositionWGS84;
   PositionReliability = coRef.PositionReliability;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_PositionHeadingSpeed::sds2hmi_fi_tcl_PositionHeadingSpeed()
:PositionWGS84()
,PositionReliability()
,Speed()
,Heading()
 {}

tS32 sds2hmi_fi_tcl_PositionHeadingSpeed::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_POSITIONHEADINGSPEED;
}


sds2hmi_fi_tcl_PositionHeadingSpeed::~sds2hmi_fi_tcl_PositionHeadingSpeed()
{}

tU32 sds2hmi_fi_tcl_PositionHeadingSpeed::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& sds2hmi_fi_tcl_PositionHeadingSpeed::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PositionWGS84);
   (tVoid) (oIn >> PositionReliability);
   (tVoid) (oIn >> Speed);
   (tVoid) (oIn >> Heading);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_PositionHeadingSpeed::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PositionWGS84);
   (tVoid) (oOut << PositionReliability);
   (tVoid) (oOut << Speed);
   (tVoid) (oOut << Heading);
   return oOut;
}

tBool sds2hmi_fi_tcl_PositionHeadingSpeed::operator==(const sds2hmi_fi_tcl_PositionHeadingSpeed& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PositionWGS84 == roRef.PositionWGS84);
   bResult = bResult && (PositionReliability == roRef.PositionReliability);
   bResult = bResult && (Speed == roRef.Speed);
   bResult = bResult && (Heading == roRef.Heading);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NavLocationDescType::sds2hmi_fi_tcl_e8_NavLocationDescType():enType(FI_EN_T_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_NavLocationDescType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAVLOCATIONDESCTYPE;
}


sds2hmi_fi_tcl_e8_NavLocationDescType::~sds2hmi_fi_tcl_e8_NavLocationDescType()
{}

tU32 sds2hmi_fi_tcl_e8_NavLocationDescType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NavLocationDescType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NavLocationDescType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavLocationDesc::sds2hmi_fi_tcl_NavLocationDesc(const sds2hmi_fi_tcl_NavLocationDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   NavLocationDescTypeType = coRef.NavLocationDescTypeType;
   if  (coRef.poNavLocationDescTypeData)
   {
      switch(NavLocationDescTypeType.enType)
      {
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poNavLocationDescTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavLocationDataDesc((const sds2hmi_fi_tcl_NavLocationDataDesc&)*coRef.poNavLocationDescTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavAreaDescriptionCircle((const sds2hmi_fi_tcl_NavAreaDescriptionCircle&)*coRef.poNavLocationDescTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavAreaDescriptionPolygon((const sds2hmi_fi_tcl_NavAreaDescriptionPolygon&)*coRef.poNavLocationDescTypeData);
         break;
      default:
         poNavLocationDescTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavLocationDescTypeData = OSAL_NULL;
   }
}
sds2hmi_fi_tcl_NavLocationDesc& sds2hmi_fi_tcl_NavLocationDesc::operator=(const sds2hmi_fi_tcl_NavLocationDesc& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poNavLocationDescTypeData;
   NavLocationDescTypeType = coRef.NavLocationDescTypeType;
   if  (coRef.poNavLocationDescTypeData)
   {
      switch(NavLocationDescTypeType.enType)
      {
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poNavLocationDescTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavLocationDataDesc((const sds2hmi_fi_tcl_NavLocationDataDesc&)*coRef.poNavLocationDescTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavAreaDescriptionCircle((const sds2hmi_fi_tcl_NavAreaDescriptionCircle&)*coRef.poNavLocationDescTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavAreaDescriptionPolygon((const sds2hmi_fi_tcl_NavAreaDescriptionPolygon&)*coRef.poNavLocationDescTypeData);
         break;
      default:
         poNavLocationDescTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavLocationDescTypeData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NavLocationDesc::vDestroy()
{
   if (poNavLocationDescTypeData)
   {
      poNavLocationDescTypeData->vDestroy();
      OSAL_DELETE poNavLocationDescTypeData;
      poNavLocationDescTypeData = OSAL_NULL;
   }
}

sds2hmi_fi_tcl_NavLocationDesc::sds2hmi_fi_tcl_NavLocationDesc()
:poNavLocationDescTypeData(0)
 {}

tS32 sds2hmi_fi_tcl_NavLocationDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVLOCATIONDESC;
}


sds2hmi_fi_tcl_NavLocationDesc::~sds2hmi_fi_tcl_NavLocationDesc()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NavLocationDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poNavLocationDescTypeData?poNavLocationDescTypeData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds2hmi_fi_tcl_NavLocationDesc::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poNavLocationDescTypeData;
#else
   if (poNavLocationDescTypeData)
   {
      poNavLocationDescTypeData->vDestroy();
      OSAL_DELETE poNavLocationDescTypeData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> NavLocationDescTypeType);
   switch(NavLocationDescTypeType.enType)
   {
   case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
      poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_Reserved;
      break;
   case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
      poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavLocationDataDesc;
      break;
   case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
      poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavAreaDescriptionCircle;
      break;
   case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
      poNavLocationDescTypeData = OSAL_NEW sds2hmi_fi_tcl_NavAreaDescriptionPolygon;
      break;
   default:
      oIn.Invalidate();
      poNavLocationDescTypeData = OSAL_NULL;
   }
   if (poNavLocationDescTypeData && oIn.bIsValid())
      poNavLocationDescTypeData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavLocationDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NavLocationDescTypeType);
   if (poNavLocationDescTypeData)
   {
      (tVoid) poNavLocationDescTypeData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_NavLocationDesc::operator==(const sds2hmi_fi_tcl_NavLocationDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NavLocationDescTypeType == roRef.NavLocationDescTypeType);
   if (bResult && poNavLocationDescTypeData && roRef.poNavLocationDescTypeData) 
   {
      switch (NavLocationDescTypeType.enType)
      {
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds2hmi_fi_tcl_Reserved*)poNavLocationDescTypeData == *(const sds2hmi_fi_tcl_Reserved*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVLOCATIONDATADESC:
         bResult = bResult && (*(const sds2hmi_fi_tcl_NavLocationDataDesc*)poNavLocationDescTypeData == *(const sds2hmi_fi_tcl_NavLocationDataDesc*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONCIRCLE:
         bResult = bResult && (*(const sds2hmi_fi_tcl_NavAreaDescriptionCircle*)poNavLocationDescTypeData == *(const sds2hmi_fi_tcl_NavAreaDescriptionCircle*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_NavLocationDescType::FI_EN_T_NAVAREADESCRIPTIONPOLYGON:
         bResult = bResult && (*(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon*)poNavLocationDescTypeData == *(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon*)roRef.poNavLocationDescTypeData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poNavLocationDescTypeData == roRef.poNavLocationDescTypeData);
   }
   return bResult;
}

//=============================================================================

#ifndef FI_S_EXTERNAL_FI
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavLocationBinContainer::sds2hmi_fi_tcl_NavLocationBinContainer(const sds2hmi_fi_tcl_NavLocationBinContainer& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   ContainerData = coRef.ContainerData;
}
sds2hmi_fi_tcl_NavLocationBinContainer& sds2hmi_fi_tcl_NavLocationBinContainer::operator=(const sds2hmi_fi_tcl_NavLocationBinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerLength = coRef.ContainerLength;
   ServiceID = coRef.ServiceID;
   ContainerFIVersion = coRef.ContainerFIVersion;
   ContainerType = coRef.ContainerType;
   ContainerData = coRef.ContainerData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NavLocationBinContainer::vDestroy()
{
   ContainerFIVersion.vDestroy(); 
   ContainerData.vDestroy(); 
}

sds2hmi_fi_tcl_NavLocationBinContainer::sds2hmi_fi_tcl_NavLocationBinContainer()
:ContainerLength(0)
,ServiceID(0)
,ContainerFIVersion()
,ContainerType()
,ContainerData()
 {}

tS32 sds2hmi_fi_tcl_NavLocationBinContainer::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVLOCATIONBINCONTAINER;
}


sds2hmi_fi_tcl_NavLocationBinContainer::~sds2hmi_fi_tcl_NavLocationBinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NavLocationBinContainer::u32GetSize(tU16 u16MajorVersion) const
{
   u16MajorVersion = ContainerFIVersion.MajorVersion;
   return 10+ContainerData.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_NavLocationBinContainer::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContainerLength);
   (tVoid) (oIn >> ServiceID);
   (tVoid) (oIn >> ContainerFIVersion);
   (tVoid) (oIn >> ContainerType);
   if (!oIn.bIsValid() ||
       (ContainerLength <= 6) ||
       (ContainerType.enType != sds2hmi_fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVLOCATIONBINCONTAINER) ||
       (ContainerFIVersion.MajorVersion < sds2hmi_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN) ||
       (ContainerFIVersion.MajorVersion > sds2hmi_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX))
   {
      if (oIn.bIsValid() && (ContainerLength >= 6))
      {
         // read rest of container but discard it
         for (tU32 u32Dummy = 0; u32Dummy < (ContainerLength - 6); ++u32Dummy)
         {
            tU8 u8Dummy;
            oIn.oRead(u8Dummy);
         }
      }
      else
      {
         oIn.Invalidate();
      }
      return oIn;
   }
   tU16 u16MajorVersion = oIn.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   (tVoid) (oIn >> ContainerData);
   oIn.u16SetMajorVersion(u16MajorVersion);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavLocationBinContainer::oWrite(fi_tclOutContext& oOut) const
{
   tU16 u16MajorVersion = oOut.u16SetMajorVersion(ContainerFIVersion.MajorVersion);
   (tVoid) (oOut << ContainerLength);
   (tVoid) (oOut << ServiceID);
   (tVoid) (oOut << ContainerFIVersion);
   (tVoid) (oOut << ContainerType);
   (tVoid) (oOut << ContainerData);
   oOut.u16SetMajorVersion(u16MajorVersion);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavLocationBinContainer::operator==(const sds2hmi_fi_tcl_NavLocationBinContainer& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContainerLength == roRef.ContainerLength);
   bResult = bResult && (ServiceID == roRef.ServiceID);
   bResult = bResult && (ContainerFIVersion == roRef.ContainerFIVersion);
   bResult = bResult && (ContainerType == roRef.ContainerType);
   bResult = bResult && (ContainerData == roRef.ContainerData);
   return bResult;
}

tU16 sds2hmi_fi_tcl_NavLocationBinContainer::u16Transform(const sds2hmi_fi_tcl_BinContainer& oContainer)
{
   tU16 u16RetVal = 0;
   if (&oContainer != OSAL_NULL) //lint !e774 (&oContainer CAN be NULL!!)
   {
      this->vDestroy();
      tU32 u32MinSize = this->u32GetSize(sds2hmi_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX);
      tU32 u32Size = oContainer.u32GetSize(0);
      if (u32Size >= u32MinSize)
      {
         tU8* pu8Buf = OSAL_NEW tU8[u32Size];
         if (pu8Buf != OSAL_NULL)
         {
            if (oContainer.ContainerDataList[8] == (tU8)sds2hmi_fi_tcl_e8_BinContainerTypes::FI_EN_T_NAVLOCATIONBINCONTAINER)
            {
               tU16 u16MajorVersion = oContainer.ContainerDataList[2] + (oContainer.ContainerDataList[3] << 8);
               if ((u16MajorVersion >= sds2hmi_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN) &&
                   (u16MajorVersion <= sds2hmi_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX))
               {
                  fi_tclOutContext oOut(pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  fi_tclInContext  oIn (pu8Buf,pu8Buf+u32Size,u16MajorVersion);
                  (tVoid) (oOut << oContainer);
                  (tVoid) (oIn >> *this);
                  if (!oIn.bIsValid())
                  {
                     u16RetVal = SDS2HMI_FI_C_U16_ERROR_INTERNALFAILURE;
                  }
               }
               else
               {
                  u16RetVal = SDS2HMI_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION;
               }
            }
            else
            {
               u16RetVal = SDS2HMI_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
            }
         }
         else
         {
            this->ContainerType.enType = sds2hmi_fi_tcl_e8_BinContainerTypes::FI_EN_T_RESERVED;
            u16RetVal = SDS2HMI_FI_C_U16_ERROR_INTERNALFAILURE;
         }
         OSAL_DELETE[] pu8Buf;
      }
      else
      {
         u16RetVal = SDS2HMI_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
      }
   }
   else
   {
      u16RetVal = SDS2HMI_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA;
   }
   return u16RetVal;
}

const tU16 sds2hmi_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MAX = 33;
const tU16 sds2hmi_fi_tcl_NavLocationBinContainer::C_U16_MAJORVERSION_MIN = 6;

#endif // FI_S_EXTERNAL_FI
//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NavIndexZFDestinationType::sds2hmi_fi_tcl_e8_NavIndexZFDestinationType():enType(FI_EN_CENTRE) {}

tS32 sds2hmi_fi_tcl_e8_NavIndexZFDestinationType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAVINDEXZFDESTINATIONTYPE;
}


sds2hmi_fi_tcl_e8_NavIndexZFDestinationType::~sds2hmi_fi_tcl_e8_NavIndexZFDestinationType()
{}

tU32 sds2hmi_fi_tcl_e8_NavIndexZFDestinationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NavIndexZFDestinationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NavIndexZFDestinationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NavLocationNavDataType::sds2hmi_fi_tcl_e8_NavLocationNavDataType():enType(FI_EN_T_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_NavLocationNavDataType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAVLOCATIONNAVDATATYPE;
}


sds2hmi_fi_tcl_e8_NavLocationNavDataType::~sds2hmi_fi_tcl_e8_NavLocationNavDataType()
{}

tU32 sds2hmi_fi_tcl_e8_NavLocationNavDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NavLocationNavDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NavLocationNavDataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u32_DataSetId::sds2hmi_fi_tcl_u32_DataSetId(tU32 _u32Value)
: u32Value(_u32Value
) {} 

tS32 sds2hmi_fi_tcl_u32_DataSetId::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U32_DATASETID;
}


sds2hmi_fi_tcl_u32_DataSetId::~sds2hmi_fi_tcl_u32_DataSetId()
{}

tU32 sds2hmi_fi_tcl_u32_DataSetId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_u32_DataSetId::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u32_DataSetId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SideInfo::sds2hmi_fi_tcl_e8_SideInfo():enType(FI_EN_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_SideInfo::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SIDEINFO;
}


sds2hmi_fi_tcl_e8_SideInfo::~sds2hmi_fi_tcl_e8_SideInfo()
{}

tU32 sds2hmi_fi_tcl_e8_SideInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SideInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SideInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NavOneCellDirection::sds2hmi_fi_tcl_e8_NavOneCellDirection():enType(FI_EN_NO) {}

tS32 sds2hmi_fi_tcl_e8_NavOneCellDirection::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAVONECELLDIRECTION;
}


sds2hmi_fi_tcl_e8_NavOneCellDirection::~sds2hmi_fi_tcl_e8_NavOneCellDirection()
{}

tU32 sds2hmi_fi_tcl_e8_NavOneCellDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NavOneCellDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NavOneCellDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavClusterDesc::sds2hmi_fi_tcl_NavClusterDesc(const sds2hmi_fi_tcl_NavClusterDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Level = coRef.Level;
   FileId = coRef.FileId;
   FileOffset = coRef.FileOffset;
   Length = coRef.Length;
}
sds2hmi_fi_tcl_NavClusterDesc& sds2hmi_fi_tcl_NavClusterDesc::operator=(const sds2hmi_fi_tcl_NavClusterDesc& coRef)
{
   if (this == &coRef) return *this;
   Level = coRef.Level;
   FileId = coRef.FileId;
   FileOffset = coRef.FileOffset;
   Length = coRef.Length;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavClusterDesc::sds2hmi_fi_tcl_NavClusterDesc()
:Level(0)
,FileId(0)
,FileOffset(0)
,Length(0)
 {}

tS32 sds2hmi_fi_tcl_NavClusterDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVCLUSTERDESC;
}


sds2hmi_fi_tcl_NavClusterDesc::~sds2hmi_fi_tcl_NavClusterDesc()
{}

tU32 sds2hmi_fi_tcl_NavClusterDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds2hmi_fi_tcl_NavClusterDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Level);
   (tVoid) (oIn >> FileId);
   (tVoid) (oIn >> FileOffset);
   (tVoid) (oIn >> Length);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavClusterDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Level);
   (tVoid) (oOut << FileId);
   (tVoid) (oOut << FileOffset);
   (tVoid) (oOut << Length);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavClusterDesc::operator==(const sds2hmi_fi_tcl_NavClusterDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Level == roRef.Level);
   bResult = bResult && (FileId == roRef.FileId);
   bResult = bResult && (FileOffset == roRef.FileOffset);
   bResult = bResult && (Length == roRef.Length);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty(const sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SideInfo = coRef.SideInfo;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}
sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::operator=(const sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   SideInfo = coRef.SideInfo;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty()
:SideInfo()
,IndexInObjectPointRefList()
,IndexInAccessPointRefList()
 {}

tS32 sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLPROPERTY;
}


sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::~sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty()
{}

tU32 sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SideInfo);
   (tVoid) (oIn >> IndexInObjectPointRefList);
   (tVoid) (oIn >> IndexInAccessPointRefList);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SideInfo);
   (tVoid) (oOut << IndexInObjectPointRefList);
   (tVoid) (oOut << IndexInAccessPointRefList);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty::operator==(const sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SideInfo == roRef.SideInfo);
   bResult = bResult && (IndexInObjectPointRefList == roRef.IndexInObjectPointRefList);
   bResult = bResult && (IndexInAccessPointRefList == roRef.IndexInAccessPointRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavOneCellDesc::sds2hmi_fi_tcl_NavOneCellDesc(const sds2hmi_fi_tcl_NavOneCellDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
}
sds2hmi_fi_tcl_NavOneCellDesc& sds2hmi_fi_tcl_NavOneCellDesc::operator=(const sds2hmi_fi_tcl_NavOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavOneCellDesc::sds2hmi_fi_tcl_NavOneCellDesc()
:OneCellId(0)
,UseDirection()
,IndexInClusterRefList()
 {}

tS32 sds2hmi_fi_tcl_NavOneCellDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVONECELLDESC;
}


sds2hmi_fi_tcl_NavOneCellDesc::~sds2hmi_fi_tcl_NavOneCellDesc()
{}

tU32 sds2hmi_fi_tcl_NavOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_fi_tcl_NavOneCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellId);
   (tVoid) (oIn >> UseDirection);
   (tVoid) (oIn >> IndexInClusterRefList);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellId);
   (tVoid) (oOut << UseDirection);
   (tVoid) (oOut << IndexInClusterRefList);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavOneCellDesc::operator==(const sds2hmi_fi_tcl_NavOneCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellId == roRef.OneCellId);
   bResult = bResult && (UseDirection == roRef.UseDirection);
   bResult = bResult && (IndexInClusterRefList == roRef.IndexInClusterRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc(const sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}
sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::operator=(const sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc()
:OneCellDesc()
,OneCellProperty()
 {}

tS32 sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLDESC;
}


sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::~sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc()
{}

tU32 sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellDesc);
   (tVoid) (oIn >> OneCellProperty);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellDesc);
   (tVoid) (oOut << OneCellProperty);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc::operator==(const sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellDesc == roRef.OneCellDesc);
   bResult = bResult && (OneCellProperty == roRef.OneCellProperty);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NavIntersectionType::sds2hmi_fi_tcl_e8_NavIntersectionType():enType(FI_EN_OBJECTINTERSECTION) {}

tS32 sds2hmi_fi_tcl_e8_NavIntersectionType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAVINTERSECTIONTYPE;
}


sds2hmi_fi_tcl_e8_NavIntersectionType::~sds2hmi_fi_tcl_e8_NavIntersectionType()
{}

tU32 sds2hmi_fi_tcl_e8_NavIntersectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NavIntersectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NavIntersectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavZeroCellDesc::sds2hmi_fi_tcl_NavZeroCellDesc(const sds2hmi_fi_tcl_NavZeroCellDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ZeroCellId = coRef.ZeroCellId;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
}
sds2hmi_fi_tcl_NavZeroCellDesc& sds2hmi_fi_tcl_NavZeroCellDesc::operator=(const sds2hmi_fi_tcl_NavZeroCellDesc& coRef)
{
   if (this == &coRef) return *this;
   ZeroCellId = coRef.ZeroCellId;
   IndexInClusterRefList = coRef.IndexInClusterRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavZeroCellDesc::sds2hmi_fi_tcl_NavZeroCellDesc()
:ZeroCellId(0)
,IndexInClusterRefList()
 {}

tS32 sds2hmi_fi_tcl_NavZeroCellDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVZEROCELLDESC;
}


sds2hmi_fi_tcl_NavZeroCellDesc::~sds2hmi_fi_tcl_NavZeroCellDesc()
{}

tU32 sds2hmi_fi_tcl_NavZeroCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_NavZeroCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ZeroCellId);
   (tVoid) (oIn >> IndexInClusterRefList);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavZeroCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ZeroCellId);
   (tVoid) (oOut << IndexInClusterRefList);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavZeroCellDesc::operator==(const sds2hmi_fi_tcl_NavZeroCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ZeroCellId == roRef.ZeroCellId);
   bResult = bResult && (IndexInClusterRefList == roRef.IndexInClusterRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   IntersectionType = coRef.IntersectionType;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}
sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::operator=(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef)
{
   if (this == &coRef) return *this;
   IntersectionType = coRef.IntersectionType;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty()
:IntersectionType()
,IndexInObjectPointRefList()
,IndexInAccessPointRefList()
 {}

tS32 sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLPROPERTY;
}


sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::~sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty()
{}

tU32 sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IntersectionType);
   (tVoid) (oIn >> IndexInObjectPointRefList);
   (tVoid) (oIn >> IndexInAccessPointRefList);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IntersectionType);
   (tVoid) (oOut << IndexInObjectPointRefList);
   (tVoid) (oOut << IndexInAccessPointRefList);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty::operator==(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IntersectionType == roRef.IntersectionType);
   bResult = bResult && (IndexInObjectPointRefList == roRef.IndexInObjectPointRefList);
   bResult = bResult && (IndexInAccessPointRefList == roRef.IndexInAccessPointRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ZeroCellDesc = coRef.ZeroCellDesc;
   ZeroCellProperty = coRef.ZeroCellProperty;
}
sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::operator=(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef)
{
   if (this == &coRef) return *this;
   ZeroCellDesc = coRef.ZeroCellDesc;
   ZeroCellProperty = coRef.ZeroCellProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc()
:ZeroCellDesc()
,ZeroCellProperty()
 {}

tS32 sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLDESC;
}


sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::~sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc()
{}

tU32 sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ZeroCellDesc);
   (tVoid) (oIn >> ZeroCellProperty);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ZeroCellDesc);
   (tVoid) (oOut << ZeroCellProperty);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc::operator==(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ZeroCellDesc == roRef.ZeroCellDesc);
   bResult = bResult && (ZeroCellProperty == roRef.ZeroCellProperty);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavAreaDescriptionCircle::sds2hmi_fi_tcl_NavAreaDescriptionCircle(const sds2hmi_fi_tcl_NavAreaDescriptionCircle& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Radius = coRef.Radius;
   Coordinate = coRef.Coordinate;
}
sds2hmi_fi_tcl_NavAreaDescriptionCircle& sds2hmi_fi_tcl_NavAreaDescriptionCircle::operator=(const sds2hmi_fi_tcl_NavAreaDescriptionCircle& coRef)
{
   if (this == &coRef) return *this;
   Radius = coRef.Radius;
   Coordinate = coRef.Coordinate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavAreaDescriptionCircle::sds2hmi_fi_tcl_NavAreaDescriptionCircle()
:Radius()
,Coordinate()
 {}

tS32 sds2hmi_fi_tcl_NavAreaDescriptionCircle::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVAREADESCRIPTIONCIRCLE;
}


sds2hmi_fi_tcl_NavAreaDescriptionCircle::~sds2hmi_fi_tcl_NavAreaDescriptionCircle()
{}

tU32 sds2hmi_fi_tcl_NavAreaDescriptionCircle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sds2hmi_fi_tcl_NavAreaDescriptionCircle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Radius);
   (tVoid) (oIn >> Coordinate);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavAreaDescriptionCircle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Radius);
   (tVoid) (oOut << Coordinate);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavAreaDescriptionCircle::operator==(const sds2hmi_fi_tcl_NavAreaDescriptionCircle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Radius == roRef.Radius);
   bResult = bResult && (Coordinate == roRef.Coordinate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavAreaDescriptionPolygon::sds2hmi_fi_tcl_NavAreaDescriptionPolygon(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   CoordinateList = coRef.CoordinateList;
}
sds2hmi_fi_tcl_NavAreaDescriptionPolygon& sds2hmi_fi_tcl_NavAreaDescriptionPolygon::operator=(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon& coRef)
{
   if (this == &coRef) return *this;
   CoordinateList = coRef.CoordinateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NavAreaDescriptionPolygon::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
         CoordinateList[u32Idx].vDestroy();
   CoordinateList.clear();
   }
}

sds2hmi_fi_tcl_NavAreaDescriptionPolygon::sds2hmi_fi_tcl_NavAreaDescriptionPolygon()

 {}

tS32 sds2hmi_fi_tcl_NavAreaDescriptionPolygon::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVAREADESCRIPTIONPOLYGON;
}


sds2hmi_fi_tcl_NavAreaDescriptionPolygon::~sds2hmi_fi_tcl_NavAreaDescriptionPolygon()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NavAreaDescriptionPolygon::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+CoordinateList.size()*8;
}

fi_tclInContext& sds2hmi_fi_tcl_NavAreaDescriptionPolygon::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
      {
         CoordinateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CoordinateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CoordinateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavAreaDescriptionPolygon::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CoordinateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CoordinateList.size(); ++u32Idx)
         (tVoid) (oOut << CoordinateList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_NavAreaDescriptionPolygon::operator==(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CoordinateList.size() == roRef.CoordinateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CoordinateList.size()); ++u32Idx)
            bResult = bResult && (CoordinateList[u32Idx] == roRef.CoordinateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavLocationDataDesc::sds2hmi_fi_tcl_NavLocationDataDesc(const sds2hmi_fi_tcl_NavLocationDataDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   NavDataSetID = coRef.NavDataSetID;
   IndexZFDestType = coRef.IndexZFDestType;
   ObjectPointRefList = coRef.ObjectPointRefList;
   AccessPointRefList = coRef.AccessPointRefList;
   NavDataTypeType = coRef.NavDataTypeType;
   if  (coRef.poNavDataTypeData)
   {
      switch(NavDataTypeType.enType)
      {
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poNavDataTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet((const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet((const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet((const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      default:
         poNavDataTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavDataTypeData = OSAL_NULL;
   }
}
sds2hmi_fi_tcl_NavLocationDataDesc& sds2hmi_fi_tcl_NavLocationDataDesc::operator=(const sds2hmi_fi_tcl_NavLocationDataDesc& coRef)
{
   if (this == &coRef) return *this;
   NavDataSetID = coRef.NavDataSetID;
   IndexZFDestType = coRef.IndexZFDestType;
   ObjectPointRefList = coRef.ObjectPointRefList;
   AccessPointRefList = coRef.AccessPointRefList;
   OSAL_DELETE poNavDataTypeData;
   NavDataTypeType = coRef.NavDataTypeType;
   if  (coRef.poNavDataTypeData)
   {
      switch(NavDataTypeType.enType)
      {
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poNavDataTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet((const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet((const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet((const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet&)*coRef.poNavDataTypeData);
         break;
      default:
         poNavDataTypeData = OSAL_NULL;
      }
   }
   else
   {
      poNavDataTypeData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NavLocationDataDesc::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
         ObjectPointRefList[u32Idx].vDestroy();
   ObjectPointRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
         AccessPointRefList[u32Idx].vDestroy();
   AccessPointRefList.clear();
   }
   if (poNavDataTypeData)
   {
      poNavDataTypeData->vDestroy();
      OSAL_DELETE poNavDataTypeData;
      poNavDataTypeData = OSAL_NULL;
   }
}

sds2hmi_fi_tcl_NavLocationDataDesc::sds2hmi_fi_tcl_NavLocationDataDesc()
:NavDataSetID()
,IndexZFDestType()


,poNavDataTypeData(0)
 {}

tS32 sds2hmi_fi_tcl_NavLocationDataDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVLOCATIONDATADESC;
}


sds2hmi_fi_tcl_NavLocationDataDesc::~sds2hmi_fi_tcl_NavLocationDataDesc()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NavLocationDataDesc::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+ObjectPointRefList.size()*8+AccessPointRefList.size()*8+(poNavDataTypeData?poNavDataTypeData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds2hmi_fi_tcl_NavLocationDataDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NavDataSetID);
   (tVoid) (oIn >> IndexZFDestType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
      {
         ObjectPointRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ObjectPointRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ObjectPointRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
      {
         AccessPointRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AccessPointRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AccessPointRefList[u32Idx]);
      }
   }
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poNavDataTypeData;
#else
   if (poNavDataTypeData)
   {
      poNavDataTypeData->vDestroy();
      OSAL_DELETE poNavDataTypeData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> NavDataTypeType);
   switch(NavDataTypeType.enType)
   {
   case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
      poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_Reserved;
      break;
   case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
      poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet;
      break;
   case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
      poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet;
      break;
   case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
      poNavDataTypeData = OSAL_NEW sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet;
      break;
   default:
      oIn.Invalidate();
      poNavDataTypeData = OSAL_NULL;
   }
   if (poNavDataTypeData && oIn.bIsValid())
      poNavDataTypeData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavLocationDataDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NavDataSetID);
   (tVoid) (oOut << IndexZFDestType);
   (tVoid) (oOut << (tU32)ObjectPointRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ObjectPointRefList.size(); ++u32Idx)
         (tVoid) (oOut << ObjectPointRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)AccessPointRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AccessPointRefList.size(); ++u32Idx)
         (tVoid) (oOut << AccessPointRefList[u32Idx]);
   }
   (tVoid) (oOut << NavDataTypeType);
   if (poNavDataTypeData)
   {
      (tVoid) poNavDataTypeData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_NavLocationDataDesc::operator==(const sds2hmi_fi_tcl_NavLocationDataDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NavDataSetID == roRef.NavDataSetID);
   bResult = bResult && (IndexZFDestType == roRef.IndexZFDestType);
      bResult = bResult && (ObjectPointRefList.size() == roRef.ObjectPointRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ObjectPointRefList.size()); ++u32Idx)
            bResult = bResult && (ObjectPointRefList[u32Idx] == roRef.ObjectPointRefList[u32Idx]);
      }
      bResult = bResult && (AccessPointRefList.size() == roRef.AccessPointRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AccessPointRefList.size()); ++u32Idx)
            bResult = bResult && (AccessPointRefList[u32Idx] == roRef.AccessPointRefList[u32Idx]);
      }
   bResult = bResult && (NavDataTypeType == roRef.NavDataTypeType);
   if (bResult && poNavDataTypeData && roRef.poNavDataTypeData) 
   {
      switch (NavDataTypeType.enType)
      {
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds2hmi_fi_tcl_Reserved*)poNavDataTypeData == *(const sds2hmi_fi_tcl_Reserved*)roRef.poNavDataTypeData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET:
         bResult = bResult && (*(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet*)poNavDataTypeData == *(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet*)roRef.poNavDataTypeData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET:
         bResult = bResult && (*(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet*)poNavDataTypeData == *(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet*)roRef.poNavDataTypeData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_NavLocationNavDataType::FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET:
         bResult = bResult && (*(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet*)poNavDataTypeData == *(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet*)roRef.poNavDataTypeData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poNavDataTypeData == roRef.poNavDataTypeData);
   }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_u32_MediaId::sds2hmi_fi_tcl_u32_MediaId(tU32 _u32Value)
: u32Value(_u32Value
) {} 

tS32 sds2hmi_fi_tcl_u32_MediaId::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_U32_MEDIAID;
}


sds2hmi_fi_tcl_u32_MediaId::~sds2hmi_fi_tcl_u32_MediaId()
{}

tU32 sds2hmi_fi_tcl_u32_MediaId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_u32_MediaId::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_u32_MediaId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_s32_EMU::sds2hmi_fi_tcl_s32_EMU(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 sds2hmi_fi_tcl_s32_EMU::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_S32_EMU;
}


sds2hmi_fi_tcl_s32_EMU::~sds2hmi_fi_tcl_s32_EMU()
{}

tU32 sds2hmi_fi_tcl_s32_EMU::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_fi_tcl_s32_EMU::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_s32_EMU::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NavDataLevel::sds2hmi_fi_tcl_e8_NavDataLevel():enType(FI_EN_DATA_LEVEL_0) {}

tS32 sds2hmi_fi_tcl_e8_NavDataLevel::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAVDATALEVEL;
}


sds2hmi_fi_tcl_e8_NavDataLevel::~sds2hmi_fi_tcl_e8_NavDataLevel()
{}

tU32 sds2hmi_fi_tcl_e8_NavDataLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NavDataLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NavDataLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty(const sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SideInfo = coRef.SideInfo;
   FromZeroCellToSpotLength = coRef.FromZeroCellToSpotLength;
   OneCellLength = coRef.OneCellLength;
   DestDistance = coRef.DestDistance;
   DecisionPoint = coRef.DecisionPoint;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
}
sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::operator=(const sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& coRef)
{
   if (this == &coRef) return *this;
   SideInfo = coRef.SideInfo;
   FromZeroCellToSpotLength = coRef.FromZeroCellToSpotLength;
   OneCellLength = coRef.OneCellLength;
   DestDistance = coRef.DestDistance;
   DecisionPoint = coRef.DecisionPoint;
   IndexInObjectPointRefList = coRef.IndexInObjectPointRefList;
   IndexInAccessPointRefList = coRef.IndexInAccessPointRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty()
:SideInfo()
,FromZeroCellToSpotLength()
,OneCellLength()
,DestDistance()
,DecisionPoint()
,IndexInObjectPointRefList()
,IndexInAccessPointRefList()
 {}

tS32 sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLPROPERTY;
}


sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::~sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty()
{}

tU32 sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 25;
}

fi_tclInContext& sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SideInfo);
   (tVoid) (oIn >> FromZeroCellToSpotLength);
   (tVoid) (oIn >> OneCellLength);
   (tVoid) (oIn >> DestDistance);
   (tVoid) (oIn >> DecisionPoint);
   (tVoid) (oIn >> IndexInObjectPointRefList);
   (tVoid) (oIn >> IndexInAccessPointRefList);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SideInfo);
   (tVoid) (oOut << FromZeroCellToSpotLength);
   (tVoid) (oOut << OneCellLength);
   (tVoid) (oOut << DestDistance);
   (tVoid) (oOut << DecisionPoint);
   (tVoid) (oOut << IndexInObjectPointRefList);
   (tVoid) (oOut << IndexInAccessPointRefList);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty::operator==(const sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SideInfo == roRef.SideInfo);
   bResult = bResult && (FromZeroCellToSpotLength == roRef.FromZeroCellToSpotLength);
   bResult = bResult && (OneCellLength == roRef.OneCellLength);
   bResult = bResult && (DestDistance == roRef.DestDistance);
   bResult = bResult && (DecisionPoint == roRef.DecisionPoint);
   bResult = bResult && (IndexInObjectPointRefList == roRef.IndexInObjectPointRefList);
   bResult = bResult && (IndexInAccessPointRefList == roRef.IndexInAccessPointRefList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   StreetDestinationOneCellRefList = coRef.StreetDestinationOneCellRefList;
}
sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::operator=(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   StreetDestinationOneCellRefList = coRef.StreetDestinationOneCellRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   ClusterRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
         StreetDestinationOneCellRefList[u32Idx].vDestroy();
   StreetDestinationOneCellRefList.clear();
   }
}

sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet()


 {}

tS32 sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVSTREETDESTINATIONONECELLLISTSET;
}


sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::~sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+StreetDestinationOneCellRefList.size()*10;
}

fi_tclInContext& sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClusterRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
      {
         StreetDestinationOneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StreetDestinationOneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StreetDestinationOneCellRefList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClusterRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         (tVoid) (oOut << ClusterRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)StreetDestinationOneCellRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StreetDestinationOneCellRefList.size(); ++u32Idx)
         (tVoid) (oOut << StreetDestinationOneCellRefList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet::operator==(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == roRef.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == roRef.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (StreetDestinationOneCellRefList.size() == roRef.StreetDestinationOneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StreetDestinationOneCellRefList.size()); ++u32Idx)
            bResult = bResult && (StreetDestinationOneCellRefList[u32Idx] == roRef.StreetDestinationOneCellRefList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc(const sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
}
sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::operator=(const sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& coRef)
{
   if (this == &coRef) return *this;
   OneCellDesc = coRef.OneCellDesc;
   OneCellProperty = coRef.OneCellProperty;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc()
:OneCellDesc()
,OneCellProperty()
 {}

tS32 sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLDESC;
}


sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::~sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc()
{}

tU32 sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 30;
}

fi_tclInContext& sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellDesc);
   (tVoid) (oIn >> OneCellProperty);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellDesc);
   (tVoid) (oOut << OneCellProperty);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc::operator==(const sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellDesc == roRef.OneCellDesc);
   bResult = bResult && (OneCellProperty == roRef.OneCellProperty);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   SpotDestinationOneCellRefList = coRef.SpotDestinationOneCellRefList;
}
sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::operator=(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   SpotDestinationOneCellRefList = coRef.SpotDestinationOneCellRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   ClusterRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
         SpotDestinationOneCellRefList[u32Idx].vDestroy();
   SpotDestinationOneCellRefList.clear();
   }
}

sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet()


 {}

tS32 sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVSPOTDESTINATIONONECELLLISTSET;
}


sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::~sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+SpotDestinationOneCellRefList.size()*30;
}

fi_tclInContext& sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClusterRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
      {
         SpotDestinationOneCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SpotDestinationOneCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SpotDestinationOneCellRefList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClusterRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         (tVoid) (oOut << ClusterRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)SpotDestinationOneCellRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SpotDestinationOneCellRefList.size(); ++u32Idx)
         (tVoid) (oOut << SpotDestinationOneCellRefList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet::operator==(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == roRef.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == roRef.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (SpotDestinationOneCellRefList.size() == roRef.SpotDestinationOneCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpotDestinationOneCellRefList.size()); ++u32Idx)
            bResult = bResult && (SpotDestinationOneCellRefList[u32Idx] == roRef.SpotDestinationOneCellRefList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ClusterRefList = coRef.ClusterRefList;
   IntersectionDestinationZeroCellRefList = coRef.IntersectionDestinationZeroCellRefList;
}
sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::operator=(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef)
{
   if (this == &coRef) return *this;
   ClusterRefList = coRef.ClusterRefList;
   IntersectionDestinationZeroCellRefList = coRef.IntersectionDestinationZeroCellRefList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         ClusterRefList[u32Idx].vDestroy();
   ClusterRefList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
         IntersectionDestinationZeroCellRefList[u32Idx].vDestroy();
   IntersectionDestinationZeroCellRefList.clear();
   }
}

sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet()


 {}

tS32 sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET;
}


sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::~sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ClusterRefList.size()*9+IntersectionDestinationZeroCellRefList.size()*9;
}

fi_tclInContext& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
      {
         ClusterRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ClusterRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClusterRefList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
      {
         IntersectionDestinationZeroCellRefList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IntersectionDestinationZeroCellRefList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IntersectionDestinationZeroCellRefList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClusterRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClusterRefList.size(); ++u32Idx)
         (tVoid) (oOut << ClusterRefList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)IntersectionDestinationZeroCellRefList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IntersectionDestinationZeroCellRefList.size(); ++u32Idx)
         (tVoid) (oOut << IntersectionDestinationZeroCellRefList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet::operator==(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClusterRefList.size() == roRef.ClusterRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClusterRefList.size()); ++u32Idx)
            bResult = bResult && (ClusterRefList[u32Idx] == roRef.ClusterRefList[u32Idx]);
      }
      bResult = bResult && (IntersectionDestinationZeroCellRefList.size() == roRef.IntersectionDestinationZeroCellRefList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IntersectionDestinationZeroCellRefList.size()); ++u32Idx)
            bResult = bResult && (IntersectionDestinationZeroCellRefList[u32Idx] == roRef.IntersectionDestinationZeroCellRefList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NavOneCell::sds2hmi_fi_tcl_NavOneCell(const sds2hmi_fi_tcl_NavOneCell& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   ClusterFileId = coRef.ClusterFileId;
   ClusterFileOffset = coRef.ClusterFileOffset;
   ClusterLength = coRef.ClusterLength;
}
sds2hmi_fi_tcl_NavOneCell& sds2hmi_fi_tcl_NavOneCell::operator=(const sds2hmi_fi_tcl_NavOneCell& coRef)
{
   if (this == &coRef) return *this;
   OneCellId = coRef.OneCellId;
   UseDirection = coRef.UseDirection;
   ClusterFileId = coRef.ClusterFileId;
   ClusterFileOffset = coRef.ClusterFileOffset;
   ClusterLength = coRef.ClusterLength;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_NavOneCell::sds2hmi_fi_tcl_NavOneCell()
:OneCellId(0)
,UseDirection()
,ClusterFileId(0)
,ClusterFileOffset(0)
,ClusterLength(0)
 {}

tS32 sds2hmi_fi_tcl_NavOneCell::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAVONECELL;
}


sds2hmi_fi_tcl_NavOneCell::~sds2hmi_fi_tcl_NavOneCell()
{}

tU32 sds2hmi_fi_tcl_NavOneCell::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& sds2hmi_fi_tcl_NavOneCell::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> OneCellId);
   (tVoid) (oIn >> UseDirection);
   (tVoid) (oIn >> ClusterFileId);
   (tVoid) (oIn >> ClusterFileOffset);
   (tVoid) (oIn >> ClusterLength);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NavOneCell::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << OneCellId);
   (tVoid) (oOut << UseDirection);
   (tVoid) (oOut << ClusterFileId);
   (tVoid) (oOut << ClusterFileOffset);
   (tVoid) (oOut << ClusterLength);
   return oOut;
}

tBool sds2hmi_fi_tcl_NavOneCell::operator==(const sds2hmi_fi_tcl_NavOneCell& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (OneCellId == roRef.OneCellId);
   bResult = bResult && (UseDirection == roRef.UseDirection);
   bResult = bResult && (ClusterFileId == roRef.ClusterFileId);
   bResult = bResult && (ClusterFileOffset == roRef.ClusterFileOffset);
   bResult = bResult && (ClusterLength == roRef.ClusterLength);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NavOneCellCategory::sds2hmi_fi_tcl_e8_NavOneCellCategory():enType(FI_EN_T_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_NavOneCellCategory::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAVONECELLCATEGORY;
}


sds2hmi_fi_tcl_e8_NavOneCellCategory::~sds2hmi_fi_tcl_e8_NavOneCellCategory()
{}

tU32 sds2hmi_fi_tcl_e8_NavOneCellCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NavOneCellCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NavOneCellCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Action::sds2hmi_fi_tcl_e8_Action():enType(FI_EN_NONE) {}

tS32 sds2hmi_fi_tcl_e8_Action::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_ACTION;
}


sds2hmi_fi_tcl_e8_Action::~sds2hmi_fi_tcl_e8_Action()
{}

tU32 sds2hmi_fi_tcl_e8_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Action::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_Action::tenType enData = enType;
   if ((enData == FI_EN_DELETE_USERWORDS) && !(2 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_NONE;
   }
   if ((enData == FI_EN_DELETE_USERWORD) && !(2 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_NONE;
   }
   if ((enData == FI_EN_DELETE_UWPROFILE) && !(2 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_NONE;
   }
   if ((enData == FI_EN_SET_PROFILE) && !(2 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_NONE;
   }
   if ((enData == FI_EN_CLEAR_PRIVATE_DATA) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_NONE;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Application::sds2hmi_fi_tcl_e8_Application():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_Application::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_APPLICATION;
}


sds2hmi_fi_tcl_e8_Application::~sds2hmi_fi_tcl_e8_Application()
{}

tU32 sds2hmi_fi_tcl_e8_Application::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Application::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Application::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_Application::tenType enData = enType;
   if ((enData == FI_EN_EXT_APP) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_GLOBAL;
   }
   if ((enData == FI_EN_INFO) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_GLOBAL;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PopUp_UpdateType::sds2hmi_fi_tcl_e8_PopUp_UpdateType():enType(FI_EN_UPDATE_ALL) {}

tS32 sds2hmi_fi_tcl_e8_PopUp_UpdateType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_POPUP_UPDATETYPE;
}


sds2hmi_fi_tcl_e8_PopUp_UpdateType::~sds2hmi_fi_tcl_e8_PopUp_UpdateType()
{}

tU32 sds2hmi_fi_tcl_e8_PopUp_UpdateType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PopUp_UpdateType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PopUp_UpdateType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PopUp_ListType::sds2hmi_fi_tcl_e8_PopUp_ListType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PopUp_ListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_POPUP_LISTTYPE;
}


sds2hmi_fi_tcl_e8_PopUp_ListType::~sds2hmi_fi_tcl_e8_PopUp_ListType()
{}

tU32 sds2hmi_fi_tcl_e8_PopUp_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PopUp_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PopUp_ListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_GEN_SelectionType::sds2hmi_fi_tcl_e8_GEN_SelectionType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_GEN_SelectionType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_GEN_SELECTIONTYPE;
}


sds2hmi_fi_tcl_e8_GEN_SelectionType::~sds2hmi_fi_tcl_e8_GEN_SelectionType()
{}

tU32 sds2hmi_fi_tcl_e8_GEN_SelectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_GEN_SelectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_GEN_SelectionType::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_GEN_SelectionType::tenType enData = enType;
   if ((enData == FI_EN_BYLISTNUMBER) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_BYVAL;
   }
   if ((enData == FI_EN_BYSOURCE) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_BYVAL;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PlayAction::sds2hmi_fi_tcl_e8_PlayAction():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PlayAction::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PLAYACTION;
}


sds2hmi_fi_tcl_e8_PlayAction::~sds2hmi_fi_tcl_e8_PlayAction()
{}

tU32 sds2hmi_fi_tcl_e8_PlayAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PlayAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PlayAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TUN_SelectionType::sds2hmi_fi_tcl_e8_TUN_SelectionType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_TUN_SelectionType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TUN_SELECTIONTYPE;
}


sds2hmi_fi_tcl_e8_TUN_SelectionType::~sds2hmi_fi_tcl_e8_TUN_SelectionType()
{}

tU32 sds2hmi_fi_tcl_e8_TUN_SelectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TUN_SelectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TUN_SelectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TUN_Status::sds2hmi_fi_tcl_e8_TUN_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_TUN_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TUN_STATUS;
}


sds2hmi_fi_tcl_e8_TUN_Status::~sds2hmi_fi_tcl_e8_TUN_Status()
{}

tU32 sds2hmi_fi_tcl_e8_TUN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TUN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TUN_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TUN_Band::sds2hmi_fi_tcl_e8_TUN_Band():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_TUN_Band::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TUN_BAND;
}


sds2hmi_fi_tcl_e8_TUN_Band::~sds2hmi_fi_tcl_e8_TUN_Band()
{}

tU32 sds2hmi_fi_tcl_e8_TUN_Band::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TUN_Band::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TUN_Band::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TUN_MemBank::sds2hmi_fi_tcl_e8_TUN_MemBank():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_TUN_MemBank::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TUN_MEMBANK;
}


sds2hmi_fi_tcl_e8_TUN_MemBank::~sds2hmi_fi_tcl_e8_TUN_MemBank()
{}

tU32 sds2hmi_fi_tcl_e8_TUN_MemBank::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TUN_MemBank::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TUN_MemBank::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TUN_Setting::sds2hmi_fi_tcl_e8_TUN_Setting():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_TUN_Setting::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TUN_SETTING;
}


sds2hmi_fi_tcl_e8_TUN_Setting::~sds2hmi_fi_tcl_e8_TUN_Setting()
{}

tU32 sds2hmi_fi_tcl_e8_TUN_Setting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TUN_Setting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TUN_Setting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_GLOBAL_Status::sds2hmi_fi_tcl_e8_GLOBAL_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_GLOBAL_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_GLOBAL_STATUS;
}


sds2hmi_fi_tcl_e8_GLOBAL_Status::~sds2hmi_fi_tcl_e8_GLOBAL_Status()
{}

tU32 sds2hmi_fi_tcl_e8_GLOBAL_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_GLOBAL_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_GLOBAL_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_MediaDataType::sds2hmi_fi_tcl_e8_MediaDataType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_MediaDataType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_MEDIADATATYPE;
}


sds2hmi_fi_tcl_e8_MediaDataType::~sds2hmi_fi_tcl_e8_MediaDataType()
{}

tU32 sds2hmi_fi_tcl_e8_MediaDataType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_MediaDataType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_MediaDataType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SMS_Status::sds2hmi_fi_tcl_e8_SMS_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SMS_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SMS_STATUS;
}


sds2hmi_fi_tcl_e8_SMS_Status::~sds2hmi_fi_tcl_e8_SMS_Status()
{}

tU32 sds2hmi_fi_tcl_e8_SMS_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SMS_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SMS_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PHN_Status::sds2hmi_fi_tcl_e8_PHN_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PHN_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHN_STATUS;
}


sds2hmi_fi_tcl_e8_PHN_Status::~sds2hmi_fi_tcl_e8_PHN_Status()
{}

tU32 sds2hmi_fi_tcl_e8_PHN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PHN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PHN_Status::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_PHN_Status::tenType enData = enType;
   if ((enData == FI_EN_INCALL_HOLD) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_INCALL;
   }
   if ((enData == FI_EN_HANDSET_MODE) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_INCALL;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PHN_MenuType::sds2hmi_fi_tcl_e8_PHN_MenuType():enType(FI_EN_OTHER) {}

tS32 sds2hmi_fi_tcl_e8_PHN_MenuType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHN_MENUTYPE;
}


sds2hmi_fi_tcl_e8_PHN_MenuType::~sds2hmi_fi_tcl_e8_PHN_MenuType()
{}

tU32 sds2hmi_fi_tcl_e8_PHN_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PHN_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PHN_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_PHN_MenuType::tenType enData = enType;
   if ((enData == FI_EN_READ_TEXT) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_OTHER;
   }
   if ((enData == FI_EN_SELECT_PHONE) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_OTHER;
   }
   if ((enData == FI_EN_ADD_PHONE) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_OTHER;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PHN_Setting::sds2hmi_fi_tcl_e8_PHN_Setting():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PHN_Setting::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHN_SETTING;
}


sds2hmi_fi_tcl_e8_PHN_Setting::~sds2hmi_fi_tcl_e8_PHN_Setting()
{}

tU32 sds2hmi_fi_tcl_e8_PHN_Setting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PHN_Setting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PHN_Setting::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_PHN_Setting::tenType enData = enType;
   if ((enData == FI_EN_SWITCH_TO_HANDSFREE) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   if ((enData == FI_EN_SWITCH_TO_HANDSET) && !(1 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PHN_ListType::sds2hmi_fi_tcl_e8_PHN_ListType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PHN_ListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHN_LISTTYPE;
}


sds2hmi_fi_tcl_e8_PHN_ListType::~sds2hmi_fi_tcl_e8_PHN_ListType()
{}

tU32 sds2hmi_fi_tcl_e8_PHN_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PHN_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PHN_ListType::oWrite(fi_tclOutContext& oOut) const
{
   sds2hmi_fi_tcl_e8_PHN_ListType::tenType enData = enType;
   if ((enData == FI_EN_USERWORD_LIST) && !(2 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_UNKNOWN;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PHN_NumberType::sds2hmi_fi_tcl_e8_PHN_NumberType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PHN_NumberType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHN_NUMBERTYPE;
}


sds2hmi_fi_tcl_e8_PHN_NumberType::~sds2hmi_fi_tcl_e8_PHN_NumberType()
{}

tU32 sds2hmi_fi_tcl_e8_PHN_NumberType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PHN_NumberType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PHN_NumberType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PHN_SelectionType::sds2hmi_fi_tcl_e8_PHN_SelectionType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PHN_SelectionType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHN_SELECTIONTYPE;
}


sds2hmi_fi_tcl_e8_PHN_SelectionType::~sds2hmi_fi_tcl_e8_PHN_SelectionType()
{}

tU32 sds2hmi_fi_tcl_e8_PHN_SelectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PHN_SelectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PHN_SelectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PHN_Transorder::sds2hmi_fi_tcl_e8_PHN_Transorder():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_PHN_Transorder::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHN_TRANSORDER;
}


sds2hmi_fi_tcl_e8_PHN_Transorder::~sds2hmi_fi_tcl_e8_PHN_Transorder()
{}

tU32 sds2hmi_fi_tcl_e8_PHN_Transorder::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PHN_Transorder::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PHN_Transorder::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_Status::sds2hmi_fi_tcl_e8_NAV_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_STATUS;
}


sds2hmi_fi_tcl_e8_NAV_Status::~sds2hmi_fi_tcl_e8_NAV_Status()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_MenuType::sds2hmi_fi_tcl_e8_NAV_MenuType():enType(FI_EN_OTHER) {}

tS32 sds2hmi_fi_tcl_e8_NAV_MenuType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_MENUTYPE;
}


sds2hmi_fi_tcl_e8_NAV_MenuType::~sds2hmi_fi_tcl_e8_NAV_MenuType()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_RouteCriteria::sds2hmi_fi_tcl_e8_NAV_RouteCriteria():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_RouteCriteria::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_ROUTECRITERIA;
}


sds2hmi_fi_tcl_e8_NAV_RouteCriteria::~sds2hmi_fi_tcl_e8_NAV_RouteCriteria()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_RouteCriteria::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_RouteCriteria::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_RouteCriteria::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_ZoomLevel::sds2hmi_fi_tcl_e8_NAV_ZoomLevel():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_ZoomLevel::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_ZOOMLEVEL;
}


sds2hmi_fi_tcl_e8_NAV_ZoomLevel::~sds2hmi_fi_tcl_e8_NAV_ZoomLevel()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_ZoomLevel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_ZoomLevel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_ZoomLevel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_ListType::sds2hmi_fi_tcl_e8_NAV_ListType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_ListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_LISTTYPE;
}


sds2hmi_fi_tcl_e8_NAV_ListType::~sds2hmi_fi_tcl_e8_NAV_ListType()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_ListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_NavUnit::sds2hmi_fi_tcl_e8_NAV_NavUnit():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_NavUnit::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_NAVUNIT;
}


sds2hmi_fi_tcl_e8_NAV_NavUnit::~sds2hmi_fi_tcl_e8_NAV_NavUnit()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_NavUnit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_NavUnit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_NavUnit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo::sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_VDEAVAILINFO;
}


sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo::~sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_Setting::sds2hmi_fi_tcl_e8_NAV_Setting():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_Setting::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_SETTING;
}


sds2hmi_fi_tcl_e8_NAV_Setting::~sds2hmi_fi_tcl_e8_NAV_Setting()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_Setting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_Setting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_Setting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_MapMode::sds2hmi_fi_tcl_e8_NAV_MapMode():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_MapMode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_MAPMODE;
}


sds2hmi_fi_tcl_e8_NAV_MapMode::~sds2hmi_fi_tcl_e8_NAV_MapMode()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_MapMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_MapMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_MapMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_AutoZoom::sds2hmi_fi_tcl_e8_NAV_AutoZoom():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_AutoZoom::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_AUTOZOOM;
}


sds2hmi_fi_tcl_e8_NAV_AutoZoom::~sds2hmi_fi_tcl_e8_NAV_AutoZoom()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_AutoZoom::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_AutoZoom::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_AutoZoom::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_MapView::sds2hmi_fi_tcl_e8_NAV_MapView():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_MapView::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_MAPVIEW;
}


sds2hmi_fi_tcl_e8_NAV_MapView::~sds2hmi_fi_tcl_e8_NAV_MapView()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_MapView::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_MapView::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_MapView::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_MapOrientation::sds2hmi_fi_tcl_e8_NAV_MapOrientation():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_MapOrientation::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_MAPORIENTATION;
}


sds2hmi_fi_tcl_e8_NAV_MapOrientation::~sds2hmi_fi_tcl_e8_NAV_MapOrientation()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_MapOrientation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_MapOrientation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_MapOrientation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::sds2hmi_fi_tcl_e8_NAV_TBT_Symbols():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_TBT_SYMBOLS;
}


sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::~sds2hmi_fi_tcl_e8_NAV_TBT_Symbols()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_POIListType::sds2hmi_fi_tcl_e8_NAV_POIListType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_POIListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_POILISTTYPE;
}


sds2hmi_fi_tcl_e8_NAV_POIListType::~sds2hmi_fi_tcl_e8_NAV_POIListType()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_POIListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_POIListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_POIListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SET_DisplayMode::sds2hmi_fi_tcl_e8_SET_DisplayMode():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SET_DisplayMode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SET_DISPLAYMODE;
}


sds2hmi_fi_tcl_e8_SET_DisplayMode::~sds2hmi_fi_tcl_e8_SET_DisplayMode()
{}

tU32 sds2hmi_fi_tcl_e8_SET_DisplayMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SET_DisplayMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SET_DisplayMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TMCListContent::sds2hmi_fi_tcl_e8_TMCListContent():enType(FI_EN_TMC_LIST_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_TMCListContent::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TMCLISTCONTENT;
}


sds2hmi_fi_tcl_e8_TMCListContent::~sds2hmi_fi_tcl_e8_TMCListContent()
{}

tU32 sds2hmi_fi_tcl_e8_TMCListContent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TMCListContent::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TMCListContent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_PopUp_ResultOptions::sds2hmi_fi_tcl_b8_PopUp_ResultOptions():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_PopUp_ResultOptions::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_POPUP_RESULTOPTIONS;
}


sds2hmi_fi_tcl_b8_PopUp_ResultOptions::~sds2hmi_fi_tcl_b8_PopUp_ResultOptions()
{}

tU32 sds2hmi_fi_tcl_b8_PopUp_ResultOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_PopUp_ResultOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_PopUp_ResultOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b16_AnsOptions::sds2hmi_fi_tcl_b16_AnsOptions():u16Value(0)
{}

tS32 sds2hmi_fi_tcl_b16_AnsOptions::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B16_ANSOPTIONS;
}


sds2hmi_fi_tcl_b16_AnsOptions::~sds2hmi_fi_tcl_b16_AnsOptions()
{}

tU32 sds2hmi_fi_tcl_b16_AnsOptions::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_b16_AnsOptions::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b16_AnsOptions::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting::sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting():u8Value(0)
{}

tS32 sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_B8_STRINGPHONEMESEARCHSETTING;
}


sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting::~sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting()
{}

tU32 sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_UPOI_Source::sds2hmi_fi_tcl_e8_UPOI_Source():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_UPOI_Source::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_UPOI_SOURCE;
}


sds2hmi_fi_tcl_e8_UPOI_Source::~sds2hmi_fi_tcl_e8_UPOI_Source()
{}

tU32 sds2hmi_fi_tcl_e8_UPOI_Source::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_UPOI_Source::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_UPOI_Source::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Gender::sds2hmi_fi_tcl_e8_Gender():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_Gender::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_GENDER;
}


sds2hmi_fi_tcl_e8_Gender::~sds2hmi_fi_tcl_e8_Gender()
{}

tU32 sds2hmi_fi_tcl_e8_Gender::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Gender::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Gender::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SDS_Status::sds2hmi_fi_tcl_e8_SDS_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SDS_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SDS_STATUS;
}


sds2hmi_fi_tcl_e8_SDS_Status::~sds2hmi_fi_tcl_e8_SDS_Status()
{}

tU32 sds2hmi_fi_tcl_e8_SDS_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SDS_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SDS_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_DeviceStatus::sds2hmi_fi_tcl_e8_DeviceStatus():enType(FI_EN_DEVICE_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_DeviceStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_DEVICESTATUS;
}


sds2hmi_fi_tcl_e8_DeviceStatus::~sds2hmi_fi_tcl_e8_DeviceStatus()
{}

tU32 sds2hmi_fi_tcl_e8_DeviceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_DeviceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_DeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_MPL_ListType::sds2hmi_fi_tcl_e8_MPL_ListType():enType(FI_EN_LIST_TYPE_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_MPL_ListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_MPL_LISTTYPE;
}


sds2hmi_fi_tcl_e8_MPL_ListType::~sds2hmi_fi_tcl_e8_MPL_ListType()
{}

tU32 sds2hmi_fi_tcl_e8_MPL_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_MPL_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_MPL_ListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_MPL_MenuType::sds2hmi_fi_tcl_e8_MPL_MenuType():enType(FI_EN_MENU_TYPE_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_MPL_MenuType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_MPL_MENUTYPE;
}


sds2hmi_fi_tcl_e8_MPL_MenuType::~sds2hmi_fi_tcl_e8_MPL_MenuType()
{}

tU32 sds2hmi_fi_tcl_e8_MPL_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_MPL_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_MPL_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_MPL_SourceType::sds2hmi_fi_tcl_e8_MPL_SourceType():enType(FI_EN_SOURCE_TYPE_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_MPL_SourceType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_MPL_SOURCETYPE;
}


sds2hmi_fi_tcl_e8_MPL_SourceType::~sds2hmi_fi_tcl_e8_MPL_SourceType()
{}

tU32 sds2hmi_fi_tcl_e8_MPL_SourceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_MPL_SourceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_MPL_SourceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_MPL_Status::sds2hmi_fi_tcl_e8_MPL_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_MPL_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_MPL_STATUS;
}


sds2hmi_fi_tcl_e8_MPL_Status::~sds2hmi_fi_tcl_e8_MPL_Status()
{}

tU32 sds2hmi_fi_tcl_e8_MPL_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_MPL_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_MPL_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_WEA_MenuType::sds2hmi_fi_tcl_e8_WEA_MenuType():enType(FI_EN_OTHER) {}

tS32 sds2hmi_fi_tcl_e8_WEA_MenuType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_WEA_MENUTYPE;
}


sds2hmi_fi_tcl_e8_WEA_MenuType::~sds2hmi_fi_tcl_e8_WEA_MenuType()
{}

tU32 sds2hmi_fi_tcl_e8_WEA_MenuType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_WEA_MenuType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_WEA_MenuType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_WEA_Status::sds2hmi_fi_tcl_e8_WEA_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_WEA_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_WEA_STATUS;
}


sds2hmi_fi_tcl_e8_WEA_Status::~sds2hmi_fi_tcl_e8_WEA_Status()
{}

tU32 sds2hmi_fi_tcl_e8_WEA_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_WEA_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_WEA_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_WEA_Location::sds2hmi_fi_tcl_e8_WEA_Location():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_WEA_Location::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_WEA_LOCATION;
}


sds2hmi_fi_tcl_e8_WEA_Location::~sds2hmi_fi_tcl_e8_WEA_Location()
{}

tU32 sds2hmi_fi_tcl_e8_WEA_Location::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_WEA_Location::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_WEA_Location::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_LocationType::sds2hmi_fi_tcl_e8_NAV_LocationType():enType(FI_EN_DEFAULT) {}

tS32 sds2hmi_fi_tcl_e8_NAV_LocationType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_LOCATIONTYPE;
}


sds2hmi_fi_tcl_e8_NAV_LocationType::~sds2hmi_fi_tcl_e8_NAV_LocationType()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_LocationType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_LocationType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_LocationType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_CON_AmbiguityListType::sds2hmi_fi_tcl_e8_CON_AmbiguityListType():enType(FI_EN_NO_ENTRY) {}

tS32 sds2hmi_fi_tcl_e8_CON_AmbiguityListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_CON_AMBIGUITYLISTTYPE;
}


sds2hmi_fi_tcl_e8_CON_AmbiguityListType::~sds2hmi_fi_tcl_e8_CON_AmbiguityListType()
{}

tU32 sds2hmi_fi_tcl_e8_CON_AmbiguityListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_CON_AmbiguityListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_CON_AmbiguityListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_CON_EntryType::sds2hmi_fi_tcl_e8_CON_EntryType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_CON_EntryType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_CON_ENTRYTYPE;
}


sds2hmi_fi_tcl_e8_CON_EntryType::~sds2hmi_fi_tcl_e8_CON_EntryType()
{}

tU32 sds2hmi_fi_tcl_e8_CON_EntryType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_CON_EntryType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_CON_EntryType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold::sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_LOG_CONFIDENCETHRESHOLD;
}


sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold::~sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold()
{}

tU32 sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_ParameterAction::sds2hmi_fi_tcl_e8_ParameterAction():enType(FI_EN_GET) {}

tS32 sds2hmi_fi_tcl_e8_ParameterAction::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PARAMETERACTION;
}


sds2hmi_fi_tcl_e8_ParameterAction::~sds2hmi_fi_tcl_e8_ParameterAction()
{}

tU32 sds2hmi_fi_tcl_e8_ParameterAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_ParameterAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_ParameterAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SDS_ParameterType::sds2hmi_fi_tcl_e8_SDS_ParameterType():enType(FI_EN_T_RESERVED) {}

tS32 sds2hmi_fi_tcl_e8_SDS_ParameterType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SDS_PARAMETERTYPE;
}


sds2hmi_fi_tcl_e8_SDS_ParameterType::~sds2hmi_fi_tcl_e8_SDS_ParameterType()
{}

tU32 sds2hmi_fi_tcl_e8_SDS_ParameterType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SDS_ParameterType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SDS_ParameterType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SDSSettings::sds2hmi_fi_tcl_e8_SDSSettings():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SDSSettings::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SDSSETTINGS;
}


sds2hmi_fi_tcl_e8_SDSSettings::~sds2hmi_fi_tcl_e8_SDSSettings()
{}

tU32 sds2hmi_fi_tcl_e8_SDSSettings::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SDSSettings::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SDSSettings::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SettingsError::sds2hmi_fi_tcl_e8_SettingsError():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SettingsError::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SETTINGSERROR;
}


sds2hmi_fi_tcl_e8_SettingsError::~sds2hmi_fi_tcl_e8_SettingsError()
{}

tU32 sds2hmi_fi_tcl_e8_SettingsError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SettingsError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SettingsError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_HMI_ListType::sds2hmi_fi_tcl_e8_HMI_ListType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_HMI_ListType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_HMI_LISTTYPE;
}


sds2hmi_fi_tcl_e8_HMI_ListType::~sds2hmi_fi_tcl_e8_HMI_ListType()
{}

tU32 sds2hmi_fi_tcl_e8_HMI_ListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_HMI_ListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_HMI_ListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_HMI_ListSize::sds2hmi_fi_tcl_e8_HMI_ListSize():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_HMI_ListSize::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_HMI_LISTSIZE;
}


sds2hmi_fi_tcl_e8_HMI_ListSize::~sds2hmi_fi_tcl_e8_HMI_ListSize()
{}

tU32 sds2hmi_fi_tcl_e8_HMI_ListSize::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_HMI_ListSize::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_HMI_ListSize::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Info_Menu::sds2hmi_fi_tcl_e8_Info_Menu():enType(FI_EN_INFO_TRAFFIC) {}

tS32 sds2hmi_fi_tcl_e8_Info_Menu::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_INFO_MENU;
}


sds2hmi_fi_tcl_e8_Info_Menu::~sds2hmi_fi_tcl_e8_Info_Menu()
{}

tU32 sds2hmi_fi_tcl_e8_Info_Menu::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Info_Menu::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Info_Menu::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Info_SXM_Services::sds2hmi_fi_tcl_e8_Info_SXM_Services():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_Info_SXM_Services::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_INFO_SXM_SERVICES;
}


sds2hmi_fi_tcl_e8_Info_SXM_Services::~sds2hmi_fi_tcl_e8_Info_SXM_Services()
{}

tU32 sds2hmi_fi_tcl_e8_Info_SXM_Services::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Info_SXM_Services::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Info_SXM_Services::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SpecialAppId::sds2hmi_fi_tcl_e8_SpecialAppId():enType(FI_EN_APP_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SpecialAppId::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SPECIALAPPID;
}


sds2hmi_fi_tcl_e8_SpecialAppId::~sds2hmi_fi_tcl_e8_SpecialAppId()
{}

tU32 sds2hmi_fi_tcl_e8_SpecialAppId::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SpecialAppId::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SpecialAppId::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SpecialAppStatus::sds2hmi_fi_tcl_e8_SpecialAppStatus():enType(FI_EN_APP_STAT_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SpecialAppStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SPECIALAPPSTATUS;
}


sds2hmi_fi_tcl_e8_SpecialAppStatus::~sds2hmi_fi_tcl_e8_SpecialAppStatus()
{}

tU32 sds2hmi_fi_tcl_e8_SpecialAppStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SpecialAppStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SpecialAppStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_INFO_TCUType::sds2hmi_fi_tcl_e8_INFO_TCUType():enType(FI_EN_INFO_TCUTYPE_NONE) {}

tS32 sds2hmi_fi_tcl_e8_INFO_TCUType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_INFO_TCUTYPE;
}


sds2hmi_fi_tcl_e8_INFO_TCUType::~sds2hmi_fi_tcl_e8_INFO_TCUType()
{}

tU32 sds2hmi_fi_tcl_e8_INFO_TCUType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_INFO_TCUType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_INFO_TCUType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_TUN_Band_Group::sds2hmi_fi_tcl_e8_TUN_Band_Group():enType(FI_EN_TUN_FREQ_GRP_NAR) {}

tS32 sds2hmi_fi_tcl_e8_TUN_Band_Group::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_TUN_BAND_GROUP;
}


sds2hmi_fi_tcl_e8_TUN_Band_Group::~sds2hmi_fi_tcl_e8_TUN_Band_Group()
{}

tU32 sds2hmi_fi_tcl_e8_TUN_Band_Group::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_TUN_Band_Group::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_TUN_Band_Group::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::sds2hmi_fi_tcl_e8_HMIElementDescriptorMode():enType(FI_EN_DESCR_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_HMIELEMENTDESCRIPTORMODE;
}


sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::~sds2hmi_fi_tcl_e8_HMIElementDescriptorMode()
{}

tU32 sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_HMIElementDescriptorMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_ZoomAction::sds2hmi_fi_tcl_e8_NAV_ZoomAction():enType(FI_EN_ZOOM_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_ZoomAction::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_ZOOMACTION;
}


sds2hmi_fi_tcl_e8_NAV_ZoomAction::~sds2hmi_fi_tcl_e8_NAV_ZoomAction()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_ZoomAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_ZoomAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_ZoomAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::sds2hmi_fi_tcl_e8_NAV_IconDisplayAction():enType(FI_EN_ICONDSPLY_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NAV_ICONDISPLAYACTION;
}


sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::~sds2hmi_fi_tcl_e8_NAV_IconDisplayAction()
{}

tU32 sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SDS_EntryPoint::sds2hmi_fi_tcl_e8_SDS_EntryPoint():enType(FI_EN_SDS_ENTRY_GLOBAL) {}

tS32 sds2hmi_fi_tcl_e8_SDS_EntryPoint::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SDS_ENTRYPOINT;
}


sds2hmi_fi_tcl_e8_SDS_EntryPoint::~sds2hmi_fi_tcl_e8_SDS_EntryPoint()
{}

tU32 sds2hmi_fi_tcl_e8_SDS_EntryPoint::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SDS_EntryPoint::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SDS_EntryPoint::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_MainDomains::sds2hmi_fi_tcl_e8_MainDomains():enType(FI_EN_DOMAIN_NONE) {}

tS32 sds2hmi_fi_tcl_e8_MainDomains::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_MAINDOMAINS;
}


sds2hmi_fi_tcl_e8_MainDomains::~sds2hmi_fi_tcl_e8_MainDomains()
{}

tU32 sds2hmi_fi_tcl_e8_MainDomains::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_MainDomains::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_MainDomains::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_HMIElementReference::sds2hmi_fi_tcl_e8_HMIElementReference():enType(FI_EN_ELEMENT_NONE) {}

tS32 sds2hmi_fi_tcl_e8_HMIElementReference::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_HMIELEMENTREFERENCE;
}


sds2hmi_fi_tcl_e8_HMIElementReference::~sds2hmi_fi_tcl_e8_HMIElementReference()
{}

tU32 sds2hmi_fi_tcl_e8_HMIElementReference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_HMIElementReference::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_HMIElementReference::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_CoreSpeechParameters::sds2hmi_fi_tcl_e8_CoreSpeechParameters():enType(FI_EN_COREPARAM_NONE) {}

tS32 sds2hmi_fi_tcl_e8_CoreSpeechParameters::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_CORESPEECHPARAMETERS;
}


sds2hmi_fi_tcl_e8_CoreSpeechParameters::~sds2hmi_fi_tcl_e8_CoreSpeechParameters()
{}

tU32 sds2hmi_fi_tcl_e8_CoreSpeechParameters::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_CoreSpeechParameters::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_CoreSpeechParameters::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_ActionInfoCategory::sds2hmi_fi_tcl_e8_ActionInfoCategory():enType(FI_EN_CATEGORY_NONE) {}

tS32 sds2hmi_fi_tcl_e8_ActionInfoCategory::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_ACTIONINFOCATEGORY;
}


sds2hmi_fi_tcl_e8_ActionInfoCategory::~sds2hmi_fi_tcl_e8_ActionInfoCategory()
{}

tU32 sds2hmi_fi_tcl_e8_ActionInfoCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_ActionInfoCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_ActionInfoCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_PhBook_Update_Action::sds2hmi_fi_tcl_e8_PhBook_Update_Action():enType(FI_EN_UPDATE_NONE) {}

tS32 sds2hmi_fi_tcl_e8_PhBook_Update_Action::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_PHBOOK_UPDATE_ACTION;
}


sds2hmi_fi_tcl_e8_PhBook_Update_Action::~sds2hmi_fi_tcl_e8_PhBook_Update_Action()
{}

tU32 sds2hmi_fi_tcl_e8_PhBook_Update_Action::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_PhBook_Update_Action::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_PhBook_Update_Action::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e16_PHN_Relationship::sds2hmi_fi_tcl_e16_PHN_Relationship():enType(FI_EN_REL_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e16_PHN_Relationship::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E16_PHN_RELATIONSHIP;
}


sds2hmi_fi_tcl_e16_PHN_Relationship::~sds2hmi_fi_tcl_e16_PHN_Relationship()
{}

tU32 sds2hmi_fi_tcl_e16_PHN_Relationship::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_e16_PHN_Relationship::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e16_PHN_Relationship::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Data_Exchange_Type::sds2hmi_fi_tcl_e8_Data_Exchange_Type():enType(FI_EN_DATA_NONE) {}

tS32 sds2hmi_fi_tcl_e8_Data_Exchange_Type::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_DATA_EXCHANGE_TYPE;
}


sds2hmi_fi_tcl_e8_Data_Exchange_Type::~sds2hmi_fi_tcl_e8_Data_Exchange_Type()
{}

tU32 sds2hmi_fi_tcl_e8_Data_Exchange_Type::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Data_Exchange_Type::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Data_Exchange_Type::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Common_SDS_Evnt::sds2hmi_fi_tcl_e8_Common_SDS_Evnt():enType(FI_EN_COMN_EVNT_NONE) {}

tS32 sds2hmi_fi_tcl_e8_Common_SDS_Evnt::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_COMMON_SDS_EVNT;
}


sds2hmi_fi_tcl_e8_Common_SDS_Evnt::~sds2hmi_fi_tcl_e8_Common_SDS_Evnt()
{}

tU32 sds2hmi_fi_tcl_e8_Common_SDS_Evnt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Common_SDS_Evnt::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Common_SDS_Evnt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat::sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat():enType(FI_EN_TA_IPA) {}

tS32 sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8NDSPHONETICTRANSCRIPTIONFORMAT;
}


sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat::~sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat()
{}

tU32 sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NDS_SDN_Status::sds2hmi_fi_tcl_e8_NDS_SDN_Status():enType(FI_EN_DATA_NOT_AVAILABLE) {}

tS32 sds2hmi_fi_tcl_e8_NDS_SDN_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NDS_SDN_STATUS;
}


sds2hmi_fi_tcl_e8_NDS_SDN_Status::~sds2hmi_fi_tcl_e8_NDS_SDN_Status()
{}

tU32 sds2hmi_fi_tcl_e8_NDS_SDN_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NDS_SDN_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NDS_SDN_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_INFO_MENU_SRVC_STATUS;
}


sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::~sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status()
{}

tU32 sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_EventForLogging::sds2hmi_fi_tcl_e8_EventForLogging():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_EventForLogging::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_EVENTFORLOGGING;
}


sds2hmi_fi_tcl_e8_EventForLogging::~sds2hmi_fi_tcl_e8_EventForLogging()
{}

tU32 sds2hmi_fi_tcl_e8_EventForLogging::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_EventForLogging::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_EventForLogging::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_Distance_Unit::sds2hmi_fi_tcl_e8_Distance_Unit():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_Distance_Unit::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_DISTANCE_UNIT;
}


sds2hmi_fi_tcl_e8_Distance_Unit::~sds2hmi_fi_tcl_e8_Distance_Unit()
{}

tU32 sds2hmi_fi_tcl_e8_Distance_Unit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_Distance_Unit::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_Distance_Unit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_SharedDataAccess::sds2hmi_fi_tcl_e8_SharedDataAccess():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_SharedDataAccess::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_SHAREDDATAACCESS;
}


sds2hmi_fi_tcl_e8_SharedDataAccess::~sds2hmi_fi_tcl_e8_SharedDataAccess()
{}

tU32 sds2hmi_fi_tcl_e8_SharedDataAccess::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_SharedDataAccess::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_SharedDataAccess::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_JournalingMode::sds2hmi_fi_tcl_e8_JournalingMode():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_JournalingMode::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_JOURNALINGMODE;
}


sds2hmi_fi_tcl_e8_JournalingMode::~sds2hmi_fi_tcl_e8_JournalingMode()
{}

tU32 sds2hmi_fi_tcl_e8_JournalingMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_JournalingMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_JournalingMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_LockType::sds2hmi_fi_tcl_e8_LockType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_LockType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_LOCKTYPE;
}


sds2hmi_fi_tcl_e8_LockType::~sds2hmi_fi_tcl_e8_LockType()
{}

tU32 sds2hmi_fi_tcl_e8_LockType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_LockType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_LockType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_NDSDataAccessType::sds2hmi_fi_tcl_e8_NDSDataAccessType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_NDSDataAccessType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_NDSDATAACCESSTYPE;
}


sds2hmi_fi_tcl_e8_NDSDataAccessType::~sds2hmi_fi_tcl_e8_NDSDataAccessType()
{}

tU32 sds2hmi_fi_tcl_e8_NDSDataAccessType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_NDSDataAccessType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_NDSDataAccessType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus::sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_REGISTRATIONANDDEREGISTRATIONSTATUS;
}


sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus::~sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus()
{}

tU32 sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_DestEntry::sds2hmi_fi_tcl_DestEntry(const sds2hmi_fi_tcl_DestEntry& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   CountryName = coRef.CountryName;
   CountyName = coRef.CountyName;
   CityName = coRef.CityName;
   StreetName = coRef.StreetName;
   POIName = coRef.POIName;
   HouseNr = coRef.HouseNr;
   RenamedDest = coRef.RenamedDest;
   nUswID_16 = coRef.nUswID_16;
   nUswID = coRef.nUswID;
   nDestListID = coRef.nDestListID;
   JunctionName = coRef.JunctionName;
}
sds2hmi_fi_tcl_DestEntry& sds2hmi_fi_tcl_DestEntry::operator=(const sds2hmi_fi_tcl_DestEntry& coRef)
{
   if (this == &coRef) return *this;
   CountryName = coRef.CountryName;
   CountyName = coRef.CountyName;
   CityName = coRef.CityName;
   StreetName = coRef.StreetName;
   POIName = coRef.POIName;
   HouseNr = coRef.HouseNr;
   RenamedDest = coRef.RenamedDest;
   nUswID_16 = coRef.nUswID_16;
   nUswID = coRef.nUswID;
   nDestListID = coRef.nDestListID;
   JunctionName = coRef.JunctionName;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_DestEntry::vDestroy()
{
   CountryName.vDestroy();
   CountyName.vDestroy();
   CityName.vDestroy();
   StreetName.vDestroy();
   POIName.vDestroy();
   HouseNr.vDestroy();
   RenamedDest.vDestroy();
   JunctionName.vDestroy();
}

sds2hmi_fi_tcl_DestEntry::sds2hmi_fi_tcl_DestEntry()
:CountryName()
,CountyName()
,CityName()
,StreetName()
,POIName()
,HouseNr()
,RenamedDest()
,nUswID_16(0)
,nUswID(0)
,nDestListID(0)
,JunctionName()
 {}

tS32 sds2hmi_fi_tcl_DestEntry::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_DESTENTRY;
}


sds2hmi_fi_tcl_DestEntry::~sds2hmi_fi_tcl_DestEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_DestEntry::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 2)
   {
      u32DynamicSize += 2;
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   return u32DynamicSize+4+CountryName.u32GetSize(u16MajorVersion)+CountyName.u32GetSize(u16MajorVersion)+CityName.u32GetSize(u16MajorVersion)+StreetName.u32GetSize(u16MajorVersion)+POIName.u32GetSize(u16MajorVersion)+HouseNr.u32GetSize(u16MajorVersion)+RenamedDest.u32GetSize(u16MajorVersion)+JunctionName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_DestEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CountryName);
   (tVoid) (oIn >> CountyName);
   (tVoid) (oIn >> CityName);
   (tVoid) (oIn >> StreetName);
   (tVoid) (oIn >> POIName);
   (tVoid) (oIn >> HouseNr);
   (tVoid) (oIn >> RenamedDest);
   if (oIn.u16GetMajorVersion() <= 2)
   {
      (tVoid) (oIn >> nUswID_16);
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> nUswID);
   }
   (tVoid) (oIn >> nDestListID);
   (tVoid) (oIn >> JunctionName);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_DestEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << CountyName);
   (tVoid) (oOut << CityName);
   (tVoid) (oOut << StreetName);
   (tVoid) (oOut << POIName);
   (tVoid) (oOut << HouseNr);
   (tVoid) (oOut << RenamedDest);
   if (oOut.u16GetMajorVersion() <= 2)
   {
      (tVoid) (oOut << nUswID_16);
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << nUswID);
   }
   (tVoid) (oOut << nDestListID);
   (tVoid) (oOut << JunctionName);
   return oOut;
}

tBool sds2hmi_fi_tcl_DestEntry::operator==(const sds2hmi_fi_tcl_DestEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CountryName == roRef.CountryName);
   bResult = bResult && (CountyName == roRef.CountyName);
   bResult = bResult && (CityName == roRef.CityName);
   bResult = bResult && (StreetName == roRef.StreetName);
   bResult = bResult && (POIName == roRef.POIName);
   bResult = bResult && (HouseNr == roRef.HouseNr);
   bResult = bResult && (RenamedDest == roRef.RenamedDest);
   bResult = bResult && (nUswID_16 == roRef.nUswID_16);
   bResult = bResult && (nUswID == roRef.nUswID);
   bResult = bResult && (nDestListID == roRef.nDestListID);
   bResult = bResult && (JunctionName == roRef.JunctionName);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_PhoneEntry::sds2hmi_fi_tcl_PhoneEntry(const sds2hmi_fi_tcl_PhoneEntry& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   LastName = coRef.LastName;
   FirstName = coRef.FirstName;
   PhoneNumber = coRef.PhoneNumber;
   PhoneNumberType = coRef.PhoneNumberType;
   nUswID_16 = coRef.nUswID_16;
   nUswID = coRef.nUswID;
   nUswListID_16 = coRef.nUswListID_16;
   nUswListID = coRef.nUswListID;
   nPhnBookListID = coRef.nPhnBookListID;
}
sds2hmi_fi_tcl_PhoneEntry& sds2hmi_fi_tcl_PhoneEntry::operator=(const sds2hmi_fi_tcl_PhoneEntry& coRef)
{
   if (this == &coRef) return *this;
   LastName = coRef.LastName;
   FirstName = coRef.FirstName;
   PhoneNumber = coRef.PhoneNumber;
   PhoneNumberType = coRef.PhoneNumberType;
   nUswID_16 = coRef.nUswID_16;
   nUswID = coRef.nUswID;
   nUswListID_16 = coRef.nUswListID_16;
   nUswListID = coRef.nUswListID;
   nPhnBookListID = coRef.nPhnBookListID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_PhoneEntry::vDestroy()
{
   LastName.vDestroy();
   FirstName.vDestroy();
   PhoneNumber.vDestroy();
}

sds2hmi_fi_tcl_PhoneEntry::sds2hmi_fi_tcl_PhoneEntry()
:LastName()
,FirstName()
,PhoneNumber()
,PhoneNumberType()
,nUswID_16(0)
,nUswID(0)
,nUswListID_16(0)
,nUswListID(0)
,nPhnBookListID(0)
 {}

tS32 sds2hmi_fi_tcl_PhoneEntry::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_PHONEENTRY;
}


sds2hmi_fi_tcl_PhoneEntry::~sds2hmi_fi_tcl_PhoneEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_PhoneEntry::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 2)
   {
      u32DynamicSize += 2;
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (u16MajorVersion <= 2)
   {
      u32DynamicSize += 2;
   }
   if (3 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
   }
   if (u16MajorVersion <= 1)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+1+LastName.u32GetSize(u16MajorVersion)+FirstName.u32GetSize(u16MajorVersion)+PhoneNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_PhoneEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LastName);
   (tVoid) (oIn >> FirstName);
   (tVoid) (oIn >> PhoneNumber);
   (tVoid) (oIn >> PhoneNumberType);
   if (oIn.u16GetMajorVersion() <= 2)
   {
      (tVoid) (oIn >> nUswID_16);
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> nUswID);
   }
   if (oIn.u16GetMajorVersion() <= 2)
   {
      (tVoid) (oIn >> nUswListID_16);
   }
   if (3 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> nUswListID);
   }
   if (oIn.u16GetMajorVersion() <= 1)
   {
      (tVoid) (oIn >> nPhnBookListID);
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_PhoneEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LastName);
   (tVoid) (oOut << FirstName);
   (tVoid) (oOut << PhoneNumber);
   (tVoid) (oOut << PhoneNumberType);
   if (oOut.u16GetMajorVersion() <= 2)
   {
      (tVoid) (oOut << nUswID_16);
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << nUswID);
   }
   if (oOut.u16GetMajorVersion() <= 2)
   {
      (tVoid) (oOut << nUswListID_16);
   }
   if (3 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << nUswListID);
   }
   if (oOut.u16GetMajorVersion() <= 1)
   {
      (tVoid) (oOut << nPhnBookListID);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_PhoneEntry::operator==(const sds2hmi_fi_tcl_PhoneEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LastName == roRef.LastName);
   bResult = bResult && (FirstName == roRef.FirstName);
   bResult = bResult && (PhoneNumber == roRef.PhoneNumber);
   bResult = bResult && (PhoneNumberType == roRef.PhoneNumberType);
   bResult = bResult && (nUswID_16 == roRef.nUswID_16);
   bResult = bResult && (nUswID == roRef.nUswID);
   bResult = bResult && (nUswListID_16 == roRef.nUswListID_16);
   bResult = bResult && (nUswListID == roRef.nUswListID);
   bResult = bResult && (nPhnBookListID == roRef.nPhnBookListID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_ContactData::sds2hmi_fi_tcl_ContactData(const sds2hmi_fi_tcl_ContactData& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ContactID = coRef.ContactID;
   ContactDetails = coRef.ContactDetails;
}
sds2hmi_fi_tcl_ContactData& sds2hmi_fi_tcl_ContactData::operator=(const sds2hmi_fi_tcl_ContactData& coRef)
{
   if (this == &coRef) return *this;
   ContactID = coRef.ContactID;
   ContactDetails = coRef.ContactDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_ContactData::vDestroy()
{
   ContactDetails.vDestroy();
}

sds2hmi_fi_tcl_ContactData::sds2hmi_fi_tcl_ContactData()
:ContactID(0)
,ContactDetails()
 {}

tS32 sds2hmi_fi_tcl_ContactData::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_CONTACTDATA;
}


sds2hmi_fi_tcl_ContactData::~sds2hmi_fi_tcl_ContactData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_ContactData::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+ContactDetails.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_ContactData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContactID);
   (tVoid) (oIn >> ContactDetails);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_ContactData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContactID);
   (tVoid) (oOut << ContactDetails);
   return oOut;
}

tBool sds2hmi_fi_tcl_ContactData::operator==(const sds2hmi_fi_tcl_ContactData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContactID == roRef.ContactID);
   bResult = bResult && (ContactDetails == roRef.ContactDetails);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_TmcEntry::sds2hmi_fi_tcl_TmcEntry(const sds2hmi_fi_tcl_TmcEntry& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   sMessage = coRef.sMessage;
   u32ID = coRef.u32ID;
}
sds2hmi_fi_tcl_TmcEntry& sds2hmi_fi_tcl_TmcEntry::operator=(const sds2hmi_fi_tcl_TmcEntry& coRef)
{
   if (this == &coRef) return *this;
   sMessage = coRef.sMessage;
   u32ID = coRef.u32ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_TmcEntry::vDestroy()
{
   sMessage.vDestroy();
}

sds2hmi_fi_tcl_TmcEntry::sds2hmi_fi_tcl_TmcEntry()
:sMessage()
,u32ID(0)
 {}

tS32 sds2hmi_fi_tcl_TmcEntry::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_TMCENTRY;
}


sds2hmi_fi_tcl_TmcEntry::~sds2hmi_fi_tcl_TmcEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_TmcEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sMessage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_TmcEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sMessage);
   (tVoid) (oIn >> u32ID);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_TmcEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sMessage);
   (tVoid) (oOut << u32ID);
   return oOut;
}

tBool sds2hmi_fi_tcl_TmcEntry::operator==(const sds2hmi_fi_tcl_TmcEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sMessage == roRef.sMessage);
   bResult = bResult && (u32ID == roRef.u32ID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_DeviceStatus::sds2hmi_fi_tcl_DeviceStatus(const sds2hmi_fi_tcl_DeviceStatus& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DeviceID = coRef.DeviceID;
   UUID = coRef.UUID;
   DeviceName = coRef.DeviceName;
   Status = coRef.Status;
   Type = coRef.Type;
}
sds2hmi_fi_tcl_DeviceStatus& sds2hmi_fi_tcl_DeviceStatus::operator=(const sds2hmi_fi_tcl_DeviceStatus& coRef)
{
   if (this == &coRef) return *this;
   DeviceID = coRef.DeviceID;
   UUID = coRef.UUID;
   DeviceName = coRef.DeviceName;
   Status = coRef.Status;
   Type = coRef.Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_DeviceStatus::vDestroy()
{
   UUID.vDestroy();
   DeviceName.vDestroy();
}

sds2hmi_fi_tcl_DeviceStatus::sds2hmi_fi_tcl_DeviceStatus()
:DeviceID(0)
,UUID()
,DeviceName()
,Status()
,Type()
 {}

tS32 sds2hmi_fi_tcl_DeviceStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_DEVICESTATUS;
}


sds2hmi_fi_tcl_DeviceStatus::~sds2hmi_fi_tcl_DeviceStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_DeviceStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+5+UUID.u32GetSize(u16MajorVersion)+DeviceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_DeviceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceID);
   (tVoid) (oIn >> UUID);
   (tVoid) (oIn >> DeviceName);
   (tVoid) (oIn >> Status);
   if (1 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> Type);
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_DeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceID);
   (tVoid) (oOut << UUID);
   (tVoid) (oOut << DeviceName);
   (tVoid) (oOut << Status);
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << Type);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_DeviceStatus::operator==(const sds2hmi_fi_tcl_DeviceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceID == roRef.DeviceID);
   bResult = bResult && (UUID == roRef.UUID);
   bResult = bResult && (DeviceName == roRef.DeviceName);
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (Type == roRef.Type);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_TunerEntry::sds2hmi_fi_tcl_TunerEntry(const sds2hmi_fi_tcl_TunerEntry& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Title = coRef.Title;
   Channel = coRef.Channel;
}
sds2hmi_fi_tcl_TunerEntry& sds2hmi_fi_tcl_TunerEntry::operator=(const sds2hmi_fi_tcl_TunerEntry& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Title = coRef.Title;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_TunerEntry::vDestroy()
{
   Title.vDestroy();
   Channel.vDestroy();
}

sds2hmi_fi_tcl_TunerEntry::sds2hmi_fi_tcl_TunerEntry()
:ID(0)
,Title()
,Channel()
 {}

tS32 sds2hmi_fi_tcl_TunerEntry::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_TUNERENTRY;
}


sds2hmi_fi_tcl_TunerEntry::~sds2hmi_fi_tcl_TunerEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_TunerEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Title.u32GetSize(u16MajorVersion)+Channel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_TunerEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> Title);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_TunerEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << Title);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool sds2hmi_fi_tcl_TunerEntry::operator==(const sds2hmi_fi_tcl_TunerEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (Title == roRef.Title);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_Userword::sds2hmi_fi_tcl_Userword(const sds2hmi_fi_tcl_Userword& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   UWProfile = coRef.UWProfile;
   LanguageID = coRef.LanguageID;
   PhoneUWs = coRef.PhoneUWs;
   TunerUWs = coRef.TunerUWs;
   NaviUWs = coRef.NaviUWs;
}
sds2hmi_fi_tcl_Userword& sds2hmi_fi_tcl_Userword::operator=(const sds2hmi_fi_tcl_Userword& coRef)
{
   if (this == &coRef) return *this;
   UWProfile = coRef.UWProfile;
   LanguageID = coRef.LanguageID;
   PhoneUWs = coRef.PhoneUWs;
   TunerUWs = coRef.TunerUWs;
   NaviUWs = coRef.NaviUWs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_Userword::vDestroy()
{
   LanguageID.vDestroy(); 
   {
   PhoneUWs.clear();
   }
   {
   TunerUWs.clear();
   }
   {
   NaviUWs.clear();
   }
}

sds2hmi_fi_tcl_Userword::sds2hmi_fi_tcl_Userword()
:UWProfile(0)
,LanguageID()



 {}

tS32 sds2hmi_fi_tcl_Userword::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_USERWORD;
}


sds2hmi_fi_tcl_Userword::~sds2hmi_fi_tcl_Userword()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_Userword::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20+PhoneUWs.size()*4+TunerUWs.size()*4+NaviUWs.size()*4;
}

fi_tclInContext& sds2hmi_fi_tcl_Userword::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UWProfile);
   (tVoid) (oIn >> LanguageID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PhoneUWs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhoneUWs[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      TunerUWs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunerUWs[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      NaviUWs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NaviUWs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_Userword::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UWProfile);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << (tU32)PhoneUWs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhoneUWs.size(); ++u32Idx)
         (tVoid) (oOut << PhoneUWs[u32Idx]);
   }
   (tVoid) (oOut << (tU32)TunerUWs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunerUWs.size(); ++u32Idx)
         (tVoid) (oOut << TunerUWs[u32Idx]);
   }
   (tVoid) (oOut << (tU32)NaviUWs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NaviUWs.size(); ++u32Idx)
         (tVoid) (oOut << NaviUWs[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_Userword::operator==(const sds2hmi_fi_tcl_Userword& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UWProfile == roRef.UWProfile);
   bResult = bResult && (LanguageID == roRef.LanguageID);
      bResult = bResult && (PhoneUWs.size() == roRef.PhoneUWs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhoneUWs.size()); ++u32Idx)
            bResult = bResult && (PhoneUWs[u32Idx] == roRef.PhoneUWs[u32Idx]);
      }
      bResult = bResult && (TunerUWs.size() == roRef.TunerUWs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunerUWs.size()); ++u32Idx)
            bResult = bResult && (TunerUWs[u32Idx] == roRef.TunerUWs[u32Idx]);
      }
      bResult = bResult && (NaviUWs.size() == roRef.NaviUWs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NaviUWs.size()); ++u32Idx)
            bResult = bResult && (NaviUWs[u32Idx] == roRef.NaviUWs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_LanguageAndSpeaker::sds2hmi_fi_tcl_LanguageAndSpeaker(const sds2hmi_fi_tcl_LanguageAndSpeaker& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SpeakerId = coRef.SpeakerId;
   Speaker = coRef.Speaker;
   LanguageID = coRef.LanguageID;
   Gender = coRef.Gender;
   ASRsupported = coRef.ASRsupported;
}
sds2hmi_fi_tcl_LanguageAndSpeaker& sds2hmi_fi_tcl_LanguageAndSpeaker::operator=(const sds2hmi_fi_tcl_LanguageAndSpeaker& coRef)
{
   if (this == &coRef) return *this;
   SpeakerId = coRef.SpeakerId;
   Speaker = coRef.Speaker;
   LanguageID = coRef.LanguageID;
   Gender = coRef.Gender;
   ASRsupported = coRef.ASRsupported;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_LanguageAndSpeaker::vDestroy()
{
   Speaker.vDestroy();
   LanguageID.vDestroy(); 
}

sds2hmi_fi_tcl_LanguageAndSpeaker::sds2hmi_fi_tcl_LanguageAndSpeaker()
:SpeakerId(0)
,Speaker()
,LanguageID()
,Gender()
,ASRsupported(0)
 {}

tS32 sds2hmi_fi_tcl_LanguageAndSpeaker::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_LANGUAGEANDSPEAKER;
}


sds2hmi_fi_tcl_LanguageAndSpeaker::~sds2hmi_fi_tcl_LanguageAndSpeaker()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_LanguageAndSpeaker::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+Speaker.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_LanguageAndSpeaker::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeakerId);
   (tVoid) (oIn >> Speaker);
   (tVoid) (oIn >> LanguageID);
   (tVoid) (oIn >> Gender);
   (tVoid) (oIn >> ASRsupported);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_LanguageAndSpeaker::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeakerId);
   (tVoid) (oOut << Speaker);
   (tVoid) (oOut << LanguageID);
   (tVoid) (oOut << Gender);
   (tVoid) (oOut << ASRsupported);
   return oOut;
}

tBool sds2hmi_fi_tcl_LanguageAndSpeaker::operator==(const sds2hmi_fi_tcl_LanguageAndSpeaker& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeakerId == roRef.SpeakerId);
   bResult = bResult && (Speaker == roRef.Speaker);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   bResult = bResult && (Gender == roRef.Gender);
   bResult = bResult && (ASRsupported == roRef.ASRsupported);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_MediaData::sds2hmi_fi_tcl_MediaData(const sds2hmi_fi_tcl_MediaData& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DataType = coRef.DataType;
   DataValue = coRef.DataValue;
}
sds2hmi_fi_tcl_MediaData& sds2hmi_fi_tcl_MediaData::operator=(const sds2hmi_fi_tcl_MediaData& coRef)
{
   if (this == &coRef) return *this;
   DataType = coRef.DataType;
   DataValue = coRef.DataValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_MediaData::vDestroy()
{
   DataValue.vDestroy();
}

sds2hmi_fi_tcl_MediaData::sds2hmi_fi_tcl_MediaData()
:DataType()
,DataValue()
 {}

tS32 sds2hmi_fi_tcl_MediaData::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_MEDIADATA;
}


sds2hmi_fi_tcl_MediaData::~sds2hmi_fi_tcl_MediaData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_MediaData::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DataValue.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_MediaData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataType);
   (tVoid) (oIn >> DataValue);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_MediaData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataType);
   (tVoid) (oOut << DataValue);
   return oOut;
}

tBool sds2hmi_fi_tcl_MediaData::operator==(const sds2hmi_fi_tcl_MediaData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataType == roRef.DataType);
   bResult = bResult && (DataValue == roRef.DataValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_MediaEntry::sds2hmi_fi_tcl_MediaEntry(const sds2hmi_fi_tcl_MediaEntry& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Data = coRef.Data;
}
sds2hmi_fi_tcl_MediaEntry& sds2hmi_fi_tcl_MediaEntry::operator=(const sds2hmi_fi_tcl_MediaEntry& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_MediaEntry::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         Data[u32Idx].vDestroy();
   Data.clear();
   }
}

sds2hmi_fi_tcl_MediaEntry::sds2hmi_fi_tcl_MediaEntry()
:ID(0)

 {}

tS32 sds2hmi_fi_tcl_MediaEntry::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_MEDIAENTRY;
}


sds2hmi_fi_tcl_MediaEntry::~sds2hmi_fi_tcl_MediaEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_MediaEntry::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Data.size(); ++u32ListIdx)
      u32DynamicSize += Data[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds2hmi_fi_tcl_MediaEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
      {
         Data[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Data.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Data[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_MediaEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << (tU32)Data.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         (tVoid) (oOut << Data[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_MediaEntry::operator==(const sds2hmi_fi_tcl_MediaEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
      bResult = bResult && (Data.size() == roRef.Data.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Data.size()); ++u32Idx)
            bResult = bResult && (Data[u32Idx] == roRef.Data[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_DeviceDatabase::sds2hmi_fi_tcl_DeviceDatabase(const sds2hmi_fi_tcl_DeviceDatabase& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DeviceID = coRef.DeviceID;
   Database = coRef.Database;
}
sds2hmi_fi_tcl_DeviceDatabase& sds2hmi_fi_tcl_DeviceDatabase::operator=(const sds2hmi_fi_tcl_DeviceDatabase& coRef)
{
   if (this == &coRef) return *this;
   DeviceID = coRef.DeviceID;
   Database = coRef.Database;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_DeviceDatabase::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Database.size(); ++u32Idx)
         Database[u32Idx].vDestroy();
   Database.clear();
   }
}

sds2hmi_fi_tcl_DeviceDatabase::sds2hmi_fi_tcl_DeviceDatabase()
:DeviceID(0)

 {}

tS32 sds2hmi_fi_tcl_DeviceDatabase::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_DEVICEDATABASE;
}


sds2hmi_fi_tcl_DeviceDatabase::~sds2hmi_fi_tcl_DeviceDatabase()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_DeviceDatabase::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Database.size(); ++u32ListIdx)
      u32DynamicSize += Database[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds2hmi_fi_tcl_DeviceDatabase::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Database.size(); ++u32Idx)
      {
         Database[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Database.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Database[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_DeviceDatabase::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceID);
   (tVoid) (oOut << (tU32)Database.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Database.size(); ++u32Idx)
         (tVoid) (oOut << Database[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_DeviceDatabase::operator==(const sds2hmi_fi_tcl_DeviceDatabase& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceID == roRef.DeviceID);
      bResult = bResult && (Database.size() == roRef.Database.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Database.size()); ++u32Idx)
            bResult = bResult && (Database[u32Idx] == roRef.Database[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_CON_AmbiguityResultEntry::sds2hmi_fi_tcl_CON_AmbiguityResultEntry(const sds2hmi_fi_tcl_CON_AmbiguityResultEntry& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   LocationType = coRef.LocationType;
   ContactID = coRef.ContactID;
   DisplayString = coRef.DisplayString;
}
sds2hmi_fi_tcl_CON_AmbiguityResultEntry& sds2hmi_fi_tcl_CON_AmbiguityResultEntry::operator=(const sds2hmi_fi_tcl_CON_AmbiguityResultEntry& coRef)
{
   if (this == &coRef) return *this;
   LocationType = coRef.LocationType;
   ContactID = coRef.ContactID;
   DisplayString = coRef.DisplayString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_CON_AmbiguityResultEntry::vDestroy()
{
   DisplayString.vDestroy();
}

sds2hmi_fi_tcl_CON_AmbiguityResultEntry::sds2hmi_fi_tcl_CON_AmbiguityResultEntry()
:LocationType()
,ContactID(0)
,DisplayString()
 {}

tS32 sds2hmi_fi_tcl_CON_AmbiguityResultEntry::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_CON_AMBIGUITYRESULTENTRY;
}


sds2hmi_fi_tcl_CON_AmbiguityResultEntry::~sds2hmi_fi_tcl_CON_AmbiguityResultEntry()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_CON_AmbiguityResultEntry::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+DisplayString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_CON_AmbiguityResultEntry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LocationType);
   (tVoid) (oIn >> ContactID);
   (tVoid) (oIn >> DisplayString);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_CON_AmbiguityResultEntry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LocationType);
   (tVoid) (oOut << ContactID);
   (tVoid) (oOut << DisplayString);
   return oOut;
}

tBool sds2hmi_fi_tcl_CON_AmbiguityResultEntry::operator==(const sds2hmi_fi_tcl_CON_AmbiguityResultEntry& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LocationType == roRef.LocationType);
   bResult = bResult && (ContactID == roRef.ContactID);
   bResult = bResult && (DisplayString == roRef.DisplayString);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_StringIDPair::sds2hmi_fi_tcl_StringIDPair(const sds2hmi_fi_tcl_StringIDPair& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   String = coRef.String;
}
sds2hmi_fi_tcl_StringIDPair& sds2hmi_fi_tcl_StringIDPair::operator=(const sds2hmi_fi_tcl_StringIDPair& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   String = coRef.String;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_StringIDPair::vDestroy()
{
   String.vDestroy();
}

sds2hmi_fi_tcl_StringIDPair::sds2hmi_fi_tcl_StringIDPair()
:ID(0)
,String()
 {}

tS32 sds2hmi_fi_tcl_StringIDPair::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_STRINGIDPAIR;
}


sds2hmi_fi_tcl_StringIDPair::~sds2hmi_fi_tcl_StringIDPair()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_StringIDPair::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_StringIDPair::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> String);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_StringIDPair::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << String);
   return oOut;
}

tBool sds2hmi_fi_tcl_StringIDPair::operator==(const sds2hmi_fi_tcl_StringIDPair& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (String == roRef.String);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_e8_MediaType::sds2hmi_fi_tcl_e8_MediaType():enType(FI_EN_UNKNOWN) {}

tS32 sds2hmi_fi_tcl_e8_MediaType::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_E8_MEDIATYPE;
}


sds2hmi_fi_tcl_e8_MediaType::~sds2hmi_fi_tcl_e8_MediaType()
{}

tU32 sds2hmi_fi_tcl_e8_MediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_fi_tcl_e8_MediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_e8_MediaType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_TypedMediaID::sds2hmi_fi_tcl_TypedMediaID(const sds2hmi_fi_tcl_TypedMediaID& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   MediaType = coRef.MediaType;
}
sds2hmi_fi_tcl_TypedMediaID& sds2hmi_fi_tcl_TypedMediaID::operator=(const sds2hmi_fi_tcl_TypedMediaID& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   MediaType = coRef.MediaType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_TypedMediaID::sds2hmi_fi_tcl_TypedMediaID()
:ID(0)
,MediaType()
 {}

tS32 sds2hmi_fi_tcl_TypedMediaID::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_TYPEDMEDIAID;
}


sds2hmi_fi_tcl_TypedMediaID::~sds2hmi_fi_tcl_TypedMediaID()
{}

tU32 sds2hmi_fi_tcl_TypedMediaID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_fi_tcl_TypedMediaID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> MediaType);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_TypedMediaID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << MediaType);
   return oOut;
}

tBool sds2hmi_fi_tcl_TypedMediaID::operator==(const sds2hmi_fi_tcl_TypedMediaID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (MediaType == roRef.MediaType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_MediaIDString::sds2hmi_fi_tcl_MediaIDString(const sds2hmi_fi_tcl_MediaIDString& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   MediaType = coRef.MediaType;
   String = coRef.String;
}
sds2hmi_fi_tcl_MediaIDString& sds2hmi_fi_tcl_MediaIDString::operator=(const sds2hmi_fi_tcl_MediaIDString& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   MediaType = coRef.MediaType;
   String = coRef.String;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_MediaIDString::vDestroy()
{
   String.vDestroy();
}

sds2hmi_fi_tcl_MediaIDString::sds2hmi_fi_tcl_MediaIDString()
:ID(0)
,MediaType()
,String()
 {}

tS32 sds2hmi_fi_tcl_MediaIDString::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_MEDIAIDSTRING;
}


sds2hmi_fi_tcl_MediaIDString::~sds2hmi_fi_tcl_MediaIDString()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_MediaIDString::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+String.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_MediaIDString::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> MediaType);
   (tVoid) (oIn >> String);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_MediaIDString::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << MediaType);
   (tVoid) (oOut << String);
   return oOut;
}

tBool sds2hmi_fi_tcl_MediaIDString::operator==(const sds2hmi_fi_tcl_MediaIDString& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (MediaType == roRef.MediaType);
   bResult = bResult && (String == roRef.String);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SDS_SettingsUnion::sds2hmi_fi_tcl_SDS_SettingsUnion(const sds2hmi_fi_tcl_SDS_SettingsUnion& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ParameterType = coRef.ParameterType;
   if  (coRef.poParameterData)
   {
      switch(ParameterType.enType)
      {
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_T_RESERVED:
         poParameterData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poParameterData);
         break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TBOOL:
         poParameterData = OSAL_NEW sds2hmi_fi_tclBool((const sds2hmi_fi_tclBool&)*coRef.poParameterData);
         break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TU32:
         poParameterData = OSAL_NEW sds2hmi_fi_tclU32((const sds2hmi_fi_tclU32&)*coRef.poParameterData);
         break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TSTRING:
         poParameterData = OSAL_NEW sds2hmi_fi_tclString((const sds2hmi_fi_tclString&)*coRef.poParameterData);
         break;
      default:
         poParameterData = OSAL_NULL;
      }
   }
   else
   {
      poParameterData = OSAL_NULL;
   }
}
sds2hmi_fi_tcl_SDS_SettingsUnion& sds2hmi_fi_tcl_SDS_SettingsUnion::operator=(const sds2hmi_fi_tcl_SDS_SettingsUnion& coRef)
{
   if (this == &coRef) return *this;
   OSAL_DELETE poParameterData;
   ParameterType = coRef.ParameterType;
   if  (coRef.poParameterData)
   {
      switch(ParameterType.enType)
      {
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_T_RESERVED:
         poParameterData = OSAL_NEW sds2hmi_fi_tcl_Reserved((const sds2hmi_fi_tcl_Reserved&)*coRef.poParameterData);
         break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TBOOL:
         poParameterData = OSAL_NEW sds2hmi_fi_tclBool((const sds2hmi_fi_tclBool&)*coRef.poParameterData);
         break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TU32:
         poParameterData = OSAL_NEW sds2hmi_fi_tclU32((const sds2hmi_fi_tclU32&)*coRef.poParameterData);
         break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TSTRING:
         poParameterData = OSAL_NEW sds2hmi_fi_tclString((const sds2hmi_fi_tclString&)*coRef.poParameterData);
         break;
      default:
         poParameterData = OSAL_NULL;
      }
   }
   else
   {
      poParameterData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_SDS_SettingsUnion::vDestroy()
{
   if (poParameterData)
   {
      poParameterData->vDestroy();
      OSAL_DELETE poParameterData;
      poParameterData = OSAL_NULL;
   }
}

sds2hmi_fi_tcl_SDS_SettingsUnion::sds2hmi_fi_tcl_SDS_SettingsUnion()
:poParameterData(0)
 {}

tS32 sds2hmi_fi_tcl_SDS_SettingsUnion::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SDS_SETTINGSUNION;
}


sds2hmi_fi_tcl_SDS_SettingsUnion::~sds2hmi_fi_tcl_SDS_SettingsUnion()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_SDS_SettingsUnion::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+(poParameterData?poParameterData->u32GetSize(u16MajorVersion):0);
}

fi_tclInContext& sds2hmi_fi_tcl_SDS_SettingsUnion::oRead(fi_tclInContext& oIn)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poParameterData;
#else
   if (poParameterData)
   {
      poParameterData->vDestroy();
      OSAL_DELETE poParameterData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> ParameterType);
   switch(ParameterType.enType)
   {
   case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_T_RESERVED:
      poParameterData = OSAL_NEW sds2hmi_fi_tcl_Reserved;
      break;
   case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TBOOL:
      poParameterData = OSAL_NEW sds2hmi_fi_tclBool;
      break;
   case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TU32:
      poParameterData = OSAL_NEW sds2hmi_fi_tclU32;
      break;
   case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TSTRING:
      poParameterData = OSAL_NEW sds2hmi_fi_tclString;
      break;
   default:
      oIn.Invalidate();
      poParameterData = OSAL_NULL;
   }
   if (poParameterData && oIn.bIsValid())
      poParameterData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SDS_SettingsUnion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ParameterType);
   if (poParameterData)
   {
      (tVoid) poParameterData->oWrite(oOut);
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_SDS_SettingsUnion::operator==(const sds2hmi_fi_tcl_SDS_SettingsUnion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ParameterType == roRef.ParameterType);
   if (bResult && poParameterData && roRef.poParameterData) 
   {
      switch (ParameterType.enType)
      {
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_T_RESERVED:
         bResult = bResult && (*(const sds2hmi_fi_tcl_Reserved*)poParameterData == *(const sds2hmi_fi_tcl_Reserved*)roRef.poParameterData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TBOOL:
         bResult = bResult && (*(const sds2hmi_fi_tclBool*)poParameterData == *(const sds2hmi_fi_tclBool*)roRef.poParameterData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TU32:
         bResult = bResult && (*(const sds2hmi_fi_tclU32*)poParameterData == *(const sds2hmi_fi_tclU32*)roRef.poParameterData); //lint !e826
      break;
      case sds2hmi_fi_tcl_e8_SDS_ParameterType::FI_EN_TSTRING:
         bResult = bResult && (*(const sds2hmi_fi_tclString*)poParameterData == *(const sds2hmi_fi_tclString*)roRef.poParameterData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poParameterData == roRef.poParameterData);
   }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SDS_SettingsRequest::sds2hmi_fi_tcl_SDS_SettingsRequest(const sds2hmi_fi_tcl_SDS_SettingsRequest& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Setting = coRef.Setting;
   Value = coRef.Value;
}
sds2hmi_fi_tcl_SDS_SettingsRequest& sds2hmi_fi_tcl_SDS_SettingsRequest::operator=(const sds2hmi_fi_tcl_SDS_SettingsRequest& coRef)
{
   if (this == &coRef) return *this;
   Setting = coRef.Setting;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_SDS_SettingsRequest::vDestroy()
{
   Value.vDestroy(); 
}

sds2hmi_fi_tcl_SDS_SettingsRequest::sds2hmi_fi_tcl_SDS_SettingsRequest()
:Setting()
,Value()
 {}

tS32 sds2hmi_fi_tcl_SDS_SettingsRequest::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SDS_SETTINGSREQUEST;
}


sds2hmi_fi_tcl_SDS_SettingsRequest::~sds2hmi_fi_tcl_SDS_SettingsRequest()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_SDS_SettingsRequest::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Value.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_SDS_SettingsRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Setting);
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SDS_SettingsRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Setting);
   (tVoid) (oOut << Value);
   return oOut;
}

tBool sds2hmi_fi_tcl_SDS_SettingsRequest::operator==(const sds2hmi_fi_tcl_SDS_SettingsRequest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Setting == roRef.Setting);
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SDS_Settings::sds2hmi_fi_tcl_SDS_Settings(const sds2hmi_fi_tcl_SDS_Settings& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   Setting = coRef.Setting;
   Value = coRef.Value;
   State = coRef.State;
}
sds2hmi_fi_tcl_SDS_Settings& sds2hmi_fi_tcl_SDS_Settings::operator=(const sds2hmi_fi_tcl_SDS_Settings& coRef)
{
   if (this == &coRef) return *this;
   Setting = coRef.Setting;
   Value = coRef.Value;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_SDS_Settings::vDestroy()
{
   Value.vDestroy(); 
}

sds2hmi_fi_tcl_SDS_Settings::sds2hmi_fi_tcl_SDS_Settings()
:Setting()
,Value()
,State()
 {}

tS32 sds2hmi_fi_tcl_SDS_Settings::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SDS_SETTINGS;
}


sds2hmi_fi_tcl_SDS_Settings::~sds2hmi_fi_tcl_SDS_Settings()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_SDS_Settings::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Value.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_SDS_Settings::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Setting);
   (tVoid) (oIn >> Value);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SDS_Settings::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Setting);
   (tVoid) (oOut << Value);
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds2hmi_fi_tcl_SDS_Settings::operator==(const sds2hmi_fi_tcl_SDS_Settings& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Setting == roRef.Setting);
   bResult = bResult && (Value == roRef.Value);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NeighboringLocation::sds2hmi_fi_tcl_NeighboringLocation(const sds2hmi_fi_tcl_NeighboringLocation& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   CriteriaByPosition = coRef.CriteriaByPosition;
   LocationByGroup = coRef.LocationByGroup;
   LocationList = coRef.LocationList;
}
sds2hmi_fi_tcl_NeighboringLocation& sds2hmi_fi_tcl_NeighboringLocation::operator=(const sds2hmi_fi_tcl_NeighboringLocation& coRef)
{
   if (this == &coRef) return *this;
   CriteriaByPosition = coRef.CriteriaByPosition;
   LocationByGroup = coRef.LocationByGroup;
   LocationList = coRef.LocationList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NeighboringLocation::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         LocationList[u32Idx].vDestroy();
   LocationList.clear();
   }
}

sds2hmi_fi_tcl_NeighboringLocation::sds2hmi_fi_tcl_NeighboringLocation()
:CriteriaByPosition()
,LocationByGroup()

 {}

tS32 sds2hmi_fi_tcl_NeighboringLocation::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NEIGHBORINGLOCATION;
}


sds2hmi_fi_tcl_NeighboringLocation::~sds2hmi_fi_tcl_NeighboringLocation()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NeighboringLocation::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LocationList.size(); ++u32ListIdx)
      u32DynamicSize += LocationList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& sds2hmi_fi_tcl_NeighboringLocation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CriteriaByPosition);
   (tVoid) (oIn >> LocationByGroup);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
      {
         LocationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LocationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LocationList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NeighboringLocation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CriteriaByPosition);
   (tVoid) (oOut << LocationByGroup);
   (tVoid) (oOut << (tU32)LocationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         (tVoid) (oOut << LocationList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_NeighboringLocation::operator==(const sds2hmi_fi_tcl_NeighboringLocation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CriteriaByPosition == roRef.CriteriaByPosition);
   bResult = bResult && (LocationByGroup == roRef.LocationByGroup);
      bResult = bResult && (LocationList.size() == roRef.LocationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LocationList.size()); ++u32Idx)
            bResult = bResult && (LocationList[u32Idx] == roRef.LocationList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SpecialAppAndStatus::sds2hmi_fi_tcl_SpecialAppAndStatus(const sds2hmi_fi_tcl_SpecialAppAndStatus& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SplAppId = coRef.SplAppId;
   SplAppStatus = coRef.SplAppStatus;
}
sds2hmi_fi_tcl_SpecialAppAndStatus& sds2hmi_fi_tcl_SpecialAppAndStatus::operator=(const sds2hmi_fi_tcl_SpecialAppAndStatus& coRef)
{
   if (this == &coRef) return *this;
   SplAppId = coRef.SplAppId;
   SplAppStatus = coRef.SplAppStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_SpecialAppAndStatus::sds2hmi_fi_tcl_SpecialAppAndStatus()
:SplAppId()
,SplAppStatus()
 {}

tS32 sds2hmi_fi_tcl_SpecialAppAndStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SPECIALAPPANDSTATUS;
}


sds2hmi_fi_tcl_SpecialAppAndStatus::~sds2hmi_fi_tcl_SpecialAppAndStatus()
{}

tU32 sds2hmi_fi_tcl_SpecialAppAndStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_SpecialAppAndStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SplAppId);
   (tVoid) (oIn >> SplAppStatus);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SpecialAppAndStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SplAppId);
   (tVoid) (oOut << SplAppStatus);
   return oOut;
}

tBool sds2hmi_fi_tcl_SpecialAppAndStatus::operator==(const sds2hmi_fi_tcl_SpecialAppAndStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SplAppId == roRef.SplAppId);
   bResult = bResult && (SplAppStatus == roRef.SplAppStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_HMIElementDescription::sds2hmi_fi_tcl_HMIElementDescription(const sds2hmi_fi_tcl_HMIElementDescription& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DescriptorTag = coRef.DescriptorTag;
   DescriptorValue = coRef.DescriptorValue;
   DescriptorId = coRef.DescriptorId;
   DestinationIdList = coRef.DestinationIdList;
   PhonemeList = coRef.PhonemeList;
}
sds2hmi_fi_tcl_HMIElementDescription& sds2hmi_fi_tcl_HMIElementDescription::operator=(const sds2hmi_fi_tcl_HMIElementDescription& coRef)
{
   if (this == &coRef) return *this;
   DescriptorTag = coRef.DescriptorTag;
   DescriptorValue = coRef.DescriptorValue;
   DescriptorId = coRef.DescriptorId;
   DestinationIdList = coRef.DestinationIdList;
   PhonemeList = coRef.PhonemeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_HMIElementDescription::vDestroy()
{
   DescriptorValue.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationIdList.size(); ++u32Idx)
         DestinationIdList[u32Idx].vDestroy();
   DestinationIdList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         PhonemeList[u32Idx].vDestroy();
   PhonemeList.clear();
   }
}

sds2hmi_fi_tcl_HMIElementDescription::sds2hmi_fi_tcl_HMIElementDescription()
:DescriptorTag()
,DescriptorValue()
,DescriptorId(0)


 {}

tS32 sds2hmi_fi_tcl_HMIElementDescription::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_HMIELEMENTDESCRIPTION;
}


sds2hmi_fi_tcl_HMIElementDescription::~sds2hmi_fi_tcl_HMIElementDescription()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_HMIElementDescription::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += PhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13+DescriptorValue.u32GetSize(u16MajorVersion)+DestinationIdList.size()*24;
}

fi_tclInContext& sds2hmi_fi_tcl_HMIElementDescription::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DescriptorTag);
   (tVoid) (oIn >> DescriptorValue);
   (tVoid) (oIn >> DescriptorId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DestinationIdList.size(); ++u32Idx)
      {
         DestinationIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DestinationIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DestinationIdList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
      {
         PhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PhonemeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_HMIElementDescription::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DescriptorTag);
   (tVoid) (oOut << DescriptorValue);
   (tVoid) (oOut << DescriptorId);
   (tVoid) (oOut << (tU32)DestinationIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationIdList.size(); ++u32Idx)
         (tVoid) (oOut << DestinationIdList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)PhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << PhonemeList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_HMIElementDescription::operator==(const sds2hmi_fi_tcl_HMIElementDescription& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DescriptorTag == roRef.DescriptorTag);
   bResult = bResult && (DescriptorValue == roRef.DescriptorValue);
   bResult = bResult && (DescriptorId == roRef.DescriptorId);
      bResult = bResult && (DestinationIdList.size() == roRef.DestinationIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DestinationIdList.size()); ++u32Idx)
            bResult = bResult && (DestinationIdList[u32Idx] == roRef.DestinationIdList[u32Idx]);
      }
      bResult = bResult && (PhonemeList.size() == roRef.PhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PhonemeList.size()); ++u32Idx)
            bResult = bResult && (PhonemeList[u32Idx] == roRef.PhonemeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_Nav_IconSetting::sds2hmi_fi_tcl_Nav_IconSetting(const sds2hmi_fi_tcl_Nav_IconSetting& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DisplayAction = coRef.DisplayAction;
   CategoryString = coRef.CategoryString;
   CategoryPredefined = coRef.CategoryPredefined;
}
sds2hmi_fi_tcl_Nav_IconSetting& sds2hmi_fi_tcl_Nav_IconSetting::operator=(const sds2hmi_fi_tcl_Nav_IconSetting& coRef)
{
   if (this == &coRef) return *this;
   DisplayAction = coRef.DisplayAction;
   CategoryString = coRef.CategoryString;
   CategoryPredefined = coRef.CategoryPredefined;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_Nav_IconSetting::vDestroy()
{
   CategoryString.vDestroy();
}

sds2hmi_fi_tcl_Nav_IconSetting::sds2hmi_fi_tcl_Nav_IconSetting()
:DisplayAction()
,CategoryString()
,CategoryPredefined()
 {}

tS32 sds2hmi_fi_tcl_Nav_IconSetting::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NAV_ICONSETTING;
}


sds2hmi_fi_tcl_Nav_IconSetting::~sds2hmi_fi_tcl_Nav_IconSetting()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_Nav_IconSetting::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+CategoryString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_Nav_IconSetting::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DisplayAction);
   (tVoid) (oIn >> CategoryString);
   (tVoid) (oIn >> CategoryPredefined);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_Nav_IconSetting::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DisplayAction);
   (tVoid) (oOut << CategoryString);
   (tVoid) (oOut << CategoryPredefined);
   return oOut;
}

tBool sds2hmi_fi_tcl_Nav_IconSetting::operator==(const sds2hmi_fi_tcl_Nav_IconSetting& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DisplayAction == roRef.DisplayAction);
   bResult = bResult && (CategoryString == roRef.CategoryString);
   bResult = bResult && (CategoryPredefined == roRef.CategoryPredefined);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_HMIElementDescrptionList::sds2hmi_fi_tcl_HMIElementDescrptionList(const sds2hmi_fi_tcl_HMIElementDescrptionList& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DescriptionList = coRef.DescriptionList;
}
sds2hmi_fi_tcl_HMIElementDescrptionList& sds2hmi_fi_tcl_HMIElementDescrptionList::operator=(const sds2hmi_fi_tcl_HMIElementDescrptionList& coRef)
{
   if (this == &coRef) return *this;
   DescriptionList = coRef.DescriptionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_HMIElementDescrptionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
         DescriptionList[u32Idx].vDestroy();
   DescriptionList.clear();
   }
}

sds2hmi_fi_tcl_HMIElementDescrptionList::sds2hmi_fi_tcl_HMIElementDescrptionList()

 {}

tS32 sds2hmi_fi_tcl_HMIElementDescrptionList::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_HMIELEMENTDESCRPTIONLIST;
}


sds2hmi_fi_tcl_HMIElementDescrptionList::~sds2hmi_fi_tcl_HMIElementDescrptionList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_HMIElementDescrptionList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += DescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_HMIElementDescrptionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
      {
         DescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DescriptionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_HMIElementDescrptionList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DescriptionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
         (tVoid) (oOut << DescriptionList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_HMIElementDescrptionList::operator==(const sds2hmi_fi_tcl_HMIElementDescrptionList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DescriptionList.size() == roRef.DescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DescriptionList.size()); ++u32Idx)
            bResult = bResult && (DescriptionList[u32Idx] == roRef.DescriptionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_CoreSpeechParameter::sds2hmi_fi_tcl_CoreSpeechParameter(const sds2hmi_fi_tcl_CoreSpeechParameter& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   CoreSpeechParameter = coRef.CoreSpeechParameter;
   Value = coRef.Value;
}
sds2hmi_fi_tcl_CoreSpeechParameter& sds2hmi_fi_tcl_CoreSpeechParameter::operator=(const sds2hmi_fi_tcl_CoreSpeechParameter& coRef)
{
   if (this == &coRef) return *this;
   CoreSpeechParameter = coRef.CoreSpeechParameter;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_CoreSpeechParameter::vDestroy()
{
   Value.vDestroy();
}

sds2hmi_fi_tcl_CoreSpeechParameter::sds2hmi_fi_tcl_CoreSpeechParameter()
:CoreSpeechParameter()
,Value()
 {}

tS32 sds2hmi_fi_tcl_CoreSpeechParameter::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_CORESPEECHPARAMETER;
}


sds2hmi_fi_tcl_CoreSpeechParameter::~sds2hmi_fi_tcl_CoreSpeechParameter()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_CoreSpeechParameter::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Value.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_CoreSpeechParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CoreSpeechParameter);
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_CoreSpeechParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CoreSpeechParameter);
   (tVoid) (oOut << Value);
   return oOut;
}

tBool sds2hmi_fi_tcl_CoreSpeechParameter::operator==(const sds2hmi_fi_tcl_CoreSpeechParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CoreSpeechParameter == roRef.CoreSpeechParameter);
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_Action_AdditionalInfo::sds2hmi_fi_tcl_Action_AdditionalInfo(const sds2hmi_fi_tcl_Action_AdditionalInfo& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ActionInfoCategory = coRef.ActionInfoCategory;
   InfoValue = coRef.InfoValue;
   InfoString = coRef.InfoString;
   DestinationIdList = coRef.DestinationIdList;
}
sds2hmi_fi_tcl_Action_AdditionalInfo& sds2hmi_fi_tcl_Action_AdditionalInfo::operator=(const sds2hmi_fi_tcl_Action_AdditionalInfo& coRef)
{
   if (this == &coRef) return *this;
   ActionInfoCategory = coRef.ActionInfoCategory;
   InfoValue = coRef.InfoValue;
   InfoString = coRef.InfoString;
   DestinationIdList = coRef.DestinationIdList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_Action_AdditionalInfo::vDestroy()
{
   InfoString.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationIdList.size(); ++u32Idx)
         DestinationIdList[u32Idx].vDestroy();
   DestinationIdList.clear();
   }
}

sds2hmi_fi_tcl_Action_AdditionalInfo::sds2hmi_fi_tcl_Action_AdditionalInfo()
:ActionInfoCategory()
,InfoValue(0)
,InfoString()

 {}

tS32 sds2hmi_fi_tcl_Action_AdditionalInfo::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_ACTION_ADDITIONALINFO;
}


sds2hmi_fi_tcl_Action_AdditionalInfo::~sds2hmi_fi_tcl_Action_AdditionalInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_Action_AdditionalInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+InfoString.u32GetSize(u16MajorVersion)+DestinationIdList.size()*24;
}

fi_tclInContext& sds2hmi_fi_tcl_Action_AdditionalInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActionInfoCategory);
   (tVoid) (oIn >> InfoValue);
   (tVoid) (oIn >> InfoString);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DestinationIdList.size(); ++u32Idx)
      {
         DestinationIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DestinationIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DestinationIdList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_Action_AdditionalInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActionInfoCategory);
   (tVoid) (oOut << InfoValue);
   (tVoid) (oOut << InfoString);
   (tVoid) (oOut << (tU32)DestinationIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationIdList.size(); ++u32Idx)
         (tVoid) (oOut << DestinationIdList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_Action_AdditionalInfo::operator==(const sds2hmi_fi_tcl_Action_AdditionalInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActionInfoCategory == roRef.ActionInfoCategory);
   bResult = bResult && (InfoValue == roRef.InfoValue);
   bResult = bResult && (InfoString == roRef.InfoString);
      bResult = bResult && (DestinationIdList.size() == roRef.DestinationIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DestinationIdList.size()); ++u32Idx)
            bResult = bResult && (DestinationIdList[u32Idx] == roRef.DestinationIdList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_RegionMetaData::sds2hmi_fi_tcl_RegionMetaData(const sds2hmi_fi_tcl_RegionMetaData& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   RegionMetaDataId = coRef.RegionMetaDataId;
   ISO_CountryCodeTxt = coRef.ISO_CountryCodeTxt;
   ISO_SubCountryCodeTxt = coRef.ISO_SubCountryCodeTxt;
}
sds2hmi_fi_tcl_RegionMetaData& sds2hmi_fi_tcl_RegionMetaData::operator=(const sds2hmi_fi_tcl_RegionMetaData& coRef)
{
   if (this == &coRef) return *this;
   RegionMetaDataId = coRef.RegionMetaDataId;
   ISO_CountryCodeTxt = coRef.ISO_CountryCodeTxt;
   ISO_SubCountryCodeTxt = coRef.ISO_SubCountryCodeTxt;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_RegionMetaData::vDestroy()
{
   ISO_CountryCodeTxt.vDestroy();
   ISO_SubCountryCodeTxt.vDestroy();
}

sds2hmi_fi_tcl_RegionMetaData::sds2hmi_fi_tcl_RegionMetaData()
:RegionMetaDataId(0)
,ISO_CountryCodeTxt()
,ISO_SubCountryCodeTxt()
 {}

tS32 sds2hmi_fi_tcl_RegionMetaData::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_REGIONMETADATA;
}


sds2hmi_fi_tcl_RegionMetaData::~sds2hmi_fi_tcl_RegionMetaData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_RegionMetaData::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ISO_CountryCodeTxt.u32GetSize(u16MajorVersion)+ISO_SubCountryCodeTxt.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_RegionMetaData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RegionMetaDataId);
   (tVoid) (oIn >> ISO_CountryCodeTxt);
   (tVoid) (oIn >> ISO_SubCountryCodeTxt);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_RegionMetaData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RegionMetaDataId);
   (tVoid) (oOut << ISO_CountryCodeTxt);
   (tVoid) (oOut << ISO_SubCountryCodeTxt);
   return oOut;
}

tBool sds2hmi_fi_tcl_RegionMetaData::operator==(const sds2hmi_fi_tcl_RegionMetaData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RegionMetaDataId == roRef.RegionMetaDataId);
   bResult = bResult && (ISO_CountryCodeTxt == roRef.ISO_CountryCodeTxt);
   bResult = bResult && (ISO_SubCountryCodeTxt == roRef.ISO_SubCountryCodeTxt);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_MetaData::sds2hmi_fi_tcl_MetaData(const sds2hmi_fi_tcl_MetaData& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   HasPhonetic = coRef.HasPhonetic;
   PhoneticTranscriptionFormat = coRef.PhoneticTranscriptionFormat;
}
sds2hmi_fi_tcl_MetaData& sds2hmi_fi_tcl_MetaData::operator=(const sds2hmi_fi_tcl_MetaData& coRef)
{
   if (this == &coRef) return *this;
   HasPhonetic = coRef.HasPhonetic;
   PhoneticTranscriptionFormat = coRef.PhoneticTranscriptionFormat;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_MetaData::sds2hmi_fi_tcl_MetaData()
:HasPhonetic(0)
,PhoneticTranscriptionFormat()
 {}

tS32 sds2hmi_fi_tcl_MetaData::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_METADATA;
}


sds2hmi_fi_tcl_MetaData::~sds2hmi_fi_tcl_MetaData()
{}

tU32 sds2hmi_fi_tcl_MetaData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_MetaData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HasPhonetic);
   (tVoid) (oIn >> PhoneticTranscriptionFormat);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_MetaData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HasPhonetic);
   (tVoid) (oOut << PhoneticTranscriptionFormat);
   return oOut;
}

tBool sds2hmi_fi_tcl_MetaData::operator==(const sds2hmi_fi_tcl_MetaData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HasPhonetic == roRef.HasPhonetic);
   bResult = bResult && (PhoneticTranscriptionFormat == roRef.PhoneticTranscriptionFormat);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_BuildingBlock::sds2hmi_fi_tcl_BuildingBlock(const sds2hmi_fi_tcl_BuildingBlock& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   BuildingBlockId = coRef.BuildingBlockId;
   BuildingBlockType = coRef.BuildingBlockType;
   Path = coRef.Path;
   EncryptionKeyId = coRef.EncryptionKeyId;
   MetaData = coRef.MetaData;
   TypeNDSSupplierId = coRef.TypeNDSSupplierId;
   TypeExtId = coRef.TypeExtId;
}
sds2hmi_fi_tcl_BuildingBlock& sds2hmi_fi_tcl_BuildingBlock::operator=(const sds2hmi_fi_tcl_BuildingBlock& coRef)
{
   if (this == &coRef) return *this;
   BuildingBlockId = coRef.BuildingBlockId;
   BuildingBlockType = coRef.BuildingBlockType;
   Path = coRef.Path;
   EncryptionKeyId = coRef.EncryptionKeyId;
   MetaData = coRef.MetaData;
   TypeNDSSupplierId = coRef.TypeNDSSupplierId;
   TypeExtId = coRef.TypeExtId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_BuildingBlock::vDestroy()
{
   Path.vDestroy();
   MetaData.vDestroy(); 
}

sds2hmi_fi_tcl_BuildingBlock::sds2hmi_fi_tcl_BuildingBlock()
:BuildingBlockId(0)
,BuildingBlockType(0)
,Path()
,EncryptionKeyId(0)
,MetaData()
,TypeNDSSupplierId(0)
,TypeExtId(0)
 {}

tS32 sds2hmi_fi_tcl_BuildingBlock::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_BUILDINGBLOCK;
}


sds2hmi_fi_tcl_BuildingBlock::~sds2hmi_fi_tcl_BuildingBlock()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_BuildingBlock::u32GetSize(tU16 u16MajorVersion) const
{
   return 15+Path.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_BuildingBlock::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BuildingBlockId);
   (tVoid) (oIn >> BuildingBlockType);
   (tVoid) (oIn >> Path);
   (tVoid) (oIn >> EncryptionKeyId);
   (tVoid) (oIn >> MetaData);
   (tVoid) (oIn >> TypeNDSSupplierId);
   (tVoid) (oIn >> TypeExtId);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_BuildingBlock::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BuildingBlockId);
   (tVoid) (oOut << BuildingBlockType);
   (tVoid) (oOut << Path);
   (tVoid) (oOut << EncryptionKeyId);
   (tVoid) (oOut << MetaData);
   (tVoid) (oOut << TypeNDSSupplierId);
   (tVoid) (oOut << TypeExtId);
   return oOut;
}

tBool sds2hmi_fi_tcl_BuildingBlock::operator==(const sds2hmi_fi_tcl_BuildingBlock& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BuildingBlockId == roRef.BuildingBlockId);
   bResult = bResult && (BuildingBlockType == roRef.BuildingBlockType);
   bResult = bResult && (Path == roRef.Path);
   bResult = bResult && (EncryptionKeyId == roRef.EncryptionKeyId);
   bResult = bResult && (MetaData == roRef.MetaData);
   bResult = bResult && (TypeNDSSupplierId == roRef.TypeNDSSupplierId);
   bResult = bResult && (TypeExtId == roRef.TypeExtId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_UpdateRegion::sds2hmi_fi_tcl_UpdateRegion(const sds2hmi_fi_tcl_UpdateRegion& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   UpdateRegionId = coRef.UpdateRegionId;
   BuilidingBlockList = coRef.BuilidingBlockList;
   RegionMetaDataList = coRef.RegionMetaDataList;
}
sds2hmi_fi_tcl_UpdateRegion& sds2hmi_fi_tcl_UpdateRegion::operator=(const sds2hmi_fi_tcl_UpdateRegion& coRef)
{
   if (this == &coRef) return *this;
   UpdateRegionId = coRef.UpdateRegionId;
   BuilidingBlockList = coRef.BuilidingBlockList;
   RegionMetaDataList = coRef.RegionMetaDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_UpdateRegion::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < BuilidingBlockList.size(); ++u32Idx)
         BuilidingBlockList[u32Idx].vDestroy();
   BuilidingBlockList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < RegionMetaDataList.size(); ++u32Idx)
         RegionMetaDataList[u32Idx].vDestroy();
   RegionMetaDataList.clear();
   }
}

sds2hmi_fi_tcl_UpdateRegion::sds2hmi_fi_tcl_UpdateRegion()
:UpdateRegionId(0)


 {}

tS32 sds2hmi_fi_tcl_UpdateRegion::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_UPDATEREGION;
}


sds2hmi_fi_tcl_UpdateRegion::~sds2hmi_fi_tcl_UpdateRegion()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_UpdateRegion::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < BuilidingBlockList.size(); ++u32ListIdx)
      u32DynamicSize += BuilidingBlockList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < RegionMetaDataList.size(); ++u32ListIdx)
      u32DynamicSize += RegionMetaDataList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+10;
}

fi_tclInContext& sds2hmi_fi_tcl_UpdateRegion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UpdateRegionId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < BuilidingBlockList.size(); ++u32Idx)
      {
         BuilidingBlockList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      BuilidingBlockList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> BuilidingBlockList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RegionMetaDataList.size(); ++u32Idx)
      {
         RegionMetaDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RegionMetaDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RegionMetaDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_UpdateRegion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UpdateRegionId);
   (tVoid) (oOut << (tU32)BuilidingBlockList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < BuilidingBlockList.size(); ++u32Idx)
         (tVoid) (oOut << BuilidingBlockList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)RegionMetaDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RegionMetaDataList.size(); ++u32Idx)
         (tVoid) (oOut << RegionMetaDataList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_UpdateRegion::operator==(const sds2hmi_fi_tcl_UpdateRegion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UpdateRegionId == roRef.UpdateRegionId);
      bResult = bResult && (BuilidingBlockList.size() == roRef.BuilidingBlockList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < BuilidingBlockList.size()); ++u32Idx)
            bResult = bResult && (BuilidingBlockList[u32Idx] == roRef.BuilidingBlockList[u32Idx]);
      }
      bResult = bResult && (RegionMetaDataList.size() == roRef.RegionMetaDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RegionMetaDataList.size()); ++u32Idx)
            bResult = bResult && (RegionMetaDataList[u32Idx] == roRef.RegionMetaDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SDSProduct::sds2hmi_fi_tcl_SDSProduct(const sds2hmi_fi_tcl_SDSProduct& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SupplierId = coRef.SupplierId;
   ProductId = coRef.ProductId;
   UpdateregionList = coRef.UpdateregionList;
   NDSLanguageList = coRef.NDSLanguageList;
}
sds2hmi_fi_tcl_SDSProduct& sds2hmi_fi_tcl_SDSProduct::operator=(const sds2hmi_fi_tcl_SDSProduct& coRef)
{
   if (this == &coRef) return *this;
   SupplierId = coRef.SupplierId;
   ProductId = coRef.ProductId;
   UpdateregionList = coRef.UpdateregionList;
   NDSLanguageList = coRef.NDSLanguageList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_SDSProduct::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < UpdateregionList.size(); ++u32Idx)
         UpdateregionList[u32Idx].vDestroy();
   UpdateregionList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < NDSLanguageList.size(); ++u32Idx)
         NDSLanguageList[u32Idx].vDestroy();
   NDSLanguageList.clear();
   }
}

sds2hmi_fi_tcl_SDSProduct::sds2hmi_fi_tcl_SDSProduct()
:SupplierId(0)
,ProductId(0)


 {}

tS32 sds2hmi_fi_tcl_SDSProduct::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SDSPRODUCT;
}


sds2hmi_fi_tcl_SDSProduct::~sds2hmi_fi_tcl_SDSProduct()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_SDSProduct::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < UpdateregionList.size(); ++u32ListIdx)
      u32DynamicSize += UpdateregionList[u32ListIdx].u32GetSize(u16MajorVersion);
   for (u32ListIdx = 0; u32ListIdx < NDSLanguageList.size(); ++u32ListIdx)
      u32DynamicSize += NDSLanguageList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

fi_tclInContext& sds2hmi_fi_tcl_SDSProduct::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SupplierId);
   (tVoid) (oIn >> ProductId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < UpdateregionList.size(); ++u32Idx)
      {
         UpdateregionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      UpdateregionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> UpdateregionList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NDSLanguageList.size(); ++u32Idx)
      {
         NDSLanguageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NDSLanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NDSLanguageList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SDSProduct::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SupplierId);
   (tVoid) (oOut << ProductId);
   (tVoid) (oOut << (tU32)UpdateregionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < UpdateregionList.size(); ++u32Idx)
         (tVoid) (oOut << UpdateregionList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)NDSLanguageList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NDSLanguageList.size(); ++u32Idx)
         (tVoid) (oOut << NDSLanguageList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_SDSProduct::operator==(const sds2hmi_fi_tcl_SDSProduct& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SupplierId == roRef.SupplierId);
   bResult = bResult && (ProductId == roRef.ProductId);
      bResult = bResult && (UpdateregionList.size() == roRef.UpdateregionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < UpdateregionList.size()); ++u32Idx)
            bResult = bResult && (UpdateregionList[u32Idx] == roRef.UpdateregionList[u32Idx]);
      }
      bResult = bResult && (NDSLanguageList.size() == roRef.NDSLanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NDSLanguageList.size()); ++u32Idx)
            bResult = bResult && (NDSLanguageList[u32Idx] == roRef.NDSLanguageList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_NDSLocationDetails::sds2hmi_fi_tcl_NDSLocationDetails(const sds2hmi_fi_tcl_NDSLocationDetails& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   CountryNDSIdList = coRef.CountryNDSIdList;
   StateNDSIdList = coRef.StateNDSIdList;
   CityNDSIdList = coRef.CityNDSIdList;
   CityNDSId = coRef.CityNDSId;
}
sds2hmi_fi_tcl_NDSLocationDetails& sds2hmi_fi_tcl_NDSLocationDetails::operator=(const sds2hmi_fi_tcl_NDSLocationDetails& coRef)
{
   if (this == &coRef) return *this;
   CountryNDSIdList = coRef.CountryNDSIdList;
   StateNDSIdList = coRef.StateNDSIdList;
   CityNDSIdList = coRef.CityNDSIdList;
   CityNDSId = coRef.CityNDSId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_NDSLocationDetails::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryNDSIdList.size(); ++u32Idx)
         CountryNDSIdList[u32Idx].vDestroy();
   CountryNDSIdList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < StateNDSIdList.size(); ++u32Idx)
         StateNDSIdList[u32Idx].vDestroy();
   StateNDSIdList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < CityNDSIdList.size(); ++u32Idx)
         CityNDSIdList[u32Idx].vDestroy();
   CityNDSIdList.clear();
   }
   CityNDSId.vDestroy(); 
}

sds2hmi_fi_tcl_NDSLocationDetails::sds2hmi_fi_tcl_NDSLocationDetails()



:CityNDSId()
 {}

tS32 sds2hmi_fi_tcl_NDSLocationDetails::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_NDSLOCATIONDETAILS;
}


sds2hmi_fi_tcl_NDSLocationDetails::~sds2hmi_fi_tcl_NDSLocationDetails()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_NDSLocationDetails::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 36+CountryNDSIdList.size()*24+StateNDSIdList.size()*24+CityNDSIdList.size()*24;
}

fi_tclInContext& sds2hmi_fi_tcl_NDSLocationDetails::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryNDSIdList.size(); ++u32Idx)
      {
         CountryNDSIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CountryNDSIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CountryNDSIdList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StateNDSIdList.size(); ++u32Idx)
      {
         StateNDSIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StateNDSIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StateNDSIdList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CityNDSIdList.size(); ++u32Idx)
      {
         CityNDSIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CityNDSIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CityNDSIdList[u32Idx]);
      }
   }
   (tVoid) (oIn >> CityNDSId);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_NDSLocationDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CountryNDSIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CountryNDSIdList.size(); ++u32Idx)
         (tVoid) (oOut << CountryNDSIdList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)StateNDSIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StateNDSIdList.size(); ++u32Idx)
         (tVoid) (oOut << StateNDSIdList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)CityNDSIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CityNDSIdList.size(); ++u32Idx)
         (tVoid) (oOut << CityNDSIdList[u32Idx]);
   }
   (tVoid) (oOut << CityNDSId);
   return oOut;
}

tBool sds2hmi_fi_tcl_NDSLocationDetails::operator==(const sds2hmi_fi_tcl_NDSLocationDetails& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CountryNDSIdList.size() == roRef.CountryNDSIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryNDSIdList.size()); ++u32Idx)
            bResult = bResult && (CountryNDSIdList[u32Idx] == roRef.CountryNDSIdList[u32Idx]);
      }
      bResult = bResult && (StateNDSIdList.size() == roRef.StateNDSIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StateNDSIdList.size()); ++u32Idx)
            bResult = bResult && (StateNDSIdList[u32Idx] == roRef.StateNDSIdList[u32Idx]);
      }
      bResult = bResult && (CityNDSIdList.size() == roRef.CityNDSIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CityNDSIdList.size()); ++u32Idx)
            bResult = bResult && (CityNDSIdList[u32Idx] == roRef.CityNDSIdList[u32Idx]);
      }
   bResult = bResult && (CityNDSId == roRef.CityNDSId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_Info_Menu_Srvice_Status::sds2hmi_fi_tcl_Info_Menu_Srvice_Status(const sds2hmi_fi_tcl_Info_Menu_Srvice_Status& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   ServiceMenu = coRef.ServiceMenu;
   Status = coRef.Status;
}
sds2hmi_fi_tcl_Info_Menu_Srvice_Status& sds2hmi_fi_tcl_Info_Menu_Srvice_Status::operator=(const sds2hmi_fi_tcl_Info_Menu_Srvice_Status& coRef)
{
   if (this == &coRef) return *this;
   ServiceMenu = coRef.ServiceMenu;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_Info_Menu_Srvice_Status::sds2hmi_fi_tcl_Info_Menu_Srvice_Status()
:ServiceMenu()
,Status()
 {}

tS32 sds2hmi_fi_tcl_Info_Menu_Srvice_Status::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_INFO_MENU_SRVICE_STATUS;
}


sds2hmi_fi_tcl_Info_Menu_Srvice_Status::~sds2hmi_fi_tcl_Info_Menu_Srvice_Status()
{}

tU32 sds2hmi_fi_tcl_Info_Menu_Srvice_Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_fi_tcl_Info_Menu_Srvice_Status::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceMenu);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_Info_Menu_Srvice_Status::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceMenu);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool sds2hmi_fi_tcl_Info_Menu_Srvice_Status::operator==(const sds2hmi_fi_tcl_Info_Menu_Srvice_Status& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceMenu == roRef.ServiceMenu);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_RecResult::sds2hmi_fi_tcl_RecResult(const sds2hmi_fi_tcl_RecResult& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   CommandId = coRef.CommandId;
   RecognizedString = coRef.RecognizedString;
   Confidence = coRef.Confidence;
}
sds2hmi_fi_tcl_RecResult& sds2hmi_fi_tcl_RecResult::operator=(const sds2hmi_fi_tcl_RecResult& coRef)
{
   if (this == &coRef) return *this;
   CommandId = coRef.CommandId;
   RecognizedString = coRef.RecognizedString;
   Confidence = coRef.Confidence;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_RecResult::vDestroy()
{
   RecognizedString.vDestroy();
}

sds2hmi_fi_tcl_RecResult::sds2hmi_fi_tcl_RecResult()
:CommandId(0)
,RecognizedString()
,Confidence(0)
 {}

tS32 sds2hmi_fi_tcl_RecResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_RECRESULT;
}


sds2hmi_fi_tcl_RecResult::~sds2hmi_fi_tcl_RecResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_RecResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+RecognizedString.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_RecResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CommandId);
   (tVoid) (oIn >> RecognizedString);
   (tVoid) (oIn >> Confidence);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_RecResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CommandId);
   (tVoid) (oOut << RecognizedString);
   (tVoid) (oOut << Confidence);
   return oOut;
}

tBool sds2hmi_fi_tcl_RecResult::operator==(const sds2hmi_fi_tcl_RecResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CommandId == roRef.CommandId);
   bResult = bResult && (RecognizedString == roRef.RecognizedString);
   bResult = bResult && (Confidence == roRef.Confidence);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_ConfThresholdSet::sds2hmi_fi_tcl_ConfThresholdSet(const sds2hmi_fi_tcl_ConfThresholdSet& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   HCT = coRef.HCT;
   LCT = coRef.LCT;
   HCD = coRef.HCD;
   MCD = coRef.MCD;
}
sds2hmi_fi_tcl_ConfThresholdSet& sds2hmi_fi_tcl_ConfThresholdSet::operator=(const sds2hmi_fi_tcl_ConfThresholdSet& coRef)
{
   if (this == &coRef) return *this;
   HCT = coRef.HCT;
   LCT = coRef.LCT;
   HCD = coRef.HCD;
   MCD = coRef.MCD;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_ConfThresholdSet::sds2hmi_fi_tcl_ConfThresholdSet()
:HCT(0)
,LCT(0)
,HCD(0)
,MCD(0)
 {}

tS32 sds2hmi_fi_tcl_ConfThresholdSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_CONFTHRESHOLDSET;
}


sds2hmi_fi_tcl_ConfThresholdSet::~sds2hmi_fi_tcl_ConfThresholdSet()
{}

tU32 sds2hmi_fi_tcl_ConfThresholdSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& sds2hmi_fi_tcl_ConfThresholdSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HCT);
   (tVoid) (oIn >> LCT);
   (tVoid) (oIn >> HCD);
   (tVoid) (oIn >> MCD);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_ConfThresholdSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HCT);
   (tVoid) (oOut << LCT);
   (tVoid) (oOut << HCD);
   (tVoid) (oOut << MCD);
   return oOut;
}

tBool sds2hmi_fi_tcl_ConfThresholdSet::operator==(const sds2hmi_fi_tcl_ConfThresholdSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HCT == roRef.HCT);
   bResult = bResult && (LCT == roRef.LCT);
   bResult = bResult && (HCD == roRef.HCD);
   bResult = bResult && (MCD == roRef.MCD);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_DestinationAndLanguageDetails::sds2hmi_fi_tcl_DestinationAndLanguageDetails(const sds2hmi_fi_tcl_DestinationAndLanguageDetails& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DestinationType = coRef.DestinationType;
   Language = coRef.Language;
}
sds2hmi_fi_tcl_DestinationAndLanguageDetails& sds2hmi_fi_tcl_DestinationAndLanguageDetails::operator=(const sds2hmi_fi_tcl_DestinationAndLanguageDetails& coRef)
{
   if (this == &coRef) return *this;
   DestinationType = coRef.DestinationType;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_DestinationAndLanguageDetails::sds2hmi_fi_tcl_DestinationAndLanguageDetails()
:DestinationType()
,Language()
 {}

tS32 sds2hmi_fi_tcl_DestinationAndLanguageDetails::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_DESTINATIONANDLANGUAGEDETAILS;
}


sds2hmi_fi_tcl_DestinationAndLanguageDetails::~sds2hmi_fi_tcl_DestinationAndLanguageDetails()
{}

tU32 sds2hmi_fi_tcl_DestinationAndLanguageDetails::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_fi_tcl_DestinationAndLanguageDetails::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DestinationType);
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_DestinationAndLanguageDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DestinationType);
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds2hmi_fi_tcl_DestinationAndLanguageDetails::operator==(const sds2hmi_fi_tcl_DestinationAndLanguageDetails& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DestinationType == roRef.DestinationType);
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_SharedDataAccessAttributes::sds2hmi_fi_tcl_SharedDataAccessAttributes(const sds2hmi_fi_tcl_SharedDataAccessAttributes& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   SharedDataAccess = coRef.SharedDataAccess;
   JournalingMode = coRef.JournalingMode;
   LockType = coRef.LockType;
}
sds2hmi_fi_tcl_SharedDataAccessAttributes& sds2hmi_fi_tcl_SharedDataAccessAttributes::operator=(const sds2hmi_fi_tcl_SharedDataAccessAttributes& coRef)
{
   if (this == &coRef) return *this;
   SharedDataAccess = coRef.SharedDataAccess;
   JournalingMode = coRef.JournalingMode;
   LockType = coRef.LockType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_fi_tcl_SharedDataAccessAttributes::sds2hmi_fi_tcl_SharedDataAccessAttributes()
:SharedDataAccess()
,JournalingMode()
,LockType()
 {}

tS32 sds2hmi_fi_tcl_SharedDataAccessAttributes::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_SHAREDDATAACCESSATTRIBUTES;
}


sds2hmi_fi_tcl_SharedDataAccessAttributes::~sds2hmi_fi_tcl_SharedDataAccessAttributes()
{}

tU32 sds2hmi_fi_tcl_SharedDataAccessAttributes::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds2hmi_fi_tcl_SharedDataAccessAttributes::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SharedDataAccess);
   (tVoid) (oIn >> JournalingMode);
   (tVoid) (oIn >> LockType);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_SharedDataAccessAttributes::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SharedDataAccess);
   (tVoid) (oOut << JournalingMode);
   (tVoid) (oOut << LockType);
   return oOut;
}

tBool sds2hmi_fi_tcl_SharedDataAccessAttributes::operator==(const sds2hmi_fi_tcl_SharedDataAccessAttributes& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SharedDataAccess == roRef.SharedDataAccess);
   bResult = bResult && (JournalingMode == roRef.JournalingMode);
   bResult = bResult && (LockType == roRef.LockType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_DestinationElement::sds2hmi_fi_tcl_DestinationElement(const sds2hmi_fi_tcl_DestinationElement& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DestinationItemType = coRef.DestinationItemType;
   Language = coRef.Language;
   DestinationItem = coRef.DestinationItem;
}
sds2hmi_fi_tcl_DestinationElement& sds2hmi_fi_tcl_DestinationElement::operator=(const sds2hmi_fi_tcl_DestinationElement& coRef)
{
   if (this == &coRef) return *this;
   DestinationItemType = coRef.DestinationItemType;
   Language = coRef.Language;
   DestinationItem = coRef.DestinationItem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_DestinationElement::vDestroy()
{
   Language.vDestroy(); 
   DestinationItem.vDestroy();
}

sds2hmi_fi_tcl_DestinationElement::sds2hmi_fi_tcl_DestinationElement()
:DestinationItemType()
,Language()
,DestinationItem()
 {}

tS32 sds2hmi_fi_tcl_DestinationElement::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_DESTINATIONELEMENT;
}


sds2hmi_fi_tcl_DestinationElement::~sds2hmi_fi_tcl_DestinationElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_DestinationElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+DestinationItem.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_DestinationElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DestinationItemType);
   (tVoid) (oIn >> Language);
   (tVoid) (oIn >> DestinationItem);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_DestinationElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DestinationItemType);
   (tVoid) (oOut << Language);
   (tVoid) (oOut << DestinationItem);
   return oOut;
}

tBool sds2hmi_fi_tcl_DestinationElement::operator==(const sds2hmi_fi_tcl_DestinationElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DestinationItemType == roRef.DestinationItemType);
   bResult = bResult && (Language == roRef.Language);
   bResult = bResult && (DestinationItem == roRef.DestinationItem);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_DestinationItem::sds2hmi_fi_tcl_DestinationItem(const sds2hmi_fi_tcl_DestinationItem& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DestinationItem = coRef.DestinationItem;
}
sds2hmi_fi_tcl_DestinationItem& sds2hmi_fi_tcl_DestinationItem::operator=(const sds2hmi_fi_tcl_DestinationItem& coRef)
{
   if (this == &coRef) return *this;
   DestinationItem = coRef.DestinationItem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_DestinationItem::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationItem.size(); ++u32Idx)
         DestinationItem[u32Idx].vDestroy();
   DestinationItem.clear();
   }
}

sds2hmi_fi_tcl_DestinationItem::sds2hmi_fi_tcl_DestinationItem()

 {}

tS32 sds2hmi_fi_tcl_DestinationItem::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_DESTINATIONITEM;
}


sds2hmi_fi_tcl_DestinationItem::~sds2hmi_fi_tcl_DestinationItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_DestinationItem::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DestinationItem.size(); ++u32ListIdx)
      u32DynamicSize += DestinationItem[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_fi_tcl_DestinationItem::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DestinationItem.size(); ++u32Idx)
      {
         DestinationItem[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DestinationItem.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DestinationItem[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_DestinationItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DestinationItem.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DestinationItem.size(); ++u32Idx)
         (tVoid) (oOut << DestinationItem[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_fi_tcl_DestinationItem::operator==(const sds2hmi_fi_tcl_DestinationItem& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DestinationItem.size() == roRef.DestinationItem.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DestinationItem.size()); ++u32Idx)
            bResult = bResult && (DestinationItem[u32Idx] == roRef.DestinationItem[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_fi_tcl_ValidatedDestinationDetails::sds2hmi_fi_tcl_ValidatedDestinationDetails(const sds2hmi_fi_tcl_ValidatedDestinationDetails& coRef)
   : sds2hmi_fi_tclVisitableTypeBase(coRef)
{
   DestinationItemType = coRef.DestinationItemType;
   DestinationItem = coRef.DestinationItem;
}
sds2hmi_fi_tcl_ValidatedDestinationDetails& sds2hmi_fi_tcl_ValidatedDestinationDetails::operator=(const sds2hmi_fi_tcl_ValidatedDestinationDetails& coRef)
{
   if (this == &coRef) return *this;
   DestinationItemType = coRef.DestinationItemType;
   DestinationItem = coRef.DestinationItem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_fi_tcl_ValidatedDestinationDetails::vDestroy()
{
   DestinationItem.vDestroy();
}

sds2hmi_fi_tcl_ValidatedDestinationDetails::sds2hmi_fi_tcl_ValidatedDestinationDetails()
:DestinationItemType()
,DestinationItem()
 {}

tS32 sds2hmi_fi_tcl_ValidatedDestinationDetails::s32GetTypeId() const
{
   return (tS32) sds2hmi_typesfi_tclToken::EN_VALIDATEDDESTINATIONDETAILS;
}


sds2hmi_fi_tcl_ValidatedDestinationDetails::~sds2hmi_fi_tcl_ValidatedDestinationDetails()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_fi_tcl_ValidatedDestinationDetails::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DestinationItem.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_fi_tcl_ValidatedDestinationDetails::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DestinationItemType);
   (tVoid) (oIn >> DestinationItem);
   return oIn;
}

fi_tclOutContext& sds2hmi_fi_tcl_ValidatedDestinationDetails::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DestinationItemType);
   (tVoid) (oOut << DestinationItem);
   return oOut;
}

tBool sds2hmi_fi_tcl_ValidatedDestinationDetails::operator==(const sds2hmi_fi_tcl_ValidatedDestinationDetails& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DestinationItemType == roRef.DestinationItemType);
   bResult = bResult && (DestinationItem == roRef.DestinationItem);
   return bResult;
}

