/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS2HMI_ALLFITYPES_HEADER
#define SDS2HMI_ALLFITYPES_HEADER

#include <vector>

class sds2hmi_fi_tclVisitorBase;

const tU16 SDS2HMI_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 SDS2HMI_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 SDS2HMI_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class sds2hmi_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  sds2hmi_fi_tclTypeBase() {}
  virtual ~sds2hmi_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& /*oVisitor*/) {}
};

class sds2hmi_fi_tclVisitableTypeBase :public sds2hmi_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& /*oVisitor*/) {}
};

class sds2hmi_fi_tclU8 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclU8& roRef) const
      { return (u8Value == roRef.u8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_U8;}
};

class sds2hmi_fi_tclS8 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclS8& roRef) const
      { return (s8Value == roRef.s8Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_S8;}
};

class sds2hmi_fi_tclU16 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclU16& roRef) const
      { return (u16Value == roRef.u16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_U16;}
};

class sds2hmi_fi_tclS16 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclS16& roRef) const
      { return (s16Value == roRef.s16Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_S16;}
};

class sds2hmi_fi_tclU24 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclU24& roRef) const
      { return (u24Value == roRef.u24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_U24;}
};

class sds2hmi_fi_tclS24 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclS24& roRef) const
      { return (s24Value == roRef.s24Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_S24;}
};

class sds2hmi_fi_tclU32 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclU32& roRef) const
      { return (u32Value == roRef.u32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_U32;}
};

class sds2hmi_fi_tclS32 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclS32& roRef) const
      { return (s32Value == roRef.s32Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_S32;}
};

class sds2hmi_fi_tclU64 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclU64& roRef) const
      { return (u64Value == roRef.u64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_U64;}
};

class sds2hmi_fi_tclS64 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclS64& roRef) const
      { return (s64Value == roRef.s64Value); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_S64;}
};

class sds2hmi_fi_tclF32 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclF32& roRef) const
      { return (f32Value == roRef.f32Value);  } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_F32;}
};

class sds2hmi_fi_tclF64 : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclF64& roRef) const
      { return (f64Value == roRef.f64Value); } //lint !e777
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_F64;}
};

class sds2hmi_fi_tclBool : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   inline tBool operator==(const sds2hmi_fi_tclBool& roRef) const
      { return (bValue == roRef.bValue); }
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_BOOL;}
};

class sds2hmi_fi_tclString : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tclString(const sds2hmi_fi_tclString& coRef);
   sds2hmi_fi_tclString& operator=(const sds2hmi_fi_tclString& coRef);
   virtual ~sds2hmi_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const sds2hmi_fi_tclString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   sds2hmi_fi_tclString& operator=(tCString coszString); // ADDED
   sds2hmi_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const sds2hmi_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class sds2hmi_fi_tclList : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const sds2hmi_fi_tclList& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_LIST;}
};

class sds2hmi_fi_tclMultiLanguageString : public sds2hmi_fi_tclVisitableTypeBase
{
public:
   sds2hmi_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tclMultiLanguageString(const sds2hmi_fi_tclMultiLanguageString& coRef);
   sds2hmi_fi_tclMultiLanguageString& operator=(const sds2hmi_fi_tclMultiLanguageString& coRef);
   virtual ~sds2hmi_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   tBool operator==(const sds2hmi_fi_tclMultiLanguageString& roRef) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(sds2hmi_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   sds2hmi_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   sds2hmi_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return sds2hmi_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const sds2hmi_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class sds2hmi_fi_tcl_e8_BinContainerTypes;
class sds2hmi_fi_tcl_BinContainer;
class sds2hmi_fi_tcl_Reserved;
class sds2hmi_fi_tcl_u8_Percent;
class sds2hmi_fi_tcl_s16_PerThousand;
class sds2hmi_fi_tcl_u16_IndexInReferenceList;
class sds2hmi_fi_tcl_u16_ErrorCode;
class sds2hmi_fi_tcl_u16_RPM;
class sds2hmi_fi_tcl_s32_Kilogram;
class sds2hmi_fi_tcl_s32_Pound;
class sds2hmi_fi_tcl_s16_Meter;
class sds2hmi_fi_tcl_s32_Meter;
class sds2hmi_fi_tcl_s32_Yards;
class sds2hmi_fi_tcl_s32_Foot;
class sds2hmi_fi_tcl_s32_Centimeter;
class sds2hmi_fi_tcl_s32_Inch;
class sds2hmi_fi_tcl_s32_Millimeter;
class sds2hmi_fi_tcl_s32_Microliter;
class sds2hmi_fi_tcl_s32_Second;
class sds2hmi_fi_tcl_u16_MilliSecond;
class sds2hmi_fi_tcl_s32_MilliSecond;
class sds2hmi_fi_tcl_POSIXTime;
class sds2hmi_fi_tcl_e8_DST_State;
class sds2hmi_fi_tcl_TimeZoneElement;
class sds2hmi_fi_tcl_s16_KmPerHour;
class sds2hmi_fi_tcl_s16_MilesPerHour;
class sds2hmi_fi_tcl_s16_Knot;
class sds2hmi_fi_tcl_s16_CentimeterSecond;
class sds2hmi_fi_tcl_s16_Kelvin;
class sds2hmi_fi_tcl_s16_Fahrenheit;
class sds2hmi_fi_tcl_s32_Pascal;
class sds2hmi_fi_tcl_s32_Watt;
class sds2hmi_fi_tcl_FIVersion;
class sds2hmi_fi_tcl_s32_Longitude;
class sds2hmi_fi_tcl_s32_Latitude;
class sds2hmi_fi_tcl_PositionWGS84;
class sds2hmi_fi_tcl_RectangleWGS84;
class sds2hmi_fi_tcl_e16_ISOCountryCode;
class sds2hmi_fi_tcl_e16_ISOLanguageCode;
class sds2hmi_fi_tcl_LanguageID;
class sds2hmi_fi_tcl_u8_DirectionAbsolute;
class sds2hmi_fi_tcl_u8_DirectionRelative;
class sds2hmi_fi_tcl_s16_CentiDegree;
class sds2hmi_fi_tcl_s16_Degree;
class sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree;
class sds2hmi_fi_tcl_e8_FuelType;
class sds2hmi_fi_tcl_DistTimeFuel;
class sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode;
class sds2hmi_fi_tcl_e8_Slot;
class sds2hmi_fi_tcl_e8_Domain;
class sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus;
class sds2hmi_fi_tcl_e8_PromptSetting;
class sds2hmi_fi_tcl_e8_WordType;
class sds2hmi_fi_tcl_e8_NDSFeatureType;
class sds2hmi_fi_tcl_e32_SSE_ASR_Mode;
class sds2hmi_fi_tcl_e8_SDSDestinationType;
class sds2hmi_fi_tcl_SDSLanguageID;
class sds2hmi_fi_tcl_ConnectedDeviceStatus;
class sds2hmi_fi_tcl_NDSLanguageID;
class sds2hmi_fi_tcl_NDSID;
class sds2hmi_fi_tcl_StreetAvailability;
class sds2hmi_fi_tcl_PhonemeForLanguage;
class sds2hmi_fi_tcl_StringAndPhoneme;
class sds2hmi_fi_tcl_StatePhoneme;
class sds2hmi_fi_tcl_CountryPhoneme;
class sds2hmi_fi_tcl_CityId;
class sds2hmi_fi_tcl_ECNR_ASR_Mode_Status;
class sds2hmi_fi_tcl_e16_SelectionCriterionType;
class sds2hmi_fi_tcl_e8_LocationDescriptionDataType;
class sds2hmi_fi_tcl_b8_LocationDescriptorStatus;
class sds2hmi_fi_tcl_LocationDescriptor;
class sds2hmi_fi_tcl_LocationDescription;
class sds2hmi_fi_tcl_StringPosition;
class sds2hmi_fi_tcl_StringID;
class sds2hmi_fi_tcl_FLIString;
class sds2hmi_fi_tcl_b8_PositionStatus;
class sds2hmi_fi_tcl_ListOfPositions;
class sds2hmi_fi_tcl_e8_FilterAttributeType;
class sds2hmi_fi_tcl_FilterAttribute;
class sds2hmi_fi_tcl_e16_MenuItemType;
class sds2hmi_fi_tcl_e8_LocationValueListType;
class sds2hmi_fi_tcl_b8_ListResultOptions;
class sds2hmi_fi_tcl_b8_ListGetOptions;
class sds2hmi_fi_tcl_LocationValueListUnion;
class sds2hmi_fi_tcl_b16_ElementProperties;
class sds2hmi_fi_tcl_StringElement;
class sds2hmi_fi_tcl_StringList;
class sds2hmi_fi_tcl_StringDescriptionElement;
class sds2hmi_fi_tcl_StringDescriptionList;
class sds2hmi_fi_tcl_StringIDElement;
class sds2hmi_fi_tcl_StringIDList;
class sds2hmi_fi_tcl_PositionWGS84Element;
class sds2hmi_fi_tcl_PositionWGS84List;
class sds2hmi_fi_tcl_StringPositionElement;
class sds2hmi_fi_tcl_StringPositionList;
class sds2hmi_fi_tcl_StringPositionDescriptionElement;
class sds2hmi_fi_tcl_StringPositionDescriptionList;
class sds2hmi_fi_tcl_b8_CriterionStatus;
class sds2hmi_fi_tcl_b8_ListSortOptions;
class sds2hmi_fi_tcl_SelectionCriterionDescription;
class sds2hmi_fi_tcl_b8_CriteriaGetOptions;
class sds2hmi_fi_tcl_SelectableCriterion;
class sds2hmi_fi_tcl_e8_TransformMode;
class sds2hmi_fi_tcl_b16_PositionReliability;
class sds2hmi_fi_tcl_PositionHeadingSpeed;
class sds2hmi_fi_tcl_e8_NavLocationDescType;
class sds2hmi_fi_tcl_NavLocationDesc;
#ifndef FI_S_EXTERNAL_FI
class sds2hmi_fi_tcl_NavLocationBinContainer;
#endif // FI_S_EXTERNAL_FI
class sds2hmi_fi_tcl_e8_NavIndexZFDestinationType;
class sds2hmi_fi_tcl_e8_NavLocationNavDataType;
class sds2hmi_fi_tcl_u32_DataSetId;
class sds2hmi_fi_tcl_e8_SideInfo;
class sds2hmi_fi_tcl_e8_NavOneCellDirection;
class sds2hmi_fi_tcl_NavClusterDesc;
class sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty;
class sds2hmi_fi_tcl_NavOneCellDesc;
class sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc;
class sds2hmi_fi_tcl_e8_NavIntersectionType;
class sds2hmi_fi_tcl_NavZeroCellDesc;
class sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty;
class sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc;
class sds2hmi_fi_tcl_NavAreaDescriptionCircle;
class sds2hmi_fi_tcl_NavAreaDescriptionPolygon;
class sds2hmi_fi_tcl_NavLocationDataDesc;
class sds2hmi_fi_tcl_u32_MediaId;
class sds2hmi_fi_tcl_s32_EMU;
class sds2hmi_fi_tcl_e8_NavDataLevel;
class sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty;
class sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet;
class sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc;
class sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet;
class sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet;
class sds2hmi_fi_tcl_NavOneCell;
class sds2hmi_fi_tcl_e8_NavOneCellCategory;
class sds2hmi_fi_tcl_e8_Action;
class sds2hmi_fi_tcl_e8_Application;
class sds2hmi_fi_tcl_e8_PopUp_UpdateType;
class sds2hmi_fi_tcl_e8_PopUp_ListType;
class sds2hmi_fi_tcl_e8_GEN_SelectionType;
class sds2hmi_fi_tcl_e8_PlayAction;
class sds2hmi_fi_tcl_e8_TUN_SelectionType;
class sds2hmi_fi_tcl_e8_TUN_Status;
class sds2hmi_fi_tcl_e8_TUN_Band;
class sds2hmi_fi_tcl_e8_TUN_MemBank;
class sds2hmi_fi_tcl_e8_TUN_Setting;
class sds2hmi_fi_tcl_e8_GLOBAL_Status;
class sds2hmi_fi_tcl_e8_MediaDataType;
class sds2hmi_fi_tcl_e8_SMS_Status;
class sds2hmi_fi_tcl_e8_PHN_Status;
class sds2hmi_fi_tcl_e8_PHN_MenuType;
class sds2hmi_fi_tcl_e8_PHN_Setting;
class sds2hmi_fi_tcl_e8_PHN_ListType;
class sds2hmi_fi_tcl_e8_PHN_NumberType;
class sds2hmi_fi_tcl_e8_PHN_SelectionType;
class sds2hmi_fi_tcl_e8_PHN_Transorder;
class sds2hmi_fi_tcl_e8_NAV_Status;
class sds2hmi_fi_tcl_e8_NAV_MenuType;
class sds2hmi_fi_tcl_e8_NAV_RouteCriteria;
class sds2hmi_fi_tcl_e8_NAV_ZoomLevel;
class sds2hmi_fi_tcl_e8_NAV_ListType;
class sds2hmi_fi_tcl_e8_NAV_NavUnit;
class sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo;
class sds2hmi_fi_tcl_e8_NAV_Setting;
class sds2hmi_fi_tcl_e8_NAV_MapMode;
class sds2hmi_fi_tcl_e8_NAV_AutoZoom;
class sds2hmi_fi_tcl_e8_NAV_MapView;
class sds2hmi_fi_tcl_e8_NAV_MapOrientation;
class sds2hmi_fi_tcl_e8_NAV_TBT_Symbols;
class sds2hmi_fi_tcl_e8_NAV_POIListType;
class sds2hmi_fi_tcl_e8_SET_DisplayMode;
class sds2hmi_fi_tcl_e8_TMCListContent;
class sds2hmi_fi_tcl_b8_PopUp_ResultOptions;
class sds2hmi_fi_tcl_b16_AnsOptions;
class sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting;
class sds2hmi_fi_tcl_e8_UPOI_Source;
class sds2hmi_fi_tcl_e8_Gender;
class sds2hmi_fi_tcl_e8_SDS_Status;
class sds2hmi_fi_tcl_e8_DeviceStatus;
class sds2hmi_fi_tcl_e8_MPL_ListType;
class sds2hmi_fi_tcl_e8_MPL_MenuType;
class sds2hmi_fi_tcl_e8_MPL_SourceType;
class sds2hmi_fi_tcl_e8_MPL_Status;
class sds2hmi_fi_tcl_e8_WEA_MenuType;
class sds2hmi_fi_tcl_e8_WEA_Status;
class sds2hmi_fi_tcl_e8_WEA_Location;
class sds2hmi_fi_tcl_e8_NAV_LocationType;
class sds2hmi_fi_tcl_e8_CON_AmbiguityListType;
class sds2hmi_fi_tcl_e8_CON_EntryType;
class sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold;
class sds2hmi_fi_tcl_e8_ParameterAction;
class sds2hmi_fi_tcl_e8_SDS_ParameterType;
class sds2hmi_fi_tcl_e8_SDSSettings;
class sds2hmi_fi_tcl_e8_SettingsError;
class sds2hmi_fi_tcl_e8_HMI_ListType;
class sds2hmi_fi_tcl_e8_HMI_ListSize;
class sds2hmi_fi_tcl_e8_Info_Menu;
class sds2hmi_fi_tcl_e8_Info_SXM_Services;
class sds2hmi_fi_tcl_e8_SpecialAppId;
class sds2hmi_fi_tcl_e8_SpecialAppStatus;
class sds2hmi_fi_tcl_e8_INFO_TCUType;
class sds2hmi_fi_tcl_e8_TUN_Band_Group;
class sds2hmi_fi_tcl_e8_HMIElementDescriptorMode;
class sds2hmi_fi_tcl_e8_NAV_ZoomAction;
class sds2hmi_fi_tcl_e8_NAV_IconDisplayAction;
class sds2hmi_fi_tcl_e8_SDS_EntryPoint;
class sds2hmi_fi_tcl_e8_MainDomains;
class sds2hmi_fi_tcl_e8_HMIElementReference;
class sds2hmi_fi_tcl_e8_CoreSpeechParameters;
class sds2hmi_fi_tcl_e8_ActionInfoCategory;
class sds2hmi_fi_tcl_e8_PhBook_Update_Action;
class sds2hmi_fi_tcl_e16_PHN_Relationship;
class sds2hmi_fi_tcl_e8_Data_Exchange_Type;
class sds2hmi_fi_tcl_e8_Common_SDS_Evnt;
class sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat;
class sds2hmi_fi_tcl_e8_NDS_SDN_Status;
class sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status;
class sds2hmi_fi_tcl_e8_EventForLogging;
class sds2hmi_fi_tcl_e8_Distance_Unit;
class sds2hmi_fi_tcl_e8_SharedDataAccess;
class sds2hmi_fi_tcl_e8_JournalingMode;
class sds2hmi_fi_tcl_e8_LockType;
class sds2hmi_fi_tcl_e8_NDSDataAccessType;
class sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus;
class sds2hmi_fi_tcl_DestEntry;
class sds2hmi_fi_tcl_PhoneEntry;
class sds2hmi_fi_tcl_ContactData;
class sds2hmi_fi_tcl_TmcEntry;
class sds2hmi_fi_tcl_DeviceStatus;
class sds2hmi_fi_tcl_TunerEntry;
class sds2hmi_fi_tcl_Userword;
class sds2hmi_fi_tcl_LanguageAndSpeaker;
class sds2hmi_fi_tcl_MediaData;
class sds2hmi_fi_tcl_MediaEntry;
class sds2hmi_fi_tcl_DeviceDatabase;
class sds2hmi_fi_tcl_CON_AmbiguityResultEntry;
class sds2hmi_fi_tcl_StringIDPair;
class sds2hmi_fi_tcl_e8_MediaType;
class sds2hmi_fi_tcl_TypedMediaID;
class sds2hmi_fi_tcl_MediaIDString;
class sds2hmi_fi_tcl_SDS_SettingsUnion;
class sds2hmi_fi_tcl_SDS_SettingsRequest;
class sds2hmi_fi_tcl_SDS_Settings;
class sds2hmi_fi_tcl_NeighboringLocation;
class sds2hmi_fi_tcl_SpecialAppAndStatus;
class sds2hmi_fi_tcl_HMIElementDescription;
class sds2hmi_fi_tcl_Nav_IconSetting;
class sds2hmi_fi_tcl_HMIElementDescrptionList;
class sds2hmi_fi_tcl_CoreSpeechParameter;
class sds2hmi_fi_tcl_Action_AdditionalInfo;
class sds2hmi_fi_tcl_RegionMetaData;
class sds2hmi_fi_tcl_MetaData;
class sds2hmi_fi_tcl_BuildingBlock;
class sds2hmi_fi_tcl_UpdateRegion;
class sds2hmi_fi_tcl_SDSProduct;
class sds2hmi_fi_tcl_NDSLocationDetails;
class sds2hmi_fi_tcl_Info_Menu_Srvice_Status;
class sds2hmi_fi_tcl_RecResult;
class sds2hmi_fi_tcl_ConfThresholdSet;
class sds2hmi_fi_tcl_DestinationAndLanguageDetails;
class sds2hmi_fi_tcl_SharedDataAccessAttributes;
class sds2hmi_fi_tcl_DestinationElement;
class sds2hmi_fi_tcl_DestinationItem;
class sds2hmi_fi_tcl_ValidatedDestinationDetails;
class sds2hmi_fi_tcl_e8_BinContainerTypes : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_BinContainerTypes();

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVUTMBINCONTAINER = 1UL,
      FI_EN_T_NAVLOCATIONBINCONTAINER = 2UL,
      FI_EN_T_TMCODEDMESSAGEBINCONTAINER = 3UL,
      FI_EN_T_NAVROUTELISTBINCONTAINER = 4UL,
      FI_EN_T_TMMAPBINCONTAINER = 5UL,
      FI_EN_T_MAPROUTEBINCONTAINER = 6UL,
      FI_EN_T_GRAPHICALWEATHERSHAPEBINCONTAINER = 7UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_BinContainerTypes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_BinContainerTypes& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_BinContainer : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_BinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_BinContainer& operator=(const sds2hmi_fi_tcl_BinContainer& coRef);
   sds2hmi_fi_tcl_BinContainer(const sds2hmi_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;
   virtual ~sds2hmi_fi_tcl_BinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_BinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_Reserved : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_Reserved();

   virtual ~sds2hmi_fi_tcl_Reserved();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_Reserved& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u8_Percent : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u8_Percent(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~sds2hmi_fi_tcl_u8_Percent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u8_Percent& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_PerThousand : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_PerThousand(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_PerThousand();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_PerThousand& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u16_IndexInReferenceList : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~sds2hmi_fi_tcl_u16_IndexInReferenceList();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u16_IndexInReferenceList& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u16_ErrorCode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~sds2hmi_fi_tcl_u16_ErrorCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u16_ErrorCode& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u16_RPM : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u16_RPM(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~sds2hmi_fi_tcl_u16_RPM();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u16_RPM& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Kilogram : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Kilogram(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Kilogram();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Kilogram& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Pound : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Pound(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Pound();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Pound& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_Meter : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_Meter(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_Meter& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Meter : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Meter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Meter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Meter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Yards : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Yards(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Yards();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Yards& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Foot : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Foot(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Foot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Foot& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Centimeter : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Centimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Centimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Centimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Inch : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Inch(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Inch();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Inch& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Millimeter : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Millimeter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Millimeter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Millimeter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Microliter : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Microliter(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Microliter();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Microliter& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Second : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Second(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Second();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Second& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u16_MilliSecond : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~sds2hmi_fi_tcl_u16_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u16_MilliSecond& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_MilliSecond : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_MilliSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_MilliSecond& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_POSIXTime : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_POSIXTime();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_POSIXTime& operator=(const sds2hmi_fi_tcl_POSIXTime& coRef);
   sds2hmi_fi_tcl_POSIXTime(const sds2hmi_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;
   virtual ~sds2hmi_fi_tcl_POSIXTime();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_POSIXTime& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_DST_State : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_DST_State();

   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_DST_State();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_DST_State& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_TimeZoneElement : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_TimeZoneElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_TimeZoneElement& operator=(const sds2hmi_fi_tcl_TimeZoneElement& coRef);
   sds2hmi_fi_tcl_TimeZoneElement(const sds2hmi_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclMultiLanguageString Abbreviation_StandardTime;
   sds2hmi_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   sds2hmi_fi_tcl_s32_Second TimeZoneDifference;
   sds2hmi_fi_tcl_e8_DST_State DST_State;
   sds2hmi_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;
   virtual ~sds2hmi_fi_tcl_TimeZoneElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_TimeZoneElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_KmPerHour : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_KmPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_KmPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_MilesPerHour : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_MilesPerHour();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_MilesPerHour& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_Knot : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_Knot(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_Knot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_Knot& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_CentimeterSecond : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_CentimeterSecond(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_CentimeterSecond();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_CentimeterSecond& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_Kelvin : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_Kelvin(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_Kelvin();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_Kelvin& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_Fahrenheit : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_Fahrenheit(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_Fahrenheit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_Fahrenheit& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Pascal : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Pascal(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Pascal();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Pascal& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Watt : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Watt(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Watt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Watt& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_FIVersion : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_FIVersion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_FIVersion& operator=(const sds2hmi_fi_tcl_FIVersion& coRef);
   sds2hmi_fi_tcl_FIVersion(const sds2hmi_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;
   virtual ~sds2hmi_fi_tcl_FIVersion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_FIVersion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Longitude : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Longitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Longitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Longitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_Latitude : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_Latitude(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_Latitude();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_Latitude& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_PositionWGS84 : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_PositionWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_PositionWGS84& operator=(const sds2hmi_fi_tcl_PositionWGS84& coRef);
   sds2hmi_fi_tcl_PositionWGS84(const sds2hmi_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_s32_Longitude Longitude;
   sds2hmi_fi_tcl_s32_Latitude Latitude;
   virtual ~sds2hmi_fi_tcl_PositionWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_PositionWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_RectangleWGS84 : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_RectangleWGS84();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_RectangleWGS84& operator=(const sds2hmi_fi_tcl_RectangleWGS84& coRef);
   sds2hmi_fi_tcl_RectangleWGS84(const sds2hmi_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_s32_Longitude LongitudeMin;
   sds2hmi_fi_tcl_s32_Latitude LatitudeMin;
   sds2hmi_fi_tcl_s32_Longitude LongitudeMax;
   sds2hmi_fi_tcl_s32_Latitude LatitudeMax;
   virtual ~sds2hmi_fi_tcl_RectangleWGS84();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_RectangleWGS84& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e16_ISOCountryCode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e16_ISOCountryCode();

   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e16_ISOCountryCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e16_ISOCountryCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e16_ISOLanguageCode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e16_ISOLanguageCode();

   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BL = 25196UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_BT = 25204UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CF = 25446UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CL = 25452UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CT = 25460UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EG = 25959UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MC = 28003UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RT = 29300UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SB = 29538UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_SX = 29560UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UL = 30060UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VA = 30305UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZL = 31340UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e16_ISOLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e16_ISOLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_LanguageID : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_LanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_LanguageID& operator=(const sds2hmi_fi_tcl_LanguageID& coRef);
   sds2hmi_fi_tcl_LanguageID(const sds2hmi_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   sds2hmi_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~sds2hmi_fi_tcl_LanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_LanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u8_DirectionAbsolute : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~sds2hmi_fi_tcl_u8_DirectionAbsolute();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u8_DirectionAbsolute& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u8_DirectionRelative : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0);

   tU8 u8Value;
   virtual ~sds2hmi_fi_tcl_u8_DirectionRelative();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u8_DirectionRelative& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_CentiDegree : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_Degree : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_Degree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_Degree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_Degree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0);

   tU16 u16Value;
   virtual ~sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u16_DirectionAbsolute_CentiDegree& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0);

   tS16 s16Value;
   virtual ~sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s16_DirectionRelative_CentiDegree& roRef) const
      {  return (s16Value == roRef.s16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_FuelType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_FuelType();

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_FuelType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_FuelType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_DistTimeFuel : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_DistTimeFuel();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_DistTimeFuel& operator=(const sds2hmi_fi_tcl_DistTimeFuel& coRef);
   sds2hmi_fi_tcl_DistTimeFuel(const sds2hmi_fi_tcl_DistTimeFuel& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_s32_Meter Distance;
   sds2hmi_fi_tcl_s32_Second Time;
   sds2hmi_fi_tcl_s32_Microliter Fuel;
   virtual ~sds2hmi_fi_tcl_DistTimeFuel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_DistTimeFuel& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode();

   enum tenType {
      FI_EN_ISO_639_3_INVALID = 0UL,
      FI_EN_ISO_639_3_AAR = 1074UL,
      FI_EN_ISO_639_3_ABK = 1099UL,
      FI_EN_ISO_639_3_AVE = 1733UL,
      FI_EN_ISO_639_3_AFR = 1234UL,
      FI_EN_ISO_639_3_AKA = 1377UL,
      FI_EN_ISO_639_3_AMH = 1448UL,
      FI_EN_ISO_639_3_ARG = 1607UL,
      FI_EN_ISO_639_3_ARA = 1601UL,
      FI_EN_ISO_639_3_ASM = 1645UL,
      FI_EN_ISO_639_3_AVA = 1729UL,
      FI_EN_ISO_639_3_AYM = 1837UL,
      FI_EN_ISO_639_3_AZE = 1861UL,
      FI_EN_ISO_639_3_BAK = 2091UL,
      FI_EN_ISO_639_3_BEL = 2220UL,
      FI_EN_ISO_639_3_BUL = 2732UL,
      FI_EN_ISO_639_3_BIS = 2355UL,
      FI_EN_ISO_639_3_BAM = 2093UL,
      FI_EN_ISO_639_3_BEN = 2222UL,
      FI_EN_ISO_639_3_BOD = 2532UL,
      FI_EN_ISO_639_3_BRE = 2629UL,
      FI_EN_ISO_639_3_BOS = 2547UL,
      FI_EN_ISO_639_3_CAT = 3124UL,
      FI_EN_ISO_639_3_CHE = 3333UL,
      FI_EN_ISO_639_3_CHA = 3329UL,
      FI_EN_ISO_639_3_COS = 3571UL,
      FI_EN_ISO_639_3_CRE = 3653UL,
      FI_EN_ISO_639_3_CES = 3251UL,
      FI_EN_ISO_639_3_CHU = 334UL,
      FI_EN_ISO_639_3_CHV = 3350UL,
      FI_EN_ISO_639_3_CMN = 3502UL,
      FI_EN_ISO_639_3_CYM = 3885UL,
      FI_EN_ISO_639_3_DAN = 4142UL,
      FI_EN_ISO_639_3_DEU = 4277UL,
      FI_EN_ISO_639_3_DIV = 4406UL,
      FI_EN_ISO_639_3_DZO = 4943UL,
      FI_EN_ISO_639_3_EWE = 5861UL,
      FI_EN_ISO_639_3_ELL = 5516UL,
      FI_EN_ISO_639_3_ENG = 5575UL,
      FI_EN_ISO_639_3_EPO = 5647UL,
      FI_EN_ISO_639_3_SPA = 19969UL,
      FI_EN_ISO_639_3_EST = 5748UL,
      FI_EN_ISO_639_3_EUS = 5811UL,
      FI_EN_ISO_639_3_FAS = 6195UL,
      FI_EN_ISO_639_3_FUL = 6828UL,
      FI_EN_ISO_639_3_FIN = 6446UL,
      FI_EN_ISO_639_3_FIJ = 6442UL,
      FI_EN_ISO_639_3_FAO = 6191UL,
      FI_EN_ISO_639_3_FRA = 6721UL,
      FI_EN_ISO_639_3_FRY = 6745UL,
      FI_EN_ISO_639_3_GLE = 7557UL,
      FI_EN_ISO_639_3_GLA = 7553UL,
      FI_EN_ISO_639_3_GLG = 7559UL,
      FI_EN_ISO_639_3_GRN = 7758UL,
      FI_EN_ISO_639_3_GUJ = 7850UL,
      FI_EN_ISO_639_3_GLV = 7574UL,
      FI_EN_ISO_639_3_HAU = 8245UL,
      FI_EN_ISO_639_3_HEB = 8354UL,
      FI_EN_ISO_639_3_HIN = 8494UL,
      FI_EN_ISO_639_3_HMO = 8623UL,
      FI_EN_ISO_639_3_HRV = 8790UL,
      FI_EN_ISO_639_3_HUN = 8878UL,
      FI_EN_ISO_639_3_HYE = 8997UL,
      FI_EN_ISO_639_3_HER = 8370UL,
      FI_EN_ISO_639_3_INA = 9665UL,
      FI_EN_ISO_639_3_IND = 9668UL,
      FI_EN_ISO_639_3_ILE = 9605UL,
      FI_EN_ISO_639_3_IBO = 9295UL,
      FI_EN_ISO_639_3_III = 9513UL,
      FI_EN_ISO_639_3_IDO = 9359UL,
      FI_EN_ISO_639_3_ISL = 9836UL,
      FI_EN_ISO_639_3_ITA = 9857UL,
      FI_EN_ISO_639_3_IKU = 9589UL,
      FI_EN_ISO_639_3_JPN = 10766UL,
      FI_EN_ISO_639_3_JAV = 10294UL,
      FI_EN_ISO_639_3_KAT = 11316UL,
      FI_EN_ISO_639_3_KON = 11758UL,
      FI_EN_ISO_639_3_KIK = 11563UL,
      FI_EN_ISO_639_3_KUA = 11937UL,
      FI_EN_ISO_639_3_KAZ = 11322UL,
      FI_EN_ISO_639_3_KAL = 11308UL,
      FI_EN_ISO_639_3_KHM = 11533UL,
      FI_EN_ISO_639_3_KAN = 11310UL,
      FI_EN_ISO_639_3_KOR = 11762UL,
      FI_EN_ISO_639_3_KAU = 11317UL,
      FI_EN_ISO_639_3_KAS = 11315UL,
      FI_EN_ISO_639_3_KUR = 11954UL,
      FI_EN_ISO_639_3_KOM = 11757UL,
      FI_EN_ISO_639_3_COR = 3570UL,
      FI_EN_ISO_639_3_KIR = 11570UL,
      FI_EN_ISO_639_3_LAT = 12340UL,
      FI_EN_ISO_639_3_LTZ = 12954UL,
      FI_EN_ISO_639_3_LUG = 12967UL,
      FI_EN_ISO_639_3_LIM = 12589UL,
      FI_EN_ISO_639_3_LIN = 12590UL,
      FI_EN_ISO_639_3_LAO = 12335UL,
      FI_EN_ISO_639_3_LIT = 12596UL,
      FI_EN_ISO_639_3_LUB = 12962UL,
      FI_EN_ISO_639_3_LAV = 12342UL,
      FI_EN_ISO_639_3_MLG = 13703UL,
      FI_EN_ISO_639_3_MAH = 13352UL,
      FI_EN_ISO_639_3_MRI = 13897UL,
      FI_EN_ISO_639_3_MKD = 13668UL,
      FI_EN_ISO_639_3_MAL = 13356UL,
      FI_EN_ISO_639_3_MON = 13806UL,
      FI_EN_ISO_639_3_MAR = 13362UL,
      FI_EN_ISO_639_3_MSA = 13921UL,
      FI_EN_ISO_639_3_MLT = 13716UL,
      FI_EN_ISO_639_3_MYA = 14113UL,
      FI_EN_ISO_639_3_NAU = 14389UL,
      FI_EN_ISO_639_3_NOB = 14818UL,
      FI_EN_ISO_639_3_NDE = 14469UL,
      FI_EN_ISO_639_3_NEP = 14512UL,
      FI_EN_ISO_639_3_NDO = 14479UL,
      FI_EN_ISO_639_3_NLD = 14724UL,
      FI_EN_ISO_639_3_NNO = 14799UL,
      FI_EN_ISO_639_3_NOR = 14834UL,
      FI_EN_ISO_639_3_NBL = 14412UL,
      FI_EN_ISO_639_3_NAV = 14390UL,
      FI_EN_ISO_639_3_NYA = 15137UL,
      FI_EN_ISO_639_3_OCI = 15465UL,
      FI_EN_ISO_639_3_OJI = 15689UL,
      FI_EN_ISO_639_3_ORM = 15949UL,
      FI_EN_ISO_639_3_ORI = 15945UL,
      FI_EN_ISO_639_3_OSS = 15987UL,
      FI_EN_ISO_639_3_PAN = 16430UL,
      FI_EN_ISO_639_3_PLI = 16777UL,
      FI_EN_ISO_639_3_POL = 16876UL,
      FI_EN_ISO_639_3_PUS = 17075UL,
      FI_EN_ISO_639_3_POR = 16882UL,
      FI_EN_ISO_639_3_QUE = 18085UL,
      FI_EN_ISO_639_3_ROH = 18920UL,
      FI_EN_ISO_639_3_RUN = 19118UL,
      FI_EN_ISO_639_3_RON = 18926UL,
      FI_EN_ISO_639_3_RUS = 19123UL,
      FI_EN_ISO_639_3_KIN = 11566UL,
      FI_EN_ISO_639_3_SAN = 19502UL,
      FI_EN_ISO_639_3_SRD = 20036UL,
      FI_EN_ISO_639_3_SND = 19908UL,
      FI_EN_ISO_639_3_SME = 19877UL,
      FI_EN_ISO_639_3_SAG = 19495UL,
      FI_EN_ISO_639_3_HBS = 8275UL,
      FI_EN_ISO_639_3_SIN = 19758UL,
      FI_EN_ISO_639_3_SLK = 19851UL,
      FI_EN_ISO_639_3_SLV = 19862UL,
      FI_EN_ISO_639_3_SMO = 19887UL,
      FI_EN_ISO_639_3_SNA = 19905UL,
      FI_EN_ISO_639_3_SOM = 19949UL,
      FI_EN_ISO_639_3_SQI = 20009UL,
      FI_EN_ISO_639_3_SRP = 20048UL,
      FI_EN_ISO_639_3_SSW = 20087UL,
      FI_EN_ISO_639_3_SOT = 19956UL,
      FI_EN_ISO_639_3_SUN = 20142UL,
      FI_EN_ISO_639_3_SWE = 20197UL,
      FI_EN_ISO_639_3_SWA = 20193UL,
      FI_EN_ISO_639_3_TAM = 20525UL,
      FI_EN_ISO_639_3_TEL = 20652UL,
      FI_EN_ISO_639_3_TGK = 20715UL,
      FI_EN_ISO_639_3_THA = 20737UL,
      FI_EN_ISO_639_3_TIR = 20786UL,
      FI_EN_ISO_639_3_TUK = 21163UL,
      FI_EN_ISO_639_3_TGL = 20716UL,
      FI_EN_ISO_639_3_TSN = 21102UL,
      FI_EN_ISO_639_3_TON = 20974UL,
      FI_EN_ISO_639_3_TUR = 21170UL,
      FI_EN_ISO_639_3_TSO = 21103UL,
      FI_EN_ISO_639_3_TAT = 20532UL,
      FI_EN_ISO_639_3_TWI = 21225UL,
      FI_EN_ISO_639_3_TAH = 20520UL,
      FI_EN_ISO_639_3_UIG = 21799UL,
      FI_EN_ISO_639_3_UKR = 21874UL,
      FI_EN_ISO_639_3_URD = 22084UL,
      FI_EN_ISO_639_3_UZB = 22338UL,
      FI_EN_ISO_639_3_VEN = 22702UL,
      FI_EN_ISO_639_3_VIE = 22821UL,
      FI_EN_ISO_639_3_VOL = 23020UL,
      FI_EN_ISO_639_3_WLN = 23950UL,
      FI_EN_ISO_639_3_WOL = 24044UL,
      FI_EN_ISO_639_3_XHO = 24847UL,
      FI_EN_ISO_639_3_YID = 25892UL,
      FI_EN_ISO_639_3_YOR = 26098UL,
      FI_EN_ISO_639_3_YUE = 26277UL,
      FI_EN_ISO_639_3_ZHA = 26881UL,
      FI_EN_ISO_639_3_ZUL = 27308UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Slot : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Slot();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SONG = 1UL,
      FI_EN_ARTIST = 2UL,
      FI_EN_ALBUM = 3UL,
      FI_EN_GENRE = 4UL,
      FI_EN_PLAYLIST = 5UL,
      FI_EN_PODCAST = 6UL,
      FI_EN_EPISODE = 7UL,
      FI_EN_AUDIOBOOKNAME = 8UL,
      FI_EN_CHAPTERNAME = 9UL,
      FI_EN_AUTHORNAME = 10UL,
      FI_EN_VIDEONAME = 11UL,
      FI_EN_AMHDSHORTNAME = 12UL,
      FI_EN_FMHDSHORTNAME = 13UL,
      FI_EN_XMCHANNELNAME = 14UL,
      FI_EN_PHONENAME = 15UL,
      FI_EN_DEVICENAME = 16UL,
      FI_EN_CONTACTNAME = 17UL,
      FI_EN_DABCHANNELNAME = 18UL,
      FI_EN_APPNAMES = 19UL,
      FI_EN_SPORTSNAMES = 20UL,
      FI_EN_RDSSTATIONNAME = 21UL,
      FI_EN_SONGBYARTIST = 22UL,
      FI_EN_ALBUMBYARTIST = 23UL,
      FI_EN_DRM_STATIONNAME = 24UL,
      FI_EN_TV_STATIONNAME = 25UL,
      FI_EN_COUNTRYNAME = 26UL,
      FI_EN_STATENAME = 27UL,
      FI_EN_PLAINTEXT = 28UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Slot();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Slot& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Domain : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Domain();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_MEDIA = 1UL,
      FI_EN_PHONE = 2UL,
      FI_EN_TUNER = 3UL,
      FI_EN_MEDIA_GLOBAL = 4UL,
      FI_EN_PHONE_GLOBAL = 5UL,
      FI_EN_VDL = 6UL,
      FI_EN_NAVIGATION = 7UL,
      FI_EN_TTS_REQUEST = 8UL,
      FI_EN_WAKEUP_WORD = 9UL,
      FI_EN_VOICE_WAKEUP_WORD = 10UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Domain();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Domain& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus();

   enum tenType {
      FI_EN_DEVICEUNAVAILABLE = 0UL,
      FI_EN_DEVICEAVAILABLEUPDATERUNNING = 1UL,
      FI_EN_DEVICEUNVAILABLEUPDATERUNNING = 2UL,
      FI_EN_DEVICEAVAILABLEUPTODATE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PromptSetting : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PromptSetting();

   enum tenType {
      FI_EN_SHORT = 0UL,
      FI_EN_LONG = 1UL,
      FI_EN_NONE = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PromptSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PromptSetting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_WordType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_WordType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SONG = 1UL,
      FI_EN_ARTIST = 2UL,
      FI_EN_ALBUM = 3UL,
      FI_EN_GENRE = 4UL,
      FI_EN_PLAYLIST = 5UL,
      FI_EN_PODCAST = 6UL,
      FI_EN_EPISODE = 7UL,
      FI_EN_AUDIOBOOKNAME = 8UL,
      FI_EN_CHAPTERNAME = 9UL,
      FI_EN_AUTHORNAME = 10UL,
      FI_EN_VIDEONAME = 11UL,
      FI_EN_AMHDSHORTNAME = 12UL,
      FI_EN_FMHDSHORTNAME = 13UL,
      FI_EN_XMCHANNELNAME = 14UL,
      FI_EN_PHONENAME = 15UL,
      FI_EN_DEVICENAME = 16UL,
      FI_EN_CONTACTNAME = 17UL,
      FI_EN_DABCHANNELNAME = 18UL,
      FI_EN_APPLICATION = 19UL,
      FI_EN_SPORTSNAMES = 20UL,
      FI_EN_RDSSTATIONNAME = 21UL,
      FI_EN_SONGBYARTIST = 22UL,
      FI_EN_ALBUMBYARTIST = 23UL,
      FI_EN_HOUSENUM = 24UL,
      FI_EN_STREET = 25UL,
      FI_EN_CITY = 26UL,
      FI_EN_STATE = 27UL,
      FI_EN_COUNTRY = 28UL,
      FI_EN_POINAME = 29UL,
      FI_EN_POIBRAND = 30UL,
      FI_EN_POICATEGORY = 31UL,
      FI_EN_FREQUENCY = 32UL,
      FI_EN_PROMPTID = 33UL,
      FI_EN_PHONENUMBER = 34UL,
      FI_EN_STREET2 = 35UL,
      FI_EN_PLAIN_TEXT = 36UL,
      FI_EN_TV_STATION_NAME = 37UL,
      FI_EN_OAZA = 38UL,
      FI_EN_AZA = 39UL,
      FI_EN_GENERIC_NUMBER = 40UL,
      FI_EN_DISTANCE_UNIT = 41UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_WordType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_WordType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NDSFeatureType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NDSFeatureType();

   enum tenType {
      FI_EN_NAMEOBJECT = 0UL,
      FI_EN_POINAME = 1UL,
      FI_EN_POI_CATEGORY = 2UL,
      FI_EN_POI_ATTRIBUTE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NDSFeatureType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NDSFeatureType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e32_SSE_ASR_Mode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e32_SSE_ASR_Mode();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SSEAUDIOONLY = 1UL,
      FI_EN_SSESPEECHPROBATTACHED = 2UL,
      FI_EN_SSESPEECHPROBLSB = 3UL,
      FI_EN_SSESPEECHPROBATTACHEDLEGACY = 4UL,
      FI_EN_SSESPEECHPROBLSBLEGACY = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e32_SSE_ASR_Mode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e32_SSE_ASR_Mode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SDSDestinationType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SDSDestinationType();

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_COUNTRY = 1UL,
      FI_EN_STATE = 2UL,
      FI_EN_CITY = 3UL,
      FI_EN_STREET = 4UL,
      FI_EN_POICATEGORY = 5UL,
      FI_EN_POIBRANDNAME = 6UL,
      FI_EN_POICORE = 7UL,
      FI_EN_HOUSENO = 8UL,
      FI_EN_OAZA = 9UL,
      FI_EN_AZA = 10UL,
      FI_EN_INVALID = 11UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SDSDestinationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SDSDestinationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SDSLanguageID : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SDSLanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SDSLanguageID& operator=(const sds2hmi_fi_tcl_SDSLanguageID& coRef);
   sds2hmi_fi_tcl_SDSLanguageID(const sds2hmi_fi_tcl_SDSLanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode ISO639_3_SDSLanguageCode;
   sds2hmi_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;
   virtual ~sds2hmi_fi_tcl_SDSLanguageID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SDSLanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_ConnectedDeviceStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_ConnectedDeviceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_ConnectedDeviceStatus& operator=(const sds2hmi_fi_tcl_ConnectedDeviceStatus& coRef);
   sds2hmi_fi_tcl_ConnectedDeviceStatus(const sds2hmi_fi_tcl_ConnectedDeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceId;
   sds2hmi_fi_tcl_e8_Domain tenDomain;
   sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus UpdateStatus;
   virtual ~sds2hmi_fi_tcl_ConnectedDeviceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_ConnectedDeviceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NDSLanguageID : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NDSLanguageID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NDSLanguageID& operator=(const sds2hmi_fi_tcl_NDSLanguageID& coRef);
   sds2hmi_fi_tcl_NDSLanguageID(const sds2hmi_fi_tcl_NDSLanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 LanguageCode;
   sds2hmi_fi_tclString ISO_CountryCode;
   sds2hmi_fi_tclString ISO_LanguageCode;
   sds2hmi_fi_tclString ScriptCode;
   virtual ~sds2hmi_fi_tcl_NDSLanguageID();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NDSLanguageID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NDSID : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NDSID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NDSID& operator=(const sds2hmi_fi_tcl_NDSID& coRef);
   sds2hmi_fi_tcl_NDSID(const sds2hmi_fi_tcl_NDSID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UpdateRegionId;
   tU32 u32ProductId;
   tU8 u8SupplierId;
   tU32 u32NDSId;
   sds2hmi_fi_tcl_e8_NDSFeatureType eNDSFeatureType;
   tU64 POIRootRegionID;
   tU32 GlobalXRefId;
   virtual ~sds2hmi_fi_tcl_NDSID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NDSID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StreetAvailability : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StreetAvailability();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StreetAvailability& operator=(const sds2hmi_fi_tcl_StreetAvailability& coRef);
   sds2hmi_fi_tcl_StreetAvailability(const sds2hmi_fi_tcl_StreetAvailability& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSID City_Id;
   tBool Availability;
   virtual ~sds2hmi_fi_tcl_StreetAvailability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StreetAvailability& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_PhonemeForLanguage : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_PhonemeForLanguage();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_PhonemeForLanguage& operator=(const sds2hmi_fi_tcl_PhonemeForLanguage& coRef);
   sds2hmi_fi_tcl_PhonemeForLanguage(const sds2hmi_fi_tcl_PhonemeForLanguage& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSLanguageID Language;
   sds2hmi_fi_tclString Phoneme;
   virtual ~sds2hmi_fi_tcl_PhonemeForLanguage();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_PhonemeForLanguage& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringAndPhoneme : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringAndPhoneme();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringAndPhoneme& operator=(const sds2hmi_fi_tcl_StringAndPhoneme& coRef);
   sds2hmi_fi_tcl_StringAndPhoneme(const sds2hmi_fi_tcl_StringAndPhoneme& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSID NDSId;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > OrthographyList;
   std::vector<sds2hmi_fi_tcl_PhonemeForLanguage, std::allocator<sds2hmi_fi_tcl_PhonemeForLanguage> > PhonemeAndLanguageList;
   sds2hmi_fi_tcl_e8_SDSDestinationType DestItemtype;
   virtual ~sds2hmi_fi_tcl_StringAndPhoneme();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringAndPhoneme& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StatePhoneme : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StatePhoneme();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StatePhoneme& operator=(const sds2hmi_fi_tcl_StatePhoneme& coRef);
   sds2hmi_fi_tcl_StatePhoneme(const sds2hmi_fi_tcl_StatePhoneme& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSID StateId;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > PhonemeList;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > OrthographyList;
   virtual ~sds2hmi_fi_tcl_StatePhoneme();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StatePhoneme& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_CountryPhoneme : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_CountryPhoneme();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_CountryPhoneme& operator=(const sds2hmi_fi_tcl_CountryPhoneme& coRef);
   sds2hmi_fi_tcl_CountryPhoneme(const sds2hmi_fi_tcl_CountryPhoneme& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSID CountryId;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > PhonemeList;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > OrthographyList;
   std::vector<sds2hmi_fi_tcl_StatePhoneme, std::allocator<sds2hmi_fi_tcl_StatePhoneme> > StateList;
   sds2hmi_fi_tcl_e16_ISOCountryCode CountryCode;
   virtual ~sds2hmi_fi_tcl_CountryPhoneme();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_CountryPhoneme& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_CityId : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_CityId();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_CityId& operator=(const sds2hmi_fi_tcl_CityId& coRef);
   sds2hmi_fi_tcl_CityId(const sds2hmi_fi_tcl_CityId& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSID City_ID_;
   virtual ~sds2hmi_fi_tcl_CityId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_CityId& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_ECNR_ASR_Mode_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_ECNR_ASR_Mode_Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& operator=(const sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& coRef);
   sds2hmi_fi_tcl_ECNR_ASR_Mode_Status(const sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Mode_Enable;
   sds2hmi_fi_tcl_e32_SSE_ASR_Mode Mode_Status;
   virtual ~sds2hmi_fi_tcl_ECNR_ASR_Mode_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_ECNR_ASR_Mode_Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e16_SelectionCriterionType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e16_SelectionCriterionType();

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_COUNTRY = 1UL,
      FI_EN_TOWN = 2UL,
      FI_EN_STREET = 3UL,
      FI_EN_JUNCTION = 4UL,
      FI_EN_HOUSENUMBER = 5UL,
      FI_EN_ZIPCODE = 6UL,
      FI_EN_BUILDING = 7UL,
      FI_EN_TELEPHONENUMBER = 8UL,
      FI_EN_PROVINCE = 9UL,
      FI_EN_DISTRICT = 10UL,
      FI_EN_POI = 11UL,
      FI_EN_ALLPOIS = 12UL,
      FI_EN_MAJORCITY = 13UL,
      FI_EN_NATIONALSUPRAREGIONALPOI = 14UL,
      FI_EN_INTERNATIONALSUPRAREGIONALPOI = 15UL,
      FI_EN_TOWNCENTER = 16UL,
      FI_EN_ATTORNEY = 17UL,
      FI_EN_BORDERCROSSING = 18UL,
      FI_EN_CITYHALL = 19UL,
      FI_EN_COURTHOUSE = 20UL,
      FI_EN_EMBASSY = 21UL,
      FI_EN_FERRYTERMINALORFERRYLINK = 22UL,
      FI_EN_GOVERMENTOFFICE = 23UL,
      FI_EN_HOSPITAL = 24UL,
      FI_EN_LANDMARK = 25UL,
      FI_EN_LIBRARY = 26UL,
      FI_EN_MOTORWAYBRANCH = 27UL,
      FI_EN_MOTORWAYEXIT = 28UL,
      FI_EN_MOTORWAYSERVICE = 29UL,
      FI_EN_PARKING = 30UL,
      FI_EN_POLICESTATION = 31UL,
      FI_EN_POSTOFFICE = 32UL,
      FI_EN_PUBLICBUILDING = 33UL,
      FI_EN_RAILWAYSTATIONORRAILWAY = 34UL,
      FI_EN_SCENICVIEW = 35UL,
      FI_EN_SCHOOL = 36UL,
      FI_EN_THEATER = 37UL,
      FI_EN_UNIVERSITYCOLLEGE = 38UL,
      FI_EN_TOLLBOOTH = 39UL,
      FI_EN_COMMUTERRAILSTATION = 40UL,
      FI_EN_MONORAILSTATION = 41UL,
      FI_EN_MAGLEVSTATION = 42UL,
      FI_EN_COACHSTATION = 43UL,
      FI_EN_OTHERTRAFFICFACILITIES = 44UL,
      FI_EN_RESIDENTIALAREA = 45UL,
      FI_EN_PRIMARYSCHOOL = 46UL,
      FI_EN_MIDDLESCHOOL = 47UL,
      FI_EN_HIGHSCHOOL = 48UL,
      FI_EN_TECHNICALSECONDARYSCHOOL = 49UL,
      FI_EN_SPECIALIZEDSCHOOL = 50UL,
      FI_EN_EDUCATIONOTHERS = 51UL,
      FI_EN_PROVINCIALREPRESENTATION = 52UL,
      FI_EN_MUNICIPALREPRESENTATION = 53UL,
      FI_EN_INTERIORREPRESENTATIONOTHER = 54UL,
      FI_EN_CONSULATE = 55UL,
      FI_EN_FOREIGNREPRESENTATIONOTHER = 56UL,
      FI_EN_FIREPOLICE = 57UL,
      FI_EN_LOGISTICS = 58UL,
      FI_EN_URBANNAME = 59UL,
      FI_EN_CITYDISTRICT = 60UL,
      FI_EN_POSTALDISTRICT = 61UL,
      FI_EN_MOTORWAYENTRANCE = 62UL,
      FI_EN_POBOXES = 63UL,
      FI_EN_PLAZA = 64UL,
      FI_EN_OTHERSCHOOL = 65UL,
      FI_EN_ELEMENTARYSCHOOL = 66UL,
      FI_EN_USER_POIS = 117UL,
      FI_EN_OSDE_ADDRESSES = 118UL,
      FI_EN_OSDE_POI = 119UL,
      FI_EN_CWS_ALLPOIS = 120UL,
      FI_EN_NAVIGATIONINTERNALDATA = 121UL,
      FI_EN_ROADDISTANCE = 122UL,
      FI_EN_AIRDISTANCE = 123UL,
      FI_EN_GEOGRAPHICALPOSITION = 124UL,
      FI_EN_COMMENT = 125UL,
      FI_EN_REFINEBYINCLUSION = 126UL,
      FI_EN_REFINEBYASSOCIATION = 127UL,
      FI_EN_DATASET = 128UL,
      FI_EN_ADDRESS = 129UL,
      FI_EN_HOUSENUMBERPATTERN = 130UL,
      FI_EN_INTERMEDIATEDESTINATION = 192UL,
      FI_EN_FINALDESTINATION = 193UL,
      FI_EN_LANDCOVER = 194UL,
      FI_EN_SURFACECOVER = 195UL,
      FI_EN_WATER = 197UL,
      FI_EN_ROUTE = 198UL,
      FI_EN_SPECIALCONTENT = 199UL,
      FI_EN_AIRLINEACCESS = 200UL,
      FI_EN_AIRPORT = 201UL,
      FI_EN_AMUSEMENTPARK = 202UL,
      FI_EN_AUTOMATICTELLERMACHINE = 203UL,
      FI_EN_BANK = 204UL,
      FI_EN_BEACH = 205UL,
      FI_EN_BOWLINGCENTRE = 206UL,
      FI_EN_BUSINESSFACILITY = 207UL,
      FI_EN_BUSSTATION = 208UL,
      FI_EN_CAFE = 209UL,
      FI_EN_CAKEANDPASTRYSHOP = 210UL,
      FI_EN_CASINO = 211UL,
      FI_EN_CHURCH = 212UL,
      FI_EN_CINEMA = 213UL,
      FI_EN_DENTIST = 214UL,
      FI_EN_DRIVETHROUGHBOTTLESHOP = 215UL,
      FI_EN_DRYCLEANERS = 216UL,
      FI_EN_ENTERTAINMENT = 217UL,
      FI_EN_EXHIBITION = 218UL,
      FI_EN_FACTORY = 219UL,
      FI_EN_GARAGE = 220UL,
      FI_EN_GASSTATION = 221UL,
      FI_EN_GOLFCOURSE = 222UL,
      FI_EN_GROCERYSTORE = 223UL,
      FI_EN_HISTORICALMONUMENT = 224UL,
      FI_EN_HOTEL_MOTEL = 225UL,
      FI_EN_ICESKATINGPARK = 226UL,
      FI_EN_MARINA = 227UL,
      FI_EN_MOSQUE = 228UL,
      FI_EN_MOTORCYCLEDEALER = 229UL,
      FI_EN_MOTORINGORGANISATION = 230UL,
      FI_EN_MOUNTAINPASS = 231UL,
      FI_EN_MOUNTAINPEAK = 232UL,
      FI_EN_MUSEUM = 233UL,
      FI_EN_NATURERESERVE = 234UL,
      FI_EN_NIGHTLIFE = 235UL,
      FI_EN_PHYSICIAN = 236UL,
      FI_EN_PLACEOFWORSHIP = 237UL,
      FI_EN_PRACTITIONER = 238UL,
      FI_EN_REALTOR = 239UL,
      FI_EN_RECREATIONAREA = 240UL,
      FI_EN_RECREATIONFACILITY = 241UL,
      FI_EN_RENTALCARSTATION = 242UL,
      FI_EN_RESTAURANT = 243UL,
      FI_EN_RECREATIONVEHICLEPARKING = 244UL,
      FI_EN_SHOPPINGCENTER = 245UL,
      FI_EN_SKIRESORT = 246UL,
      FI_EN_SPORTAIRPORT = 247UL,
      FI_EN_SPORTAREA = 248UL,
      FI_EN_SYNAGOGE = 249UL,
      FI_EN_TRUCKSTOP = 250UL,
      FI_EN_VANTAGEPOINT = 251UL,
      FI_EN_VETERINAERIANSERVICE = 252UL,
      FI_EN_WINEBAR = 253UL,
      FI_EN_WINERY = 254UL,
      FI_EN_ZOO = 255UL,
      FI_EN_COMMUNITYCENTER = 256UL,
      FI_EN_TOURISTOFFICE = 257UL,
      FI_EN_TOURISTATTRACTION = 258UL,
      FI_EN_DRIVINGEXERCISEAREA = 259UL,
      FI_EN_STADIUM = 260UL,
      FI_EN_COMPANY = 261UL,
      FI_EN_DOCTOR = 262UL,
      FI_EN_YACHTBASIN = 263UL,
      FI_EN_WATERSPORTS = 264UL,
      FI_EN_CONVENTIONCENTER = 265UL,
      FI_EN_PHARMACY = 266UL,
      FI_EN_SWIMMING = 267UL,
      FI_EN_CULTURALCENTER = 268UL,
      FI_EN_CONCERTHALL = 269UL,
      FI_EN_SHOP = 270UL,
      FI_EN_TRAVELAGENCY = 272UL,
      FI_EN_RENTACARPARKING = 273UL,
      FI_EN_MONASTERY = 274UL,
      FI_EN_LAUNDRY = 275UL,
      FI_EN_KINDERGARTEN = 276UL,
      FI_EN_HOLIDAYAREA = 278UL,
      FI_EN_FREEPORT = 279UL,
      FI_EN_FIREBRIGADE = 280UL,
      FI_EN_EMERGENCYMEDICALSERVICE = 281UL,
      FI_EN_DEPARTMENTSTORE = 282UL,
      FI_EN_CAMPGROUND = 283UL,
      FI_EN_ARTSCENTER = 284UL,
      FI_EN_RESTAURANTAREA = 285UL,
      FI_EN_OPENPARKINGAREA = 286UL,
      FI_EN_BARORPUB = 287UL,
      FI_EN_BOOKSTORE = 288UL,
      FI_EN_MEDICALSERVICE = 289UL,
      FI_EN_GUESTHOUSE = 290UL,
      FI_EN_SERVICEPARKINGAREA = 291UL,
      FI_EN_CARSPARES = 292UL,
      FI_EN_OTHERCARFACILITIES = 293UL,
      FI_EN_ARBORETUM = 294UL,
      FI_EN_MEMORIAL = 295UL,
      FI_EN_MUSICHALL = 296UL,
      FI_EN_OTHERARTSANDRELIGION = 297UL,
      FI_EN_NEWSPAPEROFFICE = 298UL,
      FI_EN_BROADCASTINGSTATION = 299UL,
      FI_EN_SONGANDDANCETROUPE = 300UL,
      FI_EN_SCIENCEEXHIBITIONCENTER = 301UL,
      FI_EN_OBSERVATORY = 302UL,
      FI_EN_SCIENTIFICRESEARCHINSTITUTION = 303UL,
      FI_EN_PUBLISHINGCOMPANY = 304UL,
      FI_EN_JOURNALEDITORIALOFFICE = 305UL,
      FI_EN_FILMANDTVPRODUCTION = 306UL,
      FI_EN_ARTSTROUPE = 307UL,
      FI_EN_ACROBATICS = 308UL,
      FI_EN_CULTURALTROUPE = 309UL,
      FI_EN_OTHERCULTUREANDSCIENCE = 310UL,
      FI_EN_GOLFTRAININGCENTER = 311UL,
      FI_EN_TENNISCOURT = 312UL,
      FI_EN_GYMNASIUM = 313UL,
      FI_EN_OTHERSPORTS = 314UL,
      FI_EN_EXCHANGES = 315UL,
      FI_EN_INSURANCEAGANCY = 316UL,
      FI_EN_OTHERBANKINGANDBUSINESS = 317UL,
      FI_EN_PUBLICTOILET = 318UL,
      FI_EN_TELECOMOFFICE = 319UL,
      FI_EN_CONFERENCECENTER = 320UL,
      FI_EN_WAREHOUSE = 321UL,
      FI_EN_ARCHIVE = 322UL,
      FI_EN_OTHERPUBLICPLACE = 323UL,
      FI_EN_PEDESTRIANPRECINCT = 324UL,
      FI_EN_INTERNETCAFE = 325UL,
      FI_EN_KARAOKECLUB = 326UL,
      FI_EN_SANATORIUM = 327UL,
      FI_EN_SAUNABATH = 328UL,
      FI_EN_CLUB = 329UL,
      FI_EN_OTHERLEISURE = 330UL,
      FI_EN_EMPORIUM = 331UL,
      FI_EN_SUPERMARKET = 332UL,
      FI_EN_ELECTRICALAPPLIANCESTORE = 333UL,
      FI_EN_PHOTOSTUDIO = 334UL,
      FI_EN_EXPRESSPHOTO = 335UL,
      FI_EN_AUDIOVIDEOSHOP = 336UL,
      FI_EN_HAIRDRESSER = 337UL,
      FI_EN_CLOTHINGSTORE = 338UL,
      FI_EN_SPORTINGGOODSSTORE = 339UL,
      FI_EN_STATIONERYSTORE = 340UL,
      FI_EN_DRUGSTORE = 341UL,
      FI_EN_GLASSESSTORE = 342UL,
      FI_EN_JUWELLERYSTORE = 343UL,
      FI_EN_PAINTINGANDCALLIGRAPHY = 344UL,
      FI_EN_TOYSTORE = 345UL,
      FI_EN_MUSICALINSTRUMENTSTORE = 346UL,
      FI_EN_PETSTORE = 347UL,
      FI_EN_OTHERSHOPPING = 348UL,
      FI_EN_REALTYEXCHANGECENTER = 349UL,
      FI_EN_UPHOLSTERYDESIGNSTUDIO = 350UL,
      FI_EN_REMOVER = 351UL,
      FI_EN_FAIRTRADEMARKET = 352UL,
      FI_EN_FOODOTHERS = 353UL,
      FI_EN_STATEGOVERNMENTDEPARTMENT = 354UL,
      FI_EN_PROVINVIALGOVERNMENTORGAN = 355UL,
      FI_EN_MUNICIPALGOVERNMENTORGAN = 356UL,
      FI_EN_TRAFFICPOLICESTATION = 357UL,
      FI_EN_GOVERNMENTOTHERS = 358UL,
      FI_EN_NURSERY = 359UL,
      FI_EN_TRAININGINSTITUTION = 360UL,
      FI_EN_FIRSTAID = 361UL,
      FI_EN_MOTHERANDCHILDCARE = 362UL,
      FI_EN_MOXIBUSTIONPARLOR = 363UL,
      FI_EN_MEDICALOTHERS = 364UL,
      FI_EN_CEMETERY = 365UL,
      FI_EN_MILITARYCEMETERY = 366UL,
      FI_EN_FUNERALHOME = 367UL,
      FI_EN_MORTUARYOTHERS = 368UL,
      FI_EN_FARM = 369UL,
      FI_EN_MINE = 370UL,
      FI_EN_COFFEESHOP = 371UL,
      FI_EN_CNGSTATION = 372UL,
      FI_EN_LPGSTATION = 373UL,
      FI_EN_INN = 374UL,
      FI_EN_OTHERACCOMMODATION = 375UL,
      FI_EN_FASTFOODRESTAURANT = 376UL,
      FI_EN_CHINESERESTAURANT = 377UL,
      FI_EN_FOREIGNRESTAURANT = 378UL,
      FI_EN_OPERA = 379UL,
      FI_EN_FURNITURESTORE = 380UL,
      FI_EN_TOURISMOTHERS = 381UL,
      FI_EN_ANTIQUEANDARTEXHIBITION = 382UL,
      FI_EN_COMMUNICATIONEQUIPMENT = 383UL,
      FI_EN_COMPUTERSTORE = 384UL,
      FI_EN_CONVENIENCESTORE = 385UL,
      FI_EN_FLOWERSHOP = 386UL,
      FI_EN_PERFORMINGARTS = 387UL,
      FI_EN_SPECIALITYFOODSTORE = 388UL,
      FI_EN_WATCHANDCAMERASTORE = 389UL,
      FI_EN_OPTICIAN = 390UL,
      FI_EN_TEMPLE = 391UL,
      FI_EN_AQUARIUM = 392UL,
      FI_EN_SUBWAYSTATION = 393UL,
      FI_EN_OTHERSTATIONS = 394UL,
      FI_EN_HIGHRISEBUILDING = 395UL,
      FI_EN_SCIENCEANDTECHNOLOGYCENTER = 396UL,
      FI_EN_TELECOMCOMPANY = 397UL,
      FI_EN_OTHERPLACEOFWORSHIP = 398UL,
      FI_EN_CARRACE = 399UL,
      FI_EN_COMMUNITYGROUP = 400UL,
      FI_EN_COSMETICS = 401UL,
      FI_EN_CRAFTWORKGIFT = 402UL,
      FI_EN_ECONOMICCHAINHOTEL = 403UL,
      FI_EN_OPENMARKET = 404UL,
      FI_EN_PARK = 405UL,
      FI_EN_PLANTANDPET = 406UL,
      FI_EN_SECURITIES = 407UL,
      FI_EN_STARHOTEL = 408UL,
      FI_EN_TEASHOP = 409UL,
      FI_EN_MOVIETHEATHER = 410UL,
      FI_EN_VOCATIONALSCHOOL = 411UL,
      FI_EN_DISEASEPREVENTIONORGANIZATION = 412UL,
      FI_EN_COMMUNITYMEDICALTREATMENT = 413UL,
      FI_EN_CULTUREART = 414UL,
      FI_EN_PARKANDRIDE = 415UL,
      FI_EN_CIGARETTEWINE = 416UL,
      FI_EN_VETERINARY = 417UL,
      FI_EN_BATH = 418UL,
      FI_EN_OTHERTRAVEL = 419UL,
      FI_EN_BAKERYANDCAKE = 420UL,
      FI_EN_PLANT = 421UL,
      FI_EN_OFFICEBUILDING = 422UL,
      FI_EN_HORSERACETRACK = 423UL,
      FI_EN_POINTADDRESS = 424UL,
      FI_EN_CONSUMERELECTRONICS = 425UL,
      FI_EN_HOMEIMPROVEMENT = 426UL,
      FI_EN_HOMESPECIALTY = 427UL,
      FI_EN_OFFICESUPPLY = 428UL,
      FI_EN_SPECIALTYSTORE = 429UL,
      FI_EN_MILITARYBASE = 430UL,
      FI_EN_TRANSPORTATIONSSERVICE = 431UL,
      FI_EN_ANIMALPARK = 432UL,
      FI_EN_CARGOCENTER = 433UL,
      FI_EN_COUNTYCOUNCIL = 434UL,
      FI_EN_INDUSTRIALZONE = 435UL,
      FI_EN_PUBLICRESTROOM = 436UL,
      FI_EN_WEIGHTSTATION = 437UL,
      FI_EN_ELECTRICCHARGESTATION = 438UL,
      FI_EN_PUBLICTRANSPORT = 439UL,
      FI_EN_HAMLET = 440UL,
      FI_EN_GOLFPRACTISE = 441UL,
      FI_EN_FUNERALDIRECTOR = 442UL,
      FI_EN_OTHERLIFESERVICE = 443UL,
      FI_EN_CHARGINGSTATION = 444UL,
      FI_EN_ACURADEALER = 450UL,
      FI_EN_ALFAROMEODEALER = 451UL,
      FI_EN_ASTONDEALER = 452UL,
      FI_EN_AUDIDEALER = 453UL,
      FI_EN_BENTLEYDEALER = 454UL,
      FI_EN_BMWDEALER = 455UL,
      FI_EN_BUICKDEALER = 457UL,
      FI_EN_CADILLACDEALER = 458UL,
      FI_EN_CHEVROLETDEALER = 459UL,
      FI_EN_CHRYSLERDEALER = 460UL,
      FI_EN_CITROENDEALER = 461UL,
      FI_EN_DAEWOODEALER = 462UL,
      FI_EN_DAIHATSUDEALER = 463UL,
      FI_EN_DODGEDEALER = 464UL,
      FI_EN_FERRARIDEALER = 465UL,
      FI_EN_FIATDEALER = 466UL,
      FI_EN_FORDDEALER = 467UL,
      FI_EN_GMCDEALER = 468UL,
      FI_EN_GMHDEALER = 469UL,
      FI_EN_HONDADEALER = 470UL,
      FI_EN_HYUNDAIDEALER = 471UL,
      FI_EN_INDEPENDENTGARAGEDEALER = 472UL,
      FI_EN_ISUZUDEALER = 473UL,
      FI_EN_JAGUARDEALER = 474UL,
      FI_EN_JEEPDEALER = 475UL,
      FI_EN_KIADEALER = 476UL,
      FI_EN_LADADEALER = 477UL,
      FI_EN_LAMBORGHINIDEALER = 478UL,
      FI_EN_LANCIADEALER = 479UL,
      FI_EN_LANDDEALER = 480UL,
      FI_EN_LANDROVERDEALER = 481UL,
      FI_EN_LEXUSDEALER = 482UL,
      FI_EN_LINCOLNDEALER = 483UL,
      FI_EN_MASERATIDEALER = 484UL,
      FI_EN_MAZDADEALER = 485UL,
      FI_EN_MCCDEALER = 486UL,
      FI_EN_MERCEDESBENZDEALER = 487UL,
      FI_EN_MGDEALER = 488UL,
      FI_EN_MINIDEALER = 489UL,
      FI_EN_MITSUBISHIDEALER = 490UL,
      FI_EN_NISSANDEALER = 491UL,
      FI_EN_OLDSMOBILEDEALER = 492UL,
      FI_EN_OPELDEALER = 493UL,
      FI_EN_PEUGEOTDEALER = 494UL,
      FI_EN_PONTIACDEALER = 495UL,
      FI_EN_PORSCHEDEALER = 496UL,
      FI_EN_RENAULTDEALER = 497UL,
      FI_EN_ROLLSROYCEDEALER = 498UL,
      FI_EN_ROVERDEALER = 499UL,
      FI_EN_SAABDEALER = 500UL,
      FI_EN_SATURNDEALER = 501UL,
      FI_EN_SEATDEALER = 502UL,
      FI_EN_SKODADEALER = 503UL,
      FI_EN_SUBARUDEALER = 504UL,
      FI_EN_SUZUKIDEALER = 505UL,
      FI_EN_TOYOTADEALER = 506UL,
      FI_EN_VOLKSWAGENDEALER = 507UL,
      FI_EN_VOLVODEALER = 508UL,
      FI_EN_GMDEALER = 510UL,
      FI_EN_VAUXHALLDEALER = 511UL,
      FI_EN_INFINITIDEALER = 512UL,
      FI_EN_PROTONDEALER = 513UL,
      FI_EN_ACURA = 600UL,
      FI_EN_ALFAROMEO = 601UL,
      FI_EN_ASTON = 602UL,
      FI_EN_AUDI = 603UL,
      FI_EN_BENTLEY = 604UL,
      FI_EN_BMW = 605UL,
      FI_EN_BOSCH = 606UL,
      FI_EN_BUICK = 607UL,
      FI_EN_CADILLAC = 608UL,
      FI_EN_CHEVROLET = 609UL,
      FI_EN_CHRYSLER = 610UL,
      FI_EN_CITROEN = 611UL,
      FI_EN_DAEWOO = 612UL,
      FI_EN_DAIHATSU = 613UL,
      FI_EN_DODGE = 614UL,
      FI_EN_FERRARI = 615UL,
      FI_EN_FIAT = 616UL,
      FI_EN_FORD = 617UL,
      FI_EN_GMC = 618UL,
      FI_EN_GMH = 619UL,
      FI_EN_HONDA = 620UL,
      FI_EN_HYUNDAI = 621UL,
      FI_EN_INDEPENDENTGARAGE = 622UL,
      FI_EN_ISUZU = 623UL,
      FI_EN_JAGUAR = 624UL,
      FI_EN_JEEP = 625UL,
      FI_EN_KIA = 626UL,
      FI_EN_LADA = 627UL,
      FI_EN_LAMBORGHINI = 628UL,
      FI_EN_LANCIA = 629UL,
      FI_EN_LAND = 630UL,
      FI_EN_LANDROVER = 631UL,
      FI_EN_LEXUS = 632UL,
      FI_EN_LINCOLN = 633UL,
      FI_EN_MASERATI = 634UL,
      FI_EN_MAZDA = 635UL,
      FI_EN_MCC = 636UL,
      FI_EN_MERCEDESBENZ = 637UL,
      FI_EN_MG = 638UL,
      FI_EN_MINI = 639UL,
      FI_EN_MITSUBISHI = 640UL,
      FI_EN_NISSAN = 641UL,
      FI_EN_OLDSMOBILE = 642UL,
      FI_EN_OPEL = 643UL,
      FI_EN_PEUGEOT = 644UL,
      FI_EN_PONTIAC = 645UL,
      FI_EN_PORSCHE = 646UL,
      FI_EN_RENAULT = 647UL,
      FI_EN_ROLLSROYCE = 648UL,
      FI_EN_ROVER = 649UL,
      FI_EN_SAAB = 650UL,
      FI_EN_SATURN = 651UL,
      FI_EN_SEAT = 652UL,
      FI_EN_SKODA = 653UL,
      FI_EN_SUBARU = 654UL,
      FI_EN_SUZUKI = 655UL,
      FI_EN_TOYOTA = 656UL,
      FI_EN_VOLKSWAGEN = 657UL,
      FI_EN_VOLVO = 658UL,
      FI_EN_GM = 660UL,
      FI_EN_BLAUPUNKT = 661UL,
      FI_EN_EVOBUS = 662UL,
      FI_EN_IRISBUS = 663UL,
      FI_EN_NEOPLAN = 664UL,
      FI_EN_OMNIBUS = 665UL,
      FI_EN_SCANIA = 666UL,
      FI_EN_VOLVOTRUCKS = 667UL,
      FI_EN_BUSSERVICE = 668UL,
      FI_EN_DAF = 669UL,
      FI_EN_MANTRUCK = 670UL,
      FI_EN_MERCEDESBENZTRUCK = 671UL,
      FI_EN_VAUXHALL = 672UL,
      FI_EN_MERCEDESBENZOMNIPLUS = 673UL,
      FI_EN_SETRAOMNIPLUS = 674UL,
      FI_EN_INFINITI = 675UL,
      FI_EN_RENAULTTRUCK = 676UL,
      FI_EN_PROTON = 677UL,
      FI_EN_VOLVOBUS = 678UL,
      FI_EN_BOSCHSERVICEPARTNER = 679UL,
      FI_EN_DAFTRUCKS = 680UL,
      FI_EN_MERCEDESBENZBUS = 681UL,
      FI_EN_SETRA = 682UL,
      FI_EN_SHOPPING = 751UL,
      FI_EN_BANKINGANDBUSINESS = 752UL,
      FI_EN_TRAVEL = 753UL,
      FI_EN_PUBLICPLACES = 754UL,
      FI_EN_AUTOMOTIVE = 755UL,
      FI_EN_PERSONALSERVICES = 756UL,
      FI_EN_LEISURE = 757UL,
      FI_EN_EMERGENCY = 758UL,
      FI_EN_CARDEALER = 759UL,
      FI_EN_MENUITEMRESTAURANT = 760UL,
      FI_EN_MENUITEMHOTEL = 761UL,
      FI_EN_TOURISMANDSIGHTSEEING = 762UL,
      FI_EN_ARTANDRELIGION = 763UL,
      FI_EN_CULTURALANDSCIENTIFICINSTITUTES = 764UL,
      FI_EN_SPORTS = 765UL,
      FI_EN_REALESTATE = 766UL,
      FI_EN_FOOD = 767UL,
      FI_EN_GOVERNMENTOFFICE = 768UL,
      FI_EN_EDUCATION = 769UL,
      FI_EN_MEDICAL = 770UL,
      FI_EN_MORTUARY = 771UL,
      FI_EN_INTERIORREPRESENTATION = 772UL,
      FI_EN_FOREIGNREPRESENTATION = 773UL,
      FI_EN_MENUITEMOTHERS = 774UL,
      FI_EN_GROUPPLACEOFWORSHIP = 775UL,
      FI_EN_GROUPNIGHTLIFE = 776UL,
      FI_EN_GROUPTOURISTATTRACTION = 777UL,
      FI_EN_GROUPSTATION = 778UL,
      FI_EN_GROUPBUSINESS = 779UL,
      FI_EN_GROUPHIGHEREDUCATION = 780UL,
      FI_EN_GROUPEATANDDRINK = 781UL,
      FI_EN_GROUPELECTRICALAPPLIANCECHAINSTORE = 782UL,
      FI_EN_GROUPHEALTHCARE = 783UL,
      FI_EN_GROUPSPECIALGROUND = 784UL,
      FI_EN_GROUPSPECIALMARKET = 785UL,
      FI_EN_GROUPLIBRARY = 786UL,
      FI_EN_GROUPBANKPUBLICSERVICE = 787UL,
      FI_EN_GROUPLOGISTICSANDPOSTOFFICE = 788UL,
      FI_EN_GROUPENTERPRISEANDFACTORY = 789UL,
      FI_EN_GROUPSPORTSENTERTAINMENT = 790UL,
      FI_EN_GROUPBUSINESSCENTER = 791UL,
      FI_EN_GROUPMEDICALSERVICE = 792UL,
      FI_EN_GROUPMARINA = 793UL,
      FI_EN_GROUPFRANCHISESTORE = 794UL,
      FI_EN_GROUPVEHICLE = 795UL,
      FI_EN_GROUPGOVERNOFFICECOMMUNITY = 796UL,
      FI_EN_GROUPLIFESERVICE = 798UL,
      FI_EN_GROUPCOMMERCIALRESIDENTIALBUILDING = 799UL,
      FI_EN_GROUPSPORTSTATIONER = 800UL,
      FI_EN_GROUPSPORTSGROUND = 801UL,
      FI_EN_GROUPPARKPLAZA = 802UL,
      FI_EN_GROUPFINANCEINSURANCE = 803UL,
      FI_EN_GROUPFURNITUREHOMEDECORATION = 804UL,
      FI_EN_CARWASHES = 901UL,
      FI_EN_PARKINGGARAGE = 902UL,
      FI_EN_ROADASSISTANCE = 903UL,
      FI_EN_AUTOPARTS = 904UL,
      FI_EN_PARKANDRIDEFACILITY = 905UL,
      FI_EN_AMERICANFOOD = 906UL,
      FI_EN_BREAKFAST = 907UL,
      FI_EN_BBQ = 908UL,
      FI_EN_BREWPUP = 909UL,
      FI_EN_DELI = 910UL,
      FI_EN_ITALIAN = 911UL,
      FI_EN_EUROPEAN = 912UL,
      FI_EN_FRENCH = 913UL,
      FI_EN_GREEK = 914UL,
      FI_EN_GRILL = 915UL,
      FI_EN_INDIAN = 916UL,
      FI_EN_INTERNATIONAL = 917UL,
      FI_EN_JAPANESE = 918UL,
      FI_EN_KOSHER = 919UL,
      FI_EN_LATIN = 920UL,
      FI_EN_MEXICAN = 921UL,
      FI_EN_MIDDLEEASTERN = 922UL,
      FI_EN_SEAFOOD = 923UL,
      FI_EN_STEAKHOUSE = 924UL,
      FI_EN_THAI = 925UL,
      FI_EN_VEGETARIAN = 926UL,
      FI_EN_OTHERRESTAURANT = 927UL,
      FI_EN_COCKTAILLOUNGE = 928UL,
      FI_EN_LOCALTRANSIT = 929UL,
      FI_EN_RVPARKS = 930UL,
      FI_EN_MALLS = 931UL,
      FI_EN_MENSAPPAREL = 932UL,
      FI_EN_WOMENSAPPAREL = 933UL,
      FI_EN_CHILDRENSAPPAREL = 934UL,
      FI_EN_SHOEFOOTWEAR = 935UL,
      FI_EN_HOMEANDGARDEN = 936UL,
      FI_EN_CDRECORDVIDEO = 937UL,
      FI_EN_MAJORAPPLIANCE = 938UL,
      FI_EN_ENTERTAINMENTELECTRONICS = 939UL,
      FI_EN_FLOWERSANDJEWELRY = 940UL,
      FI_EN_VIDEOANDGAME = 941UL,
      FI_EN_WINEANDLIQUOR = 942UL,
      FI_EN_DISCOUNTSTORE = 943UL,
      FI_EN_BOATING = 944UL,
      FI_EN_GIFTANTIQUEART = 945UL,
      FI_EN_VARIETYSTORE = 946UL,
      FI_EN_FOODBEVERAGE = 947UL,
      FI_EN_GENERALMERCHANDISE = 948UL,
      FI_EN_TAILORANDALTERATION = 949UL,
      FI_EN_HEALTHCLUB = 950UL,
      FI_EN_SPORTSCOMPLEX = 951UL,
      FI_EN_WASTEANDSANITARY = 952UL,
      FI_EN_CHECKCASHINGSERVICES = 953UL,
      FI_EN_FIREDEPARTMENT = 954UL,
      FI_EN_SOCIALSERVICE = 955UL,
      FI_EN_RETIREMENTNURSINGHOME = 956UL,
      FI_EN_TAXSERVICE = 957UL,
      FI_EN_BANKETHALL = 958UL,
      FI_EN_REPAIRSERVICE = 959UL,
      FI_EN_STORAGE = 960UL,
      FI_EN_MOVER = 961UL,
      FI_EN_MONEYTRANSFERRINGSERVICES = 962UL,
      FI_EN_TELEPHONESERVICE = 963UL,
      FI_EN_UTILITIES = 964UL,
      FI_EN_OTHERCOMMUNICATION = 965UL,
      FI_EN_OTHERWORSHIP = 968UL,
      FI_EN_NONGMCARDEALERS = 969UL,
      FI_EN_BUSINESSSERVICE = 970UL,
      FI_EN_ONEORTWOSTAR = 971UL,
      FI_EN_THREESTAR = 972UL,
      FI_EN_FOURSTAR = 973UL,
      FI_EN_FIVESTAR = 974UL,
      FI_EN_NONSTAR = 975UL,
      FI_EN_VACATIONVILLAGE = 976UL,
      FI_EN_CALIFORNIANRESTAURANT = 977UL,
      FI_EN_SOUTHWESTERNRESTAURANT = 978UL,
      FI_EN_BURGER = 979UL,
      FI_EN_CHICKEN = 980UL,
      FI_EN_ICECREAM = 981UL,
      FI_EN_PIZZA = 982UL,
      FI_EN_SANDWICH = 983UL,
      FI_EN_SNACK = 984UL,
      FI_EN_SUSHI = 985UL,
      FI_EN_VEGAN = 986UL,
      FI_EN_SPORTINSTRUCTIONCAMP = 987UL,
      FI_EN_NORTHWESTERNRESTAURANT = 988UL,
      FI_EN_JIANGXIRESTAURANT = 989UL,
      FI_EN_GUANGXIRESTAURANT = 990UL,
      FI_EN_TAIWANESERESTAURANT = 991UL,
      FI_EN_YUNNANRESTAURANT = 992UL,
      FI_EN_MONGOLIANRESTAURANT = 993UL,
      FI_EN_JIANGSURESTAURANT = 994UL,
      FI_EN_SHANDONGRESTAURANT = 995UL,
      FI_EN_HUNANRESTAURANT = 996UL,
      FI_EN_CANTONESERESTAURANT = 997UL,
      FI_EN_SZECHUANRESTAURANT = 998UL,
      FI_EN_NORTHEASTERNRESTAURANT = 999UL,
      FI_EN_BEIJINGRESTAURANT = 1000UL,
      FI_EN_SHANGHAIRESTAURANT = 1001UL,
      FI_EN_PORRIDGE = 1002UL,
      FI_EN_ISLAMICRESTAURANT = 1003UL,
      FI_EN_DUTCHRESTAURANT = 1004UL,
      FI_EN_BELGIANRESTAURANT = 1005UL,
      FI_EN_PORTUGUESERESTAURANT = 1006UL,
      FI_EN_SWISSRESTAURANT = 1007UL,
      FI_EN_SPANISHRESTAURANT = 1008UL,
      FI_EN_MALTESERESTAURANT = 1009UL,
      FI_EN_BOHEMIANRESTAURANT = 1010UL,
      FI_EN_BALKANRESTAURANT = 1011UL,
      FI_EN_BALTICRESTAURANT = 1012UL,
      FI_EN_HUNGARIANRESTAURANT = 1013UL,
      FI_EN_IRISHRESTAURANT = 1014UL,
      FI_EN_SCANDINAVIANRESTAURANT = 1015UL,
      FI_EN_FINNISHRESTAURANT = 1016UL,
      FI_EN_RUSSIANRESTAURANT = 1017UL,
      FI_EN_BRITISHRESTAURANT = 1018UL,
      FI_EN_POLISHRESTAURANT = 1019UL,
      FI_EN_AUSTRIANRESTAURANT = 1020UL,
      FI_EN_GERMANRESTAURANT = 1021UL,
      FI_EN_EASTEUROPEANRESTAURANT = 1022UL,
      FI_EN_TAPASRESTAURANT = 1023UL,
      FI_EN_HAWAIIANRESTAURANT = 1024UL,
      FI_EN_ASIANRESTAURANT = 1025UL,
      FI_EN_TURKISHRESTAURANT = 1026UL,
      FI_EN_INDONESIANRESTAURANT = 1027UL,
      FI_EN_VIETNAMESIANRESTAURANT = 1028UL,
      FI_EN_AUSTRALIANRESTAURANT = 1029UL,
      FI_EN_AFRICANRESTAURANT = 1030UL,
      FI_EN_KOREANRESTAURANT = 1031UL,
      FI_EN_AZERBAIJANRESTAURANT = 1032UL,
      FI_EN_SURINAMESERESTAURANT = 1033UL,
      FI_EN_BELORUSSIANRESTAURANT = 1034UL,
      FI_EN_FILIPINORESTAURANT = 1035UL,
      FI_EN_CAUCASIANRESTAURANT = 1036UL,
      FI_EN_SOUTHAMERICANRESTAURANT = 1037UL,
      FI_EN_ARGENTINEANRESTAURANT = 1038UL,
      FI_EN_BRAZILIANRESTAURANT = 1039UL,
      FI_EN_CHILEANRESTAURANT = 1040UL,
      FI_EN_CRIOLLARESTAURANT = 1041UL,
      FI_EN_FONDUERESTAURANT = 1042UL,
      FI_EN_FUSIONRESTAURANT = 1043UL,
      FI_EN_PASTRIERESTAURANT = 1044UL,
      FI_EN_OTHERCLOTHING = 1045UL,
      FI_EN_SPECIALTYCLOTHING = 1046UL,
      FI_EN_HOMECENTERS = 1047UL,
      FI_EN_AGRICULTURALMARKET = 1048UL,
      FI_EN_LOTTERYBOOTH = 1049UL,
      FI_EN_POLICESERVICES = 1050UL,
      FI_EN_SPORTSCENTERS = 1051UL,
      FI_EN_CATHOLIC = 1052UL,
      FI_EN_OTHERINTERNALITIONALRESTAURANT = 1053UL,
      FI_EN_USERPOI_MINCAT = 1792UL,
      FI_EN_USERPOI_MAXCAT = 2047UL,
      FI_EN_SXMPOI_MINCAT = 2048UL,
      FI_EN_SXMPOI_MAXCAT = 2303UL,
      FI_EN_GROUPFUELAUTO = 3001UL,
      FI_EN_GROUPPARKING = 3002UL,
      FI_EN_GROUPSERVICEMAINTENANCE = 3003UL,
      FI_EN_GROUPFOODANDNIGHTLIFE = 3004UL,
      FI_EN_GROUPTRAVELLODGING = 3005UL,
      FI_EN_GROUPSPORTSFACILITIESVENUES = 3006UL,
      FI_EN_GROUPTRANSPORTATION = 3007UL,
      FI_EN_GROUPCAMPINGANDRVPARKS = 3008UL,
      FI_EN_GROUPSHOPPINGSERVICES = 3009UL,
      FI_EN_GROUPMALLSANDCLOTHING = 3010UL,
      FI_EN_GROUPSHOPPINGCENTERMALLS = 3011UL,
      FI_EN_GROUPCLOTHINGSTORE = 3012UL,
      FI_EN_GROUPHOMEIMPROVEMENT = 3013UL,
      FI_EN_GROUPSPECIALTYRETAIL = 3014UL,
      FI_EN_GROUPELECTRONICS = 3015UL,
      FI_EN_GROUPFOODBEVERAGES = 3016UL,
      FI_EN_GROUPOTHERRETAIL = 3017UL,
      FI_EN_GROUPPROFESSIONALSERVICES = 3018UL,
      FI_EN_GROUPCOMMUNITYANDEMERGENCY = 3019UL,
      FI_EN_GROUPTELEPHONEANDUTILITIES = 3020UL,
      FI_EN_GROUPRECREATIONCOMMUNITYCENTER = 3021UL,
      FI_EN_GROUPCOMMUNITYSERVICES = 3022UL,
      FI_EN_GROUPENTERTAINMENT = 3023UL,
      FI_EN_GROUPRECREATION = 3024UL,
      FI_EN_GROUPTOURISTANDCULTURAL = 3025UL,
      FI_EN_GROUPCULTURALVENUES = 3026UL,
      FI_EN_GROUPRESTSTOPS = 3027UL,
      FI_EN_GROUPBANKINGFINANCIAL = 3028UL,
      FI_EN_GROUPDEALERSHIPS = 3029UL,
      FI_EN_GROUPEMERGENCYSERVICES = 3030UL,
      FI_EN_GROUPAMERICANFOOD = 3031UL,
      FI_EN_GROUPJAPANESEFOOD = 3032UL,
      FI_EN_GROUPVEGETARIANFOOD = 3033UL,
      FI_EN_GROUPOTHERRESTAURANT = 3034UL,
      FI_EN_GROUPCHINESERESTAURANT = 3035UL,
      FI_EN_GROUPLATINRESTAURANT = 3036UL,
      FI_EN_SKIRESORT2 = 3100UL,
      FI_EN_DP_MERIANSCOUT = 4000UL,
      FI_EN_DP_VIAMICHELIN = 4001UL,
      FI_EN_DP_FALK = 4002UL,
      FI_EN_F_SMALLPARK = 4096UL,
      FI_EN_F_LARGEPARK = 4097UL,
      FI_EN_F_SMALLSTADIUM = 4098UL,
      FI_EN_F_LARGESTADIUM = 4099UL,
      FI_EN_F_FASTFOOD = 4100UL,
      FI_EN_F_CHINESEFOOD = 4101UL,
      FI_EN_F_CHINESESICHUANFOOD = 4102UL,
      FI_EN_F_CHINESEHUNANFOOD = 4103UL,
      FI_EN_F_CHINESESHANDONGFOOD = 4104UL,
      FI_EN_F_CHINESEGUANGDONGFOOD = 4105UL,
      FI_EN_F_CHINESESHANGHAIFOOD = 4106UL,
      FI_EN_F_FRENCHFOOD = 4107UL,
      FI_EN_F_ITALIANFOOD = 4108UL,
      FI_EN_F_BRAZILIANFOOD = 4109UL,
      FI_EN_F_GERMANFOOD = 4110UL,
      FI_EN_F_USFOOD = 4111UL,
      FI_EN_F_JAPANESEFOOD = 4112UL,
      FI_EN_F_KOREANFOOD = 4113UL,
      FI_EN_F_MALAYSIANFOOD = 4114UL,
      FI_EN_F_INDIANFOOD = 4115UL,
      FI_EN_F_SPANISHFOOD = 4116UL,
      FI_EN_F_MEXICANFOOD = 4117UL,
      FI_EN_F_TURKISHFOOD = 4118UL,
      FI_EN_F_GREEKFOOD = 4119UL,
      FI_EN_F_DUTCHFOOD = 4120UL,
      FI_EN_F_BELGIANFOOD = 4121UL,
      FI_EN_F_DANISHFOOD = 4122UL,
      FI_EN_F_SWEDISHFOOD = 4123UL,
      FI_EN_F_SOUMIFOOD = 4124UL,
      FI_EN_F_NORWEGIANFOOD = 4125UL,
      FI_EN_F_CZECHFOOD = 4126UL,
      FI_EN_F_ARGENTINEFOOD = 4127UL,
      FI_EN_F_PORTUGESEFOOD = 4128UL,
      FI_EN_F_CANADIANFOOD = 4129UL,
      FI_EN_F_BRITISHFOOD = 4130UL,
      FI_EN_F_PUBFOOD = 4131UL,
      FI_EN_F_EGYTIANFOOD = 4132UL,
      FI_EN_F_PERSIANFOOD = 4133UL,
      FI_EN_F_ARABFOOD = 4134UL,
      FI_EN_F_RUSSIANFOOD = 4135UL,
      FI_EN_F_CHAFINGDISHFOOD = 4136UL,
      FI_EN_F_KOSHERFOOD = 4137UL,
      FI_EN_F_MUSLIMFOOD = 4138UL,
      FI_EN_F_BAR = 4140UL,
      FI_EN_F_CAFE = 4141UL,
      FI_EN_F_TEASHOP = 4142UL,
      FI_EN_F_ACCOMMODATIONHOTEL = 4143UL,
      FI_EN_F_ACCOMMODATIONINN = 4144UL,
      FI_EN_F_ACCOMMODATIONBEDANDBREAKFAST = 4145UL,
      FI_EN_F_ACCOMMODATIONGUESTHOUSE = 4146UL,
      FI_EN_F_ACCOMMODATIONMOTEL = 4147UL,
      FI_EN_F_ACCOMMODATIONAPARTMENTHOTEL = 4148UL,
      FI_EN_F_THREESTARACCOMMODATION = 4149UL,
      FI_EN_F_FOURSTARACCOMMODATION = 4150UL,
      FI_EN_F_FIVESTARACCOMMODATION = 4151UL,
      FI_EN_F_STOCKEXCHANGE = 4152UL,
      FI_EN_F_FUTURESEXCHANGE = 4153UL,
      FI_EN_F_GOLDEXCHANGE = 4154UL,
      FI_EN_F_DOMESTICAPPLIANCES = 4155UL,
      FI_EN_F_COMPUTERS = 4156UL,
      FI_EN_F_MOBILEPHONES = 4157UL,
      FI_EN_F_PHOTOEQUIPMENT = 4158UL,
      FI_EN_F_ACOUSTICEQUIPMENT = 4159UL,
      FI_EN_F_ELECTRICAPPLICATIONS = 4160UL,
      FI_EN_F_MENSCLOTHES = 4161UL,
      FI_EN_F_WOMENSCLOTHES = 4162UL,
      FI_EN_F_CHILDRENWEAR = 4163UL,
      FI_EN_F_COSTUMERENTAL = 4164UL,
      FI_EN_F_FOREIGNFOOD = 4165UL,
      FI_EN_F_OTHERCOFFEE = 4166UL,
      FI_EN_F_ONESTARACCOMMODATION = 4167UL,
      FI_EN_F_TWOSTARACCOMMODATION = 4168UL,
      FI_EN_F_PARKANDRIDEPARKING = 4169UL,
      FI_EN_F_OPENAREAPARKING = 4170UL,
      FI_EN_F_GARAGEPARKING = 4171UL,
      FI_EN_F_RENTACARPARKING = 4172UL,
      FI_EN_F_MULTISTOREYPARKING = 4173UL,
      FI_EN_F_AMERICANFOOD = 4174UL,
      FI_EN_F_CALIFORNIANFOOD = 4175UL,
      FI_EN_F_CONTINENTALFOOD = 4176UL,
      FI_EN_F_OTHERFOOD = 4177UL,
      FI_EN_F_SEAFOOD = 4178UL,
      FI_EN_F_THAIFOOD = 4179UL,
      FI_EN_F_VEGETARIANFOOD = 4180UL,
      FI_EN_F_VIETNAMESEFOOD = 4181UL,
      FI_EN_F_UNKNOWNFOOD = 4182UL,
      FI_EN_F_AUSTRIANFOOD = 4183UL,
      FI_EN_F_BARBEQUE_SOUTHERN = 4184UL,
      FI_EN_F_BISTRO = 4185UL,
      FI_EN_F_BREWPUB = 4186UL,
      FI_EN_F_BRITHISHISLESFOOD = 4187UL,
      FI_EN_F_CAJUN_CARRIBEANFOOD = 4188UL,
      FI_EN_F_EASTEUROPEANFOOD = 4189UL,
      FI_EN_F_GRILL = 4190UL,
      FI_EN_F_HAWAIIAN_POLYNESIANFOOD = 4191UL,
      FI_EN_F_HUNGARIANFOOD = 4192UL,
      FI_EN_F_INDONESIAN_MALAYSIANFOOD = 4193UL,
      FI_EN_F_LATINAMERICANFOOD = 4194UL,
      FI_EN_F_MALTESEFOOD = 4195UL,
      FI_EN_F_MIDDLEEASTERNFOOD = 4196UL,
      FI_EN_F_FILIPINOFOOD = 4197UL,
      FI_EN_F_POLISHFOOD = 4198UL,
      FI_EN_F_PORTUGUESEFOOD = 4199UL,
      FI_EN_F_SANDWICH = 4200UL,
      FI_EN_F_SCANDINAVIANFOOD = 4201UL,
      FI_EN_F_SOUTHAMERICANFOOD = 4202UL,
      FI_EN_F_SOUTHEASTASIANFOOD = 4203UL,
      FI_EN_F_SOUTHWESTERNFOOD = 4204UL,
      FI_EN_F_SURINAMESEFOOD = 4205UL,
      FI_EN_F_STEAKHOUSE = 4206UL,
      FI_EN_F_SWISSFOOD = 4207UL,
      FI_EN_F_AFRICANFOOD = 4208UL,
      FI_EN_F_INTERNATIONALFOOD = 4209UL,
      FI_EN_F_BOHEMIANFOOD = 4210UL,
      FI_EN_F_BALKANFOOD = 4211UL,
      FI_EN_F_FINNISHFOOD = 4212UL,
      FI_EN_F_AUSTRALIANFOOD = 4213UL,
      FI_EN_F_LPG_AVAILABLE = 4214UL,
      FI_EN_F_PETROL_AVAILABLE = 4215UL,
      FI_EN_F_DIESEL_AVAILABLE = 4216UL,
      FI_EN_F_CNG_AVAILABLE = 4217UL,
      FI_EN_F_E85_AVAILABLE = 4218UL,
      FI_EN_F_24H_OPEN = 4219UL,
      FI_EN_F_ONETWOSTARS = 4220UL,
      FI_EN_F_THREESTARS = 4221UL,
      FI_EN_F_FOURSTARS = 4222UL,
      FI_EN_F_FIVESTARS = 4223UL,
      FI_EN_F_ELECTRICCHARGINGSTATION = 4225UL,
      FI_EN_F_BIODIESEL = 4269UL,
      FI_EN_F_HYDROGEN = 4270UL,
      FI_EN_F_ADBLUE = 4273UL,
      FI_EN_MCDONALDS = 32768UL,
      FI_EN_BURGERKING = 32769UL,
      FI_EN_KFC = 32770UL,
      FI_EN_PIZZAHUT = 32771UL,
      FI_EN_HAAGENDASZ = 32772UL,
      FI_EN_STARBUCKS = 32773UL,
      FI_EN_UBCCOFFEE = 32774UL,
      FI_EN_PEOPLESBANKOFCHINA = 32775UL,
      FI_EN_INDANDCOMBANKOFCHINA = 32776UL,
      FI_EN_CHINACONSTRUCTIONBANK = 32777UL,
      FI_EN_AGICULTURALBANKOFCHINA = 32778UL,
      FI_EN_BANKOFCHINA = 32779UL,
      FI_EN_CHINAMERCHANTSBANK = 32780UL,
      FI_EN_COMMUNICATIONBANKOFCHINA = 32781UL,
      FI_EN_HUAXIABANK = 32782UL,
      FI_EN_MINGSHENGBANKINGCORP = 32783UL,
      FI_EN_CHINAEVERBRIGHTBANK = 32784UL,
      FI_EN_CITICINDUSTRIALBANK = 32785UL,
      FI_EN_FAMOUSFOREIGNBANK = 32786UL,
      FI_EN_ARAL = 32787UL,
      FI_EN_BP = 32788UL,
      FI_EN_SHELL = 32789UL,
      FI_EN_PETROCHINA = 32790UL,
      FI_EN_EXXONMOBIL = 32791UL,
      FI_EN_TOTAL = 32792UL,
      FI_EN_AVIA = 32793UL,
      FI_EN_AGIP = 32794UL,
      FI_EN_ORLEN = 32795UL,
      FI_EN_SINOPEC = 32796UL,
      FI_EN_REALBREWEDTEA = 32797UL,
      FI_EN_ORIGUS = 32798UL,
      FI_EN_CHINARESOURCES = 32799UL,
      FI_EN_ATMPEOPLESBANKOFCHINA = 32875UL,
      FI_EN_ATMINDANDCOMBANKOFCHINA = 32876UL,
      FI_EN_ATMCHINACONSTRUCTIONBANK = 32877UL,
      FI_EN_ATMAGICULTURALBANKOFCHINA = 32878UL,
      FI_EN_ATMBANKOFCHINA = 32879UL,
      FI_EN_ATMCHINAMERCHANTSBANK = 32880UL,
      FI_EN_ATMCOMMUNICATIONBANKOFCHINA = 32881UL,
      FI_EN_ATMHUAXIABANK = 32882UL,
      FI_EN_ATMMINGSHENGBANKINGCORP = 32883UL,
      FI_EN_ATMCHINAEVERBRIGHTBANK = 32884UL,
      FI_EN_ATMCITICINDUSTRIALBANK = 32885UL,
      FI_EN_ATMFAMOUSFOREIGNBANK = 32886UL,
      FI_EN_ATMGUANGDONGDEVELOPMENTBANK = 32887UL,
      FI_EN_ATMSHENZENDEVELOPMENTBANK = 32888UL,
      FI_EN_ATMPUDONGDEVELOPMENTBANK = 32889UL,
      FI_EN_ATMRURALCREDITCOOPCHINA = 32890UL,
      FI_EN_ATMCITIBANK = 32891UL,
      FI_EN_ATMHBSC = 32892UL,
      FI_EN_ATMSTDCHARTEREDBANK = 32893UL,
      FI_EN_ATMDAIICHIKANGYOBANK = 32894UL,
      FI_EN_GUANGDONGDEVELOPMENTBANK = 32895UL,
      FI_EN_SHENZENDEVELOPMENTBANK = 32896UL,
      FI_EN_PUDONGDEVELOPMENTBANK = 32897UL,
      FI_EN_RURALCREDITCOOPCHINA = 32898UL,
      FI_EN_CITIBANK = 32899UL,
      FI_EN_HBSC = 32900UL,
      FI_EN_STDCHARTEREDBANK = 32901UL,
      FI_EN_DAIICHIKANGYOBANK = 32902UL,
      FI_EN_SGMCOMPANY = 32903UL,
      FI_EN_YOUNGHO = 32904UL,
      FI_EN_B_HOLIDAYINN = 32905UL,
      FI_EN_B_BESTWESTERN = 32906UL,
      FI_EN_B_RAMADA = 32907UL,
      FI_EN_B_ALLGUTH = 32908UL,
      FI_EN_B_ESSO = 32909UL,
      FI_EN_B_JET = 32910UL,
      FI_EN_B_TEXACO = 32911UL,
      FI_EN_B_FINA = 32912UL,
      FI_EN_B_DEA = 32913UL,
      FI_EN_B_ELF = 32914UL,
      FI_EN_B_BFT = 32915UL,
      FI_EN_B_NOVOTEL = 32916UL,
      FI_EN_B_BAVARIA = 32917UL,
      FI_EN_B_IBIS = 32918UL,
      FI_EN_B_SOFITEL = 32919UL,
      FI_EN_B_PULLMAN = 32920UL,
      FI_EN_B_ATHENA = 32921UL,
      FI_EN_B_ASTORIA = 32922UL,
      FI_EN_B_CONCORDE = 32923UL,
      FI_EN_B_DORINT = 32924UL,
      FI_EN_B_RINGHOTEL = 32925UL,
      FI_EN_B_MOBIL = 32926UL,
      FI_EN_B_MERIDIEN = 32927UL,
      FI_EN_B_ELFANTAR = 32928UL,
      FI_EN_B_ANTAR = 32929UL,
      FI_EN_B_MOUNTCHARLOTTETHISTLE = 32930UL,
      FI_EN_B_MOEVENPICK = 32931UL,
      FI_EN_B_MORRISONS = 32932UL,
      FI_EN_B_CARREFOUR = 32933UL,
      FI_EN_B_RITZCARLTON = 32934UL,
      FI_EN_B_TESCO = 32935UL,
      FI_EN_B_GRANGE = 32936UL,
      FI_EN_B_MINOL = 32937UL,
      FI_EN_B_CARLTON = 32938UL,
      FI_EN_B_INTERHOTEL = 32939UL,
      FI_EN_B_AXOTEL = 32940UL,
      FI_EN_B_CAMPANILE = 32941UL,
      FI_EN_B_MERCURE = 32942UL,
      FI_EN_B_CONFORTEL = 32943UL,
      FI_EN_B_COMFORTINN = 32944UL,
      FI_EN_B_FIMOTEL = 32945UL,
      FI_EN_B_URBIS = 32946UL,
      FI_EN_B_CLIMATDEFRANCE = 32947UL,
      FI_EN_B_RELAISBLEUS = 32948UL,
      FI_EN_B_RESTHOTEL = 32949UL,
      FI_EN_B_GOLDENTULIP = 32950UL,
      FI_EN_B_SHERATON = 32951UL,
      FI_EN_B_HILTON = 32952UL,
      FI_EN_B_APEGIA = 32953UL,
      FI_EN_B_CLUBMEDITERRANEE = 32954UL,
      FI_EN_B_CASINO = 32955UL,
      FI_EN_B_MARRIOT = 32956UL,
      FI_EN_B_WESTFALEN = 32957UL,
      FI_EN_B_SVG = 32958UL,
      FI_EN_B_SCANDIC = 32959UL,
      FI_EN_B_STEIGENBERGER = 32960UL,
      FI_EN_B_PANNONIA = 32961UL,
      FI_EN_B_SAVOY = 32962UL,
      FI_EN_B_HYATTREGENCY = 32963UL,
      FI_EN_B_QUEENS = 32964UL,
      FI_EN_B_ERG = 32965UL,
      FI_EN_B_IP = 32966UL,
      FI_EN_B_TAMOIL = 32967UL,
      FI_EN_B_Q8 = 32968UL,
      FI_EN_B_GULF = 32969UL,
      FI_EN_B_MURCO = 32970UL,
      FI_EN_B_STAR = 32971UL,
      FI_EN_B_MARITIM = 32972UL,
      FI_EN_B_AKZENTHOTEL = 32973UL,
      FI_EN_B_FORMULE1 = 32974UL,
      FI_EN_B_FORTE = 32975UL,
      FI_EN_B_UK = 32976UL,
      FI_EN_B_SAFEWAY = 32977UL,
      FI_EN_B_BURMAH = 32978UL,
      FI_EN_B_JSAINSBURY = 32979UL,
      FI_EN_B_REPSOL = 32980UL,
      FI_EN_B_NIKKO = 32981UL,
      FI_EN_B_RISTORAGIP = 32982UL,
      FI_EN_B_MOTTA = 32983UL,
      FI_EN_B_API = 32984UL,
      FI_EN_B_FRANKLIN = 32985UL,
      FI_EN_B_ADMIRALBENBOWINN = 32986UL,
      FI_EN_B_FAMILYINN = 32987UL,
      FI_EN_B_SMOLLENSKI = 32988UL,
      FI_EN_B_CHEZGERARD = 32989UL,
      FI_EN_B_TAG = 32990UL,
      FI_EN_B_EDWARDIAN = 32991UL,
      FI_EN_B_WELCOME = 32992UL,
      FI_EN_B_SECA = 32993UL,
      FI_EN_B_ASDA = 32994UL,
      FI_EN_B_CHEVRON = 32995UL,
      FI_EN_B_OLDSMOBILE = 32996UL,
      FI_EN_B_HONDA = 32997UL,
      FI_EN_B_A_1 = 32998UL,
      FI_EN_B_AMERADAHESS = 32999UL,
      FI_EN_B_AMOCO = 33000UL,
      FI_EN_B_ARCO = 33001UL,
      FI_EN_B_ATLANTIC = 33002UL,
      FI_EN_B_BEACON = 33003UL,
      FI_EN_B_CENEX = 33004UL,
      FI_EN_B_CIRCLEX = 33005UL,
      FI_EN_B_CITGO = 33006UL,
      FI_EN_B_COASTAL = 33007UL,
      FI_EN_B_CONOCO = 33008UL,
      FI_EN_B_CROWNCENTRAL = 33009UL,
      FI_EN_B_DIAMONDSHAMROCK = 33010UL,
      FI_EN_B_EMRO = 33011UL,
      FI_EN_B_ERNIESFUELSTOP = 33012UL,
      FI_EN_B_EXXON = 33013UL,
      FI_EN_B_FARMERSUNION = 33014UL,
      FI_EN_B_FLYINGJ = 33015UL,
      FI_EN_B_GASAMATOIL = 33016UL,
      FI_EN_B_GETTY = 33017UL,
      FI_EN_B_HUNTOIL = 33018UL,
      FI_EN_B_MAPCO = 33019UL,
      FI_EN_B_MARATHON = 33020UL,
      FI_EN_B_MERIDIANOIL = 33021UL,
      FI_EN_B_MERINT = 33022UL,
      FI_EN_B_MULLINSANDPRICHARD = 33023UL,
      FI_EN_B_MURPHYOIL = 33024UL,
      FI_EN_B_PDQ = 33025UL,
      FI_EN_B_RACETRAC = 33026UL,
      FI_EN_B_REBEL = 33027UL,
      FI_EN_B_SINCLAIR = 33028UL,
      FI_EN_B_SUN = 33029UL,
      FI_EN_B_SUNOCO = 33030UL,
      FI_EN_B_TENNECO = 33031UL,
      FI_EN_B_TERRIBLEHERBST = 33032UL,
      FI_EN_B_UNIOIL = 33033UL,
      FI_EN_B_USAPETROLIUM = 33034UL,
      FI_EN_B_WESCO = 33035UL,
      FI_EN_B_ACCOR = 33036UL,
      FI_EN_B_ADAMSMARKHOTEL = 33037UL,
      FI_EN_B_BALLYSCASINOHOTEL = 33038UL,
      FI_EN_B_BESTINN = 33039UL,
      FI_EN_B_BUDGETHOSTINN = 33040UL,
      FI_EN_B_BUDGETELINN = 33041UL,
      FI_EN_B_CEARSARSWOLD = 33042UL,
      FI_EN_B_CHALETSUSSEINTERNATIONAL = 33043UL,
      FI_EN_B_CHOICEHOTELSINTERNATIONAL = 33044UL,
      FI_EN_B_CIRCUSCIRCUS = 33045UL,
      FI_EN_B_CLARION = 33046UL,
      FI_EN_B_CLUBHOUSEINN = 33047UL,
      FI_EN_B_CONSORTHOTEL = 33048UL,
      FI_EN_B_COUNTRYINN = 33049UL,
      FI_EN_B_COUNTYARDBYMARRIOTT = 33050UL,
      FI_EN_B_CROWNSTELINGSUITES = 33051UL,
      FI_EN_B_DAYSINN = 33052UL,
      FI_EN_B_DOUBLETREE = 33053UL,
      FI_EN_B_DOWNTOWNERMOTORINN = 33054UL,
      FI_EN_B_DRURYINN = 33055UL,
      FI_EN_B_EZ8MOTEL = 33056UL,
      FI_EN_B_ECONOLODGE = 33057UL,
      FI_EN_B_ECONOMYINN = 33058UL,
      FI_EN_B_ECONOMYLODGINGSYSTEMS = 33059UL,
      FI_EN_B_EMBASSYSUITES = 33060UL,
      FI_EN_B_EXELINN = 33061UL,
      FI_EN_B_FAIRFIELDINNBYMARRIOTT = 33062UL,
      FI_EN_B_FAIRMONTHOTEL = 33063UL,
      FI_EN_B_FOURSEASONS = 33064UL,
      FI_EN_B_FRIENDSHIPINN = 33065UL,
      FI_EN_B_GUESTQUATERS = 33066UL,
      FI_EN_B_HAMPTONINN = 33067UL,
      FI_EN_B_HARLEYHOTEL = 33068UL,
      FI_EN_B_HARRAHS = 33069UL,
      FI_EN_B_HARVEYHOTEL = 33070UL,
      FI_EN_B_HAWTHORN = 33071UL,
      FI_EN_B_HOMEWOODSUITES = 33072UL,
      FI_EN_B_ALLSEASONS = 33073UL,
      FI_EN_B_HOSPITALITYINTERNATIONAL = 33074UL,
      FI_EN_B_AMERIHOST = 33075UL,
      FI_EN_B_DOLLARINN = 33076UL,
      FI_EN_B_HOWARDJOHNSON = 33077UL,
      FI_EN_B_KIGHTSINN = 33078UL,
      FI_EN_B_LAQUINTAMOTORINN = 33079UL,
      FI_EN_B_LEXINGTON = 33080UL,
      FI_EN_B_LOEWSHOTEL = 33081UL,
      FI_EN_B_MASTERHOSTS = 33082UL,
      FI_EN_B_MASTERECONOMYINN = 33083UL,
      FI_EN_B_MGMGRAND = 33084UL,
      FI_EN_B_MIDWAYHOSPITALITY = 33085UL,
      FI_EN_B_MOTEL6 = 33086UL,
      FI_EN_B_OMNIHOTEL = 33087UL,
      FI_EN_B_PARKINNSINTERNATIONAL = 33088UL,
      FI_EN_B_PASSPORTINN = 33089UL,
      FI_EN_B_QUALITY = 33090UL,
      FI_EN_B_RADDISON = 33091UL,
      FI_EN_B_REDCARPETINN = 33092UL,
      FI_EN_B_REDLION = 33093UL,
      FI_EN_B_REDROOFINN = 33094UL,
      FI_EN_B_REGENTINTLHOTEL = 33095UL,
      FI_EN_B_RODEWAYINN = 33096UL,
      FI_EN_B_SCOTTISHINN = 33097UL,
      FI_EN_B_SHILOINN = 33098UL,
      FI_EN_B_SHOLODGE = 33099UL,
      FI_EN_B_SIGNATUREINN = 33100UL,
      FI_EN_B_SLEEPINN = 33101UL,
      FI_EN_B_STOUFFER = 33102UL,
      FI_EN_B_SUITEMARK = 33103UL,
      FI_EN_B_SUMMERFIELD = 33104UL,
      FI_EN_B_SUNDOWNERINTERNATIONAL = 33105UL,
      FI_EN_B_SUPER8MOTEL = 33106UL,
      FI_EN_B_HEARTLANDINN = 33107UL,
      FI_EN_B_SWISSOTELINN = 33108UL,
      FI_EN_B_THRIFTYLTD = 33109UL,
      FI_EN_B_TRAVELERSINN = 33110UL,
      FI_EN_B_TRAVELODGE = 33111UL,
      FI_EN_B_VAGABONDINN = 33112UL,
      FI_EN_B_VALUINN = 33113UL,
      FI_EN_B_VENTUREINN = 33114UL,
      FI_EN_B_WALTDISNEYWORLDRESORT = 33115UL,
      FI_EN_B_WARWICKINTLHOTEL = 33116UL,
      FI_EN_B_WESTIN = 33117UL,
      FI_EN_B_WOODFIN = 33118UL,
      FI_EN_B_WYNDHAM = 33119UL,
      FI_EN_B_LEXUS = 33120UL,
      FI_EN_B_TOYOTA = 33121UL,
      FI_EN_B_MERCEDESBENZ = 33122UL,
      FI_EN_B_ELECLERK = 33123UL,
      FI_EN_B_INTERCONTINENTAL = 33124UL,
      FI_EN_B_JARVIS = 33125UL,
      FI_EN_B_COPTHORNE = 33126UL,
      FI_EN_B_BMW = 33127UL,
      FI_EN_B_RENAULT = 33128UL,
      FI_EN_B_OPEL = 33129UL,
      FI_EN_B_VOLKSWAGEN = 33130UL,
      FI_EN_B_PEUGEOT = 33131UL,
      FI_EN_B_BALLADINS = 33132UL,
      FI_EN_B_NUITHOTEL = 33133UL,
      FI_EN_B_MIGROL = 33134UL,
      FI_EN_B_LINCOLNMERCURY = 33135UL,
      FI_EN_B_ELAN = 33136UL,
      FI_EN_B_GO = 33137UL,
      FI_EN_B_HEM = 33138UL,
      FI_EN_B_OMV = 33139UL,
      FI_EN_B_SPRINT = 33140UL,
      FI_EN_B_STATOIL = 33141UL,
      FI_EN_B_LINDNER = 33142UL,
      FI_EN_B_ROMANTIK = 33143UL,
      FI_EN_B_ROSENBERGER = 33144UL,
      FI_EN_B_WIENERWALDTOURAST = 33145UL,
      FI_EN_B_FORD = 33146UL,
      FI_EN_B_ACURA = 33147UL,
      FI_EN_B_ALFAROMEO = 33148UL,
      FI_EN_B_ASIAMOTORS = 33149UL,
      FI_EN_B_ASTONMARTIN = 33150UL,
      FI_EN_B_AUDI = 33151UL,
      FI_EN_B_BENTLEY = 33152UL,
      FI_EN_B_BUGATI = 33153UL,
      FI_EN_B_BUICK = 33154UL,
      FI_EN_B_CADILLAC = 33155UL,
      FI_EN_B_CHEVROLET = 33156UL,
      FI_EN_B_CHRYSLER = 33157UL,
      FI_EN_B_CITROEN = 33158UL,
      FI_EN_B_DAEWOO = 33159UL,
      FI_EN_B_DAIHATSU = 33160UL,
      FI_EN_B_DODGE = 33161UL,
      FI_EN_B_EAGLE = 33162UL,
      FI_EN_B_FERRARI = 33163UL,
      FI_EN_B_FIAT = 33164UL,
      FI_EN_B_FSO = 33165UL,
      FI_EN_B_GM = 33166UL,
      FI_EN_B_GMC = 33167UL,
      FI_EN_B_HYUNDAI = 33168UL,
      FI_EN_B_INFINITI = 33169UL,
      FI_EN_B_ISUZU = 33170UL,
      FI_EN_B_JAGUAR = 33171UL,
      FI_EN_B_JEEP = 33172UL,
      FI_EN_B_JENSEN = 33173UL,
      FI_EN_B_KIA = 33174UL,
      FI_EN_B_LADA = 33175UL,
      FI_EN_B_LAMBORGHINI = 33176UL,
      FI_EN_B_LANCIA = 33177UL,
      FI_EN_B_LANDROVER = 33178UL,
      FI_EN_B_LOTUS = 33179UL,
      FI_EN_B_MARCOS = 33180UL,
      FI_EN_B_MASERATI = 33181UL,
      FI_EN_B_MAZDA = 33182UL,
      FI_EN_B_MCLAREN = 33183UL,
      FI_EN_B_MEGA = 33184UL,
      FI_EN_B_MG = 33185UL,
      FI_EN_B_MITSUBISHI = 33186UL,
      FI_EN_B_MORGAN = 33187UL,
      FI_EN_B_MORRIS = 33188UL,
      FI_EN_B_NISSAN = 33189UL,
      FI_EN_B_PONTIAC = 33190UL,
      FI_EN_B_PORSCHE = 33191UL,
      FI_EN_B_ROLLSROYCE = 33192UL,
      FI_EN_B_ROVER = 33193UL,
      FI_EN_B_SAAB = 33194UL,
      FI_EN_B_SATURN = 33195UL,
      FI_EN_B_SEAT = 33196UL,
      FI_EN_B_SKODA = 33197UL,
      FI_EN_B_SSANGYONG = 33198UL,
      FI_EN_B_SUBARU = 33199UL,
      FI_EN_B_SUZUKI = 33200UL,
      FI_EN_B_TRIUMPH = 33201UL,
      FI_EN_B_TVR = 33202UL,
      FI_EN_B_VAUXHALL = 33203UL,
      FI_EN_B_VOLVO = 33204UL,
      FI_EN_B_LEESINN = 33205UL,
      FI_EN_B_SORAT = 33206UL,
      FI_EN_B_MINOTEL = 33207UL,
      FI_EN_B_KEMPINSKI = 33208UL,
      FI_EN_B_LIBERTEL = 33209UL,
      FI_EN_B_AIRPORTINN = 33210UL,
      FI_EN_B_AMBASSADOR = 33211UL,
      FI_EN_B_AMERICINNMOTEL = 33212UL,
      FI_EN_B_ATLANTICBUDGETINN = 33213UL,
      FI_EN_B_BILTMOREHOTEL = 33214UL,
      FI_EN_B_COZ8HOTEL = 33215UL,
      FI_EN_B_CORPORATELODGING = 33216UL,
      FI_EN_B_COUNTRYHEARTHINN = 33217UL,
      FI_EN_B_CRICKETINN = 33218UL,
      FI_EN_B_CROWNEPLAZA = 33219UL,
      FI_EN_B_IMA = 33220UL,
      FI_EN_B_INNSUITESHOTEL = 33221UL,
      FI_EN_B_INNKEEPER = 33222UL,
      FI_EN_B_INNSOFAMERICA = 33223UL,
      FI_EN_B_LK = 33224UL,
      FI_EN_B_MASTERSINN = 33225UL,
      FI_EN_B_MCINTOSHINN = 33226UL,
      FI_EN_B_MICROTEL = 33227UL,
      FI_EN_B_NATIONAL9MOTEL = 33228UL,
      FI_EN_B_NENDELSINN = 33229UL,
      FI_EN_B_OASISMOTEL = 33230UL,
      FI_EN_B_PARAMOUNTHOTEL = 33231UL,
      FI_EN_B_PLAZAHOTEL = 33232UL,
      FI_EN_B_RENAISSANCE = 33233UL,
      FI_EN_B_SELECTINN = 33234UL,
      FI_EN_B_SHONEYSINN = 33235UL,
      FI_EN_B_STUDIOPLUS = 33236UL,
      FI_EN_B_TRAVELINN = 33237UL,
      FI_EN_B_VILLAGEINN = 33238UL,
      FI_EN_B_WELLESLEYINN = 33239UL,
      FI_EN_B_1STOP = 33240UL,
      FI_EN_B_7ELEVEN = 33241UL,
      FI_EN_B_ALLSUPS = 33242UL,
      FI_EN_B_AMERISTOP = 33243UL,
      FI_EN_B_AMPMMINIMART = 33244UL,
      FI_EN_B_ANCHOR = 33245UL,
      FI_EN_B_ASHLAND = 33246UL,
      FI_EN_B_AUTOSTOP = 33247UL,
      FI_EN_B_BESTMART = 33248UL,
      FI_EN_B_BIG10MART = 33249UL,
      FI_EN_B_BIGD = 33250UL,
      FI_EN_B_BIGFOOT = 33251UL,
      FI_EN_B_BIGH = 33252UL,
      FI_EN_B_BLUEANDWHITESERVICE = 33253UL,
      FI_EN_B_BONDEDOIL = 33254UL,
      FI_EN_B_BRADLEY = 33255UL,
      FI_EN_B_BREAKTIME = 33256UL,
      FI_EN_B_BRYANTS = 33257UL,
      FI_EN_B_BUDGET = 33258UL,
      FI_EN_B_CANNON = 33259UL,
      FI_EN_B_CASHNDASH = 33260UL,
      FI_EN_B_CERTIFIED = 33261UL,
      FI_EN_B_CHECKER = 33262UL,
      FI_EN_B_CHRISTYSMARKET = 33263UL,
      FI_EN_B_CLARKOIL = 33264UL,
      FI_EN_B_COASTALMART = 33265UL,
      FI_EN_B_COGOS = 33266UL,
      FI_EN_B_COMPAC = 33267UL,
      FI_EN_B_CONVENIENTFOODMART = 33268UL,
      FI_EN_B_CORNERSTOP = 33269UL,
      FI_EN_B_CRYSTALFLASH = 33270UL,
      FI_EN_B_CUMBERLANDFARMS = 33271UL,
      FI_EN_B_CURTS = 33272UL,
      FI_EN_B_DAIRYMART = 33273UL,
      FI_EN_B_DAVIS = 33274UL,
      FI_EN_B_DAVISONOILANDGAS = 33275UL,
      FI_EN_B_DAYANDNIGHT = 33276UL,
      FI_EN_B_DBMART = 33277UL,
      FI_EN_B_DELIMART = 33278UL,
      FI_EN_B_DEPOT = 33279UL,
      FI_EN_B_DSIX = 33280UL,
      FI_EN_B_DUKE = 33281UL,
      FI_EN_B_DYNO = 33282UL,
      FI_EN_B_EEASTCOAST = 33283UL,
      FI_EN_B_DAYSTOP = 33284UL,
      FI_EN_B_ETNASNACKMART = 33285UL,
      FI_EN_B_EXPRESS = 33286UL,
      FI_EN_B_EXPRESSLANE = 33287UL,
      FI_EN_B_EXPRESSMART = 33288UL,
      FI_EN_B_EZGO = 33289UL,
      FI_EN_B_EZMART = 33290UL,
      FI_EN_B_EZSHOP = 33291UL,
      FI_EN_B_EZSTOP = 33292UL,
      FI_EN_B_FAMILYEXPRESS = 33293UL,
      FI_EN_B_FARMCO = 33294UL,
      FI_EN_B_FARMSTORE = 33295UL,
      FI_EN_B_FASTRIP = 33296UL,
      FI_EN_B_FASTOP = 33297UL,
      FI_EN_B_FASTSTOP = 33298UL,
      FI_EN_B_FAVORITEMARKET = 33299UL,
      FI_EN_B_FLASHFOODS = 33300UL,
      FI_EN_B_FOODMART = 33301UL,
      FI_EN_B_FOODNFUEL = 33302UL,
      FI_EN_B_FOURSTART = 33303UL,
      FI_EN_B_FRIENDLYMART = 33304UL,
      FI_EN_B_FRIENDS = 33305UL,
      FI_EN_B_GANT = 33306UL,
      FI_EN_B_GASAMERICA = 33307UL,
      FI_EN_B_GASANDGO = 33308UL,
      FI_EN_B_GASANDMINIMART = 33309UL,
      FI_EN_B_GASCENTER = 33310UL,
      FI_EN_B_GASCITY = 33311UL,
      FI_EN_B_GASLAND = 33312UL,
      FI_EN_B_GASMAN = 33313UL,
      FI_EN_B_GASMART = 33314UL,
      FI_EN_B_GASNSHOP = 33315UL,
      FI_EN_B_GATE = 33316UL,
      FI_EN_B_GIANT = 33317UL,
      FI_EN_B_GITNGO = 33318UL,
      FI_EN_B_GOLDENGALLON = 33319UL,
      FI_EN_B_HANDEEHUGOS = 33320UL,
      FI_EN_B_HANDIPLUS = 33321UL,
      FI_EN_B_HANDYANDY = 33322UL,
      FI_EN_B_HANDYMART = 33323UL,
      FI_EN_B_HANDYWAY = 33324UL,
      FI_EN_B_HESS = 33325UL,
      FI_EN_B_HOBOPANTRY = 33326UL,
      FI_EN_B_HOLIDAYMARKET = 33327UL,
      FI_EN_B_HOPIN = 33328UL,
      FI_EN_B_HUCKSFOODSTORE = 33329UL,
      FI_EN_B_ICO = 33330UL,
      FI_EN_B_INLANDFOODSTORE = 33331UL,
      FI_EN_B_JACKPOT = 33332UL,
      FI_EN_B_JETFOODSHOP = 33333UL,
      FI_EN_B_JIFFYSTOP = 33334UL,
      FI_EN_B_JRFOODMART = 33335UL,
      FI_EN_B_JRFOODSTORE = 33336UL,
      FI_EN_B_KANGAROO = 33337UL,
      FI_EN_B_KELLEYWILLIAMSON = 33338UL,
      FI_EN_B_KENTKWIK = 33339UL,
      FI_EN_B_KERRMCGEE = 33340UL,
      FI_EN_B_KOCOLENE = 33341UL,
      FI_EN_B_KUMANDGO = 33342UL,
      FI_EN_B_KWIKFILL = 33343UL,
      FI_EN_B_KWIKKING = 33344UL,
      FI_EN_B_KWIKMART = 33345UL,
      FI_EN_B_KWIKSTORE = 33346UL,
      FI_EN_B_KWIKTRIP = 33347UL,
      FI_EN_B_KWIKWAY = 33348UL,
      FI_EN_B_LAKESIDE = 33349UL,
      FI_EN_B_LILCHAMP = 33350UL,
      FI_EN_B_LITTLEGENERAL = 33351UL,
      FI_EN_B_LOVESCOUNTRYSTORE = 33352UL,
      FI_EN_B_MAJIKMARKET = 33353UL,
      FI_EN_B_MALCO = 33354UL,
      FI_EN_B_MARTINOIL = 33355UL,
      FI_EN_B_MAVERICKMARKET = 33356UL,
      FI_EN_B_MEIJER = 33357UL,
      FI_EN_B_MIDSTATESPETROLEUM = 33358UL,
      FI_EN_B_MILLER = 33359UL,
      FI_EN_B_MINIMART = 33360UL,
      FI_EN_B_MINITMART = 33361UL,
      FI_EN_B_MONARCHOIL = 33362UL,
      FI_EN_B_MRM = 33363UL,
      FI_EN_B_MRMIKES = 33364UL,
      FI_EN_B_NEIGHBORS = 33365UL,
      FI_EN_B_NICENEASY = 33366UL,
      FI_EN_B_NOCO = 33367UL,
      FI_EN_B_OCEAN = 33368UL,
      FI_EN_B_ONESTOP = 33369UL,
      FI_EN_B_OPENPANTRY = 33370UL,
      FI_EN_B_ORLOSKI = 33371UL,
      FI_EN_B_OTTOS = 33372UL,
      FI_EN_B_PACKANDSACK = 33373UL,
      FI_EN_B_PALMSPRINGSOIL = 33374UL,
      FI_EN_B_PANDM = 33375UL,
      FI_EN_B_PARMART = 33376UL,
      FI_EN_B_PATCOHANDYSHOP = 33377UL,
      FI_EN_B_PENNZMART = 33378UL,
      FI_EN_B_PEOPLES = 33379UL,
      FI_EN_B_PETROLEUM = 33380UL,
      FI_EN_B_PETROMART = 33381UL,
      FI_EN_B_PETROPANTRY = 33382UL,
      FI_EN_B_PHILLIPS66 = 33383UL,
      FI_EN_B_PILOT = 33384UL,
      FI_EN_B_PLAIDPANTRY = 33385UL,
      FI_EN_B_PRESTIGE = 33386UL,
      FI_EN_B_PRESTO = 33387UL,
      FI_EN_B_PRIDE = 33388UL,
      FI_EN_B_PRIMETIME = 33389UL,
      FI_EN_B_PRONTO = 33390UL,
      FI_EN_B_PUMPNPANTRY = 33391UL,
      FI_EN_B_QUALITYQMART = 33392UL,
      FI_EN_B_QUARLES = 33393UL,
      FI_EN_B_QUICKFUEL = 33394UL,
      FI_EN_B_QUICKSTOP = 33395UL,
      FI_EN_B_QUIKTRIP = 33396UL,
      FI_EN_B_QUICKWAY = 33397UL,
      FI_EN_B_RACEWAY = 33398UL,
      FI_EN_B_RADIANT = 33399UL,
      FI_EN_B_RAPIDROBERTS = 33400UL,
      FI_EN_B_REDAPPLE = 33401UL,
      FI_EN_B_REDDMART = 33402UL,
      FI_EN_B_REDWOOD = 33403UL,
      FI_EN_B_RENNIES = 33404UL,
      FI_EN_B_RHODES101STOP = 33405UL,
      FI_EN_B_RICKER = 33406UL,
      FI_EN_B_RIDGEWAY = 33407UL,
      FI_EN_B_RIPGRIFFIN = 33408UL,
      FI_EN_B_ROADAMERICA = 33409UL,
      FI_EN_B_ROBERTSOIL = 33410UL,
      FI_EN_B_ROTTENROBBIE = 33411UL,
      FI_EN_B_RPM = 33412UL,
      FI_EN_B_SANESCO = 33413UL,
      FI_EN_B_SANTEFEMARKET = 33414UL,
      FI_EN_B_SAVASTOP = 33415UL,
      FI_EN_B_SAVOMAT = 33416UL,
      FI_EN_B_SCHRADER = 33417UL,
      FI_EN_B_SCOT = 33418UL,
      FI_EN_B_SCOTCHMAN = 33419UL,
      FI_EN_B_SENTRYFOODMART = 33420UL,
      FI_EN_B_SHEETZ = 33421UL,
      FI_EN_B_SHOPNGO = 33422UL,
      FI_EN_B_SICO = 33423UL,
      FI_EN_B_SMILEGAS = 33424UL,
      FI_EN_B_SPARKYS = 33425UL,
      FI_EN_B_SPECTRUM = 33426UL,
      FI_EN_B_SPEEDWAY = 33427UL,
      FI_EN_B_SPUR = 33428UL,
      FI_EN_B_SANDSFOODSTORE = 33429UL,
      FI_EN_B_STANDARD = 33430UL,
      FI_EN_B_STEWARTS = 33431UL,
      FI_EN_B_STINKERSTATION = 33432UL,
      FI_EN_B_STOPIN = 33433UL,
      FI_EN_B_STOPNGO = 33434UL,
      FI_EN_B_STOPNSAVE = 33435UL,
      FI_EN_B_STUCKEYS = 33436UL,
      FI_EN_B_SUGARCREEKSTORE = 33437UL,
      FI_EN_B_SUNGLO = 33438UL,
      FI_EN_B_SUNNY = 33439UL,
      FI_EN_B_SUNRISE = 33440UL,
      FI_EN_B_SUPERAMERICA = 33441UL,
      FI_EN_B_SUPERMART = 33442UL,
      FI_EN_B_SUPERPUMPER = 33443UL,
      FI_EN_B_SUPERSTOP = 33444UL,
      FI_EN_B_SUPERSHOP = 33445UL,
      FI_EN_B_SUWANNEESWIFTYSTORE = 33446UL,
      FI_EN_B_SWIFTY = 33447UL,
      FI_EN_B_THECOUNTRYSTORE = 33448UL,
      FI_EN_B_THEPANTRY = 33449UL,
      FI_EN_B_THESTORE = 33450UL,
      FI_EN_B_THORNTONOIL = 33451UL,
      FI_EN_B_THRIFTWAY = 33452UL,
      FI_EN_B_TIGERMART = 33453UL,
      FI_EN_B_TOMTHUMB = 33454UL,
      FI_EN_B_TOWNANDCOUNTRY = 33455UL,
      FI_EN_B_TOWNSTARSTORE = 33456UL,
      FI_EN_B_TREX = 33457UL,
      FI_EN_B_UGASUM = 33458UL,
      FI_EN_B_ULTRAMAR = 33459UL,
      FI_EN_B_UNIMART = 33460UL,
      FI_EN_B_UNITEDDAIRYFARMERS = 33461UL,
      FI_EN_B_UNITEDOIL = 33462UL,
      FI_EN_B_UNIONUNOCAL76 = 33463UL,
      FI_EN_B_UPUMPIT = 33464UL,
      FI_EN_B_VILLAGEPANTRY = 33465UL,
      FI_EN_B_WACO = 33466UL,
      FI_EN_B_WARECO = 33467UL,
      FI_EN_B_WAWA = 33468UL,
      FI_EN_B_WEBBERENERGYFUELS = 33469UL,
      FI_EN_B_WHITING = 33470UL,
      FI_EN_B_WILCO = 33471UL,
      FI_EN_B_WILLIAMS = 33472UL,
      FI_EN_B_XPRESSFUELS = 33473UL,
      FI_EN_B_XTRAMART = 33474UL,
      FI_EN_B_YOUNGS = 33475UL,
      FI_EN_B_HERITAGEINN = 33476UL,
      FI_EN_B_HOMEPLACEINN = 33477UL,
      FI_EN_B_THRIFTLODGE = 33478UL,
      FI_EN_B_THRIFTY = 33479UL,
      FI_EN_B_AVANTI = 33480UL,
      FI_EN_B_COOPOK = 33481UL,
      FI_EN_B_BANDB = 33482UL,
      FI_EN_B_BONSAUHOTEL = 33483UL,
      FI_EN_B_ETAPHOTEL = 33484UL,
      FI_EN_B_FRANTOUR = 33485UL,
      FI_EN_B_MARMOTTE = 33486UL,
      FI_EN_B_PREMIERECLASSE = 33487UL,
      FI_EN_B_VILLAGESHOTEL = 33488UL,
      FI_EN_B_ARCANTIS = 33489UL,
      FI_EN_B_CHATEAUXANDHOTELSDEFRANCE = 33490UL,
      FI_EN_B_ETAPESHOTELIERSCORSES = 33491UL,
      FI_EN_B_EUROSTARTHOTUSA = 33492UL,
      FI_EN_B_ELYSEEWESTHOTEL = 33493UL,
      FI_EN_B_HERALDUS = 33494UL,
      FI_EN_B_HOTELSDUGRANDSUD = 33495UL,
      FI_EN_B_LOGISDEFRANCE = 33496UL,
      FI_EN_B_MOULINETAPE = 33497UL,
      FI_EN_B_NEOTEL = 33498UL,
      FI_EN_B_NIDSDEFRANCE = 33499UL,
      FI_EN_B_RELAISDESILENCE = 33500UL,
      FI_EN_B_RELAISANDCHATEAUX = 33501UL,
      FI_EN_B_WELCOMESWISSHOTELS = 33502UL,
      FI_EN_B_ALPINE = 33503UL,
      FI_EN_B_EANDGHOTELSSCHWEIZ = 33504UL,
      FI_EN_B_INTEREUROPEHOTEL = 33505UL,
      FI_EN_B_SWISSLEADINGHOTEL = 33506UL,
      FI_EN_B_TOPINTERNATIONALHOTEL = 33507UL,
      FI_EN_B_GENOL = 33508UL,
      FI_EN_B_STROH = 33509UL,
      FI_EN_B_TURMOEL = 33510UL,
      FI_EN_B_RUEHL = 33511UL,
      FI_EN_B_ASTRON = 33512UL,
      FI_EN_B_REMAHOTELS = 33513UL,
      FI_EN_B_SENATOR = 33514UL,
      FI_EN_B_STARHOTEL = 33515UL,
      FI_EN_B_TREFFHOTELS = 33516UL,
      FI_EN_B_AGROLA = 33517UL,
      FI_EN_B_DYNEFF = 33518UL,
      FI_EN_B_SAVE = 33519UL,
      FI_EN_B_AC = 33520UL,
      FI_EN_B_VANDERVALK = 33521UL,
      FI_EN_B_POSTILJON = 33522UL,
      FI_EN_B_SCORE = 33523UL,
      FI_EN_B_STAKIS = 33524UL,
      FI_EN_B_CANADIANPACIFIC = 33525UL,
      FI_EN_B_COAST = 33526UL,
      FI_EN_B_DELTA = 33527UL,
      FI_EN_B_HOTELDESGOUVERNEURS = 33528UL,
      FI_EN_B_JOURNEYSEND = 33529UL,
      FI_EN_B_SANDMAN = 33530UL,
      FI_EN_B_WANDLYN = 33531UL,
      FI_EN_B_BEAVER = 33532UL,
      FI_EN_B_CANADIANTIRE = 33533UL,
      FI_EN_B_CANGO = 33534UL,
      FI_EN_B_GASRITE = 33535UL,
      FI_EN_B_HUSKY = 33536UL,
      FI_EN_B_IRVING = 33537UL,
      FI_EN_B_MRGAS = 33538UL,
      FI_EN_B_OLCO = 33539UL,
      FI_EN_B_PAYLESS = 33540UL,
      FI_EN_B_PENNY = 33541UL,
      FI_EN_B_PETROCANADA = 33542UL,
      FI_EN_B_PIONEER = 33543UL,
      FI_EN_B_SUNNYS = 33544UL,
      FI_EN_B_SUPERSAVE = 33545UL,
      FI_EN_B_TURBO = 33546UL,
      FI_EN_B_COUNTRYSIDEINNS = 33547UL,
      FI_EN_B_COUNTRY = 33548UL,
      FI_EN_B_FORTEHERITAGE = 33549UL,
      FI_EN_B_FORTEPOSTHOUSE = 33550UL,
      FI_EN_B_FOWNES = 33551UL,
      FI_EN_B_FRIENDLYHOTELSCOMFORTINNS = 33552UL,
      FI_EN_B_FRIENDLYHOTELSQUALITYINNS = 33553UL,
      FI_EN_B_INDEPENDENTS = 33554UL,
      FI_EN_B_LGIS = 33555UL,
      FI_EN_B_LYRIC = 33556UL,
      FI_EN_B_MACDONALD = 33557UL,
      FI_EN_B_MARSTON = 33558UL,
      FI_EN_B_MENZIES = 33559UL,
      FI_EN_B_MILLENIUMANDCOPTHORNE = 33560UL,
      FI_EN_B_MOATHOUSEHOTELS = 33561UL,
      FI_EN_B_PRIDEOFBRITAIN = 33562UL,
      FI_EN_B_PRINCIPAL = 33563UL,
      FI_EN_B_QUEENSMOATHOUSE = 33564UL,
      FI_EN_B_REGAL = 33565UL,
      FI_EN_B_ROADCHEF = 33566UL,
      FI_EN_B_SCOTLANDSCOMMENDED = 33567UL,
      FI_EN_B_SCOTTISHHIGHLAND = 33568UL,
      FI_EN_B_SCOTTISHANDNEWCASTLE = 33569UL,
      FI_EN_B_SHIRE = 33570UL,
      FI_EN_B_SMALLLUXURYHOTELS = 33571UL,
      FI_EN_B_SWALLOW = 33572UL,
      FI_EN_B_THISTLE = 33573UL,
      FI_EN_B_TOBY = 33574UL,
      FI_EN_B_VIRGINCOLLECTION = 33575UL,
      FI_EN_B_ANGLO = 33576UL,
      FI_EN_B_BUTLER = 33577UL,
      FI_EN_B_PROTEUS = 33578UL,
      FI_EN_B_BRITISHFUELSLIMITED = 33579UL,
      FI_EN_B_RIX = 33580UL,
      FI_EN_B_POWER = 33581UL,
      FI_EN_B_OK = 33582UL,
      FI_EN_B_PREEM = 33583UL,
      FI_EN_B_NORSKHYDRO = 33584UL,
      FI_EN_B_DINX = 33585UL,
      FI_EN_B_UNOX = 33586UL,
      FI_EN_B_NESTE = 33587UL,
      FI_EN_B_TEBOIL = 33588UL,
      FI_EN_B_ATAC = 33589UL,
      FI_EN_B_INTERMARCHE = 33590UL,
      FI_EN_B_MAMMOUTH = 33591UL,
      FI_EN_B_MONTEDISON = 33592UL,
      FI_EN_B_KESOIL = 33593UL,
      FI_EN_B_MPSA = 33594UL,
      FI_EN_B_GALP = 33595UL,
      FI_EN_B_PETROCAT = 33596UL,
      FI_EN_B_PETRONOR = 33597UL,
      FI_EN_B_IDS = 33598UL,
      FI_EN_B_MEROIL = 33599UL,
      FI_EN_B_NH = 33600UL,
      FI_EN_B_STARVINMARVIN = 33601UL,
      FI_EN_B_CROWN = 33602UL,
      FI_EN_B_EZSERVE = 33603UL,
      FI_EN_B_PANTRY = 33604UL,
      FI_EN_B_HANDYPANTRY = 33605UL,
      FI_EN_B_BASTION = 33606UL,
      FI_EN_B_CAMPSA = 33607UL,
      FI_EN_B_HYDROTEXACO = 33608UL,
      FI_EN_B_KAI = 33609UL,
      FI_EN_B_AMERISUITES = 33610UL,
      FI_EN_B_DELUXINN = 33611UL,
      FI_EN_B_EXECUTIVEINN = 33612UL,
      FI_EN_B_GREATWESTERNINN = 33613UL,
      FI_EN_B_HOMESTEADVILLAGE = 33614UL,
      FI_EN_B_STRATFORDHOUSEINN = 33615UL,
      FI_EN_B_WILSONWORLDHOTEL = 33616UL,
      FI_EN_B_BLEUMARINE = 33617UL,
      FI_EN_B_CLARINE = 33618UL,
      FI_EN_B_FASTHOTEL = 33619UL,
      FI_EN_B_SOLMELIA = 33620UL,
      FI_EN_B_AUCHAN = 33621UL,
      FI_EN_B_CEDICO = 33622UL,
      FI_EN_B_CHAMPION = 33623UL,
      FI_EN_B_CLUB = 33624UL,
      FI_EN_B_DCA = 33625UL,
      FI_EN_B_DESMETANDVANDIEST = 33626UL,
      FI_EN_B_LESMOUSQUETAIRES = 33627UL,
      FI_EN_B_NORDPICARDIECARBURANT = 33628UL,
      FI_EN_B_SHOPI = 33629UL,
      FI_EN_B_CABINN = 33630UL,
      FI_EN_B_DANSKKROFERIE = 33631UL,
      FI_EN_B_FIRSTHOTELS = 33632UL,
      FI_EN_B_GOODMORNINGHOTELS = 33633UL,
      FI_EN_B_INTERDAN = 33634UL,
      FI_EN_B_LARSENHOTELOGKROFERIE = 33635UL,
      FI_EN_B_PROVOBISHOTELS = 33636UL,
      FI_EN_B_SWEDENHOTELS = 33637UL,
      FI_EN_B_DKBENZIN = 33638UL,
      FI_EN_B_HAAHR = 33639UL,
      FI_EN_B_METEX = 33640UL,
      FI_EN_B_ASTOTEL = 33641UL,
      FI_EN_B_PREMIERLODGE = 33642UL,
      FI_EN_B_NATIONAL = 33643UL,
      FI_EN_B_OAK = 33644UL,
      FI_EN_B_ED = 33645UL,
      FI_EN_B_ELLERMONTAN = 33646UL,
      FI_EN_B_METROPOLITAN = 33647UL,
      FI_EN_B_STAYNSAVE = 33648UL,
      FI_EN_B_SUTTONPLACE = 33649UL,
      FI_EN_B_CREVIER = 33650UL,
      FI_EN_B_DOMO = 33651UL,
      FI_EN_B_MOHAWK = 33652UL,
      FI_EN_B_PAYRITE = 33653UL,
      FI_EN_B_REALCANADIANSUPERSTORE = 33654UL,
      FI_EN_B_SERGAZ = 33655UL,
      FI_EN_B_STINSON = 33656UL,
      FI_EN_B_TEMPO = 33657UL,
      FI_EN_B_TRUVALUE = 33658UL,
      FI_EN_B_XL = 33659UL,
      FI_EN_B_CITADINESAPPARTHOTELS = 33660UL,
      FI_EN_B_CORA = 33661UL,
      FI_EN_B_GEANT = 33662UL,
      FI_EN_B_GLEANER = 33663UL,
      FI_EN_B_GLOBE = 33664UL,
      FI_EN_B_IMPERIAL = 33665UL,
      FI_EN_B_MARTENS = 33666UL,
      FI_EN_B_MATCH = 33667UL,
      FI_EN_B_PS = 33668UL,
      FI_EN_B_SPARTAN = 33669UL,
      FI_EN_B_SPOT = 33670UL,
      FI_EN_B_THAMES = 33671UL,
      FI_EN_B_THRUST = 33672UL,
      FI_EN_B_WCF = 33673UL,
      FI_EN_B_CEPSAELF = 33674UL,
      FI_EN_B_EXEL = 33675UL,
      FI_EN_B_ENGEN = 33676UL,
      FI_EN_B_CALTEX = 33677UL,
      FI_EN_B_ZENEX = 33678UL,
      FI_EN_B_AFRICOIL = 33679UL,
      FI_EN_B_OKQ8 = 33680UL,
      FI_EN_B_FLAIRHOTEL = 33681UL,
      FI_EN_B_BILISTEN = 33682UL,
      FI_EN_B_ICABENSIN = 33683UL,
      FI_EN_B_SUPERU = 33684UL,
      FI_EN_B_SAROIL = 33685UL,
      FI_EN_B_TRYP = 33686UL,
      FI_EN_B_ECOMARCHE = 33687UL,
      FI_EN_B_SP = 33688UL,
      FI_EN_B_ABACOLI = 33689UL,
      FI_EN_B_EROSKI = 33690UL,
      FI_EN_B_PARADORNACIONAL = 33691UL,
      FI_EN_B_POUSADA = 33692UL,
      FI_EN_B_PETROGAL = 33693UL,
      FI_EN_B_CONTACTHOTEL = 33694UL,
      FI_EN_B_CITOTEL = 33695UL,
      FI_EN_B_AUSTRIATREND = 33696UL,
      FI_EN_B_ARMORINE = 33697UL,
      FI_EN_B_NERVOL = 33698UL,
      FI_EN_B_LIBRECO = 33699UL,
      FI_EN_B_QUICKPALACE = 33700UL,
      FI_EN_B_CALPAM = 33701UL,
      FI_EN_B_MAXOL = 33702UL,
      FI_EN_B_FLARE = 33703UL,
      FI_EN_B_IDEMITSU = 33704UL,
      FI_EN_B_TOPOIL = 33705UL,
      FI_EN_B_HESPERIA = 33706UL,
      FI_EN_B_TULIPINN = 33707UL,
      FI_EN_B_COMOD = 33708UL,
      FI_EN_B_KYRIADHOTEL = 33709UL,
      FI_EN_B_CHARVET = 33710UL,
      FI_EN_B_SEO = 33711UL,
      FI_EN_B_MUNDORF = 33712UL,
      FI_EN_B_EEURO = 33713UL,
      FI_EN_B_NORLANDIA = 33714UL,
      FI_EN_B_RAINBOW = 33715UL,
      FI_EN_B_RICA = 33716UL,
      FI_EN_B_CUMULUS = 33717UL,
      FI_EN_B_LAPPIAHOTELS = 33718UL,
      FI_EN_B_SOKOSHOTELS = 33719UL,
      FI_EN_B_RIVOLIHOTELS = 33720UL,
      FI_EN_B_HUSA = 33721UL,
      FI_EN_B_VALERO = 33722UL,
      FI_EN_B_SERCOTEL = 33723UL,
      FI_EN_B_SILKEN = 33724UL,
      FI_EN_B_GOLDENARCH = 33725UL,
      FI_EN_B_BLUEBANDHOTELS = 33726UL,
      FI_EN_B_VIKTORS = 33727UL,
      FI_EN_B_FINLANDIAHOTELS = 33728UL,
      FI_EN_B_OIL = 33729UL,
      FI_EN_B_EM = 33730UL,
      FI_EN_B_JURYS = 33731UL,
      FI_EN_B_PROTEAHOTEL = 33732UL,
      FI_EN_B_PARKPLAZA = 33733UL,
      FI_EN_B_BENZINA = 33734UL,
      FI_EN_B_MINI = 33735UL,
      FI_EN_B_TOTALFINA = 33736UL,
      FI_EN_B_CHARMETTES = 33737UL,
      FI_EN_B_BARCELOHOTELS = 33738UL,
      FI_EN_B_RIUHOTELS = 33739UL,
      FI_EN_B_IBEROSTAR = 33740UL,
      FI_EN_B_FASSBINDHOTELS = 33741UL,
      FI_EN_B_IDYLLHOTELSSCHWEIZ = 33742UL,
      FI_EN_B_KIDSHOTELS = 33743UL,
      FI_EN_B_MANOTEL = 33744UL,
      FI_EN_B_SELECTIONSUISSE = 33745UL,
      FI_EN_B_SUNSTARHOTELS = 33746UL,
      FI_EN_B_SWISSDELUXEHOTELS = 33747UL,
      FI_EN_B_SWISSINTERNATIONALHOTELS = 33748UL,
      FI_EN_B_TURICUM = 33749UL,
      FI_EN_B_LIANA = 33750UL,
      FI_EN_B_PAPOIL = 33751UL,
      FI_EN_B_PARAMO = 33752UL,
      FI_EN_B_PETRA = 33753UL,
      FI_EN_B_ROBINOIL = 33754UL,
      FI_EN_B_SLOVNAFT = 33755UL,
      FI_EN_B_LAGERHAUS = 33756UL,
      FI_EN_B_IQ = 33757UL,
      FI_EN_B_BIM = 33758UL,
      FI_EN_B_TANGO = 33759UL,
      FI_EN_B_PHOENIX = 33760UL,
      FI_EN_B_TOP = 33761UL,
      FI_EN_B_AWI = 33762UL,
      FI_EN_B_AVIOLAMP = 33763UL,
      FI_EN_B_JOLLYHOTEL = 33764UL,
      FI_EN_B_RAIFFEISEN = 33765UL,
      FI_EN_B_HAI = 33766UL,
      FI_EN_B_TESORO = 33767UL,
      FI_EN_B_AUSTRIACLASSIC = 33768UL,
      FI_EN_B_LANDIDYLL = 33769UL,
      FI_EN_B_ARABELLESHERATON = 33770UL,
      FI_EN_B_RAMADATREFF = 33771UL,
      FI_EN_B_FOURPOINTS = 33772UL,
      FI_EN_B_RAMADAJARVIS = 33773UL,
      FI_EN_B_ADNOC_FOD = 33774UL,
      FI_EN_B_EMARAT = 33775UL,
      FI_EN_B_EMIRATES = 33776UL,
      FI_EN_B_ENOC = 33777UL,
      FI_EN_B_EPPCO = 33778UL,
      FI_EN_B_KNPC = 33779UL,
      FI_EN_B_NAFT = 33780UL,
      FI_EN_B_ALDREES = 33781UL,
      FI_EN_B_BANOCO = 33782UL,
      FI_EN_B_SARAS = 33783UL,
      FI_EN_B_CHRYSLERFIVESTAR = 33784UL,
      FI_EN_B_DODGEFIVESTAR = 33785UL,
      FI_EN_B_JEEPFIVESTAR = 33786UL,
      FI_EN_B_OCTAPLUS = 33787UL,
      FI_EN_B_NORDOEL = 33788UL,
      FI_EN_B_CLASSIC = 33789UL,
      FI_EN_B_ENEOS = 33790UL,
      FI_EN_B_IDEMITSUKOSAN = 33791UL,
      FI_EN_B_COSMO = 33792UL,
      FI_EN_B_SHOWASHELL = 33793UL,
      FI_EN_B_JOMO = 33794UL,
      FI_EN_B_GENERAL = 33795UL,
      FI_EN_B_KIGNAS = 33796UL,
      FI_EN_B_KYUSYUSEKIYU = 33797UL,
      FI_EN_B_MITSUISEKIYU = 33798UL,
      FI_EN_B_TAIYOSEKIYU = 33799UL,
      FI_EN_B_AEGEAN = 33800UL,
      FI_EN_B_AVIN = 33801UL,
      FI_EN_B_CYCLON = 33802UL,
      FI_EN_B_DRACOIL = 33803UL,
      FI_EN_B_EKO = 33804UL,
      FI_EN_B_EL = 33805UL,
      FI_EN_B_ETEKA = 33806UL,
      FI_EN_B_SWISSBUDGETHOTELS = 33807UL,
      FI_EN_B_TINQ = 33808UL,
      FI_EN_B_MAYBACH = 33809UL,
      FI_EN_B_HUMMER = 33810UL,
      FI_EN_B_MALANNOODLES = 33811UL,
      FI_EN_B_YONGHESOYBEANMILKKING = 33812UL,
      FI_EN_B_AANDW = 33813UL,
      FI_EN_B_ROASTERS = 33814UL,
      FI_EN_B_DOMINOS = 33815UL,
      FI_EN_B_SUBWAY = 33816UL,
      FI_EN_B_FUJANINDUSTRIALBANK = 33817UL,
      FI_EN_B_HUANRUN = 33818UL,
      FI_EN_B_WALMART = 33819UL,
      FI_EN_B_PRICESMART = 33820UL,
      FI_EN_B_SHANGHAIPUDONGDEVELOPMENTBANK = 33821UL,
      FI_EN_B_HUALIAN = 33822UL,
      FI_EN_B_GLORIA = 33823UL,
      FI_EN_B_GRANDHYATT = 33824UL,
      FI_EN_B_GREENTREEINN = 33825UL,
      FI_EN_B_GUANGDONG = 33826UL,
      FI_EN_B_HANTINGHOTEL = 33827UL,
      FI_EN_B_HARBOURPLAZA = 33828UL,
      FI_EN_B_HNAHOTEL = 33829UL,
      FI_EN_B_HOLIDAYINNEXPRESS = 33830UL,
      FI_EN_B_JINJIANG = 33831UL,
      FI_EN_B_JINJIANGINN = 33832UL,
      FI_EN_B_JINLING = 33833UL,
      FI_EN_B_MOTEL168 = 33834UL,
      FI_EN_B_NEWCENTURY = 33835UL,
      FI_EN_B_SHANGRILA = 33836UL,
      FI_EN_B_TOPSTARHOTEL = 33837UL,
      FI_EN_B_TREASUREHOTEL = 33838UL,
      FI_EN_B_XICUIZL = 33839UL,
      FI_EN_B_XINYUZHIXINGHOTEL = 33840UL,
      FI_EN_B_AJISENRAMEN = 33841UL,
      FI_EN_B_DICOS = 33842UL,
      FI_EN_B_LAOJIABAKEMEAT = 33843UL,
      FI_EN_B_CHINARESOURCES = 33844UL,
      FI_EN_B_INDUSTRIALBANK = 33845UL,
      FI_EN_B_HANGSEN = 33846UL,
      FI_EN_B_WINGHANG = 33847UL,
      FI_EN_B_DBS = 33848UL,
      FI_EN_B_BANKOFEASTASIA = 33849UL,
      FI_EN_B_HONGQI = 33850UL,
      FI_EN_B_HOYODO = 33851UL,
      FI_EN_B_EASEINN = 33852UL,
      FI_EN_B_HUALIANSHANGHAIHUALIAN = 33853UL,
      FI_EN_B_HUHUI = 33854UL,
      FI_EN_B_JIADELI = 33855UL,
      FI_EN_B_JINGGONG = 33856UL,
      FI_EN_B_LIANHUA = 33857UL,
      FI_EN_B_MINRUN = 33858UL,
      FI_EN_B_NONGGONGSHANG = 33859UL,
      FI_EN_B_SUGUO = 33860UL,
      FI_EN_B_CELEBRITYCITY = 33861UL,
      FI_EN_B_WUMART = 33862UL,
      FI_EN_B_ZHONGBAI = 33863UL,
      FI_EN_B_MANNINGS = 33864UL,
      FI_EN_B_ASWASTONGROUP = 33865UL,
      FI_EN_B_WELLCOME = 33866UL,
      FI_EN_B_BARONY = 33867UL,
      FI_EN_B_HOMEINN = 33868UL,
      FI_EN_B_EASYINN = 33869UL,
      FI_EN_B_CONIFER = 33871UL,
      FI_EN_B_EASEHOTEL = 33872UL,
      FI_EN_B_TRUSTMART = 33873UL,
      FI_EN_BN_087_JALTA = 33880UL,
      FI_EN_BN_1_POTATO_2 = 33881UL,
      FI_EN_BN_101_DROGERIE = 33882UL,
      FI_EN_BN_01022003 = 33883UL,
      FI_EN_BN_241_PIZZA = 33884UL,
      FI_EN_BN_345_STORE = 33885UL,
      FI_EN_BN_36_6 = 33886UL,
      FI_EN_BN_5_MARINOPOULOS = 33887UL,
      FI_EN_BN_76 = 33888UL,
      FI_EN_BN_8_A_HUIT = 33889UL,
      FI_EN_BN_99_RESTAURANT = 33890UL,
      FI_EN_BN_A_BANK = 33891UL,
      FI_EN_BN_A_CASCATA = 33892UL,
      FI_EN_BN_A_O = 33893UL,
      FI_EN_BN_A_P = 33894UL,
      FI_EN_BN_A_W = 33895UL,
      FI_EN_BN_A_C_SANTOS = 33896UL,
      FI_EN_BN_A24 = 33897UL,
      FI_EN_BN_AAA_RENT_A_CAR = 33898UL,
      FI_EN_BN_AACHENER_BANK_EG = 33899UL,
      FI_EN_BN_AALT_AUTO_LOCATION_ROMANDIE_SA = 33900UL,
      FI_EN_BN_AAMCO_TRANSMISSIONS = 33901UL,
      FI_EN_BN_AARGAUISCHE_KANTONALBANK = 33902UL,
      FI_EN_BN_AB_HOTELS = 33903UL,
      FI_EN_BN_AB_VASSILOPOULOS = 33904UL,
      FI_EN_BN_ABA_PIKNIK = 33905UL,
      FI_EN_BN_ABACO = 33906UL,
      FI_EN_BN_ABANKA_VIPA = 33907UL,
      FI_EN_BN_ABBA_HOTELS = 33908UL,
      FI_EN_BN_ABBEY = 33909UL,
      FI_EN_BN_ABC_FINE_WINE_SPIRITS = 33910UL,
      FI_EN_BN_ABC = 33911UL,
      FI_EN_BN_ABERCROMBIE_FITCH = 33912UL,
      FI_EN_BN_ABK = 33913UL,
      FI_EN_BN_ABN_AMRO = 33914UL,
      FI_EN_BN_ABRA_AUTOBODY_GLASS = 33915UL,
      FI_EN_BN_ABSA = 33916UL,
      FI_EN_BN_ABSOLYUT_BANK = 33917UL,
      FI_EN_BN_ABU_DHABI_COMMERCIAL_BANK = 33918UL,
      FI_EN_BN_ABU_DIYAB = 33919UL,
      FI_EN_BN_AC_RESTAURANTS = 33920UL,
      FI_EN_BN_ACAPULCO_MEXICAN_RESTAURANT = 33921UL,
      FI_EN_BN_ACCBANK = 33922UL,
      FI_EN_BN_ACCENT_INN = 33923UL,
      FI_EN_BN_ACCESS_BANK = 33924UL,
      FI_EN_BN_ACCESSORIZE = 33925UL,
      FI_EN_BN_ACCIDENT_REPAIR_CENTRE = 33926UL,
      FI_EN_BN_ACE_CO_OP_BANK = 33927UL,
      FI_EN_BN_ACE_PARKING = 33928UL,
      FI_EN_BN_ACE_RENT_A_CAR = 33929UL,
      FI_EN_BN_ACHILLEAS_ACCESSORIES = 33930UL,
      FI_EN_BN_ACME_MARKETS = 33931UL,
      FI_EN_BN_ACTION = 33932UL,
      FI_EN_BN_ACTIVE_GREEN_ROSS = 33933UL,
      FI_EN_BN_ACTIVOBANK = 33934UL,
      FI_EN_BN_AD_DELHAIZE = 33935UL,
      FI_EN_BN_ADA = 33936UL,
      FI_EN_BN_ADABANK = 33937UL,
      FI_EN_BN_ADAC_AUTOVERMIETUNG = 33938UL,
      FI_EN_BN_ADAGIO_CITY_APARTHOTEL = 33939UL,
      FI_EN_BN_ADANA_SOFRASI = 33940UL,
      FI_EN_BN_ADEG = 33941UL,
      FI_EN_BN_ADESE = 33942UL,
      FI_EN_BN_ADESSA = 33943UL,
      FI_EN_BN_ADLER = 33944UL,
      FI_EN_BN_ADNOC = 33945UL,
      FI_EN_BN_ADRIA_BANK = 33946UL,
      FI_EN_BN_ADVANCE_AUTO_PARTS = 33947UL,
      FI_EN_BN_ADVANCED_AUTOMOTIVE = 33948UL,
      FI_EN_BN_AEROPOSTALE = 33949UL,
      FI_EN_BN_AEROSOLES = 33950UL,
      FI_EN_BN_AFIRME = 33951UL,
      FI_EN_BN_AFRA = 33952UL,
      FI_EN_BN_AFRIBANK_NIGERIA = 33953UL,
      FI_EN_BN_AFRICAN_BANK = 33954UL,
      FI_EN_BN_AFRIQUIA = 33955UL,
      FI_EN_BN_AG_S = 33956UL,
      FI_EN_BN_AGON = 33957UL,
      FI_EN_BN_AGUNG_RENT_A_CAR = 33958UL,
      FI_EN_BN_AHOLD = 33959UL,
      FI_EN_BN_AHORRAMAS = 33960UL,
      FI_EN_BN_AHUMADA = 33961UL,
      FI_EN_BN_AIG_BANK_POLSKA_SA = 33962UL,
      FI_EN_BN_AIROTEL = 33963UL,
      FI_EN_BN_AIZKRAUKLES_BANKA_LATVIJA = 33964UL,
      FI_EN_BN_AK_BARS = 33965UL,
      FI_EN_BN_AKBANK = 33966UL,
      FI_EN_BN_AKENA_HOTEL = 33967UL,
      FI_EN_BN_AKI = 33968UL,
      FI_EN_BN_AKO = 33969UL,
      FI_EN_BN_AKPET = 33970UL,
      FI_EN_BN_AKS = 33971UL,
      FI_EN_BN_AKYURT = 33972UL,
      FI_EN_BN_AL_ABRAAJ = 33973UL,
      FI_EN_BN_AL_AHALI = 33974UL,
      FI_EN_BN_AL_BAIK = 33975UL,
      FI_EN_BN_AL_MAHA = 33976UL,
      FI_EN_BN_AL_REHILY = 33977UL,
      FI_EN_BN_AL_SAFI = 33978UL,
      FI_EN_BN_AL_TAZAJ = 33979UL,
      FI_EN_BN_ALABAMA_NBC = 33980UL,
      FI_EN_BN_ALADDINS_EATERY = 33981UL,
      FI_EN_BN_ALADO = 33982UL,
      FI_EN_BN_ALAMO = 33983UL,
      FI_EN_BN_ALBARAKA_TURK = 33984UL,
      FI_EN_BN_ALBERT_HEIJN = 33985UL,
      FI_EN_BN_ALBERT = 33986UL,
      FI_EN_BN_ALBERTSONS_PHARMACY = 33987UL,
      FI_EN_BN_ALBERTSONS = 33988UL,
      FI_EN_BN_ALCAMPO = 33989UL,
      FI_EN_BN_ALDI = 33990UL,
      FI_EN_BN_ALDO = 33991UL,
      FI_EN_BN_ALE = 33992UL,
      FI_EN_BN_ALEMAGNA = 33993UL,
      FI_EN_BN_ALEPA = 33994UL,
      FI_EN_BN_ALEXI_ANDRIOTTI = 33995UL,
      FI_EN_BN_ALFA_MART = 33996UL,
      FI_EN_BN_ALFA_BANK = 33997UL,
      FI_EN_BN_ALIMENTA = 33998UL,
      FI_EN_BN_ALIMERKA = 33999UL,
      FI_EN_BN_ALIMEX = 34000UL,
      FI_EN_BN_ALINEA = 34001UL,
      FI_EN_BN_ALIOR_BANK = 34002UL,
      FI_EN_BN_ALIPROX = 34003UL,
      FI_EN_BN_ALISUPER = 34004UL,
      FI_EN_BN_ALL_SEASONS_EUROPE = 34005UL,
      FI_EN_BN_ALL_TUNE_LUBE = 34006UL,
      FI_EN_BN_ALLAHABAD_BANK = 34007UL,
      FI_EN_BN_ALLIANCE_LEICESTER = 34008UL,
      FI_EN_BN_ALLIED_IRISH_BANK = 34009UL,
      FI_EN_BN_ALLIED_TIRES_SERVICE = 34010UL,
      FI_EN_BN_ALLO_TELECOM = 34011UL,
      FI_EN_BN_ALM_BRAND = 34012UL,
      FI_EN_BN_ALMA_MARKET = 34013UL,
      FI_EN_BN_ALNATURA = 34014UL,
      FI_EN_BN_ALOC_CARS = 34015UL,
      FI_EN_BN_ALOFT = 34016UL,
      FI_EN_BN_ALOHA = 34017UL,
      FI_EN_BN_ALOUETTE = 34018UL,
      FI_EN_BN_ALPARK = 34019UL,
      FI_EN_BN_ALPET = 34020UL,
      FI_EN_BN_ALPHA_BANK = 34021UL,
      FI_EN_BN_ALPHA_COPY_NOKIA_STORES = 34022UL,
      FI_EN_BN_ALTAE = 34023UL,
      FI_EN_BN_ALTUNBILEKLER = 34024UL,
      FI_EN_BN_ALVI = 34025UL,
      FI_EN_BN_AMAGERBANKEN = 34026UL,
      FI_EN_BN_AMARANTE_HOTELS = 34027UL,
      FI_EN_BN_AMARILLO = 34028UL,
      FI_EN_BN_AMARINE = 34029UL,
      FI_EN_BN_AMATOS = 34030UL,
      FI_EN_BN_AMBIT_RSM_BANK = 34031UL,
      FI_EN_BN_AMC_THEATRES = 34032UL,
      FI_EN_BN_AMCORE_BANK = 34033UL,
      FI_EN_BN_AMERICAN_CAFE = 34034UL,
      FI_EN_BN_AMERICAN_EAGLE_OUTFITTERS = 34035UL,
      FI_EN_BN_AMERICAN_NATIONAL_BANK = 34036UL,
      FI_EN_BN_AMERICAN_SAVINGS_BANK = 34037UL,
      FI_EN_BN_AMERICAS_BEST_VALUE_INN = 34038UL,
      FI_EN_BN_AMERICAS_TIRE = 34039UL,
      FI_EN_BN_AMERICINN_HOTEL_SUITES = 34040UL,
      FI_EN_BN_AMERICINN_LODGE_SUITES = 34041UL,
      FI_EN_BN_AMERICINN_MOTEL_SUITES = 34042UL,
      FI_EN_BN_AMERICINN = 34043UL,
      FI_EN_BN_AMICO = 34044UL,
      FI_EN_BN_AMIGO = 34045UL,
      FI_EN_BN_AMPM = 34046UL,
      FI_EN_BN_AMRAT_HOTELS = 34047UL,
      FI_EN_BN_AMRATH_HOTELS = 34048UL,
      FI_EN_BN_AMREY_HOTELS = 34049UL,
      FI_EN_BN_AMSOUTH_BANK = 34050UL,
      FI_EN_BN_ANADOLUBANK = 34051UL,
      FI_EN_BN_ANCANARA = 34052UL,
      FI_EN_BN_ANCHOR_BC = 34053UL,
      FI_EN_BN_ANCHORBANK = 34054UL,
      FI_EN_BN_ANDAZ = 34055UL,
      FI_EN_BN_ANDELSKASSEN = 34056UL,
      FI_EN_BN_ANDHRA_BANK = 34057UL,
      FI_EN_BN_ANDYS_BURGERS_SHAKES_FRIES = 34058UL,
      FI_EN_BN_ANGLO_IRISH_BANK = 34059UL,
      FI_EN_BN_ANGLO_ROMANIAN_BANK = 34060UL,
      FI_EN_BN_ANKER = 34061UL,
      FI_EN_BN_ANN_TAYLOR_FACTORY = 34062UL,
      FI_EN_BN_ANN_TAYLOR_LOFT = 34063UL,
      FI_EN_BN_ANN_TAYLOR = 34064UL,
      FI_EN_BN_ANNA_RISKA = 34065UL,
      FI_EN_BN_ANNA = 34066UL,
      FI_EN_BN_ANTIBES_PARKING = 34067UL,
      FI_EN_BN_ANTOL = 34068UL,
      FI_EN_BN_ANWB = 34069UL,
      FI_EN_BN_ANZ = 34070UL,
      FI_EN_BN_AP = 34071UL,
      FI_EN_BN_APCOA = 34072UL,
      FI_EN_BN_APNA_BAZAAR = 34073UL,
      FI_EN_BN_APNA_SAHAKARI_BANK = 34074UL,
      FI_EN_BN_APO_BANK = 34075UL,
      FI_EN_BN_APOLLO = 34076UL,
      FI_EN_BN_APPENZELLER_KANTONALBANK = 34077UL,
      FI_EN_BN_APPLE_AUTO_GLASS = 34078UL,
      FI_EN_BN_APPLEBEES = 34079UL,
      FI_EN_BN_APSIS_HOTELS = 34080UL,
      FI_EN_BN_ARAB_BANK = 34081UL,
      FI_EN_BN_ARAB_WORLD_RESTAURANT = 34082UL,
      FI_EN_BN_ARAP_TURK_BANKASI = 34083UL,
      FI_EN_BN_ARBEJDERNES_LANDSBANK = 34084UL,
      FI_EN_BN_ARBYS = 34085UL,
      FI_EN_BN_ARC = 34086UL,
      FI_EN_BN_ARD_DISCOUNT = 34087UL,
      FI_EN_BN_ARDENE = 34088UL,
      FI_EN_BN_ARENA_MLADOST = 34089UL,
      FI_EN_BN_ARENA_WEST = 34090UL,
      FI_EN_BN_ARGENTA = 34091UL,
      FI_EN_BN_ARGO = 34092UL,
      FI_EN_BN_ARGOS_OIL = 34093UL,
      FI_EN_BN_ARIADNI = 34094UL,
      FI_EN_BN_ARIS = 34095UL,
      FI_EN_BN_ARS = 34096UL,
      FI_EN_BN_ART_MOZI = 34097UL,
      FI_EN_BN_ARTHUR_TREACHERS = 34098UL,
      FI_EN_BN_ARTOTEL = 34099UL,
      FI_EN_BN_AS_ADVENTURE = 34100UL,
      FI_EN_BN_ASCEND_COLLECTION = 34101UL,
      FI_EN_BN_ASCOTT_THE_RESIDENCE = 34102UL,
      FI_EN_BN_ASHLEY_STEWART = 34103UL,
      FI_EN_BN_ASOIL = 34104UL,
      FI_EN_BN_ASPIS_BANK = 34105UL,
      FI_EN_BN_ASPRO = 34106UL,
      FI_EN_BN_ASSOCIATED_BANK = 34107UL,
      FI_EN_BN_ASTRAKHANGAZPROM = 34108UL,
      FI_EN_BN_ASTURIENNE = 34109UL,
      FI_EN_BN_AT_T = 34110UL,
      FI_EN_BN_ATAHOTEL = 34111UL,
      FI_EN_BN_ATB_FINANCIAL = 34112UL,
      FI_EN_BN_ATEBANK = 34113UL,
      FI_EN_BN_ATHENS_OIL = 34114UL,
      FI_EN_BN_ATHLETES_WORLD = 34115UL,
      FI_EN_BN_ATL_MIETWAGEN_GESMBH = 34116UL,
      FI_EN_BN_ATLANTSOLIA = 34117UL,
      FI_EN_BN_ATRIUM_HOTELS = 34118UL,
      FI_EN_BN_ATS_EUROMASTER = 34119UL,
      FI_EN_BN_ATTICA_BANK = 34120UL,
      FI_EN_BN_ATTIJARIWAFA_BANK = 34121UL,
      FI_EN_BN_ATU = 34122UL,
      FI_EN_BN_AU_BON_PAIN = 34123UL,
      FI_EN_BN_AU_BUREAU = 34124UL,
      FI_EN_BN_AUNTIE_ANNES = 34125UL,
      FI_EN_BN_AURELIOS_PIZZA = 34126UL,
      FI_EN_BN_AURGI = 34127UL,
      FI_EN_BN_AURIGA = 34128UL,
      FI_EN_BN_AURORA_PHARMACY = 34129UL,
      FI_EN_BN_AUTO_ATLANTIS = 34130UL,
      FI_EN_BN_AUTO_DOCTOR = 34131UL,
      FI_EN_BN_AUTO_EUROPA = 34132UL,
      FI_EN_BN_AUTO_GLASS_CENTER = 34133UL,
      FI_EN_BN_AUTO_GLASS_SPECIALISTS = 34134UL,
      FI_EN_BN_AUTO_RENT = 34135UL,
      FI_EN_BN_AUTOBAHN = 34136UL,
      FI_EN_BN_AUTODRIVER = 34137UL,
      FI_EN_BN_AUTOFERBAR = 34138UL,
      FI_EN_BN_AUTOFOOD = 34139UL,
      FI_EN_BN_AUTOGOLDEN = 34140UL,
      FI_EN_BN_AUTOGRILL = 34141UL,
      FI_EN_BN_AUTO_JARDIM = 34142UL,
      FI_EN_BN_AUTOLUX = 34143UL,
      FI_EN_BN_AUTOMATIC_RESTAURANT = 34144UL,
      FI_EN_BN_AUTONOM_RENT_A_CAR = 34145UL,
      FI_EN_BN_AUTOP = 34146UL,
      FI_EN_BN_AUTORENT = 34147UL,
      FI_EN_BN_AUTOTAALGLAS = 34148UL,
      FI_EN_BN_AUTOZONE = 34149UL,
      FI_EN_BN_AVA = 34150UL,
      FI_EN_BN_AVENTA = 34151UL,
      FI_EN_BN_AVENUE = 34152UL,
      FI_EN_BN_AVEVE = 34153UL,
      FI_EN_BN_AVIS = 34154UL,
      FI_EN_BN_AVOSKA = 34155UL,
      FI_EN_BN_AVR_RENT_A_CAR = 34156UL,
      FI_EN_BN_AXA = 34157UL,
      FI_EN_BN_AXIS_BANK = 34158UL,
      FI_EN_BN_AXON = 34159UL,
      FI_EN_BN_AZBUKA_VKUSA = 34160UL,
      FI_EN_BN_AZORIA = 34161UL,
      FI_EN_BN_AZTECA = 34162UL,
      FI_EN_BN_B_DALTON = 34163UL,
      FI_EN_BN_BABIESRUS = 34164UL,
      FI_EN_BN_BACK_YARD_BURGERS = 34165UL,
      FI_EN_BN_BADENIA = 34166UL,
      FI_EN_BN_BADGET = 34167UL,
      FI_EN_BN_BAHAMA_BREEZE = 34168UL,
      FI_EN_BN_BAJA_FRESH = 34169UL,
      FI_EN_BN_BAJAJ_AUTO = 34170UL,
      FI_EN_BN_BAKERS_SQUARE = 34171UL,
      FI_EN_BN_BAKERS = 34172UL,
      FI_EN_BN_BALA = 34173UL,
      FI_EN_BN_BALOISE_BANK_SOBA = 34174UL,
      FI_EN_BN_BALTIC_INTERNATIONAL_BANK = 34175UL,
      FI_EN_BN_BALTIC_PETROLEUM = 34176UL,
      FI_EN_BN_BALTIC_TRUST_BANK = 34177UL,
      FI_EN_BN_BALTINVESTBANK = 34178UL,
      FI_EN_BN_BALTIYSKIY_BANK = 34179UL,
      FI_EN_BN_BALT_TREYD = 34180UL,
      FI_EN_BN_BANAMEX = 34181UL,
      FI_EN_BN_BANANA_REPUBLIC = 34182UL,
      FI_EN_BN_BANC_POST = 34183UL,
      FI_EN_BN_BANCA_AGRICOLA_DI_CEREA = 34184UL,
      FI_EN_BN_BANCA_AGRICOLA_MANTOVANA = 34185UL,
      FI_EN_BN_BANCA_ANTONIANA_POPOLARE_VENETA = 34186UL,
      FI_EN_BN_BANCA_ANTONVENETA = 34187UL,
      FI_EN_BN_BANCA_BRIGNONE = 34188UL,
      FI_EN_BN_BANCA_CARIGE = 34189UL,
      FI_EN_BN_BANCA_CARIME = 34190UL,
      FI_EN_BN_BANCA_CHANTUNALA_GRISCHUNA = 34191UL,
      FI_EN_BN_BANCA_COMERCIALA_CARPATICA = 34192UL,
      FI_EN_BN_BANCA_COMERCIALA_ROMANA = 34193UL,
      FI_EN_BN_BANCA_COMMERCIALE_ITALIANA = 34194UL,
      FI_EN_BN_BANCA_COOP = 34195UL,
      FI_EN_BN_BANCA_CR_FIRENZE = 34196UL,
      FI_EN_BN_BANCA_CRT = 34197UL,
      FI_EN_BN_BANCA_DEL_FUCINO = 34198UL,
      FI_EN_BN_BANCA_DEL_GARDA = 34199UL,
      FI_EN_BN_BANCA_DEL_PIEMONTE = 34200UL,
      FI_EN_BN_BANCA_DELLA_CAMPANIA = 34201UL,
      FI_EN_BN_BANCA_DELLA_CIOCIARIA = 34202UL,
      FI_EN_BN_BANCA_DELLA_PROVINCIA_DI_MACERATA = 34203UL,
      FI_EN_BN_BANCA_DELLAGRICOLTURA = 34204UL,
      FI_EN_BN_BANCA_DELLO_STATO_DEL_CANTON_TICINO = 34205UL,
      FI_EN_BN_BANCA_DI_BERGAMO = 34206UL,
      FI_EN_BN_BANCA_DI_BOLOGNA = 34207UL,
      FI_EN_BN_BANCA_DI_CAGLIARI = 34208UL,
      FI_EN_BN_BANCA_DI_CREDITO_COOPERAT_DI_ROMA = 34209UL,
      FI_EN_BN_BANCA_DI_CREDITO_COOPERAT_GENOVESE = 34210UL,
      FI_EN_BN_BANCA_DI_CREDITO_COOPERATIVO = 34211UL,
      FI_EN_BN_BANCA_DI_PALERMO = 34212UL,
      FI_EN_BN_BANCA_DI_PIACENZA = 34213UL,
      FI_EN_BN_BANCA_DI_RIMINI = 34214UL,
      FI_EN_BN_BANCA_DI_ROMA = 34215UL,
      FI_EN_BN_BANCA_DI_SASSARI = 34216UL,
      FI_EN_BN_BANCA_DI_TRENTO_E_BOLZANO = 34217UL,
      FI_EN_BN_BANCA_DI_VERONA = 34218UL,
      FI_EN_BN_BANCA_ETRURIA = 34219UL,
      FI_EN_BN_BANCA_FIDEURAM = 34220UL,
      FI_EN_BN_BANCA_GENERALI = 34221UL,
      FI_EN_BN_BANCA_INTESA = 34222UL,
      FI_EN_BN_BANCA_LEONARDO = 34223UL,
      FI_EN_BN_BANCA_LOMBARDA = 34224UL,
      FI_EN_BN_BANCA_MALATESTIANA = 34225UL,
      FI_EN_BN_BANCA_MARCH = 34226UL,
      FI_EN_BN_BANCA_MARCHE = 34227UL,
      FI_EN_BN_BANCA_MEDIOLANUM = 34228UL,
      FI_EN_BN_BANCA_NAZIONALE_DEL_LAVORO = 34229UL,
      FI_EN_BN_BANCA_PASSADORE_C = 34230UL,
      FI_EN_BN_BANCA_POLARE_PUGLIA_E_BASILICATA = 34231UL,
      FI_EN_BN_BANCA_PONTI = 34232UL,
      FI_EN_BN_BANCA_POP_COMMERCIO_E_INDUSTRIA = 34233UL,
      FI_EN_BN_BANCA_POP_DELLETRURIA_E_DEL_LAZIO = 34234UL,
      FI_EN_BN_BANCA_POPOL_COMMERCIO_E_INDUSTRIA = 34235UL,
      FI_EN_BN_BANCA_POPOLARE_DEL_LAZIO = 34236UL,
      FI_EN_BN_BANCA_POPOLARE_DELLADRIATICO = 34237UL,
      FI_EN_BN_BANCA_POPOLARE_DELLEMILIA_ROMAGNA = 34238UL,
      FI_EN_BN_BANCA_POPOLARE_DI_ANCONA = 34239UL,
      FI_EN_BN_BANCA_POPOLARE_DI_APRILIA = 34240UL,
      FI_EN_BN_BANCA_POPOLARE_DI_BARI = 34241UL,
      FI_EN_BN_BANCA_POPOLARE_DI_BERGAMO = 34242UL,
      FI_EN_BN_BANCA_POPOLARE_DI_LODI = 34243UL,
      FI_EN_BN_BANCA_POPOLARE_DI_MILANO = 34244UL,
      FI_EN_BN_BANCA_POPOLARE_DI_NOVARA = 34245UL,
      FI_EN_BN_BANCA_POPOLARE_DI_RAVENNA = 34246UL,
      FI_EN_BN_BANCA_POPOLARE_DI_SONDRIO = 34247UL,
      FI_EN_BN_BANCA_POPOLARE_DI_SPOLETO = 34248UL,
      FI_EN_BN_BANCA_POPOLARE_DI_VICENZA = 34249UL,
      FI_EN_BN_BANCA_POPOLARE_ITALIANA = 34250UL,
      FI_EN_BN_BANCA_POPOLARE_PUGLIA_E_BASILICATA = 34251UL,
      FI_EN_BN_BANCA_POPOLARE_VALCONCA = 34252UL,
      FI_EN_BN_BANCA_PUEYO = 34253UL,
      FI_EN_BN_BANCA_REGIONALE_EUROPEA = 34254UL,
      FI_EN_BN_BANCA_ROMANEASCA = 34255UL,
      FI_EN_BN_BANCA_SELLA = 34256UL,
      FI_EN_BN_BANCA_TOSCANA = 34257UL,
      FI_EN_BN_BANCA_TRANSILVANIA = 34258UL,
      FI_EN_BN_BANCA_VESUVIANA = 34259UL,
      FI_EN_BN_BANCAJA = 34260UL,
      FI_EN_BN_BANCAMIGROS = 34261UL,
      FI_EN_BN_BANCAPULIA = 34262UL,
      FI_EN_BN_BANCARIBE = 34263UL,
      FI_EN_BN_BANCFIRST = 34264UL,
      FI_EN_BN_BANCO_24HORAS = 34265UL,
      FI_EN_BN_BANCO_ALCALA = 34266UL,
      FI_EN_BN_BANCO_AMBROSIANO_VENETO = 34267UL,
      FI_EN_BN_BANCO_AZTECA = 34268UL,
      FI_EN_BN_BANCO_CAIXA_GERAL = 34269UL,
      FI_EN_BN_BANCO_CANARIAS = 34270UL,
      FI_EN_BN_BANCO_CARONI = 34271UL,
      FI_EN_BN_BANCO_CIUDAD = 34272UL,
      FI_EN_BN_BANCO_COMAFI = 34273UL,
      FI_EN_BN_BANCO_CONDELL = 34274UL,
      FI_EN_BN_BANCO_COOPERATIVO_ESPANOL = 34275UL,
      FI_EN_BN_BANCO_CREDICHILE = 34276UL,
      FI_EN_BN_BANCO_CREDICOOP = 34277UL,
      FI_EN_BN_BANCO_DE_ANDALUCIA = 34278UL,
      FI_EN_BN_BANCO_DE_CASTILLA = 34279UL,
      FI_EN_BN_BANCO_DE_CHILE = 34280UL,
      FI_EN_BN_BANCO_DE_CREDITO_BALEAR = 34281UL,
      FI_EN_BN_BANCO_DE_ESPANA = 34282UL,
      FI_EN_BN_BANCO_DE_GALICIA = 34283UL,
      FI_EN_BN_BANCO_DE_INVESTIMENTO_GLOBAL = 34284UL,
      FI_EN_BN_BANCO_DE_LA_NACION_ARGENTINA = 34285UL,
      FI_EN_BN_BANCO_DE_VALENCIA = 34286UL,
      FI_EN_BN_BANCO_DE_VASCONIA = 34287UL,
      FI_EN_BN_BANCO_DE_VENEZUELA = 34288UL,
      FI_EN_BN_BANCO_DEL_BAJIO = 34289UL,
      FI_EN_BN_BANCO_DEL_COMERCIO = 34290UL,
      FI_EN_BN_BANCO_DEL_DESARROLLO = 34291UL,
      FI_EN_BN_BANCO_DESIO_LAZIO = 34292UL,
      FI_EN_BN_BANCO_DESIO = 34293UL,
      FI_EN_BN_BANCO_DI_BRESCIA = 34294UL,
      FI_EN_BN_BANCO_DI_CHIAVARI_E_RIVIERA_LIGURE = 34295UL,
      FI_EN_BN_BANCO_DI_NAPOLI = 34296UL,
      FI_EN_BN_BANCO_DI_SAN_GIORGIO = 34297UL,
      FI_EN_BN_BANCO_DI_SARDEGNA = 34298UL,
      FI_EN_BN_BANCO_DI_SICILIA = 34299UL,
      FI_EN_BN_BANCO_DO_BRASIL = 34300UL,
      FI_EN_BN_BANCO_ECHEVERRIA = 34301UL,
      FI_EN_BN_BANCO_ESPIRITO_SANTO = 34302UL,
      FI_EN_BN_BANCO_ESPIRITO_SANTO_2 = 34303UL,
      FI_EN_BN_BANCO_EUROPEO_DE_FINANZAS = 34304UL,
      FI_EN_BN_BANCO_EXTERIOR = 34305UL,
      FI_EN_BN_BANCO_FALABELLA = 34306UL,
      FI_EN_BN_BANCO_FEDERAL = 34307UL,
      FI_EN_BN_BANCO_FINANTIA_SOFINLOC = 34308UL,
      FI_EN_BN_BANCO_FRANCES = 34309UL,
      FI_EN_BN_BANCO_GALLEGO = 34310UL,
      FI_EN_BN_BANCO_GUAYANA = 34311UL,
      FI_EN_BN_BANCO_GUIPUZCOANO = 34312UL,
      FI_EN_BN_BANCO_HERRERO = 34313UL,
      FI_EN_BN_BANCO_INDUSTRIAL_DE_VENEZUELA = 34314UL,
      FI_EN_BN_BANCO_INTERNACIONAL_DO_FUNCHAL = 34315UL,
      FI_EN_BN_BANCO_MADRID = 34316UL,
      FI_EN_BN_BANCO_MAIS = 34317UL,
      FI_EN_BN_BANCO_MERCANTIL = 34318UL,
      FI_EN_BN_BANCO_NACIONAL_DE_CREDITO = 34319UL,
      FI_EN_BN_BANCO_PARIS = 34320UL,
      FI_EN_BN_BANCO_PASTOR = 34321UL,
      FI_EN_BN_BANCO_PLAZA = 34322UL,
      FI_EN_BN_BANCO_POPOLARE_DI_VERONA_E_NOVARA = 34323UL,
      FI_EN_BN_BANCO_POPOLARE = 34324UL,
      FI_EN_BN_BANCO_POPULAR = 34325UL,
      FI_EN_BN_BANCO_PORTUGUES_DE_INVESTIMENTO = 34326UL,
      FI_EN_BN_BANCO_PORTUGUES_DE_NEGOCIOS = 34327UL,
      FI_EN_BN_BANCO_RIPLEY = 34328UL,
      FI_EN_BN_BANCO_SAN_GEMINIANO_E_SAN_PROSPERO = 34329UL,
      FI_EN_BN_BANCO_SECURITY = 34330UL,
      FI_EN_BN_BANCO_SIMEON = 34331UL,
      FI_EN_BN_BANCO_SOFITASA = 34332UL,
      FI_EN_BN_BANCO_URQUIJO = 34333UL,
      FI_EN_BN_BANCOA_CREDIT_AGRICOLE = 34334UL,
      FI_EN_BN_BANCOBICE = 34335UL,
      FI_EN_BN_BANCOESTADO = 34336UL,
      FI_EN_BN_BANCOEX = 34337UL,
      FI_EN_BN_BANCOFAR = 34338UL,
      FI_EN_BN_BANCOMER = 34339UL,
      FI_EN_BN_BANCOPOPULAR_ECOM = 34340UL,
      FI_EN_BN_BANCORPSOUTH = 34341UL,
      FI_EN_BN_BANCORREOS = 34342UL,
      FI_EN_BN_BANCOSABADELL = 34343UL,
      FI_EN_BN_BANCSABADELL = 34344UL,
      FI_EN_BN_BANCWEST = 34345UL,
      FI_EN_BN_BANDANAS_BAR_B_QUE_AND_GRILL = 34346UL,
      FI_EN_BN_BANESCO = 34347UL,
      FI_EN_BN_BANESTO = 34348UL,
      FI_EN_BN_BANGALORE_DISTRICT_CO_OP_BANK = 34349UL,
      FI_EN_BN_BANGALORE_SOUHARDA_CO_OP_BANK = 34350UL,
      FI_EN_BN_BANGKOK_BANK = 34351UL,
      FI_EN_BN_BANIF = 34352UL,
      FI_EN_BN_BANK_1_SAAR = 34353UL,
      FI_EN_BN_BANK_ASYA = 34354UL,
      FI_EN_BN_BANK_AUSTRIA = 34355UL,
      FI_EN_BN_BANK_BPH = 34356UL,
      FI_EN_BN_BANK_BUKOPIN = 34357UL,
      FI_EN_BN_BANK_BUMIPUTERA = 34358UL,
      FI_EN_BN_BANK_CENTRAL_ASIA = 34359UL,
      FI_EN_BN_BANK_COOP = 34360UL,
      FI_EN_BN_BANK_DANAMON = 34361UL,
      FI_EN_BN_BANK_DIPO = 34362UL,
      FI_EN_BN_BANK_EKONOMI = 34363UL,
      FI_EN_BN_BANK_EKSEKUTIF_INTERNASIONAL = 34364UL,
      FI_EN_BN_BANK_GANESHA = 34365UL,
      FI_EN_BN_BANK_GOSPODARKI_ZYWNOSCIOWEJ = 34366UL,
      FI_EN_BN_BANK_HALIM_INDONESIA = 34367UL,
      FI_EN_BN_BANK_IFI = 34368UL,
      FI_EN_BN_BANK_INDONESIA = 34369UL,
      FI_EN_BN_BANK_INTERNASIONAL_INDONESIA = 34370UL,
      FI_EN_BN_BANK_INTERNATIONAL_ASIA = 34371UL,
      FI_EN_BN_BANK_JABAR = 34372UL,
      FI_EN_BN_BANK_JASA_JAKARTA = 34373UL,
      FI_EN_BN_BANK_LINTH = 34374UL,
      FI_EN_BN_BANK_MANDIRI = 34375UL,
      FI_EN_BN_BANK_MASPION = 34376UL,
      FI_EN_BN_BANK_MAYAPADA_INTERNASIONAL = 34377UL,
      FI_EN_BN_BANK_MAYORA = 34378UL,
      FI_EN_BN_BANK_MEGA = 34379UL,
      FI_EN_BN_BANK_MELLAT = 34380UL,
      FI_EN_BN_BANK_MIDWEST = 34381UL,
      FI_EN_BN_BANK_MOSKVY = 34382UL,
      FI_EN_BN_BANK_NEGARA_INDONESIA = 34383UL,
      FI_EN_BN_BANK_NIAGA = 34384UL,
      FI_EN_BN_BANK_NISP = 34385UL,
      FI_EN_BN_BANK_OCHRONY_SRODOWISKA = 34386UL,
      FI_EN_BN_BANK_OF_AMERICA = 34387UL,
      FI_EN_BN_BANK_OF_BARODA = 34388UL,
      FI_EN_BN_BANK_OF_CYPRUS = 34389UL,
      FI_EN_BN_BANK_OF_GREECE = 34390UL,
      FI_EN_BN_BANK_OF_HAWAII = 34391UL,
      FI_EN_BN_BANK_OF_INDIA = 34392UL,
      FI_EN_BN_BANK_OF_IRELAND = 34393UL,
      FI_EN_BN_BANK_OF_MADURA = 34394UL,
      FI_EN_BN_BANK_OF_MAHARASHTRA = 34395UL,
      FI_EN_BN_BANK_OF_MONTREAL = 34396UL,
      FI_EN_BN_BANK_OF_NEW_YORK = 34397UL,
      FI_EN_BN_BANK_OF_PUNJAB = 34398UL,
      FI_EN_BN_BANK_OF_QUEENSLAND = 34399UL,
      FI_EN_BN_BANK_OF_RAJASTHAN = 34400UL,
      FI_EN_BN_BANK_OF_SCOTLAND = 34401UL,
      FI_EN_BN_BANK_OF_THE_WEST = 34402UL,
      FI_EN_BN_BANK_OF_TOKYO = 34403UL,
      FI_EN_BN_BANK_PEKAO_SA = 34404UL,
      FI_EN_BN_BANK_PHB = 34405UL,
      FI_EN_BN_BANK_POCZTOWY = 34406UL,
      FI_EN_BN_BANK_POLSKIEJ_SPOLDZIELCZOSCI = 34407UL,
      FI_EN_BN_BANK_RAKYAT_INDONESIA = 34408UL,
      FI_EN_BN_BANK_UIB = 34409UL,
      FI_EN_BN_BANK_VAN_DE_POST = 34410UL,
      FI_EN_BN_BANK_VICTORIA = 34411UL,
      FI_EN_BN_BANK_VOZROZHDENIE = 34412UL,
      FI_EN_BN_BANK_ZACHODNI_WBK = 34413UL,
      FI_EN_BN_BANKA_CELJE = 34414UL,
      FI_EN_BN_BANKA_KOPER = 34415UL,
      FI_EN_BN_BANKINTER = 34416UL,
      FI_EN_BN_BANKOA = 34417UL,
      FI_EN_BN_BANKPYME = 34418UL,
      FI_EN_BN_BANORTE = 34419UL,
      FI_EN_BN_BANQUE_CANTONALE_BERNOISE = 34420UL,
      FI_EN_BN_BANQUE_CANTONALE_DE_BALE = 34421UL,
      FI_EN_BN_BANQUE_CANTONALE_DE_FRIBOURG = 34422UL,
      FI_EN_BN_BANQUE_CANTONALE_DE_GENEVE = 34423UL,
      FI_EN_BN_BANQUE_CANTONALE_DU_JURA = 34424UL,
      FI_EN_BN_BANQUE_CANTONALE_DU_VALAIS = 34425UL,
      FI_EN_BN_BANQUE_CANTONALE_NEUCHATELOISE = 34426UL,
      FI_EN_BN_BANQUE_CANTONALE_VAUDOISE = 34427UL,
      FI_EN_BN_BANQUE_COOP = 34428UL,
      FI_EN_BN_BANQUE_DE_BRETAGNE = 34429UL,
      FI_EN_BN_BANQUE_DE_FRANCE = 34430UL,
      FI_EN_BN_BANQUE_DE_LA_POSTE = 34431UL,
      FI_EN_BN_BANQUE_DE_MONTREAL = 34432UL,
      FI_EN_BN_BANQUE_DE_SAVOIE = 34433UL,
      FI_EN_BN_BANQUE_J_VAN_BREDA_CO = 34434UL,
      FI_EN_BN_BANQUE_LAURENTIENNE = 34435UL,
      FI_EN_BN_BANQUE_MARTIN_MAUREL = 34436UL,
      FI_EN_BN_BANQUE_MIGROS = 34437UL,
      FI_EN_BN_BANQUE_NATIONALE = 34438UL,
      FI_EN_BN_BANQUE_PALATINE = 34439UL,
      FI_EN_BN_BANQUE_POPULAIRE = 34440UL,
      FI_EN_BN_BANQUE_SCOTIA = 34441UL,
      FI_EN_BN_BANQUE_TARNEAUD = 34442UL,
      FI_EN_BN_BANREGIO = 34443UL,
      FI_EN_BN_BANRISUL = 34444UL,
      FI_EN_BN_BAPCO = 34445UL,
      FI_EN_BN_BARCLAYS = 34446UL,
      FI_EN_BN_BARISTA = 34447UL,
      FI_EN_BN_BARNES_NOBLE_BOOKSELLERS = 34448UL,
      FI_EN_BN_BARNEYS_NEW_YORK = 34449UL,
      FI_EN_BN_BARNHILLS = 34450UL,
      FI_EN_BN_BAS_VAN_DER_HEIJDEN = 34451UL,
      FI_EN_BN_BASE_SHOP = 34452UL,
      FI_EN_BN_BASELLANDSCHAFTLICHE_KANTONALBANK = 34453UL,
      FI_EN_BN_BASGIMPA = 34454UL,
      FI_EN_BN_BASHKIRNEFT = 34455UL,
      FI_EN_BN_BASHKIRNEFTEPRODUKT = 34456UL,
      FI_EN_BN_BASHNEFT = 34457UL,
      FI_EN_BN_BASIC = 34458UL,
      FI_EN_BN_BASILE_PETROLI = 34459UL,
      FI_EN_BN_BASKIN_ROBBINS = 34460UL,
      FI_EN_BN_BASKO = 34461UL,
      FI_EN_BN_BASLER_KANTONALBANK = 34462UL,
      FI_EN_BN_BASS = 34463UL,
      FI_EN_BN_BATA = 34464UL,
      FI_EN_BN_BATH_BODY_WORKS = 34465UL,
      FI_EN_BN_BATRIQ = 34466UL,
      FI_EN_BN_BATTARD = 34467UL,
      FI_EN_BN_BATTERIES_PLUS = 34468UL,
      FI_EN_BN_BAUHAUS = 34469UL,
      FI_EN_BN_BAUKING = 34470UL,
      FI_EN_BN_BAUMAX = 34471UL,
      FI_EN_BN_BAWAG_PSK = 34472UL,
      FI_EN_BN_BAYFIN = 34473UL,
      FI_EN_BN_BAYMONT_INN_SUITES = 34474UL,
      FI_EN_BN_BAYWA = 34475UL,
      FI_EN_BN_BAZAAR = 34476UL,
      FI_EN_BN_BB_BANK = 34477UL,
      FI_EN_BN_BB_T = 34478UL,
      FI_EN_BN_BBK = 34479UL,
      FI_EN_BN_BBVA_BANCO_PROVINCIAL = 34480UL,
      FI_EN_BN_BBVA_BANCOMER = 34481UL,
      FI_EN_BN_BBVA = 34482UL,
      FI_EN_BN_BCA = 34483UL,
      FI_EN_BN_BCBGMAXAZRIA = 34484UL,
      FI_EN_BN_BCEE = 34485UL,
      FI_EN_BN_BCI = 34486UL,
      FI_EN_BN_BCL = 34487UL,
      FI_EN_BN_BCP = 34488UL,
      FI_EN_BN_BDC = 34489UL,
      FI_EN_BN_BDS_MONGOLIAN_BARBEQUE = 34490UL,
      FI_EN_BN_BECKS_PRIME = 34491UL,
      FI_EN_BN_BEEF_OBRADYS = 34492UL,
      FI_EN_BN_BEEFEATER = 34493UL,
      FI_EN_BN_BELAMBRA_VVF = 34494UL,
      FI_EN_BN_BELCOMPANY = 34495UL,
      FI_EN_BN_BELGACOM = 34496UL,
      FI_EN_BN_BELL = 34497UL,
      FI_EN_BN_BELLAFLORA = 34498UL,
      FI_EN_BN_BEMOL = 34499UL,
      FI_EN_BN_BEN_JERRYS = 34500UL,
      FI_EN_BN_BENDIGO_BANK = 34501UL,
      FI_EN_BN_BENEDETTIS = 34502UL,
      FI_EN_BN_BENEFICIAL_FINANCE = 34503UL,
      FI_EN_BN_BENIHANA = 34504UL,
      FI_EN_BN_UNITED_COLORS_OF_BENETTON = 34505UL,
      FI_EN_BN_BENNIGANS = 34506UL,
      FI_EN_BN_BENSAUDE_TURISMO = 34507UL,
      FI_EN_BN_BENT = 34508UL,
      FI_EN_BN_BENTLEY_LEATHERS = 34509UL,
      FI_EN_BN_BENZINOL = 34510UL,
      FI_EN_BN_BEPON = 34511UL,
      FI_EN_BN_BERCA = 34512UL,
      FI_EN_BN_BERES_MULTICARS = 34513UL,
      FI_EN_BN_BERLINER_BANK = 34514UL,
      FI_EN_BN_BERLINER_SPARKASSE = 34515UL,
      FI_EN_BN_BERLINER_VOLKSBANK = 34516UL,
      FI_EN_BN_BERNARD_PHILIBERT = 34517UL,
      FI_EN_BN_BERNER_KANTONALBANK = 34518UL,
      FI_EN_BN_BERSHKA = 34519UL,
      FI_EN_BN_BERTUCCIS = 34520UL,
      FI_EN_BN_BES = 34521UL,
      FI_EN_BN_BEST_BUY = 34522UL,
      FI_EN_BN_BEST_LOVED = 34523UL,
      FI_EN_BN_BEST_OIL = 34524UL,
      FI_EN_BN_BEST_WESTERN_PREMIER = 34525UL,
      FI_EN_BN_BEST = 34526UL,
      FI_EN_BN_BETACAR = 34527UL,
      FI_EN_BN_BFC = 34528UL,
      FI_EN_BN_BG_BANK = 34529UL,
      FI_EN_BN_BGL = 34530UL,
      FI_EN_BN_BHARAT_CO_OP_BANK = 34531UL,
      FI_EN_BN_BHARAT_OVERSEAS_BANK = 34532UL,
      FI_EN_BN_BHARAT_PETROLEUM = 34533UL,
      FI_EN_BN_BHPETROL = 34534UL,
      FI_EN_BN_BHW = 34535UL,
      FI_EN_BN_BI_LO = 34536UL,
      FI_EN_BN_BIEDRONKA = 34537UL,
      FI_EN_BN_BIELEFELDER_VOLKSBANK = 34538UL,
      FI_EN_BN_BIG_10_TIRES = 34539UL,
      FI_EN_BN_BIG_BAZAAR = 34540UL,
      FI_EN_BN_BIG_BOY = 34541UL,
      FI_EN_BN_BIG_DOGS = 34542UL,
      FI_EN_BN_BIG_HORN_STEAK_HOUSE = 34543UL,
      FI_EN_BN_BIG_TOWN_HERO = 34544UL,
      FI_EN_BN_BIGMAT = 34545UL,
      FI_EN_BN_BILDERBERG = 34546UL,
      FI_EN_BN_BILDIRICI = 34547UL,
      FI_EN_BN_BILKA = 34548UL,
      FI_EN_BN_BILL_MILLER_BAR_B_Q = 34549UL,
      FI_EN_BN_BILLA = 34550UL,
      FI_EN_BN_BINBANK = 34551UL,
      FI_EN_BN_BIO_COMPANY = 34552UL,
      FI_EN_BN_BIPA = 34553UL,
      FI_EN_BN_BIPOP_CARIRE = 34554UL,
      FI_EN_BN_BIRMINGHAM_MIDSHIRES = 34555UL,
      FI_EN_BN_BISE = 34556UL,
      FI_EN_BN_BISTRO_ROMAIN = 34557UL,
      FI_EN_BN_BIVERBANCA = 34558UL,
      FI_EN_BN_BKCP = 34559UL,
      FI_EN_BN_BKS_BANK = 34560UL,
      FI_EN_BN_BLACK_ANGUS_STEAKHOUSE = 34561UL,
      FI_EN_BN_BLAKES_LOTABURGER = 34562UL,
      FI_EN_BN_BLENDERS_IN_THE_GRASS = 34563UL,
      FI_EN_BN_BLIMPIE = 34564UL,
      FI_EN_BN_BLISKA = 34565UL,
      FI_EN_BN_BLOKKER = 34566UL,
      FI_EN_BN_BLOMMERS_ICE_CREAM = 34567UL,
      FI_EN_BN_BLUE_BURRITO_GRILLE = 34568UL,
      FI_EN_BN_BLUE_CORAL_SEAFOOD_SPIRITS = 34569UL,
      FI_EN_BN_BLUE_MESA_GRILL = 34570UL,
      FI_EN_BN_BLUE_TREE = 34571UL,
      FI_EN_BN_BMCE = 34572UL,
      FI_EN_BN_BNL = 34573UL,
      FI_EN_BN_BNP_PARIBAS_FORTIS = 34574UL,
      FI_EN_BN_BNP_PARIBAS = 34575UL,
      FI_EN_BN_BOB_EVANS = 34576UL,
      FI_EN_BN_BOBS_STORES = 34577UL,
      FI_EN_BN_BOBS = 34578UL,
      FI_EN_BN_BOCATTA = 34579UL,
      FI_EN_BN_BOD = 34580UL,
      FI_EN_BN_BODEGA_AURRERA = 34581UL,
      FI_EN_BN_BODYTALK = 34582UL,
      FI_EN_BN_BOJANGLES = 34583UL,
      FI_EN_BN_BOLLE = 34584UL,
      FI_EN_BN_BOLOCO = 34585UL,
      FI_EN_BN_BOLWELL = 34586UL,
      FI_EN_BN_BOM_PRECO = 34587UL,
      FI_EN_BN_BOMBAY_MERCANTILE_CO_OP_BANK = 34588UL,
      FI_EN_BN_BOMI = 34589UL,
      FI_EN_BN_BONA_COMPRA = 34590UL,
      FI_EN_BN_BONANZA = 34591UL,
      FI_EN_BN_BONAREA = 34592UL,
      FI_EN_BN_BONEFISH_GRILL = 34593UL,
      FI_EN_BN_BONES = 34594UL,
      FI_EN_BN_BONITA = 34595UL,
      FI_EN_BN_BONPREU = 34596UL,
      FI_EN_BN_BON_TON = 34597UL,
      FI_EN_BN_BOOK_RACK = 34598UL,
      FI_EN_BN_BOOK_WORLD = 34599UL,
      FI_EN_BN_BOOKS_A_MILLION = 34600UL,
      FI_EN_BN_BOOSTER_JUICE = 34601UL,
      FI_EN_BN_BORDERS = 34602UL,
      FI_EN_BN_BOSCH_CAR_SERVICE = 34603UL,
      FI_EN_BN_BOSCOLO = 34604UL,
      FI_EN_BN_BOSTON_BEANERY = 34605UL,
      FI_EN_BN_BOSTON_MARKET = 34606UL,
      FI_EN_BN_BOSTON_PIZZA = 34607UL,
      FI_EN_BN_BOSTONS_RESTAURANT_SPORTS_BAR = 34608UL,
      FI_EN_BN_BOULANGER = 34609UL,
      FI_EN_BN_BOX = 34610UL,
      FI_EN_BN_BPET = 34611UL,
      FI_EN_BN_BPU_BANCA = 34612UL,
      FI_EN_BN_BR = 34613UL,
      FI_EN_BN_BRADESCO = 34614UL,
      FI_EN_BN_BRADFORD_BINGLEY = 34615UL,
      FI_EN_BN_BRAKES_PLUS = 34616UL,
      FI_EN_BN_BRAND_OIL = 34617UL,
      FI_EN_BN_BRANTANO = 34618UL,
      FI_EN_BN_BRASSERIES_FLO = 34619UL,
      FI_EN_BN_BRAUMS = 34620UL,
      FI_EN_BN_BRAUNEGGER = 34621UL,
      FI_EN_BN_BRD = 34622UL,
      FI_EN_BN_BRE_BANK_SA = 34623UL,
      FI_EN_BN_BRED = 34624UL,
      FI_EN_BN_BRETAGNE_MATERIAUX = 34625UL,
      FI_EN_BN_BRETECHE = 34626UL,
      FI_EN_BN_BRICK = 34627UL,
      FI_EN_BN_BRICO_DEPOT = 34628UL,
      FI_EN_BN_BRICO_PLAN_IT = 34629UL,
      FI_EN_BN_BRICO = 34630UL,
      FI_EN_BN_BRICOMARCHE = 34631UL,
      FI_EN_BN_BRISTOL_WEST = 34632UL,
      FI_EN_BN_BRIT_HOTEL = 34633UL,
      FI_EN_BN_BRIT = 34634UL,
      FI_EN_BN_BRITANNIA_BUILDING_SOCIETY = 34635UL,
      FI_EN_BN_BRITANNIA = 34636UL,
      FI_EN_BN_BROOKS_BROTHERS = 34637UL,
      FI_EN_BN_BROOKS_PHARMACY = 34638UL,
      FI_EN_BN_BROWNS = 34639UL,
      FI_EN_BN_BRUEGGERS = 34640UL,
      FI_EN_BN_BRUNA = 34641UL,
      FI_EN_BN_BRUNET = 34642UL,
      FI_EN_BN_BRUSTERS_REAL_ICE_CREAM = 34643UL,
      FI_EN_BN_BRYC = 34644UL,
      FI_EN_BN_BSB = 34645UL,
      FI_EN_BN_BSTDB = 34646UL,
      FI_EN_BN_BTV = 34647UL,
      FI_EN_BN_BUCA_DI_BEPPO = 34648UL,
      FI_EN_BN_BUCHBINDER = 34649UL,
      FI_EN_BN_BUDAPEST_BANK = 34650UL,
      FI_EN_BN_BUDGENS = 34651UL,
      FI_EN_BN_BUDGET_EXHAUST_TYRES = 34652UL,
      FI_EN_BN_BUDNIKOWSKI = 34653UL,
      FI_EN_BN_BUENO_PITTA = 34654UL,
      FI_EN_BN_BUFFALO_GRILL = 34655UL,
      FI_EN_BN_BUFFALO_WILD_WINGS = 34656UL,
      FI_EN_BN_BUFORI = 34657UL,
      FI_EN_BN_BUKVOED = 34658UL,
      FI_EN_BN_BUNNPRIS = 34659UL,
      FI_EN_BN_BUONA = 34660UL,
      FI_EN_BN_BUREAU_EN_GROS = 34661UL,
      FI_EN_BN_BURGER_KING = 34662UL,
      FI_EN_BN_BURGERLAND = 34663UL,
      FI_EN_BN_BURLEX = 34664UL,
      FI_EN_BN_BURLINGTON_SHOES = 34665UL,
      FI_EN_BN_BURN_OIL = 34666UL,
      FI_EN_BN_BURSA_ISKENDER = 34667UL,
      FI_EN_BN_BUSINESS_CAR_RENTAL = 34668UL,
      FI_EN_BN_BUT = 34669UL,
      FI_EN_BN_BW_BANK = 34670UL,
      FI_EN_BN_BWOC = 34671UL,
      FI_EN_BN_C_A = 34672UL,
      FI_EN_BN_C_C_SCHAPER = 34673UL,
      FI_EN_BN_C1000 = 34674UL,
      FI_EN_BN_CACTUS = 34675UL,
      FI_EN_BN_CAESARS = 34676UL,
      FI_EN_BN_CAFE_COFFEE_DAY = 34677UL,
      FI_EN_BN_CAFE_DU_BOUCHER = 34678UL,
      FI_EN_BN_CAFE_LEFFE = 34679UL,
      FI_EN_BN_CAFFE_NERO = 34680UL,
      FI_EN_BN_CAFFE_RITAZZA = 34681UL,
      FI_EN_BN_CAGDAS = 34682UL,
      FI_EN_BN_CAI = 34683UL,
      FI_EN_BN_CAISSE_DEPARGNE = 34684UL,
      FI_EN_BN_CAISSE_POPULAIRE_DESJARDINS = 34685UL,
      FI_EN_BN_CAIXA_ADVOCATS = 34686UL,
      FI_EN_BN_CAIXA_ALBALAT = 34687UL,
      FI_EN_BN_CAIXA_BENICARLO = 34688UL,
      FI_EN_BN_CAIXA_CALLOSA = 34689UL,
      FI_EN_BN_CAIXA_CATALUNYA = 34690UL,
      FI_EN_BN_CAIXA_DE_CREDITO_AGRICOLA = 34691UL,
      FI_EN_BN_CAIXA_DENGINYERS = 34692UL,
      FI_EN_BN_CAIXA_ECONOMICA_DA_MISERICORDIA = 34693UL,
      FI_EN_BN_CAIXA_GALICIA = 34694UL,
      FI_EN_BN_CAIXA_GERAL_DE_DEPOSITOS = 34695UL,
      FI_EN_BN_CAIXA_GERAL = 34696UL,
      FI_EN_BN_CAIXA_GIRONA = 34697UL,
      FI_EN_BN_CAIXA_LAIETANA = 34698UL,
      FI_EN_BN_CAIXA_MANLLEU = 34699UL,
      FI_EN_BN_CAIXA_MANRESA = 34700UL,
      FI_EN_BN_CAIXA_ONTINYENT = 34701UL,
      FI_EN_BN_CAIXA_PENEDES = 34702UL,
      FI_EN_BN_CAIXA_POPULAR = 34703UL,
      FI_EN_BN_CAIXA_RURAL_ALCORA = 34704UL,
      FI_EN_BN_CAIXA_RURAL_BALEARS = 34705UL,
      FI_EN_BN_CAIXA_RURAL_BURRIANA = 34706UL,
      FI_EN_BN_CAIXA_RURAL_DALGEMESI = 34707UL,
      FI_EN_BN_CAIXA_RURAL_GALEGA = 34708UL,
      FI_EN_BN_CAIXA_RURAL_LA_VALL = 34709UL,
      FI_EN_BN_CAIXA_RURAL_LES_COVES = 34710UL,
      FI_EN_BN_CAIXA_RURAL_NULES = 34711UL,
      FI_EN_BN_CAIXA_RURAL_SANT_VICENT = 34712UL,
      FI_EN_BN_CAIXA_RURAL_TORRENT = 34713UL,
      FI_EN_BN_CAIXA_RURAL_VILA_REAL = 34714UL,
      FI_EN_BN_CAIXA_RURAL_VILAVELLA = 34715UL,
      FI_EN_BN_CAIXA_RURAL = 34716UL,
      FI_EN_BN_CAIXA_SABADELL = 34717UL,
      FI_EN_BN_CAIXA_TARRAGONA = 34718UL,
      FI_EN_BN_CAIXA_TERRASSA = 34719UL,
      FI_EN_BN_CAIXA_VINAROS = 34720UL,
      FI_EN_BN_CAIXA = 34721UL,
      FI_EN_BN_CAIXACALLOSA = 34722UL,
      FI_EN_BN_CAIXALMASSORA = 34723UL,
      FI_EN_BN_CAIXALQUERIES = 34724UL,
      FI_EN_BN_CAIXALTEA = 34725UL,
      FI_EN_BN_CAIXANOVA = 34726UL,
      FI_EN_BN_CAIXAPETRER = 34727UL,
      FI_EN_BN_CAIXATERRASA = 34728UL,
      FI_EN_BN_CAJA_ABOGADOS = 34729UL,
      FI_EN_BN_CAJA_BADAJOZ = 34730UL,
      FI_EN_BN_CAJA_BURGOS = 34731UL,
      FI_EN_BN_CAJA_CAMINOS = 34732UL,
      FI_EN_BN_CAJA_CAMPO = 34733UL,
      FI_EN_BN_CAJA_CANARIAS = 34734UL,
      FI_EN_BN_CAJA_CANTABRIA = 34735UL,
      FI_EN_BN_CAJA_CIRCULO = 34736UL,
      FI_EN_BN_CAJA_DE_ARQUITECTOS = 34737UL,
      FI_EN_BN_CAJA_DE_AVILA = 34738UL,
      FI_EN_BN_CAJA_DE_BADAJOZ = 34739UL,
      FI_EN_BN_CAJA_DE_BURGOS = 34740UL,
      FI_EN_BN_CAJA_DE_EXTREMADURA = 34741UL,
      FI_EN_BN_CAJA_DE_GUADALAJARA = 34742UL,
      FI_EN_BN_CAJA_DE_INGENIEROS = 34743UL,
      FI_EN_BN_CAJA_DE_JAEN = 34744UL,
      FI_EN_BN_CAJA_DE_JAEN_2 = 34745UL,
      FI_EN_BN_CAJA_DUERO = 34746UL,
      FI_EN_BN_CAJA_ESPANA = 34747UL,
      FI_EN_BN_CAJA_GRANADA = 34748UL,
      FI_EN_BN_CAJA_IMMACULADA = 34749UL,
      FI_EN_BN_CAJA_LABORAL = 34750UL,
      FI_EN_BN_CAJA_MADRID = 34751UL,
      FI_EN_BN_CAJA_NAVARRA = 34752UL,
      FI_EN_BN_CAJA_RIOJA = 34753UL,
      FI_EN_BN_CAJA_RURAL_ALBAL = 34754UL,
      FI_EN_BN_CAJA_RURAL_ALMENARA = 34755UL,
      FI_EN_BN_CAJA_RURAL_BETXI = 34756UL,
      FI_EN_BN_CAJA_RURAL_BURGOS = 34757UL,
      FI_EN_BN_CAJA_RURAL_CASINOS = 34758UL,
      FI_EN_BN_CAJA_RURAL_CASTELLON = 34759UL,
      FI_EN_BN_CAJA_RURAL_CENTRAL = 34760UL,
      FI_EN_BN_CAJA_RURAL_CHILCHES = 34761UL,
      FI_EN_BN_CAJA_RURAL_CORDOBA = 34762UL,
      FI_EN_BN_CAJA_RURAL_DE_ALBACETE = 34763UL,
      FI_EN_BN_CAJA_RURAL_DE_ALGINET = 34764UL,
      FI_EN_BN_CAJA_RURAL_DE_ASTURIAS = 34765UL,
      FI_EN_BN_CAJA_RURAL_DE_BAENA = 34766UL,
      FI_EN_BN_CAJA_RURAL_DE_CANARIAS = 34767UL,
      FI_EN_BN_CAJA_RURAL_DE_CANETE = 34768UL,
      FI_EN_BN_CAJA_RURAL_DE_CASAS_IBANEZ = 34769UL,
      FI_EN_BN_CAJA_RURAL_DE_CHESTE = 34770UL,
      FI_EN_BN_CAJA_RURAL_DE_CIUDAD_REAL = 34771UL,
      FI_EN_BN_CAJA_RURAL_DE_CUENCA = 34772UL,
      FI_EN_BN_CAJA_RURAL_DE_FUENTEPELAYO = 34773UL,
      FI_EN_BN_CAJA_RURAL_DE_GIJON = 34774UL,
      FI_EN_BN_CAJA_RURAL_DE_GRANADA = 34775UL,
      FI_EN_BN_CAJA_RURAL_DE_LA_RODA = 34776UL,
      FI_EN_BN_CAJA_RURAL_DE_MOTA_DEL_CUERVO = 34777UL,
      FI_EN_BN_CAJA_RURAL_DE_NAVARRA = 34778UL,
      FI_EN_BN_CAJA_RURAL_DE_ONDA = 34779UL,
      FI_EN_BN_CAJA_RURAL_DE_SALAMANCA = 34780UL,
      FI_EN_BN_CAJA_RURAL_DE_SEGOVIA = 34781UL,
      FI_EN_BN_CAJA_RURAL_DE_SORIA = 34782UL,
      FI_EN_BN_CAJA_RURAL_DE_TERUEL = 34783UL,
      FI_EN_BN_CAJA_RURAL_DE_TOLEDO = 34784UL,
      FI_EN_BN_CAJA_RURAL_DE_UTRERA = 34785UL,
      FI_EN_BN_CAJA_RURAL_DE_VILLAMALEA = 34786UL,
      FI_EN_BN_CAJA_RURAL_DEL_DUERO = 34787UL,
      FI_EN_BN_CAJA_RURAL_JAEN = 34788UL,
      FI_EN_BN_CAJA_RURAL_NUEVA_CARTEYA = 34789UL,
      FI_EN_BN_CAJA_RURAL_REGIONAL = 34790UL,
      FI_EN_BN_CAJA_RURAL_VILAFAMES = 34791UL,
      FI_EN_BN_CAJA_RURAL = 34792UL,
      FI_EN_BN_CAJA_SAN_FERNANDO = 34793UL,
      FI_EN_BN_CAJA_SEGOVIA = 34794UL,
      FI_EN_BN_CAJA_VITAL_KUTXA = 34795UL,
      FI_EN_BN_CAJALMENDRALEJO = 34796UL,
      FI_EN_BN_CAJALON = 34797UL,
      FI_EN_BN_CAJAMAR = 34798UL,
      FI_EN_BN_CAJAMURCIA = 34799UL,
      FI_EN_BN_CAJASIETE = 34800UL,
      FI_EN_BN_CAJASOL = 34801UL,
      FI_EN_BN_CAJASTUR = 34802UL,
      FI_EN_BN_CAJASUR = 34803UL,
      FI_EN_BN_CALIFORNIA_BANK_TRUST = 34804UL,
      FI_EN_BN_CALIFORNIA_CHICKEN_CAFE = 34805UL,
      FI_EN_BN_CALIFORNIA_NATIONAL_BANK = 34806UL,
      FI_EN_BN_CALIFORNIA_PIZZA_KITCHEN = 34807UL,
      FI_EN_BN_CALIFORNIA_TORTILLA = 34808UL,
      FI_EN_BN_CALIFORNIA = 34809UL,
      FI_EN_BN_CALISER = 34810UL,
      FI_EN_BN_CAM = 34811UL,
      FI_EN_BN_CAMBRIA_SUITES = 34812UL,
      FI_EN_BN_CAMBRIDGE_BUILDING_SOCIETY = 34813UL,
      FI_EN_BN_CAMPUS = 34814UL,
      FI_EN_BN_CAN = 34815UL,
      FI_EN_BN_CANADAS_BEST_VALUE_INN = 34816UL,
      FI_EN_BN_CANADIAN_WESTERN_BANK = 34817UL,
      FI_EN_BN_CANARA_BANK = 34818UL,
      FI_EN_BN_CANARIAS = 34819UL,
      FI_EN_BN_CANDLEWOOD_SUITES = 34820UL,
      FI_EN_BN_CANTINA_LAREDO = 34821UL,
      FI_EN_BN_CAPITAL_BANK = 34822UL,
      FI_EN_BN_CAPITAL_CITY_BANK = 34823UL,
      FI_EN_BN_CAPITALIA = 34824UL,
      FI_EN_BN_CAPITEC_BANK = 34825UL,
      FI_EN_BN_CAPITOL = 34826UL,
      FI_EN_BN_CAPRABO = 34827UL,
      FI_EN_BN_CAPSIS_HOTELS = 34828UL,
      FI_EN_BN_CAPTAIN_DS = 34829UL,
      FI_EN_BN_CAR_MEDIC = 34830UL,
      FI_EN_BN_CAR_RENTAL_BULGARIA = 34831UL,
      FI_EN_BN_CAR_CONDAL = 34832UL,
      FI_EN_BN_CARESTEL = 34833UL,
      FI_EN_BN_CARGLASS = 34834UL,
      FI_EN_BN_CARGO = 34835UL,
      FI_EN_BN_CARIBOU_COFFEE = 34836UL,
      FI_EN_BN_CARICHIETI = 34837UL,
      FI_EN_BN_CARIFAC = 34838UL,
      FI_EN_BN_CARIFANO = 34839UL,
      FI_EN_BN_CARIFERMO = 34840UL,
      FI_EN_BN_CARINOS_ITALIAN_GRILL = 34841UL,
      FI_EN_BN_CARIPARMA_PIACENZA = 34842UL,
      FI_EN_BN_CARIPE = 34843UL,
      FI_EN_BN_CARIPLO = 34844UL,
      FI_EN_BN_CARIPRATO = 34845UL,
      FI_EN_BN_CARISBO = 34846UL,
      FI_EN_BN_CARLOS_OKELLYS_MEXICAN_CAFE = 34847UL,
      FI_EN_BN_CARLS_JR = 34848UL,
      FI_EN_BN_CAROIL = 34849UL,
      FI_EN_BN_CARPARK = 34850UL,
      FI_EN_BN_CARPET_RIGHT = 34851UL,
      FI_EN_BN_CARQUEST = 34852UL,
      FI_EN_BN_CARRABBAS_ITALIAN_GRILL = 34853UL,
      FI_EN_BN_CARREFOUR_CITY = 34854UL,
      FI_EN_BN_CARREFOUR_EXPRESS = 34855UL,
      FI_EN_BN_CARREFOUR_MARKET = 34856UL,
      FI_EN_BN_CARROWS = 34857UL,
      FI_EN_BN_CARVEL = 34858UL,
      FI_EN_BN_CASA = 34859UL,
      FI_EN_BN_CASEYS_GENERAL_STORE = 34860UL,
      FI_EN_BN_CASH_RECORD = 34861UL,
      FI_EN_BN_CASH4YOU = 34862UL,
      FI_EN_BN_CASINO_CAFETERIA = 34863UL,
      FI_EN_BN_CASSA_DI_RISP_DI_VR_VI_BL_AN = 34864UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DELLA_SPEZIA = 34865UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_ASTI = 34866UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_BOLOGNA = 34867UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_CESENA = 34868UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_FERRARA = 34869UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_FIRENZE = 34870UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_FORLI = 34871UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_IMOLA = 34872UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_LORETO = 34873UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_LUCCA = 34874UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_RAVENNA = 34875UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_RIETI = 34876UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_RIMINI = 34877UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_DI_SAN_MINIATO = 34878UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_PADOVA_E_ROVIGO = 34879UL,
      FI_EN_BN_CASSA_DI_RISPARMIO_PARMA_E_PIACENZA = 34880UL,
      FI_EN_BN_CASSA_RISP_DELLA_PROV_DELLAQUILA = 34881UL,
      FI_EN_BN_CASTELLO_LOPES = 34882UL,
      FI_EN_BN_CASTORAMA = 34883UL,
      FI_EN_BN_CASTROL = 34884UL,
      FI_EN_BN_CASUAL_MALE = 34885UL,
      FI_EN_BN_CATALONIA = 34886UL,
      FI_EN_BN_CATHAY_BANK = 34887UL,
      FI_EN_BN_CATHERINES = 34888UL,
      FI_EN_BN_CATHOLIC_SYRIAN_BANK = 34889UL,
      FI_EN_BN_CATO = 34890UL,
      FI_EN_BN_CBA = 34891UL,
      FI_EN_BN_CBC = 34892UL,
      FI_EN_BN_CC_BANK = 34893UL,
      FI_EN_BN_CCF = 34894UL,
      FI_EN_BN_CCM = 34895UL,
      FI_EN_BN_CCMONAGAS = 34896UL,
      FI_EN_BN_CCS_COFFEE_HOUSE = 34897UL,
      FI_EN_BN_CEC_BANK = 34898UL,
      FI_EN_BN_CECA = 34899UL,
      FI_EN_BN_CEDEO = 34900UL,
      FI_EN_BN_CELIKLER = 34901UL,
      FI_EN_BN_CENTAURO = 34902UL,
      FI_EN_BN_CENTEA = 34903UL,
      FI_EN_BN_CENTIMETER = 34904UL,
      FI_EN_BN_CENTRA = 34905UL,
      FI_EN_BN_CENTRAL_BANCO_UNIVERSAL = 34906UL,
      FI_EN_BN_CENTRAL_BANK_OF_INDIA = 34907UL,
      FI_EN_BN_CENTRAL_CHENNAI_CO_OP_BANK = 34908UL,
      FI_EN_BN_CENTRAL_COOPERATIVE_BANK = 34909UL,
      FI_EN_BN_CENTRAL_MADEIRENSE = 34910UL,
      FI_EN_BN_CENTRAL_TYRE = 34911UL,
      FI_EN_BN_CENTRAL = 34912UL,
      FI_EN_BN_CENTURION_BANK = 34913UL,
      FI_EN_BN_CENTURY_BANK = 34914UL,
      FI_EN_BN_CEPSA = 34915UL,
      FI_EN_BN_CERTIGARD = 34916UL,
      FI_EN_BN_CESKA_NARODNI_BANKA = 34917UL,
      FI_EN_BN_CESKA_SPORITELNA = 34918UL,
      FI_EN_BN_CESKOMORAVSKA_STAVEBNI_SPORITELNA = 34919UL,
      FI_EN_BN_CETELEM = 34920UL,
      FI_EN_BN_CHALKIADAKIS = 34921UL,
      FI_EN_BN_CHAMPION_MARINOPOULOS = 34922UL,
      FI_EN_BN_CHAMPPS = 34923UL,
      FI_EN_BN_CHAMPS_SPORTS = 34924UL,
      FI_EN_BN_CHANDRIS_HOTELS_RESORTS = 34925UL,
      FI_EN_BN_CHANELLOS_PIZZA = 34926UL,
      FI_EN_BN_CHAPTERS = 34927UL,
      FI_EN_BN_CHARLES_SCHWAB_CORP = 34928UL,
      FI_EN_BN_CHARLEYS = 34929UL,
      FI_EN_BN_CHARLOTTE_RUSSE = 34930UL,
      FI_EN_BN_CHART_HOUSE = 34931UL,
      FI_EN_BN_CHARTER_ONE_BANK = 34932UL,
      FI_EN_BN_CHARTER = 34933UL,
      FI_EN_BN_CHASE = 34934UL,
      FI_EN_BN_CHATEAU_DAX = 34935UL,
      FI_EN_BN_CHATEAUX_ET_HOTELS_COLLECTION = 34936UL,
      FI_EN_BN_CHAYNAYA_LOZHKA = 34937UL,
      FI_EN_BN_CHECKER_AUTO_PARTS = 34938UL,
      FI_EN_BN_CHECKERS = 34939UL,
      FI_EN_BN_CHEDDARS = 34940UL,
      FI_EN_BN_CHEDRAUI = 34941UL,
      FI_EN_BN_CHEEBURGER_CHEEBURGER = 34942UL,
      FI_EN_BN_CHEESEBURGER_IN_PARADISE = 34943UL,
      FI_EN_BN_CHEESECAKE_FACTORY = 34944UL,
      FI_EN_BN_CHELSEA_BUILDING_SOCIETY = 34945UL,
      FI_EN_BN_CHELTENHAM_GLOUCESTER = 34946UL,
      FI_EN_BN_CHEMICAL_BANK = 34947UL,
      FI_EN_BN_CHENNAI_CENTRAL_CO_OP_BANK = 34948UL,
      FI_EN_BN_CHENNAI_CORPORATION_CO_OP_BANK = 34949UL,
      FI_EN_BN_CHERY = 34950UL,
      FI_EN_BN_CHESHIRE_BUILDING_SOCIETY = 34951UL,
      FI_EN_BN_CHESTERS = 34952UL,
      FI_EN_BN_CHEVYS = 34953UL,
      FI_EN_BN_CHI_CHIS = 34954UL,
      FI_EN_BN_CHICKEN_DELIGHT = 34955UL,
      FI_EN_BN_CHICKEN_EXPRESS = 34956UL,
      FI_EN_BN_CHICKEN_KITCHEN = 34957UL,
      FI_EN_BN_CHICKEN_LICKEN = 34958UL,
      FI_EN_BN_CHICKEN_TIKKA = 34959UL,
      FI_EN_BN_CHICK_FIL_A = 34960UL,
      FI_EN_BN_CHICOS_ALL_AMERICAN_BISTRO = 34961UL,
      FI_EN_BN_CHICOS_RESTAURANT = 34962UL,
      FI_EN_BN_CHILDRENS_PLACE = 34963UL,
      FI_EN_BN_CHILIS_GRILL_BAR = 34964UL,
      FI_EN_BN_CHILO = 34965UL,
      FI_EN_BN_CHIMARRAO = 34966UL,
      FI_EN_BN_CHIMARRAO_2 = 34967UL,
      FI_EN_BN_CHINA_BUFFET = 34968UL,
      FI_EN_BN_CHINA_COAST = 34969UL,
      FI_EN_BN_CHINA_EAST = 34970UL,
      FI_EN_BN_CHINA_EXPRESS = 34971UL,
      FI_EN_BN_CHINA_GARDEN = 34972UL,
      FI_EN_BN_CHINA_HOUSE = 34973UL,
      FI_EN_BN_CHINA_TRUST_COMMERCIAL_BANK = 34974UL,
      FI_EN_BN_CHINS = 34975UL,
      FI_EN_BN_CHIP_7 = 34976UL,
      FI_EN_BN_CHIPOTLE = 34977UL,
      FI_EN_BN_CHIPS_AWAY = 34978UL,
      FI_EN_BN_CHLOPSKIE_JADLO = 34979UL,
      FI_EN_BN_CHRISTIAN_BROTHERS_AUTOMOTIVE = 34980UL,
      FI_EN_BN_CHRISTOPHER_BANKS = 34981UL,
      FI_EN_BN_CHUCK_E_CHEESES = 34982UL,
      FI_EN_BN_CHURCHS_CHICKEN = 34983UL,
      FI_EN_BN_CIAO = 34984UL,
      FI_EN_BN_CIB_BANK = 34985UL,
      FI_EN_BN_CIBC = 34986UL,
      FI_EN_BN_CIC = 34987UL,
      FI_EN_BN_CICAR = 34988UL,
      FI_EN_BN_CICIS_PIZZA = 34989UL,
      FI_EN_BN_CINELANDIA = 34990UL,
      FI_EN_BN_CINEMA_CITY = 34991UL,
      FI_EN_BN_CINEMAPLEXX = 34992UL,
      FI_EN_BN_CINEMARK = 34993UL,
      FI_EN_BN_CINEMAX = 34994UL,
      FI_EN_BN_CINEPLEX = 34995UL,
      FI_EN_BN_CINEPOLIS = 34996UL,
      FI_EN_BN_CINESA = 34997UL,
      FI_EN_BN_CINEWORLD = 34998UL,
      FI_EN_BN_CINNABON = 34999UL,
      FI_EN_BN_CIRCUIT_CITY = 35000UL,
      FI_EN_BN_CIRCUS = 35001UL,
      FI_EN_BN_CITADINES_APART_HOTEL = 35002UL,
      FI_EN_BN_CITI_FINANCIAL = 35003UL,
      FI_EN_BN_CITIZEN_CREDIT_CO_OP_BANK = 35004UL,
      FI_EN_BN_CITIZENS_BANK_TRUST = 35005UL,
      FI_EN_BN_CITIZENS_BANK = 35006UL,
      FI_EN_BN_CITY_BITES = 35007UL,
      FI_EN_BN_CITY_BLENDS = 35008UL,
      FI_EN_BN_CITY_DELHAIZE = 35009UL,
      FI_EN_BN_CITY_FINANCIAL = 35010UL,
      FI_EN_BN_CITY_GROSS = 35011UL,
      FI_EN_BN_CITY_HANDLOWY = 35012UL,
      FI_EN_BN_CITY_LODGE = 35013UL,
      FI_EN_BN_CITY_MARKT = 35014UL,
      FI_EN_BN_CITY_PARK_HOTELS = 35015UL,
      FI_EN_BN_CITY_PARKING = 35016UL,
      FI_EN_BN_CITY_UNION_BANK = 35017UL,
      FI_EN_BN_CJ_BANKS = 35018UL,
      FI_EN_BN_CKP_CO_OPERATIVE_BANK = 35019UL,
      FI_EN_BN_CLAIM_JUMPER = 35020UL,
      FI_EN_BN_CLAIRES = 35021UL,
      FI_EN_BN_CLARION_HOTEL = 35022UL,
      FI_EN_BN_CLARK = 35023UL,
      FI_EN_BN_CLARKS = 35024UL,
      FI_EN_BN_CLASSICAL_HOTELS = 35025UL,
      FI_EN_BN_CLEAN_CAR = 35026UL,
      FI_EN_BN_CLIENTIS = 35027UL,
      FI_EN_BN_CLUB_MED = 35028UL,
      FI_EN_BN_CLYDESDALE_BANK = 35029UL,
      FI_EN_BN_CMH = 35030UL,
      FI_EN_BN_CNG = 35031UL,
      FI_EN_BN_CO_BIGELOW = 35032UL,
      FI_EN_BN_COACH = 35033UL,
      FI_EN_BN_COALIMENT = 35034UL,
      FI_EN_BN_COALVE = 35035UL,
      FI_EN_BN_COCCIMARKET = 35036UL,
      FI_EN_BN_COCOS = 35037UL,
      FI_EN_BN_CODI = 35038UL,
      FI_EN_BN_COFFE_CO = 35039UL,
      FI_EN_BN_THE_COFFEE_BEAN_TEA_LEAF = 35040UL,
      FI_EN_BN_COFFEE_BEANERY = 35041UL,
      FI_EN_BN_COFFEE_HOUSE = 35042UL,
      FI_EN_BN_COFFEE_REPUBLIC = 35043UL,
      FI_EN_BN_COFFEE_TIME = 35044UL,
      FI_EN_BN_COFFEE_WORLD = 35045UL,
      FI_EN_BN_COLD_STONE_CREAMERY = 35046UL,
      FI_EN_BN_COLDWATER_CREEK = 35047UL,
      FI_EN_BN_COLE_HAAN = 35048UL,
      FI_EN_BN_COLE_MUFFLER = 35049UL,
      FI_EN_BN_COLES = 35050UL,
      FI_EN_BN_COLMAR = 35051UL,
      FI_EN_BN_COLONYA_CAIXA_POLLENCA = 35052UL,
      FI_EN_BN_COLRUYT = 35053UL,
      FI_EN_BN_COLTERS_TEXAS_BAR_B_Q = 35054UL,
      FI_EN_BN_COMERCIAL_MEXICANA = 35055UL,
      FI_EN_BN_COMERICA = 35056UL,
      FI_EN_BN_COMET = 35057UL,
      FI_EN_BN_COMFORT_SUITES = 35058UL,
      FI_EN_BN_COMMERZBANK = 35059UL,
      FI_EN_BN_COMMERZIALBANK = 35060UL,
      FI_EN_BN_COMMONWEALTH_BANK = 35061UL,
      FI_EN_BN_COMPRABENE = 35062UL,
      FI_EN_BN_COMPRE_BEM = 35063UL,
      FI_EN_BN_COMPREBEM = 35064UL,
      FI_EN_BN_COMPRO_QUI = 35065UL,
      FI_EN_BN_COMPUTER_CITY = 35066UL,
      FI_EN_BN_CONAD = 35067UL,
      FI_EN_BN_CONDIS = 35068UL,
      FI_EN_BN_CONFORAMA = 35069UL,
      FI_EN_BN_CONOIL = 35070UL,
      FI_EN_BN_CONRAD = 35071UL,
      FI_EN_BN_CONSAD_CITY = 35072UL,
      FI_EN_BN_CONSUM = 35073UL,
      FI_EN_BN_CONTACT_GB = 35074UL,
      FI_EN_BN_CONTINENTAL_FORUM_HOTELS = 35075UL,
      FI_EN_BN_CONTINENTAL_HOTELS = 35076UL,
      FI_EN_BN_CONTINENTE = 35077UL,
      FI_EN_BN_COOL_RIVER = 35078UL,
      FI_EN_BN_COOP_BAU_HOBBY = 35079UL,
      FI_EN_BN_COOP_CITY = 35080UL,
      FI_EN_BN_COOP_EXTRA = 35081UL,
      FI_EN_BN_COOP_FORUM = 35082UL,
      FI_EN_BN_COOP_KONSUM = 35083UL,
      FI_EN_BN_COOP_NAERA = 35084UL,
      FI_EN_BN_COOP_PRONTO = 35085UL,
      FI_EN_BN_COOP_RESTAURANT = 35086UL,
      FI_EN_BN_COOP_VITALITY_APOTHEKE = 35087UL,
      FI_EN_BN_COOP = 35088UL,
      FI_EN_BN_CO_OP = 35089UL,
      FI_EN_BN_CO_OPERATIVE_BANK = 35090UL,
      FI_EN_BN_COPEC = 35091UL,
      FI_EN_BN_CORAL_HOTELS_AND_RESORTS = 35092UL,
      FI_EN_BN_CORALIA_CLUB = 35093UL,
      FI_EN_BN_CORNER_BAKERY_CAFE = 35094UL,
      FI_EN_BN_CORP_BANCA = 35095UL,
      FI_EN_BN_CORPBANCA = 35096UL,
      FI_EN_BN_CORPORATE_COMMERCIAL_BANK = 35097UL,
      FI_EN_BN_CORPORATION_BANK = 35098UL,
      FI_EN_BN_CORSALYS = 35099UL,
      FI_EN_BN_CORUS = 35100UL,
      FI_EN_BN_CORVETTE = 35101UL,
      FI_EN_BN_COSI = 35102UL,
      FI_EN_BN_COSMOS = 35103UL,
      FI_EN_BN_COSTA_COFFEE = 35104UL,
      FI_EN_BN_COSTCO = 35105UL,
      FI_EN_BN_COSTCUTTER = 35106UL,
      FI_EN_BN_COTO = 35107UL,
      FI_EN_BN_COTTAGE_INN_PIZZA = 35108UL,
      FI_EN_BN_COTTON_GINNY = 35109UL,
      FI_EN_BN_COUCHE_TARD = 35110UL,
      FI_EN_BN_COUNTRY_INN_SUITES_BY_CARLSON = 35111UL,
      FI_EN_BN_COUNTRY_INN = 35112UL,
      FI_EN_BN_COUNTRY_KITCHEN = 35113UL,
      FI_EN_BN_COUNTRY_STYLE = 35114UL,
      FI_EN_BN_COUNTRYSIDE_HOTELS = 35115UL,
      FI_EN_BN_COURTEPAILLE = 35116UL,
      FI_EN_BN_COURTHEOUX = 35117UL,
      FI_EN_BN_COUSINS = 35118UL,
      FI_EN_BN_COVENTRY_BUILDING_SOCIETY = 35119UL,
      FI_EN_BN_COVIRAN = 35120UL,
      FI_EN_BN_COZYMELS_MEXICAN_GRILL = 35121UL,
      FI_EN_BN_CPH = 35122UL,
      FI_EN_BN_CPHM = 35123UL,
      FI_EN_BN_CR_CHICKS = 35124UL,
      FI_EN_BN_CRACKER_BARREL_OLD_COUNTRY_STORE = 35125UL,
      FI_EN_BN_CRAI = 35126UL,
      FI_EN_BN_CRATE_BARREL = 35127UL,
      FI_EN_BN_CRAZY_BOWLS_WRAPS = 35128UL,
      FI_EN_BN_CREDEM = 35129UL,
      FI_EN_BN_CREDI_VENETO = 35130UL,
      FI_EN_BN_CREDIT_AGRICOLE = 35131UL,
      FI_EN_BN_CREDIT_COOPERATIF = 35132UL,
      FI_EN_BN_CREDIT_DU_NORD = 35133UL,
      FI_EN_BN_CREDIT_FONCIER = 35134UL,
      FI_EN_BN_CREDIT_MARITIME = 35135UL,
      FI_EN_BN_CREDIT_MUTUEL = 35136UL,
      FI_EN_BN_CREDIT_POSITIVE_BANK = 35137UL,
      FI_EN_BN_CREDIT_SUISSE = 35138UL,
      FI_EN_BN_CREDIT = 35139UL,
      FI_EN_BN_CREDITO_AGRICOLA = 35140UL,
      FI_EN_BN_CREDITO_ARTIGIANO = 35141UL,
      FI_EN_BN_CREDITO_BERGAMASCO = 35142UL,
      FI_EN_BN_CREDITO_COOPERATIVO = 35143UL,
      FI_EN_BN_CREDITO_EMILIANO = 35144UL,
      FI_EN_BN_CREDITO_SICILIANO = 35145UL,
      FI_EN_BN_CREDITO_VALTELLINESE = 35146UL,
      FI_EN_BN_CREDITO_VERONESE = 35147UL,
      FI_EN_BN_CREDITPLUS_BANK = 35148UL,
      FI_EN_BN_CRISPERS = 35149UL,
      FI_EN_BN_CROWN_FRIED_CHICKEN = 35150UL,
      FI_EN_BN_CROWNE_PLAZA_HOTEL = 35151UL,
      FI_EN_BN_CROWNE_PLAZA_RESORT = 35152UL,
      FI_EN_BN_CROWNE_PLAZA_SUITES = 35153UL,
      FI_EN_BN_CRUZ_VERDE = 35154UL,
      FI_EN_BN_CSOB = 35155UL,
      FI_EN_BN_CUB_FOODS = 35156UL,
      FI_EN_BN_CULVERS = 35157UL,
      FI_EN_BN_CUMBERLAND_BUILDING_SOCIETY = 35158UL,
      FI_EN_BN_CURRYS = 35159UL,
      FI_EN_BN_CURRYSDIGITAL = 35160UL,
      FI_EN_BN_CVS_PHARMACY = 35161UL,
      FI_EN_BN_CZECHOCAR_CS = 35162UL,
      FI_EN_BN_D_MART = 35163UL,
      FI_EN_BN_D_W_FOOD_CENTERS = 35164UL,
      FI_EN_BN_D_X = 35165UL,
      FI_EN_BN_DACIA = 35166UL,
      FI_EN_BN_DAECKIA = 35167UL,
      FI_EN_BN_DADDIOS_TAKE_BAKE = 35168UL,
      FI_EN_BN_DADI = 35169UL,
      FI_EN_BN_DAGLIBRUGSEN = 35170UL,
      FI_EN_BN_DAGOSTINO_SUPERMARKET = 35171UL,
      FI_EN_BN_DAIRY_BELLE = 35172UL,
      FI_EN_BN_DAIRY_QUEEN = 35173UL,
      FI_EN_BN_DAISY_MART = 35174UL,
      FI_EN_BN_DAMLA_PETROL = 35175UL,
      FI_EN_BN_DAMONS_GRILL = 35176UL,
      FI_EN_BN_DAN_DOOLEY = 35177UL,
      FI_EN_BN_DANGELO = 35178UL,
      FI_EN_BN_DANIER_LEATHER = 35179UL,
      FI_EN_BN_DAENISCHES_BETTENLAGER = 35180UL,
      FI_EN_BN_DANSKE_BANK = 35181UL,
      FI_EN_BN_DAPHNES_GREEK_CAFE = 35182UL,
      FI_EN_BN_DARTY = 35183UL,
      FI_EN_BN_DAS_BIERHAUS = 35184UL,
      FI_EN_BN_DATS_24 = 35185UL,
      FI_EN_BN_DATS = 35186UL,
      FI_EN_BN_DAVE_BUSTERS = 35187UL,
      FI_EN_BN_DAYJET = 35188UL,
      FI_EN_BN_DAYLIGHT_DONUTS = 35189UL,
      FI_EN_BN_DB_CARSHARING = 35190UL,
      FI_EN_BN_DBANK = 35191UL,
      FI_EN_BN_DCB_BANK = 35192UL,
      FI_EN_BN_DDS_DISCOUNTS = 35193UL,
      FI_EN_BN_DE_HISTORISKE = 35194UL,
      FI_EN_BN_DE_MADRID = 35195UL,
      FI_EN_BN_DEBONAIRS_PIZZA = 35196UL,
      FI_EN_BN_DECA = 35197UL,
      FI_EN_BN_DECATHLON = 35198UL,
      FI_EN_BN_DEDEMAN_HOTELS_RESORTS = 35199UL,
      FI_EN_BN_DEEN_SUPERMARKTEN = 35200UL,
      FI_EN_BN_DEFOIL = 35201UL,
      FI_EN_BN_DEGUSSA_BANK = 35202UL,
      FI_EN_BN_DEICHMANN = 35203UL,
      FI_EN_BN_DEKAMARKT = 35204UL,
      FI_EN_BN_DEL_RIO = 35205UL,
      FI_EN_BN_DEL_SUR = 35206UL,
      FI_EN_BN_DEL_TACO = 35207UL,
      FI_EN_BN_DELHAIZE = 35208UL,
      FI_EN_BN_DELHI_STATE_CO_OP_BANK = 35209UL,
      FI_EN_BN_DELIAS = 35210UL,
      FI_EN_BN_DELKA = 35211UL,
      FI_EN_BN_DELTA_LLOYD = 35212UL,
      FI_EN_BN_DEMA = 35213UL,
      FI_EN_BN_DENA_BANK = 35214UL,
      FI_EN_BN_DENIZBANK = 35215UL,
      FI_EN_BN_DENNER = 35216UL,
      FI_EN_BN_DENNYS = 35217UL,
      FI_EN_BN_DENZELDRIVE = 35218UL,
      FI_EN_BN_DER_MANN = 35219UL,
      FI_EN_BN_DERAG = 35220UL,
      FI_EN_BN_DERANG_PLUS = 35221UL,
      FI_EN_BN_DERBY_HOTELS = 35222UL,
      FI_EN_BN_DERBYSHIRE_BUILDING_SOCIETY = 35223UL,
      FI_EN_BN_DESERT_MOON = 35224UL,
      FI_EN_BN_DESIGN_HOTELS = 35225UL,
      FI_EN_BN_DESPAR = 35226UL,
      FI_EN_BN_DEUTSCHE_APOTHEKER_UND_AERZTEBANK = 35227UL,
      FI_EN_BN_DEUTSCHE_BANK = 35228UL,
      FI_EN_BN_DEUTSCHE_KREDITBANK_AG = 35229UL,
      FI_EN_BN_DEVELOPMENT_CREDIT_BANK = 35230UL,
      FI_EN_BN_DEVERE = 35231UL,
      FI_EN_BN_DEXIA = 35232UL,
      FI_EN_BN_DEZELNA_BANKA_SLOVENIJE = 35233UL,
      FI_EN_BN_DHANALAKSHMI_BANK = 35234UL,
      FI_EN_BN_DHB = 35235UL,
      FI_EN_BN_DI_PER_DI = 35236UL,
      FI_EN_BN_DI = 35237UL,
      FI_EN_BN_DIA = 35238UL,
      FI_EN_BN_DIAGONAL_HOTELS = 35239UL,
      FI_EN_BN_DIALPRIX = 35240UL,
      FI_EN_BN_DIAMOND_AUTO_GLASS = 35241UL,
      FI_EN_BN_DIAMOND_BANK = 35242UL,
      FI_EN_BN_DICK_SMITH = 35243UL,
      FI_EN_BN_DICKEYS_BARBECUE_PIT = 35244UL,
      FI_EN_BN_DICKS_SPORTING_GOODS = 35245UL,
      FI_EN_BN_DICO = 35246UL,
      FI_EN_BN_DIFFERENT_TWIST_PRETZEL_CO = 35247UL,
      FI_EN_BN_DIGROS = 35248UL,
      FI_EN_BN_DIKSI = 35249UL,
      FI_EN_BN_DILLARDS = 35250UL,
      FI_EN_BN_DIME_SAVINGS_BANK = 35251UL,
      FI_EN_BN_DIMEGLIO = 35252UL,
      FI_EN_BN_DINAZ = 35253UL,
      FI_EN_BN_DINEROEXPRESS = 35254UL,
      FI_EN_BN_DINNERS = 35255UL,
      FI_EN_BN_DIONISOS = 35256UL,
      FI_EN_BN_DIRK_VAN_DEN_BROEK = 35257UL,
      FI_EN_BN_DISCO = 35258UL,
      FI_EN_BN_DISCOUNT_TIRE = 35259UL,
      FI_EN_BN_DISCOUNT = 35260UL,
      FI_EN_BN_DISGOR = 35261UL,
      FI_EN_BN_DISNEYLAND_RESORT_PARIS = 35262UL,
      FI_EN_BN_DISPORT = 35263UL,
      FI_EN_BN_DISPREU = 35264UL,
      FI_EN_BN_DIVANIS_CHAIN_HOTELS = 35265UL,
      FI_EN_BN_DIXIE_CHILI_DELI = 35266UL,
      FI_EN_BN_DIXONS = 35267UL,
      FI_EN_BN_DM = 35268UL,
      FI_EN_BN_DNB_NORD = 35269UL,
      FI_EN_BN_DOCK_GAMES = 35270UL,
      FI_EN_BN_DOCKX = 35271UL,
      FI_EN_BN_DOK = 35272UL,
      FI_EN_BN_DOKTOR_STOLETOV = 35273UL,
      FI_EN_BN_DOLCE_VITA = 35274UL,
      FI_EN_BN_DOLLAR_RENT_A_CAR = 35275UL,
      FI_EN_BN_DOLLAR_THRIFTY = 35276UL,
      FI_EN_BN_DOLLY_DIMPLES = 35277UL,
      FI_EN_BN_DOM_NA_KINOTO = 35278UL,
      FI_EN_BN_DOMINET_BANK = 35279UL,
      FI_EN_BN_DOMINICKS = 35280UL,
      FI_EN_BN_DOMINION = 35281UL,
      FI_EN_BN_DOMINOS_PIZZA = 35282UL,
      FI_EN_BN_DOMOTEL = 35283UL,
      FI_EN_BN_DON_DOMAT = 35284UL,
      FI_EN_BN_DON_PABLOS_MEXICAN_KITCHEN = 35285UL,
      FI_EN_BN_DONATOS = 35286UL,
      FI_EN_BN_DOOLITTLES = 35287UL,
      FI_EN_BN_DOSTEEN_RESTAURANT = 35288UL,
      FI_EN_BN_DOTS = 35289UL,
      FI_EN_BN_DPIU = 35290UL,
      FI_EN_BN_DR_AHORRO = 35291UL,
      FI_EN_BN_DRENIKOV_RENT_A_CAR = 35292UL,
      FI_EN_BN_DRESDNER_BANK = 35293UL,
      FI_EN_BN_DRESSBARN = 35294UL,
      FI_EN_BN_DROGASIL = 35295UL,
      FI_EN_BN_DROVA = 35296UL,
      FI_EN_BN_DRUG_EMPORIUM = 35297UL,
      FI_EN_BN_DRUGSTORE_PHARMACY = 35298UL,
      FI_EN_BN_DRUMMONDS = 35299UL,
      FI_EN_BN_DRUXYS = 35300UL,
      FI_EN_BN_DSK_BANK = 35301UL,
      FI_EN_BN_DU = 35302UL,
      FI_EN_BN_DUANE_READE = 35303UL,
      FI_EN_BN_DUNFERMLINE_BUILDING_SOCIETY = 35304UL,
      FI_EN_BN_DUNKIN_DONUTS = 35305UL,
      FI_EN_BN_DUNNES_STORES = 35306UL,
      FI_EN_BN_DUPONT = 35307UL,
      FI_EN_BN_DZ_BANK = 35308UL,
      FI_EN_BN_DZI_BANK = 35309UL,
      FI_EN_BN_E5_MODE = 35310UL,
      FI_EN_BN_EARL_SCHEIB_PAINT_BODY = 35311UL,
      FI_EN_BN_EARLS = 35312UL,
      FI_EN_BN_EAST_OF_CHICAGO = 35313UL,
      FI_EN_BN_EAST_SIDE_MARIOS = 35314UL,
      FI_EN_BN_E_BANKA = 35315UL,
      FI_EN_BN_EBN = 35316UL,
      FI_EN_BN_EBS_BUILDING_SOCIETY = 35317UL,
      FI_EN_BN_ECARD = 35318UL,
      FI_EN_BN_ECKERD = 35319UL,
      FI_EN_BN_ECOBANK = 35320UL,
      FI_EN_BN_ECONOMY_CAR_RENTAL = 35321UL,
      FI_EN_BN_EDAH = 35322UL,
      FI_EN_BN_EDDIE_BAUER = 35323UL,
      FI_EN_BN_EDDINGTONS = 35324UL,
      FI_EN_BN_EDEKA = 35325UL,
      FI_EN_BN_EDO_OF_JAPAN = 35326UL,
      FI_EN_BN_EEGEES = 35327UL,
      FI_EN_BN_EFFIA = 35328UL,
      FI_EN_BN_EG3 = 35329UL,
      FI_EN_BN_EGGO = 35330UL,
      FI_EN_BN_EH_HOTELES = 35331UL,
      FI_EN_BN_EIBANK = 35332UL,
      FI_EN_BN_EINSTEIN_BROS = 35333UL,
      FI_EN_BN_EKI = 35334UL,
      FI_EN_BN_EKOMAR = 35335UL,
      FI_EN_BN_EKONO = 35336UL,
      FI_EN_BN_EL_ARBOL = 35337UL,
      FI_EN_BN_EL_CHICO = 35338UL,
      FI_EN_BN_EL_CORTE_INGLES = 35339UL,
      FI_EN_BN_EL_FAROLITO = 35340UL,
      FI_EN_BN_EL_MONTE = 35341UL,
      FI_EN_BN_EL_PATIO = 35342UL,
      FI_EN_BN_EL_PETROL = 35343UL,
      FI_EN_BN_EL_POLLO_LOCO = 35344UL,
      FI_EN_BN_EL_POLLO_PEPE = 35345UL,
      FI_EN_BN_EL_PORTON = 35346UL,
      FI_EN_BN_EL_TORITO = 35347UL,
      FI_EN_BN_EL_TORO_MEXICAN_RESTAURANT_CANTINA = 35348UL,
      FI_EN_BN_EL_VAQUERO = 35349UL,
      FI_EN_BN_ELAN = 35350UL,
      FI_EN_BN_ELDA = 35351UL,
      FI_EN_BN_ELDI = 35352UL,
      FI_EN_BN_ELDORADO = 35353UL,
      FI_EN_BN_ELEA = 35354UL,
      FI_EN_BN_ELECTRA_HOTELS_RESORTS = 35355UL,
      FI_EN_BN_ELECTRIC = 35356UL,
      FI_EN_BN_ELECTROTHERM_INDIA_LIMITED = 35357UL,
      FI_EN_BN_ELEMAG = 35358UL,
      FI_EN_BN_ELEPHANT_BLEU = 35359UL,
      FI_EN_BN_ELEXIA_FITNESS = 35360UL,
      FI_EN_BN_ELGIGANTEN = 35361UL,
      FI_EN_BN_ELIN = 35362UL,
      FI_EN_BN_ELITE_CAR_RENTAL = 35363UL,
      FI_EN_BN_ELITE_HOTELS_OF_SWEDEN = 35364UL,
      FI_EN_BN_ELITE = 35365UL,
      FI_EN_BN_ELKI_PALKI = 35366UL,
      FI_EN_BN_ELKJOP = 35367UL,
      FI_EN_BN_ELLEDI = 35368UL,
      FI_EN_BN_ELLIANOS_COFFEE_COMPANY = 35369UL,
      FI_EN_BN_ELLIOTTS_OFF_BROADWAY_DELI = 35370UL,
      FI_EN_BN_ELMA = 35371UL,
      FI_EN_BN_ELPRICE = 35372UL,
      FI_EN_BN_EMERALD_CITY_SMOOTHIE = 35373UL,
      FI_EN_BN_EMIGRANT_SAVINGS_BANK = 35374UL,
      FI_EN_BN_EMIL_BANCA = 35375UL,
      FI_EN_BN_EMME_PIU = 35376UL,
      FI_EN_BN_EMO = 35377UL,
      FI_EN_BN_EMPIRE = 35378UL,
      FI_EN_BN_EMPORIKI_BANK = 35379UL,
      FI_EN_BN_EM_TE = 35380UL,
      FI_EN_BN_ENERGY_KITCHEN = 35381UL,
      FI_EN_BN_ENERGY = 35382UL,
      FI_EN_BN_ENERPETROLI = 35383UL,
      FI_EN_BN_ENTERPRISE = 35384UL,
      FI_EN_BN_EO_DER_BIOSUPERMARKT = 35385UL,
      FI_EN_BN_EP = 35386UL,
      FI_EN_BN_EP_ELECTRONIC_PARTNER = 35387UL,
      FI_EN_BN_EQUITORIAL_TRUST_BANK = 35388UL,
      FI_EN_BN_ERBERT_GERBERTS = 35389UL,
      FI_EN_BN_ERIKS_DELICAFE = 35390UL,
      FI_EN_BN_ERK = 35391UL,
      FI_EN_BN_ERO_CAR_BULGARIA_LTD = 35392UL,
      FI_EN_BN_EROSKI_CENTER = 35393UL,
      FI_EN_BN_EROSKI_CITY = 35394UL,
      FI_EN_BN_ERSTE_BANK = 35395UL,
      FI_EN_BN_ESKA = 35396UL,
      FI_EN_BN_ESPRIT = 35397UL,
      FI_EN_BN_ESSAR = 35398UL,
      FI_EN_BN_ESSEC = 35399UL,
      FI_EN_BN_ESSELUNGA = 35400UL,
      FI_EN_BN_ESSO_EXPRESS = 35401UL,
      FI_EN_BN_ESTUARY = 35402UL,
      FI_EN_BN_ETAM = 35403UL,
      FI_EN_BN_ETAP_HOTEL = 35404UL,
      FI_EN_BN_EUREST = 35405UL,
      FI_EN_BN_EURO_6000 = 35406UL,
      FI_EN_BN_EURO_CAR_PARKS = 35407UL,
      FI_EN_BN_EURO_CENTER = 35408UL,
      FI_EN_BN_EUROBANK_TEKFEN = 35409UL,
      FI_EN_BN_EUROBANK = 35410UL,
      FI_EN_BN_EURO_BULGARIAN_CULTURAL_CENTRE = 35411UL,
      FI_EN_BN_EUROCOVER = 35412UL,
      FI_EN_BN_EURODOLLAR = 35413UL,
      FI_EN_BN_EUROIL = 35414UL,
      FI_EN_BN_EUROMAR_HOTELS = 35415UL,
      FI_EN_BN_EUROMARKET = 35416UL,
      FI_EN_BN_EUROMASTER = 35417UL,
      FI_EN_BN_EUROMOBIL = 35418UL,
      FI_EN_BN_EURONET = 35419UL,
      FI_EN_BN_EURONICS = 35420UL,
      FI_EN_BN_EUROOIL = 35421UL,
      FI_EN_BN_EUROPABANK = 35422UL,
      FI_EN_BN_EUROPARK = 35423UL,
      FI_EN_BN_EUROPCAR_INTERRENT = 35424UL,
      FI_EN_BN_EUROPCAR = 35425UL,
      FI_EN_BN_EUROPEAN_CENTRAL_BANK = 35426UL,
      FI_EN_BN_EUROPETROL = 35427UL,
      FI_EN_BN_EUROPIU = 35428UL,
      FI_EN_BN_EUROPLEX = 35429UL,
      FI_EN_BN_EURORENT = 35430UL,
      FI_EN_BN_EUROSCOOP = 35431UL,
      FI_EN_BN_EUROSPAR = 35432UL,
      FI_EN_BN_EUROSPIN = 35433UL,
      FI_EN_BN_EUROSTARS_HOTELS = 35434UL,
      FI_EN_BN_EUROTYRE = 35435UL,
      FI_EN_BN_EUZKADI = 35436UL,
      FI_EN_BN_EVEREST_BANK = 35437UL,
      FI_EN_BN_EVEREST = 35438UL,
      FI_EN_BN_EVOS = 35439UL,
      FI_EN_BN_EVRAZIYA = 35440UL,
      FI_EN_BN_EVROIL = 35441UL,
      FI_EN_BN_EWA = 35442UL,
      FI_EN_BN_EXCELSIOR_GAMA_SUPERMERCADOS = 35443UL,
      FI_EN_BN_EXCELSIOR = 35444UL,
      FI_EN_BN_EXCLUSIVE_HOTELS = 35445UL,
      FI_EN_BN_EXELLENT_ELECTRO = 35446UL,
      FI_EN_BN_EXHAUST_PROS = 35447UL,
      FI_EN_BN_EXPERT = 35448UL,
      FI_EN_BN_EXPO_DESIGN_CENTER = 35449UL,
      FI_EN_BN_EXPO_HOTELES_RESORT = 35450UL,
      FI_EN_BN_EXPRESS_BY_HOLIDAY_INN = 35451UL,
      FI_EN_BN_EXPRESS_FASHION = 35452UL,
      FI_EN_BN_EXPRESS_LUBE = 35453UL,
      FI_EN_BN_EXPRESS_OIL_CHANGE = 35454UL,
      FI_EN_BN_EXTENDED_STAYAMERICA = 35455UL,
      FI_EN_BN_EXTRA = 35456UL,
      FI_EN_BN_EXTRAZONE = 35457UL,
      FI_EN_BN_EXTREME_PITA = 35458UL,
      FI_EN_BN_EZ_LUBE = 35459UL,
      FI_EN_BN_F24 = 35460UL,
      FI_EN_BN_FABRICLAND = 35461UL,
      FI_EN_BN_FACES_CINEMA = 35462UL,
      FI_EN_BN_FAETON = 35463UL,
      FI_EN_BN_FAIRFIELD_RESORTS = 35464UL,
      FI_EN_BN_FAIRWEATHER = 35465UL,
      FI_EN_BN_FAKTA = 35466UL,
      FI_EN_BN_FALKENSTEINER = 35467UL,
      FI_EN_BN_FAMILA = 35468UL,
      FI_EN_BN_FAMILIA_HOTELS = 35469UL,
      FI_EN_BN_FAMILIA = 35470UL,
      FI_EN_BN_FAMILIPRIX = 35471UL,
      FI_EN_BN_FAMILOTEL = 35472UL,
      FI_EN_BN_FAMILY_COMPANY = 35473UL,
      FI_EN_BN_FAMILY_FARE = 35474UL,
      FI_EN_BN_FAMILY_GAME_CENTER = 35475UL,
      FI_EN_BN_FAMOUS_DAVES = 35476UL,
      FI_EN_BN_FAMOUS_FOOTWEAR = 35477UL,
      FI_EN_BN_FANTASTICO = 35478UL,
      FI_EN_BN_FARMA_RED = 35479UL,
      FI_EN_BN_FARMACIAS_BENAVIDES = 35480UL,
      FI_EN_BN_FARMACIAS_DEL_AHORRO = 35481UL,
      FI_EN_BN_FARMACIAS_GUADALAJARA = 35482UL,
      FI_EN_BN_FARMACIAS_SIMILARES = 35483UL,
      FI_EN_BN_FARMACITY = 35484UL,
      FI_EN_BN_FARMAKOR = 35485UL,
      FI_EN_BN_FARMAOFERTAS = 35486UL,
      FI_EN_BN_FARMATODO = 35487UL,
      FI_EN_BN_FARMER_BOYS = 35488UL,
      FI_EN_BN_FARMER_JACK = 35489UL,
      FI_EN_BN_FARNAS = 35490UL,
      FI_EN_BN_FARRUCO = 35491UL,
      FI_EN_BN_FAS_GAS = 35492UL,
      FI_EN_BN_FASHION_BUG = 35493UL,
      FI_EN_BN_FAST = 35494UL,
      FI_EN_BN_FAT_TUESDAY = 35495UL,
      FI_EN_BN_FATBURGER = 35496UL,
      FI_EN_BN_FAZOLIS = 35497UL,
      FI_EN_BN_FEDERAL_BANK = 35498UL,
      FI_EN_BN_FEDEX_OFFICE = 35499UL,
      FI_EN_BN_FEDEX = 35500UL,
      FI_EN_BN_FEIRA_NOVA = 35501UL,
      FI_EN_BN_FESTIBAL_CENTRE = 35502UL,
      FI_EN_BN_FEU_VERT = 35503UL,
      FI_EN_BN_FIBANKC = 35504UL,
      FI_EN_BN_FIDELITY_BANK = 35505UL,
      FI_EN_BN_FIDEURAM = 35506UL,
      FI_EN_BN_FIELDS = 35507UL,
      FI_EN_BN_FIESTA_INN = 35508UL,
      FI_EN_BN_FIFTH_THIRD_BANK = 35509UL,
      FI_EN_BN_FINANSBANK = 35510UL,
      FI_EN_BN_FINBANK = 35511UL,
      FI_EN_BN_FINECO = 35512UL,
      FI_EN_BN_FINIBANCO = 35513UL,
      FI_EN_BN_FINISH_LINE = 35514UL,
      FI_EN_BN_FINNKINO = 35515UL,
      FI_EN_BN_FINTRO = 35516UL,
      FI_EN_BN_FIONIA_BANK = 35517UL,
      FI_EN_BN_FIREHOUSE_SUBS = 35518UL,
      FI_EN_BN_FIRESTONE = 35519UL,
      FI_EN_BN_FIREZONE = 35520UL,
      FI_EN_BN_FIRST_ACTIVE = 35521UL,
      FI_EN_BN_FIRST_AMERICAN_BANK = 35522UL,
      FI_EN_BN_FIRST_BANK = 35523UL,
      FI_EN_BN_FIRST_CITY_MONUMENT_BANK = 35524UL,
      FI_EN_BN_FIRST_COMMERCIAL_BANK = 35525UL,
      FI_EN_BN_FIRST_COMMONWEALTH_BANK = 35526UL,
      FI_EN_BN_FIRST_FEDERAL = 35527UL,
      FI_EN_BN_FIRST_FINANCIAL_BANK = 35528UL,
      FI_EN_BN_FIRST_INDEPENDENT_BANK = 35529UL,
      FI_EN_BN_FIRST_INTERSTATE_BANK = 35530UL,
      FI_EN_BN_FIRST_INVESTMENT_BANK = 35531UL,
      FI_EN_BN_FIRST_MIDWEST_BANK = 35532UL,
      FI_EN_BN_FIRST_NATIONAL_BANK = 35533UL,
      FI_EN_BN_FIRST_NIAGARA = 35534UL,
      FI_EN_BN_FIRST_SOUTH_BANK = 35535UL,
      FI_EN_BN_FIRST_STOP = 35536UL,
      FI_EN_BN_FIRST_TENNESSEE_BANK = 35537UL,
      FI_EN_BN_FIRST_TRUST_BANK = 35538UL,
      FI_EN_BN_FIRST_WATCH = 35539UL,
      FI_EN_BN_FIRSTBANK = 35540UL,
      FI_EN_BN_FISH_MARKET = 35541UL,
      FI_EN_BN_FIVE_GUYS_BURGERS_AND_FRIES = 35542UL,
      FI_EN_BN_FLAG_HOTEL = 35543UL,
      FI_EN_BN_FLAMINGO_CINEMA = 35544UL,
      FI_EN_BN_FLAT_TOP_GRILL = 35545UL,
      FI_EN_BN_FLEETFUELS = 35546UL,
      FI_EN_BN_FLEMINGS_PRIME_STEAKHOUSE_WINE_BAR = 35547UL,
      FI_EN_BN_FLESSABANK = 35548UL,
      FI_EN_BN_FLOR_DO_CAFE = 35549UL,
      FI_EN_BN_FLUNCH = 35550UL,
      FI_EN_BN_FLYCAR = 35551UL,
      FI_EN_BN_FLYPARK = 35552UL,
      FI_EN_BN_FNAC = 35553UL,
      FI_EN_BN_FOKUS_BANK = 35554UL,
      FI_EN_BN_FOLKETS_BIO = 35555UL,
      FI_EN_BN_FOOD_BASICS = 35556UL,
      FI_EN_BN_FOOD_CITY = 35557UL,
      FI_EN_BN_FOOD_LION = 35558UL,
      FI_EN_BN_FOODLAND = 35559UL,
      FI_EN_BN_FOODWORLD = 35560UL,
      FI_EN_BN_FOOT_LOCKER = 35561UL,
      FI_EN_BN_FOOTACTION_USA = 35562UL,
      FI_EN_BN_FORD_RENT_A_CAR = 35563UL,
      FI_EN_BN_FOERDE_SPARKASSE = 35564UL,
      FI_EN_BN_FOREVER_21 = 35565UL,
      FI_EN_BN_FORMOSA = 35566UL,
      FI_EN_BN_FORMULA_ONE_AUTOCENTRES = 35567UL,
      FI_EN_BN_FORSTAEDERNES_BANK = 35568UL,
      FI_EN_BN_FORSTINGER = 35569UL,
      FI_EN_BN_FORTINOS = 35570UL,
      FI_EN_BN_FORTIS_BANK = 35571UL,
      FI_EN_BN_FORTIS_BANQUE = 35572UL,
      FI_EN_BN_FORTUNE = 35573UL,
      FI_EN_BN_FORUM_CINEMAS = 35574UL,
      FI_EN_BN_FOSTERS_FREEZE = 35575UL,
      FI_EN_BN_FOSTERS_HOLLYWOOD = 35576UL,
      FI_EN_BN_FOTEX = 35577UL,
      FI_EN_BN_FOUNTAIN_TIRE = 35578UL,
      FI_EN_BN_FOUR_POINTS_BY_SHERATON = 35579UL,
      FI_EN_BN_FOUR_STAR_PIZZA = 35580UL,
      FI_EN_BN_FOX_RENT_A_CAR = 35581UL,
      FI_EN_BN_FOXS_PIZZA_DEN = 35582UL,
      FI_EN_BN_FRANCOCAR = 35583UL,
      FI_EN_BN_FRANKFURTER_SPARKASSE = 35584UL,
      FI_EN_BN_FRANKFURTER_VOLKSBANK = 35585UL,
      FI_EN_BN_FRANPRIX = 35586UL,
      FI_EN_BN_FRANSMANNI = 35587UL,
      FI_EN_BN_FRED_MEYER_PHARMACY = 35588UL,
      FI_EN_BN_FREE_RECORD_SHOP = 35589UL,
      FI_EN_BN_FREEBIRDS_WORLD_BURRITO = 35590UL,
      FI_EN_BN_FREIBURGER_KANTONALBANK = 35591UL,
      FI_EN_BN_FRESC_CO = 35592UL,
      FI_EN_BN_FRESH_READY = 35593UL,
      FI_EN_BN_FRESH_CHOICE = 35594UL,
      FI_EN_BN_FRESH_CITY = 35595UL,
      FI_EN_BN_FRESH_MARKET = 35596UL,
      FI_EN_BN_FRESHENS_SMOOTHIE_COMPANY = 35597UL,
      FI_EN_BN_FRESSNAPF = 35598UL,
      FI_EN_BN_FRIDAYS = 35599UL,
      FI_EN_BN_FRIENDLY_SUPERMARKET = 35600UL,
      FI_EN_BN_FRIENDLYS = 35601UL,
      FI_EN_BN_FRIESLAND_BANK = 35602UL,
      FI_EN_BN_FRISCHS_BIG_BOY = 35603UL,
      FI_EN_BN_FROIZ = 35604UL,
      FI_EN_BN_FROST_BANK = 35605UL,
      FI_EN_BN_FRULLATI_CAFE = 35606UL,
      FI_EN_BN_FUDDRUCKERS = 35607UL,
      FI_EN_BN_FURGOCAR = 35608UL,
      FI_EN_BN_FURRS = 35609UL,
      FI_EN_BN_FUST = 35610UL,
      FI_EN_BN_FUTURA = 35611UL,
      FI_EN_BN_FUTURE_SHOP = 35612UL,
      FI_EN_BN_G_V = 35613UL,
      FI_EN_BN_G20 = 35614UL,
      FI_EN_BN_GABRIELS = 35615UL,
      FI_EN_BN_GADIS = 35616UL,
      FI_EN_BN_GAILLI_MARKEY = 35617UL,
      FI_EN_BN_GALAXIAS = 35618UL,
      FI_EN_BN_GALES = 35619UL,
      FI_EN_BN_GALICIA = 35620UL,
      FI_EN_BN_GALLERY_HOTELES = 35621UL,
      FI_EN_BN_GAMA = 35622UL,
      FI_EN_BN_GAMMA = 35623UL,
      FI_EN_BN_GAP = 35624UL,
      FI_EN_BN_GARANTI_BANKASI = 35625UL,
      FI_EN_BN_GARDEN_RIDGE = 35626UL,
      FI_EN_BN_GARFIELDS = 35627UL,
      FI_EN_BN_GARLAM = 35628UL,
      FI_EN_BN_GAERTNERBANK = 35629UL,
      FI_EN_BN_GAS_KING = 35630UL,
      FI_EN_BN_GAS_PLUS = 35631UL,
      FI_EN_BN_GAST_IM_SCHLOSS = 35632UL,
      FI_EN_BN_GAUMONT = 35633UL,
      FI_EN_BN_GAZ = 35634UL,
      FI_EN_BN_GAZPROM = 35635UL,
      FI_EN_BN_GAZPROMBANK = 35636UL,
      FI_EN_BN_GB_EXPRESS = 35637UL,
      FI_EN_BN_GB = 35638UL,
      FI_EN_BN_GE_MONEY_BANK = 35639UL,
      FI_EN_BN_GEANT_CASINO = 35640UL,
      FI_EN_BN_GEELY = 35641UL,
      FI_EN_BN_GENERAL_COOPERATIVE_BANK = 35642UL,
      FI_EN_BN_GENERALI_BANK = 35643UL,
      FI_EN_BN_GENIKI_BANK = 35644UL,
      FI_EN_BN_GEOX = 35645UL,
      FI_EN_BN_GETGO = 35646UL,
      FI_EN_BN_GETIN_BANK = 35647UL,
      FI_EN_BN_GIANT_DRUGSTORE = 35648UL,
      FI_EN_BN_GIANT_EAGLE = 35649UL,
      FI_EN_BN_GIANT_FOOD_STORES = 35650UL,
      FI_EN_BN_GIANT_GASOLINE = 35651UL,
      FI_EN_BN_GIANT_TIGER = 35652UL,
      FI_EN_BN_GIBBS = 35653UL,
      FI_EN_BN_GIEFFE = 35654UL,
      FI_EN_BN_GIFI = 35655UL,
      FI_EN_BN_GIGANTTI = 35656UL,
      FI_EN_BN_GIMENES = 35657UL,
      FI_EN_BN_GIMSA = 35658UL,
      FI_EN_BN_GINOS_EAST = 35659UL,
      FI_EN_BN_GINOS_PIZZA = 35660UL,
      FI_EN_BN_GINOSS_VIPS = 35661UL,
      FI_EN_BN_GLARNER_KANTONALBANK = 35662UL,
      FI_EN_BN_GLENS_MARKET = 35663UL,
      FI_EN_BN_GLOBAL_CASH = 35664UL,
      FI_EN_BN_GLOBAL_TRUST_BANK = 35665UL,
      FI_EN_BN_GLOBEKS = 35666UL,
      FI_EN_BN_GLOBI = 35667UL,
      FI_EN_BN_GLOBUS = 35668UL,
      FI_EN_BN_GLORIA_JEANS = 35669UL,
      FI_EN_BN_GLOU = 35670UL,
      FI_EN_BN_GNC = 35671UL,
      FI_EN_BN_GO_SPORT = 35672UL,
      FI_EN_BN_GOCO = 35673UL,
      FI_EN_BN_GODFATHERS = 35674UL,
      FI_EN_BN_GOLD_STAR_CHILI = 35675UL,
      FI_EN_BN_GOLDEN_CHICK = 35676UL,
      FI_EN_BN_GOLDEN_CORRAL = 35677UL,
      FI_EN_BN_GOLDEN_FORK = 35678UL,
      FI_EN_BN_GOLDEN_PALACE = 35679UL,
      FI_EN_BN_GOLDEN_TULIP_HOTELS_INNS_RESORTS = 35680UL,
      FI_EN_BN_GOLFF = 35681UL,
      FI_EN_BN_GOOD_EATS = 35682UL,
      FI_EN_BN_GOOD_TIME_BURGERS_FROZEN_CUSTARD = 35683UL,
      FI_EN_BN_GOODYEAR = 35684UL,
      FI_EN_BN_GOODYS = 35685UL,
      FI_EN_BN_GORENJSKA_BANKA = 35686UL,
      FI_EN_BN_G_PARK = 35687UL,
      FI_EN_BN_GRAN_MELIA_HOTELS_RESORTS = 35688UL,
      FI_EN_BN_GRAND_HOTEL_CONTINENTAL = 35689UL,
      FI_EN_BN_GRAND_HYATT = 35690UL,
      FI_EN_BN_GRAND_RESIDENCES_BY_MARRIOTT = 35691UL,
      FI_EN_BN_GRAND_UNION = 35692UL,
      FI_EN_BN_GRAND = 35693UL,
      FI_EN_BN_GRANDES_ETAPES_FRANCAISES = 35694UL,
      FI_EN_BN_GRAUBUENDNER_KANTONALBANK = 35695UL,
      FI_EN_BN_GREAT_AMERICAN_COOKIE = 35696UL,
      FI_EN_BN_GREAT_OUTDOORS = 35697UL,
      FI_EN_BN_GREAT_STEAK_FRY = 35698UL,
      FI_EN_BN_GREAT_STEAK_POTATO_COMPANY = 35699UL,
      FI_EN_BN_GREAT_WALL = 35700UL,
      FI_EN_BN_GREAT_WRAPS = 35701UL,
      FI_EN_BN_GRECOTEL = 35702UL,
      FI_EN_BN_GREENE_KING_INNS = 35703UL,
      FI_EN_BN_GREENS = 35704UL,
      FI_EN_BN_GREGORYS = 35705UL,
      FI_EN_BN_GRETELS_PRETZELS = 35706UL,
      FI_EN_BN_GRIGORIS = 35707UL,
      FI_EN_BN_GROS = 35708UL,
      FI_EN_BN_GROSSMART = 35709UL,
      FI_EN_BN_GROUND_ROUND = 35710UL,
      FI_EN_BN_GROUP_H_21 = 35711UL,
      FI_EN_BN_GRUP_DUSA = 35712UL,
      FI_EN_BN_GRUP_HATIPOGLU = 35713UL,
      FI_EN_BN_GS = 35714UL,
      FI_EN_BN_GTO = 35715UL,
      FI_EN_BN_GUARANTY_TRUST_BANK = 35716UL,
      FI_EN_BN_GUARDIAN = 35717UL,
      FI_EN_BN_GUITART_HOTELS = 35718UL,
      FI_EN_BN_GULLIVER = 35719UL,
      FI_EN_BN_GURGOAN_GRAMIN = 35720UL,
      FI_EN_BN_GYMBOREE = 35721UL,
      FI_EN_BN_H_M = 35722UL,
      FI_EN_BN_H10 = 35723UL,
      FI_EN_BN_HAAN = 35725UL,
      FI_EN_BN_HACIENDA_MEXICANA = 35726UL,
      FI_EN_BN_HACIOGLU = 35727UL,
      FI_EN_BN_HAGA_BANK = 35728UL,
      FI_EN_BN_HAGEBAU = 35729UL,
      FI_EN_BN_HAKMAR_EKSPRES = 35730UL,
      FI_EN_BN_HAKMAR = 35731UL,
      FI_EN_BN_HALFORDS = 35732UL,
      FI_EN_BN_HALIFAX_HISPANIA = 35733UL,
      FI_EN_BN_HALIFAX = 35734UL,
      FI_EN_BN_HALKBANK = 35735UL,
      FI_EN_BN_HALLHUBER = 35736UL,
      FI_EN_BN_HAMBURGER_SPARKASSE = 35737UL,
      FI_EN_BN_HAMBURGER_VOLKSBANK = 35738UL,
      FI_EN_BN_HAMPSHIRE = 35739UL,
      FI_EN_BN_HAMPTON_INN_SUITES = 35740UL,
      FI_EN_BN_HANCO = 35741UL,
      FI_EN_BN_HANCOCK_BANK = 35742UL,
      FI_EN_BN_HANDELSBANKEN = 35743UL,
      FI_EN_BN_HANNOVERSCHE_VOLKSBANK = 35744UL,
      FI_EN_BN_HANSABANKA = 35745UL,
      FI_EN_BN_HANSAPANK = 35746UL,
      FI_EN_BN_HANSEATIC_BANK = 35747UL,
      FI_EN_BN_HANWHA_BANK = 35748UL,
      FI_EN_BN_HAPPI_HOUSE = 35749UL,
      FI_EN_BN_HAPPY_BAR_GRILL = 35750UL,
      FI_EN_BN_HAPPY_CENTER = 35751UL,
      FI_EN_BN_HAPPY_FOOD = 35752UL,
      FI_EN_BN_HAPPY_RENT = 35753UL,
      FI_EN_BN_HARD_ROCK_CAFE = 35754UL,
      FI_EN_BN_HARD_ROCK_HOTEL = 35755UL,
      FI_EN_BN_HARDEES = 35756UL,
      FI_EN_BN_HARLEY_DAVIDSON = 35757UL,
      FI_EN_BN_HARRIS_BANK = 35758UL,
      FI_EN_BN_HARRY_AND_MAX = 35759UL,
      FI_EN_BN_HARTLAUER = 35760UL,
      FI_EN_BN_HARVEST_FOODS = 35761UL,
      FI_EN_BN_HARVEY_NORMAN = 35762UL,
      FI_EN_BN_HARVEYS = 35763UL,
      FI_EN_BN_HAWTHORN_SUITES_BY_WYNDHAM = 35764UL,
      FI_EN_BN_HBW_EXPRESS_TAKAREKSZOEVETKEZET = 35765UL,
      FI_EN_BN_HD_SUPPLY = 35766UL,
      FI_EN_BN_HDFC_BANK = 35767UL,
      FI_EN_BN_HEAVENLY_HAM = 35768UL,
      FI_EN_BN_H_E_B_PHARMACY = 35769UL,
      FI_EN_BN_H_E_B = 35770UL,
      FI_EN_BN_HEBROS_BANK = 35771UL,
      FI_EN_BN_HELLENIC_BANK = 35772UL,
      FI_EN_BN_HELLENIC_POSTBANK = 35773UL,
      FI_EN_BN_HELLO_HOTELS = 35774UL,
      FI_EN_BN_HELLWEG = 35775UL,
      FI_EN_BN_HEMA = 35776UL,
      FI_EN_BN_HEMKOEP = 35777UL,
      FI_EN_BN_HENRI_BENDEL = 35778UL,
      FI_EN_BN_HERFY = 35779UL,
      FI_EN_BN_HERTZ = 35780UL,
      FI_EN_BN_HERVIS = 35781UL,
      FI_EN_BN_HESBURGER = 35782UL,
      FI_EN_BN_HEYTENS = 35783UL,
      FI_EN_BN_HFC_BANK = 35784UL,
      FI_EN_BN_HHGREGG = 35785UL,
      FI_EN_BN_HIBERNIA = 35786UL,
      FI_EN_BN_HIGH_TECH_BURRITO = 35787UL,
      FI_EN_BN_HILTON_GARDEN_INN = 35788UL,
      FI_EN_BN_HILTON_GRAND_VACATIONS = 35789UL,
      FI_EN_BN_HIPER_USERA = 35790UL,
      FI_EN_BN_HIPERCOMPRA = 35791UL,
      FI_EN_BN_HIPERCOR = 35792UL,
      FI_EN_BN_HIPERSOL = 35793UL,
      FI_EN_BN_HIPPOPOTAMUS = 35794UL,
      FI_EN_BN_HI_Q = 35795UL,
      FI_EN_BN_HISTORIC_HOTELS_OF_SWEDEN = 35796UL,
      FI_EN_BN_HIT = 35797UL,
      FI_EN_BN_HL_MARKT = 35798UL,
      FI_EN_BN_HOBEES = 35799UL,
      FI_EN_BN_HOFER = 35800UL,
      FI_EN_BN_HOGI_YOGI = 35801UL,
      FI_EN_BN_HOLDEN_HDT = 35802UL,
      FI_EN_BN_HOLDEN_SPECIAL_VEHICLE = 35803UL,
      FI_EN_BN_HOLDEN = 35804UL,
      FI_EN_BN_HOLIDAY_INN_EXPRESS_HOTEL_SUITES = 35805UL,
      FI_EN_BN_HOLIDAY_INN_EXPRESS = 35806UL,
      FI_EN_BN_HOLIDAY_INN_GARDEN_COURT = 35807UL,
      FI_EN_BN_HOLIDAY_INN_HOTEL_SUITES = 35808UL,
      FI_EN_BN_HOLIDAY_INN_RESORT = 35809UL,
      FI_EN_BN_HOLIDAY_INN_SELECT_SUITES = 35810UL,
      FI_EN_BN_HOLIDAY_INN_SELECT = 35811UL,
      FI_EN_BN_HOLIDAY_INN_SUNSPREE_RESORT = 35812UL,
      FI_EN_BN_HOLIDAY_STATIONSTORES = 35813UL,
      FI_EN_BN_HOLLAND_BLUMEN_MARK = 35814UL,
      FI_EN_BN_HOLLAND_HOTELS = 35815UL,
      FI_EN_BN_HOLLYWOOD_MEGAPLEX = 35816UL,
      FI_EN_BN_HOLMES_PLACE = 35817UL,
      FI_EN_BN_HOME_FEDERAL_BANK = 35818UL,
      FI_EN_BN_HOME_HARDWARE = 35819UL,
      FI_EN_BN_HOME_MARKET = 35820UL,
      FI_EN_BN_HOME_SAVINGS_LOAN = 35821UL,
      FI_EN_BN_HOMEGOODS = 35822UL,
      FI_EN_BN_HOMESTEAD_STUDIO_SUITES = 35823UL,
      FI_EN_BN_HOMETOWN_BUFFET = 35824UL,
      FI_EN_BN_HONEYBAKED_HAM_COMPANY = 35825UL,
      FI_EN_BN_HONEYCOMBE_LEISURE = 35826UL,
      FI_EN_BN_HONG_KONG_EXPRESS = 35827UL,
      FI_EN_BN_HONSEL = 35828UL,
      FI_EN_BN_HOOTERS = 35829UL,
      FI_EN_BN_HORNBACH = 35830UL,
      FI_EN_BN_HOSPES = 35831UL,
      FI_EN_BN_HOSTA_PIKNIK = 35832UL,
      FI_EN_BN_HOT_N_NOW = 35833UL,
      FI_EN_BN_HOT_TOPIC = 35834UL,
      FI_EN_BN_HOTEL_INDIGO = 35835UL,
      FI_EN_BN_HOTELES_COTURSA = 35836UL,
      FI_EN_BN_HOTELS_BARRIERE = 35837UL,
      FI_EN_BN_HOTELS_ONIX = 35838UL,
      FI_EN_BN_HOTENCO_HOTELES = 35839UL,
      FI_EN_BN_HOTUSA = 35840UL,
      FI_EN_BN_HOULIHANS = 35841UL,
      FI_EN_BN_HOUSEHOLD_BANK = 35842UL,
      FI_EN_BN_HOYER = 35843UL,
      FI_EN_BN_HP = 35844UL,
      FI_EN_BN_HRVATSKA_POSTANSKA_BANKA = 35845UL,
      FI_EN_BN_HSBC = 35846UL,
      FI_EN_BN_HSV = 35847UL,
      FI_EN_BN_HUBO = 35848UL,
      FI_EN_BN_HUDDLE_HOUSE = 35849UL,
      FI_EN_BN_HUMANIC = 35850UL,
      FI_EN_BN_HUMPTYS = 35851UL,
      FI_EN_BN_HUNAN_CHINESE_RESTAURANT = 35852UL,
      FI_EN_BN_HUNGRY_HOWIES_PIZZA = 35853UL,
      FI_EN_BN_HUNGRY_HUNTER = 35854UL,
      FI_EN_BN_HUNTINGTON_NATIONAL_BANK = 35855UL,
      FI_EN_BN_HUNTINGTON = 35856UL,
      FI_EN_BN_HVB_BANK = 35857UL,
      FI_EN_BN_HYATT_HOTELS_RESORTS = 35858UL,
      FI_EN_BN_HYATT_PLACE = 35859UL,
      FI_EN_BN_HYATT_RESORTS = 35860UL,
      FI_EN_BN_HYATT_SUMMERFIELD_SUITES = 35861UL,
      FI_EN_BN_HYATT_VACATION_CLUB = 35862UL,
      FI_EN_BN_HYDRO = 35863UL,
      FI_EN_BN_HYPER_U = 35864UL,
      FI_EN_BN_HYPERNOVA = 35865UL,
      FI_EN_BN_HYPO = 35866UL,
      FI_EN_BN_HYPO_ALPE_ADRIA_BANK = 35867UL,
      FI_EN_BN_HYPOVEREINSBANK = 35868UL,
      FI_EN_BN_HY_VEE = 35869UL,
      FI_EN_BN_I_CANT_BELIEVE_ITS_YOGURT = 35870UL,
      FI_EN_BN_IBC_BANK = 35871UL,
      FI_EN_BN_IBERCAJA = 35872UL,
      FI_EN_BN_IBERDOEX = 35873UL,
      FI_EN_BN_IBERENT = 35874UL,
      FI_EN_BN_IBP = 35875UL,
      FI_EN_BN_IC_BANK = 35876UL,
      FI_EN_BN_ICA_BANK = 35877UL,
      FI_EN_BN_ICA_KVANTUM = 35878UL,
      FI_EN_BN_ICA_MAXI = 35879UL,
      FI_EN_BN_ICA_NAERA = 35880UL,
      FI_EN_BN_ICA_SUPERMARKET = 35881UL,
      FI_EN_BN_ICELAND = 35882UL,
      FI_EN_BN_ICICI_BANK = 35883UL,
      FI_EN_BN_ICING = 35884UL,
      FI_EN_BN_IDA = 35885UL,
      FI_EN_BN_IDBI_BANK = 35886UL,
      FI_EN_BN_IES = 35887UL,
      FI_EN_BN_IFA = 35888UL,
      FI_EN_BN_IGA = 35889UL,
      FI_EN_BN_IHOP = 35890UL,
      FI_EN_BN_IHR_PLATZ = 35891UL,
      FI_EN_BN_IIB_BANK = 35892UL,
      FI_EN_BN_III_FORKS = 35893UL,
      FI_EN_BN_IKBAL = 35894UL,
      FI_EN_BN_IKEA = 35895UL,
      FI_EN_BN_IKI = 35896UL,
      FI_EN_BN_IL_PATIO = 35897UL,
      FI_EN_BN_ILEKTRONIKI = 35898UL,
      FI_EN_BN_ILHA_VERDE = 35899UL,
      FI_EN_BN_IMAGIX = 35900UL,
      FI_EN_BN_IMAX = 35901UL,
      FI_EN_BN_IMC = 35902UL,
      FI_EN_BN_IMO_CARWASH = 35903UL,
      FI_EN_BN_INA = 35904UL,
      FI_EN_BN_INBURSA = 35905UL,
      FI_EN_BN_INDIAN_BANK = 35906UL,
      FI_EN_BN_INDIAN_OIL = 35907UL,
      FI_EN_BN_INDIAN_OVERSEAS_BANK = 35908UL,
      FI_EN_BN_INDO_MART = 35909UL,
      FI_EN_BN_INDRAPRASTHA = 35910UL,
      FI_EN_BN_INDUS = 35911UL,
      FI_EN_BN_INDUSIND_BANK = 35912UL,
      FI_EN_BN_ING_BANK_SLASKI = 35913UL,
      FI_EN_BN_ING_BANK = 35914UL,
      FI_EN_BN_ING_DIRECT = 35915UL,
      FI_EN_BN_ING_NATIONALE_NEDERLANDEN = 35916UL,
      FI_EN_BN_ING_VYSYA = 35917UL,
      FI_EN_BN_ING_DIBA = 35918UL,
      FI_EN_BN_INGLES_GAS_EXPRESS = 35919UL,
      FI_EN_BN_INGLES_MARKETS = 35920UL,
      FI_EN_BN_INGLES_PHARMACY = 35921UL,
      FI_EN_BN_INKASBANK = 35922UL,
      FI_EN_BN_INNO_GALERIA = 35923UL,
      FI_EN_BN_INNO = 35924UL,
      FI_EN_BN_IN_N_OUT_BURGER = 35925UL,
      FI_EN_BN_INNSIDE_PREMIUM_HOTELS = 35926UL,
      FI_EN_BN_INOKOM = 35927UL,
      FI_EN_BN_INOV = 35928UL,
      FI_EN_BN_INS = 35929UL,
      FI_EN_BN_INTERCONTINENTAL_BANK = 35930UL,
      FI_EN_BN_INTERCONTINENTAL = 35931UL,
      FI_EN_BN_INTERDISCOUNT = 35932UL,
      FI_EN_BN_INTER_EUROPA_BANK = 35933UL,
      FI_EN_BN_INTER_HOTEL = 35934UL,
      FI_EN_BN_INTERPARKING = 35935UL,
      FI_EN_BN_INTERSPAR = 35936UL,
      FI_EN_BN_INTERSPORT = 35937UL,
      FI_EN_BN_INVERSIS = 35938UL,
      FI_EN_BN_INVEST = 35939UL,
      FI_EN_BN_INVESTACOR = 35940UL,
      FI_EN_BN_INVESTBANK = 35941UL,
      FI_EN_BN_IPAR_KUTXA = 35942UL,
      FI_EN_BN_IPIRANGA = 35943UL,
      FI_EN_BN_IRISH_LIFE_AND_PERMANENT = 35944UL,
      FI_EN_BN_IRISH_NATIONWIDE_BUILDING_SOCIETY = 35945UL,
      FI_EN_BN_IRMA = 35946UL,
      FI_EN_BN_IS_BANK = 35947UL,
      FI_EN_BN_ISA = 35948UL,
      FI_EN_BN_ISAACS_RESTAURANT_DELI = 35949UL,
      FI_EN_BN_ISLANDS = 35950UL,
      FI_EN_BN_ISMAR = 35951UL,
      FI_EN_BN_ISO = 35952UL,
      FI_EN_BN_ISSIMO = 35953UL,
      FI_EN_BN_ISTROBANKA = 35954UL,
      FI_EN_BN_ITALIANNIS = 35955UL,
      FI_EN_BN_ITAU = 35956UL,
      FI_EN_BN_ITC = 35957UL,
      FI_EN_BN_IVARS = 35958UL,
      FI_EN_BN_IVECO = 35959UL,
      FI_EN_BN_IXE = 35960UL,
      FI_EN_BN_IXINA = 35961UL,
      FI_EN_BN_IZZI = 35962UL,
      FI_EN_BN_J_ALEXANDERS = 35963UL,
      FI_EN_BN_J_CREW = 35964UL,
      FI_EN_BN_J_JILL = 35965UL,
      FI_EN_BN_JACK_ASTORS = 35966UL,
      FI_EN_BN_JACK_IN_THE_BOX = 35967UL,
      FI_EN_BN_JAI_LAXMI_BANK = 35968UL,
      FI_EN_BN_JAMBA_JUICE = 35969UL,
      FI_EN_BN_JAMMU_KASHMIR_BANK = 35970UL,
      FI_EN_BN_JAN_LINDERS = 35971UL,
      FI_EN_BN_JANATA_SAHAKARI_BANK = 35972UL,
      FI_EN_BN_JANKALYAN_SAHAKARI_BANK = 35973UL,
      FI_EN_BN_JANSAHAKARI_BANK = 35974UL,
      FI_EN_BN_JANSEVA_SAHAKARI_BANK = 35975UL,
      FI_EN_BN_JASMIS = 35976UL,
      FI_EN_BN_JASONS_DELI = 35977UL,
      FI_EN_BN_JB_BOURNAZOS = 35978UL,
      FI_EN_BN_JBC = 35979UL,
      FI_EN_BN_JCPENNEY = 35980UL,
      FI_EN_BN_JEAN_COUTU = 35981UL,
      FI_EN_BN_JEDNOTA = 35982UL,
      FI_EN_BN_JENSENS_BOFHUS = 35983UL,
      FI_EN_BN_JERAS_JUICE = 35984UL,
      FI_EN_BN_JERRYS_SUBS_PIZZA = 35985UL,
      FI_EN_BN_JERSEY_MIKES_SUBS = 35986UL,
      FI_EN_BN_JESPAC = 35987UL,
      FI_EN_BN_JETOIL = 35988UL,
      FI_EN_BN_JEWEL_OSCO = 35989UL,
      FI_EN_BN_JIFFY_LUBE = 35990UL,
      FI_EN_BN_JIMMY_JOHNS = 35991UL,
      FI_EN_BN_JOCKEY = 35992UL,
      FI_EN_BN_JOES_CRAB_SHACK = 35993UL,
      FI_EN_BN_JOEYS_ONLY = 35994UL,
      FI_EN_BN_JOHNNY_ROCKETS = 35995UL,
      FI_EN_BN_JOHNSTON_MURPHY = 35996UL,
      FI_EN_BN_JOKER = 35997UL,
      FI_EN_BN_JONES_NEW_YORK = 35998UL,
      FI_EN_BN_JONES = 35999UL,
      FI_EN_BN_JOSEPHINOS = 36000UL,
      FI_EN_BN_JOUETLAND_B_COMME_BEBE = 36001UL,
      FI_EN_BN_JOUETLAND_BEBELAND = 36002UL,
      FI_EN_BN_JOUETLAND = 36003UL,
      FI_EN_BN_JOURNEYS = 36004UL,
      FI_EN_BN_JOY_HOTELS = 36005UL,
      FI_EN_BN_JPMORGAN_CHASE = 36006UL,
      FI_EN_BN_JRECK_SUBS = 36007UL,
      FI_EN_BN_JUAN_POLLO = 36008UL,
      FI_EN_BN_JUICE_IT_UP = 36009UL,
      FI_EN_BN_JUICE_STOP = 36010UL,
      FI_EN_BN_JUMBO = 36011UL,
      FI_EN_BN_JUMPIN_JUICE_JAVA = 36012UL,
      FI_EN_BN_JURKI = 36013UL,
      FI_EN_BN_JUST_BURGERS = 36014UL,
      FI_EN_BN_JUST_TIRES = 36015UL,
      FI_EN_BN_JUSTICE = 36016UL,
      FI_EN_BN_JW_MARRIOTT = 36017UL,
      FI_EN_BN_JYSKE_BANK = 36018UL,
      FI_EN_BN_K_H_BANK = 36019UL,
      FI_EN_BN_K_K = 36020UL,
      FI_EN_BN_KADOIL = 36021UL,
      FI_EN_BN_KAISERS = 36022UL,
      FI_EN_BN_KAL_TIRE = 36023UL,
      FI_EN_BN_KAOIL = 36024UL,
      FI_EN_BN_KARADAG = 36025UL,
      FI_EN_BN_KARMELKORN = 36026UL,
      FI_EN_BN_KARNATAKA_BANK = 36027UL,
      FI_EN_BN_KARO_FILM = 36028UL,
      FI_EN_BN_KARSTADT = 36029UL,
      FI_EN_BN_KARUR_VYSYA_BANK = 36030UL,
      FI_EN_BN_KARUSEL = 36031UL,
      FI_EN_BN_KASH_N_KARRY = 36032UL,
      FI_EN_BN_KASSELER_SPARKASSE = 36033UL,
      FI_EN_BN_KAUFHOF = 36034UL,
      FI_EN_BN_KAUFLAND = 36035UL,
      FI_EN_BN_KAUFMANN = 36036UL,
      FI_EN_BN_KAUFPARK = 36037UL,
      FI_EN_BN_KAV_AUTOVERHUUR = 36038UL,
      FI_EN_BN_KBC = 36039UL,
      FI_EN_BN_K_CITYMARKET = 36040UL,
      FI_EN_BN_KDB_BANK = 36041UL,
      FI_EN_BN_KEDDY = 36042UL,
      FI_EN_BN_KEISY = 36043UL,
      FI_EN_BN_KELSEYS = 36044UL,
      FI_EN_BN_KEM = 36045UL,
      FI_EN_BN_KENOL = 36046UL,
      FI_EN_BN_KEVA_JUICE = 36047UL,
      FI_EN_BN_K_EXTRA = 36048UL,
      FI_EN_BN_KEY = 36049UL,
      FI_EN_BN_KEYBANK = 36050UL,
      FI_EN_BN_KHOUM_KREDIT = 36051UL,
      FI_EN_BN_KIDS_CLASS = 36052UL,
      FI_EN_BN_KIDS_FOOT_LOCKER = 36053UL,
      FI_EN_BN_KIK = 36054UL,
      FI_EN_BN_KIKA = 36055UL,
      FI_EN_BN_KILER = 36056UL,
      FI_EN_BN_KILOUTOU = 36057UL,
      FI_EN_BN_KIM = 36058UL,
      FI_EN_BN_KIND_HOERGERAETE = 36059UL,
      FI_EN_BN_KINEPOLIS = 36060UL,
      FI_EN_BN_KINETIC_ENGINEERING = 36061UL,
      FI_EN_BN_KING_SOOPERS_PHARMACY = 36062UL,
      FI_EN_BN_KINGS_FAMILY_RESTAURANTS = 36063UL,
      FI_EN_BN_KINGS_SUPER_MARKETS = 36064UL,
      FI_EN_BN_KINOPLEX = 36065UL,
      FI_EN_BN_KIPA = 36066UL,
      FI_EN_BN_KIWI = 36067UL,
      FI_EN_BN_KLEIDERBAUER = 36068UL,
      FI_EN_BN_KLUBPETROL = 36069UL,
      FI_EN_BN_K_MARKET = 36070UL,
      FI_EN_BN_KMART_PHARMACY = 36071UL,
      FI_EN_BN_KMART = 36072UL,
      FI_EN_BN_KMOIL = 36073UL,
      FI_EN_BN_KM_PRONA = 36074UL,
      FI_EN_BN_KNAUBER = 36075UL,
      FI_EN_BN_KNOWFAT_LIFESTYLE_GRILLE = 36076UL,
      FI_EN_BN_KOA = 36077UL,
      FI_EN_BN_KOBIL = 36078UL,
      FI_EN_BN_KODI = 36079UL,
      FI_EN_BN_KOHLS = 36080UL,
      FI_EN_BN_KOELNER_BANK = 36081UL,
      FI_EN_BN_KOMART = 36082UL,
      FI_EN_BN_KOMERCNI_BANKA = 36083UL,
      FI_EN_BN_KOMMUNALKREDIT = 36084UL,
      FI_EN_BN_KONMAR = 36085UL,
      FI_EN_BN_KONSUM = 36086UL,
      FI_EN_BN_KONTAKT = 36087UL,
      FI_EN_BN_KONTANTEN = 36088UL,
      FI_EN_BN_KONYALI_HACI_USTA = 36089UL,
      FI_EN_BN_KONZUM = 36090UL,
      FI_EN_BN_KOO_KOO_ROO = 36091UL,
      FI_EN_BN_KOPEYKA = 36092UL,
      FI_EN_BN_KORUS = 36093UL,
      FI_EN_BN_KOSEBASI = 36094UL,
      FI_EN_BN_KOTAK_MAHINDRA_BANK = 36095UL,
      FI_EN_BN_KOTIPIZZA = 36096UL,
      FI_EN_BN_KOTSOVOLOS = 36097UL,
      FI_EN_BN_KOZMO = 36098UL,
      FI_EN_BN_KRAGEN_AUTO_PARTS = 36099UL,
      FI_EN_BN_KRAKOWSKI_BANK_SPOLDZIELCZY = 36100UL,
      FI_EN_BN_KREDIIDIPANK = 36101UL,
      FI_EN_BN_KREDIT_EVROPA_BANK = 36102UL,
      FI_EN_BN_KREDYT_BANK = 36103UL,
      FI_EN_BN_KREFEL = 36104UL,
      FI_EN_BN_KREISSPARKASSE_AHRWEILER = 36105UL,
      FI_EN_BN_KREISSPARKASSE_AUGSBURG = 36106UL,
      FI_EN_BN_KREISSPARKASSE_BITBURG_PRUEM = 36107UL,
      FI_EN_BN_KREISSPARKASSE_BOEBLINGEN = 36108UL,
      FI_EN_BN_KREISSPARKASSE_COCHEM_ZELL = 36109UL,
      FI_EN_BN_KREISSPARKASSE_ESSLINGEN_NUERTINGEN = 36110UL,
      FI_EN_BN_KREISSPARKASSE_FREUDENSTADT = 36111UL,
      FI_EN_BN_KREISSPARKASSE_GOEPPINGEN = 36112UL,
      FI_EN_BN_KREISSPARKASSE_GROSS_GERAU = 36113UL,
      FI_EN_BN_KREISSPARKASSE_HEILBRONN = 36114UL,
      FI_EN_BN_KREISSPARKASSE_HEINSBERG_ERKELENZ = 36115UL,
      FI_EN_BN_KREISSPARKASSE_KOELN = 36116UL,
      FI_EN_BN_KREISSPARKASSE_LUDWIGSBURG = 36117UL,
      FI_EN_BN_KREISSPARKASSE_MAYEN = 36118UL,
      FI_EN_BN_KREISSPARKASSE_MUENCHEN_STARNBERG = 36119UL,
      FI_EN_BN_KREISSPARKASSE_REUTLINGEN = 36120UL,
      FI_EN_BN_KREISSPARKASSE_SYKE = 36121UL,
      FI_EN_BN_KREISSPARKASSE_TUEBINGEN = 36122UL,
      FI_EN_BN_KREISSPARKASSE_TUTTLINGEN = 36123UL,
      FI_EN_BN_KREISSPARKASSE_WAIBLINGEN = 36124UL,
      FI_EN_BN_KREISSPARKASSE_WESERMUENDE_HADELN = 36125UL,
      FI_EN_BN_KRISPY_KREME = 36126UL,
      FI_EN_BN_KROGER_PHARMACY = 36127UL,
      FI_EN_BN_KROGER = 36128UL,
      FI_EN_BN_KRONOS = 36129UL,
      FI_EN_BN_KROSHKA_KARTOSHKA = 36130UL,
      FI_EN_BN_KRUIDVAT = 36131UL,
      FI_EN_BN_KRUZHKA = 36132UL,
      FI_EN_BN_KRYSTAL = 36133UL,
      FI_EN_BN_K_SUPERMARKET = 36134UL,
      FI_EN_BN_KUECHENTREFF = 36135UL,
      FI_EN_BN_KUDU = 36136UL,
      FI_EN_BN_KUTXA = 36137UL,
      FI_EN_BN_KUVEYTTURK = 36138UL,
      FI_EN_BN_KVARTAL = 36139UL,
      FI_EN_BN_KVICKLY = 36140UL,
      FI_EN_BN_KWIK_SAVE = 36141UL,
      FI_EN_BN_KWIK_FIT = 36142UL,
      FI_EN_BN_KYOTO_BOWL = 36143UL,
      FI_EN_BN_KYRIAD_PRESTIGE = 36144UL,
      FI_EN_BN_KYRIAD = 36145UL,
      FI_EN_BN_L_L_HAWAIIAN_BARBECUE = 36146UL,
      FI_EN_BN_LA_BAMBA = 36147UL,
      FI_EN_BN_LA_BANQUE_POSTALE = 36148UL,
      FI_EN_BN_LA_BELLE_PROVINCE = 36149UL,
      FI_EN_BN_LA_BOUCHERIE = 36150UL,
      FI_EN_BN_LA_CAGE_AUX_SPORTS = 36151UL,
      FI_EN_BN_LA_CAIXA = 36152UL,
      FI_EN_BN_LA_CAJA_DE_CANARIAS = 36153UL,
      FI_EN_BN_LA_CRIEE = 36154UL,
      FI_EN_BN_LA_FOIRFOUILLE = 36155UL,
      FI_EN_BN_LA_FOURMI = 36156UL,
      FI_EN_BN_LA_GRANDE_RECRE = 36157UL,
      FI_EN_BN_LA_MANSION = 36158UL,
      FI_EN_BN_LA_PASTERIA = 36159UL,
      FI_EN_BN_LA_PLATEFORME_DU_BATIMENT = 36160UL,
      FI_EN_BN_LA_QUINTA_INN_SUITES = 36161UL,
      FI_EN_BN_LA_QUINTA_INN = 36162UL,
      FI_EN_BN_LA_SALSA_FRESH_MEXICAN_GRILL = 36163UL,
      FI_EN_BN_LA_SALSA = 36164UL,
      FI_EN_BN_LA_SENZA = 36165UL,
      FI_EN_BN_LA_SIRENA = 36166UL,
      FI_EN_BN_LACOSTE = 36167UL,
      FI_EN_BN_LACTUCA = 36168UL,
      FI_EN_BN_LADY_FOOT_LOCKER = 36169UL,
      FI_EN_BN_LAIKI_BANK = 36170UL,
      FI_EN_BN_LAKSHMI_VILAS_BANK = 36171UL,
      FI_EN_BN_LALA_ARBON_CO_OP_BANK = 36172UL,
      FI_EN_BN_LANDBOUWKREDIET = 36173UL,
      FI_EN_BN_LANDESBANK_BADEN_WUERTTEMBERG = 36174UL,
      FI_EN_BN_LANDESBANK_BERLIN = 36175UL,
      FI_EN_BN_LANDESBAUSPARKASSE = 36176UL,
      FI_EN_BN_LANDESSPARKASSE_ZU_OLDENBURG = 36177UL,
      FI_EN_BN_LANDHOTELS = 36178UL,
      FI_EN_BN_LANDI = 36179UL,
      FI_EN_BN_LANDRYS_SEAFOOD_HOUSE = 36180UL,
      FI_EN_BN_LANDS_END = 36181UL,
      FI_EN_BN_LANDZEIT = 36182UL,
      FI_EN_BN_LANE_BRYANT = 36183UL,
      FI_EN_BN_LANIDOR = 36184UL,
      FI_EN_BN_LAENSFOERSAEKRINGAR = 36185UL,
      FI_EN_BN_LAPEYRE = 36186UL,
      FI_EN_BN_LAPIN_HOUSE = 36187UL,
      FI_EN_BN_LARCHE = 36188UL,
      FI_EN_BN_LARRYS_GIANT_SUBS = 36189UL,
      FI_EN_BN_LAS_ALITAS = 36190UL,
      FI_EN_BN_LAS_GAONERAS = 36191UL,
      FI_EN_BN_LASALLE_BANK = 36192UL,
      FI_EN_BN_LATEKO = 36193UL,
      FI_EN_BN_LATVIJAS_KRAJBANKA = 36194UL,
      FI_EN_BN_LATVIJAS_NAFTA = 36195UL,
      FI_EN_BN_LAUDAMOTION = 36196UL,
      FI_EN_BN_LAUREN = 36197UL,
      FI_EN_BN_LAURENTIAN_BANK = 36198UL,
      FI_EN_BN_LAUTO_E_LECLERC = 36199UL,
      FI_EN_BN_LAWTONS = 36200UL,
      FI_EN_BN_LCL = 36201UL,
      FI_EN_BN_LD_MARKET = 36202UL,
      FI_EN_BN_LE_BOEUF_JARDINIER = 36203UL,
      FI_EN_BN_LE_CHATEAU = 36204UL,
      FI_EN_BN_LE_MERIDIEN = 36205UL,
      FI_EN_BN_LE_PETIT_BOFINGER = 36206UL,
      FI_EN_BN_LEADER_PRICE = 36207UL,
      FI_EN_BN_LEADING_SMALL_HOTELS_OF_THE_WORLD = 36208UL,
      FI_EN_BN_LEASEPLAN = 36209UL,
      FI_EN_BN_LEE_ROY_SELMONS = 36210UL,
      FI_EN_BN_LEEANN_CHIN = 36211UL,
      FI_EN_BN_LEEDS_HOLBECK_BUILDING_SOCIETY = 36212UL,
      FI_EN_BN_LEEDS_BUILDING_SOCIETY = 36213UL,
      FI_EN_BN_LEEN_BAKKER = 36214UL,
      FI_EN_BN_LEGACY_HOTELS_RESORTS = 36215UL,
      FI_EN_BN_LEGAL_SEA_FOODS = 36216UL,
      FI_EN_BN_LENNYS_SUB_SHOP = 36217UL,
      FI_EN_BN_LENTA = 36218UL,
      FI_EN_BN_LENTZ_USA_MUFFLERS_BRAKES_SHOCKS = 36219UL,
      FI_EN_BN_LEON_DE_BRUXELLES = 36220UL,
      FI_EN_BN_LEONS = 36221UL,
      FI_EN_BN_LEPEEP_RESTAURANT = 36222UL,
      FI_EN_BN_LEROY_MERLIN = 36223UL,
      FI_EN_BN_LES_3_BRASSEURS = 36224UL,
      FI_EN_BN_LES_ROUTIERS = 36225UL,
      FI_EN_BN_LEVIS = 36226UL,
      FI_EN_BN_LEY = 36227UL,
      FI_EN_BN_LEYSIEFFER = 36228UL,
      FI_EN_BN_LIBERTY_BANK = 36229UL,
      FI_EN_BN_LIBERTY = 36230UL,
      FI_EN_BN_LIBRA_BANK = 36231UL,
      FI_EN_BN_LIDER = 36232UL,
      FI_EN_BN_LIDL = 36233UL,
      FI_EN_BN_LIDS = 36234UL,
      FI_EN_BN_LIECHTENSTEINISCHE_LANDESBANK_AG = 36235UL,
      FI_EN_BN_LIMITED_TOO = 36236UL,
      FI_EN_BN_LION_OF_PORCHES = 36237UL,
      FI_EN_BN_LIONS_CHOICE = 36238UL,
      FI_EN_BN_LIPPO_BANK = 36239UL,
      FI_EN_BN_LITTLE_CAESARS = 36240UL,
      FI_EN_BN_LIZ_CLAIBORNE = 36241UL,
      FI_EN_BN_LIZARRAN = 36242UL,
      FI_EN_BN_LLANO_PETROL = 36243UL,
      FI_EN_BN_LLOYDS_TSB = 36244UL,
      FI_EN_BN_LMG = 36245UL,
      FI_EN_BN_LML_INDIA = 36246UL,
      FI_EN_BN_LOBLAWS = 36247UL,
      FI_EN_BN_LOCALIZA = 36248UL,
      FI_EN_BN_LOCATEL = 36249UL,
      FI_EN_BN_LOGANS_ROADHOUSE = 36250UL,
      FI_EN_BN_LOKALBRUGSEN = 36251UL,
      FI_EN_BN_LOLLICUP_COFFEE_TEA = 36252UL,
      FI_EN_BN_LOMO = 36253UL,
      FI_EN_BN_LONDIS = 36254UL,
      FI_EN_BN_LONDON_DRUGS = 36255UL,
      FI_EN_BN_LONE_STAR_STEAKHOUSE_SALOON = 36256UL,
      FI_EN_BN_LONG_JOHN_SILVERS = 36257UL,
      FI_EN_BN_LONGHORN_STEAKHOUSE = 36258UL,
      FI_EN_BN_LONGOS = 36259UL,
      FI_EN_BN_LONGS_DRUGS = 36260UL,
      FI_EN_BN_LORAN_CAR_RENTAL = 36261UL,
      FI_EN_BN_LORD_KRISHNA_BANK = 36262UL,
      FI_EN_BN_LOS_ARCOS = 36263UL,
      FI_EN_BN_LOS_BISQUETS_BISQUETS_OBREGON = 36264UL,
      FI_EN_BN_LOTOS = 36265UL,
      FI_EN_BN_LOUIS_DELHAIZE = 36266UL,
      FI_EN_BN_LOWES = 36267UL,
      FI_EN_BN_LS_UK_ = 36268UL,
      FI_EN_BN_LUBYS = 36269UL,
      FI_EN_BN_LUCAS_SERVICE = 36270UL,
      FI_EN_BN_LUCKY_CINEMA = 36271UL,
      FI_EN_BN_LUCKYS_CAFE = 36272UL,
      FI_EN_BN_LUDENDO_VILLAGE = 36273UL,
      FI_EN_BN_LUDOVA_BANKA = 36274UL,
      FI_EN_BN_LUHMANN_TANKSTELLEN = 36275UL,
      FI_EN_BN_LUKAS_BANK = 36276UL,
      FI_EN_BN_LUKOIL = 36277UL,
      FI_EN_BN_LUMIERE = 36278UL,
      FI_EN_BN_LUNCH_GARDEN = 36279UL,
      FI_EN_BN_LUPA = 36280UL,
      FI_EN_BN_LUPILLOS = 36281UL,
      FI_EN_BN_LUSITANA = 36282UL,
      FI_EN_BN_LUSITANIA = 36283UL,
      FI_EN_BN_LUSSILE = 36284UL,
      FI_EN_BN_LUTHERS = 36285UL,
      FI_EN_BN_LUXAUTO = 36286UL,
      FI_EN_BN_LUXURY_COLLECTION_ARABELLA_ = 36287UL,
      FI_EN_BN_LUXURY_COLLECTION = 36288UL,
      FI_EN_BN_LUZERNER_KANTONALBANK = 36289UL,
      FI_EN_BN_LYON_PARC_AUTO = 36290UL,
      FI_EN_BN_M_I_BANK = 36291UL,
      FI_EN_BN_M_M_MEAT_SHOP = 36292UL,
      FI_EN_BN_M_S = 36293UL,
      FI_EN_BN_M_T_BANK = 36294UL,
      FI_EN_BN_MAACO = 36295UL,
      FI_EN_BN_MACE = 36296UL,
      FI_EN_BN_MACEWEN = 36297UL,
      FI_EN_BN_MACHEEZMO_MOUSE = 36298UL,
      FI_EN_BN_MACRO = 36299UL,
      FI_EN_BN_MACROCENTER = 36300UL,
      FI_EN_BN_MACS = 36301UL,
      FI_EN_BN_MACYS = 36302UL,
      FI_EN_BN_MADE_IN_JAPAN = 36303UL,
      FI_EN_BN_MAGGIANOS = 36304UL,
      FI_EN_BN_MAGGIORE = 36305UL,
      FI_EN_BN_MAGIC_LIFE = 36306UL,
      FI_EN_BN_MAGNET = 36307UL,
      FI_EN_BN_MAGNIT = 36308UL,
      FI_EN_BN_MAGNOLIYA = 36309UL,
      FI_EN_BN_MAHALAXMI_BANK = 36310UL,
      FI_EN_BN_MAHANAGAR_CO_OP_BANK = 36311UL,
      FI_EN_BN_MAHANAGAR = 36312UL,
      FI_EN_BN_MAHINDRA = 36313UL,
      FI_EN_BN_MAIDENFORM = 36314UL,
      FI_EN_BN_MAINSTAY_SUITES = 36315UL,
      FI_EN_BN_MAINZER_VOLKSBANK = 36316UL,
      FI_EN_BN_MAKPETROL = 36317UL,
      FI_EN_BN_MAKRO = 36318UL,
      FI_EN_BN_MAKROMARKET = 36319UL,
      FI_EN_BN_MAM_LIMITED = 36320UL,
      FI_EN_BN_MAN = 36321UL,
      FI_EN_BN_MANASEER = 36322UL,
      FI_EN_BN_MANCHU_WOK = 36323UL,
      FI_EN_BN_MANCINOS_PIZZA_GRINDERS = 36324UL,
      FI_EN_BN_MANDARIN_ORIENTAL = 36325UL,
      FI_EN_BN_MANGO = 36326UL,
      FI_EN_BN_MANIA = 36327UL,
      FI_EN_BN_MANOR = 36328UL,
      FI_EN_BN_MANSINGH_GROUP = 36329UL,
      FI_EN_BN_MARBLE_SLAB_CREAMERY = 36330UL,
      FI_EN_BN_MARCHE_PLUS = 36331UL,
      FI_EN_BN_MARCHE_U = 36332UL,
      FI_EN_BN_MARCONFORT = 36333UL,
      FI_EN_BN_MARCOS_PIZZA = 36334UL,
      FI_EN_BN_MAREDO = 36335UL,
      FI_EN_BN_MAREES = 36336UL,
      FI_EN_BN_MARFIN_BANK = 36337UL,
      FI_EN_BN_MARFIN_EGNATIA_BANK = 36338UL,
      FI_EN_BN_MARGHERITA = 36339UL,
      FI_EN_BN_MARIE_CALLENDERS = 36340UL,
      FI_EN_BN_MARINOPOULOS = 36341UL,
      FI_EN_BN_MARK_PIS = 36342UL,
      FI_EN_BN_MARK = 36343UL,
      FI_EN_BN_MARKA = 36344UL,
      FI_EN_BN_MARKANTALO = 36345UL,
      FI_EN_BN_MARKS_SPENCER = 36346UL,
      FI_EN_BN_MARKS_WORK_WEARHOUSE = 36347UL,
      FI_EN_BN_MARKTKAUF = 36348UL,
      FI_EN_BN_MARRACHINHO = 36349UL,
      FI_EN_BN_MARRIOTT_VACATION_CLUB = 36350UL,
      FI_EN_BN_MARSHALL_ILSLEY_CORP = 36351UL,
      FI_EN_BN_MARSHALLS = 36352UL,
      FI_EN_BN_MARTINS_DRUGSTORE = 36353UL,
      FI_EN_BN_MARTINS_FOOD_MARKETS = 36354UL,
      FI_EN_BN_MARTINS_GASOLINE = 36355UL,
      FI_EN_BN_MARUTI = 36356UL,
      FI_EN_BN_MARY_BROWNS_FRIED_CHICKEN = 36357UL,
      FI_EN_BN_MAS_Y_MAS = 36358UL,
      FI_EN_BN_MAS = 36359UL,
      FI_EN_BN_MASKOMO = 36360UL,
      FI_EN_BN_MASOUTIS = 36361UL,
      FI_EN_BN_MASSIMO_DUTTI = 36362UL,
      FI_EN_BN_MASTER_BANK = 36363UL,
      FI_EN_BN_MASTERFIT = 36364UL,
      FI_EN_BN_MASYMAS = 36365UL,
      FI_EN_BN_MATOEPPET = 36366UL,
      FI_EN_BN_MATOU_FRANCE = 36367UL,
      FI_EN_BN_MAURICES_BBQ = 36368UL,
      FI_EN_BN_MAX_ERMAS = 36369UL,
      FI_EN_BN_MAX_BAHR = 36370UL,
      FI_EN_BN_MAX = 36371UL,
      FI_EN_BN_MAXCOOP = 36372UL,
      FI_EN_BN_MAXI = 36373UL,
      FI_EN_BN_MAXIMA = 36374UL,
      FI_EN_BN_MAXMAT = 36375UL,
      FI_EN_BN_MAXRAVE = 36376UL,
      FI_EN_BN_MAYBANK = 36377UL,
      FI_EN_BN_MAZATLAN_MEXICAN_RESTAURANT = 36378UL,
      FI_EN_BN_MAZZIOS = 36379UL,
      FI_EN_BN_MB_FINANCIAL = 36380UL,
      FI_EN_BN_MBANK = 36381UL,
      FI_EN_BN_MBNA_CORP = 36382UL,
      FI_EN_BN_MBRR = 36383UL,
      FI_EN_BN_MCALISTERS_DELI = 36384UL,
      FI_EN_BN_MCCORMICK_SCHMICKS = 36385UL,
      FI_EN_BN_MCD = 36386UL,
      FI_EN_BN_MCDONALDS = 36387UL,
      FI_EN_BN_MCL_CAFETERIA = 36388UL,
      FI_EN_BN_MDM_BANK = 36389UL,
      FI_EN_BN_ME_BY_MELIA = 36390UL,
      FI_EN_BN_MEDAS = 36391UL,
      FI_EN_BN_MEDEIA = 36392UL,
      FI_EN_BN_MEDIA_MARKT = 36393UL,
      FI_EN_BN_MEDIA_WORLD = 36394UL,
      FI_EN_BN_MEDIAN_HOTELS = 36395UL,
      FI_EN_BN_MEDICINE_SHOPPE = 36396UL,
      FI_EN_BN_MEDICINOS_BANKAS = 36397UL,
      FI_EN_BN_MEDIMAX = 36398UL,
      FI_EN_BN_MEDIUM_HOTELES = 36399UL,
      FI_EN_BN_MEDOIL = 36400UL,
      FI_EN_BN_MEDUSA_CINEMA = 36401UL,
      FI_EN_BN_MEGA_CGR = 36402UL,
      FI_EN_BN_MEGA_MARINA = 36403UL,
      FI_EN_BN_MEGA_WRAPS = 36404UL,
      FI_EN_BN_MEGA_OYL = 36405UL,
      FI_EN_BN_MEGO = 36406UL,
      FI_EN_BN_MEIJER_GAS_STATION = 36407UL,
      FI_EN_BN_MEIJER_PHARMACY = 36408UL,
      FI_EN_BN_MEINEKE_CAR_CARE_CENTER = 36409UL,
      FI_EN_BN_MEKONOMEN = 36410UL,
      FI_EN_BN_MELIA_HOTELS_RESORTS = 36411UL,
      FI_EN_BN_MELLON = 36412UL,
      FI_EN_BN_MEMA = 36413UL,
      FI_EN_BN_MENARDS = 36414UL,
      FI_EN_BN_MENS_WEARHOUSE = 36415UL,
      FI_EN_BN_MENY = 36416UL,
      FI_EN_BN_MERCADONA = 36417UL,
      FI_EN_BN_MERCANTILE_BSHRS_CORP = 36418UL,
      FI_EN_BN_MERCATOR = 36419UL,
      FI_EN_BN_MERCHANTS_BANK = 36420UL,
      FI_EN_BN_MERIDIAN_CREDIT_UNION = 36421UL,
      FI_EN_BN_MERKUR = 36422UL,
      FI_EN_BN_MERLE_NORMAN = 36423UL,
      FI_EN_BN_MERRAL = 36424UL,
      FI_EN_BN_MERVYNS = 36425UL,
      FI_EN_BN_MESHUR_PEYNIRCI = 36426UL,
      FI_EN_BN_META = 36427UL,
      FI_EN_BN_METAX = 36428UL,
      FI_EN_BN_METEOR_PARKING = 36429UL,
      FI_EN_BN_METRO = 36430UL,
      FI_EN_BN_MEXX = 36431UL,
      FI_EN_BN_MGALLERY = 36432UL,
      FI_EN_BN_MI_VIEJO_PUEBLITO = 36433UL,
      FI_EN_BN_MIAMI_SUBS_GRILL = 36434UL,
      FI_EN_BN_MICROMANIA = 36435UL,
      FI_EN_BN_MICROTEL_INNS_SUITES = 36436UL,
      FI_EN_BN_MIDAS = 36437UL,
      FI_EN_BN_MIDFIRST_BANK = 36438UL,
      FI_EN_BN_MID_STATE_BANK_TRUST = 36439UL,
      FI_EN_BN_MIGATO = 36440UL,
      FI_EN_BN_MIGROS = 36441UL,
      FI_EN_BN_MIGROSBANK = 36442UL,
      FI_EN_BN_MILESTONES = 36443UL,
      FI_EN_BN_MILIOS_SANDWICHES = 36444UL,
      FI_EN_BN_MILLENIUM_BANK = 36445UL,
      FI_EN_BN_MILLENIUM = 36446UL,
      FI_EN_BN_MILLENNIUM_BANK = 36447UL,
      FI_EN_BN_MILLENNIUM_BCP = 36448UL,
      FI_EN_BN_MIMIS_CAFE = 36449UL,
      FI_EN_BN_MINI_PRECO = 36450UL,
      FI_EN_BN_MINIMAL = 36451UL,
      FI_EN_BN_MINIPRECO_DIA = 36452UL,
      FI_EN_BN_MINIPRECO = 36453UL,
      FI_EN_BN_MIRACLE_EAR = 36454UL,
      FI_EN_BN_MISAS = 36455UL,
      FI_EN_BN_MISR = 36456UL,
      FI_EN_BN_MISS_KAPRIZ = 36457UL,
      FI_EN_BN_MISSONI = 36458UL,
      FI_EN_BN_MISTER_LADY = 36459UL,
      FI_EN_BN_MISTER_PIZZA = 36460UL,
      FI_EN_BN_MISTER_TRANSMISSION = 36461UL,
      FI_EN_BN_MITCHELLS_FISH_MARKET = 36462UL,
      FI_EN_BN_MITSUOKA = 36463UL,
      FI_EN_BN_MITTELBRANDENBURGISCHE_SPARKASSE = 36464UL,
      FI_EN_BN_MK2 = 36465UL,
      FI_EN_BN_MKB_BANK = 36466UL,
      FI_EN_BN_MKB_ROMEXTERRA_BANK = 36467UL,
      FI_EN_BN_MKB_UNIONBANK = 36468UL,
      FI_EN_BN_MOEBELIX = 36469UL,
      FI_EN_BN_MOBISTAR_CENTER = 36470UL,
      FI_EN_BN_MOCA_LOCA = 36471UL,
      FI_EN_BN_MOCHA = 36472UL,
      FI_EN_BN_MODALFA = 36473UL,
      FI_EN_BN_MODELO = 36474UL,
      FI_EN_BN_MODERN = 36475UL,
      FI_EN_BN_MOES_SOUTHWEST_GRILL = 36476UL,
      FI_EN_BN_MOIL = 36477UL,
      FI_EN_BN_MOL = 36478UL,
      FI_EN_BN_MONICAL_PIZZA = 36479UL,
      FI_EN_BN_MONOP = 36480UL,
      FI_EN_BN_MONOPRIX = 36481UL,
      FI_EN_BN_MONRIF = 36482UL,
      FI_EN_BN_MONRO_MUFFLER_BRAKE_SERVICE = 36483UL,
      FI_EN_BN_MONTANA_MIKES = 36484UL,
      FI_EN_BN_MONTANAS = 36485UL,
      FI_EN_BN_MONTE_DEI_PASCHI_DI_SIENA = 36486UL,
      FI_EN_BN_MONTEPIO_GERAL = 36487UL,
      FI_EN_BN_MONTEPIO = 36488UL,
      FI_EN_BN_MONTO_MOTORS = 36489UL,
      FI_EN_BN_MONTSERRAT = 36490UL,
      FI_EN_BN_MOORES = 36491UL,
      FI_EN_BN_MOPAS = 36492UL,
      FI_EN_BN_MORRIS_OIL = 36493UL,
      FI_EN_BN_MORTONS = 36494UL,
      FI_EN_BN_MOSKOVSKIY_INDUSTRIALNIY_BANK = 36495UL,
      FI_EN_BN_MOSKVICH = 36496UL,
      FI_EN_BN_MOTEL_ONE = 36497UL,
      FI_EN_BN_MOTHERCARE = 36498UL,
      FI_EN_BN_MOTHERHOOD_MATERNITY = 36499UL,
      FI_EN_BN_MOVIE_STAR = 36500UL,
      FI_EN_BN_MOXIES = 36501UL,
      FI_EN_BN_MPREIS = 36502UL,
      FI_EN_BN_MR_BIGGS = 36503UL,
      FI_EN_BN_MR_CLUTCH = 36504UL,
      FI_EN_BN_MR_GOODCENTS_SUBS_PASTAS = 36505UL,
      FI_EN_BN_MR_HERO = 36506UL,
      FI_EN_BN_MR_JIMS_PIZZA = 36507UL,
      FI_EN_BN_MR_LUBE = 36508UL,
      FI_EN_BN_MR_MUFFLER = 36509UL,
      FI_EN_BN_MR_PITA = 36510UL,
      FI_EN_BN_MR_SMOOTHIE = 36511UL,
      FI_EN_BN_MR_SUB = 36512UL,
      FI_EN_BN_MR_BRICOLAGE = 36513UL,
      FI_EN_BN_MRS_FIELDS = 36514UL,
      FI_EN_BN_MRS_VANELLIS = 36515UL,
      FI_EN_BN_MTEL_IMAX_3D = 36516UL,
      FI_EN_BN_MTK = 36517UL,
      FI_EN_BN_MUELLER = 36518UL,
      FI_EN_BN_MULTIBANK = 36519UL,
      FI_EN_BN_MULTIBANKA = 36520UL,
      FI_EN_BN_MULTICAJA = 36521UL,
      FI_EN_BN_MULTIKINO = 36522UL,
      FI_EN_BN_MULTIMARKET = 36523UL,
      FI_EN_BN_MULTIPLEX_UNITED_NEW_CINEMA = 36524UL,
      FI_EN_BN_MUMBAI_DISTRICT_CENTRAL_CO_OP_BANK = 36525UL,
      FI_EN_BN_MU_MU = 36526UL,
      FI_EN_BN_MUNDICENTER = 36527UL,
      FI_EN_BN_MURPHY_EXPRESS = 36528UL,
      FI_EN_BN_MURPHY_USA = 36529UL,
      FI_EN_BN_MURPHYS_DELI = 36530UL,
      FI_EN_BN_MUSTANG_CINEMA = 36531UL,
      FI_EN_BN_MY_MARKET_METRO = 36532UL,
      FI_EN_BN_MY_SUITE_APPART_HOTELS = 36533UL,
      FI_EN_BN_N1 = 36534UL,
      FI_EN_BN_NACIONAL = 36535UL,
      FI_EN_BN_NAH_FRISCH = 36536UL,
      FI_EN_BN_NAIF_CHICKEN = 36537UL,
      FI_EN_BN_NAKHODKA = 36538UL,
      FI_EN_BN_NANDOS = 36539UL,
      FI_EN_BN_NANZ = 36540UL,
      FI_EN_BN_NAPA_AUTO_PARTS = 36541UL,
      FI_EN_BN_NAPA_AUTOCARE_CENTER = 36542UL,
      FI_EN_BN_NASSAUISCHE_SPARKASSE = 36543UL,
      FI_EN_BN_NATHANS_FAMOUS = 36544UL,
      FI_EN_BN_NATIONAL_ATESA = 36545UL,
      FI_EN_BN_NATIONAL_AUSTRALIA_BANK = 36546UL,
      FI_EN_BN_NATIONAL_BANK_OF_AGR_AND_DVLPT = 36547UL,
      FI_EN_BN_NATIONAL_BANK_OF_ARIZONA = 36548UL,
      FI_EN_BN_NATIONAL_BANK_OF_GREECE = 36549UL,
      FI_EN_BN_NATIONAL_BANK = 36550UL,
      FI_EN_BN_NATIONAL_CAR_PARKS = 36551UL,
      FI_EN_BN_NATIONAL_CAR_RENTAL = 36552UL,
      FI_EN_BN_NATIONAL_CITY_BANK = 36553UL,
      FI_EN_BN_NATIONAL_CO_OP_BANK = 36554UL,
      FI_EN_BN_NATIONAL_IRISH_BANK = 36555UL,
      FI_EN_BN_NATIONAL_OIL = 36556UL,
      FI_EN_BN_NATIONAL_TYRES_AUTOCARE = 36557UL,
      FI_EN_BN_NATIONAL_CITER = 36558UL,
      FI_EN_BN_NATIONWIDE_AUTOCENTRE = 36559UL,
      FI_EN_BN_NATIONWIDE_BUILDING_SOCIETY = 36560UL,
      FI_EN_BN_NATIONWIDE_CRASH_REPAIR_CENTRE = 36561UL,
      FI_EN_BN_NATUR_PRODUKT = 36562UL,
      FI_EN_BN_NATURASI = 36563UL,
      FI_EN_BN_NATURES_BASKET = 36564UL,
      FI_EN_BN_NATURES_TABLE_CAFE = 36565UL,
      FI_EN_BN_NATWEST = 36566UL,
      FI_EN_BN_NAZA = 36567UL,
      FI_EN_BN_NAZAR = 36568UL,
      FI_EN_BN_NBC_CAPITAL_CORP = 36569UL,
      FI_EN_BN_NCP = 36570UL,
      FI_EN_BN_NEDBANK = 36571UL,
      FI_EN_BN_NEEDS = 36572UL,
      FI_EN_BN_NEHODA_CZ = 36573UL,
      FI_EN_BN_NELDA = 36574UL,
      FI_EN_BN_NEOBANK = 36575UL,
      FI_EN_BN_NEOS_BANCA = 36576UL,
      FI_EN_BN_NESPRESSO = 36577UL,
      FI_EN_BN_NETTO = 36578UL,
      FI_EN_BN_NETTORAMA = 36579UL,
      FI_EN_BN_NEUE_AARGAUER_BANK = 36580UL,
      FI_EN_BN_NEVIS = 36581UL,
      FI_EN_BN_NEW_CHINA_BUFFET = 36582UL,
      FI_EN_BN_NEW_YORK_COMPANY = 36583UL,
      FI_EN_BN_NEW_YORK_COMMUNITY_BANK = 36584UL,
      FI_EN_BN_NEW_YORK_FRIES = 36585UL,
      FI_EN_BN_NEW_YORK_PIZZERIA = 36586UL,
      FI_EN_BN_NEW_YORKER = 36587UL,
      FI_EN_BN_NEWCASTLE_BUILDING_SOCIETY = 36588UL,
      FI_EN_BN_NEX = 36589UL,
      FI_EN_BN_NGVC = 36590UL,
      FI_EN_BN_NICKELODEON_FAMILY_SUITES = 36591UL,
      FI_EN_BN_NIDWALDNER_KANTONALBANK = 36592UL,
      FI_EN_BN_NIEDERMEYER = 36593UL,
      FI_EN_BN_NIEDEROESTERREICHISCHE_LANDESBANK = 36594UL,
      FI_EN_BN_NIKE = 36595UL,
      FI_EN_BN_NILGIRIS = 36596UL,
      FI_EN_BN_NINE_WEST = 36597UL,
      FI_EN_BN_NIS = 36598UL,
      FI_EN_BN_NISA = 36599UL,
      FI_EN_BN_NKD = 36600UL,
      FI_EN_BN_NO_FRILLS = 36601UL,
      FI_EN_BN_NOAL_OIL = 36602UL,
      FI_EN_BN_NOB_HILL_FOODS = 36603UL,
      FI_EN_BN_NOKIA = 36604UL,
      FI_EN_BN_NOMOS_BANK = 36605UL,
      FI_EN_BN_NOODLES_COMPANY = 36606UL,
      FI_EN_BN_NOR_HOTELS = 36607UL,
      FI_EN_BN_NORAUTO = 36608UL,
      FI_EN_BN_NORD_LB = 36609UL,
      FI_EN_BN_NORDDEUTSCHE_LANDESBANK = 36610UL,
      FI_EN_BN_NORDEA = 36611UL,
      FI_EN_BN_NORDISK_FILM = 36612UL,
      FI_EN_BN_NORDJYSKE_BANK = 36613UL,
      FI_EN_BN_NORDSEE = 36614UL,
      FI_EN_BN_NORDSTROM = 36615UL,
      FI_EN_BN_NORFA = 36616UL,
      FI_EN_BN_NORISBANK = 36617UL,
      FI_EN_BN_NORMA = 36618UL,
      FI_EN_BN_NORSK_KINO = 36619UL,
      FI_EN_BN_NORTH_KANARA_GSB_CO_OP_BANK = 36620UL,
      FI_EN_BN_NORTHEAST_BANK = 36621UL,
      FI_EN_BN_NORTHERN_BANK = 36622UL,
      FI_EN_BN_NORTHERN_REFLECTIONS = 36623UL,
      FI_EN_BN_NORTHERN_ROCK = 36624UL,
      FI_EN_BN_NORTHERN_TRUST = 36625UL,
      FI_EN_BN_NORTHWEST_TIRE_SERVICE = 36626UL,
      FI_EN_BN_NORWICH_PETERBOROUGH_BS = 36627UL,
      FI_EN_BN_NOTHING_BUT_NOODLES = 36628UL,
      FI_EN_BN_NOTTINGHAM_BUILDING_SOCIETY = 36629UL,
      FI_EN_BN_NOVA_INVEST = 36630UL,
      FI_EN_BN_NOVA_KREDITNA_BANKA_MARIBOR = 36631UL,
      FI_EN_BN_NOVA_LJUBLJANSKA_BANKA = 36632UL,
      FI_EN_BN_NOVABANK = 36633UL,
      FI_EN_BN_NOVGORODNEFTEPRODUKT = 36634UL,
      FI_EN_BN_NOVO = 36635UL,
      FI_EN_BN_NOVOSIBIRSKNEFTEPRODUKT = 36636UL,
      FI_EN_BN_NP_MARKT = 36637UL,
      FI_EN_BN_NU_METRO = 36638UL,
      FI_EN_BN_NUNEZ_I_NAVARRO_HOTELS = 36639UL,
      FI_EN_BN_O_MAMMA_MIA = 36640UL,
      FI_EN_BN_O_SHIPKA = 36641UL,
      FI_EN_BN_OANDO = 36642UL,
      FI_EN_BN_OB = 36643UL,
      FI_EN_BN_OBERBANK = 36644UL,
      FI_EN_BN_OBEROI = 36645UL,
      FI_EN_BN_OBI = 36646UL,
      FI_EN_BN_OBK = 36647UL,
      FI_EN_BN_OBSHTINSKA_BANKA = 36648UL,
      FI_EN_BN_OBWALDNER_KANTONALBANK = 36649UL,
      FI_EN_BN_OCCIDENTAL_HOTELES = 36650UL,
      FI_EN_BN_OCEAN_BASKET = 36651UL,
      FI_EN_BN_OCEANIA_HOTELS = 36652UL,
      FI_EN_BN_OCEANIC_BANK = 36653UL,
      FI_EN_BN_OCHARLEYS = 36654UL,
      FI_EN_BN_ODALYS = 36655UL,
      FI_EN_BN_ODEON = 36656UL,
      FI_EN_BN_OEKOTEL = 36657UL,
      FI_EN_BN_OERAL = 36658UL,
      FI_EN_BN_OFFICE_DEPOT = 36659UL,
      FI_EN_BN_OFFICEMAX = 36660UL,
      FI_EN_BN_OIL_ = 36661UL,
      FI_EN_BN_OILIBYA = 36662UL,
      FI_EN_BN_OK_GROCER = 36663UL,
      FI_EN_BN_OK_TIRE = 36664UL,
      FI_EN_BN_OKEY = 36665UL,
      FI_EN_BN_OKTAN = 36666UL,
      FI_EN_BN_OLD_COUNTRY_BUFFET = 36667UL,
      FI_EN_BN_OLD_ENGLISH_INNS = 36668UL,
      FI_EN_BN_OLD_MUTUAL_BANK = 36669UL,
      FI_EN_BN_OLD_NAVY = 36670UL,
      FI_EN_BN_OLDENBURGISCHE_LANDESBANK = 36671UL,
      FI_EN_BN_OLEARYS = 36672UL,
      FI_EN_BN_OLEREX = 36673UL,
      FI_EN_BN_OLGA = 36674UL,
      FI_EN_BN_OLGAS_KITCHEN = 36675UL,
      FI_EN_BN_OLIS = 36676UL,
      FI_EN_BN_OLIVE_GARDEN = 36677UL,
      FI_EN_BN_OLIVIER_STRELLI = 36678UL,
      FI_EN_BN_OLYMPIA_SPORTS = 36679UL,
      FI_EN_BN_OMAN_OIL = 36680UL,
      FI_EN_BN_OMNI_HOTELS = 36681UL,
      FI_EN_BN_OMNIPLEX = 36682UL,
      FI_EN_BN_OMV_ISTRABENZ = 36683UL,
      FI_EN_BN_ON_THE_BORDER = 36684UL,
      FI_EN_BN_ONCE_UPON_A_CHILD = 36685UL,
      FI_EN_BN_ONCU = 36686UL,
      FI_EN_BN_ONOFF = 36687UL,
      FI_EN_BN_OPENBANK = 36688UL,
      FI_EN_BN_OPENCOR = 36689UL,
      FI_EN_BN_OPET = 36690UL,
      FI_EN_BN_ORANGE_JULIUS = 36691UL,
      FI_EN_BN_ORBIS = 36692UL,
      FI_EN_BN_ORCHARD_SUPPLY_HARDWARE = 36693UL,
      FI_EN_BN_OREA = 36694UL,
      FI_EN_BN_OREILLY_AUTO_PARTS = 36695UL,
      FI_EN_BN_ORGA = 36696UL,
      FI_EN_BN_ORIENTAL_BANK_OF_COMMERCE = 36697UL,
      FI_EN_BN_ORIGINAL_PANCAKE_HOUSE = 36698UL,
      FI_EN_BN_ORKAN = 36699UL,
      FI_EN_BN_ORLEANS_GESTION = 36700UL,
      FI_EN_BN_ORSAY = 36701UL,
      FI_EN_BN_OSCO_DRUG = 36702UL,
      FI_EN_BN_OSHKOSH_BGOSH = 36703UL,
      FI_EN_BN_OSLO_KINEMATOGRAFER = 36704UL,
      FI_EN_BN_OESTERREICHISCHE_VERKEHRSKREDITBANK = 36705UL,
      FI_EN_BN_OESTGOETA_ENSKILDA_BANK = 36706UL,
      FI_EN_BN_OSTSEE_SPARKASSE_ROSTOCK = 36707UL,
      FI_EN_BN_OSUUSPANKKI = 36708UL,
      FI_EN_BN_OTESHOP = 36709UL,
      FI_EN_BN_OTP_BANK = 36710UL,
      FI_EN_BN_OTP_BANKA = 36711UL,
      FI_EN_BN_OTTO = 36712UL,
      FI_EN_BN_OTTOS_AG = 36713UL,
      FI_EN_BN_OUTBACK_STEAKHOUSE = 36714UL,
      FI_EN_BN_OVER_RENT = 36715UL,
      FI_EN_BN_OVERSTOCK = 36716UL,
      FI_EN_BN_OYSHO = 36717UL,
      FI_EN_BN_OZTURK = 36718UL,
      FI_EN_BN_P1 = 36719UL,
      FI_EN_BN_PACSUN = 36720UL,
      FI_EN_BN_PACIFIC_WESTERN_NATIONAL_BANK = 36721UL,
      FI_EN_BN_PALACE_CINEMAS = 36722UL,
      FI_EN_BN_PAM = 36723UL,
      FI_EN_BN_PAMIDA = 36724UL,
      FI_EN_BN_PAN_PACIFIC = 36725UL,
      FI_EN_BN_PANAGO_PIZZA = 36726UL,
      FI_EN_BN_PANATSEYA = 36727UL,
      FI_EN_BN_PANCHEROS_MEXICAN_GRILL = 36728UL,
      FI_EN_BN_PANCHOS_MEXICAN_BUFFET = 36729UL,
      FI_EN_BN_PANDA_EXPRESS = 36730UL,
      FI_EN_BN_PANERA_BREAD = 36731UL,
      FI_EN_BN_PANIN_BANK = 36732UL,
      FI_EN_BN_PANORAMA = 36733UL,
      FI_EN_BN_PANS_CO = 36734UL,
      FI_EN_BN_PAO_DE_ACUCAR = 36735UL,
      FI_EN_BN_PAPA_GINOS = 36736UL,
      FI_EN_BN_PAPA_JOHNS = 36737UL,
      FI_EN_BN_PAPA_MURPHYS = 36738UL,
      FI_EN_BN_PAPA_ROMANOS = 36739UL,
      FI_EN_BN_PARADISUS_RESORTS = 36740UL,
      FI_EN_BN_PARCUS = 36741UL,
      FI_EN_BN_PAREX_BANKA = 36742UL,
      FI_EN_BN_PARITATE = 36743UL,
      FI_EN_BN_PARK_HYATT = 36744UL,
      FI_EN_BN_PARK_INN = 36745UL,
      FI_EN_BN_PARK_PLAZA_HOTELS_RESORTS = 36746UL,
      FI_EN_BN_PARK_RITE = 36747UL,
      FI_EN_BN_PARKCITY = 36748UL,
      FI_EN_BN_PARKING_EXPRESS = 36749UL,
      FI_EN_BN_PARROT_ICE = 36750UL,
      FI_EN_BN_PARTENER_ROMPETROL = 36751UL,
      FI_EN_BN_PARTSOURCE = 36752UL,
      FI_EN_BN_PASOIL = 36753UL,
      FI_EN_BN_PASTA_BRAVO = 36754UL,
      FI_EN_BN_PASTA_HOUSE_CO = 36755UL,
      FI_EN_BN_PASTA_POMODORO = 36756UL,
      FI_EN_BN_PASTA_YA_GOTCHA_ = 36757UL,
      FI_EN_BN_PASTAFIORE = 36758UL,
      FI_EN_BN_PASTARITO_PIZZARITO = 36759UL,
      FI_EN_BN_PAT_OSCARS = 36760UL,
      FI_EN_BN_PATERSON = 36761UL,
      FI_EN_BN_PATHE = 36762UL,
      FI_EN_BN_PATHMARK = 36763UL,
      FI_EN_BN_PATRIA = 36764UL,
      FI_EN_BN_PAX_BANK = 36765UL,
      FI_EN_BN_PAYLESS_CAR_RENTAL = 36766UL,
      FI_EN_BN_PAYLESS_SHOESOURCE = 36767UL,
      FI_EN_BN_PBZ = 36768UL,
      FI_EN_BN_PC_WORLD = 36769UL,
      FI_EN_BN_PDV = 36770UL,
      FI_EN_BN_PEEK_CLOPPENBURG = 36771UL,
      FI_EN_BN_PEETS_COFFEE_TEA = 36772UL,
      FI_EN_BN_PEHLIVANOGLU = 36773UL,
      FI_EN_BN_PEI_WEI_ASIAN_DINER = 36774UL,
      FI_EN_BN_PEMEX = 36775UL,
      FI_EN_BN_PENN_FEDERAL_SAVINGS_BANK = 36776UL,
      FI_EN_BN_PENN_STATION_EAST_COAST_SUBS = 36777UL,
      FI_EN_BN_PENNINGTONS = 36778UL,
      FI_EN_BN_PENNSTAR_BANK = 36779UL,
      FI_EN_BN_PENNZOIL_10_MINUTE_OIL_CHANGE = 36780UL,
      FI_EN_BN_PENSKE_AUTO_CENTER = 36781UL,
      FI_EN_BN_PENTO = 36782UL,
      FI_EN_BN_PEOPLES_BANK = 36783UL,
      FI_EN_BN_PEP_BOYS = 36784UL,
      FI_EN_BN_PEPECAR = 36785UL,
      FI_EN_BN_PEPES_MEXICAN_RESTAURANT = 36786UL,
      FI_EN_BN_PEPPERONI_GRILL = 36787UL,
      FI_EN_BN_PEPPES_PIZZA = 36788UL,
      FI_EN_BN_PEREKRYOSTOK = 36789UL,
      FI_EN_BN_PERFECT_PITA = 36790UL,
      FI_EN_BN_PERKINS = 36791UL,
      FI_EN_BN_PERMATA_BANK = 36792UL,
      FI_EN_BN_PERODUA = 36793UL,
      FI_EN_BN_PERTAMINA = 36794UL,
      FI_EN_BN_PERVAYA_POMOSHCH = 36795UL,
      FI_EN_BN_PESTANA = 36796UL,
      FI_EN_BN_PET_VALU = 36797UL,
      FI_EN_BN_PETIT_CASINO = 36798UL,
      FI_EN_BN_PETITE_SOPHISTICATE = 36799UL,
      FI_EN_BN_PETLINE = 36800UL,
      FI_EN_BN_PETRO_STOPPING_CENTERS = 36801UL,
      FI_EN_BN_PETRO_AERO_BANK = 36802UL,
      FI_EN_BN_PETROBRAS = 36803UL,
      FI_EN_BN_PETROCHEMIA_PLOCK = 36804UL,
      FI_EN_BN_PETROKOMMERTS = 36805UL,
      FI_EN_BN_PETROL_OFISI = 36806UL,
      FI_EN_BN_PETROL = 36807UL,
      FI_EN_BN_PETROM_V = 36808UL,
      FI_EN_BN_PETROM = 36809UL,
      FI_EN_BN_PETROMAR = 36810UL,
      FI_EN_BN_PETROMIN = 36811UL,
      FI_EN_BN_PETRONAS = 36812UL,
      FI_EN_BN_PETROTURK = 36813UL,
      FI_EN_BN_PEUGEOT_RENT = 36814UL,
      FI_EN_BN_PF_CHANGS_CHINA_BISTRO = 36815UL,
      FI_EN_BN_PHARMA_PLUS = 36816UL,
      FI_EN_BN_PHARMAPRIX = 36817UL,
      FI_EN_BN_PHARMASAVE = 36818UL,
      FI_EN_BN_PHARRO = 36819UL,
      FI_EN_BN_PHILLY_CONNECTION = 36820UL,
      FI_EN_BN_PHOTO_HALL = 36821UL,
      FI_EN_BN_PICCADILLY = 36822UL,
      FI_EN_BN_PICCADILY = 36823UL,
      FI_EN_BN_PICK_UP_STIX = 36824UL,
      FI_EN_BN_PICKN_PAY = 36825UL,
      FI_EN_BN_PICTUREHOUSE = 36826UL,
      FI_EN_BN_PIER_1_IMPORTS = 36827UL,
      FI_EN_BN_PIGGLY_WIGGLY = 36828UL,
      FI_EN_BN_PIM = 36829UL,
      FI_EN_BN_PINGO_DOCE = 36830UL,
      FI_EN_BN_PIOTR_I_PAWEL = 36831UL,
      FI_EN_BN_PIRAEUS_BANK = 36832UL,
      FI_EN_BN_PIT_STOP = 36833UL,
      FI_EN_BN_PITA_PIT = 36834UL,
      FI_EN_BN_PIZZA_73 = 36835UL,
      FI_EN_BN_PIZZA_DEL_ARTE = 36836UL,
      FI_EN_BN_PIZZA_DELIGHT = 36837UL,
      FI_EN_BN_PIZZA_FABRIKA = 36838UL,
      FI_EN_BN_PIZZA_FACTORY = 36839UL,
      FI_EN_BN_PIZZA_HUT = 36840UL,
      FI_EN_BN_PIZZA_INN = 36841UL,
      FI_EN_BN_PIZZA_ITALIA = 36842UL,
      FI_EN_BN_PIZZA_JAZZ = 36843UL,
      FI_EN_BN_PIZZA_MOVIL = 36844UL,
      FI_EN_BN_PIZZA_NOVA = 36845UL,
      FI_EN_BN_PIZZA_PAI = 36846UL,
      FI_EN_BN_PIZZA_PIZZA = 36847UL,
      FI_EN_BN_PIZZA_RANCH = 36848UL,
      FI_EN_BN_PIZZAVILLE = 36849UL,
      FI_EN_BN_PKO_BANK_POLSKI = 36850UL,
      FI_EN_BN_PLANET_SMOOTHIE = 36851UL,
      FI_EN_BN_PLANET_SUB = 36852UL,
      FI_EN_BN_PLANETA_SUSHI = 36853UL,
      FI_EN_BN_PLANTAGE_BOOKS_MORE = 36854UL,
      FI_EN_BN_PLAYLIFE = 36855UL,
      FI_EN_BN_PLAZA = 36856UL,
      FI_EN_BN_PLUS_SUPERDESCOMPTE = 36857UL,
      FI_EN_BN_PLUS_MARKT = 36858UL,
      FI_EN_BN_PLUS = 36859UL,
      FI_EN_BN_PM = 36860UL,
      FI_EN_BN_PMO = 36861UL,
      FI_EN_BN_PNC_BANK = 36862UL,
      FI_EN_BN_PNEUHAGE = 36863UL,
      FI_EN_BN_PODKARPACKI_BANK_SPOLDZIELCZY = 36864UL,
      FI_EN_BN_PODRAVSKA_BANKA = 36865UL,
      FI_EN_BN_POHONA_PH = 36866UL,
      FI_EN_BN_POIESZ = 36867UL,
      FI_EN_BN_POINT_S = 36868UL,
      FI_EN_BN_POINTP_TP = 36869UL,
      FI_EN_BN_POINTP = 36870UL,
      FI_EN_BN_POLBANK_EFG = 36871UL,
      FI_EN_BN_POLIS_PARK = 36872UL,
      FI_EN_BN_POLLO_FELIZ = 36873UL,
      FI_EN_BN_POLLO_TROPICAL = 36874UL,
      FI_EN_BN_POLLOS_RIO = 36875UL,
      FI_EN_BN_POLOMARKET = 36876UL,
      FI_EN_BN_POLUSHKA = 36877UL,
      FI_EN_BN_PONDEROSA = 36878UL,
      FI_EN_BN_PONT = 36879UL,
      FI_EN_BN_POPEYES = 36880UL,
      FI_EN_BN_POPULAR_ECOM = 36881UL,
      FI_EN_BN_PORT_OF_SUBS = 36882UL,
      FI_EN_BN_PORTMAN_BUILDING_SOCIETY = 36883UL,
      FI_EN_BN_PORTUGALIA = 36884UL,
      FI_EN_BN_POSTBANK = 36885UL,
      FI_EN_BN_POSTBANKEN = 36886UL,
      FI_EN_BN_POSTE_ITALIANE = 36887UL,
      FI_EN_BN_POSTEN = 36888UL,
      FI_EN_BN_POSTFINANCE = 36889UL,
      FI_EN_BN_POSTNA_BANKA_SLOVENIJE = 36890UL,
      FI_EN_BN_POSTOVA_BANKA = 36891UL,
      FI_EN_BN_POSTOVNI_SPORITELNA = 36892UL,
      FI_EN_BN_POTBELLY_SANDWICH_WORKS = 36893UL,
      FI_EN_BN_POTREFENA_HUSA = 36894UL,
      FI_EN_BN_POTUGALIA = 36895UL,
      FI_EN_BN_POTZOLLCALLI = 36896UL,
      FI_EN_BN_POUSADAS_DE_PORTUGAL = 36897UL,
      FI_EN_BN_PRAKTIKER = 36898UL,
      FI_EN_BN_PRAVEK = 36899UL,
      FI_EN_BN_PRECISION_AUTOMOTIVE = 36900UL,
      FI_EN_BN_PREMAMAN = 36901UL,
      FI_EN_BN_PREMIER_INN = 36902UL,
      FI_EN_BN_PREMIO = 36903UL,
      FI_EN_BN_PRENATAL = 36904UL,
      FI_EN_BN_PRESSBYRAN = 36905UL,
      FI_EN_BN_PRET_A_MANGER = 36906UL,
      FI_EN_BN_PRETZEL_TIME = 36907UL,
      FI_EN_BN_PRETZELMAKER = 36908UL,
      FI_EN_BN_PRICE_CHOPPER = 36909UL,
      FI_EN_BN_PRIDE_OF_BRITAIN = 36910UL,
      FI_EN_BN_PRIMA = 36911UL,
      FI_EN_BN_PRIME = 36912UL,
      FI_EN_BN_PRIMO = 36913UL,
      FI_EN_BN_PRINCES_RESORT_HOTELS = 36914UL,
      FI_EN_BN_PRINCIPALITY_BUILDING_SOCIETY = 36915UL,
      FI_EN_BN_PRISMA = 36916UL,
      FI_EN_BN_PRIVATBANK = 36917UL,
      FI_EN_BN_PRIVATBANKA = 36918UL,
      FI_EN_BN_PROBANK = 36919UL,
      FI_EN_BN_PROBANKA = 36920UL,
      FI_EN_BN_PROCREDIT_BANK = 36921UL,
      FI_EN_BN_PROFI = 36922UL,
      FI_EN_BN_PROFILE_TYRECENTER = 36923UL,
      FI_EN_BN_PROMO_FASHION = 36924UL,
      FI_EN_BN_PROMSVYAZBANK = 36925UL,
      FI_EN_BN_PRONTI = 36926UL,
      FI_EN_BN_PROTON = 36927UL,
      FI_EN_BN_PROVIGO = 36928UL,
      FI_EN_BN_PROXI = 36929UL,
      FI_EN_BN_PROXIM = 36930UL,
      FI_EN_BN_PROXY_DELHAIZE = 36931UL,
      FI_EN_BN_PSD_BANK = 36932UL,
      FI_EN_BN_PSK_BANK = 36933UL,
      FI_EN_BN_PSS_SPOLEM = 36934UL,
      FI_EN_BN_PTK = 36935UL,
      FI_EN_BN_PUBLIX_PIX = 36936UL,
      FI_EN_BN_PUBLIX = 36937UL,
      FI_EN_BN_PUERTO_CRISTO = 36938UL,
      FI_EN_BN_PULL_BEAR = 36939UL,
      FI_EN_BN_PUM_PLASTIQUES = 36940UL,
      FI_EN_BN_PUMP = 36941UL,
      FI_EN_BN_PUNE_PEOPLE_CO_OP_BANK = 36942UL,
      FI_EN_BN_PUNE_URBAN_CO_OP_BANK = 36943UL,
      FI_EN_BN_PUNE_ZILLA_MADHYAVARTI_SAHAKARI = 36944UL,
      FI_EN_BN_PUNJAB_MAHARASHTRA_CO_OP_BANK = 36945UL,
      FI_EN_BN_PUNJAB_SIND_BANK = 36946UL,
      FI_EN_BN_PUNJAB_NATIONAL_BANK = 36947UL,
      FI_EN_BN_PUNTO_DI = 36948UL,
      FI_EN_BN_PUNTO_SMA = 36949UL,
      FI_EN_BN_PYATYOROCHKA = 36950UL,
      FI_EN_BN_Q1 = 36951UL,
      FI_EN_BN_Q8_EASY = 36952UL,
      FI_EN_BN_QDOBA = 36953UL,
      FI_EN_BN_Q_PARK = 36954UL,
      FI_EN_BN_QSTAR = 36955UL,
      FI_EN_BN_QUAKER_STEAK_LUBE = 36956UL,
      FI_EN_BN_QUALITY_INN = 36957UL,
      FI_EN_BN_QUEBRAMAR = 36958UL,
      FI_EN_BN_QUENTIN = 36959UL,
      FI_EN_BN_QUESTER = 36960UL,
      FI_EN_BN_QUICK_RENT = 36961UL,
      FI_EN_BN_QUICK = 36962UL,
      FI_EN_BN_QUIKSILVER = 36963UL,
      FI_EN_BN_QUINCYS = 36964UL,
      FI_EN_BN_QUIZNOS_SUB = 36965UL,
      FI_EN_BN_RADEF = 36966UL,
      FI_EN_BN_RABOBANK = 36967UL,
      FI_EN_BN_RADIO_KORASIDI = 36968UL,
      FI_EN_BN_RADIO_POPULAR = 36969UL,
      FI_EN_BN_RADIOSHACK = 36970UL,
      FI_EN_BN_RADISSON_EDWARDIAN_HOTELS = 36971UL,
      FI_EN_BN_RADISSON_HOTELS_RESORTS = 36972UL,
      FI_EN_BN_RADISSON_SAS_HOTELS_RESORTS = 36973UL,
      FI_EN_BN_RADUGA = 36974UL,
      FI_EN_BN_RAFAEL_HOTELES = 36975UL,
      FI_EN_BN_RAFFERTYS = 36976UL,
      FI_EN_BN_RAIFFEISEN_BANK = 36977UL,
      FI_EN_BN_RAI_INTERNACIONAL = 36978UL,
      FI_EN_BN_RAINFOREST_CAFE = 36979UL,
      FI_EN_BN_RAKHAT_LUKUM = 36980UL,
      FI_EN_BN_RALLYS = 36981UL,
      FI_EN_BN_RALPH_LAUREN = 36982UL,
      FI_EN_BN_RALPHS = 36983UL,
      FI_EN_BN_RAMSTORN = 36984UL,
      FI_EN_BN_RAN = 36985UL,
      FI_EN_BN_RAPID_FIT = 36986UL,
      FI_EN_BN_RAS_BANK = 36987UL,
      FI_EN_BN_RASTA = 36988UL,
      FI_EN_BN_RATIO = 36989UL,
      FI_EN_BN_RATNAKAR_BANK = 36990UL,
      FI_EN_BN_RAUTAKIRJA = 36991UL,
      FI_EN_BN_RBC_CENTURA_BANK = 36992UL,
      FI_EN_BN_RBC_ROYAL_BANK = 36993UL,
      FI_EN_BN_READY = 36994UL,
      FI_EN_BN_READYBANK_AG = 36995UL,
      FI_EN_BN_REAL = 36996UL,
      FI_EN_BN_RECORD = 36997UL,
      FI_EN_BN_RED_HOT_BLUE = 36998UL,
      FI_EN_BN_RED_LOBSTER = 36999UL,
      FI_EN_BN_RED_POINT_RENT = 37000UL,
      FI_EN_BN_RED_ROBIN = 37001UL,
      FI_EN_BN_REDFARMA = 37002UL,
      FI_EN_BN_REGAL_CINEMAS = 37003UL,
      FI_EN_BN_REGENT_HOTELS_RESORTS = 37004UL,
      FI_EN_BN_REGENT = 37005UL,
      FI_EN_BN_REGIONS = 37006UL,
      FI_EN_BN_REIFENCOM = 37007UL,
      FI_EN_BN_REIFF = 37008UL,
      FI_EN_BN_REISEBANK = 37009UL,
      FI_EN_BN_REITMANS = 37010UL,
      FI_EN_BN_RELAIS_CHATEAUX = 37011UL,
      FI_EN_BN_RELIANCE_FRESH = 37012UL,
      FI_EN_BN_RELIANCE = 37013UL,
      FI_EN_BN_REMA_1000 = 37014UL,
      FI_EN_BN_RENAULT_RENT = 37015UL,
      FI_EN_BN_RENO = 37016UL,
      FI_EN_BN_RENT_A_CAR_KOSMOS = 37017UL,
      FI_EN_BN_RENT_A_CAR = 37018UL,
      FI_EN_BN_RENTA_AVTO = 37019UL,
      FI_EN_BN_RENTAMOBILE = 37020UL,
      FI_EN_BN_REPOSTAR = 37021UL,
      FI_EN_BN_REPUBLIC_BANK_TRUST = 37022UL,
      FI_EN_BN_RESERVE_BANK_OF_INDIA = 37023UL,
      FI_EN_BN_RESIDENCE_INN = 37024UL,
      FI_EN_BN_RESTAUMARCHE = 37025UL,
      FI_EN_BN_RESTAURANT_CACTUS = 37026UL,
      FI_EN_BN_RESTAURANT_LE_CHESNOY_SA = 37027UL,
      FI_EN_BN_RESTAURANTE_SANBORNS = 37028UL,
      FI_EN_BN_REVALIS_EVER = 37029UL,
      FI_EN_BN_REVOIL = 37030UL,
      FI_EN_BN_REWE = 37031UL,
      FI_EN_BN_REXALL = 37032UL,
      FI_EN_BN_RHASA = 37033UL,
      FI_EN_BN_RHEINGOLD = 37034UL,
      FI_EN_BN_RIETUMU_BANKA = 37035UL,
      FI_EN_BN_RIGLA = 37036UL,
      FI_EN_BN_RIMI_HYPERMARKET = 37037UL,
      FI_EN_BN_RIMI_SUPERMARKET = 37038UL,
      FI_EN_BN_RIMI = 37039UL,
      FI_EN_BN_RINGHOTELS = 37040UL,
      FI_EN_BN_RIRA_OIL = 37041UL,
      FI_EN_BN_RITE_AID = 37042UL,
      FI_EN_BN_RITZ_CARLTON_CLUB = 37043UL,
      FI_EN_BN_ROADHOUSE_GRILL = 37044UL,
      FI_EN_BN_ROADY = 37045UL,
      FI_EN_BN_ROBEKS = 37046UL,
      FI_EN_BN_ROBYS = 37047UL,
      FI_EN_BN_ROCK_BOTTOM = 37048UL,
      FI_EN_BN_RODILLA = 37049UL,
      FI_EN_BN_ROGERS = 37050UL,
      FI_EN_BN_ROLO_BANCA_1473 = 37051UL,
      FI_EN_BN_ROLY_POLY = 37052UL,
      FI_EN_BN_ROMA_PIZZA = 37053UL,
      FI_EN_BN_ROMANA_MARKET = 37054UL,
      FI_EN_BN_ROMANIA_RENTACAR = 37055UL,
      FI_EN_BN_ROMANOS_MACARONI_GRILL = 37056UL,
      FI_EN_BN_ROMPETROL = 37057UL,
      FI_EN_BN_RONA = 37058UL,
      FI_EN_BN_ROOTS = 37059UL,
      FI_EN_BN_ROSAS_CAFE = 37060UL,
      FI_EN_BN_ROSATIS_PIZZA = 37061UL,
      FI_EN_BN_ROSBANK = 37062UL,
      FI_EN_BN_ROSNEFT = 37063UL,
      FI_EN_BN_ROSS_DRESS_FOR_LESS = 37064UL,
      FI_EN_BN_ROSSELKHOZBANK = 37065UL,
      FI_EN_BN_ROSSMANN = 37066UL,
      FI_EN_BN_ROSSO = 37067UL,
      FI_EN_BN_ROSTIKS = 37068UL,
      FI_EN_BN_ROTH = 37069UL,
      FI_EN_BN_ROUND_TABLE_PIZZA = 37070UL,
      FI_EN_BN_ROY_ROGERS = 37071UL,
      FI_EN_BN_ROYAL_BANK_OF_SCOTLAND = 37072UL,
      FI_EN_BN_ROYAL_ENFIELD = 37073UL,
      FI_EN_BN_ROYS = 37074UL,
      FI_EN_BN_RUBIOS_FRESH_MEXICAN_GRILL = 37075UL,
      FI_EN_BN_RUBY_TUESDAY = 37076UL,
      FI_EN_BN_RUBYS_DINER = 37077UL,
      FI_EN_BN_RUE21 = 37078UL,
      FI_EN_BN_RUGGED_BEAR = 37079UL,
      FI_EN_BN_RUMBI_ISLAND_GRILL = 37080UL,
      FI_EN_BN_RUPEE_CO_OP_BANK = 37081UL,
      FI_EN_BN_RURAL_KUTXA = 37082UL,
      FI_EN_BN_RURALCAJA = 37083UL,
      FI_EN_BN_RUSBANK = 37084UL,
      FI_EN_BN_RUSSKIY_STANDART = 37085UL,
      FI_EN_BN_RUSSNEFT = 37086UL,
      FI_EN_BN_RUSTICAE_METROPOLI = 37087UL,
      FI_EN_BN_RUTHS_CHRIS_STEAK_HOUSE = 37088UL,
      FI_EN_BN_RUTTERS = 37089UL,
      FI_EN_BN_RYANS = 37090UL,
      FI_EN_BN_SA_NOSTRA = 37091UL,
      FI_EN_BN_SAEAESTOEPANKKI = 37092UL,
      FI_EN_BN_SAEAESTUMARKET = 37093UL,
      FI_EN_BN_SABA = 37094UL,
      FI_EN_BN_SABADELLATLANTICO = 37095UL,
      FI_EN_BN_SABECO = 37096UL,
      FI_EN_BN_SACOOR = 37097UL,
      FI_EN_BN_SAFEWAY_PHARMACY = 37098UL,
      FI_EN_BN_SAGARDI = 37099UL,
      FI_EN_BN_SAHAKARI_BHANDAR = 37100UL,
      FI_EN_BN_SAHAN = 37101UL,
      FI_EN_BN_SAHARA = 37102UL,
      FI_EN_BN_SAINSBURYS = 37103UL,
      FI_EN_BN_SALAD_SPINNERS = 37104UL,
      FI_EN_BN_SALADWORKS = 37105UL,
      FI_EN_BN_SALAMA = 37106UL,
      FI_EN_BN_SALAMANDER = 37107UL,
      FI_EN_BN_SALCOBRAND = 37108UL,
      FI_EN_BN_SALE = 37109UL,
      FI_EN_BN_SALSA = 37110UL,
      FI_EN_BN_SAM_0_13 = 37111UL,
      FI_EN_BN_SAMOKHVAL = 37112UL,
      FI_EN_BN_SAMPI = 37113UL,
      FI_EN_BN_SAMPO = 37114UL,
      FI_EN_BN_SAMS_CLUB = 37115UL,
      FI_EN_BN_SAMSONITE = 37116UL,
      FI_EN_BN_SAN_CARLO = 37117UL,
      FI_EN_BN_SAN_FRANCISCO_OVEN = 37118UL,
      FI_EN_BN_SAN_FRANCISCO_SOUP_COMPANY = 37119UL,
      FI_EN_BN_SANDELLAS = 37120UL,
      FI_EN_BN_SANDERS = 37121UL,
      FI_EN_BN_SANDWICH_FACTORY = 37122UL,
      FI_EN_BN_SANGALI_CO_OP_BANK = 37123UL,
      FI_EN_BN_SANKT_GALLER_KANTONALBANK = 37124UL,
      FI_EN_BN_SANPAOLO_BANK = 37125UL,
      FI_EN_BN_SANTA_BARBARA_BANK_TRUST = 37126UL,
      FI_EN_BN_SANTA_ISABEL = 37127UL,
      FI_EN_BN_SANTANA = 37128UL,
      FI_EN_BN_SANTANDER_CENTRAL_HISPANO = 37129UL,
      FI_EN_BN_SANTANDER_CONSUMER_BANK = 37130UL,
      FI_EN_BN_SANTANDER_RIO = 37131UL,
      FI_EN_BN_SANTANDER_TOTTA = 37132UL,
      FI_EN_BN_SANTANDER = 37133UL,
      FI_EN_BN_SANTELENA = 37134UL,
      FI_EN_BN_SARAS_ENERGIA = 37135UL,
      FI_EN_BN_SARASWAT_BANK = 37136UL,
      FI_EN_BN_SARKU_JAPAN = 37137UL,
      FI_EN_BN_SARNI = 37138UL,
      FI_EN_BN_SASCO = 37139UL,
      FI_EN_BN_SASOL = 37140UL,
      FI_EN_BN_SAUDI_FUEL = 37141UL,
      FI_EN_BN_SAVE_ON_FOODS = 37142UL,
      FI_EN_BN_SAVE_A_LOT = 37143UL,
      FI_EN_BN_SAV_MOR_FOODS = 37144UL,
      FI_EN_BN_SAV_ON_DRUGS = 37145UL,
      FI_EN_BN_SAYPA = 37146UL,
      FI_EN_BN_SBARRO = 37147UL,
      FI_EN_BN_SBERBANK_ROSSII = 37148UL,
      FI_EN_BN_SCANIA = 37149UL,
      FI_EN_BN_SCAPA = 37150UL,
      FI_EN_BN_SCAPINO = 37151UL,
      FI_EN_BN_SCHAFFHAUSER_KANTONALBANK = 37152UL,
      FI_EN_BN_SCHLECKER = 37153UL,
      FI_EN_BN_SCHLEIPER = 37154UL,
      FI_EN_BN_SCHLOTZSKYS = 37155UL,
      FI_EN_BN_SCHNITZELHAUS = 37156UL,
      FI_EN_BN_SCHNITZLPLATZL = 37157UL,
      FI_EN_BN_SCHNUCKS = 37158UL,
      FI_EN_BN_SCHOELLERBANK = 37159UL,
      FI_EN_BN_SCHOENEN_REUS = 37160UL,
      FI_EN_BN_SCHOEPS = 37161UL,
      FI_EN_BN_SCHUHHOF = 37162UL,
      FI_EN_BN_SCHWAEBISCH_HALL = 37163UL,
      FI_EN_BN_SCHWYZER_KANTONALBANK = 37164UL,
      FI_EN_BN_SCORE_SUPERMARKET = 37165UL,
      FI_EN_BN_SCOTIABANK = 37166UL,
      FI_EN_BN_SCOTTISH_FUELS = 37167UL,
      FI_EN_BN_SEARS_AUTO_CENTER = 37168UL,
      FI_EN_BN_SEARS_HARDWARE = 37169UL,
      FI_EN_BN_SEARS_HOMETOWN_STORE = 37170UL,
      FI_EN_BN_SEARS_OUTLET = 37171UL,
      FI_EN_BN_SEARS_RENT_A_CAR = 37172UL,
      FI_EN_BN_SEARS = 37173UL,
      FI_EN_BN_SEASONS_52 = 37174UL,
      FI_EN_BN_SEASSIDE_HOTELS = 37175UL,
      FI_EN_BN_SEATTLES_BEST = 37176UL,
      FI_EN_BN_SEB = 37177UL,
      FI_EN_BN_SECOND_CUP = 37178UL,
      FI_EN_BN_SEDMOY_KONTINENT = 37179UL,
      FI_EN_BN_SEKERBANK = 37180UL,
      FI_EN_BN_SELEXION = 37181UL,
      FI_EN_BN_SELEXYZ = 37182UL,
      FI_EN_BN_SELGROS = 37183UL,
      FI_EN_BN_SELVER = 37184UL,
      FI_EN_BN_SEM_ANGLES = 37185UL,
      FI_EN_BN_SEMIACS = 37186UL,
      FI_EN_BN_SENDAS = 37187UL,
      FI_EN_BN_SERRA_DA_ESTRELA = 37188UL,
      FI_EN_BN_SEYHANLAR_MARKET = 37189UL,
      FI_EN_BN_SF = 37190UL,
      FI_EN_BN_SFIC = 37191UL,
      FI_EN_BN_SHAKEYS = 37192UL,
      FI_EN_BN_SHAMRAO_VITHAL_CO_OP_BANK = 37193UL,
      FI_EN_BN_SHANGRI_LA = 37194UL,
      FI_EN_BN_SHARIS = 37195UL,
      FI_EN_BN_SHARKYS_WOODFIRED_MEXICAN_GRILL = 37196UL,
      FI_EN_BN_SHAWS = 37197UL,
      FI_EN_BN_SHEARINGS = 37198UL,
      FI_EN_BN_SHELL_EXPRESS = 37199UL,
      FI_EN_BN_SHERRIFS = 37200UL,
      FI_EN_BN_SHIVAJINAGAR_SAHAKARI_BANK = 37201UL,
      FI_EN_BN_SHIVAJIRAO_BHOSALE_SAHAKARI_BANK = 37202UL,
      FI_EN_BN_SHIVAJIRAO_BHOSLE_BANK = 37203UL,
      FI_EN_BN_SHOE_DEPT = 37204UL,
      FI_EN_BN_SHOE_DISCOUNT = 37205UL,
      FI_EN_BN_SHOE_SHOW = 37206UL,
      FI_EN_BN_SHOKOLADNITSA = 37207UL,
      FI_EN_BN_SHONEYS = 37208UL,
      FI_EN_BN_SHOPKO = 37209UL,
      FI_EN_BN_SHOPPERS_DRUG_MART = 37210UL,
      FI_EN_BN_SHOPRITE = 37211UL,
      FI_EN_BN_SHORTYS_MEXICAN_ROADHOUSE = 37212UL,
      FI_EN_BN_SHOWCASE = 37213UL,
      FI_EN_BN_SIAULIU_BANKAS = 37214UL,
      FI_EN_BN_SIBA = 37215UL,
      FI_EN_BN_SIBNEFT = 37216UL,
      FI_EN_BN_SIDIS = 37217UL,
      FI_EN_BN_SIGMA = 37218UL,
      FI_EN_BN_SIKON_GROUP_LTD = 37219UL,
      FI_EN_BN_SILK_OIL = 37220UL,
      FI_EN_BN_SILMET = 37221UL,
      FI_EN_BN_SILVER_DINER = 37222UL,
      FI_EN_BN_SILVER_FOX = 37223UL,
      FI_EN_BN_SILVER_MINE_SUBS = 37224UL,
      FI_EN_BN_SILVER_SCREEN = 37225UL,
      FI_EN_BN_SIMPATIA_CRAI = 37226UL,
      FI_EN_BN_SIMPLY_MARKET = 37227UL,
      FI_EN_BN_SIR_PIZZA = 37228UL,
      FI_EN_BN_SIR = 37229UL,
      FI_EN_BN_SIRLOIN_STOCKADE = 37230UL,
      FI_EN_BN_SISA = 37231UL,
      FI_EN_BN_SIWA = 37232UL,
      FI_EN_BN_SIXT = 37233UL,
      FI_EN_BN_SIZZLER = 37234UL,
      FI_EN_BN_SKARLET = 37235UL,
      FI_EN_BN_SKB_BANKA = 37236UL,
      FI_EN_BN_SKECHERS = 37237UL,
      FI_EN_BN_SKIPPERS = 37238UL,
      FI_EN_BN_SKIPTON_BUILDING_SOCIETY = 37239UL,
      FI_EN_BN_SKLAVENITIS = 37240UL,
      FI_EN_BN_SKY_PARK_SECURE = 37241UL,
      FI_EN_BN_SKYE_BANK = 37242UL,
      FI_EN_BN_SKYLINE_CHILI = 37243UL,
      FI_EN_BN_SLAVNEFT = 37244UL,
      FI_EN_BN_SLEEP_COUNTRY = 37245UL,
      FI_EN_BN_SLOVENSKA_SPORITELNA = 37246UL,
      FI_EN_BN_SMA = 37247UL,
      FI_EN_BN_SMALL_ELEGANT_HOTELS = 37248UL,
      FI_EN_BN_S_MARKET = 37249UL,
      FI_EN_BN_SMART_SET = 37250UL,
      FI_EN_BN_SMART = 37251UL,
      FI_EN_BN_S_MART = 37252UL,
      FI_EN_BN_SMATCH = 37253UL,
      FI_EN_BN_SMC = 37254UL,
      FI_EN_BN_SMOKEY_BONES = 37255UL,
      FI_EN_BN_SMOOTHIE_FACTORY = 37256UL,
      FI_EN_BN_SMOOTHIE_KING = 37257UL,
      FI_EN_BN_SNACK_ATTACK = 37258UL,
      FI_EN_BN_SNG = 37259UL,
      FI_EN_BN_SNORAS = 37260UL,
      FI_EN_BN_SNS_BANK = 37261UL,
      FI_EN_BN_SOBEYS = 37262UL,
      FI_EN_BN_SOCIETE_GENERALE_EXPRESSBANK = 37263UL,
      FI_EN_BN_SOCIETE_GENERALE = 37264UL,
      FI_EN_BN_SOFIA_CITY_CENTRE_CINEMA = 37265UL,
      FI_EN_BN_SOGLIA = 37266UL,
      FI_EN_BN_SOK = 37267UL,
      FI_EN_BN_SOL_HOTELS = 37268UL,
      FI_EN_BN_SOLAPUR_JANTA_SAHAKARI_BANK = 37269UL,
      FI_EN_BN_SOLBANK = 37270UL,
      FI_EN_BN_SOLINCA = 37271UL,
      FI_EN_BN_SOLMAR = 37272UL,
      FI_EN_BN_SOLO_SQUEEZE = 37273UL,
      FI_EN_BN_SOLSTICE = 37274UL,
      FI_EN_BN_SOMAP = 37275UL,
      FI_EN_BN_SOMEPI = 37276UL,
      FI_EN_BN_SOMERFIELD = 37277UL,
      FI_EN_BN_SOMETHINGS_FISHY = 37278UL,
      FI_EN_BN_SONAE_SIERRA = 37279UL,
      FI_EN_BN_SONIC = 37280UL,
      FI_EN_BN_SONNYS_REAL_PIT_BBQ = 37281UL,
      FI_EN_BN_SONY = 37282UL,
      FI_EN_BN_SORELI_ISLA = 37283UL,
      FI_EN_BN_SORIANA = 37284UL,
      FI_EN_BN_SORLI_DISCAU = 37285UL,
      FI_EN_BN_SOUPBOX = 37286UL,
      FI_EN_BN_SOUPER_SALAD = 37287UL,
      FI_EN_BN_SOUPLANTATION = 37288UL,
      FI_EN_BN_SOUTH_INDIAN_BANK = 37289UL,
      FI_EN_BN_SOUTHERN_FRIED_CHICKEN = 37290UL,
      FI_EN_BN_SOUTHERN_SUN = 37291UL,
      FI_EN_BN_SOUTHERN_TSUNAMI = 37292UL,
      FI_EN_BN_SOVEREIGN_BANK = 37293UL,
      FI_EN_BN_SOYKAN = 37294UL,
      FI_EN_BN_SPAGHETTI_WAREHOUSE = 37295UL,
      FI_EN_BN_SPAR_GOURMET = 37296UL,
      FI_EN_BN_SPAR_NORD_BANK = 37297UL,
      FI_EN_BN_SPAR = 37298UL,
      FI_EN_BN_SPARBANK_VEST = 37299UL,
      FI_EN_BN_SPARDA_BANK = 37300UL,
      FI_EN_BN_SPAREBANK_1 = 37301UL,
      FI_EN_BN_SPAREBANKEN_VEST = 37302UL,
      FI_EN_BN_SPARKASSE_AACHEN = 37303UL,
      FI_EN_BN_SPARKASSE_ALLGAEU = 37304UL,
      FI_EN_BN_SPARKASSE_BAMBERG = 37305UL,
      FI_EN_BN_SPARKASSE_BIELEFELD = 37306UL,
      FI_EN_BN_SPARKASSE_BOCHUM = 37307UL,
      FI_EN_BN_SPARKASSE_BREMEN = 37308UL,
      FI_EN_BN_SPARKASSE_CHEMNITZ = 37309UL,
      FI_EN_BN_SPARKASSE_DACHAU = 37310UL,
      FI_EN_BN_SPARKASSE_DORTMUND = 37311UL,
      FI_EN_BN_SPARKASSE_DUISBURG = 37312UL,
      FI_EN_BN_SPARKASSE_DUEREN = 37313UL,
      FI_EN_BN_SPARKASSE_ERDING_DORFEN = 37314UL,
      FI_EN_BN_SPARKASSE_ESSEN = 37315UL,
      FI_EN_BN_SPARKASSE_FICHTELGEBIRGE = 37316UL,
      FI_EN_BN_SPARKASSE_FUERSTENFELDBRUCK = 37317UL,
      FI_EN_BN_SPARKASSE_GIESSEN = 37318UL,
      FI_EN_BN_SPARKASSE_GOEPPINGEN = 37319UL,
      FI_EN_BN_SPARKASSE_HANNOVER = 37320UL,
      FI_EN_BN_SPARKASSE_HARBURG_BUXTEHUDE = 37321UL,
      FI_EN_BN_SPARKASSE_HEIDELBERG = 37322UL,
      FI_EN_BN_SPARKASSE_HERFORD = 37323UL,
      FI_EN_BN_SPARKASSE_HILDESHEIM = 37324UL,
      FI_EN_BN_SPARKASSE_HOHENLOHEKREIS = 37325UL,
      FI_EN_BN_SPARKASSE_HOLSTEIN_EUTIN = 37326UL,
      FI_EN_BN_SPARKASSE_KARLSRUHE = 37327UL,
      FI_EN_BN_SPARKASSE_KOBLENZ = 37328UL,
      FI_EN_BN_SPARKASSE_KOELNBONN = 37329UL,
      FI_EN_BN_SPARKASSE_KREFELD = 37330UL,
      FI_EN_BN_SPARKASSE_KULMBACH_KRONACH = 37331UL,
      FI_EN_BN_SPARKASSE_LANDSBERG_DIESSEN = 37332UL,
      FI_EN_BN_SPARKASSE_LANGEN_SELIGENSTADT = 37333UL,
      FI_EN_BN_SPARKASSE_LEIPZIG = 37334UL,
      FI_EN_BN_SPARKASSE_LEMGO = 37335UL,
      FI_EN_BN_SPARKASSE_MITTELMOSEL_EIFEL = 37336UL,
      FI_EN_BN_SPARKASSE_NEUSS = 37337UL,
      FI_EN_BN_SPARKASSE_NEUSTADT_AD_AISCH = 37338UL,
      FI_EN_BN_SPARKASSE_NUERNBERG = 37339UL,
      FI_EN_BN_SPARKASSE_OBERHESSEN = 37340UL,
      FI_EN_BN_SPARKASSE_OSTERODE_AM_HARZ = 37341UL,
      FI_EN_BN_SPARKASSE_PFORZHEIM_CALW = 37342UL,
      FI_EN_BN_SPARKASSE_RHEIN_NECKAR_NORD = 37343UL,
      FI_EN_BN_SPARKASSE_RHEIN_NAHE = 37344UL,
      FI_EN_BN_SPARKASSE_SCHAUMBURG = 37345UL,
      FI_EN_BN_SPARKASSE_SUEDHOLSTEIN = 37346UL,
      FI_EN_BN_SPARKASSE_TRIER = 37347UL,
      FI_EN_BN_SPARKASSE_ULM = 37348UL,
      FI_EN_BN_SPARKASSE_VOGTLAND = 37349UL,
      FI_EN_BN_SPARKASSE_VORDERPFALZ = 37350UL,
      FI_EN_BN_SPARKASSE = 37351UL,
      FI_EN_BN_SPEEDY_AUTO_SERVICE = 37352UL,
      FI_EN_BN_SPEEDY_GLASS = 37353UL,
      FI_EN_BN_SPEEDY = 37354UL,
      FI_EN_BN_SPENCERS = 37355UL,
      FI_EN_BN_SPENDIMEGLIO = 37356UL,
      FI_EN_BN_SPF = 37357UL,
      FI_EN_BN_SPHINX = 37358UL,
      FI_EN_BN_SPINACH = 37359UL,
      FI_EN_BN_SPIZZICO = 37360UL,
      FI_EN_BN_SPLITSKA_BANKA = 37361UL,
      FI_EN_BN_SPOLDZIELCZA_GRUPA_BANKOWA_GBW = 37362UL,
      FI_EN_BN_SPORTCHEK = 37363UL,
      FI_EN_BN_SPORTMART = 37364UL,
      FI_EN_BN_SPORTS_AUTHORITY = 37365UL,
      FI_EN_BN_SPORTS_EXPERTS = 37366UL,
      FI_EN_BN_SPORTS_WORLD = 37367UL,
      FI_EN_BN_SPORTZONE = 37368UL,
      FI_EN_BN_SPRIDER_STORES = 37369UL,
      FI_EN_BN_SPRING_BANK = 37370UL,
      FI_EN_BN_SPRING_TIME = 37371UL,
      FI_EN_BN_SPRINGFIELD = 37372UL,
      FI_EN_BN_MARRIOTT_SPRINGHILL_SUITES = 37373UL,
      FI_EN_BN_SR_FRANGO_DA_GUIA = 37374UL,
      FI_EN_BN_ST_GEORGE = 37375UL,
      FI_EN_BN_ST_REGIS = 37376UL,
      FI_EN_BN_ST_GALLER_KANTONALBANK = 37377UL,
      FI_EN_BN_ST1 = 37378UL,
      FI_EN_BN_STADTSPARKASSE_MUENCHEN = 37379UL,
      FI_EN_BN_STADTSPARKASSE_WUPPERTAL = 37380UL,
      FI_EN_BN_STAFFORDSHIRE = 37381UL,
      FI_EN_BN_STANDA = 37382UL,
      FI_EN_BN_STANDAARD_BOEKHANDEL = 37383UL,
      FI_EN_BN_STANDARD_BANK_TRUST = 37384UL,
      FI_EN_BN_STANDARD_BANK = 37385UL,
      FI_EN_BN_STANDARD_CHARTERED = 37386UL,
      FI_EN_BN_STANDARD_PARKING = 37387UL,
      FI_EN_BN_STAPLES_BUSINESS_DEPOT = 37388UL,
      FI_EN_BN_STAPLES = 37389UL,
      FI_EN_BN_STAR_MARKET = 37390UL,
      FI_EN_BN_STAR_MART = 37391UL,
      FI_EN_BN_STARCAR = 37392UL,
      FI_EN_BN_STARIY_LEKAR = 37393UL,
      FI_EN_BN_STARPET = 37394UL,
      FI_EN_BN_STARS_HOTELS = 37395UL,
      FI_EN_BN_STATE_BANK_OF_HYDERABAD = 37396UL,
      FI_EN_BN_STATE_BANK_OF_INDIA = 37397UL,
      FI_EN_BN_STATE_BANK_OF_INDORE = 37398UL,
      FI_EN_BN_STATE_BANK_OF_MYSORE = 37399UL,
      FI_EN_BN_STATE_BANK_OF_PATIALA = 37400UL,
      FI_EN_BN_STATE_BANK_OF_SAURASHTRA = 37401UL,
      FI_EN_BN_STATE_BANK = 37402UL,
      FI_EN_BN_STAYBRIDGE_SUITES = 37403UL,
      FI_EN_BN_STEAK_ESCAPE = 37404UL,
      FI_EN_BN_STEAK_N_SHAKE = 37405UL,
      FI_EN_BN_STEAK_OUT = 37406UL,
      FI_EN_BN_STEERS = 37407UL,
      FI_EN_BN_STER_CENTURY = 37408UL,
      FI_EN_BN_STER_CINEMAS = 37409UL,
      FI_EN_BN_STER_KINEKOR = 37410UL,
      FI_EN_BN_STERLING_BANK = 37411UL,
      FI_EN_BN_STEVE_BARRYS = 37412UL,
      FI_EN_BN_STEVE_MADDEN = 37413UL,
      FI_EN_BN_STITCHES = 37414UL,
      FI_EN_BN_STOKROTKA = 37415UL,
      FI_EN_BN_STOP_SHOP = 37416UL,
      FI_EN_BN_STRADIVARIUS = 37417UL,
      FI_EN_BN_STRASBURG_CHILDREN = 37418UL,
      FI_EN_BN_STRIDE_RITE = 37419UL,
      FI_EN_BN_STROUD_SWINDON_BUILDING_SOCIETY = 37420UL,
      FI_EN_BN_STUDIO_6 = 37421UL,
      FI_EN_BN_STUDIO = 37422UL,
      FI_EN_BN_STUTTGARTER_VOLKSBANK = 37423UL,
      FI_EN_BN_SUB_STATION_II = 37424UL,
      FI_EN_BN_SUBMARINA_CALIFORNIA_SUBS = 37425UL,
      FI_EN_BN_SUBURBAN_EXTENDED_STAY = 37426UL,
      FI_EN_BN_SUEDWESTBANK = 37427UL,
      FI_EN_BN_SUITEHOTEL = 37428UL,
      FI_EN_BN_SULTANAHMET_KOFTECISI = 37429UL,
      FI_EN_BN_SUMA = 37430UL,
      FI_EN_BN_SUN_SAND = 37431UL,
      FI_EN_BN_SUN_NATIONAL_BANK = 37432UL,
      FI_EN_BN_SUN_OIL = 37433UL,
      FI_EN_BN_SUNCORP = 37434UL,
      FI_EN_BN_SUNHOTEL = 37435UL,
      FI_EN_BN_SUNOCO_CANADA = 37436UL,
      FI_EN_BN_SUPA_QUICK = 37437UL,
      FI_EN_BN_SUPER_8 = 37438UL,
      FI_EN_BN_SUPER_BM = 37439UL,
      FI_EN_BN_SUPER_CENTRO = 37440UL,
      FI_EN_BN_SUPER_DE_BOER = 37441UL,
      FI_EN_BN_SUPER_ELITE = 37442UL,
      FI_EN_BN_SUPER_GAZ = 37443UL,
      FI_EN_BN_SUPER_GB = 37444UL,
      FI_EN_BN_SUPER_INDO = 37445UL,
      FI_EN_BN_SUPER_PARTNER_GB = 37446UL,
      FI_EN_BN_SUPER_SALADS = 37447UL,
      FI_EN_BN_SUPERAMA = 37448UL,
      FI_EN_BN_SUPERAVUI = 37449UL,
      FI_EN_BN_SUPERBEST = 37450UL,
      FI_EN_BN_SUPERBRUGSEN = 37451UL,
      FI_EN_BN_SUPERCOR = 37452UL,
      FI_EN_BN_SUPERESTALVI = 37453UL,
      FI_EN_BN_SUPERM = 37454UL,
      FI_EN_BN_SUPERMA = 37455UL,
      FI_EN_BN_SUPERMACS_FAMILY_RESTAURANT = 37456UL,
      FI_EN_BN_SUPERMACS_FRESH_EXPRESS = 37457UL,
      FI_EN_BN_SUPERMEC = 37458UL,
      FI_EN_BN_SUPERMERCADOS_BH = 37459UL,
      FI_EN_BN_SUPERNETTO = 37460UL,
      FI_EN_BN_SUPERQUINN = 37461UL,
      FI_EN_BN_SUPERSOL = 37462UL,
      FI_EN_BN_SUPERVALU = 37463UL,
      FI_EN_BN_SUPERVIELLE_BANCO = 37464UL,
      FI_EN_BN_SURCOUF = 37465UL,
      FI_EN_BN_SURGUTNEFTEGAZ = 37466UL,
      FI_EN_BN_SUSHI_ITTO = 37467UL,
      FI_EN_BN_SUTTERLUETY = 37468UL,
      FI_EN_BN_SUVARNA_SAHAKARI_BANK = 37469UL,
      FI_EN_BN_SUWARN_SAHAKARI_BANK = 37470UL,
      FI_EN_BN_SUZY_SHIER = 37471UL,
      FI_EN_BN_SVEJK_RESTAURANT = 37472UL,
      FI_EN_BN_SVENSK_KASSASERVICE = 37473UL,
      FI_EN_BN_SWEDBANK = 37474UL,
      FI_EN_BN_SWENSENS = 37475UL,
      FI_EN_BN_SWISS_CHALET = 37476UL,
      FI_EN_BN_SWISS_QUALITY_HOTELS = 37477UL,
      FI_EN_BN_SYNDICATE_BANK = 37478UL,
      FI_EN_BN_SYNOVUS = 37479UL,
      FI_EN_BN_SYSTEM_PARKING = 37480UL,
      FI_EN_BN_TABI = 37481UL,
      FI_EN_BN_TABLAPIZZA = 37482UL,
      FI_EN_BN_TABLES_AUBERGES_DE_FRANCE = 37483UL,
      FI_EN_BN_TACI_OIL = 37484UL,
      FI_EN_BN_TACO_BELL = 37485UL,
      FI_EN_BN_TACO_BUENO = 37486UL,
      FI_EN_BN_TACO_CABANA = 37487UL,
      FI_EN_BN_TACO_DEL_MAR = 37488UL,
      FI_EN_BN_TACO_H = 37489UL,
      FI_EN_BN_TACO_INN = 37490UL,
      FI_EN_BN_TACO_JOHNS = 37491UL,
      FI_EN_BN_TACO_MAC = 37492UL,
      FI_EN_BN_TACOTIME = 37493UL,
      FI_EN_BN_TADIM_PIZZA = 37494UL,
      FI_EN_BN_TAJ = 37495UL,
      FI_EN_BN_TAKKO_FASHION = 37496UL,
      FI_EN_BN_TALBOTS = 37497UL,
      FI_EN_BN_TALLY_WEIJL = 37498UL,
      FI_EN_BN_TAMILNADU_MERCANTILE_BANK = 37499UL,
      FI_EN_BN_TANDY_ELECTRONICS = 37500UL,
      FI_EN_BN_TANDY = 37501UL,
      FI_EN_BN_TANKA = 37502UL,
      FI_EN_BN_TANSAS = 37503UL,
      FI_EN_BN_TANTALIZER = 37504UL,
      FI_EN_BN_TANUKI = 37505UL,
      FI_EN_BN_TAPELIA = 37506UL,
      FI_EN_BN_TAQUERIA_ARANDAS = 37507UL,
      FI_EN_BN_TAQUERIA_GUADALAJARA = 37508UL,
      FI_EN_BN_TARAS_BULBA = 37509UL,
      FI_EN_BN_TARGET_PHARMACY = 37510UL,
      FI_EN_BN_TARGET = 37511UL,
      FI_EN_BN_TASET = 37512UL,
      FI_EN_BN_TASHELAT = 37513UL,
      FI_EN_BN_TASTEE_FREEZ = 37514UL,
      FI_EN_BN_TATA = 37515UL,
      FI_EN_BN_TATNEFT = 37516UL,
      FI_EN_BN_TATNEFTEPRODUKT = 37517UL,
      FI_EN_BN_TATRA_BANKA = 37518UL,
      FI_EN_BN_TAVERNE_DE_MAITRE_KANTER = 37519UL,
      FI_EN_BN_T_BONES_GREAT_AMERICAN_EATERY = 37520UL,
      FI_EN_BN_TC_ZIRAAT_BANKASI = 37521UL,
      FI_EN_BN_TCBY = 37522UL,
      FI_EN_BN_TCF = 37523UL,
      FI_EN_BN_TD_BANK = 37524UL,
      FI_EN_BN_TD_CANADA_TRUST = 37525UL,
      FI_EN_BN_TD_CARS = 37526UL,
      FI_EN_BN_TDC = 37527UL,
      FI_EN_BN_TEB = 37528UL,
      FI_EN_BN_TEBOIL_EXPRESS = 37529UL,
      FI_EN_BN_TECH_NET = 37530UL,
      FI_EN_BN_TEDCASTLES = 37531UL,
      FI_EN_BN_TEDS_MONTANA_GRILL = 37532UL,
      FI_EN_BN_TEGUT = 37533UL,
      FI_EN_BN_TEKNISET = 37534UL,
      FI_EN_BN_TEKPA = 37535UL,
      FI_EN_BN_TEKSTILBANK = 37536UL,
      FI_EN_BN_TELEPIZZA = 37537UL,
      FI_EN_BN_TELUS = 37538UL,
      FI_EN_BN_TEMPEST = 37539UL,
      FI_EN_BN_TENGELMANN = 37540UL,
      FI_EN_BN_TERCAS = 37541UL,
      FI_EN_BN_TEREMOK = 37542UL,
      FI_EN_BN_TERIYAKI_STIX = 37543UL,
      FI_EN_BN_TERMO = 37544UL,
      FI_EN_BN_TERNO = 37545UL,
      FI_EN_BN_TERPEL = 37546UL,
      FI_EN_BN_TESCO_IRELAND = 37547UL,
      FI_EN_BN_TETCO = 37548UL,
      FI_EN_BN_TEXAS_ROADHOUSE = 37549UL,
      FI_EN_BN_TEXAS_STEAKHOUSE_SALOON = 37550UL,
      FI_EN_BN_TGI_FRIDAYS = 37551UL,
      FI_EN_BN_THANE_JANATA_SAHAKARI_BANK = 37552UL,
      FI_EN_BN_THANSEN = 37553UL,
      FI_EN_BN_THE_AJARA_URBAN_BANK = 37554UL,
      FI_EN_BN_THE_BAY = 37555UL,
      FI_EN_BN_THE_BISHOPS_ARMS = 37556UL,
      FI_EN_BN_THE_CAPITAL_GRILLE = 37557UL,
      FI_EN_BN_THE_COSMOS_CO_OP_BANK = 37558UL,
      FI_EN_BN_THE_DECCAN_MERCHANTS_CO_OP_BANK = 37559UL,
      FI_EN_BN_THE_DISCOVERY_STORE = 37560UL,
      FI_EN_BN_THE_HOME_DEPOT_FLOOR_STORE = 37561UL,
      FI_EN_BN_THE_HOME_DEPOT_LANDSCAPE_SUPPLY = 37562UL,
      FI_EN_BN_THE_HOME_DEPOT = 37563UL,
      FI_EN_BN_THE_KEG_STEAKHOUSE_BAR = 37564UL,
      FI_EN_BN_THE_LIMITED = 37565UL,
      FI_EN_BN_THE_MELTING_POT = 37566UL,
      FI_EN_BN_THE_MILLS = 37567UL,
      FI_EN_BN_THE_PHONE_HOUSE = 37568UL,
      FI_EN_BN_THE_READ_SHOP = 37569UL,
      FI_EN_BN_THE_SOURCE = 37570UL,
      FI_EN_BN_THEEB = 37571UL,
      FI_EN_BN_THIRD_FEDERAL_SAVINGS_LOAN = 37572UL,
      FI_EN_BN_THIROS = 37573UL,
      FI_EN_BN_THON = 37574UL,
      FI_EN_BN_THRIFTLODGE_CANADA = 37575UL,
      FI_EN_BN_THRIFTY_RENTAL_CAR = 37576UL,
      FI_EN_BN_THUNDERCLOUD_SUBS = 37577UL,
      FI_EN_BN_THURGAUER_KANTONALBANK = 37578UL,
      FI_EN_BN_TIA_CAR_RENT = 37579UL,
      FI_EN_BN_TIAS_TEX_MEX = 37580UL,
      FI_EN_BN_TIFFOSI = 37581UL,
      FI_EN_BN_TIFON = 37582UL,
      FI_EN_BN_TIGER_WHEEL_TYRE = 37583UL,
      FI_EN_BN_TIGRE = 37584UL,
      FI_EN_BN_TIGROS = 37585UL,
      FI_EN_BN_TIKE = 37586UL,
      FI_EN_BN_TIM_HORTONS = 37587UL,
      FI_EN_BN_TIMBER_LODGE_STEAKHOUSE = 37588UL,
      FI_EN_BN_TIMBERLAND = 37589UL,
      FI_EN_BN_TIMOTHYS = 37590UL,
      FI_EN_BN_TIP_TOP_TAILORS = 37591UL,
      FI_EN_BN_TIRECRAFT = 37592UL,
      FI_EN_BN_TIRES_PLUS = 37593UL,
      FI_EN_BN_TIREX = 37594UL,
      FI_EN_BN_TIVOLI = 37595UL,
      FI_EN_BN_T_MARKET = 37596UL,
      FI_EN_BN_T_MOBILE = 37597UL,
      FI_EN_BN_TNK = 37598UL,
      FI_EN_BN_TNSC_BANK = 37599UL,
      FI_EN_BN_TODIS = 37600UL,
      FI_EN_BN_TOGOS = 37601UL,
      FI_EN_BN_TOI_MOI = 37602UL,
      FI_EN_BN_TOKS = 37603UL,
      FI_EN_BN_TOKYO_EXPRESS = 37604UL,
      FI_EN_BN_TOM_CO = 37605UL,
      FI_EN_BN_TOMPKINS_TRUST_COMPANY = 37606UL,
      FI_EN_BN_TONY_ROMAS = 37607UL,
      FI_EN_BN_TOOM_BAUMARKT = 37608UL,
      FI_EN_BN_TOOM = 37609UL,
      FI_EN_BN_TOP_SERVICE_TEAM = 37610UL,
      FI_EN_BN_TOPAZ = 37611UL,
      FI_EN_BN_TOPPERS_PIZZA = 37612UL,
      FI_EN_BN_TORFS = 37613UL,
      FI_EN_BN_TORONTO_DOMINION_BANK_CANADA = 37614UL,
      FI_EN_BN_TORRID = 37615UL,
      FI_EN_BN_TOTTA = 37616UL,
      FI_EN_BN_TOWN_PUMP = 37617UL,
      FI_EN_BN_TOWNEPLACE_SUITES = 37618UL,
      FI_EN_BN_TOWNHOME_INN = 37619UL,
      FI_EN_BN_TOYSRUS = 37620UL,
      FI_EN_BN_TRADER_JOES = 37621UL,
      FI_EN_BN_TRADER_VICS_RESTAURANT = 37622UL,
      FI_EN_BN_TRAFIC = 37623UL,
      FI_EN_BN_TRAGUS = 37624UL,
      FI_EN_BN_TRASTA_KOMERCBANKA = 37625UL,
      FI_EN_BN_TRAVELCENTERS_OF_AMERICA = 37626UL,
      FI_EN_BN_TRAVELODGE_CANADA = 37627UL,
      FI_EN_BN_TREBOL = 37628UL,
      FI_EN_BN_TREFF = 37629UL,
      FI_EN_BN_TRENDWEST_RESORTS = 37630UL,
      FI_EN_BN_TRIAL = 37631UL,
      FI_EN_BN_TRIODOS_BANK = 37632UL,
      FI_EN_BN_TROEFMARKT = 37633UL,
      FI_EN_BN_TROMBA_RIJA = 37634UL,
      FI_EN_BN_TRONY = 37635UL,
      FI_EN_BN_TROPICAL_SMOOTHIE_CAFE = 37636UL,
      FI_EN_BN_TRYP_HOTELS = 37637UL,
      FI_EN_BN_TSAKIRIS_MALLAS = 37638UL,
      FI_EN_BN_TSENTR_INVEST = 37639UL,
      FI_EN_BN_TUBBYS = 37640UL,
      FI_EN_BN_TUFFY = 37641UL,
      FI_EN_BN_TUI_CARS = 37642UL,
      FI_EN_BN_TULLYS = 37643UL,
      FI_EN_BN_TUNE_UP = 37644UL,
      FI_EN_BN_TUO = 37645UL,
      FI_EN_BN_TUODI = 37646UL,
      FI_EN_BN_TURIN = 37647UL,
      FI_EN_BN_TURK_EXIMBANK = 37648UL,
      FI_EN_BN_TUERK_PETROL = 37649UL,
      FI_EN_BN_TURKISH_BANK = 37650UL,
      FI_EN_BN_TURKIYE_FINANS_KATILIM_BANKASI = 37651UL,
      FI_EN_BN_TURKIYE_IS_BANKASI = 37652UL,
      FI_EN_BN_TURKLAND_BANK = 37653UL,
      FI_EN_BN_TURKUAZ = 37654UL,
      FI_EN_BN_TUS_OIL = 37655UL,
      FI_EN_BN_TUS = 37656UL,
      FI_EN_BN_TUTA = 37657UL,
      FI_EN_BN_TVS_MOTORS = 37658UL,
      FI_EN_BN_U_SAVE_AUTO_RENTAL = 37659UL,
      FI_EN_BN_UBA = 37660UL,
      FI_EN_BN_UBS_AG = 37661UL,
      FI_EN_BN_UCAR = 37662UL,
      FI_EN_BN_UCI_KINOWELT = 37663UL,
      FI_EN_BN_UCI = 37664UL,
      FI_EN_BN_UCO_BANK = 37665UL,
      FI_EN_BN_UDACO = 37666UL,
      FI_EN_BN_UDGAM_VIKAS_SAHAKARI_BANK = 37667UL,
      FI_EN_BN_UGC = 37668UL,
      FI_EN_BN_UGUR_CENTER = 37669UL,
      FI_EN_BN_ULLRICH = 37670UL,
      FI_EN_BN_ULSTER_BANK = 37671UL,
      FI_EN_BN_ULTRA = 37672UL,
      FI_EN_BN_UMB_BANK = 37673UL,
      FI_EN_BN_UNA_MAS = 37674UL,
      FI_EN_BN_UNAWAY = 37675UL,
      FI_EN_BN_UNDERGROUND_STATION = 37676UL,
      FI_EN_BN_UNES = 37677UL,
      FI_EN_BN_UNI_CREDITO = 37678UL,
      FI_EN_BN_UNIBANCO = 37679UL,
      FI_EN_BN_UNIBANKA = 37680UL,
      FI_EN_BN_UNICAJA = 37681UL,
      FI_EN_BN_UNICASA_SUPERMERCADOS = 37682UL,
      FI_EN_BN_UNICO = 37683UL,
      FI_EN_BN_UNICREDIT_BANCA = 37684UL,
      FI_EN_BN_UNICREDIT_BANK = 37685UL,
      FI_EN_BN_UNICREDIT_BULBANK = 37686UL,
      FI_EN_BN_UNICREDIT_ROMANIA = 37687UL,
      FI_EN_BN_UNICREDIT_TIRIAC_BANK = 37688UL,
      FI_EN_BN_UNIDAS = 37689UL,
      FI_EN_BN_UNIEURO = 37690UL,
      FI_EN_BN_UNIMARC = 37691UL,
      FI_EN_BN_UNIMARKT = 37692UL,
      FI_EN_BN_UNION_BANK_TRUST = 37693UL,
      FI_EN_BN_UNION_BANK_OF_CALIFORNIA = 37694UL,
      FI_EN_BN_UNION_BANK_OF_INDIA = 37695UL,
      FI_EN_BN_UNION_PLANTERS_BANK = 37696UL,
      FI_EN_BN_UNIPOL_BANCA = 37697UL,
      FI_EN_BN_UNIPRIX = 37698UL,
      FI_EN_BN_UNITED_BANK_OF_INDIA = 37699UL,
      FI_EN_BN_UNITED_BRANDS = 37700UL,
      FI_EN_BN_UNITED_BULGARIAN_BANK = 37701UL,
      FI_EN_BN_UNITY_BANK = 37702UL,
      FI_EN_BN_UNO_CHICAGO_GRILL = 37703UL,
      FI_EN_BN_UNO_E = 37704UL,
      FI_EN_BN_UOB_BUANA = 37705UL,
      FI_EN_BN_UPI = 37706UL,
      FI_EN_BN_UPS_STORE = 37707UL,
      FI_EN_BN_UPS = 37708UL,
      FI_EN_BN_UPSTALSBOOM = 37709UL,
      FI_EN_BN_URALSIB = 37710UL,
      FI_EN_BN_URBAN_BEHAVIOR = 37711UL,
      FI_EN_BN_URNER_KANTONALBANK = 37712UL,
      FI_EN_BN_US_BANK = 37713UL,
      FI_EN_BN_US_CELLULAR = 37714UL,
      FI_EN_BN_USPET = 37715UL,
      FI_EN_BN_UTKONOS = 37716UL,
      FI_EN_BN_UTOPIA = 37717UL,
      FI_EN_BN_UTOPOLIS = 37718UL,
      FI_EN_BN_UYUM = 37719UL,
      FI_EN_BN_VACANCES_BLEUES = 37720UL,
      FI_EN_BN_VAKIFBANK = 37721UL,
      FI_EN_BN_VALENTINE = 37722UL,
      FI_EN_BN_VALIANT_BANK = 37723UL,
      FI_EN_BN_VALIEXCHIMP = 37724UL,
      FI_EN_BN_VALINTATALO = 37725UL,
      FI_EN_BN_VALLEY_NATIONAL_BANK = 37726UL,
      FI_EN_BN_VALVOLINE_INSTANT_OIL_CHANGE = 37727UL,
      FI_EN_BN_VAN_HOUTTE = 37728UL,
      FI_EN_BN_VAN_REETH = 37729UL,
      FI_EN_BN_VANCITY_CREDIT_UNION = 37730UL,
      FI_EN_BN_VANDEN_BORRE = 37731UL,
      FI_EN_BN_VANITY = 37732UL,
      FI_EN_BN_VAZ = 37733UL,
      FI_EN_BN_VECINO = 37734UL,
      FI_EN_BN_VEF_BANKA = 37735UL,
      FI_EN_BN_VEFK = 37736UL,
      FI_EN_BN_VENETO_BANCA = 37737UL,
      FI_EN_BN_VENEZOLANO_DE_CREDITO = 37738UL,
      FI_EN_BN_VENTUS = 37739UL,
      FI_EN_BN_VERBANDS_SPARKASSE_WESEL = 37740UL,
      FI_EN_BN_VERGOELST = 37741UL,
      FI_EN_BN_VERIZON = 37742UL,
      FI_EN_BN_VERO_MODA = 37743UL,
      FI_EN_BN_VEROPOULOS_SPAR = 37744UL,
      FI_EN_BN_VETI = 37745UL,
      FI_EN_BN_VIADA = 37746UL,
      FI_EN_BN_VI_BUTIKERNA = 37747UL,
      FI_EN_BN_VICTORIAS_SECRET = 37748UL,
      FI_EN_BN_VICTORY = 37749UL,
      FI_EN_BN_VIDAL = 37750UL,
      FI_EN_BN_VIDYA_SAHAKARI_BANK = 37751UL,
      FI_EN_BN_VIE_DE_FRANCE = 37752UL,
      FI_EN_BN_VIENA = 37753UL,
      FI_EN_BN_VIJAYA_BANK = 37754UL,
      FI_EN_BN_VILLA_DEL_MAR = 37755UL,
      FI_EN_BN_VILLA_PIZZA = 37756UL,
      FI_EN_BN_VILLAGE_CINEMAS = 37757UL,
      FI_EN_BN_VINCCI = 37758UL,
      FI_EN_BN_VINCI_PARK = 37759UL,
      FI_EN_BN_VIPS = 37760UL,
      FI_EN_BN_VIS_A_VIS = 37761UL,
      FI_EN_BN_VITA = 37762UL,
      FI_EN_BN_VITALYS = 37763UL,
      FI_EN_BN_VIVAHOTEL = 37764UL,
      FI_EN_BN_VIVAL = 37765UL,
      FI_EN_BN_VIVO = 37766UL,
      FI_EN_BN_VLAIKOVA = 37767UL,
      FI_EN_BN_VOBIS = 37768UL,
      FI_EN_BN_VODAFONE = 37769UL,
      FI_EN_BN_VOEGELE = 37770UL,
      FI_EN_BN_VOLG = 37771UL,
      FI_EN_BN_VOLGANEFTEPRODUKT = 37772UL,
      FI_EN_BN_VOLGA_PETROLEUM = 37773UL,
      FI_EN_BN_VOLKSBANK_GOEPPINGEN = 37774UL,
      FI_EN_BN_VOLKSBANK_HEILBRONN = 37775UL,
      FI_EN_BN_VOLKSBANK_HOHENZOLLERN = 37776UL,
      FI_EN_BN_VOLKSBANK_KARLSRUHE = 37777UL,
      FI_EN_BN_VOLKSBANK_LUDWIGSBURG = 37778UL,
      FI_EN_BN_VOLKSBANK_NAHETAL = 37779UL,
      FI_EN_BN_VOLKSBANK_PADERBORN_HOEXTER_DETMOLD = 37780UL,
      FI_EN_BN_VOLKSBANK_PFORZHEIM = 37781UL,
      FI_EN_BN_VOLKSBANK_REMS = 37782UL,
      FI_EN_BN_VOLKSBANK_ROTTWEIL = 37783UL,
      FI_EN_BN_VOLKSBANK = 37784UL,
      FI_EN_BN_VOLKSBANKEN_RAIFFEISENBANKEN = 37785UL,
      FI_EN_BN_VOLKSKREDITBANK = 37786UL,
      FI_EN_BN_VOMAR = 37787UL,
      FI_EN_BN_VONS = 37788UL,
      FI_EN_BN_VOZROZHDENIE = 37789UL,
      FI_EN_BN_VP_MEDIA = 37790UL,
      FI_EN_BN_VP_MARKET = 37791UL,
      FI_EN_BN_VR_BANK_HOF = 37792UL,
      FI_EN_BN_VR_BANK_RHEIN_NECKAR = 37793UL,
      FI_EN_BN_VR_GENOSSENSCHAFTSBANK_FULDA = 37794UL,
      FI_EN_BN_VSEOBECNA_UVEROVA_BANKA = 37795UL,
      FI_EN_BN_VTB_24 = 37796UL,
      FI_EN_BN_VTB = 37797UL,
      FI_EN_BN_VUE = 37798UL,
      FI_EN_BN_W = 37799UL,
      FI_EN_BN_WACHOVIA = 37800UL,
      FI_EN_BN_WAFFLE_HOUSE = 37801UL,
      FI_EN_BN_WAHOOS_FISH_TACO = 37802UL,
      FI_EN_BN_WAITROSE = 37803UL,
      FI_EN_BN_WALDENBOOKS = 37804UL,
      FI_EN_BN_WALDORF_ASTORIA_COLLECTION = 37805UL,
      FI_EN_BN_WALGREENS = 37806UL,
      FI_EN_BN_WALL_STREET_DELI = 37807UL,
      FI_EN_BN_WALLISER_KANTONALBANK = 37808UL,
      FI_EN_BN_WAL_MART_PHARMACY = 37809UL,
      FI_EN_BN_WAL_MART_SUPERCENTER = 37810UL,
      FI_EN_BN_WAL_MART_TIRE_AND_LUBE = 37811UL,
      FI_EN_BN_WARNER_VILLAGE = 37812UL,
      FI_EN_BN_WASH_BOX = 37813UL,
      FI_EN_BN_WASHINGTON_MUTUAL = 37814UL,
      FI_EN_BN_WATANIA = 37815UL,
      FI_EN_BN_WATANYA = 37816UL,
      FI_EN_BN_WE = 37817UL,
      FI_EN_BN_WEGMANS_PHARMACY = 37818UL,
      FI_EN_BN_WEGMANS = 37819UL,
      FI_EN_BN_WEIS_MARKETS = 37820UL,
      FI_EN_BN_WELL = 37821UL,
      FI_EN_BN_WELLS_FARGO = 37822UL,
      FI_EN_BN_WEMA_BANK = 37823UL,
      FI_EN_BN_WENDYS = 37824UL,
      FI_EN_BN_WERE_ROLLING_PRETZEL_COMPANY = 37825UL,
      FI_EN_BN_WESBANK = 37826UL,
      FI_EN_BN_WESSELS_MUELLER = 37827UL,
      FI_EN_BN_WEST_BROMWICH_BUILDING_SOCIETY = 37828UL,
      FI_EN_BN_WESTERN_SIZZLIN_STEAK_MORE = 37829UL,
      FI_EN_BN_WESTERN_UNION = 37830UL,
      FI_EN_BN_WESTLB = 37831UL,
      FI_EN_BN_WESTPAC = 37832UL,
      FI_EN_BN_WESTSIDE_DELI = 37833UL,
      FI_EN_BN_WET_SEAL = 37834UL,
      FI_EN_BN_WETZELS_PRETZELS = 37835UL,
      FI_EN_BN_WG_GRINDERS = 37836UL,
      FI_EN_BN_WHATABURGER = 37837UL,
      FI_EN_BN_WHITE_BARN_CANDLE_CO = 37838UL,
      FI_EN_BN_WHITE_CASTLE = 37839UL,
      FI_EN_BN_WHITE_HEN_PANTRY = 37840UL,
      FI_EN_BN_WHITE_HOUSE_BLACK_MARKET = 37841UL,
      FI_EN_BN_WHITE_SPOT = 37842UL,
      FI_EN_BN_WHITTS_BARBECUE = 37843UL,
      FI_EN_BN_WHOLE_FOODS = 37844UL,
      FI_EN_BN_WHSMITH = 37845UL,
      FI_EN_BN_WIBRA = 37846UL,
      FI_EN_BN_WIENER_SPAR_UND_KREDITINSTITUT = 37847UL,
      FI_EN_BN_WIENERSCHNITZEL = 37848UL,
      FI_EN_BN_WIENERWALD = 37849UL,
      FI_EN_BN_WIESBADENER_VOLKSBANK = 37850UL,
      FI_EN_BN_WILD_BEAN_CAFE = 37851UL,
      FI_EN_BN_WILLIAMS_COFFEE_PUB = 37852UL,
      FI_EN_BN_WILLYS_HEMMA = 37853UL,
      FI_EN_BN_WILLYS = 37854UL,
      FI_EN_BN_WIMPY = 37855UL,
      FI_EN_BN_WINCHELLS = 37856UL,
      FI_EN_BN_WIND = 37857UL,
      FI_EN_BN_WINGATE_BY_WYNDHAM = 37858UL,
      FI_EN_BN_WINGS = 37859UL,
      FI_EN_BN_WINGSTOP = 37860UL,
      FI_EN_BN_WINN_DIXIE = 37861UL,
      FI_EN_BN_WINNERS = 37862UL,
      FI_EN_BN_WINTERS = 37863UL,
      FI_EN_BN_WOLFF_CINEMA = 37864UL,
      FI_EN_BN_WOMENS_SECRET = 37865UL,
      FI_EN_BN_WONGS_WOK = 37866UL,
      FI_EN_BN_WOODYS_BARBQ = 37867UL,
      FI_EN_BN_WOOLWICH = 37868UL,
      FI_EN_BN_WORLD_WRAPPS = 37869UL,
      FI_EN_BN_WORLDHOTELS = 37870UL,
      FI_EN_BN_WORTEN = 37871UL,
      FI_EN_BN_WUESTENROT = 37872UL,
      FI_EN_BN_WYNDAM_HOTELS = 37873UL,
      FI_EN_BN_XXXLUTZ = 37874UL,
      FI_EN_BN_XYNOS = 37875UL,
      FI_EN_BN_YAKITORIYA = 37876UL,
      FI_EN_BN_YAPI_KREDI_BANKASI = 37877UL,
      FI_EN_BN_YAPOSHA = 37878UL,
      FI_EN_BN_YARD_HOUSE = 37879UL,
      FI_EN_BN_YELMO = 37880UL,
      FI_EN_BN_YOKOHAMA_RICE_BOWL = 37881UL,
      FI_EN_BN_YORKSHIRE_BANK = 37882UL,
      FI_EN_BN_YORKSHIRE_BUILDING_SOCIETY = 37883UL,
      FI_EN_BN_YOSHINOYA = 37884UL,
      FI_EN_BN_YOUNGS_BREWERY = 37885UL,
      FI_EN_BN_YOUR_HOTEL = 37886UL,
      FI_EN_BN_YOURS_TRULY = 37887UL,
      FI_EN_BN_YPF = 37888UL,
      FI_EN_BN_YUKOS = 37889UL,
      FI_EN_BN_YUNIASTRUM_BANK = 37890UL,
      FI_EN_BN_YUNIKREDIT_BANK = 37891UL,
      FI_EN_BN_YUNUS_MARKET = 37892UL,
      FI_EN_BN_YUROPET = 37893UL,
      FI_EN_BN_YX = 37894UL,
      FI_EN_BN_ZAFFARI = 37895UL,
      FI_EN_BN_ZAGREBACKA_BANKA = 37896UL,
      FI_EN_BN_ZARA = 37897UL,
      FI_EN_BN_ZAXBYS = 37898UL,
      FI_EN_BN_ZDOROVYE_LYUDI = 37899UL,
      FI_EN_BN_ZEEMAN = 37900UL,
      FI_EN_BN_ZEHRS = 37901UL,
      FI_EN_BN_ZELLERS_PHARMACY = 37902UL,
      FI_EN_BN_ZELLERS = 37903UL,
      FI_EN_BN_ZENIT = 37904UL,
      FI_EN_BN_ZENITH_BANK = 37905UL,
      FI_EN_BN_ZEYNEL_CILLI = 37906UL,
      FI_EN_BN_ZIELPUNKT = 37907UL,
      FI_EN_BN_ZIONS_BANK = 37908UL,
      FI_EN_BN_ZIONS_FIRST_NATIONAL_BANK = 37909UL,
      FI_EN_BN_ZIPPO = 37910UL,
      FI_EN_BN_ZIPPY_KIDSTORE = 37911UL,
      FI_EN_BN_ZIZ = 37912UL,
      FI_EN_BN_ZOES_KITCHEN = 37913UL,
      FI_EN_BN_ZON_LUSOMUNDO = 37914UL,
      FI_EN_BN_ZOUP_ = 37915UL,
      FI_EN_BN_ZUGER_KANTONALBANK = 37916UL,
      FI_EN_BN_ZUERCHER_KANTONALBANK = 37917UL,
      FI_EN_BN_PETIT_BISTRO = 37944UL,
      FI_EN_BN_ACCOMMODATION_GETAWAYS_VIC = 37945UL,
      FI_EN_BN_AUSTRALIS = 37946UL,
      FI_EN_BN_BED_BREAKFAST_NSW = 37947UL,
      FI_EN_BN_BED_BREAKFAST_NT = 37948UL,
      FI_EN_BN_BED_BREAKFAST_QLD = 37949UL,
      FI_EN_BN_BED_BREAKFAST_SA = 37950UL,
      FI_EN_BN_BED_BREAKFAST_TAS = 37951UL,
      FI_EN_BN_BREAKFREE = 37952UL,
      FI_EN_BN_BREAKFREE_RESORTS = 37953UL,
      FI_EN_BN_BROADWATER_RESORTS = 37954UL,
      FI_EN_BN_CHANCELLOR = 37955UL,
      FI_EN_BN_CHIFLEY = 37956UL,
      FI_EN_BN_CITIGATE = 37957UL,
      FI_EN_BN_COMFORT = 37958UL,
      FI_EN_BN_COUNTRY_COMFORT = 37959UL,
      FI_EN_BN_GOLDEN_CHAIN = 37960UL,
      FI_EN_BN_GRAND_CHANCELLOR = 37961UL,
      FI_EN_BN_GRAND_MERCURE = 37962UL,
      FI_EN_BN_HYATT = 37963UL,
      FI_EN_BN_LANDMARK_RESORTS = 37964UL,
      FI_EN_BN_LEISURE_INN = 37965UL,
      FI_EN_BN_MANNING_APARTMENT_HOTELS = 37966UL,
      FI_EN_BN_MANTRA = 37967UL,
      FI_EN_BN_MEDINA = 37968UL,
      FI_EN_BN_MEDINA_APARTMENT_HOTELS = 37969UL,
      FI_EN_BN_MERITON_APARTMENTS = 37970UL,
      FI_EN_BN_OAKFORD = 37971UL,
      FI_EN_BN_OAKS = 37972UL,
      FI_EN_BN_OAKS_HOTELS = 37973UL,
      FI_EN_BN_PACIFIC_INTERNATIONAL = 37974UL,
      FI_EN_BN_PALAZZO_RESORTS = 37975UL,
      FI_EN_BN_PARK_REGIS = 37976UL,
      FI_EN_BN_PUNTHILL_APARTMENT_HOTELS = 37977UL,
      FI_EN_BN_QUAY_GRAND_QUAY_WEST_SUITES = 37978UL,
      FI_EN_BN_CALVIN_KLEIN = 37979UL,
      FI_EN_BN_RENDEZVOUS = 37980UL,
      FI_EN_BN_RYDGES = 37981UL,
      FI_EN_BN_SAVILLE_SUITES = 37982UL,
      FI_EN_BN_SEBEL = 37983UL,
      FI_EN_BN_SHERATON_PERTH_HOTEL = 37984UL,
      FI_EN_BN_SOMERSET = 37985UL,
      FI_EN_BN_STAMFORD = 37986UL,
      FI_EN_BN_STAR_CITY_5_STAR_LUXURY = 37987UL,
      FI_EN_BN_COTTON_CLUB = 37988UL,
      FI_EN_BN_TOWN_COUNTRY_ACCOMMODATION_WA = 37989UL,
      FI_EN_BN_TRAVELODGE_HOTELS = 37990UL,
      FI_EN_BN_YHA = 37991UL,
      FI_EN_BN_AMPOL = 37992UL,
      FI_EN_BN_APCO = 37993UL,
      FI_EN_BN_BETTER_CHOICE = 37994UL,
      FI_EN_BN_BLUE_STAR = 37995UL,
      FI_EN_BN_BOGAS = 37996UL,
      FI_EN_BN_BRANBAC = 37997UL,
      FI_EN_BN_CALTEX_SAFEWAY = 37998UL,
      FI_EN_BN_CALTEX_WOOLWORTHS = 37999UL,
      FI_EN_BN_COLES_EXPRESS = 38000UL,
      FI_EN_BN_CROSS_COUNTRY = 38001UL,
      FI_EN_BN_ENFFUE = 38002UL,
      FI_EN_BN_EXCEL = 38003UL,
      FI_EN_BN_FREEDOM_FUELS = 38004UL,
      FI_EN_BN_FUEL_ZONE = 38005UL,
      FI_EN_BN_GUCCI = 38006UL,
      FI_EN_BN_MAJOR = 38007UL,
      FI_EN_BN_MATILDA_FUELS = 38008UL,
      FI_EN_BN_NEUMANN_PETROLEUM = 38009UL,
      FI_EN_BN_HUGO_BOSS = 38010UL,
      FI_EN_BN_PENTACO = 38011UL,
      FI_EN_BN_SAFF = 38012UL,
      FI_EN_BN_SOLO = 38013UL,
      FI_EN_BN_UNITED_PETROLEUM = 38014UL,
      FI_EN_BN_VOLUME_PLUS = 38015UL,
      FI_EN_BN_WESTERN_FUEL = 38016UL,
      FI_EN_BN_WOOLWORTHS = 38017UL,
      FI_EN_BN_CHALLENGE = 38018UL,
      FI_EN_BN_ATU_AUTOSERVIS_PRO_KAZDEHO = 38019UL,
      FI_EN_BN_ATU_AUTOSUPERMARKET_E_OFFICINA = 38020UL,
      FI_EN_BN_ATU_DE_COMPLETE_GARAGE = 38021UL,
      FI_EN_BN_ATU_DIE_NR1_MEISTERWERKSTATT = 38022UL,
      FI_EN_BN_AGNES_B = 38023UL,
      FI_EN_BN_AGORA = 38024UL,
      FI_EN_BN_AUGUSTA_BANK = 38025UL,
      FI_EN_BN_BAKERS_2 = 38026UL,
      FI_EN_BN_BAKERS_PHARMACY = 38027UL,
      FI_EN_BN_BASS_PRO_SHOPS = 38028UL,
      FI_EN_BN_BLAU_VERD_HOTELS = 38029UL,
      FI_EN_BN_BRANDENBURGER_BANK = 38030UL,
      FI_EN_BN_BREMISCHE_VOLKSBANK = 38031UL,
      FI_EN_BN_CEREALITY = 38032UL,
      FI_EN_BN_CHICOS = 38033UL,
      FI_EN_BN_CITY_MARKET = 38034UL,
      FI_EN_BN_CITY_MARKET_FUEL_CENTER = 38035UL,
      FI_EN_BN_CITY_MARKET_PHARMACY = 38036UL,
      FI_EN_BN_CLICKS = 38037UL,
      FI_EN_BN_COAST_GAS = 38038UL,
      FI_EN_BN_COSMOTE = 38039UL,
      FI_EN_BN_COSTA_BRAVA_HOTELS = 38040UL,
      FI_EN_BN_COULEURS_DE_TOLLENS = 38041UL,
      FI_EN_BN_CREDIT_UND_VOLKSBANK = 38042UL,
      FI_EN_BN_NEIMAN_MARCUS = 38043UL,
      FI_EN_BN_DILLONS_FUEL_CENTER = 38044UL,
      FI_EN_BN_DILLONS_MARKETPLACE = 38045UL,
      FI_EN_BN_DILLONS_MARKETPLACE_FUEL_CENTER = 38046UL,
      FI_EN_BN_DILLONS_MARKETPLACE_PHARMACY = 38047UL,
      FI_EN_BN_DILLONS_PHARMACY = 38048UL,
      FI_EN_BN_DITHMARSCHER_VR_BANK = 38049UL,
      FI_EN_BN_DORTMUNDER_VOLKSBANK = 38050UL,
      FI_EN_BN_DRESDNER_VOLKSBANK_RAIFFEISENBANK = 38051UL,
      FI_EN_BN_ECKERNFOERDER_BANK = 38052UL,
      FI_EN_BN_EDEKABANK = 38053UL,
      FI_EN_BN_EHINGER_VOLKSBANK = 38054UL,
      FI_EN_BN_EMSLAENDISCHE_VOLKSBANK = 38055UL,
      FI_EN_BN_ENZTALBANK = 38056UL,
      FI_EN_BN_ERFURTER_BANK = 38057UL,
      FI_EN_BN_EVANGELISCHE_KREDITGENOSSENSCHAFT = 38058UL,
      FI_EN_BN_FAMILYPRIX = 38059UL,
      FI_EN_BN_FARMACIILE_DONA = 38060UL,
      FI_EN_BN_FOOD_4_LESS = 38061UL,
      FI_EN_BN_FOOD_4_LESS_FUEL_CENTER = 38062UL,
      FI_EN_BN_FOOD_4_LESS_PHARMACY = 38063UL,
      FI_EN_BN_FOODS_CO = 38064UL,
      FI_EN_BN_FOODS_CO_FUEL_CENTER = 38065UL,
      FI_EN_BN_FOODS_CO_PHARMACY = 38066UL,
      FI_EN_BN_FRANKENBERGER_BANK = 38067UL,
      FI_EN_BN_FRASSES = 38068UL,
      FI_EN_BN_FRED_MEYER = 38069UL,
      FI_EN_BN_FRED_MEYER_FUEL_CENTER = 38070UL,
      FI_EN_BN_FREIBERGER_BANK = 38071UL,
      FI_EN_BN_FREISINGER_BANK = 38072UL,
      FI_EN_BN_FRYS = 38073UL,
      FI_EN_BN_FRYS_FUEL_CENTER = 38074UL,
      FI_EN_BN_FRYS_MARKETPLACE = 38075UL,
      FI_EN_BN_FRYS_MARKETPLACE_FUEL_CENTER = 38076UL,
      FI_EN_BN_FRYS_MARKETPLACE_PHARMACY = 38077UL,
      FI_EN_BN_FRYS_PHARMACY = 38078UL,
      FI_EN_BN_GENO_BANK_ESSEN = 38079UL,
      FI_EN_BN_GENOBANK_DONAUWALD = 38080UL,
      FI_EN_BN_GENOBANK_RHOEN_GRABFELD = 38081UL,
      FI_EN_BN_GENOSSENSCHAFTSBANK_UNTERALLG = 38082UL,
      FI_EN_BN_GERAER_BANK = 38083UL,
      FI_EN_BN_GERBES = 38084UL,
      FI_EN_BN_GERBES_PHARMACY = 38085UL,
      FI_EN_BN_GERMANOS = 38086UL,
      FI_EN_BN_GOLDEN_KRUST_BAKERY = 38087UL,
      FI_EN_BN_GRAFSCHAFTER_VOLKSBANK = 38088UL,
      FI_EN_BN_GROSS_GERAUER_VOLKSBANK = 38089UL,
      FI_EN_BN_H_G_BANK_HEIDELBERG_KURPFALZ = 38090UL,
      FI_EN_BN_HALLERTAUER_VOLKSBANK = 38091UL,
      FI_EN_BN_HEIDELBERGER_VOLKSBANK = 38092UL,
      FI_EN_BN_HEIDENHEIMER_VOLKSBANK = 38093UL,
      FI_EN_BN_HILANDER = 38094UL,
      FI_EN_BN_HILANDER_FUEL_CENTER = 38095UL,
      FI_EN_BN_HILANDER_PHARMACY = 38096UL,
      FI_EN_BN_HONEY_DEW_DONUTS = 38097UL,
      FI_EN_BN_JAY_C = 38098UL,
      FI_EN_BN_JAY_C_FUEL_CENTER = 38099UL,
      FI_EN_BN_JAY_C_PHARMACY = 38100UL,
      FI_EN_BN_JOHN_DORYS = 38101UL,
      FI_EN_BN_JOHNNIES = 38102UL,
      FI_EN_BN_KASSELER_BANK = 38103UL,
      FI_EN_BN_KIELER_VOLKSBANK = 38104UL,
      FI_EN_BN_KING_SOOPERS = 38105UL,
      FI_EN_BN_KING_SOOPERS_FUEL_CENTER = 38106UL,
      FI_EN_BN_KROGER_FUEL_CENTER = 38107UL,
      FI_EN_BN_KROGER_MARKETPLACE = 38108UL,
      FI_EN_BN_KROGER_MARKETPLACE_FUEL_CENTER = 38109UL,
      FI_EN_BN_KROGER_MARKETPLACE_PHARMACY = 38110UL,
      FI_EN_BN_KULMBACHER_BANK = 38111UL,
      FI_EN_BN_LANDSBERG_AMMERSEE_BANK = 38112UL,
      FI_EN_BN_LARKSPUR_HOTELS = 38113UL,
      FI_EN_BN_LEDO_PIZZA_AND_PASTA = 38114UL,
      FI_EN_BN_LEUTKIRCHER_BANK = 38115UL,
      FI_EN_BN_LEVOBANK = 38116UL,
      FI_EN_BN_LIGA_BANK = 38117UL,
      FI_EN_BN_LOAF_N_JUG = 38118UL,
      FI_EN_BN_LOXAM = 38119UL,
      FI_EN_BN_MAERKISCHE_BANK = 38120UL,
      FI_EN_BN_MCCAFE = 38121UL,
      FI_EN_BN_MERCHANTS_TIRE_AUTO = 38122UL,
      FI_EN_BN_MUENCHNER_BANK = 38123UL,
      FI_EN_BN_NORDTHUERINGER_VOLKSBANK = 38124UL,
      FI_EN_BN_OIL_CAN_HENRYS = 38125UL,
      FI_EN_BN_OSTFRIESISCHE_VOLKSBANK = 38126UL,
      FI_EN_BN_OSTHARZER_VOLKSBANK = 38127UL,
      FI_EN_BN_OWENS = 38128UL,
      FI_EN_BN_OWENS_FUEL_CENTER = 38129UL,
      FI_EN_BN_OWENS_PHARMACY = 38130UL,
      FI_EN_BN_PAY_LESS_FUEL_CENTER = 38131UL,
      FI_EN_BN_PAY_LESS_PHARMACY = 38132UL,
      FI_EN_BN_PENNYPINCHERS = 38133UL,
      FI_EN_BN_PETITS_GRANS_HOTELS_DE_CATALUNYA = 38134UL,
      FI_EN_BN_PETRO_T = 38135UL,
      FI_EN_BN_PHARMAVIE = 38136UL,
      FI_EN_BN_POMMERSCHE_VOLKSBANK = 38137UL,
      FI_EN_BN_PRICE_RITE = 38138UL,
      FI_EN_BN_PRICE_RITE_PHARMACY = 38139UL,
      FI_EN_BN_QFC = 38140UL,
      FI_EN_BN_QFC_FUEL_CENTER = 38141UL,
      FI_EN_BN_QFC_PHARMACY = 38142UL,
      FI_EN_BN_RAIFFEISEN_SPAR_KREDITBANK = 38143UL,
      FI_EN_BN_RAIFFEISENBANK_AUGSBURGER_LAND_WEST = 38144UL,
      FI_EN_BN_RAIFFEISENBANK_BAD_ABBACH_SAAL = 38145UL,
      FI_EN_BN_RAIFFEISENBANK_BURGAU = 38146UL,
      FI_EN_BN_RAIFFEISENBANK_DONAU_HEUBERG = 38147UL,
      FI_EN_BN_RAIFFEISENBANK_EHINGEN_HOCHSTRAESS = 38148UL,
      FI_EN_BN_RAIFFEISENBANK_ERKELENZ = 38149UL,
      FI_EN_BN_RAIFFEISENBANK_GREVENBROICH = 38150UL,
      FI_EN_BN_RAIFFEISENBANK_GROSSENLUEDER = 38151UL,
      FI_EN_BN_RAIFFEISENBANK_HAMMELBURG = 38152UL,
      FI_EN_BN_RAIFFEISENBANK_HEINSBERG = 38153UL,
      FI_EN_BN_RAIFFEISENBANK_IM_ALLGAEUER_LAND = 38154UL,
      FI_EN_BN_RAIFFEISENBANK_IM_KREIS_CALW = 38155UL,
      FI_EN_BN_RAIFFEISENBANK_IM_NAABTAL = 38156UL,
      FI_EN_BN_RAIFFEISENBANK_IM_OBERLAND = 38157UL,
      FI_EN_BN_RAIFFEISENBANK_IM_STIFTLAND = 38158UL,
      FI_EN_BN_RAIFFEISENBANK_ISAR_LOISACHTAL = 38159UL,
      FI_EN_BN_RAIFFEISENBANK_KARLSTADT_GEMUENDEN = 38160UL,
      FI_EN_BN_RAIFFEISENBANK_KEMPTEN = 38161UL,
      FI_EN_BN_RAIFFEISENBANK_KIRCHWEIHTAL = 38162UL,
      FI_EN_BN_RAIFFEISENBANK_KRUMBACH = 38163UL,
      FI_EN_BN_RAIFFEISENBANK_LOHR_AM_MAIN = 38164UL,
      FI_EN_BN_RAIFFEISENBANK_MARKTHEIDENFELD = 38165UL,
      FI_EN_BN_RAIFFEISENBANK_OBERALLGAEU_SUED = 38166UL,
      FI_EN_BN_RAIFFEISENBANK_OBERMAIN_NORD = 38167UL,
      FI_EN_BN_RAIFFEISENBANK_OBERPFALZ_SUED = 38168UL,
      FI_EN_BN_RAIFFEISENBANK_RHEINBACH_VOREIFEL = 38169UL,
      FI_EN_BN_RAIFFEISENBANK_RHEIN_BERG = 38170UL,
      FI_EN_BN_RAIFFEISENBANK_RISSTAL = 38171UL,
      FI_EN_BN_RAIFFEISENBANK_RONSHAUSEN_MARKSUHL = 38172UL,
      FI_EN_BN_RAIFFEISENBANK_ROSDORF = 38173UL,
      FI_EN_BN_RAIFFEISENBANK_ROTTUMTAL = 38174UL,
      FI_EN_BN_RAIFFEISENBANK_SCHWANDORF_NITTENAU = 38175UL,
      FI_EN_BN_RAIFFEISENBANK_STRAUBING = 38176UL,
      FI_EN_BN_RAIFFEISENBANK_TOELZER_LAND = 38177UL,
      FI_EN_BN_RAIFFEISENBANK_TROSTBERG_TRAUNREUT = 38178UL,
      FI_EN_BN_RAIFFEISENBANK_VOLKACH_WIESENTHEID = 38179UL,
      FI_EN_BN_RAIFFEISENBANK_WESERMARSCH_SUED = 38180UL,
      FI_EN_BN_RAIFFEISENBANK_WESTEIFEL = 38181UL,
      FI_EN_BN_RAIFFEISENBANK_VOLKSBANK_MILTENBERG = 38182UL,
      FI_EN_BN_RAIFFEISEN_VB_BAD_STAFFELSTEIN = 38183UL,
      FI_EN_BN_RAIFFEISEN_VB_DONAUWOERTH = 38184UL,
      FI_EN_BN_RAIFFEISEN_VB_FUERTH = 38185UL,
      FI_EN_BN_RAIFFEISEN_VB_LICHTENFELS_ITZGRUND = 38186UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_EBERSBERG = 38187UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_FRESENA = 38188UL,
      FI_EN_BN_RAIFFEISENVOLKSBANK_GEWERBEBANK = 38189UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_HASSBERGE = 38190UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_ISEN_SEMPT = 38191UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_RIES = 38192UL,
      FI_EN_BN_RAIFFEISEN_VOLKSBANK_SAALE_ORLA = 38193UL,
      FI_EN_BN_RALPHS_FUEL_CENTER = 38194UL,
      FI_EN_BN_RALPHS_PHARMACY = 38195UL,
      FI_EN_BN_RANCH_1 = 38196UL,
      FI_EN_BN_RB_ALTDORF_ERGOLDING = 38197UL,
      FI_EN_BN_RB_ASCHAFFENBURG = 38198UL,
      FI_EN_BN_RB_BAD_GOEGGING = 38199UL,
      FI_EN_BN_RB_BAD_WINDSHEIM = 38200UL,
      FI_EN_BN_RB_CHAM_RODING_FURTH_IM_WALD = 38201UL,
      FI_EN_BN_RB_DEGGENDORF_PLATTLING = 38202UL,
      FI_EN_BN_RB_DONAU_ILLER = 38203UL,
      FI_EN_BN_RB_ESTENFELD_BERGTHEIM = 38204UL,
      FI_EN_BN_RB_FUESSEN_PFRONTEN_NESSELWANG = 38205UL,
      FI_EN_BN_RB_GRAEFENB_FORCHH_ESCH_HEROLDSB = 38206UL,
      FI_EN_BN_RB_GROSSOSTHEIM_OBERNBURG = 38207UL,
      FI_EN_BN_RB_HALLERTAU = 38208UL,
      FI_EN_BN_RB_HERSBRUCK = 38209UL,
      FI_EN_BN_RB_HOECHBERG = 38210UL,
      FI_EN_BN_RB_I_LKRS_PASSAU_NORD = 38211UL,
      FI_EN_BN_RB_KEMNATHER_LAND_STEINWALD = 38212UL,
      FI_EN_BN_RB_KITZINGER_LAND = 38213UL,
      FI_EN_BN_RB_KOCHER_JAGST = 38214UL,
      FI_EN_BN_RB_MECKLENBURGER_SEENPLATTE = 38215UL,
      FI_EN_BN_RB_MITTELRHEIN = 38216UL,
      FI_EN_BN_RB_MUENCHEN_NORD = 38217UL,
      FI_EN_BN_RB_NEUMARKT_I_D_OPF = 38218UL,
      FI_EN_BN_RB_NEUSTADT_VOHENSTRAUSS = 38219UL,
      FI_EN_BN_RB_OCHSENFURT = 38220UL,
      FI_EN_BN_RB_OESTLICHE_SUEDEIFEL = 38221UL,
      FI_EN_BN_RB_PFAFFENWINKEL = 38222UL,
      FI_EN_BN_RB_RAIN_AM_LECH = 38223UL,
      FI_EN_BN_RB_ROTH_SCHWABACH = 38224UL,
      FI_EN_BN_RB_STAUDEN = 38225UL,
      FI_EN_BN_RB_SULZBACH_ROSENBERG = 38226UL,
      FI_EN_BN_RB_VILSHOFENER_LAND = 38227UL,
      FI_EN_BN_RB_WEIDEN = 38228UL,
      FI_EN_BN_RB_WEILHEIM = 38229UL,
      FI_EN_BN_RB_WEISSENBURG_GUNZENHAUSEN = 38230UL,
      FI_EN_BN_RB_WERRATAL_LANDECK = 38231UL,
      FI_EN_BN_RHEINGAUER_VB = 38232UL,
      FI_EN_BN_ROLLERZ = 38233UL,
      FI_EN_BN_ROTTALER_RB = 38234UL,
      FI_EN_BN_ROTTALER_VOLKSBANK_RAIFFEISENBANK = 38235UL,
      FI_EN_BN_RULER = 38236UL,
      FI_EN_BN_RUESSELSHEIMER_VB = 38237UL,
      FI_EN_BN_RV_BANK_RHEIN_HAARDT = 38238UL,
      FI_EN_BN_RVB_EBERN = 38239UL,
      FI_EN_BN_RVB_ERLANGEN_HOECHSTADT = 38240UL,
      FI_EN_BN_RVB_KRONACH_LUDWIGSSTADT = 38241UL,
      FI_EN_BN_RVB_NEUBURG_DONAU = 38242UL,
      FI_EN_BN_SAMURAI_SAMS = 38243UL,
      FI_EN_BN_SCOTTS = 38244UL,
      FI_EN_BN_SCOTTS_FUEL_CENTER = 38245UL,
      FI_EN_BN_SCOTTS_PHARMACY = 38246UL,
      FI_EN_BN_SELECT_REGISTRY = 38247UL,
      FI_EN_BN_SMITHS = 38248UL,
      FI_EN_BN_SMITHS_FUEL_CENTER = 38249UL,
      FI_EN_BN_SMITHS_MARKETPLACE = 38250UL,
      FI_EN_BN_SMITHS_MARKETPLACE_FUEL_CENTER = 38251UL,
      FI_EN_BN_SMITHS_MARKETPLACE_PHARMACY = 38252UL,
      FI_EN_BN_SMITHS_PHARMACY = 38253UL,
      FI_EN_BN_SPAR_UND_KREDITBANK = 38254UL,
      FI_EN_BN_SPREEWALDBANK = 38255UL,
      FI_EN_BN_ST_LOUIS_BREAD_CO = 38256UL,
      FI_EN_BN_ST_WENDELER_VB = 38257UL,
      FI_EN_BN_STAYEASY = 38258UL,
      FI_EN_BN_SURF_CITY_SQUEEZE = 38259UL,
      FI_EN_BN_TIMBERCITY = 38260UL,
      FI_EN_BN_TOMMY_BAHAMA = 38261UL,
      FI_EN_BN_TURKEY_HILL = 38262UL,
      FI_EN_BN_ULMER_VOLKSBANK = 38263UL,
      FI_EN_BN_URENDE = 38264UL,
      FI_EN_BN_VB_BACKNANG = 38265UL,
      FI_EN_BN_VB_BAD_DRIBURG_BRAKEL_STEINHEIM = 38266UL,
      FI_EN_BN_VB_BAD_SAULGAU = 38267UL,
      FI_EN_BN_VB_BADEN_BADEN_RASTATT = 38268UL,
      FI_EN_BN_VB_BAUTZEN = 38269UL,
      FI_EN_BN_VB_BITBURG = 38270UL,
      FI_EN_BN_VB_BRAMGAU_IM_OSNABRUECKER_LAND = 38271UL,
      FI_EN_BN_VB_BREISGAU_SUED = 38272UL,
      FI_EN_BN_VB_BUEREN_UND_SALZKOTTEN = 38273UL,
      FI_EN_BN_VB_CHEMNITZ = 38274UL,
      FI_EN_BN_VB_DARMSTADT_KREIS_BERGSTRASSE = 38275UL,
      FI_EN_BN_VB_DILL_VB_UND_RB = 38276UL,
      FI_EN_BN_VB_ERKELENZ_HUECKELHOVEN_WEGBERG = 38277UL,
      FI_EN_BN_VB_ETTLINGEN = 38278UL,
      FI_EN_BN_VB_FREIBURG = 38279UL,
      FI_EN_BN_VB_GLAN_MUENCHWEILER = 38280UL,
      FI_EN_BN_VB_GRONAU_AHAUS = 38281UL,
      FI_EN_BN_VB_HERRENBERG_ROTTENBURG = 38282UL,
      FI_EN_BN_VB_HEUCHELHEIM = 38283UL,
      FI_EN_BN_VB_HOHENLOHE = 38284UL,
      FI_EN_BN_VB_KAISERSLAUTERN_NORDWESTPFALZ = 38285UL,
      FI_EN_BN_VB_KIRNAU = 38286UL,
      FI_EN_BN_VB_KRAICHGAU = 38287UL,
      FI_EN_BN_VB_LAUTERBACH_SCHLITZ = 38288UL,
      FI_EN_BN_VB_LAUTERECKEN = 38289UL,
      FI_EN_BN_VB_LUDWIGSBURG = 38290UL,
      FI_EN_BN_VB_MAGDEBURG = 38291UL,
      FI_EN_BN_VB_MAIN_TAUNUS = 38292UL,
      FI_EN_BN_VB_MESSKIRCH_RB = 38293UL,
      FI_EN_BN_VB_MITTLERES_ERZGEBIRGE = 38294UL,
      FI_EN_BN_VB_MOECKMUEHL_NEUENSTADT = 38295UL,
      FI_EN_BN_VB_NAGOLDTAL = 38296UL,
      FI_EN_BN_VB_NORDOBERPFALZ = 38297UL,
      FI_EN_BN_VB_NORDSCHWARZWALD = 38298UL,
      FI_EN_BN_VB_OSTERBURG_LUECHOW_DANNENBERG = 38299UL,
      FI_EN_BN_VB_OSTLIPPE = 38300UL,
      FI_EN_BN_VB_PFORZHEIM = 38301UL,
      FI_EN_BN_VB_RB_EICHSTAETT = 38302UL,
      FI_EN_BN_VB_REISTE_ESLOHE = 38303UL,
      FI_EN_BN_VB_RHEIN_LAHN = 38304UL,
      FI_EN_BN_VB_RIESA = 38305UL,
      FI_EN_BN_VB_RION_LEONBERG = 38306UL,
      FI_EN_BN_VB_ROTTWEIL = 38307UL,
      FI_EN_BN_VB_SAALETAL = 38308UL,
      FI_EN_BN_VB_SAARLOUIS = 38309UL,
      FI_EN_BN_VB_SAAR_WEST = 38310UL,
      FI_EN_BN_VB_SCHMALLENBERG = 38311UL,
      FI_EN_BN_VB_SCHWAEBISCH_GMUEND = 38312UL,
      FI_EN_BN_VB_SULMTAL = 38313UL,
      FI_EN_BN_VB_TUEBINGEN = 38314UL,
      FI_EN_BN_VB_UND_RB_EISENACH = 38315UL,
      FI_EN_BN_VB_UNTERE_SAAR = 38316UL,
      FI_EN_BN_VB_WILFERDINGEN_KELTERN = 38317UL,
      FI_EN_BN_VB_WORMS_WONNEGAU = 38318UL,
      FI_EN_BN_VB_RB_DEGGINGEN = 38319UL,
      FI_EN_BN_VB_RB_DINGOLFING = 38320UL,
      FI_EN_BN_VB_RB_MEISSEN_GROSSENHAIN = 38321UL,
      FI_EN_BN_VB_RB_RIEDLINGEN = 38322UL,
      FI_EN_BN_VER_VB_REGIONALVERBAND_SAARBRUECKEN = 38323UL,
      FI_EN_BN_VEREINIGTE_RB_BURGSTAEDT = 38324UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK = 38325UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK_LIMBURG = 38326UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK_MAINGAU = 38327UL,
      FI_EN_BN_VEREINIGTE_VOLKSBANK_RAIFFEISENBANK = 38328UL,
      FI_EN_BN_VOLKSBANK_ACHERN = 38329UL,
      FI_EN_BN_VOLKSBANK_ALLGAEU_WEST = 38330UL,
      FI_EN_BN_VOLKSBANK_ALZEY = 38331UL,
      FI_EN_BN_VOLKSBANK_AN_DER_NIERS = 38332UL,
      FI_EN_BN_VOLKSBANK_BAD_OEYNHAUSEN_HERFORD = 38333UL,
      FI_EN_BN_VOLKSBANK_BAD_SALZUFLEN = 38334UL,
      FI_EN_BN_VOLKSBANK_BALINGEN = 38335UL,
      FI_EN_BN_VOLKSBANK_BECKUM = 38336UL,
      FI_EN_BN_VOLKSBANK_BIGGE_LENNE = 38337UL,
      FI_EN_BN_VOLKSBANK_BOCHUM_WITTEN = 38338UL,
      FI_EN_BN_VOLKSBANK_BONN_RHEIN_SIEG = 38339UL,
      FI_EN_BN_VOLKSBANK_BOERDE_BERNBURG = 38340UL,
      FI_EN_BN_VOLKSBANK_BRACKENHEIM_GUEGLINGEN = 38341UL,
      FI_EN_BN_VOLKSBANK_BRAUNSCHWEIG_WOLFSBURG = 38342UL,
      FI_EN_BN_VOLKSBANK_BREISGAU_NORD = 38343UL,
      FI_EN_BN_VOLKSBANK_BREMEN_NORD = 38344UL,
      FI_EN_BN_VOLKSBANK_BREMERHAVEN_CUXLAND = 38345UL,
      FI_EN_BN_VOLKSBANK_BRENZTAL = 38346UL,
      FI_EN_BN_VOLKSBANK_BRILON = 38347UL,
      FI_EN_BN_VOLKSBANK_BRUCHSAL_BRETTEN = 38348UL,
      FI_EN_BN_VOLKSBANK_BRUHRAIN_KRAICH_HARDT = 38349UL,
      FI_EN_BN_VOLKSBANK_BUEHL = 38350UL,
      FI_EN_BN_VOLKSBANK_DESSAU_ANHALT = 38351UL,
      FI_EN_BN_VOLKSBANK_DILLINGEN = 38352UL,
      FI_EN_BN_VOLKSBANK_DONAU_NECKAR = 38353UL,
      FI_EN_BN_VOLKSBANK_DORNSTETTEN = 38354UL,
      FI_EN_BN_VOLKSBANK_DREIEICH = 38355UL,
      FI_EN_BN_VOLKSBANK_DREILAENDERECK = 38356UL,
      FI_EN_BN_VOLKSBANK_DUEREN = 38357UL,
      FI_EN_BN_VOLKSBANK_DUESSELDORF_NEUSS = 38358UL,
      FI_EN_BN_VOLKSBANK_EBINGEN = 38359UL,
      FI_EN_BN_VOLKSBANK_EICHSFELD_NORTHEIM = 38360UL,
      FI_EN_BN_VOLKSBANK_EIFEL_MITTE = 38361UL,
      FI_EN_BN_VOLKSBANK_EINBECK = 38362UL,
      FI_EN_BN_VOLKSBANK_ELMSHORN = 38363UL,
      FI_EN_BN_VOLKSBANK_ELSTERLAND = 38364UL,
      FI_EN_BN_VOLKSBANK_EMMERICH_REES = 38365UL,
      FI_EN_BN_VOLKSBANK_ERFT = 38366UL,
      FI_EN_BN_VOLKSBANK_ESSLINGEN = 38367UL,
      FI_EN_BN_VOLKSBANK_EUSKIRCHEN = 38368UL,
      FI_EN_BN_VOLKSBANK_EUTIN_RAIFFEISENBANK = 38369UL,
      FI_EN_BN_VOLKSBANK_FORCHHEIM = 38370UL,
      FI_EN_BN_VOLKSBANK_FRANKEN = 38371UL,
      FI_EN_BN_VOLKSBANK_GEEST = 38372UL,
      FI_EN_BN_VOLKSBANK_GMHUETTE_HAGEN_BISSENDORF = 38373UL,
      FI_EN_BN_VOLKSBANK_GOETTINGEN = 38374UL,
      FI_EN_BN_VOLKSBANK_GRAFSCHAFT_HOYA = 38375UL,
      FI_EN_BN_VOLKSBANK_GUETERSLOH = 38376UL,
      FI_EN_BN_VOLKSBANK_HALLE_SAALE_ = 38377UL,
      FI_EN_BN_VOLKSBANK_HAMELN_STADTHAGEN = 38378UL,
      FI_EN_BN_VOLKSBANK_HAMM = 38379UL,
      FI_EN_BN_VOLKSBANK_HEGAU = 38380UL,
      FI_EN_BN_VOLKSBANK_HELLWEG = 38381UL,
      FI_EN_BN_VOLKSBANK_HELMSTEDT = 38382UL,
      FI_EN_BN_VOLKSBANK_HILDESHEIM = 38383UL,
      FI_EN_BN_VOLKSBANK_HILDESHEIMER_BOERDE = 38384UL,
      FI_EN_BN_VOLKSBANK_HOCHRHEIN = 38385UL,
      FI_EN_BN_VOLKSBANK_HORB_FREUDENSTADT = 38386UL,
      FI_EN_BN_VOLKSBANK_HUNSRUECK_NAHE = 38387UL,
      FI_EN_BN_VOLKSBANK_IM_HARZ = 38388UL,
      FI_EN_BN_VOLKSBANK_IM_MAERKISCHEN_KREIS = 38389UL,
      FI_EN_BN_VOLKSBANK_IN_SCHAUMBURG = 38390UL,
      FI_EN_BN_VOLKSBANK_JEVER = 38391UL,
      FI_EN_BN_VOLKSBANK_KINZIGTAL = 38392UL,
      FI_EN_BN_VOLKSBANK_KIRCHHEIM_NUERTINGEN = 38393UL,
      FI_EN_BN_VOLKSBANK_KLEVERLAND = 38394UL,
      FI_EN_BN_VOLKSBANK_KOBLENZ_MITTELRHEIN = 38395UL,
      FI_EN_BN_VOLKSBANK_KONSTANZ = 38396UL,
      FI_EN_BN_VOLKSBANK_KREFELD = 38397UL,
      FI_EN_BN_VOLKSBANK_KUR_UND_RHEINPFALZ = 38398UL,
      FI_EN_BN_VOLKSBANK_LAHR = 38399UL,
      FI_EN_BN_VOLKSBANK_LAUPHEIM = 38400UL,
      FI_EN_BN_VOLKSBANK_LEIPZIG = 38401UL,
      FI_EN_BN_VOLKSBANK_LINGEN = 38402UL,
      FI_EN_BN_VOLKSBANK_LOEBAU_ZITTAU = 38403UL,
      FI_EN_BN_VOLKSBANK_LUEBBECKER_LAND = 38404UL,
      FI_EN_BN_VOLKSBANK_LUENEBURGER_HEIDE = 38405UL,
      FI_EN_BN_VOLKSBANK_MAIN_TAUBER = 38406UL,
      FI_EN_BN_VOLKSBANK_MARL_RECKLINGHAUSEN = 38407UL,
      FI_EN_BN_VOLKSBANK_METZINGEN_BAD_URACH = 38408UL,
      FI_EN_BN_VOLKSBANK_MINDEN_HILLE_PORTA = 38409UL,
      FI_EN_BN_VOLKSBANK_MITTELHESSEN = 38410UL,
      FI_EN_BN_VOLKSBANK_MOENCHENGLADBACH = 38411UL,
      FI_EN_BN_VOLKSBANK_MOSBACH = 38412UL,
      FI_EN_BN_VOLKSBANK_MUENSINGEN = 38413UL,
      FI_EN_BN_VOLKSBANK_MUENSTER = 38414UL,
      FI_EN_BN_VOLKSBANK_NECKARTAL = 38415UL,
      FI_EN_BN_VOLKSBANK_NEUNKIRCHEN = 38416UL,
      FI_EN_BN_VOLKSBANK_NIEDERRHEIN = 38417UL,
      FI_EN_BN_VOLKSBANK_NORDHARZ = 38418UL,
      FI_EN_BN_VOLKSBANK_NORDHEIDE = 38419UL,
      FI_EN_BN_VOLKSBANK_OBERBERG = 38420UL,
      FI_EN_BN_VOLKSBANK_ODENWALD = 38421UL,
      FI_EN_BN_VOLKSBANK_OFFENBURG = 38422UL,
      FI_EN_BN_VOLKSBANK_OSNABRUECK = 38423UL,
      FI_EN_BN_VOLKSBANK_PEINE = 38424UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_DACHAU = 38425UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_ITZEHOE = 38426UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_WUERZBURG = 38427UL,
      FI_EN_BN_VOLKSBANK_REMSCHEID_SOLINGEN = 38428UL,
      FI_EN_BN_VOLKSBANK_REUTLINGEN = 38429UL,
      FI_EN_BN_VOLKSBANK_RHEINAHREIFEL = 38430UL,
      FI_EN_BN_VOLKSBANK_RHEIN_LIPPE = 38431UL,
      FI_EN_BN_VOLKSBANK_RHEIN_NAHE_HUNSRUECK = 38432UL,
      FI_EN_BN_VOLKSBANK_RHEIN_RUHR = 38433UL,
      FI_EN_BN_VOLKSBANK_RHEIN_WEHRA = 38434UL,
      FI_EN_BN_VOLKSBANK_RHEIN_WUPPER = 38435UL,
      FI_EN_BN_VOLKSBANK_RUHR_MITTE = 38436UL,
      FI_EN_BN_VOLKSBANK_SAARPFALZ = 38437UL,
      FI_EN_BN_VOLKSBANK_SAUERLAND = 38438UL,
      FI_EN_BN_VOLKSBANK_SCHWARZWALD_NECKAR = 38439UL,
      FI_EN_BN_VOLKSBANK_SOLLING = 38440UL,
      FI_EN_BN_VOLKSBANK_STORMARN = 38441UL,
      FI_EN_BN_VOLKSBANK_SUED_EMSLAND = 38442UL,
      FI_EN_BN_VOLKSBANK_SUEDHEIDE = 38443UL,
      FI_EN_BN_VOLKSBANK_SULINGEN = 38444UL,
      FI_EN_BN_VOLKSBANK_TECKLENBURGER_LAND = 38445UL,
      FI_EN_BN_VOLKSBANK_TRIER = 38446UL,
      FI_EN_BN_VOLKSBANK_UELZEN_SALZWEDEL = 38447UL,
      FI_EN_BN_VOLKSBANK_UNNA = 38448UL,
      FI_EN_BN_VOLKSBANK_VERDEN = 38449UL,
      FI_EN_BN_VOLKSBANK_VOGTLAND = 38450UL,
      FI_EN_BN_VOLKSBANK_WARBURGER_LAND = 38451UL,
      FI_EN_BN_VOLKSBANK_WENDEN_DROLSHAGEN = 38452UL,
      FI_EN_BN_VOLKSBANK_WESERBERGLAND = 38453UL,
      FI_EN_BN_VOLKSBANK_WIESLOCH = 38454UL,
      FI_EN_BN_VOLKSBANK_WITTINGEN_KLOETZE = 38455UL,
      FI_EN_BN_VOLKSBANK_WOLFENBUETTEL_SALZGITTER = 38456UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_AMBERG = 38457UL,
      FI_EN_BN_VOLKSBANK_RAIFFEISENBANK_DOEBELN = 38458UL,
      FI_EN_BN_VOLKS_UND_RAIFFEISENBANK_PRIGNITZ = 38459UL,
      FI_EN_BN_VOLKS_UND_RAIFFEISENBANK_WISMAR = 38460UL,
      FI_EN_BN_VR_BANK_BAMBERG = 38461UL,
      FI_EN_BN_VR_BANK_BIEDENKOPF_GLADENBACH = 38462UL,
      FI_EN_BN_VR_BANK_DINKELSBUEHL = 38463UL,
      FI_EN_BN_VR_BANK_FLENSBURG_SCHLESWIG = 38464UL,
      FI_EN_BN_VR_BANK_HESSENLAND = 38465UL,
      FI_EN_BN_VR_BANK_IM_ENZKREIS = 38466UL,
      FI_EN_BN_VR_BANK_KAUFBEUREN_OSTALLGAEU = 38467UL,
      FI_EN_BN_VR_BANK_KITZINGEN = 38468UL,
      FI_EN_BN_VR_BANK_LAUSITZ = 38469UL,
      FI_EN_BN_VR_BANK_MAIN_KINZIG_BUEDINGEN = 38470UL,
      FI_EN_BN_VR_BANK_MITTELHAARDT = 38471UL,
      FI_EN_BN_VR_BANK_MUENCHEN_LAND = 38472UL,
      FI_EN_BN_VR_BANK_NIEBUELL = 38473UL,
      FI_EN_BN_VR_BANK_NUERNBERG = 38474UL,
      FI_EN_BN_VR_BANK_OSTHOLSTEIN_NORD_PLOEN = 38475UL,
      FI_EN_BN_VR_BANK_PINNEBERG = 38476UL,
      FI_EN_BN_VR_BANK_RHEIN_MOSEL = 38477UL,
      FI_EN_BN_VR_BANK_ROSENHEIM_CHIEMSEE = 38478UL,
      FI_EN_BN_VR_BANK_SAARPFALZ = 38479UL,
      FI_EN_BN_VR_BANK_SCHWAEBISCH_HALL_CRAILSHEIM = 38480UL,
      FI_EN_BN_VR_BANK_SUEDLICHE_WEINSTRASSE = 38481UL,
      FI_EN_BN_VR_BANK_SUEDPFALZ = 38482UL,
      FI_EN_BN_VR_BANK_SUEDTHUERINGEN = 38483UL,
      FI_EN_BN_VR_BANK_SUEDWESTPFALZ = 38484UL,
      FI_EN_BN_VR_BANK_UNTERTAUNUS = 38485UL,
      FI_EN_BN_VR_BANK_WESTTHUERINGEN = 38486UL,
      FI_EN_BN_VR_MEINE_RAIFFEISENBANK = 38487UL,
      FI_EN_BN_VR_BANK_AALEN = 38488UL,
      FI_EN_BN_VR_BANK_ALB = 38489UL,
      FI_EN_BN_VR_BANK_ALTENBURGER_LAND = 38490UL,
      FI_EN_BN_VR_BANK_ASPERG_MARKGROENINGEN = 38491UL,
      FI_EN_BN_VR_BANK_BGLADBACH_OVERATH_ROESRATH = 38492UL,
      FI_EN_BN_VR_BANK_BAD_HERSFELD_ROTENBURG = 38493UL,
      FI_EN_BN_VR_BANK_BAD_KISSINGEN_BAD_BRUECKENAU = 38494UL,
      FI_EN_BN_VR_BANK_BAD_SALZUNGEN_SCHMALKALDEN = 38495UL,
      FI_EN_BN_VR_BANK_BAYREUTH = 38496UL,
      FI_EN_BN_VR_BANK_BONN = 38497UL,
      FI_EN_BN_VR_BANK_COBURG = 38498UL,
      FI_EN_BN_VR_BANK_ELLWANGEN = 38499UL,
      FI_EN_BN_VR_BANK_FICHTELGEBIRGE = 38500UL,
      FI_EN_BN_VR_BANK_FUERSTENFELDBRUCK = 38501UL,
      FI_EN_BN_VR_BANK_FUERSTENWALDE_SEELOW_WRIEZEN = 38502UL,
      FI_EN_BN_VR_BANK_GEROLZHOFEN = 38503UL,
      FI_EN_BN_VR_BANK_HUNSRUECK_MOSEL = 38504UL,
      FI_EN_BN_VR_BANK_IM_KREIS_RENDSBURG = 38505UL,
      FI_EN_BN_VR_BANK_IN_MITTELBADEN = 38506UL,
      FI_EN_BN_VR_BANK_LANDAU = 38507UL,
      FI_EN_BN_VR_BANK_LECH_ZUSAM = 38508UL,
      FI_EN_BN_VR_BANK_LKR_GARMISCH_PARTENKIRCHEN = 38509UL,
      FI_EN_BN_VR_BANK_MANGFALLTAL_ROSENHEIM = 38510UL,
      FI_EN_BN_VR_BANK_MEMMINGEN = 38511UL,
      FI_EN_BN_VR_BANK_NEU_ULM_WEISSENHORN = 38512UL,
      FI_EN_BN_VR_BANK_NEUWIED_LINZ = 38513UL,
      FI_EN_BN_VR_BANK_NIEDERSCHLESIEN = 38514UL,
      FI_EN_BN_VR_BANK_NORDEIFEL = 38515UL,
      FI_EN_BN_VR_BANK_NORDRHOEN = 38516UL,
      FI_EN_BN_VR_BANK_OBERBAYERN_SUEDOST = 38517UL,
      FI_EN_BN_VR_BANK_PASSAU = 38518UL,
      FI_EN_BN_VR_BANK_RAIFFEISENBANK_BAYERN_MITTE = 38519UL,
      FI_EN_BN_VR_BANK_RHEIN_ERFT = 38520UL,
      FI_EN_BN_VR_BANK_RHEIN_SIEG = 38521UL,
      FI_EN_BN_VR_BANK_RHOEN_GRABFELD = 38522UL,
      FI_EN_BN_VR_BANK_ROTHENBURG_O_D_TBR = 38523UL,
      FI_EN_BN_VR_BANK_ROTTAL_INN = 38524UL,
      FI_EN_BN_VR_BANK_STROMBERG_NECKAR = 38525UL,
      FI_EN_BN_VR_BANK_TAUFKIRCHEN_DORFEN = 38526UL,
      FI_EN_BN_VR_BANK_UCKERMARK_RANDOW = 38527UL,
      FI_EN_BN_VR_BANK_UFFENHEIM_NEUSTADT = 38528UL,
      FI_EN_BN_VR_BANK_VILSBIBURG = 38529UL,
      FI_EN_BN_VR_BANK_WERRA_MEISSNER = 38530UL,
      FI_EN_BN_VR_BANK_WESTMUENSTERLAND = 38531UL,
      FI_EN_BN_VR_BANK_WESTPFALZ = 38532UL,
      FI_EN_BN_V_UND_RB_SAALE_UNSTRUT = 38533UL,
      FI_EN_BN_WALDECKER_BANK = 38534UL,
      FI_EN_BN_WESTERWALD_BANK = 38535UL,
      FI_EN_BN_WILSONS = 38536UL,
      FI_EN_BN_YOGEN_FRUZ = 38537UL,
      FI_EN_AZA = 40001UL,
      FI_EN_CC_AMERICANEXPRESS = 60000UL,
      FI_EN_CC_BARCLAYCARD = 60001UL,
      FI_EN_CC_CARTEBLEU = 60002UL,
      FI_EN_CC_ACCESS = 60003UL,
      FI_EN_CC_CONNECTCARD = 60004UL,
      FI_EN_CC_DELTACARD = 60005UL,
      FI_EN_CC_SWITCHCARD = 60006UL,
      FI_EN_CC_TARJETA6000 = 60007UL,
      FI_EN_CC_CARTEBLANCHE = 60008UL,
      FI_EN_CC_DINERSCLUBCARD = 60009UL,
      FI_EN_CC_MASTERCARD = 60010UL,
      FI_EN_CC_VISACARD = 60011UL,
      FI_EN_CC_JAPANESECREDITBANK = 60012UL,
      FI_EN_CC_ELECTRONICCASH = 60013UL,
      FI_EN_CC_CARTASI = 60014UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e16_SelectionCriterionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e16_SelectionCriterionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_LocationDescriptionDataType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_LocationDescriptionDataType();

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_TSTRING = 1UL,
      FI_EN_T_STRINGID = 3UL,
      FI_EN_T_POSITIONHEADINGSPEED = 16UL,
      FI_EN_T_POSITIONWGS84 = 18UL,
      FI_EN_T_NAVLOCATIONBINCONTAINER = 21UL,
      FI_EN_T_STRINGPOSITION = 23UL,
      FI_EN_T_FLISTRING = 25UL,
      FI_EN_T_LISTOFPOSITIONS = 26UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_LocationDescriptionDataType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_LocationDescriptionDataType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_LocationDescriptorStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_LocationDescriptorStatus();

   enum {
      FI_C_U8_BIT_ISPREFIX = 0x1UL,
      FI_C_U8_BIT_ISINEXACT = 0x2UL
   };
   tBool bIsPrefix() const {return (u8Value & FI_C_U8_BIT_ISPREFIX) != 0; }
   tVoid vSetIsPrefix(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISPREFIX):(u8Value & ~FI_C_U8_BIT_ISPREFIX); }
   tBool bIsInexact() const {return (u8Value & FI_C_U8_BIT_ISINEXACT) != 0; }
   tVoid vSetIsInexact(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ISINEXACT):(u8Value & ~FI_C_U8_BIT_ISINEXACT); }
   struct rBitValues {
      tBool IsPrefix:1;
      tBool IsInexact:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_LocationDescriptorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_LocationDescriptorStatus& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_LocationDescriptor : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_LocationDescriptor();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_LocationDescriptor& operator=(const sds2hmi_fi_tcl_LocationDescriptor& coRef);
   sds2hmi_fi_tcl_LocationDescriptor(const sds2hmi_fi_tcl_LocationDescriptor& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_SelectionCriterionType SelectionCriterion;
   sds2hmi_fi_tcl_e8_LocationDescriptionDataType DataType;
   fi_tclTypeBase* poDataData;
   sds2hmi_fi_tcl_b8_LocationDescriptorStatus Status;
   virtual ~sds2hmi_fi_tcl_LocationDescriptor();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_LocationDescriptor& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_LocationDescription : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_LocationDescription();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_LocationDescription& operator=(const sds2hmi_fi_tcl_LocationDescription& coRef);
   sds2hmi_fi_tcl_LocationDescription(const sds2hmi_fi_tcl_LocationDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_LocationDescriptor, std::allocator<sds2hmi_fi_tcl_LocationDescriptor> > Descriptors;
   virtual ~sds2hmi_fi_tcl_LocationDescription();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_LocationDescription& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringPosition : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringPosition();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringPosition& operator=(const sds2hmi_fi_tcl_StringPosition& coRef);
   sds2hmi_fi_tcl_StringPosition(const sds2hmi_fi_tcl_StringPosition& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString String;
   sds2hmi_fi_tcl_PositionWGS84 Position;
   virtual ~sds2hmi_fi_tcl_StringPosition();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringPosition& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringID : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringID& operator=(const sds2hmi_fi_tcl_StringID& coRef);
   sds2hmi_fi_tcl_StringID(const sds2hmi_fi_tcl_StringID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString String;
   tU32 ID;
   virtual ~sds2hmi_fi_tcl_StringID();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_FLIString : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_FLIString();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_FLIString& operator=(const sds2hmi_fi_tcl_FLIString& coRef);
   sds2hmi_fi_tcl_FLIString(const sds2hmi_fi_tcl_FLIString& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString String;
   virtual ~sds2hmi_fi_tcl_FLIString();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_FLIString& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_PositionStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_PositionStatus();

   enum {
      FI_C_U8_BIT_EXIT = 0x1UL
   };
   tBool bExit() const {return (u8Value & FI_C_U8_BIT_EXIT) != 0; }
   tVoid vSetExit(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXIT):(u8Value & ~FI_C_U8_BIT_EXIT); }
   struct rBitValues {
      tBool Exit:1;
      tBool dummy1:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_PositionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_PositionStatus& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_ListOfPositions : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_ListOfPositions();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_ListOfPositions& operator=(const sds2hmi_fi_tcl_ListOfPositions& coRef);
   sds2hmi_fi_tcl_ListOfPositions(const sds2hmi_fi_tcl_ListOfPositions& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_PositionWGS84, std::allocator<sds2hmi_fi_tcl_PositionWGS84> > Positions;
   std::vector<sds2hmi_fi_tcl_b8_PositionStatus, std::allocator<sds2hmi_fi_tcl_b8_PositionStatus> > PositionStati;
   tU32 ID;
   sds2hmi_fi_tcl_PositionWGS84 CurrentPosition;
   virtual ~sds2hmi_fi_tcl_ListOfPositions();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_ListOfPositions& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_FilterAttributeType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_FilterAttributeType();

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_ATTRIBUTEGROUP = 1UL,
      FI_EN_SELECTABLEGROUPATTRIBUTE = 2UL,
      FI_EN_SELECTABLESINGLEATTRIBUTE = 3UL,
      FI_EN_SUBCATEGORYGROUP = 4UL,
      FI_EN_MENUITEM = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_FilterAttributeType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_FilterAttributeType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_FilterAttribute : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_FilterAttribute();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_FilterAttribute& operator=(const sds2hmi_fi_tcl_FilterAttribute& coRef);
   sds2hmi_fi_tcl_FilterAttribute(const sds2hmi_fi_tcl_FilterAttribute& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_FilterAttributeType Type;
   tU16 Code;
   sds2hmi_fi_tclString Name;
   virtual ~sds2hmi_fi_tcl_FilterAttribute();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_FilterAttribute& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e16_MenuItemType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e16_MenuItemType();

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_ALL = 1UL,
      FI_EN_FILTERSETTINGS = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e16_MenuItemType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e16_MenuItemType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_LocationValueListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_LocationValueListType();

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_STRINGLIST = 1UL,
      FI_EN_T_STRINGDESCRIPTIONLIST = 2UL,
      FI_EN_T_STRINGIDLIST = 3UL,
      FI_EN_T_POSITIONWGS84LIST = 18UL,
      FI_EN_T_STRINGPOSITIONLIST = 23UL,
      FI_EN_T_STRINGPOSITIONDESCRIPTIONLIST = 24UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_LocationValueListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_LocationValueListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_ListResultOptions : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_ListResultOptions();

   enum {
      FI_C_U8_BIT_PREVPAGE = 0x1UL,
      FI_C_U8_BIT_NEXTPAGE = 0x2UL,
      FI_C_U8_BIT_DATABASEINCOMPLETE = 0x4UL
   };
   tBool bPrevPage() const {return (u8Value & FI_C_U8_BIT_PREVPAGE) != 0; }
   tVoid vSetPrevPage(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_PREVPAGE):(u8Value & ~FI_C_U8_BIT_PREVPAGE); }
   tBool bNextPage() const {return (u8Value & FI_C_U8_BIT_NEXTPAGE) != 0; }
   tVoid vSetNextPage(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NEXTPAGE):(u8Value & ~FI_C_U8_BIT_NEXTPAGE); }
   tBool bDatabaseIncomplete() const {return (u8Value & FI_C_U8_BIT_DATABASEINCOMPLETE) != 0; }
   tVoid vSetDatabaseIncomplete(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_DATABASEINCOMPLETE):(u8Value & ~FI_C_U8_BIT_DATABASEINCOMPLETE); }
   struct rBitValues {
      tBool PrevPage:1;
      tBool NextPage:1;
      tBool DatabaseIncomplete:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_ListResultOptions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_ListResultOptions& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_ListGetOptions : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_ListGetOptions();

   enum {
      FI_C_U8_BIT_MATCHFORREDUCTION = 0x1UL,
      FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS = 0x2UL,
      FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES = 0x4UL,
      FI_C_U8_BIT_CASECORRECTSPELLING = 0x8UL,
      FI_C_U8_BIT_LOWERCASE = 0x10UL,
      FI_C_U8_BIT_ASINDATA = 0x20UL,
      FI_C_U8_BIT_INCLUDEALLEXONYMS = 0x40UL,
      FI_C_U8_BIT_MAPGROUPINATTRIBUTES = 0x80UL
   };
   tBool bMatchForReduction() const {return (u8Value & FI_C_U8_BIT_MATCHFORREDUCTION) != 0; }
   tVoid vSetMatchForReduction(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MATCHFORREDUCTION):(u8Value & ~FI_C_U8_BIT_MATCHFORREDUCTION); }
   tBool bIncludeAmbiguousElements() const {return (u8Value & FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS) != 0; }
   tVoid vSetIncludeAmbiguousElements(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS):(u8Value & ~FI_C_U8_BIT_INCLUDEAMBIGUOUSELEMENTS); }
   tBool bExcludeAlternativeNames() const {return (u8Value & FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES) != 0; }
   tVoid vSetExcludeAlternativeNames(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES):(u8Value & ~FI_C_U8_BIT_EXCLUDEALTERNATIVENAMES); }
   tBool bCaseCorrectSpelling() const {return (u8Value & FI_C_U8_BIT_CASECORRECTSPELLING) != 0; }
   tVoid vSetCaseCorrectSpelling(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_CASECORRECTSPELLING):(u8Value & ~FI_C_U8_BIT_CASECORRECTSPELLING); }
   tBool bLowerCase() const {return (u8Value & FI_C_U8_BIT_LOWERCASE) != 0; }
   tVoid vSetLowerCase(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LOWERCASE):(u8Value & ~FI_C_U8_BIT_LOWERCASE); }
   tBool bAsInData() const {return (u8Value & FI_C_U8_BIT_ASINDATA) != 0; }
   tVoid vSetAsInData(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ASINDATA):(u8Value & ~FI_C_U8_BIT_ASINDATA); }
   tBool bIncludeAllExonyms() const {return (u8Value & FI_C_U8_BIT_INCLUDEALLEXONYMS) != 0; }
   tVoid vSetIncludeAllExonyms(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INCLUDEALLEXONYMS):(u8Value & ~FI_C_U8_BIT_INCLUDEALLEXONYMS); }
   tBool bMapGroupInAttributes() const {return (u8Value & FI_C_U8_BIT_MAPGROUPINATTRIBUTES) != 0; }
   tVoid vSetMapGroupInAttributes(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_MAPGROUPINATTRIBUTES):(u8Value & ~FI_C_U8_BIT_MAPGROUPINATTRIBUTES); }
   struct rBitValues {
      tBool MatchForReduction:1;
      tBool IncludeAmbiguousElements:1;
      tBool ExcludeAlternativeNames:1;
      tBool CaseCorrectSpelling:1;
      tBool LowerCase:1;
      tBool AsInData:1;
      tBool IncludeAllExonyms:1;
      tBool MapGroupInAttributes:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_ListGetOptions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_ListGetOptions& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_LocationValueListUnion : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_LocationValueListUnion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_LocationValueListUnion& operator=(const sds2hmi_fi_tcl_LocationValueListUnion& coRef);
   sds2hmi_fi_tcl_LocationValueListUnion(const sds2hmi_fi_tcl_LocationValueListUnion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_LocationValueListType ValueListType;
   fi_tclTypeBase* poValueListData;
   virtual ~sds2hmi_fi_tcl_LocationValueListUnion();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_LocationValueListUnion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b16_ElementProperties : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b16_ElementProperties();

   enum {
      FI_C_U16_BIT_VALIDDESTINATION = 0x1UL,
      FI_C_U16_BIT_VALIDPOSITION = 0x2UL,
      FI_C_U16_BIT_VALIDFORMAPDISPLAY = 0x4UL,
      FI_C_U16_BIT_DETAILAVAILABLE = 0x8UL,
      FI_C_U16_BIT_ALTERNATIVENAME = 0x10UL,
      FI_C_U16_BIT_AMBIGUOUS = 0x20UL,
      FI_C_U16_BIT_CONTAINESXMLDESCRIPTION = 0x40UL,
      FI_C_U16_BIT_ISTRAVELGUIDEDATASET = 0x80UL,
      FI_C_U16_BIT_ISBASENAME = 0x100UL,
      FI_C_U16_BIT_ISUSERPOIDATASET = 0x200UL
   };
   tBool bValidDestination() const {return (u16Value & FI_C_U16_BIT_VALIDDESTINATION) != 0; }
   tVoid vSetValidDestination(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_VALIDDESTINATION):(u16Value & ~FI_C_U16_BIT_VALIDDESTINATION); }
   tBool bValidPosition() const {return (u16Value & FI_C_U16_BIT_VALIDPOSITION) != 0; }
   tVoid vSetValidPosition(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_VALIDPOSITION):(u16Value & ~FI_C_U16_BIT_VALIDPOSITION); }
   tBool bValidForMapDisplay() const {return (u16Value & FI_C_U16_BIT_VALIDFORMAPDISPLAY) != 0; }
   tVoid vSetValidForMapDisplay(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_VALIDFORMAPDISPLAY):(u16Value & ~FI_C_U16_BIT_VALIDFORMAPDISPLAY); }
   tBool bDetailAvailable() const {return (u16Value & FI_C_U16_BIT_DETAILAVAILABLE) != 0; }
   tVoid vSetDetailAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DETAILAVAILABLE):(u16Value & ~FI_C_U16_BIT_DETAILAVAILABLE); }
   tBool bAlternativeName() const {return (u16Value & FI_C_U16_BIT_ALTERNATIVENAME) != 0; }
   tVoid vSetAlternativeName(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ALTERNATIVENAME):(u16Value & ~FI_C_U16_BIT_ALTERNATIVENAME); }
   tBool bAmbiguous() const {return (u16Value & FI_C_U16_BIT_AMBIGUOUS) != 0; }
   tVoid vSetAmbiguous(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_AMBIGUOUS):(u16Value & ~FI_C_U16_BIT_AMBIGUOUS); }
   tBool bContainesXMLDescription() const {return (u16Value & FI_C_U16_BIT_CONTAINESXMLDESCRIPTION) != 0; }
   tVoid vSetContainesXMLDescription(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_CONTAINESXMLDESCRIPTION):(u16Value & ~FI_C_U16_BIT_CONTAINESXMLDESCRIPTION); }
   tBool bIsTravelGuideDataSet() const {return (u16Value & FI_C_U16_BIT_ISTRAVELGUIDEDATASET) != 0; }
   tVoid vSetIsTravelGuideDataSet(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISTRAVELGUIDEDATASET):(u16Value & ~FI_C_U16_BIT_ISTRAVELGUIDEDATASET); }
   tBool bIsBaseName() const {return (u16Value & FI_C_U16_BIT_ISBASENAME) != 0; }
   tVoid vSetIsBaseName(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISBASENAME):(u16Value & ~FI_C_U16_BIT_ISBASENAME); }
   tBool bIsUserPOIDataSet() const {return (u16Value & FI_C_U16_BIT_ISUSERPOIDATASET) != 0; }
   tVoid vSetIsUserPOIDataSet(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_ISUSERPOIDATASET):(u16Value & ~FI_C_U16_BIT_ISUSERPOIDATASET); }
   struct rBitValues {
      tBool ValidDestination:1;
      tBool ValidPosition:1;
      tBool ValidForMapDisplay:1;
      tBool DetailAvailable:1;
      tBool AlternativeName:1;
      tBool Ambiguous:1;
      tBool ContainesXMLDescription:1;
      tBool IsTravelGuideDataSet:1;
      tBool IsBaseName:1;
      tBool IsUserPOIDataSet:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b16_ElementProperties();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b16_ElementProperties& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringElement : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringElement& operator=(const sds2hmi_fi_tcl_StringElement& coRef);
   sds2hmi_fi_tcl_StringElement(const sds2hmi_fi_tcl_StringElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_b16_ElementProperties Properties;
   sds2hmi_fi_tclString String;
   virtual ~sds2hmi_fi_tcl_StringElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringList : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringList& operator=(const sds2hmi_fi_tcl_StringList& coRef);
   sds2hmi_fi_tcl_StringList(const sds2hmi_fi_tcl_StringList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StringElement, std::allocator<sds2hmi_fi_tcl_StringElement> > StringList;
   virtual ~sds2hmi_fi_tcl_StringList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringDescriptionElement : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringDescriptionElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringDescriptionElement& operator=(const sds2hmi_fi_tcl_StringDescriptionElement& coRef);
   sds2hmi_fi_tcl_StringDescriptionElement(const sds2hmi_fi_tcl_StringDescriptionElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_b16_ElementProperties Properties;
   sds2hmi_fi_tclString ElementString;
   sds2hmi_fi_tclString DescriptionString;
   virtual ~sds2hmi_fi_tcl_StringDescriptionElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringDescriptionElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringDescriptionList : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringDescriptionList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringDescriptionList& operator=(const sds2hmi_fi_tcl_StringDescriptionList& coRef);
   sds2hmi_fi_tcl_StringDescriptionList(const sds2hmi_fi_tcl_StringDescriptionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StringDescriptionElement, std::allocator<sds2hmi_fi_tcl_StringDescriptionElement> > StringDescriptionList;
   virtual ~sds2hmi_fi_tcl_StringDescriptionList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringDescriptionList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringIDElement : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringIDElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringIDElement& operator=(const sds2hmi_fi_tcl_StringIDElement& coRef);
   sds2hmi_fi_tcl_StringIDElement(const sds2hmi_fi_tcl_StringIDElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_b16_ElementProperties Properties;
   sds2hmi_fi_tcl_StringID StringID;
   virtual ~sds2hmi_fi_tcl_StringIDElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringIDElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringIDList : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringIDList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringIDList& operator=(const sds2hmi_fi_tcl_StringIDList& coRef);
   sds2hmi_fi_tcl_StringIDList(const sds2hmi_fi_tcl_StringIDList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StringIDElement, std::allocator<sds2hmi_fi_tcl_StringIDElement> > StringIDList;
   virtual ~sds2hmi_fi_tcl_StringIDList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringIDList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_PositionWGS84Element : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_PositionWGS84Element();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_PositionWGS84Element& operator=(const sds2hmi_fi_tcl_PositionWGS84Element& coRef);
   sds2hmi_fi_tcl_PositionWGS84Element(const sds2hmi_fi_tcl_PositionWGS84Element& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_b16_ElementProperties Properties;
   sds2hmi_fi_tcl_PositionWGS84 PositionWGS84;
   virtual ~sds2hmi_fi_tcl_PositionWGS84Element();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_PositionWGS84Element& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_PositionWGS84List : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_PositionWGS84List();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_PositionWGS84List& operator=(const sds2hmi_fi_tcl_PositionWGS84List& coRef);
   sds2hmi_fi_tcl_PositionWGS84List(const sds2hmi_fi_tcl_PositionWGS84List& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_PositionWGS84Element, std::allocator<sds2hmi_fi_tcl_PositionWGS84Element> > PositionWGS84List;
   virtual ~sds2hmi_fi_tcl_PositionWGS84List();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_PositionWGS84List& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringPositionElement : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringPositionElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringPositionElement& operator=(const sds2hmi_fi_tcl_StringPositionElement& coRef);
   sds2hmi_fi_tcl_StringPositionElement(const sds2hmi_fi_tcl_StringPositionElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_b16_ElementProperties Properties;
   sds2hmi_fi_tcl_StringPosition StringPosition;
   virtual ~sds2hmi_fi_tcl_StringPositionElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringPositionElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringPositionList : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringPositionList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringPositionList& operator=(const sds2hmi_fi_tcl_StringPositionList& coRef);
   sds2hmi_fi_tcl_StringPositionList(const sds2hmi_fi_tcl_StringPositionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StringPositionElement, std::allocator<sds2hmi_fi_tcl_StringPositionElement> > StringPositionList;
   virtual ~sds2hmi_fi_tcl_StringPositionList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringPositionList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringPositionDescriptionElement : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringPositionDescriptionElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringPositionDescriptionElement& operator=(const sds2hmi_fi_tcl_StringPositionDescriptionElement& coRef);
   sds2hmi_fi_tcl_StringPositionDescriptionElement(const sds2hmi_fi_tcl_StringPositionDescriptionElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_b16_ElementProperties Properties;
   sds2hmi_fi_tcl_StringPosition ElementStringPosition;
   sds2hmi_fi_tclString DescriptionString;
   virtual ~sds2hmi_fi_tcl_StringPositionDescriptionElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringPositionDescriptionElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringPositionDescriptionList : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringPositionDescriptionList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringPositionDescriptionList& operator=(const sds2hmi_fi_tcl_StringPositionDescriptionList& coRef);
   sds2hmi_fi_tcl_StringPositionDescriptionList(const sds2hmi_fi_tcl_StringPositionDescriptionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StringPositionDescriptionElement, std::allocator<sds2hmi_fi_tcl_StringPositionDescriptionElement> > StringPositionDescriptionList;
   virtual ~sds2hmi_fi_tcl_StringPositionDescriptionList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringPositionDescriptionList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_CriterionStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_CriterionStatus();

   enum {
      FI_C_U8_BIT_AMBIGUITYRESOLVING = 0x1UL
   };
   tBool bAmbiguityResolving() const {return (u8Value & FI_C_U8_BIT_AMBIGUITYRESOLVING) != 0; }
   tVoid vSetAmbiguityResolving(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_AMBIGUITYRESOLVING):(u8Value & ~FI_C_U8_BIT_AMBIGUITYRESOLVING); }
   struct rBitValues {
      tBool AmbiguityResolving:1;
      tBool dummy1:1;
      tBool dummy2:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_CriterionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_CriterionStatus& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_ListSortOptions : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_ListSortOptions();

   enum {
      FI_C_U8_BIT_NONSORTED = 0x1UL,
      FI_C_U8_BIT_SORTBYALPHABETICALORDER = 0x2UL,
      FI_C_U8_BIT_SORTBYAIRDISTANCE = 0x4UL,
      FI_C_U8_BIT_SORTBYROUTEDISTANCE = 0x8UL,
      FI_C_U8_BIT_SORTBYSIMILARITY = 0x10UL
   };
   tBool bNonSorted() const {return (u8Value & FI_C_U8_BIT_NONSORTED) != 0; }
   tVoid vSetNonSorted(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NONSORTED):(u8Value & ~FI_C_U8_BIT_NONSORTED); }
   tBool bSortByAlphabeticalOrder() const {return (u8Value & FI_C_U8_BIT_SORTBYALPHABETICALORDER) != 0; }
   tVoid vSetSortByAlphabeticalOrder(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYALPHABETICALORDER):(u8Value & ~FI_C_U8_BIT_SORTBYALPHABETICALORDER); }
   tBool bSortByAirDistance() const {return (u8Value & FI_C_U8_BIT_SORTBYAIRDISTANCE) != 0; }
   tVoid vSetSortByAirDistance(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYAIRDISTANCE):(u8Value & ~FI_C_U8_BIT_SORTBYAIRDISTANCE); }
   tBool bSortByRouteDistance() const {return (u8Value & FI_C_U8_BIT_SORTBYROUTEDISTANCE) != 0; }
   tVoid vSetSortByRouteDistance(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYROUTEDISTANCE):(u8Value & ~FI_C_U8_BIT_SORTBYROUTEDISTANCE); }
   tBool bSortBySimilarity() const {return (u8Value & FI_C_U8_BIT_SORTBYSIMILARITY) != 0; }
   tVoid vSetSortBySimilarity(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SORTBYSIMILARITY):(u8Value & ~FI_C_U8_BIT_SORTBYSIMILARITY); }
   struct rBitValues {
      tBool NonSorted:1;
      tBool SortByAlphabeticalOrder:1;
      tBool SortByAirDistance:1;
      tBool SortByRouteDistance:1;
      tBool SortBySimilarity:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_ListSortOptions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_ListSortOptions& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SelectionCriterionDescription : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SelectionCriterionDescription();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SelectionCriterionDescription& operator=(const sds2hmi_fi_tcl_SelectionCriterionDescription& coRef);
   sds2hmi_fi_tcl_SelectionCriterionDescription(const sds2hmi_fi_tcl_SelectionCriterionDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_SelectionCriterionType SelectionCriterion;
   sds2hmi_fi_tclString Description;
   virtual ~sds2hmi_fi_tcl_SelectionCriterionDescription();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SelectionCriterionDescription& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_CriteriaGetOptions : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_CriteriaGetOptions();

   enum {
      FI_C_U8_BIT_NONSORTED = 0x1UL,
      FI_C_U8_BIT_INCLUDEEMPTY = 0x2UL,
      FI_C_U8_BIT_HIDEVIRTUALCATS = 0x4UL
   };
   tBool bNonSorted() const {return (u8Value & FI_C_U8_BIT_NONSORTED) != 0; }
   tVoid vSetNonSorted(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NONSORTED):(u8Value & ~FI_C_U8_BIT_NONSORTED); }
   tBool bIncludeEmpty() const {return (u8Value & FI_C_U8_BIT_INCLUDEEMPTY) != 0; }
   tVoid vSetIncludeEmpty(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_INCLUDEEMPTY):(u8Value & ~FI_C_U8_BIT_INCLUDEEMPTY); }
   tBool bHideVirtualCats() const {return (u8Value & FI_C_U8_BIT_HIDEVIRTUALCATS) != 0; }
   tVoid vSetHideVirtualCats(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_HIDEVIRTUALCATS):(u8Value & ~FI_C_U8_BIT_HIDEVIRTUALCATS); }
   struct rBitValues {
      tBool NonSorted:1;
      tBool IncludeEmpty:1;
      tBool HideVirtualCats:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_CriteriaGetOptions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_CriteriaGetOptions& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SelectableCriterion : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SelectableCriterion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SelectableCriterion& operator=(const sds2hmi_fi_tcl_SelectableCriterion& coRef);
   sds2hmi_fi_tcl_SelectableCriterion(const sds2hmi_fi_tcl_SelectableCriterion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_SelectionCriterionType SelectionCriterion;
   sds2hmi_fi_tcl_e8_LocationDescriptionDataType DataType;
   sds2hmi_fi_tcl_b8_ListSortOptions SortOption;
   tBool AttributesAvailable;
   sds2hmi_fi_tcl_b8_CriterionStatus Status;
   tU16 NumOfPOI;
   virtual ~sds2hmi_fi_tcl_SelectableCriterion();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SelectableCriterion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TransformMode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TransformMode();

   enum tenType {
      FI_EN_RESOLVENAME = 1UL,
      FI_EN_GETNAVINFO = 2UL,
      FI_EN_RESOLVENAMEANDGETNAVINFO = 3UL,
      FI_EN_TRANSFORMPATH = 4UL,
      FI_EN_MATCHASFARASPOSSIBLE = 5UL,
      FI_EN_GETEDITABLEADDRESSFORPOSITION = 6UL,
      FI_EN_GETADDRESSINFOFORPOSITION = 7UL,
      FI_EN_ASSIGNADDRESSPARTS = 8UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TransformMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TransformMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b16_PositionReliability : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b16_PositionReliability();

   enum {
      FI_C_U16_BIT_CALIBRATED = 0x1UL,
      FI_C_U16_BIT_MATCHEDTODIGITALMAP = 0x2UL,
      FI_C_U16_BIT_FULLYDIGITIZEDAREA = 0x4UL,
      FI_C_U16_BIT_INSIDEDIGITIZEDAREA = 0x8UL,
      FI_C_U16_BIT_DEADRECKONINGAVAILABLE = 0x10UL,
      FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE = 0x20UL,
      FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE = 0x40UL,
      FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE = 0x80UL,
      FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY = 0x100UL
   };
   tBool bCalibrated() const {return (u16Value & FI_C_U16_BIT_CALIBRATED) != 0; }
   tVoid vSetCalibrated(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_CALIBRATED):(u16Value & ~FI_C_U16_BIT_CALIBRATED); }
   tBool bMatchedToDigitalMap() const {return (u16Value & FI_C_U16_BIT_MATCHEDTODIGITALMAP) != 0; }
   tVoid vSetMatchedToDigitalMap(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MATCHEDTODIGITALMAP):(u16Value & ~FI_C_U16_BIT_MATCHEDTODIGITALMAP); }
   tBool bFullyDigitizedArea() const {return (u16Value & FI_C_U16_BIT_FULLYDIGITIZEDAREA) != 0; }
   tVoid vSetFullyDigitizedArea(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_FULLYDIGITIZEDAREA):(u16Value & ~FI_C_U16_BIT_FULLYDIGITIZEDAREA); }
   tBool bInsideDigitizedArea() const {return (u16Value & FI_C_U16_BIT_INSIDEDIGITIZEDAREA) != 0; }
   tVoid vSetInsideDigitizedArea(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_INSIDEDIGITIZEDAREA):(u16Value & ~FI_C_U16_BIT_INSIDEDIGITIZEDAREA); }
   tBool bDeadReckoningAvailable() const {return (u16Value & FI_C_U16_BIT_DEADRECKONINGAVAILABLE) != 0; }
   tVoid vSetDeadReckoningAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DEADRECKONINGAVAILABLE):(u16Value & ~FI_C_U16_BIT_DEADRECKONINGAVAILABLE); }
   tBool bDifferentialGPSPositionDataAvailable() const {return (u16Value & FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE) != 0; }
   tVoid vSetDifferentialGPSPositionDataAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE):(u16Value & ~FI_C_U16_BIT_DIFFERENTIALGPSPOSITIONDATAAVAILABLE); }
   tBool bGPSPositionDataAvailable() const {return (u16Value & FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE) != 0; }
   tVoid vSetGPSPositionDataAvailable(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE):(u16Value & ~FI_C_U16_BIT_GPSPOSITIONDATAAVAILABLE); }
   tBool bGPSCompleteBlockage() const {return (u16Value & FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE) != 0; }
   tVoid vSetGPSCompleteBlockage(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE):(u16Value & ~FI_C_U16_BIT_GPSCOMPLETEBLOCKAGE); }
   tBool bMatchingAllowedReverseToHardOneway() const {return (u16Value & FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY) != 0; }
   tVoid vSetMatchingAllowedReverseToHardOneway(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY):(u16Value & ~FI_C_U16_BIT_MATCHINGALLOWEDREVERSETOHARDONEWAY); }
   struct rBitValues {
      tBool Calibrated:1;
      tBool MatchedToDigitalMap:1;
      tBool FullyDigitizedArea:1;
      tBool InsideDigitizedArea:1;
      tBool DeadReckoningAvailable:1;
      tBool DifferentialGPSPositionDataAvailable:1;
      tBool GPSPositionDataAvailable:1;
      tBool GPSCompleteBlockage:1;
      tBool MatchingAllowedReverseToHardOneway:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b16_PositionReliability();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b16_PositionReliability& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_PositionHeadingSpeed : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_PositionHeadingSpeed();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_PositionHeadingSpeed& operator=(const sds2hmi_fi_tcl_PositionHeadingSpeed& coRef);
   sds2hmi_fi_tcl_PositionHeadingSpeed(const sds2hmi_fi_tcl_PositionHeadingSpeed& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_PositionWGS84 PositionWGS84;
   sds2hmi_fi_tcl_b16_PositionReliability PositionReliability;
   sds2hmi_fi_tcl_s16_CentimeterSecond Speed;
   sds2hmi_fi_tcl_u8_DirectionAbsolute Heading;
   virtual ~sds2hmi_fi_tcl_PositionHeadingSpeed();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_PositionHeadingSpeed& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NavLocationDescType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NavLocationDescType();

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVLOCATIONDATADESC = 1UL,
      FI_EN_T_NAVAREADESCRIPTIONCIRCLE = 2UL,
      FI_EN_T_NAVAREADESCRIPTIONPOLYGON = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NavLocationDescType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NavLocationDescType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavLocationDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavLocationDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavLocationDesc& operator=(const sds2hmi_fi_tcl_NavLocationDesc& coRef);
   sds2hmi_fi_tcl_NavLocationDesc(const sds2hmi_fi_tcl_NavLocationDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NavLocationDescType NavLocationDescTypeType;
   fi_tclTypeBase* poNavLocationDescTypeData;
   virtual ~sds2hmi_fi_tcl_NavLocationDesc();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavLocationDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

#ifndef FI_S_EXTERNAL_FI
class sds2hmi_fi_tcl_NavLocationBinContainer : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavLocationBinContainer();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavLocationBinContainer& operator=(const sds2hmi_fi_tcl_NavLocationBinContainer& coRef);
   sds2hmi_fi_tcl_NavLocationBinContainer(const sds2hmi_fi_tcl_NavLocationBinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ContainerLength;
   tU16 ServiceID;
   sds2hmi_fi_tcl_FIVersion ContainerFIVersion;
   sds2hmi_fi_tcl_e8_BinContainerTypes ContainerType;
   sds2hmi_fi_tcl_NavLocationDesc ContainerData;
   virtual ~sds2hmi_fi_tcl_NavLocationBinContainer();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavLocationBinContainer& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
   tU16 u16Transform(const sds2hmi_fi_tcl_BinContainer& oContainer);
   static const tU16 C_U16_MAJORVERSION_MAX;
   static const tU16 C_U16_MAJORVERSION_MIN;
};
#endif // FI_S_EXTERNAL_FI

class sds2hmi_fi_tcl_e8_NavIndexZFDestinationType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NavIndexZFDestinationType();

   enum tenType {
      FI_EN_CENTRE = 1UL,
      FI_EN_SPOT = 2UL,
      FI_EN_STREET = 3UL,
      FI_EN_HOUSENUMBER = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NavIndexZFDestinationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NavIndexZFDestinationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NavLocationNavDataType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NavLocationNavDataType();

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVINTERSECTIONDESTINATIONZEROCELLLISTSET = 1UL,
      FI_EN_T_NAVSTREETDESTINATIONONECELLLISTSET = 2UL,
      FI_EN_T_NAVSPOTDESTINATIONONECELLLISTSET = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NavLocationNavDataType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NavLocationNavDataType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u32_DataSetId : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u32_DataSetId(tU32 _u32Value = 0);

   tU32 u32Value;
   virtual ~sds2hmi_fi_tcl_u32_DataSetId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u32_DataSetId& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SideInfo : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SideInfo();

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_LEFT = 1UL,
      FI_EN_RIGHT = 2UL,
      FI_EN_UNKNOWN = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SideInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SideInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NavOneCellDirection : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NavOneCellDirection();

   enum tenType {
      FI_EN_NO = 0UL,
      FI_EN_INDIGITIZED = 1UL,
      FI_EN_REVDIGITIZED = 2UL,
      FI_EN_OMNIDIGITIZED = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NavOneCellDirection();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NavOneCellDirection& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavClusterDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavClusterDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavClusterDesc& operator=(const sds2hmi_fi_tcl_NavClusterDesc& coRef);
   sds2hmi_fi_tcl_NavClusterDesc(const sds2hmi_fi_tcl_NavClusterDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Level;
   tU16 FileId;
   tU32 FileOffset;
   tU16 Length;
   virtual ~sds2hmi_fi_tcl_NavClusterDesc();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavClusterDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& operator=(const sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& coRef);
   sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty(const sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SideInfo SideInfo;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInObjectPointRefList;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInAccessPointRefList;
   virtual ~sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavOneCellDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavOneCellDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavOneCellDesc& operator=(const sds2hmi_fi_tcl_NavOneCellDesc& coRef);
   sds2hmi_fi_tcl_NavOneCellDesc(const sds2hmi_fi_tcl_NavOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 OneCellId;
   sds2hmi_fi_tcl_e8_NavOneCellDirection UseDirection;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInClusterRefList;
   virtual ~sds2hmi_fi_tcl_NavOneCellDesc();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavOneCellDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& operator=(const sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& coRef);
   sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc(const sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NavOneCellDesc OneCellDesc;
   sds2hmi_fi_tcl_NavStreetDestinationOneCellProperty OneCellProperty;
   virtual ~sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NavIntersectionType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NavIntersectionType();

   enum tenType {
      FI_EN_OBJECTINTERSECTION = 1UL,
      FI_EN_COMPLEXINTERSECTION = 2UL,
      FI_EN_SIMPLEINTERSECTION = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NavIntersectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NavIntersectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavZeroCellDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavZeroCellDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavZeroCellDesc& operator=(const sds2hmi_fi_tcl_NavZeroCellDesc& coRef);
   sds2hmi_fi_tcl_NavZeroCellDesc(const sds2hmi_fi_tcl_NavZeroCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 ZeroCellId;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInClusterRefList;
   virtual ~sds2hmi_fi_tcl_NavZeroCellDesc();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavZeroCellDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& operator=(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef);
   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NavIntersectionType IntersectionType;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInObjectPointRefList;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInAccessPointRefList;
   virtual ~sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& operator=(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef);
   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NavZeroCellDesc ZeroCellDesc;
   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellProperty ZeroCellProperty;
   virtual ~sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavAreaDescriptionCircle : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavAreaDescriptionCircle();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavAreaDescriptionCircle& operator=(const sds2hmi_fi_tcl_NavAreaDescriptionCircle& coRef);
   sds2hmi_fi_tcl_NavAreaDescriptionCircle(const sds2hmi_fi_tcl_NavAreaDescriptionCircle& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_s32_Meter Radius;
   sds2hmi_fi_tcl_PositionWGS84 Coordinate;
   virtual ~sds2hmi_fi_tcl_NavAreaDescriptionCircle();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavAreaDescriptionCircle& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavAreaDescriptionPolygon : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavAreaDescriptionPolygon();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavAreaDescriptionPolygon& operator=(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon& coRef);
   sds2hmi_fi_tcl_NavAreaDescriptionPolygon(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_PositionWGS84, std::allocator<sds2hmi_fi_tcl_PositionWGS84> > CoordinateList;
   virtual ~sds2hmi_fi_tcl_NavAreaDescriptionPolygon();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavAreaDescriptionPolygon& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavLocationDataDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavLocationDataDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavLocationDataDesc& operator=(const sds2hmi_fi_tcl_NavLocationDataDesc& coRef);
   sds2hmi_fi_tcl_NavLocationDataDesc(const sds2hmi_fi_tcl_NavLocationDataDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_u32_DataSetId NavDataSetID;
   sds2hmi_fi_tcl_e8_NavIndexZFDestinationType IndexZFDestType;
   std::vector<sds2hmi_fi_tcl_PositionWGS84, std::allocator<sds2hmi_fi_tcl_PositionWGS84> > ObjectPointRefList;
   std::vector<sds2hmi_fi_tcl_PositionWGS84, std::allocator<sds2hmi_fi_tcl_PositionWGS84> > AccessPointRefList;
   sds2hmi_fi_tcl_e8_NavLocationNavDataType NavDataTypeType;
   fi_tclTypeBase* poNavDataTypeData;
   virtual ~sds2hmi_fi_tcl_NavLocationDataDesc();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavLocationDataDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_u32_MediaId : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_u32_MediaId(tU32 _u32Value = 0);

   tU32 u32Value;
   virtual ~sds2hmi_fi_tcl_u32_MediaId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_u32_MediaId& roRef) const
      {  return (u32Value == roRef.u32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_s32_EMU : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_s32_EMU(tS32 _s32Value = 0);

   tS32 s32Value;
   virtual ~sds2hmi_fi_tcl_s32_EMU();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_s32_EMU& roRef) const
      {  return (s32Value == roRef.s32Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NavDataLevel : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NavDataLevel();

   enum tenType {
      FI_EN_DATA_LEVEL_0 = 0UL,
      FI_EN_DATA_LEVEL_1 = 1UL,
      FI_EN_DATA_LEVEL_2 = 2UL,
      FI_EN_DATA_LEVEL_3 = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NavDataLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NavDataLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& operator=(const sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& coRef);
   sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty(const sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SideInfo SideInfo;
   sds2hmi_fi_tcl_s32_EMU FromZeroCellToSpotLength;
   sds2hmi_fi_tcl_s32_EMU OneCellLength;
   sds2hmi_fi_tcl_s32_EMU DestDistance;
   sds2hmi_fi_tcl_PositionWGS84 DecisionPoint;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInObjectPointRefList;
   sds2hmi_fi_tcl_u16_IndexInReferenceList IndexInAccessPointRefList;
   virtual ~sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& operator=(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& coRef);
   sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_NavClusterDesc, std::allocator<sds2hmi_fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc, std::allocator<sds2hmi_fi_tcl_NavStreetDestinationOneCellDesc> > StreetDestinationOneCellRefList;
   virtual ~sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavStreetDestinationOneCellListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& operator=(const sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& coRef);
   sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc(const sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NavOneCellDesc OneCellDesc;
   sds2hmi_fi_tcl_NavSpotDestinationOneCellProperty OneCellProperty;
   virtual ~sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& operator=(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& coRef);
   sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_NavClusterDesc, std::allocator<sds2hmi_fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc, std::allocator<sds2hmi_fi_tcl_NavSpotDestinationOneCellDesc> > SpotDestinationOneCellRefList;
   virtual ~sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavSpotDestinationOneCellListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& operator=(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef);
   sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_NavClusterDesc, std::allocator<sds2hmi_fi_tcl_NavClusterDesc> > ClusterRefList;
   std::vector<sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc, std::allocator<sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellDesc> > IntersectionDestinationZeroCellRefList;
   virtual ~sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavIntersectionDestinationZeroCellListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NavOneCell : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NavOneCell();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NavOneCell& operator=(const sds2hmi_fi_tcl_NavOneCell& coRef);
   sds2hmi_fi_tcl_NavOneCell(const sds2hmi_fi_tcl_NavOneCell& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 OneCellId;
   sds2hmi_fi_tcl_e8_NavOneCellDirection UseDirection;
   tU16 ClusterFileId;
   tU32 ClusterFileOffset;
   tU16 ClusterLength;
   virtual ~sds2hmi_fi_tcl_NavOneCell();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NavOneCell& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NavOneCellCategory : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NavOneCellCategory();

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_T_NAVONECELL = 1UL,
      FI_EN_T_U16_INDEXINREFERENCELIST = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NavOneCellCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NavOneCellCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Action : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Action();

   enum tenType {
      FI_EN_NONE = 0UL,
      FI_EN_GET_STATUS = 1UL,
      FI_EN_GET_ALL_SPEAKERS = 2UL,
      FI_EN_SET_SPEAKER = 3UL,
      FI_EN_ABORT_DIALOG = 4UL,
      FI_EN_PTT_SHORT_PRESS = 5UL,
      FI_EN_PTT_LONG_PRESS = 6UL,
      FI_EN_BACK = 7UL,
      FI_EN_CANCEL = 8UL,
      FI_EN_LIST_UP = 9UL,
      FI_EN_LIST_DOWN = 10UL,
      FI_EN_SELECTION = 11UL,
      FI_EN_LIST_SELECT = 12UL,
      FI_EN_TIMEOUT = 15UL,
      FI_EN_SET_DEFAULTS = 16UL,
      FI_EN_CLEAR_PRIVATE_DATA = 17UL,
      FI_EN_SET_PROFILE = 18UL,
      FI_EN_DELETE_UWPROFILE = 19UL,
      FI_EN_DELETE_USERWORD = 20UL,
      FI_EN_DELETE_USERWORDS = 21UL,
      FI_EN_ENTER_MANUALMODE = 22UL,
      FI_EN_FOCUS_MOVED = 23UL,
      FI_EN_RECORD_USERWORD = 24UL,
      FI_EN_REPLACE_USERWORD = 25UL,
      FI_EN_PLAY_USERWORD = 26UL,
      FI_EN_ENTER_PAUSE_MODE = 27UL,
      FI_EN_EXIT_PAUSE_MODE = 28UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Application : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Application();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_GLOBAL = 1UL,
      FI_EN_MEDIA_PLAYER = 2UL,
      FI_EN_NAVI = 3UL,
      FI_EN_PHONE = 4UL,
      FI_EN_TUNER = 5UL,
      FI_EN_WEATHER = 6UL,
      FI_EN_ADR_BOOK = 7UL,
      FI_EN_TV_TUNER = 8UL,
      FI_EN_CLIMATE_CTR = 9UL,
      FI_EN_SYSTEM_SETTINGS = 10UL,
      FI_EN_AUDIO = 11UL,
      FI_EN_ONSTAR = 12UL,
      FI_EN_INFO = 13UL,
      FI_EN_EXT_APP = 14UL,
      FI_EN_SPEECH_SETTINGS = 15UL,
      FI_EN_LANGUAGE_MENU = 16UL,
      FI_EN_SONG_LIST = 17UL,
      FI_EN_ARTIST_LIST = 18UL,
      FI_EN_ALBUM_LIST = 19UL,
      FI_EN_EXTERNAL_NAVI = 20UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Application();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Application& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PopUp_UpdateType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PopUp_UpdateType();

   enum tenType {
      FI_EN_UPDATE_ALL = 0UL,
      FI_EN_UPDATE_LISTENING_STATUS = 1UL,
      FI_EN_UPDATE_HEADLINE = 2UL,
      FI_EN_UPDATE_STATUSLINE = 3UL,
      FI_EN_UPDATE_TEXTLINES = 4UL,
      FI_EN_UPDATE_LIST_PREV = 5UL,
      FI_EN_UPDATE_LIST_NEXT = 6UL,
      FI_EN_UPDATE_REC_RESULT = 7UL,
      FI_EN_UPDATE_RESTORE_PREVIOUS = 8UL,
      FI_EN_UPDATE_TOFIRSTPAGE = 9UL,
      FI_EN_UPDATE_TOLASTPAGE = 10UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PopUp_UpdateType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PopUp_UpdateType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PopUp_ListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PopUp_ListType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SCROLL_LIST = 1UL,
      FI_EN_FAV_LIST = 2UL,
      FI_EN_AUTOSTORE_LIST = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PopUp_ListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PopUp_ListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_GEN_SelectionType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_GEN_SelectionType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NEXT = 1UL,
      FI_EN_PREV = 2UL,
      FI_EN_BYVAL = 3UL,
      FI_EN_BYPRESET = 4UL,
      FI_EN_BYUSW = 5UL,
      FI_EN_BYTRACK = 6UL,
      FI_EN_BYSOURCE = 7UL,
      FI_EN_BYLISTNUMBER = 8UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_GEN_SelectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_GEN_SelectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PlayAction : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PlayAction();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_PLAY = 1UL,
      FI_EN_SET = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PlayAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PlayAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TUN_SelectionType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TUN_SelectionType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NEXT = 1UL,
      FI_EN_PREV = 2UL,
      FI_EN_BYNAME = 3UL,
      FI_EN_BYPRESET = 4UL,
      FI_EN_BYUSW = 5UL,
      FI_EN_BYFREQUENCY = 6UL,
      FI_EN_BYCHANNEL = 7UL,
      FI_EN_BYFREQUENCYANDSUBCHANNEL = 9UL,
      FI_EN_BYID = 11UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TUN_SelectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TUN_SelectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TUN_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TUN_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BUSY = 1UL,
      FI_EN_SCANNING = 2UL,
      FI_EN_PLAYING = 3UL,
      FI_EN_IDLE = 4UL,
      FI_EN_AUTOSTORING = 5UL,
      FI_EN_NOT_AVAILABLE = 6UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TUN_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TUN_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TUN_Band : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TUN_Band();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_FM = 1UL,
      FI_EN_AM_MW = 2UL,
      FI_EN_AM_LW = 3UL,
      FI_EN_DAB = 4UL,
      FI_EN_XM = 5UL,
      FI_EN_HD_FM = 6UL,
      FI_EN_HD_AM = 7UL,
      FI_EN_RDS_FM = 8UL,
      FI_EN_TV = 9UL,
      FI_EN_DRM = 10UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TUN_Band();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TUN_Band& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TUN_MemBank : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TUN_MemBank();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_FM1 = 1UL,
      FI_EN_FM2 = 2UL,
      FI_EN_FM3 = 3UL,
      FI_EN_FM_AST = 4UL,
      FI_EN_AM_MW = 5UL,
      FI_EN_AM_LW = 6UL,
      FI_EN_BANK_7 = 7UL,
      FI_EN_BANK_8 = 8UL,
      FI_EN_BANK_9 = 9UL,
      FI_EN_BANK_10 = 10UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TUN_MemBank();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TUN_MemBank& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TUN_Setting : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TUN_Setting();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_TA_OFF = 1UL,
      FI_EN_TA_ON = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TUN_Setting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TUN_Setting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_GLOBAL_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_GLOBAL_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BUSY = 1UL,
      FI_EN_IDLE = 2UL,
      FI_EN_NOT_AVAILABLE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_GLOBAL_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_GLOBAL_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_MediaDataType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_MediaDataType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_TITLE = 1UL,
      FI_EN_ARTIST = 2UL,
      FI_EN_ALBUM = 3UL,
      FI_EN_GENRE = 4UL,
      FI_EN_FILENAME = 5UL,
      FI_EN_TRACK = 6UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_MediaDataType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_MediaDataType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SMS_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SMS_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_DISABLED = 1UL,
      FI_EN_NOT_AVAIL = 2UL,
      FI_EN_READ_ONLY = 3UL,
      FI_EN_READ_SEND = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SMS_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SMS_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PHN_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PHN_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BUSY = 1UL,
      FI_EN_IDLE = 2UL,
      FI_EN_INCALL = 3UL,
      FI_EN_DIALLING = 4UL,
      FI_EN_RINGING = 5UL,
      FI_EN_NOT_AVAILABLE = 6UL,
      FI_EN_PHONE_NOT_READY = 7UL,
      FI_EN_PAIRING = 8UL,
      FI_EN_HANDSET_MODE = 9UL,
      FI_EN_INCALL_HOLD = 10UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PHN_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PHN_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PHN_MenuType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PHN_MenuType();

   enum tenType {
      FI_EN_OTHER = 0UL,
      FI_EN_ENTER_PIN = 1UL,
      FI_EN_ENTER_PUK = 2UL,
      FI_EN_ENTER_NUMBER = 3UL,
      FI_EN_PHONEBOOK = 4UL,
      FI_EN_SETTINGS = 5UL,
      FI_EN_ADD_PHONE = 6UL,
      FI_EN_SELECT_PHONE = 7UL,
      FI_EN_READ_TEXT = 8UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PHN_MenuType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PHN_MenuType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PHN_Setting : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PHN_Setting();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ALL_INCOMING_ON = 1UL,
      FI_EN_ALL_INCOMING_OFF = 2UL,
      FI_EN_BLUETOOTH_ON = 3UL,
      FI_EN_BLUETOOTH_OFF = 4UL,
      FI_EN_SWITCH_TO_HANDSET = 5UL,
      FI_EN_SWITCH_TO_HANDSFREE = 6UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PHN_Setting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PHN_Setting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PHN_ListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PHN_ListType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SIMCARD = 1UL,
      FI_EN_PHONEBOOK = 2UL,
      FI_EN_CALL_LIST_ALL = 3UL,
      FI_EN_CALL_LIST_ANSWERED = 4UL,
      FI_EN_CALL_LIST_DIALLED = 5UL,
      FI_EN_CALL_LIST_MISSED = 6UL,
      FI_EN_PAIRING_LIST = 7UL,
      FI_EN_USERWORD_LIST = 8UL,
      FI_EN_POI_LIST = 9UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PHN_ListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PHN_ListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PHN_NumberType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PHN_NumberType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_HOME1 = 1UL,
      FI_EN_HOME2 = 2UL,
      FI_EN_OFFICE1 = 3UL,
      FI_EN_OFFICE2 = 4UL,
      FI_EN_MOBILE1 = 5UL,
      FI_EN_MOBILE2 = 6UL,
      FI_EN_OTHER = 7UL,
      FI_EN_MAIN = 8UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PHN_NumberType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PHN_NumberType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PHN_SelectionType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PHN_SelectionType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BY_CONTACT_ID = 1UL,
      FI_EN_BY_PHONEBOOK_INDEX = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PHN_SelectionType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PHN_SelectionType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PHN_Transorder : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PHN_Transorder();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_LASTNAME_FIRSTNAME = 1UL,
      FI_EN_FIRSTNAME_LASTNAME = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PHN_Transorder();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PHN_Transorder& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BUSY = 1UL,
      FI_EN_IDLE = 2UL,
      FI_EN_GUIDANCE_ACTIVE = 3UL,
      FI_EN_GUIDANCE_ACTIVE_OFFBOARD = 5UL,
      FI_EN_CALCULATING_ROUTE = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_MenuType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_MenuType();

   enum tenType {
      FI_EN_OTHER = 0UL,
      FI_EN_ENTER_DESTINATION = 1UL,
      FI_EN_MAP = 2UL,
      FI_EN_SETTINGS = 3UL,
      FI_EN_ROUTELIST = 4UL,
      FI_EN_CONFIRMATION_CLOSE = 5UL,
      FI_EN_NAV_MAIN = 6UL,
      FI_EN_ENTER_USERWORD = 7UL,
      FI_EN_DISCLAIMER = 8UL,
      FI_EN_SHOW_DEST_IN_MAP = 9UL,
      FI_EN_ADJUST_LOCATION = 10UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_MenuType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_MenuType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_RouteCriteria : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_RouteCriteria();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_USE_SHORT_ROUTE = 1UL,
      FI_EN_USE_FAST_ROUTE = 2UL,
      FI_EN_USE_HIGHWAYS = 3UL,
      FI_EN_AVOID_HIGHWAYS = 4UL,
      FI_EN_USE_TOLLSTREET = 5UL,
      FI_EN_AVOID_TOLLSTREET = 6UL,
      FI_EN_USE_TUNNEL = 7UL,
      FI_EN_AVOID_TUNNELS = 8UL,
      FI_EN_USE_FERRY = 9UL,
      FI_EN_AVOID_FERRY = 10UL,
      FI_EN_USE_CUSTOM_ROUTE = 11UL,
      FI_EN_USE_ECOLOGIC_ROUTE = 12UL,
      FI_EN_USE_ECONOMIC_ROUTE = 13UL,
      FI_EN_USE_AUTOTRAIN = 14UL,
      FI_EN_AVOID_AUTOTRAIN = 15UL,
      FI_EN_USE_TRUCKUNSAFEROADS = 16UL,
      FI_EN_AVOID_TRUCKUNSAFEROADS = 17UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_RouteCriteria();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_RouteCriteria& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_ZoomLevel : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_ZoomLevel();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_ZOOMLEVEL_1 = 1UL,
      FI_EN_ZOOMLEVEL_2 = 2UL,
      FI_EN_ZOOMLEVEL_3 = 3UL,
      FI_EN_ZOOMLEVEL_4 = 4UL,
      FI_EN_ZOOMLEVEL_5 = 5UL,
      FI_EN_ZOOMLEVEL_6 = 6UL,
      FI_EN_ZOOMLEVEL_7 = 7UL,
      FI_EN_ZOOMLEVEL_8 = 8UL,
      FI_EN_ZOOMLEVEL_9 = 9UL,
      FI_EN_ZOOMLEVEL_10 = 10UL,
      FI_EN_ZOOMLEVEL_11 = 11UL,
      FI_EN_ZOOMLEVEL_12 = 12UL,
      FI_EN_ZOOMLEVEL_13 = 13UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_ZoomLevel();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_ZoomLevel& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_ListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_ListType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_LAST_DEST = 1UL,
      FI_EN_PERSISTANT_DEST = 2UL,
      FI_EN_HOME_DEST = 3UL,
      FI_EN_WORK_DEST = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_ListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_ListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_NavUnit : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_NavUnit();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_METRIC = 1UL,
      FI_EN_IMPERIAL = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_NavUnit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_NavUnit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NOTAVAILABLE = 1UL,
      FI_EN_AVAILABLE = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_Setting : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_Setting();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_DYN_RG_ON = 1UL,
      FI_EN_DYN_RG_OFF = 2UL,
      FI_EN_VOICE_GUID_ON = 3UL,
      FI_EN_VOICE_GUID_OFF = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_Setting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_Setting& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_MapMode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_MapMode();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_POSITION = 1UL,
      FI_EN_DESTINATION = 2UL,
      FI_EN_OVERVIEW = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_MapMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_MapMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_AutoZoom : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_AutoZoom();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_AUTOZOOM_OFF = 1UL,
      FI_EN_AUTOZOOM_ON = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_AutoZoom();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_AutoZoom& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_MapView : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_MapView();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_VIEW_2D = 1UL,
      FI_EN_VIEW_3D = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_MapView();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_MapView& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_MapOrientation : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_MapOrientation();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NORTH_UP = 1UL,
      FI_EN_HEADING = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_MapOrientation();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_MapOrientation& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_TBT_Symbols : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_TBT_Symbols();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SYMBOLS_OFF = 1UL,
      FI_EN_SYMBOLS_ON = 2UL,
      FI_EN_SYMBOLS_MIXED = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_TBT_Symbols();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_TBT_Symbols& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_POIListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_POIListType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_AROUND_DESTINATION = 1UL,
      FI_EN_AROUND_POSITION = 2UL,
      FI_EN_ON_ROUTE = 3UL,
      FI_EN_AROUND_OTHER_CITY = 4UL,
      FI_EN_SELECT_FROM_MAP = 5UL,
      FI_EN_SELECT_BY_NAME = 6UL,
      FI_EN_ACTUAL_LIST = 7UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_POIListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_POIListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SET_DisplayMode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SET_DisplayMode();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_DAY = 1UL,
      FI_EN_NIGHT = 2UL,
      FI_EN_AUTO = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SET_DisplayMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SET_DisplayMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TMCListContent : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TMCListContent();

   enum tenType {
      FI_EN_TMC_LIST_UNKNOWN = 0UL,
      FI_EN_TMC_LIST_ALL = 1UL,
      FI_EN_TMC_LIST_AROUND_POSITION = 2UL,
      FI_EN_TMC_LIST_ALONG_ROUTE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TMCListContent();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TMCListContent& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_PopUp_ResultOptions : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_PopUp_ResultOptions();

   enum {
      FI_C_U8_BIT_NOPAGE = 0x1UL,
      FI_C_U8_BIT_PREVIOUSPAGE = 0x2UL,
      FI_C_U8_BIT_NEXTPAGE = 0x4UL
   };
   tBool bNoPage() const {return (u8Value & FI_C_U8_BIT_NOPAGE) != 0; }
   tVoid vSetNoPage(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NOPAGE):(u8Value & ~FI_C_U8_BIT_NOPAGE); }
   tBool bPreviousPage() const {return (u8Value & FI_C_U8_BIT_PREVIOUSPAGE) != 0; }
   tVoid vSetPreviousPage(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_PREVIOUSPAGE):(u8Value & ~FI_C_U8_BIT_PREVIOUSPAGE); }
   tBool bNextPage() const {return (u8Value & FI_C_U8_BIT_NEXTPAGE) != 0; }
   tVoid vSetNextPage(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_NEXTPAGE):(u8Value & ~FI_C_U8_BIT_NEXTPAGE); }
   struct rBitValues {
      tBool NoPage:1;
      tBool PreviousPage:1;
      tBool NextPage:1;
      tBool dummy3:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_PopUp_ResultOptions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_PopUp_ResultOptions& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b16_AnsOptions : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b16_AnsOptions();

   enum {
      FI_C_U16_BIT_INVALIDADDRESS = 0x1UL,
      FI_C_U16_BIT_HOUSENUMBERINRANGE = 0x2UL,
      FI_C_U16_BIT_AMBIGUOUS = 0x4UL,
      FI_C_U16_BIT_GUIDANCEPOSSIBLE = 0x8UL
   };
   tBool bInvalidAddress() const {return (u16Value & FI_C_U16_BIT_INVALIDADDRESS) != 0; }
   tVoid vSetInvalidAddress(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_INVALIDADDRESS):(u16Value & ~FI_C_U16_BIT_INVALIDADDRESS); }
   tBool bHouseNumberInRange() const {return (u16Value & FI_C_U16_BIT_HOUSENUMBERINRANGE) != 0; }
   tVoid vSetHouseNumberInRange(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_HOUSENUMBERINRANGE):(u16Value & ~FI_C_U16_BIT_HOUSENUMBERINRANGE); }
   tBool bAmbiguous() const {return (u16Value & FI_C_U16_BIT_AMBIGUOUS) != 0; }
   tVoid vSetAmbiguous(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_AMBIGUOUS):(u16Value & ~FI_C_U16_BIT_AMBIGUOUS); }
   tBool bGuidancePossible() const {return (u16Value & FI_C_U16_BIT_GUIDANCEPOSSIBLE) != 0; }
   tVoid vSetGuidancePossible(tBool bSetBit) { u16Value = (bSetBit)?(u16Value | FI_C_U16_BIT_GUIDANCEPOSSIBLE):(u16Value & ~FI_C_U16_BIT_GUIDANCEPOSSIBLE); }
   struct rBitValues {
      tBool InvalidAddress:1;
      tBool HouseNumberInRange:1;
      tBool Ambiguous:1;
      tBool GuidancePossible:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool dummy7:1;
      tBool dummy8:1;
      tBool dummy9:1;
      tBool dummy10:1;
      tBool dummy11:1;
      tBool dummy12:1;
      tBool dummy13:1;
      tBool dummy14:1;
      tBool dummy15:1;
   };
   union {
      tU16 u16Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b16_AnsOptions();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b16_AnsOptions& roRef) const
      {  return (u16Value == roRef.u16Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting();

   enum {
      FI_C_U8_BIT_FULLMATCH = 0x1UL,
      FI_C_U8_BIT_LANGUAGECODEMATCH = 0x2UL,
      FI_C_U8_BIT_SCRIPTMATCH = 0x8UL,
      FI_C_U8_BIT_ANYMATCH = 0x80UL
   };
   tBool bFullMatch() const {return (u8Value & FI_C_U8_BIT_FULLMATCH) != 0; }
   tVoid vSetFullMatch(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_FULLMATCH):(u8Value & ~FI_C_U8_BIT_FULLMATCH); }
   tBool bLanguageCodeMatch() const {return (u8Value & FI_C_U8_BIT_LANGUAGECODEMATCH) != 0; }
   tVoid vSetLanguageCodeMatch(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_LANGUAGECODEMATCH):(u8Value & ~FI_C_U8_BIT_LANGUAGECODEMATCH); }
   tBool bScriptMatch() const {return (u8Value & FI_C_U8_BIT_SCRIPTMATCH) != 0; }
   tVoid vSetScriptMatch(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_SCRIPTMATCH):(u8Value & ~FI_C_U8_BIT_SCRIPTMATCH); }
   tBool bAnyMatch() const {return (u8Value & FI_C_U8_BIT_ANYMATCH) != 0; }
   tVoid vSetAnyMatch(tBool bSetBit) { u8Value = (bSetBit)?(u8Value | FI_C_U8_BIT_ANYMATCH):(u8Value & ~FI_C_U8_BIT_ANYMATCH); }
   struct rBitValues {
      tBool FullMatch:1;
      tBool LanguageCodeMatch:1;
      tBool dummy2:1;
      tBool ScriptMatch:1;
      tBool dummy4:1;
      tBool dummy5:1;
      tBool dummy6:1;
      tBool AnyMatch:1;
   };
   union {
      tU8 u8Value;
      rBitValues bits;
   };
   virtual ~sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting& roRef) const
      {  return (u8Value == roRef.u8Value);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_UPOI_Source : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_UPOI_Source();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_STANDARD = 1UL,
      FI_EN_DOWNLOADED = 2UL,
      FI_EN_TRAVELGUIDE = 3UL,
      FI_EN_INDIVIDUAL = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_UPOI_Source();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_UPOI_Source& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Gender : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Gender();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_MALE = 1UL,
      FI_EN_FEMALE = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Gender();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Gender& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SDS_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SDS_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_UNAVAILABLE = 1UL,
      FI_EN_LOADING = 2UL,
      FI_EN_IDLE = 3UL,
      FI_EN_ACTIVE = 4UL,
      FI_EN_LISTENING = 5UL,
      FI_EN_PROCESSING = 6UL,
      FI_EN_ERROR = 7UL,
      FI_EN_DATA_ERROR = 8UL,
      FI_EN_PAUSE = 9UL,
      FI_EN_IDLE_TTS_ONLY = 10UL,
      FI_EN_ACTIVE_PROMPTONLY = 11UL,
      FI_EN_LISTENING_AND_SPEECH_DETECTED = 12UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SDS_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SDS_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_DeviceStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_DeviceStatus();

   enum tenType {
      FI_EN_DEVICE_UNKNOWN = 0UL,
      FI_EN_DEVICE_VERIFYING = 1UL,
      FI_EN_DEVICE_UPDATING = 2UL,
      FI_EN_DEVICE_READY = 3UL,
      FI_EN_DEVICE_DISABLED = 4UL,
      FI_EN_DEVICE_READY_NOT_ACTIVE = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_DeviceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_DeviceStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_MPL_ListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_MPL_ListType();

   enum tenType {
      FI_EN_LIST_TYPE_UNKNOWN = 0UL,
      FI_EN_LIST_TYPE_TRACKS = 1UL,
      FI_EN_LIST_TYPE_PLAYLIST = 2UL,
      FI_EN_LIST_TYPE_TITLES = 3UL,
      FI_EN_LIST_TYPE_ARTISTS = 4UL,
      FI_EN_LIST_TYPE_ALBUMS = 5UL,
      FI_EN_LIST_TYPE_GENRES = 6UL,
      FI_EN_LIST_TYPE_SONGS_BY_ARTIST = 7UL,
      FI_EN_LIST_TYPE_SONGS_BY_ALBUM = 8UL,
      FI_EN_LIST_TYPE_ALBUMS_BY_ARTIST = 9UL,
      FI_EN_LIST_TYPE_ARTISTS_BY_GENRE = 10UL,
      FI_EN_LIST_TYPE_ALBUMS_BY_GENRE = 11UL,
      FI_EN_LIST_TYPE_PODCAST_TITLES = 12UL,
      FI_EN_LIST_TYPE_PODCAST_EPISODES = 13UL,
      FI_EN_LIST_TYPE_PODCAST_EPISODES_BY_TITLE = 14UL,
      FI_EN_LIST_TYPE_AUDIOBOOK_TITLES = 15UL,
      FI_EN_LIST_TYPE_AUDIOBOOK_AUTHORS = 16UL,
      FI_EN_LIST_TYPE_AUDIOBOOK_CHAPTERS = 17UL,
      FI_EN_LIST_TYPE_AUDIOBOOK_TITLES_BY_AUTHOR = 18UL,
      FI_EN_LIST_TYPE_AUDIOBOOK_CHAPTERS_BY_TITLES = 19UL,
      FI_EN_LIST_TYPE_VIDEOS = 20UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_MPL_ListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_MPL_ListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_MPL_MenuType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_MPL_MenuType();

   enum tenType {
      FI_EN_MENU_TYPE_UNKNOWN = 0UL,
      FI_EN_MENU_TYPE_MAIN = 1UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_MPL_MenuType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_MPL_MenuType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_MPL_SourceType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_MPL_SourceType();

   enum tenType {
      FI_EN_SOURCE_TYPE_UNKNOWN = 0UL,
      FI_EN_SOURCE_TYPE_LINE_IN = 1UL,
      FI_EN_SOURCE_TYPE_BTAUDIO = 2UL,
      FI_EN_SOURCE_TYPE_USB = 3UL,
      FI_EN_SOURCE_TYPE_IPOD = 4UL,
      FI_EN_SOURCE_TYPE_SDCARD = 5UL,
      FI_EN_SOURCE_TYPE_CDA = 6UL,
      FI_EN_SOURCE_TYPE_CARPLAY_AUD = 7UL,
      FI_EN_SOURCE_TYPE_ANDROID_AUD = 8UL,
      FI_EN_SOURCE_TYPE_DVD = 9UL,
      FI_EN_SOURCE_TYPE_MUSIC_BOX = 10UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_MPL_SourceType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_MPL_SourceType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_MPL_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_MPL_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BUSY = 1UL,
      FI_EN_SCANNING = 2UL,
      FI_EN_PLAYING = 3UL,
      FI_EN_IDLE = 4UL,
      FI_EN_NOT_AVAILABLE = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_MPL_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_MPL_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_WEA_MenuType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_WEA_MenuType();

   enum tenType {
      FI_EN_OTHER = 0UL,
      FI_EN_MAIN = 1UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_WEA_MenuType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_WEA_MenuType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_WEA_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_WEA_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BUSY = 1UL,
      FI_EN_IDLE = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_WEA_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_WEA_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_WEA_Location : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_WEA_Location();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NEARBY = 1UL,
      FI_EN_CONTACT = 2UL,
      FI_EN_CITY_STATE = 3UL,
      FI_EN_ZIP_CODE = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_WEA_Location();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_WEA_Location& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_LocationType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_LocationType();

   enum tenType {
      FI_EN_DEFAULT = 0UL,
      FI_EN_NEARBY = 1UL,
      FI_EN_ALONG_ROUTE = 2UL,
      FI_EN_NEAR_DESTINATION = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_LocationType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_LocationType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_CON_AmbiguityListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_CON_AmbiguityListType();

   enum tenType {
      FI_EN_NO_ENTRY = 0UL,
      FI_EN_AMBIG_CONTACT = 1UL,
      FI_EN_SINGLE_ENTRY = 2UL,
      FI_EN_AMBIG_LOCATION = 3UL,
      FI_EN_AMBIG_ENTRY = 4UL,
      FI_EN_AMBIG_ALL_ENTRIES = 5UL,
      FI_EN_NO_MATCHING_LOCATION = 6UL,
      FI_EN_CONTACT_UNAVAILABLE = 7UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_CON_AmbiguityListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_CON_AmbiguityListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_CON_EntryType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_CON_EntryType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_PHONE_NUMBER = 1UL,
      FI_EN_ADDRESS = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_CON_EntryType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_CON_EntryType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_LOW = 1UL,
      FI_EN_HIGH = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_ParameterAction : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_ParameterAction();

   enum tenType {
      FI_EN_GET = 0UL,
      FI_EN_GETALL = 1UL,
      FI_EN_SET = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_ParameterAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_ParameterAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SDS_ParameterType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SDS_ParameterType();

   enum tenType {
      FI_EN_T_RESERVED = 0UL,
      FI_EN_TBOOL = 1UL,
      FI_EN_TU32 = 2UL,
      FI_EN_TSTRING = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SDS_ParameterType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SDS_ParameterType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SDSSettings : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SDSSettings();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BREQUESTMORECONFIRMATIONS = 1UL,
      FI_EN_INFOCLEAR_PRIVATE_DATA = 2UL,
      FI_EN_INFOSET_DEFAULTS = 3UL,
      FI_EN_INFOSET_PROMPTMODE = 4UL,
      FI_EN_SET_SPEECH_OUTPUT_RATE = 5UL,
      FI_EN_SET_WAKEUP_WORD = 6UL,
      FI_EN_DELETE_WAKEUP_WORD = 7UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SDSSettings();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SDSSettings& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SettingsError : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SettingsError();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_OK = 1UL,
      FI_EN_SETTINGSAPPLIED = 2UL,
      FI_EN_SETTINGSNOTSUPPORTED = 3UL,
      FI_EN_SETTINGSFAILED = 4UL,
      FI_EN_INTERNALERROR = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SettingsError();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SettingsError& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_HMI_ListType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_HMI_ListType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_LIST_ADDRESSBOOK = 1UL,
      FI_EN_LIST_NAV_PREV_DESTINATIONS = 2UL,
      FI_EN_LIST_NAV_FAVOURITES = 3UL,
      FI_EN_LIST_POI_CATEGORIES = 4UL,
      FI_EN_LIST_POI_ENTRIES = 5UL,
      FI_EN_LIST_PHONE_ALL_CALLS = 6UL,
      FI_EN_LIST_PHONE_MISSED_CALLS = 7UL,
      FI_EN_LIST_PHONE_ANSWERED_CALLS = 8UL,
      FI_EN_LIST_PHONE_DIALLED_CALLS = 9UL,
      FI_EN_LIST_PHONE_PAIRINGS = 10UL,
      FI_EN_LIST_CUSTOM_SMS = 11UL,
      FI_EN_LIST_FUEL_PRICES = 12UL,
      FI_EN_LIST_FUEL_DISTANCES = 13UL,
      FI_EN_LIST_CONTACT_AMBIGUITY = 14UL,
      FI_EN_LIST_PHONE_RECEIVED_SMS = 15UL,
      FI_EN_LIST_PHONE_USERWORDS = 16UL,
      FI_EN_LIST_PHONE_PB_ALL_ENTRIES = 17UL,
      FI_EN_LIST_PHONE_PB_WITH_LOC_ENTRIES = 18UL,
      FI_EN_LIST_PHONE_VB_ALL_ENTRIES = 19UL,
      FI_EN_LIST_PHONE_VB_WITH_LOC_ENTRIES = 20UL,
      FI_EN_LIST_PHONE_VB_WITH_REL_ENTRIES = 21UL,
      FI_EN_LIST_PHONE_VB_REL_LOC_ENTRIES = 22UL,
      FI_EN_LIST_NAV_ADDRESS = 23UL,
      FI_EN_LIST_PARKING = 24UL,
      FI_EN_LIST_INFO_FEEDS = 25UL,
      FI_EN_LIST_CITYCENTER = 26UL,
      FI_EN_LIST_INTERSECTION = 27UL,
      FI_EN_LIST_INTERSECT_STREET2 = 28UL,
      FI_EN_LIST_INTERSECT_STREET1 = 29UL,
      FI_EN_LIST_HOUSE_NUMBR = 30UL,
      FI_EN_LIST_STREET = 31UL,
      FI_EN_LIST_CITY = 32UL,
      FI_EN_LIST_STATE = 33UL,
      FI_EN_LIST_COUNTRY = 34UL,
      FI_EN_LIST_EVE_QUICK_CHARGE_STATIONS = 35UL,
      FI_EN_LIST_EVE_ALL_CHARGE_STATIONS = 36UL,
      FI_EN_LIST_NAV_DISTANCE_DETOUR = 37UL,
      FI_EN_LIST_NAV_POI_ICON = 38UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_HMI_ListType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_HMI_ListType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_HMI_ListSize : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_HMI_ListSize();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_NONE = 1UL,
      FI_EN_ONE = 2UL,
      FI_EN_MULTIPLE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_HMI_ListSize();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_HMI_ListSize& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Info_Menu : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Info_Menu();

   enum tenType {
      FI_EN_INFO_TRAFFIC = 0UL,
      FI_EN_INFO_CURRENT_WEATHER = 1UL,
      FI_EN_INFO_WEATHER_MAP = 2UL,
      FI_EN_INFO_5DAY_FORECAST = 3UL,
      FI_EN_INFO_6HOUR_FORECAST = 4UL,
      FI_EN_INFO_SPORTS = 5UL,
      FI_EN_INFO_STOCKS_FAVOURITES = 6UL,
      FI_EN_INFO_STOCKS_INDICES = 7UL,
      FI_EN_INFO_MOVIES_FAV_THEATERS = 8UL,
      FI_EN_INFO_MOVIES_LIST_THEATERS = 9UL,
      FI_EN_INFO_MOVIES_LIST_MOVIES = 10UL,
      FI_EN_INFO_TCU_VOICE_MENU = 11UL,
      FI_EN_INFO_SPORTS_FAVOURITES = 12UL,
      FI_EN_INFO_SPORTS_FOOTBALL = 13UL,
      FI_EN_INFO_SPORTS_BASEBALL = 14UL,
      FI_EN_INFO_SPORTS_BASKETBALL = 15UL,
      FI_EN_INFO_SPORTS_HOCKEY = 16UL,
      FI_EN_INFO_SPORTS_GOLF = 17UL,
      FI_EN_INFO_SPORTS_AUTORACING = 18UL,
      FI_EN_INFO_SPORTS_SOCCER = 19UL,
      FI_EN_INFO_SPORTS_TENNIS = 20UL,
      FI_EN_INFO_SPORTS_OTHERSPORTS = 21UL,
      FI_EN_INFO_MAINTENANCE = 22UL,
      FI_EN_INFO_TIRE_PRESSURE = 23UL,
      FI_EN_INFO_ENERGY_FLOW = 24UL,
      FI_EN_INFO_CLIMATE_CONTROL = 25UL,
      FI_EN_INFO_SET_TEMPERATURE = 26UL,
      FI_EN_INFO_CURRENT_LOCATION = 27UL,
      FI_EN_INFO_ADJUST_LOCATION = 28UL,
      FI_EN_INFO_FUEL_ECONOMY = 29UL,
      FI_EN_INFO_INFO_FEED = 30UL,
      FI_EN_INFO_EVE_ENERGY_USAGE = 31UL,
      FI_EN_INFO_EVE_DRIVING_RANGE = 32UL,
      FI_EN_INFO_EVE_ENERGY_ECONOMY = 33UL,
      FI_EN_INFO_EVE_UPDATE_STATIONS = 34UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Info_Menu();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Info_Menu& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Info_SXM_Services : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Info_SXM_Services();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_FUEL_PRICE = 1UL,
      FI_EN_PARKING = 2UL,
      FI_EN_CURRENT_WEATHER = 3UL,
      FI_EN_SIX_HOUR_FORECAST = 4UL,
      FI_EN_FIVE_DAY_FORECAST = 5UL,
      FI_EN_WEATHER_MAP = 6UL,
      FI_EN_SPORTS = 7UL,
      FI_EN_STOCKS = 8UL,
      FI_EN_MOVIES = 9UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Info_SXM_Services();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Info_SXM_Services& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SpecialAppId : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SpecialAppId();

   enum tenType {
      FI_EN_APP_UNKNOWN = 0UL,
      FI_EN_APP_SIRI = 1UL,
      FI_EN_APP_VOICEASSIST = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SpecialAppId();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SpecialAppId& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SpecialAppStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SpecialAppStatus();

   enum tenType {
      FI_EN_APP_STAT_UNKNOWN = 0UL,
      FI_EN_APP_STAT_AVAIALABLE_ACTIVE = 1UL,
      FI_EN_APP_STAT_AVAILABLE_NOT_ACTIVE = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SpecialAppStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SpecialAppStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_INFO_TCUType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_INFO_TCUType();

   enum tenType {
      FI_EN_INFO_TCUTYPE_NONE = 0UL,
      FI_EN_INFO_TCUTYPE_NISSAN = 1UL,
      FI_EN_INFO_TCUTYPE_INFINITY = 2UL,
      FI_EN_INFO_TCUTYPE_RENAULT = 3UL,
      FI_EN_INFO_TCUTYPE_DACIA = 4UL,
      FI_EN_INFO_TCUTYPE_RN_ALPINE = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_INFO_TCUType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_INFO_TCUType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_TUN_Band_Group : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_TUN_Band_Group();

   enum tenType {
      FI_EN_TUN_FREQ_GRP_NAR = 0UL,
      FI_EN_TUN_FREQ_GRP_EUR = 1UL,
      FI_EN_TUN_FREQ_GRP_GLO = 2UL,
      FI_EN_TUN_FREQ_GRP_SAM = 3UL,
      FI_EN_TUN_FREQ_GRP_AUS = 4UL,
      FI_EN_TUN_FREQ_GRP_JAP = 5UL,
      FI_EN_TUN_FREQ_GRP_RESERVED = 6UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_TUN_Band_Group();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_TUN_Band_Group& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_HMIElementDescriptorMode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_HMIElementDescriptorMode();

   enum tenType {
      FI_EN_DESCR_UNKNOWN = 0UL,
      FI_EN_DESCR_PROMPT = 1UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_HMIElementDescriptorMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_HMIElementDescriptorMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_ZoomAction : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_ZoomAction();

   enum tenType {
      FI_EN_ZOOM_UNKNOWN = 0UL,
      FI_EN_ZOOM_IN = 1UL,
      FI_EN_ZOOM_OUT = 2UL,
      FI_EN_ZOOM_STREETS = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_ZoomAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_ZoomAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NAV_IconDisplayAction : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NAV_IconDisplayAction();

   enum tenType {
      FI_EN_ICONDSPLY_UNKNOWN = 0UL,
      FI_EN_ICONDSPLY_SHOW = 1UL,
      FI_EN_ICONDSPLY_REMOVE = 2UL,
      FI_EN_ICONDSPLY_SHOWALL = 3UL,
      FI_EN_ICONDSPLY_REMOVEALL = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NAV_IconDisplayAction();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NAV_IconDisplayAction& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SDS_EntryPoint : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SDS_EntryPoint();

   enum tenType {
      FI_EN_SDS_ENTRY_GLOBAL = 0UL,
      FI_EN_SDS_ENTRY_PHONE = 1UL,
      FI_EN_SDS_ENTRY_PHONE_OAC = 2UL,
      FI_EN_SDS_ENTRY_NAVI = 3UL,
      FI_EN_SDS_ENTRY_WEATHER = 4UL,
      FI_EN_SDS_ENTRY_AUDIO = 5UL,
      FI_EN_SDS_ENTRY_MYMEDIA = 6UL,
      FI_EN_SDS_ENTRY_TUNER = 7UL,
      FI_EN_SDS_ENTRY_NAVI_GA = 8UL,
      FI_EN_SDS_ENTRY_CALL_CONTACT = 9UL,
      FI_EN_SDS_ENTRY_DIAL_NUMBER = 10UL,
      FI_EN_SDS_ENTRY_CALL_HISTORY = 11UL,
      FI_EN_SDS_ENTRY_QUICK_DIAL = 12UL,
      FI_EN_SDS_ENTRY_READ_TEXT = 13UL,
      FI_EN_SDS_ENTRY_SEND_TEXT = 14UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_ADDRESS = 15UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_POI = 16UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_POICAT = 17UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_INTERSECTION = 18UL,
      FI_EN_SDS_ENTRY_NAVI_CITYCENTER_CITY = 19UL,
      FI_EN_SDS_ENTRY_SELECT_ARTIST = 20UL,
      FI_EN_SDS_ENTRY_SELECT_ALBUM = 21UL,
      FI_EN_SDS_ENTRY_SELECT_SONG = 22UL,
      FI_EN_SDS_ENTRY_SELECT_PLAYLIST = 23UL,
      FI_EN_SDS_ENTRY_SELECT_GENRE = 24UL,
      FI_EN_SDS_ENTRY_MYAPPS = 25UL,
      FI_EN_SDS_ENTRY_INFO = 26UL,
      FI_EN_SDS_ENTRY_USERWORD = 27UL,
      FI_EN_SDS_ENTRY_PHONE_OMC = 28UL,
      FI_EN_SDS_ENTRY_NAVI_SET_DEST_CITY_CENTER = 29UL,
      FI_EN_SDS_ENTRY_NAVI_POI_IN_CITY = 30UL,
      FI_EN_SDS_ENTRY_NAVI_SET_DEST_POI = 31UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_POI_IN_CITY_TAB = 32UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_POI_ALONG_ROUTE_TAB = 33UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_POI_NEAR_DEST_TAB = 34UL,
      FI_EN_SDS_ENTRY_NAVI_ENTER_POI_NEARBY_TAB = 35UL,
      FI_EN_SDS_ENTRY_NAVI_SET_DEST_INTERSECTION = 36UL,
      FI_EN_SDS_ENTRY_NAVI_INTERSECTION_STRT2 = 37UL,
      FI_EN_SDS_ENTRY_NAVI_INTERSECTION_STRT1 = 38UL,
      FI_EN_SDS_ENTRY_NAVI_SET_DEST_ADDRERSS = 39UL,
      FI_EN_SDS_ENTRY_NAVI_STEP_CITYFIRST_HNO = 40UL,
      FI_EN_SDS_ENTRY_NAVI_STEP_CITYFIRST_HNO_STREET = 41UL,
      FI_EN_SDS_ENTRY_NAVI_STEP_CITYFIRST_CITY = 42UL,
      FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_ENTER_STATE = 43UL,
      FI_EN_SDS_ENTRY_NAVI_POI_STEP_ENTER_STATE = 44UL,
      FI_EN_SDS_ENTRY_NAVI_INTERSECT_STEP_ENTER_STATE = 45UL,
      FI_EN_SDS_ENTRY_NAVI_POI_STEP_ENTER_CITY = 46UL,
      FI_EN_SDS_ENTRY_NAVI_INTERSECT_STEP_ENTER_CITY = 47UL,
      FI_EN_SDS_ENTRY_NAVI_STEP_ENTER_COUNTRY = 48UL,
      FI_EN_SDS_ENTRY_NAVI_ADRS_STEP_ENTER_COUNTRY = 49UL,
      FI_EN_SDS_ENTRY_NAVI_POI_STEP_ENTER_COUNTRY = 50UL,
      FI_EN_SDS_ENTRY_NAVI_INTERSECT_STEP_ENTER_COUNTRY = 51UL,
      FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_HNOFIRST_HNO = 52UL,
      FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_HNOFIRST_STREET = 53UL,
      FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_HNOFIRST_STREET_CITY = 54UL,
      FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_CITYFIRST_STREET = 55UL,
      FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_CITYFIRST_STREET_HNO = 56UL,
      FI_EN_SDS_ENTRY_NAVI_AMBIG_ADDRESS = 57UL,
      FI_EN_SDS_ENTRY_NAVI_AMBIG_CITY_CENTER = 58UL,
      FI_EN_SDS_ENTRY_NAVI_CITYCENTER_STEP_ENTER_STATE = 59UL,
      FI_EN_SDS_ENTRY_NAVI_CITYCENTER_STEP_ENTER_COUNTRY = 60UL,
      FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_OAZA = 61UL,
      FI_EN_SDS_ENTRY_DICTATE_MSG = 62UL,
      FI_EN_SDS_ENTRY_TUNER_AM = 63UL,
      FI_EN_SDS_ENTRY_TUNER_FM = 64UL,
      FI_EN_SDS_ENTRY_TUNER_SXM = 65UL,
      FI_EN_SDS_ENTRY_TV = 66UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SDS_EntryPoint();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SDS_EntryPoint& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_MainDomains : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_MainDomains();

   enum tenType {
      FI_EN_DOMAIN_NONE = 0UL,
      FI_EN_DOMAIN_PHONE = 1UL,
      FI_EN_DOMAIN_NAVIGATION = 2UL,
      FI_EN_DOMAIN_AUDIO = 3UL,
      FI_EN_DOMAIN_INFORMATION = 4UL,
      FI_EN_DOMAIN_EVE = 5UL,
      FI_EN_DOMAIN_VEH_INFO = 6UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_MainDomains();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_MainDomains& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_HMIElementReference : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_HMIElementReference();

   enum tenType {
      FI_EN_ELEMENT_NONE = 0UL,
      FI_EN_ELEMENT_ONFOCUS = 1UL,
      FI_EN_ELEMENT_BY_LINENUMBER = 2UL,
      FI_EN_ELEMENT_BY_ID = 3UL,
      FI_EN_ELEMENT_BY_USW_ID = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_HMIElementReference();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_HMIElementReference& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_CoreSpeechParameters : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_CoreSpeechParameters();

   enum tenType {
      FI_EN_COREPARAM_NONE = 0UL,
      FI_EN_COREPARAM_TTS_ENGINE = 1UL,
      FI_EN_COREPARAM_TTS_VOICE_NAME = 2UL,
      FI_EN_COREPARAM_TTS_VOICE_GENDER = 3UL,
      FI_EN_COREPARAM_TTS_VOICE_VERSION = 4UL,
      FI_EN_COREPARAM_REC_VOCON_ENG_VERSION = 5UL,
      FI_EN_COREPARAM_REC_ACO_MODEL_VERSION = 6UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_CoreSpeechParameters();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_CoreSpeechParameters& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_ActionInfoCategory : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_ActionInfoCategory();

   enum tenType {
      FI_EN_CATEGORY_NONE = 0UL,
      FI_EN_CATEGORY_DOMAIN = 1UL,
      FI_EN_CATEGORY_DATA_EXCHANGE = 2UL,
      FI_EN_CATEGORY_DATA_DESCRPTION = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_ActionInfoCategory();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_ActionInfoCategory& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_PhBook_Update_Action : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_PhBook_Update_Action();

   enum tenType {
      FI_EN_UPDATE_NONE = 0UL,
      FI_EN_UPDATE_RELATIONSHIP = 1UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_PhBook_Update_Action();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_PhBook_Update_Action& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e16_PHN_Relationship : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e16_PHN_Relationship();

   enum tenType {
      FI_EN_REL_UNKNOWN = 0UL,
      FI_EN_REL_MOM = 400UL,
      FI_EN_REL_DAD = 401UL,
      FI_EN_REL_PARENTS = 402UL,
      FI_EN_REL_BROTHER = 403UL,
      FI_EN_REL_SISTER = 404UL,
      FI_EN_REL_CHILD = 405UL,
      FI_EN_REL_SON = 406UL,
      FI_EN_REL_DAUGHTER = 407UL,
      FI_EN_REL_FRIEND = 408UL,
      FI_EN_REL_PARTNER = 409UL,
      FI_EN_REL_WIFE = 410UL,
      FI_EN_REL_HUSBAND = 411UL,
      FI_EN_REL_HOME = 412UL,
      FI_EN_REL_OFFICE = 413UL,
      FI_EN_REL_ASSISTANT = 414UL,
      FI_EN_REL_MANAGER = 415UL,
      FI_EN_REL_OTHER = 416UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e16_PHN_Relationship();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e16_PHN_Relationship& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Data_Exchange_Type : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Data_Exchange_Type();

   enum tenType {
      FI_EN_DATA_NONE = 0UL,
      FI_EN_DATA_SINGLE = 1UL,
      FI_EN_DATA_LIST = 2UL,
      FI_EN_DATA_MULTIPLE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Data_Exchange_Type();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Data_Exchange_Type& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Common_SDS_Evnt : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Common_SDS_Evnt();

   enum tenType {
      FI_EN_COMN_EVNT_NONE = 0UL,
      FI_EN_COMN_EVNT_REC_TIMEOUT = 1UL,
      FI_EN_COMN_EVNT_PAUSE_COMMAND = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Common_SDS_Evnt();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Common_SDS_Evnt& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat();

   enum tenType {
      FI_EN_TA_IPA = 0UL,
      FI_EN_STARREC_SAMPA = 1UL,
      FI_EN_X_SAMPA = 2UL,
      FI_EN_LH_PLUS = 3UL,
      FI_EN_NT_SAMPA = 4UL,
      FI_EN_SVOX_PA = 5UL,
      FI_EN_VFA = 6UL,
      FI_EN_I_FLYTEC = 7UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NDS_SDN_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NDS_SDN_Status();

   enum tenType {
      FI_EN_DATA_NOT_AVAILABLE = 0UL,
      FI_EN_DATA_AVAILABLE = 1UL,
      FI_EN_DATA_UPDATE_ONGOING = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NDS_SDN_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NDS_SDN_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_AVAILABLE = 1UL,
      FI_EN_SERVICE_NOT_SUBSCRIBED = 2UL,
      FI_EN_ANTENA_NOT_CONNECTED = 3UL,
      FI_EN_NO_SIGNAL = 4UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_EventForLogging : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_EventForLogging();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_BEGIN_OF_SPEECH = 1UL,
      FI_EN_END_OF_SPEECH = 2UL,
      FI_EN_CALL_TO_PP = 3UL,
      FI_EN_PROMPT_PLAY_SATRTED = 4UL,
      FI_EN_END_OF_PROMPT = 5UL,
      FI_EN_SDS_ERROR = 6UL,
      FI_EN_SPOKE_TOO_EARLY = 7UL,
      FI_EN_SCREEN_SHOW_TRIGGER = 8UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_EventForLogging();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_EventForLogging& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_Distance_Unit : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_Distance_Unit();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_KM = 1UL,
      FI_EN_METER = 2UL,
      FI_EN_MILE = 3UL,
      FI_EN_YARD = 4UL,
      FI_EN_FEET = 5UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_Distance_Unit();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_Distance_Unit& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_SharedDataAccess : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_SharedDataAccess();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_REQUIRED = 1UL,
      FI_EN_ENABLE = 2UL,
      FI_EN_NOT_REQUIRED = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_SharedDataAccess();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_SharedDataAccess& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_JournalingMode : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_JournalingMode();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_WAL = 1UL,
      FI_EN_NONE = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_JournalingMode();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_JournalingMode& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_LockType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_LockType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_EXCLUSIVE = 1UL,
      FI_EN_NORMAL = 2UL,
      FI_EN_NONE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_LockType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_LockType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_NDSDataAccessType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_NDSDataAccessType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_SHARED = 1UL,
      FI_EN_NOT_SHARED = 2UL,
      FI_EN_NONE = 3UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_NDSDataAccessType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_NDSDataAccessType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_FAILED = 1UL,
      FI_EN_OK = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_DestEntry : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_DestEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_DestEntry& operator=(const sds2hmi_fi_tcl_DestEntry& coRef);
   sds2hmi_fi_tcl_DestEntry(const sds2hmi_fi_tcl_DestEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString CountryName;
   sds2hmi_fi_tclString CountyName;
   sds2hmi_fi_tclString CityName;
   sds2hmi_fi_tclString StreetName;
   sds2hmi_fi_tclString POIName;
   sds2hmi_fi_tclString HouseNr;
   sds2hmi_fi_tclString RenamedDest;
   tU16 nUswID_16;
   tU32 nUswID;
   tU32 nDestListID;
   sds2hmi_fi_tclString JunctionName;
   virtual ~sds2hmi_fi_tcl_DestEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_DestEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_PhoneEntry : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_PhoneEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_PhoneEntry& operator=(const sds2hmi_fi_tcl_PhoneEntry& coRef);
   sds2hmi_fi_tcl_PhoneEntry(const sds2hmi_fi_tcl_PhoneEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString LastName;
   sds2hmi_fi_tclString FirstName;
   sds2hmi_fi_tclString PhoneNumber;
   sds2hmi_fi_tcl_e8_PHN_NumberType PhoneNumberType;
   tU16 nUswID_16;
   tU32 nUswID;
   tU16 nUswListID_16;
   tU32 nUswListID;
   tU16 nPhnBookListID;
   virtual ~sds2hmi_fi_tcl_PhoneEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_PhoneEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_ContactData : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_ContactData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_ContactData& operator=(const sds2hmi_fi_tcl_ContactData& coRef);
   sds2hmi_fi_tcl_ContactData(const sds2hmi_fi_tcl_ContactData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ContactID;
   sds2hmi_fi_tclString ContactDetails;
   virtual ~sds2hmi_fi_tcl_ContactData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_ContactData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_TmcEntry : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_TmcEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_TmcEntry& operator=(const sds2hmi_fi_tcl_TmcEntry& coRef);
   sds2hmi_fi_tcl_TmcEntry(const sds2hmi_fi_tcl_TmcEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString sMessage;
   tU32 u32ID;
   virtual ~sds2hmi_fi_tcl_TmcEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_TmcEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_DeviceStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_DeviceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_DeviceStatus& operator=(const sds2hmi_fi_tcl_DeviceStatus& coRef);
   sds2hmi_fi_tcl_DeviceStatus(const sds2hmi_fi_tcl_DeviceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceID;
   sds2hmi_fi_tclString UUID;
   sds2hmi_fi_tclString DeviceName;
   sds2hmi_fi_tcl_e8_DeviceStatus Status;
   sds2hmi_fi_tcl_e8_MPL_SourceType Type;
   virtual ~sds2hmi_fi_tcl_DeviceStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_DeviceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_TunerEntry : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_TunerEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_TunerEntry& operator=(const sds2hmi_fi_tcl_TunerEntry& coRef);
   sds2hmi_fi_tcl_TunerEntry(const sds2hmi_fi_tcl_TunerEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   sds2hmi_fi_tclString Title;
   sds2hmi_fi_tclString Channel;
   virtual ~sds2hmi_fi_tcl_TunerEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_TunerEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_Userword : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_Userword();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_Userword& operator=(const sds2hmi_fi_tcl_Userword& coRef);
   sds2hmi_fi_tcl_Userword(const sds2hmi_fi_tcl_Userword& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 UWProfile;
   sds2hmi_fi_tcl_SDSLanguageID LanguageID;
   std::vector<tU32, std::allocator<tU32> > PhoneUWs;
   std::vector<tU32, std::allocator<tU32> > TunerUWs;
   std::vector<tU32, std::allocator<tU32> > NaviUWs;
   virtual ~sds2hmi_fi_tcl_Userword();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_Userword& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_LanguageAndSpeaker : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_LanguageAndSpeaker();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_LanguageAndSpeaker& operator=(const sds2hmi_fi_tcl_LanguageAndSpeaker& coRef);
   sds2hmi_fi_tcl_LanguageAndSpeaker(const sds2hmi_fi_tcl_LanguageAndSpeaker& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SpeakerId;
   sds2hmi_fi_tclString Speaker;
   sds2hmi_fi_tcl_SDSLanguageID LanguageID;
   sds2hmi_fi_tcl_e8_Gender Gender;
   tBool ASRsupported;
   virtual ~sds2hmi_fi_tcl_LanguageAndSpeaker();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_LanguageAndSpeaker& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_MediaData : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_MediaData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_MediaData& operator=(const sds2hmi_fi_tcl_MediaData& coRef);
   sds2hmi_fi_tcl_MediaData(const sds2hmi_fi_tcl_MediaData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_MediaDataType DataType;
   sds2hmi_fi_tclString DataValue;
   virtual ~sds2hmi_fi_tcl_MediaData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_MediaData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_MediaEntry : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_MediaEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_MediaEntry& operator=(const sds2hmi_fi_tcl_MediaEntry& coRef);
   sds2hmi_fi_tcl_MediaEntry(const sds2hmi_fi_tcl_MediaEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   std::vector<sds2hmi_fi_tcl_MediaData, std::allocator<sds2hmi_fi_tcl_MediaData> > Data;
   virtual ~sds2hmi_fi_tcl_MediaEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_MediaEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_DeviceDatabase : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_DeviceDatabase();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_DeviceDatabase& operator=(const sds2hmi_fi_tcl_DeviceDatabase& coRef);
   sds2hmi_fi_tcl_DeviceDatabase(const sds2hmi_fi_tcl_DeviceDatabase& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceID;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > Database;
   virtual ~sds2hmi_fi_tcl_DeviceDatabase();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_DeviceDatabase& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_CON_AmbiguityResultEntry : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_CON_AmbiguityResultEntry();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_CON_AmbiguityResultEntry& operator=(const sds2hmi_fi_tcl_CON_AmbiguityResultEntry& coRef);
   sds2hmi_fi_tcl_CON_AmbiguityResultEntry(const sds2hmi_fi_tcl_CON_AmbiguityResultEntry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PHN_NumberType LocationType;
   tU32 ContactID;
   sds2hmi_fi_tclString DisplayString;
   virtual ~sds2hmi_fi_tcl_CON_AmbiguityResultEntry();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_CON_AmbiguityResultEntry& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_StringIDPair : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_StringIDPair();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_StringIDPair& operator=(const sds2hmi_fi_tcl_StringIDPair& coRef);
   sds2hmi_fi_tcl_StringIDPair(const sds2hmi_fi_tcl_StringIDPair& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   sds2hmi_fi_tclString String;
   virtual ~sds2hmi_fi_tcl_StringIDPair();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_StringIDPair& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_e8_MediaType : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_e8_MediaType();

   enum tenType {
      FI_EN_UNKNOWN = 0UL,
      FI_EN_MEDIAOBJECTID = 1UL,
      FI_EN_DRIVEID = 2UL
   };
   tenType enType;
   virtual ~sds2hmi_fi_tcl_e8_MediaType();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   inline tBool operator==(const sds2hmi_fi_tcl_e8_MediaType& roRef) const
      {  return (enType == roRef.enType);  }
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_TypedMediaID : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_TypedMediaID();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_TypedMediaID& operator=(const sds2hmi_fi_tcl_TypedMediaID& coRef);
   sds2hmi_fi_tcl_TypedMediaID(const sds2hmi_fi_tcl_TypedMediaID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   sds2hmi_fi_tcl_e8_MediaType MediaType;
   virtual ~sds2hmi_fi_tcl_TypedMediaID();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_TypedMediaID& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_MediaIDString : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_MediaIDString();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_MediaIDString& operator=(const sds2hmi_fi_tcl_MediaIDString& coRef);
   sds2hmi_fi_tcl_MediaIDString(const sds2hmi_fi_tcl_MediaIDString& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ID;
   sds2hmi_fi_tcl_e8_MediaType MediaType;
   sds2hmi_fi_tclString String;
   virtual ~sds2hmi_fi_tcl_MediaIDString();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_MediaIDString& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SDS_SettingsUnion : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SDS_SettingsUnion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SDS_SettingsUnion& operator=(const sds2hmi_fi_tcl_SDS_SettingsUnion& coRef);
   sds2hmi_fi_tcl_SDS_SettingsUnion(const sds2hmi_fi_tcl_SDS_SettingsUnion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDS_ParameterType ParameterType;
   fi_tclTypeBase* poParameterData;
   virtual ~sds2hmi_fi_tcl_SDS_SettingsUnion();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SDS_SettingsUnion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SDS_SettingsRequest : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SDS_SettingsRequest();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SDS_SettingsRequest& operator=(const sds2hmi_fi_tcl_SDS_SettingsRequest& coRef);
   sds2hmi_fi_tcl_SDS_SettingsRequest(const sds2hmi_fi_tcl_SDS_SettingsRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDSSettings Setting;
   sds2hmi_fi_tcl_SDS_SettingsUnion Value;
   virtual ~sds2hmi_fi_tcl_SDS_SettingsRequest();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SDS_SettingsRequest& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SDS_Settings : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SDS_Settings();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SDS_Settings& operator=(const sds2hmi_fi_tcl_SDS_Settings& coRef);
   sds2hmi_fi_tcl_SDS_Settings(const sds2hmi_fi_tcl_SDS_Settings& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDSSettings Setting;
   sds2hmi_fi_tcl_SDS_SettingsUnion Value;
   sds2hmi_fi_tcl_e8_SettingsError State;
   virtual ~sds2hmi_fi_tcl_SDS_Settings();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SDS_Settings& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NeighboringLocation : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NeighboringLocation();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NeighboringLocation& operator=(const sds2hmi_fi_tcl_NeighboringLocation& coRef);
   sds2hmi_fi_tcl_NeighboringLocation(const sds2hmi_fi_tcl_NeighboringLocation& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_LocationType CriteriaByPosition;
   sds2hmi_fi_tcl_e16_SelectionCriterionType LocationByGroup;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > LocationList;
   virtual ~sds2hmi_fi_tcl_NeighboringLocation();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NeighboringLocation& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SpecialAppAndStatus : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SpecialAppAndStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SpecialAppAndStatus& operator=(const sds2hmi_fi_tcl_SpecialAppAndStatus& coRef);
   sds2hmi_fi_tcl_SpecialAppAndStatus(const sds2hmi_fi_tcl_SpecialAppAndStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SpecialAppId SplAppId;
   sds2hmi_fi_tcl_e8_SpecialAppStatus SplAppStatus;
   virtual ~sds2hmi_fi_tcl_SpecialAppAndStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SpecialAppAndStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_HMIElementDescription : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_HMIElementDescription();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_HMIElementDescription& operator=(const sds2hmi_fi_tcl_HMIElementDescription& coRef);
   sds2hmi_fi_tcl_HMIElementDescription(const sds2hmi_fi_tcl_HMIElementDescription& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_WordType DescriptorTag;
   sds2hmi_fi_tclString DescriptorValue;
   tU32 DescriptorId;
   std::vector<sds2hmi_fi_tcl_NDSID, std::allocator<sds2hmi_fi_tcl_NDSID> > DestinationIdList;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > PhonemeList;
   virtual ~sds2hmi_fi_tcl_HMIElementDescription();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_HMIElementDescription& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_Nav_IconSetting : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_Nav_IconSetting();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_Nav_IconSetting& operator=(const sds2hmi_fi_tcl_Nav_IconSetting& coRef);
   sds2hmi_fi_tcl_Nav_IconSetting(const sds2hmi_fi_tcl_Nav_IconSetting& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_IconDisplayAction DisplayAction;
   sds2hmi_fi_tclString CategoryString;
   sds2hmi_fi_tcl_e16_SelectionCriterionType CategoryPredefined;
   virtual ~sds2hmi_fi_tcl_Nav_IconSetting();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_Nav_IconSetting& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_HMIElementDescrptionList : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_HMIElementDescrptionList();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_HMIElementDescrptionList& operator=(const sds2hmi_fi_tcl_HMIElementDescrptionList& coRef);
   sds2hmi_fi_tcl_HMIElementDescrptionList(const sds2hmi_fi_tcl_HMIElementDescrptionList& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_HMIElementDescription, std::allocator<sds2hmi_fi_tcl_HMIElementDescription> > DescriptionList;
   virtual ~sds2hmi_fi_tcl_HMIElementDescrptionList();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_HMIElementDescrptionList& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_CoreSpeechParameter : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_CoreSpeechParameter();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_CoreSpeechParameter& operator=(const sds2hmi_fi_tcl_CoreSpeechParameter& coRef);
   sds2hmi_fi_tcl_CoreSpeechParameter(const sds2hmi_fi_tcl_CoreSpeechParameter& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_CoreSpeechParameters CoreSpeechParameter;
   sds2hmi_fi_tclString Value;
   virtual ~sds2hmi_fi_tcl_CoreSpeechParameter();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_CoreSpeechParameter& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_Action_AdditionalInfo : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_Action_AdditionalInfo();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_Action_AdditionalInfo& operator=(const sds2hmi_fi_tcl_Action_AdditionalInfo& coRef);
   sds2hmi_fi_tcl_Action_AdditionalInfo(const sds2hmi_fi_tcl_Action_AdditionalInfo& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_ActionInfoCategory ActionInfoCategory;
   tU32 InfoValue;
   sds2hmi_fi_tclString InfoString;
   std::vector<sds2hmi_fi_tcl_NDSID, std::allocator<sds2hmi_fi_tcl_NDSID> > DestinationIdList;
   virtual ~sds2hmi_fi_tcl_Action_AdditionalInfo();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_Action_AdditionalInfo& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_RegionMetaData : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_RegionMetaData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_RegionMetaData& operator=(const sds2hmi_fi_tcl_RegionMetaData& coRef);
   sds2hmi_fi_tcl_RegionMetaData(const sds2hmi_fi_tcl_RegionMetaData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 RegionMetaDataId;
   sds2hmi_fi_tclString ISO_CountryCodeTxt;
   sds2hmi_fi_tclString ISO_SubCountryCodeTxt;
   virtual ~sds2hmi_fi_tcl_RegionMetaData();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_RegionMetaData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_MetaData : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_MetaData();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_MetaData& operator=(const sds2hmi_fi_tcl_MetaData& coRef);
   sds2hmi_fi_tcl_MetaData(const sds2hmi_fi_tcl_MetaData& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool HasPhonetic;
   sds2hmi_fi_tcl_e8NDSPhoneticTranscriptionFormat PhoneticTranscriptionFormat;
   virtual ~sds2hmi_fi_tcl_MetaData();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_MetaData& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_BuildingBlock : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_BuildingBlock();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_BuildingBlock& operator=(const sds2hmi_fi_tcl_BuildingBlock& coRef);
   sds2hmi_fi_tcl_BuildingBlock(const sds2hmi_fi_tcl_BuildingBlock& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 BuildingBlockId;
   tU16 BuildingBlockType;
   sds2hmi_fi_tclString Path;
   tU32 EncryptionKeyId;
   sds2hmi_fi_tcl_MetaData MetaData;
   tU8 TypeNDSSupplierId;
   tU32 TypeExtId;
   virtual ~sds2hmi_fi_tcl_BuildingBlock();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_BuildingBlock& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_UpdateRegion : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_UpdateRegion();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_UpdateRegion& operator=(const sds2hmi_fi_tcl_UpdateRegion& coRef);
   sds2hmi_fi_tcl_UpdateRegion(const sds2hmi_fi_tcl_UpdateRegion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 UpdateRegionId;
   std::vector<sds2hmi_fi_tcl_BuildingBlock, std::allocator<sds2hmi_fi_tcl_BuildingBlock> > BuilidingBlockList;
   std::vector<sds2hmi_fi_tcl_RegionMetaData, std::allocator<sds2hmi_fi_tcl_RegionMetaData> > RegionMetaDataList;
   virtual ~sds2hmi_fi_tcl_UpdateRegion();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_UpdateRegion& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SDSProduct : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SDSProduct();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SDSProduct& operator=(const sds2hmi_fi_tcl_SDSProduct& coRef);
   sds2hmi_fi_tcl_SDSProduct(const sds2hmi_fi_tcl_SDSProduct& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SupplierId;
   tU32 ProductId;
   std::vector<sds2hmi_fi_tcl_UpdateRegion, std::allocator<sds2hmi_fi_tcl_UpdateRegion> > UpdateregionList;
   std::vector<sds2hmi_fi_tcl_NDSLanguageID, std::allocator<sds2hmi_fi_tcl_NDSLanguageID> > NDSLanguageList;
   virtual ~sds2hmi_fi_tcl_SDSProduct();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SDSProduct& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_NDSLocationDetails : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_NDSLocationDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_NDSLocationDetails& operator=(const sds2hmi_fi_tcl_NDSLocationDetails& coRef);
   sds2hmi_fi_tcl_NDSLocationDetails(const sds2hmi_fi_tcl_NDSLocationDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_NDSID, std::allocator<sds2hmi_fi_tcl_NDSID> > CountryNDSIdList;
   std::vector<sds2hmi_fi_tcl_NDSID, std::allocator<sds2hmi_fi_tcl_NDSID> > StateNDSIdList;
   std::vector<sds2hmi_fi_tcl_NDSID, std::allocator<sds2hmi_fi_tcl_NDSID> > CityNDSIdList;
   sds2hmi_fi_tcl_NDSID CityNDSId;
   virtual ~sds2hmi_fi_tcl_NDSLocationDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_NDSLocationDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_Info_Menu_Srvice_Status : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_Info_Menu_Srvice_Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_Info_Menu_Srvice_Status& operator=(const sds2hmi_fi_tcl_Info_Menu_Srvice_Status& coRef);
   sds2hmi_fi_tcl_Info_Menu_Srvice_Status(const sds2hmi_fi_tcl_Info_Menu_Srvice_Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_Info_SXM_Services ServiceMenu;
   sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status Status;
   virtual ~sds2hmi_fi_tcl_Info_Menu_Srvice_Status();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_Info_Menu_Srvice_Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_RecResult : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_RecResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_RecResult& operator=(const sds2hmi_fi_tcl_RecResult& coRef);
   sds2hmi_fi_tcl_RecResult(const sds2hmi_fi_tcl_RecResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 CommandId;
   sds2hmi_fi_tclString RecognizedString;
   tU32 Confidence;
   virtual ~sds2hmi_fi_tcl_RecResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_RecResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_ConfThresholdSet : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_ConfThresholdSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_ConfThresholdSet& operator=(const sds2hmi_fi_tcl_ConfThresholdSet& coRef);
   sds2hmi_fi_tcl_ConfThresholdSet(const sds2hmi_fi_tcl_ConfThresholdSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 HCT;
   tU32 LCT;
   tU32 HCD;
   tU32 MCD;
   virtual ~sds2hmi_fi_tcl_ConfThresholdSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_ConfThresholdSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_DestinationAndLanguageDetails : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_DestinationAndLanguageDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_DestinationAndLanguageDetails& operator=(const sds2hmi_fi_tcl_DestinationAndLanguageDetails& coRef);
   sds2hmi_fi_tcl_DestinationAndLanguageDetails(const sds2hmi_fi_tcl_DestinationAndLanguageDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDSDestinationType DestinationType;
   sds2hmi_fi_tcl_SDSLanguageID Language;
   virtual ~sds2hmi_fi_tcl_DestinationAndLanguageDetails();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_DestinationAndLanguageDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_SharedDataAccessAttributes : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_SharedDataAccessAttributes();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_SharedDataAccessAttributes& operator=(const sds2hmi_fi_tcl_SharedDataAccessAttributes& coRef);
   sds2hmi_fi_tcl_SharedDataAccessAttributes(const sds2hmi_fi_tcl_SharedDataAccessAttributes& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SharedDataAccess SharedDataAccess;
   sds2hmi_fi_tcl_e8_JournalingMode JournalingMode;
   sds2hmi_fi_tcl_e8_LockType LockType;
   virtual ~sds2hmi_fi_tcl_SharedDataAccessAttributes();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_SharedDataAccessAttributes& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_DestinationElement : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_DestinationElement();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_DestinationElement& operator=(const sds2hmi_fi_tcl_DestinationElement& coRef);
   sds2hmi_fi_tcl_DestinationElement(const sds2hmi_fi_tcl_DestinationElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDSDestinationType DestinationItemType;
   sds2hmi_fi_tcl_SDSLanguageID Language;
   sds2hmi_fi_tclString DestinationItem;
   virtual ~sds2hmi_fi_tcl_DestinationElement();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_DestinationElement& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_DestinationItem : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_DestinationItem();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_DestinationItem& operator=(const sds2hmi_fi_tcl_DestinationItem& coRef);
   sds2hmi_fi_tcl_DestinationItem(const sds2hmi_fi_tcl_DestinationItem& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_DestinationElement, std::allocator<sds2hmi_fi_tcl_DestinationElement> > DestinationItem;
   virtual ~sds2hmi_fi_tcl_DestinationItem();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_DestinationItem& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

class sds2hmi_fi_tcl_ValidatedDestinationDetails : public sds2hmi_fi_tclVisitableTypeBase
{
public:

   sds2hmi_fi_tcl_ValidatedDestinationDetails();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_fi_tcl_ValidatedDestinationDetails& operator=(const sds2hmi_fi_tcl_ValidatedDestinationDetails& coRef);
   sds2hmi_fi_tcl_ValidatedDestinationDetails(const sds2hmi_fi_tcl_ValidatedDestinationDetails& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDSDestinationType DestinationItemType;
   sds2hmi_fi_tclString DestinationItem;
   virtual ~sds2hmi_fi_tcl_ValidatedDestinationDetails();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_fi_tcl_ValidatedDestinationDetails& roRef) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(sds2hmi_fi_tclVisitorBase& rfoVisitor);
};

#endif
