/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef SDS2HMI_SDSFITYPES_HEADER
#define SDS2HMI_SDSFITYPES_HEADER


class sds2hmi_sdsfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for sds2hmi_sds_fi message types

fi_tclMessageBase* sds2hmi_sdsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class sds2hmi_sdsfi_tclMsgBaseMessage : public sds2hmi_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   sds2hmi_sdsfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PopUp_UpdateType nPopUp_UpDateType;
   sds2hmi_fi_tclString sXMLStream;
   virtual ~sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& operator=(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 nListCount;
   sds2hmi_fi_tcl_b8_PopUp_ResultOptions nResultOptions;
   tU16 nPageNumber;
   sds2hmi_fi_tcl_e8_MainDomains NextDomain;
   sds2hmi_fi_tcl_e8_MainDomains PrevDomain;
   tU32 CurrentFocus;
   virtual ~sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PopUp_ListType nListType;
   tU32 nLine;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& operator=(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 nLine;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_Application ApplicationId;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_LanguageAndSpeaker, std::allocator<sds2hmi_fi_tcl_LanguageAndSpeaker> > LanguageAndSpeaker;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_Userword, std::allocator<sds2hmi_fi_tcl_Userword> > AvailableUserwords;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart(const sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU64 TimeStamp;
   sds2hmi_fi_tcl_e8_EventForLogging Event;
   sds2hmi_fi_tclString EventValue;
   std::vector<sds2hmi_fi_tcl_RecResult, std::allocator<sds2hmi_fi_tcl_RecResult> > SpeechCommandList;
   sds2hmi_fi_tcl_e8_LOG_ConfidenceThreshold CommandConfidence;
   sds2hmi_fi_tclString GrammarOrSlmID;
   sds2hmi_fi_tcl_ConfThresholdSet CurrentConfThreshold;
   sds2hmi_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart(const sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_SDS_Settings, std::allocator<sds2hmi_fi_tcl_SDS_Settings> > Settings;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_HMI_ListType ListType;
   virtual ~sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& operator=(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_HMI_ListSize ListSize;
   virtual ~sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart(const sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TUN_Band Band;
   sds2hmi_fi_tcl_e8_TUN_SelectionType SelectionType;
   sds2hmi_fi_tclString Frequency;
   tU32 Value;
   virtual ~sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart(const sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TUN_Band Band;
   sds2hmi_fi_tcl_e8_TUN_MemBank MemBank;
   virtual ~sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart(const sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TUN_Setting nTunerSetting;
   virtual ~sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart(const sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nPreset;
   virtual ~sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart(const sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TUN_Band nBand;
   virtual ~sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TUN_Band Band;
   tU32 FirstID;
   tU32 MaxNumberOfEntries;
   virtual ~sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_TunerEntry, std::allocator<sds2hmi_fi_tcl_TunerEntry> > ListEntries;
   tBool NoMoreEntries;
   virtual ~sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult(const sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_DeviceDatabase, std::allocator<sds2hmi_fi_tcl_DeviceDatabase> > Devices;
   virtual ~sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU32, std::allocator<tU32> > ValueIDs;
   virtual ~sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& operator=(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StringIDPair, std::allocator<sds2hmi_fi_tcl_StringIDPair> > AmbiguousEntries;
   virtual ~sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PhoneID;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   sds2hmi_fi_tclString sPhoneNumber;
   tU16 nIDValue;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PHN_ListType nListEntryType;
   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   tU16 nNumberOfEntries;
   tU16 nCurrentFirstID;
   tU16 nCurrentLastID;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_PhoneEntry, std::allocator<sds2hmi_fi_tcl_PhoneEntry> > tPhoneBookEntries;
   tU16 nNumberOfEntries;
   tBool bNoMoreEntries;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString sPhoneNumber;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& operator=(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nMemoryID;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart(const sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nMemoryID;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PHN_Setting nPhoneSetting;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_DeviceDatabase, std::allocator<sds2hmi_fi_tcl_DeviceDatabase> > Devices;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart(const sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ContactID;
   sds2hmi_fi_tcl_e8_PHN_NumberType LocationType;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart(const sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PHN_MenuType nMenuType;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString nDTMFDigits;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PHN_SelectionType SelectionType;
   tU32 ValueID;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 nUswID;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& operator=(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString sResult;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaPlayMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaPlayMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& operator=(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgMediaPlayMethodStart(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DriveID;
   sds2hmi_fi_tcl_e8_GEN_SelectionType SelectionType;
   sds2hmi_fi_tcl_e8_PlayAction Action;
   std::vector<tU32, std::allocator<tU32> > ValueIDs;
   sds2hmi_fi_tcl_e8_MPL_ListType MediaListType;
   virtual ~sds2hmi_sdsfi_tclMsgMediaPlayMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaPlayMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaPlayMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgMediaPlayMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgMediaPlayMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& operator=(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceID;
   virtual ~sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& operator=(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceID;
   sds2hmi_fi_tclString Filename;
   virtual ~sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_TypedMediaID, std::allocator<sds2hmi_fi_tcl_TypedMediaID> > ValueIDs;
   virtual ~sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& operator=(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_MediaIDString, std::allocator<sds2hmi_fi_tcl_MediaIDString> > AmbiguousEntries;
   virtual ~sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& operator=(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DeviceID;
   tU32 Slot;
   virtual ~sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& operator=(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_MPL_SourceType DeviceType;
   tU32 NumberOfTracks;
   virtual ~sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_ZoomAction ZoomAction;
   sds2hmi_fi_tcl_e8_NAV_ZoomLevel ZoomLevel;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_e8_NAV_RouteCriteria, std::allocator<sds2hmi_fi_tcl_e8_NAV_RouteCriteria> > tRouteOptions;
   sds2hmi_fi_tcl_e8_NAV_Setting nDynRGState;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_RouteCriteria tRouteOptions;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_Setting nNavSetting;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart(const sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_MenuType nMenuType;
   virtual ~sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_TBT_Symbols nTBTSymbols;
   sds2hmi_fi_tcl_e8_NAV_AutoZoom nAutoZoom;
   sds2hmi_fi_tcl_e8_NAV_MapMode nMapMode;
   sds2hmi_fi_tcl_e8_NAV_MapOrientation nMapOrientation;
   sds2hmi_fi_tcl_e8_NAV_MapView nMapView;
   sds2hmi_fi_tcl_Nav_IconSetting IconSetting;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_TBT_Symbols nTBTSymbols;
   sds2hmi_fi_tcl_e8_NAV_AutoZoom nAutoZoom;
   sds2hmi_fi_tcl_e8_NAV_MapMode nMapMode;
   sds2hmi_fi_tcl_e8_NAV_MapOrientation nMapOrientation;
   sds2hmi_fi_tcl_e8_NAV_MapView nMapView;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_ListType nListEntryType;
   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   tU32 nReferenceID;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_HMIElementDescription, std::allocator<sds2hmi_fi_tcl_HMIElementDescription> > tDestListEntries;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart(const sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   sds2hmi_fi_tcl_e8_NAV_ListType nListEntryType;
   tU32 nIDValue;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult(const sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 nPersistantMemoryID;
   virtual ~sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart(const sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 nPersistantMemoryID;
   virtual ~sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart(const sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDeleteCountry;
   virtual ~sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nNumberOfElements;
   sds2hmi_fi_tcl_LocationDescription tLocationDescription;
   std::vector<sds2hmi_fi_tcl_e16_SelectionCriterionType, std::allocator<sds2hmi_fi_tcl_e16_SelectionCriterionType> > tSelectionCriterionType;
   tBool bGuidancePossible;
   tBool bAmbiguous;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nNumberOfElements;
   sds2hmi_fi_tcl_LocationDescription tLocationDescription;
   sds2hmi_fi_tcl_e8_NAV_LocationType tLocationType;
   tU8 nAmbiguityAbsVal;
   sds2hmi_fi_tcl_SDSLanguageID VDESearchLanguage;
   std::vector<sds2hmi_fi_tcl_DestinationAndLanguageDetails, std::allocator<sds2hmi_fi_tcl_DestinationAndLanguageDetails> > VDESearchDetails;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nNumberOfElements;
   sds2hmi_fi_tcl_LocationDescription tLocationDescription;
   std::vector<sds2hmi_fi_tcl_e16_SelectionCriterionType, std::allocator<sds2hmi_fi_tcl_e16_SelectionCriterionType> > tSelectionCriterionType;
   sds2hmi_fi_tcl_b16_AnsOptions nAnswerOptions;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_SelectionCriterionType tSelectionCriterionType;
   sds2hmi_fi_tcl_LocationDescription tLocationDescription;
   tU16 nLimit;
   tU16 nListOffset;
   sds2hmi_fi_tcl_b8_ListSortOptions nSortOption;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nNumberOfElements;
   sds2hmi_fi_tcl_b8_ListResultOptions nNextOptions;
   sds2hmi_fi_tcl_LocationValueListUnion tAmbiguities;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart(const sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TMCListContent nListContent;
   virtual ~sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart(const sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_UPOI_Source nPoiSource;
   sds2hmi_fi_tcl_e8_NAV_POIListType nListContent;
   tU8 nValue;
   virtual ~sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_UPOI_Source nPoiSource;
   sds2hmi_fi_tcl_e8_NAV_POIListType nListContent;
   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   tU16 nNumberOfEntries;
   tU32 nCurrentFirstID;
   tU32 nCurrentLastID;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > sListEntries;
   tBool bNoMoreEntries;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TMCListContent nListEntryType;
   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   tU16 nNumberOfEntries;
   tU32 nCurrentFirstID;
   tU32 nCurrentLastID;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_TmcEntry, std::allocator<sds2hmi_fi_tcl_TmcEntry> > tTmcListEntries;
   tBool bNoMoreEntries;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart(const sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TMCListContent nListEntryType;
   tU32 nIDValue;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ContactID;
   sds2hmi_fi_tcl_e8_PHN_NumberType LocationType;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult(const sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool nWaypointMustBeDeleted;
   virtual ~sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   sds2hmi_fi_tclString sFirst;
   sds2hmi_fi_tclString sLast;
   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > PatternList;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bWaypointMustBeDeleted;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart(const sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nNumberOfElements;
   sds2hmi_fi_tcl_LocationDescription tLocationDescription;
   sds2hmi_fi_tcl_e8_NAV_LocationType tLocationType;
   virtual ~sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& operator=(const sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart(const sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 ContactID;
   sds2hmi_fi_tcl_e8_PHN_NumberType LocationType;
   virtual ~sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart(const sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 nNumberOfElements;
   sds2hmi_fi_tcl_LocationDescription tLocationDescription;
   sds2hmi_fi_tcl_e8_NAV_LocationType tLocationType;
   virtual ~sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& operator=(const sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult(const sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool nMoreThanOne;
   tBool nFirstSMS;
   tBool nLastSMS;
   sds2hmi_fi_tclString sNameSender;
   sds2hmi_fi_tclString sAdditionalInformation;
   sds2hmi_fi_tclString sPhoneNumberSender;
   std::vector<sds2hmi_fi_tcl_ContactData, std::allocator<sds2hmi_fi_tcl_ContactData> > ContactIDs;
   virtual ~sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart(const sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_GEN_SelectionType SelectionType;
   tU32 nContentID;
   sds2hmi_fi_tclString Message;
   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart(const sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   tU32 ValueID;
   sds2hmi_fi_tclString sPhoneNumber;
   sds2hmi_fi_tcl_e8_PHN_NumberType ContactLocation;
   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart(const sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_GEN_SelectionType nSelectionType;
   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_CON_EntryType EntryType;
   sds2hmi_fi_tcl_e8_PHN_NumberType LocationType;
   std::vector<tU32, std::allocator<tU32> > ContactIDs;
   tBool RequireAllLocationIfNoExactMatch;
   virtual ~sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& operator=(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_CON_AmbiguityListType ResultType;
   std::vector<sds2hmi_fi_tcl_CON_AmbiguityResultEntry, std::allocator<sds2hmi_fi_tcl_CON_AmbiguityResultEntry> > ResultEntries;
   virtual ~sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& operator=(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_Info_Menu eMenu;
   sds2hmi_fi_tclString Param;
   virtual ~sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult(const sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_DeviceDatabase, std::allocator<sds2hmi_fi_tcl_DeviceDatabase> > Slots;
   virtual ~sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart(const sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString sAppName;
   tU32 AppId;
   virtual ~sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_Domain Domain;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 Radius;
   sds2hmi_fi_tcl_LocationDescription LocationDescription;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tclString, std::allocator<sds2hmi_fi_tclString> > NearbyStateList;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_HMIElementDescriptorMode DescriptionMode;
   sds2hmi_fi_tcl_e8_HMIElementReference ElementReference;
   tU32 HMIId;
   virtual ~sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_HMIElementDescription, std::allocator<sds2hmi_fi_tcl_HMIElementDescription> > Description;
   virtual ~sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& operator=(const sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult(const sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString TxtMessage;
   virtual ~sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_HMI_ListType ListType;
   virtual ~sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList, std::allocator<sds2hmi_fi_tcl_HMIElementDescrptionList> > DescriptionList;
   virtual ~sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart(const sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PhBook_Update_Action Action;
   sds2hmi_fi_tclString ContactInfo;
   tU32 UniqueId;
   sds2hmi_fi_tcl_e8_PHN_NumberType NumberType;
   sds2hmi_fi_tcl_e16_PHN_Relationship Relationship;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_HMIElementDescription, std::allocator<sds2hmi_fi_tcl_HMIElementDescription> > SearchString;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_LocationType SearchLocation;
   virtual ~sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_Common_SDS_Evnt SDS_Event;
   tU32 Val_Num;
   sds2hmi_fi_tclString Val_Str;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& operator=(const sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart(const sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TUN_SelectionType SelectionBy;
   tU32 Val_Id;
   sds2hmi_fi_tclString Val_Name;
   virtual ~sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSLanguageID NDSLanguageID;
   std::vector<sds2hmi_fi_tcl_NDSID, std::allocator<sds2hmi_fi_tcl_NDSID> > CityIdList;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StreetAvailability, std::allocator<sds2hmi_fi_tcl_StreetAvailability> > StreetAvailabilityList;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_NDSLanguageID, std::allocator<sds2hmi_fi_tcl_NDSLanguageID> > NDSLanguageIDList;
   std::vector<sds2hmi_fi_tcl_NDSID, std::allocator<sds2hmi_fi_tcl_NDSID> > IdList;
   tBool GetString;
   tBool GetPhoneme;
   sds2hmi_fi_tcl_b8_StringPhonemeSearchSetting SearchSetting;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_StringAndPhoneme, std::allocator<sds2hmi_fi_tcl_StringAndPhoneme> > StringPhonemeList;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DataSetId;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString Device;
   sds2hmi_fi_tclString PersistentDataSetId;
   std::vector<sds2hmi_fi_tcl_SDSProduct, std::allocator<sds2hmi_fi_tcl_SDSProduct> > SDSProductList;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DataSetId;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_RegistrationAndDeRegistrationStatus Status;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_NDSLanguageID NDSLanguageID;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_CountryPhoneme, std::allocator<sds2hmi_fi_tcl_CountryPhoneme> > CountryStateList;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& operator=(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString PhoneNumber;
   sds2hmi_fi_tcl_SDSLanguageID Language;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& operator=(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString FormatttedPhoneNumber;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& operator=(const sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart(const sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_HMI_ListType ListType;
   virtual ~sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& operator=(const sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart(const sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_Info_SXM_Services ServiceType;
   virtual ~sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart(const sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString Distance;
   sds2hmi_fi_tcl_e8_Distance_Unit Unit;
   virtual ~sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart(const sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DataSetId;
   sds2hmi_fi_tcl_e8_NDSDataAccessType DataAccessType;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& operator=(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& coRef);
   sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_SDSLanguageID VDESearchLanguage;
   std::vector<sds2hmi_fi_tcl_DestinationItem, std::allocator<sds2hmi_fi_tcl_DestinationItem> > VDEList;
   virtual ~sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& operator=(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& coRef);
   sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_DestinationElement, std::allocator<sds2hmi_fi_tcl_DestinationElement> > InvalidList;
   virtual ~sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_StatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_StatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgSDS_StatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_StatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_StatusSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_StatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgSDS_StatusSet& operator=(const sds2hmi_sdsfi_tclMsgSDS_StatusSet& coRef);
   sds2hmi_sdsfi_tclMsgSDS_StatusSet(const sds2hmi_sdsfi_tclMsgSDS_StatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDS_Status State;
   virtual ~sds2hmi_sdsfi_tclMsgSDS_StatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_StatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_StatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_StatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgSDS_StatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_StatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_StatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_StatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgSDS_StatusStatus& operator=(const sds2hmi_sdsfi_tclMsgSDS_StatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgSDS_StatusStatus(const sds2hmi_sdsfi_tclMsgSDS_StatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SDS_Status State;
   virtual ~sds2hmi_sdsfi_tclMsgSDS_StatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_StatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet();

   virtual ~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& operator=(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& coRef);
   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SpeakerId;
   virtual ~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& operator=(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& coRef);
   sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 SpeakerId;
   virtual ~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonActionRequestGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonActionRequestGet();

   virtual ~sds2hmi_sdsfi_tclMsgCommonActionRequestGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonActionRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonActionRequestStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonActionRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& operator=(const sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& coRef);
   sds2hmi_sdsfi_tclMsgCommonActionRequestStatus(const sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_Action Action;
   tU32 Value;
   std::vector<sds2hmi_fi_tcl_Action_AdditionalInfo, std::allocator<sds2hmi_fi_tcl_Action_AdditionalInfo> > AdditionalInfoList;
   virtual ~sds2hmi_sdsfi_tclMsgCommonActionRequestStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgCommonStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgCommonStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgCommonStatusStatus(const sds2hmi_sdsfi_tclMsgCommonStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_GLOBAL_Status Status;
   sds2hmi_fi_tcl_e8_Application ApplicationId;
   tBool IsVehicleMoving;
   sds2hmi_fi_tclString FeatureConfiguration;
   tBool IsSearchServiceAvailable;
   tBool TCUAvialable;
   tBool SportsServiceAvailable;
   virtual ~sds2hmi_sdsfi_tclMsgCommonStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgMediaStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgMediaStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgMediaStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgMediaStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgMediaStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgMediaStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgMediaStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgMediaStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgMediaStatusStatus(const sds2hmi_sdsfi_tclMsgMediaStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_MPL_Status Status;
   sds2hmi_fi_tcl_e8_MPL_MenuType MenuType;
   sds2hmi_fi_tcl_e8_MPL_SourceType SourceType;
   tU32 SourceId;
   std::vector<sds2hmi_fi_tcl_DeviceStatus, std::allocator<sds2hmi_fi_tcl_DeviceStatus> > DeviceList;
   virtual ~sds2hmi_sdsfi_tclMsgMediaStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgMediaStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStatusSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviStatusSet& operator=(const sds2hmi_sdsfi_tclMsgNaviStatusSet& coRef);
   sds2hmi_sdsfi_tclMsgNaviStatusSet(const sds2hmi_sdsfi_tclMsgNaviStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo VDEAvailInfo;
   virtual ~sds2hmi_sdsfi_tclMsgNaviStatusSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgNaviStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgNaviStatusStatus(const sds2hmi_sdsfi_tclMsgNaviStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NAV_Status Status;
   sds2hmi_fi_tcl_e8_NAV_MenuType MenuType;
   sds2hmi_fi_tcl_e8_NAV_NavUnit NavUnit;
   sds2hmi_fi_tcl_e8_NAV_VDEAvailInfo VDEAvailInfo;
   tBool DetourOn;
   virtual ~sds2hmi_sdsfi_tclMsgNaviStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgPhoneStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgPhoneStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgPhoneStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgPhoneStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgPhoneStatusStatus(const sds2hmi_sdsfi_tclMsgPhoneStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_PHN_Status Status;
   sds2hmi_fi_tcl_e8_PHN_MenuType MenuType;
   tU32 SourceId;
   std::vector<sds2hmi_fi_tcl_DeviceStatus, std::allocator<sds2hmi_fi_tcl_DeviceStatus> > DeviceList;
   tBool BTenabled;
   sds2hmi_fi_tcl_e8_PHN_Transorder TransorderType;
   tBool CarPlayAvailable;
   virtual ~sds2hmi_sdsfi_tclMsgPhoneStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgPhoneStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgTunerStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgTunerStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTunerStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTunerStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTunerStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgTunerStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgTunerStatusStatus(const sds2hmi_sdsfi_tclMsgTunerStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_TUN_Status Status;
   sds2hmi_fi_tcl_e8_TUN_Band Band;
   tU16 PresetNr;
   sds2hmi_fi_tclString StationName;
   std::vector<sds2hmi_fi_tcl_DeviceStatus, std::allocator<sds2hmi_fi_tcl_DeviceStatus> > DeviceList;
   virtual ~sds2hmi_sdsfi_tclMsgTunerStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTunerStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgWeatherStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgWeatherStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgWeatherStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgWeatherStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgWeatherStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgWeatherStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgWeatherStatusStatus(const sds2hmi_sdsfi_tclMsgWeatherStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_WEA_Status Status;
   sds2hmi_fi_tcl_e8_WEA_MenuType MenuType;
   virtual ~sds2hmi_sdsfi_tclMsgWeatherStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgWeatherStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& coRef);
   sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_ISOCountryCode Country;
   sds2hmi_fi_tclString State;
   sds2hmi_fi_tclString CountryName;
   sds2hmi_fi_tclString StateName;
   sds2hmi_fi_tclString CityName;
   sds2hmi_fi_tcl_NDSLocationDetails NDSLocationDetails;
   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& operator=(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& coRef);
   sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_ParameterAction Action;
   std::vector<sds2hmi_fi_tcl_SDS_SettingsRequest, std::allocator<sds2hmi_fi_tcl_SDS_SettingsRequest> > Settings;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgTextMsgStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgTextMsgStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgTextMsgStatusStatus(const sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_SMS_Status Status;
   tBool IsMsgAvailable;
   virtual ~sds2hmi_sdsfi_tclMsgTextMsgStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgVDLStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgVDLStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgVDLStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgVDLStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgVDLStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgVDLStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgVDLStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgVDLStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgVDLStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgVDLStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgVDLStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgVDLStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgVDLStatusStatus(const sds2hmi_sdsfi_tclMsgVDLStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_DeviceStatus, std::allocator<sds2hmi_fi_tcl_DeviceStatus> > Slots;
   virtual ~sds2hmi_sdsfi_tclMsgVDLStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgVDLStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& operator=(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& coRef);
   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_ConnectedDeviceStatus, std::allocator<sds2hmi_fi_tcl_ConnectedDeviceStatus> > ConnectedDeviceStatus;
   tU8 MediaState;
   std::vector<sds2hmi_fi_tcl_e8_Slot, std::allocator<sds2hmi_fi_tcl_e8_Slot> > e8Slot;
   virtual ~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_ConnectedDeviceStatus, std::allocator<sds2hmi_fi_tcl_ConnectedDeviceStatus> > ConnectedDeviceStatus;
   tU8 MediaState;
   std::vector<sds2hmi_fi_tcl_e8_Slot, std::allocator<sds2hmi_fi_tcl_e8_Slot> > e8Slot;
   virtual ~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& coRef);
   sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_NeighboringLocation, std::allocator<sds2hmi_fi_tcl_NeighboringLocation> > LocationList;
   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSpecialAppStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSpecialAppStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgSpecialAppStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSpecialAppStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus(const sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_SpecialAppAndStatus AppTypeAndStatus;
   virtual ~sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& operator=(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& coRef);
   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString Value;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& operator=(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& coRef);
   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tclString Value;
   virtual ~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet();

   virtual ~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& operator=(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& coRef);
   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_CoreSpeechParameter, std::allocator<sds2hmi_fi_tcl_CoreSpeechParameter> > CoreSpeechParameterList;
   virtual ~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& operator=(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& coRef);
   sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_CoreSpeechParameter, std::allocator<sds2hmi_fi_tcl_CoreSpeechParameter> > CoreSpeechParameterList;
   virtual ~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& operator=(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& coRef);
   sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e8_NDS_SDN_Status State;
   tU32 DataSetId;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet();

   virtual ~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& operator=(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_ECNR_ASR_Mode_Status ECNR_ASR_Status;
   virtual ~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet();

   virtual ~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet();

   virtual ~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& operator=(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& coRef);
   sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DataSize;
   std::vector<tU8, std::allocator<tU8> > DataList;
   virtual ~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoServiceStatusGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoServiceStatusGet();

   virtual ~sds2hmi_sdsfi_tclMsgInfoServiceStatusGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgInfoServiceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoServiceStatusSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoServiceStatusSet();

   virtual ~sds2hmi_sdsfi_tclMsgInfoServiceStatusSet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgInfoServiceStatusSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& operator=(const sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& coRef);
   sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus(const sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_Info_Menu_Srvice_Status, std::allocator<sds2hmi_fi_tcl_Info_Menu_Srvice_Status> > Info_Menu_StatusList;
   virtual ~sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviPOIIconListGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviPOIIconListGet();

   virtual ~sds2hmi_sdsfi_tclMsgNaviPOIIconListGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviPOIIconListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviPOIIconListSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviPOIIconListSet();

   virtual ~sds2hmi_sdsfi_tclMsgNaviPOIIconListSet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviPOIIconListSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& operator=(const sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& coRef);
   sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus(const sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<sds2hmi_fi_tcl_HMIElementDescription, std::allocator<sds2hmi_fi_tcl_HMIElementDescription> > DescriptionList;
   sds2hmi_fi_tcl_SDSLanguageID LanguageID;
   virtual ~sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& operator=(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& coRef);
   sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 DataSetId;
   sds2hmi_fi_tclString PersistentDataSetId;
   sds2hmi_fi_tcl_SharedDataAccessAttributes SharedDataAccessAttributes;
   virtual ~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& coRef);
   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_ISOCountryCode Country;
   sds2hmi_fi_tclString CountryName;
   sds2hmi_fi_tcl_SDSLanguageID VDELanguage;
   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg();

   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg();

   inline tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus : public sds2hmi_sdsfi_tclMsgBaseMessage
{
public:

   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& coRef);
   sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   sds2hmi_fi_tcl_e16_ISOCountryCode Country;
   sds2hmi_fi_tclString CountryName;
   sds2hmi_fi_tcl_SDSLanguageID VDELanguage;
   virtual ~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
