/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#include "precompiled.hh"
// =============================================================================
//
//                Factory for sds2hmi_sds_fi message types

fi_tclMessageBase* sds2hmi_sdsfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTARTSESSIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTARTSESSIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTOPSESSIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTOPSESSIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSHOWDIALOGMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSHOWDIALOGMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSELECTLISTELEMENTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSELECTLISTELEMENTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTELEMENTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTELEMENTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETACTIVEAPPLICATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETACTIVEAPPLICATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLESPEAKERSMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLESPEAKERSMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLEUSERWORDSMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLEUSERWORDSMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONINTERACTIONLOGGERMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONINTERACTIONLOGGERMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTINFOMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTINFOMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTSTATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTSTATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTBAND_MEMBANKMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTBAND_MEMBANKMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERAUTOSTOREMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERAUTOSTOREMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSETSETTINGMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSETSETTINGMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTORESTATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTORESTATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSHOWSTATIONLISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSHOWSTATIONLISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETLISTENTRIESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETLISTENTRIESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETDATABASESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETDATABASESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETAMBIGUITYLISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETAMBIGUITYLISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESELECTPHONEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESELECTPHONEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTARTPAIRINGMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTARTPAIRINGMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALNUMBERMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALNUMBERMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEREDIALLASTNUMBERMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEREDIALLASTNUMBERMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETCONTACTLISTENTRIESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETCONTACTLISTENTRIESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTORENUMBERMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTORENUMBERMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDELETENUMBERMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDELETENUMBERMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETPHONESETTINGMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETPHONESETTINGMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALVOICEMAILMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALVOICEMAILMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETDATABASESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETDATABASESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALCONTACTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALCONTACTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESHOWMENUMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESHOWMENUMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESENDDTMFDIGITSMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESENDDTMFDIGITSMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESWITCHCALLMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESWITCHCALLMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETCONTACTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETCONTACTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETNUMBERINFOMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETNUMBERINFOMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAPLAYMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaPlayMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAPLAYMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaPlayMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDATABASEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDATABASEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETAMBIGUITYLISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETAMBIGUITYLISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDEVICEINFOMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDEVICEINFOMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTGUIDANCEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTGUIDANCEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOPGUIDANCEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOPGUIDANCEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETZOOMSETTINGMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETZOOMSETTINGMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETROUTECRITERIAMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETROUTECRITERIAMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETROUTECRITERIAMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETROUTECRITERIAMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETNAVSETTINGMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETNAVSETTINGMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWNAVMENUMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWNAVMENUMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETMAPMODEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETMAPMODEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETMAPMODEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETMAPMODEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCONTACTLISTENTRIESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCONTACTLISTENTRIESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTDESTLISTENTRYMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTDESTLISTENTRYMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOREDESTINATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOREDESTINATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIDELETEDESTINATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIDELETEDESTINATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVINEWDESTINATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVINEWDESTINATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCURRENTDESTINATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCURRENTDESTINATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONITEMMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONITEMMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETAMBIGUITYLISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETAMBIGUITYLISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWTMCLISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWTMCLISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWPOILISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWPOILISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETPOICATEGORIESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETPOICATEGORIESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETTMCLISTENTRIESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETTMCLISTENTRIESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTTMCLISTENTRYMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTTMCLISTENTRYMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONCONTACTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONCONTACTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONASWAYPOINTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONASWAYPOINTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETHOUSENUMBERRANGEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETHOUSENUMBERRANGEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETWAYPOINTLISTINFOMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETWAYPOINTLISTINFOMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTLOCATIONSEARCHMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTLOCATIONSEARCHMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETCONTACTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETCONTACTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETLOCATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETLOCATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETINFOMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETINFOMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGCALLBACKSENDERMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGCALLBACKSENDERMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETCONTENTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETCONTENTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETNUMBERMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETNUMBERMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSENDMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSENDMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSELECTMESSAGEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSELECTMESSAGEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_CONTACTSGETAMBIGUITYLISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_CONTACTSGETAMBIGUITYLISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWMENUMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWMENUMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_VDLGETDATABASESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_VDLGETDATABASESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_APPSLAUNCHAPPLICATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_APPSLAUNCHAPPLICATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETDYNACCESSINFOMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETDYNACCESSINFOMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETNEARBYSTATESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETNEARBYSTATESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMIELEMENTDESCRIPTIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMIELEMENTDESCRIPTIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIREPEATINSTRUCTIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIREPEATINSTRUCTIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETCONTENTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETCONTENTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMILISTDESCRIPTIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMILISTDESCRIPTIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEUPDATEPHONEBOOKMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEUPDATEPHONEBOOKMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETSEARCHLOCATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETSEARCHLOCATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETSDSEVENTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETSDSEVENTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TVSELECTSTATIONMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TVSELECTSTATIONMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTREETAVAILABILITYMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTREETAVAILABILITYMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTRINGANDPHONEMEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTRINGANDPHONEMEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAREGISTERDIRECTNDSUSEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAREGISTERDIRECTNDSUSEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAUNREGISTERDIRECTNDSUSEMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAUNREGISTERDIRECTNDSUSEMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETCOUNTRYSTATELISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETCOUNTRYSTATELISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETPHONENUMBERFORMATTEDMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETPHONENUMBERFORMATTEDMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONRESTOREHMILISTMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONRESTOREHMILISTMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWSERVICEADVISORYMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWSERVICEADVISORYMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTDISTANCEDETOURMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTDISTANCEDETOURMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICANCELDISTANCEDETOURMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICANCELDISTANCEDETOURMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACCESSMODECHANGEDMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACCESSMODECHANGEDMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIVALIDATEDESTINATIONENTRIESMETHODSTART:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIVALIDATEDESTINATIONENTRIESMETHODRESULT:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_StatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_StatusSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_StatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_StatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonActionRequestGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonActionRequestStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgMediaStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStatusSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgPhoneStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTunerStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgWeatherStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATEGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATEUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATERELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATESTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgTextMsgStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgVDLStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgVDLStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgVDLStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSpecialAppStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNAGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNAUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNARELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNASTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoServiceStatusGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoServiceStatusSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviPOIIconListGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviPOIIconListSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFORELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONGET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONSET:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONRELUPREG:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg;

      case sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONSTATUS:
         return OSAL_NEW sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all sds2hmi_sdsfifi messages

// common functions

tU16 sds2hmi_sdsfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return SDS2HMI_SDSFI_C_U16_SERVICE_ID;
}

tU16 sds2hmi_sdsfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 sds2hmi_sdsfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& sds2hmi_sdsfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& sds2hmi_sdsfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 sds2hmi_sdsfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart::sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTARTSESSIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart::~sds2hmi_sdsfi_tclMsgCommonStartSessionMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult::sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTARTSESSIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult::~sds2hmi_sdsfi_tclMsgCommonStartSessionMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart::sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTOPSESSIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart::~sds2hmi_sdsfi_tclMsgCommonStopSessionMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult::sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTOPSESSIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult::~sds2hmi_sdsfi_tclMsgCommonStopSessionMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nPopUp_UpDateType = coRef.nPopUp_UpDateType;
   sXMLStream = coRef.sXMLStream;
}
sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nPopUp_UpDateType = coRef.nPopUp_UpDateType;
   sXMLStream = coRef.sXMLStream;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::vDestroy()
{
   sXMLStream.vDestroy();
}

sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart()
:nPopUp_UpDateType()
,sXMLStream()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSHOWDIALOGMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::~sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sXMLStream.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nPopUp_UpDateType);
   (tVoid) (oIn >> sXMLStream);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nPopUp_UpDateType);
   (tVoid) (oOut << sXMLStream);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nPopUp_UpDateType == roRef.nPopUp_UpDateType);
   bResult = bResult && (sXMLStream == roRef.sXMLStream);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nListCount = coRef.nListCount;
   nResultOptions = coRef.nResultOptions;
   nPageNumber = coRef.nPageNumber;
   NextDomain = coRef.NextDomain;
   PrevDomain = coRef.PrevDomain;
   CurrentFocus = coRef.CurrentFocus;
}
sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::operator=(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nListCount = coRef.nListCount;
   nResultOptions = coRef.nResultOptions;
   nPageNumber = coRef.nPageNumber;
   NextDomain = coRef.NextDomain;
   PrevDomain = coRef.PrevDomain;
   CurrentFocus = coRef.CurrentFocus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult()
:nListCount(0)
,nResultOptions()
,nPageNumber(0)
,NextDomain()
,PrevDomain()
,CurrentFocus(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSHOWDIALOGMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::~sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nListCount);
   (tVoid) (oIn >> nResultOptions);
   (tVoid) (oIn >> nPageNumber);
   (tVoid) (oIn >> NextDomain);
   (tVoid) (oIn >> PrevDomain);
   (tVoid) (oIn >> CurrentFocus);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nListCount);
   (tVoid) (oOut << nResultOptions);
   (tVoid) (oOut << nPageNumber);
   (tVoid) (oOut << NextDomain);
   (tVoid) (oOut << PrevDomain);
   (tVoid) (oOut << CurrentFocus);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult::operator==(const sds2hmi_sdsfi_tclMsgCommonShowDialogMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nListCount == roRef.nListCount);
   bResult = bResult && (nResultOptions == roRef.nResultOptions);
   bResult = bResult && (nPageNumber == roRef.nPageNumber);
   bResult = bResult && (NextDomain == roRef.NextDomain);
   bResult = bResult && (PrevDomain == roRef.PrevDomain);
   bResult = bResult && (CurrentFocus == roRef.CurrentFocus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nListType = coRef.nListType;
   nLine = coRef.nLine;
}
sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nListType = coRef.nListType;
   nLine = coRef.nLine;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart()
:nListType()
,nLine(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSELECTLISTELEMENTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::~sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nListType);
   (tVoid) (oIn >> nLine);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nListType);
   (tVoid) (oOut << nLine);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nListType == roRef.nListType);
   bResult = bResult && (nLine == roRef.nLine);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nLine = coRef.nLine;
}
sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::operator=(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nLine = coRef.nLine;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult()
:nLine(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSELECTLISTELEMENTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::~sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nLine);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nLine);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult::operator==(const sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nLine == roRef.nLine);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart::sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTELEMENTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart::~sds2hmi_sdsfi_tclMsgCommonGetListElementMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult::sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTELEMENTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult::~sds2hmi_sdsfi_tclMsgCommonGetListElementMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ApplicationId = coRef.ApplicationId;
}
sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ApplicationId = coRef.ApplicationId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart()
:ApplicationId()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETACTIVEAPPLICATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::~sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ApplicationId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ApplicationId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ApplicationId == roRef.ApplicationId);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult::sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETACTIVEAPPLICATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult::~sds2hmi_sdsfi_tclMsgCommonSetActiveApplicationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   LanguageAndSpeaker = coRef.LanguageAndSpeaker;
}
sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& coRef)
{
   if (this == &coRef) return *this;
   LanguageAndSpeaker = coRef.LanguageAndSpeaker;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageAndSpeaker.size(); ++u32Idx)
         LanguageAndSpeaker[u32Idx].vDestroy();
   LanguageAndSpeaker.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLESPEAKERSMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::~sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LanguageAndSpeaker.size(); ++u32ListIdx)
      u32DynamicSize += LanguageAndSpeaker[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LanguageAndSpeaker.size(); ++u32Idx)
      {
         LanguageAndSpeaker[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LanguageAndSpeaker.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LanguageAndSpeaker[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)LanguageAndSpeaker.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LanguageAndSpeaker.size(); ++u32Idx)
         (tVoid) (oOut << LanguageAndSpeaker[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (LanguageAndSpeaker.size() == roRef.LanguageAndSpeaker.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LanguageAndSpeaker.size()); ++u32Idx)
            bResult = bResult && (LanguageAndSpeaker[u32Idx] == roRef.LanguageAndSpeaker[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult::sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLESPEAKERSMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult::~sds2hmi_sdsfi_tclMsgCommonSetAvailableSpeakersMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   AvailableUserwords = coRef.AvailableUserwords;
}
sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AvailableUserwords = coRef.AvailableUserwords;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableUserwords.size(); ++u32Idx)
         AvailableUserwords[u32Idx].vDestroy();
   AvailableUserwords.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLEUSERWORDSMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::~sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AvailableUserwords.size(); ++u32ListIdx)
      u32DynamicSize += AvailableUserwords[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AvailableUserwords.size(); ++u32Idx)
      {
         AvailableUserwords[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AvailableUserwords.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AvailableUserwords[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AvailableUserwords.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AvailableUserwords.size(); ++u32Idx)
         (tVoid) (oOut << AvailableUserwords[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AvailableUserwords.size() == roRef.AvailableUserwords.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AvailableUserwords.size()); ++u32Idx)
            bResult = bResult && (AvailableUserwords[u32Idx] == roRef.AvailableUserwords[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult::sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETAVAILABLEUSERWORDSMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult::~sds2hmi_sdsfi_tclMsgCommonSetAvailableUserwordsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart(const sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   TimeStamp = coRef.TimeStamp;
   Event = coRef.Event;
   EventValue = coRef.EventValue;
   SpeechCommandList = coRef.SpeechCommandList;
   CommandConfidence = coRef.CommandConfidence;
   GrammarOrSlmID = coRef.GrammarOrSlmID;
   CurrentConfThreshold = coRef.CurrentConfThreshold;
   LanguageID = coRef.LanguageID;
}
sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TimeStamp = coRef.TimeStamp;
   Event = coRef.Event;
   EventValue = coRef.EventValue;
   SpeechCommandList = coRef.SpeechCommandList;
   CommandConfidence = coRef.CommandConfidence;
   GrammarOrSlmID = coRef.GrammarOrSlmID;
   CurrentConfThreshold = coRef.CurrentConfThreshold;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::vDestroy()
{
   EventValue.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < SpeechCommandList.size(); ++u32Idx)
         SpeechCommandList[u32Idx].vDestroy();
   SpeechCommandList.clear();
   }
   GrammarOrSlmID.vDestroy();
   CurrentConfThreshold.vDestroy(); 
   LanguageID.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart()
:TimeStamp(0)
,Event()
,EventValue()

,CommandConfidence()
,GrammarOrSlmID()
,CurrentConfThreshold()
,LanguageID()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONINTERACTIONLOGGERMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::~sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SpeechCommandList.size(); ++u32ListIdx)
      u32DynamicSize += SpeechCommandList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+34+EventValue.u32GetSize(u16MajorVersion)+GrammarOrSlmID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeStamp);
   (tVoid) (oIn >> Event);
   (tVoid) (oIn >> EventValue);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SpeechCommandList.size(); ++u32Idx)
      {
         SpeechCommandList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SpeechCommandList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SpeechCommandList[u32Idx]);
      }
   }
   (tVoid) (oIn >> CommandConfidence);
   (tVoid) (oIn >> GrammarOrSlmID);
   (tVoid) (oIn >> CurrentConfThreshold);
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeStamp);
   (tVoid) (oOut << Event);
   (tVoid) (oOut << EventValue);
   (tVoid) (oOut << (tU32)SpeechCommandList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SpeechCommandList.size(); ++u32Idx)
         (tVoid) (oOut << SpeechCommandList[u32Idx]);
   }
   (tVoid) (oOut << CommandConfidence);
   (tVoid) (oOut << GrammarOrSlmID);
   (tVoid) (oOut << CurrentConfThreshold);
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeStamp == roRef.TimeStamp);
   bResult = bResult && (Event == roRef.Event);
   bResult = bResult && (EventValue == roRef.EventValue);
      bResult = bResult && (SpeechCommandList.size() == roRef.SpeechCommandList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SpeechCommandList.size()); ++u32Idx)
            bResult = bResult && (SpeechCommandList[u32Idx] == roRef.SpeechCommandList[u32Idx]);
      }
   bResult = bResult && (CommandConfidence == roRef.CommandConfidence);
   bResult = bResult && (GrammarOrSlmID == roRef.GrammarOrSlmID);
   bResult = bResult && (CurrentConfThreshold == roRef.CurrentConfThreshold);
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult::sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONINTERACTIONLOGGERMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult::~sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart(const sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Settings = coRef.Settings;
}
sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Settings = coRef.Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         Settings[u32Idx].vDestroy();
   Settings.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::~sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Settings.size(); ++u32ListIdx)
      u32DynamicSize += Settings[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
      {
         Settings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Settings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Settings[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Settings.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         (tVoid) (oOut << Settings[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Settings.size() == roRef.Settings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Settings.size()); ++u32Idx)
            bResult = bResult && (Settings[u32Idx] == roRef.Settings[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult::sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult::~sds2hmi_sdsfi_tclMsgCommonSettingsMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ListType = coRef.ListType;
}
sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListType = coRef.ListType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart()
:ListType()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTINFOMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::~sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListType == roRef.ListType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ListSize = coRef.ListSize;
}
sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::operator=(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListSize = coRef.ListSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult()
:ListSize()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETLISTINFOMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::~sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListSize);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListSize);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult::operator==(const sds2hmi_sdsfi_tclMsgCommonGetListInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListSize == roRef.ListSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart(const sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Band = coRef.Band;
   SelectionType = coRef.SelectionType;
   Frequency = coRef.Frequency;
   Value = coRef.Value;
}
sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Band = coRef.Band;
   SelectionType = coRef.SelectionType;
   Frequency = coRef.Frequency;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::vDestroy()
{
   Frequency.vDestroy();
}

sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart()
:Band()
,SelectionType()
,Frequency()
,Value(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTSTATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::~sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+Frequency.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> SelectionType);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Band);
   (tVoid) (oOut << SelectionType);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << Value);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTunerSelectStationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (SelectionType == roRef.SelectionType);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult::sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTSTATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult::~sds2hmi_sdsfi_tclMsgTunerSelectStationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart(const sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Band = coRef.Band;
   MemBank = coRef.MemBank;
}
sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Band = coRef.Band;
   MemBank = coRef.MemBank;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart()
:Band()
,MemBank()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTBAND_MEMBANKMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::~sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> MemBank);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Band);
   (tVoid) (oOut << MemBank);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (MemBank == roRef.MemBank);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult::sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSELECTBAND_MEMBANKMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult::~sds2hmi_sdsfi_tclMsgTunerSelectBand_MemBankMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart::sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERAUTOSTOREMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart::~sds2hmi_sdsfi_tclMsgTunerAutostoreMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult::sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERAUTOSTOREMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult::~sds2hmi_sdsfi_tclMsgTunerAutostoreMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart(const sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nTunerSetting = coRef.nTunerSetting;
}
sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nTunerSetting = coRef.nTunerSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart()
:nTunerSetting()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSETSETTINGMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::~sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nTunerSetting);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nTunerSetting);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTunerSetSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nTunerSetting == roRef.nTunerSetting);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult::sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSETSETTINGMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult::~sds2hmi_sdsfi_tclMsgTunerSetSettingMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart(const sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nPreset = coRef.nPreset;
}
sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nPreset = coRef.nPreset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart()
:nPreset(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTORESTATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::~sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nPreset);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nPreset);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTunerStoreStationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nPreset == roRef.nPreset);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult::sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTORESTATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult::~sds2hmi_sdsfi_tclMsgTunerStoreStationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart(const sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nBand = coRef.nBand;
}
sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nBand = coRef.nBand;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart()
:nBand()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSHOWSTATIONLISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::~sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nBand);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nBand);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTunerShowStationListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nBand == roRef.nBand);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult::sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSHOWSTATIONLISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult::~sds2hmi_sdsfi_tclMsgTunerShowStationListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Band = coRef.Band;
   FirstID = coRef.FirstID;
   MaxNumberOfEntries = coRef.MaxNumberOfEntries;
}
sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Band = coRef.Band;
   FirstID = coRef.FirstID;
   MaxNumberOfEntries = coRef.MaxNumberOfEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart()
:Band()
,FirstID(0)
,MaxNumberOfEntries(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETLISTENTRIESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::~sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> FirstID);
   (tVoid) (oIn >> MaxNumberOfEntries);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Band);
   (tVoid) (oOut << FirstID);
   (tVoid) (oOut << MaxNumberOfEntries);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (FirstID == roRef.FirstID);
   bResult = bResult && (MaxNumberOfEntries == roRef.MaxNumberOfEntries);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ListEntries = coRef.ListEntries;
   NoMoreEntries = coRef.NoMoreEntries;
}
sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ListEntries = coRef.ListEntries;
   NoMoreEntries = coRef.NoMoreEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListEntries.size(); ++u32Idx)
         ListEntries[u32Idx].vDestroy();
   ListEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult()

:NoMoreEntries(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETLISTENTRIESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::~sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListEntries.size(); ++u32ListIdx)
      u32DynamicSize += ListEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListEntries.size(); ++u32Idx)
      {
         ListEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListEntries[u32Idx]);
      }
   }
   (tVoid) (oIn >> NoMoreEntries);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListEntries.size(); ++u32Idx)
         (tVoid) (oOut << ListEntries[u32Idx]);
   }
   (tVoid) (oOut << NoMoreEntries);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgTunerGetListEntriesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListEntries.size() == roRef.ListEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListEntries.size()); ++u32Idx)
            bResult = bResult && (ListEntries[u32Idx] == roRef.ListEntries[u32Idx]);
      }
   bResult = bResult && (NoMoreEntries == roRef.NoMoreEntries);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart::sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETDATABASESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart::~sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult(const sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Devices = coRef.Devices;
}
sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Devices = coRef.Devices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         Devices[u32Idx].vDestroy();
   Devices.clear();
   }
}

sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETDATABASESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::~sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Devices.size(); ++u32ListIdx)
      u32DynamicSize += Devices[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
      {
         Devices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Devices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Devices[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Devices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         (tVoid) (oOut << Devices[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgTunerGetDatabasesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Devices.size() == roRef.Devices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Devices.size()); ++u32Idx)
            bResult = bResult && (Devices[u32Idx] == roRef.Devices[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ValueIDs = coRef.ValueIDs;
}
sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ValueIDs = coRef.ValueIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::vDestroy()
{
   {
   ValueIDs.clear();
   }
}

sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart()

 {}

tS32 sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETAMBIGUITYLISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::~sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ValueIDs.size()*4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ValueIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ValueIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ValueIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ValueIDs.size(); ++u32Idx)
         (tVoid) (oOut << ValueIDs[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ValueIDs.size() == roRef.ValueIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ValueIDs.size()); ++u32Idx)
            bResult = bResult && (ValueIDs[u32Idx] == roRef.ValueIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   AmbiguousEntries = coRef.AmbiguousEntries;
}
sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::operator=(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AmbiguousEntries = coRef.AmbiguousEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AmbiguousEntries.size(); ++u32Idx)
         AmbiguousEntries[u32Idx].vDestroy();
   AmbiguousEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERGETAMBIGUITYLISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::~sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AmbiguousEntries.size(); ++u32ListIdx)
      u32DynamicSize += AmbiguousEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AmbiguousEntries.size(); ++u32Idx)
      {
         AmbiguousEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AmbiguousEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AmbiguousEntries[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AmbiguousEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AmbiguousEntries.size(); ++u32Idx)
         (tVoid) (oOut << AmbiguousEntries[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult::operator==(const sds2hmi_sdsfi_tclMsgTunerGetAmbiguityListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AmbiguousEntries.size() == roRef.AmbiguousEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AmbiguousEntries.size()); ++u32Idx)
            bResult = bResult && (AmbiguousEntries[u32Idx] == roRef.AmbiguousEntries[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   PhoneID = coRef.PhoneID;
}
sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneID = coRef.PhoneID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart()
:PhoneID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESELECTPHONEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::~sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneID == roRef.PhoneID);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult::sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESELECTPHONEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult::~sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart::sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTARTPAIRINGMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart::~sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult::sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTARTPAIRINGMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult::~sds2hmi_sdsfi_tclMsgPhoneStartPairingMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nSelectionType = coRef.nSelectionType;
   sPhoneNumber = coRef.sPhoneNumber;
   nIDValue = coRef.nIDValue;
}
sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nSelectionType = coRef.nSelectionType;
   sPhoneNumber = coRef.sPhoneNumber;
   nIDValue = coRef.nIDValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::vDestroy()
{
   sPhoneNumber.vDestroy();
}

sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart()
:nSelectionType()
,sPhoneNumber()
,nIDValue(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALNUMBERMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::~sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+sPhoneNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nSelectionType);
   (tVoid) (oIn >> sPhoneNumber);
   (tVoid) (oIn >> nIDValue);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nSelectionType);
   (tVoid) (oOut << sPhoneNumber);
   (tVoid) (oOut << nIDValue);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   bResult = bResult && (sPhoneNumber == roRef.sPhoneNumber);
   bResult = bResult && (nIDValue == roRef.nIDValue);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult::sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALNUMBERMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult::~sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart::sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEREDIALLASTNUMBERMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart::~sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult::sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEREDIALLASTNUMBERMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult::~sds2hmi_sdsfi_tclMsgPhoneRedialLastNumberMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nListEntryType = coRef.nListEntryType;
   nSelectionType = coRef.nSelectionType;
   nNumberOfEntries = coRef.nNumberOfEntries;
   nCurrentFirstID = coRef.nCurrentFirstID;
   nCurrentLastID = coRef.nCurrentLastID;
}
sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nListEntryType = coRef.nListEntryType;
   nSelectionType = coRef.nSelectionType;
   nNumberOfEntries = coRef.nNumberOfEntries;
   nCurrentFirstID = coRef.nCurrentFirstID;
   nCurrentLastID = coRef.nCurrentLastID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart()
:nListEntryType()
,nSelectionType()
,nNumberOfEntries(0)
,nCurrentFirstID(0)
,nCurrentLastID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETCONTACTLISTENTRIESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::~sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nListEntryType);
   (tVoid) (oIn >> nSelectionType);
   (tVoid) (oIn >> nNumberOfEntries);
   (tVoid) (oIn >> nCurrentFirstID);
   (tVoid) (oIn >> nCurrentLastID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nListEntryType);
   (tVoid) (oOut << nSelectionType);
   (tVoid) (oOut << nNumberOfEntries);
   (tVoid) (oOut << nCurrentFirstID);
   (tVoid) (oOut << nCurrentLastID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nListEntryType == roRef.nListEntryType);
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   bResult = bResult && (nNumberOfEntries == roRef.nNumberOfEntries);
   bResult = bResult && (nCurrentFirstID == roRef.nCurrentFirstID);
   bResult = bResult && (nCurrentLastID == roRef.nCurrentLastID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   tPhoneBookEntries = coRef.tPhoneBookEntries;
   nNumberOfEntries = coRef.nNumberOfEntries;
   bNoMoreEntries = coRef.bNoMoreEntries;
}
sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   tPhoneBookEntries = coRef.tPhoneBookEntries;
   nNumberOfEntries = coRef.nNumberOfEntries;
   bNoMoreEntries = coRef.bNoMoreEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tPhoneBookEntries.size(); ++u32Idx)
         tPhoneBookEntries[u32Idx].vDestroy();
   tPhoneBookEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult()

:nNumberOfEntries(0)
,bNoMoreEntries(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETCONTACTLISTENTRIESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::~sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tPhoneBookEntries.size(); ++u32ListIdx)
      u32DynamicSize += tPhoneBookEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tPhoneBookEntries.size(); ++u32Idx)
      {
         tPhoneBookEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tPhoneBookEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tPhoneBookEntries[u32Idx]);
      }
   }
   (tVoid) (oIn >> nNumberOfEntries);
   (tVoid) (oIn >> bNoMoreEntries);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tPhoneBookEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tPhoneBookEntries.size(); ++u32Idx)
         (tVoid) (oOut << tPhoneBookEntries[u32Idx]);
   }
   (tVoid) (oOut << nNumberOfEntries);
   (tVoid) (oOut << bNoMoreEntries);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgPhoneGetContactListEntriesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tPhoneBookEntries.size() == roRef.tPhoneBookEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tPhoneBookEntries.size()); ++u32Idx)
            bResult = bResult && (tPhoneBookEntries[u32Idx] == roRef.tPhoneBookEntries[u32Idx]);
      }
   bResult = bResult && (nNumberOfEntries == roRef.nNumberOfEntries);
   bResult = bResult && (bNoMoreEntries == roRef.bNoMoreEntries);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   sPhoneNumber = coRef.sPhoneNumber;
}
sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sPhoneNumber = coRef.sPhoneNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::vDestroy()
{
   sPhoneNumber.vDestroy();
}

sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart()
:sPhoneNumber()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTORENUMBERMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::~sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sPhoneNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sPhoneNumber);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sPhoneNumber);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sPhoneNumber == roRef.sPhoneNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nMemoryID = coRef.nMemoryID;
}
sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::operator=(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nMemoryID = coRef.nMemoryID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult()
:nMemoryID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTORENUMBERMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::~sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nMemoryID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nMemoryID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult::operator==(const sds2hmi_sdsfi_tclMsgPhoneStoreNumberMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nMemoryID == roRef.nMemoryID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart(const sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nMemoryID = coRef.nMemoryID;
}
sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nMemoryID = coRef.nMemoryID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart()
:nMemoryID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDELETENUMBERMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::~sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nMemoryID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nMemoryID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nMemoryID == roRef.nMemoryID);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult::sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDELETENUMBERMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult::~sds2hmi_sdsfi_tclMsgPhoneDeleteNumberMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nPhoneSetting = coRef.nPhoneSetting;
}
sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nPhoneSetting = coRef.nPhoneSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart()
:nPhoneSetting()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETPHONESETTINGMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::~sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nPhoneSetting);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nPhoneSetting);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nPhoneSetting == roRef.nPhoneSetting);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult::sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETPHONESETTINGMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult::~sds2hmi_sdsfi_tclMsgPhoneSetPhoneSettingMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart::sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALVOICEMAILMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart::~sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult::sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALVOICEMAILMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult::~sds2hmi_sdsfi_tclMsgPhoneDialVoiceMailMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart::sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETDATABASESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart::~sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Devices = coRef.Devices;
}
sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Devices = coRef.Devices;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         Devices[u32Idx].vDestroy();
   Devices.clear();
   }
}

sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETDATABASESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::~sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Devices.size(); ++u32ListIdx)
      u32DynamicSize += Devices[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
      {
         Devices[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Devices.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Devices[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Devices.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Devices.size(); ++u32Idx)
         (tVoid) (oOut << Devices[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgPhoneGetDatabasesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Devices.size() == roRef.Devices.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Devices.size()); ++u32Idx)
            bResult = bResult && (Devices[u32Idx] == roRef.Devices[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart(const sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ContactID = coRef.ContactID;
   LocationType = coRef.LocationType;
}
sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ContactID = coRef.ContactID;
   LocationType = coRef.LocationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart()
:ContactID(0)
,LocationType()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALCONTACTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::~sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContactID);
   (tVoid) (oIn >> LocationType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContactID);
   (tVoid) (oOut << LocationType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneDialContactMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContactID == roRef.ContactID);
   bResult = bResult && (LocationType == roRef.LocationType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult::sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEDIALCONTACTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult::~sds2hmi_sdsfi_tclMsgPhoneDialContactMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart(const sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nMenuType = coRef.nMenuType;
}
sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nMenuType = coRef.nMenuType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart()
:nMenuType()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESHOWMENUMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::~sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nMenuType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nMenuType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nMenuType == roRef.nMenuType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult::sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESHOWMENUMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult::~sds2hmi_sdsfi_tclMsgPhoneShowMenuMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nDTMFDigits = coRef.nDTMFDigits;
}
sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nDTMFDigits = coRef.nDTMFDigits;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::vDestroy()
{
   nDTMFDigits.vDestroy();
}

sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart()
:nDTMFDigits()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESENDDTMFDIGITSMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::~sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+nDTMFDigits.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nDTMFDigits);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nDTMFDigits);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nDTMFDigits == roRef.nDTMFDigits);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult::sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESENDDTMFDIGITSMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult::~sds2hmi_sdsfi_tclMsgPhoneSendDTMFDigitsMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart::sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESWITCHCALLMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart::~sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult::sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESWITCHCALLMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult::~sds2hmi_sdsfi_tclMsgPhoneSwitchCallMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart(const sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SelectionType = coRef.SelectionType;
   ValueID = coRef.ValueID;
}
sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectionType = coRef.SelectionType;
   ValueID = coRef.ValueID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart()
:SelectionType()
,ValueID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETCONTACTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::~sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionType);
   (tVoid) (oIn >> ValueID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionType);
   (tVoid) (oOut << ValueID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneSetContactMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionType == roRef.SelectionType);
   bResult = bResult && (ValueID == roRef.ValueID);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult::sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESETCONTACTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult::~sds2hmi_sdsfi_tclMsgPhoneSetContactMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nUswID = coRef.nUswID;
}
sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nUswID = coRef.nUswID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart()
:nUswID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETNUMBERINFOMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::~sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nUswID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nUswID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nUswID == roRef.nUswID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   sResult = coRef.sResult;
}
sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::operator=(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sResult = coRef.sResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::vDestroy()
{
   sResult.vDestroy();
}

sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult()
:sResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETNUMBERINFOMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::~sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sResult);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sResult);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult::operator==(const sds2hmi_sdsfi_tclMsgPhoneGetNumberInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sResult == roRef.sResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::sds2hmi_sdsfi_tclMsgMediaPlayMethodStart(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DriveID = coRef.DriveID;
   SelectionType = coRef.SelectionType;
   Action = coRef.Action;
   ValueIDs = coRef.ValueIDs;
   MediaListType = coRef.MediaListType;
}
sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::operator=(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DriveID = coRef.DriveID;
   SelectionType = coRef.SelectionType;
   Action = coRef.Action;
   ValueIDs = coRef.ValueIDs;
   MediaListType = coRef.MediaListType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::vDestroy()
{
   {
   ValueIDs.clear();
   }
}

sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::sds2hmi_sdsfi_tclMsgMediaPlayMethodStart()
:DriveID(0)
,SelectionType()
,Action()

,MediaListType()
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAPLAYMETHODSTART;
}


sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::~sds2hmi_sdsfi_tclMsgMediaPlayMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11+ValueIDs.size()*4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveID);
   (tVoid) (oIn >> SelectionType);
   (tVoid) (oIn >> Action);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ValueIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ValueIDs[u32Idx]);
      }
   }
   (tVoid) (oIn >> MediaListType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveID);
   (tVoid) (oOut << SelectionType);
   (tVoid) (oOut << Action);
   (tVoid) (oOut << (tU32)ValueIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ValueIDs.size(); ++u32Idx)
         (tVoid) (oOut << ValueIDs[u32Idx]);
   }
   (tVoid) (oOut << MediaListType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaPlayMethodStart::operator==(const sds2hmi_sdsfi_tclMsgMediaPlayMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveID == roRef.DriveID);
   bResult = bResult && (SelectionType == roRef.SelectionType);
   bResult = bResult && (Action == roRef.Action);
      bResult = bResult && (ValueIDs.size() == roRef.ValueIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ValueIDs.size()); ++u32Idx)
            bResult = bResult && (ValueIDs[u32Idx] == roRef.ValueIDs[u32Idx]);
      }
   bResult = bResult && (MediaListType == roRef.MediaListType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgMediaPlayMethodResult::sds2hmi_sdsfi_tclMsgMediaPlayMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaPlayMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAPLAYMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgMediaPlayMethodResult::~sds2hmi_sdsfi_tclMsgMediaPlayMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DeviceID = coRef.DeviceID;
}
sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::operator=(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceID = coRef.DeviceID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart()
:DeviceID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDATABASEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::~sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart::operator==(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceID == roRef.DeviceID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DeviceID = coRef.DeviceID;
   Filename = coRef.Filename;
}
sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::operator=(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceID = coRef.DeviceID;
   Filename = coRef.Filename;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::vDestroy()
{
   Filename.vDestroy();
}

sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult()
:DeviceID(0)
,Filename()
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDATABASEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::~sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+Filename.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceID);
   (tVoid) (oIn >> Filename);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceID);
   (tVoid) (oOut << Filename);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult::operator==(const sds2hmi_sdsfi_tclMsgMediaGetDatabaseMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceID == roRef.DeviceID);
   bResult = bResult && (Filename == roRef.Filename);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ValueIDs = coRef.ValueIDs;
}
sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ValueIDs = coRef.ValueIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ValueIDs.size(); ++u32Idx)
         ValueIDs[u32Idx].vDestroy();
   ValueIDs.clear();
   }
}

sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart()

 {}

tS32 sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETAMBIGUITYLISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::~sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ValueIDs.size()*5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ValueIDs.size(); ++u32Idx)
      {
         ValueIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ValueIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ValueIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ValueIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ValueIDs.size(); ++u32Idx)
         (tVoid) (oOut << ValueIDs[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ValueIDs.size() == roRef.ValueIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ValueIDs.size()); ++u32Idx)
            bResult = bResult && (ValueIDs[u32Idx] == roRef.ValueIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   AmbiguousEntries = coRef.AmbiguousEntries;
}
sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::operator=(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   AmbiguousEntries = coRef.AmbiguousEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AmbiguousEntries.size(); ++u32Idx)
         AmbiguousEntries[u32Idx].vDestroy();
   AmbiguousEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETAMBIGUITYLISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::~sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AmbiguousEntries.size(); ++u32ListIdx)
      u32DynamicSize += AmbiguousEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AmbiguousEntries.size(); ++u32Idx)
      {
         AmbiguousEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AmbiguousEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AmbiguousEntries[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)AmbiguousEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AmbiguousEntries.size(); ++u32Idx)
         (tVoid) (oOut << AmbiguousEntries[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult::operator==(const sds2hmi_sdsfi_tclMsgMediaGetAmbiguityListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (AmbiguousEntries.size() == roRef.AmbiguousEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AmbiguousEntries.size()); ++u32Idx)
            bResult = bResult && (AmbiguousEntries[u32Idx] == roRef.AmbiguousEntries[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DeviceID = coRef.DeviceID;
   Slot = coRef.Slot;
}
sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::operator=(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DeviceID = coRef.DeviceID;
   Slot = coRef.Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart()
:DeviceID(0)
,Slot(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDEVICEINFOMETHODSTART;
}


sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::~sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceID);
   (tVoid) (oIn >> Slot);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceID);
   (tVoid) (oOut << Slot);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart::operator==(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceID == roRef.DeviceID);
   bResult = bResult && (Slot == roRef.Slot);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DeviceType = coRef.DeviceType;
   NumberOfTracks = coRef.NumberOfTracks;
}
sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::operator=(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DeviceType = coRef.DeviceType;
   NumberOfTracks = coRef.NumberOfTracks;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult()
:DeviceType()
,NumberOfTracks(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIAGETDEVICEINFOMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::~sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceType);
   (tVoid) (oIn >> NumberOfTracks);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceType);
   (tVoid) (oOut << NumberOfTracks);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult::operator==(const sds2hmi_sdsfi_tclMsgMediaGetDeviceInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceType == roRef.DeviceType);
   bResult = bResult && (NumberOfTracks == roRef.NumberOfTracks);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart::sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTGUIDANCEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart::~sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult::sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTGUIDANCEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult::~sds2hmi_sdsfi_tclMsgNaviStartGuidanceMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart::sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOPGUIDANCEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart::~sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult::sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOPGUIDANCEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult::~sds2hmi_sdsfi_tclMsgNaviStopGuidanceMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ZoomAction = coRef.ZoomAction;
   ZoomLevel = coRef.ZoomLevel;
}
sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ZoomAction = coRef.ZoomAction;
   ZoomLevel = coRef.ZoomLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart()
:ZoomAction()
,ZoomLevel()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETZOOMSETTINGMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::~sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ZoomAction);
   (tVoid) (oIn >> ZoomLevel);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ZoomAction);
   (tVoid) (oOut << ZoomLevel);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ZoomAction == roRef.ZoomAction);
   bResult = bResult && (ZoomLevel == roRef.ZoomLevel);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult::sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETZOOMSETTINGMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult::~sds2hmi_sdsfi_tclMsgNaviSetZoomSettingMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart::sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETROUTECRITERIAMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   tRouteOptions = coRef.tRouteOptions;
   nDynRGState = coRef.nDynRGState;
}
sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& coRef)
{
   if (this == &coRef) return *this;
   tRouteOptions = coRef.tRouteOptions;
   nDynRGState = coRef.nDynRGState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::vDestroy()
{
   {
   tRouteOptions.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult()

:nDynRGState()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETROUTECRITERIAMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+tRouteOptions.size()*1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tRouteOptions.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tRouteOptions[u32Idx]);
      }
   }
   (tVoid) (oIn >> nDynRGState);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tRouteOptions.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tRouteOptions.size(); ++u32Idx)
         (tVoid) (oOut << tRouteOptions[u32Idx]);
   }
   (tVoid) (oOut << nDynRGState);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetRouteCriteriaMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tRouteOptions.size() == roRef.tRouteOptions.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tRouteOptions.size()); ++u32Idx)
            bResult = bResult && (tRouteOptions[u32Idx] == roRef.tRouteOptions[u32Idx]);
      }
   bResult = bResult && (nDynRGState == roRef.nDynRGState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   tRouteOptions = coRef.tRouteOptions;
}
sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tRouteOptions = coRef.tRouteOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart()
:tRouteOptions()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETROUTECRITERIAMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::~sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tRouteOptions);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tRouteOptions);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tRouteOptions == roRef.tRouteOptions);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult::sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETROUTECRITERIAMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult::~sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nNavSetting = coRef.nNavSetting;
}
sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nNavSetting = coRef.nNavSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart()
:nNavSetting()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETNAVSETTINGMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::~sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nNavSetting);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nNavSetting);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nNavSetting == roRef.nNavSetting);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult::sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETNAVSETTINGMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult::~sds2hmi_sdsfi_tclMsgNaviSetNavSettingMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart(const sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nMenuType = coRef.nMenuType;
}
sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nMenuType = coRef.nMenuType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart()
:nMenuType()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWNAVMENUMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::~sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nMenuType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nMenuType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nMenuType == roRef.nMenuType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult::sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWNAVMENUMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult::~sds2hmi_sdsfi_tclMsgNaviShowNavMenuMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nTBTSymbols = coRef.nTBTSymbols;
   nAutoZoom = coRef.nAutoZoom;
   nMapMode = coRef.nMapMode;
   nMapOrientation = coRef.nMapOrientation;
   nMapView = coRef.nMapView;
   IconSetting = coRef.IconSetting;
}
sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nTBTSymbols = coRef.nTBTSymbols;
   nAutoZoom = coRef.nAutoZoom;
   nMapMode = coRef.nMapMode;
   nMapOrientation = coRef.nMapOrientation;
   nMapView = coRef.nMapView;
   IconSetting = coRef.IconSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::vDestroy()
{
   IconSetting.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart()
:nTBTSymbols()
,nAutoZoom()
,nMapMode()
,nMapOrientation()
,nMapView()
,IconSetting()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETMAPMODEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::~sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+IconSetting.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nTBTSymbols);
   (tVoid) (oIn >> nAutoZoom);
   (tVoid) (oIn >> nMapMode);
   (tVoid) (oIn >> nMapOrientation);
   (tVoid) (oIn >> nMapView);
   (tVoid) (oIn >> IconSetting);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nTBTSymbols);
   (tVoid) (oOut << nAutoZoom);
   (tVoid) (oOut << nMapMode);
   (tVoid) (oOut << nMapOrientation);
   (tVoid) (oOut << nMapView);
   (tVoid) (oOut << IconSetting);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nTBTSymbols == roRef.nTBTSymbols);
   bResult = bResult && (nAutoZoom == roRef.nAutoZoom);
   bResult = bResult && (nMapMode == roRef.nMapMode);
   bResult = bResult && (nMapOrientation == roRef.nMapOrientation);
   bResult = bResult && (nMapView == roRef.nMapView);
   bResult = bResult && (IconSetting == roRef.IconSetting);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult::sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETMAPMODEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult::~sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart::sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETMAPMODEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nTBTSymbols = coRef.nTBTSymbols;
   nAutoZoom = coRef.nAutoZoom;
   nMapMode = coRef.nMapMode;
   nMapOrientation = coRef.nMapOrientation;
   nMapView = coRef.nMapView;
}
sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nTBTSymbols = coRef.nTBTSymbols;
   nAutoZoom = coRef.nAutoZoom;
   nMapMode = coRef.nMapMode;
   nMapOrientation = coRef.nMapOrientation;
   nMapView = coRef.nMapView;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult()
:nTBTSymbols()
,nAutoZoom()
,nMapMode()
,nMapOrientation()
,nMapView()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETMAPMODEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nTBTSymbols);
   (tVoid) (oIn >> nAutoZoom);
   (tVoid) (oIn >> nMapMode);
   (tVoid) (oIn >> nMapOrientation);
   (tVoid) (oIn >> nMapView);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nTBTSymbols);
   (tVoid) (oOut << nAutoZoom);
   (tVoid) (oOut << nMapMode);
   (tVoid) (oOut << nMapOrientation);
   (tVoid) (oOut << nMapView);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetMapModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nTBTSymbols == roRef.nTBTSymbols);
   bResult = bResult && (nAutoZoom == roRef.nAutoZoom);
   bResult = bResult && (nMapMode == roRef.nMapMode);
   bResult = bResult && (nMapOrientation == roRef.nMapOrientation);
   bResult = bResult && (nMapView == roRef.nMapView);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nListEntryType = coRef.nListEntryType;
   nSelectionType = coRef.nSelectionType;
   nReferenceID = coRef.nReferenceID;
}
sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nListEntryType = coRef.nListEntryType;
   nSelectionType = coRef.nSelectionType;
   nReferenceID = coRef.nReferenceID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart()
:nListEntryType()
,nSelectionType()
,nReferenceID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCONTACTLISTENTRIESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nListEntryType);
   (tVoid) (oIn >> nSelectionType);
   (tVoid) (oIn >> nReferenceID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nListEntryType);
   (tVoid) (oOut << nSelectionType);
   (tVoid) (oOut << nReferenceID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nListEntryType == roRef.nListEntryType);
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   bResult = bResult && (nReferenceID == roRef.nReferenceID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   tDestListEntries = coRef.tDestListEntries;
}
sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   tDestListEntries = coRef.tDestListEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tDestListEntries.size(); ++u32Idx)
         tDestListEntries[u32Idx].vDestroy();
   tDestListEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCONTACTLISTENTRIESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tDestListEntries.size(); ++u32ListIdx)
      u32DynamicSize += tDestListEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tDestListEntries.size(); ++u32Idx)
      {
         tDestListEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tDestListEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tDestListEntries[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tDestListEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tDestListEntries.size(); ++u32Idx)
         (tVoid) (oOut << tDestListEntries[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetContactListEntriesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tDestListEntries.size() == roRef.tDestListEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tDestListEntries.size()); ++u32Idx)
            bResult = bResult && (tDestListEntries[u32Idx] == roRef.tDestListEntries[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart(const sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nSelectionType = coRef.nSelectionType;
   nListEntryType = coRef.nListEntryType;
   nIDValue = coRef.nIDValue;
}
sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nSelectionType = coRef.nSelectionType;
   nListEntryType = coRef.nListEntryType;
   nIDValue = coRef.nIDValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart()
:nSelectionType()
,nListEntryType()
,nIDValue(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTDESTLISTENTRYMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::~sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nSelectionType);
   (tVoid) (oIn >> nListEntryType);
   (tVoid) (oIn >> nIDValue);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nSelectionType);
   (tVoid) (oOut << nListEntryType);
   (tVoid) (oOut << nIDValue);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   bResult = bResult && (nListEntryType == roRef.nListEntryType);
   bResult = bResult && (nIDValue == roRef.nIDValue);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult::sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTDESTLISTENTRYMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult::~sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart::sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOREDESTINATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart::~sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult(const sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nPersistantMemoryID = coRef.nPersistantMemoryID;
}
sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nPersistantMemoryID = coRef.nPersistantMemoryID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult()
:nPersistantMemoryID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTOREDESTINATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::~sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nPersistantMemoryID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nPersistantMemoryID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviStoreDestinationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nPersistantMemoryID == roRef.nPersistantMemoryID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart(const sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nPersistantMemoryID = coRef.nPersistantMemoryID;
}
sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nPersistantMemoryID = coRef.nPersistantMemoryID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart()
:nPersistantMemoryID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIDELETEDESTINATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::~sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nPersistantMemoryID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nPersistantMemoryID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nPersistantMemoryID == roRef.nPersistantMemoryID);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult::sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIDELETEDESTINATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult::~sds2hmi_sdsfi_tclMsgNaviDeleteDestinationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart(const sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   bDeleteCountry = coRef.bDeleteCountry;
}
sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bDeleteCountry = coRef.bDeleteCountry;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart()
:bDeleteCountry(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVINEWDESTINATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::~sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDeleteCountry);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDeleteCountry);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDeleteCountry == roRef.bDeleteCountry);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult::sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVINEWDESTINATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult::~sds2hmi_sdsfi_tclMsgNaviNewDestinationMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart::sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCURRENTDESTINATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tSelectionCriterionType = coRef.tSelectionCriterionType;
   bGuidancePossible = coRef.bGuidancePossible;
   bAmbiguous = coRef.bAmbiguous;
}
sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tSelectionCriterionType = coRef.tSelectionCriterionType;
   bGuidancePossible = coRef.bGuidancePossible;
   bAmbiguous = coRef.bAmbiguous;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::vDestroy()
{
   tLocationDescription.vDestroy(); 
   {
   tSelectionCriterionType.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult()
:nNumberOfElements(0)
,tLocationDescription()

,bGuidancePossible(0)
,bAmbiguous(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETCURRENTDESTINATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+tLocationDescription.u32GetSize(u16MajorVersion)+tSelectionCriterionType.size()*2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nNumberOfElements);
   (tVoid) (oIn >> tLocationDescription);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tSelectionCriterionType.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tSelectionCriterionType[u32Idx]);
      }
   }
   (tVoid) (oIn >> bGuidancePossible);
   (tVoid) (oIn >> bAmbiguous);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nNumberOfElements);
   (tVoid) (oOut << tLocationDescription);
   (tVoid) (oOut << (tU32)tSelectionCriterionType.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tSelectionCriterionType.size(); ++u32Idx)
         (tVoid) (oOut << tSelectionCriterionType[u32Idx]);
   }
   (tVoid) (oOut << bGuidancePossible);
   (tVoid) (oOut << bAmbiguous);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nNumberOfElements == roRef.nNumberOfElements);
   bResult = bResult && (tLocationDescription == roRef.tLocationDescription);
      bResult = bResult && (tSelectionCriterionType.size() == roRef.tSelectionCriterionType.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tSelectionCriterionType.size()); ++u32Idx)
            bResult = bResult && (tSelectionCriterionType[u32Idx] == roRef.tSelectionCriterionType[u32Idx]);
      }
   bResult = bResult && (bGuidancePossible == roRef.bGuidancePossible);
   bResult = bResult && (bAmbiguous == roRef.bAmbiguous);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tLocationType = coRef.tLocationType;
   nAmbiguityAbsVal = coRef.nAmbiguityAbsVal;
   VDESearchLanguage = coRef.VDESearchLanguage;
   VDESearchDetails = coRef.VDESearchDetails;
}
sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tLocationType = coRef.tLocationType;
   nAmbiguityAbsVal = coRef.nAmbiguityAbsVal;
   VDESearchLanguage = coRef.VDESearchLanguage;
   VDESearchDetails = coRef.VDESearchDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::vDestroy()
{
   tLocationDescription.vDestroy(); 
   VDESearchLanguage.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < VDESearchDetails.size(); ++u32Idx)
         VDESearchDetails[u32Idx].vDestroy();
   VDESearchDetails.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart()
:nNumberOfElements(0)
,tLocationDescription()
,tLocationType()
,nAmbiguityAbsVal(0)
,VDESearchLanguage()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONITEMMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::~sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+tLocationDescription.u32GetSize(u16MajorVersion)+VDESearchDetails.size()*5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nNumberOfElements);
   (tVoid) (oIn >> tLocationDescription);
   (tVoid) (oIn >> tLocationType);
   (tVoid) (oIn >> nAmbiguityAbsVal);
   (tVoid) (oIn >> VDESearchLanguage);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VDESearchDetails.size(); ++u32Idx)
      {
         VDESearchDetails[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      VDESearchDetails.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VDESearchDetails[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nNumberOfElements);
   (tVoid) (oOut << tLocationDescription);
   (tVoid) (oOut << tLocationType);
   (tVoid) (oOut << nAmbiguityAbsVal);
   (tVoid) (oOut << VDESearchLanguage);
   (tVoid) (oOut << (tU32)VDESearchDetails.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VDESearchDetails.size(); ++u32Idx)
         (tVoid) (oOut << VDESearchDetails[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nNumberOfElements == roRef.nNumberOfElements);
   bResult = bResult && (tLocationDescription == roRef.tLocationDescription);
   bResult = bResult && (tLocationType == roRef.tLocationType);
   bResult = bResult && (nAmbiguityAbsVal == roRef.nAmbiguityAbsVal);
   bResult = bResult && (VDESearchLanguage == roRef.VDESearchLanguage);
      bResult = bResult && (VDESearchDetails.size() == roRef.VDESearchDetails.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VDESearchDetails.size()); ++u32Idx)
            bResult = bResult && (VDESearchDetails[u32Idx] == roRef.VDESearchDetails[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tSelectionCriterionType = coRef.tSelectionCriterionType;
   nAnswerOptions = coRef.nAnswerOptions;
}
sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tSelectionCriterionType = coRef.tSelectionCriterionType;
   nAnswerOptions = coRef.nAnswerOptions;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::vDestroy()
{
   tLocationDescription.vDestroy(); 
   {
   tSelectionCriterionType.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult()
:nNumberOfElements(0)
,tLocationDescription()

,nAnswerOptions()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONITEMMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::~sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+6+tLocationDescription.u32GetSize(u16MajorVersion)+tSelectionCriterionType.size()*2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nNumberOfElements);
   (tVoid) (oIn >> tLocationDescription);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      tSelectionCriterionType.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tSelectionCriterionType[u32Idx]);
      }
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> nAnswerOptions);
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nNumberOfElements);
   (tVoid) (oOut << tLocationDescription);
   (tVoid) (oOut << (tU32)tSelectionCriterionType.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tSelectionCriterionType.size(); ++u32Idx)
         (tVoid) (oOut << tSelectionCriterionType[u32Idx]);
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << nAnswerOptions);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationItemMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nNumberOfElements == roRef.nNumberOfElements);
   bResult = bResult && (tLocationDescription == roRef.tLocationDescription);
      bResult = bResult && (tSelectionCriterionType.size() == roRef.tSelectionCriterionType.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tSelectionCriterionType.size()); ++u32Idx)
            bResult = bResult && (tSelectionCriterionType[u32Idx] == roRef.tSelectionCriterionType[u32Idx]);
      }
   bResult = bResult && (nAnswerOptions == roRef.nAnswerOptions);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   tSelectionCriterionType = coRef.tSelectionCriterionType;
   tLocationDescription = coRef.tLocationDescription;
   nLimit = coRef.nLimit;
   nListOffset = coRef.nListOffset;
   nSortOption = coRef.nSortOption;
}
sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   tSelectionCriterionType = coRef.tSelectionCriterionType;
   tLocationDescription = coRef.tLocationDescription;
   nLimit = coRef.nLimit;
   nListOffset = coRef.nListOffset;
   nSortOption = coRef.nSortOption;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::vDestroy()
{
   tLocationDescription.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart()
:tSelectionCriterionType()
,tLocationDescription()
,nLimit(0)
,nListOffset(0)
,nSortOption()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETAMBIGUITYLISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+tLocationDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSelectionCriterionType);
   (tVoid) (oIn >> tLocationDescription);
   (tVoid) (oIn >> nLimit);
   (tVoid) (oIn >> nListOffset);
   (tVoid) (oIn >> nSortOption);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSelectionCriterionType);
   (tVoid) (oOut << tLocationDescription);
   (tVoid) (oOut << nLimit);
   (tVoid) (oOut << nListOffset);
   (tVoid) (oOut << nSortOption);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSelectionCriterionType == roRef.tSelectionCriterionType);
   bResult = bResult && (tLocationDescription == roRef.tLocationDescription);
   bResult = bResult && (nLimit == roRef.nLimit);
   bResult = bResult && (nListOffset == roRef.nListOffset);
   bResult = bResult && (nSortOption == roRef.nSortOption);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nNumberOfElements = coRef.nNumberOfElements;
   nNextOptions = coRef.nNextOptions;
   tAmbiguities = coRef.tAmbiguities;
}
sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nNumberOfElements = coRef.nNumberOfElements;
   nNextOptions = coRef.nNextOptions;
   tAmbiguities = coRef.tAmbiguities;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::vDestroy()
{
   tAmbiguities.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult()
:nNumberOfElements(0)
,nNextOptions()
,tAmbiguities()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETAMBIGUITYLISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+tAmbiguities.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nNumberOfElements);
   (tVoid) (oIn >> nNextOptions);
   (tVoid) (oIn >> tAmbiguities);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nNumberOfElements);
   (tVoid) (oOut << nNextOptions);
   (tVoid) (oOut << tAmbiguities);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetAmbiguityListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nNumberOfElements == roRef.nNumberOfElements);
   bResult = bResult && (nNextOptions == roRef.nNextOptions);
   bResult = bResult && (tAmbiguities == roRef.tAmbiguities);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart(const sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nListContent = coRef.nListContent;
}
sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nListContent = coRef.nListContent;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart()
:nListContent()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWTMCLISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::~sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nListContent);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nListContent);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nListContent == roRef.nListContent);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult::sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWTMCLISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult::~sds2hmi_sdsfi_tclMsgNaviShowTmcListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart(const sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nPoiSource = coRef.nPoiSource;
   nListContent = coRef.nListContent;
   nValue = coRef.nValue;
}
sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nPoiSource = coRef.nPoiSource;
   nListContent = coRef.nListContent;
   nValue = coRef.nValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart()
:nPoiSource()
,nListContent()
,nValue(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWPOILISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::~sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nPoiSource);
   (tVoid) (oIn >> nListContent);
   (tVoid) (oIn >> nValue);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nPoiSource);
   (tVoid) (oOut << nListContent);
   (tVoid) (oOut << nValue);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nPoiSource == roRef.nPoiSource);
   bResult = bResult && (nListContent == roRef.nListContent);
   bResult = bResult && (nValue == roRef.nValue);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult::sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISHOWPOILISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult::~sds2hmi_sdsfi_tclMsgNaviShowPoiListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nPoiSource = coRef.nPoiSource;
   nListContent = coRef.nListContent;
   nSelectionType = coRef.nSelectionType;
   nNumberOfEntries = coRef.nNumberOfEntries;
   nCurrentFirstID = coRef.nCurrentFirstID;
   nCurrentLastID = coRef.nCurrentLastID;
}
sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nPoiSource = coRef.nPoiSource;
   nListContent = coRef.nListContent;
   nSelectionType = coRef.nSelectionType;
   nNumberOfEntries = coRef.nNumberOfEntries;
   nCurrentFirstID = coRef.nCurrentFirstID;
   nCurrentLastID = coRef.nCurrentLastID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart()
:nPoiSource()
,nListContent()
,nSelectionType()
,nNumberOfEntries(0)
,nCurrentFirstID(0)
,nCurrentLastID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETPOICATEGORIESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nPoiSource);
   (tVoid) (oIn >> nListContent);
   (tVoid) (oIn >> nSelectionType);
   (tVoid) (oIn >> nNumberOfEntries);
   (tVoid) (oIn >> nCurrentFirstID);
   (tVoid) (oIn >> nCurrentLastID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nPoiSource);
   (tVoid) (oOut << nListContent);
   (tVoid) (oOut << nSelectionType);
   (tVoid) (oOut << nNumberOfEntries);
   (tVoid) (oOut << nCurrentFirstID);
   (tVoid) (oOut << nCurrentLastID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nPoiSource == roRef.nPoiSource);
   bResult = bResult && (nListContent == roRef.nListContent);
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   bResult = bResult && (nNumberOfEntries == roRef.nNumberOfEntries);
   bResult = bResult && (nCurrentFirstID == roRef.nCurrentFirstID);
   bResult = bResult && (nCurrentLastID == roRef.nCurrentLastID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   sListEntries = coRef.sListEntries;
   bNoMoreEntries = coRef.bNoMoreEntries;
}
sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   sListEntries = coRef.sListEntries;
   bNoMoreEntries = coRef.bNoMoreEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < sListEntries.size(); ++u32Idx)
         sListEntries[u32Idx].vDestroy();
   sListEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult()

:bNoMoreEntries(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETPOICATEGORIESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < sListEntries.size(); ++u32ListIdx)
      u32DynamicSize += sListEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < sListEntries.size(); ++u32Idx)
      {
         sListEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      sListEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> sListEntries[u32Idx]);
      }
   }
   (tVoid) (oIn >> bNoMoreEntries);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)sListEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < sListEntries.size(); ++u32Idx)
         (tVoid) (oOut << sListEntries[u32Idx]);
   }
   (tVoid) (oOut << bNoMoreEntries);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetPoiCategoriesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (sListEntries.size() == roRef.sListEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < sListEntries.size()); ++u32Idx)
            bResult = bResult && (sListEntries[u32Idx] == roRef.sListEntries[u32Idx]);
      }
   bResult = bResult && (bNoMoreEntries == roRef.bNoMoreEntries);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nListEntryType = coRef.nListEntryType;
   nSelectionType = coRef.nSelectionType;
   nNumberOfEntries = coRef.nNumberOfEntries;
   nCurrentFirstID = coRef.nCurrentFirstID;
   nCurrentLastID = coRef.nCurrentLastID;
}
sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nListEntryType = coRef.nListEntryType;
   nSelectionType = coRef.nSelectionType;
   nNumberOfEntries = coRef.nNumberOfEntries;
   nCurrentFirstID = coRef.nCurrentFirstID;
   nCurrentLastID = coRef.nCurrentLastID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart()
:nListEntryType()
,nSelectionType()
,nNumberOfEntries(0)
,nCurrentFirstID(0)
,nCurrentLastID(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETTMCLISTENTRIESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nListEntryType);
   (tVoid) (oIn >> nSelectionType);
   (tVoid) (oIn >> nNumberOfEntries);
   (tVoid) (oIn >> nCurrentFirstID);
   (tVoid) (oIn >> nCurrentLastID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nListEntryType);
   (tVoid) (oOut << nSelectionType);
   (tVoid) (oOut << nNumberOfEntries);
   (tVoid) (oOut << nCurrentFirstID);
   (tVoid) (oOut << nCurrentLastID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nListEntryType == roRef.nListEntryType);
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   bResult = bResult && (nNumberOfEntries == roRef.nNumberOfEntries);
   bResult = bResult && (nCurrentFirstID == roRef.nCurrentFirstID);
   bResult = bResult && (nCurrentLastID == roRef.nCurrentLastID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   tTmcListEntries = coRef.tTmcListEntries;
   bNoMoreEntries = coRef.bNoMoreEntries;
}
sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   tTmcListEntries = coRef.tTmcListEntries;
   bNoMoreEntries = coRef.bNoMoreEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < tTmcListEntries.size(); ++u32Idx)
         tTmcListEntries[u32Idx].vDestroy();
   tTmcListEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult()

:bNoMoreEntries(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETTMCLISTENTRIESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < tTmcListEntries.size(); ++u32ListIdx)
      u32DynamicSize += tTmcListEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < tTmcListEntries.size(); ++u32Idx)
      {
         tTmcListEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      tTmcListEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> tTmcListEntries[u32Idx]);
      }
   }
   (tVoid) (oIn >> bNoMoreEntries);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)tTmcListEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < tTmcListEntries.size(); ++u32Idx)
         (tVoid) (oOut << tTmcListEntries[u32Idx]);
   }
   (tVoid) (oOut << bNoMoreEntries);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetTmcListEntriesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (tTmcListEntries.size() == roRef.tTmcListEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < tTmcListEntries.size()); ++u32Idx)
            bResult = bResult && (tTmcListEntries[u32Idx] == roRef.tTmcListEntries[u32Idx]);
      }
   bResult = bResult && (bNoMoreEntries == roRef.bNoMoreEntries);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart(const sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nListEntryType = coRef.nListEntryType;
   nIDValue = coRef.nIDValue;
}
sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nListEntryType = coRef.nListEntryType;
   nIDValue = coRef.nIDValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart()
:nListEntryType()
,nIDValue(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTTMCLISTENTRYMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::~sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nListEntryType);
   (tVoid) (oIn >> nIDValue);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nListEntryType);
   (tVoid) (oOut << nIDValue);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nListEntryType == roRef.nListEntryType);
   bResult = bResult && (nIDValue == roRef.nIDValue);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult::sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISELECTTMCLISTENTRYMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult::~sds2hmi_sdsfi_tclMsgNaviSelectTmcListEntryMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart(const sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ContactID = coRef.ContactID;
   LocationType = coRef.LocationType;
}
sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ContactID = coRef.ContactID;
   LocationType = coRef.LocationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart()
:ContactID(0)
,LocationType()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONCONTACTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::~sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContactID);
   (tVoid) (oIn >> LocationType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContactID);
   (tVoid) (oOut << LocationType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContactID == roRef.ContactID);
   bResult = bResult && (LocationType == roRef.LocationType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult::sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONCONTACTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult::~sds2hmi_sdsfi_tclMsgNaviSetDestinationContactMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart::sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONASWAYPOINTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart::~sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult(const sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nWaypointMustBeDeleted = coRef.nWaypointMustBeDeleted;
}
sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nWaypointMustBeDeleted = coRef.nWaypointMustBeDeleted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult()
:nWaypointMustBeDeleted(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISETDESTINATIONASWAYPOINTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::~sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nWaypointMustBeDeleted);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nWaypointMustBeDeleted);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviSetDestinationAsWaypointMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nWaypointMustBeDeleted == roRef.nWaypointMustBeDeleted);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart::sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETHOUSENUMBERRANGEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
   sFirst = coRef.sFirst;
   sLast = coRef.sLast;
   PatternList = coRef.PatternList;
}
sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   sFirst = coRef.sFirst;
   sLast = coRef.sLast;
   PatternList = coRef.PatternList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::vDestroy()
{
   sFirst.vDestroy();
   sLast.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < PatternList.size(); ++u32Idx)
         PatternList[u32Idx].vDestroy();
   PatternList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult()
:bResult(0)
,sFirst()
,sLast()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETHOUSENUMBERRANGEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 4;
      for (u32ListIdx = 0; u32ListIdx < PatternList.size(); ++u32ListIdx)
         u32DynamicSize += PatternList[u32ListIdx].u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+1+sFirst.u32GetSize(u16MajorVersion)+sLast.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   (tVoid) (oIn >> sFirst);
   (tVoid) (oIn >> sLast);
   if (1 <= oIn.u16GetMajorVersion())
   {
      {
         tU32 u32Length;
         tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
         for (u32Idx = 0; u32Idx < PatternList.size(); ++u32Idx)
         {
            PatternList[u32Idx].vDestroy();
         }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
         (tVoid) (oIn >> u32Length);
         PatternList.resize(u32Length);
         for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
         {
            (tVoid) (oIn >> PatternList[u32Idx]);
         }
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   (tVoid) (oOut << sFirst);
   (tVoid) (oOut << sLast);
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << (tU32)PatternList.size());
      {
         for (tU32 u32Idx = 0; u32Idx < PatternList.size(); ++u32Idx)
            (tVoid) (oOut << PatternList[u32Idx]);
      }
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   bResult = bResult && (sFirst == roRef.sFirst);
   bResult = bResult && (sLast == roRef.sLast);
      bResult = bResult && (PatternList.size() == roRef.PatternList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PatternList.size()); ++u32Idx)
            bResult = bResult && (PatternList[u32Idx] == roRef.PatternList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart::sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETWAYPOINTLISTINFOMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   bWaypointMustBeDeleted = coRef.bWaypointMustBeDeleted;
}
sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bWaypointMustBeDeleted = coRef.bWaypointMustBeDeleted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult()
:bWaypointMustBeDeleted(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETWAYPOINTLISTINFOMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bWaypointMustBeDeleted);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bWaypointMustBeDeleted);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetWaypointListInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bWaypointMustBeDeleted == roRef.bWaypointMustBeDeleted);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart(const sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tLocationType = coRef.tLocationType;
}
sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tLocationType = coRef.tLocationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::vDestroy()
{
   tLocationDescription.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart()
:nNumberOfElements(0)
,tLocationDescription()
,tLocationType()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTLOCATIONSEARCHMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::~sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+tLocationDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nNumberOfElements);
   (tVoid) (oIn >> tLocationDescription);
   (tVoid) (oIn >> tLocationType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nNumberOfElements);
   (tVoid) (oOut << tLocationDescription);
   (tVoid) (oOut << tLocationType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nNumberOfElements == roRef.nNumberOfElements);
   bResult = bResult && (tLocationDescription == roRef.tLocationDescription);
   bResult = bResult && (tLocationType == roRef.tLocationType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult::sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTLOCATIONSEARCHMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult::~sds2hmi_sdsfi_tclMsgNaviStartLocationSearchMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart(const sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ContactID = coRef.ContactID;
   LocationType = coRef.LocationType;
}
sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::operator=(const sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ContactID = coRef.ContactID;
   LocationType = coRef.LocationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart()
:ContactID(0)
,LocationType()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETCONTACTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::~sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ContactID);
   (tVoid) (oIn >> LocationType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ContactID);
   (tVoid) (oOut << LocationType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart::operator==(const sds2hmi_sdsfi_tclMsgWeatherSetContactMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ContactID == roRef.ContactID);
   bResult = bResult && (LocationType == roRef.LocationType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult::sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETCONTACTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult::~sds2hmi_sdsfi_tclMsgWeatherSetContactMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart(const sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tLocationType = coRef.tLocationType;
}
sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nNumberOfElements = coRef.nNumberOfElements;
   tLocationDescription = coRef.tLocationDescription;
   tLocationType = coRef.tLocationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::vDestroy()
{
   tLocationDescription.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart()
:nNumberOfElements(0)
,tLocationDescription()
,tLocationType()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETLOCATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::~sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+tLocationDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nNumberOfElements);
   (tVoid) (oIn >> tLocationDescription);
   (tVoid) (oIn >> tLocationType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nNumberOfElements);
   (tVoid) (oOut << tLocationDescription);
   (tVoid) (oOut << tLocationType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nNumberOfElements == roRef.nNumberOfElements);
   bResult = bResult && (tLocationDescription == roRef.tLocationDescription);
   bResult = bResult && (tLocationType == roRef.tLocationType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult::sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSETLOCATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult::~sds2hmi_sdsfi_tclMsgWeatherSetLocationMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart::sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETINFOMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart::~sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult(const sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nMoreThanOne = coRef.nMoreThanOne;
   nFirstSMS = coRef.nFirstSMS;
   nLastSMS = coRef.nLastSMS;
   sNameSender = coRef.sNameSender;
   sAdditionalInformation = coRef.sAdditionalInformation;
   sPhoneNumberSender = coRef.sPhoneNumberSender;
   ContactIDs = coRef.ContactIDs;
}
sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::operator=(const sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   nMoreThanOne = coRef.nMoreThanOne;
   nFirstSMS = coRef.nFirstSMS;
   nLastSMS = coRef.nLastSMS;
   sNameSender = coRef.sNameSender;
   sAdditionalInformation = coRef.sAdditionalInformation;
   sPhoneNumberSender = coRef.sPhoneNumberSender;
   ContactIDs = coRef.ContactIDs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::vDestroy()
{
   sNameSender.vDestroy();
   sAdditionalInformation.vDestroy();
   sPhoneNumberSender.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < ContactIDs.size(); ++u32Idx)
         ContactIDs[u32Idx].vDestroy();
   ContactIDs.clear();
   }
}

sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult()
:nMoreThanOne(0)
,nFirstSMS(0)
,nLastSMS(0)
,sNameSender()
,sAdditionalInformation()
,sPhoneNumberSender()

 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETINFOMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::~sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ContactIDs.size(); ++u32ListIdx)
      u32DynamicSize += ContactIDs[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7+sNameSender.u32GetSize(u16MajorVersion)+sAdditionalInformation.u32GetSize(u16MajorVersion)+sPhoneNumberSender.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nMoreThanOne);
   (tVoid) (oIn >> nFirstSMS);
   (tVoid) (oIn >> nLastSMS);
   (tVoid) (oIn >> sNameSender);
   (tVoid) (oIn >> sAdditionalInformation);
   (tVoid) (oIn >> sPhoneNumberSender);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ContactIDs.size(); ++u32Idx)
      {
         ContactIDs[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ContactIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContactIDs[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nMoreThanOne);
   (tVoid) (oOut << nFirstSMS);
   (tVoid) (oOut << nLastSMS);
   (tVoid) (oOut << sNameSender);
   (tVoid) (oOut << sAdditionalInformation);
   (tVoid) (oOut << sPhoneNumberSender);
   (tVoid) (oOut << (tU32)ContactIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContactIDs.size(); ++u32Idx)
         (tVoid) (oOut << ContactIDs[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult::operator==(const sds2hmi_sdsfi_tclMsgTextMsgGetInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nMoreThanOne == roRef.nMoreThanOne);
   bResult = bResult && (nFirstSMS == roRef.nFirstSMS);
   bResult = bResult && (nLastSMS == roRef.nLastSMS);
   bResult = bResult && (sNameSender == roRef.sNameSender);
   bResult = bResult && (sAdditionalInformation == roRef.sAdditionalInformation);
   bResult = bResult && (sPhoneNumberSender == roRef.sPhoneNumberSender);
      bResult = bResult && (ContactIDs.size() == roRef.ContactIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContactIDs.size()); ++u32Idx)
            bResult = bResult && (ContactIDs[u32Idx] == roRef.ContactIDs[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart::sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGCALLBACKSENDERMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart::~sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult::sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGCALLBACKSENDERMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult::~sds2hmi_sdsfi_tclMsgTextMsgCallbackSenderMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart(const sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SelectionType = coRef.SelectionType;
   nContentID = coRef.nContentID;
   Message = coRef.Message;
}
sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectionType = coRef.SelectionType;
   nContentID = coRef.nContentID;
   Message = coRef.Message;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::vDestroy()
{
   Message.vDestroy();
}

sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart()
:SelectionType()
,nContentID(0)
,Message()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETCONTENTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::~sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Message.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionType);
   (tVoid) (oIn >> nContentID);
   (tVoid) (oIn >> Message);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionType);
   (tVoid) (oOut << nContentID);
   (tVoid) (oOut << Message);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionType == roRef.SelectionType);
   bResult = bResult && (nContentID == roRef.nContentID);
   bResult = bResult && (Message == roRef.Message);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult::sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETCONTENTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult::~sds2hmi_sdsfi_tclMsgTextMsgSetContentMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart(const sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nSelectionType = coRef.nSelectionType;
   ValueID = coRef.ValueID;
   sPhoneNumber = coRef.sPhoneNumber;
   ContactLocation = coRef.ContactLocation;
}
sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nSelectionType = coRef.nSelectionType;
   ValueID = coRef.ValueID;
   sPhoneNumber = coRef.sPhoneNumber;
   ContactLocation = coRef.ContactLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::vDestroy()
{
   sPhoneNumber.vDestroy();
}

sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart()
:nSelectionType()
,ValueID(0)
,sPhoneNumber()
,ContactLocation()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETNUMBERMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::~sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+sPhoneNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nSelectionType);
   (tVoid) (oIn >> ValueID);
   (tVoid) (oIn >> sPhoneNumber);
   (tVoid) (oIn >> ContactLocation);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nSelectionType);
   (tVoid) (oOut << ValueID);
   (tVoid) (oOut << sPhoneNumber);
   (tVoid) (oOut << ContactLocation);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   bResult = bResult && (ValueID == roRef.ValueID);
   bResult = bResult && (sPhoneNumber == roRef.sPhoneNumber);
   bResult = bResult && (ContactLocation == roRef.ContactLocation);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult::sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSETNUMBERMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult::~sds2hmi_sdsfi_tclMsgTextMsgSetNumberMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart::sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSENDMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart::~sds2hmi_sdsfi_tclMsgTextMsgSendMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult::sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSENDMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult::~sds2hmi_sdsfi_tclMsgTextMsgSendMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart(const sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   nSelectionType = coRef.nSelectionType;
}
sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   nSelectionType = coRef.nSelectionType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart()
:nSelectionType()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSELECTMESSAGEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::~sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> nSelectionType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << nSelectionType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (nSelectionType == roRef.nSelectionType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult::sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSELECTMESSAGEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult::~sds2hmi_sdsfi_tclMsgTextMsgSelectMessageMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   EntryType = coRef.EntryType;
   LocationType = coRef.LocationType;
   ContactIDs = coRef.ContactIDs;
   RequireAllLocationIfNoExactMatch = coRef.RequireAllLocationIfNoExactMatch;
}
sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   EntryType = coRef.EntryType;
   LocationType = coRef.LocationType;
   ContactIDs = coRef.ContactIDs;
   RequireAllLocationIfNoExactMatch = coRef.RequireAllLocationIfNoExactMatch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::vDestroy()
{
   {
   ContactIDs.clear();
   }
}

sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart()
:EntryType()
,LocationType()

,RequireAllLocationIfNoExactMatch(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_CONTACTSGETAMBIGUITYLISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::~sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7+ContactIDs.size()*4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EntryType);
   (tVoid) (oIn >> LocationType);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContactIDs.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContactIDs[u32Idx]);
      }
   }
   (tVoid) (oIn >> RequireAllLocationIfNoExactMatch);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EntryType);
   (tVoid) (oOut << LocationType);
   (tVoid) (oOut << (tU32)ContactIDs.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContactIDs.size(); ++u32Idx)
         (tVoid) (oOut << ContactIDs[u32Idx]);
   }
   (tVoid) (oOut << RequireAllLocationIfNoExactMatch);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EntryType == roRef.EntryType);
   bResult = bResult && (LocationType == roRef.LocationType);
      bResult = bResult && (ContactIDs.size() == roRef.ContactIDs.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContactIDs.size()); ++u32Idx)
            bResult = bResult && (ContactIDs[u32Idx] == roRef.ContactIDs[u32Idx]);
      }
   bResult = bResult && (RequireAllLocationIfNoExactMatch == roRef.RequireAllLocationIfNoExactMatch);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ResultType = coRef.ResultType;
   ResultEntries = coRef.ResultEntries;
}
sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::operator=(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ResultType = coRef.ResultType;
   ResultEntries = coRef.ResultEntries;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ResultEntries.size(); ++u32Idx)
         ResultEntries[u32Idx].vDestroy();
   ResultEntries.clear();
   }
}

sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult()
:ResultType()

 {}

tS32 sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_CONTACTSGETAMBIGUITYLISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::~sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ResultEntries.size(); ++u32ListIdx)
      u32DynamicSize += ResultEntries[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ResultType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ResultEntries.size(); ++u32Idx)
      {
         ResultEntries[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ResultEntries.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ResultEntries[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ResultType);
   (tVoid) (oOut << (tU32)ResultEntries.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ResultEntries.size(); ++u32Idx)
         (tVoid) (oOut << ResultEntries[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult::operator==(const sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ResultType == roRef.ResultType);
      bResult = bResult && (ResultEntries.size() == roRef.ResultEntries.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ResultEntries.size()); ++u32Idx)
            bResult = bResult && (ResultEntries[u32Idx] == roRef.ResultEntries[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   eMenu = coRef.eMenu;
   Param = coRef.Param;
}
sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::operator=(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& coRef)
{
   if (this == &coRef) return *this;
   eMenu = coRef.eMenu;
   Param = coRef.Param;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::vDestroy()
{
   Param.vDestroy();
}

sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart()
:eMenu()
,Param()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWMENUMETHODSTART;
}


sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::~sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Param.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> eMenu);
   (tVoid) (oIn >> Param);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << eMenu);
   (tVoid) (oOut << Param);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart::operator==(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (eMenu == roRef.eMenu);
   bResult = bResult && (Param == roRef.Param);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult::sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWMENUMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult::~sds2hmi_sdsfi_tclMsgInfoShowMenuMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart::sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_VDLGETDATABASESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart::~sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult(const sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Slots = coRef.Slots;
}
sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Slots = coRef.Slots;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
         Slots[u32Idx].vDestroy();
   Slots.clear();
   }
}

sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_VDLGETDATABASESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::~sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Slots.size(); ++u32ListIdx)
      u32DynamicSize += Slots[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
      {
         Slots[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Slots.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Slots[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Slots.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
         (tVoid) (oOut << Slots[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgVDLGetDatabasesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Slots.size() == roRef.Slots.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Slots.size()); ++u32Idx)
            bResult = bResult && (Slots[u32Idx] == roRef.Slots[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart(const sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   sAppName = coRef.sAppName;
   AppId = coRef.AppId;
}
sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sAppName = coRef.sAppName;
   AppId = coRef.AppId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::vDestroy()
{
   sAppName.vDestroy();
}

sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart()
:sAppName()
,AppId(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_APPSLAUNCHAPPLICATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::~sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sAppName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAppName);
   (tVoid) (oIn >> AppId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAppName);
   (tVoid) (oOut << AppId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAppName == roRef.sAppName);
   bResult = bResult && (AppId == roRef.AppId);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult::sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_APPSLAUNCHAPPLICATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult::~sds2hmi_sdsfi_tclMsgAppsLaunchApplicationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Domain = coRef.Domain;
}
sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Domain = coRef.Domain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart()
:Domain()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETDYNACCESSINFOMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::~sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Domain);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Domain);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Domain == roRef.Domain);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult::sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETDYNACCESSINFOMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult::~sds2hmi_sdsfi_tclMsgCommonSetDynAccessInfoMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Radius = coRef.Radius;
   LocationDescription = coRef.LocationDescription;
}
sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Radius = coRef.Radius;
   LocationDescription = coRef.LocationDescription;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::vDestroy()
{
   LocationDescription.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart()
:Radius(0)
,LocationDescription()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETNEARBYSTATESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+LocationDescription.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Radius);
   (tVoid) (oIn >> LocationDescription);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Radius);
   (tVoid) (oOut << LocationDescription);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Radius == roRef.Radius);
   bResult = bResult && (LocationDescription == roRef.LocationDescription);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   NearbyStateList = coRef.NearbyStateList;
}
sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   NearbyStateList = coRef.NearbyStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < NearbyStateList.size(); ++u32Idx)
         NearbyStateList[u32Idx].vDestroy();
   NearbyStateList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETNEARBYSTATESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < NearbyStateList.size(); ++u32ListIdx)
      u32DynamicSize += NearbyStateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NearbyStateList.size(); ++u32Idx)
      {
         NearbyStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NearbyStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NearbyStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)NearbyStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NearbyStateList.size(); ++u32Idx)
         (tVoid) (oOut << NearbyStateList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetNearbyStatesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (NearbyStateList.size() == roRef.NearbyStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NearbyStateList.size()); ++u32Idx)
            bResult = bResult && (NearbyStateList[u32Idx] == roRef.NearbyStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DescriptionMode = coRef.DescriptionMode;
   ElementReference = coRef.ElementReference;
   HMIId = coRef.HMIId;
}
sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DescriptionMode = coRef.DescriptionMode;
   ElementReference = coRef.ElementReference;
   HMIId = coRef.HMIId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart()
:DescriptionMode()
,ElementReference()
,HMIId(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMIELEMENTDESCRIPTIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::~sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DescriptionMode);
   (tVoid) (oIn >> ElementReference);
   (tVoid) (oIn >> HMIId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DescriptionMode);
   (tVoid) (oOut << ElementReference);
   (tVoid) (oOut << HMIId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DescriptionMode == roRef.DescriptionMode);
   bResult = bResult && (ElementReference == roRef.ElementReference);
   bResult = bResult && (HMIId == roRef.HMIId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Description = coRef.Description;
}
sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Description = coRef.Description;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Description.size(); ++u32Idx)
         Description[u32Idx].vDestroy();
   Description.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMIELEMENTDESCRIPTIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::~sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Description.size(); ++u32ListIdx)
      u32DynamicSize += Description[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Description.size(); ++u32Idx)
      {
         Description[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Description.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Description[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Description.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Description.size(); ++u32Idx)
         (tVoid) (oOut << Description[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult::operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIElementDescriptionMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Description.size() == roRef.Description.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Description.size()); ++u32Idx)
            bResult = bResult && (Description[u32Idx] == roRef.Description[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart::sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIREPEATINSTRUCTIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart::~sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult::sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIREPEATINSTRUCTIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult::~sds2hmi_sdsfi_tclMsgNaviRepeatInstructionMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart::sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETCONTENTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart::~sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult(const sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   TxtMessage = coRef.TxtMessage;
}
sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::operator=(const sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TxtMessage = coRef.TxtMessage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::vDestroy()
{
   TxtMessage.vDestroy();
}

sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult()
:TxtMessage()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGGETCONTENTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::~sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TxtMessage.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TxtMessage);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TxtMessage);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult::operator==(const sds2hmi_sdsfi_tclMsgTextMsgGetContentMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TxtMessage == roRef.TxtMessage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ListType = coRef.ListType;
}
sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListType = coRef.ListType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart()
:ListType()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMILISTDESCRIPTIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::~sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListType == roRef.ListType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DescriptionList = coRef.DescriptionList;
}
sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::operator=(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DescriptionList = coRef.DescriptionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
         DescriptionList[u32Idx].vDestroy();
   DescriptionList.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONGETHMILISTDESCRIPTIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::~sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += DescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
      {
         DescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DescriptionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DescriptionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
         (tVoid) (oOut << DescriptionList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult::operator==(const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DescriptionList.size() == roRef.DescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DescriptionList.size()); ++u32Idx)
            bResult = bResult && (DescriptionList[u32Idx] == roRef.DescriptionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart(const sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   ContactInfo = coRef.ContactInfo;
   UniqueId = coRef.UniqueId;
   NumberType = coRef.NumberType;
   Relationship = coRef.Relationship;
}
sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   ContactInfo = coRef.ContactInfo;
   UniqueId = coRef.UniqueId;
   NumberType = coRef.NumberType;
   Relationship = coRef.Relationship;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::vDestroy()
{
   ContactInfo.vDestroy();
}

sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart()
:Action()
,ContactInfo()
,UniqueId(0)
,NumberType()
,Relationship()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEUPDATEPHONEBOOKMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::~sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+ContactInfo.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> ContactInfo);
   (tVoid) (oIn >> UniqueId);
   (tVoid) (oIn >> NumberType);
   (tVoid) (oIn >> Relationship);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << ContactInfo);
   (tVoid) (oOut << UniqueId);
   (tVoid) (oOut << NumberType);
   (tVoid) (oOut << Relationship);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (ContactInfo == roRef.ContactInfo);
   bResult = bResult && (UniqueId == roRef.UniqueId);
   bResult = bResult && (NumberType == roRef.NumberType);
   bResult = bResult && (Relationship == roRef.Relationship);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult::sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEUPDATEPHONEBOOKMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult::~sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SearchString = coRef.SearchString;
}
sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SearchString = coRef.SearchString;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SearchString.size(); ++u32Idx)
         SearchString[u32Idx].vDestroy();
   SearchString.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETSEARCHLOCATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::~sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SearchString.size(); ++u32ListIdx)
      u32DynamicSize += SearchString[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SearchString.size(); ++u32Idx)
      {
         SearchString[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SearchString.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SearchString[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SearchString.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SearchString.size(); ++u32Idx)
         (tVoid) (oOut << SearchString[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SearchString.size() == roRef.SearchString.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SearchString.size()); ++u32Idx)
            bResult = bResult && (SearchString[u32Idx] == roRef.SearchString[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SearchLocation = coRef.SearchLocation;
}
sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SearchLocation = coRef.SearchLocation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult()
:SearchLocation()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIGETSEARCHLOCATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::~sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SearchLocation);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SearchLocation);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SearchLocation == roRef.SearchLocation);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart(const sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SDS_Event = coRef.SDS_Event;
   Val_Num = coRef.Val_Num;
   Val_Str = coRef.Val_Str;
}
sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SDS_Event = coRef.SDS_Event;
   Val_Num = coRef.Val_Num;
   Val_Str = coRef.Val_Str;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::vDestroy()
{
   Val_Str.vDestroy();
}

sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart()
:SDS_Event()
,Val_Num(0)
,Val_Str()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETSDSEVENTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::~sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Val_Str.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SDS_Event);
   (tVoid) (oIn >> Val_Num);
   (tVoid) (oIn >> Val_Str);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SDS_Event);
   (tVoid) (oOut << Val_Num);
   (tVoid) (oOut << Val_Str);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SDS_Event == roRef.SDS_Event);
   bResult = bResult && (Val_Num == roRef.Val_Num);
   bResult = bResult && (Val_Str == roRef.Val_Str);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult::sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETSDSEVENTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult::~sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart(const sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SelectionBy = coRef.SelectionBy;
   Val_Id = coRef.Val_Id;
   Val_Name = coRef.Val_Name;
}
sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::operator=(const sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SelectionBy = coRef.SelectionBy;
   Val_Id = coRef.Val_Id;
   Val_Name = coRef.Val_Name;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::vDestroy()
{
   Val_Name.vDestroy();
}

sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart()
:SelectionBy()
,Val_Id(0)
,Val_Name()
 {}

tS32 sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TVSELECTSTATIONMETHODSTART;
}


sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::~sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+Val_Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SelectionBy);
   (tVoid) (oIn >> Val_Id);
   (tVoid) (oIn >> Val_Name);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SelectionBy);
   (tVoid) (oOut << Val_Id);
   (tVoid) (oOut << Val_Name);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart::operator==(const sds2hmi_sdsfi_tclMsgTVSelectStationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SelectionBy == roRef.SelectionBy);
   bResult = bResult && (Val_Id == roRef.Val_Id);
   bResult = bResult && (Val_Name == roRef.Val_Name);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult::sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TVSELECTSTATIONMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult::~sds2hmi_sdsfi_tclMsgTVSelectStationMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   NDSLanguageID = coRef.NDSLanguageID;
   CityIdList = coRef.CityIdList;
}
sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NDSLanguageID = coRef.NDSLanguageID;
   CityIdList = coRef.CityIdList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::vDestroy()
{
   NDSLanguageID.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < CityIdList.size(); ++u32Idx)
         CityIdList[u32Idx].vDestroy();
   CityIdList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart()
:NDSLanguageID()

 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTREETAVAILABILITYMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::~sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+NDSLanguageID.u32GetSize(u16MajorVersion)+CityIdList.size()*24;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NDSLanguageID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CityIdList.size(); ++u32Idx)
      {
         CityIdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CityIdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CityIdList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NDSLanguageID);
   (tVoid) (oOut << (tU32)CityIdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CityIdList.size(); ++u32Idx)
         (tVoid) (oOut << CityIdList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NDSLanguageID == roRef.NDSLanguageID);
      bResult = bResult && (CityIdList.size() == roRef.CityIdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CityIdList.size()); ++u32Idx)
            bResult = bResult && (CityIdList[u32Idx] == roRef.CityIdList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   StreetAvailabilityList = coRef.StreetAvailabilityList;
}
sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StreetAvailabilityList = coRef.StreetAvailabilityList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StreetAvailabilityList.size(); ++u32Idx)
         StreetAvailabilityList[u32Idx].vDestroy();
   StreetAvailabilityList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTREETAVAILABILITYMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::~sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+StreetAvailabilityList.size()*25;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StreetAvailabilityList.size(); ++u32Idx)
      {
         StreetAvailabilityList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StreetAvailabilityList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StreetAvailabilityList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StreetAvailabilityList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StreetAvailabilityList.size(); ++u32Idx)
         (tVoid) (oOut << StreetAvailabilityList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStreetAvailabilityMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StreetAvailabilityList.size() == roRef.StreetAvailabilityList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StreetAvailabilityList.size()); ++u32Idx)
            bResult = bResult && (StreetAvailabilityList[u32Idx] == roRef.StreetAvailabilityList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   NDSLanguageIDList = coRef.NDSLanguageIDList;
   IdList = coRef.IdList;
   GetString = coRef.GetString;
   GetPhoneme = coRef.GetPhoneme;
   SearchSetting = coRef.SearchSetting;
}
sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NDSLanguageIDList = coRef.NDSLanguageIDList;
   IdList = coRef.IdList;
   GetString = coRef.GetString;
   GetPhoneme = coRef.GetPhoneme;
   SearchSetting = coRef.SearchSetting;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < NDSLanguageIDList.size(); ++u32Idx)
         NDSLanguageIDList[u32Idx].vDestroy();
   NDSLanguageIDList.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < IdList.size(); ++u32Idx)
         IdList[u32Idx].vDestroy();
   IdList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart()


:GetString(0)
,GetPhoneme(0)
,SearchSetting()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTRINGANDPHONEMEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::~sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < NDSLanguageIDList.size(); ++u32ListIdx)
      u32DynamicSize += NDSLanguageIDList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11+IdList.size()*24;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < NDSLanguageIDList.size(); ++u32Idx)
      {
         NDSLanguageIDList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      NDSLanguageIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> NDSLanguageIDList[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < IdList.size(); ++u32Idx)
      {
         IdList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      IdList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> IdList[u32Idx]);
      }
   }
   (tVoid) (oIn >> GetString);
   (tVoid) (oIn >> GetPhoneme);
   (tVoid) (oIn >> SearchSetting);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)NDSLanguageIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < NDSLanguageIDList.size(); ++u32Idx)
         (tVoid) (oOut << NDSLanguageIDList[u32Idx]);
   }
   (tVoid) (oOut << (tU32)IdList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < IdList.size(); ++u32Idx)
         (tVoid) (oOut << IdList[u32Idx]);
   }
   (tVoid) (oOut << GetString);
   (tVoid) (oOut << GetPhoneme);
   (tVoid) (oOut << SearchSetting);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (NDSLanguageIDList.size() == roRef.NDSLanguageIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < NDSLanguageIDList.size()); ++u32Idx)
            bResult = bResult && (NDSLanguageIDList[u32Idx] == roRef.NDSLanguageIDList[u32Idx]);
      }
      bResult = bResult && (IdList.size() == roRef.IdList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < IdList.size()); ++u32Idx)
            bResult = bResult && (IdList[u32Idx] == roRef.IdList[u32Idx]);
      }
   bResult = bResult && (GetString == roRef.GetString);
   bResult = bResult && (GetPhoneme == roRef.GetPhoneme);
   bResult = bResult && (SearchSetting == roRef.SearchSetting);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   StringPhonemeList = coRef.StringPhonemeList;
}
sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StringPhonemeList = coRef.StringPhonemeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringPhonemeList.size(); ++u32Idx)
         StringPhonemeList[u32Idx].vDestroy();
   StringPhonemeList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETSTRINGANDPHONEMEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::~sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringPhonemeList.size(); ++u32ListIdx)
      u32DynamicSize += StringPhonemeList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringPhonemeList.size(); ++u32Idx)
      {
         StringPhonemeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringPhonemeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringPhonemeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringPhonemeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringPhonemeList.size(); ++u32Idx)
         (tVoid) (oOut << StringPhonemeList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNavDataGetStringAndPhonemeMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringPhonemeList.size() == roRef.StringPhonemeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringPhonemeList.size()); ++u32Idx)
            bResult = bResult && (StringPhonemeList[u32Idx] == roRef.StringPhonemeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DataSetId = coRef.DataSetId;
}
sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart()
:DataSetId(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAREGISTERDIRECTNDSUSEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::~sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataSetId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataSetId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataSetId == roRef.DataSetId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Device = coRef.Device;
   PersistentDataSetId = coRef.PersistentDataSetId;
   SDSProductList = coRef.SDSProductList;
}
sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Device = coRef.Device;
   PersistentDataSetId = coRef.PersistentDataSetId;
   SDSProductList = coRef.SDSProductList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::vDestroy()
{
   Device.vDestroy();
   PersistentDataSetId.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < SDSProductList.size(); ++u32Idx)
         SDSProductList[u32Idx].vDestroy();
   SDSProductList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult()
:Device()
,PersistentDataSetId()

 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAREGISTERDIRECTNDSUSEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::~sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SDSProductList.size(); ++u32ListIdx)
      u32DynamicSize += SDSProductList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4+Device.u32GetSize(u16MajorVersion)+PersistentDataSetId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Device);
   (tVoid) (oIn >> PersistentDataSetId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SDSProductList.size(); ++u32Idx)
      {
         SDSProductList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SDSProductList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SDSProductList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Device);
   (tVoid) (oOut << PersistentDataSetId);
   (tVoid) (oOut << (tU32)SDSProductList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SDSProductList.size(); ++u32Idx)
         (tVoid) (oOut << SDSProductList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNavDataRegisterDirectNDSUseMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Device == roRef.Device);
   bResult = bResult && (PersistentDataSetId == roRef.PersistentDataSetId);
      bResult = bResult && (SDSProductList.size() == roRef.SDSProductList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SDSProductList.size()); ++u32Idx)
            bResult = bResult && (SDSProductList[u32Idx] == roRef.SDSProductList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DataSetId = coRef.DataSetId;
}
sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart()
:DataSetId(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAUNREGISTERDIRECTNDSUSEMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::~sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataSetId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataSetId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataSetId == roRef.DataSetId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult()
:Status()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAUNREGISTERDIRECTNDSUSEMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::~sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult()
{}

tU32 sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNavDataUnRegisterDirectNDSUseMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   NDSLanguageID = coRef.NDSLanguageID;
}
sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   NDSLanguageID = coRef.NDSLanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::vDestroy()
{
   NDSLanguageID.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart()
:NDSLanguageID()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETCOUNTRYSTATELISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::~sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+NDSLanguageID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NDSLanguageID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NDSLanguageID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NDSLanguageID == roRef.NDSLanguageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   CountryStateList = coRef.CountryStateList;
}
sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CountryStateList = coRef.CountryStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         CountryStateList[u32Idx].vDestroy();
   CountryStateList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAGETCOUNTRYSTATELISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::~sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CountryStateList.size(); ++u32ListIdx)
      u32DynamicSize += CountryStateList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
      {
         CountryStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CountryStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CountryStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CountryStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CountryStateList.size(); ++u32Idx)
         (tVoid) (oOut << CountryStateList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNavDataGetCountryStateListMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CountryStateList.size() == roRef.CountryStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryStateList.size()); ++u32Idx)
            bResult = bResult && (CountryStateList[u32Idx] == roRef.CountryStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   PhoneNumber = coRef.PhoneNumber;
   Language = coRef.Language;
}
sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::operator=(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   PhoneNumber = coRef.PhoneNumber;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::vDestroy()
{
   PhoneNumber.vDestroy();
   Language.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart()
:PhoneNumber()
,Language()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETPHONENUMBERFORMATTEDMETHODSTART;
}


sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::~sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+PhoneNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PhoneNumber);
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PhoneNumber);
   (tVoid) (oOut << Language);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart::operator==(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhoneNumber == roRef.PhoneNumber);
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   FormatttedPhoneNumber = coRef.FormatttedPhoneNumber;
}
sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::operator=(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& coRef)
{
   if (this == &coRef) return *this;
   FormatttedPhoneNumber = coRef.FormatttedPhoneNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::vDestroy()
{
   FormatttedPhoneNumber.vDestroy();
}

sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult()
:FormatttedPhoneNumber()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONEGETPHONENUMBERFORMATTEDMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::~sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+FormatttedPhoneNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FormatttedPhoneNumber);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FormatttedPhoneNumber);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult::operator==(const sds2hmi_sdsfi_tclMsgPhoneGetPhoneNumberFormattedMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FormatttedPhoneNumber == roRef.FormatttedPhoneNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart(const sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ListType = coRef.ListType;
}
sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::operator=(const sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ListType = coRef.ListType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart()
:ListType()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONRESTOREHMILISTMETHODSTART;
}


sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::~sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ListType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ListType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart::operator==(const sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ListType == roRef.ListType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult::sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONRESTOREHMILISTMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult::~sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart(const sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ServiceType = coRef.ServiceType;
}
sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::operator=(const sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ServiceType = coRef.ServiceType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart()
:ServiceType()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWSERVICEADVISORYMETHODSTART;
}


sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::~sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart::operator==(const sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceType == roRef.ServiceType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult::sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSHOWSERVICEADVISORYMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult::~sds2hmi_sdsfi_tclMsgInfoShowServiceAdvisoryMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart(const sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Distance = coRef.Distance;
   Unit = coRef.Unit;
}
sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Unit = coRef.Unit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::vDestroy()
{
   Distance.vDestroy();
}

sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart()
:Distance()
,Unit()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTDISTANCEDETOURMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::~sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Distance.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Unit);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Unit);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Unit == roRef.Unit);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult::sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTARTDISTANCEDETOURMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult::~sds2hmi_sdsfi_tclMsgNaviStartDistanceDetourMethodResult()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart::sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICANCELDISTANCEDETOURMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart::~sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodStart()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult::sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICANCELDISTANCEDETOURMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult::~sds2hmi_sdsfi_tclMsgNaviCancelDistanceDetourMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart(const sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DataSetId = coRef.DataSetId;
   DataAccessType = coRef.DataAccessType;
}
sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   DataAccessType = coRef.DataAccessType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart()
:DataSetId(0)
,DataAccessType()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACCESSMODECHANGEDMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::~sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart()
{}

tU32 sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataSetId);
   (tVoid) (oIn >> DataAccessType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataSetId);
   (tVoid) (oOut << DataAccessType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataSetId == roRef.DataSetId);
   bResult = bResult && (DataAccessType == roRef.DataAccessType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult::sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACCESSMODECHANGEDMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult::~sds2hmi_sdsfi_tclMsgNavDataAccessModeChangedMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   VDESearchLanguage = coRef.VDESearchLanguage;
   VDEList = coRef.VDEList;
}
sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::operator=(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VDESearchLanguage = coRef.VDESearchLanguage;
   VDEList = coRef.VDEList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::vDestroy()
{
   VDESearchLanguage.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < VDEList.size(); ++u32Idx)
         VDEList[u32Idx].vDestroy();
   VDEList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart()
:VDESearchLanguage()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIVALIDATEDESTINATIONENTRIESMETHODSTART;
}


sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::~sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < VDEList.size(); ++u32ListIdx)
      u32DynamicSize += VDEList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VDESearchLanguage);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < VDEList.size(); ++u32Idx)
      {
         VDEList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      VDEList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> VDEList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VDESearchLanguage);
   (tVoid) (oOut << (tU32)VDEList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < VDEList.size(); ++u32Idx)
         (tVoid) (oOut << VDEList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart::operator==(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VDESearchLanguage == roRef.VDESearchLanguage);
      bResult = bResult && (VDEList.size() == roRef.VDEList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < VDEList.size()); ++u32Idx)
            bResult = bResult && (VDEList[u32Idx] == roRef.VDEList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   InvalidList = coRef.InvalidList;
}
sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::operator=(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& coRef)
{
   if (this == &coRef) return *this;
   InvalidList = coRef.InvalidList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < InvalidList.size(); ++u32Idx)
         InvalidList[u32Idx].vDestroy();
   InvalidList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIVALIDATEDESTINATIONENTRIESMETHODRESULT;
}


sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::~sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < InvalidList.size(); ++u32ListIdx)
      u32DynamicSize += InvalidList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < InvalidList.size(); ++u32Idx)
      {
         InvalidList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      InvalidList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> InvalidList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)InvalidList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < InvalidList.size(); ++u32Idx)
         (tVoid) (oOut << InvalidList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult::operator==(const sds2hmi_sdsfi_tclMsgNaviValidateDestinationEntriesMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (InvalidList.size() == roRef.InvalidList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < InvalidList.size()); ++u32Idx)
            bResult = bResult && (InvalidList[u32Idx] == roRef.InvalidList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgSDS_StatusGet::sds2hmi_sdsfi_tclMsgSDS_StatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_StatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSGET;
}


sds2hmi_sdsfi_tclMsgSDS_StatusGet::~sds2hmi_sdsfi_tclMsgSDS_StatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgSDS_StatusSet::sds2hmi_sdsfi_tclMsgSDS_StatusSet(const sds2hmi_sdsfi_tclMsgSDS_StatusSet& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
sds2hmi_sdsfi_tclMsgSDS_StatusSet& sds2hmi_sdsfi_tclMsgSDS_StatusSet::operator=(const sds2hmi_sdsfi_tclMsgSDS_StatusSet& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgSDS_StatusSet::sds2hmi_sdsfi_tclMsgSDS_StatusSet()
:State()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_StatusSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSSET;
}


sds2hmi_sdsfi_tclMsgSDS_StatusSet::~sds2hmi_sdsfi_tclMsgSDS_StatusSet()
{}

tU32 sds2hmi_sdsfi_tclMsgSDS_StatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgSDS_StatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgSDS_StatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgSDS_StatusSet::operator==(const sds2hmi_sdsfi_tclMsgSDS_StatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgSDS_StatusUpReg::sds2hmi_sdsfi_tclMsgSDS_StatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_StatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSUPREG;
}


sds2hmi_sdsfi_tclMsgSDS_StatusUpReg::~sds2hmi_sdsfi_tclMsgSDS_StatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg::sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg::~sds2hmi_sdsfi_tclMsgSDS_StatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgSDS_StatusStatus::sds2hmi_sdsfi_tclMsgSDS_StatusStatus(const sds2hmi_sdsfi_tclMsgSDS_StatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
sds2hmi_sdsfi_tclMsgSDS_StatusStatus& sds2hmi_sdsfi_tclMsgSDS_StatusStatus::operator=(const sds2hmi_sdsfi_tclMsgSDS_StatusStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgSDS_StatusStatus::sds2hmi_sdsfi_tclMsgSDS_StatusStatus()
:State()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_StatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_STATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgSDS_StatusStatus::~sds2hmi_sdsfi_tclMsgSDS_StatusStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgSDS_StatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgSDS_StatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgSDS_StatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgSDS_StatusStatus::operator==(const sds2hmi_sdsfi_tclMsgSDS_StatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet::sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERGET;
}


sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet::~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SpeakerId = coRef.SpeakerId;
}
sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::operator=(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& coRef)
{
   if (this == &coRef) return *this;
   SpeakerId = coRef.SpeakerId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet()
:SpeakerId(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERSET;
}


sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet()
{}

tU32 sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeakerId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeakerId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet::operator==(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeakerId == roRef.SpeakerId);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg::sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERUPREG;
}


sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg::~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg::sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERRELUPREG;
}


sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg::~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   SpeakerId = coRef.SpeakerId;
}
sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::operator=(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeakerId = coRef.SpeakerId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus()
:SpeakerId(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SDS_ACTIVESPEAKERSTATUS;
}


sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::~sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeakerId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeakerId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus::operator==(const sds2hmi_sdsfi_tclMsgSDS_ActiveSpeakerStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeakerId == roRef.SpeakerId);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonActionRequestGet::sds2hmi_sdsfi_tclMsgCommonActionRequestGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonActionRequestGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTGET;
}


sds2hmi_sdsfi_tclMsgCommonActionRequestGet::~sds2hmi_sdsfi_tclMsgCommonActionRequestGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg::sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTUPREG;
}


sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg::~sds2hmi_sdsfi_tclMsgCommonActionRequestUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg::sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTRELUPREG;
}


sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg::~sds2hmi_sdsfi_tclMsgCommonActionRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::sds2hmi_sdsfi_tclMsgCommonActionRequestStatus(const sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   Value = coRef.Value;
   AdditionalInfoList = coRef.AdditionalInfoList;
}
sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::operator=(const sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   Value = coRef.Value;
   AdditionalInfoList = coRef.AdditionalInfoList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < AdditionalInfoList.size(); ++u32Idx)
         AdditionalInfoList[u32Idx].vDestroy();
   AdditionalInfoList.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::sds2hmi_sdsfi_tclMsgCommonActionRequestStatus()
:Action()
,Value(0)

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONACTIONREQUESTSTATUS;
}


sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::~sds2hmi_sdsfi_tclMsgCommonActionRequestStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AdditionalInfoList.size(); ++u32ListIdx)
      u32DynamicSize += AdditionalInfoList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+9;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> Value);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AdditionalInfoList.size(); ++u32Idx)
      {
         AdditionalInfoList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AdditionalInfoList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AdditionalInfoList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << Value);
   (tVoid) (oOut << (tU32)AdditionalInfoList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AdditionalInfoList.size(); ++u32Idx)
         (tVoid) (oOut << AdditionalInfoList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonActionRequestStatus::operator==(const sds2hmi_sdsfi_tclMsgCommonActionRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (Value == roRef.Value);
      bResult = bResult && (AdditionalInfoList.size() == roRef.AdditionalInfoList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AdditionalInfoList.size()); ++u32Idx)
            bResult = bResult && (AdditionalInfoList[u32Idx] == roRef.AdditionalInfoList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonStatusGet::sds2hmi_sdsfi_tclMsgCommonStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSGET;
}


sds2hmi_sdsfi_tclMsgCommonStatusGet::~sds2hmi_sdsfi_tclMsgCommonStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonStatusUpReg::sds2hmi_sdsfi_tclMsgCommonStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgCommonStatusUpReg::~sds2hmi_sdsfi_tclMsgCommonStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg::sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg::~sds2hmi_sdsfi_tclMsgCommonStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonStatusStatus::sds2hmi_sdsfi_tclMsgCommonStatusStatus(const sds2hmi_sdsfi_tclMsgCommonStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   ApplicationId = coRef.ApplicationId;
   IsVehicleMoving = coRef.IsVehicleMoving;
   FeatureConfiguration = coRef.FeatureConfiguration;
   IsSearchServiceAvailable = coRef.IsSearchServiceAvailable;
   TCUAvialable = coRef.TCUAvialable;
   SportsServiceAvailable = coRef.SportsServiceAvailable;
}
sds2hmi_sdsfi_tclMsgCommonStatusStatus& sds2hmi_sdsfi_tclMsgCommonStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgCommonStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   ApplicationId = coRef.ApplicationId;
   IsVehicleMoving = coRef.IsVehicleMoving;
   FeatureConfiguration = coRef.FeatureConfiguration;
   IsSearchServiceAvailable = coRef.IsSearchServiceAvailable;
   TCUAvialable = coRef.TCUAvialable;
   SportsServiceAvailable = coRef.SportsServiceAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonStatusStatus::vDestroy()
{
   FeatureConfiguration.vDestroy();
}

sds2hmi_sdsfi_tclMsgCommonStatusStatus::sds2hmi_sdsfi_tclMsgCommonStatusStatus()
:Status()
,ApplicationId()
,IsVehicleMoving(0)
,FeatureConfiguration()
,IsSearchServiceAvailable(0)
,TCUAvialable(0)
,SportsServiceAvailable(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgCommonStatusStatus::~sds2hmi_sdsfi_tclMsgCommonStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += FeatureConfiguration.u32GetSize(u16MajorVersion);
   }
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> ApplicationId);
   if (1 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> IsVehicleMoving);
   }
   if (1 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> FeatureConfiguration);
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> IsSearchServiceAvailable);
   }
   (tVoid) (oIn >> TCUAvialable);
   (tVoid) (oIn >> SportsServiceAvailable);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << ApplicationId);
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << IsVehicleMoving);
   }
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << FeatureConfiguration);
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << IsSearchServiceAvailable);
   }
   (tVoid) (oOut << TCUAvialable);
   (tVoid) (oOut << SportsServiceAvailable);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgCommonStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (ApplicationId == roRef.ApplicationId);
   bResult = bResult && (IsVehicleMoving == roRef.IsVehicleMoving);
   bResult = bResult && (FeatureConfiguration == roRef.FeatureConfiguration);
   bResult = bResult && (IsSearchServiceAvailable == roRef.IsSearchServiceAvailable);
   bResult = bResult && (TCUAvialable == roRef.TCUAvialable);
   bResult = bResult && (SportsServiceAvailable == roRef.SportsServiceAvailable);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgMediaStatusGet::sds2hmi_sdsfi_tclMsgMediaStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSGET;
}


sds2hmi_sdsfi_tclMsgMediaStatusGet::~sds2hmi_sdsfi_tclMsgMediaStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgMediaStatusUpReg::sds2hmi_sdsfi_tclMsgMediaStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgMediaStatusUpReg::~sds2hmi_sdsfi_tclMsgMediaStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg::sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg::~sds2hmi_sdsfi_tclMsgMediaStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgMediaStatusStatus::sds2hmi_sdsfi_tclMsgMediaStatusStatus(const sds2hmi_sdsfi_tclMsgMediaStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceType = coRef.SourceType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
}
sds2hmi_sdsfi_tclMsgMediaStatusStatus& sds2hmi_sdsfi_tclMsgMediaStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgMediaStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceType = coRef.SourceType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgMediaStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         DeviceList[u32Idx].vDestroy();
   DeviceList.clear();
   }
}

sds2hmi_sdsfi_tclMsgMediaStatusStatus::sds2hmi_sdsfi_tclMsgMediaStatusStatus()
:Status()
,MenuType()
,SourceType()
,SourceId(0)

 {}

tS32 sds2hmi_sdsfi_tclMsgMediaStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_MEDIASTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgMediaStatusStatus::~sds2hmi_sdsfi_tclMsgMediaStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgMediaStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+11;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgMediaStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> MenuType);
   (tVoid) (oIn >> SourceType);
   (tVoid) (oIn >> SourceId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
      {
         DeviceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgMediaStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << MenuType);
   (tVoid) (oOut << SourceType);
   (tVoid) (oOut << SourceId);
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgMediaStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgMediaStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (MenuType == roRef.MenuType);
   bResult = bResult && (SourceType == roRef.SourceType);
   bResult = bResult && (SourceId == roRef.SourceId);
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStatusGet::sds2hmi_sdsfi_tclMsgNaviStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSGET;
}


sds2hmi_sdsfi_tclMsgNaviStatusGet::~sds2hmi_sdsfi_tclMsgNaviStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviStatusSet::sds2hmi_sdsfi_tclMsgNaviStatusSet(const sds2hmi_sdsfi_tclMsgNaviStatusSet& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   VDEAvailInfo = coRef.VDEAvailInfo;
}
sds2hmi_sdsfi_tclMsgNaviStatusSet& sds2hmi_sdsfi_tclMsgNaviStatusSet::operator=(const sds2hmi_sdsfi_tclMsgNaviStatusSet& coRef)
{
   if (this == &coRef) return *this;
   VDEAvailInfo = coRef.VDEAvailInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviStatusSet::sds2hmi_sdsfi_tclMsgNaviStatusSet()
:VDEAvailInfo()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStatusSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSSET;
}


sds2hmi_sdsfi_tclMsgNaviStatusSet::~sds2hmi_sdsfi_tclMsgNaviStatusSet()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviStatusSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VDEAvailInfo);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VDEAvailInfo);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviStatusSet::operator==(const sds2hmi_sdsfi_tclMsgNaviStatusSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VDEAvailInfo == roRef.VDEAvailInfo);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStatusUpReg::sds2hmi_sdsfi_tclMsgNaviStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgNaviStatusUpReg::~sds2hmi_sdsfi_tclMsgNaviStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg::sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg::~sds2hmi_sdsfi_tclMsgNaviStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviStatusStatus::sds2hmi_sdsfi_tclMsgNaviStatusStatus(const sds2hmi_sdsfi_tclMsgNaviStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   NavUnit = coRef.NavUnit;
   VDEAvailInfo = coRef.VDEAvailInfo;
   DetourOn = coRef.DetourOn;
}
sds2hmi_sdsfi_tclMsgNaviStatusStatus& sds2hmi_sdsfi_tclMsgNaviStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgNaviStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   NavUnit = coRef.NavUnit;
   VDEAvailInfo = coRef.VDEAvailInfo;
   DetourOn = coRef.DetourOn;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNaviStatusStatus::sds2hmi_sdsfi_tclMsgNaviStatusStatus()
:Status()
,MenuType()
,NavUnit()
,VDEAvailInfo()
,DetourOn(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVISTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgNaviStatusStatus::~sds2hmi_sdsfi_tclMsgNaviStatusStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgNaviStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> MenuType);
   (tVoid) (oIn >> NavUnit);
   (tVoid) (oIn >> VDEAvailInfo);
   (tVoid) (oIn >> DetourOn);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << MenuType);
   (tVoid) (oOut << NavUnit);
   (tVoid) (oOut << VDEAvailInfo);
   (tVoid) (oOut << DetourOn);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgNaviStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (MenuType == roRef.MenuType);
   bResult = bResult && (NavUnit == roRef.NavUnit);
   bResult = bResult && (VDEAvailInfo == roRef.VDEAvailInfo);
   bResult = bResult && (DetourOn == roRef.DetourOn);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneStatusGet::sds2hmi_sdsfi_tclMsgPhoneStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSGET;
}


sds2hmi_sdsfi_tclMsgPhoneStatusGet::~sds2hmi_sdsfi_tclMsgPhoneStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneStatusUpReg::sds2hmi_sdsfi_tclMsgPhoneStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgPhoneStatusUpReg::~sds2hmi_sdsfi_tclMsgPhoneStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg::sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg::~sds2hmi_sdsfi_tclMsgPhoneStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgPhoneStatusStatus::sds2hmi_sdsfi_tclMsgPhoneStatusStatus(const sds2hmi_sdsfi_tclMsgPhoneStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
   BTenabled = coRef.BTenabled;
   TransorderType = coRef.TransorderType;
   CarPlayAvailable = coRef.CarPlayAvailable;
}
sds2hmi_sdsfi_tclMsgPhoneStatusStatus& sds2hmi_sdsfi_tclMsgPhoneStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgPhoneStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   SourceId = coRef.SourceId;
   DeviceList = coRef.DeviceList;
   BTenabled = coRef.BTenabled;
   TransorderType = coRef.TransorderType;
   CarPlayAvailable = coRef.CarPlayAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgPhoneStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         DeviceList[u32Idx].vDestroy();
   DeviceList.clear();
   }
}

sds2hmi_sdsfi_tclMsgPhoneStatusStatus::sds2hmi_sdsfi_tclMsgPhoneStatusStatus()
:Status()
,MenuType()
,SourceId(0)

,BTenabled(0)
,TransorderType()
,CarPlayAvailable(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgPhoneStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_PHONESTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgPhoneStatusStatus::~sds2hmi_sdsfi_tclMsgPhoneStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgPhoneStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceList[u32ListIdx].u32GetSize(u16MajorVersion);
   if (1 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+11;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgPhoneStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> MenuType);
   (tVoid) (oIn >> SourceId);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
      {
         DeviceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   if (1 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> BTenabled);
   }
   if (2 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> TransorderType);
   }
   (tVoid) (oIn >> CarPlayAvailable);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgPhoneStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << MenuType);
   (tVoid) (oOut << SourceId);
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   if (1 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << BTenabled);
   }
   if (2 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << TransorderType);
   }
   (tVoid) (oOut << CarPlayAvailable);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgPhoneStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgPhoneStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (MenuType == roRef.MenuType);
   bResult = bResult && (SourceId == roRef.SourceId);
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   bResult = bResult && (BTenabled == roRef.BTenabled);
   bResult = bResult && (TransorderType == roRef.TransorderType);
   bResult = bResult && (CarPlayAvailable == roRef.CarPlayAvailable);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerStatusGet::sds2hmi_sdsfi_tclMsgTunerStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSGET;
}


sds2hmi_sdsfi_tclMsgTunerStatusGet::~sds2hmi_sdsfi_tclMsgTunerStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerStatusUpReg::sds2hmi_sdsfi_tclMsgTunerStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgTunerStatusUpReg::~sds2hmi_sdsfi_tclMsgTunerStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg::sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg::~sds2hmi_sdsfi_tclMsgTunerStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTunerStatusStatus::sds2hmi_sdsfi_tclMsgTunerStatusStatus(const sds2hmi_sdsfi_tclMsgTunerStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   Band = coRef.Band;
   PresetNr = coRef.PresetNr;
   StationName = coRef.StationName;
   DeviceList = coRef.DeviceList;
}
sds2hmi_sdsfi_tclMsgTunerStatusStatus& sds2hmi_sdsfi_tclMsgTunerStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgTunerStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   Band = coRef.Band;
   PresetNr = coRef.PresetNr;
   StationName = coRef.StationName;
   DeviceList = coRef.DeviceList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgTunerStatusStatus::vDestroy()
{
   StationName.vDestroy();
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         DeviceList[u32Idx].vDestroy();
   DeviceList.clear();
   }
}

sds2hmi_sdsfi_tclMsgTunerStatusStatus::sds2hmi_sdsfi_tclMsgTunerStatusStatus()
:Status()
,Band()
,PresetNr(0)
,StationName()

 {}

tS32 sds2hmi_sdsfi_tclMsgTunerStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TUNERSTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgTunerStatusStatus::~sds2hmi_sdsfi_tclMsgTunerStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgTunerStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DeviceList.size(); ++u32ListIdx)
      u32DynamicSize += DeviceList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8+StationName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTunerStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> PresetNr);
   (tVoid) (oIn >> StationName);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
      {
         DeviceList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DeviceList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DeviceList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTunerStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << Band);
   (tVoid) (oOut << PresetNr);
   (tVoid) (oOut << StationName);
   (tVoid) (oOut << (tU32)DeviceList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DeviceList.size(); ++u32Idx)
         (tVoid) (oOut << DeviceList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTunerStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgTunerStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (PresetNr == roRef.PresetNr);
   bResult = bResult && (StationName == roRef.StationName);
      bResult = bResult && (DeviceList.size() == roRef.DeviceList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DeviceList.size()); ++u32Idx)
            bResult = bResult && (DeviceList[u32Idx] == roRef.DeviceList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgWeatherStatusGet::sds2hmi_sdsfi_tclMsgWeatherStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSGET;
}


sds2hmi_sdsfi_tclMsgWeatherStatusGet::~sds2hmi_sdsfi_tclMsgWeatherStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgWeatherStatusUpReg::sds2hmi_sdsfi_tclMsgWeatherStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgWeatherStatusUpReg::~sds2hmi_sdsfi_tclMsgWeatherStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg::sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg::~sds2hmi_sdsfi_tclMsgWeatherStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgWeatherStatusStatus::sds2hmi_sdsfi_tclMsgWeatherStatusStatus(const sds2hmi_sdsfi_tclMsgWeatherStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   MenuType = coRef.MenuType;
}
sds2hmi_sdsfi_tclMsgWeatherStatusStatus& sds2hmi_sdsfi_tclMsgWeatherStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgWeatherStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   MenuType = coRef.MenuType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgWeatherStatusStatus::sds2hmi_sdsfi_tclMsgWeatherStatusStatus()
:Status()
,MenuType()
 {}

tS32 sds2hmi_sdsfi_tclMsgWeatherStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_WEATHERSTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgWeatherStatusStatus::~sds2hmi_sdsfi_tclMsgWeatherStatusStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgWeatherStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgWeatherStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> MenuType);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgWeatherStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << MenuType);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgWeatherStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgWeatherStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (MenuType == roRef.MenuType);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet::sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATEGET;
}


sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet::~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg::sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATEUPREG;
}


sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg::~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg::sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATERELUPREG;
}


sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg::~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Country = coRef.Country;
   State = coRef.State;
   CountryName = coRef.CountryName;
   StateName = coRef.StateName;
   CityName = coRef.CityName;
   NDSLocationDetails = coRef.NDSLocationDetails;
}
sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   State = coRef.State;
   CountryName = coRef.CountryName;
   StateName = coRef.StateName;
   CityName = coRef.CityName;
   NDSLocationDetails = coRef.NDSLocationDetails;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::vDestroy()
{
   State.vDestroy();
   CountryName.vDestroy();
   StateName.vDestroy();
   CityName.vDestroy();
   NDSLocationDetails.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus()
:Country()
,State()
,CountryName()
,StateName()
,CityName()
,NDSLocationDetails()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTCOUNTRYSTATESTATUS;
}


sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::~sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+State.u32GetSize(u16MajorVersion)+CountryName.u32GetSize(u16MajorVersion)+StateName.u32GetSize(u16MajorVersion)+CityName.u32GetSize(u16MajorVersion)+NDSLocationDetails.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> CountryName);
   (tVoid) (oIn >> StateName);
   (tVoid) (oIn >> CityName);
   (tVoid) (oIn >> NDSLocationDetails);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   (tVoid) (oOut << State);
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << StateName);
   (tVoid) (oOut << CityName);
   (tVoid) (oOut << NDSLocationDetails);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus::operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentCountryStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (CountryName == roRef.CountryName);
   bResult = bResult && (StateName == roRef.StateName);
   bResult = bResult && (CityName == roRef.CityName);
   bResult = bResult && (NDSLocationDetails == roRef.NDSLocationDetails);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet::sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTGET;
}


sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet::~sds2hmi_sdsfi_tclMsgCommonSettingsRequestGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg::sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTUPREG;
}


sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg::~sds2hmi_sdsfi_tclMsgCommonSettingsRequestUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg::sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTRELUPREG;
}


sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg::~sds2hmi_sdsfi_tclMsgCommonSettingsRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   Settings = coRef.Settings;
}
sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::operator=(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   Settings = coRef.Settings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         Settings[u32Idx].vDestroy();
   Settings.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus()
:Action()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSETTINGSREQUESTSTATUS;
}


sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::~sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Settings.size(); ++u32ListIdx)
      u32DynamicSize += Settings[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
      {
         Settings[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Settings.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Settings[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << (tU32)Settings.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Settings.size(); ++u32Idx)
         (tVoid) (oOut << Settings[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus::operator==(const sds2hmi_sdsfi_tclMsgCommonSettingsRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
      bResult = bResult && (Settings.size() == roRef.Settings.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Settings.size()); ++u32Idx)
            bResult = bResult && (Settings[u32Idx] == roRef.Settings[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgStatusGet::sds2hmi_sdsfi_tclMsgTextMsgStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSGET;
}


sds2hmi_sdsfi_tclMsgTextMsgStatusGet::~sds2hmi_sdsfi_tclMsgTextMsgStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg::sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg::~sds2hmi_sdsfi_tclMsgTextMsgStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg::sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg::~sds2hmi_sdsfi_tclMsgTextMsgStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::sds2hmi_sdsfi_tclMsgTextMsgStatusStatus(const sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
   IsMsgAvailable = coRef.IsMsgAvailable;
}
sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   IsMsgAvailable = coRef.IsMsgAvailable;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::sds2hmi_sdsfi_tclMsgTextMsgStatusStatus()
:Status()
,IsMsgAvailable(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_TEXTMSGSTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::~sds2hmi_sdsfi_tclMsgTextMsgStatusStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> IsMsgAvailable);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << IsMsgAvailable);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgTextMsgStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgTextMsgStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (IsMsgAvailable == roRef.IsMsgAvailable);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgVDLStatusGet::sds2hmi_sdsfi_tclMsgVDLStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgVDLStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSGET;
}


sds2hmi_sdsfi_tclMsgVDLStatusGet::~sds2hmi_sdsfi_tclMsgVDLStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgVDLStatusUpReg::sds2hmi_sdsfi_tclMsgVDLStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgVDLStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgVDLStatusUpReg::~sds2hmi_sdsfi_tclMsgVDLStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg::sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg::~sds2hmi_sdsfi_tclMsgVDLStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgVDLStatusStatus::sds2hmi_sdsfi_tclMsgVDLStatusStatus(const sds2hmi_sdsfi_tclMsgVDLStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Slots = coRef.Slots;
}
sds2hmi_sdsfi_tclMsgVDLStatusStatus& sds2hmi_sdsfi_tclMsgVDLStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgVDLStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Slots = coRef.Slots;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgVDLStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
         Slots[u32Idx].vDestroy();
   Slots.clear();
   }
}

sds2hmi_sdsfi_tclMsgVDLStatusStatus::sds2hmi_sdsfi_tclMsgVDLStatusStatus()

 {}

tS32 sds2hmi_sdsfi_tclMsgVDLStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_VDLSTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgVDLStatusStatus::~sds2hmi_sdsfi_tclMsgVDLStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgVDLStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < Slots.size(); ++u32ListIdx)
      u32DynamicSize += Slots[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgVDLStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
      {
         Slots[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Slots.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Slots[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgVDLStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Slots.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Slots.size(); ++u32Idx)
         (tVoid) (oOut << Slots[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgVDLStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgVDLStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Slots.size() == roRef.Slots.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Slots.size()); ++u32Idx)
            bResult = bResult && (Slots[u32Idx] == roRef.Slots[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet::sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSGET;
}


sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet::~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ConnectedDeviceStatus = coRef.ConnectedDeviceStatus;
   MediaState = coRef.MediaState;
   e8Slot = coRef.e8Slot;
}
sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::operator=(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& coRef)
{
   if (this == &coRef) return *this;
   ConnectedDeviceStatus = coRef.ConnectedDeviceStatus;
   MediaState = coRef.MediaState;
   e8Slot = coRef.e8Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
         ConnectedDeviceStatus[u32Idx].vDestroy();
   ConnectedDeviceStatus.clear();
   }
   {
   e8Slot.clear();
   }
}

sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet()

:MediaState(0)

 {}

tS32 sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSET;
}


sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+ConnectedDeviceStatus.size()*6+e8Slot.size()*1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
      {
         ConnectedDeviceStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ConnectedDeviceStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ConnectedDeviceStatus[u32Idx]);
      }
   }
   (tVoid) (oIn >> MediaState);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      e8Slot.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> e8Slot[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ConnectedDeviceStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
         (tVoid) (oOut << ConnectedDeviceStatus[u32Idx]);
   }
   (tVoid) (oOut << MediaState);
   (tVoid) (oOut << (tU32)e8Slot.size());
   {
      for (tU32 u32Idx = 0; u32Idx < e8Slot.size(); ++u32Idx)
         (tVoid) (oOut << e8Slot[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet::operator==(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ConnectedDeviceStatus.size() == roRef.ConnectedDeviceStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ConnectedDeviceStatus.size()); ++u32Idx)
            bResult = bResult && (ConnectedDeviceStatus[u32Idx] == roRef.ConnectedDeviceStatus[u32Idx]);
      }
   bResult = bResult && (MediaState == roRef.MediaState);
      bResult = bResult && (e8Slot.size() == roRef.e8Slot.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < e8Slot.size()); ++u32Idx)
            bResult = bResult && (e8Slot[u32Idx] == roRef.e8Slot[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg::sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg::~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg::sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg::~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ConnectedDeviceStatus = coRef.ConnectedDeviceStatus;
   MediaState = coRef.MediaState;
   e8Slot = coRef.e8Slot;
}
sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   ConnectedDeviceStatus = coRef.ConnectedDeviceStatus;
   MediaState = coRef.MediaState;
   e8Slot = coRef.e8Slot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
         ConnectedDeviceStatus[u32Idx].vDestroy();
   ConnectedDeviceStatus.clear();
   }
   {
   e8Slot.clear();
   }
}

sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus()

:MediaState(0)

 {}

tS32 sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_CONNECTEDDEVICESTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::~sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9+ConnectedDeviceStatus.size()*6+e8Slot.size()*1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
      {
         ConnectedDeviceStatus[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ConnectedDeviceStatus.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ConnectedDeviceStatus[u32Idx]);
      }
   }
   (tVoid) (oIn >> MediaState);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      e8Slot.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> e8Slot[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ConnectedDeviceStatus.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ConnectedDeviceStatus.size(); ++u32Idx)
         (tVoid) (oOut << ConnectedDeviceStatus[u32Idx]);
   }
   (tVoid) (oOut << MediaState);
   (tVoid) (oOut << (tU32)e8Slot.size());
   {
      for (tU32 u32Idx = 0; u32Idx < e8Slot.size(); ++u32Idx)
         (tVoid) (oOut << e8Slot[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ConnectedDeviceStatus.size() == roRef.ConnectedDeviceStatus.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ConnectedDeviceStatus.size()); ++u32Idx)
            bResult = bResult && (ConnectedDeviceStatus[u32Idx] == roRef.ConnectedDeviceStatus[u32Idx]);
      }
   bResult = bResult && (MediaState == roRef.MediaState);
      bResult = bResult && (e8Slot.size() == roRef.e8Slot.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < e8Slot.size()); ++u32Idx)
            bResult = bResult && (e8Slot[u32Idx] == roRef.e8Slot[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet::sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONGET;
}


sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet::~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg::sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONUPREG;
}


sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg::~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg::sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONRELUPREG;
}


sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg::~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   LocationList = coRef.LocationList;
}
sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& coRef)
{
   if (this == &coRef) return *this;
   LocationList = coRef.LocationList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         LocationList[u32Idx].vDestroy();
   LocationList.clear();
   }
}

sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus()

 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTNEIGHBORINGLOCATIONSTATUS;
}


sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::~sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < LocationList.size(); ++u32ListIdx)
      u32DynamicSize += LocationList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
      {
         LocationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      LocationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> LocationList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)LocationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < LocationList.size(); ++u32Idx)
         (tVoid) (oOut << LocationList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus::operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentNeighboringLocationStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (LocationList.size() == roRef.LocationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < LocationList.size()); ++u32Idx)
            bResult = bResult && (LocationList[u32Idx] == roRef.LocationList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgSpecialAppStatusGet::sds2hmi_sdsfi_tclMsgSpecialAppStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgSpecialAppStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSGET;
}


sds2hmi_sdsfi_tclMsgSpecialAppStatusGet::~sds2hmi_sdsfi_tclMsgSpecialAppStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg::sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg::~sds2hmi_sdsfi_tclMsgSpecialAppStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg::sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg::~sds2hmi_sdsfi_tclMsgSpecialAppStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus(const sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   AppTypeAndStatus = coRef.AppTypeAndStatus;
}
sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   AppTypeAndStatus = coRef.AppTypeAndStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus()
:AppTypeAndStatus()
 {}

tS32 sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_SPECIALAPPSTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::~sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AppTypeAndStatus);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AppTypeAndStatus);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgSpecialAppStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AppTypeAndStatus == roRef.AppTypeAndStatus);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATGET;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATUPREG;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATRELUPREG;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
}
sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::operator=(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::vDestroy()
{
   Value.vDestroy();
}

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus()
:Value()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_STATSTATUS;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Value.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus::operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNAGET;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNAUPREG;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNARELUPREG;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Value = coRef.Value;
}
sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::operator=(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& coRef)
{
   if (this == &coRef) return *this;
   Value = coRef.Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::vDestroy()
{
   Value.vDestroy();
}

sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus()
:Value()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONSDSCONFIGURATION_DYNASTATUS;
}


sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::~sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Value.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Value);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Value);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus::operator==(const sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_DynaStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Value == roRef.Value);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet::sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSGET;
}


sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet::~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   CoreSpeechParameterList = coRef.CoreSpeechParameterList;
}
sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::operator=(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& coRef)
{
   if (this == &coRef) return *this;
   CoreSpeechParameterList = coRef.CoreSpeechParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CoreSpeechParameterList.size(); ++u32Idx)
         CoreSpeechParameterList[u32Idx].vDestroy();
   CoreSpeechParameterList.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSSET;
}


sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CoreSpeechParameterList.size(); ++u32ListIdx)
      u32DynamicSize += CoreSpeechParameterList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CoreSpeechParameterList.size(); ++u32Idx)
      {
         CoreSpeechParameterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CoreSpeechParameterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CoreSpeechParameterList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CoreSpeechParameterList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CoreSpeechParameterList.size(); ++u32Idx)
         (tVoid) (oOut << CoreSpeechParameterList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet::operator==(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersSet& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CoreSpeechParameterList.size() == roRef.CoreSpeechParameterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CoreSpeechParameterList.size()); ++u32Idx)
            bResult = bResult && (CoreSpeechParameterList[u32Idx] == roRef.CoreSpeechParameterList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg::sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSUPREG;
}


sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg::~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg::sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSRELUPREG;
}


sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg::~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   CoreSpeechParameterList = coRef.CoreSpeechParameterList;
}
sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::operator=(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& coRef)
{
   if (this == &coRef) return *this;
   CoreSpeechParameterList = coRef.CoreSpeechParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CoreSpeechParameterList.size(); ++u32Idx)
         CoreSpeechParameterList[u32Idx].vDestroy();
   CoreSpeechParameterList.clear();
   }
}

sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus()

 {}

tS32 sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_COMMONCORESPEECHPARAMETERSSTATUS;
}


sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::~sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < CoreSpeechParameterList.size(); ++u32ListIdx)
      u32DynamicSize += CoreSpeechParameterList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CoreSpeechParameterList.size(); ++u32Idx)
      {
         CoreSpeechParameterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CoreSpeechParameterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CoreSpeechParameterList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CoreSpeechParameterList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CoreSpeechParameterList.size(); ++u32Idx)
         (tVoid) (oOut << CoreSpeechParameterList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus::operator==(const sds2hmi_sdsfi_tclMsgCommonCoreSpeechParametersStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CoreSpeechParameterList.size() == roRef.CoreSpeechParameterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CoreSpeechParameterList.size()); ++u32Idx)
            bResult = bResult && (CoreSpeechParameterList[u32Idx] == roRef.CoreSpeechParameterList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet::sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETGET;
}


sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet::~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet::sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETSET;
}


sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet::~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetSet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg::sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETUPREG;
}


sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg::~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg::sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETRELUPREG;
}


sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg::~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   DataSetId = coRef.DataSetId;
}
sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::operator=(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   DataSetId = coRef.DataSetId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus()
:State()
,DataSetId(0)
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATAACTIVEDATASETSTATUS;
}


sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::~sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> DataSetId);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << DataSetId);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus::operator==(const sds2hmi_sdsfi_tclMsgNavDataActiveDataSetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (DataSetId == roRef.DataSetId);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet::sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSGET;
}


sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet::~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet::sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSSET;
}


sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet::~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusSet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg::sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSUPREG;
}


sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg::~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg::sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg::~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   ECNR_ASR_Status = coRef.ECNR_ASR_Status;
}
sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::operator=(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& coRef)
{
   if (this == &coRef) return *this;
   ECNR_ASR_Status = coRef.ECNR_ASR_Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus()
:ECNR_ASR_Status()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIOECNR_ASR_MODE_STATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::~sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus()
{}

tU32 sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ECNR_ASR_Status);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ECNR_ASR_Status);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus::operator==(const sds2hmi_sdsfi_tclMsgAudioECNR_ASR_Mode_StatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ECNR_ASR_Status == roRef.ECNR_ASR_Status);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet::sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERGET;
}


sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet::~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet::sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERSET;
}


sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet::~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterSet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg::sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERUPREG;
}


sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg::~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg::sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERRELUPREG;
}


sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg::~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DataSize = coRef.DataSize;
   DataList = coRef.DataList;
}
sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::operator=(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& coRef)
{
   if (this == &coRef) return *this;
   DataSize = coRef.DataSize;
   DataList = coRef.DataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::vDestroy()
{
   {
   DataList.clear();
   }
}

sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus()
:DataSize(0)

 {}

tS32 sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_AUDIO_ECNR_ENGINEPARAMETERSTATUS;
}


sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::~sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+DataList.size()*1;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataSize);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataSize);
   (tVoid) (oOut << (tU32)DataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DataList.size(); ++u32Idx)
         (tVoid) (oOut << DataList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus::operator==(const sds2hmi_sdsfi_tclMsgAudio_ECNR_EngineParameterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataSize == roRef.DataSize);
      bResult = bResult && (DataList.size() == roRef.DataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DataList.size()); ++u32Idx)
            bResult = bResult && (DataList[u32Idx] == roRef.DataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgInfoServiceStatusGet::sds2hmi_sdsfi_tclMsgInfoServiceStatusGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoServiceStatusGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSGET;
}


sds2hmi_sdsfi_tclMsgInfoServiceStatusGet::~sds2hmi_sdsfi_tclMsgInfoServiceStatusGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgInfoServiceStatusSet::sds2hmi_sdsfi_tclMsgInfoServiceStatusSet()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoServiceStatusSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSSET;
}


sds2hmi_sdsfi_tclMsgInfoServiceStatusSet::~sds2hmi_sdsfi_tclMsgInfoServiceStatusSet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg::sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSUPREG;
}


sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg::~sds2hmi_sdsfi_tclMsgInfoServiceStatusUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg::sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSRELUPREG;
}


sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg::~sds2hmi_sdsfi_tclMsgInfoServiceStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus(const sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Info_Menu_StatusList = coRef.Info_Menu_StatusList;
}
sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::operator=(const sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Info_Menu_StatusList = coRef.Info_Menu_StatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Info_Menu_StatusList.size(); ++u32Idx)
         Info_Menu_StatusList[u32Idx].vDestroy();
   Info_Menu_StatusList.clear();
   }
}

sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus()

 {}

tS32 sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_INFOSERVICESTATUSSTATUS;
}


sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::~sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+Info_Menu_StatusList.size()*2;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Info_Menu_StatusList.size(); ++u32Idx)
      {
         Info_Menu_StatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Info_Menu_StatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Info_Menu_StatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Info_Menu_StatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Info_Menu_StatusList.size(); ++u32Idx)
         (tVoid) (oOut << Info_Menu_StatusList[u32Idx]);
   }
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus::operator==(const sds2hmi_sdsfi_tclMsgInfoServiceStatusStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Info_Menu_StatusList.size() == roRef.Info_Menu_StatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Info_Menu_StatusList.size()); ++u32Idx)
            bResult = bResult && (Info_Menu_StatusList[u32Idx] == roRef.Info_Menu_StatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviPOIIconListGet::sds2hmi_sdsfi_tclMsgNaviPOIIconListGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviPOIIconListGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTGET;
}


sds2hmi_sdsfi_tclMsgNaviPOIIconListGet::~sds2hmi_sdsfi_tclMsgNaviPOIIconListGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviPOIIconListSet::sds2hmi_sdsfi_tclMsgNaviPOIIconListSet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviPOIIconListSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTSET;
}


sds2hmi_sdsfi_tclMsgNaviPOIIconListSet::~sds2hmi_sdsfi_tclMsgNaviPOIIconListSet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg::sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTUPREG;
}


sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg::~sds2hmi_sdsfi_tclMsgNaviPOIIconListUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg::sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTRELUPREG;
}


sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg::~sds2hmi_sdsfi_tclMsgNaviPOIIconListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus(const sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DescriptionList = coRef.DescriptionList;
   LanguageID = coRef.LanguageID;
}
sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::operator=(const sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& coRef)
{
   if (this == &coRef) return *this;
   DescriptionList = coRef.DescriptionList;
   LanguageID = coRef.LanguageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
         DescriptionList[u32Idx].vDestroy();
   DescriptionList.clear();
   }
   LanguageID.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus()

:LanguageID()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVIPOIICONLISTSTATUS;
}


sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::~sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DescriptionList.size(); ++u32ListIdx)
      u32DynamicSize += DescriptionList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
      {
         DescriptionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DescriptionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DescriptionList[u32Idx]);
      }
   }
   (tVoid) (oIn >> LanguageID);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DescriptionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DescriptionList.size(); ++u32Idx)
         (tVoid) (oOut << DescriptionList[u32Idx]);
   }
   (tVoid) (oOut << LanguageID);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus::operator==(const sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DescriptionList.size() == roRef.DescriptionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DescriptionList.size()); ++u32Idx)
            bResult = bResult && (DescriptionList[u32Idx] == roRef.DescriptionList[u32Idx]);
      }
   bResult = bResult && (LanguageID == roRef.LanguageID);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet::sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOGET;
}


sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet::~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoGet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet::sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOSET;
}


sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet::~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoSet()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg::sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOUPREG;
}


sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg::~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg::sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFORELUPREG;
}


sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg::~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   DataSetId = coRef.DataSetId;
   PersistentDataSetId = coRef.PersistentDataSetId;
   SharedDataAccessAttributes = coRef.SharedDataAccessAttributes;
}
sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::operator=(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   DataSetId = coRef.DataSetId;
   PersistentDataSetId = coRef.PersistentDataSetId;
   SharedDataAccessAttributes = coRef.SharedDataAccessAttributes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::vDestroy()
{
   PersistentDataSetId.vDestroy();
   SharedDataAccessAttributes.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus()
:DataSetId(0)
,PersistentDataSetId()
,SharedDataAccessAttributes()
 {}

tS32 sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVDATADATASETINFOSTATUS;
}


sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::~sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+PersistentDataSetId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DataSetId);
   (tVoid) (oIn >> PersistentDataSetId);
   (tVoid) (oIn >> SharedDataAccessAttributes);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DataSetId);
   (tVoid) (oOut << PersistentDataSetId);
   (tVoid) (oOut << SharedDataAccessAttributes);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus::operator==(const sds2hmi_sdsfi_tclMsgNavDataDataSetInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DataSetId == roRef.DataSetId);
   bResult = bResult && (PersistentDataSetId == roRef.PersistentDataSetId);
   bResult = bResult && (SharedDataAccessAttributes == roRef.SharedDataAccessAttributes);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet::sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONGET;
}


sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet::~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Country = coRef.Country;
   CountryName = coRef.CountryName;
   VDELanguage = coRef.VDELanguage;
}
sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   CountryName = coRef.CountryName;
   VDELanguage = coRef.VDELanguage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::vDestroy()
{
   CountryName.vDestroy();
   VDELanguage.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet()
:Country()
,CountryName()
,VDELanguage()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONSET;
}


sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+CountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> CountryName);
   (tVoid) (oIn >> VDELanguage);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << VDELanguage);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet::operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (CountryName == roRef.CountryName);
   bResult = bResult && (VDELanguage == roRef.VDELanguage);
   return bResult;
}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg::sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONUPREG;
}


sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg::~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationUpReg()
{}

//=============================================================================

sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg::sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONRELUPREG;
}


sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg::~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& coRef)
   : sds2hmi_sdsfi_tclMsgBaseMessage(coRef)
{
   Country = coRef.Country;
   CountryName = coRef.CountryName;
   VDELanguage = coRef.VDELanguage;
}
sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::operator=(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   CountryName = coRef.CountryName;
   VDELanguage = coRef.VDELanguage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::vDestroy()
{
   CountryName.vDestroy();
   VDELanguage.vDestroy(); 
}

sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus()
:Country()
,CountryName()
,VDELanguage()
 {}

tS32 sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::s32GetTypeId() const
{
   return (tS32) sds2hmi_sdsfi_tclToken::EN_MSG_NAVICURRENTVOICEDESTINATIONSTATUS;
}


sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::~sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+CountryName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> CountryName);
   (tVoid) (oIn >> VDELanguage);
   return oIn;
}

fi_tclOutContext& sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   (tVoid) (oOut << CountryName);
   (tVoid) (oOut << VDELanguage);
   return oOut;
}

tBool sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus::operator==(const sds2hmi_sdsfi_tclMsgNaviCurrentVoiceDestinationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (CountryName == roRef.CountryName);
   bResult = bResult && (VDELanguage == roRef.VDELanguage);
   return bResult;
}

