#ifndef SDS2HMI_SDSFILANGUAGE_HEADER
#define SDS2HMI_SDSFILANGUAGE_HEADER

class sds2hmi_sdsfi_tclInContext;
class sds2hmi_sdsfi_tclOutContext;
class sds2hmi_sdsfi_tclVisitorBase;

class MY_DECL sds2hmi_sdsfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  sds2hmi_sdsfi_tclDescription(fi_tclInContext* poIn, sds2hmi_sdsfi_tclVisitorBase* poVisit);
  sds2hmi_sdsfi_tclDescription(fi_tclOutContext* poOut, sds2hmi_sdsfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(sds2hmi_sdsfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(sds2hmi_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ sds2hmi_sdsfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--Lesen oder Schreiben?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  sds2hmi_sdsfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<sds2hmi_sdsfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<sds2hmi_sdsfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline sds2hmi_sdsfi_tclDescription::sds2hmi_sdsfi_tclDescription(fi_tclInContext* poIn, sds2hmi_sdsfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline sds2hmi_sdsfi_tclDescription::sds2hmi_sdsfi_tclDescription(fi_tclOutContext* poOut, sds2hmi_sdsfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

