/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef RVC_CCAFITYPES_HEADER
#define RVC_CCAFITYPES_HEADER


class rvc_ccafi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for rvc_cca_fi message types

fi_tclMessageBase* rvc_ccafi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class rvc_ccafi_tclMsgBaseMessage : public rvc_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   rvc_ccafi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class rvc_ccafi_tclMsgCameraButtonMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCameraButtonMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgCameraButtonMethodStart& operator=(const rvc_ccafi_tclMsgCameraButtonMethodStart& coRef);
   rvc_ccafi_tclMsgCameraButtonMethodStart(const rvc_ccafi_tclMsgCameraButtonMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_ButtonState e8ButtonState;
   virtual ~rvc_ccafi_tclMsgCameraButtonMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgCameraButtonMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCameraButtonMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCameraButtonMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgCameraButtonMethodResult& operator=(const rvc_ccafi_tclMsgCameraButtonMethodResult& coRef);
   rvc_ccafi_tclMsgCameraButtonMethodResult(const rvc_ccafi_tclMsgCameraButtonMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgCameraButtonMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgCameraButtonMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetStatusHmiMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetStatusHmiMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetStatusHmiMethodStart& operator=(const rvc_ccafi_tclMsgSetStatusHmiMethodStart& coRef);
   rvc_ccafi_tclMsgSetStatusHmiMethodStart(const rvc_ccafi_tclMsgSetStatusHmiMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_Status e8StatusHmi;
   virtual ~rvc_ccafi_tclMsgSetStatusHmiMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetStatusHmiMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetStatusHmiMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetStatusHmiMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetStatusHmiMethodResult& operator=(const rvc_ccafi_tclMsgSetStatusHmiMethodResult& coRef);
   rvc_ccafi_tclMsgSetStatusHmiMethodResult(const rvc_ccafi_tclMsgSetStatusHmiMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;
   virtual ~rvc_ccafi_tclMsgSetStatusHmiMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetStatusHmiMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupLanguageMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupLanguageMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupLanguageMethodStart& operator=(const rvc_ccafi_tclMsgSetupLanguageMethodStart& coRef);
   rvc_ccafi_tclMsgSetupLanguageMethodStart(const rvc_ccafi_tclMsgSetupLanguageMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_Language e8Language;
   virtual ~rvc_ccafi_tclMsgSetupLanguageMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupLanguageMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupLanguageMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupLanguageMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupLanguageMethodResult& operator=(const rvc_ccafi_tclMsgSetupLanguageMethodResult& coRef);
   rvc_ccafi_tclMsgSetupLanguageMethodResult(const rvc_ccafi_tclMsgSetupLanguageMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetupLanguageMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupLanguageMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupGuideLineMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupGuideLineMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupGuideLineMethodStart& operator=(const rvc_ccafi_tclMsgSetupGuideLineMethodStart& coRef);
   rvc_ccafi_tclMsgSetupGuideLineMethodStart(const rvc_ccafi_tclMsgSetupGuideLineMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine;
   virtual ~rvc_ccafi_tclMsgSetupGuideLineMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupGuideLineMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupGuideLineMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupGuideLineMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupGuideLineMethodResult& operator=(const rvc_ccafi_tclMsgSetupGuideLineMethodResult& coRef);
   rvc_ccafi_tclMsgSetupGuideLineMethodResult(const rvc_ccafi_tclMsgSetupGuideLineMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetupGuideLineMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupGuideLineMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupVideoControlsMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupVideoControlsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupVideoControlsMethodStart& operator=(const rvc_ccafi_tclMsgSetupVideoControlsMethodStart& coRef);
   rvc_ccafi_tclMsgSetupVideoControlsMethodStart(const rvc_ccafi_tclMsgSetupVideoControlsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode;
   std::vector<rvc_fi_tcl_RVC_VideoAnalogLevels, std::allocator<rvc_fi_tcl_RVC_VideoAnalogLevels> > arVideoControlParameter;
   rvc_fi_tcl_e8_MVCViewingState e8MVCViewingState;
   virtual ~rvc_ccafi_tclMsgSetupVideoControlsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupVideoControlsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupVideoControlsMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupVideoControlsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupVideoControlsMethodResult& operator=(const rvc_ccafi_tclMsgSetupVideoControlsMethodResult& coRef);
   rvc_ccafi_tclMsgSetupVideoControlsMethodResult(const rvc_ccafi_tclMsgSetupVideoControlsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetupVideoControlsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupVideoControlsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetSystemStatusMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetSystemStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetSystemStatusMethodStart& operator=(const rvc_ccafi_tclMsgSetSystemStatusMethodStart& coRef);
   rvc_ccafi_tclMsgSetSystemStatusMethodStart(const rvc_ccafi_tclMsgSetSystemStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;
   rvc_fi_tcl_e8_RVC_StatusGuideLine e8GuideLine;
   rvc_fi_tcl_e8_RVC_StatusWarningText e8WarningText;
   virtual ~rvc_ccafi_tclMsgSetSystemStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetSystemStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetSystemStatusMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetSystemStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetSystemStatusMethodResult& operator=(const rvc_ccafi_tclMsgSetSystemStatusMethodResult& coRef);
   rvc_ccafi_tclMsgSetSystemStatusMethodResult(const rvc_ccafi_tclMsgSetSystemStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetSystemStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetSystemStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& operator=(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& coRef);
   rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 pwrSupplyID;
   virtual ~rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& operator=(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& coRef);
   rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 pwrSupplyID;
   rvc_fi_tcl_e8_Camera_PowerSupplyStatus status;
   tU32 current;
   virtual ~rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgInitializeMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgInitializeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgInitializeMethodStart& operator=(const rvc_ccafi_tclMsgInitializeMethodStart& coRef);
   rvc_ccafi_tclMsgInitializeMethodStart(const rvc_ccafi_tclMsgInitializeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_Module e8Module;
   virtual ~rvc_ccafi_tclMsgInitializeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgInitializeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgInitializeMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgInitializeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgInitializeMethodResult& operator=(const rvc_ccafi_tclMsgInitializeMethodResult& coRef);
   rvc_ccafi_tclMsgInitializeMethodResult(const rvc_ccafi_tclMsgInitializeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgInitializeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgInitializeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgConfirmSystemStatusMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgConfirmSystemStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& operator=(const rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& coRef);
   rvc_ccafi_tclMsgConfirmSystemStatusMethodStart(const rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;
   virtual ~rvc_ccafi_tclMsgConfirmSystemStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgConfirmSystemStatusMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgConfirmSystemStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& operator=(const rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& coRef);
   rvc_ccafi_tclMsgConfirmSystemStatusMethodResult(const rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgConfirmSystemStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupUserConfigurationMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupUserConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& operator=(const rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& coRef);
   rvc_ccafi_tclMsgSetupUserConfigurationMethodStart(const rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<rvc_fi_tcl_ParkAssist_UserConfiguration, std::allocator<rvc_fi_tcl_ParkAssist_UserConfiguration> > arUserConfiguration;
   virtual ~rvc_ccafi_tclMsgSetupUserConfigurationMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetupUserConfigurationMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetupUserConfigurationMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& operator=(const rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& coRef);
   rvc_ccafi_tclMsgSetupUserConfigurationMethodResult(const rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetupUserConfigurationMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetMicrophoneStateMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetMicrophoneStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& operator=(const rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& coRef);
   rvc_ccafi_tclMsgSetMicrophoneStateMethodStart(const rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_Set_MicState e8RequestState;
   virtual ~rvc_ccafi_tclMsgSetMicrophoneStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetMicrophoneStateMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetMicrophoneStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& operator=(const rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& coRef);
   rvc_ccafi_tclMsgSetMicrophoneStateMethodResult(const rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetMicrophoneStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetRVCStatusMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetRVCStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetRVCStatusMethodStart& operator=(const rvc_ccafi_tclMsgSetRVCStatusMethodStart& coRef);
   rvc_ccafi_tclMsgSetRVCStatusMethodStart(const rvc_ccafi_tclMsgSetRVCStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 e8RequestState;
   virtual ~rvc_ccafi_tclMsgSetRVCStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetRVCStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetRVCStatusMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetRVCStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetRVCStatusMethodResult& operator=(const rvc_ccafi_tclMsgSetRVCStatusMethodResult& coRef);
   rvc_ccafi_tclMsgSetRVCStatusMethodResult(const rvc_ccafi_tclMsgSetRVCStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetRVCStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetRVCStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCamera_SetupBeepMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCamera_SetupBeepMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& operator=(const rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& coRef);
   rvc_ccafi_tclMsgCamera_SetupBeepMethodStart(const rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVM_StatusBeep e8SetupBeep;
   virtual ~rvc_ccafi_tclMsgCamera_SetupBeepMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCamera_SetupBeepMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCamera_SetupBeepMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& operator=(const rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& coRef);
   rvc_ccafi_tclMsgCamera_SetupBeepMethodResult(const rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVM_StatusBeep e8StatusBeep;
   virtual ~rvc_ccafi_tclMsgCamera_SetupBeepMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetCamerastateMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetCamerastateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetCamerastateMethodStart& operator=(const rvc_ccafi_tclMsgSetCamerastateMethodStart& coRef);
   rvc_ccafi_tclMsgSetCamerastateMethodStart(const rvc_ccafi_tclMsgSetCamerastateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_CameraState CameraState;
   virtual ~rvc_ccafi_tclMsgSetCamerastateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetCamerastateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetCamerastateMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetCamerastateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetCamerastateMethodResult& operator=(const rvc_ccafi_tclMsgSetCamerastateMethodResult& coRef);
   rvc_ccafi_tclMsgSetCamerastateMethodResult(const rvc_ccafi_tclMsgSetCamerastateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetCamerastateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetCamerastateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgChangeViewRequestMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgChangeViewRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgChangeViewRequestMethodStart& operator=(const rvc_ccafi_tclMsgChangeViewRequestMethodStart& coRef);
   rvc_ccafi_tclMsgChangeViewRequestMethodStart(const rvc_ccafi_tclMsgChangeViewRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVM_View_Request u8Status;
   virtual ~rvc_ccafi_tclMsgChangeViewRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgChangeViewRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgChangeViewRequestMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgChangeViewRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgChangeViewRequestMethodResult& operator=(const rvc_ccafi_tclMsgChangeViewRequestMethodResult& coRef);
   rvc_ccafi_tclMsgChangeViewRequestMethodResult(const rvc_ccafi_tclMsgChangeViewRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgChangeViewRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgChangeViewRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& coRef);
   rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Status;
   virtual ~rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& coRef);
   rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& coRef);
   rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Status;
   virtual ~rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& coRef);
   rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& coRef);
   rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Status;
   virtual ~rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& coRef);
   rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& operator=(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& coRef);
   rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_HMIStatus e8IPAStatus;
   virtual ~rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& operator=(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& coRef);
   rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPA_SetButtonMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPA_SetButtonMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPA_SetButtonMethodStart& operator=(const rvc_ccafi_tclMsgIPA_SetButtonMethodStart& coRef);
   rvc_ccafi_tclMsgIPA_SetButtonMethodStart(const rvc_ccafi_tclMsgIPA_SetButtonMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier;
   rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus;
   virtual ~rvc_ccafi_tclMsgIPA_SetButtonMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPA_SetButtonMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPA_SetButtonMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPA_SetButtonMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPA_SetButtonMethodResult& operator=(const rvc_ccafi_tclMsgIPA_SetButtonMethodResult& coRef);
   rvc_ccafi_tclMsgIPA_SetButtonMethodResult(const rvc_ccafi_tclMsgIPA_SetButtonMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgIPA_SetButtonMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPA_SetButtonMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& operator=(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& coRef);
   rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<rvc_fi_tcl_IPA_Voice_Text_Strings, std::allocator<rvc_fi_tcl_IPA_Voice_Text_Strings> > arTexts;
   rvc_fi_tcl_e8_RVC_Language Language;
   virtual ~rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& operator=(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& coRef);
   rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& operator=(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& coRef);
   rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_MVCViewingState e8Request;
   virtual ~rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& operator=(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& coRef);
   rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& coRef);
   rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_GdlAdj_Completion e8Completion;
   virtual ~rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& coRef);
   rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& coRef);
   rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_GdlAdj_AdjustButton e8Button;
   virtual ~rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& coRef);
   rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& operator=(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& coRef);
   rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_GdlAdj_Request e8Request;
   std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData;
   virtual ~rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& operator=(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& coRef);
   rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   rvc_fi_tcl_e8_GdlAdj_Request e8Request;
   std::vector<rvc_fi_tcl_GdlAdj_ConfigParameterData, std::allocator<rvc_fi_tcl_GdlAdj_ConfigParameterData> > arConfigParameterData;
   virtual ~rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAP_SetButtonMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAP_SetButtonMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgFAP_SetButtonMethodStart& operator=(const rvc_ccafi_tclMsgFAP_SetButtonMethodStart& coRef);
   rvc_ccafi_tclMsgFAP_SetButtonMethodStart(const rvc_ccafi_tclMsgFAP_SetButtonMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_BUTTON_ID e8ButtonIdentifier;
   rvc_fi_tcl_e8_RVC_ButtonState e8ButtonStatus;
   virtual ~rvc_ccafi_tclMsgFAP_SetButtonMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgFAP_SetButtonMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAP_SetButtonMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAP_SetButtonMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgFAP_SetButtonMethodResult& operator=(const rvc_ccafi_tclMsgFAP_SetButtonMethodResult& coRef);
   rvc_ccafi_tclMsgFAP_SetButtonMethodResult(const rvc_ccafi_tclMsgFAP_SetButtonMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgFAP_SetButtonMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgFAP_SetButtonMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgTouchEventMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgTouchEventMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgTouchEventMethodStart& operator=(const rvc_ccafi_tclMsgTouchEventMethodStart& coRef);
   rvc_ccafi_tclMsgTouchEventMethodStart(const rvc_ccafi_tclMsgTouchEventMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_Touch_Data arTouchData;
   virtual ~rvc_ccafi_tclMsgTouchEventMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgTouchEventMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgTouchEventMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgTouchEventMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgTouchEventMethodResult& operator=(const rvc_ccafi_tclMsgTouchEventMethodResult& coRef);
   rvc_ccafi_tclMsgTouchEventMethodResult(const rvc_ccafi_tclMsgTouchEventMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgTouchEventMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgTouchEventMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGPSInfoMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGPSInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGPSInfoMethodStart& operator=(const rvc_ccafi_tclMsgGPSInfoMethodStart& coRef);
   rvc_ccafi_tclMsgGPSInfoMethodStart(const rvc_ccafi_tclMsgGPSInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_GPS_Data arGpsData;
   virtual ~rvc_ccafi_tclMsgGPSInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGPSInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGPSInfoMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGPSInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGPSInfoMethodResult& operator=(const rvc_ccafi_tclMsgGPSInfoMethodResult& coRef);
   rvc_ccafi_tclMsgGPSInfoMethodResult(const rvc_ccafi_tclMsgGPSInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgGPSInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGPSInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMapMatchedInfoMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMapMatchedInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgMapMatchedInfoMethodStart& operator=(const rvc_ccafi_tclMsgMapMatchedInfoMethodStart& coRef);
   rvc_ccafi_tclMsgMapMatchedInfoMethodStart(const rvc_ccafi_tclMsgMapMatchedInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_MapMatched_Data arMapMatchedData;
   virtual ~rvc_ccafi_tclMsgMapMatchedInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgMapMatchedInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMapMatchedInfoMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMapMatchedInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgMapMatchedInfoMethodResult& operator=(const rvc_ccafi_tclMsgMapMatchedInfoMethodResult& coRef);
   rvc_ccafi_tclMsgMapMatchedInfoMethodResult(const rvc_ccafi_tclMsgMapMatchedInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgMapMatchedInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgMapMatchedInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFapLearnParkPositionMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFapLearnParkPositionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& operator=(const rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& coRef);
   rvc_ccafi_tclMsgFapLearnParkPositionMethodStart(const rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RequestOn;
   virtual ~rvc_ccafi_tclMsgFapLearnParkPositionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFapLearnParkPositionMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFapLearnParkPositionMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& operator=(const rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& coRef);
   rvc_ccafi_tclMsgFapLearnParkPositionMethodResult(const rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgFapLearnParkPositionMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetFapGuidanceMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetFapGuidanceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetFapGuidanceMethodStart& operator=(const rvc_ccafi_tclMsgSetFapGuidanceMethodStart& coRef);
   rvc_ccafi_tclMsgSetFapGuidanceMethodStart(const rvc_ccafi_tclMsgSetFapGuidanceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Request;
   virtual ~rvc_ccafi_tclMsgSetFapGuidanceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetFapGuidanceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSetFapGuidanceMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSetFapGuidanceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSetFapGuidanceMethodResult& operator=(const rvc_ccafi_tclMsgSetFapGuidanceMethodResult& coRef);
   rvc_ccafi_tclMsgSetFapGuidanceMethodResult(const rvc_ccafi_tclMsgSetFapGuidanceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Result;
   virtual ~rvc_ccafi_tclMsgSetFapGuidanceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSetFapGuidanceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& operator=(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& coRef);
   rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_SwitchId e8SwitchId;
   virtual ~rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& operator=(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& coRef);
   rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& operator=(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& coRef);
   rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus;
   virtual ~rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& operator=(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& coRef);
   rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& operator=(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& coRef);
   rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType;
   std::vector<rvc_fi_tcl_AVMph3_Setting_Item, std::allocator<rvc_fi_tcl_AVMph3_Setting_Item> > arChangedItems;
   virtual ~rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& operator=(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& coRef);
   rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& operator=(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& coRef);
   rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_RequestType e8RequestType;
   rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer;
   tBool bDetailsSettingsAvail;
   tBool bImageQualitySettingAvail;
   virtual ~rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& operator=(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& coRef);
   rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& operator=(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& coRef);
   rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_VersionInfoType e8VersionType;
   virtual ~rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& operator=(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& coRef);
   rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart();

   virtual ~rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& operator=(const rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& coRef);
   rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult(const rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart();

   virtual ~rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& operator=(const rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& coRef);
   rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult(const rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bResult;
   virtual ~rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart();

   virtual ~rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart();

   inline tBool operator==(const rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult();

   virtual ~rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult();

   inline tBool operator==(const rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSystemConfigurationsUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSystemConfigurationsUpReg();

   virtual ~rvc_ccafi_tclMsgSystemConfigurationsUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgSystemConfigurationsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSystemConfigurationsRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSystemConfigurationsRelUpReg();

   virtual ~rvc_ccafi_tclMsgSystemConfigurationsRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgSystemConfigurationsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSystemConfigurationsStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSystemConfigurationsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSystemConfigurationsStatus& operator=(const rvc_ccafi_tclMsgSystemConfigurationsStatus& coRef);
   rvc_ccafi_tclMsgSystemConfigurationsStatus(const rvc_ccafi_tclMsgSystemConfigurationsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_Camera_System_Type e8CameraSystem;
   tU8 u8RVCGuideLine;
   tU8 u8Brightness;
   virtual ~rvc_ccafi_tclMsgSystemConfigurationsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSystemConfigurationsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSystemStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSystemStatusUpReg();

   virtual ~rvc_ccafi_tclMsgSystemStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgSystemStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSystemStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSystemStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgSystemStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgSystemStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgSystemStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgSystemStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgSystemStatusStatus& operator=(const rvc_ccafi_tclMsgSystemStatusStatus& coRef);
   rvc_ccafi_tclMsgSystemStatusStatus(const rvc_ccafi_tclMsgSystemStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_SystemStatus e8SystemStatus;
   virtual ~rvc_ccafi_tclMsgSystemStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgSystemStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgVideoSignalStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgVideoSignalStatusUpReg();

   virtual ~rvc_ccafi_tclMsgVideoSignalStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgVideoSignalStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgVideoSignalStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgVideoSignalStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgVideoSignalStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgVideoSignalStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgVideoSignalStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgVideoSignalStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgVideoSignalStatusStatus& operator=(const rvc_ccafi_tclMsgVideoSignalStatusStatus& coRef);
   rvc_ccafi_tclMsgVideoSignalStatusStatus(const rvc_ccafi_tclMsgVideoSignalStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_SignalStatus e8StatusVideoSignal;
   virtual ~rvc_ccafi_tclMsgVideoSignalStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgVideoSignalStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgReverseSignalStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgReverseSignalStatusUpReg();

   virtual ~rvc_ccafi_tclMsgReverseSignalStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgReverseSignalStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgReverseSignalStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgReverseSignalStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgReverseSignalStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgReverseSignalStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgReverseSignalStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgReverseSignalStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgReverseSignalStatusStatus& operator=(const rvc_ccafi_tclMsgReverseSignalStatusStatus& coRef);
   rvc_ccafi_tclMsgReverseSignalStatusStatus(const rvc_ccafi_tclMsgReverseSignalStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_ReverseSignalStatus e8StatusReverseSignal;
   virtual ~rvc_ccafi_tclMsgReverseSignalStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgReverseSignalStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg();

   virtual ~rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet();

   virtual ~rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet();

   inline tBool operator==(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& operator=(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& coRef);
   rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 pwrSupplyID;
   rvc_fi_tcl_e8_Camera_PowerSupplyStatus status;
   tU32 current;
   virtual ~rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg();

   virtual ~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet();

   virtual ~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet();

   inline tBool operator==(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& operator=(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& coRef);
   rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 pwrSupplyID;
   rvc_fi_tcl_e8_Microphone_PowerSupplyStatus status;
   tU32 current;
   virtual ~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgTailgate_StatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgTailgate_StatusUpReg();

   virtual ~rvc_ccafi_tclMsgTailgate_StatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgTailgate_StatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgTailgate_StatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgTailgate_StatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgTailgate_StatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgTailgate_StatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgTailgate_StatusGet : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgTailgate_StatusGet();

   virtual ~rvc_ccafi_tclMsgTailgate_StatusGet();

   inline tBool operator==(const rvc_ccafi_tclMsgTailgate_StatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgTailgate_StatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgTailgate_StatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgTailgate_StatusStatus& operator=(const rvc_ccafi_tclMsgTailgate_StatusStatus& coRef);
   rvc_ccafi_tclMsgTailgate_StatusStatus(const rvc_ccafi_tclMsgTailgate_StatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_Tailgate_State State;
   virtual ~rvc_ccafi_tclMsgTailgate_StatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgTailgate_StatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgView_Close_AuthorizedUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgView_Close_AuthorizedUpReg();

   virtual ~rvc_ccafi_tclMsgView_Close_AuthorizedUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgView_Close_AuthorizedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg();

   virtual ~rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgView_Close_AuthorizedStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgView_Close_AuthorizedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgView_Close_AuthorizedStatus& operator=(const rvc_ccafi_tclMsgView_Close_AuthorizedStatus& coRef);
   rvc_ccafi_tclMsgView_Close_AuthorizedStatus(const rvc_ccafi_tclMsgView_Close_AuthorizedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_Exit_Authorized e8Allowed;
   virtual ~rvc_ccafi_tclMsgView_Close_AuthorizedStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgView_Close_AuthorizedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAvmR_Current_ViewUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAvmR_Current_ViewUpReg();

   virtual ~rvc_ccafi_tclMsgAvmR_Current_ViewUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAvmR_Current_ViewUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg();

   virtual ~rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAvmR_Current_ViewStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAvmR_Current_ViewStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAvmR_Current_ViewStatus& operator=(const rvc_ccafi_tclMsgAvmR_Current_ViewStatus& coRef);
   rvc_ccafi_tclMsgAvmR_Current_ViewStatus(const rvc_ccafi_tclMsgAvmR_Current_ViewStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVM_View_Status e8View;
   virtual ~rvc_ccafi_tclMsgAvmR_Current_ViewStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAvmR_Current_ViewStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_ITSUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_ITSUpReg();

   virtual ~rvc_ccafi_tclMsgAffordable_ITSUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAffordable_ITSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_ITSRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_ITSRelUpReg();

   virtual ~rvc_ccafi_tclMsgAffordable_ITSRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAffordable_ITSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAffordable_ITSStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAffordable_ITSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAffordable_ITSStatus& operator=(const rvc_ccafi_tclMsgAffordable_ITSStatus& coRef);
   rvc_ccafi_tclMsgAffordable_ITSStatus(const rvc_ccafi_tclMsgAffordable_ITSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AffordableIts_Status e8AffordableItsAvailable;
   rvc_fi_tcl_e8_AffordableIts_StatusFeature e8BswStatus;
   rvc_fi_tcl_e8_AffordableIts_StatusFeature e8ModStatus;
   rvc_fi_tcl_e8_AffordableIts_StatusFeature e8LdwStatus;
   virtual ~rvc_ccafi_tclMsgAffordable_ITSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAffordable_ITSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAConfigurationUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAConfigurationUpReg();

   virtual ~rvc_ccafi_tclMsgIPAConfigurationUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAConfigurationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAConfigurationRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAConfigurationRelUpReg();

   virtual ~rvc_ccafi_tclMsgIPAConfigurationRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAConfigurationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAConfigurationStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAConfigurationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPAConfigurationStatus& operator=(const rvc_ccafi_tclMsgIPAConfigurationStatus& coRef);
   rvc_ccafi_tclMsgIPAConfigurationStatus(const rvc_ccafi_tclMsgIPAConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_AvailabilityStatus e8AvailabilityStatus;
   rvc_fi_tcl_e8_IPA_RegionalSelection e8RegionalSelection;
   virtual ~rvc_ccafi_tclMsgIPAConfigurationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPAConfigurationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAStatusUpReg();

   virtual ~rvc_ccafi_tclMsgIPAStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgIPAStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPAStatusStatus& operator=(const rvc_ccafi_tclMsgIPAStatusStatus& coRef);
   rvc_ccafi_tclMsgIPAStatusStatus(const rvc_ccafi_tclMsgIPAStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_OperationStatus e8OperationStatus;
   rvc_fi_tcl_e8_IPA_ModeChangeRequest e8Request;
   virtual ~rvc_ccafi_tclMsgIPAStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPAStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAPatternRequestUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAPatternRequestUpReg();

   virtual ~rvc_ccafi_tclMsgIPAPatternRequestUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAPatternRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAPatternRequestRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAPatternRequestRelUpReg();

   virtual ~rvc_ccafi_tclMsgIPAPatternRequestRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAPatternRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAPatternRequestStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAPatternRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPAPatternRequestStatus& operator=(const rvc_ccafi_tclMsgIPAPatternRequestStatus& coRef);
   rvc_ccafi_tclMsgIPAPatternRequestStatus(const rvc_ccafi_tclMsgIPAPatternRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_PatternID e8DisplayPattern;
   virtual ~rvc_ccafi_tclMsgIPAPatternRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPAPatternRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAMessageRequestUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAMessageRequestUpReg();

   virtual ~rvc_ccafi_tclMsgIPAMessageRequestUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAMessageRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAMessageRequestRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAMessageRequestRelUpReg();

   virtual ~rvc_ccafi_tclMsgIPAMessageRequestRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPAMessageRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPAMessageRequestStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPAMessageRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPAMessageRequestStatus& operator=(const rvc_ccafi_tclMsgIPAMessageRequestStatus& coRef);
   rvc_ccafi_tclMsgIPAMessageRequestStatus(const rvc_ccafi_tclMsgIPAMessageRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_MessageID e8MessageID;
   virtual ~rvc_ccafi_tclMsgIPAMessageRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPAMessageRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg();

   virtual ~rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg();

   virtual ~rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPASwitchMaskRequestStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPASwitchMaskRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& operator=(const rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& coRef);
   rvc_ccafi_tclMsgIPASwitchMaskRequestStatus(const rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_SwitchMask e8SwitchMask;
   virtual ~rvc_ccafi_tclMsgIPASwitchMaskRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg();

   virtual ~rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg();

   virtual ~rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& operator=(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& coRef);
   rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SwitchGreyOut;
   virtual ~rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPADirectionIndicatorUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPADirectionIndicatorUpReg();

   virtual ~rvc_ccafi_tclMsgIPADirectionIndicatorUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPADirectionIndicatorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg();

   virtual ~rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgIPADirectionIndicatorStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgIPADirectionIndicatorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgIPADirectionIndicatorStatus& operator=(const rvc_ccafi_tclMsgIPADirectionIndicatorStatus& coRef);
   rvc_ccafi_tclMsgIPADirectionIndicatorStatus(const rvc_ccafi_tclMsgIPADirectionIndicatorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_IPA_DirectionIndicator e8Direction;
   virtual ~rvc_ccafi_tclMsgIPADirectionIndicatorStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgIPADirectionIndicatorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg();

   virtual ~rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg();

   virtual ~rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& operator=(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& coRef);
   rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bShowValues;
   tU8 u8CentreAdjustmentState;
   tS32 s32SteeringAngleCentreAdjusted;
   rvc_fi_tclString SteeringAngleSignalState;
   virtual ~rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg();

   virtual ~rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg();

   virtual ~rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& operator=(const rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& coRef);
   rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus(const rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tF32 f32CameraRollAngle;
   tF32 f32CameraYawAngle;
   tF32 f32CameraPitchAngle;
   virtual ~rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCANFrameStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCANFrameStatusUpReg();

   virtual ~rvc_ccafi_tclMsgCANFrameStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgCANFrameStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCANFrameStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCANFrameStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgCANFrameStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgCANFrameStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgCANFrameStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgCANFrameStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgCANFrameStatusStatus& operator=(const rvc_ccafi_tclMsgCANFrameStatusStatus& coRef);
   rvc_ccafi_tclMsgCANFrameStatusStatus(const rvc_ccafi_tclMsgCANFrameStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_RVC_SignalStatus e8StatusCANFrame;
   virtual ~rvc_ccafi_tclMsgCANFrameStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgCANFrameStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMvcViewStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMvcViewStatusUpReg();

   virtual ~rvc_ccafi_tclMsgMvcViewStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgMvcViewStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMvcViewStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMvcViewStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgMvcViewStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgMvcViewStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMvcViewStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMvcViewStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgMvcViewStatusStatus& operator=(const rvc_ccafi_tclMsgMvcViewStatusStatus& coRef);
   rvc_ccafi_tclMsgMvcViewStatusStatus(const rvc_ccafi_tclMsgMvcViewStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_MVCViewingState e8View;
   virtual ~rvc_ccafi_tclMsgMvcViewStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgMvcViewStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMvcAlertRequestUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMvcAlertRequestUpReg();

   virtual ~rvc_ccafi_tclMsgMvcAlertRequestUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgMvcAlertRequestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMvcAlertRequestRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMvcAlertRequestRelUpReg();

   virtual ~rvc_ccafi_tclMsgMvcAlertRequestRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgMvcAlertRequestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgMvcAlertRequestStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgMvcAlertRequestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgMvcAlertRequestStatus& operator=(const rvc_ccafi_tclMsgMvcAlertRequestStatus& coRef);
   rvc_ccafi_tclMsgMvcAlertRequestStatus(const rvc_ccafi_tclMsgMvcAlertRequestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRequest;
   virtual ~rvc_ccafi_tclMsgMvcAlertRequestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgMvcAlertRequestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPModeUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPModeUpReg();

   virtual ~rvc_ccafi_tclMsgFAPModeUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgFAPModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPModeRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPModeRelUpReg();

   virtual ~rvc_ccafi_tclMsgFAPModeRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgFAPModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPModeStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgFAPModeStatus& operator=(const rvc_ccafi_tclMsgFAPModeStatus& coRef);
   rvc_ccafi_tclMsgFAPModeStatus(const rvc_ccafi_tclMsgFAPModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool e8State;
   virtual ~rvc_ccafi_tclMsgFAPModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgFAPModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPSettingsUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPSettingsUpReg();

   virtual ~rvc_ccafi_tclMsgFAPSettingsUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgFAPSettingsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPSettingsRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPSettingsRelUpReg();

   virtual ~rvc_ccafi_tclMsgFAPSettingsRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgFAPSettingsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPSettingsStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPSettingsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgFAPSettingsStatus& operator=(const rvc_ccafi_tclMsgFAPSettingsStatus& coRef);
   rvc_ccafi_tclMsgFAPSettingsStatus(const rvc_ccafi_tclMsgFAPSettingsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<rvc_fi_tcl_FAP_Settings_State, std::allocator<rvc_fi_tcl_FAP_Settings_State> > arFapSettingState;
   std::vector<rvc_fi_tcl_AVM_Settings_State, std::allocator<rvc_fi_tcl_AVM_Settings_State> > arAvmSettingState;
   virtual ~rvc_ccafi_tclMsgFAPSettingsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgFAPSettingsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPGuidanceStateUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPGuidanceStateUpReg();

   virtual ~rvc_ccafi_tclMsgFAPGuidanceStateUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgFAPGuidanceStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg();

   virtual ~rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgFAPGuidanceStateStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgFAPGuidanceStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgFAPGuidanceStateStatus& operator=(const rvc_ccafi_tclMsgFAPGuidanceStateStatus& coRef);
   rvc_ccafi_tclMsgFAPGuidanceStateStatus(const rvc_ccafi_tclMsgFAPGuidanceStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool e8State;
   virtual ~rvc_ccafi_tclMsgFAPGuidanceStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgFAPGuidanceStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_DispStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_DispStatusUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_DispStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_DispStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_DispStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_DispStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_DispStatusStatus& operator=(const rvc_ccafi_tclMsgAVM3_DispStatusStatus& coRef);
   rvc_ccafi_tclMsgAVM3_DispStatusStatus(const rvc_ccafi_tclMsgAVM3_DispStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_DispStatus e8DispStatus;
   virtual ~rvc_ccafi_tclMsgAVM3_DispStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_DispStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ViewSetupUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ViewSetupUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_ViewSetupUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_ViewSetupUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ViewSetupStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ViewSetupStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_ViewSetupStatus& operator=(const rvc_ccafi_tclMsgAVM3_ViewSetupStatus& coRef);
   rvc_ccafi_tclMsgAVM3_ViewSetupStatus(const rvc_ccafi_tclMsgAVM3_ViewSetupStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_ViewPattern e8ViewPattern;
   rvc_fi_tcl_e8_AVMph3_CautionId e8CautionId;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch1;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch2;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch3;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch4;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch5;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch6;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch7;
   rvc_fi_tcl_AVMph3_SwitchDescriptor Switch8;
   rvc_fi_tcl_e8_AVMph3_IconId e8IconId;
   rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus;
   virtual ~rvc_ccafi_tclMsgAVM3_ViewSetupStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_ViewSetupStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ErrorMessageStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ErrorMessageStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& operator=(const rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& coRef);
   rvc_ccafi_tclMsgAVM3_ErrorMessageStatus(const rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_ErrorMessage e8ErrorMessage;
   virtual ~rvc_ccafi_tclMsgAVM3_ErrorMessageStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& operator=(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& coRef);
   rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_BuzzerStatus e8BuzzerStatus;
   virtual ~rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& operator=(const rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& coRef);
   rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus(const rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<rvc_fi_tcl_AVMph3_Setting_Option, std::allocator<rvc_fi_tcl_AVMph3_Setting_Option> > arSettingsOption;
   rvc_fi_tcl_e8_AVMph3_Setting_PrioView e8PriorityView;
   rvc_fi_tcl_e8_AVMph3_Setting_PrioWide e8PriorityWide;
   rvc_fi_tcl_e8_AVMph3_Setting_AutoCamPos e8AutoCamPos;
   rvc_fi_tcl_AVMph3_Setting_CornerSonarSensLvl rCornerSonarSensLvl;
   rvc_fi_tcl_AVMph3_Setting_SonarSensLvl rSonarSensLvl;
   rvc_fi_tcl_AVMph3_Setting_BuzzerSoundLvl rBuzzerSoundLvl;
   virtual ~rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& operator=(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& coRef);
   rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer;
   tBool bDetailsSettingsAvail;
   tBool bImageQualitySettingAvail;
   virtual ~rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ConfigurationUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ConfigurationUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_ConfigurationUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_ConfigurationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_ConfigurationStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_ConfigurationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_ConfigurationStatus& operator=(const rvc_ccafi_tclMsgAVM3_ConfigurationStatus& coRef);
   rvc_ccafi_tclMsgAVM3_ConfigurationStatus(const rvc_ccafi_tclMsgAVM3_ConfigurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_e8_AVMph3_ConfigurationStatus e8ConfigStatus;
   rvc_fi_tcl_AVMph3_Unit_ID rUnit_ID;
   rvc_fi_tcl_AVMph3_VersionInfo rMsgSetVersion;
   virtual ~rvc_ccafi_tclMsgAVM3_ConfigurationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_ConfigurationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Software_VersionUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Software_VersionUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Software_VersionUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Software_VersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Software_VersionStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Software_VersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Software_VersionStatus& operator=(const rvc_ccafi_tclMsgAVM3_Software_VersionStatus& coRef);
   rvc_ccafi_tclMsgAVM3_Software_VersionStatus(const rvc_ccafi_tclMsgAVM3_Software_VersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_AVM;
   rvc_fi_tcl_AVMph3_VersionInfo rSW_Version_Sonar;
   virtual ~rvc_ccafi_tclMsgAVM3_Software_VersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Software_VersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& operator=(const rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& coRef);
   rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus(const rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_AVM;
   rvc_fi_tcl_AVMph3_VersionInfo rHW_Version_Sonar;
   virtual ~rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg();

   virtual ~rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg();

   inline tBool operator==(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus : public rvc_ccafi_tclMsgBaseMessage
{
public:

   rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& operator=(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& coRef);
   rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   rvc_fi_tcl_AVMph3_MCAN_CommunicationErrors rCommErrors;
   virtual ~rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
