/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define RVC_FI_S_IMPORT_INTERFACE_RVC_CCAFI_TYPES
#define RVC_FI_S_IMPORT_INTERFACE_RVC_CCAFI_FUNCTIONIDS
#define RVC_FI_S_IMPORT_INTERFACE_RVC_CCAFI_SERVICEINFO
#include "rvc_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for rvc_cca_fi message types

fi_tclMessageBase* rvc_ccafi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgCameraButtonMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgCameraButtonMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetStatusHmiMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetStatusHmiMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetupLanguageMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetupLanguageMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetupGuideLineMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetupGuideLineMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetupVideoControlsMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetupVideoControlsMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetSystemStatusMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetSystemStatusMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgInitializeMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgInitializeMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgConfirmSystemStatusMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgConfirmSystemStatusMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetupUserConfigurationMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetupUserConfigurationMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetMicrophoneStateMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetMicrophoneStateMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetRVCStatusMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetRVCStatusMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgCamera_SetupBeepMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgCamera_SetupBeepMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetCamerastateMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetCamerastateMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgChangeViewRequestMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgChangeViewRequestMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgIPA_SetButtonMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgIPA_SetButtonMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgFAP_SetButtonMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgFAP_SetButtonMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgTouchEventMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgTouchEventMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgGPSInfoMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgGPSInfoMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgMapMatchedInfoMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgMapMatchedInfoMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgFapLearnParkPositionMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgFapLearnParkPositionMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgSetFapGuidanceMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgSetFapGuidanceMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODSTART:
         return OSAL_NEW rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart;

      case rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODRESULT:
         return OSAL_NEW rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult;

      case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgSystemConfigurationsUpReg;

      case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgSystemConfigurationsRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgSystemConfigurationsStatus;

      case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgSystemStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgSystemStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgSystemStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgVideoSignalStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgVideoSignalStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgVideoSignalStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgReverseSignalStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgReverseSignalStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgReverseSignalStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSGET:
         return OSAL_NEW rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet;

      case rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSGET:
         return OSAL_NEW rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet;

      case rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgTailgate_StatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgTailgate_StatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSGET:
         return OSAL_NEW rvc_ccafi_tclMsgTailgate_StatusGet;

      case rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgTailgate_StatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgView_Close_AuthorizedUpReg;

      case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgView_Close_AuthorizedStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAvmR_Current_ViewUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAvmR_Current_ViewStatus;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_ITSUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_ITSRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAffordable_ITSStatus;

      case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAConfigurationUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAConfigurationRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgIPAConfigurationStatus;

      case rvc_ccafi_tclToken::EN_MSG_IPASTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPASTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPASTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgIPAStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAPatternRequestUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAPatternRequestRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgIPAPatternRequestStatus;

      case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAMessageRequestUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPAMessageRequestRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgIPAMessageRequestStatus;

      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgIPASwitchMaskRequestStatus;

      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus;

      case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPADirectionIndicatorUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgIPADirectionIndicatorStatus;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLEUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLERELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLESTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLEUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLERELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLESTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus;

      case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgCANFrameStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgCANFrameStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgCANFrameStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgMvcViewStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgMvcViewStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgMvcViewStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgMvcAlertRequestUpReg;

      case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgMvcAlertRequestRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgMvcAlertRequestStatus;

      case rvc_ccafi_tclToken::EN_MSG_FAPMODEUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgFAPModeUpReg;

      case rvc_ccafi_tclToken::EN_MSG_FAPMODERELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgFAPModeRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_FAPMODESTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgFAPModeStatus;

      case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgFAPSettingsUpReg;

      case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgFAPSettingsRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgFAPSettingsStatus;

      case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATEUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgFAPGuidanceStateUpReg;

      case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATERELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATESTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgFAPGuidanceStateStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_DispStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_DispStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ViewSetupUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ViewSetupStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGEUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGERELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGESTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ErrorMessageStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ConfigurationUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_ConfigurationStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Software_VersionUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Software_VersionStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSRELUPREG:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg;

      case rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSSTATUS:
         return OSAL_NEW rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all rvc_ccafifi messages

// common functions

tU16 rvc_ccafi_tclMsgBaseMessage::u16GetServiceID() const
{
   return RVC_CCAFI_C_U16_SERVICE_ID;
}

tU16 rvc_ccafi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 rvc_ccafi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& rvc_ccafi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& rvc_ccafi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 rvc_ccafi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& rvc_ccafi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& rvc_ccafi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgCameraButtonMethodStart::rvc_ccafi_tclMsgCameraButtonMethodStart(const rvc_ccafi_tclMsgCameraButtonMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8ButtonState = coRef.e8ButtonState;
}
rvc_ccafi_tclMsgCameraButtonMethodStart& rvc_ccafi_tclMsgCameraButtonMethodStart::operator=(const rvc_ccafi_tclMsgCameraButtonMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ButtonState = coRef.e8ButtonState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgCameraButtonMethodStart::rvc_ccafi_tclMsgCameraButtonMethodStart()
:e8ButtonState()
 {}

tS32 rvc_ccafi_tclMsgCameraButtonMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODSTART;
}


rvc_ccafi_tclMsgCameraButtonMethodStart::~rvc_ccafi_tclMsgCameraButtonMethodStart()
{}

tU32 rvc_ccafi_tclMsgCameraButtonMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgCameraButtonMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ButtonState);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgCameraButtonMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ButtonState);
   return oOut;
}

tBool rvc_ccafi_tclMsgCameraButtonMethodStart::operator==(const rvc_ccafi_tclMsgCameraButtonMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ButtonState == roRef.e8ButtonState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgCameraButtonMethodResult::rvc_ccafi_tclMsgCameraButtonMethodResult(const rvc_ccafi_tclMsgCameraButtonMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgCameraButtonMethodResult& rvc_ccafi_tclMsgCameraButtonMethodResult::operator=(const rvc_ccafi_tclMsgCameraButtonMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgCameraButtonMethodResult::rvc_ccafi_tclMsgCameraButtonMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgCameraButtonMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERABUTTONMETHODRESULT;
}


rvc_ccafi_tclMsgCameraButtonMethodResult::~rvc_ccafi_tclMsgCameraButtonMethodResult()
{}

tU32 rvc_ccafi_tclMsgCameraButtonMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgCameraButtonMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgCameraButtonMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgCameraButtonMethodResult::operator==(const rvc_ccafi_tclMsgCameraButtonMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetStatusHmiMethodStart::rvc_ccafi_tclMsgSetStatusHmiMethodStart(const rvc_ccafi_tclMsgSetStatusHmiMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8StatusHmi = coRef.e8StatusHmi;
}
rvc_ccafi_tclMsgSetStatusHmiMethodStart& rvc_ccafi_tclMsgSetStatusHmiMethodStart::operator=(const rvc_ccafi_tclMsgSetStatusHmiMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8StatusHmi = coRef.e8StatusHmi;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetStatusHmiMethodStart::rvc_ccafi_tclMsgSetStatusHmiMethodStart()
:e8StatusHmi()
 {}

tS32 rvc_ccafi_tclMsgSetStatusHmiMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODSTART;
}


rvc_ccafi_tclMsgSetStatusHmiMethodStart::~rvc_ccafi_tclMsgSetStatusHmiMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetStatusHmiMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetStatusHmiMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8StatusHmi);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetStatusHmiMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8StatusHmi);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetStatusHmiMethodStart::operator==(const rvc_ccafi_tclMsgSetStatusHmiMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8StatusHmi == roRef.e8StatusHmi);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetStatusHmiMethodResult::rvc_ccafi_tclMsgSetStatusHmiMethodResult(const rvc_ccafi_tclMsgSetStatusHmiMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8SystemStatus = coRef.e8SystemStatus;
}
rvc_ccafi_tclMsgSetStatusHmiMethodResult& rvc_ccafi_tclMsgSetStatusHmiMethodResult::operator=(const rvc_ccafi_tclMsgSetStatusHmiMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8SystemStatus = coRef.e8SystemStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetStatusHmiMethodResult::rvc_ccafi_tclMsgSetStatusHmiMethodResult()
:e8SystemStatus()
 {}

tS32 rvc_ccafi_tclMsgSetStatusHmiMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETSTATUSHMIMETHODRESULT;
}


rvc_ccafi_tclMsgSetStatusHmiMethodResult::~rvc_ccafi_tclMsgSetStatusHmiMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetStatusHmiMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetStatusHmiMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SystemStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetStatusHmiMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SystemStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetStatusHmiMethodResult::operator==(const rvc_ccafi_tclMsgSetStatusHmiMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SystemStatus == roRef.e8SystemStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupLanguageMethodStart::rvc_ccafi_tclMsgSetupLanguageMethodStart(const rvc_ccafi_tclMsgSetupLanguageMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Language = coRef.e8Language;
}
rvc_ccafi_tclMsgSetupLanguageMethodStart& rvc_ccafi_tclMsgSetupLanguageMethodStart::operator=(const rvc_ccafi_tclMsgSetupLanguageMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Language = coRef.e8Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetupLanguageMethodStart::rvc_ccafi_tclMsgSetupLanguageMethodStart()
:e8Language()
 {}

tS32 rvc_ccafi_tclMsgSetupLanguageMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODSTART;
}


rvc_ccafi_tclMsgSetupLanguageMethodStart::~rvc_ccafi_tclMsgSetupLanguageMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetupLanguageMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetupLanguageMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Language);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupLanguageMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Language);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupLanguageMethodStart::operator==(const rvc_ccafi_tclMsgSetupLanguageMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Language == roRef.e8Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupLanguageMethodResult::rvc_ccafi_tclMsgSetupLanguageMethodResult(const rvc_ccafi_tclMsgSetupLanguageMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetupLanguageMethodResult& rvc_ccafi_tclMsgSetupLanguageMethodResult::operator=(const rvc_ccafi_tclMsgSetupLanguageMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetupLanguageMethodResult::rvc_ccafi_tclMsgSetupLanguageMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetupLanguageMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPLANGUAGEMETHODRESULT;
}


rvc_ccafi_tclMsgSetupLanguageMethodResult::~rvc_ccafi_tclMsgSetupLanguageMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetupLanguageMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetupLanguageMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupLanguageMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupLanguageMethodResult::operator==(const rvc_ccafi_tclMsgSetupLanguageMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupGuideLineMethodStart::rvc_ccafi_tclMsgSetupGuideLineMethodStart(const rvc_ccafi_tclMsgSetupGuideLineMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8GuideLine = coRef.e8GuideLine;
}
rvc_ccafi_tclMsgSetupGuideLineMethodStart& rvc_ccafi_tclMsgSetupGuideLineMethodStart::operator=(const rvc_ccafi_tclMsgSetupGuideLineMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8GuideLine = coRef.e8GuideLine;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetupGuideLineMethodStart::rvc_ccafi_tclMsgSetupGuideLineMethodStart()
:e8GuideLine()
 {}

tS32 rvc_ccafi_tclMsgSetupGuideLineMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODSTART;
}


rvc_ccafi_tclMsgSetupGuideLineMethodStart::~rvc_ccafi_tclMsgSetupGuideLineMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetupGuideLineMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetupGuideLineMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8GuideLine);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupGuideLineMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8GuideLine);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupGuideLineMethodStart::operator==(const rvc_ccafi_tclMsgSetupGuideLineMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8GuideLine == roRef.e8GuideLine);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupGuideLineMethodResult::rvc_ccafi_tclMsgSetupGuideLineMethodResult(const rvc_ccafi_tclMsgSetupGuideLineMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetupGuideLineMethodResult& rvc_ccafi_tclMsgSetupGuideLineMethodResult::operator=(const rvc_ccafi_tclMsgSetupGuideLineMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetupGuideLineMethodResult::rvc_ccafi_tclMsgSetupGuideLineMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetupGuideLineMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPGUIDELINEMETHODRESULT;
}


rvc_ccafi_tclMsgSetupGuideLineMethodResult::~rvc_ccafi_tclMsgSetupGuideLineMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetupGuideLineMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetupGuideLineMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupGuideLineMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupGuideLineMethodResult::operator==(const rvc_ccafi_tclMsgSetupGuideLineMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupVideoControlsMethodStart::rvc_ccafi_tclMsgSetupVideoControlsMethodStart(const rvc_ccafi_tclMsgSetupVideoControlsMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8HMIDimmingMode = coRef.e8HMIDimmingMode;
   arVideoControlParameter = coRef.arVideoControlParameter;
   e8MVCViewingState = coRef.e8MVCViewingState;
}
rvc_ccafi_tclMsgSetupVideoControlsMethodStart& rvc_ccafi_tclMsgSetupVideoControlsMethodStart::operator=(const rvc_ccafi_tclMsgSetupVideoControlsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8HMIDimmingMode = coRef.e8HMIDimmingMode;
   arVideoControlParameter = coRef.arVideoControlParameter;
   e8MVCViewingState = coRef.e8MVCViewingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgSetupVideoControlsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arVideoControlParameter.size(); ++u32Idx)
         arVideoControlParameter[u32Idx].vDestroy();
   arVideoControlParameter.clear();
   }
}

rvc_ccafi_tclMsgSetupVideoControlsMethodStart::rvc_ccafi_tclMsgSetupVideoControlsMethodStart()
:e8HMIDimmingMode()

,e8MVCViewingState()
 {}

tS32 rvc_ccafi_tclMsgSetupVideoControlsMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODSTART;
}


rvc_ccafi_tclMsgSetupVideoControlsMethodStart::~rvc_ccafi_tclMsgSetupVideoControlsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgSetupVideoControlsMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(arVideoControlParameter.size()*3);
}

fi_tclInContext& rvc_ccafi_tclMsgSetupVideoControlsMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8HMIDimmingMode);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arVideoControlParameter.size(); ++u32Idx)
      {
         arVideoControlParameter[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arVideoControlParameter.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arVideoControlParameter[u32Idx]);
      }
   }
   (tVoid) (oIn >> e8MVCViewingState);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupVideoControlsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8HMIDimmingMode);
   (tVoid) (oOut << (tU32)arVideoControlParameter.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arVideoControlParameter.size(); ++u32Idx)
         (tVoid) (oOut << arVideoControlParameter[u32Idx]);
   }
   (tVoid) (oOut << e8MVCViewingState);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupVideoControlsMethodStart::operator==(const rvc_ccafi_tclMsgSetupVideoControlsMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8HMIDimmingMode == roRef.e8HMIDimmingMode);
      bResult = bResult && (arVideoControlParameter.size() == roRef.arVideoControlParameter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arVideoControlParameter.size()); ++u32Idx)
            bResult = bResult && (arVideoControlParameter[u32Idx] == roRef.arVideoControlParameter[u32Idx]);
      }
   bResult = bResult && (e8MVCViewingState == roRef.e8MVCViewingState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupVideoControlsMethodResult::rvc_ccafi_tclMsgSetupVideoControlsMethodResult(const rvc_ccafi_tclMsgSetupVideoControlsMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetupVideoControlsMethodResult& rvc_ccafi_tclMsgSetupVideoControlsMethodResult::operator=(const rvc_ccafi_tclMsgSetupVideoControlsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetupVideoControlsMethodResult::rvc_ccafi_tclMsgSetupVideoControlsMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetupVideoControlsMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPVIDEOCONTROLSMETHODRESULT;
}


rvc_ccafi_tclMsgSetupVideoControlsMethodResult::~rvc_ccafi_tclMsgSetupVideoControlsMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetupVideoControlsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetupVideoControlsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupVideoControlsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupVideoControlsMethodResult::operator==(const rvc_ccafi_tclMsgSetupVideoControlsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetSystemStatusMethodStart::rvc_ccafi_tclMsgSetSystemStatusMethodStart(const rvc_ccafi_tclMsgSetSystemStatusMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8SystemStatus = coRef.e8SystemStatus;
   e8GuideLine = coRef.e8GuideLine;
   e8WarningText = coRef.e8WarningText;
}
rvc_ccafi_tclMsgSetSystemStatusMethodStart& rvc_ccafi_tclMsgSetSystemStatusMethodStart::operator=(const rvc_ccafi_tclMsgSetSystemStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SystemStatus = coRef.e8SystemStatus;
   e8GuideLine = coRef.e8GuideLine;
   e8WarningText = coRef.e8WarningText;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetSystemStatusMethodStart::rvc_ccafi_tclMsgSetSystemStatusMethodStart()
:e8SystemStatus()
,e8GuideLine()
,e8WarningText()
 {}

tS32 rvc_ccafi_tclMsgSetSystemStatusMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODSTART;
}


rvc_ccafi_tclMsgSetSystemStatusMethodStart::~rvc_ccafi_tclMsgSetSystemStatusMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetSystemStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& rvc_ccafi_tclMsgSetSystemStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SystemStatus);
   (tVoid) (oIn >> e8GuideLine);
   (tVoid) (oIn >> e8WarningText);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetSystemStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SystemStatus);
   (tVoid) (oOut << e8GuideLine);
   (tVoid) (oOut << e8WarningText);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetSystemStatusMethodStart::operator==(const rvc_ccafi_tclMsgSetSystemStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SystemStatus == roRef.e8SystemStatus);
   bResult = bResult && (e8GuideLine == roRef.e8GuideLine);
   bResult = bResult && (e8WarningText == roRef.e8WarningText);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetSystemStatusMethodResult::rvc_ccafi_tclMsgSetSystemStatusMethodResult(const rvc_ccafi_tclMsgSetSystemStatusMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetSystemStatusMethodResult& rvc_ccafi_tclMsgSetSystemStatusMethodResult::operator=(const rvc_ccafi_tclMsgSetSystemStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetSystemStatusMethodResult::rvc_ccafi_tclMsgSetSystemStatusMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetSystemStatusMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETSYSTEMSTATUSMETHODRESULT;
}


rvc_ccafi_tclMsgSetSystemStatusMethodResult::~rvc_ccafi_tclMsgSetSystemStatusMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetSystemStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetSystemStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetSystemStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetSystemStatusMethodResult::operator==(const rvc_ccafi_tclMsgSetSystemStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   pwrSupplyID = coRef.pwrSupplyID;
}
rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::operator=(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   pwrSupplyID = coRef.pwrSupplyID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart()
:pwrSupplyID(0)
 {}

tS32 rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODSTART;
}


rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::~rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart()
{}

tU32 rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> pwrSupplyID);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << pwrSupplyID);
   return oOut;
}

tBool rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart::operator==(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (pwrSupplyID == roRef.pwrSupplyID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   pwrSupplyID = coRef.pwrSupplyID;
   status = coRef.status;
   current = coRef.current;
}
rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::operator=(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   pwrSupplyID = coRef.pwrSupplyID;
   status = coRef.status;
   current = coRef.current;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult()
:pwrSupplyID(0)
,status()
,current(0)
 {}

tS32 rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_RUNEXTDEVICEPOWERSUPPLYTESTMETHODRESULT;
}


rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::~rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult()
{}

tU32 rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> pwrSupplyID);
   (tVoid) (oIn >> status);
   (tVoid) (oIn >> current);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << pwrSupplyID);
   (tVoid) (oOut << status);
   (tVoid) (oOut << current);
   return oOut;
}

tBool rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult::operator==(const rvc_ccafi_tclMsgrunExtDevicePowerSupplyTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (pwrSupplyID == roRef.pwrSupplyID);
   bResult = bResult && (status == roRef.status);
   bResult = bResult && (current == roRef.current);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgInitializeMethodStart::rvc_ccafi_tclMsgInitializeMethodStart(const rvc_ccafi_tclMsgInitializeMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Module = coRef.e8Module;
}
rvc_ccafi_tclMsgInitializeMethodStart& rvc_ccafi_tclMsgInitializeMethodStart::operator=(const rvc_ccafi_tclMsgInitializeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Module = coRef.e8Module;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgInitializeMethodStart::rvc_ccafi_tclMsgInitializeMethodStart()
:e8Module()
 {}

tS32 rvc_ccafi_tclMsgInitializeMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODSTART;
}


rvc_ccafi_tclMsgInitializeMethodStart::~rvc_ccafi_tclMsgInitializeMethodStart()
{}

tU32 rvc_ccafi_tclMsgInitializeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgInitializeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Module);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgInitializeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Module);
   return oOut;
}

tBool rvc_ccafi_tclMsgInitializeMethodStart::operator==(const rvc_ccafi_tclMsgInitializeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Module == roRef.e8Module);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgInitializeMethodResult::rvc_ccafi_tclMsgInitializeMethodResult(const rvc_ccafi_tclMsgInitializeMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgInitializeMethodResult& rvc_ccafi_tclMsgInitializeMethodResult::operator=(const rvc_ccafi_tclMsgInitializeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgInitializeMethodResult::rvc_ccafi_tclMsgInitializeMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgInitializeMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_INITIALIZEMETHODRESULT;
}


rvc_ccafi_tclMsgInitializeMethodResult::~rvc_ccafi_tclMsgInitializeMethodResult()
{}

tU32 rvc_ccafi_tclMsgInitializeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgInitializeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgInitializeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgInitializeMethodResult::operator==(const rvc_ccafi_tclMsgInitializeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::rvc_ccafi_tclMsgConfirmSystemStatusMethodStart(const rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8SystemStatus = coRef.e8SystemStatus;
}
rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::operator=(const rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SystemStatus = coRef.e8SystemStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::rvc_ccafi_tclMsgConfirmSystemStatusMethodStart()
:e8SystemStatus()
 {}

tS32 rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODSTART;
}


rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::~rvc_ccafi_tclMsgConfirmSystemStatusMethodStart()
{}

tU32 rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SystemStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SystemStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgConfirmSystemStatusMethodStart::operator==(const rvc_ccafi_tclMsgConfirmSystemStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SystemStatus == roRef.e8SystemStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::rvc_ccafi_tclMsgConfirmSystemStatusMethodResult(const rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::operator=(const rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::rvc_ccafi_tclMsgConfirmSystemStatusMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CONFIRMSYSTEMSTATUSMETHODRESULT;
}


rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::~rvc_ccafi_tclMsgConfirmSystemStatusMethodResult()
{}

tU32 rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgConfirmSystemStatusMethodResult::operator==(const rvc_ccafi_tclMsgConfirmSystemStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::rvc_ccafi_tclMsgSetupUserConfigurationMethodStart(const rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   arUserConfiguration = coRef.arUserConfiguration;
}
rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::operator=(const rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   arUserConfiguration = coRef.arUserConfiguration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arUserConfiguration.size(); ++u32Idx)
         arUserConfiguration[u32Idx].vDestroy();
   arUserConfiguration.clear();
   }
}

rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::rvc_ccafi_tclMsgSetupUserConfigurationMethodStart()

 {}

tS32 rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODSTART;
}


rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::~rvc_ccafi_tclMsgSetupUserConfigurationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arUserConfiguration.size()*2);
}

fi_tclInContext& rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arUserConfiguration.size(); ++u32Idx)
      {
         arUserConfiguration[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arUserConfiguration.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arUserConfiguration[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arUserConfiguration.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arUserConfiguration.size(); ++u32Idx)
         (tVoid) (oOut << arUserConfiguration[u32Idx]);
   }
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupUserConfigurationMethodStart::operator==(const rvc_ccafi_tclMsgSetupUserConfigurationMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arUserConfiguration.size() == roRef.arUserConfiguration.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arUserConfiguration.size()); ++u32Idx)
            bResult = bResult && (arUserConfiguration[u32Idx] == roRef.arUserConfiguration[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::rvc_ccafi_tclMsgSetupUserConfigurationMethodResult(const rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::operator=(const rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::rvc_ccafi_tclMsgSetupUserConfigurationMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETUPUSERCONFIGURATIONMETHODRESULT;
}


rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::~rvc_ccafi_tclMsgSetupUserConfigurationMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetupUserConfigurationMethodResult::operator==(const rvc_ccafi_tclMsgSetupUserConfigurationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::rvc_ccafi_tclMsgSetMicrophoneStateMethodStart(const rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8RequestState = coRef.e8RequestState;
}
rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::operator=(const rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8RequestState = coRef.e8RequestState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::rvc_ccafi_tclMsgSetMicrophoneStateMethodStart()
:e8RequestState()
 {}

tS32 rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODSTART;
}


rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::~rvc_ccafi_tclMsgSetMicrophoneStateMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RequestState);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RequestState);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetMicrophoneStateMethodStart::operator==(const rvc_ccafi_tclMsgSetMicrophoneStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RequestState == roRef.e8RequestState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::rvc_ccafi_tclMsgSetMicrophoneStateMethodResult(const rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::operator=(const rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::rvc_ccafi_tclMsgSetMicrophoneStateMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETMICROPHONESTATEMETHODRESULT;
}


rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::~rvc_ccafi_tclMsgSetMicrophoneStateMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetMicrophoneStateMethodResult::operator==(const rvc_ccafi_tclMsgSetMicrophoneStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetRVCStatusMethodStart::rvc_ccafi_tclMsgSetRVCStatusMethodStart(const rvc_ccafi_tclMsgSetRVCStatusMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8RequestState = coRef.e8RequestState;
}
rvc_ccafi_tclMsgSetRVCStatusMethodStart& rvc_ccafi_tclMsgSetRVCStatusMethodStart::operator=(const rvc_ccafi_tclMsgSetRVCStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8RequestState = coRef.e8RequestState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetRVCStatusMethodStart::rvc_ccafi_tclMsgSetRVCStatusMethodStart()
:e8RequestState(0)
 {}

tS32 rvc_ccafi_tclMsgSetRVCStatusMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODSTART;
}


rvc_ccafi_tclMsgSetRVCStatusMethodStart::~rvc_ccafi_tclMsgSetRVCStatusMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetRVCStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetRVCStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RequestState);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetRVCStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RequestState);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetRVCStatusMethodStart::operator==(const rvc_ccafi_tclMsgSetRVCStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RequestState == roRef.e8RequestState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetRVCStatusMethodResult::rvc_ccafi_tclMsgSetRVCStatusMethodResult(const rvc_ccafi_tclMsgSetRVCStatusMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetRVCStatusMethodResult& rvc_ccafi_tclMsgSetRVCStatusMethodResult::operator=(const rvc_ccafi_tclMsgSetRVCStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetRVCStatusMethodResult::rvc_ccafi_tclMsgSetRVCStatusMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetRVCStatusMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETRVCSTATUSMETHODRESULT;
}


rvc_ccafi_tclMsgSetRVCStatusMethodResult::~rvc_ccafi_tclMsgSetRVCStatusMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetRVCStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetRVCStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetRVCStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetRVCStatusMethodResult::operator==(const rvc_ccafi_tclMsgSetRVCStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::rvc_ccafi_tclMsgCamera_SetupBeepMethodStart(const rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8SetupBeep = coRef.e8SetupBeep;
}
rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::operator=(const rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SetupBeep = coRef.e8SetupBeep;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::rvc_ccafi_tclMsgCamera_SetupBeepMethodStart()
:e8SetupBeep()
 {}

tS32 rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODSTART;
}


rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::~rvc_ccafi_tclMsgCamera_SetupBeepMethodStart()
{}

tU32 rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SetupBeep);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SetupBeep);
   return oOut;
}

tBool rvc_ccafi_tclMsgCamera_SetupBeepMethodStart::operator==(const rvc_ccafi_tclMsgCamera_SetupBeepMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SetupBeep == roRef.e8SetupBeep);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::rvc_ccafi_tclMsgCamera_SetupBeepMethodResult(const rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8StatusBeep = coRef.e8StatusBeep;
}
rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::operator=(const rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8StatusBeep = coRef.e8StatusBeep;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::rvc_ccafi_tclMsgCamera_SetupBeepMethodResult()
:e8StatusBeep()
 {}

tS32 rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERA_SETUPBEEPMETHODRESULT;
}


rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::~rvc_ccafi_tclMsgCamera_SetupBeepMethodResult()
{}

tU32 rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8StatusBeep);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8StatusBeep);
   return oOut;
}

tBool rvc_ccafi_tclMsgCamera_SetupBeepMethodResult::operator==(const rvc_ccafi_tclMsgCamera_SetupBeepMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8StatusBeep == roRef.e8StatusBeep);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetCamerastateMethodStart::rvc_ccafi_tclMsgSetCamerastateMethodStart(const rvc_ccafi_tclMsgSetCamerastateMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   CameraState = coRef.CameraState;
}
rvc_ccafi_tclMsgSetCamerastateMethodStart& rvc_ccafi_tclMsgSetCamerastateMethodStart::operator=(const rvc_ccafi_tclMsgSetCamerastateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   CameraState = coRef.CameraState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetCamerastateMethodStart::rvc_ccafi_tclMsgSetCamerastateMethodStart()
:CameraState()
 {}

tS32 rvc_ccafi_tclMsgSetCamerastateMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODSTART;
}


rvc_ccafi_tclMsgSetCamerastateMethodStart::~rvc_ccafi_tclMsgSetCamerastateMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetCamerastateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetCamerastateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CameraState);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetCamerastateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CameraState);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetCamerastateMethodStart::operator==(const rvc_ccafi_tclMsgSetCamerastateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CameraState == roRef.CameraState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetCamerastateMethodResult::rvc_ccafi_tclMsgSetCamerastateMethodResult(const rvc_ccafi_tclMsgSetCamerastateMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetCamerastateMethodResult& rvc_ccafi_tclMsgSetCamerastateMethodResult::operator=(const rvc_ccafi_tclMsgSetCamerastateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetCamerastateMethodResult::rvc_ccafi_tclMsgSetCamerastateMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetCamerastateMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETCAMERASTATEMETHODRESULT;
}


rvc_ccafi_tclMsgSetCamerastateMethodResult::~rvc_ccafi_tclMsgSetCamerastateMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetCamerastateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetCamerastateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetCamerastateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetCamerastateMethodResult::operator==(const rvc_ccafi_tclMsgSetCamerastateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgChangeViewRequestMethodStart::rvc_ccafi_tclMsgChangeViewRequestMethodStart(const rvc_ccafi_tclMsgChangeViewRequestMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   u8Status = coRef.u8Status;
}
rvc_ccafi_tclMsgChangeViewRequestMethodStart& rvc_ccafi_tclMsgChangeViewRequestMethodStart::operator=(const rvc_ccafi_tclMsgChangeViewRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Status = coRef.u8Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgChangeViewRequestMethodStart::rvc_ccafi_tclMsgChangeViewRequestMethodStart()
:u8Status()
 {}

tS32 rvc_ccafi_tclMsgChangeViewRequestMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODSTART;
}


rvc_ccafi_tclMsgChangeViewRequestMethodStart::~rvc_ccafi_tclMsgChangeViewRequestMethodStart()
{}

tU32 rvc_ccafi_tclMsgChangeViewRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgChangeViewRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Status);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgChangeViewRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Status);
   return oOut;
}

tBool rvc_ccafi_tclMsgChangeViewRequestMethodStart::operator==(const rvc_ccafi_tclMsgChangeViewRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Status == roRef.u8Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgChangeViewRequestMethodResult::rvc_ccafi_tclMsgChangeViewRequestMethodResult(const rvc_ccafi_tclMsgChangeViewRequestMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgChangeViewRequestMethodResult& rvc_ccafi_tclMsgChangeViewRequestMethodResult::operator=(const rvc_ccafi_tclMsgChangeViewRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgChangeViewRequestMethodResult::rvc_ccafi_tclMsgChangeViewRequestMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgChangeViewRequestMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CHANGEVIEWREQUESTMETHODRESULT;
}


rvc_ccafi_tclMsgChangeViewRequestMethodResult::~rvc_ccafi_tclMsgChangeViewRequestMethodResult()
{}

tU32 rvc_ccafi_tclMsgChangeViewRequestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgChangeViewRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgChangeViewRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgChangeViewRequestMethodResult::operator==(const rvc_ccafi_tclMsgChangeViewRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   u8Status = coRef.u8Status;
}
rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Status = coRef.u8Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart()
:u8Status(0)
 {}

tS32 rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODSTART;
}


rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::~rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart()
{}

tU32 rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Status);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Status);
   return oOut;
}

tBool rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart::operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Status == roRef.u8Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPBSWMETHODRESULT;
}


rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::~rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult()
{}

tU32 rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult::operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupBswMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   u8Status = coRef.u8Status;
}
rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Status = coRef.u8Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart()
:u8Status(0)
 {}

tS32 rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODSTART;
}


rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::~rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart()
{}

tU32 rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Status);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Status);
   return oOut;
}

tBool rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart::operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Status == roRef.u8Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPMODMETHODRESULT;
}


rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::~rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult()
{}

tU32 rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult::operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupModMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   u8Status = coRef.u8Status;
}
rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8Status = coRef.u8Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart()
:u8Status(0)
 {}

tS32 rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODSTART;
}


rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::~rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart()
{}

tU32 rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Status);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Status);
   return oOut;
}

tBool rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart::operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Status == roRef.u8Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::operator=(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITS_SETUPLDWMETHODRESULT;
}


rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::~rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult()
{}

tU32 rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult::operator==(const rvc_ccafi_tclMsgAffordable_Its_SetupLdwMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8IPAStatus = coRef.e8IPAStatus;
}
rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::operator=(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8IPAStatus = coRef.e8IPAStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart()
:e8IPAStatus()
 {}

tS32 rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODSTART;
}


rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::~rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart()
{}

tU32 rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8IPAStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8IPAStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart::operator==(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8IPAStatus == roRef.e8IPAStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::operator=(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPA_SETHMISTATUSMETHODRESULT;
}


rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::~rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult()
{}

tU32 rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult::operator==(const rvc_ccafi_tclMsgIPA_SetHMIStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPA_SetButtonMethodStart::rvc_ccafi_tclMsgIPA_SetButtonMethodStart(const rvc_ccafi_tclMsgIPA_SetButtonMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8ButtonIdentifier = coRef.e8ButtonIdentifier;
   e8ButtonStatus = coRef.e8ButtonStatus;
}
rvc_ccafi_tclMsgIPA_SetButtonMethodStart& rvc_ccafi_tclMsgIPA_SetButtonMethodStart::operator=(const rvc_ccafi_tclMsgIPA_SetButtonMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ButtonIdentifier = coRef.e8ButtonIdentifier;
   e8ButtonStatus = coRef.e8ButtonStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPA_SetButtonMethodStart::rvc_ccafi_tclMsgIPA_SetButtonMethodStart()
:e8ButtonIdentifier()
,e8ButtonStatus()
 {}

tS32 rvc_ccafi_tclMsgIPA_SetButtonMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODSTART;
}


rvc_ccafi_tclMsgIPA_SetButtonMethodStart::~rvc_ccafi_tclMsgIPA_SetButtonMethodStart()
{}

tU32 rvc_ccafi_tclMsgIPA_SetButtonMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_ccafi_tclMsgIPA_SetButtonMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ButtonIdentifier);
   (tVoid) (oIn >> e8ButtonStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPA_SetButtonMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ButtonIdentifier);
   (tVoid) (oOut << e8ButtonStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPA_SetButtonMethodStart::operator==(const rvc_ccafi_tclMsgIPA_SetButtonMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ButtonIdentifier == roRef.e8ButtonIdentifier);
   bResult = bResult && (e8ButtonStatus == roRef.e8ButtonStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPA_SetButtonMethodResult::rvc_ccafi_tclMsgIPA_SetButtonMethodResult(const rvc_ccafi_tclMsgIPA_SetButtonMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgIPA_SetButtonMethodResult& rvc_ccafi_tclMsgIPA_SetButtonMethodResult::operator=(const rvc_ccafi_tclMsgIPA_SetButtonMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPA_SetButtonMethodResult::rvc_ccafi_tclMsgIPA_SetButtonMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgIPA_SetButtonMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPA_SETBUTTONMETHODRESULT;
}


rvc_ccafi_tclMsgIPA_SetButtonMethodResult::~rvc_ccafi_tclMsgIPA_SetButtonMethodResult()
{}

tU32 rvc_ccafi_tclMsgIPA_SetButtonMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPA_SetButtonMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPA_SetButtonMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPA_SetButtonMethodResult::operator==(const rvc_ccafi_tclMsgIPA_SetButtonMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   arTexts = coRef.arTexts;
   Language = coRef.Language;
}
rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::operator=(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& coRef)
{
   if (this == &coRef) return *this;
   arTexts = coRef.arTexts;
   Language = coRef.Language;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arTexts.size(); ++u32Idx)
         arTexts[u32Idx].vDestroy();
   arTexts.clear();
   }
}

rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart()

:Language()
 {}

tS32 rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODSTART;
}


rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::~rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < arTexts.size(); ++u32ListIdx)
      u32DynamicSize += arTexts[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arTexts.size(); ++u32Idx)
      {
         arTexts[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arTexts.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arTexts[u32Idx]);
      }
   }
   (tVoid) (oIn >> Language);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arTexts.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arTexts.size(); ++u32Idx)
         (tVoid) (oOut << arTexts[u32Idx]);
   }
   (tVoid) (oOut << Language);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart::operator==(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arTexts.size() == roRef.arTexts.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arTexts.size()); ++u32Idx)
            bResult = bResult && (arTexts[u32Idx] == roRef.arTexts[u32Idx]);
      }
   bResult = bResult && (Language == roRef.Language);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::operator=(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPA_VOICE_TEXTSMETHODRESULT;
}


rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::~rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult()
{}

tU32 rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult::operator==(const rvc_ccafi_tclMsgIPA_Voice_TextsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Request = coRef.e8Request;
}
rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::operator=(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Request = coRef.e8Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart()
:e8Request()
 {}

tS32 rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODSTART;
}


rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::~rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart()
{}

tU32 rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Request);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Request);
   return oOut;
}

tBool rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart::operator==(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Request == roRef.e8Request);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::operator=(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVC_HMI_VIEWREQUESTMETHODRESULT;
}


rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::~rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult()
{}

tU32 rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult::operator==(const rvc_ccafi_tclMsgMVC_HMI_ViewRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Completion = coRef.e8Completion;
}
rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Completion = coRef.e8Completion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart()
:e8Completion()
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODSTART;
}


rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::~rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart()
{}

tU32 rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Completion);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Completion);
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart::operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Completion == roRef.e8Completion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTMENTCOMPLETEMETHODRESULT;
}


rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::~rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult()
{}

tU32 rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult::operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustmentCompleteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Button = coRef.e8Button;
}
rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Button = coRef.e8Button;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart()
:e8Button()
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODSTART;
}


rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::~rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart()
{}

tU32 rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Button);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Button);
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart::operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Button == roRef.e8Button);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::operator=(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_ADJUSTBUTTONMETHODRESULT;
}


rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::~rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult()
{}

tU32 rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult::operator==(const rvc_ccafi_tclMsgGdlAdj_AdjustButtonMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Request = coRef.e8Request;
   arConfigParameterData = coRef.arConfigParameterData;
}
rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::operator=(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Request = coRef.e8Request;
   arConfigParameterData = coRef.arConfigParameterData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arConfigParameterData.size(); ++u32Idx)
         arConfigParameterData[u32Idx].vDestroy();
   arConfigParameterData.clear();
   }
}

rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart()
:e8Request()

 {}

tS32 rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODSTART;
}


rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::~rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(arConfigParameterData.size()*9);
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Request);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arConfigParameterData.size(); ++u32Idx)
      {
         arConfigParameterData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arConfigParameterData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arConfigParameterData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Request);
   (tVoid) (oOut << (tU32)arConfigParameterData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arConfigParameterData.size(); ++u32Idx)
         (tVoid) (oOut << arConfigParameterData[u32Idx]);
   }
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart::operator==(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Request == roRef.e8Request);
      bResult = bResult && (arConfigParameterData.size() == roRef.arConfigParameterData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arConfigParameterData.size()); ++u32Idx)
            bResult = bResult && (arConfigParameterData[u32Idx] == roRef.arConfigParameterData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
   e8Request = coRef.e8Request;
   arConfigParameterData = coRef.arConfigParameterData;
}
rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::operator=(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   e8Request = coRef.e8Request;
   arConfigParameterData = coRef.arConfigParameterData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arConfigParameterData.size(); ++u32Idx)
         arConfigParameterData[u32Idx].vDestroy();
   arConfigParameterData.clear();
   }
}

rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult()
:Result(0)
,e8Request()

 {}

tS32 rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_CONFIGURATIONDATAMETHODRESULT;
}


rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::~rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(arConfigParameterData.size()*9);
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   (tVoid) (oIn >> e8Request);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arConfigParameterData.size(); ++u32Idx)
      {
         arConfigParameterData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arConfigParameterData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arConfigParameterData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   (tVoid) (oOut << e8Request);
   (tVoid) (oOut << (tU32)arConfigParameterData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arConfigParameterData.size(); ++u32Idx)
         (tVoid) (oOut << arConfigParameterData[u32Idx]);
   }
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult::operator==(const rvc_ccafi_tclMsgGdlAdj_ConfigurationDataMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   bResult = bResult && (e8Request == roRef.e8Request);
      bResult = bResult && (arConfigParameterData.size() == roRef.arConfigParameterData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arConfigParameterData.size()); ++u32Idx)
            bResult = bResult && (arConfigParameterData[u32Idx] == roRef.arConfigParameterData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgFAP_SetButtonMethodStart::rvc_ccafi_tclMsgFAP_SetButtonMethodStart(const rvc_ccafi_tclMsgFAP_SetButtonMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8ButtonIdentifier = coRef.e8ButtonIdentifier;
   e8ButtonStatus = coRef.e8ButtonStatus;
}
rvc_ccafi_tclMsgFAP_SetButtonMethodStart& rvc_ccafi_tclMsgFAP_SetButtonMethodStart::operator=(const rvc_ccafi_tclMsgFAP_SetButtonMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8ButtonIdentifier = coRef.e8ButtonIdentifier;
   e8ButtonStatus = coRef.e8ButtonStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgFAP_SetButtonMethodStart::rvc_ccafi_tclMsgFAP_SetButtonMethodStart()
:e8ButtonIdentifier()
,e8ButtonStatus()
 {}

tS32 rvc_ccafi_tclMsgFAP_SetButtonMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODSTART;
}


rvc_ccafi_tclMsgFAP_SetButtonMethodStart::~rvc_ccafi_tclMsgFAP_SetButtonMethodStart()
{}

tU32 rvc_ccafi_tclMsgFAP_SetButtonMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_ccafi_tclMsgFAP_SetButtonMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ButtonIdentifier);
   (tVoid) (oIn >> e8ButtonStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgFAP_SetButtonMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ButtonIdentifier);
   (tVoid) (oOut << e8ButtonStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgFAP_SetButtonMethodStart::operator==(const rvc_ccafi_tclMsgFAP_SetButtonMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ButtonIdentifier == roRef.e8ButtonIdentifier);
   bResult = bResult && (e8ButtonStatus == roRef.e8ButtonStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgFAP_SetButtonMethodResult::rvc_ccafi_tclMsgFAP_SetButtonMethodResult(const rvc_ccafi_tclMsgFAP_SetButtonMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgFAP_SetButtonMethodResult& rvc_ccafi_tclMsgFAP_SetButtonMethodResult::operator=(const rvc_ccafi_tclMsgFAP_SetButtonMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgFAP_SetButtonMethodResult::rvc_ccafi_tclMsgFAP_SetButtonMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgFAP_SetButtonMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAP_SETBUTTONMETHODRESULT;
}


rvc_ccafi_tclMsgFAP_SetButtonMethodResult::~rvc_ccafi_tclMsgFAP_SetButtonMethodResult()
{}

tU32 rvc_ccafi_tclMsgFAP_SetButtonMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgFAP_SetButtonMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgFAP_SetButtonMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgFAP_SetButtonMethodResult::operator==(const rvc_ccafi_tclMsgFAP_SetButtonMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgTouchEventMethodStart::rvc_ccafi_tclMsgTouchEventMethodStart(const rvc_ccafi_tclMsgTouchEventMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   arTouchData = coRef.arTouchData;
}
rvc_ccafi_tclMsgTouchEventMethodStart& rvc_ccafi_tclMsgTouchEventMethodStart::operator=(const rvc_ccafi_tclMsgTouchEventMethodStart& coRef)
{
   if (this == &coRef) return *this;
   arTouchData = coRef.arTouchData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgTouchEventMethodStart::rvc_ccafi_tclMsgTouchEventMethodStart()
:arTouchData()
 {}

tS32 rvc_ccafi_tclMsgTouchEventMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODSTART;
}


rvc_ccafi_tclMsgTouchEventMethodStart::~rvc_ccafi_tclMsgTouchEventMethodStart()
{}

tU32 rvc_ccafi_tclMsgTouchEventMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& rvc_ccafi_tclMsgTouchEventMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> arTouchData);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgTouchEventMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << arTouchData);
   return oOut;
}

tBool rvc_ccafi_tclMsgTouchEventMethodStart::operator==(const rvc_ccafi_tclMsgTouchEventMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (arTouchData == roRef.arTouchData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgTouchEventMethodResult::rvc_ccafi_tclMsgTouchEventMethodResult(const rvc_ccafi_tclMsgTouchEventMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgTouchEventMethodResult& rvc_ccafi_tclMsgTouchEventMethodResult::operator=(const rvc_ccafi_tclMsgTouchEventMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgTouchEventMethodResult::rvc_ccafi_tclMsgTouchEventMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgTouchEventMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TOUCHEVENTMETHODRESULT;
}


rvc_ccafi_tclMsgTouchEventMethodResult::~rvc_ccafi_tclMsgTouchEventMethodResult()
{}

tU32 rvc_ccafi_tclMsgTouchEventMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgTouchEventMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgTouchEventMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgTouchEventMethodResult::operator==(const rvc_ccafi_tclMsgTouchEventMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGPSInfoMethodStart::rvc_ccafi_tclMsgGPSInfoMethodStart(const rvc_ccafi_tclMsgGPSInfoMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   arGpsData = coRef.arGpsData;
}
rvc_ccafi_tclMsgGPSInfoMethodStart& rvc_ccafi_tclMsgGPSInfoMethodStart::operator=(const rvc_ccafi_tclMsgGPSInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   arGpsData = coRef.arGpsData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgGPSInfoMethodStart::rvc_ccafi_tclMsgGPSInfoMethodStart()
:arGpsData()
 {}

tS32 rvc_ccafi_tclMsgGPSInfoMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODSTART;
}


rvc_ccafi_tclMsgGPSInfoMethodStart::~rvc_ccafi_tclMsgGPSInfoMethodStart()
{}

tU32 rvc_ccafi_tclMsgGPSInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 32;
}

fi_tclInContext& rvc_ccafi_tclMsgGPSInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> arGpsData);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGPSInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << arGpsData);
   return oOut;
}

tBool rvc_ccafi_tclMsgGPSInfoMethodStart::operator==(const rvc_ccafi_tclMsgGPSInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (arGpsData == roRef.arGpsData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGPSInfoMethodResult::rvc_ccafi_tclMsgGPSInfoMethodResult(const rvc_ccafi_tclMsgGPSInfoMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgGPSInfoMethodResult& rvc_ccafi_tclMsgGPSInfoMethodResult::operator=(const rvc_ccafi_tclMsgGPSInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgGPSInfoMethodResult::rvc_ccafi_tclMsgGPSInfoMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgGPSInfoMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GPSINFOMETHODRESULT;
}


rvc_ccafi_tclMsgGPSInfoMethodResult::~rvc_ccafi_tclMsgGPSInfoMethodResult()
{}

tU32 rvc_ccafi_tclMsgGPSInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgGPSInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGPSInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgGPSInfoMethodResult::operator==(const rvc_ccafi_tclMsgGPSInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgMapMatchedInfoMethodStart::rvc_ccafi_tclMsgMapMatchedInfoMethodStart(const rvc_ccafi_tclMsgMapMatchedInfoMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   arMapMatchedData = coRef.arMapMatchedData;
}
rvc_ccafi_tclMsgMapMatchedInfoMethodStart& rvc_ccafi_tclMsgMapMatchedInfoMethodStart::operator=(const rvc_ccafi_tclMsgMapMatchedInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   arMapMatchedData = coRef.arMapMatchedData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgMapMatchedInfoMethodStart::rvc_ccafi_tclMsgMapMatchedInfoMethodStart()
:arMapMatchedData()
 {}

tS32 rvc_ccafi_tclMsgMapMatchedInfoMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODSTART;
}


rvc_ccafi_tclMsgMapMatchedInfoMethodStart::~rvc_ccafi_tclMsgMapMatchedInfoMethodStart()
{}

tU32 rvc_ccafi_tclMsgMapMatchedInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& rvc_ccafi_tclMsgMapMatchedInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> arMapMatchedData);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgMapMatchedInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << arMapMatchedData);
   return oOut;
}

tBool rvc_ccafi_tclMsgMapMatchedInfoMethodStart::operator==(const rvc_ccafi_tclMsgMapMatchedInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (arMapMatchedData == roRef.arMapMatchedData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgMapMatchedInfoMethodResult::rvc_ccafi_tclMsgMapMatchedInfoMethodResult(const rvc_ccafi_tclMsgMapMatchedInfoMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgMapMatchedInfoMethodResult& rvc_ccafi_tclMsgMapMatchedInfoMethodResult::operator=(const rvc_ccafi_tclMsgMapMatchedInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgMapMatchedInfoMethodResult::rvc_ccafi_tclMsgMapMatchedInfoMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgMapMatchedInfoMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MAPMATCHEDINFOMETHODRESULT;
}


rvc_ccafi_tclMsgMapMatchedInfoMethodResult::~rvc_ccafi_tclMsgMapMatchedInfoMethodResult()
{}

tU32 rvc_ccafi_tclMsgMapMatchedInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgMapMatchedInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgMapMatchedInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgMapMatchedInfoMethodResult::operator==(const rvc_ccafi_tclMsgMapMatchedInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::rvc_ccafi_tclMsgFapLearnParkPositionMethodStart(const rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   RequestOn = coRef.RequestOn;
}
rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::operator=(const rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RequestOn = coRef.RequestOn;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::rvc_ccafi_tclMsgFapLearnParkPositionMethodStart()
:RequestOn(0)
 {}

tS32 rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODSTART;
}


rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::~rvc_ccafi_tclMsgFapLearnParkPositionMethodStart()
{}

tU32 rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestOn);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestOn);
   return oOut;
}

tBool rvc_ccafi_tclMsgFapLearnParkPositionMethodStart::operator==(const rvc_ccafi_tclMsgFapLearnParkPositionMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestOn == roRef.RequestOn);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::rvc_ccafi_tclMsgFapLearnParkPositionMethodResult(const rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::operator=(const rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::rvc_ccafi_tclMsgFapLearnParkPositionMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPLEARNPARKPOSITIONMETHODRESULT;
}


rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::~rvc_ccafi_tclMsgFapLearnParkPositionMethodResult()
{}

tU32 rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgFapLearnParkPositionMethodResult::operator==(const rvc_ccafi_tclMsgFapLearnParkPositionMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetFapGuidanceMethodStart::rvc_ccafi_tclMsgSetFapGuidanceMethodStart(const rvc_ccafi_tclMsgSetFapGuidanceMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Request = coRef.Request;
}
rvc_ccafi_tclMsgSetFapGuidanceMethodStart& rvc_ccafi_tclMsgSetFapGuidanceMethodStart::operator=(const rvc_ccafi_tclMsgSetFapGuidanceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Request = coRef.Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetFapGuidanceMethodStart::rvc_ccafi_tclMsgSetFapGuidanceMethodStart()
:Request(0)
 {}

tS32 rvc_ccafi_tclMsgSetFapGuidanceMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODSTART;
}


rvc_ccafi_tclMsgSetFapGuidanceMethodStart::~rvc_ccafi_tclMsgSetFapGuidanceMethodStart()
{}

tU32 rvc_ccafi_tclMsgSetFapGuidanceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetFapGuidanceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Request);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetFapGuidanceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Request);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetFapGuidanceMethodStart::operator==(const rvc_ccafi_tclMsgSetFapGuidanceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Request == roRef.Request);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSetFapGuidanceMethodResult::rvc_ccafi_tclMsgSetFapGuidanceMethodResult(const rvc_ccafi_tclMsgSetFapGuidanceMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   Result = coRef.Result;
}
rvc_ccafi_tclMsgSetFapGuidanceMethodResult& rvc_ccafi_tclMsgSetFapGuidanceMethodResult::operator=(const rvc_ccafi_tclMsgSetFapGuidanceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSetFapGuidanceMethodResult::rvc_ccafi_tclMsgSetFapGuidanceMethodResult()
:Result(0)
 {}

tS32 rvc_ccafi_tclMsgSetFapGuidanceMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SETFAPGUIDANCEMETHODRESULT;
}


rvc_ccafi_tclMsgSetFapGuidanceMethodResult::~rvc_ccafi_tclMsgSetFapGuidanceMethodResult()
{}

tU32 rvc_ccafi_tclMsgSetFapGuidanceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSetFapGuidanceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSetFapGuidanceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Result);
   return oOut;
}

tBool rvc_ccafi_tclMsgSetFapGuidanceMethodResult::operator==(const rvc_ccafi_tclMsgSetFapGuidanceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8SwitchId = coRef.e8SwitchId;
}
rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::operator=(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8SwitchId = coRef.e8SwitchId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart()
:e8SwitchId()
 {}

tS32 rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODSTART;
}


rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::~rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart()
{}

tU32 rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SwitchId);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SwitchId);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart::operator==(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SwitchId == roRef.e8SwitchId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::operator=(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult()
:bResult(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETSWITCHMETHODRESULT;
}


rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::~rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult()
{}

tU32 rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult::operator==(const rvc_ccafi_tclMsgAVM3_SetSwitchMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8BuzzerStatus = coRef.e8BuzzerStatus;
}
rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::operator=(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8BuzzerStatus = coRef.e8BuzzerStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart()
:e8BuzzerStatus()
 {}

tS32 rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODSTART;
}


rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::~rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart()
{}

tU32 rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8BuzzerStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8BuzzerStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart::operator==(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8BuzzerStatus == roRef.e8BuzzerStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::operator=(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult()
:bResult(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETSONARBUZZERSTATUSMETHODRESULT;
}


rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::~rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult()
{}

tU32 rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult::operator==(const rvc_ccafi_tclMsgAVM3_SetSonarBuzzerStatusMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8RequestType = coRef.e8RequestType;
   arChangedItems = coRef.arChangedItems;
}
rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::operator=(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8RequestType = coRef.e8RequestType;
   arChangedItems = coRef.arChangedItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arChangedItems.size(); ++u32Idx)
         arChangedItems[u32Idx].vDestroy();
   arChangedItems.clear();
   }
}

rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart()
:e8RequestType()

 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODSTART;
}


rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::~rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(arChangedItems.size()*2);
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RequestType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arChangedItems.size(); ++u32Idx)
      {
         arChangedItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arChangedItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arChangedItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RequestType);
   (tVoid) (oOut << (tU32)arChangedItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arChangedItems.size(); ++u32Idx)
         (tVoid) (oOut << arChangedItems[u32Idx]);
   }
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart::operator==(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RequestType == roRef.e8RequestType);
      bResult = bResult && (arChangedItems.size() == roRef.arChangedItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arChangedItems.size()); ++u32Idx)
            bResult = bResult && (arChangedItems[u32Idx] == roRef.arChangedItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::operator=(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult()
:bResult(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILED_SENDREQMETHODRESULT;
}


rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::~rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult()
{}

tU32 rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult::operator==(const rvc_ccafi_tclMsgAVM3_Settings_Detailed_SendReqMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8RequestType = coRef.e8RequestType;
   e8AvmSonarBuzzer = coRef.e8AvmSonarBuzzer;
   bDetailsSettingsAvail = coRef.bDetailsSettingsAvail;
   bImageQualitySettingAvail = coRef.bImageQualitySettingAvail;
}
rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::operator=(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8RequestType = coRef.e8RequestType;
   e8AvmSonarBuzzer = coRef.e8AvmSonarBuzzer;
   bDetailsSettingsAvail = coRef.bDetailsSettingsAvail;
   bImageQualitySettingAvail = coRef.bImageQualitySettingAvail;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart()
:e8RequestType()
,e8AvmSonarBuzzer()
,bDetailsSettingsAvail(0)
,bImageQualitySettingAvail(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODSTART;
}


rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::~rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart()
{}

tU32 rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RequestType);
   (tVoid) (oIn >> e8AvmSonarBuzzer);
   (tVoid) (oIn >> bDetailsSettingsAvail);
   (tVoid) (oIn >> bImageQualitySettingAvail);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RequestType);
   (tVoid) (oOut << e8AvmSonarBuzzer);
   (tVoid) (oOut << bDetailsSettingsAvail);
   (tVoid) (oOut << bImageQualitySettingAvail);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart::operator==(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RequestType == roRef.e8RequestType);
   bResult = bResult && (e8AvmSonarBuzzer == roRef.e8AvmSonarBuzzer);
   bResult = bResult && (bDetailsSettingsAvail == roRef.bDetailsSettingsAvail);
   bResult = bResult && (bImageQualitySettingAvail == roRef.bImageQualitySettingAvail);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::operator=(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult()
:bResult(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARY_SENDREQMETHODRESULT;
}


rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::~rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult()
{}

tU32 rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult::operator==(const rvc_ccafi_tclMsgAVM3_Settings_Primary_SendReqMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8VersionType = coRef.e8VersionType;
}
rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::operator=(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8VersionType = coRef.e8VersionType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart()
:e8VersionType()
 {}

tS32 rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODSTART;
}


rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::~rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart()
{}

tU32 rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8VersionType);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8VersionType);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart::operator==(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8VersionType == roRef.e8VersionType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::operator=(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult()
:bResult(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_GETVERSIONINFOMETHODRESULT;
}


rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::~rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult()
{}

tU32 rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult::operator==(const rvc_ccafi_tclMsgAVM3_GetVersionInfoMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart::rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart()
 {}

tS32 rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODSTART;
}


rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart::~rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult(const rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::operator=(const rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult()
:bResult(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_GETCOMMUNICATIONERRORSMETHODRESULT;
}


rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::~rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult()
{}

tU32 rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult::operator==(const rvc_ccafi_tclMsgAVM3_GetCommunicationErrorsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart::rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODSTART;
}


rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart::~rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult(const rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bResult = coRef.bResult;
}
rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::operator=(const rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bResult = coRef.bResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult()
:bResult(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_CLEARCOMMUNICATIONERRORSMETHODRESULT;
}


rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::~rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult()
{}

tU32 rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bResult);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bResult);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult::operator==(const rvc_ccafi_tclMsgAVM3_ClearCommunicationErrorsMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bResult == roRef.bResult);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart::rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart()
 {}

tS32 rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODSTART;
}


rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart::~rvc_ccafi_tclMsgToggleGpioPinOnOffMethodStart()
{}

//=============================================================================

rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult::rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult()
 {}

tS32 rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TOGGLEGPIOPINONOFFMETHODRESULT;
}


rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult::~rvc_ccafi_tclMsgToggleGpioPinOnOffMethodResult()
{}

//=============================================================================

rvc_ccafi_tclMsgSystemConfigurationsUpReg::rvc_ccafi_tclMsgSystemConfigurationsUpReg()
 {}

tS32 rvc_ccafi_tclMsgSystemConfigurationsUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSUPREG;
}


rvc_ccafi_tclMsgSystemConfigurationsUpReg::~rvc_ccafi_tclMsgSystemConfigurationsUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgSystemConfigurationsRelUpReg::rvc_ccafi_tclMsgSystemConfigurationsRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgSystemConfigurationsRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSRELUPREG;
}


rvc_ccafi_tclMsgSystemConfigurationsRelUpReg::~rvc_ccafi_tclMsgSystemConfigurationsRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSystemConfigurationsStatus::rvc_ccafi_tclMsgSystemConfigurationsStatus(const rvc_ccafi_tclMsgSystemConfigurationsStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8CameraSystem = coRef.e8CameraSystem;
   u8RVCGuideLine = coRef.u8RVCGuideLine;
   u8Brightness = coRef.u8Brightness;
}
rvc_ccafi_tclMsgSystemConfigurationsStatus& rvc_ccafi_tclMsgSystemConfigurationsStatus::operator=(const rvc_ccafi_tclMsgSystemConfigurationsStatus& coRef)
{
   if (this == &coRef) return *this;
   e8CameraSystem = coRef.e8CameraSystem;
   u8RVCGuideLine = coRef.u8RVCGuideLine;
   u8Brightness = coRef.u8Brightness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSystemConfigurationsStatus::rvc_ccafi_tclMsgSystemConfigurationsStatus()
:e8CameraSystem()
,u8RVCGuideLine(0)
,u8Brightness(0)
 {}

tS32 rvc_ccafi_tclMsgSystemConfigurationsStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SYSTEMCONFIGURATIONSSTATUS;
}


rvc_ccafi_tclMsgSystemConfigurationsStatus::~rvc_ccafi_tclMsgSystemConfigurationsStatus()
{}

tU32 rvc_ccafi_tclMsgSystemConfigurationsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& rvc_ccafi_tclMsgSystemConfigurationsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CameraSystem);
   (tVoid) (oIn >> u8RVCGuideLine);
   (tVoid) (oIn >> u8Brightness);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSystemConfigurationsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CameraSystem);
   (tVoid) (oOut << u8RVCGuideLine);
   (tVoid) (oOut << u8Brightness);
   return oOut;
}

tBool rvc_ccafi_tclMsgSystemConfigurationsStatus::operator==(const rvc_ccafi_tclMsgSystemConfigurationsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CameraSystem == roRef.e8CameraSystem);
   bResult = bResult && (u8RVCGuideLine == roRef.u8RVCGuideLine);
   bResult = bResult && (u8Brightness == roRef.u8Brightness);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgSystemStatusUpReg::rvc_ccafi_tclMsgSystemStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgSystemStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSUPREG;
}


rvc_ccafi_tclMsgSystemStatusUpReg::~rvc_ccafi_tclMsgSystemStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgSystemStatusRelUpReg::rvc_ccafi_tclMsgSystemStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgSystemStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSRELUPREG;
}


rvc_ccafi_tclMsgSystemStatusRelUpReg::~rvc_ccafi_tclMsgSystemStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgSystemStatusStatus::rvc_ccafi_tclMsgSystemStatusStatus(const rvc_ccafi_tclMsgSystemStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8SystemStatus = coRef.e8SystemStatus;
}
rvc_ccafi_tclMsgSystemStatusStatus& rvc_ccafi_tclMsgSystemStatusStatus::operator=(const rvc_ccafi_tclMsgSystemStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8SystemStatus = coRef.e8SystemStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgSystemStatusStatus::rvc_ccafi_tclMsgSystemStatusStatus()
:e8SystemStatus()
 {}

tS32 rvc_ccafi_tclMsgSystemStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_SYSTEMSTATUSSTATUS;
}


rvc_ccafi_tclMsgSystemStatusStatus::~rvc_ccafi_tclMsgSystemStatusStatus()
{}

tU32 rvc_ccafi_tclMsgSystemStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgSystemStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SystemStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgSystemStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SystemStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgSystemStatusStatus::operator==(const rvc_ccafi_tclMsgSystemStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SystemStatus == roRef.e8SystemStatus);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgVideoSignalStatusUpReg::rvc_ccafi_tclMsgVideoSignalStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgVideoSignalStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSUPREG;
}


rvc_ccafi_tclMsgVideoSignalStatusUpReg::~rvc_ccafi_tclMsgVideoSignalStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgVideoSignalStatusRelUpReg::rvc_ccafi_tclMsgVideoSignalStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgVideoSignalStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSRELUPREG;
}


rvc_ccafi_tclMsgVideoSignalStatusRelUpReg::~rvc_ccafi_tclMsgVideoSignalStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgVideoSignalStatusStatus::rvc_ccafi_tclMsgVideoSignalStatusStatus(const rvc_ccafi_tclMsgVideoSignalStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8StatusVideoSignal = coRef.e8StatusVideoSignal;
}
rvc_ccafi_tclMsgVideoSignalStatusStatus& rvc_ccafi_tclMsgVideoSignalStatusStatus::operator=(const rvc_ccafi_tclMsgVideoSignalStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8StatusVideoSignal = coRef.e8StatusVideoSignal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgVideoSignalStatusStatus::rvc_ccafi_tclMsgVideoSignalStatusStatus()
:e8StatusVideoSignal()
 {}

tS32 rvc_ccafi_tclMsgVideoSignalStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_VIDEOSIGNALSTATUSSTATUS;
}


rvc_ccafi_tclMsgVideoSignalStatusStatus::~rvc_ccafi_tclMsgVideoSignalStatusStatus()
{}

tU32 rvc_ccafi_tclMsgVideoSignalStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgVideoSignalStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8StatusVideoSignal);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgVideoSignalStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8StatusVideoSignal);
   return oOut;
}

tBool rvc_ccafi_tclMsgVideoSignalStatusStatus::operator==(const rvc_ccafi_tclMsgVideoSignalStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8StatusVideoSignal == roRef.e8StatusVideoSignal);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgReverseSignalStatusUpReg::rvc_ccafi_tclMsgReverseSignalStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgReverseSignalStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSUPREG;
}


rvc_ccafi_tclMsgReverseSignalStatusUpReg::~rvc_ccafi_tclMsgReverseSignalStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgReverseSignalStatusRelUpReg::rvc_ccafi_tclMsgReverseSignalStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgReverseSignalStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSRELUPREG;
}


rvc_ccafi_tclMsgReverseSignalStatusRelUpReg::~rvc_ccafi_tclMsgReverseSignalStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgReverseSignalStatusStatus::rvc_ccafi_tclMsgReverseSignalStatusStatus(const rvc_ccafi_tclMsgReverseSignalStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8StatusReverseSignal = coRef.e8StatusReverseSignal;
}
rvc_ccafi_tclMsgReverseSignalStatusStatus& rvc_ccafi_tclMsgReverseSignalStatusStatus::operator=(const rvc_ccafi_tclMsgReverseSignalStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8StatusReverseSignal = coRef.e8StatusReverseSignal;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgReverseSignalStatusStatus::rvc_ccafi_tclMsgReverseSignalStatusStatus()
:e8StatusReverseSignal()
 {}

tS32 rvc_ccafi_tclMsgReverseSignalStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_REVERSESIGNALSTATUSSTATUS;
}


rvc_ccafi_tclMsgReverseSignalStatusStatus::~rvc_ccafi_tclMsgReverseSignalStatusStatus()
{}

tU32 rvc_ccafi_tclMsgReverseSignalStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgReverseSignalStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8StatusReverseSignal);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgReverseSignalStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8StatusReverseSignal);
   return oOut;
}

tBool rvc_ccafi_tclMsgReverseSignalStatusStatus::operator==(const rvc_ccafi_tclMsgReverseSignalStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8StatusReverseSignal == roRef.e8StatusReverseSignal);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg::rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSUPREG;
}


rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg::~rvc_ccafi_tclMsgCamera_PwrSupplyStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg::rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSRELUPREG;
}


rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg::~rvc_ccafi_tclMsgCamera_PwrSupplyStatusRelUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet::rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet()
 {}

tS32 rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSGET;
}


rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet::~rvc_ccafi_tclMsgCamera_PwrSupplyStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   pwrSupplyID = coRef.pwrSupplyID;
   status = coRef.status;
   current = coRef.current;
}
rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::operator=(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   pwrSupplyID = coRef.pwrSupplyID;
   status = coRef.status;
   current = coRef.current;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus()
:pwrSupplyID(0)
,status()
,current(0)
 {}

tS32 rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CAMERA_PWRSUPPLYSTATUSSTATUS;
}


rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::~rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus()
{}

tU32 rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> pwrSupplyID);
   (tVoid) (oIn >> status);
   (tVoid) (oIn >> current);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << pwrSupplyID);
   (tVoid) (oOut << status);
   (tVoid) (oOut << current);
   return oOut;
}

tBool rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus::operator==(const rvc_ccafi_tclMsgCamera_PwrSupplyStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (pwrSupplyID == roRef.pwrSupplyID);
   bResult = bResult && (status == roRef.status);
   bResult = bResult && (current == roRef.current);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg::rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSUPREG;
}


rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg::~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg::rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSRELUPREG;
}


rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg::~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusRelUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet::rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet()
 {}

tS32 rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSGET;
}


rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet::~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   pwrSupplyID = coRef.pwrSupplyID;
   status = coRef.status;
   current = coRef.current;
}
rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::operator=(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   pwrSupplyID = coRef.pwrSupplyID;
   status = coRef.status;
   current = coRef.current;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus()
:pwrSupplyID(0)
,status()
,current(0)
 {}

tS32 rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MICROPHONE_PWRSUPPLYSTATUSSTATUS;
}


rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::~rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus()
{}

tU32 rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> pwrSupplyID);
   (tVoid) (oIn >> status);
   (tVoid) (oIn >> current);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << pwrSupplyID);
   (tVoid) (oOut << status);
   (tVoid) (oOut << current);
   return oOut;
}

tBool rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus::operator==(const rvc_ccafi_tclMsgMicrophone_PwrSupplyStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (pwrSupplyID == roRef.pwrSupplyID);
   bResult = bResult && (status == roRef.status);
   bResult = bResult && (current == roRef.current);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgTailgate_StatusUpReg::rvc_ccafi_tclMsgTailgate_StatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgTailgate_StatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSUPREG;
}


rvc_ccafi_tclMsgTailgate_StatusUpReg::~rvc_ccafi_tclMsgTailgate_StatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgTailgate_StatusRelUpReg::rvc_ccafi_tclMsgTailgate_StatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgTailgate_StatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSRELUPREG;
}


rvc_ccafi_tclMsgTailgate_StatusRelUpReg::~rvc_ccafi_tclMsgTailgate_StatusRelUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgTailgate_StatusGet::rvc_ccafi_tclMsgTailgate_StatusGet()
 {}

tS32 rvc_ccafi_tclMsgTailgate_StatusGet::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSGET;
}


rvc_ccafi_tclMsgTailgate_StatusGet::~rvc_ccafi_tclMsgTailgate_StatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgTailgate_StatusStatus::rvc_ccafi_tclMsgTailgate_StatusStatus(const rvc_ccafi_tclMsgTailgate_StatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
}
rvc_ccafi_tclMsgTailgate_StatusStatus& rvc_ccafi_tclMsgTailgate_StatusStatus::operator=(const rvc_ccafi_tclMsgTailgate_StatusStatus& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgTailgate_StatusStatus::rvc_ccafi_tclMsgTailgate_StatusStatus()
:State()
 {}

tS32 rvc_ccafi_tclMsgTailgate_StatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_TAILGATE_STATUSSTATUS;
}


rvc_ccafi_tclMsgTailgate_StatusStatus::~rvc_ccafi_tclMsgTailgate_StatusStatus()
{}

tU32 rvc_ccafi_tclMsgTailgate_StatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgTailgate_StatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgTailgate_StatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   return oOut;
}

tBool rvc_ccafi_tclMsgTailgate_StatusStatus::operator==(const rvc_ccafi_tclMsgTailgate_StatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgView_Close_AuthorizedUpReg::rvc_ccafi_tclMsgView_Close_AuthorizedUpReg()
 {}

tS32 rvc_ccafi_tclMsgView_Close_AuthorizedUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDUPREG;
}


rvc_ccafi_tclMsgView_Close_AuthorizedUpReg::~rvc_ccafi_tclMsgView_Close_AuthorizedUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg::rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDRELUPREG;
}


rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg::~rvc_ccafi_tclMsgView_Close_AuthorizedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgView_Close_AuthorizedStatus::rvc_ccafi_tclMsgView_Close_AuthorizedStatus(const rvc_ccafi_tclMsgView_Close_AuthorizedStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Allowed = coRef.e8Allowed;
}
rvc_ccafi_tclMsgView_Close_AuthorizedStatus& rvc_ccafi_tclMsgView_Close_AuthorizedStatus::operator=(const rvc_ccafi_tclMsgView_Close_AuthorizedStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Allowed = coRef.e8Allowed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgView_Close_AuthorizedStatus::rvc_ccafi_tclMsgView_Close_AuthorizedStatus()
:e8Allowed()
 {}

tS32 rvc_ccafi_tclMsgView_Close_AuthorizedStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_VIEW_CLOSE_AUTHORIZEDSTATUS;
}


rvc_ccafi_tclMsgView_Close_AuthorizedStatus::~rvc_ccafi_tclMsgView_Close_AuthorizedStatus()
{}

tU32 rvc_ccafi_tclMsgView_Close_AuthorizedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgView_Close_AuthorizedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Allowed);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgView_Close_AuthorizedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Allowed);
   return oOut;
}

tBool rvc_ccafi_tclMsgView_Close_AuthorizedStatus::operator==(const rvc_ccafi_tclMsgView_Close_AuthorizedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Allowed == roRef.e8Allowed);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAvmR_Current_ViewUpReg::rvc_ccafi_tclMsgAvmR_Current_ViewUpReg()
 {}

tS32 rvc_ccafi_tclMsgAvmR_Current_ViewUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWUPREG;
}


rvc_ccafi_tclMsgAvmR_Current_ViewUpReg::~rvc_ccafi_tclMsgAvmR_Current_ViewUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg::rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWRELUPREG;
}


rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg::~rvc_ccafi_tclMsgAvmR_Current_ViewRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAvmR_Current_ViewStatus::rvc_ccafi_tclMsgAvmR_Current_ViewStatus(const rvc_ccafi_tclMsgAvmR_Current_ViewStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8View = coRef.e8View;
}
rvc_ccafi_tclMsgAvmR_Current_ViewStatus& rvc_ccafi_tclMsgAvmR_Current_ViewStatus::operator=(const rvc_ccafi_tclMsgAvmR_Current_ViewStatus& coRef)
{
   if (this == &coRef) return *this;
   e8View = coRef.e8View;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAvmR_Current_ViewStatus::rvc_ccafi_tclMsgAvmR_Current_ViewStatus()
:e8View()
 {}

tS32 rvc_ccafi_tclMsgAvmR_Current_ViewStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVMR_CURRENT_VIEWSTATUS;
}


rvc_ccafi_tclMsgAvmR_Current_ViewStatus::~rvc_ccafi_tclMsgAvmR_Current_ViewStatus()
{}

tU32 rvc_ccafi_tclMsgAvmR_Current_ViewStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAvmR_Current_ViewStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8View);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAvmR_Current_ViewStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8View);
   return oOut;
}

tBool rvc_ccafi_tclMsgAvmR_Current_ViewStatus::operator==(const rvc_ccafi_tclMsgAvmR_Current_ViewStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8View == roRef.e8View);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAffordable_ITSUpReg::rvc_ccafi_tclMsgAffordable_ITSUpReg()
 {}

tS32 rvc_ccafi_tclMsgAffordable_ITSUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSUPREG;
}


rvc_ccafi_tclMsgAffordable_ITSUpReg::~rvc_ccafi_tclMsgAffordable_ITSUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAffordable_ITSRelUpReg::rvc_ccafi_tclMsgAffordable_ITSRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAffordable_ITSRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSRELUPREG;
}


rvc_ccafi_tclMsgAffordable_ITSRelUpReg::~rvc_ccafi_tclMsgAffordable_ITSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAffordable_ITSStatus::rvc_ccafi_tclMsgAffordable_ITSStatus(const rvc_ccafi_tclMsgAffordable_ITSStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8AffordableItsAvailable = coRef.e8AffordableItsAvailable;
   e8BswStatus = coRef.e8BswStatus;
   e8ModStatus = coRef.e8ModStatus;
   e8LdwStatus = coRef.e8LdwStatus;
}
rvc_ccafi_tclMsgAffordable_ITSStatus& rvc_ccafi_tclMsgAffordable_ITSStatus::operator=(const rvc_ccafi_tclMsgAffordable_ITSStatus& coRef)
{
   if (this == &coRef) return *this;
   e8AffordableItsAvailable = coRef.e8AffordableItsAvailable;
   e8BswStatus = coRef.e8BswStatus;
   e8ModStatus = coRef.e8ModStatus;
   e8LdwStatus = coRef.e8LdwStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAffordable_ITSStatus::rvc_ccafi_tclMsgAffordable_ITSStatus()
:e8AffordableItsAvailable()
,e8BswStatus()
,e8ModStatus()
,e8LdwStatus()
 {}

tS32 rvc_ccafi_tclMsgAffordable_ITSStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AFFORDABLE_ITSSTATUS;
}


rvc_ccafi_tclMsgAffordable_ITSStatus::~rvc_ccafi_tclMsgAffordable_ITSStatus()
{}

tU32 rvc_ccafi_tclMsgAffordable_ITSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_ccafi_tclMsgAffordable_ITSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AffordableItsAvailable);
   (tVoid) (oIn >> e8BswStatus);
   (tVoid) (oIn >> e8ModStatus);
   (tVoid) (oIn >> e8LdwStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAffordable_ITSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AffordableItsAvailable);
   (tVoid) (oOut << e8BswStatus);
   (tVoid) (oOut << e8ModStatus);
   (tVoid) (oOut << e8LdwStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgAffordable_ITSStatus::operator==(const rvc_ccafi_tclMsgAffordable_ITSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AffordableItsAvailable == roRef.e8AffordableItsAvailable);
   bResult = bResult && (e8BswStatus == roRef.e8BswStatus);
   bResult = bResult && (e8ModStatus == roRef.e8ModStatus);
   bResult = bResult && (e8LdwStatus == roRef.e8LdwStatus);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgIPAConfigurationUpReg::rvc_ccafi_tclMsgIPAConfigurationUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAConfigurationUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONUPREG;
}


rvc_ccafi_tclMsgIPAConfigurationUpReg::~rvc_ccafi_tclMsgIPAConfigurationUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgIPAConfigurationRelUpReg::rvc_ccafi_tclMsgIPAConfigurationRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAConfigurationRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONRELUPREG;
}


rvc_ccafi_tclMsgIPAConfigurationRelUpReg::~rvc_ccafi_tclMsgIPAConfigurationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPAConfigurationStatus::rvc_ccafi_tclMsgIPAConfigurationStatus(const rvc_ccafi_tclMsgIPAConfigurationStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8AvailabilityStatus = coRef.e8AvailabilityStatus;
   e8RegionalSelection = coRef.e8RegionalSelection;
}
rvc_ccafi_tclMsgIPAConfigurationStatus& rvc_ccafi_tclMsgIPAConfigurationStatus::operator=(const rvc_ccafi_tclMsgIPAConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8AvailabilityStatus = coRef.e8AvailabilityStatus;
   e8RegionalSelection = coRef.e8RegionalSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPAConfigurationStatus::rvc_ccafi_tclMsgIPAConfigurationStatus()
:e8AvailabilityStatus()
,e8RegionalSelection()
 {}

tS32 rvc_ccafi_tclMsgIPAConfigurationStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPACONFIGURATIONSTATUS;
}


rvc_ccafi_tclMsgIPAConfigurationStatus::~rvc_ccafi_tclMsgIPAConfigurationStatus()
{}

tU32 rvc_ccafi_tclMsgIPAConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_ccafi_tclMsgIPAConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AvailabilityStatus);
   (tVoid) (oIn >> e8RegionalSelection);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPAConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AvailabilityStatus);
   (tVoid) (oOut << e8RegionalSelection);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPAConfigurationStatus::operator==(const rvc_ccafi_tclMsgIPAConfigurationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AvailabilityStatus == roRef.e8AvailabilityStatus);
   bResult = bResult && (e8RegionalSelection == roRef.e8RegionalSelection);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgIPAStatusUpReg::rvc_ccafi_tclMsgIPAStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASTATUSUPREG;
}


rvc_ccafi_tclMsgIPAStatusUpReg::~rvc_ccafi_tclMsgIPAStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgIPAStatusRelUpReg::rvc_ccafi_tclMsgIPAStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASTATUSRELUPREG;
}


rvc_ccafi_tclMsgIPAStatusRelUpReg::~rvc_ccafi_tclMsgIPAStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPAStatusStatus::rvc_ccafi_tclMsgIPAStatusStatus(const rvc_ccafi_tclMsgIPAStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8OperationStatus = coRef.e8OperationStatus;
   e8Request = coRef.e8Request;
}
rvc_ccafi_tclMsgIPAStatusStatus& rvc_ccafi_tclMsgIPAStatusStatus::operator=(const rvc_ccafi_tclMsgIPAStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8OperationStatus = coRef.e8OperationStatus;
   e8Request = coRef.e8Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPAStatusStatus::rvc_ccafi_tclMsgIPAStatusStatus()
:e8OperationStatus()
,e8Request()
 {}

tS32 rvc_ccafi_tclMsgIPAStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASTATUSSTATUS;
}


rvc_ccafi_tclMsgIPAStatusStatus::~rvc_ccafi_tclMsgIPAStatusStatus()
{}

tU32 rvc_ccafi_tclMsgIPAStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& rvc_ccafi_tclMsgIPAStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8OperationStatus);
   (tVoid) (oIn >> e8Request);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPAStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8OperationStatus);
   (tVoid) (oOut << e8Request);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPAStatusStatus::operator==(const rvc_ccafi_tclMsgIPAStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8OperationStatus == roRef.e8OperationStatus);
   bResult = bResult && (e8Request == roRef.e8Request);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgIPAPatternRequestUpReg::rvc_ccafi_tclMsgIPAPatternRequestUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAPatternRequestUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTUPREG;
}


rvc_ccafi_tclMsgIPAPatternRequestUpReg::~rvc_ccafi_tclMsgIPAPatternRequestUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgIPAPatternRequestRelUpReg::rvc_ccafi_tclMsgIPAPatternRequestRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAPatternRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTRELUPREG;
}


rvc_ccafi_tclMsgIPAPatternRequestRelUpReg::~rvc_ccafi_tclMsgIPAPatternRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPAPatternRequestStatus::rvc_ccafi_tclMsgIPAPatternRequestStatus(const rvc_ccafi_tclMsgIPAPatternRequestStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8DisplayPattern = coRef.e8DisplayPattern;
}
rvc_ccafi_tclMsgIPAPatternRequestStatus& rvc_ccafi_tclMsgIPAPatternRequestStatus::operator=(const rvc_ccafi_tclMsgIPAPatternRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   e8DisplayPattern = coRef.e8DisplayPattern;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPAPatternRequestStatus::rvc_ccafi_tclMsgIPAPatternRequestStatus()
:e8DisplayPattern()
 {}

tS32 rvc_ccafi_tclMsgIPAPatternRequestStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPAPATTERNREQUESTSTATUS;
}


rvc_ccafi_tclMsgIPAPatternRequestStatus::~rvc_ccafi_tclMsgIPAPatternRequestStatus()
{}

tU32 rvc_ccafi_tclMsgIPAPatternRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPAPatternRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DisplayPattern);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPAPatternRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DisplayPattern);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPAPatternRequestStatus::operator==(const rvc_ccafi_tclMsgIPAPatternRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DisplayPattern == roRef.e8DisplayPattern);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgIPAMessageRequestUpReg::rvc_ccafi_tclMsgIPAMessageRequestUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAMessageRequestUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTUPREG;
}


rvc_ccafi_tclMsgIPAMessageRequestUpReg::~rvc_ccafi_tclMsgIPAMessageRequestUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgIPAMessageRequestRelUpReg::rvc_ccafi_tclMsgIPAMessageRequestRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPAMessageRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTRELUPREG;
}


rvc_ccafi_tclMsgIPAMessageRequestRelUpReg::~rvc_ccafi_tclMsgIPAMessageRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPAMessageRequestStatus::rvc_ccafi_tclMsgIPAMessageRequestStatus(const rvc_ccafi_tclMsgIPAMessageRequestStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8MessageID = coRef.e8MessageID;
}
rvc_ccafi_tclMsgIPAMessageRequestStatus& rvc_ccafi_tclMsgIPAMessageRequestStatus::operator=(const rvc_ccafi_tclMsgIPAMessageRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   e8MessageID = coRef.e8MessageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPAMessageRequestStatus::rvc_ccafi_tclMsgIPAMessageRequestStatus()
:e8MessageID()
 {}

tS32 rvc_ccafi_tclMsgIPAMessageRequestStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPAMESSAGEREQUESTSTATUS;
}


rvc_ccafi_tclMsgIPAMessageRequestStatus::~rvc_ccafi_tclMsgIPAMessageRequestStatus()
{}

tU32 rvc_ccafi_tclMsgIPAMessageRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPAMessageRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MessageID);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPAMessageRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MessageID);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPAMessageRequestStatus::operator==(const rvc_ccafi_tclMsgIPAMessageRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MessageID == roRef.e8MessageID);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg::rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTUPREG;
}


rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg::~rvc_ccafi_tclMsgIPASwitchMaskRequestUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg::rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTRELUPREG;
}


rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg::~rvc_ccafi_tclMsgIPASwitchMaskRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::rvc_ccafi_tclMsgIPASwitchMaskRequestStatus(const rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8SwitchMask = coRef.e8SwitchMask;
}
rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::operator=(const rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   e8SwitchMask = coRef.e8SwitchMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::rvc_ccafi_tclMsgIPASwitchMaskRequestStatus()
:e8SwitchMask()
 {}

tS32 rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASWITCHMASKREQUESTSTATUS;
}


rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::~rvc_ccafi_tclMsgIPASwitchMaskRequestStatus()
{}

tU32 rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8SwitchMask);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8SwitchMask);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPASwitchMaskRequestStatus::operator==(const rvc_ccafi_tclMsgIPASwitchMaskRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8SwitchMask == roRef.e8SwitchMask);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg::rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTUPREG;
}


rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg::~rvc_ccafi_tclMsgIPASwitchGreyOutRequestUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg::rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTRELUPREG;
}


rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg::~rvc_ccafi_tclMsgIPASwitchGreyOutRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   u8SwitchGreyOut = coRef.u8SwitchGreyOut;
}
rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::operator=(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   u8SwitchGreyOut = coRef.u8SwitchGreyOut;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus()
:u8SwitchGreyOut(0)
 {}

tS32 rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPASWITCHGREYOUTREQUESTSTATUS;
}


rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::~rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus()
{}

tU32 rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8SwitchGreyOut);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8SwitchGreyOut);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus::operator==(const rvc_ccafi_tclMsgIPASwitchGreyOutRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8SwitchGreyOut == roRef.u8SwitchGreyOut);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgIPADirectionIndicatorUpReg::rvc_ccafi_tclMsgIPADirectionIndicatorUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPADirectionIndicatorUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORUPREG;
}


rvc_ccafi_tclMsgIPADirectionIndicatorUpReg::~rvc_ccafi_tclMsgIPADirectionIndicatorUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg::rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORRELUPREG;
}


rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg::~rvc_ccafi_tclMsgIPADirectionIndicatorRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgIPADirectionIndicatorStatus::rvc_ccafi_tclMsgIPADirectionIndicatorStatus(const rvc_ccafi_tclMsgIPADirectionIndicatorStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8Direction = coRef.e8Direction;
}
rvc_ccafi_tclMsgIPADirectionIndicatorStatus& rvc_ccafi_tclMsgIPADirectionIndicatorStatus::operator=(const rvc_ccafi_tclMsgIPADirectionIndicatorStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Direction = coRef.e8Direction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgIPADirectionIndicatorStatus::rvc_ccafi_tclMsgIPADirectionIndicatorStatus()
:e8Direction()
 {}

tS32 rvc_ccafi_tclMsgIPADirectionIndicatorStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_IPADIRECTIONINDICATORSTATUS;
}


rvc_ccafi_tclMsgIPADirectionIndicatorStatus::~rvc_ccafi_tclMsgIPADirectionIndicatorStatus()
{}

tU32 rvc_ccafi_tclMsgIPADirectionIndicatorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgIPADirectionIndicatorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Direction);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgIPADirectionIndicatorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Direction);
   return oOut;
}

tBool rvc_ccafi_tclMsgIPADirectionIndicatorStatus::operator==(const rvc_ccafi_tclMsgIPADirectionIndicatorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Direction == roRef.e8Direction);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg::rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg()
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLEUPREG;
}


rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg::~rvc_ccafi_tclMsgGdlAdj_SteeringAngleUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg::rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLERELUPREG;
}


rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg::~rvc_ccafi_tclMsgGdlAdj_SteeringAngleRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bShowValues = coRef.bShowValues;
   u8CentreAdjustmentState = coRef.u8CentreAdjustmentState;
   s32SteeringAngleCentreAdjusted = coRef.s32SteeringAngleCentreAdjusted;
   SteeringAngleSignalState = coRef.SteeringAngleSignalState;
}
rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::operator=(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& coRef)
{
   if (this == &coRef) return *this;
   bShowValues = coRef.bShowValues;
   u8CentreAdjustmentState = coRef.u8CentreAdjustmentState;
   s32SteeringAngleCentreAdjusted = coRef.s32SteeringAngleCentreAdjusted;
   SteeringAngleSignalState = coRef.SteeringAngleSignalState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::vDestroy()
{
   SteeringAngleSignalState.vDestroy();
}

rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus()
:bShowValues(0)
,u8CentreAdjustmentState(0)
,s32SteeringAngleCentreAdjusted(0)
,SteeringAngleSignalState()
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_STEERINGANGLESTATUS;
}


rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::~rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+SteeringAngleSignalState.u32GetSize(u16MajorVersion);
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bShowValues);
   (tVoid) (oIn >> u8CentreAdjustmentState);
   (tVoid) (oIn >> s32SteeringAngleCentreAdjusted);
   (tVoid) (oIn >> SteeringAngleSignalState);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bShowValues);
   (tVoid) (oOut << u8CentreAdjustmentState);
   (tVoid) (oOut << s32SteeringAngleCentreAdjusted);
   (tVoid) (oOut << SteeringAngleSignalState);
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus::operator==(const rvc_ccafi_tclMsgGdlAdj_SteeringAngleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bShowValues == roRef.bShowValues);
   bResult = bResult && (u8CentreAdjustmentState == roRef.u8CentreAdjustmentState);
   bResult = bResult && (s32SteeringAngleCentreAdjusted == roRef.s32SteeringAngleCentreAdjusted);
   bResult = bResult && (SteeringAngleSignalState == roRef.SteeringAngleSignalState);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg::rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg()
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLEUPREG;
}


rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg::~rvc_ccafi_tclMsgGdlAdj_CameraAngleUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg::rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLERELUPREG;
}


rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg::~rvc_ccafi_tclMsgGdlAdj_CameraAngleRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus(const rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   f32CameraRollAngle = coRef.f32CameraRollAngle;
   f32CameraYawAngle = coRef.f32CameraYawAngle;
   f32CameraPitchAngle = coRef.f32CameraPitchAngle;
}
rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::operator=(const rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& coRef)
{
   if (this == &coRef) return *this;
   f32CameraRollAngle = coRef.f32CameraRollAngle;
   f32CameraYawAngle = coRef.f32CameraYawAngle;
   f32CameraPitchAngle = coRef.f32CameraPitchAngle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus()
:f32CameraRollAngle(0)
,f32CameraYawAngle(0)
,f32CameraPitchAngle(0)
 {}

tS32 rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_GDLADJ_CAMERAANGLESTATUS;
}


rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::~rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus()
{}

tU32 rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> f32CameraRollAngle);
   (tVoid) (oIn >> f32CameraYawAngle);
   (tVoid) (oIn >> f32CameraPitchAngle);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << f32CameraRollAngle);
   (tVoid) (oOut << f32CameraYawAngle);
   (tVoid) (oOut << f32CameraPitchAngle);
   return oOut;
}

tBool rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus::operator==(const rvc_ccafi_tclMsgGdlAdj_CameraAngleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (f32CameraRollAngle == roRef.f32CameraRollAngle);
   bResult = bResult && (f32CameraYawAngle == roRef.f32CameraYawAngle);
   bResult = bResult && (f32CameraPitchAngle == roRef.f32CameraPitchAngle);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgCANFrameStatusUpReg::rvc_ccafi_tclMsgCANFrameStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgCANFrameStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSUPREG;
}


rvc_ccafi_tclMsgCANFrameStatusUpReg::~rvc_ccafi_tclMsgCANFrameStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgCANFrameStatusRelUpReg::rvc_ccafi_tclMsgCANFrameStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgCANFrameStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSRELUPREG;
}


rvc_ccafi_tclMsgCANFrameStatusRelUpReg::~rvc_ccafi_tclMsgCANFrameStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgCANFrameStatusStatus::rvc_ccafi_tclMsgCANFrameStatusStatus(const rvc_ccafi_tclMsgCANFrameStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8StatusCANFrame = coRef.e8StatusCANFrame;
}
rvc_ccafi_tclMsgCANFrameStatusStatus& rvc_ccafi_tclMsgCANFrameStatusStatus::operator=(const rvc_ccafi_tclMsgCANFrameStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8StatusCANFrame = coRef.e8StatusCANFrame;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgCANFrameStatusStatus::rvc_ccafi_tclMsgCANFrameStatusStatus()
:e8StatusCANFrame()
 {}

tS32 rvc_ccafi_tclMsgCANFrameStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_CANFRAMESTATUSSTATUS;
}


rvc_ccafi_tclMsgCANFrameStatusStatus::~rvc_ccafi_tclMsgCANFrameStatusStatus()
{}

tU32 rvc_ccafi_tclMsgCANFrameStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgCANFrameStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8StatusCANFrame);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgCANFrameStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8StatusCANFrame);
   return oOut;
}

tBool rvc_ccafi_tclMsgCANFrameStatusStatus::operator==(const rvc_ccafi_tclMsgCANFrameStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8StatusCANFrame == roRef.e8StatusCANFrame);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgMvcViewStatusUpReg::rvc_ccafi_tclMsgMvcViewStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgMvcViewStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSUPREG;
}


rvc_ccafi_tclMsgMvcViewStatusUpReg::~rvc_ccafi_tclMsgMvcViewStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgMvcViewStatusRelUpReg::rvc_ccafi_tclMsgMvcViewStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgMvcViewStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSRELUPREG;
}


rvc_ccafi_tclMsgMvcViewStatusRelUpReg::~rvc_ccafi_tclMsgMvcViewStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgMvcViewStatusStatus::rvc_ccafi_tclMsgMvcViewStatusStatus(const rvc_ccafi_tclMsgMvcViewStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8View = coRef.e8View;
}
rvc_ccafi_tclMsgMvcViewStatusStatus& rvc_ccafi_tclMsgMvcViewStatusStatus::operator=(const rvc_ccafi_tclMsgMvcViewStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8View = coRef.e8View;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgMvcViewStatusStatus::rvc_ccafi_tclMsgMvcViewStatusStatus()
:e8View()
 {}

tS32 rvc_ccafi_tclMsgMvcViewStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVCVIEWSTATUSSTATUS;
}


rvc_ccafi_tclMsgMvcViewStatusStatus::~rvc_ccafi_tclMsgMvcViewStatusStatus()
{}

tU32 rvc_ccafi_tclMsgMvcViewStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgMvcViewStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8View);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgMvcViewStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8View);
   return oOut;
}

tBool rvc_ccafi_tclMsgMvcViewStatusStatus::operator==(const rvc_ccafi_tclMsgMvcViewStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8View == roRef.e8View);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgMvcAlertRequestUpReg::rvc_ccafi_tclMsgMvcAlertRequestUpReg()
 {}

tS32 rvc_ccafi_tclMsgMvcAlertRequestUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTUPREG;
}


rvc_ccafi_tclMsgMvcAlertRequestUpReg::~rvc_ccafi_tclMsgMvcAlertRequestUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgMvcAlertRequestRelUpReg::rvc_ccafi_tclMsgMvcAlertRequestRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgMvcAlertRequestRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTRELUPREG;
}


rvc_ccafi_tclMsgMvcAlertRequestRelUpReg::~rvc_ccafi_tclMsgMvcAlertRequestRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgMvcAlertRequestStatus::rvc_ccafi_tclMsgMvcAlertRequestStatus(const rvc_ccafi_tclMsgMvcAlertRequestStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   bRequest = coRef.bRequest;
}
rvc_ccafi_tclMsgMvcAlertRequestStatus& rvc_ccafi_tclMsgMvcAlertRequestStatus::operator=(const rvc_ccafi_tclMsgMvcAlertRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   bRequest = coRef.bRequest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgMvcAlertRequestStatus::rvc_ccafi_tclMsgMvcAlertRequestStatus()
:bRequest(0)
 {}

tS32 rvc_ccafi_tclMsgMvcAlertRequestStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_MVCALERTREQUESTSTATUS;
}


rvc_ccafi_tclMsgMvcAlertRequestStatus::~rvc_ccafi_tclMsgMvcAlertRequestStatus()
{}

tU32 rvc_ccafi_tclMsgMvcAlertRequestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgMvcAlertRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRequest);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgMvcAlertRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRequest);
   return oOut;
}

tBool rvc_ccafi_tclMsgMvcAlertRequestStatus::operator==(const rvc_ccafi_tclMsgMvcAlertRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRequest == roRef.bRequest);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgFAPModeUpReg::rvc_ccafi_tclMsgFAPModeUpReg()
 {}

tS32 rvc_ccafi_tclMsgFAPModeUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPMODEUPREG;
}


rvc_ccafi_tclMsgFAPModeUpReg::~rvc_ccafi_tclMsgFAPModeUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgFAPModeRelUpReg::rvc_ccafi_tclMsgFAPModeRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgFAPModeRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPMODERELUPREG;
}


rvc_ccafi_tclMsgFAPModeRelUpReg::~rvc_ccafi_tclMsgFAPModeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgFAPModeStatus::rvc_ccafi_tclMsgFAPModeStatus(const rvc_ccafi_tclMsgFAPModeStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8State = coRef.e8State;
}
rvc_ccafi_tclMsgFAPModeStatus& rvc_ccafi_tclMsgFAPModeStatus::operator=(const rvc_ccafi_tclMsgFAPModeStatus& coRef)
{
   if (this == &coRef) return *this;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgFAPModeStatus::rvc_ccafi_tclMsgFAPModeStatus()
:e8State(0)
 {}

tS32 rvc_ccafi_tclMsgFAPModeStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPMODESTATUS;
}


rvc_ccafi_tclMsgFAPModeStatus::~rvc_ccafi_tclMsgFAPModeStatus()
{}

tU32 rvc_ccafi_tclMsgFAPModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgFAPModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgFAPModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool rvc_ccafi_tclMsgFAPModeStatus::operator==(const rvc_ccafi_tclMsgFAPModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgFAPSettingsUpReg::rvc_ccafi_tclMsgFAPSettingsUpReg()
 {}

tS32 rvc_ccafi_tclMsgFAPSettingsUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSUPREG;
}


rvc_ccafi_tclMsgFAPSettingsUpReg::~rvc_ccafi_tclMsgFAPSettingsUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgFAPSettingsRelUpReg::rvc_ccafi_tclMsgFAPSettingsRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgFAPSettingsRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSRELUPREG;
}


rvc_ccafi_tclMsgFAPSettingsRelUpReg::~rvc_ccafi_tclMsgFAPSettingsRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgFAPSettingsStatus::rvc_ccafi_tclMsgFAPSettingsStatus(const rvc_ccafi_tclMsgFAPSettingsStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   arFapSettingState = coRef.arFapSettingState;
   arAvmSettingState = coRef.arAvmSettingState;
}
rvc_ccafi_tclMsgFAPSettingsStatus& rvc_ccafi_tclMsgFAPSettingsStatus::operator=(const rvc_ccafi_tclMsgFAPSettingsStatus& coRef)
{
   if (this == &coRef) return *this;
   arFapSettingState = coRef.arFapSettingState;
   arAvmSettingState = coRef.arAvmSettingState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgFAPSettingsStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arFapSettingState.size(); ++u32Idx)
         arFapSettingState[u32Idx].vDestroy();
   arFapSettingState.clear();
   }
   {
      for (tU32 u32Idx = 0; u32Idx < arAvmSettingState.size(); ++u32Idx)
         arAvmSettingState[u32Idx].vDestroy();
   arAvmSettingState.clear();
   }
}

rvc_ccafi_tclMsgFAPSettingsStatus::rvc_ccafi_tclMsgFAPSettingsStatus()


 {}

tS32 rvc_ccafi_tclMsgFAPSettingsStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPSETTINGSSTATUS;
}


rvc_ccafi_tclMsgFAPSettingsStatus::~rvc_ccafi_tclMsgFAPSettingsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgFAPSettingsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8+ static_cast<tU32>(arFapSettingState.size()*2)+ static_cast<tU32>(arAvmSettingState.size()*2);
}

fi_tclInContext& rvc_ccafi_tclMsgFAPSettingsStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arFapSettingState.size(); ++u32Idx)
      {
         arFapSettingState[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arFapSettingState.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arFapSettingState[u32Idx]);
      }
   }
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arAvmSettingState.size(); ++u32Idx)
      {
         arAvmSettingState[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arAvmSettingState.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arAvmSettingState[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgFAPSettingsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arFapSettingState.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arFapSettingState.size(); ++u32Idx)
         (tVoid) (oOut << arFapSettingState[u32Idx]);
   }
   (tVoid) (oOut << (tU32)arAvmSettingState.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arAvmSettingState.size(); ++u32Idx)
         (tVoid) (oOut << arAvmSettingState[u32Idx]);
   }
   return oOut;
}

tBool rvc_ccafi_tclMsgFAPSettingsStatus::operator==(const rvc_ccafi_tclMsgFAPSettingsStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arFapSettingState.size() == roRef.arFapSettingState.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arFapSettingState.size()); ++u32Idx)
            bResult = bResult && (arFapSettingState[u32Idx] == roRef.arFapSettingState[u32Idx]);
      }
      bResult = bResult && (arAvmSettingState.size() == roRef.arAvmSettingState.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arAvmSettingState.size()); ++u32Idx)
            bResult = bResult && (arAvmSettingState[u32Idx] == roRef.arAvmSettingState[u32Idx]);
      }
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgFAPGuidanceStateUpReg::rvc_ccafi_tclMsgFAPGuidanceStateUpReg()
 {}

tS32 rvc_ccafi_tclMsgFAPGuidanceStateUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATEUPREG;
}


rvc_ccafi_tclMsgFAPGuidanceStateUpReg::~rvc_ccafi_tclMsgFAPGuidanceStateUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg::rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATERELUPREG;
}


rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg::~rvc_ccafi_tclMsgFAPGuidanceStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgFAPGuidanceStateStatus::rvc_ccafi_tclMsgFAPGuidanceStateStatus(const rvc_ccafi_tclMsgFAPGuidanceStateStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8State = coRef.e8State;
}
rvc_ccafi_tclMsgFAPGuidanceStateStatus& rvc_ccafi_tclMsgFAPGuidanceStateStatus::operator=(const rvc_ccafi_tclMsgFAPGuidanceStateStatus& coRef)
{
   if (this == &coRef) return *this;
   e8State = coRef.e8State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgFAPGuidanceStateStatus::rvc_ccafi_tclMsgFAPGuidanceStateStatus()
:e8State(0)
 {}

tS32 rvc_ccafi_tclMsgFAPGuidanceStateStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_FAPGUIDANCESTATESTATUS;
}


rvc_ccafi_tclMsgFAPGuidanceStateStatus::~rvc_ccafi_tclMsgFAPGuidanceStateStatus()
{}

tU32 rvc_ccafi_tclMsgFAPGuidanceStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgFAPGuidanceStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8State);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgFAPGuidanceStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8State);
   return oOut;
}

tBool rvc_ccafi_tclMsgFAPGuidanceStateStatus::operator==(const rvc_ccafi_tclMsgFAPGuidanceStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8State == roRef.e8State);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_DispStatusUpReg::rvc_ccafi_tclMsgAVM3_DispStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_DispStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSUPREG;
}


rvc_ccafi_tclMsgAVM3_DispStatusUpReg::~rvc_ccafi_tclMsgAVM3_DispStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg::rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSRELUPREG;
}


rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg::~rvc_ccafi_tclMsgAVM3_DispStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_DispStatusStatus::rvc_ccafi_tclMsgAVM3_DispStatusStatus(const rvc_ccafi_tclMsgAVM3_DispStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8DispStatus = coRef.e8DispStatus;
}
rvc_ccafi_tclMsgAVM3_DispStatusStatus& rvc_ccafi_tclMsgAVM3_DispStatusStatus::operator=(const rvc_ccafi_tclMsgAVM3_DispStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8DispStatus = coRef.e8DispStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_DispStatusStatus::rvc_ccafi_tclMsgAVM3_DispStatusStatus()
:e8DispStatus()
 {}

tS32 rvc_ccafi_tclMsgAVM3_DispStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_DISPSTATUSSTATUS;
}


rvc_ccafi_tclMsgAVM3_DispStatusStatus::~rvc_ccafi_tclMsgAVM3_DispStatusStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_DispStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_DispStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DispStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_DispStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DispStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_DispStatusStatus::operator==(const rvc_ccafi_tclMsgAVM3_DispStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DispStatus == roRef.e8DispStatus);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_ViewSetupUpReg::rvc_ccafi_tclMsgAVM3_ViewSetupUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ViewSetupUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPUPREG;
}


rvc_ccafi_tclMsgAVM3_ViewSetupUpReg::~rvc_ccafi_tclMsgAVM3_ViewSetupUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg::rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPRELUPREG;
}


rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg::~rvc_ccafi_tclMsgAVM3_ViewSetupRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_ViewSetupStatus::rvc_ccafi_tclMsgAVM3_ViewSetupStatus(const rvc_ccafi_tclMsgAVM3_ViewSetupStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8ViewPattern = coRef.e8ViewPattern;
   e8CautionId = coRef.e8CautionId;
   Switch1 = coRef.Switch1;
   Switch2 = coRef.Switch2;
   Switch3 = coRef.Switch3;
   Switch4 = coRef.Switch4;
   Switch5 = coRef.Switch5;
   Switch6 = coRef.Switch6;
   Switch7 = coRef.Switch7;
   Switch8 = coRef.Switch8;
   e8IconId = coRef.e8IconId;
   e8BuzzerStatus = coRef.e8BuzzerStatus;
}
rvc_ccafi_tclMsgAVM3_ViewSetupStatus& rvc_ccafi_tclMsgAVM3_ViewSetupStatus::operator=(const rvc_ccafi_tclMsgAVM3_ViewSetupStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ViewPattern = coRef.e8ViewPattern;
   e8CautionId = coRef.e8CautionId;
   Switch1 = coRef.Switch1;
   Switch2 = coRef.Switch2;
   Switch3 = coRef.Switch3;
   Switch4 = coRef.Switch4;
   Switch5 = coRef.Switch5;
   Switch6 = coRef.Switch6;
   Switch7 = coRef.Switch7;
   Switch8 = coRef.Switch8;
   e8IconId = coRef.e8IconId;
   e8BuzzerStatus = coRef.e8BuzzerStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_ViewSetupStatus::rvc_ccafi_tclMsgAVM3_ViewSetupStatus()
:e8ViewPattern()
,e8CautionId()
,Switch1()
,Switch2()
,Switch3()
,Switch4()
,Switch5()
,Switch6()
,Switch7()
,Switch8()
,e8IconId()
,e8BuzzerStatus()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ViewSetupStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_VIEWSETUPSTATUS;
}


rvc_ccafi_tclMsgAVM3_ViewSetupStatus::~rvc_ccafi_tclMsgAVM3_ViewSetupStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_ViewSetupStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_ViewSetupStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ViewPattern);
   (tVoid) (oIn >> e8CautionId);
   (tVoid) (oIn >> Switch1);
   (tVoid) (oIn >> Switch2);
   (tVoid) (oIn >> Switch3);
   (tVoid) (oIn >> Switch4);
   (tVoid) (oIn >> Switch5);
   (tVoid) (oIn >> Switch6);
   (tVoid) (oIn >> Switch7);
   (tVoid) (oIn >> Switch8);
   (tVoid) (oIn >> e8IconId);
   (tVoid) (oIn >> e8BuzzerStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_ViewSetupStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ViewPattern);
   (tVoid) (oOut << e8CautionId);
   (tVoid) (oOut << Switch1);
   (tVoid) (oOut << Switch2);
   (tVoid) (oOut << Switch3);
   (tVoid) (oOut << Switch4);
   (tVoid) (oOut << Switch5);
   (tVoid) (oOut << Switch6);
   (tVoid) (oOut << Switch7);
   (tVoid) (oOut << Switch8);
   (tVoid) (oOut << e8IconId);
   (tVoid) (oOut << e8BuzzerStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_ViewSetupStatus::operator==(const rvc_ccafi_tclMsgAVM3_ViewSetupStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ViewPattern == roRef.e8ViewPattern);
   bResult = bResult && (e8CautionId == roRef.e8CautionId);
   bResult = bResult && (Switch1 == roRef.Switch1);
   bResult = bResult && (Switch2 == roRef.Switch2);
   bResult = bResult && (Switch3 == roRef.Switch3);
   bResult = bResult && (Switch4 == roRef.Switch4);
   bResult = bResult && (Switch5 == roRef.Switch5);
   bResult = bResult && (Switch6 == roRef.Switch6);
   bResult = bResult && (Switch7 == roRef.Switch7);
   bResult = bResult && (Switch8 == roRef.Switch8);
   bResult = bResult && (e8IconId == roRef.e8IconId);
   bResult = bResult && (e8BuzzerStatus == roRef.e8BuzzerStatus);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg::rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGEUPREG;
}


rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg::~rvc_ccafi_tclMsgAVM3_ErrorMessageUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg::rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGERELUPREG;
}


rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg::~rvc_ccafi_tclMsgAVM3_ErrorMessageRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::rvc_ccafi_tclMsgAVM3_ErrorMessageStatus(const rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8ErrorMessage = coRef.e8ErrorMessage;
}
rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::operator=(const rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ErrorMessage = coRef.e8ErrorMessage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::rvc_ccafi_tclMsgAVM3_ErrorMessageStatus()
:e8ErrorMessage()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_ERRORMESSAGESTATUS;
}


rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::~rvc_ccafi_tclMsgAVM3_ErrorMessageStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ErrorMessage);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ErrorMessage);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_ErrorMessageStatus::operator==(const rvc_ccafi_tclMsgAVM3_ErrorMessageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ErrorMessage == roRef.e8ErrorMessage);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg::rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSUPREG;
}


rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg::~rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg::rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSRELUPREG;
}


rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg::~rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8BuzzerStatus = coRef.e8BuzzerStatus;
}
rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::operator=(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8BuzzerStatus = coRef.e8BuzzerStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus()
:e8BuzzerStatus()
 {}

tS32 rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SONARBUZZERSTATUSSTATUS;
}


rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::~rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8BuzzerStatus);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8BuzzerStatus);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus::operator==(const rvc_ccafi_tclMsgAVM3_SonarBuzzerStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8BuzzerStatus == roRef.e8BuzzerStatus);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg::rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDUPREG;
}


rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg::~rvc_ccafi_tclMsgAVM3_Settings_DetailedUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg::rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDRELUPREG;
}


rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg::~rvc_ccafi_tclMsgAVM3_Settings_DetailedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus(const rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   arSettingsOption = coRef.arSettingsOption;
   e8PriorityView = coRef.e8PriorityView;
   e8PriorityWide = coRef.e8PriorityWide;
   e8AutoCamPos = coRef.e8AutoCamPos;
   rCornerSonarSensLvl = coRef.rCornerSonarSensLvl;
   rSonarSensLvl = coRef.rSonarSensLvl;
   rBuzzerSoundLvl = coRef.rBuzzerSoundLvl;
}
rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::operator=(const rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& coRef)
{
   if (this == &coRef) return *this;
   arSettingsOption = coRef.arSettingsOption;
   e8PriorityView = coRef.e8PriorityView;
   e8PriorityWide = coRef.e8PriorityWide;
   e8AutoCamPos = coRef.e8AutoCamPos;
   rCornerSonarSensLvl = coRef.rCornerSonarSensLvl;
   rSonarSensLvl = coRef.rSonarSensLvl;
   rBuzzerSoundLvl = coRef.rBuzzerSoundLvl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arSettingsOption.size(); ++u32Idx)
         arSettingsOption[u32Idx].vDestroy();
   arSettingsOption.clear();
   }
   rCornerSonarSensLvl.vDestroy(); 
   rSonarSensLvl.vDestroy(); 
   rBuzzerSoundLvl.vDestroy(); 
}

rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus()

:e8PriorityView()
,e8PriorityWide()
,e8AutoCamPos()
,rCornerSonarSensLvl()
,rSonarSensLvl()
,rBuzzerSoundLvl()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_DETAILEDSTATUS;
}


rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::~rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 13+ static_cast<tU32>(arSettingsOption.size()*2);
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arSettingsOption.size(); ++u32Idx)
      {
         arSettingsOption[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arSettingsOption.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arSettingsOption[u32Idx]);
      }
   }
   (tVoid) (oIn >> e8PriorityView);
   (tVoid) (oIn >> e8PriorityWide);
   (tVoid) (oIn >> e8AutoCamPos);
   (tVoid) (oIn >> rCornerSonarSensLvl);
   (tVoid) (oIn >> rSonarSensLvl);
   (tVoid) (oIn >> rBuzzerSoundLvl);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arSettingsOption.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arSettingsOption.size(); ++u32Idx)
         (tVoid) (oOut << arSettingsOption[u32Idx]);
   }
   (tVoid) (oOut << e8PriorityView);
   (tVoid) (oOut << e8PriorityWide);
   (tVoid) (oOut << e8AutoCamPos);
   (tVoid) (oOut << rCornerSonarSensLvl);
   (tVoid) (oOut << rSonarSensLvl);
   (tVoid) (oOut << rBuzzerSoundLvl);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus::operator==(const rvc_ccafi_tclMsgAVM3_Settings_DetailedStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arSettingsOption.size() == roRef.arSettingsOption.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arSettingsOption.size()); ++u32Idx)
            bResult = bResult && (arSettingsOption[u32Idx] == roRef.arSettingsOption[u32Idx]);
      }
   bResult = bResult && (e8PriorityView == roRef.e8PriorityView);
   bResult = bResult && (e8PriorityWide == roRef.e8PriorityWide);
   bResult = bResult && (e8AutoCamPos == roRef.e8AutoCamPos);
   bResult = bResult && (rCornerSonarSensLvl == roRef.rCornerSonarSensLvl);
   bResult = bResult && (rSonarSensLvl == roRef.rSonarSensLvl);
   bResult = bResult && (rBuzzerSoundLvl == roRef.rBuzzerSoundLvl);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg::rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYUPREG;
}


rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg::~rvc_ccafi_tclMsgAVM3_Settings_PrimaryUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg::rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYRELUPREG;
}


rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg::~rvc_ccafi_tclMsgAVM3_Settings_PrimaryRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8AvmSonarBuzzer = coRef.e8AvmSonarBuzzer;
   bDetailsSettingsAvail = coRef.bDetailsSettingsAvail;
   bImageQualitySettingAvail = coRef.bImageQualitySettingAvail;
}
rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::operator=(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& coRef)
{
   if (this == &coRef) return *this;
   e8AvmSonarBuzzer = coRef.e8AvmSonarBuzzer;
   bDetailsSettingsAvail = coRef.bDetailsSettingsAvail;
   bImageQualitySettingAvail = coRef.bImageQualitySettingAvail;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus()
:e8AvmSonarBuzzer()
,bDetailsSettingsAvail(0)
,bImageQualitySettingAvail(0)
 {}

tS32 rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SETTINGS_PRIMARYSTATUS;
}


rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::~rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AvmSonarBuzzer);
   (tVoid) (oIn >> bDetailsSettingsAvail);
   (tVoid) (oIn >> bImageQualitySettingAvail);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AvmSonarBuzzer);
   (tVoid) (oOut << bDetailsSettingsAvail);
   (tVoid) (oOut << bImageQualitySettingAvail);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus::operator==(const rvc_ccafi_tclMsgAVM3_Settings_PrimaryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AvmSonarBuzzer == roRef.e8AvmSonarBuzzer);
   bResult = bResult && (bDetailsSettingsAvail == roRef.bDetailsSettingsAvail);
   bResult = bResult && (bImageQualitySettingAvail == roRef.bImageQualitySettingAvail);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_ConfigurationUpReg::rvc_ccafi_tclMsgAVM3_ConfigurationUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ConfigurationUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONUPREG;
}


rvc_ccafi_tclMsgAVM3_ConfigurationUpReg::~rvc_ccafi_tclMsgAVM3_ConfigurationUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg::rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONRELUPREG;
}


rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg::~rvc_ccafi_tclMsgAVM3_ConfigurationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_ConfigurationStatus::rvc_ccafi_tclMsgAVM3_ConfigurationStatus(const rvc_ccafi_tclMsgAVM3_ConfigurationStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   e8ConfigStatus = coRef.e8ConfigStatus;
   rUnit_ID = coRef.rUnit_ID;
   rMsgSetVersion = coRef.rMsgSetVersion;
}
rvc_ccafi_tclMsgAVM3_ConfigurationStatus& rvc_ccafi_tclMsgAVM3_ConfigurationStatus::operator=(const rvc_ccafi_tclMsgAVM3_ConfigurationStatus& coRef)
{
   if (this == &coRef) return *this;
   e8ConfigStatus = coRef.e8ConfigStatus;
   rUnit_ID = coRef.rUnit_ID;
   rMsgSetVersion = coRef.rMsgSetVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_ConfigurationStatus::rvc_ccafi_tclMsgAVM3_ConfigurationStatus()
:e8ConfigStatus()
,rUnit_ID()
,rMsgSetVersion()
 {}

tS32 rvc_ccafi_tclMsgAVM3_ConfigurationStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_CONFIGURATIONSTATUS;
}


rvc_ccafi_tclMsgAVM3_ConfigurationStatus::~rvc_ccafi_tclMsgAVM3_ConfigurationStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_ConfigurationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_ConfigurationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8ConfigStatus);
   (tVoid) (oIn >> rUnit_ID);
   (tVoid) (oIn >> rMsgSetVersion);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_ConfigurationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8ConfigStatus);
   (tVoid) (oOut << rUnit_ID);
   (tVoid) (oOut << rMsgSetVersion);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_ConfigurationStatus::operator==(const rvc_ccafi_tclMsgAVM3_ConfigurationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8ConfigStatus == roRef.e8ConfigStatus);
   bResult = bResult && (rUnit_ID == roRef.rUnit_ID);
   bResult = bResult && (rMsgSetVersion == roRef.rMsgSetVersion);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Software_VersionUpReg::rvc_ccafi_tclMsgAVM3_Software_VersionUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Software_VersionUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONUPREG;
}


rvc_ccafi_tclMsgAVM3_Software_VersionUpReg::~rvc_ccafi_tclMsgAVM3_Software_VersionUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg::rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONRELUPREG;
}


rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg::~rvc_ccafi_tclMsgAVM3_Software_VersionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Software_VersionStatus::rvc_ccafi_tclMsgAVM3_Software_VersionStatus(const rvc_ccafi_tclMsgAVM3_Software_VersionStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   rSW_Version_AVM = coRef.rSW_Version_AVM;
   rSW_Version_Sonar = coRef.rSW_Version_Sonar;
}
rvc_ccafi_tclMsgAVM3_Software_VersionStatus& rvc_ccafi_tclMsgAVM3_Software_VersionStatus::operator=(const rvc_ccafi_tclMsgAVM3_Software_VersionStatus& coRef)
{
   if (this == &coRef) return *this;
   rSW_Version_AVM = coRef.rSW_Version_AVM;
   rSW_Version_Sonar = coRef.rSW_Version_Sonar;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_Software_VersionStatus::rvc_ccafi_tclMsgAVM3_Software_VersionStatus()
:rSW_Version_AVM()
,rSW_Version_Sonar()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Software_VersionStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_SOFTWARE_VERSIONSTATUS;
}


rvc_ccafi_tclMsgAVM3_Software_VersionStatus::~rvc_ccafi_tclMsgAVM3_Software_VersionStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_Software_VersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Software_VersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rSW_Version_AVM);
   (tVoid) (oIn >> rSW_Version_Sonar);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Software_VersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rSW_Version_AVM);
   (tVoid) (oOut << rSW_Version_Sonar);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Software_VersionStatus::operator==(const rvc_ccafi_tclMsgAVM3_Software_VersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rSW_Version_AVM == roRef.rSW_Version_AVM);
   bResult = bResult && (rSW_Version_Sonar == roRef.rSW_Version_Sonar);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg::rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONUPREG;
}


rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg::~rvc_ccafi_tclMsgAVM3_Hardware_VersionUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg::rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONRELUPREG;
}


rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg::~rvc_ccafi_tclMsgAVM3_Hardware_VersionRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus(const rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   rHW_Version_AVM = coRef.rHW_Version_AVM;
   rHW_Version_Sonar = coRef.rHW_Version_Sonar;
}
rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::operator=(const rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& coRef)
{
   if (this == &coRef) return *this;
   rHW_Version_AVM = coRef.rHW_Version_AVM;
   rHW_Version_Sonar = coRef.rHW_Version_Sonar;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus()
:rHW_Version_AVM()
,rHW_Version_Sonar()
 {}

tS32 rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_HARDWARE_VERSIONSTATUS;
}


rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::~rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rHW_Version_AVM);
   (tVoid) (oIn >> rHW_Version_Sonar);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rHW_Version_AVM);
   (tVoid) (oOut << rHW_Version_Sonar);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus::operator==(const rvc_ccafi_tclMsgAVM3_Hardware_VersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rHW_Version_AVM == roRef.rHW_Version_AVM);
   bResult = bResult && (rHW_Version_Sonar == roRef.rHW_Version_Sonar);
   return bResult;
}

//=============================================================================

rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg::rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSUPREG;
}


rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg::~rvc_ccafi_tclMsgAVM3_CommunicationErrorsUpReg()
{}

//=============================================================================

rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg::rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg()
 {}

tS32 rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSRELUPREG;
}


rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg::~rvc_ccafi_tclMsgAVM3_CommunicationErrorsRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& coRef)
   : rvc_ccafi_tclMsgBaseMessage(coRef)
{
   rCommErrors = coRef.rCommErrors;
}
rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::operator=(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& coRef)
{
   if (this == &coRef) return *this;
   rCommErrors = coRef.rCommErrors;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus()
:rCommErrors()
 {}

tS32 rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::s32GetTypeId() const
{
   return (tS32) rvc_ccafi_tclToken::EN_MSG_AVM3_COMMUNICATIONERRORSSTATUS;
}


rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::~rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus()
{}

tU32 rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> rCommErrors);
   return oIn;
}

fi_tclOutContext& rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << rCommErrors);
   return oOut;
}

tBool rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus::operator==(const rvc_ccafi_tclMsgAVM3_CommunicationErrorsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (rCommErrors == roRef.rCommErrors);
   return bResult;
}

