/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_TYPES
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_FUNCTIONIDS
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_SERVICEINFO
#include "profile_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for profile_main_fi message types

fi_tclMessageBase* profile_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgdoChangeToProfileMethodStart;

      case profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODRESULT:
         return OSAL_NEW profile_mainfi_tclMsgdoChangeToProfileMethodResult;

      case profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgdoCopyProfileMethodStart;

      case profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODRESULT:
         return OSAL_NEW profile_mainfi_tclMsgdoCopyProfileMethodResult;

      case profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgdoDeleteProfileMethodStart;

      case profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODRESULT:
         return OSAL_NEW profile_mainfi_tclMsgdoDeleteProfileMethodResult;

      case profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgdoCreateProfileMethodStart;

      case profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODRESULT:
         return OSAL_NEW profile_mainfi_tclMsgdoCreateProfileMethodResult;

      case profile_mainfi_tclToken::EN_MSG_ONDATACHANGEDMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgonDataChangedMethodStart;

      case profile_mainfi_tclToken::EN_MSG_ONPROFILECREATEDMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgonProfileCreatedMethodStart;

      case profile_mainfi_tclToken::EN_MSG_ONPROFILECOPIEDMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgonProfileCopiedMethodStart;

      case profile_mainfi_tclToken::EN_MSG_ONPROFILEDELETEDMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgonProfileDeletedMethodStart;

      case profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODSTART:
         return OSAL_NEW profile_mainfi_tclMsgRegisterClientMethodStart;

      case profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODRESULT:
         return OSAL_NEW profile_mainfi_tclMsgRegisterClientMethodResult;

      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEUPREG:
         return OSAL_NEW profile_mainfi_tclMsgactiveProfileUpReg;

      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILERELUPREG:
         return OSAL_NEW profile_mainfi_tclMsgactiveProfileRelUpReg;

      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEGET:
         return OSAL_NEW profile_mainfi_tclMsgactiveProfileGet;

      case profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILESTATUS:
         return OSAL_NEW profile_mainfi_tclMsgactiveProfileStatus;

      case profile_mainfi_tclToken::EN_MSG_STATUSUPREG:
         return OSAL_NEW profile_mainfi_tclMsgstatusUpReg;

      case profile_mainfi_tclToken::EN_MSG_STATUSRELUPREG:
         return OSAL_NEW profile_mainfi_tclMsgstatusRelUpReg;

      case profile_mainfi_tclToken::EN_MSG_STATUSGET:
         return OSAL_NEW profile_mainfi_tclMsgstatusGet;

      case profile_mainfi_tclToken::EN_MSG_STATUSSTATUS:
         return OSAL_NEW profile_mainfi_tclMsgstatusStatus;

      case profile_mainfi_tclToken::EN_MSG_COPYPROFILEUPREG:
         return OSAL_NEW profile_mainfi_tclMsgcopyProfileUpReg;

      case profile_mainfi_tclToken::EN_MSG_COPYPROFILERELUPREG:
         return OSAL_NEW profile_mainfi_tclMsgcopyProfileRelUpReg;

      case profile_mainfi_tclToken::EN_MSG_COPYPROFILESTATUS:
         return OSAL_NEW profile_mainfi_tclMsgcopyProfileStatus;

      case profile_mainfi_tclToken::EN_MSG_DELETEPROFILEUPREG:
         return OSAL_NEW profile_mainfi_tclMsgdeleteProfileUpReg;

      case profile_mainfi_tclToken::EN_MSG_DELETEPROFILERELUPREG:
         return OSAL_NEW profile_mainfi_tclMsgdeleteProfileRelUpReg;

      case profile_mainfi_tclToken::EN_MSG_DELETEPROFILESTATUS:
         return OSAL_NEW profile_mainfi_tclMsgdeleteProfileStatus;

      case profile_mainfi_tclToken::EN_MSG_DATACHANGEDUPREG:
         return OSAL_NEW profile_mainfi_tclMsgdataChangedUpReg;

      case profile_mainfi_tclToken::EN_MSG_DATACHANGEDRELUPREG:
         return OSAL_NEW profile_mainfi_tclMsgdataChangedRelUpReg;

      case profile_mainfi_tclToken::EN_MSG_DATACHANGEDSTATUS:
         return OSAL_NEW profile_mainfi_tclMsgdataChangedStatus;

      case profile_mainfi_tclToken::EN_MSG_CREATEPROFILEUPREG:
         return OSAL_NEW profile_mainfi_tclMsgcreateProfileUpReg;

      case profile_mainfi_tclToken::EN_MSG_CREATEPROFILERELUPREG:
         return OSAL_NEW profile_mainfi_tclMsgcreateProfileRelUpReg;

      case profile_mainfi_tclToken::EN_MSG_CREATEPROFILESTATUS:
         return OSAL_NEW profile_mainfi_tclMsgcreateProfileStatus;

      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSUPREG:
         return OSAL_NEW profile_mainfi_tclMsgprivacyStatusUpReg;

      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSRELUPREG:
         return OSAL_NEW profile_mainfi_tclMsgprivacyStatusRelUpReg;

      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSGET:
         return OSAL_NEW profile_mainfi_tclMsgprivacyStatusGet;

      case profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSSTATUS:
         return OSAL_NEW profile_mainfi_tclMsgprivacyStatusStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all profile_mainfifi messages

// common functions

tU16 profile_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return PROFILE_MAINFI_C_U16_SERVICE_ID;
}

tU16 profile_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 profile_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& profile_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& profile_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 profile_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& profile_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& profile_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoChangeToProfileMethodStart::profile_mainfi_tclMsgdoChangeToProfileMethodStart(const profile_mainfi_tclMsgdoChangeToProfileMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   newUserID = coRef.newUserID;
}
profile_mainfi_tclMsgdoChangeToProfileMethodStart& profile_mainfi_tclMsgdoChangeToProfileMethodStart::operator=(const profile_mainfi_tclMsgdoChangeToProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   newUserID = coRef.newUserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdoChangeToProfileMethodStart::profile_mainfi_tclMsgdoChangeToProfileMethodStart()
:newUserID(0)
 {}

tS32 profile_mainfi_tclMsgdoChangeToProfileMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODSTART;
}


profile_mainfi_tclMsgdoChangeToProfileMethodStart::~profile_mainfi_tclMsgdoChangeToProfileMethodStart()
{}

tU32 profile_mainfi_tclMsgdoChangeToProfileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgdoChangeToProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> newUserID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoChangeToProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << newUserID);
   return oOut;
}

tBool profile_mainfi_tclMsgdoChangeToProfileMethodStart::operator==(const profile_mainfi_tclMsgdoChangeToProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (newUserID == roRef.newUserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoChangeToProfileMethodResult::profile_mainfi_tclMsgdoChangeToProfileMethodResult(const profile_mainfi_tclMsgdoChangeToProfileMethodResult& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
profile_mainfi_tclMsgdoChangeToProfileMethodResult& profile_mainfi_tclMsgdoChangeToProfileMethodResult::operator=(const profile_mainfi_tclMsgdoChangeToProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdoChangeToProfileMethodResult::profile_mainfi_tclMsgdoChangeToProfileMethodResult()
:result()
 {}

tS32 profile_mainfi_tclMsgdoChangeToProfileMethodResult::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DOCHANGETOPROFILEMETHODRESULT;
}


profile_mainfi_tclMsgdoChangeToProfileMethodResult::~profile_mainfi_tclMsgdoChangeToProfileMethodResult()
{}

tU32 profile_mainfi_tclMsgdoChangeToProfileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgdoChangeToProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoChangeToProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool profile_mainfi_tclMsgdoChangeToProfileMethodResult::operator==(const profile_mainfi_tclMsgdoChangeToProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoCopyProfileMethodStart::profile_mainfi_tclMsgdoCopyProfileMethodStart(const profile_mainfi_tclMsgdoCopyProfileMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   sourceID = coRef.sourceID;
   destinationID = coRef.destinationID;
}
profile_mainfi_tclMsgdoCopyProfileMethodStart& profile_mainfi_tclMsgdoCopyProfileMethodStart::operator=(const profile_mainfi_tclMsgdoCopyProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sourceID = coRef.sourceID;
   destinationID = coRef.destinationID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdoCopyProfileMethodStart::profile_mainfi_tclMsgdoCopyProfileMethodStart()
:sourceID(0)
,destinationID(0)
 {}

tS32 profile_mainfi_tclMsgdoCopyProfileMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODSTART;
}


profile_mainfi_tclMsgdoCopyProfileMethodStart::~profile_mainfi_tclMsgdoCopyProfileMethodStart()
{}

tU32 profile_mainfi_tclMsgdoCopyProfileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& profile_mainfi_tclMsgdoCopyProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sourceID);
   (tVoid) (oIn >> destinationID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoCopyProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sourceID);
   (tVoid) (oOut << destinationID);
   return oOut;
}

tBool profile_mainfi_tclMsgdoCopyProfileMethodStart::operator==(const profile_mainfi_tclMsgdoCopyProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sourceID == roRef.sourceID);
   bResult = bResult && (destinationID == roRef.destinationID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoCopyProfileMethodResult::profile_mainfi_tclMsgdoCopyProfileMethodResult(const profile_mainfi_tclMsgdoCopyProfileMethodResult& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
profile_mainfi_tclMsgdoCopyProfileMethodResult& profile_mainfi_tclMsgdoCopyProfileMethodResult::operator=(const profile_mainfi_tclMsgdoCopyProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdoCopyProfileMethodResult::profile_mainfi_tclMsgdoCopyProfileMethodResult()
:result()
 {}

tS32 profile_mainfi_tclMsgdoCopyProfileMethodResult::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DOCOPYPROFILEMETHODRESULT;
}


profile_mainfi_tclMsgdoCopyProfileMethodResult::~profile_mainfi_tclMsgdoCopyProfileMethodResult()
{}

tU32 profile_mainfi_tclMsgdoCopyProfileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgdoCopyProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoCopyProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool profile_mainfi_tclMsgdoCopyProfileMethodResult::operator==(const profile_mainfi_tclMsgdoCopyProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoDeleteProfileMethodStart::profile_mainfi_tclMsgdoDeleteProfileMethodStart(const profile_mainfi_tclMsgdoDeleteProfileMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   UserID = coRef.UserID;
}
profile_mainfi_tclMsgdoDeleteProfileMethodStart& profile_mainfi_tclMsgdoDeleteProfileMethodStart::operator=(const profile_mainfi_tclMsgdoDeleteProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   UserID = coRef.UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdoDeleteProfileMethodStart::profile_mainfi_tclMsgdoDeleteProfileMethodStart()
:UserID(0)
 {}

tS32 profile_mainfi_tclMsgdoDeleteProfileMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODSTART;
}


profile_mainfi_tclMsgdoDeleteProfileMethodStart::~profile_mainfi_tclMsgdoDeleteProfileMethodStart()
{}

tU32 profile_mainfi_tclMsgdoDeleteProfileMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgdoDeleteProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoDeleteProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserID);
   return oOut;
}

tBool profile_mainfi_tclMsgdoDeleteProfileMethodStart::operator==(const profile_mainfi_tclMsgdoDeleteProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserID == roRef.UserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoDeleteProfileMethodResult::profile_mainfi_tclMsgdoDeleteProfileMethodResult(const profile_mainfi_tclMsgdoDeleteProfileMethodResult& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
profile_mainfi_tclMsgdoDeleteProfileMethodResult& profile_mainfi_tclMsgdoDeleteProfileMethodResult::operator=(const profile_mainfi_tclMsgdoDeleteProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdoDeleteProfileMethodResult::profile_mainfi_tclMsgdoDeleteProfileMethodResult()
:result()
 {}

tS32 profile_mainfi_tclMsgdoDeleteProfileMethodResult::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DODELETEPROFILEMETHODRESULT;
}


profile_mainfi_tclMsgdoDeleteProfileMethodResult::~profile_mainfi_tclMsgdoDeleteProfileMethodResult()
{}

tU32 profile_mainfi_tclMsgdoDeleteProfileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgdoDeleteProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoDeleteProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool profile_mainfi_tclMsgdoDeleteProfileMethodResult::operator==(const profile_mainfi_tclMsgdoDeleteProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoCreateProfileMethodStart::profile_mainfi_tclMsgdoCreateProfileMethodStart(const profile_mainfi_tclMsgdoCreateProfileMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   Name = coRef.Name;
   ImageID = coRef.ImageID;
}
profile_mainfi_tclMsgdoCreateProfileMethodStart& profile_mainfi_tclMsgdoCreateProfileMethodStart::operator=(const profile_mainfi_tclMsgdoCreateProfileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Name = coRef.Name;
   ImageID = coRef.ImageID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid profile_mainfi_tclMsgdoCreateProfileMethodStart::vDestroy()
{
   Name.vDestroy();
}

profile_mainfi_tclMsgdoCreateProfileMethodStart::profile_mainfi_tclMsgdoCreateProfileMethodStart()
:Name()
,ImageID(0)
 {}

tS32 profile_mainfi_tclMsgdoCreateProfileMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODSTART;
}


profile_mainfi_tclMsgdoCreateProfileMethodStart::~profile_mainfi_tclMsgdoCreateProfileMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 profile_mainfi_tclMsgdoCreateProfileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& profile_mainfi_tclMsgdoCreateProfileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Name);
   (tVoid) (oIn >> ImageID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoCreateProfileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Name);
   (tVoid) (oOut << ImageID);
   return oOut;
}

tBool profile_mainfi_tclMsgdoCreateProfileMethodStart::operator==(const profile_mainfi_tclMsgdoCreateProfileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Name == roRef.Name);
   bResult = bResult && (ImageID == roRef.ImageID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdoCreateProfileMethodResult::profile_mainfi_tclMsgdoCreateProfileMethodResult(const profile_mainfi_tclMsgdoCreateProfileMethodResult& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
   UserID = coRef.UserID;
}
profile_mainfi_tclMsgdoCreateProfileMethodResult& profile_mainfi_tclMsgdoCreateProfileMethodResult::operator=(const profile_mainfi_tclMsgdoCreateProfileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   UserID = coRef.UserID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdoCreateProfileMethodResult::profile_mainfi_tclMsgdoCreateProfileMethodResult()
:result()
,UserID(0)
 {}

tS32 profile_mainfi_tclMsgdoCreateProfileMethodResult::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DOCREATEPROFILEMETHODRESULT;
}


profile_mainfi_tclMsgdoCreateProfileMethodResult::~profile_mainfi_tclMsgdoCreateProfileMethodResult()
{}

tU32 profile_mainfi_tclMsgdoCreateProfileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& profile_mainfi_tclMsgdoCreateProfileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   (tVoid) (oIn >> UserID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdoCreateProfileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   (tVoid) (oOut << UserID);
   return oOut;
}

tBool profile_mainfi_tclMsgdoCreateProfileMethodResult::operator==(const profile_mainfi_tclMsgdoCreateProfileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   bResult = bResult && (UserID == roRef.UserID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgonDataChangedMethodStart::profile_mainfi_tclMsgonDataChangedMethodStart(const profile_mainfi_tclMsgonDataChangedMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
profile_mainfi_tclMsgonDataChangedMethodStart& profile_mainfi_tclMsgonDataChangedMethodStart::operator=(const profile_mainfi_tclMsgonDataChangedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgonDataChangedMethodStart::profile_mainfi_tclMsgonDataChangedMethodStart()
:result()
 {}

tS32 profile_mainfi_tclMsgonDataChangedMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ONDATACHANGEDMETHODSTART;
}


profile_mainfi_tclMsgonDataChangedMethodStart::~profile_mainfi_tclMsgonDataChangedMethodStart()
{}

tU32 profile_mainfi_tclMsgonDataChangedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgonDataChangedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgonDataChangedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool profile_mainfi_tclMsgonDataChangedMethodStart::operator==(const profile_mainfi_tclMsgonDataChangedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgonProfileCreatedMethodStart::profile_mainfi_tclMsgonProfileCreatedMethodStart(const profile_mainfi_tclMsgonProfileCreatedMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
profile_mainfi_tclMsgonProfileCreatedMethodStart& profile_mainfi_tclMsgonProfileCreatedMethodStart::operator=(const profile_mainfi_tclMsgonProfileCreatedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgonProfileCreatedMethodStart::profile_mainfi_tclMsgonProfileCreatedMethodStart()
:result()
 {}

tS32 profile_mainfi_tclMsgonProfileCreatedMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ONPROFILECREATEDMETHODSTART;
}


profile_mainfi_tclMsgonProfileCreatedMethodStart::~profile_mainfi_tclMsgonProfileCreatedMethodStart()
{}

tU32 profile_mainfi_tclMsgonProfileCreatedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgonProfileCreatedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgonProfileCreatedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool profile_mainfi_tclMsgonProfileCreatedMethodStart::operator==(const profile_mainfi_tclMsgonProfileCreatedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgonProfileCopiedMethodStart::profile_mainfi_tclMsgonProfileCopiedMethodStart(const profile_mainfi_tclMsgonProfileCopiedMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
profile_mainfi_tclMsgonProfileCopiedMethodStart& profile_mainfi_tclMsgonProfileCopiedMethodStart::operator=(const profile_mainfi_tclMsgonProfileCopiedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgonProfileCopiedMethodStart::profile_mainfi_tclMsgonProfileCopiedMethodStart()
:result()
 {}

tS32 profile_mainfi_tclMsgonProfileCopiedMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ONPROFILECOPIEDMETHODSTART;
}


profile_mainfi_tclMsgonProfileCopiedMethodStart::~profile_mainfi_tclMsgonProfileCopiedMethodStart()
{}

tU32 profile_mainfi_tclMsgonProfileCopiedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgonProfileCopiedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgonProfileCopiedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool profile_mainfi_tclMsgonProfileCopiedMethodStart::operator==(const profile_mainfi_tclMsgonProfileCopiedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgonProfileDeletedMethodStart::profile_mainfi_tclMsgonProfileDeletedMethodStart(const profile_mainfi_tclMsgonProfileDeletedMethodStart& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   result = coRef.result;
}
profile_mainfi_tclMsgonProfileDeletedMethodStart& profile_mainfi_tclMsgonProfileDeletedMethodStart::operator=(const profile_mainfi_tclMsgonProfileDeletedMethodStart& coRef)
{
   if (this == &coRef) return *this;
   result = coRef.result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgonProfileDeletedMethodStart::profile_mainfi_tclMsgonProfileDeletedMethodStart()
:result()
 {}

tS32 profile_mainfi_tclMsgonProfileDeletedMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ONPROFILEDELETEDMETHODSTART;
}


profile_mainfi_tclMsgonProfileDeletedMethodStart::~profile_mainfi_tclMsgonProfileDeletedMethodStart()
{}

tU32 profile_mainfi_tclMsgonProfileDeletedMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgonProfileDeletedMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> result);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgonProfileDeletedMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << result);
   return oOut;
}

tBool profile_mainfi_tclMsgonProfileDeletedMethodStart::operator==(const profile_mainfi_tclMsgonProfileDeletedMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (result == roRef.result);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgRegisterClientMethodStart::profile_mainfi_tclMsgRegisterClientMethodStart()
 {}

tS32 profile_mainfi_tclMsgRegisterClientMethodStart::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODSTART;
}


profile_mainfi_tclMsgRegisterClientMethodStart::~profile_mainfi_tclMsgRegisterClientMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgRegisterClientMethodResult::profile_mainfi_tclMsgRegisterClientMethodResult(const profile_mainfi_tclMsgRegisterClientMethodResult& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   bReloadData = coRef.bReloadData;
}
profile_mainfi_tclMsgRegisterClientMethodResult& profile_mainfi_tclMsgRegisterClientMethodResult::operator=(const profile_mainfi_tclMsgRegisterClientMethodResult& coRef)
{
   if (this == &coRef) return *this;
   bReloadData = coRef.bReloadData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgRegisterClientMethodResult::profile_mainfi_tclMsgRegisterClientMethodResult()
:bReloadData(0)
 {}

tS32 profile_mainfi_tclMsgRegisterClientMethodResult::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_REGISTERCLIENTMETHODRESULT;
}


profile_mainfi_tclMsgRegisterClientMethodResult::~profile_mainfi_tclMsgRegisterClientMethodResult()
{}

tU32 profile_mainfi_tclMsgRegisterClientMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgRegisterClientMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bReloadData);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgRegisterClientMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bReloadData);
   return oOut;
}

tBool profile_mainfi_tclMsgRegisterClientMethodResult::operator==(const profile_mainfi_tclMsgRegisterClientMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bReloadData == roRef.bReloadData);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgactiveProfileUpReg::profile_mainfi_tclMsgactiveProfileUpReg()
 {}

tS32 profile_mainfi_tclMsgactiveProfileUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEUPREG;
}


profile_mainfi_tclMsgactiveProfileUpReg::~profile_mainfi_tclMsgactiveProfileUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgactiveProfileRelUpReg::profile_mainfi_tclMsgactiveProfileRelUpReg()
 {}

tS32 profile_mainfi_tclMsgactiveProfileRelUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILERELUPREG;
}


profile_mainfi_tclMsgactiveProfileRelUpReg::~profile_mainfi_tclMsgactiveProfileRelUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgactiveProfileGet::profile_mainfi_tclMsgactiveProfileGet()
 {}

tS32 profile_mainfi_tclMsgactiveProfileGet::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILEGET;
}


profile_mainfi_tclMsgactiveProfileGet::~profile_mainfi_tclMsgactiveProfileGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgactiveProfileStatus::profile_mainfi_tclMsgactiveProfileStatus(const profile_mainfi_tclMsgactiveProfileStatus& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   ID = coRef.ID;
}
profile_mainfi_tclMsgactiveProfileStatus& profile_mainfi_tclMsgactiveProfileStatus::operator=(const profile_mainfi_tclMsgactiveProfileStatus& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgactiveProfileStatus::profile_mainfi_tclMsgactiveProfileStatus()
:ID(0)
 {}

tS32 profile_mainfi_tclMsgactiveProfileStatus::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_ACTIVEPROFILESTATUS;
}


profile_mainfi_tclMsgactiveProfileStatus::~profile_mainfi_tclMsgactiveProfileStatus()
{}

tU32 profile_mainfi_tclMsgactiveProfileStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgactiveProfileStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgactiveProfileStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   return oOut;
}

tBool profile_mainfi_tclMsgactiveProfileStatus::operator==(const profile_mainfi_tclMsgactiveProfileStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgstatusUpReg::profile_mainfi_tclMsgstatusUpReg()
 {}

tS32 profile_mainfi_tclMsgstatusUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_STATUSUPREG;
}


profile_mainfi_tclMsgstatusUpReg::~profile_mainfi_tclMsgstatusUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgstatusRelUpReg::profile_mainfi_tclMsgstatusRelUpReg()
 {}

tS32 profile_mainfi_tclMsgstatusRelUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_STATUSRELUPREG;
}


profile_mainfi_tclMsgstatusRelUpReg::~profile_mainfi_tclMsgstatusRelUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgstatusGet::profile_mainfi_tclMsgstatusGet()
 {}

tS32 profile_mainfi_tclMsgstatusGet::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_STATUSGET;
}


profile_mainfi_tclMsgstatusGet::~profile_mainfi_tclMsgstatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgstatusStatus::profile_mainfi_tclMsgstatusStatus(const profile_mainfi_tclMsgstatusStatus& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   status = coRef.status;
}
profile_mainfi_tclMsgstatusStatus& profile_mainfi_tclMsgstatusStatus::operator=(const profile_mainfi_tclMsgstatusStatus& coRef)
{
   if (this == &coRef) return *this;
   status = coRef.status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgstatusStatus::profile_mainfi_tclMsgstatusStatus()
:status()
 {}

tS32 profile_mainfi_tclMsgstatusStatus::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_STATUSSTATUS;
}


profile_mainfi_tclMsgstatusStatus::~profile_mainfi_tclMsgstatusStatus()
{}

tU32 profile_mainfi_tclMsgstatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgstatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> status);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgstatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << status);
   return oOut;
}

tBool profile_mainfi_tclMsgstatusStatus::operator==(const profile_mainfi_tclMsgstatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (status == roRef.status);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgcopyProfileUpReg::profile_mainfi_tclMsgcopyProfileUpReg()
 {}

tS32 profile_mainfi_tclMsgcopyProfileUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_COPYPROFILEUPREG;
}


profile_mainfi_tclMsgcopyProfileUpReg::~profile_mainfi_tclMsgcopyProfileUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgcopyProfileRelUpReg::profile_mainfi_tclMsgcopyProfileRelUpReg()
 {}

tS32 profile_mainfi_tclMsgcopyProfileRelUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_COPYPROFILERELUPREG;
}


profile_mainfi_tclMsgcopyProfileRelUpReg::~profile_mainfi_tclMsgcopyProfileRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgcopyProfileStatus::profile_mainfi_tclMsgcopyProfileStatus(const profile_mainfi_tclMsgcopyProfileStatus& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   sourceID = coRef.sourceID;
   destinationID = coRef.destinationID;
}
profile_mainfi_tclMsgcopyProfileStatus& profile_mainfi_tclMsgcopyProfileStatus::operator=(const profile_mainfi_tclMsgcopyProfileStatus& coRef)
{
   if (this == &coRef) return *this;
   sourceID = coRef.sourceID;
   destinationID = coRef.destinationID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgcopyProfileStatus::profile_mainfi_tclMsgcopyProfileStatus()
:sourceID(0)
,destinationID(0)
 {}

tS32 profile_mainfi_tclMsgcopyProfileStatus::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_COPYPROFILESTATUS;
}


profile_mainfi_tclMsgcopyProfileStatus::~profile_mainfi_tclMsgcopyProfileStatus()
{}

tU32 profile_mainfi_tclMsgcopyProfileStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& profile_mainfi_tclMsgcopyProfileStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sourceID);
   (tVoid) (oIn >> destinationID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgcopyProfileStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sourceID);
   (tVoid) (oOut << destinationID);
   return oOut;
}

tBool profile_mainfi_tclMsgcopyProfileStatus::operator==(const profile_mainfi_tclMsgcopyProfileStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sourceID == roRef.sourceID);
   bResult = bResult && (destinationID == roRef.destinationID);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgdeleteProfileUpReg::profile_mainfi_tclMsgdeleteProfileUpReg()
 {}

tS32 profile_mainfi_tclMsgdeleteProfileUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DELETEPROFILEUPREG;
}


profile_mainfi_tclMsgdeleteProfileUpReg::~profile_mainfi_tclMsgdeleteProfileUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgdeleteProfileRelUpReg::profile_mainfi_tclMsgdeleteProfileRelUpReg()
 {}

tS32 profile_mainfi_tclMsgdeleteProfileRelUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DELETEPROFILERELUPREG;
}


profile_mainfi_tclMsgdeleteProfileRelUpReg::~profile_mainfi_tclMsgdeleteProfileRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdeleteProfileStatus::profile_mainfi_tclMsgdeleteProfileStatus(const profile_mainfi_tclMsgdeleteProfileStatus& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   ProfileID = coRef.ProfileID;
}
profile_mainfi_tclMsgdeleteProfileStatus& profile_mainfi_tclMsgdeleteProfileStatus::operator=(const profile_mainfi_tclMsgdeleteProfileStatus& coRef)
{
   if (this == &coRef) return *this;
   ProfileID = coRef.ProfileID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdeleteProfileStatus::profile_mainfi_tclMsgdeleteProfileStatus()
:ProfileID(0)
 {}

tS32 profile_mainfi_tclMsgdeleteProfileStatus::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DELETEPROFILESTATUS;
}


profile_mainfi_tclMsgdeleteProfileStatus::~profile_mainfi_tclMsgdeleteProfileStatus()
{}

tU32 profile_mainfi_tclMsgdeleteProfileStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgdeleteProfileStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProfileID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdeleteProfileStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProfileID);
   return oOut;
}

tBool profile_mainfi_tclMsgdeleteProfileStatus::operator==(const profile_mainfi_tclMsgdeleteProfileStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProfileID == roRef.ProfileID);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgdataChangedUpReg::profile_mainfi_tclMsgdataChangedUpReg()
 {}

tS32 profile_mainfi_tclMsgdataChangedUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DATACHANGEDUPREG;
}


profile_mainfi_tclMsgdataChangedUpReg::~profile_mainfi_tclMsgdataChangedUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgdataChangedRelUpReg::profile_mainfi_tclMsgdataChangedRelUpReg()
 {}

tS32 profile_mainfi_tclMsgdataChangedRelUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DATACHANGEDRELUPREG;
}


profile_mainfi_tclMsgdataChangedRelUpReg::~profile_mainfi_tclMsgdataChangedRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgdataChangedStatus::profile_mainfi_tclMsgdataChangedStatus(const profile_mainfi_tclMsgdataChangedStatus& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   reason = coRef.reason;
}
profile_mainfi_tclMsgdataChangedStatus& profile_mainfi_tclMsgdataChangedStatus::operator=(const profile_mainfi_tclMsgdataChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   reason = coRef.reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgdataChangedStatus::profile_mainfi_tclMsgdataChangedStatus()
:reason()
 {}

tS32 profile_mainfi_tclMsgdataChangedStatus::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_DATACHANGEDSTATUS;
}


profile_mainfi_tclMsgdataChangedStatus::~profile_mainfi_tclMsgdataChangedStatus()
{}

tU32 profile_mainfi_tclMsgdataChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgdataChangedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> reason);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgdataChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << reason);
   return oOut;
}

tBool profile_mainfi_tclMsgdataChangedStatus::operator==(const profile_mainfi_tclMsgdataChangedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (reason == roRef.reason);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgcreateProfileUpReg::profile_mainfi_tclMsgcreateProfileUpReg()
 {}

tS32 profile_mainfi_tclMsgcreateProfileUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_CREATEPROFILEUPREG;
}


profile_mainfi_tclMsgcreateProfileUpReg::~profile_mainfi_tclMsgcreateProfileUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgcreateProfileRelUpReg::profile_mainfi_tclMsgcreateProfileRelUpReg()
 {}

tS32 profile_mainfi_tclMsgcreateProfileRelUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_CREATEPROFILERELUPREG;
}


profile_mainfi_tclMsgcreateProfileRelUpReg::~profile_mainfi_tclMsgcreateProfileRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgcreateProfileStatus::profile_mainfi_tclMsgcreateProfileStatus(const profile_mainfi_tclMsgcreateProfileStatus& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   ID = coRef.ID;
}
profile_mainfi_tclMsgcreateProfileStatus& profile_mainfi_tclMsgcreateProfileStatus::operator=(const profile_mainfi_tclMsgcreateProfileStatus& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgcreateProfileStatus::profile_mainfi_tclMsgcreateProfileStatus()
:ID(0)
 {}

tS32 profile_mainfi_tclMsgcreateProfileStatus::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_CREATEPROFILESTATUS;
}


profile_mainfi_tclMsgcreateProfileStatus::~profile_mainfi_tclMsgcreateProfileStatus()
{}

tU32 profile_mainfi_tclMsgcreateProfileStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& profile_mainfi_tclMsgcreateProfileStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgcreateProfileStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   return oOut;
}

tBool profile_mainfi_tclMsgcreateProfileStatus::operator==(const profile_mainfi_tclMsgcreateProfileStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   return bResult;
}

//=============================================================================

profile_mainfi_tclMsgprivacyStatusUpReg::profile_mainfi_tclMsgprivacyStatusUpReg()
 {}

tS32 profile_mainfi_tclMsgprivacyStatusUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSUPREG;
}


profile_mainfi_tclMsgprivacyStatusUpReg::~profile_mainfi_tclMsgprivacyStatusUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgprivacyStatusRelUpReg::profile_mainfi_tclMsgprivacyStatusRelUpReg()
 {}

tS32 profile_mainfi_tclMsgprivacyStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSRELUPREG;
}


profile_mainfi_tclMsgprivacyStatusRelUpReg::~profile_mainfi_tclMsgprivacyStatusRelUpReg()
{}

//=============================================================================

profile_mainfi_tclMsgprivacyStatusGet::profile_mainfi_tclMsgprivacyStatusGet()
 {}

tS32 profile_mainfi_tclMsgprivacyStatusGet::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSGET;
}


profile_mainfi_tclMsgprivacyStatusGet::~profile_mainfi_tclMsgprivacyStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
profile_mainfi_tclMsgprivacyStatusStatus::profile_mainfi_tclMsgprivacyStatusStatus(const profile_mainfi_tclMsgprivacyStatusStatus& coRef)
   : profile_mainfi_tclMsgBaseMessage(coRef)
{
   Privacy = coRef.Privacy;
}
profile_mainfi_tclMsgprivacyStatusStatus& profile_mainfi_tclMsgprivacyStatusStatus::operator=(const profile_mainfi_tclMsgprivacyStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   Privacy = coRef.Privacy;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

profile_mainfi_tclMsgprivacyStatusStatus::profile_mainfi_tclMsgprivacyStatusStatus()
:Privacy(0)
 {}

tS32 profile_mainfi_tclMsgprivacyStatusStatus::s32GetTypeId() const
{
   return (tS32) profile_mainfi_tclToken::EN_MSG_PRIVACYSTATUSSTATUS;
}


profile_mainfi_tclMsgprivacyStatusStatus::~profile_mainfi_tclMsgprivacyStatusStatus()
{}

tU32 profile_mainfi_tclMsgprivacyStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& profile_mainfi_tclMsgprivacyStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Privacy);
   return oIn;
}

fi_tclOutContext& profile_mainfi_tclMsgprivacyStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Privacy);
   return oOut;
}

tBool profile_mainfi_tclMsgprivacyStatusStatus::operator==(const profile_mainfi_tclMsgprivacyStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Privacy == roRef.Privacy);
   return bResult;
}

