/**
 * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        generated header for the configuration on the SCC.
 * @addtogroup   PDD generated header file
 * @{
 */
#ifndef PDD_CONFIG_SCC_H
#define PDD_CONFIG_SCC_H

#ifdef __cplusplus
extern "C" {
#endif
/************************************************************************
|defines and macros (scope: global)
|---------------------------------------------------------------------------*/
/* end table*/
#define PDD_SCC_TABLE_INFO_END          8
/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/
/******** for SCC access *********/
typedef struct
{
  tU8       u8Filename[PDD_SCC_MAX_SIZE_NAME];    
  tU32      u32PDUPort;
  tU8       u8KindSave; 
  tU8       u8KindPool;
  tU32      u32SizeData;
  tU32      u32Version;
}tsPddSccConfig;

/************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------*/
/* SCC configuration*/
static const tsPddSccConfig    vrPddSccConfig[PDD_SCC_TABLE_INFO_END] = 
{   /* name , PORT    , kind save, kind Pool , size, version*/
  { "VehFuncPDD" , PD_NET_PORT, PDD_SCC_STORE_AT_SHUTDOWN,DATAPOOL_SCC_IDENTITY_NUMBER_VEHFUNCPDD,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_SteeringPosition),DATAPOOL_SCC_VERSION_POOL_VEHFUNCPDD},
  { "DPCMD_AlignmentData" , PD_NET_PORT, PDD_SCC_STORE_DIRECT,DATAPOOL_SCC_IDENTITY_NUMBER_DPCMD_ALIGNMENTDATA,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_ADCRefPlusActualVoltageValues),DATAPOOL_SCC_VERSION_POOL_DPCMD_ALIGNMENTDATA},
  { "DPCMD_CMVariantCoding" , PD_NET_PORT, PDD_SCC_STORE_DIRECT,DATAPOOL_SCC_IDENTITY_NUMBER_DPCMD_CMVARIANTCODING,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_CMVariantCodingValue),DATAPOOL_SCC_VERSION_POOL_DPCMD_CMVARIANTCODING},
  { "DPCMC_PNM_DATA_SYNC_WITH_NVM" , PD_NET_PORT, PDD_SCC_STORE_DIRECT,DATAPOOL_SCC_IDENTITY_NUMBER_DPCMC_PNM_DATA_SYNC_WITH_NVM,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_NVMConfigurationValue),DATAPOOL_SCC_VERSION_POOL_DPCMC_PNM_DATA_SYNC_WITH_NVM},
  { "ThmDpPDD" , PD_NET_PORT, PDD_SCC_STORE_AT_SHUTDOWN,DATAPOOL_SCC_IDENTITY_NUMBER_THMDPPDD,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_PDD_THM_Version)+sizeof(TDataPoolScc_PDD_THM_SensorID_1)+sizeof(TDataPoolScc_PDD_THM_MaximumTemperature_1)+sizeof(TDataPoolScc_PDD_THM_MinimumTemperature_1)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperature_1)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_1)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_1)+sizeof(TDataPoolScc_PDD_THM_HighTemperature_1)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureHysteresis_1)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_1)+sizeof(TDataPoolScc_PDD_THM_LowTemperature_1)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureHysteresis_1)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_1)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperature_1)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_1)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_1)+sizeof(TDataPoolScc_PDD_THM_SensorID_2)+sizeof(TDataPoolScc_PDD_THM_MaximumTemperature_2)+sizeof(TDataPoolScc_PDD_THM_MinimumTemperature_2)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperature_2)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_2)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_2)+sizeof(TDataPoolScc_PDD_THM_HighTemperature_2)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureHysteresis_2)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_2)+sizeof(TDataPoolScc_PDD_THM_LowTemperature_2)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureHysteresis_2)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_2)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperature_2)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_2)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_2)+sizeof(TDataPoolScc_PDD_THM_SensorID_3)+sizeof(TDataPoolScc_PDD_THM_MaximumTemperature_3)+sizeof(TDataPoolScc_PDD_THM_MinimumTemperature_3)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperature_3)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_3)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_3)+sizeof(TDataPoolScc_PDD_THM_HighTemperature_3)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureHysteresis_3)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_3)+sizeof(TDataPoolScc_PDD_THM_LowTemperature_3)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureHysteresis_3)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_3)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperature_3)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_3)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_3)+sizeof(TDataPoolScc_PDD_THM_SensorID_4)+sizeof(TDataPoolScc_PDD_THM_MaximumTemperature_4)+sizeof(TDataPoolScc_PDD_THM_MinimumTemperature_4)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperature_4)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_4)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_4)+sizeof(TDataPoolScc_PDD_THM_HighTemperature_4)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureHysteresis_4)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_4)+sizeof(TDataPoolScc_PDD_THM_LowTemperature_4)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureHysteresis_4)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_4)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperature_4)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_4)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_4)+sizeof(TDataPoolScc_PDD_THM_SensorID_5)+sizeof(TDataPoolScc_PDD_THM_MaximumTemperature_5)+sizeof(TDataPoolScc_PDD_THM_MinimumTemperature_5)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperature_5)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureHysteresis_5)+sizeof(TDataPoolScc_PDD_THM_CriticalHighTemperatureTimeDelay_5)+sizeof(TDataPoolScc_PDD_THM_HighTemperature_5)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureHysteresis_5)+sizeof(TDataPoolScc_PDD_THM_HighTemperatureTimeDelay_5)+sizeof(TDataPoolScc_PDD_THM_LowTemperature_5)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureHysteresis_5)+sizeof(TDataPoolScc_PDD_THM_LowTemperatureTimeDelay_5)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperature_5)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureHysteresis_5)+sizeof(TDataPoolScc_PDD_THM_CriticalLowTemperatureTimeDelay_5)+sizeof(TDataPoolScc_PDD_THM_RESERVED),DATAPOOL_SCC_VERSION_POOL_THMDPPDD},
  { "DimmingDpPDD" , PD_NET_PORT, PDD_SCC_STORE_AT_SHUTDOWN,DATAPOOL_SCC_IDENTITY_NUMBER_DIMMINGDPPDD,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_BRIGTHNESS_CURVE_HMI_NIGHT)+sizeof(TDataPoolScc_BRIGTHNESS_CURVE_HMI_DAY)+sizeof(TDataPoolScc_DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY)+sizeof(TDataPoolScc_KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY)+sizeof(TDataPoolScc_BRIGTHNESS_NO_OF_HMI_OFFSET)+sizeof(TDataPoolScc_NUMBER_OF_KEYS)+sizeof(TDataPoolScc_HIGH_TEMPERATURE)+sizeof(TDataPoolScc_CRITICAL_TEMPERATURE)+sizeof(TDataPoolScc_LOW_TEMPERATURE)+sizeof(TDataPoolScc_TEMP_HYSTERESIS)+sizeof(TDataPoolScc_TEMP_COMPENSATION_PWM_MIN)+sizeof(TDataPoolScc_KEYB_LED_CALIBRATION_VALUE)+sizeof(TDataPoolScc_BRANDNAME)+sizeof(TDataPoolScc_DISPLAY_TYPE)+sizeof(TDataPoolScc_DIMMING_COCKPIT_STRATEGY)+sizeof(TDataPoolScc_KEY_BRIGHTNESS_NUMOF_OFFSETS)+sizeof(TDataPoolScc_DAMPING_STRATEGY)+sizeof(TDataPoolScc_DAMPING_SAMPLING_TIMETE)+sizeof(TDataPoolScc_DAMPING_CONSTANTK)+sizeof(TDataPoolScc_DAMPING_CONSTANTJ)+sizeof(TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY)+sizeof(TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT)+sizeof(TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT)+sizeof(TDataPoolScc_BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON)+sizeof(TDataPoolScc_BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF)+sizeof(TDataPoolScc_BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON)+sizeof(TDataPoolScc_DAY_NIGHT_DELAY)+sizeof(TDataPoolScc_DIMMING_ARCHITECTURE),DATAPOOL_SCC_VERSION_POOL_DIMMINGDPPDD},
  { "InputDP" , PD_NET_PORT, PDD_SCC_STORE_DIRECT,DATAPOOL_SCC_IDENTITY_NUMBER_INPUTDP,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_KeyMatrixData)+sizeof(TDataPoolScc_SystemKeyData)+sizeof(TDataPoolScc_CarBusData)+sizeof(TDataPoolScc_ITCommanderData)+sizeof(TDataPoolScc_RSCData),DATAPOOL_SCC_VERSION_POOL_INPUTDP},
  { "CsmDpPDD" , PD_NET_PORT, PDD_SCC_STORE_DIRECT,DATAPOOL_SCC_IDENTITY_NUMBER_CSMDPPDD,sizeof(TPddScc_Header)+sizeof(TDataPoolScc_SlotNr)+sizeof(TDataPoolScc_SteeringWheelType)+sizeof(TDataPoolScc_VoiceRec)+sizeof(TDataPoolScc_FuelType)+sizeof(TDataPoolScc_CameraSystem)+sizeof(TDataPoolScc_IpaHfp)+sizeof(TDataPoolScc_Sonar)+sizeof(TDataPoolScc_AntiTheft)+sizeof(TDataPoolScc_AnticipatoryLine)+sizeof(TDataPoolScc_SteeringMsg)+sizeof(TDataPoolScc_TrafficSignRec)+sizeof(TDataPoolScc_NaviFunc)+sizeof(TDataPoolScc_RCSType)+sizeof(TDataPoolScc_ITCommanderType)+sizeof(TDataPoolScc_VCANMCANGateway)+sizeof(TDataPoolScc_FuelConsumptionInfo)+sizeof(TDataPoolScc_TPMS)+sizeof(TDataPoolScc_VDC)+sizeof(TDataPoolScc_AdFunction)+sizeof(TDataPoolScc_VehicleSetting)+sizeof(TDataPoolScc_HudSetting)+sizeof(TDataPoolScc_HvacType)+sizeof(TDataPoolScc_DigitalAssi)+sizeof(TDataPoolScc_SendCountryInfo),DATAPOOL_SCC_VERSION_POOL_CSMDPPDD}
};
 /************************************************************************
|function prototypes (scope: global)
|-----------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#else
#error pdd_config_scc.h included several times
#endif
