/**
 * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
 *               The reproduction, distribution and utilization of this file as well as the
 *               communication of its contents to others without express authorization is prohibited.
 *               Offenders will be held liable for the payment of damages.
 *               All rights reserved in the event of the grant of a patent, utility model or design.
 * @brief        generated header for the configuration on the nor user access.
 * @addtogroup   PDD generated header file
 * @{
 */
#ifndef PDD_CONFIG_NOR_USER_H
#define PDD_CONFIG_NOR_USER_H

#ifdef __cplusplus
extern "C" {
#endif
/************************************************************************
|defines and macros (scope: global)
|-----------------------------------------------------------------------*/
#ifdef PDD_UNIT_TEST
#define PDD_NOR_USER_DATASTREAM_NAME_KDS               "kds_data" 
#define PDD_NOR_USER_DATASTREAM_NAME_CONFIG            "config_data" 
#define PDD_NOR_USER_CONFIG_NUMBER_DATASTREAM          2
#else
#define PDD_NOR_USER_DATASTREAM_NAME_KDS               "kds_data" 
#define PDD_NOR_USER_DATASTREAM_NAME_VEHFUNCPDD     "VehFuncPDD" 
#define PDD_NOR_USER_DATASTREAM_NAME_DPCMD_ALIGNMENTDATA     "DPCMD_AlignmentData" 
#define PDD_NOR_USER_DATASTREAM_NAME_DPCMD_CMVARIANTCODING     "DPCMD_CMVariantCoding" 
#define PDD_NOR_USER_DATASTREAM_NAME_DPCMC_PNM_DATA_SYNC_WITH_NVM     "DPCMC_PNM_DATA_SYNC_WITH_NVM" 
#define PDD_NOR_USER_DATASTREAM_NAME_PDDTRACELEVEL     "PddTraceLevel" 
#define PDD_NOR_USER_DATASTREAM_NAME_THMDPPDD     "ThmDpPDD" 
#define PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGCSC     "EarlyConfigCSC" 
#define PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGDISPLAY     "EarlyConfigDisplay" 
#define PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGRTCDRIVER     "EarlyConfigRTCDriver" 
#define PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGTOUCHDRIVER     "EarlyConfigTouchDriver" 
#define PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGTWODISPLAYS     "EarlyConfigTwoDisplays" 
#define PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGTWOTOUCHDRIVER     "EarlyConfigTwoTouchDriver" 
#define PDD_NOR_USER_DATASTREAM_NAME_DIMMINGDPPDD     "DimmingDpPDD" 
#define PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGLAYERMANAGER     "EarlyConfigLayerManager" 
#define PDD_NOR_USER_DATASTREAM_NAME_DATASET_VD_EARLY_CONFIG     "DATASET_VD_EARLY_CONFIG" 
#define PDD_NOR_USER_DATASTREAM_NAME_DATASET_VD_EARLY_FORCE_CONFIG     "DATASET_VD_EARLY_FORCE_CONFIG" 
#define PDD_NOR_USER_DATASTREAM_NAME_INPUTDP     "InputDP" 
#define PDD_NOR_USER_DATASTREAM_NAME_CSMEARLYNORCONFIG     "CsmEarlyNorConfig" 
#define PDD_NOR_USER_DATASTREAM_NAME_CSMDPPDD     "CsmDpPDD" 
#define PDD_NOR_USER_DATASTREAM_NAME_DEFAULT     "Default" 
#define PDD_NOR_USER_CONFIG_NUMBER_DATASTREAM          21 
#endif
#if PDD_NOR_USER_CONFIG_NUMBER_DATASTREAM
/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/
/******** for NOR User access *********/
typedef struct
{
  tU8               u8DataStreamName[PDD_NOR_MAX_SIZE_NAME];    
  tU32              u32Version;
  tePddLocation     eLocation;
}tsPddNorUserConfig;
/************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------*/
static  const tsPddNorUserConfig    vrPddNorUserConfig[PDD_NOR_USER_CONFIG_NUMBER_DATASTREAM] =
{   /* name              */
  #ifdef PDD_UNIT_TEST
  {PDD_NOR_USER_DATASTREAM_NAME_KDS,0x00000206,PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_CONFIG,0x00000001,PDD_LOCATION_NOR_USER}
  #else
  {PDD_NOR_USER_DATASTREAM_NAME_KDS, 0x00000206, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_VEHFUNCPDD, 0x0001, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_DPCMD_ALIGNMENTDATA, 0x0001, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_DPCMD_CMVARIANTCODING, 0x0001, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_DPCMC_PNM_DATA_SYNC_WITH_NVM, 0x0000, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_PDDTRACELEVEL, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_THMDPPDD, 0x0003, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGCSC, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGDISPLAY, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGRTCDRIVER, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGTOUCHDRIVER, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGTWODISPLAYS, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGTWOTOUCHDRIVER, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_DIMMINGDPPDD, 0x0002, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_EARLYCONFIGLAYERMANAGER, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_DATASET_VD_EARLY_CONFIG, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_DATASET_VD_EARLY_FORCE_CONFIG, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_INPUTDP, 0x0002, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_CSMEARLYNORCONFIG, 0x00000001, PDD_LOCATION_NOR_USER},
  {PDD_NOR_USER_DATASTREAM_NAME_CSMDPPDD, 0x0001, PDD_LOCATION_SCC},
  {PDD_NOR_USER_DATASTREAM_NAME_DEFAULT, 0x0001, PDD_LOCATION_NOR_USER}
#endif
};

#endif
/************************************************************************
|typedefs and struct defs (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
| variable declaration (scope: global)
|-----------------------------------------------------------------------*/

/************************************************************************
|function prototypes (scope: global)
|-----------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif
#else
#error pdd_config_nor_user.h included several times
#endif
