/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "mplay_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 mplay_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 mplay_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 mplay_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 mplay_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 mplay_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 mplay_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 mplay_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 mplay_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 mplay_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 mplay_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 mplay_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& mplay_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 mplay_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& mplay_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 mplay_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid mplay_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tclString::~mplay_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

mplay_fi_tclString& mplay_fi_tclString::operator=(const mplay_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

mplay_fi_tclString::mplay_fi_tclString(const mplay_fi_tclString& coRef):mplay_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& mplay_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool mplay_fi_tclString::operator==(const mplay_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 mplay_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
mplay_fi_tclString& mplay_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
mplay_fi_tclString::mplay_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool mplay_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

mplay_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

mplay_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool mplay_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar mplay_FI_C_U8_NULLCHAR = '\0';

tChar* mplay_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* mplay_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* mplay_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& mplay_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return mplay_FI_C_U8_NULLCHAR;
}

tChar& mplay_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return mplay_FI_C_U8_NULLCHAR;
}

tChar& mplay_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return mplay_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool mplay_fi_tclString::bSet(const mplay_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool mplay_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString mplay_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& mplay_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool mplay_fi_tclList::operator==(const mplay_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 mplay_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& mplay_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid mplay_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tclMultiLanguageString::~mplay_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

mplay_fi_tclMultiLanguageString& mplay_fi_tclMultiLanguageString::operator=(const mplay_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

mplay_fi_tclMultiLanguageString::mplay_fi_tclMultiLanguageString(const mplay_fi_tclMultiLanguageString& coRef):mplay_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& mplay_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool mplay_fi_tclMultiLanguageString::operator==(const mplay_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 mplay_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
mplay_fi_tclMultiLanguageString& mplay_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
mplay_fi_tclMultiLanguageString::mplay_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool mplay_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

mplay_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

mplay_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool mplay_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* mplay_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* mplay_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* mplay_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& mplay_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return mplay_FI_C_U8_NULLCHAR;
}

tChar& mplay_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return mplay_FI_C_U8_NULLCHAR;
}

tChar& mplay_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return mplay_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool mplay_fi_tclMultiLanguageString::bSet(const mplay_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool mplay_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString mplay_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_BinContainer::mplay_fi_tcl_BinContainer(const mplay_fi_tcl_BinContainer& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
mplay_fi_tcl_BinContainer& mplay_fi_tcl_BinContainer::operator=(const mplay_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

mplay_fi_tcl_BinContainer::mplay_fi_tcl_BinContainer()

 {}

tS32 mplay_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_BINCONTAINER;
}


mplay_fi_tcl_BinContainer::~mplay_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& mplay_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_BinContainer::operator==(const mplay_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_ShortStream::mplay_fi_tcl_ShortStream(const mplay_fi_tcl_ShortStream& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u8Data = coRef.u8Data;
}
mplay_fi_tcl_ShortStream& mplay_fi_tcl_ShortStream::operator=(const mplay_fi_tcl_ShortStream& coRef)
{
   if (this == &coRef) return *this;
   u8Data = coRef.u8Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_ShortStream::vDestroy()
{
   {
   u8Data.clear();
   }
}

mplay_fi_tcl_ShortStream::mplay_fi_tcl_ShortStream()

 {}

tS32 mplay_fi_tcl_ShortStream::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_SHORTSTREAM;
}


mplay_fi_tcl_ShortStream::~mplay_fi_tcl_ShortStream()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_ShortStream::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(u8Data.size()*1);
}

fi_tclInContext& mplay_fi_tcl_ShortStream::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u8Data.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u8Data[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_ShortStream::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)u8Data.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u8Data.size(); ++u32Idx)
         (tVoid) (oOut << u8Data[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_ShortStream::operator==(const mplay_fi_tcl_ShortStream& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (u8Data.size() == roRef.u8Data.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u8Data.size()); ++u32Idx)
            bResult = bResult && (u8Data[u32Idx] == roRef.u8Data[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult():enType(FI_EN_ACCEPTED) {}

tS32 mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_EJECTOPTICALDISC_METHODRESULT;
}


mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::~mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult()
{}

tU32 mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_SlotStateOpticalDiscType::mplay_fi_tcl_e8_SlotStateOpticalDiscType():enType(FI_EN_INITIALISING) {}

tS32 mplay_fi_tcl_e8_SlotStateOpticalDiscType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_SLOTSTATEOPTICALDISCTYPE;
}


mplay_fi_tcl_e8_SlotStateOpticalDiscType::~mplay_fi_tcl_e8_SlotStateOpticalDiscType()
{}

tU32 mplay_fi_tcl_e8_SlotStateOpticalDiscType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_SlotStateOpticalDiscType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_SlotStateOpticalDiscType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_EjectParmType::mplay_fi_tcl_e8_EjectParmType():enType(FI_EN_E8CMD_EJECT) {}

tS32 mplay_fi_tcl_e8_EjectParmType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_EJECTPARMTYPE;
}


mplay_fi_tcl_e8_EjectParmType::~mplay_fi_tcl_e8_EjectParmType()
{}

tU32 mplay_fi_tcl_e8_EjectParmType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_EjectParmType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_EjectParmType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8DeviceState::mplay_fi_tcl_e8DeviceState():enType(FI_EN_MMGR_DEVICE_NOT_READY) {}

tS32 mplay_fi_tcl_e8DeviceState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8DEVICESTATE;
}


mplay_fi_tcl_e8DeviceState::~mplay_fi_tcl_e8DeviceState()
{}

tU32 mplay_fi_tcl_e8DeviceState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8DeviceState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8DeviceState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_e8_CDInfo::mplay_fi_tcl_e8_CDInfo(const mplay_fi_tcl_e8_CDInfo& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   DriveVersion = coRef.DriveVersion;
   e8DeviceState = coRef.e8DeviceState;
}
mplay_fi_tcl_e8_CDInfo& mplay_fi_tcl_e8_CDInfo::operator=(const mplay_fi_tcl_e8_CDInfo& coRef)
{
   if (this == &coRef) return *this;
   DriveVersion = coRef.DriveVersion;
   e8DeviceState = coRef.e8DeviceState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_e8_CDInfo::vDestroy()
{
   DriveVersion.vDestroy();
}

mplay_fi_tcl_e8_CDInfo::mplay_fi_tcl_e8_CDInfo()
:DriveVersion()
,e8DeviceState()
 {}

tS32 mplay_fi_tcl_e8_CDInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_CDINFO;
}


mplay_fi_tcl_e8_CDInfo::~mplay_fi_tcl_e8_CDInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_e8_CDInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DriveVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_e8_CDInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveVersion);
   (tVoid) (oIn >> e8DeviceState);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_CDInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveVersion);
   (tVoid) (oOut << e8DeviceState);
   return oOut;
}

tBool mplay_fi_tcl_e8_CDInfo::operator==(const mplay_fi_tcl_e8_CDInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveVersion == roRef.DriveVersion);
   bResult = bResult && (e8DeviceState == roRef.e8DeviceState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DVDCommandStatus::mplay_fi_tcl_e8_DVDCommandStatus():enType(FI_EN_E8INVALID_INPUT) {}

tS32 mplay_fi_tcl_e8_DVDCommandStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DVDCOMMANDSTATUS;
}


mplay_fi_tcl_e8_DVDCommandStatus::~mplay_fi_tcl_e8_DVDCommandStatus()
{}

tU32 mplay_fi_tcl_e8_DVDCommandStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DVDCommandStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DVDCommandStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDVDDiscType::mplay_fi_tcl_e8_MDVDDiscType():enType(FI_EN_E8NON_DISC_DATA) {}

tS32 mplay_fi_tcl_e8_MDVDDiscType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDVDDISCTYPE;
}


mplay_fi_tcl_e8_MDVDDiscType::~mplay_fi_tcl_e8_MDVDDiscType()
{}

tU32 mplay_fi_tcl_e8_MDVDDiscType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDVDDiscType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDVDDiscType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDVDDriveMode::mplay_fi_tcl_e8_MDVDDriveMode():enType(FI_EN_E8MASS_STORAGE_MODE) {}

tS32 mplay_fi_tcl_e8_MDVDDriveMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDVDDRIVEMODE;
}


mplay_fi_tcl_e8_MDVDDriveMode::~mplay_fi_tcl_e8_MDVDDriveMode()
{}

tU32 mplay_fi_tcl_e8_MDVDDriveMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDVDDriveMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDVDDriveMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MAngle::mplay_fi_tcl_e8_MAngle():enType(FI_EN_E8DVD_ANGLE_1) {}

tS32 mplay_fi_tcl_e8_MAngle::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MANGLE;
}


mplay_fi_tcl_e8_MAngle::~mplay_fi_tcl_e8_MAngle()
{}

tU32 mplay_fi_tcl_e8_MAngle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MAngle::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MAngle::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MAudioOutputNumber::mplay_fi_tcl_e8_MAudioOutputNumber():enType(FI_EN_E8DVD_AUDIO_NUMBER_1) {}

tS32 mplay_fi_tcl_e8_MAudioOutputNumber::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MAUDIOOUTPUTNUMBER;
}


mplay_fi_tcl_e8_MAudioOutputNumber::~mplay_fi_tcl_e8_MAudioOutputNumber()
{}

tU32 mplay_fi_tcl_e8_MAudioOutputNumber::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MAudioOutputNumber::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MAudioOutputNumber::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MChannelAssignment::mplay_fi_tcl_e8_MChannelAssignment():enType(FI_EN_E8DVD_AUDIO_0_0) {}

tS32 mplay_fi_tcl_e8_MChannelAssignment::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MCHANNELASSIGNMENT;
}


mplay_fi_tcl_e8_MChannelAssignment::~mplay_fi_tcl_e8_MChannelAssignment()
{}

tU32 mplay_fi_tcl_e8_MChannelAssignment::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MChannelAssignment::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MChannelAssignment::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MCMSkipValue::mplay_fi_tcl_e8_MCMSkipValue():enType(FI_EN_E8FORWARD_15) {}

tS32 mplay_fi_tcl_e8_MCMSkipValue::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MCMSKIPVALUE;
}


mplay_fi_tcl_e8_MCMSkipValue::~mplay_fi_tcl_e8_MCMSkipValue()
{}

tU32 mplay_fi_tcl_e8_MCMSkipValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MCMSkipValue::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MCMSkipValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDiscError::mplay_fi_tcl_e8_MDiscError():enType(FI_EN_E8DISC_HOT_ERROR) {}

tS32 mplay_fi_tcl_e8_MDiscError::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDISCERROR;
}


mplay_fi_tcl_e8_MDiscError::~mplay_fi_tcl_e8_MDiscError()
{}

tU32 mplay_fi_tcl_e8_MDiscError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDiscError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDiscError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDiscMechanicalInfo::mplay_fi_tcl_e8_MDiscMechanicalInfo():enType(FI_EN_E8DISC_CHUCKING) {}

tS32 mplay_fi_tcl_e8_MDiscMechanicalInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDISCMECHANICALINFO;
}


mplay_fi_tcl_e8_MDiscMechanicalInfo::~mplay_fi_tcl_e8_MDiscMechanicalInfo()
{}

tU32 mplay_fi_tcl_e8_MDiscMechanicalInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDiscMechanicalInfo::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDiscMechanicalInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDiscOperation::mplay_fi_tcl_e8_MDiscOperation():enType(FI_EN_E8DISC_EJECT) {}

tS32 mplay_fi_tcl_e8_MDiscOperation::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDISCOPERATION;
}


mplay_fi_tcl_e8_MDiscOperation::~mplay_fi_tcl_e8_MDiscOperation()
{}

tU32 mplay_fi_tcl_e8_MDiscOperation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDiscOperation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDiscOperation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDiscType::mplay_fi_tcl_e8_MDiscType():enType(FI_EN_E8AUDIO_CD_DISC) {}

tS32 mplay_fi_tcl_e8_MDiscType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDISCTYPE;
}


mplay_fi_tcl_e8_MDiscType::~mplay_fi_tcl_e8_MDiscType()
{}

tU32 mplay_fi_tcl_e8_MDiscType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDiscType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDiscType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDisplayMode::mplay_fi_tcl_e8_MDisplayMode():enType(FI_EN_E8DISPLAY_MODE_16_9) {}

tS32 mplay_fi_tcl_e8_MDisplayMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDISPLAYMODE;
}


mplay_fi_tcl_e8_MDisplayMode::~mplay_fi_tcl_e8_MDisplayMode()
{}

tU32 mplay_fi_tcl_e8_MDisplayMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDisplayMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDisplayMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MDRCSetting::mplay_fi_tcl_e8_MDRCSetting():enType(FI_EN_E8DRC_BOOST) {}

tS32 mplay_fi_tcl_e8_MDRCSetting::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MDRCSETTING;
}


mplay_fi_tcl_e8_MDRCSetting::~mplay_fi_tcl_e8_MDRCSetting()
{}

tU32 mplay_fi_tcl_e8_MDRCSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MDRCSetting::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MDRCSetting::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MGeneralSelectionType::mplay_fi_tcl_e8_MGeneralSelectionType():enType(FI_EN_E8SEL_CYCLIC) {}

tS32 mplay_fi_tcl_e8_MGeneralSelectionType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MGENERALSELECTIONTYPE;
}


mplay_fi_tcl_e8_MGeneralSelectionType::~mplay_fi_tcl_e8_MGeneralSelectionType()
{}

tU32 mplay_fi_tcl_e8_MGeneralSelectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MGeneralSelectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MGeneralSelectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MMenuControlData::mplay_fi_tcl_e8_MMenuControlData():enType(FI_EN_E8MENU) {}

tS32 mplay_fi_tcl_e8_MMenuControlData::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MMENUCONTROLDATA;
}


mplay_fi_tcl_e8_MMenuControlData::~mplay_fi_tcl_e8_MMenuControlData()
{}

tU32 mplay_fi_tcl_e8_MMenuControlData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MMenuControlData::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MMenuControlData::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MNavigationKey::mplay_fi_tcl_e8_MNavigationKey():enType(FI_EN_E8NAVIGATE_ENTER) {}

tS32 mplay_fi_tcl_e8_MNavigationKey::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MNAVIGATIONKEY;
}


mplay_fi_tcl_e8_MNavigationKey::~mplay_fi_tcl_e8_MNavigationKey()
{}

tU32 mplay_fi_tcl_e8_MNavigationKey::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MNavigationKey::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MNavigationKey::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayAction::mplay_fi_tcl_e8_MPlayAction():enType(FI_EN_E8PBA_PLAY) {}

tS32 mplay_fi_tcl_e8_MPlayAction::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYACTION;
}


mplay_fi_tcl_e8_MPlayAction::~mplay_fi_tcl_e8_MPlayAction()
{}

tU32 mplay_fi_tcl_e8_MPlayAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayAudioChannelFormat::mplay_fi_tcl_e8_MPlayAudioChannelFormat():enType(FI_EN_E8ACF_MONO) {}

tS32 mplay_fi_tcl_e8_MPlayAudioChannelFormat::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYAUDIOCHANNELFORMAT;
}


mplay_fi_tcl_e8_MPlayAudioChannelFormat::~mplay_fi_tcl_e8_MPlayAudioChannelFormat()
{}

tU32 mplay_fi_tcl_e8_MPlayAudioChannelFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayAudioChannelFormat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayAudioChannelFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayAvailabilityReason::mplay_fi_tcl_e8_MPlayAvailabilityReason():enType(FI_EN_E8AR_NEW_MEDIA) {}

tS32 mplay_fi_tcl_e8_MPlayAvailabilityReason::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYAVAILABILITYREASON;
}


mplay_fi_tcl_e8_MPlayAvailabilityReason::~mplay_fi_tcl_e8_MPlayAvailabilityReason()
{}

tU32 mplay_fi_tcl_e8_MPlayAvailabilityReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayAvailabilityReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayAvailabilityReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlaybackDirection::mplay_fi_tcl_e8_MPlaybackDirection():enType(FI_EN_E8PBK_BACKWARD) {}

tS32 mplay_fi_tcl_e8_MPlaybackDirection::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYBACKDIRECTION;
}


mplay_fi_tcl_e8_MPlaybackDirection::~mplay_fi_tcl_e8_MPlaybackDirection()
{}

tU32 mplay_fi_tcl_e8_MPlaybackDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlaybackDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlaybackDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlaybackSpeed::mplay_fi_tcl_e8_MPlaybackSpeed():enType(FI_EN_E8PBK_SPEED_0_2X) {}

tS32 mplay_fi_tcl_e8_MPlaybackSpeed::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYBACKSPEED;
}


mplay_fi_tcl_e8_MPlaybackSpeed::~mplay_fi_tcl_e8_MPlaybackSpeed()
{}

tU32 mplay_fi_tcl_e8_MPlaybackSpeed::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlaybackSpeed::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlaybackSpeed::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayCategoryType::mplay_fi_tcl_e8_MPlayCategoryType():enType(FI_EN_E8CTY_ALBUM) {}

tS32 mplay_fi_tcl_e8_MPlayCategoryType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYCATEGORYTYPE;
}


mplay_fi_tcl_e8_MPlayCategoryType::~mplay_fi_tcl_e8_MPlayCategoryType()
{}

tU32 mplay_fi_tcl_e8_MPlayCategoryType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayCategoryType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayCategoryType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayChange::mplay_fi_tcl_e8_MPlayChange():enType(FI_EN_E8LCH_CONTENT_CHANGED) {}

tS32 mplay_fi_tcl_e8_MPlayChange::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYCHANGE;
}


mplay_fi_tcl_e8_MPlayChange::~mplay_fi_tcl_e8_MPlayChange()
{}

tU32 mplay_fi_tcl_e8_MPlayChange::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayChange::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayChange::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayConnectionState::mplay_fi_tcl_e8_MPlayConnectionState():enType(FI_EN_E8CS_ATTACHED) {}

tS32 mplay_fi_tcl_e8_MPlayConnectionState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYCONNECTIONSTATE;
}


mplay_fi_tcl_e8_MPlayConnectionState::~mplay_fi_tcl_e8_MPlayConnectionState()
{}

tU32 mplay_fi_tcl_e8_MPlayConnectionState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayConnectionState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayConnectionState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayConnectionType::mplay_fi_tcl_e8_MPlayConnectionType():enType(FI_EN_E8DCT_BLUETOOTH) {}

tS32 mplay_fi_tcl_e8_MPlayConnectionType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYCONNECTIONTYPE;
}


mplay_fi_tcl_e8_MPlayConnectionType::~mplay_fi_tcl_e8_MPlayConnectionType()
{}

tU32 mplay_fi_tcl_e8_MPlayConnectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayConnectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayConnectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult():enType(FI_EN_E8DATABASE_ERROR) {}

tS32 mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYDELETEMEDIACONTENTTASKRESULT;
}


mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::~mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult()
{}

tU32 mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayDeleteMediaContentTaskResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayDeviceControlSupport::mplay_fi_tcl_e8_MPlayDeviceControlSupport():enType(FI_EN_E8DCS_BROWSING) {}

tS32 mplay_fi_tcl_e8_MPlayDeviceControlSupport::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYDEVICECONTROLSUPPORT;
}


mplay_fi_tcl_e8_MPlayDeviceControlSupport::~mplay_fi_tcl_e8_MPlayDeviceControlSupport()
{}

tU32 mplay_fi_tcl_e8_MPlayDeviceControlSupport::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayDeviceControlSupport::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayDeviceControlSupport::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayDeviceIndexedState::mplay_fi_tcl_e8_MPlayDeviceIndexedState():enType(FI_EN_E8IDS_COMPLETE) {}

tS32 mplay_fi_tcl_e8_MPlayDeviceIndexedState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYDEVICEINDEXEDSTATE;
}


mplay_fi_tcl_e8_MPlayDeviceIndexedState::~mplay_fi_tcl_e8_MPlayDeviceIndexedState()
{}

tU32 mplay_fi_tcl_e8_MPlayDeviceIndexedState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayDeviceIndexedState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayDeviceIndexedState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayDeviceRippingState::mplay_fi_tcl_e8_MPlayDeviceRippingState():enType(FI_EN_E8RS_COMPLETE) {}

tS32 mplay_fi_tcl_e8_MPlayDeviceRippingState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYDEVICERIPPINGSTATE;
}


mplay_fi_tcl_e8_MPlayDeviceRippingState::~mplay_fi_tcl_e8_MPlayDeviceRippingState()
{}

tU32 mplay_fi_tcl_e8_MPlayDeviceRippingState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayDeviceRippingState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayDeviceRippingState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayDeviceStatus::mplay_fi_tcl_e8_MPlayDeviceStatus():enType(FI_EN_E8DS_COMMUNICATION_ERROR) {}

tS32 mplay_fi_tcl_e8_MPlayDeviceStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYDEVICESTATUS;
}


mplay_fi_tcl_e8_MPlayDeviceStatus::~mplay_fi_tcl_e8_MPlayDeviceStatus()
{}

tU32 mplay_fi_tcl_e8_MPlayDeviceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayDeviceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayDeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayDeviceType::mplay_fi_tcl_e8_MPlayDeviceType():enType(FI_EN_E8DTY_BLUETOOTH) {}

tS32 mplay_fi_tcl_e8_MPlayDeviceType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYDEVICETYPE;
}


mplay_fi_tcl_e8_MPlayDeviceType::~mplay_fi_tcl_e8_MPlayDeviceType()
{}

tU32 mplay_fi_tcl_e8_MPlayDeviceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayDeviceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayDeviceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayDisconnectReason::mplay_fi_tcl_e8_MPlayDisconnectReason():enType(FI_EN_E8DR_AUTOMATIC) {}

tS32 mplay_fi_tcl_e8_MPlayDisconnectReason::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYDISCONNECTREASON;
}


mplay_fi_tcl_e8_MPlayDisconnectReason::~mplay_fi_tcl_e8_MPlayDisconnectReason()
{}

tU32 mplay_fi_tcl_e8_MPlayDisconnectReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayDisconnectReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayDisconnectReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult():enType(FI_EN_E8DATABASE_ERROR) {}

tS32 mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYEDITMETADATATASKRESULT;
}


mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::~mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult()
{}

tU32 mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayEditMetaDataTaskResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayEncodingQuality::mplay_fi_tcl_e8_MPlayEncodingQuality():enType(FI_EN_E8CD_QUALIY) {}

tS32 mplay_fi_tcl_e8_MPlayEncodingQuality::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYENCODINGQUALITY;
}


mplay_fi_tcl_e8_MPlayEncodingQuality::~mplay_fi_tcl_e8_MPlayEncodingQuality()
{}

tU32 mplay_fi_tcl_e8_MPlayEncodingQuality::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayEncodingQuality::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayEncodingQuality::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayFileFormat::mplay_fi_tcl_e8_MPlayFileFormat():enType(FI_EN_E8FFT_3G2) {}

tS32 mplay_fi_tcl_e8_MPlayFileFormat::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYFILEFORMAT;
}


mplay_fi_tcl_e8_MPlayFileFormat::~mplay_fi_tcl_e8_MPlayFileFormat()
{}

tU32 mplay_fi_tcl_e8_MPlayFileFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayFileFormat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayFileFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayFileSystemType::mplay_fi_tcl_e8_MPlayFileSystemType():enType(FI_EN_E8FSTY_EXFAT) {}

tS32 mplay_fi_tcl_e8_MPlayFileSystemType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYFILESYSTEMTYPE;
}


mplay_fi_tcl_e8_MPlayFileSystemType::~mplay_fi_tcl_e8_MPlayFileSystemType()
{}

tU32 mplay_fi_tcl_e8_MPlayFileSystemType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayFileSystemType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayFileSystemType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayFileType::mplay_fi_tcl_e8_MPlayFileType():enType(FI_EN_E8FT_AUDIO) {}

tS32 mplay_fi_tcl_e8_MPlayFileType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYFILETYPE;
}


mplay_fi_tcl_e8_MPlayFileType::~mplay_fi_tcl_e8_MPlayFileType()
{}

tU32 mplay_fi_tcl_e8_MPlayFileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayFileType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayFileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayFileTypeSelection::mplay_fi_tcl_e8_MPlayFileTypeSelection():enType(FI_EN_E8FTS_ALL) {}

tS32 mplay_fi_tcl_e8_MPlayFileTypeSelection::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYFILETYPESELECTION;
}


mplay_fi_tcl_e8_MPlayFileTypeSelection::~mplay_fi_tcl_e8_MPlayFileTypeSelection()
{}

tU32 mplay_fi_tcl_e8_MPlayFileTypeSelection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayFileTypeSelection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayFileTypeSelection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult():enType(FI_EN_E8GNMETADATA_EXTRACTION_SUCCESS) {}

tS32 mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYGNMETADATAEXTRACTIONRESULT;
}


mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::~mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult()
{}

tU32 mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayGNmetadataExtractionResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult():enType(FI_EN_E8DATABASE_ERROR) {}

tS32 mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYINTERNALPLAYLISTTASKRESULT;
}


mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::~mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult()
{}

tU32 mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayInternalPlaylistTaskResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayiPodCommunicationError::mplay_fi_tcl_e8_MPlayiPodCommunicationError():enType(FI_EN_E8IPOD_COMM_ERROR) {}

tS32 mplay_fi_tcl_e8_MPlayiPodCommunicationError::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYIPODCOMMUNICATIONERROR;
}


mplay_fi_tcl_e8_MPlayiPodCommunicationError::~mplay_fi_tcl_e8_MPlayiPodCommunicationError()
{}

tU32 mplay_fi_tcl_e8_MPlayiPodCommunicationError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayiPodCommunicationError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayiPodCommunicationError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayLanguage::mplay_fi_tcl_e8_MPlayLanguage():enType(FI_EN_E8LANGUAGE_SELECTION_ARABIC) {}

tS32 mplay_fi_tcl_e8_MPlayLanguage::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYLANGUAGE;
}


mplay_fi_tcl_e8_MPlayLanguage::~mplay_fi_tcl_e8_MPlayLanguage()
{}

tU32 mplay_fi_tcl_e8_MPlayLanguage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayLanguage::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayLanguage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayListType::mplay_fi_tcl_e8_MPlayListType():enType(FI_EN_E8LTY_ALBUM_SONG) {}

tS32 mplay_fi_tcl_e8_MPlayListType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYLISTTYPE;
}


mplay_fi_tcl_e8_MPlayListType::~mplay_fi_tcl_e8_MPlayListType()
{}

tU32 mplay_fi_tcl_e8_MPlayListType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayListType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayListType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayMediaType::mplay_fi_tcl_e8_MPlayMediaType():enType(FI_EN_E8MRY_AUDIO_STREAM) {}

tS32 mplay_fi_tcl_e8_MPlayMediaType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYMEDIATYPE;
}


mplay_fi_tcl_e8_MPlayMediaType::~mplay_fi_tcl_e8_MPlayMediaType()
{}

tU32 mplay_fi_tcl_e8_MPlayMediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayMediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayMediaType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayMode::mplay_fi_tcl_e8_MPlayMode():enType(FI_EN_E8PBM_NORMAL) {}

tS32 mplay_fi_tcl_e8_MPlayMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYMODE;
}


mplay_fi_tcl_e8_MPlayMode::~mplay_fi_tcl_e8_MPlayMode()
{}

tU32 mplay_fi_tcl_e8_MPlayMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayNowPlayingState::mplay_fi_tcl_e8_MPlayNowPlayingState():enType(FI_EN_E8NP_INVALID) {}

tS32 mplay_fi_tcl_e8_MPlayNowPlayingState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYNOWPLAYINGSTATE;
}


mplay_fi_tcl_e8_MPlayNowPlayingState::~mplay_fi_tcl_e8_MPlayNowPlayingState()
{}

tU32 mplay_fi_tcl_e8_MPlayNowPlayingState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayNowPlayingState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayNowPlayingState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayPlayableStatus::mplay_fi_tcl_e8_MPlayPlayableStatus():enType(FI_EN_E8FP_DRM_PROTECTED) {}

tS32 mplay_fi_tcl_e8_MPlayPlayableStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYPLAYABLESTATUS;
}


mplay_fi_tcl_e8_MPlayPlayableStatus::~mplay_fi_tcl_e8_MPlayPlayableStatus()
{}

tU32 mplay_fi_tcl_e8_MPlayPlayableStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayPlayableStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayPlayableStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayPlaypointFormat::mplay_fi_tcl_e8_MPlayPlaypointFormat():enType(FI_EN_E8PPF_ABSOLUTE) {}

tS32 mplay_fi_tcl_e8_MPlayPlaypointFormat::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYPLAYPOINTFORMAT;
}


mplay_fi_tcl_e8_MPlayPlaypointFormat::~mplay_fi_tcl_e8_MPlayPlaypointFormat()
{}

tU32 mplay_fi_tcl_e8_MPlayPlaypointFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayPlaypointFormat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayPlaypointFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayRepeat::mplay_fi_tcl_e8_MPlayRepeat():enType(FI_EN_E8RPT_ALL_LISTS) {}

tS32 mplay_fi_tcl_e8_MPlayRepeat::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYREPEAT;
}


mplay_fi_tcl_e8_MPlayRepeat::~mplay_fi_tcl_e8_MPlayRepeat()
{}

tU32 mplay_fi_tcl_e8_MPlayRepeat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayRepeat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayRepeat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayState::mplay_fi_tcl_e8_MPlayState():enType(FI_EN_E8PBS_FFWD) {}

tS32 mplay_fi_tcl_e8_MPlayState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYSTATE;
}


mplay_fi_tcl_e8_MPlayState::~mplay_fi_tcl_e8_MPlayState()
{}

tU32 mplay_fi_tcl_e8_MPlayState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayStreamingInfo::mplay_fi_tcl_e8_MPlayStreamingInfo():enType(FI_EN_E16REASON_ACTION_ERROR) {}

tS32 mplay_fi_tcl_e8_MPlayStreamingInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYSTREAMINGINFO;
}


mplay_fi_tcl_e8_MPlayStreamingInfo::~mplay_fi_tcl_e8_MPlayStreamingInfo()
{}

tU32 mplay_fi_tcl_e8_MPlayStreamingInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayStreamingInfo::oRead(fi_tclInContext& oIn)
{
   tS16 s16Value;
   (tVoid) (oIn >> s16Value);
   enType = (tenType)s16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayStreamingInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tS16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayTagTransferStatus::mplay_fi_tcl_e8_MPlayTagTransferStatus():enType(FI_EN_E8TAG_TRANSFER_COMM_ERROR) {}

tS32 mplay_fi_tcl_e8_MPlayTagTransferStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYTAGTRANSFERSTATUS;
}


mplay_fi_tcl_e8_MPlayTagTransferStatus::~mplay_fi_tcl_e8_MPlayTagTransferStatus()
{}

tU32 mplay_fi_tcl_e8_MPlayTagTransferStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayTagTransferStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayTagTransferStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MPlayUmountResult::mplay_fi_tcl_e8_MPlayUmountResult():enType(FI_EN_E8UMOUNT_BUSY) {}

tS32 mplay_fi_tcl_e8_MPlayUmountResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MPLAYUMOUNTRESULT;
}


mplay_fi_tcl_e8_MPlayUmountResult::~mplay_fi_tcl_e8_MPlayUmountResult()
{}

tU32 mplay_fi_tcl_e8_MPlayUmountResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MPlayUmountResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MPlayUmountResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MSoundFormat::mplay_fi_tcl_e8_MSoundFormat():enType(FI_EN_E8AUDIO_CD_DTS) {}

tS32 mplay_fi_tcl_e8_MSoundFormat::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MSOUNDFORMAT;
}


mplay_fi_tcl_e8_MSoundFormat::~mplay_fi_tcl_e8_MSoundFormat()
{}

tU32 mplay_fi_tcl_e8_MSoundFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MSoundFormat::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MSoundFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MSubtitleSelectionType::mplay_fi_tcl_e8_MSubtitleSelectionType():enType(FI_EN_E8SUB_SEL_CYCLIC_OFF) {}

tS32 mplay_fi_tcl_e8_MSubtitleSelectionType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MSUBTITLESELECTIONTYPE;
}


mplay_fi_tcl_e8_MSubtitleSelectionType::~mplay_fi_tcl_e8_MSubtitleSelectionType()
{}

tU32 mplay_fi_tcl_e8_MSubtitleSelectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MSubtitleSelectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MSubtitleSelectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MTotalChannel::mplay_fi_tcl_e8_MTotalChannel():enType(FI_EN_E8DVD_AUDIO_CHANNEL_0) {}

tS32 mplay_fi_tcl_e8_MTotalChannel::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MTOTALCHANNEL;
}


mplay_fi_tcl_e8_MTotalChannel::~mplay_fi_tcl_e8_MTotalChannel()
{}

tU32 mplay_fi_tcl_e8_MTotalChannel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MTotalChannel::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MTotalChannel::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MTouchAction::mplay_fi_tcl_e8_MTouchAction():enType(FI_EN_E8DISPLAY_TOUCH_OFF) {}

tS32 mplay_fi_tcl_e8_MTouchAction::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MTOUCHACTION;
}


mplay_fi_tcl_e8_MTouchAction::~mplay_fi_tcl_e8_MTouchAction()
{}

tU32 mplay_fi_tcl_e8_MTouchAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MTouchAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MTouchAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MVCDAudioMode::mplay_fi_tcl_e8_MVCDAudioMode():enType(FI_EN_E8VCD_CHANNEL_2_LL) {}

tS32 mplay_fi_tcl_e8_MVCDAudioMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MVCDAUDIOMODE;
}


mplay_fi_tcl_e8_MVCDAudioMode::~mplay_fi_tcl_e8_MVCDAudioMode()
{}

tU32 mplay_fi_tcl_e8_MVCDAudioMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MVCDAudioMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MVCDAudioMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_QuickSearchResult::mplay_fi_tcl_e8_QuickSearchResult():enType(FI_EN_E8ENDOFLIST) {}

tS32 mplay_fi_tcl_e8_QuickSearchResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_QUICKSEARCHRESULT;
}


mplay_fi_tcl_e8_QuickSearchResult::~mplay_fi_tcl_e8_QuickSearchResult()
{}

tU32 mplay_fi_tcl_e8_QuickSearchResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_QuickSearchResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_QuickSearchResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MInternalDVDLangSetting::mplay_fi_tcl_MInternalDVDLangSetting(const mplay_fi_tcl_MInternalDVDLangSetting& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u16AudioLanguage = coRef.u16AudioLanguage;
   u16MenuLanguage = coRef.u16MenuLanguage;
   u16SubtitleLanguage = coRef.u16SubtitleLanguage;
}
mplay_fi_tcl_MInternalDVDLangSetting& mplay_fi_tcl_MInternalDVDLangSetting::operator=(const mplay_fi_tcl_MInternalDVDLangSetting& coRef)
{
   if (this == &coRef) return *this;
   u16AudioLanguage = coRef.u16AudioLanguage;
   u16MenuLanguage = coRef.u16MenuLanguage;
   u16SubtitleLanguage = coRef.u16SubtitleLanguage;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_MInternalDVDLangSetting::mplay_fi_tcl_MInternalDVDLangSetting()
:u16AudioLanguage(0)
,u16MenuLanguage(0)
,u16SubtitleLanguage(0)
 {}

tS32 mplay_fi_tcl_MInternalDVDLangSetting::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MINTERNALDVDLANGSETTING;
}


mplay_fi_tcl_MInternalDVDLangSetting::~mplay_fi_tcl_MInternalDVDLangSetting()
{}

tU32 mplay_fi_tcl_MInternalDVDLangSetting::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mplay_fi_tcl_MInternalDVDLangSetting::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AudioLanguage);
   (tVoid) (oIn >> u16MenuLanguage);
   (tVoid) (oIn >> u16SubtitleLanguage);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MInternalDVDLangSetting::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AudioLanguage);
   (tVoid) (oOut << u16MenuLanguage);
   (tVoid) (oOut << u16SubtitleLanguage);
   return oOut;
}

tBool mplay_fi_tcl_MInternalDVDLangSetting::operator==(const mplay_fi_tcl_MInternalDVDLangSetting& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u16AudioLanguage == roRef.u16AudioLanguage);
   bResult = bResult && (u16MenuLanguage == roRef.u16MenuLanguage);
   bResult = bResult && (u16SubtitleLanguage == roRef.u16SubtitleLanguage);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_MPlayDeviceDBViewStatus::mplay_fi_tcl_e_MPlayDeviceDBViewStatus():enType(FI_EN_DB_VIEWS_DONT_CARE) {}

tS32 mplay_fi_tcl_e_MPlayDeviceDBViewStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_MPLAYDEVICEDBVIEWSTATUS;
}


mplay_fi_tcl_e_MPlayDeviceDBViewStatus::~mplay_fi_tcl_e_MPlayDeviceDBViewStatus()
{}

tU32 mplay_fi_tcl_e_MPlayDeviceDBViewStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_MPlayDeviceDBViewStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_MPlayDeviceDBViewStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayDeviceInfoItem::mplay_fi_tcl_MPlayDeviceInfoItem(const mplay_fi_tcl_MPlayDeviceInfoItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8DiscType = coRef.e8DiscType;
   e8AvailabilityReason = coRef.e8AvailabilityReason;
   e8ConnectionState = coRef.e8ConnectionState;
   e8ConnectionType = coRef.e8ConnectionType;
   e8DeviceControlSupport = coRef.e8DeviceControlSupport;
   e8DeviceIndexedState = coRef.e8DeviceIndexedState;
   e8DeviceState = coRef.e8DeviceState;
   e8DeviceType = coRef.e8DeviceType;
   e8DisconnectReason = coRef.e8DisconnectReason;
   e8FileSystemType = coRef.e8FileSystemType;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   bDeviceConnected = coRef.bDeviceConnected;
   bIsNowPlayingListAvailable = coRef.bIsNowPlayingListAvailable;
   bRepeatSupported = coRef.bRepeatSupported;
   bScanSupported = coRef.bScanSupported;
   bShuffleSupported = coRef.bShuffleSupported;
   sDeviceName = coRef.sDeviceName;
   sDeviceSerialNumber = coRef.sDeviceSerialNumber;
   sDeviceSysPath = coRef.sDeviceSysPath;
   sDeviceVersion = coRef.sDeviceVersion;
   sLastPlayedFile = coRef.sLastPlayedFile;
   sMountPoint = coRef.sMountPoint;
   u32FreeSize = coRef.u32FreeSize;
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32NumberOfImageFiles = coRef.u32NumberOfImageFiles;
   u32NumberOfVideoFiles = coRef.u32NumberOfVideoFiles;
   u32PartitionNumber = coRef.u32PartitionNumber;
   u32TotalSize = coRef.u32TotalSize;
   u8DeviceTag = coRef.u8DeviceTag;
   DeviceDBViewStatus = coRef.DeviceDBViewStatus;
}
mplay_fi_tcl_MPlayDeviceInfoItem& mplay_fi_tcl_MPlayDeviceInfoItem::operator=(const mplay_fi_tcl_MPlayDeviceInfoItem& coRef)
{
   if (this == &coRef) return *this;
   e8DiscType = coRef.e8DiscType;
   e8AvailabilityReason = coRef.e8AvailabilityReason;
   e8ConnectionState = coRef.e8ConnectionState;
   e8ConnectionType = coRef.e8ConnectionType;
   e8DeviceControlSupport = coRef.e8DeviceControlSupport;
   e8DeviceIndexedState = coRef.e8DeviceIndexedState;
   e8DeviceState = coRef.e8DeviceState;
   e8DeviceType = coRef.e8DeviceType;
   e8DisconnectReason = coRef.e8DisconnectReason;
   e8FileSystemType = coRef.e8FileSystemType;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   bDeviceConnected = coRef.bDeviceConnected;
   bIsNowPlayingListAvailable = coRef.bIsNowPlayingListAvailable;
   bRepeatSupported = coRef.bRepeatSupported;
   bScanSupported = coRef.bScanSupported;
   bShuffleSupported = coRef.bShuffleSupported;
   sDeviceName = coRef.sDeviceName;
   sDeviceSerialNumber = coRef.sDeviceSerialNumber;
   sDeviceSysPath = coRef.sDeviceSysPath;
   sDeviceVersion = coRef.sDeviceVersion;
   sLastPlayedFile = coRef.sLastPlayedFile;
   sMountPoint = coRef.sMountPoint;
   u32FreeSize = coRef.u32FreeSize;
   u32NumberOfFiles = coRef.u32NumberOfFiles;
   u32NumberOfImageFiles = coRef.u32NumberOfImageFiles;
   u32NumberOfVideoFiles = coRef.u32NumberOfVideoFiles;
   u32PartitionNumber = coRef.u32PartitionNumber;
   u32TotalSize = coRef.u32TotalSize;
   u8DeviceTag = coRef.u8DeviceTag;
   DeviceDBViewStatus = coRef.DeviceDBViewStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayDeviceInfoItem::vDestroy()
{
   sDeviceName.vDestroy();
   sDeviceSerialNumber.vDestroy();
   sDeviceSysPath.vDestroy();
   sDeviceVersion.vDestroy();
   sLastPlayedFile.vDestroy();
   sMountPoint.vDestroy();
}

mplay_fi_tcl_MPlayDeviceInfoItem::mplay_fi_tcl_MPlayDeviceInfoItem()
:e8DiscType()
,e8AvailabilityReason()
,e8ConnectionState()
,e8ConnectionType()
,e8DeviceControlSupport()
,e8DeviceIndexedState()
,e8DeviceState()
,e8DeviceType()
,e8DisconnectReason()
,e8FileSystemType()
,bDeviceActiveSource(0)
,bDeviceConnected(0)
,bIsNowPlayingListAvailable(0)
,bRepeatSupported(0)
,bScanSupported(0)
,bShuffleSupported(0)
,sDeviceName()
,sDeviceSerialNumber()
,sDeviceSysPath()
,sDeviceVersion()
,sLastPlayedFile()
,sMountPoint()
,u32FreeSize(0)
,u32NumberOfFiles(0)
,u32NumberOfImageFiles(0)
,u32NumberOfVideoFiles(0)
,u32PartitionNumber(0)
,u32TotalSize(0)
,u8DeviceTag(0)
,DeviceDBViewStatus()
 {}

tS32 mplay_fi_tcl_MPlayDeviceInfoItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYDEVICEINFOITEM;
}


mplay_fi_tcl_MPlayDeviceInfoItem::~mplay_fi_tcl_MPlayDeviceInfoItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayDeviceInfoItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 42+sDeviceName.u32GetSize(u16MajorVersion)+sDeviceSerialNumber.u32GetSize(u16MajorVersion)+sDeviceSysPath.u32GetSize(u16MajorVersion)+sDeviceVersion.u32GetSize(u16MajorVersion)+sLastPlayedFile.u32GetSize(u16MajorVersion)+sMountPoint.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayDeviceInfoItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DiscType);
   (tVoid) (oIn >> e8AvailabilityReason);
   (tVoid) (oIn >> e8ConnectionState);
   (tVoid) (oIn >> e8ConnectionType);
   (tVoid) (oIn >> e8DeviceControlSupport);
   (tVoid) (oIn >> e8DeviceIndexedState);
   (tVoid) (oIn >> e8DeviceState);
   (tVoid) (oIn >> e8DeviceType);
   (tVoid) (oIn >> e8DisconnectReason);
   (tVoid) (oIn >> e8FileSystemType);
   (tVoid) (oIn >> bDeviceActiveSource);
   (tVoid) (oIn >> bDeviceConnected);
   (tVoid) (oIn >> bIsNowPlayingListAvailable);
   (tVoid) (oIn >> bRepeatSupported);
   (tVoid) (oIn >> bScanSupported);
   (tVoid) (oIn >> bShuffleSupported);
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> sDeviceSerialNumber);
   (tVoid) (oIn >> sDeviceSysPath);
   (tVoid) (oIn >> sDeviceVersion);
   (tVoid) (oIn >> sLastPlayedFile);
   (tVoid) (oIn >> sMountPoint);
   (tVoid) (oIn >> u32FreeSize);
   (tVoid) (oIn >> u32NumberOfFiles);
   (tVoid) (oIn >> u32NumberOfImageFiles);
   (tVoid) (oIn >> u32NumberOfVideoFiles);
   (tVoid) (oIn >> u32PartitionNumber);
   (tVoid) (oIn >> u32TotalSize);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> DeviceDBViewStatus);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayDeviceInfoItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DiscType);
   (tVoid) (oOut << e8AvailabilityReason);
   (tVoid) (oOut << e8ConnectionState);
   (tVoid) (oOut << e8ConnectionType);
   (tVoid) (oOut << e8DeviceControlSupport);
   (tVoid) (oOut << e8DeviceIndexedState);
   (tVoid) (oOut << e8DeviceState);
   (tVoid) (oOut << e8DeviceType);
   (tVoid) (oOut << e8DisconnectReason);
   (tVoid) (oOut << e8FileSystemType);
   (tVoid) (oOut << bDeviceActiveSource);
   (tVoid) (oOut << bDeviceConnected);
   (tVoid) (oOut << bIsNowPlayingListAvailable);
   (tVoid) (oOut << bRepeatSupported);
   (tVoid) (oOut << bScanSupported);
   (tVoid) (oOut << bShuffleSupported);
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << sDeviceSerialNumber);
   (tVoid) (oOut << sDeviceSysPath);
   (tVoid) (oOut << sDeviceVersion);
   (tVoid) (oOut << sLastPlayedFile);
   (tVoid) (oOut << sMountPoint);
   (tVoid) (oOut << u32FreeSize);
   (tVoid) (oOut << u32NumberOfFiles);
   (tVoid) (oOut << u32NumberOfImageFiles);
   (tVoid) (oOut << u32NumberOfVideoFiles);
   (tVoid) (oOut << u32PartitionNumber);
   (tVoid) (oOut << u32TotalSize);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << DeviceDBViewStatus);
   return oOut;
}

tBool mplay_fi_tcl_MPlayDeviceInfoItem::operator==(const mplay_fi_tcl_MPlayDeviceInfoItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DiscType == roRef.e8DiscType);
   bResult = bResult && (e8AvailabilityReason == roRef.e8AvailabilityReason);
   bResult = bResult && (e8ConnectionState == roRef.e8ConnectionState);
   bResult = bResult && (e8ConnectionType == roRef.e8ConnectionType);
   bResult = bResult && (e8DeviceControlSupport == roRef.e8DeviceControlSupport);
   bResult = bResult && (e8DeviceIndexedState == roRef.e8DeviceIndexedState);
   bResult = bResult && (e8DeviceState == roRef.e8DeviceState);
   bResult = bResult && (e8DeviceType == roRef.e8DeviceType);
   bResult = bResult && (e8DisconnectReason == roRef.e8DisconnectReason);
   bResult = bResult && (e8FileSystemType == roRef.e8FileSystemType);
   bResult = bResult && (bDeviceActiveSource == roRef.bDeviceActiveSource);
   bResult = bResult && (bDeviceConnected == roRef.bDeviceConnected);
   bResult = bResult && (bIsNowPlayingListAvailable == roRef.bIsNowPlayingListAvailable);
   bResult = bResult && (bRepeatSupported == roRef.bRepeatSupported);
   bResult = bResult && (bScanSupported == roRef.bScanSupported);
   bResult = bResult && (bShuffleSupported == roRef.bShuffleSupported);
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (sDeviceSerialNumber == roRef.sDeviceSerialNumber);
   bResult = bResult && (sDeviceSysPath == roRef.sDeviceSysPath);
   bResult = bResult && (sDeviceVersion == roRef.sDeviceVersion);
   bResult = bResult && (sLastPlayedFile == roRef.sLastPlayedFile);
   bResult = bResult && (sMountPoint == roRef.sMountPoint);
   bResult = bResult && (u32FreeSize == roRef.u32FreeSize);
   bResult = bResult && (u32NumberOfFiles == roRef.u32NumberOfFiles);
   bResult = bResult && (u32NumberOfImageFiles == roRef.u32NumberOfImageFiles);
   bResult = bResult && (u32NumberOfVideoFiles == roRef.u32NumberOfVideoFiles);
   bResult = bResult && (u32PartitionNumber == roRef.u32PartitionNumber);
   bResult = bResult && (u32TotalSize == roRef.u32TotalSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (DeviceDBViewStatus == roRef.DeviceDBViewStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayFavoritesList::mplay_fi_tcl_MPlayFavoritesList(const mplay_fi_tcl_MPlayFavoritesList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u64FavoriteID = coRef.u64FavoriteID;
}
mplay_fi_tcl_MPlayFavoritesList& mplay_fi_tcl_MPlayFavoritesList::operator=(const mplay_fi_tcl_MPlayFavoritesList& coRef)
{
   if (this == &coRef) return *this;
   u64FavoriteID = coRef.u64FavoriteID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayFavoritesList::vDestroy()
{
   {
   u64FavoriteID.clear();
   }
}

mplay_fi_tcl_MPlayFavoritesList::mplay_fi_tcl_MPlayFavoritesList()

 {}

tS32 mplay_fi_tcl_MPlayFavoritesList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYFAVORITESLIST;
}


mplay_fi_tcl_MPlayFavoritesList::~mplay_fi_tcl_MPlayFavoritesList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayFavoritesList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(u64FavoriteID.size()*8);
}

fi_tclInContext& mplay_fi_tcl_MPlayFavoritesList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u64FavoriteID.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u64FavoriteID[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayFavoritesList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)u64FavoriteID.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u64FavoriteID.size(); ++u32Idx)
         (tVoid) (oOut << u64FavoriteID[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayFavoritesList::operator==(const mplay_fi_tcl_MPlayFavoritesList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (u64FavoriteID.size() == roRef.u64FavoriteID.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u64FavoriteID.size()); ++u32Idx)
            bResult = bResult && (u64FavoriteID[u32Idx] == roRef.u64FavoriteID[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayFileListItem::mplay_fi_tcl_MPlayFileListItem(const mplay_fi_tcl_MPlayFileListItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8FileFormat = coRef.e8FileFormat;
   e8FileType = coRef.e8FileType;
   e8PlayableStatus = coRef.e8PlayableStatus;
   bIsPlaying = coRef.bIsPlaying;
   bReadOnlyFlag = coRef.bReadOnlyFlag;
   sFilename = coRef.sFilename;
   u32Tag = coRef.u32Tag;
   u8TrackNumber = coRef.u8TrackNumber;
   sDateTime = coRef.sDateTime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u64FileSize = coRef.u64FileSize;
   sCoverArt = coRef.sCoverArt;
   Tag = coRef.Tag;
   ParentTag = coRef.ParentTag;
}
mplay_fi_tcl_MPlayFileListItem& mplay_fi_tcl_MPlayFileListItem::operator=(const mplay_fi_tcl_MPlayFileListItem& coRef)
{
   if (this == &coRef) return *this;
   e8FileFormat = coRef.e8FileFormat;
   e8FileType = coRef.e8FileType;
   e8PlayableStatus = coRef.e8PlayableStatus;
   bIsPlaying = coRef.bIsPlaying;
   bReadOnlyFlag = coRef.bReadOnlyFlag;
   sFilename = coRef.sFilename;
   u32Tag = coRef.u32Tag;
   u8TrackNumber = coRef.u8TrackNumber;
   sDateTime = coRef.sDateTime;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u64FileSize = coRef.u64FileSize;
   sCoverArt = coRef.sCoverArt;
   Tag = coRef.Tag;
   ParentTag = coRef.ParentTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayFileListItem::vDestroy()
{
   sFilename.vDestroy();
   sDateTime.vDestroy();
   sCoverArt.vDestroy();
}

mplay_fi_tcl_MPlayFileListItem::mplay_fi_tcl_MPlayFileListItem()
:e8FileFormat()
,e8FileType()
,e8PlayableStatus()
,bIsPlaying(0)
,bReadOnlyFlag(0)
,sFilename()
,u32Tag(0)
,u8TrackNumber(0)
,sDateTime()
,u32TotalPlaytime(0)
,u64FileSize(0)
,sCoverArt()
,Tag(0)
,ParentTag(0)
 {}

tS32 mplay_fi_tcl_MPlayFileListItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYFILELISTITEM;
}


mplay_fi_tcl_MPlayFileListItem::~mplay_fi_tcl_MPlayFileListItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayFileListItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 38+sFilename.u32GetSize(u16MajorVersion)+sDateTime.u32GetSize(u16MajorVersion)+sCoverArt.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayFileListItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8FileFormat);
   (tVoid) (oIn >> e8FileType);
   (tVoid) (oIn >> e8PlayableStatus);
   (tVoid) (oIn >> bIsPlaying);
   (tVoid) (oIn >> bReadOnlyFlag);
   (tVoid) (oIn >> sFilename);
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> u8TrackNumber);
   (tVoid) (oIn >> sDateTime);
   (tVoid) (oIn >> u32TotalPlaytime);
   (tVoid) (oIn >> u64FileSize);
   (tVoid) (oIn >> sCoverArt);
   (tVoid) (oIn >> Tag);
   (tVoid) (oIn >> ParentTag);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayFileListItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8FileFormat);
   (tVoid) (oOut << e8FileType);
   (tVoid) (oOut << e8PlayableStatus);
   (tVoid) (oOut << bIsPlaying);
   (tVoid) (oOut << bReadOnlyFlag);
   (tVoid) (oOut << sFilename);
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << u8TrackNumber);
   (tVoid) (oOut << sDateTime);
   (tVoid) (oOut << u32TotalPlaytime);
   (tVoid) (oOut << u64FileSize);
   (tVoid) (oOut << sCoverArt);
   (tVoid) (oOut << Tag);
   (tVoid) (oOut << ParentTag);
   return oOut;
}

tBool mplay_fi_tcl_MPlayFileListItem::operator==(const mplay_fi_tcl_MPlayFileListItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8FileFormat == roRef.e8FileFormat);
   bResult = bResult && (e8FileType == roRef.e8FileType);
   bResult = bResult && (e8PlayableStatus == roRef.e8PlayableStatus);
   bResult = bResult && (bIsPlaying == roRef.bIsPlaying);
   bResult = bResult && (bReadOnlyFlag == roRef.bReadOnlyFlag);
   bResult = bResult && (sFilename == roRef.sFilename);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (u8TrackNumber == roRef.u8TrackNumber);
   bResult = bResult && (sDateTime == roRef.sDateTime);
   bResult = bResult && (u32TotalPlaytime == roRef.u32TotalPlaytime);
   bResult = bResult && (u64FileSize == roRef.u64FileSize);
   bResult = bResult && (sCoverArt == roRef.sCoverArt);
   bResult = bResult && (Tag == roRef.Tag);
   bResult = bResult && (ParentTag == roRef.ParentTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayFileList::mplay_fi_tcl_MPlayFileList(const mplay_fi_tcl_MPlayFileList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayFileList& mplay_fi_tcl_MPlayFileList::operator=(const mplay_fi_tcl_MPlayFileList& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayFileList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayFileList::mplay_fi_tcl_MPlayFileList()

 {}

tS32 mplay_fi_tcl_MPlayFileList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYFILELIST;
}


mplay_fi_tcl_MPlayFileList::~mplay_fi_tcl_MPlayFileList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayFileList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayFileList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayFileList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayFileList::operator==(const mplay_fi_tcl_MPlayFileList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayImageData::mplay_fi_tcl_MPlayImageData(const mplay_fi_tcl_MPlayImageData& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u8Items = coRef.u8Items;
}
mplay_fi_tcl_MPlayImageData& mplay_fi_tcl_MPlayImageData::operator=(const mplay_fi_tcl_MPlayImageData& coRef)
{
   if (this == &coRef) return *this;
   u8Items = coRef.u8Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayImageData::vDestroy()
{
   {
   u8Items.clear();
   }
}

mplay_fi_tcl_MPlayImageData::mplay_fi_tcl_MPlayImageData()

 {}

tS32 mplay_fi_tcl_MPlayImageData::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYIMAGEDATA;
}


mplay_fi_tcl_MPlayImageData::~mplay_fi_tcl_MPlayImageData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayImageData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(u8Items.size()*1);
}

fi_tclInContext& mplay_fi_tcl_MPlayImageData::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u8Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u8Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayImageData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)u8Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u8Items.size(); ++u32Idx)
         (tVoid) (oOut << u8Items[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayImageData::operator==(const mplay_fi_tcl_MPlayImageData& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (u8Items.size() == roRef.u8Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u8Items.size()); ++u32Idx)
            bResult = bResult && (u8Items[u32Idx] == roRef.u8Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayImageObjectItem::mplay_fi_tcl_MPlayImageObjectItem(const mplay_fi_tcl_MPlayImageObjectItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8FileFormat = coRef.e8FileFormat;
   e8FileType = coRef.e8FileType;
   sDateTime = coRef.sDateTime;
   sDimension = coRef.sDimension;
   sFolderTitle = coRef.sFolderTitle;
   sImageFile = coRef.sImageFile;
   sImageSize = coRef.sImageSize;
   sImageTitle = coRef.sImageTitle;
   sMountPoint = coRef.sMountPoint;
   sPath = coRef.sPath;
   sResolution = coRef.sResolution;
   u32NumberOfImages = coRef.u32NumberOfImages;
   u32Tag = coRef.u32Tag;
   u8DeviceTag = coRef.u8DeviceTag;
}
mplay_fi_tcl_MPlayImageObjectItem& mplay_fi_tcl_MPlayImageObjectItem::operator=(const mplay_fi_tcl_MPlayImageObjectItem& coRef)
{
   if (this == &coRef) return *this;
   e8FileFormat = coRef.e8FileFormat;
   e8FileType = coRef.e8FileType;
   sDateTime = coRef.sDateTime;
   sDimension = coRef.sDimension;
   sFolderTitle = coRef.sFolderTitle;
   sImageFile = coRef.sImageFile;
   sImageSize = coRef.sImageSize;
   sImageTitle = coRef.sImageTitle;
   sMountPoint = coRef.sMountPoint;
   sPath = coRef.sPath;
   sResolution = coRef.sResolution;
   u32NumberOfImages = coRef.u32NumberOfImages;
   u32Tag = coRef.u32Tag;
   u8DeviceTag = coRef.u8DeviceTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayImageObjectItem::vDestroy()
{
   sDateTime.vDestroy();
   sDimension.vDestroy();
   sFolderTitle.vDestroy();
   sImageFile.vDestroy();
   sImageSize.vDestroy();
   sImageTitle.vDestroy();
   sMountPoint.vDestroy();
   sPath.vDestroy();
   sResolution.vDestroy();
}

mplay_fi_tcl_MPlayImageObjectItem::mplay_fi_tcl_MPlayImageObjectItem()
:e8FileFormat()
,e8FileType()
,sDateTime()
,sDimension()
,sFolderTitle()
,sImageFile()
,sImageSize()
,sImageTitle()
,sMountPoint()
,sPath()
,sResolution()
,u32NumberOfImages(0)
,u32Tag(0)
,u8DeviceTag(0)
 {}

tS32 mplay_fi_tcl_MPlayImageObjectItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYIMAGEOBJECTITEM;
}


mplay_fi_tcl_MPlayImageObjectItem::~mplay_fi_tcl_MPlayImageObjectItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayImageObjectItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+sDateTime.u32GetSize(u16MajorVersion)+sDimension.u32GetSize(u16MajorVersion)+sFolderTitle.u32GetSize(u16MajorVersion)+sImageFile.u32GetSize(u16MajorVersion)+sImageSize.u32GetSize(u16MajorVersion)+sImageTitle.u32GetSize(u16MajorVersion)+sMountPoint.u32GetSize(u16MajorVersion)+sPath.u32GetSize(u16MajorVersion)+sResolution.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayImageObjectItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8FileFormat);
   (tVoid) (oIn >> e8FileType);
   (tVoid) (oIn >> sDateTime);
   (tVoid) (oIn >> sDimension);
   (tVoid) (oIn >> sFolderTitle);
   (tVoid) (oIn >> sImageFile);
   (tVoid) (oIn >> sImageSize);
   (tVoid) (oIn >> sImageTitle);
   (tVoid) (oIn >> sMountPoint);
   (tVoid) (oIn >> sPath);
   (tVoid) (oIn >> sResolution);
   (tVoid) (oIn >> u32NumberOfImages);
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> u8DeviceTag);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayImageObjectItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8FileFormat);
   (tVoid) (oOut << e8FileType);
   (tVoid) (oOut << sDateTime);
   (tVoid) (oOut << sDimension);
   (tVoid) (oOut << sFolderTitle);
   (tVoid) (oOut << sImageFile);
   (tVoid) (oOut << sImageSize);
   (tVoid) (oOut << sImageTitle);
   (tVoid) (oOut << sMountPoint);
   (tVoid) (oOut << sPath);
   (tVoid) (oOut << sResolution);
   (tVoid) (oOut << u32NumberOfImages);
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << u8DeviceTag);
   return oOut;
}

tBool mplay_fi_tcl_MPlayImageObjectItem::operator==(const mplay_fi_tcl_MPlayImageObjectItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8FileFormat == roRef.e8FileFormat);
   bResult = bResult && (e8FileType == roRef.e8FileType);
   bResult = bResult && (sDateTime == roRef.sDateTime);
   bResult = bResult && (sDimension == roRef.sDimension);
   bResult = bResult && (sFolderTitle == roRef.sFolderTitle);
   bResult = bResult && (sImageFile == roRef.sImageFile);
   bResult = bResult && (sImageSize == roRef.sImageSize);
   bResult = bResult && (sImageTitle == roRef.sImageTitle);
   bResult = bResult && (sMountPoint == roRef.sMountPoint);
   bResult = bResult && (sPath == roRef.sPath);
   bResult = bResult && (sResolution == roRef.sResolution);
   bResult = bResult && (u32NumberOfImages == roRef.u32NumberOfImages);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayImageObjects::mplay_fi_tcl_MPlayImageObjects(const mplay_fi_tcl_MPlayImageObjects& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayImageObjects& mplay_fi_tcl_MPlayImageObjects::operator=(const mplay_fi_tcl_MPlayImageObjects& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayImageObjects::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayImageObjects::mplay_fi_tcl_MPlayImageObjects()

 {}

tS32 mplay_fi_tcl_MPlayImageObjects::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYIMAGEOBJECTS;
}


mplay_fi_tcl_MPlayImageObjects::~mplay_fi_tcl_MPlayImageObjects()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayImageObjects::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayImageObjects::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayImageObjects::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayImageObjects::operator==(const mplay_fi_tcl_MPlayImageObjects& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayIndexingStateResultItem::mplay_fi_tcl_MPlayIndexingStateResultItem(const mplay_fi_tcl_MPlayIndexingStateResultItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8DeviceIndexedState = coRef.e8DeviceIndexedState;
   u8DeviceTag = coRef.u8DeviceTag;
   u8IndexingPercentComplete = coRef.u8IndexingPercentComplete;
}
mplay_fi_tcl_MPlayIndexingStateResultItem& mplay_fi_tcl_MPlayIndexingStateResultItem::operator=(const mplay_fi_tcl_MPlayIndexingStateResultItem& coRef)
{
   if (this == &coRef) return *this;
   e8DeviceIndexedState = coRef.e8DeviceIndexedState;
   u8DeviceTag = coRef.u8DeviceTag;
   u8IndexingPercentComplete = coRef.u8IndexingPercentComplete;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_MPlayIndexingStateResultItem::mplay_fi_tcl_MPlayIndexingStateResultItem()
:e8DeviceIndexedState()
,u8DeviceTag(0)
,u8IndexingPercentComplete(0)
 {}

tS32 mplay_fi_tcl_MPlayIndexingStateResultItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYINDEXINGSTATERESULTITEM;
}


mplay_fi_tcl_MPlayIndexingStateResultItem::~mplay_fi_tcl_MPlayIndexingStateResultItem()
{}

tU32 mplay_fi_tcl_MPlayIndexingStateResultItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_fi_tcl_MPlayIndexingStateResultItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DeviceIndexedState);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u8IndexingPercentComplete);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayIndexingStateResultItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DeviceIndexedState);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u8IndexingPercentComplete);
   return oOut;
}

tBool mplay_fi_tcl_MPlayIndexingStateResultItem::operator==(const mplay_fi_tcl_MPlayIndexingStateResultItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DeviceIndexedState == roRef.e8DeviceIndexedState);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u8IndexingPercentComplete == roRef.u8IndexingPercentComplete);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayIndexingStateResult::mplay_fi_tcl_MPlayIndexingStateResult(const mplay_fi_tcl_MPlayIndexingStateResult& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayIndexingStateResult& mplay_fi_tcl_MPlayIndexingStateResult::operator=(const mplay_fi_tcl_MPlayIndexingStateResult& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayIndexingStateResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayIndexingStateResult::mplay_fi_tcl_MPlayIndexingStateResult()

 {}

tS32 mplay_fi_tcl_MPlayIndexingStateResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYINDEXINGSTATERESULT;
}


mplay_fi_tcl_MPlayIndexingStateResult::~mplay_fi_tcl_MPlayIndexingStateResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayIndexingStateResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(oItems.size()*3);
}

fi_tclInContext& mplay_fi_tcl_MPlayIndexingStateResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayIndexingStateResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayIndexingStateResult::operator==(const mplay_fi_tcl_MPlayIndexingStateResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayItems::mplay_fi_tcl_MPlayItems(const mplay_fi_tcl_MPlayItems& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u32Items = coRef.u32Items;
}
mplay_fi_tcl_MPlayItems& mplay_fi_tcl_MPlayItems::operator=(const mplay_fi_tcl_MPlayItems& coRef)
{
   if (this == &coRef) return *this;
   u32Items = coRef.u32Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayItems::vDestroy()
{
   {
   u32Items.clear();
   }
}

mplay_fi_tcl_MPlayItems::mplay_fi_tcl_MPlayItems()

 {}

tS32 mplay_fi_tcl_MPlayItems::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYITEMS;
}


mplay_fi_tcl_MPlayItems::~mplay_fi_tcl_MPlayItems()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayItems::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(u32Items.size()*4);
}

fi_tclInContext& mplay_fi_tcl_MPlayItems::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u32Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u32Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayItems::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)u32Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u32Items.size(); ++u32Idx)
         (tVoid) (oOut << u32Items[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayItems::operator==(const mplay_fi_tcl_MPlayItems& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (u32Items.size() == roRef.u32Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u32Items.size()); ++u32Idx)
            bResult = bResult && (u32Items[u32Idx] == roRef.u32Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayMediaAlbums::mplay_fi_tcl_MPlayMediaAlbums(const mplay_fi_tcl_MPlayMediaAlbums& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   sAlbumTitle = coRef.sAlbumTitle;
}
mplay_fi_tcl_MPlayMediaAlbums& mplay_fi_tcl_MPlayMediaAlbums::operator=(const mplay_fi_tcl_MPlayMediaAlbums& coRef)
{
   if (this == &coRef) return *this;
   sAlbumTitle = coRef.sAlbumTitle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayMediaAlbums::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < sAlbumTitle.size(); ++u32Idx)
         sAlbumTitle[u32Idx].vDestroy();
   sAlbumTitle.clear();
   }
}

mplay_fi_tcl_MPlayMediaAlbums::mplay_fi_tcl_MPlayMediaAlbums()

 {}

tS32 mplay_fi_tcl_MPlayMediaAlbums::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYMEDIAALBUMS;
}


mplay_fi_tcl_MPlayMediaAlbums::~mplay_fi_tcl_MPlayMediaAlbums()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayMediaAlbums::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < sAlbumTitle.size(); ++u32ListIdx)
      u32DynamicSize += sAlbumTitle[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayMediaAlbums::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < sAlbumTitle.size(); ++u32Idx)
      {
         sAlbumTitle[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      sAlbumTitle.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> sAlbumTitle[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayMediaAlbums::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)sAlbumTitle.size());
   {
      for (tU32 u32Idx = 0; u32Idx < sAlbumTitle.size(); ++u32Idx)
         (tVoid) (oOut << sAlbumTitle[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayMediaAlbums::operator==(const mplay_fi_tcl_MPlayMediaAlbums& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (sAlbumTitle.size() == roRef.sAlbumTitle.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < sAlbumTitle.size()); ++u32Idx)
            bResult = bResult && (sAlbumTitle[u32Idx] == roRef.sAlbumTitle[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayMediaObject::mplay_fi_tcl_MPlayMediaObject(const mplay_fi_tcl_MPlayMediaObject& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8AudioChannelFormat = coRef.e8AudioChannelFormat;
   e8CategoryType = coRef.e8CategoryType;
   e8DeviceType = coRef.e8DeviceType;
   e8FileFormat = coRef.e8FileFormat;
   e8MediaType = coRef.e8MediaType;
   e8PlayableStatus = coRef.e8PlayableStatus;
   bIsPlaying = coRef.bIsPlaying;
   bVBR = coRef.bVBR;
   sAlbumArt = coRef.sAlbumArt;
   sDateTime = coRef.sDateTime;
   sDeviceVersion = coRef.sDeviceVersion;
   sFilename = coRef.sFilename;
   sMetaDataField1 = coRef.sMetaDataField1;
   sMetaDataField2 = coRef.sMetaDataField2;
   sMetaDataField3 = coRef.sMetaDataField3;
   sMetaDataField4 = coRef.sMetaDataField4;
   sYomiMetaDataTitle = coRef.sYomiMetaDataTitle;
   sYomiMetaDataArtist = coRef.sYomiMetaDataArtist;
   sYomiMetaDataAlbum = coRef.sYomiMetaDataAlbum;
   sResolution = coRef.sResolution;
   u16ExtendedTrackNumber = coRef.u16ExtendedTrackNumber;
   u32BitRate = coRef.u32BitRate;
   u32MetaDataTag1 = coRef.u32MetaDataTag1;
   u32MetaDataTag2 = coRef.u32MetaDataTag2;
   u32MetaDataTag3 = coRef.u32MetaDataTag3;
   u32MetaDataTag4 = coRef.u32MetaDataTag4;
   u32SampleRate = coRef.u32SampleRate;
   u32Tag = coRef.u32Tag;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u32Year = coRef.u32Year;
   u32YearID = coRef.u32YearID;
   u64FileSize = coRef.u64FileSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u8TrackNumber = coRef.u8TrackNumber;
   bIsFavorite = coRef.bIsFavorite;
}
mplay_fi_tcl_MPlayMediaObject& mplay_fi_tcl_MPlayMediaObject::operator=(const mplay_fi_tcl_MPlayMediaObject& coRef)
{
   if (this == &coRef) return *this;
   e8AudioChannelFormat = coRef.e8AudioChannelFormat;
   e8CategoryType = coRef.e8CategoryType;
   e8DeviceType = coRef.e8DeviceType;
   e8FileFormat = coRef.e8FileFormat;
   e8MediaType = coRef.e8MediaType;
   e8PlayableStatus = coRef.e8PlayableStatus;
   bIsPlaying = coRef.bIsPlaying;
   bVBR = coRef.bVBR;
   sAlbumArt = coRef.sAlbumArt;
   sDateTime = coRef.sDateTime;
   sDeviceVersion = coRef.sDeviceVersion;
   sFilename = coRef.sFilename;
   sMetaDataField1 = coRef.sMetaDataField1;
   sMetaDataField2 = coRef.sMetaDataField2;
   sMetaDataField3 = coRef.sMetaDataField3;
   sMetaDataField4 = coRef.sMetaDataField4;
   sYomiMetaDataTitle = coRef.sYomiMetaDataTitle;
   sYomiMetaDataArtist = coRef.sYomiMetaDataArtist;
   sYomiMetaDataAlbum = coRef.sYomiMetaDataAlbum;
   sResolution = coRef.sResolution;
   u16ExtendedTrackNumber = coRef.u16ExtendedTrackNumber;
   u32BitRate = coRef.u32BitRate;
   u32MetaDataTag1 = coRef.u32MetaDataTag1;
   u32MetaDataTag2 = coRef.u32MetaDataTag2;
   u32MetaDataTag3 = coRef.u32MetaDataTag3;
   u32MetaDataTag4 = coRef.u32MetaDataTag4;
   u32SampleRate = coRef.u32SampleRate;
   u32Tag = coRef.u32Tag;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u32Year = coRef.u32Year;
   u32YearID = coRef.u32YearID;
   u64FileSize = coRef.u64FileSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u8TrackNumber = coRef.u8TrackNumber;
   bIsFavorite = coRef.bIsFavorite;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayMediaObject::vDestroy()
{
   sAlbumArt.vDestroy();
   sDateTime.vDestroy();
   sDeviceVersion.vDestroy();
   sFilename.vDestroy();
   sMetaDataField1.vDestroy();
   sMetaDataField2.vDestroy();
   sMetaDataField3.vDestroy();
   sMetaDataField4.vDestroy();
   sYomiMetaDataTitle.vDestroy();
   sYomiMetaDataArtist.vDestroy();
   sYomiMetaDataAlbum.vDestroy();
   sResolution.vDestroy();
}

mplay_fi_tcl_MPlayMediaObject::mplay_fi_tcl_MPlayMediaObject()
:e8AudioChannelFormat()
,e8CategoryType()
,e8DeviceType()
,e8FileFormat()
,e8MediaType()
,e8PlayableStatus()
,bIsPlaying(0)
,bVBR(0)
,sAlbumArt()
,sDateTime()
,sDeviceVersion()
,sFilename()
,sMetaDataField1()
,sMetaDataField2()
,sMetaDataField3()
,sMetaDataField4()
,sYomiMetaDataTitle()
,sYomiMetaDataArtist()
,sYomiMetaDataAlbum()
,sResolution()
,u16ExtendedTrackNumber(0)
,u32BitRate(0)
,u32MetaDataTag1(0)
,u32MetaDataTag2(0)
,u32MetaDataTag3(0)
,u32MetaDataTag4(0)
,u32SampleRate(0)
,u32Tag(0)
,u32TotalPlaytime(0)
,u32Year(0)
,u32YearID(0)
,u64FileSize(0)
,u8DeviceTag(0)
,u8TrackNumber(0)
,bIsFavorite(0)
 {}

tS32 mplay_fi_tcl_MPlayMediaObject::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYMEDIAOBJECT;
}


mplay_fi_tcl_MPlayMediaObject::~mplay_fi_tcl_MPlayMediaObject()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayMediaObject::u32GetSize(tU16 u16MajorVersion) const
{
   return 61+sAlbumArt.u32GetSize(u16MajorVersion)+sDateTime.u32GetSize(u16MajorVersion)+sDeviceVersion.u32GetSize(u16MajorVersion)+sFilename.u32GetSize(u16MajorVersion)+sMetaDataField1.u32GetSize(u16MajorVersion)+sMetaDataField2.u32GetSize(u16MajorVersion)+sMetaDataField3.u32GetSize(u16MajorVersion)+sMetaDataField4.u32GetSize(u16MajorVersion)+sYomiMetaDataTitle.u32GetSize(u16MajorVersion)+sYomiMetaDataArtist.u32GetSize(u16MajorVersion)+sYomiMetaDataAlbum.u32GetSize(u16MajorVersion)+sResolution.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayMediaObject::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8AudioChannelFormat);
   (tVoid) (oIn >> e8CategoryType);
   (tVoid) (oIn >> e8DeviceType);
   (tVoid) (oIn >> e8FileFormat);
   (tVoid) (oIn >> e8MediaType);
   (tVoid) (oIn >> e8PlayableStatus);
   (tVoid) (oIn >> bIsPlaying);
   (tVoid) (oIn >> bVBR);
   (tVoid) (oIn >> sAlbumArt);
   (tVoid) (oIn >> sDateTime);
   (tVoid) (oIn >> sDeviceVersion);
   (tVoid) (oIn >> sFilename);
   (tVoid) (oIn >> sMetaDataField1);
   (tVoid) (oIn >> sMetaDataField2);
   (tVoid) (oIn >> sMetaDataField3);
   (tVoid) (oIn >> sMetaDataField4);
   (tVoid) (oIn >> sYomiMetaDataTitle);
   (tVoid) (oIn >> sYomiMetaDataArtist);
   (tVoid) (oIn >> sYomiMetaDataAlbum);
   (tVoid) (oIn >> sResolution);
   (tVoid) (oIn >> u16ExtendedTrackNumber);
   (tVoid) (oIn >> u32BitRate);
   (tVoid) (oIn >> u32MetaDataTag1);
   (tVoid) (oIn >> u32MetaDataTag2);
   (tVoid) (oIn >> u32MetaDataTag3);
   (tVoid) (oIn >> u32MetaDataTag4);
   (tVoid) (oIn >> u32SampleRate);
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> u32TotalPlaytime);
   (tVoid) (oIn >> u32Year);
   (tVoid) (oIn >> u32YearID);
   (tVoid) (oIn >> u64FileSize);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u8TrackNumber);
   (tVoid) (oIn >> bIsFavorite);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayMediaObject::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8AudioChannelFormat);
   (tVoid) (oOut << e8CategoryType);
   (tVoid) (oOut << e8DeviceType);
   (tVoid) (oOut << e8FileFormat);
   (tVoid) (oOut << e8MediaType);
   (tVoid) (oOut << e8PlayableStatus);
   (tVoid) (oOut << bIsPlaying);
   (tVoid) (oOut << bVBR);
   (tVoid) (oOut << sAlbumArt);
   (tVoid) (oOut << sDateTime);
   (tVoid) (oOut << sDeviceVersion);
   (tVoid) (oOut << sFilename);
   (tVoid) (oOut << sMetaDataField1);
   (tVoid) (oOut << sMetaDataField2);
   (tVoid) (oOut << sMetaDataField3);
   (tVoid) (oOut << sMetaDataField4);
   (tVoid) (oOut << sYomiMetaDataTitle);
   (tVoid) (oOut << sYomiMetaDataArtist);
   (tVoid) (oOut << sYomiMetaDataAlbum);
   (tVoid) (oOut << sResolution);
   (tVoid) (oOut << u16ExtendedTrackNumber);
   (tVoid) (oOut << u32BitRate);
   (tVoid) (oOut << u32MetaDataTag1);
   (tVoid) (oOut << u32MetaDataTag2);
   (tVoid) (oOut << u32MetaDataTag3);
   (tVoid) (oOut << u32MetaDataTag4);
   (tVoid) (oOut << u32SampleRate);
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << u32TotalPlaytime);
   (tVoid) (oOut << u32Year);
   (tVoid) (oOut << u32YearID);
   (tVoid) (oOut << u64FileSize);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u8TrackNumber);
   (tVoid) (oOut << bIsFavorite);
   return oOut;
}

tBool mplay_fi_tcl_MPlayMediaObject::operator==(const mplay_fi_tcl_MPlayMediaObject& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8AudioChannelFormat == roRef.e8AudioChannelFormat);
   bResult = bResult && (e8CategoryType == roRef.e8CategoryType);
   bResult = bResult && (e8DeviceType == roRef.e8DeviceType);
   bResult = bResult && (e8FileFormat == roRef.e8FileFormat);
   bResult = bResult && (e8MediaType == roRef.e8MediaType);
   bResult = bResult && (e8PlayableStatus == roRef.e8PlayableStatus);
   bResult = bResult && (bIsPlaying == roRef.bIsPlaying);
   bResult = bResult && (bVBR == roRef.bVBR);
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   bResult = bResult && (sDateTime == roRef.sDateTime);
   bResult = bResult && (sDeviceVersion == roRef.sDeviceVersion);
   bResult = bResult && (sFilename == roRef.sFilename);
   bResult = bResult && (sMetaDataField1 == roRef.sMetaDataField1);
   bResult = bResult && (sMetaDataField2 == roRef.sMetaDataField2);
   bResult = bResult && (sMetaDataField3 == roRef.sMetaDataField3);
   bResult = bResult && (sMetaDataField4 == roRef.sMetaDataField4);
   bResult = bResult && (sYomiMetaDataTitle == roRef.sYomiMetaDataTitle);
   bResult = bResult && (sYomiMetaDataArtist == roRef.sYomiMetaDataArtist);
   bResult = bResult && (sYomiMetaDataAlbum == roRef.sYomiMetaDataAlbum);
   bResult = bResult && (sResolution == roRef.sResolution);
   bResult = bResult && (u16ExtendedTrackNumber == roRef.u16ExtendedTrackNumber);
   bResult = bResult && (u32BitRate == roRef.u32BitRate);
   bResult = bResult && (u32MetaDataTag1 == roRef.u32MetaDataTag1);
   bResult = bResult && (u32MetaDataTag2 == roRef.u32MetaDataTag2);
   bResult = bResult && (u32MetaDataTag3 == roRef.u32MetaDataTag3);
   bResult = bResult && (u32MetaDataTag4 == roRef.u32MetaDataTag4);
   bResult = bResult && (u32SampleRate == roRef.u32SampleRate);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (u32TotalPlaytime == roRef.u32TotalPlaytime);
   bResult = bResult && (u32Year == roRef.u32Year);
   bResult = bResult && (u32YearID == roRef.u32YearID);
   bResult = bResult && (u64FileSize == roRef.u64FileSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u8TrackNumber == roRef.u8TrackNumber);
   bResult = bResult && (bIsFavorite == roRef.bIsFavorite);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayMediaObjectsItem::mplay_fi_tcl_MPlayMediaObjectsItem(const mplay_fi_tcl_MPlayMediaObjectsItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8CategoryType = coRef.e8CategoryType;
   e8DeviceType = coRef.e8DeviceType;
   e8FileFormat = coRef.e8FileFormat;
   e8MediaType = coRef.e8MediaType;
   e8PlayableStatus = coRef.e8PlayableStatus;
   oThumbnailData = coRef.oThumbnailData;
   bIsPlaying = coRef.bIsPlaying;
   bReadOnlyFlag = coRef.bReadOnlyFlag;
   sAlbumArt = coRef.sAlbumArt;
   sCoverArt = coRef.sCoverArt;
   sDateTime = coRef.sDateTime;
   sDeviceVersion = coRef.sDeviceVersion;
   sFilename = coRef.sFilename;
   sMetaDataField1 = coRef.sMetaDataField1;
   sMetaDataField2 = coRef.sMetaDataField2;
   sMetaDataField3 = coRef.sMetaDataField3;
   sMetaDataField4 = coRef.sMetaDataField4;
   u32MetaDataTag1 = coRef.u32MetaDataTag1;
   u32MetaDataTag2 = coRef.u32MetaDataTag2;
   u32MetaDataTag3 = coRef.u32MetaDataTag3;
   u32MetaDataTag4 = coRef.u32MetaDataTag4;
   sYomiMetaDataTitle = coRef.sYomiMetaDataTitle;
   sYomiMetaDataArtist = coRef.sYomiMetaDataArtist;
   sYomiMetaDataAlbum = coRef.sYomiMetaDataAlbum;
   u32Tag = coRef.u32Tag;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u32Year = coRef.u32Year;
   u32YearID = coRef.u32YearID;
   u64FileSize = coRef.u64FileSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u8TrackNumber = coRef.u8TrackNumber;
   bIsFavorite = coRef.bIsFavorite;
}
mplay_fi_tcl_MPlayMediaObjectsItem& mplay_fi_tcl_MPlayMediaObjectsItem::operator=(const mplay_fi_tcl_MPlayMediaObjectsItem& coRef)
{
   if (this == &coRef) return *this;
   e8CategoryType = coRef.e8CategoryType;
   e8DeviceType = coRef.e8DeviceType;
   e8FileFormat = coRef.e8FileFormat;
   e8MediaType = coRef.e8MediaType;
   e8PlayableStatus = coRef.e8PlayableStatus;
   oThumbnailData = coRef.oThumbnailData;
   bIsPlaying = coRef.bIsPlaying;
   bReadOnlyFlag = coRef.bReadOnlyFlag;
   sAlbumArt = coRef.sAlbumArt;
   sCoverArt = coRef.sCoverArt;
   sDateTime = coRef.sDateTime;
   sDeviceVersion = coRef.sDeviceVersion;
   sFilename = coRef.sFilename;
   sMetaDataField1 = coRef.sMetaDataField1;
   sMetaDataField2 = coRef.sMetaDataField2;
   sMetaDataField3 = coRef.sMetaDataField3;
   sMetaDataField4 = coRef.sMetaDataField4;
   u32MetaDataTag1 = coRef.u32MetaDataTag1;
   u32MetaDataTag2 = coRef.u32MetaDataTag2;
   u32MetaDataTag3 = coRef.u32MetaDataTag3;
   u32MetaDataTag4 = coRef.u32MetaDataTag4;
   sYomiMetaDataTitle = coRef.sYomiMetaDataTitle;
   sYomiMetaDataArtist = coRef.sYomiMetaDataArtist;
   sYomiMetaDataAlbum = coRef.sYomiMetaDataAlbum;
   u32Tag = coRef.u32Tag;
   u32TotalPlaytime = coRef.u32TotalPlaytime;
   u32Year = coRef.u32Year;
   u32YearID = coRef.u32YearID;
   u64FileSize = coRef.u64FileSize;
   u8DeviceTag = coRef.u8DeviceTag;
   u8TrackNumber = coRef.u8TrackNumber;
   bIsFavorite = coRef.bIsFavorite;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayMediaObjectsItem::vDestroy()
{
   oThumbnailData.vDestroy(); 
   sAlbumArt.vDestroy();
   sCoverArt.vDestroy();
   sDateTime.vDestroy();
   sDeviceVersion.vDestroy();
   sFilename.vDestroy();
   sMetaDataField1.vDestroy();
   sMetaDataField2.vDestroy();
   sMetaDataField3.vDestroy();
   sMetaDataField4.vDestroy();
   sYomiMetaDataTitle.vDestroy();
   sYomiMetaDataArtist.vDestroy();
   sYomiMetaDataAlbum.vDestroy();
}

mplay_fi_tcl_MPlayMediaObjectsItem::mplay_fi_tcl_MPlayMediaObjectsItem()
:e8CategoryType()
,e8DeviceType()
,e8FileFormat()
,e8MediaType()
,e8PlayableStatus()
,oThumbnailData()
,bIsPlaying(0)
,bReadOnlyFlag(0)
,sAlbumArt()
,sCoverArt()
,sDateTime()
,sDeviceVersion()
,sFilename()
,sMetaDataField1()
,sMetaDataField2()
,sMetaDataField3()
,sMetaDataField4()
,u32MetaDataTag1(0)
,u32MetaDataTag2(0)
,u32MetaDataTag3(0)
,u32MetaDataTag4(0)
,sYomiMetaDataTitle()
,sYomiMetaDataArtist()
,sYomiMetaDataAlbum()
,u32Tag(0)
,u32TotalPlaytime(0)
,u32Year(0)
,u32YearID(0)
,u64FileSize(0)
,u8DeviceTag(0)
,u8TrackNumber(0)
,bIsFavorite(0)
 {}

tS32 mplay_fi_tcl_MPlayMediaObjectsItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYMEDIAOBJECTSITEM;
}


mplay_fi_tcl_MPlayMediaObjectsItem::~mplay_fi_tcl_MPlayMediaObjectsItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayMediaObjectsItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 50+oThumbnailData.u32GetSize(u16MajorVersion)+sAlbumArt.u32GetSize(u16MajorVersion)+sCoverArt.u32GetSize(u16MajorVersion)+sDateTime.u32GetSize(u16MajorVersion)+sDeviceVersion.u32GetSize(u16MajorVersion)+sFilename.u32GetSize(u16MajorVersion)+sMetaDataField1.u32GetSize(u16MajorVersion)+sMetaDataField2.u32GetSize(u16MajorVersion)+sMetaDataField3.u32GetSize(u16MajorVersion)+sMetaDataField4.u32GetSize(u16MajorVersion)+sYomiMetaDataTitle.u32GetSize(u16MajorVersion)+sYomiMetaDataArtist.u32GetSize(u16MajorVersion)+sYomiMetaDataAlbum.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayMediaObjectsItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CategoryType);
   (tVoid) (oIn >> e8DeviceType);
   (tVoid) (oIn >> e8FileFormat);
   (tVoid) (oIn >> e8MediaType);
   (tVoid) (oIn >> e8PlayableStatus);
   (tVoid) (oIn >> oThumbnailData);
   (tVoid) (oIn >> bIsPlaying);
   (tVoid) (oIn >> bReadOnlyFlag);
   (tVoid) (oIn >> sAlbumArt);
   (tVoid) (oIn >> sCoverArt);
   (tVoid) (oIn >> sDateTime);
   (tVoid) (oIn >> sDeviceVersion);
   (tVoid) (oIn >> sFilename);
   (tVoid) (oIn >> sMetaDataField1);
   (tVoid) (oIn >> sMetaDataField2);
   (tVoid) (oIn >> sMetaDataField3);
   (tVoid) (oIn >> sMetaDataField4);
   (tVoid) (oIn >> u32MetaDataTag1);
   (tVoid) (oIn >> u32MetaDataTag2);
   (tVoid) (oIn >> u32MetaDataTag3);
   (tVoid) (oIn >> u32MetaDataTag4);
   (tVoid) (oIn >> sYomiMetaDataTitle);
   (tVoid) (oIn >> sYomiMetaDataArtist);
   (tVoid) (oIn >> sYomiMetaDataAlbum);
   (tVoid) (oIn >> u32Tag);
   (tVoid) (oIn >> u32TotalPlaytime);
   (tVoid) (oIn >> u32Year);
   (tVoid) (oIn >> u32YearID);
   (tVoid) (oIn >> u64FileSize);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u8TrackNumber);
   (tVoid) (oIn >> bIsFavorite);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayMediaObjectsItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CategoryType);
   (tVoid) (oOut << e8DeviceType);
   (tVoid) (oOut << e8FileFormat);
   (tVoid) (oOut << e8MediaType);
   (tVoid) (oOut << e8PlayableStatus);
   (tVoid) (oOut << oThumbnailData);
   (tVoid) (oOut << bIsPlaying);
   (tVoid) (oOut << bReadOnlyFlag);
   (tVoid) (oOut << sAlbumArt);
   (tVoid) (oOut << sCoverArt);
   (tVoid) (oOut << sDateTime);
   (tVoid) (oOut << sDeviceVersion);
   (tVoid) (oOut << sFilename);
   (tVoid) (oOut << sMetaDataField1);
   (tVoid) (oOut << sMetaDataField2);
   (tVoid) (oOut << sMetaDataField3);
   (tVoid) (oOut << sMetaDataField4);
   (tVoid) (oOut << u32MetaDataTag1);
   (tVoid) (oOut << u32MetaDataTag2);
   (tVoid) (oOut << u32MetaDataTag3);
   (tVoid) (oOut << u32MetaDataTag4);
   (tVoid) (oOut << sYomiMetaDataTitle);
   (tVoid) (oOut << sYomiMetaDataArtist);
   (tVoid) (oOut << sYomiMetaDataAlbum);
   (tVoid) (oOut << u32Tag);
   (tVoid) (oOut << u32TotalPlaytime);
   (tVoid) (oOut << u32Year);
   (tVoid) (oOut << u32YearID);
   (tVoid) (oOut << u64FileSize);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u8TrackNumber);
   (tVoid) (oOut << bIsFavorite);
   return oOut;
}

tBool mplay_fi_tcl_MPlayMediaObjectsItem::operator==(const mplay_fi_tcl_MPlayMediaObjectsItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CategoryType == roRef.e8CategoryType);
   bResult = bResult && (e8DeviceType == roRef.e8DeviceType);
   bResult = bResult && (e8FileFormat == roRef.e8FileFormat);
   bResult = bResult && (e8MediaType == roRef.e8MediaType);
   bResult = bResult && (e8PlayableStatus == roRef.e8PlayableStatus);
   bResult = bResult && (oThumbnailData == roRef.oThumbnailData);
   bResult = bResult && (bIsPlaying == roRef.bIsPlaying);
   bResult = bResult && (bReadOnlyFlag == roRef.bReadOnlyFlag);
   bResult = bResult && (sAlbumArt == roRef.sAlbumArt);
   bResult = bResult && (sCoverArt == roRef.sCoverArt);
   bResult = bResult && (sDateTime == roRef.sDateTime);
   bResult = bResult && (sDeviceVersion == roRef.sDeviceVersion);
   bResult = bResult && (sFilename == roRef.sFilename);
   bResult = bResult && (sMetaDataField1 == roRef.sMetaDataField1);
   bResult = bResult && (sMetaDataField2 == roRef.sMetaDataField2);
   bResult = bResult && (sMetaDataField3 == roRef.sMetaDataField3);
   bResult = bResult && (sMetaDataField4 == roRef.sMetaDataField4);
   bResult = bResult && (u32MetaDataTag1 == roRef.u32MetaDataTag1);
   bResult = bResult && (u32MetaDataTag2 == roRef.u32MetaDataTag2);
   bResult = bResult && (u32MetaDataTag3 == roRef.u32MetaDataTag3);
   bResult = bResult && (u32MetaDataTag4 == roRef.u32MetaDataTag4);
   bResult = bResult && (sYomiMetaDataTitle == roRef.sYomiMetaDataTitle);
   bResult = bResult && (sYomiMetaDataArtist == roRef.sYomiMetaDataArtist);
   bResult = bResult && (sYomiMetaDataAlbum == roRef.sYomiMetaDataAlbum);
   bResult = bResult && (u32Tag == roRef.u32Tag);
   bResult = bResult && (u32TotalPlaytime == roRef.u32TotalPlaytime);
   bResult = bResult && (u32Year == roRef.u32Year);
   bResult = bResult && (u32YearID == roRef.u32YearID);
   bResult = bResult && (u64FileSize == roRef.u64FileSize);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u8TrackNumber == roRef.u8TrackNumber);
   bResult = bResult && (bIsFavorite == roRef.bIsFavorite);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayMediaObjects::mplay_fi_tcl_MPlayMediaObjects(const mplay_fi_tcl_MPlayMediaObjects& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayMediaObjects& mplay_fi_tcl_MPlayMediaObjects::operator=(const mplay_fi_tcl_MPlayMediaObjects& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayMediaObjects::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayMediaObjects::mplay_fi_tcl_MPlayMediaObjects()

 {}

tS32 mplay_fi_tcl_MPlayMediaObjects::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYMEDIAOBJECTS;
}


mplay_fi_tcl_MPlayMediaObjects::~mplay_fi_tcl_MPlayMediaObjects()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayMediaObjects::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayMediaObjects::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayMediaObjects::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayMediaObjects::operator==(const mplay_fi_tcl_MPlayMediaObjects& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayMediaObjectTag::mplay_fi_tcl_MPlayMediaObjectTag(const mplay_fi_tcl_MPlayMediaObjectTag& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   MediaObjectTag = coRef.MediaObjectTag;
}
mplay_fi_tcl_MPlayMediaObjectTag& mplay_fi_tcl_MPlayMediaObjectTag::operator=(const mplay_fi_tcl_MPlayMediaObjectTag& coRef)
{
   if (this == &coRef) return *this;
   MediaObjectTag = coRef.MediaObjectTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayMediaObjectTag::vDestroy()
{
   {
   MediaObjectTag.clear();
   }
}

mplay_fi_tcl_MPlayMediaObjectTag::mplay_fi_tcl_MPlayMediaObjectTag()

 {}

tS32 mplay_fi_tcl_MPlayMediaObjectTag::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYMEDIAOBJECTTAG;
}


mplay_fi_tcl_MPlayMediaObjectTag::~mplay_fi_tcl_MPlayMediaObjectTag()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayMediaObjectTag::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MediaObjectTag.size()*4);
}

fi_tclInContext& mplay_fi_tcl_MPlayMediaObjectTag::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      MediaObjectTag.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MediaObjectTag[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayMediaObjectTag::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MediaObjectTag.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MediaObjectTag.size(); ++u32Idx)
         (tVoid) (oOut << MediaObjectTag[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayMediaObjectTag::operator==(const mplay_fi_tcl_MPlayMediaObjectTag& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MediaObjectTag.size() == roRef.MediaObjectTag.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MediaObjectTag.size()); ++u32Idx)
            bResult = bResult && (MediaObjectTag[u32Idx] == roRef.MediaObjectTag[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayMediaObjectUrl::mplay_fi_tcl_MPlayMediaObjectUrl(const mplay_fi_tcl_MPlayMediaObjectUrl& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   sMediaObjectUrl = coRef.sMediaObjectUrl;
}
mplay_fi_tcl_MPlayMediaObjectUrl& mplay_fi_tcl_MPlayMediaObjectUrl::operator=(const mplay_fi_tcl_MPlayMediaObjectUrl& coRef)
{
   if (this == &coRef) return *this;
   sMediaObjectUrl = coRef.sMediaObjectUrl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayMediaObjectUrl::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < sMediaObjectUrl.size(); ++u32Idx)
         sMediaObjectUrl[u32Idx].vDestroy();
   sMediaObjectUrl.clear();
   }
}

mplay_fi_tcl_MPlayMediaObjectUrl::mplay_fi_tcl_MPlayMediaObjectUrl()

 {}

tS32 mplay_fi_tcl_MPlayMediaObjectUrl::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYMEDIAOBJECTURL;
}


mplay_fi_tcl_MPlayMediaObjectUrl::~mplay_fi_tcl_MPlayMediaObjectUrl()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayMediaObjectUrl::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < sMediaObjectUrl.size(); ++u32ListIdx)
      u32DynamicSize += sMediaObjectUrl[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayMediaObjectUrl::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < sMediaObjectUrl.size(); ++u32Idx)
      {
         sMediaObjectUrl[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      sMediaObjectUrl.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> sMediaObjectUrl[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayMediaObjectUrl::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)sMediaObjectUrl.size());
   {
      for (tU32 u32Idx = 0; u32Idx < sMediaObjectUrl.size(); ++u32Idx)
         (tVoid) (oOut << sMediaObjectUrl[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayMediaObjectUrl::operator==(const mplay_fi_tcl_MPlayMediaObjectUrl& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (sMediaObjectUrl.size() == roRef.sMediaObjectUrl.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < sMediaObjectUrl.size()); ++u32Idx)
            bResult = bResult && (sMediaObjectUrl[u32Idx] == roRef.sMediaObjectUrl[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_PermissionByTag::mplay_fi_tcl_PermissionByTag(const mplay_fi_tcl_PermissionByTag& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   bReadOnlyFlag = coRef.bReadOnlyFlag;
   MediaObjectTag = coRef.MediaObjectTag;
}
mplay_fi_tcl_PermissionByTag& mplay_fi_tcl_PermissionByTag::operator=(const mplay_fi_tcl_PermissionByTag& coRef)
{
   if (this == &coRef) return *this;
   bReadOnlyFlag = coRef.bReadOnlyFlag;
   MediaObjectTag = coRef.MediaObjectTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_PermissionByTag::mplay_fi_tcl_PermissionByTag()
:bReadOnlyFlag(0)
,MediaObjectTag(0)
 {}

tS32 mplay_fi_tcl_PermissionByTag::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_PERMISSIONBYTAG;
}


mplay_fi_tcl_PermissionByTag::~mplay_fi_tcl_PermissionByTag()
{}

tU32 mplay_fi_tcl_PermissionByTag::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_fi_tcl_PermissionByTag::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bReadOnlyFlag);
   (tVoid) (oIn >> MediaObjectTag);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_PermissionByTag::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bReadOnlyFlag);
   (tVoid) (oOut << MediaObjectTag);
   return oOut;
}

tBool mplay_fi_tcl_PermissionByTag::operator==(const mplay_fi_tcl_PermissionByTag& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bReadOnlyFlag == roRef.bReadOnlyFlag);
   bResult = bResult && (MediaObjectTag == roRef.MediaObjectTag);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayPlayListPosition::mplay_fi_tcl_MPlayPlayListPosition(const mplay_fi_tcl_MPlayPlayListPosition& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   Position = coRef.Position;
}
mplay_fi_tcl_MPlayPlayListPosition& mplay_fi_tcl_MPlayPlayListPosition::operator=(const mplay_fi_tcl_MPlayPlayListPosition& coRef)
{
   if (this == &coRef) return *this;
   Position = coRef.Position;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayPlayListPosition::vDestroy()
{
   {
   Position.clear();
   }
}

mplay_fi_tcl_MPlayPlayListPosition::mplay_fi_tcl_MPlayPlayListPosition()

 {}

tS32 mplay_fi_tcl_MPlayPlayListPosition::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYPLAYLISTPOSITION;
}


mplay_fi_tcl_MPlayPlayListPosition::~mplay_fi_tcl_MPlayPlayListPosition()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayPlayListPosition::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Position.size()*4);
}

fi_tclInContext& mplay_fi_tcl_MPlayPlayListPosition::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Position.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Position[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayPlayListPosition::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Position.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Position.size(); ++u32Idx)
         (tVoid) (oOut << Position[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayPlayListPosition::operator==(const mplay_fi_tcl_MPlayPlayListPosition& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Position.size() == roRef.Position.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Position.size()); ++u32Idx)
            bResult = bResult && (Position[u32Idx] == roRef.Position[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_MPlayRippingErrors::mplay_fi_tcl_MPlayRippingErrors():enType(FI_EN_E8RE_OK) {}

tS32 mplay_fi_tcl_MPlayRippingErrors::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYRIPPINGERRORS;
}


mplay_fi_tcl_MPlayRippingErrors::~mplay_fi_tcl_MPlayRippingErrors()
{}

tU32 mplay_fi_tcl_MPlayRippingErrors::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_MPlayRippingErrors::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayRippingErrors::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayRippingStateResultItem::mplay_fi_tcl_MPlayRippingStateResultItem(const mplay_fi_tcl_MPlayRippingStateResultItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8DeviceRippingState = coRef.e8DeviceRippingState;
   u8DeviceTag = coRef.u8DeviceTag;
   u8RippingPercentComplete = coRef.u8RippingPercentComplete;
   TotalTracksInCD = coRef.TotalTracksInCD;
   CurrentRippedTrackIndex = coRef.CurrentRippedTrackIndex;
}
mplay_fi_tcl_MPlayRippingStateResultItem& mplay_fi_tcl_MPlayRippingStateResultItem::operator=(const mplay_fi_tcl_MPlayRippingStateResultItem& coRef)
{
   if (this == &coRef) return *this;
   e8DeviceRippingState = coRef.e8DeviceRippingState;
   u8DeviceTag = coRef.u8DeviceTag;
   u8RippingPercentComplete = coRef.u8RippingPercentComplete;
   TotalTracksInCD = coRef.TotalTracksInCD;
   CurrentRippedTrackIndex = coRef.CurrentRippedTrackIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_MPlayRippingStateResultItem::mplay_fi_tcl_MPlayRippingStateResultItem()
:e8DeviceRippingState()
,u8DeviceTag(0)
,u8RippingPercentComplete(0)
,TotalTracksInCD(0)
,CurrentRippedTrackIndex(0)
 {}

tS32 mplay_fi_tcl_MPlayRippingStateResultItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYRIPPINGSTATERESULTITEM;
}


mplay_fi_tcl_MPlayRippingStateResultItem::~mplay_fi_tcl_MPlayRippingStateResultItem()
{}

tU32 mplay_fi_tcl_MPlayRippingStateResultItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_fi_tcl_MPlayRippingStateResultItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8DeviceRippingState);
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> u8RippingPercentComplete);
   (tVoid) (oIn >> TotalTracksInCD);
   (tVoid) (oIn >> CurrentRippedTrackIndex);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayRippingStateResultItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8DeviceRippingState);
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << u8RippingPercentComplete);
   (tVoid) (oOut << TotalTracksInCD);
   (tVoid) (oOut << CurrentRippedTrackIndex);
   return oOut;
}

tBool mplay_fi_tcl_MPlayRippingStateResultItem::operator==(const mplay_fi_tcl_MPlayRippingStateResultItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8DeviceRippingState == roRef.e8DeviceRippingState);
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (u8RippingPercentComplete == roRef.u8RippingPercentComplete);
   bResult = bResult && (TotalTracksInCD == roRef.TotalTracksInCD);
   bResult = bResult && (CurrentRippedTrackIndex == roRef.CurrentRippedTrackIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlaySearchKeyboardListItem::mplay_fi_tcl_MPlaySearchKeyboardListItem(const mplay_fi_tcl_MPlaySearchKeyboardListItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   bLetterAvailable = coRef.bLetterAvailable;
   sSearchKeyboardLetter = coRef.sSearchKeyboardLetter;
   u32LetterEndIndex = coRef.u32LetterEndIndex;
   u32LetterStartIndex = coRef.u32LetterStartIndex;
}
mplay_fi_tcl_MPlaySearchKeyboardListItem& mplay_fi_tcl_MPlaySearchKeyboardListItem::operator=(const mplay_fi_tcl_MPlaySearchKeyboardListItem& coRef)
{
   if (this == &coRef) return *this;
   bLetterAvailable = coRef.bLetterAvailable;
   sSearchKeyboardLetter = coRef.sSearchKeyboardLetter;
   u32LetterEndIndex = coRef.u32LetterEndIndex;
   u32LetterStartIndex = coRef.u32LetterStartIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlaySearchKeyboardListItem::vDestroy()
{
   sSearchKeyboardLetter.vDestroy();
}

mplay_fi_tcl_MPlaySearchKeyboardListItem::mplay_fi_tcl_MPlaySearchKeyboardListItem()
:bLetterAvailable(0)
,sSearchKeyboardLetter()
,u32LetterEndIndex(0)
,u32LetterStartIndex(0)
 {}

tS32 mplay_fi_tcl_MPlaySearchKeyboardListItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYSEARCHKEYBOARDLISTITEM;
}


mplay_fi_tcl_MPlaySearchKeyboardListItem::~mplay_fi_tcl_MPlaySearchKeyboardListItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlaySearchKeyboardListItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+sSearchKeyboardLetter.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlaySearchKeyboardListItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bLetterAvailable);
   (tVoid) (oIn >> sSearchKeyboardLetter);
   (tVoid) (oIn >> u32LetterEndIndex);
   (tVoid) (oIn >> u32LetterStartIndex);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlaySearchKeyboardListItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bLetterAvailable);
   (tVoid) (oOut << sSearchKeyboardLetter);
   (tVoid) (oOut << u32LetterEndIndex);
   (tVoid) (oOut << u32LetterStartIndex);
   return oOut;
}

tBool mplay_fi_tcl_MPlaySearchKeyboardListItem::operator==(const mplay_fi_tcl_MPlaySearchKeyboardListItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bLetterAvailable == roRef.bLetterAvailable);
   bResult = bResult && (sSearchKeyboardLetter == roRef.sSearchKeyboardLetter);
   bResult = bResult && (u32LetterEndIndex == roRef.u32LetterEndIndex);
   bResult = bResult && (u32LetterStartIndex == roRef.u32LetterStartIndex);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlaySearchKeyboardList::mplay_fi_tcl_MPlaySearchKeyboardList(const mplay_fi_tcl_MPlaySearchKeyboardList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlaySearchKeyboardList& mplay_fi_tcl_MPlaySearchKeyboardList::operator=(const mplay_fi_tcl_MPlaySearchKeyboardList& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlaySearchKeyboardList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlaySearchKeyboardList::mplay_fi_tcl_MPlaySearchKeyboardList()

 {}

tS32 mplay_fi_tcl_MPlaySearchKeyboardList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYSEARCHKEYBOARDLIST;
}


mplay_fi_tcl_MPlaySearchKeyboardList::~mplay_fi_tcl_MPlaySearchKeyboardList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlaySearchKeyboardList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlaySearchKeyboardList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlaySearchKeyboardList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlaySearchKeyboardList::operator==(const mplay_fi_tcl_MPlaySearchKeyboardList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayTagTransferItem_1::mplay_fi_tcl_MPlayTagTransferItem_1(const mplay_fi_tcl_MPlayTagTransferItem_1& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oUnknownData = coRef.oUnknownData;
   sPodCastFeedURL = coRef.sPodCastFeedURL;
   sStationURL = coRef.sStationURL;
   sStationURLFrequency = coRef.sStationURLFrequency;
   sTagAffiliateID = coRef.sTagAffiliateID;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtistName = coRef.sTagArtistName;
   sTagChannelName = coRef.sTagChannelName;
   sTagChannelNumber = coRef.sTagChannelNumber;
   sTagGenre = coRef.sTagGenre;
   sTagTimeStamp = coRef.sTagTimeStamp;
   sTagTrackName = coRef.sTagTrackName;
   u32TagSongID = coRef.u32TagSongID;
   u8AmbiguousTag = coRef.u8AmbiguousTag;
   u8ButtonPressed = coRef.u8ButtonPressed;
   u8TagProgramNumber = coRef.u8TagProgramNumber;
   u8TagStorefrontID = coRef.u8TagStorefrontID;
}
mplay_fi_tcl_MPlayTagTransferItem_1& mplay_fi_tcl_MPlayTagTransferItem_1::operator=(const mplay_fi_tcl_MPlayTagTransferItem_1& coRef)
{
   if (this == &coRef) return *this;
   oUnknownData = coRef.oUnknownData;
   sPodCastFeedURL = coRef.sPodCastFeedURL;
   sStationURL = coRef.sStationURL;
   sStationURLFrequency = coRef.sStationURLFrequency;
   sTagAffiliateID = coRef.sTagAffiliateID;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtistName = coRef.sTagArtistName;
   sTagChannelName = coRef.sTagChannelName;
   sTagChannelNumber = coRef.sTagChannelNumber;
   sTagGenre = coRef.sTagGenre;
   sTagTimeStamp = coRef.sTagTimeStamp;
   sTagTrackName = coRef.sTagTrackName;
   u32TagSongID = coRef.u32TagSongID;
   u8AmbiguousTag = coRef.u8AmbiguousTag;
   u8ButtonPressed = coRef.u8ButtonPressed;
   u8TagProgramNumber = coRef.u8TagProgramNumber;
   u8TagStorefrontID = coRef.u8TagStorefrontID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayTagTransferItem_1::vDestroy()
{
   oUnknownData.vDestroy(); 
   sPodCastFeedURL.vDestroy();
   sStationURL.vDestroy();
   sStationURLFrequency.vDestroy();
   sTagAffiliateID.vDestroy();
   sTagAlbum.vDestroy();
   sTagArtistName.vDestroy();
   sTagChannelName.vDestroy();
   sTagChannelNumber.vDestroy();
   sTagGenre.vDestroy();
   sTagTimeStamp.vDestroy();
   sTagTrackName.vDestroy();
}

mplay_fi_tcl_MPlayTagTransferItem_1::mplay_fi_tcl_MPlayTagTransferItem_1()
:oUnknownData()
,sPodCastFeedURL()
,sStationURL()
,sStationURLFrequency()
,sTagAffiliateID()
,sTagAlbum()
,sTagArtistName()
,sTagChannelName()
,sTagChannelNumber()
,sTagGenre()
,sTagTimeStamp()
,sTagTrackName()
,u32TagSongID(0)
,u8AmbiguousTag(0)
,u8ButtonPressed(0)
,u8TagProgramNumber(0)
,u8TagStorefrontID(0)
 {}

tS32 mplay_fi_tcl_MPlayTagTransferItem_1::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYTAGTRANSFERITEM_1;
}


mplay_fi_tcl_MPlayTagTransferItem_1::~mplay_fi_tcl_MPlayTagTransferItem_1()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayTagTransferItem_1::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+oUnknownData.u32GetSize(u16MajorVersion)+sPodCastFeedURL.u32GetSize(u16MajorVersion)+sStationURL.u32GetSize(u16MajorVersion)+sStationURLFrequency.u32GetSize(u16MajorVersion)+sTagAffiliateID.u32GetSize(u16MajorVersion)+sTagAlbum.u32GetSize(u16MajorVersion)+sTagArtistName.u32GetSize(u16MajorVersion)+sTagChannelName.u32GetSize(u16MajorVersion)+sTagChannelNumber.u32GetSize(u16MajorVersion)+sTagGenre.u32GetSize(u16MajorVersion)+sTagTimeStamp.u32GetSize(u16MajorVersion)+sTagTrackName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayTagTransferItem_1::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oUnknownData);
   (tVoid) (oIn >> sPodCastFeedURL);
   (tVoid) (oIn >> sStationURL);
   (tVoid) (oIn >> sStationURLFrequency);
   (tVoid) (oIn >> sTagAffiliateID);
   (tVoid) (oIn >> sTagAlbum);
   (tVoid) (oIn >> sTagArtistName);
   (tVoid) (oIn >> sTagChannelName);
   (tVoid) (oIn >> sTagChannelNumber);
   (tVoid) (oIn >> sTagGenre);
   (tVoid) (oIn >> sTagTimeStamp);
   (tVoid) (oIn >> sTagTrackName);
   (tVoid) (oIn >> u32TagSongID);
   (tVoid) (oIn >> u8AmbiguousTag);
   (tVoid) (oIn >> u8ButtonPressed);
   (tVoid) (oIn >> u8TagProgramNumber);
   (tVoid) (oIn >> u8TagStorefrontID);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayTagTransferItem_1::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oUnknownData);
   (tVoid) (oOut << sPodCastFeedURL);
   (tVoid) (oOut << sStationURL);
   (tVoid) (oOut << sStationURLFrequency);
   (tVoid) (oOut << sTagAffiliateID);
   (tVoid) (oOut << sTagAlbum);
   (tVoid) (oOut << sTagArtistName);
   (tVoid) (oOut << sTagChannelName);
   (tVoid) (oOut << sTagChannelNumber);
   (tVoid) (oOut << sTagGenre);
   (tVoid) (oOut << sTagTimeStamp);
   (tVoid) (oOut << sTagTrackName);
   (tVoid) (oOut << u32TagSongID);
   (tVoid) (oOut << u8AmbiguousTag);
   (tVoid) (oOut << u8ButtonPressed);
   (tVoid) (oOut << u8TagProgramNumber);
   (tVoid) (oOut << u8TagStorefrontID);
   return oOut;
}

tBool mplay_fi_tcl_MPlayTagTransferItem_1::operator==(const mplay_fi_tcl_MPlayTagTransferItem_1& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oUnknownData == roRef.oUnknownData);
   bResult = bResult && (sPodCastFeedURL == roRef.sPodCastFeedURL);
   bResult = bResult && (sStationURL == roRef.sStationURL);
   bResult = bResult && (sStationURLFrequency == roRef.sStationURLFrequency);
   bResult = bResult && (sTagAffiliateID == roRef.sTagAffiliateID);
   bResult = bResult && (sTagAlbum == roRef.sTagAlbum);
   bResult = bResult && (sTagArtistName == roRef.sTagArtistName);
   bResult = bResult && (sTagChannelName == roRef.sTagChannelName);
   bResult = bResult && (sTagChannelNumber == roRef.sTagChannelNumber);
   bResult = bResult && (sTagGenre == roRef.sTagGenre);
   bResult = bResult && (sTagTimeStamp == roRef.sTagTimeStamp);
   bResult = bResult && (sTagTrackName == roRef.sTagTrackName);
   bResult = bResult && (u32TagSongID == roRef.u32TagSongID);
   bResult = bResult && (u8AmbiguousTag == roRef.u8AmbiguousTag);
   bResult = bResult && (u8ButtonPressed == roRef.u8ButtonPressed);
   bResult = bResult && (u8TagProgramNumber == roRef.u8TagProgramNumber);
   bResult = bResult && (u8TagStorefrontID == roRef.u8TagStorefrontID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayTagTransferItem_2::mplay_fi_tcl_MPlayTagTransferItem_2(const mplay_fi_tcl_MPlayTagTransferItem_2& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oUnknownData = coRef.oUnknownData;
   sPodCastFeedURL = coRef.sPodCastFeedURL;
   sStationURL = coRef.sStationURL;
   sStationURLFrequency = coRef.sStationURLFrequency;
   sTagAffiliateID = coRef.sTagAffiliateID;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtistName = coRef.sTagArtistName;
   sTagChannelName = coRef.sTagChannelName;
   sTagChannelNumber = coRef.sTagChannelNumber;
   sTagGenre = coRef.sTagGenre;
   sTagTimeStamp = coRef.sTagTimeStamp;
   sTagTrackName = coRef.sTagTrackName;
   u32TagSongID = coRef.u32TagSongID;
   u32TagStorefrontID = coRef.u32TagStorefrontID;
   u8AmbiguousTag = coRef.u8AmbiguousTag;
   u8ButtonPressed = coRef.u8ButtonPressed;
   u8TagProgramNumber = coRef.u8TagProgramNumber;
}
mplay_fi_tcl_MPlayTagTransferItem_2& mplay_fi_tcl_MPlayTagTransferItem_2::operator=(const mplay_fi_tcl_MPlayTagTransferItem_2& coRef)
{
   if (this == &coRef) return *this;
   oUnknownData = coRef.oUnknownData;
   sPodCastFeedURL = coRef.sPodCastFeedURL;
   sStationURL = coRef.sStationURL;
   sStationURLFrequency = coRef.sStationURLFrequency;
   sTagAffiliateID = coRef.sTagAffiliateID;
   sTagAlbum = coRef.sTagAlbum;
   sTagArtistName = coRef.sTagArtistName;
   sTagChannelName = coRef.sTagChannelName;
   sTagChannelNumber = coRef.sTagChannelNumber;
   sTagGenre = coRef.sTagGenre;
   sTagTimeStamp = coRef.sTagTimeStamp;
   sTagTrackName = coRef.sTagTrackName;
   u32TagSongID = coRef.u32TagSongID;
   u32TagStorefrontID = coRef.u32TagStorefrontID;
   u8AmbiguousTag = coRef.u8AmbiguousTag;
   u8ButtonPressed = coRef.u8ButtonPressed;
   u8TagProgramNumber = coRef.u8TagProgramNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayTagTransferItem_2::vDestroy()
{
   oUnknownData.vDestroy(); 
   sPodCastFeedURL.vDestroy();
   sStationURL.vDestroy();
   sStationURLFrequency.vDestroy();
   sTagAffiliateID.vDestroy();
   sTagAlbum.vDestroy();
   sTagArtistName.vDestroy();
   sTagChannelName.vDestroy();
   sTagChannelNumber.vDestroy();
   sTagGenre.vDestroy();
   sTagTimeStamp.vDestroy();
   sTagTrackName.vDestroy();
}

mplay_fi_tcl_MPlayTagTransferItem_2::mplay_fi_tcl_MPlayTagTransferItem_2()
:oUnknownData()
,sPodCastFeedURL()
,sStationURL()
,sStationURLFrequency()
,sTagAffiliateID()
,sTagAlbum()
,sTagArtistName()
,sTagChannelName()
,sTagChannelNumber()
,sTagGenre()
,sTagTimeStamp()
,sTagTrackName()
,u32TagSongID(0)
,u32TagStorefrontID(0)
,u8AmbiguousTag(0)
,u8ButtonPressed(0)
,u8TagProgramNumber(0)
 {}

tS32 mplay_fi_tcl_MPlayTagTransferItem_2::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYTAGTRANSFERITEM_2;
}


mplay_fi_tcl_MPlayTagTransferItem_2::~mplay_fi_tcl_MPlayTagTransferItem_2()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayTagTransferItem_2::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+oUnknownData.u32GetSize(u16MajorVersion)+sPodCastFeedURL.u32GetSize(u16MajorVersion)+sStationURL.u32GetSize(u16MajorVersion)+sStationURLFrequency.u32GetSize(u16MajorVersion)+sTagAffiliateID.u32GetSize(u16MajorVersion)+sTagAlbum.u32GetSize(u16MajorVersion)+sTagArtistName.u32GetSize(u16MajorVersion)+sTagChannelName.u32GetSize(u16MajorVersion)+sTagChannelNumber.u32GetSize(u16MajorVersion)+sTagGenre.u32GetSize(u16MajorVersion)+sTagTimeStamp.u32GetSize(u16MajorVersion)+sTagTrackName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayTagTransferItem_2::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oUnknownData);
   (tVoid) (oIn >> sPodCastFeedURL);
   (tVoid) (oIn >> sStationURL);
   (tVoid) (oIn >> sStationURLFrequency);
   (tVoid) (oIn >> sTagAffiliateID);
   (tVoid) (oIn >> sTagAlbum);
   (tVoid) (oIn >> sTagArtistName);
   (tVoid) (oIn >> sTagChannelName);
   (tVoid) (oIn >> sTagChannelNumber);
   (tVoid) (oIn >> sTagGenre);
   (tVoid) (oIn >> sTagTimeStamp);
   (tVoid) (oIn >> sTagTrackName);
   (tVoid) (oIn >> u32TagSongID);
   (tVoid) (oIn >> u32TagStorefrontID);
   (tVoid) (oIn >> u8AmbiguousTag);
   (tVoid) (oIn >> u8ButtonPressed);
   (tVoid) (oIn >> u8TagProgramNumber);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayTagTransferItem_2::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oUnknownData);
   (tVoid) (oOut << sPodCastFeedURL);
   (tVoid) (oOut << sStationURL);
   (tVoid) (oOut << sStationURLFrequency);
   (tVoid) (oOut << sTagAffiliateID);
   (tVoid) (oOut << sTagAlbum);
   (tVoid) (oOut << sTagArtistName);
   (tVoid) (oOut << sTagChannelName);
   (tVoid) (oOut << sTagChannelNumber);
   (tVoid) (oOut << sTagGenre);
   (tVoid) (oOut << sTagTimeStamp);
   (tVoid) (oOut << sTagTrackName);
   (tVoid) (oOut << u32TagSongID);
   (tVoid) (oOut << u32TagStorefrontID);
   (tVoid) (oOut << u8AmbiguousTag);
   (tVoid) (oOut << u8ButtonPressed);
   (tVoid) (oOut << u8TagProgramNumber);
   return oOut;
}

tBool mplay_fi_tcl_MPlayTagTransferItem_2::operator==(const mplay_fi_tcl_MPlayTagTransferItem_2& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oUnknownData == roRef.oUnknownData);
   bResult = bResult && (sPodCastFeedURL == roRef.sPodCastFeedURL);
   bResult = bResult && (sStationURL == roRef.sStationURL);
   bResult = bResult && (sStationURLFrequency == roRef.sStationURLFrequency);
   bResult = bResult && (sTagAffiliateID == roRef.sTagAffiliateID);
   bResult = bResult && (sTagAlbum == roRef.sTagAlbum);
   bResult = bResult && (sTagArtistName == roRef.sTagArtistName);
   bResult = bResult && (sTagChannelName == roRef.sTagChannelName);
   bResult = bResult && (sTagChannelNumber == roRef.sTagChannelNumber);
   bResult = bResult && (sTagGenre == roRef.sTagGenre);
   bResult = bResult && (sTagTimeStamp == roRef.sTagTimeStamp);
   bResult = bResult && (sTagTrackName == roRef.sTagTrackName);
   bResult = bResult && (u32TagSongID == roRef.u32TagSongID);
   bResult = bResult && (u32TagStorefrontID == roRef.u32TagStorefrontID);
   bResult = bResult && (u8AmbiguousTag == roRef.u8AmbiguousTag);
   bResult = bResult && (u8ButtonPressed == roRef.u8ButtonPressed);
   bResult = bResult && (u8TagProgramNumber == roRef.u8TagProgramNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayTagTransfer_1::mplay_fi_tcl_MPlayTagTransfer_1(const mplay_fi_tcl_MPlayTagTransfer_1& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayTagTransfer_1& mplay_fi_tcl_MPlayTagTransfer_1::operator=(const mplay_fi_tcl_MPlayTagTransfer_1& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayTagTransfer_1::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayTagTransfer_1::mplay_fi_tcl_MPlayTagTransfer_1()

 {}

tS32 mplay_fi_tcl_MPlayTagTransfer_1::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYTAGTRANSFER_1;
}


mplay_fi_tcl_MPlayTagTransfer_1::~mplay_fi_tcl_MPlayTagTransfer_1()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayTagTransfer_1::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayTagTransfer_1::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayTagTransfer_1::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayTagTransfer_1::operator==(const mplay_fi_tcl_MPlayTagTransfer_1& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayTagTransfer_2::mplay_fi_tcl_MPlayTagTransfer_2(const mplay_fi_tcl_MPlayTagTransfer_2& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayTagTransfer_2& mplay_fi_tcl_MPlayTagTransfer_2::operator=(const mplay_fi_tcl_MPlayTagTransfer_2& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayTagTransfer_2::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayTagTransfer_2::mplay_fi_tcl_MPlayTagTransfer_2()

 {}

tS32 mplay_fi_tcl_MPlayTagTransfer_2::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYTAGTRANSFER_2;
}


mplay_fi_tcl_MPlayTagTransfer_2::~mplay_fi_tcl_MPlayTagTransfer_2()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayTagTransfer_2::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayTagTransfer_2::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayTagTransfer_2::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayTagTransfer_2::operator==(const mplay_fi_tcl_MPlayTagTransfer_2& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayUntransferredTagStreamItem::mplay_fi_tcl_MPlayUntransferredTagStreamItem(const mplay_fi_tcl_MPlayUntransferredTagStreamItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   sTagArtistName = coRef.sTagArtistName;
   sTagTrackName = coRef.sTagTrackName;
   u32TagSongID = coRef.u32TagSongID;
}
mplay_fi_tcl_MPlayUntransferredTagStreamItem& mplay_fi_tcl_MPlayUntransferredTagStreamItem::operator=(const mplay_fi_tcl_MPlayUntransferredTagStreamItem& coRef)
{
   if (this == &coRef) return *this;
   sTagArtistName = coRef.sTagArtistName;
   sTagTrackName = coRef.sTagTrackName;
   u32TagSongID = coRef.u32TagSongID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayUntransferredTagStreamItem::vDestroy()
{
   sTagArtistName.vDestroy();
   sTagTrackName.vDestroy();
}

mplay_fi_tcl_MPlayUntransferredTagStreamItem::mplay_fi_tcl_MPlayUntransferredTagStreamItem()
:sTagArtistName()
,sTagTrackName()
,u32TagSongID(0)
 {}

tS32 mplay_fi_tcl_MPlayUntransferredTagStreamItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYUNTRANSFERREDTAGSTREAMITEM;
}


mplay_fi_tcl_MPlayUntransferredTagStreamItem::~mplay_fi_tcl_MPlayUntransferredTagStreamItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayUntransferredTagStreamItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sTagArtistName.u32GetSize(u16MajorVersion)+sTagTrackName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_MPlayUntransferredTagStreamItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sTagArtistName);
   (tVoid) (oIn >> sTagTrackName);
   (tVoid) (oIn >> u32TagSongID);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayUntransferredTagStreamItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sTagArtistName);
   (tVoid) (oOut << sTagTrackName);
   (tVoid) (oOut << u32TagSongID);
   return oOut;
}

tBool mplay_fi_tcl_MPlayUntransferredTagStreamItem::operator==(const mplay_fi_tcl_MPlayUntransferredTagStreamItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sTagArtistName == roRef.sTagArtistName);
   bResult = bResult && (sTagTrackName == roRef.sTagTrackName);
   bResult = bResult && (u32TagSongID == roRef.u32TagSongID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayUntransferredTagStream::mplay_fi_tcl_MPlayUntransferredTagStream(const mplay_fi_tcl_MPlayUntransferredTagStream& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayUntransferredTagStream& mplay_fi_tcl_MPlayUntransferredTagStream::operator=(const mplay_fi_tcl_MPlayUntransferredTagStream& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayUntransferredTagStream::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayUntransferredTagStream::mplay_fi_tcl_MPlayUntransferredTagStream()

 {}

tS32 mplay_fi_tcl_MPlayUntransferredTagStream::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYUNTRANSFERREDTAGSTREAM;
}


mplay_fi_tcl_MPlayUntransferredTagStream::~mplay_fi_tcl_MPlayUntransferredTagStream()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayUntransferredTagStream::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayUntransferredTagStream::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayUntransferredTagStream::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayUntransferredTagStream::operator==(const mplay_fi_tcl_MPlayUntransferredTagStream& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayPermissionByTag::mplay_fi_tcl_MPlayPermissionByTag(const mplay_fi_tcl_MPlayPermissionByTag& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   PermissionTag = coRef.PermissionTag;
}
mplay_fi_tcl_MPlayPermissionByTag& mplay_fi_tcl_MPlayPermissionByTag::operator=(const mplay_fi_tcl_MPlayPermissionByTag& coRef)
{
   if (this == &coRef) return *this;
   PermissionTag = coRef.PermissionTag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayPermissionByTag::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PermissionTag.size(); ++u32Idx)
         PermissionTag[u32Idx].vDestroy();
   PermissionTag.clear();
   }
}

mplay_fi_tcl_MPlayPermissionByTag::mplay_fi_tcl_MPlayPermissionByTag()

 {}

tS32 mplay_fi_tcl_MPlayPermissionByTag::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYPERMISSIONBYTAG;
}


mplay_fi_tcl_MPlayPermissionByTag::~mplay_fi_tcl_MPlayPermissionByTag()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayPermissionByTag::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(PermissionTag.size()*5);
}

fi_tclInContext& mplay_fi_tcl_MPlayPermissionByTag::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PermissionTag.size(); ++u32Idx)
      {
         PermissionTag[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PermissionTag.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PermissionTag[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayPermissionByTag::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)PermissionTag.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PermissionTag.size(); ++u32Idx)
         (tVoid) (oOut << PermissionTag[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayPermissionByTag::operator==(const mplay_fi_tcl_MPlayPermissionByTag& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (PermissionTag.size() == roRef.PermissionTag.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PermissionTag.size()); ++u32Idx)
            bResult = bResult && (PermissionTag[u32Idx] == roRef.PermissionTag[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_SearchString::mplay_fi_tcl_SearchString(const mplay_fi_tcl_SearchString& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   sText = coRef.sText;
   u8Encoding = coRef.u8Encoding;
}
mplay_fi_tcl_SearchString& mplay_fi_tcl_SearchString::operator=(const mplay_fi_tcl_SearchString& coRef)
{
   if (this == &coRef) return *this;
   sText = coRef.sText;
   u8Encoding = coRef.u8Encoding;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_SearchString::vDestroy()
{
   sText.vDestroy();
}

mplay_fi_tcl_SearchString::mplay_fi_tcl_SearchString()
:sText()
,u8Encoding(0)
 {}

tS32 mplay_fi_tcl_SearchString::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_SEARCHSTRING;
}


mplay_fi_tcl_SearchString::~mplay_fi_tcl_SearchString()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_SearchString::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sText.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_SearchString::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sText);
   (tVoid) (oIn >> u8Encoding);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_SearchString::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sText);
   (tVoid) (oOut << u8Encoding);
   return oOut;
}

tBool mplay_fi_tcl_SearchString::operator==(const mplay_fi_tcl_SearchString& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sText == roRef.sText);
   bResult = bResult && (u8Encoding == roRef.u8Encoding);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_MPlaySearchType::mplay_fi_tcl_MPlaySearchType():enType(FI_EN_E8GLOBAL_AUDIO_INDEXED_SEARCH) {}

tS32 mplay_fi_tcl_MPlaySearchType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYSEARCHTYPE;
}


mplay_fi_tcl_MPlaySearchType::~mplay_fi_tcl_MPlaySearchType()
{}

tU32 mplay_fi_tcl_MPlaySearchType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_MPlaySearchType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlaySearchType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_VideoScalingType::mplay_fi_tcl_VideoScalingType():enType(FI_EN_EUNSPECIFIED) {}

tS32 mplay_fi_tcl_VideoScalingType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_VIDEOSCALINGTYPE;
}


mplay_fi_tcl_VideoScalingType::~mplay_fi_tcl_VideoScalingType()
{}

tU32 mplay_fi_tcl_VideoScalingType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_VideoScalingType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_VideoScalingType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_IndicesType::mplay_fi_tcl_IndicesType():enType(FI_EN_INDEX_RANGE) {}

tS32 mplay_fi_tcl_IndicesType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_INDICESTYPE;
}


mplay_fi_tcl_IndicesType::~mplay_fi_tcl_IndicesType()
{}

tU32 mplay_fi_tcl_IndicesType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_IndicesType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_IndicesType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_IndicesList::mplay_fi_tcl_IndicesList(const mplay_fi_tcl_IndicesList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_IndicesList& mplay_fi_tcl_IndicesList::operator=(const mplay_fi_tcl_IndicesList& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_IndicesList::vDestroy()
{
   {
   oItems.clear();
   }
}

mplay_fi_tcl_IndicesList::mplay_fi_tcl_IndicesList()

 {}

tS32 mplay_fi_tcl_IndicesList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_INDICESLIST;
}


mplay_fi_tcl_IndicesList::~mplay_fi_tcl_IndicesList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_IndicesList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(oItems.size()*4);
}

fi_tclInContext& mplay_fi_tcl_IndicesList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_IndicesList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_IndicesList::operator==(const mplay_fi_tcl_IndicesList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_AlbumArtUrlList::mplay_fi_tcl_AlbumArtUrlList(const mplay_fi_tcl_AlbumArtUrlList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_AlbumArtUrlList& mplay_fi_tcl_AlbumArtUrlList::operator=(const mplay_fi_tcl_AlbumArtUrlList& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_AlbumArtUrlList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_AlbumArtUrlList::mplay_fi_tcl_AlbumArtUrlList()

 {}

tS32 mplay_fi_tcl_AlbumArtUrlList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_ALBUMARTURLLIST;
}


mplay_fi_tcl_AlbumArtUrlList::~mplay_fi_tcl_AlbumArtUrlList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_AlbumArtUrlList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_AlbumArtUrlList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_AlbumArtUrlList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_AlbumArtUrlList::operator==(const mplay_fi_tcl_AlbumArtUrlList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_MPlayHIDCommand::mplay_fi_tcl_e_MPlayHIDCommand():enType(FI_EN_HID_PLAY) {}

tS32 mplay_fi_tcl_e_MPlayHIDCommand::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_MPLAYHIDCOMMAND;
}


mplay_fi_tcl_e_MPlayHIDCommand::~mplay_fi_tcl_e_MPlayHIDCommand()
{}

tU32 mplay_fi_tcl_e_MPlayHIDCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_MPlayHIDCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_MPlayHIDCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_MPlayKeyEvent::mplay_fi_tcl_e_MPlayKeyEvent():enType(FI_EN_KEY_PRESS) {}

tS32 mplay_fi_tcl_e_MPlayKeyEvent::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_MPLAYKEYEVENT;
}


mplay_fi_tcl_e_MPlayKeyEvent::~mplay_fi_tcl_e_MPlayKeyEvent()
{}

tU32 mplay_fi_tcl_e_MPlayKeyEvent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_MPlayKeyEvent::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_MPlayKeyEvent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_MPlayDeviceInfo::mplay_fi_tcl_MPlayDeviceInfo(const mplay_fi_tcl_MPlayDeviceInfo& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_MPlayDeviceInfo& mplay_fi_tcl_MPlayDeviceInfo::operator=(const mplay_fi_tcl_MPlayDeviceInfo& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_MPlayDeviceInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_MPlayDeviceInfo::mplay_fi_tcl_MPlayDeviceInfo()

 {}

tS32 mplay_fi_tcl_MPlayDeviceInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_MPLAYDEVICEINFO;
}


mplay_fi_tcl_MPlayDeviceInfo::~mplay_fi_tcl_MPlayDeviceInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_MPlayDeviceInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_MPlayDeviceInfo::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_MPlayDeviceInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_MPlayDeviceInfo::operator==(const mplay_fi_tcl_MPlayDeviceInfo& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DeviceConnectStatus::mplay_fi_tcl_e8_DeviceConnectStatus():enType(FI_EN_USB_DEV_CONNECTED) {}

tS32 mplay_fi_tcl_e8_DeviceConnectStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DEVICECONNECTSTATUS;
}


mplay_fi_tcl_e8_DeviceConnectStatus::~mplay_fi_tcl_e8_DeviceConnectStatus()
{}

tU32 mplay_fi_tcl_e8_DeviceConnectStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DeviceConnectStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DeviceConnectStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_Device::mplay_fi_tcl_e8_Device():enType(FI_EN_DTY_BTA) {}

tS32 mplay_fi_tcl_e8_Device::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DEVICE;
}


mplay_fi_tcl_e8_Device::~mplay_fi_tcl_e8_Device()
{}

tU32 mplay_fi_tcl_e8_Device::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_Device::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_Device::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DevManager_PortStates::mplay_fi_tcl_DevManager_PortStates(const mplay_fi_tcl_DevManager_PortStates& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   ElectricalFailure = coRef.ElectricalFailure;
   HubConnected = coRef.HubConnected;
   OpenCircuit = coRef.OpenCircuit;
   OverCurrent = coRef.OverCurrent;
   UnderVoltage = coRef.UnderVoltage;
   USBPortConfiguredUsed = coRef.USBPortConfiguredUsed;
   USBPowerON = coRef.USBPowerON;
   USBPortNo = coRef.USBPortNo;
}
mplay_fi_tcl_DevManager_PortStates& mplay_fi_tcl_DevManager_PortStates::operator=(const mplay_fi_tcl_DevManager_PortStates& coRef)
{
   if (this == &coRef) return *this;
   ElectricalFailure = coRef.ElectricalFailure;
   HubConnected = coRef.HubConnected;
   OpenCircuit = coRef.OpenCircuit;
   OverCurrent = coRef.OverCurrent;
   UnderVoltage = coRef.UnderVoltage;
   USBPortConfiguredUsed = coRef.USBPortConfiguredUsed;
   USBPowerON = coRef.USBPowerON;
   USBPortNo = coRef.USBPortNo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DevManager_PortStates::mplay_fi_tcl_DevManager_PortStates()
:ElectricalFailure(0)
,HubConnected(0)
,OpenCircuit(0)
,OverCurrent(0)
,UnderVoltage(0)
,USBPortConfiguredUsed(0)
,USBPowerON(0)
,USBPortNo(0)
 {}

tS32 mplay_fi_tcl_DevManager_PortStates::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DEVMANAGER_PORTSTATES;
}


mplay_fi_tcl_DevManager_PortStates::~mplay_fi_tcl_DevManager_PortStates()
{}

tU32 mplay_fi_tcl_DevManager_PortStates::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_fi_tcl_DevManager_PortStates::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ElectricalFailure);
   (tVoid) (oIn >> HubConnected);
   (tVoid) (oIn >> OpenCircuit);
   (tVoid) (oIn >> OverCurrent);
   (tVoid) (oIn >> UnderVoltage);
   (tVoid) (oIn >> USBPortConfiguredUsed);
   (tVoid) (oIn >> USBPowerON);
   (tVoid) (oIn >> USBPortNo);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DevManager_PortStates::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ElectricalFailure);
   (tVoid) (oOut << HubConnected);
   (tVoid) (oOut << OpenCircuit);
   (tVoid) (oOut << OverCurrent);
   (tVoid) (oOut << UnderVoltage);
   (tVoid) (oOut << USBPortConfiguredUsed);
   (tVoid) (oOut << USBPowerON);
   (tVoid) (oOut << USBPortNo);
   return oOut;
}

tBool mplay_fi_tcl_DevManager_PortStates::operator==(const mplay_fi_tcl_DevManager_PortStates& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ElectricalFailure == roRef.ElectricalFailure);
   bResult = bResult && (HubConnected == roRef.HubConnected);
   bResult = bResult && (OpenCircuit == roRef.OpenCircuit);
   bResult = bResult && (OverCurrent == roRef.OverCurrent);
   bResult = bResult && (UnderVoltage == roRef.UnderVoltage);
   bResult = bResult && (USBPortConfiguredUsed == roRef.USBPortConfiguredUsed);
   bResult = bResult && (USBPowerON == roRef.USBPowerON);
   bResult = bResult && (USBPortNo == roRef.USBPortNo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DVM_CardIdentifierRegister::mplay_fi_tcl_DVM_CardIdentifierRegister(const mplay_fi_tcl_DVM_CardIdentifierRegister& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   CID = coRef.CID;
}
mplay_fi_tcl_DVM_CardIdentifierRegister& mplay_fi_tcl_DVM_CardIdentifierRegister::operator=(const mplay_fi_tcl_DVM_CardIdentifierRegister& coRef)
{
   if (this == &coRef) return *this;
   CID = coRef.CID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DVM_CardIdentifierRegister::vDestroy()
{
   {
   CID.clear();
   }
}

mplay_fi_tcl_DVM_CardIdentifierRegister::mplay_fi_tcl_DVM_CardIdentifierRegister()

 {}

tS32 mplay_fi_tcl_DVM_CardIdentifierRegister::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DVM_CARDIDENTIFIERREGISTER;
}


mplay_fi_tcl_DVM_CardIdentifierRegister::~mplay_fi_tcl_DVM_CardIdentifierRegister()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DVM_CardIdentifierRegister::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(CID.size()*1);
}

fi_tclInContext& mplay_fi_tcl_DVM_CardIdentifierRegister::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      CID.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CID[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DVM_CardIdentifierRegister::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)CID.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CID.size(); ++u32Idx)
         (tVoid) (oOut << CID[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DVM_CardIdentifierRegister::operator==(const mplay_fi_tcl_DVM_CardIdentifierRegister& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (CID.size() == roRef.CID.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CID.size()); ++u32Idx)
            bResult = bResult && (CID[u32Idx] == roRef.CID[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DVM_MediaState::mplay_fi_tcl_e8_DVM_MediaState():enType(FI_EN_MEDIA_NOT_READY) {}

tS32 mplay_fi_tcl_e8_DVM_MediaState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DVM_MEDIASTATE;
}


mplay_fi_tcl_e8_DVM_MediaState::~mplay_fi_tcl_e8_DVM_MediaState()
{}

tU32 mplay_fi_tcl_e8_DVM_MediaState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DVM_MediaState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DVM_MediaState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::mplay_fi_tcl_e8_DVM_DeviceSpeedUsb():enType(FI_EN_FULL_SPEED) {}

tS32 mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DVM_DEVICESPEEDUSB;
}


mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::~mplay_fi_tcl_e8_DVM_DeviceSpeedUsb()
{}

tU32 mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DVM_DeviceSpeedUsb::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DVM_UnsupportedReason::mplay_fi_tcl_e8_DVM_UnsupportedReason():enType(FI_EN_DISABLEDINCONFIGURATION) {}

tS32 mplay_fi_tcl_e8_DVM_UnsupportedReason::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DVM_UNSUPPORTEDREASON;
}


mplay_fi_tcl_e8_DVM_UnsupportedReason::~mplay_fi_tcl_e8_DVM_UnsupportedReason()
{}

tU32 mplay_fi_tcl_e8_DVM_UnsupportedReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DVM_UnsupportedReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DVM_UnsupportedReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_FileSystem::mplay_fi_tcl_e8_FileSystem():enType(FI_EN_FSTY_EXFAT) {}

tS32 mplay_fi_tcl_e8_FileSystem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_FILESYSTEM;
}


mplay_fi_tcl_e8_FileSystem::~mplay_fi_tcl_e8_FileSystem()
{}

tU32 mplay_fi_tcl_e8_FileSystem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_FileSystem::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_FileSystem::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DVM_MediaType::mplay_fi_tcl_e8_DVM_MediaType():enType(FI_EN_DATA_MEDIA) {}

tS32 mplay_fi_tcl_e8_DVM_MediaType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DVM_MEDIATYPE;
}


mplay_fi_tcl_e8_DVM_MediaType::~mplay_fi_tcl_e8_DVM_MediaType()
{}

tU32 mplay_fi_tcl_e8_DVM_MediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DVM_MediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DVM_MediaType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_PowerStatus::mplay_fi_tcl_e8_PowerStatus():enType(FI_EN_POWER_STATUS_INIT) {}

tS32 mplay_fi_tcl_e8_PowerStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_POWERSTATUS;
}


mplay_fi_tcl_e8_PowerStatus::~mplay_fi_tcl_e8_PowerStatus()
{}

tU32 mplay_fi_tcl_e8_PowerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_PowerStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_PowerStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DevManager_DeviceProperty::mplay_fi_tcl_DevManager_DeviceProperty(const mplay_fi_tcl_DevManager_DeviceProperty& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   DeviceConnectStatus = coRef.DeviceConnectStatus;
   DeviceType = coRef.DeviceType;
   DeviceSpeedUsb = coRef.DeviceSpeedUsb;
   UnsupportedReason = coRef.UnsupportedReason;
   FileSystemType = coRef.FileSystemType;
   AccessoryName2 = coRef.AccessoryName2;
   AccessoryName = coRef.AccessoryName;
   DeviceName = coRef.DeviceName;
   DeviceSerialNo = coRef.DeviceSerialNo;
   DeviceVersion = coRef.DeviceVersion;
   Manufacturer = coRef.Manufacturer;
   MountPoint = coRef.MountPoint;
   USBPortNo = coRef.USBPortNo;
   ProductID = coRef.ProductID;
   VendorID = coRef.VendorID;
   FreeSize_kB = coRef.FreeSize_kB;
   TotalSize_kB = coRef.TotalSize_kB;
   TotalSize = coRef.TotalSize;
   UsedSize_kB = coRef.UsedSize_kB;
   BaseClassCodeUsb = coRef.BaseClassCodeUsb;
   ParitionNum = coRef.ParitionNum;
   ProtocolUsb = coRef.ProtocolUsb;
   SubClassCodeUsb = coRef.SubClassCodeUsb;
   DevicePath = coRef.DevicePath;
   DeviceNode = coRef.DeviceNode;
}
mplay_fi_tcl_DevManager_DeviceProperty& mplay_fi_tcl_DevManager_DeviceProperty::operator=(const mplay_fi_tcl_DevManager_DeviceProperty& coRef)
{
   if (this == &coRef) return *this;
   DeviceConnectStatus = coRef.DeviceConnectStatus;
   DeviceType = coRef.DeviceType;
   DeviceSpeedUsb = coRef.DeviceSpeedUsb;
   UnsupportedReason = coRef.UnsupportedReason;
   FileSystemType = coRef.FileSystemType;
   AccessoryName2 = coRef.AccessoryName2;
   AccessoryName = coRef.AccessoryName;
   DeviceName = coRef.DeviceName;
   DeviceSerialNo = coRef.DeviceSerialNo;
   DeviceVersion = coRef.DeviceVersion;
   Manufacturer = coRef.Manufacturer;
   MountPoint = coRef.MountPoint;
   USBPortNo = coRef.USBPortNo;
   ProductID = coRef.ProductID;
   VendorID = coRef.VendorID;
   FreeSize_kB = coRef.FreeSize_kB;
   TotalSize_kB = coRef.TotalSize_kB;
   TotalSize = coRef.TotalSize;
   UsedSize_kB = coRef.UsedSize_kB;
   BaseClassCodeUsb = coRef.BaseClassCodeUsb;
   ParitionNum = coRef.ParitionNum;
   ProtocolUsb = coRef.ProtocolUsb;
   SubClassCodeUsb = coRef.SubClassCodeUsb;
   DevicePath = coRef.DevicePath;
   DeviceNode = coRef.DeviceNode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DevManager_DeviceProperty::vDestroy()
{
   AccessoryName2.vDestroy();
   AccessoryName.vDestroy();
   DeviceName.vDestroy();
   DeviceSerialNo.vDestroy();
   DeviceVersion.vDestroy();
   Manufacturer.vDestroy();
   MountPoint.vDestroy();
   USBPortNo.vDestroy();
   DevicePath.vDestroy();
   DeviceNode.vDestroy();
}

mplay_fi_tcl_DevManager_DeviceProperty::mplay_fi_tcl_DevManager_DeviceProperty()
:DeviceConnectStatus()
,DeviceType()
,DeviceSpeedUsb()
,UnsupportedReason()
,FileSystemType()
,AccessoryName2()
,AccessoryName()
,DeviceName()
,DeviceSerialNo()
,DeviceVersion()
,Manufacturer()
,MountPoint()
,USBPortNo()
,ProductID(0)
,VendorID(0)
,FreeSize_kB(0)
,TotalSize_kB(0)
,TotalSize(0)
,UsedSize_kB(0)
,BaseClassCodeUsb(0)
,ParitionNum(0)
,ProtocolUsb(0)
,SubClassCodeUsb(0)
,DevicePath()
,DeviceNode()
 {}

tS32 mplay_fi_tcl_DevManager_DeviceProperty::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY;
}


mplay_fi_tcl_DevManager_DeviceProperty::~mplay_fi_tcl_DevManager_DeviceProperty()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DevManager_DeviceProperty::u32GetSize(tU16 u16MajorVersion) const
{
   return 45+AccessoryName2.u32GetSize(u16MajorVersion)+AccessoryName.u32GetSize(u16MajorVersion)+DeviceName.u32GetSize(u16MajorVersion)+DeviceSerialNo.u32GetSize(u16MajorVersion)+DeviceVersion.u32GetSize(u16MajorVersion)+Manufacturer.u32GetSize(u16MajorVersion)+MountPoint.u32GetSize(u16MajorVersion)+USBPortNo.u32GetSize(u16MajorVersion)+DevicePath.u32GetSize(u16MajorVersion)+DeviceNode.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_DevManager_DeviceProperty::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DeviceConnectStatus);
   (tVoid) (oIn >> DeviceType);
   (tVoid) (oIn >> DeviceSpeedUsb);
   (tVoid) (oIn >> UnsupportedReason);
   (tVoid) (oIn >> FileSystemType);
   (tVoid) (oIn >> AccessoryName2);
   (tVoid) (oIn >> AccessoryName);
   (tVoid) (oIn >> DeviceName);
   (tVoid) (oIn >> DeviceSerialNo);
   (tVoid) (oIn >> DeviceVersion);
   (tVoid) (oIn >> Manufacturer);
   (tVoid) (oIn >> MountPoint);
   (tVoid) (oIn >> USBPortNo);
   (tVoid) (oIn >> ProductID);
   (tVoid) (oIn >> VendorID);
   (tVoid) (oIn >> FreeSize_kB);
   (tVoid) (oIn >> TotalSize_kB);
   (tVoid) (oIn >> TotalSize);
   (tVoid) (oIn >> UsedSize_kB);
   (tVoid) (oIn >> BaseClassCodeUsb);
   (tVoid) (oIn >> ParitionNum);
   (tVoid) (oIn >> ProtocolUsb);
   (tVoid) (oIn >> SubClassCodeUsb);
   (tVoid) (oIn >> DevicePath);
   (tVoid) (oIn >> DeviceNode);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DevManager_DeviceProperty::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DeviceConnectStatus);
   (tVoid) (oOut << DeviceType);
   (tVoid) (oOut << DeviceSpeedUsb);
   (tVoid) (oOut << UnsupportedReason);
   (tVoid) (oOut << FileSystemType);
   (tVoid) (oOut << AccessoryName2);
   (tVoid) (oOut << AccessoryName);
   (tVoid) (oOut << DeviceName);
   (tVoid) (oOut << DeviceSerialNo);
   (tVoid) (oOut << DeviceVersion);
   (tVoid) (oOut << Manufacturer);
   (tVoid) (oOut << MountPoint);
   (tVoid) (oOut << USBPortNo);
   (tVoid) (oOut << ProductID);
   (tVoid) (oOut << VendorID);
   (tVoid) (oOut << FreeSize_kB);
   (tVoid) (oOut << TotalSize_kB);
   (tVoid) (oOut << TotalSize);
   (tVoid) (oOut << UsedSize_kB);
   (tVoid) (oOut << BaseClassCodeUsb);
   (tVoid) (oOut << ParitionNum);
   (tVoid) (oOut << ProtocolUsb);
   (tVoid) (oOut << SubClassCodeUsb);
   (tVoid) (oOut << DevicePath);
   (tVoid) (oOut << DeviceNode);
   return oOut;
}

tBool mplay_fi_tcl_DevManager_DeviceProperty::operator==(const mplay_fi_tcl_DevManager_DeviceProperty& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DeviceConnectStatus == roRef.DeviceConnectStatus);
   bResult = bResult && (DeviceType == roRef.DeviceType);
   bResult = bResult && (DeviceSpeedUsb == roRef.DeviceSpeedUsb);
   bResult = bResult && (UnsupportedReason == roRef.UnsupportedReason);
   bResult = bResult && (FileSystemType == roRef.FileSystemType);
   bResult = bResult && (AccessoryName2 == roRef.AccessoryName2);
   bResult = bResult && (AccessoryName == roRef.AccessoryName);
   bResult = bResult && (DeviceName == roRef.DeviceName);
   bResult = bResult && (DeviceSerialNo == roRef.DeviceSerialNo);
   bResult = bResult && (DeviceVersion == roRef.DeviceVersion);
   bResult = bResult && (Manufacturer == roRef.Manufacturer);
   bResult = bResult && (MountPoint == roRef.MountPoint);
   bResult = bResult && (USBPortNo == roRef.USBPortNo);
   bResult = bResult && (ProductID == roRef.ProductID);
   bResult = bResult && (VendorID == roRef.VendorID);
   bResult = bResult && (FreeSize_kB == roRef.FreeSize_kB);
   bResult = bResult && (TotalSize_kB == roRef.TotalSize_kB);
   bResult = bResult && (TotalSize == roRef.TotalSize);
   bResult = bResult && (UsedSize_kB == roRef.UsedSize_kB);
   bResult = bResult && (BaseClassCodeUsb == roRef.BaseClassCodeUsb);
   bResult = bResult && (ParitionNum == roRef.ParitionNum);
   bResult = bResult && (ProtocolUsb == roRef.ProtocolUsb);
   bResult = bResult && (SubClassCodeUsb == roRef.SubClassCodeUsb);
   bResult = bResult && (DevicePath == roRef.DevicePath);
   bResult = bResult && (DeviceNode == roRef.DeviceNode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DevManager_DevInfoStr::mplay_fi_tcl_DevManager_DevInfoStr(const mplay_fi_tcl_DevManager_DevInfoStr& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   DevList = coRef.DevList;
}
mplay_fi_tcl_DevManager_DevInfoStr& mplay_fi_tcl_DevManager_DevInfoStr::operator=(const mplay_fi_tcl_DevManager_DevInfoStr& coRef)
{
   if (this == &coRef) return *this;
   DevList = coRef.DevList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DevManager_DevInfoStr::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DevList.size(); ++u32Idx)
         DevList[u32Idx].vDestroy();
   DevList.clear();
   }
}

mplay_fi_tcl_DevManager_DevInfoStr::mplay_fi_tcl_DevManager_DevInfoStr()

 {}

tS32 mplay_fi_tcl_DevManager_DevInfoStr::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DEVMANAGER_DEVINFOSTR;
}


mplay_fi_tcl_DevManager_DevInfoStr::~mplay_fi_tcl_DevManager_DevInfoStr()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DevManager_DevInfoStr::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < DevList.size(); ++u32ListIdx)
      u32DynamicSize += DevList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_DevManager_DevInfoStr::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DevList.size(); ++u32Idx)
      {
         DevList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DevList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DevList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DevManager_DevInfoStr::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DevList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DevList.size(); ++u32Idx)
         (tVoid) (oOut << DevList[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DevManager_DevInfoStr::operator==(const mplay_fi_tcl_DevManager_DevInfoStr& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DevList.size() == roRef.DevList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DevList.size()); ++u32Idx)
            bResult = bResult && (DevList[u32Idx] == roRef.DevList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DevManager_SDCardInfo::mplay_fi_tcl_DevManager_SDCardInfo(const mplay_fi_tcl_DevManager_SDCardInfo& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   CardIdentifierRegister = coRef.CardIdentifierRegister;
   SDCardState = coRef.SDCardState;
   SDCardMedia = coRef.SDCardMedia;
   PowerStatus = coRef.PowerStatus;
   HW_WriteProtected = coRef.HW_WriteProtected;
   Mounted = coRef.Mounted;
   SW_WriteProtected = coRef.SW_WriteProtected;
   MountPoint = coRef.MountPoint;
   DeviceSerialNo = coRef.DeviceSerialNo;
   TotalSize = coRef.TotalSize;
   DevManufactureId = coRef.DevManufactureId;
   DevSpecVersion = coRef.DevSpecVersion;
   SDCardSlot = coRef.SDCardSlot;
}
mplay_fi_tcl_DevManager_SDCardInfo& mplay_fi_tcl_DevManager_SDCardInfo::operator=(const mplay_fi_tcl_DevManager_SDCardInfo& coRef)
{
   if (this == &coRef) return *this;
   CardIdentifierRegister = coRef.CardIdentifierRegister;
   SDCardState = coRef.SDCardState;
   SDCardMedia = coRef.SDCardMedia;
   PowerStatus = coRef.PowerStatus;
   HW_WriteProtected = coRef.HW_WriteProtected;
   Mounted = coRef.Mounted;
   SW_WriteProtected = coRef.SW_WriteProtected;
   MountPoint = coRef.MountPoint;
   DeviceSerialNo = coRef.DeviceSerialNo;
   TotalSize = coRef.TotalSize;
   DevManufactureId = coRef.DevManufactureId;
   DevSpecVersion = coRef.DevSpecVersion;
   SDCardSlot = coRef.SDCardSlot;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DevManager_SDCardInfo::vDestroy()
{
   CardIdentifierRegister.vDestroy(); 
   MountPoint.vDestroy();
}

mplay_fi_tcl_DevManager_SDCardInfo::mplay_fi_tcl_DevManager_SDCardInfo()
:CardIdentifierRegister()
,SDCardState()
,SDCardMedia()
,PowerStatus()
,HW_WriteProtected(0)
,Mounted(0)
,SW_WriteProtected(0)
,MountPoint()
,DeviceSerialNo(0)
,TotalSize(0)
,DevManufactureId(0)
,DevSpecVersion(0)
,SDCardSlot(0)
 {}

tS32 mplay_fi_tcl_DevManager_SDCardInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DEVMANAGER_SDCARDINFO;
}


mplay_fi_tcl_DevManager_SDCardInfo::~mplay_fi_tcl_DevManager_SDCardInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DevManager_SDCardInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 21+CardIdentifierRegister.u32GetSize(u16MajorVersion)+MountPoint.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_DevManager_SDCardInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CardIdentifierRegister);
   (tVoid) (oIn >> SDCardState);
   (tVoid) (oIn >> SDCardMedia);
   (tVoid) (oIn >> PowerStatus);
   (tVoid) (oIn >> HW_WriteProtected);
   (tVoid) (oIn >> Mounted);
   (tVoid) (oIn >> SW_WriteProtected);
   (tVoid) (oIn >> MountPoint);
   (tVoid) (oIn >> DeviceSerialNo);
   (tVoid) (oIn >> TotalSize);
   (tVoid) (oIn >> DevManufactureId);
   (tVoid) (oIn >> DevSpecVersion);
   (tVoid) (oIn >> SDCardSlot);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DevManager_SDCardInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CardIdentifierRegister);
   (tVoid) (oOut << SDCardState);
   (tVoid) (oOut << SDCardMedia);
   (tVoid) (oOut << PowerStatus);
   (tVoid) (oOut << HW_WriteProtected);
   (tVoid) (oOut << Mounted);
   (tVoid) (oOut << SW_WriteProtected);
   (tVoid) (oOut << MountPoint);
   (tVoid) (oOut << DeviceSerialNo);
   (tVoid) (oOut << TotalSize);
   (tVoid) (oOut << DevManufactureId);
   (tVoid) (oOut << DevSpecVersion);
   (tVoid) (oOut << SDCardSlot);
   return oOut;
}

tBool mplay_fi_tcl_DevManager_SDCardInfo::operator==(const mplay_fi_tcl_DevManager_SDCardInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CardIdentifierRegister == roRef.CardIdentifierRegister);
   bResult = bResult && (SDCardState == roRef.SDCardState);
   bResult = bResult && (SDCardMedia == roRef.SDCardMedia);
   bResult = bResult && (PowerStatus == roRef.PowerStatus);
   bResult = bResult && (HW_WriteProtected == roRef.HW_WriteProtected);
   bResult = bResult && (Mounted == roRef.Mounted);
   bResult = bResult && (SW_WriteProtected == roRef.SW_WriteProtected);
   bResult = bResult && (MountPoint == roRef.MountPoint);
   bResult = bResult && (DeviceSerialNo == roRef.DeviceSerialNo);
   bResult = bResult && (TotalSize == roRef.TotalSize);
   bResult = bResult && (DevManufactureId == roRef.DevManufactureId);
   bResult = bResult && (DevSpecVersion == roRef.DevSpecVersion);
   bResult = bResult && (SDCardSlot == roRef.SDCardSlot);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_SettingsMode::mplay_fi_tcl_e8_SettingsMode():enType(FI_EN_DEFAULT) {}

tS32 mplay_fi_tcl_e8_SettingsMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_SETTINGSMODE;
}


mplay_fi_tcl_e8_SettingsMode::~mplay_fi_tcl_e8_SettingsMode()
{}

tU32 mplay_fi_tcl_e8_SettingsMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_SettingsMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_SettingsMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_AccessoryPowerMode::mplay_fi_tcl_e8_AccessoryPowerMode():enType(FI_EN_E8DIPO_APM_INTERMITTENT_HIGH_POWER_MODE) {}

tS32 mplay_fi_tcl_e8_AccessoryPowerMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_ACCESSORYPOWERMODE;
}


mplay_fi_tcl_e8_AccessoryPowerMode::~mplay_fi_tcl_e8_AccessoryPowerMode()
{}

tU32 mplay_fi_tcl_e8_AccessoryPowerMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_AccessoryPowerMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_AccessoryPowerMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_BatteryChargingState::mplay_fi_tcl_e8_BatteryChargingState():enType(FI_EN_E8DIPO_BCS_CHARGED) {}

tS32 mplay_fi_tcl_e8_BatteryChargingState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_BATTERYCHARGINGSTATE;
}


mplay_fi_tcl_e8_BatteryChargingState::~mplay_fi_tcl_e8_BatteryChargingState()
{}

tU32 mplay_fi_tcl_e8_BatteryChargingState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_BatteryChargingState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_BatteryChargingState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPODeviceType::mplay_fi_tcl_e8_DiPODeviceType():enType(FI_EN_E8DTY_UNKNOWN) {}

tS32 mplay_fi_tcl_e8_DiPODeviceType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPODEVICETYPE;
}


mplay_fi_tcl_e8_DiPODeviceType::~mplay_fi_tcl_e8_DiPODeviceType()
{}

tU32 mplay_fi_tcl_e8_DiPODeviceType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPODeviceType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPODeviceType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOConnectionType::mplay_fi_tcl_e8_DiPOConnectionType():enType(FI_EN_E8DCT_UNKNOWN) {}

tS32 mplay_fi_tcl_e8_DiPOConnectionType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCONNECTIONTYPE;
}


mplay_fi_tcl_e8_DiPOConnectionType::~mplay_fi_tcl_e8_DiPOConnectionType()
{}

tU32 mplay_fi_tcl_e8_DiPOConnectionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOConnectionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOConnectionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOConnectionState::mplay_fi_tcl_e8_DiPOConnectionState():enType(FI_EN_E8CS_CONNECTED) {}

tS32 mplay_fi_tcl_e8_DiPOConnectionState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCONNECTIONSTATE;
}


mplay_fi_tcl_e8_DiPOConnectionState::~mplay_fi_tcl_e8_DiPOConnectionState()
{}

tU32 mplay_fi_tcl_e8_DiPOConnectionState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOConnectionState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOConnectionState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCaps::mplay_fi_tcl_e8_DiPOCaps():enType(FI_EN_E8DIPO_CAP_NONE) {}

tS32 mplay_fi_tcl_e8_DiPOCaps::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCAPS;
}


mplay_fi_tcl_e8_DiPOCaps::~mplay_fi_tcl_e8_DiPOCaps()
{}

tU32 mplay_fi_tcl_e8_DiPOCaps::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCaps::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCaps::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPODeviceStatus::mplay_fi_tcl_e8_DiPODeviceStatus():enType(FI_EN_E8DS_NONE) {}

tS32 mplay_fi_tcl_e8_DiPODeviceStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPODEVICESTATUS;
}


mplay_fi_tcl_e8_DiPODeviceStatus::~mplay_fi_tcl_e8_DiPODeviceStatus()
{}

tU32 mplay_fi_tcl_e8_DiPODeviceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPODeviceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPODeviceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOPlaypackAction::mplay_fi_tcl_e8_DiPOPlaypackAction():enType(FI_EN_E8DIPO_PBA_PLAY) {}

tS32 mplay_fi_tcl_e8_DiPOPlaypackAction::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOPLAYPACKACTION;
}


mplay_fi_tcl_e8_DiPOPlaypackAction::~mplay_fi_tcl_e8_DiPOPlaypackAction()
{}

tU32 mplay_fi_tcl_e8_DiPOPlaypackAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOPlaypackAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOPlaypackAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOPlaybackStatus::mplay_fi_tcl_e8_DiPOPlaybackStatus():enType(FI_EN_E8DIPO_PBS_STOPPED) {}

tS32 mplay_fi_tcl_e8_DiPOPlaybackStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOPLAYBACKSTATUS;
}


mplay_fi_tcl_e8_DiPOPlaybackStatus::~mplay_fi_tcl_e8_DiPOPlaybackStatus()
{}

tU32 mplay_fi_tcl_e8_DiPOPlaybackStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOPlaybackStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOPlaybackStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::mplay_fi_tcl_e8_DiPOPlaybackShuffleMode():enType(FI_EN_E8DIPO_PBSM_OFF) {}

tS32 mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOPLAYBACKSHUFFLEMODE;
}


mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::~mplay_fi_tcl_e8_DiPOPlaybackShuffleMode()
{}

tU32 mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOPlaybackShuffleMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::mplay_fi_tcl_e8_DiPOPlaybackRepeatMode():enType(FI_EN_E8DIPO_PBRM_OFF) {}

tS32 mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOPLAYBACKREPEATMODE;
}


mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::~mplay_fi_tcl_e8_DiPOPlaybackRepeatMode()
{}

tU32 mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOPlaybackRepeatMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOResponse::mplay_fi_tcl_e8_DiPOResponse():enType(FI_EN_E8DIPO_OK) {}

tS32 mplay_fi_tcl_e8_DiPOResponse::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPORESPONSE;
}


mplay_fi_tcl_e8_DiPOResponse::~mplay_fi_tcl_e8_DiPOResponse()
{}

tU32 mplay_fi_tcl_e8_DiPOResponse::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOResponse::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOResponse::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPORoleStatus::mplay_fi_tcl_e8_DiPORoleStatus():enType(FI_EN_E8DIPO_CLIENTMODE) {}

tS32 mplay_fi_tcl_e8_DiPORoleStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOROLESTATUS;
}


mplay_fi_tcl_e8_DiPORoleStatus::~mplay_fi_tcl_e8_DiPORoleStatus()
{}

tU32 mplay_fi_tcl_e8_DiPORoleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPORoleStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPORoleStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiPODeviceInfoItem::mplay_fi_tcl_DiPODeviceInfoItem(const mplay_fi_tcl_DiPODeviceInfoItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceName = coRef.sDeviceName;
   e8DeviceType = coRef.e8DeviceType;
   sDeviceSerialNumber = coRef.sDeviceSerialNumber;
   bDeviceConnected = coRef.bDeviceConnected;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   bDiPOCapable = coRef.bDiPOCapable;
   bDiPOActive = coRef.bDiPOActive;
   sDiPOVersion = coRef.sDiPOVersion;
   e8ConnectionType = coRef.e8ConnectionType;
   e8ConnectionState = coRef.e8ConnectionState;
   sMountPoint = coRef.sMountPoint;
   sAccessoryName = coRef.sAccessoryName;
   e8DiPOCaps = coRef.e8DiPOCaps;
   e8DeviceState = coRef.e8DeviceState;
   sDeviceUUID = coRef.sDeviceUUID;
   sDeviceBTMacAddress = coRef.sDeviceBTMacAddress;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
}
mplay_fi_tcl_DiPODeviceInfoItem& mplay_fi_tcl_DiPODeviceInfoItem::operator=(const mplay_fi_tcl_DiPODeviceInfoItem& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceTag = coRef.u8DeviceTag;
   sDeviceName = coRef.sDeviceName;
   e8DeviceType = coRef.e8DeviceType;
   sDeviceSerialNumber = coRef.sDeviceSerialNumber;
   bDeviceConnected = coRef.bDeviceConnected;
   bDeviceActiveSource = coRef.bDeviceActiveSource;
   bDiPOCapable = coRef.bDiPOCapable;
   bDiPOActive = coRef.bDiPOActive;
   sDiPOVersion = coRef.sDiPOVersion;
   e8ConnectionType = coRef.e8ConnectionType;
   e8ConnectionState = coRef.e8ConnectionState;
   sMountPoint = coRef.sMountPoint;
   sAccessoryName = coRef.sAccessoryName;
   e8DiPOCaps = coRef.e8DiPOCaps;
   e8DeviceState = coRef.e8DeviceState;
   sDeviceUUID = coRef.sDeviceUUID;
   sDeviceBTMacAddress = coRef.sDeviceBTMacAddress;
   sDeviceUSBSerialNumber = coRef.sDeviceUSBSerialNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiPODeviceInfoItem::vDestroy()
{
   sDeviceName.vDestroy();
   sDeviceSerialNumber.vDestroy();
   sDiPOVersion.vDestroy();
   sMountPoint.vDestroy();
   sAccessoryName.vDestroy();
   sDeviceUUID.vDestroy();
   sDeviceBTMacAddress.vDestroy();
   sDeviceUSBSerialNumber.vDestroy();
}

mplay_fi_tcl_DiPODeviceInfoItem::mplay_fi_tcl_DiPODeviceInfoItem()
:u8DeviceTag(0)
,sDeviceName()
,e8DeviceType()
,sDeviceSerialNumber()
,bDeviceConnected(0)
,bDeviceActiveSource(0)
,bDiPOCapable(0)
,bDiPOActive(0)
,sDiPOVersion()
,e8ConnectionType()
,e8ConnectionState()
,sMountPoint()
,sAccessoryName()
,e8DiPOCaps()
,e8DeviceState()
,sDeviceUUID()
,sDeviceBTMacAddress()
,sDeviceUSBSerialNumber()
 {}

tS32 mplay_fi_tcl_DiPODeviceInfoItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIPODEVICEINFOITEM;
}


mplay_fi_tcl_DiPODeviceInfoItem::~mplay_fi_tcl_DiPODeviceInfoItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiPODeviceInfoItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+sDeviceName.u32GetSize(u16MajorVersion)+sDeviceSerialNumber.u32GetSize(u16MajorVersion)+sDiPOVersion.u32GetSize(u16MajorVersion)+sMountPoint.u32GetSize(u16MajorVersion)+sAccessoryName.u32GetSize(u16MajorVersion)+sDeviceUUID.u32GetSize(u16MajorVersion)+sDeviceBTMacAddress.u32GetSize(u16MajorVersion)+sDeviceUSBSerialNumber.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_DiPODeviceInfoItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceTag);
   (tVoid) (oIn >> sDeviceName);
   (tVoid) (oIn >> e8DeviceType);
   (tVoid) (oIn >> sDeviceSerialNumber);
   (tVoid) (oIn >> bDeviceConnected);
   (tVoid) (oIn >> bDeviceActiveSource);
   (tVoid) (oIn >> bDiPOCapable);
   (tVoid) (oIn >> bDiPOActive);
   (tVoid) (oIn >> sDiPOVersion);
   (tVoid) (oIn >> e8ConnectionType);
   (tVoid) (oIn >> e8ConnectionState);
   (tVoid) (oIn >> sMountPoint);
   (tVoid) (oIn >> sAccessoryName);
   (tVoid) (oIn >> e8DiPOCaps);
   (tVoid) (oIn >> e8DeviceState);
   (tVoid) (oIn >> sDeviceUUID);
   (tVoid) (oIn >> sDeviceBTMacAddress);
   (tVoid) (oIn >> sDeviceUSBSerialNumber);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiPODeviceInfoItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceTag);
   (tVoid) (oOut << sDeviceName);
   (tVoid) (oOut << e8DeviceType);
   (tVoid) (oOut << sDeviceSerialNumber);
   (tVoid) (oOut << bDeviceConnected);
   (tVoid) (oOut << bDeviceActiveSource);
   (tVoid) (oOut << bDiPOCapable);
   (tVoid) (oOut << bDiPOActive);
   (tVoid) (oOut << sDiPOVersion);
   (tVoid) (oOut << e8ConnectionType);
   (tVoid) (oOut << e8ConnectionState);
   (tVoid) (oOut << sMountPoint);
   (tVoid) (oOut << sAccessoryName);
   (tVoid) (oOut << e8DiPOCaps);
   (tVoid) (oOut << e8DeviceState);
   (tVoid) (oOut << sDeviceUUID);
   (tVoid) (oOut << sDeviceBTMacAddress);
   (tVoid) (oOut << sDeviceUSBSerialNumber);
   return oOut;
}

tBool mplay_fi_tcl_DiPODeviceInfoItem::operator==(const mplay_fi_tcl_DiPODeviceInfoItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceTag == roRef.u8DeviceTag);
   bResult = bResult && (sDeviceName == roRef.sDeviceName);
   bResult = bResult && (e8DeviceType == roRef.e8DeviceType);
   bResult = bResult && (sDeviceSerialNumber == roRef.sDeviceSerialNumber);
   bResult = bResult && (bDeviceConnected == roRef.bDeviceConnected);
   bResult = bResult && (bDeviceActiveSource == roRef.bDeviceActiveSource);
   bResult = bResult && (bDiPOCapable == roRef.bDiPOCapable);
   bResult = bResult && (bDiPOActive == roRef.bDiPOActive);
   bResult = bResult && (sDiPOVersion == roRef.sDiPOVersion);
   bResult = bResult && (e8ConnectionType == roRef.e8ConnectionType);
   bResult = bResult && (e8ConnectionState == roRef.e8ConnectionState);
   bResult = bResult && (sMountPoint == roRef.sMountPoint);
   bResult = bResult && (sAccessoryName == roRef.sAccessoryName);
   bResult = bResult && (e8DiPOCaps == roRef.e8DiPOCaps);
   bResult = bResult && (e8DeviceState == roRef.e8DeviceState);
   bResult = bResult && (sDeviceUUID == roRef.sDeviceUUID);
   bResult = bResult && (sDeviceBTMacAddress == roRef.sDeviceBTMacAddress);
   bResult = bResult && (sDeviceUSBSerialNumber == roRef.sDeviceUSBSerialNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiPODeviceInfo::mplay_fi_tcl_DiPODeviceInfo(const mplay_fi_tcl_DiPODeviceInfo& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_DiPODeviceInfo& mplay_fi_tcl_DiPODeviceInfo::operator=(const mplay_fi_tcl_DiPODeviceInfo& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiPODeviceInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_DiPODeviceInfo::mplay_fi_tcl_DiPODeviceInfo()

 {}

tS32 mplay_fi_tcl_DiPODeviceInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIPODEVICEINFO;
}


mplay_fi_tcl_DiPODeviceInfo::~mplay_fi_tcl_DiPODeviceInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiPODeviceInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_DiPODeviceInfo::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiPODeviceInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DiPODeviceInfo::operator==(const mplay_fi_tcl_DiPODeviceInfo& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiPOImageData::mplay_fi_tcl_DiPOImageData(const mplay_fi_tcl_DiPOImageData& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u8Items = coRef.u8Items;
}
mplay_fi_tcl_DiPOImageData& mplay_fi_tcl_DiPOImageData::operator=(const mplay_fi_tcl_DiPOImageData& coRef)
{
   if (this == &coRef) return *this;
   u8Items = coRef.u8Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiPOImageData::vDestroy()
{
   {
   u8Items.clear();
   }
}

mplay_fi_tcl_DiPOImageData::mplay_fi_tcl_DiPOImageData()

 {}

tS32 mplay_fi_tcl_DiPOImageData::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIPOIMAGEDATA;
}


mplay_fi_tcl_DiPOImageData::~mplay_fi_tcl_DiPOImageData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiPOImageData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(u8Items.size()*1);
}

fi_tclInContext& mplay_fi_tcl_DiPOImageData::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u8Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u8Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiPOImageData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)u8Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u8Items.size(); ++u32Idx)
         (tVoid) (oOut << u8Items[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DiPOImageData::operator==(const mplay_fi_tcl_DiPOImageData& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (u8Items.size() == roRef.u8Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u8Items.size()); ++u32Idx)
            bResult = bResult && (u8Items[u32Idx] == roRef.u8Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_b8_DiPOLocationInfoType::mplay_fi_tcl_b8_DiPOLocationInfoType():u8Value(0)
{}

tS32 mplay_fi_tcl_b8_DiPOLocationInfoType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_B8_DIPOLOCATIONINFOTYPE;
}


mplay_fi_tcl_b8_DiPOLocationInfoType::~mplay_fi_tcl_b8_DiPOLocationInfoType()
{}

tU32 mplay_fi_tcl_b8_DiPOLocationInfoType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_b8_DiPOLocationInfoType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& mplay_fi_tcl_b8_DiPOLocationInfoType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues::mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues():u8Value(0)
{}

tS32 mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_B8_DIPOGPRMCDATASTATUSVALUES;
}


mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues::~mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues()
{}

tU32 mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_AudioError::mplay_fi_tcl_e8_AudioError():enType(FI_EN_E8NO_ERROR) {}

tS32 mplay_fi_tcl_e8_AudioError::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_AUDIOERROR;
}


mplay_fi_tcl_e8_AudioError::~mplay_fi_tcl_e8_AudioError()
{}

tU32 mplay_fi_tcl_e8_AudioError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_AudioError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_AudioError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_AppLaunchOption::mplay_fi_tcl_e8_AppLaunchOption():enType(FI_EN_E8LAUNCH_WITH_USER_ALERT) {}

tS32 mplay_fi_tcl_e8_AppLaunchOption::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_APPLAUNCHOPTION;
}


mplay_fi_tcl_e8_AppLaunchOption::~mplay_fi_tcl_e8_AppLaunchOption()
{}

tU32 mplay_fi_tcl_e8_AppLaunchOption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_AppLaunchOption::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_AppLaunchOption::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_b32_BTProfileType::mplay_fi_tcl_b32_BTProfileType():u32Value(0)
{}

tS32 mplay_fi_tcl_b32_BTProfileType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_B32_BTPROFILETYPE;
}


mplay_fi_tcl_b32_BTProfileType::~mplay_fi_tcl_b32_BTProfileType()
{}

tU32 mplay_fi_tcl_b32_BTProfileType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_fi_tcl_b32_BTProfileType::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& mplay_fi_tcl_b32_BTProfileType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_BTProfileItem::mplay_fi_tcl_BTProfileItem(const mplay_fi_tcl_BTProfileItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u8DeviceId = coRef.u8DeviceId;
   b32BTProfile = coRef.b32BTProfile;
}
mplay_fi_tcl_BTProfileItem& mplay_fi_tcl_BTProfileItem::operator=(const mplay_fi_tcl_BTProfileItem& coRef)
{
   if (this == &coRef) return *this;
   u8DeviceId = coRef.u8DeviceId;
   b32BTProfile = coRef.b32BTProfile;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_BTProfileItem::mplay_fi_tcl_BTProfileItem()
:u8DeviceId(0)
,b32BTProfile()
 {}

tS32 mplay_fi_tcl_BTProfileItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_BTPROFILEITEM;
}


mplay_fi_tcl_BTProfileItem::~mplay_fi_tcl_BTProfileItem()
{}

tU32 mplay_fi_tcl_BTProfileItem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_fi_tcl_BTProfileItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DeviceId);
   (tVoid) (oIn >> b32BTProfile);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_BTProfileItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DeviceId);
   (tVoid) (oOut << b32BTProfile);
   return oOut;
}

tBool mplay_fi_tcl_BTProfileItem::operator==(const mplay_fi_tcl_BTProfileItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DeviceId == roRef.u8DeviceId);
   bResult = bResult && (b32BTProfile == roRef.b32BTProfile);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_BTProfileInfo::mplay_fi_tcl_BTProfileInfo(const mplay_fi_tcl_BTProfileInfo& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_BTProfileInfo& mplay_fi_tcl_BTProfileInfo::operator=(const mplay_fi_tcl_BTProfileInfo& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_BTProfileInfo::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_BTProfileInfo::mplay_fi_tcl_BTProfileInfo()

 {}

tS32 mplay_fi_tcl_BTProfileInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_BTPROFILEINFO;
}


mplay_fi_tcl_BTProfileInfo::~mplay_fi_tcl_BTProfileInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_BTProfileInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(oItems.size()*5);
}

fi_tclInContext& mplay_fi_tcl_BTProfileInfo::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_BTProfileInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_BTProfileInfo::operator==(const mplay_fi_tcl_BTProfileInfo& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::mplay_fi_tcl_e8_DiPOCallStateUpdateStatus():enType(FI_EN_E8DIPO_CSUS_DISCONNECTED) {}

tS32 mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCALLSTATEUPDATESTATUS;
}


mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::~mplay_fi_tcl_e8_DiPOCallStateUpdateStatus()
{}

tU32 mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCallStateUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::mplay_fi_tcl_e8_DiPOCallStateUpdateDirection():enType(FI_EN_E8DIPO_CSUD_UNKNOWN) {}

tS32 mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCALLSTATEUPDATEDIRECTION;
}


mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::~mplay_fi_tcl_e8_DiPOCallStateUpdateDirection()
{}

tU32 mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCallStateUpdateDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCallStateUpdateService::mplay_fi_tcl_e8_DiPOCallStateUpdateService():enType(FI_EN_E8DIPO_CSEV_UNKNOWN) {}

tS32 mplay_fi_tcl_e8_DiPOCallStateUpdateService::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCALLSTATEUPDATESERVICE;
}


mplay_fi_tcl_e8_DiPOCallStateUpdateService::~mplay_fi_tcl_e8_DiPOCallStateUpdateService()
{}

tU32 mplay_fi_tcl_e8_DiPOCallStateUpdateService::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCallStateUpdateService::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCallStateUpdateService::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason():enType(FI_EN_E8DIPO_CSDR_ENDED) {}

tS32 mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCALLSTATEUPDATEDISCONNECTREASON;
}


mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::~mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason()
{}

tU32 mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCallStateUpdateDisconnectReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiPOCallStateItem::mplay_fi_tcl_DiPOCallStateItem(const mplay_fi_tcl_DiPOCallStateItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   sRemoteID = coRef.sRemoteID;
   sDisplayName = coRef.sDisplayName;
   eStatus = coRef.eStatus;
   eDirection = coRef.eDirection;
   sCallUUID = coRef.sCallUUID;
   sAddressBookID = coRef.sAddressBookID;
   sLabel = coRef.sLabel;
   eService = coRef.eService;
   bIsConferenced = coRef.bIsConferenced;
   u8ConferenceGroup = coRef.u8ConferenceGroup;
   eDisconnectReason = coRef.eDisconnectReason;
   u64StartTimestamp = coRef.u64StartTimestamp;
}
mplay_fi_tcl_DiPOCallStateItem& mplay_fi_tcl_DiPOCallStateItem::operator=(const mplay_fi_tcl_DiPOCallStateItem& coRef)
{
   if (this == &coRef) return *this;
   sRemoteID = coRef.sRemoteID;
   sDisplayName = coRef.sDisplayName;
   eStatus = coRef.eStatus;
   eDirection = coRef.eDirection;
   sCallUUID = coRef.sCallUUID;
   sAddressBookID = coRef.sAddressBookID;
   sLabel = coRef.sLabel;
   eService = coRef.eService;
   bIsConferenced = coRef.bIsConferenced;
   u8ConferenceGroup = coRef.u8ConferenceGroup;
   eDisconnectReason = coRef.eDisconnectReason;
   u64StartTimestamp = coRef.u64StartTimestamp;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiPOCallStateItem::vDestroy()
{
   sRemoteID.vDestroy();
   sDisplayName.vDestroy();
   sCallUUID.vDestroy();
   sAddressBookID.vDestroy();
   sLabel.vDestroy();
}

mplay_fi_tcl_DiPOCallStateItem::mplay_fi_tcl_DiPOCallStateItem()
:sRemoteID()
,sDisplayName()
,eStatus()
,eDirection()
,sCallUUID()
,sAddressBookID()
,sLabel()
,eService()
,bIsConferenced(0)
,u8ConferenceGroup(0)
,eDisconnectReason()
,u64StartTimestamp(0)
 {}

tS32 mplay_fi_tcl_DiPOCallStateItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIPOCALLSTATEITEM;
}


mplay_fi_tcl_DiPOCallStateItem::~mplay_fi_tcl_DiPOCallStateItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiPOCallStateItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+sRemoteID.u32GetSize(u16MajorVersion)+sDisplayName.u32GetSize(u16MajorVersion)+sCallUUID.u32GetSize(u16MajorVersion)+sAddressBookID.u32GetSize(u16MajorVersion)+sLabel.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_DiPOCallStateItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sRemoteID);
   (tVoid) (oIn >> sDisplayName);
   (tVoid) (oIn >> eStatus);
   (tVoid) (oIn >> eDirection);
   (tVoid) (oIn >> sCallUUID);
   (tVoid) (oIn >> sAddressBookID);
   (tVoid) (oIn >> sLabel);
   (tVoid) (oIn >> eService);
   (tVoid) (oIn >> bIsConferenced);
   (tVoid) (oIn >> u8ConferenceGroup);
   (tVoid) (oIn >> eDisconnectReason);
   (tVoid) (oIn >> u64StartTimestamp);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiPOCallStateItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sRemoteID);
   (tVoid) (oOut << sDisplayName);
   (tVoid) (oOut << eStatus);
   (tVoid) (oOut << eDirection);
   (tVoid) (oOut << sCallUUID);
   (tVoid) (oOut << sAddressBookID);
   (tVoid) (oOut << sLabel);
   (tVoid) (oOut << eService);
   (tVoid) (oOut << bIsConferenced);
   (tVoid) (oOut << u8ConferenceGroup);
   (tVoid) (oOut << eDisconnectReason);
   (tVoid) (oOut << u64StartTimestamp);
   return oOut;
}

tBool mplay_fi_tcl_DiPOCallStateItem::operator==(const mplay_fi_tcl_DiPOCallStateItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sRemoteID == roRef.sRemoteID);
   bResult = bResult && (sDisplayName == roRef.sDisplayName);
   bResult = bResult && (eStatus == roRef.eStatus);
   bResult = bResult && (eDirection == roRef.eDirection);
   bResult = bResult && (sCallUUID == roRef.sCallUUID);
   bResult = bResult && (sAddressBookID == roRef.sAddressBookID);
   bResult = bResult && (sLabel == roRef.sLabel);
   bResult = bResult && (eService == roRef.eService);
   bResult = bResult && (bIsConferenced == roRef.bIsConferenced);
   bResult = bResult && (u8ConferenceGroup == roRef.u8ConferenceGroup);
   bResult = bResult && (eDisconnectReason == roRef.eDisconnectReason);
   bResult = bResult && (u64StartTimestamp == roRef.u64StartTimestamp);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiPOCallStateUpdate::mplay_fi_tcl_DiPOCallStateUpdate(const mplay_fi_tcl_DiPOCallStateUpdate& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_DiPOCallStateUpdate& mplay_fi_tcl_DiPOCallStateUpdate::operator=(const mplay_fi_tcl_DiPOCallStateUpdate& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiPOCallStateUpdate::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_DiPOCallStateUpdate::mplay_fi_tcl_DiPOCallStateUpdate()

 {}

tS32 mplay_fi_tcl_DiPOCallStateUpdate::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIPOCALLSTATEUPDATE;
}


mplay_fi_tcl_DiPOCallStateUpdate::~mplay_fi_tcl_DiPOCallStateUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiPOCallStateUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_DiPOCallStateUpdate::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiPOCallStateUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DiPOCallStateUpdate::operator==(const mplay_fi_tcl_DiPOCallStateUpdate& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength():enType(FI_EN_E8DIPO_CUSS_0BARS) {}

tS32 mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCOMMUNICATIONSUPDATESIGNALSTRENGTH;
}


mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::~mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength()
{}

tU32 mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus():enType(FI_EN_E8DIPO_CURS_UNKNONW) {}

tS32 mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCOMMUNICATIONSUPDATEREGISTRATIONSTATUS;
}


mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::~mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus()
{}

tU32 mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::mplay_fi_tcl_RouteGuidanceDisplayComponentIDs(const mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   Items = coRef.Items;
}
mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::operator=(const mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& coRef)
{
   if (this == &coRef) return *this;
   Items = coRef.Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::vDestroy()
{
   {
   Items.clear();
   }
}

mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::mplay_fi_tcl_RouteGuidanceDisplayComponentIDs()

 {}

tS32 mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_ROUTEGUIDANCEDISPLAYCOMPONENTIDS;
}


mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::~mplay_fi_tcl_RouteGuidanceDisplayComponentIDs()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Items.size()*2);
}

fi_tclInContext& mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
         (tVoid) (oOut << Items[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_RouteGuidanceDisplayComponentIDs::operator==(const mplay_fi_tcl_RouteGuidanceDisplayComponentIDs& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Items.size() == roRef.Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Items.size()); ++u32Idx)
            bResult = bResult && (Items[u32Idx] == roRef.Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_RouteGuidanceState::mplay_fi_tcl_e8_RouteGuidanceState():enType(FI_EN_E8DIPO_ROUTE_GUIDANCE_STATE_NO_ROUTE_SET) {}

tS32 mplay_fi_tcl_e8_RouteGuidanceState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_ROUTEGUIDANCESTATE;
}


mplay_fi_tcl_e8_RouteGuidanceState::~mplay_fi_tcl_e8_RouteGuidanceState()
{}

tU32 mplay_fi_tcl_e8_RouteGuidanceState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_RouteGuidanceState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_RouteGuidanceState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_ManeuverState::mplay_fi_tcl_e8_ManeuverState():enType(FI_EN_E8DIPO_MANEUVER_STATE_CONTINUE) {}

tS32 mplay_fi_tcl_e8_ManeuverState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MANEUVERSTATE;
}


mplay_fi_tcl_e8_ManeuverState::~mplay_fi_tcl_e8_ManeuverState()
{}

tU32 mplay_fi_tcl_e8_ManeuverState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_ManeuverState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_ManeuverState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DistanceDisplayUnits::mplay_fi_tcl_e8_DistanceDisplayUnits():enType(FI_EN_E8DIPO_DISTANCE_DISPLAY_UNIT_KM) {}

tS32 mplay_fi_tcl_e8_DistanceDisplayUnits::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DISTANCEDISPLAYUNITS;
}


mplay_fi_tcl_e8_DistanceDisplayUnits::~mplay_fi_tcl_e8_DistanceDisplayUnits()
{}

tU32 mplay_fi_tcl_e8_DistanceDisplayUnits::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DistanceDisplayUnits::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DistanceDisplayUnits::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_RouteGuidanceManeuverCurrentList::mplay_fi_tcl_RouteGuidanceManeuverCurrentList(const mplay_fi_tcl_RouteGuidanceManeuverCurrentList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u16Items = coRef.u16Items;
}
mplay_fi_tcl_RouteGuidanceManeuverCurrentList& mplay_fi_tcl_RouteGuidanceManeuverCurrentList::operator=(const mplay_fi_tcl_RouteGuidanceManeuverCurrentList& coRef)
{
   if (this == &coRef) return *this;
   u16Items = coRef.u16Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_RouteGuidanceManeuverCurrentList::vDestroy()
{
   {
   u16Items.clear();
   }
}

mplay_fi_tcl_RouteGuidanceManeuverCurrentList::mplay_fi_tcl_RouteGuidanceManeuverCurrentList()

 {}

tS32 mplay_fi_tcl_RouteGuidanceManeuverCurrentList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_ROUTEGUIDANCEMANEUVERCURRENTLIST;
}


mplay_fi_tcl_RouteGuidanceManeuverCurrentList::~mplay_fi_tcl_RouteGuidanceManeuverCurrentList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_RouteGuidanceManeuverCurrentList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(u16Items.size()*2);
}

fi_tclInContext& mplay_fi_tcl_RouteGuidanceManeuverCurrentList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      u16Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> u16Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_RouteGuidanceManeuverCurrentList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)u16Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < u16Items.size(); ++u32Idx)
         (tVoid) (oOut << u16Items[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_RouteGuidanceManeuverCurrentList::operator==(const mplay_fi_tcl_RouteGuidanceManeuverCurrentList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (u16Items.size() == roRef.u16Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < u16Items.size()); ++u32Idx)
            bResult = bResult && (u16Items[u32Idx] == roRef.u16Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_ManeuverType::mplay_fi_tcl_e8_ManeuverType():enType(FI_EN_E8DIPO_MANEUVER_TYPE_NO_TURN) {}

tS32 mplay_fi_tcl_e8_ManeuverType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MANEUVERTYPE;
}


mplay_fi_tcl_e8_ManeuverType::~mplay_fi_tcl_e8_ManeuverType()
{}

tU32 mplay_fi_tcl_e8_ManeuverType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_ManeuverType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_ManeuverType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DrivingSide::mplay_fi_tcl_e8_DrivingSide():enType(FI_EN_E8DIPO_DRIVING_SIDE_RIGHT) {}

tS32 mplay_fi_tcl_e8_DrivingSide::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DRIVINGSIDE;
}


mplay_fi_tcl_e8_DrivingSide::~mplay_fi_tcl_e8_DrivingSide()
{}

tU32 mplay_fi_tcl_e8_DrivingSide::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DrivingSide::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DrivingSide::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_JunctionType::mplay_fi_tcl_e8_JunctionType():enType(FI_EN_E8DIPO_JUNCTION_TYPE_SINGLE_INTERSECTION) {}

tS32 mplay_fi_tcl_e8_JunctionType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_JUNCTIONTYPE;
}


mplay_fi_tcl_e8_JunctionType::~mplay_fi_tcl_e8_JunctionType()
{}

tU32 mplay_fi_tcl_e8_JunctionType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_JunctionType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_JunctionType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_JunctionElementAngles::mplay_fi_tcl_JunctionElementAngles(const mplay_fi_tcl_JunctionElementAngles& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   Items = coRef.Items;
}
mplay_fi_tcl_JunctionElementAngles& mplay_fi_tcl_JunctionElementAngles::operator=(const mplay_fi_tcl_JunctionElementAngles& coRef)
{
   if (this == &coRef) return *this;
   Items = coRef.Items;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_JunctionElementAngles::vDestroy()
{
   {
   Items.clear();
   }
}

mplay_fi_tcl_JunctionElementAngles::mplay_fi_tcl_JunctionElementAngles()

 {}

tS32 mplay_fi_tcl_JunctionElementAngles::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_JUNCTIONELEMENTANGLES;
}


mplay_fi_tcl_JunctionElementAngles::~mplay_fi_tcl_JunctionElementAngles()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_JunctionElementAngles::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Items.size()*2);
}

fi_tclInContext& mplay_fi_tcl_JunctionElementAngles::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Items.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Items[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_JunctionElementAngles::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Items.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Items.size(); ++u32Idx)
         (tVoid) (oOut << Items[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_JunctionElementAngles::operator==(const mplay_fi_tcl_JunctionElementAngles& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Items.size() == roRef.Items.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Items.size()); ++u32Idx)
            bResult = bResult && (Items[u32Idx] == roRef.Items[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_RouteGuidanceDisplayComponentItem::mplay_fi_tcl_RouteGuidanceDisplayComponentItem(const mplay_fi_tcl_RouteGuidanceDisplayComponentItem& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   Identifier = coRef.Identifier;
   Name = coRef.Name;
   MaxCurrentRoadNameLength = coRef.MaxCurrentRoadNameLength;
   MaxDestinationNameLength = coRef.MaxDestinationNameLength;
   MaxAfterManeuverRoadNameLength = coRef.MaxAfterManeuverRoadNameLength;
   MaxManeuverDescriptionLength = coRef.MaxManeuverDescriptionLength;
   MaxGuidanceManeuverCapacity = coRef.MaxGuidanceManeuverCapacity;
}
mplay_fi_tcl_RouteGuidanceDisplayComponentItem& mplay_fi_tcl_RouteGuidanceDisplayComponentItem::operator=(const mplay_fi_tcl_RouteGuidanceDisplayComponentItem& coRef)
{
   if (this == &coRef) return *this;
   Identifier = coRef.Identifier;
   Name = coRef.Name;
   MaxCurrentRoadNameLength = coRef.MaxCurrentRoadNameLength;
   MaxDestinationNameLength = coRef.MaxDestinationNameLength;
   MaxAfterManeuverRoadNameLength = coRef.MaxAfterManeuverRoadNameLength;
   MaxManeuverDescriptionLength = coRef.MaxManeuverDescriptionLength;
   MaxGuidanceManeuverCapacity = coRef.MaxGuidanceManeuverCapacity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_RouteGuidanceDisplayComponentItem::vDestroy()
{
   Name.vDestroy();
}

mplay_fi_tcl_RouteGuidanceDisplayComponentItem::mplay_fi_tcl_RouteGuidanceDisplayComponentItem()
:Identifier(0)
,Name()
,MaxCurrentRoadNameLength(0)
,MaxDestinationNameLength(0)
,MaxAfterManeuverRoadNameLength(0)
,MaxManeuverDescriptionLength(0)
,MaxGuidanceManeuverCapacity(0)
 {}

tS32 mplay_fi_tcl_RouteGuidanceDisplayComponentItem::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_ROUTEGUIDANCEDISPLAYCOMPONENTITEM;
}


mplay_fi_tcl_RouteGuidanceDisplayComponentItem::~mplay_fi_tcl_RouteGuidanceDisplayComponentItem()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_RouteGuidanceDisplayComponentItem::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+Name.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_RouteGuidanceDisplayComponentItem::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Identifier);
   (tVoid) (oIn >> Name);
   (tVoid) (oIn >> MaxCurrentRoadNameLength);
   (tVoid) (oIn >> MaxDestinationNameLength);
   (tVoid) (oIn >> MaxAfterManeuverRoadNameLength);
   (tVoid) (oIn >> MaxManeuverDescriptionLength);
   (tVoid) (oIn >> MaxGuidanceManeuverCapacity);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_RouteGuidanceDisplayComponentItem::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Identifier);
   (tVoid) (oOut << Name);
   (tVoid) (oOut << MaxCurrentRoadNameLength);
   (tVoid) (oOut << MaxDestinationNameLength);
   (tVoid) (oOut << MaxAfterManeuverRoadNameLength);
   (tVoid) (oOut << MaxManeuverDescriptionLength);
   (tVoid) (oOut << MaxGuidanceManeuverCapacity);
   return oOut;
}

tBool mplay_fi_tcl_RouteGuidanceDisplayComponentItem::operator==(const mplay_fi_tcl_RouteGuidanceDisplayComponentItem& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Identifier == roRef.Identifier);
   bResult = bResult && (Name == roRef.Name);
   bResult = bResult && (MaxCurrentRoadNameLength == roRef.MaxCurrentRoadNameLength);
   bResult = bResult && (MaxDestinationNameLength == roRef.MaxDestinationNameLength);
   bResult = bResult && (MaxAfterManeuverRoadNameLength == roRef.MaxAfterManeuverRoadNameLength);
   bResult = bResult && (MaxManeuverDescriptionLength == roRef.MaxManeuverDescriptionLength);
   bResult = bResult && (MaxGuidanceManeuverCapacity == roRef.MaxGuidanceManeuverCapacity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_RouteGuidanceDisplayComponents::mplay_fi_tcl_RouteGuidanceDisplayComponents(const mplay_fi_tcl_RouteGuidanceDisplayComponents& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   oItems = coRef.oItems;
}
mplay_fi_tcl_RouteGuidanceDisplayComponents& mplay_fi_tcl_RouteGuidanceDisplayComponents::operator=(const mplay_fi_tcl_RouteGuidanceDisplayComponents& coRef)
{
   if (this == &coRef) return *this;
   oItems = coRef.oItems;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_RouteGuidanceDisplayComponents::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         oItems[u32Idx].vDestroy();
   oItems.clear();
   }
}

mplay_fi_tcl_RouteGuidanceDisplayComponents::mplay_fi_tcl_RouteGuidanceDisplayComponents()

 {}

tS32 mplay_fi_tcl_RouteGuidanceDisplayComponents::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_ROUTEGUIDANCEDISPLAYCOMPONENTS;
}


mplay_fi_tcl_RouteGuidanceDisplayComponents::~mplay_fi_tcl_RouteGuidanceDisplayComponents()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_RouteGuidanceDisplayComponents::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < oItems.size(); ++u32ListIdx)
      u32DynamicSize += oItems[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& mplay_fi_tcl_RouteGuidanceDisplayComponents::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
      {
         oItems[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oItems.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oItems[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_RouteGuidanceDisplayComponents::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)oItems.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oItems.size(); ++u32Idx)
         (tVoid) (oOut << oItems[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_RouteGuidanceDisplayComponents::operator==(const mplay_fi_tcl_RouteGuidanceDisplayComponents& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (oItems.size() == roRef.oItems.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oItems.size()); ++u32Idx)
            bResult = bResult && (oItems[u32Idx] == roRef.oItems[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_RouteGuidanceUpdate::mplay_fi_tcl_RouteGuidanceUpdate(const mplay_fi_tcl_RouteGuidanceUpdate& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   bRouteGuidanceStateAvailable = coRef.bRouteGuidanceStateAvailable;
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   bManeuverStateAvailable = coRef.bManeuverStateAvailable;
   e8ManeuverState = coRef.e8ManeuverState;
   bCurrentRoadNameAvailable = coRef.bCurrentRoadNameAvailable;
   CurrentRoadName = coRef.CurrentRoadName;
   bDestinationNameAvailable = coRef.bDestinationNameAvailable;
   DestinationName = coRef.DestinationName;
   bEstimatedTimeOfArrivalAvailable = coRef.bEstimatedTimeOfArrivalAvailable;
   EstimatedTimeOfArrival = coRef.EstimatedTimeOfArrival;
   bTimeRemainingToDestinationAvailable = coRef.bTimeRemainingToDestinationAvailable;
   TimeRemainingToDestination = coRef.TimeRemainingToDestination;
   bDistanceRemainingAvailable = coRef.bDistanceRemainingAvailable;
   DistanceRemaining = coRef.DistanceRemaining;
   bDistanceRemainingDisplayStrAvailable = coRef.bDistanceRemainingDisplayStrAvailable;
   DistanceRemainingDisplayStr = coRef.DistanceRemainingDisplayStr;
   bDistanceRemainingDisplayUnitsAvailable = coRef.bDistanceRemainingDisplayUnitsAvailable;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   bDistanceToNextManeuverAvailable = coRef.bDistanceToNextManeuverAvailable;
   DistanceToNextManeuver = coRef.DistanceToNextManeuver;
   bDistanceToNextManeuverDisplayStrAvailable = coRef.bDistanceToNextManeuverDisplayStrAvailable;
   DistanceToNextManeuverDisplayStr = coRef.DistanceToNextManeuverDisplayStr;
   bDistanceToNextManeuverDisplayUnitsAvailable = coRef.bDistanceToNextManeuverDisplayUnitsAvailable;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   bRouteGuidanceManeuverCurrentListAvailable = coRef.bRouteGuidanceManeuverCurrentListAvailable;
   RouteGuidanceManeuverCurrentList = coRef.RouteGuidanceManeuverCurrentList;
   bRouteGuidanceManeuverCountAvailable = coRef.bRouteGuidanceManeuverCountAvailable;
   RouteGuidanceManeuverCount = coRef.RouteGuidanceManeuverCount;
   bRouteGuidanceVisibleInAppAvailable = coRef.bRouteGuidanceVisibleInAppAvailable;
   RouteGuidanceVisibleInApp = coRef.RouteGuidanceVisibleInApp;
   bSourceNameAvailable = coRef.bSourceNameAvailable;
   SourceName = coRef.SourceName;
   bSourceSupportsRouteGuidanceAvailable = coRef.bSourceSupportsRouteGuidanceAvailable;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
}
mplay_fi_tcl_RouteGuidanceUpdate& mplay_fi_tcl_RouteGuidanceUpdate::operator=(const mplay_fi_tcl_RouteGuidanceUpdate& coRef)
{
   if (this == &coRef) return *this;
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   bRouteGuidanceStateAvailable = coRef.bRouteGuidanceStateAvailable;
   e8RouteGuidanceState = coRef.e8RouteGuidanceState;
   bManeuverStateAvailable = coRef.bManeuverStateAvailable;
   e8ManeuverState = coRef.e8ManeuverState;
   bCurrentRoadNameAvailable = coRef.bCurrentRoadNameAvailable;
   CurrentRoadName = coRef.CurrentRoadName;
   bDestinationNameAvailable = coRef.bDestinationNameAvailable;
   DestinationName = coRef.DestinationName;
   bEstimatedTimeOfArrivalAvailable = coRef.bEstimatedTimeOfArrivalAvailable;
   EstimatedTimeOfArrival = coRef.EstimatedTimeOfArrival;
   bTimeRemainingToDestinationAvailable = coRef.bTimeRemainingToDestinationAvailable;
   TimeRemainingToDestination = coRef.TimeRemainingToDestination;
   bDistanceRemainingAvailable = coRef.bDistanceRemainingAvailable;
   DistanceRemaining = coRef.DistanceRemaining;
   bDistanceRemainingDisplayStrAvailable = coRef.bDistanceRemainingDisplayStrAvailable;
   DistanceRemainingDisplayStr = coRef.DistanceRemainingDisplayStr;
   bDistanceRemainingDisplayUnitsAvailable = coRef.bDistanceRemainingDisplayUnitsAvailable;
   e8DistanceRemainingDisplayUnits = coRef.e8DistanceRemainingDisplayUnits;
   bDistanceToNextManeuverAvailable = coRef.bDistanceToNextManeuverAvailable;
   DistanceToNextManeuver = coRef.DistanceToNextManeuver;
   bDistanceToNextManeuverDisplayStrAvailable = coRef.bDistanceToNextManeuverDisplayStrAvailable;
   DistanceToNextManeuverDisplayStr = coRef.DistanceToNextManeuverDisplayStr;
   bDistanceToNextManeuverDisplayUnitsAvailable = coRef.bDistanceToNextManeuverDisplayUnitsAvailable;
   e8DistanceToNextManeuverDisplayUnits = coRef.e8DistanceToNextManeuverDisplayUnits;
   bRouteGuidanceManeuverCurrentListAvailable = coRef.bRouteGuidanceManeuverCurrentListAvailable;
   RouteGuidanceManeuverCurrentList = coRef.RouteGuidanceManeuverCurrentList;
   bRouteGuidanceManeuverCountAvailable = coRef.bRouteGuidanceManeuverCountAvailable;
   RouteGuidanceManeuverCount = coRef.RouteGuidanceManeuverCount;
   bRouteGuidanceVisibleInAppAvailable = coRef.bRouteGuidanceVisibleInAppAvailable;
   RouteGuidanceVisibleInApp = coRef.RouteGuidanceVisibleInApp;
   bSourceNameAvailable = coRef.bSourceNameAvailable;
   SourceName = coRef.SourceName;
   bSourceSupportsRouteGuidanceAvailable = coRef.bSourceSupportsRouteGuidanceAvailable;
   SourceSupportsRouteGuidance = coRef.SourceSupportsRouteGuidance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_RouteGuidanceUpdate::vDestroy()
{
   RouteGuidanceDisplayComponentIDs.vDestroy(); 
   CurrentRoadName.vDestroy();
   DestinationName.vDestroy();
   DistanceRemainingDisplayStr.vDestroy();
   DistanceToNextManeuverDisplayStr.vDestroy();
   RouteGuidanceManeuverCurrentList.vDestroy(); 
   SourceName.vDestroy();
}

mplay_fi_tcl_RouteGuidanceUpdate::mplay_fi_tcl_RouteGuidanceUpdate()
:bRouteGuidanceDisplayComponentIDsAvailable(0)
,RouteGuidanceDisplayComponentIDs()
,bRouteGuidanceStateAvailable(0)
,e8RouteGuidanceState()
,bManeuverStateAvailable(0)
,e8ManeuverState()
,bCurrentRoadNameAvailable(0)
,CurrentRoadName()
,bDestinationNameAvailable(0)
,DestinationName()
,bEstimatedTimeOfArrivalAvailable(0)
,EstimatedTimeOfArrival(0)
,bTimeRemainingToDestinationAvailable(0)
,TimeRemainingToDestination(0)
,bDistanceRemainingAvailable(0)
,DistanceRemaining(0)
,bDistanceRemainingDisplayStrAvailable(0)
,DistanceRemainingDisplayStr()
,bDistanceRemainingDisplayUnitsAvailable(0)
,e8DistanceRemainingDisplayUnits()
,bDistanceToNextManeuverAvailable(0)
,DistanceToNextManeuver(0)
,bDistanceToNextManeuverDisplayStrAvailable(0)
,DistanceToNextManeuverDisplayStr()
,bDistanceToNextManeuverDisplayUnitsAvailable(0)
,e8DistanceToNextManeuverDisplayUnits()
,bRouteGuidanceManeuverCurrentListAvailable(0)
,RouteGuidanceManeuverCurrentList()
,bRouteGuidanceManeuverCountAvailable(0)
,RouteGuidanceManeuverCount(0)
,bRouteGuidanceVisibleInAppAvailable(0)
,RouteGuidanceVisibleInApp(0)
,bSourceNameAvailable(0)
,SourceName()
,bSourceSupportsRouteGuidanceAvailable(0)
,SourceSupportsRouteGuidance(0)
 {}

tS32 mplay_fi_tcl_RouteGuidanceUpdate::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_ROUTEGUIDANCEUPDATE;
}


mplay_fi_tcl_RouteGuidanceUpdate::~mplay_fi_tcl_RouteGuidanceUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_RouteGuidanceUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 50+RouteGuidanceDisplayComponentIDs.u32GetSize(u16MajorVersion)+CurrentRoadName.u32GetSize(u16MajorVersion)+DestinationName.u32GetSize(u16MajorVersion)+DistanceRemainingDisplayStr.u32GetSize(u16MajorVersion)+DistanceToNextManeuverDisplayStr.u32GetSize(u16MajorVersion)+RouteGuidanceManeuverCurrentList.u32GetSize(u16MajorVersion)+SourceName.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_RouteGuidanceUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRouteGuidanceDisplayComponentIDsAvailable);
   (tVoid) (oIn >> RouteGuidanceDisplayComponentIDs);
   (tVoid) (oIn >> bRouteGuidanceStateAvailable);
   (tVoid) (oIn >> e8RouteGuidanceState);
   (tVoid) (oIn >> bManeuverStateAvailable);
   (tVoid) (oIn >> e8ManeuverState);
   (tVoid) (oIn >> bCurrentRoadNameAvailable);
   (tVoid) (oIn >> CurrentRoadName);
   (tVoid) (oIn >> bDestinationNameAvailable);
   (tVoid) (oIn >> DestinationName);
   (tVoid) (oIn >> bEstimatedTimeOfArrivalAvailable);
   (tVoid) (oIn >> EstimatedTimeOfArrival);
   (tVoid) (oIn >> bTimeRemainingToDestinationAvailable);
   (tVoid) (oIn >> TimeRemainingToDestination);
   (tVoid) (oIn >> bDistanceRemainingAvailable);
   (tVoid) (oIn >> DistanceRemaining);
   (tVoid) (oIn >> bDistanceRemainingDisplayStrAvailable);
   (tVoid) (oIn >> DistanceRemainingDisplayStr);
   (tVoid) (oIn >> bDistanceRemainingDisplayUnitsAvailable);
   (tVoid) (oIn >> e8DistanceRemainingDisplayUnits);
   (tVoid) (oIn >> bDistanceToNextManeuverAvailable);
   (tVoid) (oIn >> DistanceToNextManeuver);
   (tVoid) (oIn >> bDistanceToNextManeuverDisplayStrAvailable);
   (tVoid) (oIn >> DistanceToNextManeuverDisplayStr);
   (tVoid) (oIn >> bDistanceToNextManeuverDisplayUnitsAvailable);
   (tVoid) (oIn >> e8DistanceToNextManeuverDisplayUnits);
   (tVoid) (oIn >> bRouteGuidanceManeuverCurrentListAvailable);
   (tVoid) (oIn >> RouteGuidanceManeuverCurrentList);
   (tVoid) (oIn >> bRouteGuidanceManeuverCountAvailable);
   (tVoid) (oIn >> RouteGuidanceManeuverCount);
   (tVoid) (oIn >> bRouteGuidanceVisibleInAppAvailable);
   (tVoid) (oIn >> RouteGuidanceVisibleInApp);
   (tVoid) (oIn >> bSourceNameAvailable);
   (tVoid) (oIn >> SourceName);
   (tVoid) (oIn >> bSourceSupportsRouteGuidanceAvailable);
   (tVoid) (oIn >> SourceSupportsRouteGuidance);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_RouteGuidanceUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRouteGuidanceDisplayComponentIDsAvailable);
   (tVoid) (oOut << RouteGuidanceDisplayComponentIDs);
   (tVoid) (oOut << bRouteGuidanceStateAvailable);
   (tVoid) (oOut << e8RouteGuidanceState);
   (tVoid) (oOut << bManeuverStateAvailable);
   (tVoid) (oOut << e8ManeuverState);
   (tVoid) (oOut << bCurrentRoadNameAvailable);
   (tVoid) (oOut << CurrentRoadName);
   (tVoid) (oOut << bDestinationNameAvailable);
   (tVoid) (oOut << DestinationName);
   (tVoid) (oOut << bEstimatedTimeOfArrivalAvailable);
   (tVoid) (oOut << EstimatedTimeOfArrival);
   (tVoid) (oOut << bTimeRemainingToDestinationAvailable);
   (tVoid) (oOut << TimeRemainingToDestination);
   (tVoid) (oOut << bDistanceRemainingAvailable);
   (tVoid) (oOut << DistanceRemaining);
   (tVoid) (oOut << bDistanceRemainingDisplayStrAvailable);
   (tVoid) (oOut << DistanceRemainingDisplayStr);
   (tVoid) (oOut << bDistanceRemainingDisplayUnitsAvailable);
   (tVoid) (oOut << e8DistanceRemainingDisplayUnits);
   (tVoid) (oOut << bDistanceToNextManeuverAvailable);
   (tVoid) (oOut << DistanceToNextManeuver);
   (tVoid) (oOut << bDistanceToNextManeuverDisplayStrAvailable);
   (tVoid) (oOut << DistanceToNextManeuverDisplayStr);
   (tVoid) (oOut << bDistanceToNextManeuverDisplayUnitsAvailable);
   (tVoid) (oOut << e8DistanceToNextManeuverDisplayUnits);
   (tVoid) (oOut << bRouteGuidanceManeuverCurrentListAvailable);
   (tVoid) (oOut << RouteGuidanceManeuverCurrentList);
   (tVoid) (oOut << bRouteGuidanceManeuverCountAvailable);
   (tVoid) (oOut << RouteGuidanceManeuverCount);
   (tVoid) (oOut << bRouteGuidanceVisibleInAppAvailable);
   (tVoid) (oOut << RouteGuidanceVisibleInApp);
   (tVoid) (oOut << bSourceNameAvailable);
   (tVoid) (oOut << SourceName);
   (tVoid) (oOut << bSourceSupportsRouteGuidanceAvailable);
   (tVoid) (oOut << SourceSupportsRouteGuidance);
   return oOut;
}

tBool mplay_fi_tcl_RouteGuidanceUpdate::operator==(const mplay_fi_tcl_RouteGuidanceUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRouteGuidanceDisplayComponentIDsAvailable == roRef.bRouteGuidanceDisplayComponentIDsAvailable);
   bResult = bResult && (RouteGuidanceDisplayComponentIDs == roRef.RouteGuidanceDisplayComponentIDs);
   bResult = bResult && (bRouteGuidanceStateAvailable == roRef.bRouteGuidanceStateAvailable);
   bResult = bResult && (e8RouteGuidanceState == roRef.e8RouteGuidanceState);
   bResult = bResult && (bManeuverStateAvailable == roRef.bManeuverStateAvailable);
   bResult = bResult && (e8ManeuverState == roRef.e8ManeuverState);
   bResult = bResult && (bCurrentRoadNameAvailable == roRef.bCurrentRoadNameAvailable);
   bResult = bResult && (CurrentRoadName == roRef.CurrentRoadName);
   bResult = bResult && (bDestinationNameAvailable == roRef.bDestinationNameAvailable);
   bResult = bResult && (DestinationName == roRef.DestinationName);
   bResult = bResult && (bEstimatedTimeOfArrivalAvailable == roRef.bEstimatedTimeOfArrivalAvailable);
   bResult = bResult && (EstimatedTimeOfArrival == roRef.EstimatedTimeOfArrival);
   bResult = bResult && (bTimeRemainingToDestinationAvailable == roRef.bTimeRemainingToDestinationAvailable);
   bResult = bResult && (TimeRemainingToDestination == roRef.TimeRemainingToDestination);
   bResult = bResult && (bDistanceRemainingAvailable == roRef.bDistanceRemainingAvailable);
   bResult = bResult && (DistanceRemaining == roRef.DistanceRemaining);
   bResult = bResult && (bDistanceRemainingDisplayStrAvailable == roRef.bDistanceRemainingDisplayStrAvailable);
   bResult = bResult && (DistanceRemainingDisplayStr == roRef.DistanceRemainingDisplayStr);
   bResult = bResult && (bDistanceRemainingDisplayUnitsAvailable == roRef.bDistanceRemainingDisplayUnitsAvailable);
   bResult = bResult && (e8DistanceRemainingDisplayUnits == roRef.e8DistanceRemainingDisplayUnits);
   bResult = bResult && (bDistanceToNextManeuverAvailable == roRef.bDistanceToNextManeuverAvailable);
   bResult = bResult && (DistanceToNextManeuver == roRef.DistanceToNextManeuver);
   bResult = bResult && (bDistanceToNextManeuverDisplayStrAvailable == roRef.bDistanceToNextManeuverDisplayStrAvailable);
   bResult = bResult && (DistanceToNextManeuverDisplayStr == roRef.DistanceToNextManeuverDisplayStr);
   bResult = bResult && (bDistanceToNextManeuverDisplayUnitsAvailable == roRef.bDistanceToNextManeuverDisplayUnitsAvailable);
   bResult = bResult && (e8DistanceToNextManeuverDisplayUnits == roRef.e8DistanceToNextManeuverDisplayUnits);
   bResult = bResult && (bRouteGuidanceManeuverCurrentListAvailable == roRef.bRouteGuidanceManeuverCurrentListAvailable);
   bResult = bResult && (RouteGuidanceManeuverCurrentList == roRef.RouteGuidanceManeuverCurrentList);
   bResult = bResult && (bRouteGuidanceManeuverCountAvailable == roRef.bRouteGuidanceManeuverCountAvailable);
   bResult = bResult && (RouteGuidanceManeuverCount == roRef.RouteGuidanceManeuverCount);
   bResult = bResult && (bRouteGuidanceVisibleInAppAvailable == roRef.bRouteGuidanceVisibleInAppAvailable);
   bResult = bResult && (RouteGuidanceVisibleInApp == roRef.RouteGuidanceVisibleInApp);
   bResult = bResult && (bSourceNameAvailable == roRef.bSourceNameAvailable);
   bResult = bResult && (SourceName == roRef.SourceName);
   bResult = bResult && (bSourceSupportsRouteGuidanceAvailable == roRef.bSourceSupportsRouteGuidanceAvailable);
   bResult = bResult && (SourceSupportsRouteGuidance == roRef.SourceSupportsRouteGuidance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_RouteGuidanceManeuverUpdate::mplay_fi_tcl_RouteGuidanceManeuverUpdate(const mplay_fi_tcl_RouteGuidanceManeuverUpdate& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   bIndexAvailable = coRef.bIndexAvailable;
   Index = coRef.Index;
   bManeuverDescriptionAvailable = coRef.bManeuverDescriptionAvailable;
   ManeuverDescription = coRef.ManeuverDescription;
   bManeuverTypeAvailable = coRef.bManeuverTypeAvailable;
   e8ManeuverType = coRef.e8ManeuverType;
   bAfterManeuverRoadNameAvailable = coRef.bAfterManeuverRoadNameAvailable;
   AfterManeuverRoadName = coRef.AfterManeuverRoadName;
   bDistanceBetweenManeuverAvailable = coRef.bDistanceBetweenManeuverAvailable;
   DistanceBetweenManeuver = coRef.DistanceBetweenManeuver;
   bDistanceBetweenManeuverDisplayStrAvailable = coRef.bDistanceBetweenManeuverDisplayStrAvailable;
   DistanceBetweenManeuverDisplayStr = coRef.DistanceBetweenManeuverDisplayStr;
   bDistanceBetweenManeuverDisplayUnitsAvailable = coRef.bDistanceBetweenManeuverDisplayUnitsAvailable;
   e8DistanceBetweenManeuverDisplayUnits = coRef.e8DistanceBetweenManeuverDisplayUnits;
   bDrivingSideAvailable = coRef.bDrivingSideAvailable;
   e8DrivingSide = coRef.e8DrivingSide;
   bJunctionTypeAvailable = coRef.bJunctionTypeAvailable;
   e8JunctionType = coRef.e8JunctionType;
   bJunctionElementAngleAvailable = coRef.bJunctionElementAngleAvailable;
   JunctionElementAngle = coRef.JunctionElementAngle;
   bJunctionElementExitAngleAvailable = coRef.bJunctionElementExitAngleAvailable;
   JunctionElementExitAngle = coRef.JunctionElementExitAngle;
}
mplay_fi_tcl_RouteGuidanceManeuverUpdate& mplay_fi_tcl_RouteGuidanceManeuverUpdate::operator=(const mplay_fi_tcl_RouteGuidanceManeuverUpdate& coRef)
{
   if (this == &coRef) return *this;
   bRouteGuidanceDisplayComponentIDsAvailable = coRef.bRouteGuidanceDisplayComponentIDsAvailable;
   RouteGuidanceDisplayComponentIDs = coRef.RouteGuidanceDisplayComponentIDs;
   bIndexAvailable = coRef.bIndexAvailable;
   Index = coRef.Index;
   bManeuverDescriptionAvailable = coRef.bManeuverDescriptionAvailable;
   ManeuverDescription = coRef.ManeuverDescription;
   bManeuverTypeAvailable = coRef.bManeuverTypeAvailable;
   e8ManeuverType = coRef.e8ManeuverType;
   bAfterManeuverRoadNameAvailable = coRef.bAfterManeuverRoadNameAvailable;
   AfterManeuverRoadName = coRef.AfterManeuverRoadName;
   bDistanceBetweenManeuverAvailable = coRef.bDistanceBetweenManeuverAvailable;
   DistanceBetweenManeuver = coRef.DistanceBetweenManeuver;
   bDistanceBetweenManeuverDisplayStrAvailable = coRef.bDistanceBetweenManeuverDisplayStrAvailable;
   DistanceBetweenManeuverDisplayStr = coRef.DistanceBetweenManeuverDisplayStr;
   bDistanceBetweenManeuverDisplayUnitsAvailable = coRef.bDistanceBetweenManeuverDisplayUnitsAvailable;
   e8DistanceBetweenManeuverDisplayUnits = coRef.e8DistanceBetweenManeuverDisplayUnits;
   bDrivingSideAvailable = coRef.bDrivingSideAvailable;
   e8DrivingSide = coRef.e8DrivingSide;
   bJunctionTypeAvailable = coRef.bJunctionTypeAvailable;
   e8JunctionType = coRef.e8JunctionType;
   bJunctionElementAngleAvailable = coRef.bJunctionElementAngleAvailable;
   JunctionElementAngle = coRef.JunctionElementAngle;
   bJunctionElementExitAngleAvailable = coRef.bJunctionElementExitAngleAvailable;
   JunctionElementExitAngle = coRef.JunctionElementExitAngle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_RouteGuidanceManeuverUpdate::vDestroy()
{
   RouteGuidanceDisplayComponentIDs.vDestroy(); 
   ManeuverDescription.vDestroy();
   AfterManeuverRoadName.vDestroy();
   DistanceBetweenManeuverDisplayStr.vDestroy();
   JunctionElementAngle.vDestroy(); 
}

mplay_fi_tcl_RouteGuidanceManeuverUpdate::mplay_fi_tcl_RouteGuidanceManeuverUpdate()
:bRouteGuidanceDisplayComponentIDsAvailable(0)
,RouteGuidanceDisplayComponentIDs()
,bIndexAvailable(0)
,Index(0)
,bManeuverDescriptionAvailable(0)
,ManeuverDescription()
,bManeuverTypeAvailable(0)
,e8ManeuverType()
,bAfterManeuverRoadNameAvailable(0)
,AfterManeuverRoadName()
,bDistanceBetweenManeuverAvailable(0)
,DistanceBetweenManeuver(0)
,bDistanceBetweenManeuverDisplayStrAvailable(0)
,DistanceBetweenManeuverDisplayStr()
,bDistanceBetweenManeuverDisplayUnitsAvailable(0)
,e8DistanceBetweenManeuverDisplayUnits()
,bDrivingSideAvailable(0)
,e8DrivingSide()
,bJunctionTypeAvailable(0)
,e8JunctionType()
,bJunctionElementAngleAvailable(0)
,JunctionElementAngle()
,bJunctionElementExitAngleAvailable(0)
,JunctionElementExitAngle(0)
 {}

tS32 mplay_fi_tcl_RouteGuidanceManeuverUpdate::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_ROUTEGUIDANCEMANEUVERUPDATE;
}


mplay_fi_tcl_RouteGuidanceManeuverUpdate::~mplay_fi_tcl_RouteGuidanceManeuverUpdate()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_RouteGuidanceManeuverUpdate::u32GetSize(tU16 u16MajorVersion) const
{
   return 24+RouteGuidanceDisplayComponentIDs.u32GetSize(u16MajorVersion)+ManeuverDescription.u32GetSize(u16MajorVersion)+AfterManeuverRoadName.u32GetSize(u16MajorVersion)+DistanceBetweenManeuverDisplayStr.u32GetSize(u16MajorVersion)+JunctionElementAngle.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_RouteGuidanceManeuverUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bRouteGuidanceDisplayComponentIDsAvailable);
   (tVoid) (oIn >> RouteGuidanceDisplayComponentIDs);
   (tVoid) (oIn >> bIndexAvailable);
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> bManeuverDescriptionAvailable);
   (tVoid) (oIn >> ManeuverDescription);
   (tVoid) (oIn >> bManeuverTypeAvailable);
   (tVoid) (oIn >> e8ManeuverType);
   (tVoid) (oIn >> bAfterManeuverRoadNameAvailable);
   (tVoid) (oIn >> AfterManeuverRoadName);
   (tVoid) (oIn >> bDistanceBetweenManeuverAvailable);
   (tVoid) (oIn >> DistanceBetweenManeuver);
   (tVoid) (oIn >> bDistanceBetweenManeuverDisplayStrAvailable);
   (tVoid) (oIn >> DistanceBetweenManeuverDisplayStr);
   (tVoid) (oIn >> bDistanceBetweenManeuverDisplayUnitsAvailable);
   (tVoid) (oIn >> e8DistanceBetweenManeuverDisplayUnits);
   (tVoid) (oIn >> bDrivingSideAvailable);
   (tVoid) (oIn >> e8DrivingSide);
   (tVoid) (oIn >> bJunctionTypeAvailable);
   (tVoid) (oIn >> e8JunctionType);
   (tVoid) (oIn >> bJunctionElementAngleAvailable);
   (tVoid) (oIn >> JunctionElementAngle);
   (tVoid) (oIn >> bJunctionElementExitAngleAvailable);
   (tVoid) (oIn >> JunctionElementExitAngle);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_RouteGuidanceManeuverUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bRouteGuidanceDisplayComponentIDsAvailable);
   (tVoid) (oOut << RouteGuidanceDisplayComponentIDs);
   (tVoid) (oOut << bIndexAvailable);
   (tVoid) (oOut << Index);
   (tVoid) (oOut << bManeuverDescriptionAvailable);
   (tVoid) (oOut << ManeuverDescription);
   (tVoid) (oOut << bManeuverTypeAvailable);
   (tVoid) (oOut << e8ManeuverType);
   (tVoid) (oOut << bAfterManeuverRoadNameAvailable);
   (tVoid) (oOut << AfterManeuverRoadName);
   (tVoid) (oOut << bDistanceBetweenManeuverAvailable);
   (tVoid) (oOut << DistanceBetweenManeuver);
   (tVoid) (oOut << bDistanceBetweenManeuverDisplayStrAvailable);
   (tVoid) (oOut << DistanceBetweenManeuverDisplayStr);
   (tVoid) (oOut << bDistanceBetweenManeuverDisplayUnitsAvailable);
   (tVoid) (oOut << e8DistanceBetweenManeuverDisplayUnits);
   (tVoid) (oOut << bDrivingSideAvailable);
   (tVoid) (oOut << e8DrivingSide);
   (tVoid) (oOut << bJunctionTypeAvailable);
   (tVoid) (oOut << e8JunctionType);
   (tVoid) (oOut << bJunctionElementAngleAvailable);
   (tVoid) (oOut << JunctionElementAngle);
   (tVoid) (oOut << bJunctionElementExitAngleAvailable);
   (tVoid) (oOut << JunctionElementExitAngle);
   return oOut;
}

tBool mplay_fi_tcl_RouteGuidanceManeuverUpdate::operator==(const mplay_fi_tcl_RouteGuidanceManeuverUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bRouteGuidanceDisplayComponentIDsAvailable == roRef.bRouteGuidanceDisplayComponentIDsAvailable);
   bResult = bResult && (RouteGuidanceDisplayComponentIDs == roRef.RouteGuidanceDisplayComponentIDs);
   bResult = bResult && (bIndexAvailable == roRef.bIndexAvailable);
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (bManeuverDescriptionAvailable == roRef.bManeuverDescriptionAvailable);
   bResult = bResult && (ManeuverDescription == roRef.ManeuverDescription);
   bResult = bResult && (bManeuverTypeAvailable == roRef.bManeuverTypeAvailable);
   bResult = bResult && (e8ManeuverType == roRef.e8ManeuverType);
   bResult = bResult && (bAfterManeuverRoadNameAvailable == roRef.bAfterManeuverRoadNameAvailable);
   bResult = bResult && (AfterManeuverRoadName == roRef.AfterManeuverRoadName);
   bResult = bResult && (bDistanceBetweenManeuverAvailable == roRef.bDistanceBetweenManeuverAvailable);
   bResult = bResult && (DistanceBetweenManeuver == roRef.DistanceBetweenManeuver);
   bResult = bResult && (bDistanceBetweenManeuverDisplayStrAvailable == roRef.bDistanceBetweenManeuverDisplayStrAvailable);
   bResult = bResult && (DistanceBetweenManeuverDisplayStr == roRef.DistanceBetweenManeuverDisplayStr);
   bResult = bResult && (bDistanceBetweenManeuverDisplayUnitsAvailable == roRef.bDistanceBetweenManeuverDisplayUnitsAvailable);
   bResult = bResult && (e8DistanceBetweenManeuverDisplayUnits == roRef.e8DistanceBetweenManeuverDisplayUnits);
   bResult = bResult && (bDrivingSideAvailable == roRef.bDrivingSideAvailable);
   bResult = bResult && (e8DrivingSide == roRef.e8DrivingSide);
   bResult = bResult && (bJunctionTypeAvailable == roRef.bJunctionTypeAvailable);
   bResult = bResult && (e8JunctionType == roRef.e8JunctionType);
   bResult = bResult && (bJunctionElementAngleAvailable == roRef.bJunctionElementAngleAvailable);
   bResult = bResult && (JunctionElementAngle == roRef.JunctionElementAngle);
   bResult = bResult && (bJunctionElementExitAngleAvailable == roRef.bJunctionElementExitAngleAvailable);
   bResult = bResult && (JunctionElementExitAngle == roRef.JunctionElementExitAngle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_CallControlsConfiguration::mplay_fi_tcl_CallControlsConfiguration():u8Value(0)
{}

tS32 mplay_fi_tcl_CallControlsConfiguration::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_CALLCONTROLSCONFIGURATION;
}


mplay_fi_tcl_CallControlsConfiguration::~mplay_fi_tcl_CallControlsConfiguration()
{}

tU32 mplay_fi_tcl_CallControlsConfiguration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_CallControlsConfiguration::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& mplay_fi_tcl_CallControlsConfiguration::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_InitiateCallType::mplay_fi_tcl_e_InitiateCallType():enType(FI_EN_EDESTINATION) {}

tS32 mplay_fi_tcl_e_InitiateCallType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_INITIATECALLTYPE;
}


mplay_fi_tcl_e_InitiateCallType::~mplay_fi_tcl_e_InitiateCallType()
{}

tU32 mplay_fi_tcl_e_InitiateCallType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_InitiateCallType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_InitiateCallType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_InitiateCallService::mplay_fi_tcl_e_InitiateCallService():enType(FI_EN_ETELEPHONY) {}

tS32 mplay_fi_tcl_e_InitiateCallService::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_INITIATECALLSERVICE;
}


mplay_fi_tcl_e_InitiateCallService::~mplay_fi_tcl_e_InitiateCallService()
{}

tU32 mplay_fi_tcl_e_InitiateCallService::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_InitiateCallService::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_InitiateCallService::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_AcceptAction::mplay_fi_tcl_e_AcceptAction():enType(FI_EN_EACCEPT_OR_HOLD_AND_ACCEPT) {}

tS32 mplay_fi_tcl_e_AcceptAction::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_ACCEPTACTION;
}


mplay_fi_tcl_e_AcceptAction::~mplay_fi_tcl_e_AcceptAction()
{}

tU32 mplay_fi_tcl_e_AcceptAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_AcceptAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_AcceptAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_EndAction::mplay_fi_tcl_e_EndAction():enType(FI_EN_EEND_OR_DECLINE) {}

tS32 mplay_fi_tcl_e_EndAction::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_ENDACTION;
}


mplay_fi_tcl_e_EndAction::~mplay_fi_tcl_e_EndAction()
{}

tU32 mplay_fi_tcl_e_EndAction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_EndAction::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_EndAction::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e_SendDTMFTone::mplay_fi_tcl_e_SendDTMFTone():enType(FI_EN_NUMBER_0) {}

tS32 mplay_fi_tcl_e_SendDTMFTone::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E_SENDDTMFTONE;
}


mplay_fi_tcl_e_SendDTMFTone::~mplay_fi_tcl_e_SendDTMFTone()
{}

tU32 mplay_fi_tcl_e_SendDTMFTone::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e_SendDTMFTone::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e_SendDTMFTone::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiPOCommunicationError::mplay_fi_tcl_e8_DiPOCommunicationError():enType(FI_EN_E8IPOD_NO_ERROR) {}

tS32 mplay_fi_tcl_e8_DiPOCommunicationError::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIPOCOMMUNICATIONERROR;
}


mplay_fi_tcl_e8_DiPOCommunicationError::~mplay_fi_tcl_e8_DiPOCommunicationError()
{}

tU32 mplay_fi_tcl_e8_DiPOCommunicationError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiPOCommunicationError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiPOCommunicationError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_AppInfo::mplay_fi_tcl_AppInfo(const mplay_fi_tcl_AppInfo& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   sAppName = coRef.sAppName;
   sProtocol = coRef.sProtocol;
   sBundleID = coRef.sBundleID;
}
mplay_fi_tcl_AppInfo& mplay_fi_tcl_AppInfo::operator=(const mplay_fi_tcl_AppInfo& coRef)
{
   if (this == &coRef) return *this;
   sAppName = coRef.sAppName;
   sProtocol = coRef.sProtocol;
   sBundleID = coRef.sBundleID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_AppInfo::vDestroy()
{
   sAppName.vDestroy();
   sProtocol.vDestroy();
   sBundleID.vDestroy();
}

mplay_fi_tcl_AppInfo::mplay_fi_tcl_AppInfo()
:sAppName()
,sProtocol()
,sBundleID()
 {}

tS32 mplay_fi_tcl_AppInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_APPINFO;
}


mplay_fi_tcl_AppInfo::~mplay_fi_tcl_AppInfo()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_AppInfo::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+sAppName.u32GetSize(u16MajorVersion)+sProtocol.u32GetSize(u16MajorVersion)+sBundleID.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_fi_tcl_AppInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sAppName);
   (tVoid) (oIn >> sProtocol);
   (tVoid) (oIn >> sBundleID);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_AppInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sAppName);
   (tVoid) (oOut << sProtocol);
   (tVoid) (oOut << sBundleID);
   return oOut;
}

tBool mplay_fi_tcl_AppInfo::operator==(const mplay_fi_tcl_AppInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sAppName == roRef.sAppName);
   bResult = bResult && (sProtocol == roRef.sProtocol);
   bResult = bResult && (sBundleID == roRef.sBundleID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DeviceTimeUpdate::mplay_fi_tcl_DeviceTimeUpdate(const mplay_fi_tcl_DeviceTimeUpdate& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u64SecondsSinceReferenceDate = coRef.u64SecondsSinceReferenceDate;
   s16TimeZoneOffsetMinutes = coRef.s16TimeZoneOffsetMinutes;
   s8DaylightSavingsOffsetMinutes = coRef.s8DaylightSavingsOffsetMinutes;
}
mplay_fi_tcl_DeviceTimeUpdate& mplay_fi_tcl_DeviceTimeUpdate::operator=(const mplay_fi_tcl_DeviceTimeUpdate& coRef)
{
   if (this == &coRef) return *this;
   u64SecondsSinceReferenceDate = coRef.u64SecondsSinceReferenceDate;
   s16TimeZoneOffsetMinutes = coRef.s16TimeZoneOffsetMinutes;
   s8DaylightSavingsOffsetMinutes = coRef.s8DaylightSavingsOffsetMinutes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DeviceTimeUpdate::mplay_fi_tcl_DeviceTimeUpdate()
:u64SecondsSinceReferenceDate(0)
,s16TimeZoneOffsetMinutes(0)
,s8DaylightSavingsOffsetMinutes(0)
 {}

tS32 mplay_fi_tcl_DeviceTimeUpdate::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DEVICETIMEUPDATE;
}


mplay_fi_tcl_DeviceTimeUpdate::~mplay_fi_tcl_DeviceTimeUpdate()
{}

tU32 mplay_fi_tcl_DeviceTimeUpdate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& mplay_fi_tcl_DeviceTimeUpdate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u64SecondsSinceReferenceDate);
   (tVoid) (oIn >> s16TimeZoneOffsetMinutes);
   (tVoid) (oIn >> s8DaylightSavingsOffsetMinutes);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DeviceTimeUpdate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u64SecondsSinceReferenceDate);
   (tVoid) (oOut << s16TimeZoneOffsetMinutes);
   (tVoid) (oOut << s8DaylightSavingsOffsetMinutes);
   return oOut;
}

tBool mplay_fi_tcl_DeviceTimeUpdate::operator==(const mplay_fi_tcl_DeviceTimeUpdate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u64SecondsSinceReferenceDate == roRef.u64SecondsSinceReferenceDate);
   bResult = bResult && (s16TimeZoneOffsetMinutes == roRef.s16TimeZoneOffsetMinutes);
   bResult = bResult && (s8DaylightSavingsOffsetMinutes == roRef.s8DaylightSavingsOffsetMinutes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_CdType::mplay_fi_tcl_e8_CdType():enType(FI_EN_MMGR_INIT) {}

tS32 mplay_fi_tcl_e8_CdType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_CDTYPE;
}


mplay_fi_tcl_e8_CdType::~mplay_fi_tcl_e8_CdType()
{}

tU32 mplay_fi_tcl_e8_CdType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_CdType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_CdType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MediaState::mplay_fi_tcl_e8_MediaState():enType(FI_EN_MMGR_MEDIA_NOT_READY) {}

tS32 mplay_fi_tcl_e8_MediaState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MEDIASTATE;
}


mplay_fi_tcl_e8_MediaState::~mplay_fi_tcl_e8_MediaState()
{}

tU32 mplay_fi_tcl_e8_MediaState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MediaState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MediaState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_InsertState::mplay_fi_tcl_e8_InsertState():enType(FI_EN_MMGR_INSERT_BEFOREON) {}

tS32 mplay_fi_tcl_e8_InsertState::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_INSERTSTATE;
}


mplay_fi_tcl_e8_InsertState::~mplay_fi_tcl_e8_InsertState()
{}

tU32 mplay_fi_tcl_e8_InsertState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_InsertState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_InsertState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_MMgr_MethodResult::mplay_fi_tcl_e8_MMgr_MethodResult():enType(FI_EN_MMGR_ACCEPTED) {}

tS32 mplay_fi_tcl_e8_MMgr_MethodResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_MMGR_METHODRESULT;
}


mplay_fi_tcl_e8_MMgr_MethodResult::~mplay_fi_tcl_e8_MMgr_MethodResult()
{}

tU32 mplay_fi_tcl_e8_MMgr_MethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_MMgr_MethodResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_MMgr_MethodResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8DriveTempSensorStatus::mplay_fi_tcl_e8DriveTempSensorStatus():enType(FI_EN_INIT) {}

tS32 mplay_fi_tcl_e8DriveTempSensorStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8DRIVETEMPSENSORSTATUS;
}


mplay_fi_tcl_e8DriveTempSensorStatus::~mplay_fi_tcl_e8DriveTempSensorStatus()
{}

tU32 mplay_fi_tcl_e8DriveTempSensorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8DriveTempSensorStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8DriveTempSensorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagDrv::mplay_fi_tcl_e16_DiagDrv():enType(FI_EN_MMGR_CD) {}

tS32 mplay_fi_tcl_e16_DiagDrv::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGDRV;
}


mplay_fi_tcl_e16_DiagDrv::~mplay_fi_tcl_e16_DiagDrv()
{}

tU32 mplay_fi_tcl_e16_DiagDrv::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagDrv::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagDrv::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagDrvTestCmd::mplay_fi_tcl_e16_DiagDrvTestCmd():enType(FI_EN_MMGR_START) {}

tS32 mplay_fi_tcl_e16_DiagDrvTestCmd::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGDRVTESTCMD;
}


mplay_fi_tcl_e16_DiagDrvTestCmd::~mplay_fi_tcl_e16_DiagDrvTestCmd()
{}

tU32 mplay_fi_tcl_e16_DiagDrvTestCmd::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagDrvTestCmd::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagDrvTestCmd::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagDrvTestParam::mplay_fi_tcl_e16_DiagDrvTestParam():enType(FI_EN_MMGR_SHORT) {}

tS32 mplay_fi_tcl_e16_DiagDrvTestParam::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGDRVTESTPARAM;
}


mplay_fi_tcl_e16_DiagDrvTestParam::~mplay_fi_tcl_e16_DiagDrvTestParam()
{}

tU32 mplay_fi_tcl_e16_DiagDrvTestParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagDrvTestParam::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagDrvTestParam::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagResultEject::mplay_fi_tcl_e16_DiagResultEject():enType(FI_EN_MMGR_EJECT_OK) {}

tS32 mplay_fi_tcl_e16_DiagResultEject::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGRESULTEJECT;
}


mplay_fi_tcl_e16_DiagResultEject::~mplay_fi_tcl_e16_DiagResultEject()
{}

tU32 mplay_fi_tcl_e16_DiagResultEject::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagResultEject::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagResultEject::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiagLoadStatus::mplay_fi_tcl_e8_DiagLoadStatus():enType(FI_EN_MMGR_MEDIA_IN_SLOT) {}

tS32 mplay_fi_tcl_e8_DiagLoadStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIAGLOADSTATUS;
}


mplay_fi_tcl_e8_DiagLoadStatus::~mplay_fi_tcl_e8_DiagLoadStatus()
{}

tU32 mplay_fi_tcl_e8_DiagLoadStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiagLoadStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiagLoadStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiagDuration::mplay_fi_tcl_e8_DiagDuration():enType(FI_EN_MMGR_CONTINUOUS) {}

tS32 mplay_fi_tcl_e8_DiagDuration::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIAGDURATION;
}


mplay_fi_tcl_e8_DiagDuration::~mplay_fi_tcl_e8_DiagDuration()
{}

tU32 mplay_fi_tcl_e8_DiagDuration::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e8_DiagDuration::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiagDuration::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiagRetValueDriveTest::mplay_fi_tcl_e8_DiagRetValueDriveTest():enType(FI_EN_MMGR_RESULT_FALSE) {}

tS32 mplay_fi_tcl_e8_DiagRetValueDriveTest::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIAGRETVALUEDRIVETEST;
}


mplay_fi_tcl_e8_DiagRetValueDriveTest::~mplay_fi_tcl_e8_DiagRetValueDriveTest()
{}

tU32 mplay_fi_tcl_e8_DiagRetValueDriveTest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e8_DiagRetValueDriveTest::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiagRetValueDriveTest::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagTroubleCode::mplay_fi_tcl_e16_DiagTroubleCode():enType(FI_EN_MMGR_TC_DEVICE_FAIL_CD) {}

tS32 mplay_fi_tcl_e16_DiagTroubleCode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGTROUBLECODE;
}


mplay_fi_tcl_e16_DiagTroubleCode::~mplay_fi_tcl_e16_DiagTroubleCode()
{}

tU32 mplay_fi_tcl_e16_DiagTroubleCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagTroubleCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagTroubleCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiagMonitoringMode::mplay_fi_tcl_e8_DiagMonitoringMode():enType(FI_EN_MMGR_OFF) {}

tS32 mplay_fi_tcl_e8_DiagMonitoringMode::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIAGMONITORINGMODE;
}


mplay_fi_tcl_e8_DiagMonitoringMode::~mplay_fi_tcl_e8_DiagMonitoringMode()
{}

tU32 mplay_fi_tcl_e8_DiagMonitoringMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiagMonitoringMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiagMonitoringMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiagSupervisionControl::mplay_fi_tcl_e8_DiagSupervisionControl():enType(FI_EN_MMGR_SUPERVISIONDEFAULT) {}

tS32 mplay_fi_tcl_e8_DiagSupervisionControl::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIAGSUPERVISIONCONTROL;
}


mplay_fi_tcl_e8_DiagSupervisionControl::~mplay_fi_tcl_e8_DiagSupervisionControl()
{}

tU32 mplay_fi_tcl_e8_DiagSupervisionControl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiagSupervisionControl::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiagSupervisionControl::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagErrorStatus::mplay_fi_tcl_e16_DiagErrorStatus():enType(FI_EN_MMGR_TESTPASSED) {}

tS32 mplay_fi_tcl_e16_DiagErrorStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGERRORSTATUS;
}


mplay_fi_tcl_e16_DiagErrorStatus::~mplay_fi_tcl_e16_DiagErrorStatus()
{}

tU32 mplay_fi_tcl_e16_DiagErrorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagErrorStatus::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagErrorStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagRoutineStatus::mplay_fi_tcl_e16_DiagRoutineStatus():enType(FI_EN_MMGR_ROUTINENOTRUNNING) {}

tS32 mplay_fi_tcl_e16_DiagRoutineStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGROUTINESTATUS;
}


mplay_fi_tcl_e16_DiagRoutineStatus::~mplay_fi_tcl_e16_DiagRoutineStatus()
{}

tU32 mplay_fi_tcl_e16_DiagRoutineStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagRoutineStatus::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagRoutineStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_TrackType::mplay_fi_tcl_e8_TrackType():enType(FI_EN_INIT) {}

tS32 mplay_fi_tcl_e8_TrackType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_TRACKTYPE;
}


mplay_fi_tcl_e8_TrackType::~mplay_fi_tcl_e8_TrackType()
{}

tU32 mplay_fi_tcl_e8_TrackType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_TrackType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_TrackType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_TrackTypeResult::mplay_fi_tcl_e8_TrackTypeResult():enType(FI_EN_OK) {}

tS32 mplay_fi_tcl_e8_TrackTypeResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_TRACKTYPERESULT;
}


mplay_fi_tcl_e8_TrackTypeResult::~mplay_fi_tcl_e8_TrackTypeResult()
{}

tU32 mplay_fi_tcl_e8_TrackTypeResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_TrackTypeResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_TrackTypeResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagDrvTestParameter::mplay_fi_tcl_DiagDrvTestParameter(const mplay_fi_tcl_DiagDrvTestParameter& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16Drive = coRef.e16Drive;
   e16DriveTestCmd = coRef.e16DriveTestCmd;
   e16DriveTestParam = coRef.e16DriveTestParam;
}
mplay_fi_tcl_DiagDrvTestParameter& mplay_fi_tcl_DiagDrvTestParameter::operator=(const mplay_fi_tcl_DiagDrvTestParameter& coRef)
{
   if (this == &coRef) return *this;
   e16Drive = coRef.e16Drive;
   e16DriveTestCmd = coRef.e16DriveTestCmd;
   e16DriveTestParam = coRef.e16DriveTestParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagDrvTestParameter::mplay_fi_tcl_DiagDrvTestParameter()
:e16Drive()
,e16DriveTestCmd()
,e16DriveTestParam()
 {}

tS32 mplay_fi_tcl_DiagDrvTestParameter::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGDRVTESTPARAMETER;
}


mplay_fi_tcl_DiagDrvTestParameter::~mplay_fi_tcl_DiagDrvTestParameter()
{}

tU32 mplay_fi_tcl_DiagDrvTestParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mplay_fi_tcl_DiagDrvTestParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Drive);
   (tVoid) (oIn >> e16DriveTestCmd);
   (tVoid) (oIn >> e16DriveTestParam);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagDrvTestParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Drive);
   (tVoid) (oOut << e16DriveTestCmd);
   (tVoid) (oOut << e16DriveTestParam);
   return oOut;
}

tBool mplay_fi_tcl_DiagDrvTestParameter::operator==(const mplay_fi_tcl_DiagDrvTestParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Drive == roRef.e16Drive);
   bResult = bResult && (e16DriveTestCmd == roRef.e16DriveTestCmd);
   bResult = bResult && (e16DriveTestParam == roRef.e16DriveTestParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagMethodResultDrvTest::mplay_fi_tcl_DiagMethodResultDrvTest(const mplay_fi_tcl_DiagMethodResultDrvTest& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e8RetValueDriveTest = coRef.e8RetValueDriveTest;
   e16DiagDrvTesttype = coRef.e16DiagDrvTesttype;
   e16Drive = coRef.e16Drive;
   u32SectorsRead = coRef.u32SectorsRead;
   u16ReadAttemps = coRef.u16ReadAttemps;
   u16CntErrors = coRef.u16CntErrors;
   u16AverageReadtimeSector = coRef.u16AverageReadtimeSector;
   u32TotalReadTime = coRef.u32TotalReadTime;
   u16MaxReadTimePerSector = coRef.u16MaxReadTimePerSector;
   u32MaxLBA = coRef.u32MaxLBA;
   u8CntDVDLayer = coRef.u8CntDVDLayer;
}
mplay_fi_tcl_DiagMethodResultDrvTest& mplay_fi_tcl_DiagMethodResultDrvTest::operator=(const mplay_fi_tcl_DiagMethodResultDrvTest& coRef)
{
   if (this == &coRef) return *this;
   e8RetValueDriveTest = coRef.e8RetValueDriveTest;
   e16DiagDrvTesttype = coRef.e16DiagDrvTesttype;
   e16Drive = coRef.e16Drive;
   u32SectorsRead = coRef.u32SectorsRead;
   u16ReadAttemps = coRef.u16ReadAttemps;
   u16CntErrors = coRef.u16CntErrors;
   u16AverageReadtimeSector = coRef.u16AverageReadtimeSector;
   u32TotalReadTime = coRef.u32TotalReadTime;
   u16MaxReadTimePerSector = coRef.u16MaxReadTimePerSector;
   u32MaxLBA = coRef.u32MaxLBA;
   u8CntDVDLayer = coRef.u8CntDVDLayer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagMethodResultDrvTest::mplay_fi_tcl_DiagMethodResultDrvTest()
:e8RetValueDriveTest()
,e16DiagDrvTesttype()
,e16Drive()
,u32SectorsRead(0)
,u16ReadAttemps(0)
,u16CntErrors(0)
,u16AverageReadtimeSector(0)
,u32TotalReadTime(0)
,u16MaxReadTimePerSector(0)
,u32MaxLBA(0)
,u8CntDVDLayer(0)
 {}

tS32 mplay_fi_tcl_DiagMethodResultDrvTest::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGMETHODRESULTDRVTEST;
}


mplay_fi_tcl_DiagMethodResultDrvTest::~mplay_fi_tcl_DiagMethodResultDrvTest()
{}

tU32 mplay_fi_tcl_DiagMethodResultDrvTest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 27;
}

fi_tclInContext& mplay_fi_tcl_DiagMethodResultDrvTest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8RetValueDriveTest);
   (tVoid) (oIn >> e16DiagDrvTesttype);
   (tVoid) (oIn >> e16Drive);
   (tVoid) (oIn >> u32SectorsRead);
   (tVoid) (oIn >> u16ReadAttemps);
   (tVoid) (oIn >> u16CntErrors);
   (tVoid) (oIn >> u16AverageReadtimeSector);
   (tVoid) (oIn >> u32TotalReadTime);
   (tVoid) (oIn >> u16MaxReadTimePerSector);
   (tVoid) (oIn >> u32MaxLBA);
   (tVoid) (oIn >> u8CntDVDLayer);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagMethodResultDrvTest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8RetValueDriveTest);
   (tVoid) (oOut << e16DiagDrvTesttype);
   (tVoid) (oOut << e16Drive);
   (tVoid) (oOut << u32SectorsRead);
   (tVoid) (oOut << u16ReadAttemps);
   (tVoid) (oOut << u16CntErrors);
   (tVoid) (oOut << u16AverageReadtimeSector);
   (tVoid) (oOut << u32TotalReadTime);
   (tVoid) (oOut << u16MaxReadTimePerSector);
   (tVoid) (oOut << u32MaxLBA);
   (tVoid) (oOut << u8CntDVDLayer);
   return oOut;
}

tBool mplay_fi_tcl_DiagMethodResultDrvTest::operator==(const mplay_fi_tcl_DiagMethodResultDrvTest& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8RetValueDriveTest == roRef.e8RetValueDriveTest);
   bResult = bResult && (e16DiagDrvTesttype == roRef.e16DiagDrvTesttype);
   bResult = bResult && (e16Drive == roRef.e16Drive);
   bResult = bResult && (u32SectorsRead == roRef.u32SectorsRead);
   bResult = bResult && (u16ReadAttemps == roRef.u16ReadAttemps);
   bResult = bResult && (u16CntErrors == roRef.u16CntErrors);
   bResult = bResult && (u16AverageReadtimeSector == roRef.u16AverageReadtimeSector);
   bResult = bResult && (u32TotalReadTime == roRef.u32TotalReadTime);
   bResult = bResult && (u16MaxReadTimePerSector == roRef.u16MaxReadTimePerSector);
   bResult = bResult && (u32MaxLBA == roRef.u32MaxLBA);
   bResult = bResult && (u8CntDVDLayer == roRef.u8CntDVDLayer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagEjectParam::mplay_fi_tcl_DiagEjectParam(const mplay_fi_tcl_DiagEjectParam& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16Drive = coRef.e16Drive;
}
mplay_fi_tcl_DiagEjectParam& mplay_fi_tcl_DiagEjectParam::operator=(const mplay_fi_tcl_DiagEjectParam& coRef)
{
   if (this == &coRef) return *this;
   e16Drive = coRef.e16Drive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagEjectParam::mplay_fi_tcl_DiagEjectParam()
:e16Drive()
 {}

tS32 mplay_fi_tcl_DiagEjectParam::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGEJECTPARAM;
}


mplay_fi_tcl_DiagEjectParam::~mplay_fi_tcl_DiagEjectParam()
{}

tU32 mplay_fi_tcl_DiagEjectParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_DiagEjectParam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Drive);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagEjectParam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Drive);
   return oOut;
}

tBool mplay_fi_tcl_DiagEjectParam::operator==(const mplay_fi_tcl_DiagEjectParam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Drive == roRef.e16Drive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagMethodResultEject::mplay_fi_tcl_DiagMethodResultEject(const mplay_fi_tcl_DiagMethodResultEject& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16Result = coRef.e16Result;
}
mplay_fi_tcl_DiagMethodResultEject& mplay_fi_tcl_DiagMethodResultEject::operator=(const mplay_fi_tcl_DiagMethodResultEject& coRef)
{
   if (this == &coRef) return *this;
   e16Result = coRef.e16Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagMethodResultEject::mplay_fi_tcl_DiagMethodResultEject()
:e16Result()
 {}

tS32 mplay_fi_tcl_DiagMethodResultEject::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGMETHODRESULTEJECT;
}


mplay_fi_tcl_DiagMethodResultEject::~mplay_fi_tcl_DiagMethodResultEject()
{}

tU32 mplay_fi_tcl_DiagMethodResultEject::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_DiagMethodResultEject::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Result);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagMethodResultEject::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Result);
   return oOut;
}

tBool mplay_fi_tcl_DiagMethodResultEject::operator==(const mplay_fi_tcl_DiagMethodResultEject& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Result == roRef.e16Result);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagFirmwareVersion::mplay_fi_tcl_DiagFirmwareVersion(const mplay_fi_tcl_DiagFirmwareVersion& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u8FirmwareVersion00 = coRef.u8FirmwareVersion00;
   u8FirmwareVersion01 = coRef.u8FirmwareVersion01;
   u8FirmwareVersion02 = coRef.u8FirmwareVersion02;
   u8FirmwareVersion03 = coRef.u8FirmwareVersion03;
   u8FirmwareVersion04 = coRef.u8FirmwareVersion04;
   u8FirmwareVersion05 = coRef.u8FirmwareVersion05;
   u8FirmwareVersion06 = coRef.u8FirmwareVersion06;
   u8FirmwareVersion07 = coRef.u8FirmwareVersion07;
}
mplay_fi_tcl_DiagFirmwareVersion& mplay_fi_tcl_DiagFirmwareVersion::operator=(const mplay_fi_tcl_DiagFirmwareVersion& coRef)
{
   if (this == &coRef) return *this;
   u8FirmwareVersion00 = coRef.u8FirmwareVersion00;
   u8FirmwareVersion01 = coRef.u8FirmwareVersion01;
   u8FirmwareVersion02 = coRef.u8FirmwareVersion02;
   u8FirmwareVersion03 = coRef.u8FirmwareVersion03;
   u8FirmwareVersion04 = coRef.u8FirmwareVersion04;
   u8FirmwareVersion05 = coRef.u8FirmwareVersion05;
   u8FirmwareVersion06 = coRef.u8FirmwareVersion06;
   u8FirmwareVersion07 = coRef.u8FirmwareVersion07;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagFirmwareVersion::mplay_fi_tcl_DiagFirmwareVersion()
:u8FirmwareVersion00(0)
,u8FirmwareVersion01(0)
,u8FirmwareVersion02(0)
,u8FirmwareVersion03(0)
,u8FirmwareVersion04(0)
,u8FirmwareVersion05(0)
,u8FirmwareVersion06(0)
,u8FirmwareVersion07(0)
 {}

tS32 mplay_fi_tcl_DiagFirmwareVersion::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGFIRMWAREVERSION;
}


mplay_fi_tcl_DiagFirmwareVersion::~mplay_fi_tcl_DiagFirmwareVersion()
{}

tU32 mplay_fi_tcl_DiagFirmwareVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_fi_tcl_DiagFirmwareVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8FirmwareVersion00);
   (tVoid) (oIn >> u8FirmwareVersion01);
   (tVoid) (oIn >> u8FirmwareVersion02);
   (tVoid) (oIn >> u8FirmwareVersion03);
   (tVoid) (oIn >> u8FirmwareVersion04);
   (tVoid) (oIn >> u8FirmwareVersion05);
   (tVoid) (oIn >> u8FirmwareVersion06);
   (tVoid) (oIn >> u8FirmwareVersion07);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagFirmwareVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8FirmwareVersion00);
   (tVoid) (oOut << u8FirmwareVersion01);
   (tVoid) (oOut << u8FirmwareVersion02);
   (tVoid) (oOut << u8FirmwareVersion03);
   (tVoid) (oOut << u8FirmwareVersion04);
   (tVoid) (oOut << u8FirmwareVersion05);
   (tVoid) (oOut << u8FirmwareVersion06);
   (tVoid) (oOut << u8FirmwareVersion07);
   return oOut;
}

tBool mplay_fi_tcl_DiagFirmwareVersion::operator==(const mplay_fi_tcl_DiagFirmwareVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8FirmwareVersion00 == roRef.u8FirmwareVersion00);
   bResult = bResult && (u8FirmwareVersion01 == roRef.u8FirmwareVersion01);
   bResult = bResult && (u8FirmwareVersion02 == roRef.u8FirmwareVersion02);
   bResult = bResult && (u8FirmwareVersion03 == roRef.u8FirmwareVersion03);
   bResult = bResult && (u8FirmwareVersion04 == roRef.u8FirmwareVersion04);
   bResult = bResult && (u8FirmwareVersion05 == roRef.u8FirmwareVersion05);
   bResult = bResult && (u8FirmwareVersion06 == roRef.u8FirmwareVersion06);
   bResult = bResult && (u8FirmwareVersion07 == roRef.u8FirmwareVersion07);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagDriveVersion::mplay_fi_tcl_DiagDriveVersion(const mplay_fi_tcl_DiagDriveVersion& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   u8DriveVersion00 = coRef.u8DriveVersion00;
   u8DriveVersion01 = coRef.u8DriveVersion01;
   u8DriveVersion02 = coRef.u8DriveVersion02;
   u8DriveVersion03 = coRef.u8DriveVersion03;
   u8DriveVersion04 = coRef.u8DriveVersion04;
   u8DriveVersion05 = coRef.u8DriveVersion05;
   u8DriveVersion06 = coRef.u8DriveVersion06;
   u8DriveVersion07 = coRef.u8DriveVersion07;
   u8DriveVersion08 = coRef.u8DriveVersion08;
   u8DriveVersion09 = coRef.u8DriveVersion09;
   u8DriveVersion10 = coRef.u8DriveVersion10;
   u8DriveVersion11 = coRef.u8DriveVersion11;
   u8DriveVersion12 = coRef.u8DriveVersion12;
   u8DriveVersion13 = coRef.u8DriveVersion13;
   u8DriveVersion14 = coRef.u8DriveVersion14;
   u8DriveVersion15 = coRef.u8DriveVersion15;
   u8DriveVersion16 = coRef.u8DriveVersion16;
   u8DriveVersion17 = coRef.u8DriveVersion17;
   u8DriveVersion18 = coRef.u8DriveVersion18;
   u8DriveVersion19 = coRef.u8DriveVersion19;
   u8DriveVersion20 = coRef.u8DriveVersion20;
   u8DriveVersion21 = coRef.u8DriveVersion21;
   u8DriveVersion22 = coRef.u8DriveVersion22;
   u8DriveVersion23 = coRef.u8DriveVersion23;
   u8DriveVersion24 = coRef.u8DriveVersion24;
   u8DriveVersion25 = coRef.u8DriveVersion25;
   u8DriveVersion26 = coRef.u8DriveVersion26;
   u8DriveVersion27 = coRef.u8DriveVersion27;
   u8DriveVersion28 = coRef.u8DriveVersion28;
   u8DriveVersion29 = coRef.u8DriveVersion29;
   u8DriveVersion30 = coRef.u8DriveVersion30;
   u8DriveVersion31 = coRef.u8DriveVersion31;
   u8DriveVersion32 = coRef.u8DriveVersion32;
   u8DriveVersion33 = coRef.u8DriveVersion33;
   u8DriveVersion34 = coRef.u8DriveVersion34;
   u8DriveVersion35 = coRef.u8DriveVersion35;
   u8DriveVersion36 = coRef.u8DriveVersion36;
   u8DriveVersion37 = coRef.u8DriveVersion37;
   u8DriveVersion38 = coRef.u8DriveVersion38;
   u8DriveVersion39 = coRef.u8DriveVersion39;
}
mplay_fi_tcl_DiagDriveVersion& mplay_fi_tcl_DiagDriveVersion::operator=(const mplay_fi_tcl_DiagDriveVersion& coRef)
{
   if (this == &coRef) return *this;
   u8DriveVersion00 = coRef.u8DriveVersion00;
   u8DriveVersion01 = coRef.u8DriveVersion01;
   u8DriveVersion02 = coRef.u8DriveVersion02;
   u8DriveVersion03 = coRef.u8DriveVersion03;
   u8DriveVersion04 = coRef.u8DriveVersion04;
   u8DriveVersion05 = coRef.u8DriveVersion05;
   u8DriveVersion06 = coRef.u8DriveVersion06;
   u8DriveVersion07 = coRef.u8DriveVersion07;
   u8DriveVersion08 = coRef.u8DriveVersion08;
   u8DriveVersion09 = coRef.u8DriveVersion09;
   u8DriveVersion10 = coRef.u8DriveVersion10;
   u8DriveVersion11 = coRef.u8DriveVersion11;
   u8DriveVersion12 = coRef.u8DriveVersion12;
   u8DriveVersion13 = coRef.u8DriveVersion13;
   u8DriveVersion14 = coRef.u8DriveVersion14;
   u8DriveVersion15 = coRef.u8DriveVersion15;
   u8DriveVersion16 = coRef.u8DriveVersion16;
   u8DriveVersion17 = coRef.u8DriveVersion17;
   u8DriveVersion18 = coRef.u8DriveVersion18;
   u8DriveVersion19 = coRef.u8DriveVersion19;
   u8DriveVersion20 = coRef.u8DriveVersion20;
   u8DriveVersion21 = coRef.u8DriveVersion21;
   u8DriveVersion22 = coRef.u8DriveVersion22;
   u8DriveVersion23 = coRef.u8DriveVersion23;
   u8DriveVersion24 = coRef.u8DriveVersion24;
   u8DriveVersion25 = coRef.u8DriveVersion25;
   u8DriveVersion26 = coRef.u8DriveVersion26;
   u8DriveVersion27 = coRef.u8DriveVersion27;
   u8DriveVersion28 = coRef.u8DriveVersion28;
   u8DriveVersion29 = coRef.u8DriveVersion29;
   u8DriveVersion30 = coRef.u8DriveVersion30;
   u8DriveVersion31 = coRef.u8DriveVersion31;
   u8DriveVersion32 = coRef.u8DriveVersion32;
   u8DriveVersion33 = coRef.u8DriveVersion33;
   u8DriveVersion34 = coRef.u8DriveVersion34;
   u8DriveVersion35 = coRef.u8DriveVersion35;
   u8DriveVersion36 = coRef.u8DriveVersion36;
   u8DriveVersion37 = coRef.u8DriveVersion37;
   u8DriveVersion38 = coRef.u8DriveVersion38;
   u8DriveVersion39 = coRef.u8DriveVersion39;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagDriveVersion::mplay_fi_tcl_DiagDriveVersion()
:u8DriveVersion00(0)
,u8DriveVersion01(0)
,u8DriveVersion02(0)
,u8DriveVersion03(0)
,u8DriveVersion04(0)
,u8DriveVersion05(0)
,u8DriveVersion06(0)
,u8DriveVersion07(0)
,u8DriveVersion08(0)
,u8DriveVersion09(0)
,u8DriveVersion10(0)
,u8DriveVersion11(0)
,u8DriveVersion12(0)
,u8DriveVersion13(0)
,u8DriveVersion14(0)
,u8DriveVersion15(0)
,u8DriveVersion16(0)
,u8DriveVersion17(0)
,u8DriveVersion18(0)
,u8DriveVersion19(0)
,u8DriveVersion20(0)
,u8DriveVersion21(0)
,u8DriveVersion22(0)
,u8DriveVersion23(0)
,u8DriveVersion24(0)
,u8DriveVersion25(0)
,u8DriveVersion26(0)
,u8DriveVersion27(0)
,u8DriveVersion28(0)
,u8DriveVersion29(0)
,u8DriveVersion30(0)
,u8DriveVersion31(0)
,u8DriveVersion32(0)
,u8DriveVersion33(0)
,u8DriveVersion34(0)
,u8DriveVersion35(0)
,u8DriveVersion36(0)
,u8DriveVersion37(0)
,u8DriveVersion38(0)
,u8DriveVersion39(0)
 {}

tS32 mplay_fi_tcl_DiagDriveVersion::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGDRIVEVERSION;
}


mplay_fi_tcl_DiagDriveVersion::~mplay_fi_tcl_DiagDriveVersion()
{}

tU32 mplay_fi_tcl_DiagDriveVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 40;
}

fi_tclInContext& mplay_fi_tcl_DiagDriveVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DriveVersion00);
   (tVoid) (oIn >> u8DriveVersion01);
   (tVoid) (oIn >> u8DriveVersion02);
   (tVoid) (oIn >> u8DriveVersion03);
   (tVoid) (oIn >> u8DriveVersion04);
   (tVoid) (oIn >> u8DriveVersion05);
   (tVoid) (oIn >> u8DriveVersion06);
   (tVoid) (oIn >> u8DriveVersion07);
   (tVoid) (oIn >> u8DriveVersion08);
   (tVoid) (oIn >> u8DriveVersion09);
   (tVoid) (oIn >> u8DriveVersion10);
   (tVoid) (oIn >> u8DriveVersion11);
   (tVoid) (oIn >> u8DriveVersion12);
   (tVoid) (oIn >> u8DriveVersion13);
   (tVoid) (oIn >> u8DriveVersion14);
   (tVoid) (oIn >> u8DriveVersion15);
   (tVoid) (oIn >> u8DriveVersion16);
   (tVoid) (oIn >> u8DriveVersion17);
   (tVoid) (oIn >> u8DriveVersion18);
   (tVoid) (oIn >> u8DriveVersion19);
   (tVoid) (oIn >> u8DriveVersion20);
   (tVoid) (oIn >> u8DriveVersion21);
   (tVoid) (oIn >> u8DriveVersion22);
   (tVoid) (oIn >> u8DriveVersion23);
   (tVoid) (oIn >> u8DriveVersion24);
   (tVoid) (oIn >> u8DriveVersion25);
   (tVoid) (oIn >> u8DriveVersion26);
   (tVoid) (oIn >> u8DriveVersion27);
   (tVoid) (oIn >> u8DriveVersion28);
   (tVoid) (oIn >> u8DriveVersion29);
   (tVoid) (oIn >> u8DriveVersion30);
   (tVoid) (oIn >> u8DriveVersion31);
   (tVoid) (oIn >> u8DriveVersion32);
   (tVoid) (oIn >> u8DriveVersion33);
   (tVoid) (oIn >> u8DriveVersion34);
   (tVoid) (oIn >> u8DriveVersion35);
   (tVoid) (oIn >> u8DriveVersion36);
   (tVoid) (oIn >> u8DriveVersion37);
   (tVoid) (oIn >> u8DriveVersion38);
   (tVoid) (oIn >> u8DriveVersion39);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagDriveVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DriveVersion00);
   (tVoid) (oOut << u8DriveVersion01);
   (tVoid) (oOut << u8DriveVersion02);
   (tVoid) (oOut << u8DriveVersion03);
   (tVoid) (oOut << u8DriveVersion04);
   (tVoid) (oOut << u8DriveVersion05);
   (tVoid) (oOut << u8DriveVersion06);
   (tVoid) (oOut << u8DriveVersion07);
   (tVoid) (oOut << u8DriveVersion08);
   (tVoid) (oOut << u8DriveVersion09);
   (tVoid) (oOut << u8DriveVersion10);
   (tVoid) (oOut << u8DriveVersion11);
   (tVoid) (oOut << u8DriveVersion12);
   (tVoid) (oOut << u8DriveVersion13);
   (tVoid) (oOut << u8DriveVersion14);
   (tVoid) (oOut << u8DriveVersion15);
   (tVoid) (oOut << u8DriveVersion16);
   (tVoid) (oOut << u8DriveVersion17);
   (tVoid) (oOut << u8DriveVersion18);
   (tVoid) (oOut << u8DriveVersion19);
   (tVoid) (oOut << u8DriveVersion20);
   (tVoid) (oOut << u8DriveVersion21);
   (tVoid) (oOut << u8DriveVersion22);
   (tVoid) (oOut << u8DriveVersion23);
   (tVoid) (oOut << u8DriveVersion24);
   (tVoid) (oOut << u8DriveVersion25);
   (tVoid) (oOut << u8DriveVersion26);
   (tVoid) (oOut << u8DriveVersion27);
   (tVoid) (oOut << u8DriveVersion28);
   (tVoid) (oOut << u8DriveVersion29);
   (tVoid) (oOut << u8DriveVersion30);
   (tVoid) (oOut << u8DriveVersion31);
   (tVoid) (oOut << u8DriveVersion32);
   (tVoid) (oOut << u8DriveVersion33);
   (tVoid) (oOut << u8DriveVersion34);
   (tVoid) (oOut << u8DriveVersion35);
   (tVoid) (oOut << u8DriveVersion36);
   (tVoid) (oOut << u8DriveVersion37);
   (tVoid) (oOut << u8DriveVersion38);
   (tVoid) (oOut << u8DriveVersion39);
   return oOut;
}

tBool mplay_fi_tcl_DiagDriveVersion::operator==(const mplay_fi_tcl_DiagDriveVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DriveVersion00 == roRef.u8DriveVersion00);
   bResult = bResult && (u8DriveVersion01 == roRef.u8DriveVersion01);
   bResult = bResult && (u8DriveVersion02 == roRef.u8DriveVersion02);
   bResult = bResult && (u8DriveVersion03 == roRef.u8DriveVersion03);
   bResult = bResult && (u8DriveVersion04 == roRef.u8DriveVersion04);
   bResult = bResult && (u8DriveVersion05 == roRef.u8DriveVersion05);
   bResult = bResult && (u8DriveVersion06 == roRef.u8DriveVersion06);
   bResult = bResult && (u8DriveVersion07 == roRef.u8DriveVersion07);
   bResult = bResult && (u8DriveVersion08 == roRef.u8DriveVersion08);
   bResult = bResult && (u8DriveVersion09 == roRef.u8DriveVersion09);
   bResult = bResult && (u8DriveVersion10 == roRef.u8DriveVersion10);
   bResult = bResult && (u8DriveVersion11 == roRef.u8DriveVersion11);
   bResult = bResult && (u8DriveVersion12 == roRef.u8DriveVersion12);
   bResult = bResult && (u8DriveVersion13 == roRef.u8DriveVersion13);
   bResult = bResult && (u8DriveVersion14 == roRef.u8DriveVersion14);
   bResult = bResult && (u8DriveVersion15 == roRef.u8DriveVersion15);
   bResult = bResult && (u8DriveVersion16 == roRef.u8DriveVersion16);
   bResult = bResult && (u8DriveVersion17 == roRef.u8DriveVersion17);
   bResult = bResult && (u8DriveVersion18 == roRef.u8DriveVersion18);
   bResult = bResult && (u8DriveVersion19 == roRef.u8DriveVersion19);
   bResult = bResult && (u8DriveVersion20 == roRef.u8DriveVersion20);
   bResult = bResult && (u8DriveVersion21 == roRef.u8DriveVersion21);
   bResult = bResult && (u8DriveVersion22 == roRef.u8DriveVersion22);
   bResult = bResult && (u8DriveVersion23 == roRef.u8DriveVersion23);
   bResult = bResult && (u8DriveVersion24 == roRef.u8DriveVersion24);
   bResult = bResult && (u8DriveVersion25 == roRef.u8DriveVersion25);
   bResult = bResult && (u8DriveVersion26 == roRef.u8DriveVersion26);
   bResult = bResult && (u8DriveVersion27 == roRef.u8DriveVersion27);
   bResult = bResult && (u8DriveVersion28 == roRef.u8DriveVersion28);
   bResult = bResult && (u8DriveVersion29 == roRef.u8DriveVersion29);
   bResult = bResult && (u8DriveVersion30 == roRef.u8DriveVersion30);
   bResult = bResult && (u8DriveVersion31 == roRef.u8DriveVersion31);
   bResult = bResult && (u8DriveVersion32 == roRef.u8DriveVersion32);
   bResult = bResult && (u8DriveVersion33 == roRef.u8DriveVersion33);
   bResult = bResult && (u8DriveVersion34 == roRef.u8DriveVersion34);
   bResult = bResult && (u8DriveVersion35 == roRef.u8DriveVersion35);
   bResult = bResult && (u8DriveVersion36 == roRef.u8DriveVersion36);
   bResult = bResult && (u8DriveVersion37 == roRef.u8DriveVersion37);
   bResult = bResult && (u8DriveVersion38 == roRef.u8DriveVersion38);
   bResult = bResult && (u8DriveVersion39 == roRef.u8DriveVersion39);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagTestRoutineParameter::mplay_fi_tcl_DiagTestRoutineParameter(const mplay_fi_tcl_DiagTestRoutineParameter& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16TroubleCode = coRef.e16TroubleCode;
   bWriteToRM = coRef.bWriteToRM;
   e8MonitoringMode = coRef.e8MonitoringMode;
   e8SupervisionControl = coRef.e8SupervisionControl;
}
mplay_fi_tcl_DiagTestRoutineParameter& mplay_fi_tcl_DiagTestRoutineParameter::operator=(const mplay_fi_tcl_DiagTestRoutineParameter& coRef)
{
   if (this == &coRef) return *this;
   e16TroubleCode = coRef.e16TroubleCode;
   bWriteToRM = coRef.bWriteToRM;
   e8MonitoringMode = coRef.e8MonitoringMode;
   e8SupervisionControl = coRef.e8SupervisionControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagTestRoutineParameter::mplay_fi_tcl_DiagTestRoutineParameter()
:e16TroubleCode()
,bWriteToRM(0)
,e8MonitoringMode()
,e8SupervisionControl()
 {}

tS32 mplay_fi_tcl_DiagTestRoutineParameter::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGTESTROUTINEPARAMETER;
}


mplay_fi_tcl_DiagTestRoutineParameter::~mplay_fi_tcl_DiagTestRoutineParameter()
{}

tU32 mplay_fi_tcl_DiagTestRoutineParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& mplay_fi_tcl_DiagTestRoutineParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16TroubleCode);
   (tVoid) (oIn >> bWriteToRM);
   (tVoid) (oIn >> e8MonitoringMode);
   (tVoid) (oIn >> e8SupervisionControl);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagTestRoutineParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16TroubleCode);
   (tVoid) (oOut << bWriteToRM);
   (tVoid) (oOut << e8MonitoringMode);
   (tVoid) (oOut << e8SupervisionControl);
   return oOut;
}

tBool mplay_fi_tcl_DiagTestRoutineParameter::operator==(const mplay_fi_tcl_DiagTestRoutineParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16TroubleCode == roRef.e16TroubleCode);
   bResult = bResult && (bWriteToRM == roRef.bWriteToRM);
   bResult = bResult && (e8MonitoringMode == roRef.e8MonitoringMode);
   bResult = bResult && (e8SupervisionControl == roRef.e8SupervisionControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagTestRoutineList::mplay_fi_tcl_DiagTestRoutineList(const mplay_fi_tcl_DiagTestRoutineList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   TestRoutineParameterList = coRef.TestRoutineParameterList;
}
mplay_fi_tcl_DiagTestRoutineList& mplay_fi_tcl_DiagTestRoutineList::operator=(const mplay_fi_tcl_DiagTestRoutineList& coRef)
{
   if (this == &coRef) return *this;
   TestRoutineParameterList = coRef.TestRoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiagTestRoutineList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         TestRoutineParameterList[u32Idx].vDestroy();
   TestRoutineParameterList.clear();
   }
}

mplay_fi_tcl_DiagTestRoutineList::mplay_fi_tcl_DiagTestRoutineList()

 {}

tS32 mplay_fi_tcl_DiagTestRoutineList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGTESTROUTINELIST;
}


mplay_fi_tcl_DiagTestRoutineList::~mplay_fi_tcl_DiagTestRoutineList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiagTestRoutineList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TestRoutineParameterList.size()*5);
}

fi_tclInContext& mplay_fi_tcl_DiagTestRoutineList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
      {
         TestRoutineParameterList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TestRoutineParameterList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TestRoutineParameterList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagTestRoutineList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TestRoutineParameterList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TestRoutineParameterList.size(); ++u32Idx)
         (tVoid) (oOut << TestRoutineParameterList[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DiagTestRoutineList::operator==(const mplay_fi_tcl_DiagTestRoutineList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TestRoutineParameterList.size() == roRef.TestRoutineParameterList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TestRoutineParameterList.size()); ++u32Idx)
            bResult = bResult && (TestRoutineParameterList[u32Idx] == roRef.TestRoutineParameterList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagTroubleCodeList::mplay_fi_tcl_DiagTroubleCodeList(const mplay_fi_tcl_DiagTroubleCodeList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16TroubleCodeList = coRef.e16TroubleCodeList;
}
mplay_fi_tcl_DiagTroubleCodeList& mplay_fi_tcl_DiagTroubleCodeList::operator=(const mplay_fi_tcl_DiagTroubleCodeList& coRef)
{
   if (this == &coRef) return *this;
   e16TroubleCodeList = coRef.e16TroubleCodeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiagTroubleCodeList::vDestroy()
{
   {
   e16TroubleCodeList.clear();
   }
}

mplay_fi_tcl_DiagTroubleCodeList::mplay_fi_tcl_DiagTroubleCodeList()

 {}

tS32 mplay_fi_tcl_DiagTroubleCodeList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGTROUBLECODELIST;
}


mplay_fi_tcl_DiagTroubleCodeList::~mplay_fi_tcl_DiagTroubleCodeList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiagTroubleCodeList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(e16TroubleCodeList.size()*2);
}

fi_tclInContext& mplay_fi_tcl_DiagTroubleCodeList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      e16TroubleCodeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> e16TroubleCodeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagTroubleCodeList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)e16TroubleCodeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < e16TroubleCodeList.size(); ++u32Idx)
         (tVoid) (oOut << e16TroubleCodeList[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DiagTroubleCodeList::operator==(const mplay_fi_tcl_DiagTroubleCodeList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (e16TroubleCodeList.size() == roRef.e16TroubleCodeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < e16TroubleCodeList.size()); ++u32Idx)
            bResult = bResult && (e16TroubleCodeList[u32Idx] == roRef.e16TroubleCodeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagTroubleStatus::mplay_fi_tcl_DiagTroubleStatus(const mplay_fi_tcl_DiagTroubleStatus& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16TroubleCode = coRef.e16TroubleCode;
   e16ErrorStatus = coRef.e16ErrorStatus;
   e16RoutineStatus = coRef.e16RoutineStatus;
}
mplay_fi_tcl_DiagTroubleStatus& mplay_fi_tcl_DiagTroubleStatus::operator=(const mplay_fi_tcl_DiagTroubleStatus& coRef)
{
   if (this == &coRef) return *this;
   e16TroubleCode = coRef.e16TroubleCode;
   e16ErrorStatus = coRef.e16ErrorStatus;
   e16RoutineStatus = coRef.e16RoutineStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagTroubleStatus::mplay_fi_tcl_DiagTroubleStatus()
:e16TroubleCode()
,e16ErrorStatus()
,e16RoutineStatus()
 {}

tS32 mplay_fi_tcl_DiagTroubleStatus::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGTROUBLESTATUS;
}


mplay_fi_tcl_DiagTroubleStatus::~mplay_fi_tcl_DiagTroubleStatus()
{}

tU32 mplay_fi_tcl_DiagTroubleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& mplay_fi_tcl_DiagTroubleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16TroubleCode);
   (tVoid) (oIn >> e16ErrorStatus);
   (tVoid) (oIn >> e16RoutineStatus);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagTroubleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16TroubleCode);
   (tVoid) (oOut << e16ErrorStatus);
   (tVoid) (oOut << e16RoutineStatus);
   return oOut;
}

tBool mplay_fi_tcl_DiagTroubleStatus::operator==(const mplay_fi_tcl_DiagTroubleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16TroubleCode == roRef.e16TroubleCode);
   bResult = bResult && (e16ErrorStatus == roRef.e16ErrorStatus);
   bResult = bResult && (e16RoutineStatus == roRef.e16RoutineStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagTroubleCodeStatusList::mplay_fi_tcl_DiagTroubleCodeStatusList(const mplay_fi_tcl_DiagTroubleCodeStatusList& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
}
mplay_fi_tcl_DiagTroubleCodeStatusList& mplay_fi_tcl_DiagTroubleCodeStatusList::operator=(const mplay_fi_tcl_DiagTroubleCodeStatusList& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_fi_tcl_DiagTroubleCodeStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
         TroubleCodeStatusList[u32Idx].vDestroy();
   TroubleCodeStatusList.clear();
   }
}

mplay_fi_tcl_DiagTroubleCodeStatusList::mplay_fi_tcl_DiagTroubleCodeStatusList()

 {}

tS32 mplay_fi_tcl_DiagTroubleCodeStatusList::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGTROUBLECODESTATUSLIST;
}


mplay_fi_tcl_DiagTroubleCodeStatusList::~mplay_fi_tcl_DiagTroubleCodeStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_fi_tcl_DiagTroubleCodeStatusList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TroubleCodeStatusList.size()*6);
}

fi_tclInContext& mplay_fi_tcl_DiagTroubleCodeStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
      {
         TroubleCodeStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TroubleCodeStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TroubleCodeStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagTroubleCodeStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TroubleCodeStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeStatusList.size(); ++u32Idx)
         (tVoid) (oOut << TroubleCodeStatusList[u32Idx]);
   }
   return oOut;
}

tBool mplay_fi_tcl_DiagTroubleCodeStatusList::operator==(const mplay_fi_tcl_DiagTroubleCodeStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TroubleCodeStatusList.size() == roRef.TroubleCodeStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TroubleCodeStatusList.size()); ++u32Idx)
            bResult = bResult && (TroubleCodeStatusList[u32Idx] == roRef.TroubleCodeStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e8_DiagnosisTestType::mplay_fi_tcl_e8_DiagnosisTestType():enType(FI_EN_MMGR_CUSTOMER_DIAGNOSIS) {}

tS32 mplay_fi_tcl_e8_DiagnosisTestType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E8_DIAGNOSISTESTTYPE;
}


mplay_fi_tcl_e8_DiagnosisTestType::~mplay_fi_tcl_e8_DiagnosisTestType()
{}

tU32 mplay_fi_tcl_e8_DiagnosisTestType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e8_DiagnosisTestType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e8_DiagnosisTestType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DiagTestType::mplay_fi_tcl_e16_DiagTestType():enType(FI_EN_MMGR_DIAGNOSIS_ON_DEMAND) {}

tS32 mplay_fi_tcl_e16_DiagTestType::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DIAGTESTTYPE;
}


mplay_fi_tcl_e16_DiagTestType::~mplay_fi_tcl_e16_DiagTestType()
{}

tU32 mplay_fi_tcl_e16_DiagTestType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_fi_tcl_e16_DiagTestType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DiagTestType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DiagReadDevInterfaceTestParam::mplay_fi_tcl_DiagReadDevInterfaceTestParam(const mplay_fi_tcl_DiagReadDevInterfaceTestParam& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16Drive = coRef.e16Drive;
   DiagnosisTestInitiator = coRef.DiagnosisTestInitiator;
   TestType = coRef.TestType;
}
mplay_fi_tcl_DiagReadDevInterfaceTestParam& mplay_fi_tcl_DiagReadDevInterfaceTestParam::operator=(const mplay_fi_tcl_DiagReadDevInterfaceTestParam& coRef)
{
   if (this == &coRef) return *this;
   e16Drive = coRef.e16Drive;
   DiagnosisTestInitiator = coRef.DiagnosisTestInitiator;
   TestType = coRef.TestType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagReadDevInterfaceTestParam::mplay_fi_tcl_DiagReadDevInterfaceTestParam()
:e16Drive()
,DiagnosisTestInitiator()
,TestType()
 {}

tS32 mplay_fi_tcl_DiagReadDevInterfaceTestParam::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGREADDEVINTERFACETESTPARAM;
}


mplay_fi_tcl_DiagReadDevInterfaceTestParam::~mplay_fi_tcl_DiagReadDevInterfaceTestParam()
{}

tU32 mplay_fi_tcl_DiagReadDevInterfaceTestParam::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_fi_tcl_DiagReadDevInterfaceTestParam::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Drive);
   (tVoid) (oIn >> DiagnosisTestInitiator);
   (tVoid) (oIn >> TestType);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagReadDevInterfaceTestParam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Drive);
   (tVoid) (oOut << DiagnosisTestInitiator);
   (tVoid) (oOut << TestType);
   return oOut;
}

tBool mplay_fi_tcl_DiagReadDevInterfaceTestParam::operator==(const mplay_fi_tcl_DiagReadDevInterfaceTestParam& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Drive == roRef.e16Drive);
   bResult = bResult && (DiagnosisTestInitiator == roRef.DiagnosisTestInitiator);
   bResult = bResult && (TestType == roRef.TestType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DiagTestResult::mplay_fi_tcl_DiagTestResult():enType(FI_EN_TEST_PASSED) {}

tS32 mplay_fi_tcl_DiagTestResult::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DIAGTESTRESULT;
}


mplay_fi_tcl_DiagTestResult::~mplay_fi_tcl_DiagTestResult()
{}

tU32 mplay_fi_tcl_DiagTestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_DiagTestResult::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DiagTestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_e16_DriveErrorValue::mplay_fi_tcl_e16_DriveErrorValue():enType(FI_EN_DEFECT_NO_ERROR) {}

tS32 mplay_fi_tcl_e16_DriveErrorValue::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_E16_DRIVEERRORVALUE;
}


mplay_fi_tcl_e16_DriveErrorValue::~mplay_fi_tcl_e16_DriveErrorValue()
{}

tU32 mplay_fi_tcl_e16_DriveErrorValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_fi_tcl_e16_DriveErrorValue::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_e16_DriveErrorValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_fi_tcl_DriveErrorInfo::mplay_fi_tcl_DriveErrorInfo(const mplay_fi_tcl_DriveErrorInfo& coRef)
   : mplay_fi_tclVisitableTypeBase(coRef)
{
   e16Drive = coRef.e16Drive;
   e16ErrorValue = coRef.e16ErrorValue;
}
mplay_fi_tcl_DriveErrorInfo& mplay_fi_tcl_DriveErrorInfo::operator=(const mplay_fi_tcl_DriveErrorInfo& coRef)
{
   if (this == &coRef) return *this;
   e16Drive = coRef.e16Drive;
   e16ErrorValue = coRef.e16ErrorValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_fi_tcl_DriveErrorInfo::mplay_fi_tcl_DriveErrorInfo()
:e16Drive()
,e16ErrorValue()
 {}

tS32 mplay_fi_tcl_DriveErrorInfo::s32GetTypeId() const
{
   return (tS32) mplay_typesfi_tclToken::EN_DRIVEERRORINFO;
}


mplay_fi_tcl_DriveErrorInfo::~mplay_fi_tcl_DriveErrorInfo()
{}

tU32 mplay_fi_tcl_DriveErrorInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_fi_tcl_DriveErrorInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e16Drive);
   (tVoid) (oIn >> e16ErrorValue);
   return oIn;
}

fi_tclOutContext& mplay_fi_tcl_DriveErrorInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e16Drive);
   (tVoid) (oOut << e16ErrorValue);
   return oOut;
}

tBool mplay_fi_tcl_DriveErrorInfo::operator==(const mplay_fi_tcl_DriveErrorInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e16Drive == roRef.e16Drive);
   bResult = bResult && (e16ErrorValue == roRef.e16ErrorValue);
   return bResult;
}

