#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MEDIAPLAYERFI_SERVICEINFO
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_SERVICEINFO
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_SERVICEINFO
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_SERVICEINFO
#include "mplay_fi_if.h"

#include "alltypefactory.h"

fi_tclTypeBase* mplay_fi_poGetFIObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclMessageBase* poType
   = mplay_fi_poGetMessageBaseObject(u16ServiceId, u16FunctionId, u8Opcode);
   if (poType)
      return &poType->rfoGetTypeBase();
   else
      return OSAL_NULL;
}

fi_tclMessageBase* mplay_fi_poGetMessageBaseObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   switch(u16ServiceId)
   {
      case MPLAY_MEDIAPLAYERFI_C_U16_SERVICE_ID:
         return mplay_mediaplayerfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_ID:
         return mplay_devicemanagerfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case MPLAY_APPCONTROLFI_C_U16_SERVICE_ID:
         return mplay_appcontrolfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      case MPLAY_MMGRFI_C_U16_SERVICE_ID:
         return mplay_mmgrfi_poGetMessageBaseObject(u16FunctionId, u8Opcode); 

      default: 
         return OSAL_NULL;
   }
}

