/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_SERVICEINFO
#include "mplay_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MPLAY_MMGR_FI message types

fi_tclMessageBase* mplay_mmgrfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODSTART:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDEjectMethodStart;

      case mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODRESULT:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDEjectMethodResult;

      case mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODSTART:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDInsertMethodStart;

      case mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODRESULT:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDInsertMethodResult;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODSTART:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULTFIRST:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULT:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODSTART:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagControlEjectMethodStart;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODRESULT:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagControlEjectMethodResult;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODSTART:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagPerformTestMethodStart;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODRESULT:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagPerformTestMethodResult;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODSTART:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODRESULT:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult;

      case mplay_mmgrfi_tclToken::EN_MSG_CDINFOUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDInfoUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_CDINFORELUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDInfoRelUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_CDINFOGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDInfoGet;

      case mplay_mmgrfi_tclToken::EN_MSG_CDINFOSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDInfoStatus;

      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDTempUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPRELUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDTempRelUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDTempGet;

      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgCDTempStatus;

      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgDriveErrorInformationUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONRELUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgDriveErrorInformationGet;

      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgDriveErrorInformationStatus;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagFirmwareVersionGet;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagDriveVersionGet;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagDriveVersionStatus;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagLoadStatusGet;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagLoadStatusStatus;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagErrorStatusUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSRELUPREG:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagErrorStatusGet;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagErrorStatusStatus;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTGET:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet;

      case mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTSTATUS:
         return OSAL_NEW mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all mplay_mmgrfifi messages

// common functions

tU16 mplay_mmgrfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MPLAY_MMGRFI_C_U16_SERVICE_ID;
}

tU16 mplay_mmgrfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 mplay_mmgrfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& mplay_mmgrfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& mplay_mmgrfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 mplay_mmgrfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& mplay_mmgrfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

mplay_mmgrfi_tclMsgCDEjectMethodStart::mplay_mmgrfi_tclMsgCDEjectMethodStart()
 {}

tS32 mplay_mmgrfi_tclMsgCDEjectMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODSTART;
}


mplay_mmgrfi_tclMsgCDEjectMethodStart::~mplay_mmgrfi_tclMsgCDEjectMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgCDEjectMethodResult::mplay_mmgrfi_tclMsgCDEjectMethodResult(const mplay_mmgrfi_tclMsgCDEjectMethodResult& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mplay_mmgrfi_tclMsgCDEjectMethodResult& mplay_mmgrfi_tclMsgCDEjectMethodResult::operator=(const mplay_mmgrfi_tclMsgCDEjectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgCDEjectMethodResult::mplay_mmgrfi_tclMsgCDEjectMethodResult()
:ServiceStatus()
 {}

tS32 mplay_mmgrfi_tclMsgCDEjectMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODRESULT;
}


mplay_mmgrfi_tclMsgCDEjectMethodResult::~mplay_mmgrfi_tclMsgCDEjectMethodResult()
{}

tU32 mplay_mmgrfi_tclMsgCDEjectMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mmgrfi_tclMsgCDEjectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgCDEjectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgCDEjectMethodResult::operator==(const mplay_mmgrfi_tclMsgCDEjectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

mplay_mmgrfi_tclMsgCDInsertMethodStart::mplay_mmgrfi_tclMsgCDInsertMethodStart()
 {}

tS32 mplay_mmgrfi_tclMsgCDInsertMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODSTART;
}


mplay_mmgrfi_tclMsgCDInsertMethodStart::~mplay_mmgrfi_tclMsgCDInsertMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgCDInsertMethodResult::mplay_mmgrfi_tclMsgCDInsertMethodResult(const mplay_mmgrfi_tclMsgCDInsertMethodResult& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
mplay_mmgrfi_tclMsgCDInsertMethodResult& mplay_mmgrfi_tclMsgCDInsertMethodResult::operator=(const mplay_mmgrfi_tclMsgCDInsertMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgCDInsertMethodResult::mplay_mmgrfi_tclMsgCDInsertMethodResult()
:ServiceStatus()
 {}

tS32 mplay_mmgrfi_tclMsgCDInsertMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODRESULT;
}


mplay_mmgrfi_tclMsgCDInsertMethodResult::~mplay_mmgrfi_tclMsgCDInsertMethodResult()
{}

tU32 mplay_mmgrfi_tclMsgCDInsertMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mmgrfi_tclMsgCDInsertMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgCDInsertMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgCDInsertMethodResult::operator==(const mplay_mmgrfi_tclMsgCDInsertMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   e8Duration = coRef.e8Duration;
   StartDriveTestParam = coRef.StartDriveTestParam;
}
mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::operator=(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Duration = coRef.e8Duration;
   StartDriveTestParam = coRef.StartDriveTestParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart()
:e8Duration()
,StartDriveTestParam()
 {}

tS32 mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODSTART;
}


mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::~mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart()
{}

tU32 mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Duration);
   (tVoid) (oIn >> StartDriveTestParam);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Duration);
   (tVoid) (oOut << StartDriveTestParam);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart::operator==(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Duration == roRef.e8Duration);
   bResult = bResult && (StartDriveTestParam == roRef.StartDriveTestParam);
   return bResult;
}

//=============================================================================

mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst::mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst()
 {}

tS32 mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULTFIRST;
}


mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst::~mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResultFirst()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   e8Duration = coRef.e8Duration;
   ResultDriveTest = coRef.ResultDriveTest;
}
mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::operator=(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8Duration = coRef.e8Duration;
   ResultDriveTest = coRef.ResultDriveTest;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult()
:e8Duration()
,ResultDriveTest()
 {}

tS32 mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULT;
}


mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::~mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult()
{}

tU32 mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 29;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Duration);
   (tVoid) (oIn >> ResultDriveTest);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Duration);
   (tVoid) (oOut << ResultDriveTest);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult::operator==(const mplay_mmgrfi_tclMsgDiagControlDriveTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Duration == roRef.e8Duration);
   bResult = bResult && (ResultDriveTest == roRef.ResultDriveTest);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::mplay_mmgrfi_tclMsgDiagControlEjectMethodStart(const mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   e8Duration = coRef.e8Duration;
   StartEjectParam = coRef.StartEjectParam;
}
mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::operator=(const mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Duration = coRef.e8Duration;
   StartEjectParam = coRef.StartEjectParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::mplay_mmgrfi_tclMsgDiagControlEjectMethodStart()
:e8Duration()
,StartEjectParam()
 {}

tS32 mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODSTART;
}


mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::~mplay_mmgrfi_tclMsgDiagControlEjectMethodStart()
{}

tU32 mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Duration);
   (tVoid) (oIn >> StartEjectParam);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Duration);
   (tVoid) (oOut << StartEjectParam);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagControlEjectMethodStart::operator==(const mplay_mmgrfi_tclMsgDiagControlEjectMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Duration == roRef.e8Duration);
   bResult = bResult && (StartEjectParam == roRef.StartEjectParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::mplay_mmgrfi_tclMsgDiagControlEjectMethodResult(const mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   e8Duration = coRef.e8Duration;
   ResultEject = coRef.ResultEject;
}
mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::operator=(const mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8Duration = coRef.e8Duration;
   ResultEject = coRef.ResultEject;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::mplay_mmgrfi_tclMsgDiagControlEjectMethodResult()
:e8Duration()
,ResultEject()
 {}

tS32 mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODRESULT;
}


mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::~mplay_mmgrfi_tclMsgDiagControlEjectMethodResult()
{}

tU32 mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Duration);
   (tVoid) (oIn >> ResultEject);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Duration);
   (tVoid) (oOut << ResultEject);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagControlEjectMethodResult::operator==(const mplay_mmgrfi_tclMsgDiagControlEjectMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Duration == roRef.e8Duration);
   bResult = bResult && (ResultEject == roRef.ResultEject);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::mplay_mmgrfi_tclMsgDiagPerformTestMethodStart(const mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   TestRoutineParameterList = coRef.TestRoutineParameterList;
}
mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::operator=(const mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestRoutineParameterList = coRef.TestRoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::vDestroy()
{
   TestRoutineParameterList.vDestroy(); 
}

mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::mplay_mmgrfi_tclMsgDiagPerformTestMethodStart()
:TestRoutineParameterList()
 {}

tS32 mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODSTART;
}


mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::~mplay_mmgrfi_tclMsgDiagPerformTestMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestRoutineParameterList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestRoutineParameterList);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestRoutineParameterList);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagPerformTestMethodStart::operator==(const mplay_mmgrfi_tclMsgDiagPerformTestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestRoutineParameterList == roRef.TestRoutineParameterList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::mplay_mmgrfi_tclMsgDiagPerformTestMethodResult(const mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   TestRoutineParameterList = coRef.TestRoutineParameterList;
}
mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::operator=(const mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TestRoutineParameterList = coRef.TestRoutineParameterList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::vDestroy()
{
   TestRoutineParameterList.vDestroy(); 
}

mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::mplay_mmgrfi_tclMsgDiagPerformTestMethodResult()
:TestRoutineParameterList()
 {}

tS32 mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODRESULT;
}


mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::~mplay_mmgrfi_tclMsgDiagPerformTestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestRoutineParameterList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestRoutineParameterList);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestRoutineParameterList);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagPerformTestMethodResult::operator==(const mplay_mmgrfi_tclMsgDiagPerformTestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestRoutineParameterList == roRef.TestRoutineParameterList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   TrackType = coRef.TrackType;
}
mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::operator=(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TrackType = coRef.TrackType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart()
:TrackType()
 {}

tS32 mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODSTART;
}


mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::~mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart()
{}

tU32 mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TrackType);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TrackType);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart::operator==(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TrackType == roRef.TrackType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   ActTrackType = coRef.ActTrackType;
   ReqTrackType = coRef.ReqTrackType;
   Result = coRef.Result;
}
mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::operator=(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ActTrackType = coRef.ActTrackType;
   ReqTrackType = coRef.ReqTrackType;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult()
:ActTrackType()
,ReqTrackType()
,Result()
 {}

tS32 mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODRESULT;
}


mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::~mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult()
{}

tU32 mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActTrackType);
   (tVoid) (oIn >> ReqTrackType);
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActTrackType);
   (tVoid) (oOut << ReqTrackType);
   (tVoid) (oOut << Result);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult::operator==(const mplay_mmgrfi_tclMsgDiagCdSelectTrackTypeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActTrackType == roRef.ActTrackType);
   bResult = bResult && (ReqTrackType == roRef.ReqTrackType);
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

//=============================================================================

mplay_mmgrfi_tclMsgCDInfoUpReg::mplay_mmgrfi_tclMsgCDInfoUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgCDInfoUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDINFOUPREG;
}


mplay_mmgrfi_tclMsgCDInfoUpReg::~mplay_mmgrfi_tclMsgCDInfoUpReg()
{}

//=============================================================================

mplay_mmgrfi_tclMsgCDInfoRelUpReg::mplay_mmgrfi_tclMsgCDInfoRelUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgCDInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDINFORELUPREG;
}


mplay_mmgrfi_tclMsgCDInfoRelUpReg::~mplay_mmgrfi_tclMsgCDInfoRelUpReg()
{}

//=============================================================================

mplay_mmgrfi_tclMsgCDInfoGet::mplay_mmgrfi_tclMsgCDInfoGet()
 {}

tS32 mplay_mmgrfi_tclMsgCDInfoGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDINFOGET;
}


mplay_mmgrfi_tclMsgCDInfoGet::~mplay_mmgrfi_tclMsgCDInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgCDInfoStatus::mplay_mmgrfi_tclMsgCDInfoStatus(const mplay_mmgrfi_tclMsgCDInfoStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   CDType = coRef.CDType;
   MediaState = coRef.MediaState;
   InsertState = coRef.InsertState;
   e8DeviceState = coRef.e8DeviceState;
   szcUniqueID = coRef.szcUniqueID;
   DriveVersion = coRef.DriveVersion;
}
mplay_mmgrfi_tclMsgCDInfoStatus& mplay_mmgrfi_tclMsgCDInfoStatus::operator=(const mplay_mmgrfi_tclMsgCDInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   CDType = coRef.CDType;
   MediaState = coRef.MediaState;
   InsertState = coRef.InsertState;
   e8DeviceState = coRef.e8DeviceState;
   szcUniqueID = coRef.szcUniqueID;
   DriveVersion = coRef.DriveVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mmgrfi_tclMsgCDInfoStatus::vDestroy()
{
   szcUniqueID.vDestroy();
   DriveVersion.vDestroy();
}

mplay_mmgrfi_tclMsgCDInfoStatus::mplay_mmgrfi_tclMsgCDInfoStatus()
:CDType()
,MediaState()
,InsertState()
,e8DeviceState()
,szcUniqueID()
,DriveVersion()
 {}

tS32 mplay_mmgrfi_tclMsgCDInfoStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDINFOSTATUS;
}


mplay_mmgrfi_tclMsgCDInfoStatus::~mplay_mmgrfi_tclMsgCDInfoStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mmgrfi_tclMsgCDInfoStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+szcUniqueID.u32GetSize(u16MajorVersion)+DriveVersion.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mmgrfi_tclMsgCDInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CDType);
   (tVoid) (oIn >> MediaState);
   (tVoid) (oIn >> InsertState);
   (tVoid) (oIn >> e8DeviceState);
   (tVoid) (oIn >> szcUniqueID);
   (tVoid) (oIn >> DriveVersion);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgCDInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CDType);
   (tVoid) (oOut << MediaState);
   (tVoid) (oOut << InsertState);
   (tVoid) (oOut << e8DeviceState);
   (tVoid) (oOut << szcUniqueID);
   (tVoid) (oOut << DriveVersion);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgCDInfoStatus::operator==(const mplay_mmgrfi_tclMsgCDInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CDType == roRef.CDType);
   bResult = bResult && (MediaState == roRef.MediaState);
   bResult = bResult && (InsertState == roRef.InsertState);
   bResult = bResult && (e8DeviceState == roRef.e8DeviceState);
   bResult = bResult && (szcUniqueID == roRef.szcUniqueID);
   bResult = bResult && (DriveVersion == roRef.DriveVersion);
   return bResult;
}

//=============================================================================

mplay_mmgrfi_tclMsgCDTempUpReg::mplay_mmgrfi_tclMsgCDTempUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgCDTempUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDTEMPUPREG;
}


mplay_mmgrfi_tclMsgCDTempUpReg::~mplay_mmgrfi_tclMsgCDTempUpReg()
{}

//=============================================================================

mplay_mmgrfi_tclMsgCDTempRelUpReg::mplay_mmgrfi_tclMsgCDTempRelUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgCDTempRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDTEMPRELUPREG;
}


mplay_mmgrfi_tclMsgCDTempRelUpReg::~mplay_mmgrfi_tclMsgCDTempRelUpReg()
{}

//=============================================================================

mplay_mmgrfi_tclMsgCDTempGet::mplay_mmgrfi_tclMsgCDTempGet()
 {}

tS32 mplay_mmgrfi_tclMsgCDTempGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDTEMPGET;
}


mplay_mmgrfi_tclMsgCDTempGet::~mplay_mmgrfi_tclMsgCDTempGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgCDTempStatus::mplay_mmgrfi_tclMsgCDTempStatus(const mplay_mmgrfi_tclMsgCDTempStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   CDTemp = coRef.CDTemp;
   Status = coRef.Status;
}
mplay_mmgrfi_tclMsgCDTempStatus& mplay_mmgrfi_tclMsgCDTempStatus::operator=(const mplay_mmgrfi_tclMsgCDTempStatus& coRef)
{
   if (this == &coRef) return *this;
   CDTemp = coRef.CDTemp;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgCDTempStatus::mplay_mmgrfi_tclMsgCDTempStatus()
:CDTemp(0)
,Status()
 {}

tS32 mplay_mmgrfi_tclMsgCDTempStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_CDTEMPSTATUS;
}


mplay_mmgrfi_tclMsgCDTempStatus::~mplay_mmgrfi_tclMsgCDTempStatus()
{}

tU32 mplay_mmgrfi_tclMsgCDTempStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_mmgrfi_tclMsgCDTempStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CDTemp);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgCDTempStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CDTemp);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgCDTempStatus::operator==(const mplay_mmgrfi_tclMsgCDTempStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CDTemp == roRef.CDTemp);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

mplay_mmgrfi_tclMsgDriveErrorInformationUpReg::mplay_mmgrfi_tclMsgDriveErrorInformationUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgDriveErrorInformationUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONUPREG;
}


mplay_mmgrfi_tclMsgDriveErrorInformationUpReg::~mplay_mmgrfi_tclMsgDriveErrorInformationUpReg()
{}

//=============================================================================

mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg::mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONRELUPREG;
}


mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg::~mplay_mmgrfi_tclMsgDriveErrorInformationRelUpReg()
{}

//=============================================================================

mplay_mmgrfi_tclMsgDriveErrorInformationGet::mplay_mmgrfi_tclMsgDriveErrorInformationGet()
 {}

tS32 mplay_mmgrfi_tclMsgDriveErrorInformationGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONGET;
}


mplay_mmgrfi_tclMsgDriveErrorInformationGet::~mplay_mmgrfi_tclMsgDriveErrorInformationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDriveErrorInformationStatus::mplay_mmgrfi_tclMsgDriveErrorInformationStatus(const mplay_mmgrfi_tclMsgDriveErrorInformationStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   DriveErrorInfo = coRef.DriveErrorInfo;
}
mplay_mmgrfi_tclMsgDriveErrorInformationStatus& mplay_mmgrfi_tclMsgDriveErrorInformationStatus::operator=(const mplay_mmgrfi_tclMsgDriveErrorInformationStatus& coRef)
{
   if (this == &coRef) return *this;
   DriveErrorInfo = coRef.DriveErrorInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDriveErrorInformationStatus::mplay_mmgrfi_tclMsgDriveErrorInformationStatus()
:DriveErrorInfo()
 {}

tS32 mplay_mmgrfi_tclMsgDriveErrorInformationStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONSTATUS;
}


mplay_mmgrfi_tclMsgDriveErrorInformationStatus::~mplay_mmgrfi_tclMsgDriveErrorInformationStatus()
{}

tU32 mplay_mmgrfi_tclMsgDriveErrorInformationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDriveErrorInformationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveErrorInfo);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDriveErrorInformationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveErrorInfo);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDriveErrorInformationStatus::operator==(const mplay_mmgrfi_tclMsgDriveErrorInformationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveErrorInfo == roRef.DriveErrorInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::mplay_mmgrfi_tclMsgDiagFirmwareVersionGet(const mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   Drive = coRef.Drive;
}
mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::operator=(const mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& coRef)
{
   if (this == &coRef) return *this;
   Drive = coRef.Drive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::mplay_mmgrfi_tclMsgDiagFirmwareVersionGet()
:Drive()
 {}

tS32 mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONGET;
}


mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::~mplay_mmgrfi_tclMsgDiagFirmwareVersionGet()
{}

tU32 mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Drive);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Drive);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagFirmwareVersionGet::operator==(const mplay_mmgrfi_tclMsgDiagFirmwareVersionGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Drive == roRef.Drive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus(const mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   FirmwareVersion = coRef.FirmwareVersion;
}
mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::operator=(const mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   FirmwareVersion = coRef.FirmwareVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus()
:FirmwareVersion()
 {}

tS32 mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONSTATUS;
}


mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::~mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus()
{}

tU32 mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FirmwareVersion);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FirmwareVersion);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus::operator==(const mplay_mmgrfi_tclMsgDiagFirmwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FirmwareVersion == roRef.FirmwareVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagDriveVersionGet::mplay_mmgrfi_tclMsgDiagDriveVersionGet(const mplay_mmgrfi_tclMsgDiagDriveVersionGet& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   Drive = coRef.Drive;
}
mplay_mmgrfi_tclMsgDiagDriveVersionGet& mplay_mmgrfi_tclMsgDiagDriveVersionGet::operator=(const mplay_mmgrfi_tclMsgDiagDriveVersionGet& coRef)
{
   if (this == &coRef) return *this;
   Drive = coRef.Drive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagDriveVersionGet::mplay_mmgrfi_tclMsgDiagDriveVersionGet()
:Drive()
 {}

tS32 mplay_mmgrfi_tclMsgDiagDriveVersionGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONGET;
}


mplay_mmgrfi_tclMsgDiagDriveVersionGet::~mplay_mmgrfi_tclMsgDiagDriveVersionGet()
{}

tU32 mplay_mmgrfi_tclMsgDiagDriveVersionGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagDriveVersionGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Drive);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagDriveVersionGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Drive);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagDriveVersionGet::operator==(const mplay_mmgrfi_tclMsgDiagDriveVersionGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Drive == roRef.Drive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagDriveVersionStatus::mplay_mmgrfi_tclMsgDiagDriveVersionStatus(const mplay_mmgrfi_tclMsgDiagDriveVersionStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   DriveVersion = coRef.DriveVersion;
}
mplay_mmgrfi_tclMsgDiagDriveVersionStatus& mplay_mmgrfi_tclMsgDiagDriveVersionStatus::operator=(const mplay_mmgrfi_tclMsgDiagDriveVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   DriveVersion = coRef.DriveVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagDriveVersionStatus::mplay_mmgrfi_tclMsgDiagDriveVersionStatus()
:DriveVersion()
 {}

tS32 mplay_mmgrfi_tclMsgDiagDriveVersionStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONSTATUS;
}


mplay_mmgrfi_tclMsgDiagDriveVersionStatus::~mplay_mmgrfi_tclMsgDiagDriveVersionStatus()
{}

tU32 mplay_mmgrfi_tclMsgDiagDriveVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 40;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagDriveVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveVersion);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagDriveVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveVersion);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagDriveVersionStatus::operator==(const mplay_mmgrfi_tclMsgDiagDriveVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveVersion == roRef.DriveVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagLoadStatusGet::mplay_mmgrfi_tclMsgDiagLoadStatusGet(const mplay_mmgrfi_tclMsgDiagLoadStatusGet& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   Drive = coRef.Drive;
}
mplay_mmgrfi_tclMsgDiagLoadStatusGet& mplay_mmgrfi_tclMsgDiagLoadStatusGet::operator=(const mplay_mmgrfi_tclMsgDiagLoadStatusGet& coRef)
{
   if (this == &coRef) return *this;
   Drive = coRef.Drive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagLoadStatusGet::mplay_mmgrfi_tclMsgDiagLoadStatusGet()
:Drive()
 {}

tS32 mplay_mmgrfi_tclMsgDiagLoadStatusGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSGET;
}


mplay_mmgrfi_tclMsgDiagLoadStatusGet::~mplay_mmgrfi_tclMsgDiagLoadStatusGet()
{}

tU32 mplay_mmgrfi_tclMsgDiagLoadStatusGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagLoadStatusGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Drive);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagLoadStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Drive);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagLoadStatusGet::operator==(const mplay_mmgrfi_tclMsgDiagLoadStatusGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Drive == roRef.Drive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagLoadStatusStatus::mplay_mmgrfi_tclMsgDiagLoadStatusStatus(const mplay_mmgrfi_tclMsgDiagLoadStatusStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   LoadStatus = coRef.LoadStatus;
}
mplay_mmgrfi_tclMsgDiagLoadStatusStatus& mplay_mmgrfi_tclMsgDiagLoadStatusStatus::operator=(const mplay_mmgrfi_tclMsgDiagLoadStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   LoadStatus = coRef.LoadStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagLoadStatusStatus::mplay_mmgrfi_tclMsgDiagLoadStatusStatus()
:LoadStatus()
 {}

tS32 mplay_mmgrfi_tclMsgDiagLoadStatusStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSSTATUS;
}


mplay_mmgrfi_tclMsgDiagLoadStatusStatus::~mplay_mmgrfi_tclMsgDiagLoadStatusStatus()
{}

tU32 mplay_mmgrfi_tclMsgDiagLoadStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagLoadStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LoadStatus);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagLoadStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LoadStatus);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagLoadStatusStatus::operator==(const mplay_mmgrfi_tclMsgDiagLoadStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LoadStatus == roRef.LoadStatus);
   return bResult;
}

//=============================================================================

mplay_mmgrfi_tclMsgDiagErrorStatusUpReg::mplay_mmgrfi_tclMsgDiagErrorStatusUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgDiagErrorStatusUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSUPREG;
}


mplay_mmgrfi_tclMsgDiagErrorStatusUpReg::~mplay_mmgrfi_tclMsgDiagErrorStatusUpReg()
{}

//=============================================================================

mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg::mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg()
 {}

tS32 mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSRELUPREG;
}


mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg::~mplay_mmgrfi_tclMsgDiagErrorStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagErrorStatusGet::mplay_mmgrfi_tclMsgDiagErrorStatusGet(const mplay_mmgrfi_tclMsgDiagErrorStatusGet& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   TroubleCodeList = coRef.TroubleCodeList;
}
mplay_mmgrfi_tclMsgDiagErrorStatusGet& mplay_mmgrfi_tclMsgDiagErrorStatusGet::operator=(const mplay_mmgrfi_tclMsgDiagErrorStatusGet& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodeList = coRef.TroubleCodeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mmgrfi_tclMsgDiagErrorStatusGet::vDestroy()
{
   TroubleCodeList.vDestroy(); 
}

mplay_mmgrfi_tclMsgDiagErrorStatusGet::mplay_mmgrfi_tclMsgDiagErrorStatusGet()
:TroubleCodeList()
 {}

tS32 mplay_mmgrfi_tclMsgDiagErrorStatusGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSGET;
}


mplay_mmgrfi_tclMsgDiagErrorStatusGet::~mplay_mmgrfi_tclMsgDiagErrorStatusGet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mmgrfi_tclMsgDiagErrorStatusGet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TroubleCodeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagErrorStatusGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCodeList);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagErrorStatusGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCodeList);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagErrorStatusGet::operator==(const mplay_mmgrfi_tclMsgDiagErrorStatusGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCodeList == roRef.TroubleCodeList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagErrorStatusStatus::mplay_mmgrfi_tclMsgDiagErrorStatusStatus(const mplay_mmgrfi_tclMsgDiagErrorStatusStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
}
mplay_mmgrfi_tclMsgDiagErrorStatusStatus& mplay_mmgrfi_tclMsgDiagErrorStatusStatus::operator=(const mplay_mmgrfi_tclMsgDiagErrorStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodeStatusList = coRef.TroubleCodeStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid mplay_mmgrfi_tclMsgDiagErrorStatusStatus::vDestroy()
{
   TroubleCodeStatusList.vDestroy(); 
}

mplay_mmgrfi_tclMsgDiagErrorStatusStatus::mplay_mmgrfi_tclMsgDiagErrorStatusStatus()
:TroubleCodeStatusList()
 {}

tS32 mplay_mmgrfi_tclMsgDiagErrorStatusStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSSTATUS;
}


mplay_mmgrfi_tclMsgDiagErrorStatusStatus::~mplay_mmgrfi_tclMsgDiagErrorStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 mplay_mmgrfi_tclMsgDiagErrorStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TroubleCodeStatusList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagErrorStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCodeStatusList);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagErrorStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCodeStatusList);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagErrorStatusStatus::operator==(const mplay_mmgrfi_tclMsgDiagErrorStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCodeStatusList == roRef.TroubleCodeStatusList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   DiagnosisTestParam = coRef.DiagnosisTestParam;
}
mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::operator=(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisTestParam = coRef.DiagnosisTestParam;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet()
:DiagnosisTestParam()
 {}

tS32 mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTGET;
}


mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::~mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet()
{}

tU32 mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisTestParam);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisTestParam);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet::operator==(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisTestParam == roRef.DiagnosisTestParam);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& coRef)
   : mplay_mmgrfi_tclMsgBaseMessage(coRef)
{
   DiagnosisTestType = coRef.DiagnosisTestType;
   DiagTestResult = coRef.DiagTestResult;
}
mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::operator=(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& coRef)
{
   if (this == &coRef) return *this;
   DiagnosisTestType = coRef.DiagnosisTestType;
   DiagTestResult = coRef.DiagTestResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus()
:DiagnosisTestType()
,DiagTestResult()
 {}

tS32 mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::s32GetTypeId() const
{
   return (tS32) mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTSTATUS;
}


mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::~mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus()
{}

tU32 mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagnosisTestType);
   (tVoid) (oIn >> DiagTestResult);
   return oIn;
}

fi_tclOutContext& mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagnosisTestType);
   (tVoid) (oOut << DiagTestResult);
   return oOut;
}

tBool mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus::operator==(const mplay_mmgrfi_tclMsgDiagReadOnlyDevInterfaceTestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagnosisTestType == roRef.DiagnosisTestType);
   bResult = bResult && (DiagTestResult == roRef.DiagTestResult);
   return bResult;
}

