#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_MMGRFI_STDVISITORS
#include "mplay_fi_if.h"

tBool mplay_mmgrfi_tclDescription::bInitMessage(mplay_mmgrfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case mplay_mmgrfi_tclToken::EN_LAST_TOKEN:
   case mplay_mmgrfi_tclToken::EN_LIST:
   case mplay_mmgrfi_tclToken::EN_END_OF_STRUCT:
   case mplay_mmgrfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_MMGR_METHODRESULT,mplay_mmgrfi_tclSemanticDomain::EN_MSG_SERVICESTATUS)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_MMGR_METHODRESULT,mplay_mmgrfi_tclSemanticDomain::EN_MSG_SERVICESTATUS)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGDRVTESTPARAMETER,mplay_mmgrfi_tclSemanticDomain::EN_MSG_STARTDRIVETESTPARAM)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGDURATION,mplay_mmgrfi_tclSemanticDomain::EN_MSG_E8DURATION)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGMETHODRESULTDRVTEST,mplay_mmgrfi_tclSemanticDomain::EN_MSG_RESULTDRIVETEST)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGDURATION,mplay_mmgrfi_tclSemanticDomain::EN_MSG_E8DURATION)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGEJECTPARAM,mplay_mmgrfi_tclSemanticDomain::EN_MSG_STARTEJECTPARAM)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGDURATION,mplay_mmgrfi_tclSemanticDomain::EN_MSG_E8DURATION)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGMETHODRESULTEJECT,mplay_mmgrfi_tclSemanticDomain::EN_MSG_RESULTEJECT)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGDURATION,mplay_mmgrfi_tclSemanticDomain::EN_MSG_E8DURATION)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGTESTROUTINELIST,mplay_mmgrfi_tclSemanticDomain::EN_MSG_TESTROUTINEPARAMETERLIST)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGTESTROUTINELIST,mplay_mmgrfi_tclSemanticDomain::EN_MSG_TESTROUTINEPARAMETERLIST)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_TRACKTYPE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_TRACKTYPE)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_TRACKTYPERESULT,mplay_mmgrfi_tclSemanticDomain::EN_MSG_RESULT)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_TRACKTYPE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_REQTRACKTYPE)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_TRACKTYPE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_ACTTRACKTYPE)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_CDINFOSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_STRING,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DRIVEVERSION)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_STRING,mplay_mmgrfi_tclSemanticDomain::EN_MSG_SZCUNIQUEID)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8DEVICESTATE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_E8DEVICESTATE)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_INSERTSTATE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_INSERTSTATE)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_MEDIASTATE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_MEDIASTATE)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_CDTYPE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_CDTYPE)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8DRIVETEMPSENSORSTATUS,mplay_mmgrfi_tclSemanticDomain::EN_MSG_STATUS)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_S16,mplay_mmgrfi_tclSemanticDomain::EN_MSG_CDTEMP)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DRIVEERRORINFO,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DRIVEERRORINFO)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONGET:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DRIVE)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGFIRMWAREVERSION,mplay_mmgrfi_tclSemanticDomain::EN_MSG_FIRMWAREVERSION)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONGET:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DRIVE)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGDRIVEVERSION,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DRIVEVERSION)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSGET:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DRIVE)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGLOADSTATUS,mplay_mmgrfi_tclSemanticDomain::EN_MSG_LOADSTATUS)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSGET:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGTROUBLECODELIST,mplay_mmgrfi_tclSemanticDomain::EN_MSG_TROUBLECODELIST)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGTROUBLECODESTATUSLIST,mplay_mmgrfi_tclSemanticDomain::EN_MSG_TROUBLECODESTATUSLIST)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTGET:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGREADDEVINTERFACETESTPARAM,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DIAGNOSISTESTPARAM)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTSTATUS:
   {
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGTESTRESULT,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DIAGTESTRESULT)) && bResult;
      bResult = oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGNOSISTESTTYPE,mplay_mmgrfi_tclSemanticDomain::EN_MSG_DIAGNOSISTESTTYPE)) && bResult;
   } break;
   case mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODSTART:
   case mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODSTART:
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULTFIRST:
   case mplay_mmgrfi_tclToken::EN_MSG_CDINFOUPREG:
   case mplay_mmgrfi_tclToken::EN_MSG_CDINFORELUPREG:
   case mplay_mmgrfi_tclToken::EN_MSG_CDINFOGET:
   case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPUPREG:
   case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPRELUPREG:
   case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPGET:
   case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONUPREG:
   case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONRELUPREG:
   case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONGET:
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSUPREG:
   case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSRELUPREG:
   case mplay_mmgrfi_tclToken::EN_BINCONTAINER:
   case mplay_mmgrfi_tclToken::EN_E8_CDTYPE:
   case mplay_mmgrfi_tclToken::EN_E8_MEDIASTATE:
   case mplay_mmgrfi_tclToken::EN_E8_INSERTSTATE:
   case mplay_mmgrfi_tclToken::EN_E8_MMGR_METHODRESULT:
   case mplay_mmgrfi_tclToken::EN_E8DEVICESTATE:
   case mplay_mmgrfi_tclToken::EN_E8DRIVETEMPSENSORSTATUS:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGDRV:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGDRVTESTCMD:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGDRVTESTPARAM:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGRESULTEJECT:
   case mplay_mmgrfi_tclToken::EN_E8_DIAGLOADSTATUS:
   case mplay_mmgrfi_tclToken::EN_E8_DIAGDURATION:
   case mplay_mmgrfi_tclToken::EN_E8_DIAGRETVALUEDRIVETEST:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGTROUBLECODE:
   case mplay_mmgrfi_tclToken::EN_E8_DIAGMONITORINGMODE:
   case mplay_mmgrfi_tclToken::EN_E8_DIAGSUPERVISIONCONTROL:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGERRORSTATUS:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGROUTINESTATUS:
   case mplay_mmgrfi_tclToken::EN_E8_TRACKTYPE:
   case mplay_mmgrfi_tclToken::EN_E8_TRACKTYPERESULT:
   case mplay_mmgrfi_tclToken::EN_DIAGDRVTESTPARAMETER:
   case mplay_mmgrfi_tclToken::EN_DIAGMETHODRESULTDRVTEST:
   case mplay_mmgrfi_tclToken::EN_DIAGEJECTPARAM:
   case mplay_mmgrfi_tclToken::EN_DIAGMETHODRESULTEJECT:
   case mplay_mmgrfi_tclToken::EN_DIAGFIRMWAREVERSION:
   case mplay_mmgrfi_tclToken::EN_DIAGDRIVEVERSION:
   case mplay_mmgrfi_tclToken::EN_DIAGTESTROUTINEPARAMETER:
   case mplay_mmgrfi_tclToken::EN_DIAGTESTROUTINELIST:
   case mplay_mmgrfi_tclToken::EN_DIAGTROUBLECODELIST:
   case mplay_mmgrfi_tclToken::EN_DIAGTROUBLESTATUS:
   case mplay_mmgrfi_tclToken::EN_DIAGTROUBLECODESTATUSLIST:
   case mplay_mmgrfi_tclToken::EN_E8_DIAGNOSISTESTTYPE:
   case mplay_mmgrfi_tclToken::EN_E16_DIAGTESTTYPE:
   case mplay_mmgrfi_tclToken::EN_DIAGREADDEVINTERFACETESTPARAM:
   case mplay_mmgrfi_tclToken::EN_DIAGTESTRESULT:
   case mplay_mmgrfi_tclToken::EN_E16_DRIVEERRORVALUE:
   case mplay_mmgrfi_tclToken::EN_DRIVEERRORINFO:
   case mplay_mmgrfi_tclToken::EN_U8:   
   case mplay_mmgrfi_tclToken::EN_S8:   
   case mplay_mmgrfi_tclToken::EN_U16:   
   case mplay_mmgrfi_tclToken::EN_S16:   
   case mplay_mmgrfi_tclToken::EN_U24:   
   case mplay_mmgrfi_tclToken::EN_S24:   
   case mplay_mmgrfi_tclToken::EN_U32:   
   case mplay_mmgrfi_tclToken::EN_S32:   
   case mplay_mmgrfi_tclToken::EN_U64:   
   case mplay_mmgrfi_tclToken::EN_S64:   
   case mplay_mmgrfi_tclToken::EN_F32:   
   case mplay_mmgrfi_tclToken::EN_F64:   
   case mplay_mmgrfi_tclToken::EN_BOOL:   
   case mplay_mmgrfi_tclToken::EN_STRING:   
   case mplay_mmgrfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(enMsgToken,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool mplay_mmgrfi_tclDescription::bDoIt(mplay_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool mplay_mmgrfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      mplay_mmgrfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      mplay_mmgrfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      mplay_mmgrfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == mplay_mmgrfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(mplay_mmgrfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case mplay_mmgrfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == mplay_mmgrfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_LIST: 
      {
         mplay_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            mplay_mmgrfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            mplay_mmgrfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case mplay_mmgrfi_tclToken::EN_U8: 
      {
         mplay_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case mplay_mmgrfi_tclToken::EN_U16: 
      {
         mplay_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_U24: 
      {
         mplay_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_U32: 
      {
         mplay_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_U64: 
      {
         mplay_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_S8: 
      {
         mplay_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_S16: 
      {
         mplay_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_S24: 
      {
         mplay_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_S32: 
      {
         mplay_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_S64: 
      {
         mplay_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_F32: 
      {
         mplay_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_F64: 
      {
         mplay_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_BOOL: 
      {
         mplay_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_STRING: 
      {
         mplay_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         mplay_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODSTART:
      case mplay_mmgrfi_tclToken::EN_MSG_CDEJECTMETHODRESULT:
      case mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODSTART:
      case mplay_mmgrfi_tclToken::EN_MSG_CDINSERTMETHODRESULT:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODSTART:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULTFIRST:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLDRIVETESTMETHODRESULT:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODSTART:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCONTROLEJECTMETHODRESULT:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODSTART:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGPERFORMTESTMETHODRESULT:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODSTART:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGCDSELECTTRACKTYPEMETHODRESULT:
      case mplay_mmgrfi_tclToken::EN_MSG_CDINFOUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_CDINFORELUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_CDINFOGET:
      case mplay_mmgrfi_tclToken::EN_MSG_CDINFOSTATUS:
      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPRELUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPGET:
      case mplay_mmgrfi_tclToken::EN_MSG_CDTEMPSTATUS:
      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONRELUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONGET:
      case mplay_mmgrfi_tclToken::EN_MSG_DRIVEERRORINFORMATIONSTATUS:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONGET:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGFIRMWAREVERSIONSTATUS:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONGET:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGDRIVEVERSIONSTATUS:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSGET:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGLOADSTATUSSTATUS:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSRELUPREG:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSGET:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGERRORSTATUSSTATUS:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTGET:
      case mplay_mmgrfi_tclToken::EN_MSG_DIAGREADONLYDEVINTERFACETESTSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case mplay_mmgrfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_LIST,mplay_mmgrfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         mplay_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_CDTYPE:
      {
         mplay_fi_tcl_e8_CdType o_e8_CdType;
         if (!bDoIt(o_e8_CdType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_MEDIASTATE:
      {
         mplay_fi_tcl_e8_MediaState o_e8_MediaState;
         if (!bDoIt(o_e8_MediaState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_INSERTSTATE:
      {
         mplay_fi_tcl_e8_InsertState o_e8_InsertState;
         if (!bDoIt(o_e8_InsertState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_MMGR_METHODRESULT:
      {
         mplay_fi_tcl_e8_MMgr_MethodResult o_e8_MMgr_MethodResult;
         if (!bDoIt(o_e8_MMgr_MethodResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8DEVICESTATE:
      {
         mplay_fi_tcl_e8DeviceState o_e8DeviceState;
         if (!bDoIt(o_e8DeviceState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8DRIVETEMPSENSORSTATUS:
      {
         mplay_fi_tcl_e8DriveTempSensorStatus o_e8DriveTempSensorStatus;
         if (!bDoIt(o_e8DriveTempSensorStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGDRV:
      {
         mplay_fi_tcl_e16_DiagDrv o_e16_DiagDrv;
         if (!bDoIt(o_e16_DiagDrv))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGDRVTESTCMD:
      {
         mplay_fi_tcl_e16_DiagDrvTestCmd o_e16_DiagDrvTestCmd;
         if (!bDoIt(o_e16_DiagDrvTestCmd))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGDRVTESTPARAM:
      {
         mplay_fi_tcl_e16_DiagDrvTestParam o_e16_DiagDrvTestParam;
         if (!bDoIt(o_e16_DiagDrvTestParam))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGRESULTEJECT:
      {
         mplay_fi_tcl_e16_DiagResultEject o_e16_DiagResultEject;
         if (!bDoIt(o_e16_DiagResultEject))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_DIAGLOADSTATUS:
      {
         mplay_fi_tcl_e8_DiagLoadStatus o_e8_DiagLoadStatus;
         if (!bDoIt(o_e8_DiagLoadStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_DIAGDURATION:
      {
         mplay_fi_tcl_e8_DiagDuration o_e8_DiagDuration;
         if (!bDoIt(o_e8_DiagDuration))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_DIAGRETVALUEDRIVETEST:
      {
         mplay_fi_tcl_e8_DiagRetValueDriveTest o_e8_DiagRetValueDriveTest;
         if (!bDoIt(o_e8_DiagRetValueDriveTest))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGTROUBLECODE:
      {
         mplay_fi_tcl_e16_DiagTroubleCode o_e16_DiagTroubleCode;
         if (!bDoIt(o_e16_DiagTroubleCode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_DIAGMONITORINGMODE:
      {
         mplay_fi_tcl_e8_DiagMonitoringMode o_e8_DiagMonitoringMode;
         if (!bDoIt(o_e8_DiagMonitoringMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_DIAGSUPERVISIONCONTROL:
      {
         mplay_fi_tcl_e8_DiagSupervisionControl o_e8_DiagSupervisionControl;
         if (!bDoIt(o_e8_DiagSupervisionControl))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGERRORSTATUS:
      {
         mplay_fi_tcl_e16_DiagErrorStatus o_e16_DiagErrorStatus;
         if (!bDoIt(o_e16_DiagErrorStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGROUTINESTATUS:
      {
         mplay_fi_tcl_e16_DiagRoutineStatus o_e16_DiagRoutineStatus;
         if (!bDoIt(o_e16_DiagRoutineStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_TRACKTYPE:
      {
         mplay_fi_tcl_e8_TrackType o_e8_TrackType;
         if (!bDoIt(o_e8_TrackType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_TRACKTYPERESULT:
      {
         mplay_fi_tcl_e8_TrackTypeResult o_e8_TrackTypeResult;
         if (!bDoIt(o_e8_TrackTypeResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGDRVTESTPARAMETER:
      {
      if (poVisitor->bDoExpand_DiagDrvTestParameter(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRVTESTPARAM,mplay_mmgrfi_tclSemanticDomain::EN_E16DRIVETESTPARAM));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRVTESTCMD,mplay_mmgrfi_tclSemanticDomain::EN_E16DRIVETESTCMD));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_E16DRIVE));
      }
      else
      {
         mplay_fi_tcl_DiagDrvTestParameter o_DiagDrvTestParameter;
         if (!bDoIt(o_DiagDrvTestParameter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagDrvTestParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagDrvTestParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGMETHODRESULTDRVTEST:
      {
      if (poVisitor->bDoExpand_DiagMethodResultDrvTest(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8CNTDVDLAYER));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U32,mplay_mmgrfi_tclSemanticDomain::EN_U32MAXLBA));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U16,mplay_mmgrfi_tclSemanticDomain::EN_U16MAXREADTIMEPERSECTOR));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U32,mplay_mmgrfi_tclSemanticDomain::EN_U32TOTALREADTIME));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U16,mplay_mmgrfi_tclSemanticDomain::EN_U16AVERAGEREADTIMESECTOR));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U16,mplay_mmgrfi_tclSemanticDomain::EN_U16CNTERRORS));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U16,mplay_mmgrfi_tclSemanticDomain::EN_U16READATTEMPS));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U32,mplay_mmgrfi_tclSemanticDomain::EN_U32SECTORSREAD));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_E16DRIVE));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRVTESTPARAM,mplay_mmgrfi_tclSemanticDomain::EN_E16DIAGDRVTESTTYPE));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGRETVALUEDRIVETEST,mplay_mmgrfi_tclSemanticDomain::EN_E8RETVALUEDRIVETEST));
      }
      else
      {
         mplay_fi_tcl_DiagMethodResultDrvTest o_DiagMethodResultDrvTest;
         if (!bDoIt(o_DiagMethodResultDrvTest))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagMethodResultDrvTest.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagMethodResultDrvTest.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGEJECTPARAM:
      {
      if (poVisitor->bDoExpand_DiagEjectParam(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_E16DRIVE));
      }
      else
      {
         mplay_fi_tcl_DiagEjectParam o_DiagEjectParam;
         if (!bDoIt(o_DiagEjectParam))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagEjectParam.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagEjectParam.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGMETHODRESULTEJECT:
      {
      if (poVisitor->bDoExpand_DiagMethodResultEject(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGRESULTEJECT,mplay_mmgrfi_tclSemanticDomain::EN_E16RESULT));
      }
      else
      {
         mplay_fi_tcl_DiagMethodResultEject o_DiagMethodResultEject;
         if (!bDoIt(o_DiagMethodResultEject))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagMethodResultEject.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagMethodResultEject.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGFIRMWAREVERSION:
      {
      if (poVisitor->bDoExpand_DiagFirmwareVersion(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION07));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION06));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION05));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION04));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION03));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION02));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION01));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8FIRMWAREVERSION00));
      }
      else
      {
         mplay_fi_tcl_DiagFirmwareVersion o_DiagFirmwareVersion;
         if (!bDoIt(o_DiagFirmwareVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagFirmwareVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagFirmwareVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGDRIVEVERSION:
      {
      if (poVisitor->bDoExpand_DiagDriveVersion(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION39));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION38));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION37));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION36));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION35));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION34));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION33));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION32));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION31));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION30));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION29));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION28));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION27));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION26));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION25));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION24));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION23));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION22));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION21));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION20));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION19));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION18));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION17));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION16));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION15));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION14));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION13));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION12));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION11));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION10));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION09));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION08));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION07));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION06));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION05));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION04));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION03));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION02));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION01));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_U8,mplay_mmgrfi_tclSemanticDomain::EN_U8DRIVEVERSION00));
      }
      else
      {
         mplay_fi_tcl_DiagDriveVersion o_DiagDriveVersion;
         if (!bDoIt(o_DiagDriveVersion))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagDriveVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagDriveVersion.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGTESTROUTINEPARAMETER:
      {
      if (poVisitor->bDoExpand_DiagTestRoutineParameter(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGSUPERVISIONCONTROL,mplay_mmgrfi_tclSemanticDomain::EN_E8SUPERVISIONCONTROL));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGMONITORINGMODE,mplay_mmgrfi_tclSemanticDomain::EN_E8MONITORINGMODE));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_BOOL,mplay_mmgrfi_tclSemanticDomain::EN_BWRITETORM));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGTROUBLECODE,mplay_mmgrfi_tclSemanticDomain::EN_E16TROUBLECODE));
      }
      else
      {
         mplay_fi_tcl_DiagTestRoutineParameter o_DiagTestRoutineParameter;
         if (!bDoIt(o_DiagTestRoutineParameter))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTestRoutineParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTestRoutineParameter.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGTESTROUTINELIST:
      {
      if (poVisitor->bDoExpand_DiagTestRoutineList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGTESTROUTINEPARAMETER,mplay_mmgrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_LIST,mplay_mmgrfi_tclSemanticDomain::EN_TESTROUTINEPARAMETERLIST));
      }
      else
      {
         mplay_fi_tcl_DiagTestRoutineList o_DiagTestRoutineList;
         if (!bDoIt(o_DiagTestRoutineList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTestRoutineList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTestRoutineList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGTROUBLECODELIST:
      {
      if (poVisitor->bDoExpand_DiagTroubleCodeList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGTROUBLECODE,mplay_mmgrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_LIST,mplay_mmgrfi_tclSemanticDomain::EN_E16TROUBLECODELIST));
      }
      else
      {
         mplay_fi_tcl_DiagTroubleCodeList o_DiagTroubleCodeList;
         if (!bDoIt(o_DiagTroubleCodeList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTroubleCodeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTroubleCodeList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGTROUBLESTATUS:
      {
      if (poVisitor->bDoExpand_DiagTroubleStatus(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGROUTINESTATUS,mplay_mmgrfi_tclSemanticDomain::EN_E16ROUTINESTATUS));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGERRORSTATUS,mplay_mmgrfi_tclSemanticDomain::EN_E16ERRORSTATUS));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGTROUBLECODE,mplay_mmgrfi_tclSemanticDomain::EN_E16TROUBLECODE));
      }
      else
      {
         mplay_fi_tcl_DiagTroubleStatus o_DiagTroubleStatus;
         if (!bDoIt(o_DiagTroubleStatus))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTroubleStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTroubleStatus.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGTROUBLECODESTATUSLIST:
      {
      if (poVisitor->bDoExpand_DiagTroubleCodeStatusList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_DIAGTROUBLESTATUS,mplay_mmgrfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_LIST,mplay_mmgrfi_tclSemanticDomain::EN_TROUBLECODESTATUSLIST));
      }
      else
      {
         mplay_fi_tcl_DiagTroubleCodeStatusList o_DiagTroubleCodeStatusList;
         if (!bDoIt(o_DiagTroubleCodeStatusList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTroubleCodeStatusList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagTroubleCodeStatusList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_E8_DIAGNOSISTESTTYPE:
      {
         mplay_fi_tcl_e8_DiagnosisTestType o_e8_DiagnosisTestType;
         if (!bDoIt(o_e8_DiagnosisTestType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DIAGTESTTYPE:
      {
         mplay_fi_tcl_e16_DiagTestType o_e16_DiagTestType;
         if (!bDoIt(o_e16_DiagTestType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGREADDEVINTERFACETESTPARAM:
      {
      if (poVisitor->bDoExpand_DiagReadDevInterfaceTestParam(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGTESTTYPE,mplay_mmgrfi_tclSemanticDomain::EN_TESTTYPE));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E8_DIAGNOSISTESTTYPE,mplay_mmgrfi_tclSemanticDomain::EN_DIAGNOSISTESTINITIATOR));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_E16DRIVE));
      }
      else
      {
         mplay_fi_tcl_DiagReadDevInterfaceTestParam o_DiagReadDevInterfaceTestParam;
         if (!bDoIt(o_DiagReadDevInterfaceTestParam))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagReadDevInterfaceTestParam.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DiagReadDevInterfaceTestParam.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_DIAGTESTRESULT:
      {
         mplay_fi_tcl_DiagTestResult o_DiagTestResult;
         if (!bDoIt(o_DiagTestResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_E16_DRIVEERRORVALUE:
      {
         mplay_fi_tcl_e16_DriveErrorValue o_e16_DriveErrorValue;
         if (!bDoIt(o_e16_DriveErrorValue))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_mmgrfi_tclToken::EN_DRIVEERRORINFO:
      {
      if (poVisitor->bDoExpand_DriveErrorInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_END_OF_STRUCT,mplay_mmgrfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DRIVEERRORVALUE,mplay_mmgrfi_tclSemanticDomain::EN_E16ERRORVALUE));
         (tVoid) oPath.bGoDown(mplay_mmgrfi_tclKnot(mplay_mmgrfi_tclToken::EN_E16_DIAGDRV,mplay_mmgrfi_tclSemanticDomain::EN_E16DRIVE));
      }
      else
      {
         mplay_fi_tcl_DriveErrorInfo o_DriveErrorInfo;
         if (!bDoIt(o_DriveErrorInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DriveErrorInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DriveErrorInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_mmgrfi_tclToken::EN_UNKNOWN:
      case mplay_mmgrfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

