#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_DEVICEMANAGERFI_STDVISITORS
#include "mplay_fi_if.h"

tBool mplay_devicemanagerfi_tclDescription::bInitMessage(mplay_devicemanagerfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case mplay_devicemanagerfi_tclToken::EN_LAST_TOKEN:
   case mplay_devicemanagerfi_tclToken::EN_LIST:
   case mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT:
   case mplay_devicemanagerfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_BLOCKDEVICE)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_MOUNT)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SUCCESS)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_EJECTPARMTYPE,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_ECMDPARAM)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_EJECTOPTICALDISC_METHODRESULT,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SERVICESTATUS)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_ADD)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_DVM_DEVICESPEEDUSB,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SPEEDINFO)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_USBPORTNO)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_PRODUCTID)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_VENDORID)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SUCCESS)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_SETTINGSMODE,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SETTINGSMODE)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U16,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_VALUE)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_CONFIGURATIONPARAM)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SUCCESS)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_CONFIGURATIONPARAM)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U16,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_VALUE)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_ADD)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_USBPORTNO)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_PRODUCTID)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_VENDORID)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SUCCESS)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODSTART:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_DEVICESERIALNO)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_DEVICEPROPERTY)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODRESULT:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVINFOSTR,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_DEVINFOARR)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONGET:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_DEVICETYPE)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONSTATUS:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_PORTSTATES,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_USBPORTLIST)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_UNDERVOLTAGE)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_DEVICETYPE)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDSTATUS:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_SDCARDINFO,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_SDCARDLIST)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSET:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_OVERTEMPERATURE)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSTATUS:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_OVERTEMPERATURE)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESET:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_TIMOUTBEFORESENDINGITC)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_BTACONNECTIONSTATUS)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESTATUS:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_TIMOUTBEFORESENDINGITC)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_BTACONNECTIONSTATUS)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCSTATUS:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_SLOTSTATEOPTICALDISCTYPE,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_OPTICALDISCSLOTSTATE)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOSTATUS:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_CDINFO,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_CDINFO)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSET:
   {
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_MDVDDRIVEMODE,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_E8DVDDRIVEMODE)) && bResult;
      bResult = oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_MDVDDISCTYPE,mplay_devicemanagerfi_tclSemanticDomain::EN_MSG_E8DVDDISCTYPE)) && bResult;
   } break;
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODSTART:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONRELUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDRELUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDGET:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDRELUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDGET:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVERELUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEGET:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCRELUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCGET:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFORELUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOGET:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFORELUPREG:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSTATUS:
   case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOUPREG:
   case mplay_devicemanagerfi_tclToken::EN_BINCONTAINER:
   case mplay_devicemanagerfi_tclToken::EN_E8_EJECTOPTICALDISC_METHODRESULT:
   case mplay_devicemanagerfi_tclToken::EN_E8_SLOTSTATEOPTICALDISCTYPE:
   case mplay_devicemanagerfi_tclToken::EN_E8_EJECTPARMTYPE:
   case mplay_devicemanagerfi_tclToken::EN_E8DEVICESTATE:
   case mplay_devicemanagerfi_tclToken::EN_E8_CDINFO:
   case mplay_devicemanagerfi_tclToken::EN_E8_DEVICECONNECTSTATUS:
   case mplay_devicemanagerfi_tclToken::EN_E8_DEVICE:
   case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_PORTSTATES:
   case mplay_devicemanagerfi_tclToken::EN_DVM_CARDIDENTIFIERREGISTER:
   case mplay_devicemanagerfi_tclToken::EN_E8_DVM_MEDIASTATE:
   case mplay_devicemanagerfi_tclToken::EN_E8_DVM_DEVICESPEEDUSB:
   case mplay_devicemanagerfi_tclToken::EN_E8_DVM_UNSUPPORTEDREASON:
   case mplay_devicemanagerfi_tclToken::EN_E8_FILESYSTEM:
   case mplay_devicemanagerfi_tclToken::EN_E8_DVM_MEDIATYPE:
   case mplay_devicemanagerfi_tclToken::EN_E8_POWERSTATUS:
   case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY:
   case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVINFOSTR:
   case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_SDCARDINFO:
   case mplay_devicemanagerfi_tclToken::EN_E8_SETTINGSMODE:
   case mplay_devicemanagerfi_tclToken::EN_E8_MDVDDISCTYPE:
   case mplay_devicemanagerfi_tclToken::EN_E8_MDVDDRIVEMODE:
   case mplay_devicemanagerfi_tclToken::EN_U8:   
   case mplay_devicemanagerfi_tclToken::EN_S8:   
   case mplay_devicemanagerfi_tclToken::EN_U16:   
   case mplay_devicemanagerfi_tclToken::EN_S16:   
   case mplay_devicemanagerfi_tclToken::EN_U24:   
   case mplay_devicemanagerfi_tclToken::EN_S24:   
   case mplay_devicemanagerfi_tclToken::EN_U32:   
   case mplay_devicemanagerfi_tclToken::EN_S32:   
   case mplay_devicemanagerfi_tclToken::EN_U64:   
   case mplay_devicemanagerfi_tclToken::EN_S64:   
   case mplay_devicemanagerfi_tclToken::EN_F32:   
   case mplay_devicemanagerfi_tclToken::EN_F64:   
   case mplay_devicemanagerfi_tclToken::EN_BOOL:   
   case mplay_devicemanagerfi_tclToken::EN_STRING:   
   case mplay_devicemanagerfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(enMsgToken,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool mplay_devicemanagerfi_tclDescription::bDoIt(mplay_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool mplay_devicemanagerfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      mplay_devicemanagerfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      mplay_devicemanagerfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      mplay_devicemanagerfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(mplay_devicemanagerfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == mplay_devicemanagerfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_LIST: 
      {
         mplay_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            mplay_devicemanagerfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            mplay_devicemanagerfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_U8: 
      {
         mplay_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_U16: 
      {
         mplay_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_U24: 
      {
         mplay_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_U32: 
      {
         mplay_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_U64: 
      {
         mplay_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_S8: 
      {
         mplay_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_S16: 
      {
         mplay_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_S24: 
      {
         mplay_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_S32: 
      {
         mplay_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_S64: 
      {
         mplay_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_F32: 
      {
         mplay_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_F64: 
      {
         mplay_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_BOOL: 
      {
         mplay_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_STRING: 
      {
         mplay_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         mplay_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERMOUNTCDROMINTERNALMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEREJECTOPTICALDISCMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDTELEMATICSBOXMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERSETCONFIGURATIONVALUEMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETCONFIGURATIONVALUEMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERADDEXTERNALHUBMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETDEVPROPERTIESMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODSTART:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERGETALLCONNECTEDDEVICESMETHODRESULT:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONRELUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONGET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCONNECTIONSTATUS:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDRELUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDGET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSDCARDSTATUS:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDRELUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDGET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGEROVERTEMPCDSTATUS:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVERELUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVEGET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERTELEMATICSBOXALIVESTATUS:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCRELUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCGET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYSLOTSTATEOPTICALDISCSTATUS:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFORELUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOGET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERNOTIFYCDINFOSTATUS:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSET:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFORELUPREG:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOSTATUS:
      case mplay_devicemanagerfi_tclToken::EN_MSG_DEVMANAGERDVDDRIVEINFOUPREG:
         (tVoid) bInitMessage(enToken);
         break;
      case mplay_devicemanagerfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         mplay_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_EJECTOPTICALDISC_METHODRESULT:
      {
         mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult o_e8_EjectOpticalDisc_MethodResult;
         if (!bDoIt(o_e8_EjectOpticalDisc_MethodResult))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_SLOTSTATEOPTICALDISCTYPE:
      {
         mplay_fi_tcl_e8_SlotStateOpticalDiscType o_e8_SlotStateOpticalDiscType;
         if (!bDoIt(o_e8_SlotStateOpticalDiscType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_EJECTPARMTYPE:
      {
         mplay_fi_tcl_e8_EjectParmType o_e8_EjectParmType;
         if (!bDoIt(o_e8_EjectParmType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8DEVICESTATE:
      {
         mplay_fi_tcl_e8DeviceState o_e8DeviceState;
         if (!bDoIt(o_e8DeviceState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_CDINFO:
      {
      if (poVisitor->bDoExpand_e8_CDInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8DEVICESTATE,mplay_devicemanagerfi_tclSemanticDomain::EN_E8DEVICESTATE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_DRIVEVERSION));
      }
      else
      {
         mplay_fi_tcl_e8_CDInfo o_e8_CDInfo;
         if (!bDoIt(o_e8_CDInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e8_CDInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_e8_CDInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_DEVICECONNECTSTATUS:
      {
         mplay_fi_tcl_e8_DeviceConnectStatus o_e8_DeviceConnectStatus;
         if (!bDoIt(o_e8_DeviceConnectStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_DEVICE:
      {
         mplay_fi_tcl_e8_Device o_e8_Device;
         if (!bDoIt(o_e8_Device))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_PORTSTATES:
      {
      if (poVisitor->bDoExpand_DevManager_PortStates(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_USBPORTNO));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_USBPOWERON));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_USBPORTCONFIGUREDUSED));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_UNDERVOLTAGE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_OVERCURRENT));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_OPENCIRCUIT));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_HUBCONNECTED));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_ELECTRICALFAILURE));
      }
      else
      {
         mplay_fi_tcl_DevManager_PortStates o_DevManager_PortStates;
         if (!bDoIt(o_DevManager_PortStates))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_PortStates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_PortStates.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_DVM_CARDIDENTIFIERREGISTER:
      {
      if (poVisitor->bDoExpand_DVM_CardIdentifierRegister(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_CID));
      }
      else
      {
         mplay_fi_tcl_DVM_CardIdentifierRegister o_DVM_CardIdentifierRegister;
         if (!bDoIt(o_DVM_CardIdentifierRegister))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DVM_CardIdentifierRegister.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DVM_CardIdentifierRegister.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_DVM_MEDIASTATE:
      {
         mplay_fi_tcl_e8_DVM_MediaState o_e8_DVM_MediaState;
         if (!bDoIt(o_e8_DVM_MediaState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_DVM_DEVICESPEEDUSB:
      {
         mplay_fi_tcl_e8_DVM_DeviceSpeedUsb o_e8_DVM_DeviceSpeedUsb;
         if (!bDoIt(o_e8_DVM_DeviceSpeedUsb))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_DVM_UNSUPPORTEDREASON:
      {
         mplay_fi_tcl_e8_DVM_UnsupportedReason o_e8_DVM_UnsupportedReason;
         if (!bDoIt(o_e8_DVM_UnsupportedReason))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_FILESYSTEM:
      {
         mplay_fi_tcl_e8_FileSystem o_e8_FileSystem;
         if (!bDoIt(o_e8_FileSystem))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_DVM_MEDIATYPE:
      {
         mplay_fi_tcl_e8_DVM_MediaType o_e8_DVM_MediaType;
         if (!bDoIt(o_e8_DVM_MediaType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_POWERSTATUS:
      {
         mplay_fi_tcl_e8_PowerStatus o_e8_PowerStatus;
         if (!bDoIt(o_e8_PowerStatus))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY:
      {
      if (poVisitor->bDoExpand_DevManager_DeviceProperty(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICENODE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICEPATH));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_SUBCLASSCODEUSB));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_PROTOCOLUSB));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_PARITIONNUM));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_BASECLASSCODEUSB));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U64,mplay_devicemanagerfi_tclSemanticDomain::EN_USEDSIZE_KB));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U64,mplay_devicemanagerfi_tclSemanticDomain::EN_TOTALSIZE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U64,mplay_devicemanagerfi_tclSemanticDomain::EN_TOTALSIZE_KB));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U64,mplay_devicemanagerfi_tclSemanticDomain::EN_FREESIZE_KB));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U16,mplay_devicemanagerfi_tclSemanticDomain::EN_VENDORID));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U16,mplay_devicemanagerfi_tclSemanticDomain::EN_PRODUCTID));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_USBPORTNO));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_MOUNTPOINT));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_MANUFACTURER));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICEVERSION));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICESERIALNO));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICENAME));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_ACCESSORYNAME));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_ACCESSORYNAME2));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_FILESYSTEM,mplay_devicemanagerfi_tclSemanticDomain::EN_FILESYSTEMTYPE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_DVM_UNSUPPORTEDREASON,mplay_devicemanagerfi_tclSemanticDomain::EN_UNSUPPORTEDREASON));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_DVM_DEVICESPEEDUSB,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICESPEEDUSB));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_DEVICE,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICETYPE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_DEVICECONNECTSTATUS,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICECONNECTSTATUS));
      }
      else
      {
         mplay_fi_tcl_DevManager_DeviceProperty o_DevManager_DeviceProperty;
         if (!bDoIt(o_DevManager_DeviceProperty))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_DeviceProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_DeviceProperty.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVINFOSTR:
      {
      if (poVisitor->bDoExpand_DevManager_DevInfoStr(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_DEVICEPROPERTY,mplay_devicemanagerfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_LIST,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVLIST));
      }
      else
      {
         mplay_fi_tcl_DevManager_DevInfoStr o_DevManager_DevInfoStr;
         if (!bDoIt(o_DevManager_DevInfoStr))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_DevInfoStr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_DevInfoStr.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_DEVMANAGER_SDCARDINFO:
      {
      if (poVisitor->bDoExpand_DevManager_SDCardInfo(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_END_OF_STRUCT,mplay_devicemanagerfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_SDCARDSLOT));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVSPECVERSION));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U8,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVMANUFACTUREID));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U64,mplay_devicemanagerfi_tclSemanticDomain::EN_TOTALSIZE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_U32,mplay_devicemanagerfi_tclSemanticDomain::EN_DEVICESERIALNO));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_STRING,mplay_devicemanagerfi_tclSemanticDomain::EN_MOUNTPOINT));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_SW_WRITEPROTECTED));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_MOUNTED));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_BOOL,mplay_devicemanagerfi_tclSemanticDomain::EN_HW_WRITEPROTECTED));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_POWERSTATUS,mplay_devicemanagerfi_tclSemanticDomain::EN_POWERSTATUS));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_DVM_MEDIATYPE,mplay_devicemanagerfi_tclSemanticDomain::EN_SDCARDMEDIA));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_E8_DVM_MEDIASTATE,mplay_devicemanagerfi_tclSemanticDomain::EN_SDCARDSTATE));
         (tVoid) oPath.bGoDown(mplay_devicemanagerfi_tclKnot(mplay_devicemanagerfi_tclToken::EN_DVM_CARDIDENTIFIERREGISTER,mplay_devicemanagerfi_tclSemanticDomain::EN_CARDIDENTIFIERREGISTER));
      }
      else
      {
         mplay_fi_tcl_DevManager_SDCardInfo o_DevManager_SDCardInfo;
         if (!bDoIt(o_DevManager_SDCardInfo))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_SDCardInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_DevManager_SDCardInfo.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_SETTINGSMODE:
      {
         mplay_fi_tcl_e8_SettingsMode o_e8_SettingsMode;
         if (!bDoIt(o_e8_SettingsMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_MDVDDISCTYPE:
      {
         mplay_fi_tcl_e8_MDVDDiscType o_e8_MDVDDiscType;
         if (!bDoIt(o_e8_MDVDDiscType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_E8_MDVDDRIVEMODE:
      {
         mplay_fi_tcl_e8_MDVDDriveMode o_e8_MDVDDriveMode;
         if (!bDoIt(o_e8_MDVDDriveMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case mplay_devicemanagerfi_tclToken::EN_UNKNOWN:
      case mplay_devicemanagerfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

