/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MPLAY_APPCONTROLFITYPES_HEADER
#define MPLAY_APPCONTROLFITYPES_HEADER


class mplay_appcontrolfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for mplay_appcontrol_fi message types

fi_tclMessageBase* mplay_appcontrolfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class mplay_appcontrolfi_tclMsgBaseMessage : public mplay_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   mplay_appcontrolfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class mplay_appcontrolfi_tclMsgConnectMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgConnectMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgConnectMethodStart& operator=(const mplay_appcontrolfi_tclMsgConnectMethodStart& coRef);
   mplay_appcontrolfi_tclMsgConnectMethodStart(const mplay_appcontrolfi_tclMsgConnectMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   mplay_fi_tclString szProtocol;
   mplay_fi_tclString szBundleSeedID;
   mplay_fi_tclString szAppName;
   mplay_fi_tcl_e8_AppLaunchOption e8AppLaunchOption;
   virtual ~mplay_appcontrolfi_tclMsgConnectMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgConnectMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgConnectMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgConnectMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgConnectMethodResult& operator=(const mplay_appcontrolfi_tclMsgConnectMethodResult& coRef);
   mplay_appcontrolfi_tclMsgConnectMethodResult(const mplay_appcontrolfi_tclMsgConnectMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   tU16 u16SessionId;
   mplay_fi_tclString szAppName;
   virtual ~mplay_appcontrolfi_tclMsgConnectMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgConnectMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgCommandMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgCommandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgCommandMethodStart& operator=(const mplay_appcontrolfi_tclMsgCommandMethodStart& coRef);
   mplay_appcontrolfi_tclMsgCommandMethodStart(const mplay_appcontrolfi_tclMsgCommandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   mplay_fi_tclString szAppName;
   tU16 u16SessionId;
   mplay_fi_tcl_BinContainer au8CommandBuffer;
   virtual ~mplay_appcontrolfi_tclMsgCommandMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgCommandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgCommandMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgCommandMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgCommandMethodResult& operator=(const mplay_appcontrolfi_tclMsgCommandMethodResult& coRef);
   mplay_appcontrolfi_tclMsgCommandMethodResult(const mplay_appcontrolfi_tclMsgCommandMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   mplay_fi_tclString szAppName;
   tU16 u16SessionId;
   mplay_fi_tcl_BinContainer au8CommandResponseBuffer;
   virtual ~mplay_appcontrolfi_tclMsgCommandMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgCommandMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgCloseMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgCloseMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgCloseMethodStart& operator=(const mplay_appcontrolfi_tclMsgCloseMethodStart& coRef);
   mplay_appcontrolfi_tclMsgCloseMethodStart(const mplay_appcontrolfi_tclMsgCloseMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   mplay_fi_tclString szAppName;
   tU16 u16SessionId;
   virtual ~mplay_appcontrolfi_tclMsgCloseMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgCloseMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgCloseMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgCloseMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgCloseMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgCloseMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgStartAudioMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgStartAudioMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgStartAudioMethodStart& operator=(const mplay_appcontrolfi_tclMsgStartAudioMethodStart& coRef);
   mplay_appcontrolfi_tclMsgStartAudioMethodStart(const mplay_appcontrolfi_tclMsgStartAudioMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   virtual ~mplay_appcontrolfi_tclMsgStartAudioMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgStartAudioMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgStartAudioMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgStartAudioMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgStartAudioMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgStartAudioMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgStopAudioMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgStopAudioMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgStopAudioMethodStart& operator=(const mplay_appcontrolfi_tclMsgStopAudioMethodStart& coRef);
   mplay_appcontrolfi_tclMsgStopAudioMethodStart(const mplay_appcontrolfi_tclMsgStopAudioMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   virtual ~mplay_appcontrolfi_tclMsgStopAudioMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgStopAudioMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgStopAudioMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgStopAudioMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgStopAudioMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgStopAudioMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   tBool bDiPOActive;
   virtual ~mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiPOResponse e8DiPOResponse;
   virtual ~mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOActiveDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tcl_e8_DiPORoleStatus e8DiPORoleStatus;
   mplay_fi_tcl_AppInfo oAppInfo;
   virtual ~mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiPOResponse e8DiPOResponse;
   mplay_fi_tclString sDeviceUSBSerialNumber;
   virtual ~mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORoleSwitchRequestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sAlbumArt;
   virtual ~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sMIMEImageSubtype;
   tU32 u32PhotoSize;
   virtual ~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sAlbumArt;
   virtual ~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiPOImageData oImageData;
   virtual ~mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGetMediaObjectAlbumArtMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tclString sGPGGAData;
   mplay_fi_tclString sGPRMCData;
   mplay_fi_tclString sGPGSVData;
   mplay_fi_tclString sGPHDTData;
   virtual ~mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiPOResponse e8DiPOResponse;
   virtual ~mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOTransferGPSDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tclString sPASCDData;
   mplay_fi_tclString sPAGCDData;
   mplay_fi_tclString sPAACDData;
   virtual ~mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiPOResponse e8DiPOResponse;
   virtual ~mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOTransferDRDataMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceName;
   mplay_fi_tcl_e8_AudioError e8Error;
   virtual ~mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORequestAudioDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_AudioError e8Error;
   virtual ~mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOReleaseAudioDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart(const mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_DiPOPlaypackAction e8Action;
   tU8 u8NextPrevSkipCount;
   virtual ~mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORequestPlaybackActionMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart(const mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceBTMacAddress;
   virtual ~mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStartIAP2OverCarPlayWifiMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   tU16 u16RouteGuidanceDisplayComponentID;
   tBool SourceName;
   tBool SourceSupportsRouteGuidance;
   virtual ~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidanceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   tU16 u16RouteGuidanceDisplayComponentID;
   virtual ~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidanceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSwapCallsMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSwapCallsMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgSwapCallsMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgSwapCallsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSwapCallsMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSwapCallsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgSwapCallsMethodStart& operator=(const mplay_appcontrolfi_tclMsgSwapCallsMethodStart& coRef);
   mplay_appcontrolfi_tclMsgSwapCallsMethodStart(const mplay_appcontrolfi_tclMsgSwapCallsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   virtual ~mplay_appcontrolfi_tclMsgSwapCallsMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgSwapCallsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart(const mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_RouteGuidanceDisplayComponents RouteGuidanceDisplayComponents;
   virtual ~mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSetRouteGuidanceDisplayComponentInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tcl_RouteGuidanceDisplayComponentIDs RouteGuidanceDisplayComponentIDs;
   virtual ~mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStopRouteGuidance2MethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tcl_RouteGuidanceDisplayComponentIDs RouteGuidanceDisplayComponentIDs;
   tBool SourceName;
   tBool SourceSupportsRouteGuidance;
   virtual ~mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOStartRouteGuidance2MethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart(const mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_CallControlsConfiguration callControlsConfiguration;
   virtual ~mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSetCallControlsConfigurationMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart(const mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   mplay_fi_tcl_e_InitiateCallType type;
   mplay_fi_tcl_e_InitiateCallService service;
   mplay_fi_tclString destinationID;
   mplay_fi_tclString addressBookID;
   virtual ~mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOInitiateCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart(const mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   mplay_fi_tcl_e_AcceptAction acceptAction;
   mplay_fi_tclString callUUID;
   virtual ~mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOAcceptCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOEndCallMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart(const mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   mplay_fi_tcl_e_EndAction endAction;
   mplay_fi_tclString callUUID;
   virtual ~mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOEndCallMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart(const mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   virtual ~mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMergeCallsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart(const mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   tBool holdStatus;
   mplay_fi_tclString callUUID;
   virtual ~mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOHoldStatusUpdateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart(const mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   tBool muteStatus;
   virtual ~mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMuteStatusUpdateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart(const mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   mplay_fi_tcl_e_SendDTMFTone tone;
   mplay_fi_tclString callUUID;
   virtual ~mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSendDTMFMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult();

   virtual ~mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart(const mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString deviceUSBSerialNumber;
   virtual ~mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSwapCallsMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString ProductPlanUUID;
   virtual ~mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_e8_DiPOResponse e8DiPOResponse;
   virtual ~mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOSetAppleIdentificationInfoMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& operator=(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& coRef);
   mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRequestAction;
   virtual ~mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& operator=(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& coRef);
   mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRequestStatus;
   virtual ~mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORequestBluetoothAudioDeviceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDataResponseUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDataResponseUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDataResponseUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDataResponseUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDataResponseRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDataResponseRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDataResponseRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDataResponseRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDataResponseGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDataResponseGet();

   virtual ~mplay_appcontrolfi_tclMsgDataResponseGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDataResponseGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDataResponseStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDataResponseStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDataResponseStatus& operator=(const mplay_appcontrolfi_tclMsgDataResponseStatus& coRef);
   mplay_appcontrolfi_tclMsgDataResponseStatus(const mplay_appcontrolfi_tclMsgDataResponseStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   mplay_fi_tclString szAppName;
   tU16 u16SessionId;
   mplay_fi_tcl_BinContainer au8CommandResponseBuffer;
   virtual ~mplay_appcontrolfi_tclMsgDataResponseStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDataResponseStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionOpenedUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionOpenedUpReg();

   virtual ~mplay_appcontrolfi_tclMsgSessionOpenedUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgSessionOpenedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgSessionOpenedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionOpenedGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionOpenedGet();

   virtual ~mplay_appcontrolfi_tclMsgSessionOpenedGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgSessionOpenedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionOpenedStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionOpenedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgSessionOpenedStatus& operator=(const mplay_appcontrolfi_tclMsgSessionOpenedStatus& coRef);
   mplay_appcontrolfi_tclMsgSessionOpenedStatus(const mplay_appcontrolfi_tclMsgSessionOpenedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   mplay_fi_tclString szAppName;
   tU16 u16SessionId;
   mplay_fi_tclString szProtocolName;
   virtual ~mplay_appcontrolfi_tclMsgSessionOpenedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgSessionOpenedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionClosedUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionClosedUpReg();

   virtual ~mplay_appcontrolfi_tclMsgSessionClosedUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgSessionClosedUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionClosedRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionClosedRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgSessionClosedRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgSessionClosedRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionClosedGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionClosedGet();

   virtual ~mplay_appcontrolfi_tclMsgSessionClosedGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgSessionClosedGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgSessionClosedStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgSessionClosedStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgSessionClosedStatus& operator=(const mplay_appcontrolfi_tclMsgSessionClosedStatus& coRef);
   mplay_appcontrolfi_tclMsgSessionClosedStatus(const mplay_appcontrolfi_tclMsgSessionClosedStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString szDeviceId;
   mplay_fi_tclString szAppName;
   tU16 u16SessionId;
   virtual ~mplay_appcontrolfi_tclMsgSessionClosedStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgSessionClosedStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& operator=(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_DiPODeviceInfo oDeviceInfo;
   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaytimeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaytimeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaytimeGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaytimeGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaytimeGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaytimeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus(const mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   tU32 u32ElapsedPlaytime;
   tU32 u32TotalPlaytime;
   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaytimeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOLocationInfoUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOLocationInfoRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOLocationInfoGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOLocationInfoGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOLocationInfoGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOLocationInfoGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus(const mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStartStopLocationInfo;
   mplay_fi_tcl_b8_DiPOLocationInfoType b8LocationInfoType;
   virtual ~mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOLocationInfoStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMetaDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMetaDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMetaDataGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMetaDataGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOMetaDataGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMetaDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOMetaDataStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOMetaDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOMetaDataStatus(const mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tclString sArtist;
   mplay_fi_tclString sTitle;
   mplay_fi_tclString sAlbum;
   mplay_fi_tclString sGenre;
   mplay_fi_tclString sAlbumArt;
   mplay_fi_tclString sAppName;
   virtual ~mplay_appcontrolfi_tclMsgDiPOMetaDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOMetaDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPhoneDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPhoneDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPhoneDataGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPhoneDataGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPhoneDataGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPhoneDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus(const mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sPhoneCaller;
   mplay_fi_tclString sPhoneCallInfo;
   virtual ~mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPhoneDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStartUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStartUpReg();

   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStartUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStartUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStartRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStartGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStartGet();

   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStartGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStartGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStartStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStartStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgNativeTransportStartStatus& operator=(const mplay_appcontrolfi_tclMsgNativeTransportStartStatus& coRef);
   mplay_appcontrolfi_tclMsgNativeTransportStartStatus(const mplay_appcontrolfi_tclMsgNativeTransportStartStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceId;
   tU8 u8IAP2iOSAppIdentifier;
   tU8 u8SinkEndpoint;
   tU8 u8SourceEndpoint;
   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStartStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStartStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStopUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStopUpReg();

   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStopUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStopUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStopRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStopGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStopGet();

   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStopGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStopGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgNativeTransportStopStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgNativeTransportStopStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgNativeTransportStopStatus& operator=(const mplay_appcontrolfi_tclMsgNativeTransportStopStatus& coRef);
   mplay_appcontrolfi_tclMsgNativeTransportStopStatus(const mplay_appcontrolfi_tclMsgNativeTransportStopStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceId;
   tU8 u8IAP2iOSAppIdentifier;
   tU8 u8SinkEndpoint;
   tU8 u8SourceEndpoint;
   virtual ~mplay_appcontrolfi_tclMsgNativeTransportStopStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgNativeTransportStopStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg();

   virtual ~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet();

   virtual ~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& operator=(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& coRef);
   mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tcl_BTProfileInfo oBTProfileInfo;
   virtual ~mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgConnectedBluetoothProfilesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPONowPlayingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPONowPlayingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPONowPlayingGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPONowPlayingGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPONowPlayingGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPONowPlayingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPONowPlayingStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPONowPlayingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& operator=(const mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPONowPlayingStatus(const mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tclString sTitle;
   mplay_fi_tclString sArtist;
   mplay_fi_tclString sAlbum;
   mplay_fi_tclString sGenre;
   mplay_fi_tclString sComposer;
   mplay_fi_tclString sAlbumArt;
   mplay_fi_tclString sAppName;
   tU16 u16AlbumTrackNumber;
   tU16 u16AlbumTrackCount;
   tU16 u16AlbumDiscNumber;
   tU16 u16AlbumDiscCount;
   tU16 u16ChapterCount;
   tU32 u32QueueIndex;
   tU32 u32QueueCount;
   tU32 u32QueueChapterIndex;
   tBool biTunesRadioAd;
   mplay_fi_tclString siTunesRadioStationName;
   virtual ~mplay_appcontrolfi_tclMsgDiPONowPlayingStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPONowPlayingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tcl_e8_DiPOPlaybackStatus e8State;
   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tcl_e8_DiPOPlaybackShuffleMode e8Mode;
   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackShuffleModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tcl_e8_DiPOPlaybackRepeatMode e8Mode;
   virtual ~mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPlaybackRepeatModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallStateUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallStateUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCallStateUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallStateGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallStateGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCallStateGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallStateStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOCallStateStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOCallStateStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOCallStateStatus(const mplay_appcontrolfi_tclMsgDiPOCallStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tcl_DiPOCallStateUpdate oCallStateUpdate;
   virtual ~mplay_appcontrolfi_tclMsgDiPOCallStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationsUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationsRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationsGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationsGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationsGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationsGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus(const mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tcl_e8_DiPOCommunicationsUpdateSignalStrength eSignalStrength;
   mplay_fi_tcl_e8_DiPOCommunicationsUpdateRegistrationStatus eRegistrationStatus;
   tBool bAirplaneModeStatus;
   mplay_fi_tclString sCarrierName;
   tBool bCellularSupported;
   tBool bTelephonyEnabled;
   tBool bFaceTimeAudioEnabled;
   tBool bFaceTimeVideoEnabled;
   tBool bMuteStatus;
   tU8 u8CurrentCallCount;
   tU8 u8NewVoicemailCount;
   tBool bInitiateCallAvalable;
   tBool bEndAndAcceptAvailable;
   tBool bHoldAndAcceptAvailable;
   tBool bSwapAvailable;
   tBool bMergeAvailable;
   tBool bHoldAvailable;
   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationsStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceTag;
   mplay_fi_tcl_e8_DiPOCommunicationError e8DiPOCommunicationError;
   mplay_fi_tclString sDeviceUSBSerialNumber;
   virtual ~mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCommunicationErrorStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallDurationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallDurationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallDurationGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallDurationGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOCallDurationGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallDurationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOCallDurationStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOCallDurationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOCallDurationStatus(const mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   tU32 u32CallDuration;
   virtual ~mplay_appcontrolfi_tclMsgDiPOCallDurationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOCallDurationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPowerUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPowerUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPowerUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPowerUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPowerRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPowerGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPowerGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOPowerGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPowerGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOPowerStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOPowerStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOPowerStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOPowerStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOPowerStatus(const mplay_appcontrolfi_tclMsgDiPOPowerStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   tU16 u16BatteryChargeLevel;
   mplay_fi_tcl_e8_AccessoryPowerMode e8AccessoryPowerMode;
   tU16 u16MaximumCurrentDrawnFromAccessory;
   tBool bDeviceBatteryWillChargeIfPowerIsPresent;
   mplay_fi_tcl_e8_BatteryChargingState e8BatteryChargingState;
   tBool bIsExternalChargerConnected;
   virtual ~mplay_appcontrolfi_tclMsgDiPOPowerStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOPowerStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   tU16 u16RouteGuidanceDisplayComponentID;
   mplay_fi_tcl_e8_RouteGuidanceState e8RouteGuidanceState;
   mplay_fi_tcl_e8_ManeuverState e8ManeuverState;
   mplay_fi_tclString szCurrentRoadName;
   mplay_fi_tclString szDestinationName;
   tU64 u64EstimatedTimeOfArrival;
   tU64 u64TimeRemainingToDestination;
   tU32 u32DistanceRemaining;
   mplay_fi_tclString szDistanceRemainingDisplayStr;
   mplay_fi_tcl_e8_DistanceDisplayUnits e8DistanceRemainingDisplayUnits;
   tU32 u32DistanceToNextManeuver;
   mplay_fi_tclString szDistanceToNextManeuverDisplayStr;
   mplay_fi_tcl_e8_DistanceDisplayUnits e8DistanceToNextManeuverDisplayUnits;
   mplay_fi_tcl_RouteGuidanceManeuverCurrentList u16RouteGuidanceManeuverCurrentList;
   tU16 u16RouteGuidanceManeuverCount;
   tBool bIsRouteGuidanceVisibleInApp;
   mplay_fi_tclString SourceName;
   tBool SourceSupportsRouteGuidance;
   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   tU16 u16RouteGuidanceDisplayComponentID;
   tU16 u16Index;
   mplay_fi_tclString szManeuverDescription;
   mplay_fi_tcl_e8_ManeuverType e8ManeuverType;
   mplay_fi_tclString szAfterManeuverRoadName;
   tU32 u32DistanceBetweenManeuver;
   mplay_fi_tclString szDistanceBetweenManeuverDisplayStr;
   mplay_fi_tcl_e8_DistanceDisplayUnits e8DistanceBetweenManeuverDisplayUnits;
   mplay_fi_tcl_e8_DrivingSide e8DrivingSide;
   mplay_fi_tcl_e8_JunctionType e8JunctionType;
   tS16 s16JunctionElementAngle;
   tS16 s16JunctionElementExitAngle;
   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuverStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DeviceId;
   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tcl_b8_DiPOGPRMCDataStatusValues b8GPRMCDataStatusValues;
   virtual ~mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOGPRMCDataStatusValuesStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& coRef);
   mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tcl_RouteGuidanceUpdate RouteGuidanceUpdate;
   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidance2Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get();

   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& operator=(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& coRef);
   mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tcl_RouteGuidanceManeuverUpdate RouteGuidanceManeuverUpdate;
   virtual ~mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPORouteGuidanceManeuver2Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& operator=(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bAudioDeviceStatus;
   virtual ~mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPOBluetoothAudioDeviceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg();

   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet();

   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet();

   inline tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus : public mplay_appcontrolfi_tclMsgBaseMessage
{
public:

   mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& operator=(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& coRef);
   mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   mplay_fi_tclString sDeviceUSBSerialNumber;
   mplay_fi_tcl_DeviceTimeUpdate DeviceTimeUpdate;
   virtual ~mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const mplay_appcontrolfi_tclMsgDiPODeviceTimeUpdateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
