/* Description and history of most_defines_p.h at the end of the file.             */
#ifndef MOST_DEFINES_P_HEADER
/** File name for preprozessor commands */
#define MOST_DEFINES_P_HEADER

/* no further includes allowed */

#else /* MOST_DEFINES_P_HEADER already defined */
  #error MOST_DEFINES_P.H included several times
#endif
/*******************************************************************************
 *                MODULE GROUPING INFORMATION FOR DOXYGEN
 * \doxydocu
 *
 * \defgroup      
 *******************************************************************************/

/* --------------------------------------------------------------------------- 
*  In the following part project specific MOST definitions can be given to be 
*  accessible in the whole project 
--------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------- 
*  Additional ErrorCode 0x42 Processing Error, 
*  see https://hi-cmts.apps.intranet.bosch.com:8443/browse/GMNGA-44100
--------------------------------------------------------------------------- */
#ifndef FI_EN_PROCESSINGERROR
  #define FI_EN_PROCESSINGERROR 66U
#else
  #error FI_EN_PROCESSINGERROR redefined
#endif

/* --------------------------------------------------------------------------- 
*  Additional ErrorInfo according to MOST Specification Rev. 3.0 E2, 07/2010 
*  (https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-197032)
--------------------------------------------------------------------------- */

/* For ErrorCode 0x0C Segmentation Error (according to chapter 2.2.3.5.1 Error): */
#ifndef MOST_FI_C_FIRST_SEGMENT_MISSING
  #define MOST_FI_C_FIRST_SEGMENT_MISSING             0x01
#else
  #error MOST_FI_C_FIRST_SEGMENT_MISSING redefined
#endif

#ifndef MOST_FI_C_TARGET_BUFFER_SIZE
  #define MOST_FI_C_TARGET_BUFFER_SIZE                0x02
#else
  #error MOST_FI_C_TARGET_BUFFER_SIZE redefined
#endif

#ifndef MOST_FI_C_UNEXPECTED_SEGMENT_NUMBER
  #define MOST_FI_C_UNEXPECTED_SEGMENT_NUMBER         0x03
#else
  #error MOST_FI_C_UNEXPECTED_SEGMENT_NUMBER redefined
#endif

#ifndef MOST_FI_C_SEGMENTATION_MESSAGES_PENDING
  #define MOST_FI_C_SEGMENTATION_MESSAGES_PENDING     0x04
#else
  #error MOST_FI_C_SEGMENTATION_MESSAGES_PENDING redefined
#endif

#ifndef MOST_FI_C_SEGMENT_TIMEOUT
  #define MOST_FI_C_SEGMENT_TIMEOUT                   0x05
#else
  #error MOST_FI_C_SEGMENT_TIMEOUT redefined
#endif

#ifndef MOST_FI_C_NO_SEGMENTED_MESSAGES_SUPPORT
  #define MOST_FI_C_NO_SEGMENTED_MESSAGES_SUPPORT     0x06
#else
  #error MOST_FI_C_NO_SEGMENTED_MESSAGES_SUPPORT redefined
#endif

#ifndef MOST_FI_C_SEGMENTED_MESSAGE_ALREADY_PENDING
  #define MOST_FI_C_SEGMENTED_MESSAGE_ALREADY_PENDING 0x07
#else
  #error MOST_FI_C_SEGMENTED_MESSAGE_ALREADY_PENDING redefined
#endif

/* For FktID Notification (according to chapter 2.2.5 Handling Message Notification, paragraph Error handling": */
#ifndef MOST_FI_C_NOTIFICATION_GET_NOT_POSSIBLE
  #define MOST_FI_C_NOTIFICATION_GET_NOT_POSSIBLE                 0x01
#else
  #error MOST_FI_C_NOTIFICATION_GET_NOT_POSSIBLE redefined
#endif

#ifndef MOST_FI_C_NOTIFICATION_SET_REJECTED
  #define MOST_FI_C_NOTIFICATION_SET_REJECTED                     0x10
#else
  #error MOST_FI_C_NOTIFICATION_SET_REJECTED redefined
#endif

#ifndef MOST_FI_C_FBLOCK_NOT_REGISTERED_IN_NOTIFICATION_SERVICE
  #define MOST_FI_C_FBLOCK_NOT_REGISTERED_IN_NOTIFICATION_SERVICE 0x20
#else
  #error MOST_FI_C_FBLOCK_NOT_REGISTERED_IN_NOTIFICATION_SERVICE redefined
#endif

#ifndef MOST_FI_C_NO_MORE_REGISTRATION_POSSIBLE
  #define MOST_FI_C_NO_MORE_REGISTRATION_POSSIBLE                 0x21
#else
  #error MOST_FI_C_NO_MORE_REGISTRATION_POSSIBLE redefined
#endif

/* --------------------------------------------------------------------------- 
*  ErrorInfo according to MOST FBlock Template GeneralFBlock Rev 3.0.3, 03/2011 
*  (https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-268920):
--------------------------------------------------------------------------- */

/* For FktID NotificationCheck (according to chapter 2.1.3 NotificationCheck (0x002)): */
#ifndef MOST_FI_C_BUFFER_OVERFLOW
  #define MOST_FI_C_BUFFER_OVERFLOW           0x01
#else
  #error MOST_FI_C_BUFFER_OVERFLOW redefined
#endif

#ifndef MOST_FI_C_DEVICE_ID_NOT_REGISTERED
  #define MOST_FI_C_DEVICE_ID_NOT_REGISTERED  0x08
#else
  #error MOST_FI_C_DEVICE_ID_NOT_REGISTERED redefined
#endif

#ifndef MOST_FI_C_FBLOCK_NOT_REGISTERED
  #define MOST_FI_C_FBLOCK_NOT_REGISTERED     0x20
#else
  #error MOST_FI_C_FBLOCK_NOT_REGISTERED redefined
#endif

/*******************************************************************************
 * \doxydocu
 * \file          most_defines_p.h
 * \brief         Interface header for project specific MOST definitions.
 *
 * \see           
 *
 * \sw_component  MOST_FI
 * \project       
 * \path          
 *
 * \ingroup       
 *
 * \authors       CM-AI/PJ-CD58-Pistoor
 *
 * COPYRIGHT      (c) 2011 Robert Bosch Car Multimedia GmbH
 *
 * \history_begin
 *
 * 31.07.11  main\1  CM-AI/PJ-CD58-Pistoor
 * - Initial revision.
 *
 * \history_end
 *//**** END OF FILE **********************************************************/
