
///////////////////////////////////////////////////////////////////////////////
//
// special version including MOST compatible types
//
// implementation omitted intentionally for 
// bool, U8, U16, U24, U32, S8, S16, S24, S32, list and multilanguage string
//
///////////////////////////////////////////////////////////////////////////////

#ifdef OSAL_CONF
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>
#else
#include <myosal.h>
#endif

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "most_fi_if.h"
#include "allvisitor.h"

// #define FIDEBUG 
#ifdef FIDEBUG
// #include <iostream>
#endif

/* deleted, since it is now in the fitypes.h to avoid unneccessary dependencies for the common_fi.lib
tVoid figroup_fi_tclTypeBase::vTakeVisitor(figroup_fi_tclVisitorBase& oVisitor) {
   oVisitor.vInvalidate();
}
*/

// --Implementierungen der Methoden der Besucher-Basisklasse
// --Alle Besuchmethoden setzen den Status des Objektes auf ungueltig.

tVoid most_fi_tclVisitorBase::vVisitU8(most_fi_tclU8& /*oU8*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitU8 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclU8::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitU8(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitS8(most_fi_tclS8& /*oS8*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitS8 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclS8::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitS8(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitU16(most_fi_tclU16& /*oU16*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitU16 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclU16::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitU16(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitS16(most_fi_tclS16& /*oS16*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitS16 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclS16::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitS16(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitU32(most_fi_tclU32& /*oU32*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitU32 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclU32::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitU32(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitS32(most_fi_tclS32& /*oS32*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitS32 not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclS32::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitS32(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisitBool(most_fi_tclBool& /*oBool*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisitBool not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}

tVoid most_fi_tclBool::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
	oVisitor.vVisitBool(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_String(most_fi_tcl_String& /*oString*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_String::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_String(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_TrailingStream(most_fi_tcl_TrailingStream& /*oContainer*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_TrailingStream::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_TrailingStream(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_ShortStream(most_fi_tcl_ShortStream& /*oContainer*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_ShortStream::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_ShortStream(*this);
}

//------------------------------------------------------------------------------------

tVoid most_fi_tclVisitorBase::vVisit_ClassifiedStream(most_fi_tcl_ClassifiedStream& /*oContainer*/) {
#ifdef FIDEBUG
  RTF_M_TRACE("vVisit_String not implemented for specialized visitor!\n");
#endif
  // bIsVisitorValid=FALSE;
}
tVoid most_fi_tcl_ClassifiedStream::vTakeVisitor(most_fi_tclVisitorBase& oVisitor) {
   oVisitor.vVisit_ClassifiedStream(*this);
}

//------------------------------------------------------------------------------------

most_fi_tclOutput::most_fi_tclOutput()
{
}

tVoid most_fi_tclFileOutput::vPrintLine(tCString coszLine)
{
   if (coszLine)
   {
      (void)OSALUTIL_s32FPrintf(fd,"%s",coszLine);
   }
}

most_fi_tclMemOutput::most_fi_tclMemOutput(tU32 u32MemSize)
{
   s8BufPos = 0;
   szEndBuf = 0;
   szBuf = new tChar[u32MemSize];
   if (szBuf)
   {
      s8BufPos = szBuf;
      szEndBuf = szBuf + u32MemSize;
   }
}

most_fi_tclMemOutput::~most_fi_tclMemOutput()
{
   if (szBuf != 0)
   {
      delete[] szBuf;
      szBuf = 0;
   }
   s8BufPos = 0;
   szEndBuf = 0;
}

tString most_fi_tclMemOutput::szGetBuffer()
{
   return szBuf;
}

tVoid most_fi_tclMemOutput::vPrintLine(tCString coszLine)
{
   if ((coszLine) && (szBuf))
   {
      tU32 u32LineLength = OSAL_u32StringLength(coszLine);
      if (s8BufPos && szEndBuf && (s8BufPos + u32LineLength) < szEndBuf)
      {
         (void)OSAL_szStringCopy(s8BufPos,coszLine);
         s8BufPos += u32LineLength;
      }
   }
}
tVoid most_fi_tclVisitorBase::vVisit_e8_ErrorCode(most_fi_tcl_e8_ErrorCode& /*oe8_ErrorCode*/)
{
}
tVoid most_fi_tcl_e8_ErrorCode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ErrorCode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AdPrAsObjectDetectionEventEnum(most_fi_tcl_e8_AdPrAsObjectDetectionEventEnum& /*oe8_AdPrAsObjectDetectionEventEnum*/)
{
}
tVoid most_fi_tcl_e8_AdPrAsObjectDetectionEventEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AdPrAsObjectDetectionEventEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AdPrAsParkInstructionValue(most_fi_tcl_e8_AdPrAsParkInstructionValue& /*oe8_AdPrAsParkInstructionValue*/)
{
}
tVoid most_fi_tcl_e8_AdPrAsParkInstructionValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AdPrAsParkInstructionValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AdPrAsParkInstructionAPA2Value(most_fi_tcl_e8_AdPrAsParkInstructionAPA2Value& /*oe8_AdPrAsParkInstructionAPA2Value*/)
{
}
tVoid most_fi_tcl_e8_AdPrAsParkInstructionAPA2Value::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AdPrAsParkInstructionAPA2Value(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AdPrAsHeaderIconLeftAPA2Value(most_fi_tcl_e8_AdPrAsHeaderIconLeftAPA2Value& /*oe8_AdPrAsHeaderIconLeftAPA2Value*/)
{
}
tVoid most_fi_tcl_e8_AdPrAsHeaderIconLeftAPA2Value::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AdPrAsHeaderIconLeftAPA2Value(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AdPrAsHeaderIconRightAPA2Value(most_fi_tcl_e8_AdPrAsHeaderIconRightAPA2Value& /*oe8_AdPrAsHeaderIconRightAPA2Value*/)
{
}
tVoid most_fi_tcl_e8_AdPrAsHeaderIconRightAPA2Value::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AdPrAsHeaderIconRightAPA2Value(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AdPrAsFooterTextAPA2Value(most_fi_tcl_e8_AdPrAsFooterTextAPA2Value& /*oe8_AdPrAsFooterTextAPA2Value*/)
{
}
tVoid most_fi_tcl_e8_AdPrAsFooterTextAPA2Value::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AdPrAsFooterTextAPA2Value(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AdPrAsInfotainmentSoftButtonFocusValue(most_fi_tcl_e8_AdPrAsInfotainmentSoftButtonFocusValue& /*oe8_AdPrAsInfotainmentSoftButtonFocusValue*/)
{
}
tVoid most_fi_tcl_e8_AdPrAsInfotainmentSoftButtonFocusValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AdPrAsInfotainmentSoftButtonFocusValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AtManDisplayType(most_fi_tcl_e8_AtManDisplayType& /*oe8_AtManDisplayType*/)
{
}
tVoid most_fi_tcl_e8_AtManDisplayType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AtManDisplayType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AtManAckType(most_fi_tcl_e8_AtManAckType& /*oe8_AtManAckType*/)
{
}
tVoid most_fi_tcl_e8_AtManAckType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AtManAckType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AtManPriority(most_fi_tcl_e8_AtManPriority& /*oe8_AtManPriority*/)
{
}
tVoid most_fi_tcl_e8_AtManPriority::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AtManPriority(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AtManButtonAction(most_fi_tcl_e8_AtManButtonAction& /*oe8_AtManButtonAction*/)
{
}
tVoid most_fi_tcl_e8_AtManButtonAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AtManButtonAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManBluetooth_Call_Active_with_Known_Contact(most_fi_tcl_AtManBluetooth_Call_Active_with_Known_Contact& /*oAtManBluetooth_Call_Active_with_Known_Contact*/)
{
}
tVoid most_fi_tcl_AtManBluetooth_Call_Active_with_Known_Contact::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManBluetooth_Call_Active_with_Known_Contact(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManEmail_sent_successfully_alert(most_fi_tcl_AtManEmail_sent_successfully_alert& /*oAtManEmail_sent_successfully_alert*/)
{
}
tVoid most_fi_tcl_AtManEmail_sent_successfully_alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManEmail_sent_successfully_alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManNew_Email_received_alert(most_fi_tcl_AtManNew_Email_received_alert& /*oAtManNew_Email_received_alert*/)
{
}
tVoid most_fi_tcl_AtManNew_Email_received_alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManNew_Email_received_alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManNew_Text_Received_Alert(most_fi_tcl_AtManNew_Text_Received_Alert& /*oAtManNew_Text_Received_Alert*/)
{
}
tVoid most_fi_tcl_AtManNew_Text_Received_Alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManNew_Text_Received_Alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManCall_Ended_With_Known_Contact_Alert(most_fi_tcl_AtManCall_Ended_With_Known_Contact_Alert& /*oAtManCall_Ended_With_Known_Contact_Alert*/)
{
}
tVoid most_fi_tcl_AtManCall_Ended_With_Known_Contact_Alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManCall_Ended_With_Known_Contact_Alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert(most_fi_tcl_AtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert& /*oAtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert*/)
{
}
tVoid most_fi_tcl_AtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManID_of_TrafficEvent_in_Traffic_Ahead_alert(most_fi_tcl_AtManID_of_TrafficEvent_in_Traffic_Ahead_alert& /*oAtManID_of_TrafficEvent_in_Traffic_Ahead_alert*/)
{
}
tVoid most_fi_tcl_AtManID_of_TrafficEvent_in_Traffic_Ahead_alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManID_of_TrafficEvent_in_Traffic_Ahead_alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManID_of_weather_event__in_Weather_Advisory_alert(most_fi_tcl_AtManID_of_weather_event__in_Weather_Advisory_alert& /*oAtManID_of_weather_event__in_Weather_Advisory_alert*/)
{
}
tVoid most_fi_tcl_AtManID_of_weather_event__in_Weather_Advisory_alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManID_of_weather_event__in_Weather_Advisory_alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManText_Message_Sent_Successfully_Alert(most_fi_tcl_AtManText_Message_Sent_Successfully_Alert& /*oAtManText_Message_Sent_Successfully_Alert*/)
{
}
tVoid most_fi_tcl_AtManText_Message_Sent_Successfully_Alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManText_Message_Sent_Successfully_Alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManText_Message_Delivery_Failure_Alert(most_fi_tcl_AtManText_Message_Delivery_Failure_Alert& /*oAtManText_Message_Delivery_Failure_Alert*/)
{
}
tVoid most_fi_tcl_AtManText_Message_Delivery_Failure_Alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManText_Message_Delivery_Failure_Alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManEmail_Delivery_Failure_Alert(most_fi_tcl_AtManEmail_Delivery_Failure_Alert& /*oAtManEmail_Delivery_Failure_Alert*/)
{
}
tVoid most_fi_tcl_AtManEmail_Delivery_Failure_Alert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManEmail_Delivery_Failure_Alert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManAlertParameterDataStream(most_fi_tcl_AtManAlertParameterDataStream& /*oAtManAlertParameterDataStream*/)
{
}
tVoid most_fi_tcl_AtManAlertParameterDataStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManAlertParameterDataStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManButtonActionStream(most_fi_tcl_AtManButtonActionStream& /*oAtManButtonActionStream*/)
{
}
tVoid most_fi_tcl_AtManButtonActionStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManButtonActionStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManCurrentAlertStreamItem(most_fi_tcl_AtManCurrentAlertStreamItem& /*oAtManCurrentAlertStreamItem*/)
{
}
tVoid most_fi_tcl_AtManCurrentAlertStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManCurrentAlertStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManCurrentAlertStream(most_fi_tcl_AtManCurrentAlertStream& /*oAtManCurrentAlertStream*/)
{
}
tVoid most_fi_tcl_AtManCurrentAlertStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManCurrentAlertStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManAlertStreamItem(most_fi_tcl_AtManAlertStreamItem& /*oAtManAlertStreamItem*/)
{
}
tVoid most_fi_tcl_AtManAlertStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManAlertStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManAlertStream(most_fi_tcl_AtManAlertStream& /*oAtManAlertStream*/)
{
}
tVoid most_fi_tcl_AtManAlertStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManAlertStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AtManAlertDisplayedEnum(most_fi_tcl_e8_AtManAlertDisplayedEnum& /*oe8_AtManAlertDisplayedEnum*/)
{
}
tVoid most_fi_tcl_e8_AtManAlertDisplayedEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AtManAlertDisplayedEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManDisplayTypeStream(most_fi_tcl_AtManDisplayTypeStream& /*oAtManDisplayTypeStream*/)
{
}
tVoid most_fi_tcl_AtManDisplayTypeStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManDisplayTypeStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManAlertIDStreamItem(most_fi_tcl_AtManAlertIDStreamItem& /*oAtManAlertIDStreamItem*/)
{
}
tVoid most_fi_tcl_AtManAlertIDStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManAlertIDStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AtManAlertIDStream(most_fi_tcl_AtManAlertIDStream& /*oAtManAlertIDStream*/)
{
}
tVoid most_fi_tcl_AtManAlertIDStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AtManAlertIDStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AmpATCConfiguration(most_fi_tcl_e8_AmpATCConfiguration& /*oe8_AmpATCConfiguration*/)
{
}
tVoid most_fi_tcl_e8_AmpATCConfiguration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AmpATCConfiguration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AmpDSPModeEnabledStream(most_fi_tcl_AmpDSPModeEnabledStream& /*oAmpDSPModeEnabledStream*/)
{
}
tVoid most_fi_tcl_AmpDSPModeEnabledStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AmpDSPModeEnabledStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudCuCueTypeEnum(most_fi_tcl_e8_AudCuCueTypeEnum& /*oe8_AudCuCueTypeEnum*/)
{
}
tVoid most_fi_tcl_e8_AudCuCueTypeEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudCuCueTypeEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudCuCueCalibrationEnum(most_fi_tcl_e8_AudCuCueCalibrationEnum& /*oe8_AudCuCueCalibrationEnum*/)
{
}
tVoid most_fi_tcl_e8_AudCuCueCalibrationEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudCuCueCalibrationEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudCuCueCalibrationStreamItem(most_fi_tcl_AudCuCueCalibrationStreamItem& /*oAudCuCueCalibrationStreamItem*/)
{
}
tVoid most_fi_tcl_AudCuCueCalibrationStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudCuCueCalibrationStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudCuCueCalibrationStream(most_fi_tcl_AudCuCueCalibrationStream& /*oAudCuCueCalibrationStream*/)
{
}
tVoid most_fi_tcl_AudCuCueCalibrationStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudCuCueCalibrationStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudCuCueEnableEnum(most_fi_tcl_e8_AudCuCueEnableEnum& /*oe8_AudCuCueEnableEnum*/)
{
}
tVoid most_fi_tcl_e8_AudCuCueEnableEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudCuCueEnableEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudCuCueEnableStreamItem(most_fi_tcl_AudCuCueEnableStreamItem& /*oAudCuCueEnableStreamItem*/)
{
}
tVoid most_fi_tcl_AudCuCueEnableStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudCuCueEnableStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudCuCueEnableStream(most_fi_tcl_AudCuCueEnableStream& /*oAudCuCueEnableStream*/)
{
}
tVoid most_fi_tcl_AudCuCueEnableStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudCuCueEnableStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudCuPlayStatusEnum(most_fi_tcl_e8_AudCuPlayStatusEnum& /*oe8_AudCuPlayStatusEnum*/)
{
}
tVoid most_fi_tcl_e8_AudCuPlayStatusEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudCuPlayStatusEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudCuAudibleFeedbackType(most_fi_tcl_e8_AudCuAudibleFeedbackType& /*oe8_AudCuAudibleFeedbackType*/)
{
}
tVoid most_fi_tcl_e8_AudCuAudibleFeedbackType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudCuAudibleFeedbackType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManConnectionListItem(most_fi_tcl_AVManConnectionListItem& /*oAVManConnectionListItem*/)
{
}
tVoid most_fi_tcl_AVManConnectionListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManConnectionListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManConnectionList(most_fi_tcl_AVManConnectionList& /*oAVManConnectionList*/)
{
}
tVoid most_fi_tcl_AVManConnectionList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManConnectionList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManLogicalAVChannel(most_fi_tcl_e8_AVManLogicalAVChannel& /*oe8_AVManLogicalAVChannel*/)
{
}
tVoid most_fi_tcl_e8_AVManLogicalAVChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManLogicalAVChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManRequestResult(most_fi_tcl_e8_AVManRequestResult& /*oe8_AVManRequestResult*/)
{
}
tVoid most_fi_tcl_e8_AVManRequestResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManRequestResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManChannelStatus(most_fi_tcl_e8_AVManChannelStatus& /*oe8_AVManChannelStatus*/)
{
}
tVoid most_fi_tcl_e8_AVManChannelStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManChannelStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManBaseStatusItem(most_fi_tcl_AVManBaseStatusItem& /*oAVManBaseStatusItem*/)
{
}
tVoid most_fi_tcl_AVManBaseStatusItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManBaseStatusItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManBaseStatus(most_fi_tcl_AVManBaseStatus& /*oAVManBaseStatus*/)
{
}
tVoid most_fi_tcl_AVManBaseStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManBaseStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManRearStatusItem(most_fi_tcl_AVManRearStatusItem& /*oAVManRearStatusItem*/)
{
}
tVoid most_fi_tcl_AVManRearStatusItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManRearStatusItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManRearStatus(most_fi_tcl_AVManRearStatus& /*oAVManRearStatus*/)
{
}
tVoid most_fi_tcl_AVManRearStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManRearStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManHeadphoneStatusItem(most_fi_tcl_AVManHeadphoneStatusItem& /*oAVManHeadphoneStatusItem*/)
{
}
tVoid most_fi_tcl_AVManHeadphoneStatusItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManHeadphoneStatusItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManHeadphoneStatus(most_fi_tcl_AVManHeadphoneStatus& /*oAVManHeadphoneStatus*/)
{
}
tVoid most_fi_tcl_AVManHeadphoneStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManHeadphoneStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManVideoStatusItem(most_fi_tcl_AVManVideoStatusItem& /*oAVManVideoStatusItem*/)
{
}
tVoid most_fi_tcl_AVManVideoStatusItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManVideoStatusItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManVideoStatus(most_fi_tcl_AVManVideoStatus& /*oAVManVideoStatus*/)
{
}
tVoid most_fi_tcl_AVManVideoStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManVideoStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManBaseVoiceMode(most_fi_tcl_e8_AVManBaseVoiceMode& /*oe8_AVManBaseVoiceMode*/)
{
}
tVoid most_fi_tcl_e8_AVManBaseVoiceMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManBaseVoiceMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManRearVoiceMode(most_fi_tcl_e8_AVManRearVoiceMode& /*oe8_AVManRearVoiceMode*/)
{
}
tVoid most_fi_tcl_e8_AVManRearVoiceMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManRearVoiceMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManVolumeGroup(most_fi_tcl_e8_AVManVolumeGroup& /*oe8_AVManVolumeGroup*/)
{
}
tVoid most_fi_tcl_e8_AVManVolumeGroup::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManVolumeGroup(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManAVCType(most_fi_tcl_e8_AVManAVCType& /*oe8_AVManAVCType*/)
{
}
tVoid most_fi_tcl_e8_AVManAVCType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManAVCType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManATCSetting(most_fi_tcl_e8_AVManATCSetting& /*oe8_AVManATCSetting*/)
{
}
tVoid most_fi_tcl_e8_AVManATCSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManATCSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManVolumeGroupExtentStreamItem(most_fi_tcl_AVManVolumeGroupExtentStreamItem& /*oAVManVolumeGroupExtentStreamItem*/)
{
}
tVoid most_fi_tcl_AVManVolumeGroupExtentStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManVolumeGroupExtentStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManVolumeGroupExtentStream(most_fi_tcl_AVManVolumeGroupExtentStream& /*oAVManVolumeGroupExtentStream*/)
{
}
tVoid most_fi_tcl_AVManVolumeGroupExtentStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManVolumeGroupExtentStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AVManRearVolumeGroup(most_fi_tcl_e8_AVManRearVolumeGroup& /*oe8_AVManRearVolumeGroup*/)
{
}
tVoid most_fi_tcl_e8_AVManRearVolumeGroup::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AVManRearVolumeGroup(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManRearVolumeGroupExtentStreamItem(most_fi_tcl_AVManRearVolumeGroupExtentStreamItem& /*oAVManRearVolumeGroupExtentStreamItem*/)
{
}
tVoid most_fi_tcl_AVManRearVolumeGroupExtentStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManRearVolumeGroupExtentStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AVManRearVolumeGroupExtentStream(most_fi_tcl_AVManRearVolumeGroupExtentStream& /*oAVManRearVolumeGroupExtentStream*/)
{
}
tVoid most_fi_tcl_AVManRearVolumeGroupExtentStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AVManRearVolumeGroupExtentStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AuxInInsertionStatus(most_fi_tcl_e8_AuxInInsertionStatus& /*oe8_AuxInInsertionStatus*/)
{
}
tVoid most_fi_tcl_e8_AuxInInsertionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AuxInInsertionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AuxTchProximityState(most_fi_tcl_e8_AuxTchProximityState& /*oe8_AuxTchProximityState*/)
{
}
tVoid most_fi_tcl_e8_AuxTchProximityState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AuxTchProximityState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AuxTchInteractionInfoListItem(most_fi_tcl_AuxTchInteractionInfoListItem& /*oAuxTchInteractionInfoListItem*/)
{
}
tVoid most_fi_tcl_AuxTchInteractionInfoListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AuxTchInteractionInfoListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AuxTchInteractionInfoList(most_fi_tcl_AuxTchInteractionInfoList& /*oAuxTchInteractionInfoList*/)
{
}
tVoid most_fi_tcl_AuxTchInteractionInfoList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AuxTchInteractionInfoList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_CntStkSwipeApplication(most_fi_tcl_e8_CntStkSwipeApplication& /*oe8_CntStkSwipeApplication*/)
{
}
tVoid most_fi_tcl_e8_CntStkSwipeApplication::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_CntStkSwipeApplication(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_CntStkDayNightModeOverrideSetting(most_fi_tcl_e8_CntStkDayNightModeOverrideSetting& /*oe8_CntStkDayNightModeOverrideSetting*/)
{
}
tVoid most_fi_tcl_e8_CntStkDayNightModeOverrideSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_CntStkDayNightModeOverrideSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_CntStkAppsItem(most_fi_tcl_CntStkAppsItem& /*oCntStkAppsItem*/)
{
}
tVoid most_fi_tcl_CntStkAppsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_CntStkAppsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_CntStkApps(most_fi_tcl_CntStkApps& /*oCntStkApps*/)
{
}
tVoid most_fi_tcl_CntStkApps::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_CntStkApps(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_CntStkSearchResult(most_fi_tcl_e8_CntStkSearchResult& /*oe8_CntStkSearchResult*/)
{
}
tVoid most_fi_tcl_e8_CntStkSearchResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_CntStkSearchResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_CntStkAckType(most_fi_tcl_e8_CntStkAckType& /*oe8_CntStkAckType*/)
{
}
tVoid most_fi_tcl_e8_CntStkAckType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_CntStkAckType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_CntStkButtonText(most_fi_tcl_CntStkButtonText& /*oCntStkButtonText*/)
{
}
tVoid most_fi_tcl_CntStkButtonText::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_CntStkButtonText(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_CntStkApplicationID(most_fi_tcl_e8_CntStkApplicationID& /*oe8_CntStkApplicationID*/)
{
}
tVoid most_fi_tcl_e8_CntStkApplicationID::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_CntStkApplicationID(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetApproachLightingValue(most_fi_tcl_e8_BCMSetApproachLightingValue& /*oe8_BCMSetApproachLightingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetApproachLightingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetApproachLightingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetAutoReverseGearRearWiperSettingValue(most_fi_tcl_e8_BCMSetAutoReverseGearRearWiperSettingValue& /*oe8_BCMSetAutoReverseGearRearWiperSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetAutoReverseGearRearWiperSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetAutoReverseGearRearWiperSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetDriverPersonalizationSettingValue(most_fi_tcl_e8_BCMSetDriverPersonalizationSettingValue& /*oe8_BCMSetDriverPersonalizationSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetDriverPersonalizationSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetDriverPersonalizationSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetExitLightTimeSettingValue(most_fi_tcl_e8_BCMSetExitLightTimeSettingValue& /*oe8_BCMSetExitLightTimeSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetExitLightTimeSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetExitLightTimeSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetRemoteStartSettingValue(most_fi_tcl_e8_BCMSetRemoteStartSettingValue& /*oe8_BCMSetRemoteStartSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetRemoteStartSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetRemoteStartSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetRemoteStartCooledSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartCooledSeatSettingValue& /*oe8_BCMSetRemoteStartCooledSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetRemoteStartCooledSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetRemoteStartCooledSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetRemoteStartHeatedSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartHeatedSeatSettingValue& /*oe8_BCMSetRemoteStartHeatedSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetRemoteStartHeatedSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetRemoteStartHeatedSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetPowertrainPerformanceSettingValue(most_fi_tcl_e8_BCMSetPowertrainPerformanceSettingValue& /*oe8_BCMSetPowertrainPerformanceSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetPowertrainPerformanceSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetPowertrainPerformanceSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetDaytimeTaillightsSettingValue(most_fi_tcl_e8_BCMSetDaytimeTaillightsSettingValue& /*oe8_BCMSetDaytimeTaillightsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetDaytimeTaillightsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetDaytimeTaillightsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetRemoteStartCooledDrPasSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartCooledDrPasSeatSettingValue& /*oe8_BCMSetRemoteStartCooledDrPasSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetRemoteStartCooledDrPasSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetRemoteStartCooledDrPasSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetRemoteStartHeatedDrPasSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartHeatedDrPasSeatSettingValue& /*oe8_BCMSetRemoteStartHeatedDrPasSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetRemoteStartHeatedDrPasSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetRemoteStartHeatedDrPasSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetRainSenseWipersSettingValue(most_fi_tcl_e8_BCMSetRainSenseWipersSettingValue& /*oe8_BCMSetRainSenseWipersSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetRainSenseWipersSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetRainSenseWipersSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMSetRemoteWindowOperationSettingValue(most_fi_tcl_e8_BCMSetRemoteWindowOperationSettingValue& /*oe8_BCMSetRemoteWindowOperationSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMSetRemoteWindowOperationSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMSetRemoteWindowOperationSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMApproachLightingSettingValue(most_fi_tcl_e8_BCMApproachLightingSettingValue& /*oe8_BCMApproachLightingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMApproachLightingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMApproachLightingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMAutoReverseGearRearWiperSettingValue(most_fi_tcl_e8_BCMAutoReverseGearRearWiperSettingValue& /*oe8_BCMAutoReverseGearRearWiperSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMAutoReverseGearRearWiperSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMAutoReverseGearRearWiperSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMDriverPersonalizationSettingValue(most_fi_tcl_e8_BCMDriverPersonalizationSettingValue& /*oe8_BCMDriverPersonalizationSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMDriverPersonalizationSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMDriverPersonalizationSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMExitLightTimeSettingValue(most_fi_tcl_e8_BCMExitLightTimeSettingValue& /*oe8_BCMExitLightTimeSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMExitLightTimeSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMExitLightTimeSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMRemoteStartSettingValue(most_fi_tcl_e8_BCMRemoteStartSettingValue& /*oe8_BCMRemoteStartSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMRemoteStartSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMRemoteStartSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMRemoteStartCooledSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartCooledSeatSettingValue& /*oe8_BCMRemoteStartCooledSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMRemoteStartCooledSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMRemoteStartCooledSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMRemoteStartHeatedSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartHeatedSeatSettingValue& /*oe8_BCMRemoteStartHeatedSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMRemoteStartHeatedSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMRemoteStartHeatedSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMPowertrainPerformanceSettingValue(most_fi_tcl_e8_BCMPowertrainPerformanceSettingValue& /*oe8_BCMPowertrainPerformanceSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMPowertrainPerformanceSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMPowertrainPerformanceSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMDaytimeTaillightsSettingValue(most_fi_tcl_e8_BCMDaytimeTaillightsSettingValue& /*oe8_BCMDaytimeTaillightsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMDaytimeTaillightsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMDaytimeTaillightsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMRemoteStartCooledDrPasSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartCooledDrPasSeatSettingValue& /*oe8_BCMRemoteStartCooledDrPasSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMRemoteStartCooledDrPasSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMRemoteStartCooledDrPasSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMRemoteStartHeatedDrPasSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartHeatedDrPasSeatSettingValue& /*oe8_BCMRemoteStartHeatedDrPasSeatSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMRemoteStartHeatedDrPasSeatSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMRemoteStartHeatedDrPasSeatSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMRainSenseWipersSettingValue(most_fi_tcl_e8_BCMRainSenseWipersSettingValue& /*oe8_BCMRainSenseWipersSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMRainSenseWipersSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMRainSenseWipersSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_BCMRemoteWindowOperationSettingValue(most_fi_tcl_e8_BCMRemoteWindowOperationSettingValue& /*oe8_BCMRemoteWindowOperationSettingValue*/)
{
}
tVoid most_fi_tcl_e8_BCMRemoteWindowOperationSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_BCMRemoteWindowOperationSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetAutoLockingSettingValue(most_fi_tcl_e8_DorLckSetAutoLockingSettingValue& /*oe8_DorLckSetAutoLockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetAutoLockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetAutoLockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetAutoUnlockingSettingValue(most_fi_tcl_e8_DorLckSetAutoUnlockingSettingValue& /*oe8_DorLckSetAutoUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetAutoUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetAutoUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetLastDoorClosedLockingSettingValue(most_fi_tcl_e8_DorLckSetLastDoorClosedLockingSettingValue& /*oe8_DorLckSetLastDoorClosedLockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetLastDoorClosedLockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetLastDoorClosedLockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetManualTransUnlockingSettingValue(most_fi_tcl_e8_DorLckSetManualTransUnlockingSettingValue& /*oe8_DorLckSetManualTransUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetManualTransUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetManualTransUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetPassiveLockingSettingValue(most_fi_tcl_e8_DorLckSetPassiveLockingSettingValue& /*oe8_DorLckSetPassiveLockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetPassiveLockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetPassiveLockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetPassiveUnlockingSettingValue(most_fi_tcl_e8_DorLckSetPassiveUnlockingSettingValue& /*oe8_DorLckSetPassiveUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetPassiveUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetPassiveUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetRelockRemoteDoorSettingValue(most_fi_tcl_e8_DorLckSetRelockRemoteDoorSettingValue& /*oe8_DorLckSetRelockRemoteDoorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetRelockRemoteDoorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetRelockRemoteDoorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetRelockRemoteUnlockedDoorSettingValue(most_fi_tcl_e8_DorLckSetRelockRemoteUnlockedDoorSettingValue& /*oe8_DorLckSetRelockRemoteUnlockedDoorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetRelockRemoteUnlockedDoorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetRelockRemoteUnlockedDoorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetRemoteInVehicleReminderSettingValue(most_fi_tcl_e8_DorLckSetRemoteInVehicleReminderSettingValue& /*oe8_DorLckSetRemoteInVehicleReminderSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetRemoteInVehicleReminderSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetRemoteInVehicleReminderSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetRemoteLockingFeedbackSettingValue(most_fi_tcl_e8_DorLckSetRemoteLockingFeedbackSettingValue& /*oe8_DorLckSetRemoteLockingFeedbackSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetRemoteLockingFeedbackSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetRemoteLockingFeedbackSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetRemoteSlidingDoorSettingValue(most_fi_tcl_e8_DorLckSetRemoteSlidingDoorSettingValue& /*oe8_DorLckSetRemoteSlidingDoorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetRemoteSlidingDoorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetRemoteSlidingDoorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue(most_fi_tcl_e8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue& /*oe8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetSelectiveUnlockingSettingValue(most_fi_tcl_e8_DorLckSetSelectiveUnlockingSettingValue& /*oe8_DorLckSetSelectiveUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetSelectiveUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetSelectiveUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSetOpenDoorAntiLockOutSettingValue(most_fi_tcl_e8_DorLckSetOpenDoorAntiLockOutSettingValue& /*oe8_DorLckSetOpenDoorAntiLockOutSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSetOpenDoorAntiLockOutSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSetOpenDoorAntiLockOutSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckAutoLockingSettingValue(most_fi_tcl_e8_DorLckAutoLockingSettingValue& /*oe8_DorLckAutoLockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckAutoLockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckAutoLockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckAutoUnlockingSettingValue(most_fi_tcl_e8_DorLckAutoUnlockingSettingValue& /*oe8_DorLckAutoUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckAutoUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckAutoUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckLastDoorClosedLockingSettingValue(most_fi_tcl_e8_DorLckLastDoorClosedLockingSettingValue& /*oe8_DorLckLastDoorClosedLockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckLastDoorClosedLockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckLastDoorClosedLockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckManualTransAutoUnlockingSettingValue(most_fi_tcl_e8_DorLckManualTransAutoUnlockingSettingValue& /*oe8_DorLckManualTransAutoUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckManualTransAutoUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckManualTransAutoUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckPassiveLockingSettingValue(most_fi_tcl_e8_DorLckPassiveLockingSettingValue& /*oe8_DorLckPassiveLockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckPassiveLockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckPassiveLockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckPassiveUnlockingSettingValue(most_fi_tcl_e8_DorLckPassiveUnlockingSettingValue& /*oe8_DorLckPassiveUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckPassiveUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckPassiveUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckRelockRemoteDoorSettingValue(most_fi_tcl_e8_DorLckRelockRemoteDoorSettingValue& /*oe8_DorLckRelockRemoteDoorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckRelockRemoteDoorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckRelockRemoteDoorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckRelockRemoteUnlockedDoorSettingValue(most_fi_tcl_e8_DorLckRelockRemoteUnlockedDoorSettingValue& /*oe8_DorLckRelockRemoteUnlockedDoorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckRelockRemoteUnlockedDoorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckRelockRemoteUnlockedDoorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckRemoteInVehicleReminderSettingValue(most_fi_tcl_e8_DorLckRemoteInVehicleReminderSettingValue& /*oe8_DorLckRemoteInVehicleReminderSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckRemoteInVehicleReminderSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckRemoteInVehicleReminderSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckRemoteLockingFeedbackSettingValue(most_fi_tcl_e8_DorLckRemoteLockingFeedbackSettingValue& /*oe8_DorLckRemoteLockingFeedbackSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckRemoteLockingFeedbackSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckRemoteLockingFeedbackSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckRemoteSlidingDoorSettingValue(most_fi_tcl_e8_DorLckRemoteSlidingDoorSettingValue& /*oe8_DorLckRemoteSlidingDoorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckRemoteSlidingDoorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckRemoteSlidingDoorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckRemoteUnlockLightingFeedbackSettingValue(most_fi_tcl_e8_DorLckRemoteUnlockLightingFeedbackSettingValue& /*oe8_DorLckRemoteUnlockLightingFeedbackSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckRemoteUnlockLightingFeedbackSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckRemoteUnlockLightingFeedbackSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckSelectiveUnlockingSettingValue(most_fi_tcl_e8_DorLckSelectiveUnlockingSettingValue& /*oe8_DorLckSelectiveUnlockingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckSelectiveUnlockingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckSelectiveUnlockingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DorLckOpenDoorAntiLockOutSettingValue(most_fi_tcl_e8_DorLckOpenDoorAntiLockOutSettingValue& /*oe8_DorLckOpenDoorAntiLockOutSettingValue*/)
{
}
tVoid most_fi_tcl_e8_DorLckOpenDoorAntiLockOutSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DorLckOpenDoorAntiLockOutSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetAirQualitySensorSettingValue(most_fi_tcl_e8_ECCSetAirQualitySensorSettingValue& /*oe8_ECCSetAirQualitySensorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetAirQualitySensorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetAirQualitySensorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetAutoCoolSeatsSettingValue(most_fi_tcl_e8_ECCSetAutoCoolSeatsSettingValue& /*oe8_ECCSetAutoCoolSeatsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetAutoCoolSeatsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetAutoCoolSeatsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetAutoFanSettingValue(most_fi_tcl_e8_ECCSetAutoFanSettingValue& /*oe8_ECCSetAutoFanSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetAutoFanSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetAutoFanSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetAutoHeatedSeatsSettingValue(most_fi_tcl_e8_ECCSetAutoHeatedSeatsSettingValue& /*oe8_ECCSetAutoHeatedSeatsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetAutoHeatedSeatsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetAutoHeatedSeatsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetAutoZoneTempSettingValue(most_fi_tcl_e8_ECCSetAutoZoneTempSettingValue& /*oe8_ECCSetAutoZoneTempSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetAutoZoneTempSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetAutoZoneTempSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetHVACRemoteStartSettingSettingValue(most_fi_tcl_e8_ECCSetHVACRemoteStartSettingSettingValue& /*oe8_ECCSetHVACRemoteStartSettingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetHVACRemoteStartSettingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetHVACRemoteStartSettingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetACModeSettingValue(most_fi_tcl_e8_ECCSetACModeSettingValue& /*oe8_ECCSetACModeSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetACModeSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetACModeSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetAutoDefogSettingValue(most_fi_tcl_e8_ECCSetAutoDefogSettingValue& /*oe8_ECCSetAutoDefogSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetAutoDefogSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetAutoDefogSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetRearZoneStartupSettingsValue(most_fi_tcl_e8_ECCSetRearZoneStartupSettingsValue& /*oe8_ECCSetRearZoneStartupSettingsValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetRearZoneStartupSettingsValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetRearZoneStartupSettingsValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetRearDefogStartupSettingsValue(most_fi_tcl_e8_ECCSetRearDefogStartupSettingsValue& /*oe8_ECCSetRearDefogStartupSettingsValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetRearDefogStartupSettingsValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetRearDefogStartupSettingsValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetPollutionControlSettingsValue(most_fi_tcl_e8_ECCSetPollutionControlSettingsValue& /*oe8_ECCSetPollutionControlSettingsValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetPollutionControlSettingsValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetPollutionControlSettingsValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetIonizerSettingsValue(most_fi_tcl_e8_ECCSetIonizerSettingsValue& /*oe8_ECCSetIonizerSettingsValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetIonizerSettingsValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetIonizerSettingsValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCSetAutoAirDistrSettingsValue(most_fi_tcl_e8_ECCSetAutoAirDistrSettingsValue& /*oe8_ECCSetAutoAirDistrSettingsValue*/)
{
}
tVoid most_fi_tcl_e8_ECCSetAutoAirDistrSettingsValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCSetAutoAirDistrSettingsValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCAirQualitySensorSettingValue(most_fi_tcl_e8_ECCAirQualitySensorSettingValue& /*oe8_ECCAirQualitySensorSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCAirQualitySensorSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCAirQualitySensorSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCAutoCoolSeatsSettingValue(most_fi_tcl_e8_ECCAutoCoolSeatsSettingValue& /*oe8_ECCAutoCoolSeatsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCAutoCoolSeatsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCAutoCoolSeatsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCAutoFanSettingValue(most_fi_tcl_e8_ECCAutoFanSettingValue& /*oe8_ECCAutoFanSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCAutoFanSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCAutoFanSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCAutoHeatedSeatsSettingValue(most_fi_tcl_e8_ECCAutoHeatedSeatsSettingValue& /*oe8_ECCAutoHeatedSeatsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCAutoHeatedSeatsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCAutoHeatedSeatsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCAutoZoneTempSettingValue(most_fi_tcl_e8_ECCAutoZoneTempSettingValue& /*oe8_ECCAutoZoneTempSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCAutoZoneTempSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCAutoZoneTempSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCHVACRemoteStartSettingValue(most_fi_tcl_e8_ECCHVACRemoteStartSettingValue& /*oe8_ECCHVACRemoteStartSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCHVACRemoteStartSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCHVACRemoteStartSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCACModeSettingValue(most_fi_tcl_e8_ECCACModeSettingValue& /*oe8_ECCACModeSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCACModeSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCACModeSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCAutoDefogSettingValue(most_fi_tcl_e8_ECCAutoDefogSettingValue& /*oe8_ECCAutoDefogSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCAutoDefogSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCAutoDefogSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCRearZoneStartupSettingValue(most_fi_tcl_e8_ECCRearZoneStartupSettingValue& /*oe8_ECCRearZoneStartupSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCRearZoneStartupSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCRearZoneStartupSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCRearDefogStartupSettingValue(most_fi_tcl_e8_ECCRearDefogStartupSettingValue& /*oe8_ECCRearDefogStartupSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCRearDefogStartupSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCRearDefogStartupSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCPollutionControlSettingValue(most_fi_tcl_e8_ECCPollutionControlSettingValue& /*oe8_ECCPollutionControlSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCPollutionControlSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCPollutionControlSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCIonizerSettingValue(most_fi_tcl_e8_ECCIonizerSettingValue& /*oe8_ECCIonizerSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCIonizerSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCIonizerSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ECCAutoAirDistrSettingValue(most_fi_tcl_e8_ECCAutoAirDistrSettingValue& /*oe8_ECCAutoAirDistrSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ECCAutoAirDistrSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ECCAutoAirDistrSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_IPCSetSpeedScaleIlluminationSettingValue(most_fi_tcl_e8_IPCSetSpeedScaleIlluminationSettingValue& /*oe8_IPCSetSpeedScaleIlluminationSettingValue*/)
{
}
tVoid most_fi_tcl_e8_IPCSetSpeedScaleIlluminationSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_IPCSetSpeedScaleIlluminationSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_IPCSetSportModeBackLightingSettingValue(most_fi_tcl_e8_IPCSetSportModeBackLightingSettingValue& /*oe8_IPCSetSportModeBackLightingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_IPCSetSportModeBackLightingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_IPCSetSportModeBackLightingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_IPCSetEcoModeTelltaleEnableSettingValue(most_fi_tcl_e8_IPCSetEcoModeTelltaleEnableSettingValue& /*oe8_IPCSetEcoModeTelltaleEnableSettingValue*/)
{
}
tVoid most_fi_tcl_e8_IPCSetEcoModeTelltaleEnableSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_IPCSetEcoModeTelltaleEnableSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_IPCSpeedScaleIlluminationSettingValue(most_fi_tcl_e8_IPCSpeedScaleIlluminationSettingValue& /*oe8_IPCSpeedScaleIlluminationSettingValue*/)
{
}
tVoid most_fi_tcl_e8_IPCSpeedScaleIlluminationSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_IPCSpeedScaleIlluminationSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_IPCSportModeBacklightingSettingValue(most_fi_tcl_e8_IPCSportModeBacklightingSettingValue& /*oe8_IPCSportModeBacklightingSettingValue*/)
{
}
tVoid most_fi_tcl_e8_IPCSportModeBacklightingSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_IPCSportModeBacklightingSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_IPCEcoModeTelltaleEnableSettingValue(most_fi_tcl_e8_IPCEcoModeTelltaleEnableSettingValue& /*oe8_IPCEcoModeTelltaleEnableSettingValue*/)
{
}
tVoid most_fi_tcl_e8_IPCEcoModeTelltaleEnableSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_IPCEcoModeTelltaleEnableSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetDriverSeatEasyExitSettingValue(most_fi_tcl_e8_MemSetSetDriverSeatEasyExitSettingValue& /*oe8_MemSetSetDriverSeatEasyExitSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetDriverSeatEasyExitSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetDriverSeatEasyExitSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetFoldingMirrorsSettingValue(most_fi_tcl_e8_MemSetSetFoldingMirrorsSettingValue& /*oe8_MemSetSetFoldingMirrorsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetFoldingMirrorsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetFoldingMirrorsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetMemoryColumnSettingValue(most_fi_tcl_e8_MemSetSetMemoryColumnSettingValue& /*oe8_MemSetSetMemoryColumnSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetMemoryColumnSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetMemoryColumnSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetParkingTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetSetParkingTiltMirrorsSettingValue& /*oe8_MemSetSetParkingTiltMirrorsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetParkingTiltMirrorsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetParkingTiltMirrorsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetRemoteMemoryUnlockRecallSettingValue(most_fi_tcl_e8_MemSetSetRemoteMemoryUnlockRecallSettingValue& /*oe8_MemSetSetRemoteMemoryUnlockRecallSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetRemoteMemoryUnlockRecallSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetRemoteMemoryUnlockRecallSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetMemoryTiltColumnSettingValue(most_fi_tcl_e8_MemSetSetMemoryTiltColumnSettingValue& /*oe8_MemSetSetMemoryTiltColumnSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetMemoryTiltColumnSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetMemoryTiltColumnSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetCrashAvoidanceAlertTypeSettingValue(most_fi_tcl_e8_MemSetSetCrashAvoidanceAlertTypeSettingValue& /*oe8_MemSetSetCrashAvoidanceAlertTypeSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetCrashAvoidanceAlertTypeSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetCrashAvoidanceAlertTypeSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetReverseTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetSetReverseTiltMirrorsSettingValue& /*oe8_MemSetSetReverseTiltMirrorsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetReverseTiltMirrorsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetReverseTiltMirrorsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetEasyExitSettingValue(most_fi_tcl_e8_MemSetSetEasyExitSettingValue& /*oe8_MemSetSetEasyExitSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetEasyExitSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetEasyExitSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetSetMemoryRemoteRecallSettingValue(most_fi_tcl_e8_MemSetSetMemoryRemoteRecallSettingValue& /*oe8_MemSetSetMemoryRemoteRecallSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetSetMemoryRemoteRecallSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetSetMemoryRemoteRecallSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetDriverSeatEasyExitSettingValue(most_fi_tcl_e8_MemSetDriverSeatEasyExitSettingValue& /*oe8_MemSetDriverSeatEasyExitSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetDriverSeatEasyExitSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetDriverSeatEasyExitSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetFoldingMirrorsSettingValue(most_fi_tcl_e8_MemSetFoldingMirrorsSettingValue& /*oe8_MemSetFoldingMirrorsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetFoldingMirrorsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetFoldingMirrorsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetMemoryColumnSettingValue(most_fi_tcl_e8_MemSetMemoryColumnSettingValue& /*oe8_MemSetMemoryColumnSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetMemoryColumnSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetMemoryColumnSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetParkingTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetParkingTiltMirrorsSettingValue& /*oe8_MemSetParkingTiltMirrorsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetParkingTiltMirrorsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetParkingTiltMirrorsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetRemoteMemoryUnlockRecallSettingValue(most_fi_tcl_e8_MemSetRemoteMemoryUnlockRecallSettingValue& /*oe8_MemSetRemoteMemoryUnlockRecallSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetRemoteMemoryUnlockRecallSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetRemoteMemoryUnlockRecallSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetMemoryTiltColumnSettingValue(most_fi_tcl_e8_MemSetMemoryTiltColumnSettingValue& /*oe8_MemSetMemoryTiltColumnSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetMemoryTiltColumnSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetMemoryTiltColumnSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetCrashAvoidanceAlertTypeSettingValue(most_fi_tcl_e8_MemSetCrashAvoidanceAlertTypeSettingValue& /*oe8_MemSetCrashAvoidanceAlertTypeSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetCrashAvoidanceAlertTypeSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetCrashAvoidanceAlertTypeSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetReverseTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetReverseTiltMirrorsSettingValue& /*oe8_MemSetReverseTiltMirrorsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetReverseTiltMirrorsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetReverseTiltMirrorsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetEasyExitSettingValue(most_fi_tcl_e8_MemSetEasyExitSettingValue& /*oe8_MemSetEasyExitSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetEasyExitSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetEasyExitSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MemSetMemoryRemoteRecallSettingValue(most_fi_tcl_e8_MemSetMemoryRemoteRecallSettingValue& /*oe8_MemSetMemoryRemoteRecallSettingValue*/)
{
}
tVoid most_fi_tcl_e8_MemSetMemoryRemoteRecallSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MemSetMemoryRemoteRecallSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ObjCmpSet24GHzRadarsSettingValue(most_fi_tcl_e8_ObjCmpSet24GHzRadarsSettingValue& /*oe8_ObjCmpSet24GHzRadarsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ObjCmpSet24GHzRadarsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ObjCmpSet24GHzRadarsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ObjCmp24GHzRadarsSettingValue(most_fi_tcl_e8_ObjCmp24GHzRadarsSettingValue& /*oe8_ObjCmp24GHzRadarsSettingValue*/)
{
}
tVoid most_fi_tcl_e8_ObjCmp24GHzRadarsSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ObjCmp24GHzRadarsSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PASetParkAssistSettingValue(most_fi_tcl_e8_PASetParkAssistSettingValue& /*oe8_PASetParkAssistSettingValue*/)
{
}
tVoid most_fi_tcl_e8_PASetParkAssistSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PASetParkAssistSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PASetParkAssistWithTowbarSettingValue(most_fi_tcl_e8_PASetParkAssistWithTowbarSettingValue& /*oe8_PASetParkAssistWithTowbarSettingValue*/)
{
}
tVoid most_fi_tcl_e8_PASetParkAssistWithTowbarSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PASetParkAssistWithTowbarSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PAParkAssistSettingValue(most_fi_tcl_e8_PAParkAssistSettingValue& /*oe8_PAParkAssistSettingValue*/)
{
}
tVoid most_fi_tcl_e8_PAParkAssistSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PAParkAssistSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PAParkAssistWithTowbarSettingValue(most_fi_tcl_e8_PAParkAssistWithTowbarSettingValue& /*oe8_PAParkAssistWithTowbarSettingValue*/)
{
}
tVoid most_fi_tcl_e8_PAParkAssistWithTowbarSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PAParkAssistWithTowbarSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SBZASetSideBlindZoneAlertSettingValue(most_fi_tcl_e8_SBZASetSideBlindZoneAlertSettingValue& /*oe8_SBZASetSideBlindZoneAlertSettingValue*/)
{
}
tVoid most_fi_tcl_e8_SBZASetSideBlindZoneAlertSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SBZASetSideBlindZoneAlertSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SBZASetRearCrossTrafficAlertSettingValue(most_fi_tcl_e8_SBZASetRearCrossTrafficAlertSettingValue& /*oe8_SBZASetRearCrossTrafficAlertSettingValue*/)
{
}
tVoid most_fi_tcl_e8_SBZASetRearCrossTrafficAlertSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SBZASetRearCrossTrafficAlertSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SBZASetLaneChangeAlertSettingValue(most_fi_tcl_e8_SBZASetLaneChangeAlertSettingValue& /*oe8_SBZASetLaneChangeAlertSettingValue*/)
{
}
tVoid most_fi_tcl_e8_SBZASetLaneChangeAlertSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SBZASetLaneChangeAlertSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SBZASideBlindZoneAlertSettingValue(most_fi_tcl_e8_SBZASideBlindZoneAlertSettingValue& /*oe8_SBZASideBlindZoneAlertSettingValue*/)
{
}
tVoid most_fi_tcl_e8_SBZASideBlindZoneAlertSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SBZASideBlindZoneAlertSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SBZARearCrossTrafficAlertSettingValue(most_fi_tcl_e8_SBZARearCrossTrafficAlertSettingValue& /*oe8_SBZARearCrossTrafficAlertSettingValue*/)
{
}
tVoid most_fi_tcl_e8_SBZARearCrossTrafficAlertSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SBZARearCrossTrafficAlertSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SBZALaneChangeAlertSettingValue(most_fi_tcl_e8_SBZALaneChangeAlertSettingValue& /*oe8_SBZALaneChangeAlertSettingValue*/)
{
}
tVoid most_fi_tcl_e8_SBZALaneChangeAlertSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SBZALaneChangeAlertSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunDABStationListItem(most_fi_tcl_DABTunDABStationListItem& /*oDABTunDABStationListItem*/)
{
}
tVoid most_fi_tcl_DABTunDABStationListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunDABStationListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunDABStationList(most_fi_tcl_DABTunDABStationList& /*oDABTunDABStationList*/)
{
}
tVoid most_fi_tcl_DABTunDABStationList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunDABStationList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunServiceTypeFlag(most_fi_tcl_e8_DABTunServiceTypeFlag& /*oe8_DABTunServiceTypeFlag*/)
{
}
tVoid most_fi_tcl_e8_DABTunServiceTypeFlag::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunServiceTypeFlag(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunDABStationListResultItem(most_fi_tcl_DABTunDABStationListResultItem& /*oDABTunDABStationListResultItem*/)
{
}
tVoid most_fi_tcl_DABTunDABStationListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunDABStationListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunDABStationListResult(most_fi_tcl_DABTunDABStationListResult& /*oDABTunDABStationListResult*/)
{
}
tVoid most_fi_tcl_DABTunDABStationListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunDABStationListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunDABObjectIDList(most_fi_tcl_DABTunDABObjectIDList& /*oDABTunDABObjectIDList*/)
{
}
tVoid most_fi_tcl_DABTunDABObjectIDList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunDABObjectIDList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunBroadcastType(most_fi_tcl_e8_DABTunBroadcastType& /*oe8_DABTunBroadcastType*/)
{
}
tVoid most_fi_tcl_e8_DABTunBroadcastType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunBroadcastType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunDynamicLabelPlusCmd(most_fi_tcl_DABTunDynamicLabelPlusCmd& /*oDABTunDynamicLabelPlusCmd*/)
{
}
tVoid most_fi_tcl_DABTunDynamicLabelPlusCmd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunDynamicLabelPlusCmd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunDABTuningStatus(most_fi_tcl_e8_DABTunDABTuningStatus& /*oe8_DABTunDABTuningStatus*/)
{
}
tVoid most_fi_tcl_e8_DABTunDABTuningStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunDABTuningStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunDABWaveBandSwitch(most_fi_tcl_e8_DABTunDABWaveBandSwitch& /*oe8_DABTunDABWaveBandSwitch*/)
{
}
tVoid most_fi_tcl_e8_DABTunDABWaveBandSwitch::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunDABWaveBandSwitch(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunStationListUpdateStatus(most_fi_tcl_e8_DABTunStationListUpdateStatus& /*oe8_DABTunStationListUpdateStatus*/)
{
}
tVoid most_fi_tcl_e8_DABTunStationListUpdateStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunStationListUpdateStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_b16_DABTunMask(most_fi_tcl_b16_DABTunMask& /*ob16_DABTunMask*/)
{
}
tVoid most_fi_tcl_b16_DABTunMask::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_b16_DABTunMask(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunFilterDataItem(most_fi_tcl_DABTunFilterDataItem& /*oDABTunFilterDataItem*/)
{
}
tVoid most_fi_tcl_DABTunFilterDataItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunFilterDataItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunFilterData(most_fi_tcl_DABTunFilterData& /*oDABTunFilterData*/)
{
}
tVoid most_fi_tcl_DABTunFilterData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunFilterData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunGroupID(most_fi_tcl_e8_DABTunGroupID& /*oe8_DABTunGroupID*/)
{
}
tVoid most_fi_tcl_e8_DABTunGroupID::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunGroupID(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunTunerSelection(most_fi_tcl_e8_DABTunTunerSelection& /*oe8_DABTunTunerSelection*/)
{
}
tVoid most_fi_tcl_e8_DABTunTunerSelection::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunTunerSelection(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunTMCMessage_(most_fi_tcl_DABTunTMCMessage_& /*oDABTunTMCMessage_*/)
{
}
tVoid most_fi_tcl_DABTunTMCMessage_::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunTMCMessage_(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunTimeData(most_fi_tcl_DABTunTimeData& /*oDABTunTimeData*/)
{
}
tVoid most_fi_tcl_DABTunTimeData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunTimeData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunDAB_RDSGroupMessage(most_fi_tcl_DABTunDAB_RDSGroupMessage& /*oDABTunDAB_RDSGroupMessage*/)
{
}
tVoid most_fi_tcl_DABTunDAB_RDSGroupMessage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunDAB_RDSGroupMessage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunBackgroundTMCStatusInfo(most_fi_tcl_e8_DABTunBackgroundTMCStatusInfo& /*oe8_DABTunBackgroundTMCStatusInfo*/)
{
}
tVoid most_fi_tcl_e8_DABTunBackgroundTMCStatusInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunBackgroundTMCStatusInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunDABTMCStatusInfo(most_fi_tcl_e8_DABTunDABTMCStatusInfo& /*oe8_DABTunDABTMCStatusInfo*/)
{
}
tVoid most_fi_tcl_e8_DABTunDABTMCStatusInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunDABTMCStatusInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunForegroundTMCStatusInfo(most_fi_tcl_e8_DABTunForegroundTMCStatusInfo& /*oe8_DABTunForegroundTMCStatusInfo*/)
{
}
tVoid most_fi_tcl_e8_DABTunForegroundTMCStatusInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunForegroundTMCStatusInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DABTunTMCSenderNameInfo(most_fi_tcl_e8_DABTunTMCSenderNameInfo& /*oe8_DABTunTMCSenderNameInfo*/)
{
}
tVoid most_fi_tcl_e8_DABTunTMCSenderNameInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DABTunTMCSenderNameInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunTMCStationDataItem(most_fi_tcl_DABTunTMCStationDataItem& /*oDABTunTMCStationDataItem*/)
{
}
tVoid most_fi_tcl_DABTunTMCStationDataItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunTMCStationDataItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DABTunTMCStationData(most_fi_tcl_DABTunTMCStationData& /*oDABTunTMCStationData*/)
{
}
tVoid most_fi_tcl_DABTunTMCStationData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DABTunTMCStationData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevCltInfoListItem(most_fi_tcl_DevCltInfoListItem& /*oDevCltInfoListItem*/)
{
}
tVoid most_fi_tcl_DevCltInfoListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevCltInfoListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevCltInfoList(most_fi_tcl_DevCltInfoList& /*oDevCltInfoList*/)
{
}
tVoid most_fi_tcl_DevCltInfoList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevCltInfoList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjDeviceType(most_fi_tcl_e8_DevPrjDeviceType& /*oe8_DevPrjDeviceType*/)
{
}
tVoid most_fi_tcl_e8_DevPrjDeviceType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjDeviceType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjDeviceInterfaceType(most_fi_tcl_e8_DevPrjDeviceInterfaceType& /*oe8_DevPrjDeviceInterfaceType*/)
{
}
tVoid most_fi_tcl_e8_DevPrjDeviceInterfaceType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjDeviceInterfaceType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjDeviceListItem(most_fi_tcl_DevPrjDeviceListItem& /*oDevPrjDeviceListItem*/)
{
}
tVoid most_fi_tcl_DevPrjDeviceListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjDeviceListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjDeviceList(most_fi_tcl_DevPrjDeviceList& /*oDevPrjDeviceList*/)
{
}
tVoid most_fi_tcl_DevPrjDeviceList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjDeviceList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjRequestedDisplayContext(most_fi_tcl_e8_DevPrjRequestedDisplayContext& /*oe8_DevPrjRequestedDisplayContext*/)
{
}
tVoid most_fi_tcl_e8_DevPrjRequestedDisplayContext::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjRequestedDisplayContext(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjDigitalIPodOutApplication(most_fi_tcl_e8_DevPrjDigitalIPodOutApplication& /*oe8_DevPrjDigitalIPodOutApplication*/)
{
}
tVoid most_fi_tcl_e8_DevPrjDigitalIPodOutApplication::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjDigitalIPodOutApplication(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjEchoCancellationNoiseReductionSetting(most_fi_tcl_e8_DevPrjEchoCancellationNoiseReductionSetting& /*oe8_DevPrjEchoCancellationNoiseReductionSetting*/)
{
}
tVoid most_fi_tcl_e8_DevPrjEchoCancellationNoiseReductionSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjEchoCancellationNoiseReductionSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjLaunchResult(most_fi_tcl_e8_DevPrjLaunchResult& /*oe8_DevPrjLaunchResult*/)
{
}
tVoid most_fi_tcl_e8_DevPrjLaunchResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjLaunchResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjApplicationCertificateType(most_fi_tcl_e8_DevPrjApplicationCertificateType& /*oe8_DevPrjApplicationCertificateType*/)
{
}
tVoid most_fi_tcl_e8_DevPrjApplicationCertificateType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjApplicationCertificateType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjAppActivityState(most_fi_tcl_e8_DevPrjAppActivityState& /*oe8_DevPrjAppActivityState*/)
{
}
tVoid most_fi_tcl_e8_DevPrjAppActivityState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjAppActivityState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjApplicationListItem(most_fi_tcl_DevPrjApplicationListItem& /*oDevPrjApplicationListItem*/)
{
}
tVoid most_fi_tcl_DevPrjApplicationListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjApplicationListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjApplicationList(most_fi_tcl_DevPrjApplicationList& /*oDevPrjApplicationList*/)
{
}
tVoid most_fi_tcl_DevPrjApplicationList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjApplicationList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjSwitchEnumeration(most_fi_tcl_e8_DevPrjSwitchEnumeration& /*oe8_DevPrjSwitchEnumeration*/)
{
}
tVoid most_fi_tcl_e8_DevPrjSwitchEnumeration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjSwitchEnumeration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjSwitchEventTypeEnumeration(most_fi_tcl_e8_DevPrjSwitchEventTypeEnumeration& /*oe8_DevPrjSwitchEventTypeEnumeration*/)
{
}
tVoid most_fi_tcl_e8_DevPrjSwitchEventTypeEnumeration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjSwitchEventTypeEnumeration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjButtonAction(most_fi_tcl_e8_DevPrjButtonAction& /*oe8_DevPrjButtonAction*/)
{
}
tVoid most_fi_tcl_e8_DevPrjButtonAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjButtonAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjSessionState(most_fi_tcl_e8_DevPrjSessionState& /*oe8_DevPrjSessionState*/)
{
}
tVoid most_fi_tcl_e8_DevPrjSessionState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjSessionState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjConnectivityMappingItem(most_fi_tcl_DevPrjConnectivityMappingItem& /*oDevPrjConnectivityMappingItem*/)
{
}
tVoid most_fi_tcl_DevPrjConnectivityMappingItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjConnectivityMappingItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjConnectivityMapping(most_fi_tcl_DevPrjConnectivityMapping& /*oDevPrjConnectivityMapping*/)
{
}
tVoid most_fi_tcl_DevPrjConnectivityMapping::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjConnectivityMapping(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjDeviceUserParametersItem(most_fi_tcl_DevPrjDeviceUserParametersItem& /*oDevPrjDeviceUserParametersItem*/)
{
}
tVoid most_fi_tcl_DevPrjDeviceUserParametersItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjDeviceUserParametersItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_DevPrjDeviceUserParameters(most_fi_tcl_DevPrjDeviceUserParameters& /*oDevPrjDeviceUserParameters*/)
{
}
tVoid most_fi_tcl_DevPrjDeviceUserParameters::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_DevPrjDeviceUserParameters(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjBTChangeInfo(most_fi_tcl_e8_DevPrjBTChangeInfo& /*oe8_DevPrjBTChangeInfo*/)
{
}
tVoid most_fi_tcl_e8_DevPrjBTChangeInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjBTChangeInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjNavigationAppState(most_fi_tcl_e8_DevPrjNavigationAppState& /*oe8_DevPrjNavigationAppState*/)
{
}
tVoid most_fi_tcl_e8_DevPrjNavigationAppState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjNavigationAppState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjPhoneAppState(most_fi_tcl_e8_DevPrjPhoneAppState& /*oe8_DevPrjPhoneAppState*/)
{
}
tVoid most_fi_tcl_e8_DevPrjPhoneAppState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjPhoneAppState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DevPrjSpeechAppState(most_fi_tcl_e8_DevPrjSpeechAppState& /*oe8_DevPrjSpeechAppState*/)
{
}
tVoid most_fi_tcl_e8_DevPrjSpeechAppState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DevPrjSpeechAppState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_DiPOSwitchReqResponse(most_fi_tcl_e8_DiPOSwitchReqResponse& /*oe8_DiPOSwitchReqResponse*/)
{
}
tVoid most_fi_tcl_e8_DiPOSwitchReqResponse::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_DiPOSwitchReqResponse(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PlaybackStopReason(most_fi_tcl_e8_PlaybackStopReason& /*oe8_PlaybackStopReason*/)
{
}
tVoid most_fi_tcl_e8_PlaybackStopReason::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PlaybackStopReason(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavManAudioChannel(most_fi_tcl_e8_FavManAudioChannel& /*oe8_FavManAudioChannel*/)
{
}
tVoid most_fi_tcl_e8_FavManAudioChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavManAudioChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavManVideoChannel(most_fi_tcl_e8_FavManVideoChannel& /*oe8_FavManVideoChannel*/)
{
}
tVoid most_fi_tcl_e8_FavManVideoChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavManVideoChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavManFavoriteType(most_fi_tcl_e8_FavManFavoriteType& /*oe8_FavManFavoriteType*/)
{
}
tVoid most_fi_tcl_e8_FavManFavoriteType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavManFavoriteType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavManFavoriteTypesList(most_fi_tcl_FavManFavoriteTypesList& /*oFavManFavoriteTypesList*/)
{
}
tVoid most_fi_tcl_FavManFavoriteTypesList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavManFavoriteTypesList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavManFavoriteHMIDataItem(most_fi_tcl_FavManFavoriteHMIDataItem& /*oFavManFavoriteHMIDataItem*/)
{
}
tVoid most_fi_tcl_FavManFavoriteHMIDataItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavManFavoriteHMIDataItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavManFavoriteHMIData(most_fi_tcl_FavManFavoriteHMIData& /*oFavManFavoriteHMIData*/)
{
}
tVoid most_fi_tcl_FavManFavoriteHMIData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavManFavoriteHMIData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavManListChangeType(most_fi_tcl_e8_FavManListChangeType& /*oe8_FavManListChangeType*/)
{
}
tVoid most_fi_tcl_e8_FavManListChangeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavManListChangeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavManChangeItems(most_fi_tcl_FavManChangeItems& /*oFavManChangeItems*/)
{
}
tVoid most_fi_tcl_FavManChangeItems::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavManChangeItems(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FMTunImageData(most_fi_tcl_FMTunImageData& /*oFMTunImageData*/)
{
}
tVoid most_fi_tcl_FMTunImageData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FMTunImageData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAPAIconDisplayRequest(most_fi_tcl_e8_GMLnGWAPAIconDisplayRequest& /*oe8_GMLnGWAPAIconDisplayRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAPAIconDisplayRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAPAIconDisplayRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDrivelineCustomizationSettings(most_fi_tcl_e8_GMLnGWDrivelineCustomizationSettings& /*oe8_GMLnGWDrivelineCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDrivelineCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDrivelineCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSteeringCustomizationSettings(most_fi_tcl_e8_GMLnGWSteeringCustomizationSettings& /*oe8_GMLnGWSteeringCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSteeringCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSteeringCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSuspensionCustomizationSettings(most_fi_tcl_e8_GMLnGWSuspensionCustomizationSettings& /*oe8_GMLnGWSuspensionCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSuspensionCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSuspensionCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWForwardCollisionAlertCustomizationSettings(most_fi_tcl_e8_GMLnGWForwardCollisionAlertCustomizationSettings& /*oe8_GMLnGWForwardCollisionAlertCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWForwardCollisionAlertCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWForwardCollisionAlertCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWGoNotifierCustomizationSettings(most_fi_tcl_e8_GMLnGWGoNotifierCustomizationSettings& /*oe8_GMLnGWGoNotifierCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWGoNotifierCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWGoNotifierCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWCollisionPreparationSystemCustomizationSettings(most_fi_tcl_e8_GMLnGWCollisionPreparationSystemCustomizationSettings& /*oe8_GMLnGWCollisionPreparationSystemCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWCollisionPreparationSystemCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWCollisionPreparationSystemCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRightHandTrafficCustomizationSettings(most_fi_tcl_e8_GMLnGWLeftRightHandTrafficCustomizationSettings& /*oe8_GMLnGWLeftRightHandTrafficCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRightHandTrafficCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRightHandTrafficCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSeatBeltTighteningCustomizationSettings(most_fi_tcl_e8_GMLnGWSeatBeltTighteningCustomizationSettings& /*oe8_GMLnGWSeatBeltTighteningCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSeatBeltTighteningCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSeatBeltTighteningCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting(most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting& /*oe8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAdaptiveForwardLightingCustomizationSetting(most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingCustomizationSetting& /*oe8_GMLnGWAdaptiveForwardLightingCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAdaptiveForwardLightingCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings(most_fi_tcl_e8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings& /*oe8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAutoHighBeamAssistCustomizationSettings(most_fi_tcl_e8_GMLnGWAutoHighBeamAssistCustomizationSettings& /*oe8_GMLnGWAutoHighBeamAssistCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAutoHighBeamAssistCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAutoHighBeamAssistCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings(most_fi_tcl_e8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings& /*oe8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings(most_fi_tcl_e8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings& /*oe8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings(most_fi_tcl_e8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings& /*oe8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargePowerLossAlertCustomizationSettings(most_fi_tcl_e8_GMLnGWChargePowerLossAlertCustomizationSettings& /*oe8_GMLnGWChargePowerLossAlertCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargePowerLossAlertCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargePowerLossAlertCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeCordTheftAlertCustomizationSettings(most_fi_tcl_e8_GMLnGWChargeCordTheftAlertCustomizationSettings& /*oe8_GMLnGWChargeCordTheftAlertCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeCordTheftAlertCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeCordTheftAlertCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings(most_fi_tcl_e8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings& /*oe8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverDrowsinessDetectionCustomizationSetting(most_fi_tcl_e8_GMLnGWDriverDrowsinessDetectionCustomizationSetting& /*oe8_GMLnGWDriverDrowsinessDetectionCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverDrowsinessDetectionCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverDrowsinessDetectionCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPTOSetOneSpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOSetOneSpeedCustomizationSetting& /*oe8_GMLnGWPTOSetOneSpeedCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPTOSetOneSpeedCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPTOSetOneSpeedCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPTOSetTwoSpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOSetTwoSpeedCustomizationSetting& /*oe8_GMLnGWPTOSetTwoSpeedCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPTOSetTwoSpeedCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPTOSetTwoSpeedCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPTOEngineRunTimerCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOEngineRunTimerCustomizationSetting& /*oe8_GMLnGWPTOEngineRunTimerCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPTOEngineRunTimerCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPTOEngineRunTimerCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPTOTapSetSpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOTapSetSpeedCustomizationSetting& /*oe8_GMLnGWPTOTapSetSpeedCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPTOTapSetSpeedCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPTOTapSetSpeedCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPTOStandbySpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOStandbySpeedCustomizationSetting& /*oe8_GMLnGWPTOStandbySpeedCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPTOStandbySpeedCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPTOStandbySpeedCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeDisplayCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeDisplayCustomizationSettings& /*oe8_GMLnGWPerfModeDisplayCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeDisplayCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeDisplayCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeSoundCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeSoundCustomizationSettings& /*oe8_GMLnGWPerfModeSoundCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeSoundCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeSoundCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPedestrianFriendlyAlertCustomizationSetting(most_fi_tcl_e8_GMLnGWPedestrianFriendlyAlertCustomizationSetting& /*oe8_GMLnGWPedestrianFriendlyAlertCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPedestrianFriendlyAlertCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPedestrianFriendlyAlertCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEngineAssistedHeatingCustomizationSetting(most_fi_tcl_e8_GMLnGWEngineAssistedHeatingCustomizationSetting& /*oe8_GMLnGWEngineAssistedHeatingCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEngineAssistedHeatingCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEngineAssistedHeatingCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting(most_fi_tcl_e8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting& /*oe8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWElevatedIdleCustomizationSetting(most_fi_tcl_e8_GMLnGWElevatedIdleCustomizationSetting& /*oe8_GMLnGWElevatedIdleCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWElevatedIdleCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWElevatedIdleCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting(most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting& /*oe8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeMainMenuType(most_fi_tcl_e8_GMLnGWPerfModeMainMenuType& /*oe8_GMLnGWPerfModeMainMenuType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeMainMenuType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeMainMenuType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings& /*oe8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeDriverSeatControlCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeDriverSeatControlCustomizationSettings& /*oe8_GMLnGWPerfModeDriverSeatControlCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeDriverSeatControlCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeDriverSeatControlCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModePassengerSeatControlCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModePassengerSeatControlCustomizationSettings& /*oe8_GMLnGWPerfModePassengerSeatControlCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModePassengerSeatControlCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModePassengerSeatControlCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeDrivingStyleCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeDrivingStyleCustomizationSettings& /*oe8_GMLnGWPerfModeDrivingStyleCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeDrivingStyleCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeDrivingStyleCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_AdapCruiseControl(most_fi_tcl_e8_GMLnGWPerfModeVisualization_AdapCruiseControl& /*oe8_GMLnGWPerfModeVisualization_AdapCruiseControl*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_AdapCruiseControl::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_AdapCruiseControl(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Displays(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Displays& /*oe8_GMLnGWPerfModeVisualization_Displays*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Displays::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Displays(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Driveline(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Driveline& /*oe8_GMLnGWPerfModeVisualization_Driveline*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Driveline::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Driveline(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_DriverSeat(most_fi_tcl_e8_GMLnGWPerfModeVisualization_DriverSeat& /*oe8_GMLnGWPerfModeVisualization_DriverSeat*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_DriverSeat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_DriverSeat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Engine(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Engine& /*oe8_GMLnGWPerfModeVisualization_Engine*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Engine::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Engine(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Exhaust(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Exhaust& /*oe8_GMLnGWPerfModeVisualization_Exhaust*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Exhaust::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Exhaust(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_PassengerSeat(most_fi_tcl_e8_GMLnGWPerfModeVisualization_PassengerSeat& /*oe8_GMLnGWPerfModeVisualization_PassengerSeat*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_PassengerSeat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_PassengerSeat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Sound(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Sound& /*oe8_GMLnGWPerfModeVisualization_Sound*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Sound::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Sound(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Steering(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Steering& /*oe8_GMLnGWPerfModeVisualization_Steering*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Steering::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Steering(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Suspension(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Suspension& /*oe8_GMLnGWPerfModeVisualization_Suspension*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Suspension::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Suspension(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPerfModeVisualization_Trans(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Trans& /*oe8_GMLnGWPerfModeVisualization_Trans*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPerfModeVisualization_Trans::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPerfModeVisualization_Trans(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWExtendedHillStartAssistCustomizationSetting(most_fi_tcl_e8_GMLnGWExtendedHillStartAssistCustomizationSetting& /*oe8_GMLnGWExtendedHillStartAssistCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWExtendedHillStartAssistCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWExtendedHillStartAssistCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearPedestrianDetectionCustomizationSetting(most_fi_tcl_e8_GMLnGWRearPedestrianDetectionCustomizationSetting& /*oe8_GMLnGWRearPedestrianDetectionCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearPedestrianDetectionCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearPedestrianDetectionCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingCustomizationSetting(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomizationSetting& /*oe8_GMLnGWLocationBasedChargingCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWFrontPedestrianDetectionCustomizationSetting(most_fi_tcl_e8_GMLnGWFrontPedestrianDetectionCustomizationSetting& /*oe8_GMLnGWFrontPedestrianDetectionCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWFrontPedestrianDetectionCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWFrontPedestrianDetectionCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings(most_fi_tcl_e8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings& /*oe8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearSeatReminderCustomizationSetting(most_fi_tcl_e8_GMLnGWRearSeatReminderCustomizationSetting& /*oe8_GMLnGWRearSeatReminderCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearSeatReminderCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearSeatReminderCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRunningBoardsCustomizationSetting(most_fi_tcl_e8_GMLnGWRunningBoardsCustomizationSetting& /*oe8_GMLnGWRunningBoardsCustomizationSetting*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRunningBoardsCustomizationSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRunningBoardsCustomizationSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode1Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode1Status& /*oe8_GMLnGWDriverSelectedMode1Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode1Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode1Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode2Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode2Status& /*oe8_GMLnGWDriverSelectedMode2Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode2Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode2Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode3Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode3Status& /*oe8_GMLnGWDriverSelectedMode3Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode3Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode3Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode4Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode4Status& /*oe8_GMLnGWDriverSelectedMode4Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode4Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode4Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode5Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode5Status& /*oe8_GMLnGWDriverSelectedMode5Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode5Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode5Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode6Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode6Status& /*oe8_GMLnGWDriverSelectedMode6Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode6Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode6Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode7Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode7Status& /*oe8_GMLnGWDriverSelectedMode7Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode7Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode7Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSelectedMode8Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode8Status& /*oe8_GMLnGWDriverSelectedMode8Status*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSelectedMode8Status::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSelectedMode8Status(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest& /*oe8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest& /*oe8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest& /*oe8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest& /*oe8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest(most_fi_tcl_e8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest& /*oe8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest(most_fi_tcl_e8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest& /*oe8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWForwardObjectAlertWarningIndicationRequest(most_fi_tcl_e8_GMLnGWForwardObjectAlertWarningIndicationRequest& /*oe8_GMLnGWForwardObjectAlertWarningIndicationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWForwardObjectAlertWarningIndicationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWForwardObjectAlertWarningIndicationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWForwardObjectAlertStream(most_fi_tcl_GMLnGWForwardObjectAlertStream& /*oGMLnGWForwardObjectAlertStream*/)
{
}
tVoid most_fi_tcl_GMLnGWForwardObjectAlertStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWForwardObjectAlertStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLaneDepartureWarningAudibleWarningLocation(most_fi_tcl_e8_GMLnGWLaneDepartureWarningAudibleWarningLocation& /*oe8_GMLnGWLaneDepartureWarningAudibleWarningLocation*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLaneDepartureWarningAudibleWarningLocation::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLaneDepartureWarningAudibleWarningLocation(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest(most_fi_tcl_e8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest& /*oe8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftLaneDepartureWarningStatus(most_fi_tcl_e8_GMLnGWLeftLaneDepartureWarningStatus& /*oe8_GMLnGWLeftLaneDepartureWarningStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftLaneDepartureWarningStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftLaneDepartureWarningStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightLaneDepartureWarningStatus(most_fi_tcl_e8_GMLnGWRightLaneDepartureWarningStatus& /*oe8_GMLnGWRightLaneDepartureWarningStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightLaneDepartureWarningStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightLaneDepartureWarningStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLaneKeepingAssistAudibleWarningLocation(most_fi_tcl_e8_GMLnGWLaneKeepingAssistAudibleWarningLocation& /*oe8_GMLnGWLaneKeepingAssistAudibleWarningLocation*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLaneKeepingAssistAudibleWarningLocation::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLaneKeepingAssistAudibleWarningLocation(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest(most_fi_tcl_e8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest& /*oe8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftTurnLampActive(most_fi_tcl_e8_GMLnGWLeftTurnLampActive& /*oe8_GMLnGWLeftTurnLampActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftTurnLampActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftTurnLampActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightTurnLampActive(most_fi_tcl_e8_GMLnGWRightTurnLampActive& /*oe8_GMLnGWRightTurnLampActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightTurnLampActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightTurnLampActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWExtendedLightingStatusStream(most_fi_tcl_GMLnGWExtendedLightingStatusStream& /*oGMLnGWExtendedLightingStatusStream*/)
{
}
tVoid most_fi_tcl_GMLnGWExtendedLightingStatusStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWExtendedLightingStatusStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication(most_fi_tcl_e8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication& /*oe8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHighVoltageChargerSystemStatus(most_fi_tcl_e8_GMLnGWHighVoltageChargerSystemStatus& /*oe8_GMLnGWHighVoltageChargerSystemStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHighVoltageChargerSystemStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHighVoltageChargerSystemStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWExtendedHMIHybridVehicleStatus(most_fi_tcl_GMLnGWExtendedHMIHybridVehicleStatus& /*oGMLnGWExtendedHMIHybridVehicleStatus*/)
{
}
tVoid most_fi_tcl_GMLnGWExtendedHMIHybridVehicleStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWExtendedHMIHybridVehicleStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHighVoltageChargerPowerLevel(most_fi_tcl_e8_GMLnGWHighVoltageChargerPowerLevel& /*oe8_GMLnGWHighVoltageChargerPowerLevel*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHighVoltageChargerPowerLevel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHighVoltageChargerPowerLevel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWPropulsionDisplayInfoStream(most_fi_tcl_GMLnGWPropulsionDisplayInfoStream& /*oGMLnGWPropulsionDisplayInfoStream*/)
{
}
tVoid most_fi_tcl_GMLnGWPropulsionDisplayInfoStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWPropulsionDisplayInfoStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWRedundantHighVoltageBatteryPackStream(most_fi_tcl_GMLnGWRedundantHighVoltageBatteryPackStream& /*oGMLnGWRedundantHighVoltageBatteryPackStream*/)
{
}
tVoid most_fi_tcl_GMLnGWRedundantHighVoltageBatteryPackStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWRedundantHighVoltageBatteryPackStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWAirbagImpactDataStream(most_fi_tcl_GMLnGWAirbagImpactDataStream& /*oGMLnGWAirbagImpactDataStream*/)
{
}
tVoid most_fi_tcl_GMLnGWAirbagImpactDataStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWAirbagImpactDataStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHillDescentControlSystemStatus(most_fi_tcl_e8_GMLnGWHillDescentControlSystemStatus& /*oe8_GMLnGWHillDescentControlSystemStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHillDescentControlSystemStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHillDescentControlSystemStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel(most_fi_tcl_e8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel& /*oe8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPedestrianWarningIndicationRequest(most_fi_tcl_e8_GMLnGWPedestrianWarningIndicationRequest& /*oe8_GMLnGWPedestrianWarningIndicationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPedestrianWarningIndicationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPedestrianWarningIndicationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSpeedLimiterSettingTypeActive(most_fi_tcl_e8_GMLnGWSpeedLimiterSettingTypeActive& /*oe8_GMLnGWSpeedLimiterSettingTypeActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSpeedLimiterSettingTypeActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSpeedLimiterSettingTypeActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSpeedLimitVisionFusedSpeedMask(most_fi_tcl_e8_GMLnGWSpeedLimitVisionFusedSpeedMask& /*oe8_GMLnGWSpeedLimitVisionFusedSpeedMask*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSpeedLimitVisionFusedSpeedMask::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSpeedLimitVisionFusedSpeedMask(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSpeedLimitVisionFusedSpeedUnit(most_fi_tcl_e8_GMLnGWSpeedLimitVisionFusedSpeedUnit& /*oe8_GMLnGWSpeedLimitVisionFusedSpeedUnit*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSpeedLimitVisionFusedSpeedUnit::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSpeedLimitVisionFusedSpeedUnit(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWSpeedLimitVisionFusedSpeedStream(most_fi_tcl_GMLnGWSpeedLimitVisionFusedSpeedStream& /*oGMLnGWSpeedLimitVisionFusedSpeedStream*/)
{
}
tVoid most_fi_tcl_GMLnGWSpeedLimitVisionFusedSpeedStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWSpeedLimitVisionFusedSpeedStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPhoneSpeedRecAudioPromptStatus(most_fi_tcl_e8_GMLnGWPhoneSpeedRecAudioPromptStatus& /*oe8_GMLnGWPhoneSpeedRecAudioPromptStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPhoneSpeedRecAudioPromptStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPhoneSpeedRecAudioPromptStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTransmissionEngagedState(most_fi_tcl_e8_GMLnGWTransmissionEngagedState& /*oe8_GMLnGWTransmissionEngagedState*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTransmissionEngagedState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTransmissionEngagedState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWVehicleStabilityEnhancementMode(most_fi_tcl_e8_GMLnGWVehicleStabilityEnhancementMode& /*oe8_GMLnGWVehicleStabilityEnhancementMode*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWVehicleStabilityEnhancementMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWVehicleStabilityEnhancementMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWVehicleStabilityEnhancementStatus(most_fi_tcl_e8_GMLnGWVehicleStabilityEnhancementStatus& /*oe8_GMLnGWVehicleStabilityEnhancementStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWVehicleStabilityEnhancementStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWVehicleStabilityEnhancementStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWVehicleStabilityInfoStream(most_fi_tcl_GMLnGWVehicleStabilityInfoStream& /*oGMLnGWVehicleStabilityInfoStream*/)
{
}
tVoid most_fi_tcl_GMLnGWVehicleStabilityInfoStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWVehicleStabilityInfoStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWVehicleDisplayUnits(most_fi_tcl_e8_GMLnGWVehicleDisplayUnits& /*oe8_GMLnGWVehicleDisplayUnits*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWVehicleDisplayUnits::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWVehicleDisplayUnits(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWVINDigitStream(most_fi_tcl_GMLnGWVINDigitStream& /*oGMLnGWVINDigitStream*/)
{
}
tVoid most_fi_tcl_GMLnGWVINDigitStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWVINDigitStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTransmissionShiftLeverPosition(most_fi_tcl_e8_GMLnGWTransmissionShiftLeverPosition& /*oe8_GMLnGWTransmissionShiftLeverPosition*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTransmissionShiftLeverPosition::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTransmissionShiftLeverPosition(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTransmissionEstimatedGearPosition(most_fi_tcl_e8_GMLnGWTransmissionEstimatedGearPosition& /*oe8_GMLnGWTransmissionEstimatedGearPosition*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTransmissionEstimatedGearPosition::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTransmissionEstimatedGearPosition(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSWCSwitchState(most_fi_tcl_e8_GMLnGWSWCSwitchState& /*oe8_GMLnGWSWCSwitchState*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSWCSwitchState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSWCSwitchState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearCrossTrafficAlertLeftIndicationControl(most_fi_tcl_e8_GMLnGWRearCrossTrafficAlertLeftIndicationControl& /*oe8_GMLnGWRearCrossTrafficAlertLeftIndicationControl*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearCrossTrafficAlertLeftIndicationControl::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearCrossTrafficAlertLeftIndicationControl(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearCrossTrafficAlertRightIndicationControl(most_fi_tcl_e8_GMLnGWRearCrossTrafficAlertRightIndicationControl& /*oe8_GMLnGWRearCrossTrafficAlertRightIndicationControl*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearCrossTrafficAlertRightIndicationControl::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearCrossTrafficAlertRightIndicationControl(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistFrontRegion1ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion1ObjectStatus& /*oe8_GMLnGWParkAssistFrontRegion1ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistFrontRegion1ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistFrontRegion1ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistFrontRegion2ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion2ObjectStatus& /*oe8_GMLnGWParkAssistFrontRegion2ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistFrontRegion2ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistFrontRegion2ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistFrontRegion3ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion3ObjectStatus& /*oe8_GMLnGWParkAssistFrontRegion3ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistFrontRegion3ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistFrontRegion3ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistFrontRegion4ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion4ObjectStatus& /*oe8_GMLnGWParkAssistFrontRegion4ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistFrontRegion4ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistFrontRegion4ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistFrontSystemStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontSystemStatus& /*oe8_GMLnGWParkAssistFrontSystemStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistFrontSystemStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistFrontSystemStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistRearRegion1ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion1ObjectStatus& /*oe8_GMLnGWParkAssistRearRegion1ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistRearRegion1ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistRearRegion1ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistRearRegion2ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion2ObjectStatus& /*oe8_GMLnGWParkAssistRearRegion2ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistRearRegion2ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistRearRegion2ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistRearRegion3ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion3ObjectStatus& /*oe8_GMLnGWParkAssistRearRegion3ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistRearRegion3ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistRearRegion3ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistRearRegion4ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion4ObjectStatus& /*oe8_GMLnGWParkAssistRearRegion4ObjectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistRearRegion4ObjectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistRearRegion4ObjectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkAssistRearSystemStatus(most_fi_tcl_e8_GMLnGWParkAssistRearSystemStatus& /*oe8_GMLnGWParkAssistRearSystemStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkAssistRearSystemStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkAssistRearSystemStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWXMCurrentStationService(most_fi_tcl_e8_GMLnGWXMCurrentStationService& /*oe8_GMLnGWXMCurrentStationService*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWXMCurrentStationService::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWXMCurrentStationService(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWXMRadioServiceProvider(most_fi_tcl_e8_GMLnGWXMRadioServiceProvider& /*oe8_GMLnGWXMRadioServiceProvider*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWXMRadioServiceProvider::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWXMRadioServiceProvider(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSpeedLimitUnits(most_fi_tcl_e8_GMLnGWSpeedLimitUnits& /*oe8_GMLnGWSpeedLimitUnits*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSpeedLimitUnits::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSpeedLimitUnits(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLanguageSelection(most_fi_tcl_e8_GMLnGWLanguageSelection& /*oe8_GMLnGWLanguageSelection*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLanguageSelection::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLanguageSelection(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWFuelEconomyMetricDisplayUnits(most_fi_tcl_e8_GMLnGWFuelEconomyMetricDisplayUnits& /*oe8_GMLnGWFuelEconomyMetricDisplayUnits*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWFuelEconomyMetricDisplayUnits::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWFuelEconomyMetricDisplayUnits(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPowerConvertibleTopStatus(most_fi_tcl_e8_GMLnGWPowerConvertibleTopStatus& /*oe8_GMLnGWPowerConvertibleTopStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPowerConvertibleTopStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPowerConvertibleTopStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEngineCylinderDeactivationMode(most_fi_tcl_e8_GMLnGWEngineCylinderDeactivationMode& /*oe8_GMLnGWEngineCylinderDeactivationMode*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEngineCylinderDeactivationMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEngineCylinderDeactivationMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWVehicleMovementState(most_fi_tcl_e8_GMLnGWVehicleMovementState& /*oe8_GMLnGWVehicleMovementState*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWVehicleMovementState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWVehicleMovementState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus(most_fi_tcl_e8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus& /*oe8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWFrontPassengerSeatOccupancyFaultStatus(most_fi_tcl_e8_GMLnGWFrontPassengerSeatOccupancyFaultStatus& /*oe8_GMLnGWFrontPassengerSeatOccupancyFaultStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWFrontPassengerSeatOccupancyFaultStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWFrontPassengerSeatOccupancyFaultStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTargaTopState(most_fi_tcl_e8_GMLnGWTargaTopState& /*oe8_GMLnGWTargaTopState*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTargaTopState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTargaTopState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTargaTopStateValidity(most_fi_tcl_e8_GMLnGWTargaTopStateValidity& /*oe8_GMLnGWTargaTopStateValidity*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTargaTopStateValidity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTargaTopStateValidity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWCompassOctantHeading(most_fi_tcl_e8_GMLnGWCompassOctantHeading& /*oe8_GMLnGWCompassOctantHeading*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWCompassOctantHeading::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWCompassOctantHeading(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWFunctionalRoadClass(most_fi_tcl_e8_GMLnGWFunctionalRoadClass& /*oe8_GMLnGWFunctionalRoadClass*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWFunctionalRoadClass::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWFunctionalRoadClass(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWInternationalStdAlphaCountryCodeChar1(most_fi_tcl_e8_GMLnGWInternationalStdAlphaCountryCodeChar1& /*oe8_GMLnGWInternationalStdAlphaCountryCodeChar1*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWInternationalStdAlphaCountryCodeChar1::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWInternationalStdAlphaCountryCodeChar1(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWInternationalStdAlphaCountryCodeChar2(most_fi_tcl_e8_GMLnGWInternationalStdAlphaCountryCodeChar2& /*oe8_GMLnGWInternationalStdAlphaCountryCodeChar2*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWInternationalStdAlphaCountryCodeChar2::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWInternationalStdAlphaCountryCodeChar2(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLaneCategory(most_fi_tcl_e8_GMLnGWLaneCategory& /*oe8_GMLnGWLaneCategory*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLaneCategory::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLaneCategory(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRoadSpeedCategoryType(most_fi_tcl_e8_GMLnGWRoadSpeedCategoryType& /*oe8_GMLnGWRoadSpeedCategoryType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRoadSpeedCategoryType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRoadSpeedCategoryType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDTCFaultType(most_fi_tcl_e8_GMLnGWDTCFaultType& /*oe8_GMLnGWDTCFaultType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDTCFaultType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDTCFaultType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAutomaticBeamSelectStatus(most_fi_tcl_e8_GMLnGWAutomaticBeamSelectStatus& /*oe8_GMLnGWAutomaticBeamSelectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAutomaticBeamSelectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAutomaticBeamSelectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTractionControlSystemActive(most_fi_tcl_e8_GMLnGWTractionControlSystemActive& /*oe8_GMLnGWTractionControlSystemActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTractionControlSystemActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTractionControlSystemActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTractionControlSystemOperatingMode(most_fi_tcl_e8_GMLnGWTractionControlSystemOperatingMode& /*oe8_GMLnGWTractionControlSystemOperatingMode*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTractionControlSystemOperatingMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTractionControlSystemOperatingMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTractionControlSystemOperatingStatus(most_fi_tcl_e8_GMLnGWTractionControlSystemOperatingStatus& /*oe8_GMLnGWTractionControlSystemOperatingStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTractionControlSystemOperatingStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTractionControlSystemOperatingStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTransmissionShiftModeStatus(most_fi_tcl_e8_GMLnGWTransmissionShiftModeStatus& /*oe8_GMLnGWTransmissionShiftModeStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTransmissionShiftModeStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTransmissionShiftModeStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWCruiseAndSpeedLimiterSwitchStatus(most_fi_tcl_e8_GMLnGWCruiseAndSpeedLimiterSwitchStatus& /*oe8_GMLnGWCruiseAndSpeedLimiterSwitchStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWCruiseAndSpeedLimiterSwitchStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWCruiseAndSpeedLimiterSwitchStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWCruiseControlActive(most_fi_tcl_e8_GMLnGWCruiseControlActive& /*oe8_GMLnGWCruiseControlActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWCruiseControlActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWCruiseControlActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWCruiseControlEnabled(most_fi_tcl_e8_GMLnGWCruiseControlEnabled& /*oe8_GMLnGWCruiseControlEnabled*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWCruiseControlEnabled::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWCruiseControlEnabled(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAutomaticTransmissionCommandedGear(most_fi_tcl_e8_GMLnGWAutomaticTransmissionCommandedGear& /*oe8_GMLnGWAutomaticTransmissionCommandedGear*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAutomaticTransmissionCommandedGear::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAutomaticTransmissionCommandedGear(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWVehicleTopSpeedLimitModeActive(most_fi_tcl_e8_GMLnGWVehicleTopSpeedLimitModeActive& /*oe8_GMLnGWVehicleTopSpeedLimitModeActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWVehicleTopSpeedLimitModeActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWVehicleTopSpeedLimitModeActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRemoteVehicleStartEngineRunning(most_fi_tcl_e8_GMLnGWRemoteVehicleStartEngineRunning& /*oe8_GMLnGWRemoteVehicleStartEngineRunning*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRemoteVehicleStartEngineRunning::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRemoteVehicleStartEngineRunning(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAirConditioningCompressorCommand(most_fi_tcl_e8_GMLnGWAirConditioningCompressorCommand& /*oe8_GMLnGWAirConditioningCompressorCommand*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAirConditioningCompressorCommand::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAirConditioningCompressorCommand(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWFuelModeStatus(most_fi_tcl_e8_GMLnGWFuelModeStatus& /*oe8_GMLnGWFuelModeStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWFuelModeStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWFuelModeStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAdaptiveCruiseControlActive(most_fi_tcl_e8_GMLnGWAdaptiveCruiseControlActive& /*oe8_GMLnGWAdaptiveCruiseControlActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAdaptiveCruiseControlActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAdaptiveCruiseControlActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWCruiseControlDriverSelectedSpeedActive(most_fi_tcl_e8_GMLnGWCruiseControlDriverSelectedSpeedActive& /*oe8_GMLnGWCruiseControlDriverSelectedSpeedActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWCruiseControlDriverSelectedSpeedActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWCruiseControlDriverSelectedSpeedActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWAntilockBrakeSystemActive(most_fi_tcl_e8_GMLnGWAntilockBrakeSystemActive& /*oe8_GMLnGWAntilockBrakeSystemActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWAntilockBrakeSystemActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWAntilockBrakeSystemActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverWindowPositionStatus(most_fi_tcl_e8_GMLnGWDriverWindowPositionStatus& /*oe8_GMLnGWDriverWindowPositionStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverWindowPositionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverWindowPositionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearWindowPositionStatus(most_fi_tcl_e8_GMLnGWLeftRearWindowPositionStatus& /*oe8_GMLnGWLeftRearWindowPositionStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearWindowPositionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearWindowPositionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerWindowPositionStatus(most_fi_tcl_e8_GMLnGWPassengerWindowPositionStatus& /*oe8_GMLnGWPassengerWindowPositionStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerWindowPositionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerWindowPositionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearWindowPositionStatus(most_fi_tcl_e8_GMLnGWRightRearWindowPositionStatus& /*oe8_GMLnGWRightRearWindowPositionStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearWindowPositionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearWindowPositionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWBrakeLightsActive(most_fi_tcl_e8_GMLnGWBrakeLightsActive& /*oe8_GMLnGWBrakeLightsActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWBrakeLightsActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWBrakeLightsActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDaytimeRunningLampsActive(most_fi_tcl_e8_GMLnGWDaytimeRunningLampsActive& /*oe8_GMLnGWDaytimeRunningLampsActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDaytimeRunningLampsActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDaytimeRunningLampsActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHazardSwitchActive(most_fi_tcl_e8_GMLnGWHazardSwitchActive& /*oe8_GMLnGWHazardSwitchActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHazardSwitchActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHazardSwitchActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHeadlampBeamSelectStatus(most_fi_tcl_e8_GMLnGWHeadlampBeamSelectStatus& /*oe8_GMLnGWHeadlampBeamSelectStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHeadlampBeamSelectStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHeadlampBeamSelectStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWMainLightSwitch(most_fi_tcl_e8_GMLnGWMainLightSwitch& /*oe8_GMLnGWMainLightSwitch*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWMainLightSwitch::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWMainLightSwitch(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTurnSwitchActivation(most_fi_tcl_e8_GMLnGWTurnSwitchActivation& /*oe8_GMLnGWTurnSwitchActivation*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTurnSwitchActivation::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTurnSwitchActivation(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPowerLiftgateMotionStatus(most_fi_tcl_e8_GMLnGWPowerLiftgateMotionStatus& /*oe8_GMLnGWPowerLiftgateMotionStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPowerLiftgateMotionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPowerLiftgateMotionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearClosureObstacleDetected(most_fi_tcl_e8_GMLnGWRearClosureObstacleDetected& /*oe8_GMLnGWRearClosureObstacleDetected*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearClosureObstacleDetected::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearClosureObstacleDetected(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftSecondaryTurnIndicatorFailed(most_fi_tcl_e8_GMLnGWLeftSecondaryTurnIndicatorFailed& /*oe8_GMLnGWLeftSecondaryTurnIndicatorFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftSecondaryTurnIndicatorFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftSecondaryTurnIndicatorFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearLeftParkLampFailed(most_fi_tcl_e8_GMLnGWRearLeftParkLampFailed& /*oe8_GMLnGWRearLeftParkLampFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearLeftParkLampFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearLeftParkLampFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearRightParkLampFailed(most_fi_tcl_e8_GMLnGWRearRightParkLampFailed& /*oe8_GMLnGWRearRightParkLampFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearRightParkLampFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearRightParkLampFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightSecondaryTurnIndicatorFailed(most_fi_tcl_e8_GMLnGWRightSecondaryTurnIndicatorFailed& /*oe8_GMLnGWRightSecondaryTurnIndicatorFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightSecondaryTurnIndicatorFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightSecondaryTurnIndicatorFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTrailerBrakeLightFailed(most_fi_tcl_e8_GMLnGWTrailerBrakeLightFailed& /*oe8_GMLnGWTrailerBrakeLightFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTrailerBrakeLightFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTrailerBrakeLightFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTrailerFogLightFailed(most_fi_tcl_e8_GMLnGWTrailerFogLightFailed& /*oe8_GMLnGWTrailerFogLightFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTrailerFogLightFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTrailerFogLightFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTrailerFogLightPresent(most_fi_tcl_e8_GMLnGWTrailerFogLightPresent& /*oe8_GMLnGWTrailerFogLightPresent*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTrailerFogLightPresent::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTrailerFogLightPresent(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTrailerHitchSwitchActive(most_fi_tcl_e8_GMLnGWTrailerHitchSwitchActive& /*oe8_GMLnGWTrailerHitchSwitchActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTrailerHitchSwitchActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTrailerHitchSwitchActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTrailerTailLightFailed(most_fi_tcl_e8_GMLnGWTrailerTailLightFailed& /*oe8_GMLnGWTrailerTailLightFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTrailerTailLightFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTrailerTailLightFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSpareTireStatus(most_fi_tcl_e8_GMLnGWSpareTireStatus& /*oe8_GMLnGWSpareTireStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSpareTireStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSpareTireStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTireInflationMonitoringSystemResetPerformed(most_fi_tcl_e8_GMLnGWTireInflationMonitoringSystemResetPerformed& /*oe8_GMLnGWTireInflationMonitoringSystemResetPerformed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTireInflationMonitoringSystemResetPerformed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTireInflationMonitoringSystemResetPerformed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTirePressureMonitoringSystemFailed(most_fi_tcl_e8_GMLnGWTirePressureMonitoringSystemFailed& /*oe8_GMLnGWTirePressureMonitoringSystemFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTirePressureMonitoringSystemFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTirePressureMonitoringSystemFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWParkingAssistanceFunctionFailed(most_fi_tcl_e8_GMLnGWParkingAssistanceFunctionFailed& /*oe8_GMLnGWParkingAssistanceFunctionFailed*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWParkingAssistanceFunctionFailed::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWParkingAssistanceFunctionFailed(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWWasherFluidLow(most_fi_tcl_e8_GMLnGWWasherFluidLow& /*oe8_GMLnGWWasherFluidLow*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWWasherFluidLow::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWWasherFluidLow(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWWindshieldWiperActive(most_fi_tcl_e8_GMLnGWWindshieldWiperActive& /*oe8_GMLnGWWindshieldWiperActive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWWindshieldWiperActive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWWindshieldWiperActive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHoodStatus(most_fi_tcl_e8_GMLnGWHoodStatus& /*oe8_GMLnGWHoodStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHoodStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHoodStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWWirelessChargingSystemChargingStatus(most_fi_tcl_e8_GMLnGWWirelessChargingSystemChargingStatus& /*oe8_GMLnGWWirelessChargingSystemChargingStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWWirelessChargingSystemChargingStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWWirelessChargingSystemChargingStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDigitalMapConditionalSpeedLimit(most_fi_tcl_e8_GMLnGWDigitalMapConditionalSpeedLimit& /*oe8_GMLnGWDigitalMapConditionalSpeedLimit*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDigitalMapConditionalSpeedLimit::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDigitalMapConditionalSpeedLimit(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDigitalMapConditionalSpeedLimitType(most_fi_tcl_e8_GMLnGWDigitalMapConditionalSpeedLimitType& /*oe8_GMLnGWDigitalMapConditionalSpeedLimitType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDigitalMapConditionalSpeedLimitType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDigitalMapConditionalSpeedLimitType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDigitalMapSpeedCategory(most_fi_tcl_e8_GMLnGWDigitalMapSpeedCategory& /*oe8_GMLnGWDigitalMapSpeedCategory*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDigitalMapSpeedCategory::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDigitalMapSpeedCategory(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDigitalMapVersionQuarter(most_fi_tcl_e8_GMLnGWDigitalMapVersionQuarter& /*oe8_GMLnGWDigitalMapVersionQuarter*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDigitalMapVersionQuarter::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDigitalMapVersionQuarter(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDigitalMapDrivingSide(most_fi_tcl_e8_GMLnGWDigitalMapDrivingSide& /*oe8_GMLnGWDigitalMapDrivingSide*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDigitalMapDrivingSide::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDigitalMapDrivingSide(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDigitalMapPassingRestriction(most_fi_tcl_e8_GMLnGWDigitalMapPassingRestriction& /*oe8_GMLnGWDigitalMapPassingRestriction*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDigitalMapPassingRestriction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDigitalMapPassingRestriction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWADASISLiteExtendedInfoStream(most_fi_tcl_GMLnGWADASISLiteExtendedInfoStream& /*oGMLnGWADASISLiteExtendedInfoStream*/)
{
}
tVoid most_fi_tcl_GMLnGWADASISLiteExtendedInfoStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWADASISLiteExtendedInfoStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWElectricParkBrakeStatus(most_fi_tcl_e8_GMLnGWElectricParkBrakeStatus& /*oe8_GMLnGWElectricParkBrakeStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWElectricParkBrakeStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWElectricParkBrakeStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWGMLANGPSConfiguration(most_fi_tcl_e8_GMLnGWGMLANGPSConfiguration& /*oe8_GMLnGWGMLANGPSConfiguration*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWGMLANGPSConfiguration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWGMLANGPSConfiguration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWCalendarMonth(most_fi_tcl_e8_GMLnGWCalendarMonth& /*oe8_GMLnGWCalendarMonth*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWCalendarMonth::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWCalendarMonth(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWInteriorDimmingAnimationType(most_fi_tcl_e8_GMLnGWInteriorDimmingAnimationType& /*oe8_GMLnGWInteriorDimmingAnimationType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWInteriorDimmingAnimationType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWInteriorDimmingAnimationType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWInteriorDimmingColorType(most_fi_tcl_e8_GMLnGWInteriorDimmingColorType& /*oe8_GMLnGWInteriorDimmingColorType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWInteriorDimmingColorType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWInteriorDimmingColorType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWBatteryChargeCordAlert(most_fi_tcl_e8_GMLnGWBatteryChargeCordAlert& /*oe8_GMLnGWBatteryChargeCordAlert*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWBatteryChargeCordAlert::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWBatteryChargeCordAlert(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeDisplayStatus(most_fi_tcl_e8_GMLnGWChargeDisplayStatus& /*oe8_GMLnGWChargeDisplayStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeDisplayStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeDisplayStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargingPortDoorState(most_fi_tcl_e8_GMLnGWChargingPortDoorState& /*oe8_GMLnGWChargingPortDoorState*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargingPortDoorState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargingPortDoorState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLowPowerDayOfWeek(most_fi_tcl_e8_GMLnGWLowPowerDayOfWeek& /*oe8_GMLnGWLowPowerDayOfWeek*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLowPowerDayOfWeek::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLowPowerDayOfWeek(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHighPowerDayOfWeek(most_fi_tcl_e8_GMLnGWHighPowerDayOfWeek& /*oe8_GMLnGWHighPowerDayOfWeek*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHighPowerDayOfWeek::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHighPowerDayOfWeek(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWStartTimeHighPowerDayOfWeek(most_fi_tcl_e8_GMLnGWStartTimeHighPowerDayOfWeek& /*oe8_GMLnGWStartTimeHighPowerDayOfWeek*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWStartTimeHighPowerDayOfWeek::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWStartTimeHighPowerDayOfWeek(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWStartTimeLowPowerDayOfWeek(most_fi_tcl_e8_GMLnGWStartTimeLowPowerDayOfWeek& /*oe8_GMLnGWStartTimeLowPowerDayOfWeek*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWStartTimeLowPowerDayOfWeek::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWStartTimeLowPowerDayOfWeek(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWMaintenanceModeDisplayRequest(most_fi_tcl_e8_GMLnGWMaintenanceModeDisplayRequest& /*oe8_GMLnGWMaintenanceModeDisplayRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWMaintenanceModeDisplayRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWMaintenanceModeDisplayRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWNextPlannedDepartureDayOfWeek(most_fi_tcl_e8_GMLnGWNextPlannedDepartureDayOfWeek& /*oe8_GMLnGWNextPlannedDepartureDayOfWeek*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWNextPlannedDepartureDayOfWeek::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWNextPlannedDepartureDayOfWeek(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHybridModeDisplayRequest(most_fi_tcl_e8_GMLnGWHybridModeDisplayRequest& /*oe8_GMLnGWHybridModeDisplayRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHybridModeDisplayRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHybridModeDisplayRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTimeBasedChargingModeRequest(most_fi_tcl_e8_GMLnGWTimeBasedChargingModeRequest& /*oe8_GMLnGWTimeBasedChargingModeRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTimeBasedChargingModeRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTimeBasedChargingModeRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTimeBasedChargingModeResponse(most_fi_tcl_e8_GMLnGWTimeBasedChargingModeResponse& /*oe8_GMLnGWTimeBasedChargingModeResponse*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTimeBasedChargingModeResponse::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTimeBasedChargingModeResponse(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeRateDaySetRequest(most_fi_tcl_e8_GMLnGWChargeRateDaySetRequest& /*oe8_GMLnGWChargeRateDaySetRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeRateDaySetRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeRateDaySetRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeRateEnableSetRequest(most_fi_tcl_e8_GMLnGWChargeRateEnableSetRequest& /*oe8_GMLnGWChargeRateEnableSetRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeRateEnableSetRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeRateEnableSetRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeRateSelectedSetRequest(most_fi_tcl_e8_GMLnGWChargeRateSelectedSetRequest& /*oe8_GMLnGWChargeRateSelectedSetRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeRateSelectedSetRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeRateSelectedSetRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeRateDayStatus(most_fi_tcl_e8_GMLnGWChargeRateDayStatus& /*oe8_GMLnGWChargeRateDayStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeRateDayStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeRateDayStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeRateEnableStatus(most_fi_tcl_e8_GMLnGWChargeRateEnableStatus& /*oe8_GMLnGWChargeRateEnableStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeRateEnableStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeRateEnableStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeRateSelectedStatus(most_fi_tcl_e8_GMLnGWChargeRateSelectedStatus& /*oe8_GMLnGWChargeRateSelectedStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeRateSelectedStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeRateSelectedStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDelayedChargingDay(most_fi_tcl_e8_GMLnGWDelayedChargingDay& /*oe8_GMLnGWDelayedChargingDay*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDelayedChargingDay::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDelayedChargingDay(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDelayedChargingSeason(most_fi_tcl_e8_GMLnGWDelayedChargingSeason& /*oe8_GMLnGWDelayedChargingSeason*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDelayedChargingSeason::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDelayedChargingSeason(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDelayedChargingSelected(most_fi_tcl_e8_GMLnGWDelayedChargingSelected& /*oe8_GMLnGWDelayedChargingSelected*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDelayedChargingSelected::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDelayedChargingSelected(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDelayedChargingDayStatus(most_fi_tcl_e8_GMLnGWDelayedChargingDayStatus& /*oe8_GMLnGWDelayedChargingDayStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDelayedChargingDayStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDelayedChargingDayStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDelayedChargingSeasonStatus(most_fi_tcl_e8_GMLnGWDelayedChargingSeasonStatus& /*oe8_GMLnGWDelayedChargingSeasonStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDelayedChargingSeasonStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDelayedChargingSeasonStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDelayedChargingSelectedStatus(most_fi_tcl_e8_GMLnGWDelayedChargingSelectedStatus& /*oe8_GMLnGWDelayedChargingSelectedStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDelayedChargingSelectedStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDelayedChargingSelectedStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingDay(most_fi_tcl_e8_GMLnGWRateChargingDay& /*oe8_GMLnGWRateChargingDay*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingDay::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingDay(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingSeason(most_fi_tcl_e8_GMLnGWRateChargingSeason& /*oe8_GMLnGWRateChargingSeason*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingSeason::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingSeason(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingSelected(most_fi_tcl_e8_GMLnGWRateChargingSelected& /*oe8_GMLnGWRateChargingSelected*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingSelected::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingSelected(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingSelectedRate(most_fi_tcl_e8_GMLnGWRateChargingSelectedRate& /*oe8_GMLnGWRateChargingSelectedRate*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingSelectedRate::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingSelectedRate(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingDayStatus(most_fi_tcl_e8_GMLnGWRateChargingDayStatus& /*oe8_GMLnGWRateChargingDayStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingDayStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingDayStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingSeasonStatus(most_fi_tcl_e8_GMLnGWRateChargingSeasonStatus& /*oe8_GMLnGWRateChargingSeasonStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingSeasonStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingSeasonStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingSelectedRateStatus(most_fi_tcl_e8_GMLnGWRateChargingSelectedRateStatus& /*oe8_GMLnGWRateChargingSelectedRateStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingSelectedRateStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingSelectedRateStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateChargingSelectedStatus(most_fi_tcl_e8_GMLnGWRateChargingSelectedStatus& /*oe8_GMLnGWRateChargingSelectedStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateChargingSelectedStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateChargingSelectedStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSeason(most_fi_tcl_e8_GMLnGWSeason& /*oe8_GMLnGWSeason*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSeason::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSeason(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSeasonMonth(most_fi_tcl_e8_GMLnGWSeasonMonth& /*oe8_GMLnGWSeasonMonth*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSeasonMonth::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSeasonMonth(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSeasonSelected(most_fi_tcl_e8_GMLnGWSeasonSelected& /*oe8_GMLnGWSeasonSelected*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSeasonSelected::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSeasonSelected(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSeasonMonthStatus(most_fi_tcl_e8_GMLnGWSeasonMonthStatus& /*oe8_GMLnGWSeasonMonthStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSeasonMonthStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSeasonMonthStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSeasonSelectedStatus(most_fi_tcl_e8_GMLnGWSeasonSelectedStatus& /*oe8_GMLnGWSeasonSelectedStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSeasonSelectedStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSeasonSelectedStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSeasonStatus(most_fi_tcl_e8_GMLnGWSeasonStatus& /*oe8_GMLnGWSeasonStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSeasonStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSeasonStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive(most_fi_tcl_e8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive& /*oe8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek(most_fi_tcl_e8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek& /*oe8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWChargeLevelPreferenceStatus(most_fi_tcl_e8_GMLnGWChargeLevelPreferenceStatus& /*oe8_GMLnGWChargeLevelPreferenceStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWChargeLevelPreferenceStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWChargeLevelPreferenceStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWUserInterfaceType(most_fi_tcl_e8_GMLnGWUserInterfaceType& /*oe8_GMLnGWUserInterfaceType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWUserInterfaceType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWUserInterfaceType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSetChargingSystemChargeLevelPreference(most_fi_tcl_e8_GMLnGWSetChargingSystemChargeLevelPreference& /*oe8_GMLnGWSetChargingSystemChargeLevelPreference*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSetChargingSystemChargeLevelPreference::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSetChargingSystemChargeLevelPreference(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus(most_fi_tcl_e8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus& /*oe8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWJumpStartStatus(most_fi_tcl_e8_GMLnGWJumpStartStatus& /*oe8_GMLnGWJumpStartStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWJumpStartStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWJumpStartStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWHybridChargeModeState(most_fi_tcl_e8_GMLnGWHybridChargeModeState& /*oe8_GMLnGWHybridChargeModeState*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWHybridChargeModeState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWHybridChargeModeState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphMeasurement(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphMeasurement& /*oe8_GMLnGWEnergyConsumptionHistoryGraphMeasurement*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphMeasurement::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphMeasurement(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval& /*oe8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue& /*oe8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWEnergyEconomyDataStream(most_fi_tcl_GMLnGWEnergyEconomyDataStream& /*oGMLnGWEnergyEconomyDataStream*/)
{
}
tVoid most_fi_tcl_GMLnGWEnergyEconomyDataStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWEnergyEconomyDataStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest(most_fi_tcl_e8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest& /*oe8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse(most_fi_tcl_e8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse& /*oe8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest& /*oe8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber& /*oe8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse& /*oe8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber& /*oe8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingPositionStoreRequest(most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStoreRequest& /*oe8_GMLnGWLocationBasedChargingPositionStoreRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStoreRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingPositionStoreRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus(most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus& /*oe8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation(most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation& /*oe8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation(most_fi_tcl_e8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation& /*oe8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWEnergyUsageScoreDataStream(most_fi_tcl_GMLnGWEnergyUsageScoreDataStream& /*oGMLnGWEnergyUsageScoreDataStream*/)
{
}
tVoid most_fi_tcl_GMLnGWEnergyUsageScoreDataStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWEnergyUsageScoreDataStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWEnergyUsageScoreScalingDataStream(most_fi_tcl_GMLnGWEnergyUsageScoreScalingDataStream& /*oGMLnGWEnergyUsageScoreScalingDataStream*/)
{
}
tVoid most_fi_tcl_GMLnGWEnergyUsageScoreScalingDataStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWEnergyUsageScoreScalingDataStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit& /*oe8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval& /*oe8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWEnergyUsageScreenMeasurementUnits(most_fi_tcl_e8_GMLnGWEnergyUsageScreenMeasurementUnits& /*oe8_GMLnGWEnergyUsageScreenMeasurementUnits*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWEnergyUsageScreenMeasurementUnits::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWEnergyUsageScreenMeasurementUnits(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut& /*oe8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_BackBolsterInOut& /*oe8_GMLnGWDriverSeatControlStatus_BackBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_BackBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_BackBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut& /*oe8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust& /*oe8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_DisplaySize& /*oe8_GMLnGWDriverSeatControlStatus_DisplaySize*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_DisplaySize::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_DisplaySize(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd& /*oe8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward& /*oe8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDown& /*oe8_GMLnGWDriverSeatControlStatus_HeadrestUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd& /*oe8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut& /*oe8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward& /*oe8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarUpDown& /*oe8_GMLnGWDriverSeatControlStatus_LumbarUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward& /*oe8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_Massage& /*oe8_GMLnGWDriverSeatControlStatus_Massage*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_Massage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_Massage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_MassageIntensity& /*oe8_GMLnGWDriverSeatControlStatus_MassageIntensity*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_MassageIntensity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_MassageIntensity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_MassageType& /*oe8_GMLnGWDriverSeatControlStatus_MassageType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_MassageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_MassageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward& /*oe8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut& /*oe8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut& /*oe8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut& /*oe8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust& /*oe8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_DisplaySize& /*oe8_GMLnGWPassengerSeatControlStatus_DisplaySize*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_DisplaySize::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_DisplaySize(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd& /*oe8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward& /*oe8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown& /*oe8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd& /*oe8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut& /*oe8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward& /*oe8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDown& /*oe8_GMLnGWPassengerSeatControlStatus_LumbarUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward& /*oe8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_Massage& /*oe8_GMLnGWPassengerSeatControlStatus_Massage*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_Massage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_Massage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_MassageIntensity& /*oe8_GMLnGWPassengerSeatControlStatus_MassageIntensity*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_MassageIntensity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_MassageIntensity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_MassageType& /*oe8_GMLnGWPassengerSeatControlStatus_MassageType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_MassageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_MassageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward& /*oe8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut& /*oe8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut& /*oe8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut& /*oe8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust& /*oe8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_DisplaySize& /*oe8_GMLnGWLeftRearSeatControlStatus_DisplaySize*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_DisplaySize::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_DisplaySize(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd& /*oe8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward& /*oe8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown& /*oe8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd& /*oe8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut& /*oe8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward& /*oe8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown& /*oe8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward& /*oe8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_Massage& /*oe8_GMLnGWLeftRearSeatControlStatus_Massage*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_Massage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_Massage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_MassageIntensity& /*oe8_GMLnGWLeftRearSeatControlStatus_MassageIntensity*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_MassageIntensity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_MassageIntensity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_MassageType& /*oe8_GMLnGWLeftRearSeatControlStatus_MassageType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_MassageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_MassageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward& /*oe8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut& /*oe8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut& /*oe8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut& /*oe8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust& /*oe8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_DisplaySize& /*oe8_GMLnGWRightRearSeatControlStatus_DisplaySize*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_DisplaySize::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_DisplaySize(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd& /*oe8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward& /*oe8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown& /*oe8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd& /*oe8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut& /*oe8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward& /*oe8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDown& /*oe8_GMLnGWRightRearSeatControlStatus_LumbarUpDown*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDown::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDown(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward& /*oe8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_Massage& /*oe8_GMLnGWRightRearSeatControlStatus_Massage*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_Massage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_Massage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_MassageIntensity& /*oe8_GMLnGWRightRearSeatControlStatus_MassageIntensity*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_MassageIntensity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_MassageIntensity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_MassageType& /*oe8_GMLnGWRightRearSeatControlStatus_MassageType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_MassageType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_MassageType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward& /*oe8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWRearSeatKey(most_fi_tcl_e8_GMLnGWRearSeatKey& /*oe8_GMLnGWRearSeatKey*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWRearSeatKey::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWRearSeatKey(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTeenDriverRequest(most_fi_tcl_e8_GMLnGWTeenDriverRequest& /*oe8_GMLnGWTeenDriverRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTeenDriverRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTeenDriverRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTeenDriverResponse(most_fi_tcl_e8_GMLnGWTeenDriverResponse& /*oe8_GMLnGWTeenDriverResponse*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTeenDriverResponse::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTeenDriverResponse(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWSpeedLimitStatus(most_fi_tcl_e8_GMLnGWSpeedLimitStatus& /*oe8_GMLnGWSpeedLimitStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWSpeedLimitStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWSpeedLimitStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWOverspeedWarningCurrentStatus(most_fi_tcl_e8_GMLnGWOverspeedWarningCurrentStatus& /*oe8_GMLnGWOverspeedWarningCurrentStatus*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWOverspeedWarningCurrentStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWOverspeedWarningCurrentStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWVideoProcessingFeatureConfigurationStream(most_fi_tcl_GMLnGWVideoProcessingFeatureConfigurationStream& /*oGMLnGWVideoProcessingFeatureConfigurationStream*/)
{
}
tVoid most_fi_tcl_GMLnGWVideoProcessingFeatureConfigurationStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWVideoProcessingFeatureConfigurationStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWTouchProximity(most_fi_tcl_e8_GMLnGWTouchProximity& /*oe8_GMLnGWTouchProximity*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWTouchProximity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWTouchProximity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWWifiSSIDDigits1_8(most_fi_tcl_GMLnGWWifiSSIDDigits1_8& /*oGMLnGWWifiSSIDDigits1_8*/)
{
}
tVoid most_fi_tcl_GMLnGWWifiSSIDDigits1_8::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWWifiSSIDDigits1_8(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWWifiSSIDDigits9_16(most_fi_tcl_GMLnGWWifiSSIDDigits9_16& /*oGMLnGWWifiSSIDDigits9_16*/)
{
}
tVoid most_fi_tcl_GMLnGWWifiSSIDDigits9_16::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWWifiSSIDDigits9_16(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWWifiSSIDDigits17_24(most_fi_tcl_GMLnGWWifiSSIDDigits17_24& /*oGMLnGWWifiSSIDDigits17_24*/)
{
}
tVoid most_fi_tcl_GMLnGWWifiSSIDDigits17_24::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWWifiSSIDDigits17_24(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWWifiPassPhraseDigits1_8(most_fi_tcl_GMLnGWWifiPassPhraseDigits1_8& /*oGMLnGWWifiPassPhraseDigits1_8*/)
{
}
tVoid most_fi_tcl_GMLnGWWifiPassPhraseDigits1_8::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWWifiPassPhraseDigits1_8(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWWifiPassPhraseDigits9_16(most_fi_tcl_GMLnGWWifiPassPhraseDigits9_16& /*oGMLnGWWifiPassPhraseDigits9_16*/)
{
}
tVoid most_fi_tcl_GMLnGWWifiPassPhraseDigits9_16::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWWifiPassPhraseDigits9_16(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWWifiPassPhraseDigits17_24(most_fi_tcl_GMLnGWWifiPassPhraseDigits17_24& /*oGMLnGWWifiPassPhraseDigits17_24*/)
{
}
tVoid most_fi_tcl_GMLnGWWifiPassPhraseDigits17_24::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWWifiPassPhraseDigits17_24(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWInfotainmentWifiEnabled(most_fi_tcl_e8_GMLnGWInfotainmentWifiEnabled& /*oe8_GMLnGWInfotainmentWifiEnabled*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWInfotainmentWifiEnabled::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWInfotainmentWifiEnabled(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWWifiEncryptionType(most_fi_tcl_e8_GMLnGWWifiEncryptionType& /*oe8_GMLnGWWifiEncryptionType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWWifiEncryptionType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWWifiEncryptionType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWWifiSecurityType(most_fi_tcl_e8_GMLnGWWifiSecurityType& /*oe8_GMLnGWWifiSecurityType*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWWifiSecurityType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWWifiSecurityType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_GMLnGWWifiAssociationRequest(most_fi_tcl_e8_GMLnGWWifiAssociationRequest& /*oe8_GMLnGWWifiAssociationRequest*/)
{
}
tVoid most_fi_tcl_e8_GMLnGWWifiAssociationRequest::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_GMLnGWWifiAssociationRequest(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_GMLnGWWifiStationMediaAccessControlAddress(most_fi_tcl_GMLnGWWifiStationMediaAccessControlAddress& /*oGMLnGWWifiStationMediaAccessControlAddress*/)
{
}
tVoid most_fi_tcl_GMLnGWWifiStationMediaAccessControlAddress::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_GMLnGWWifiStationMediaAccessControlAddress(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACHVACSettingsEventEnum(most_fi_tcl_e8_HVACHVACSettingsEventEnum& /*oe8_HVACHVACSettingsEventEnum*/)
{
}
tVoid most_fi_tcl_e8_HVACHVACSettingsEventEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACHVACSettingsEventEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFanSpeedReductionValue(most_fi_tcl_e8_HVACFanSpeedReductionValue& /*oe8_HVACFanSpeedReductionValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFanSpeedReductionValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFanSpeedReductionValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFront_BlowerModeValue(most_fi_tcl_e8_HVACFront_BlowerModeValue& /*oe8_HVACFront_BlowerModeValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFront_BlowerModeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFront_BlowerModeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFront_FanSpeedValue(most_fi_tcl_e8_HVACFront_FanSpeedValue& /*oe8_HVACFront_FanSpeedValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFront_FanSpeedValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFront_FanSpeedValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFront_LeftSetTempValue(most_fi_tcl_e8_HVACFront_LeftSetTempValue& /*oe8_HVACFront_LeftSetTempValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFront_LeftSetTempValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFront_LeftSetTempValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFront_RightSetTempValue(most_fi_tcl_e8_HVACFront_RightSetTempValue& /*oe8_HVACFront_RightSetTempValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFront_RightSetTempValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFront_RightSetTempValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACRear_BlowerModeValue(most_fi_tcl_e8_HVACRear_BlowerModeValue& /*oe8_HVACRear_BlowerModeValue*/)
{
}
tVoid most_fi_tcl_e8_HVACRear_BlowerModeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACRear_BlowerModeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACRear_FanSpeedValue(most_fi_tcl_e8_HVACRear_FanSpeedValue& /*oe8_HVACRear_FanSpeedValue*/)
{
}
tVoid most_fi_tcl_e8_HVACRear_FanSpeedValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACRear_FanSpeedValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACRear_SetPointSetTempValue(most_fi_tcl_e8_HVACRear_SetPointSetTempValue& /*oe8_HVACRear_SetPointSetTempValue*/)
{
}
tVoid most_fi_tcl_e8_HVACRear_SetPointSetTempValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACRear_SetPointSetTempValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACZoneValue(most_fi_tcl_e8_HVACZoneValue& /*oe8_HVACZoneValue*/)
{
}
tVoid most_fi_tcl_e8_HVACZoneValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACZoneValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACAirQualitySensorValue(most_fi_tcl_e8_HVACAirQualitySensorValue& /*oe8_HVACAirQualitySensorValue*/)
{
}
tVoid most_fi_tcl_e8_HVACAirQualitySensorValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACAirQualitySensorValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACAutoDefogValue(most_fi_tcl_e8_HVACAutoDefogValue& /*oe8_HVACAutoDefogValue*/)
{
}
tVoid most_fi_tcl_e8_HVACAutoDefogValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACAutoDefogValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACAirConditionValue(most_fi_tcl_e8_HVACAirConditionValue& /*oe8_HVACAirConditionValue*/)
{
}
tVoid most_fi_tcl_e8_HVACAirConditionValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACAirConditionValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACAirInletValue(most_fi_tcl_e8_HVACAirInletValue& /*oe8_HVACAirInletValue*/)
{
}
tVoid most_fi_tcl_e8_HVACAirInletValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACAirInletValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACMaximum_Front_FanSpeedValue(most_fi_tcl_e8_HVACMaximum_Front_FanSpeedValue& /*oe8_HVACMaximum_Front_FanSpeedValue*/)
{
}
tVoid most_fi_tcl_e8_HVACMaximum_Front_FanSpeedValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACMaximum_Front_FanSpeedValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFront_LeftThermalSeatValue(most_fi_tcl_e8_HVACFront_LeftThermalSeatValue& /*oe8_HVACFront_LeftThermalSeatValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFront_LeftThermalSeatValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFront_LeftThermalSeatValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFront_RightThermalSeatValue(most_fi_tcl_e8_HVACFront_RightThermalSeatValue& /*oe8_HVACFront_RightThermalSeatValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFront_RightThermalSeatValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFront_RightThermalSeatValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACRear_DefogValue(most_fi_tcl_e8_HVACRear_DefogValue& /*oe8_HVACRear_DefogValue*/)
{
}
tVoid most_fi_tcl_e8_HVACRear_DefogValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACRear_DefogValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACHybridEconModeValue(most_fi_tcl_e8_HVACHybridEconModeValue& /*oe8_HVACHybridEconModeValue*/)
{
}
tVoid most_fi_tcl_e8_HVACHybridEconModeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACHybridEconModeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACHighVoltageHeaterValue(most_fi_tcl_e8_HVACHighVoltageHeaterValue& /*oe8_HVACHighVoltageHeaterValue*/)
{
}
tVoid most_fi_tcl_e8_HVACHighVoltageHeaterValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACHighVoltageHeaterValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACRear_PanelLockValue(most_fi_tcl_e8_HVACRear_PanelLockValue& /*oe8_HVACRear_PanelLockValue*/)
{
}
tVoid most_fi_tcl_e8_HVACRear_PanelLockValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACRear_PanelLockValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACRear_PanelSyncValue(most_fi_tcl_e8_HVACRear_PanelSyncValue& /*oe8_HVACRear_PanelSyncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACRear_PanelSyncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACRear_PanelSyncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_HybridFanOnlyValue(most_fi_tcl_e8_HVACFTouchButton_HybridFanOnlyValue& /*oe8_HVACFTouchButton_HybridFanOnlyValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_HybridFanOnlyValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_HybridFanOnlyValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_HybridEconValue(most_fi_tcl_e8_HVACFTouchButton_HybridEconValue& /*oe8_HVACFTouchButton_HybridEconValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_HybridEconValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_HybridEconValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_HybridComfortValue(most_fi_tcl_e8_HVACFTouchButton_HybridComfortValue& /*oe8_HVACFTouchButton_HybridComfortValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_HybridComfortValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_HybridComfortValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_LFAutoHeatedSeatValue(most_fi_tcl_e8_HVACFTouchButton_LFAutoHeatedSeatValue& /*oe8_HVACFTouchButton_LFAutoHeatedSeatValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_LFAutoHeatedSeatValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_LFAutoHeatedSeatValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RFAutoHeatedSeatValue(most_fi_tcl_e8_HVACFTouchButton_RFAutoHeatedSeatValue& /*oe8_HVACFTouchButton_RFAutoHeatedSeatValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RFAutoHeatedSeatValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RFAutoHeatedSeatValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_HybridHVHeaterValue(most_fi_tcl_e8_HVACFTouchButton_HybridHVHeaterValue& /*oe8_HVACFTouchButton_HybridHVHeaterValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_HybridHVHeaterValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_HybridHVHeaterValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_ACValue(most_fi_tcl_e8_HVACFTouchButton_ACValue& /*oe8_HVACFTouchButton_ACValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_ACValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_ACValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RecircValue(most_fi_tcl_e8_HVACFTouchButton_RecircValue& /*oe8_HVACFTouchButton_RecircValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RecircValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RecircValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_AutoRecircValue(most_fi_tcl_e8_HVACFTouchButton_AutoRecircValue& /*oe8_HVACFTouchButton_AutoRecircValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_AutoRecircValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_AutoRecircValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Mode_ACValue(most_fi_tcl_e8_HVACFTouchButton_Mode_ACValue& /*oe8_HVACFTouchButton_Mode_ACValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Mode_ACValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Mode_ACValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Mode_BiLevelValue(most_fi_tcl_e8_HVACFTouchButton_Mode_BiLevelValue& /*oe8_HVACFTouchButton_Mode_BiLevelValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Mode_BiLevelValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Mode_BiLevelValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Mode_HeaterDefrostValue(most_fi_tcl_e8_HVACFTouchButton_Mode_HeaterDefrostValue& /*oe8_HVACFTouchButton_Mode_HeaterDefrostValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Mode_HeaterDefrostValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Mode_HeaterDefrostValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Mode_HeaterValue(most_fi_tcl_e8_HVACFTouchButton_Mode_HeaterValue& /*oe8_HVACFTouchButton_Mode_HeaterValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Mode_HeaterValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Mode_HeaterValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_FrontFanIncValue(most_fi_tcl_e8_HVACFTouchButton_FrontFanIncValue& /*oe8_HVACFTouchButton_FrontFanIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_FrontFanIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_FrontFanIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_FrontFanDecValue(most_fi_tcl_e8_HVACFTouchButton_FrontFanDecValue& /*oe8_HVACFTouchButton_FrontFanDecValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_FrontFanDecValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_FrontFanDecValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_AutoValue(most_fi_tcl_e8_HVACFTouchButton_AutoValue& /*oe8_HVACFTouchButton_AutoValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_AutoValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_AutoValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_SyncValue(most_fi_tcl_e8_HVACFTouchButton_SyncValue& /*oe8_HVACFTouchButton_SyncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_SyncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_SyncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_ECOACValue(most_fi_tcl_e8_HVACFTouchButton_ECOACValue& /*oe8_HVACFTouchButton_ECOACValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_ECOACValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_ECOACValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_FreshAirValue(most_fi_tcl_e8_HVACFTouchButton_FreshAirValue& /*oe8_HVACFTouchButton_FreshAirValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_FreshAirValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_FreshAirValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Mode_WindshieldValue(most_fi_tcl_e8_HVACFTouchButton_Mode_WindshieldValue& /*oe8_HVACFTouchButton_Mode_WindshieldValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Mode_WindshieldValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Mode_WindshieldValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Mode_DefrostValue(most_fi_tcl_e8_HVACFTouchButton_Mode_DefrostValue& /*oe8_HVACFTouchButton_Mode_DefrostValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Mode_DefrostValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Mode_DefrostValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACACHeaterStateValue(most_fi_tcl_e8_HVACACHeaterStateValue& /*oe8_HVACACHeaterStateValue*/)
{
}
tVoid most_fi_tcl_e8_HVACACHeaterStateValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACACHeaterStateValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_LeftSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_LeftSetTempIncValue& /*oe8_HVACFTouchButton_LeftSetTempIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_LeftSetTempIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_LeftSetTempIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_LeftSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_LeftSetTempDecValue& /*oe8_HVACFTouchButton_LeftSetTempDecValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_LeftSetTempDecValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_LeftSetTempDecValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RightSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_RightSetTempIncValue& /*oe8_HVACFTouchButton_RightSetTempIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RightSetTempIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RightSetTempIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RightSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_RightSetTempDecValue& /*oe8_HVACFTouchButton_RightSetTempDecValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RightSetTempDecValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RightSetTempDecValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearDefogValue(most_fi_tcl_e8_HVACFTouchButton_RearDefogValue& /*oe8_HVACFTouchButton_RearDefogValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearDefogValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearDefogValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearMode_HeaterValue(most_fi_tcl_e8_HVACFTouchButton_RearMode_HeaterValue& /*oe8_HVACFTouchButton_RearMode_HeaterValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearMode_HeaterValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearMode_HeaterValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearMode_BiLevelValue(most_fi_tcl_e8_HVACFTouchButton_RearMode_BiLevelValue& /*oe8_HVACFTouchButton_RearMode_BiLevelValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearMode_BiLevelValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearMode_BiLevelValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearMode_ACValue(most_fi_tcl_e8_HVACFTouchButton_RearMode_ACValue& /*oe8_HVACFTouchButton_RearMode_ACValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearMode_ACValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearMode_ACValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearFanIncValue(most_fi_tcl_e8_HVACFTouchButton_RearFanIncValue& /*oe8_HVACFTouchButton_RearFanIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearFanIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearFanIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearFanDecValue(most_fi_tcl_e8_HVACFTouchButton_RearFanDecValue& /*oe8_HVACFTouchButton_RearFanDecValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearFanDecValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearFanDecValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_RearSetTempIncValue& /*oe8_HVACFTouchButton_RearSetTempIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearSetTempIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearSetTempIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_RearSetTempDecValue& /*oe8_HVACFTouchButton_RearSetTempDecValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearSetTempDecValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearSetTempDecValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearPanelLockIncValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelLockIncValue& /*oe8_HVACFTouchButton_RearPanelLockIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearPanelLockIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearPanelLockIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearPanelSyncValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelSyncValue& /*oe8_HVACFTouchButton_RearPanelSyncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearPanelSyncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearPanelSyncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearPanelPowerValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelPowerValue& /*oe8_HVACFTouchButton_RearPanelPowerValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearPanelPowerValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearPanelPowerValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearPanelAutoValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelAutoValue& /*oe8_HVACFTouchButton_RearPanelAutoValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearPanelAutoValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearPanelAutoValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_ACIncValue(most_fi_tcl_e8_HVACFTouchButton_ACIncValue& /*oe8_HVACFTouchButton_ACIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_ACIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_ACIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RecircIncValue(most_fi_tcl_e8_HVACFTouchButton_RecircIncValue& /*oe8_HVACFTouchButton_RecircIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RecircIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RecircIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACMaximum_Rear_FanSpeedValue(most_fi_tcl_e8_HVACMaximum_Rear_FanSpeedValue& /*oe8_HVACMaximum_Rear_FanSpeedValue*/)
{
}
tVoid most_fi_tcl_e8_HVACMaximum_Rear_FanSpeedValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACMaximum_Rear_FanSpeedValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACMaximum_Front_SetTempsValue(most_fi_tcl_e8_HVACMaximum_Front_SetTempsValue& /*oe8_HVACMaximum_Front_SetTempsValue*/)
{
}
tVoid most_fi_tcl_e8_HVACMaximum_Front_SetTempsValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACMaximum_Front_SetTempsValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACMaximum_Rear_SetTempsValue(most_fi_tcl_e8_HVACMaximum_Rear_SetTempsValue& /*oe8_HVACMaximum_Rear_SetTempsValue*/)
{
}
tVoid most_fi_tcl_e8_HVACMaximum_Rear_SetTempsValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACMaximum_Rear_SetTempsValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_ClimateModeIncValue(most_fi_tcl_e8_HVACFTouchButton_ClimateModeIncValue& /*oe8_HVACFTouchButton_ClimateModeIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_ClimateModeIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_ClimateModeIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFront_Right_BlowerModeValue(most_fi_tcl_e8_HVACFront_Right_BlowerModeValue& /*oe8_HVACFront_Right_BlowerModeValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFront_Right_BlowerModeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFront_Right_BlowerModeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Right_Mode_ACValue(most_fi_tcl_e8_HVACFTouchButton_Right_Mode_ACValue& /*oe8_HVACFTouchButton_Right_Mode_ACValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Right_Mode_ACValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Right_Mode_ACValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Right_Mode_BiLevelValue(most_fi_tcl_e8_HVACFTouchButton_Right_Mode_BiLevelValue& /*oe8_HVACFTouchButton_Right_Mode_BiLevelValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Right_Mode_BiLevelValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Right_Mode_BiLevelValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Right_Mode_HeaterValue(most_fi_tcl_e8_HVACFTouchButton_Right_Mode_HeaterValue& /*oe8_HVACFTouchButton_Right_Mode_HeaterValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Right_Mode_HeaterValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Right_Mode_HeaterValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Right_RearSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_Right_RearSetTempIncValue& /*oe8_HVACFTouchButton_Right_RearSetTempIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Right_RearSetTempIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Right_RearSetTempIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_Right_RearSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_Right_RearSetTempDecValue& /*oe8_HVACFTouchButton_Right_RearSetTempDecValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_Right_RearSetTempDecValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_Right_RearSetTempDecValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearModeIncValue(most_fi_tcl_e8_HVACFTouchButton_RearModeIncValue& /*oe8_HVACFTouchButton_RearModeIncValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearModeIncValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearModeIncValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACFTouchButton_RearModeDecValue(most_fi_tcl_e8_HVACFTouchButton_RearModeDecValue& /*oe8_HVACFTouchButton_RearModeDecValue*/)
{
}
tVoid most_fi_tcl_e8_HVACFTouchButton_RearModeDecValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACFTouchButton_RearModeDecValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACRight_Rear_SetPointSetTempValue(most_fi_tcl_e8_HVACRight_Rear_SetPointSetTempValue& /*oe8_HVACRight_Rear_SetPointSetTempValue*/)
{
}
tVoid most_fi_tcl_e8_HVACRight_Rear_SetPointSetTempValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACRight_Rear_SetPointSetTempValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACIonizerStateValue(most_fi_tcl_e8_HVACIonizerStateValue& /*oe8_HVACIonizerStateValue*/)
{
}
tVoid most_fi_tcl_e8_HVACIonizerStateValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACIonizerStateValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HVACHVACSettingsValidEnum(most_fi_tcl_e8_HVACHVACSettingsValidEnum& /*oe8_HVACHVACSettingsValidEnum*/)
{
}
tVoid most_fi_tcl_e8_HVACHVACSettingsValidEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HVACHVACSettingsValidEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ICSCtlSwitchEnumeration(most_fi_tcl_e8_ICSCtlSwitchEnumeration& /*oe8_ICSCtlSwitchEnumeration*/)
{
}
tVoid most_fi_tcl_e8_ICSCtlSwitchEnumeration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ICSCtlSwitchEnumeration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ICSCtlSwitchEventTypeEnumeration(most_fi_tcl_e8_ICSCtlSwitchEventTypeEnumeration& /*oe8_ICSCtlSwitchEventTypeEnumeration*/)
{
}
tVoid most_fi_tcl_e8_ICSCtlSwitchEventTypeEnumeration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ICSCtlSwitchEventTypeEnumeration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_ICSCtlSliderProximity(most_fi_tcl_e8_ICSCtlSliderProximity& /*oe8_ICSCtlSliderProximity*/)
{
}
tVoid most_fi_tcl_e8_ICSCtlSliderProximity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_ICSCtlSliderProximity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsIBErrorCode(most_fi_tcl_e8_iAppsIBErrorCode& /*oe8_iAppsIBErrorCode*/)
{
}
tVoid most_fi_tcl_e8_iAppsIBErrorCode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsIBErrorCode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsListType(most_fi_tcl_e8_iAppsListType& /*oe8_iAppsListType*/)
{
}
tVoid most_fi_tcl_e8_iAppsListType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsListType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsActiveState(most_fi_tcl_e8_iAppsActiveState& /*oe8_iAppsActiveState*/)
{
}
tVoid most_fi_tcl_e8_iAppsActiveState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsActiveState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsSourceLocation(most_fi_tcl_e8_iAppsSourceLocation& /*oe8_iAppsSourceLocation*/)
{
}
tVoid most_fi_tcl_e8_iAppsSourceLocation::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsSourceLocation(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsAppConnectionRequired(most_fi_tcl_e8_iAppsAppConnectionRequired& /*oe8_iAppsAppConnectionRequired*/)
{
}
tVoid most_fi_tcl_e8_iAppsAppConnectionRequired::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsAppConnectionRequired(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsAppVehicleStateRequired(most_fi_tcl_e8_iAppsAppVehicleStateRequired& /*oe8_iAppsAppVehicleStateRequired*/)
{
}
tVoid most_fi_tcl_e8_iAppsAppVehicleStateRequired::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsAppVehicleStateRequired(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsAppObjectsItem(most_fi_tcl_iAppsAppObjectsItem& /*oiAppsAppObjectsItem*/)
{
}
tVoid most_fi_tcl_iAppsAppObjectsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsAppObjectsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsAppObjects(most_fi_tcl_iAppsAppObjects& /*oiAppsAppObjects*/)
{
}
tVoid most_fi_tcl_iAppsAppObjects::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsAppObjects(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsChange(most_fi_tcl_e8_iAppsChange& /*oe8_iAppsChange*/)
{
}
tVoid most_fi_tcl_e8_iAppsChange::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsChange(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsItems(most_fi_tcl_iAppsItems& /*oiAppsItems*/)
{
}
tVoid most_fi_tcl_iAppsItems::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsItems(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsRendererPosition(most_fi_tcl_iAppsRendererPosition& /*oiAppsRendererPosition*/)
{
}
tVoid most_fi_tcl_iAppsRendererPosition::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsRendererPosition(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsActiveAppsItem(most_fi_tcl_iAppsActiveAppsItem& /*oiAppsActiveAppsItem*/)
{
}
tVoid most_fi_tcl_iAppsActiveAppsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsActiveAppsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsActiveApps(most_fi_tcl_iAppsActiveApps& /*oiAppsActiveApps*/)
{
}
tVoid most_fi_tcl_iAppsActiveApps::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsActiveApps(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsImageData(most_fi_tcl_iAppsImageData& /*oiAppsImageData*/)
{
}
tVoid most_fi_tcl_iAppsImageData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsImageData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsConnectionType(most_fi_tcl_e8_iAppsConnectionType& /*oe8_iAppsConnectionType*/)
{
}
tVoid most_fi_tcl_e8_iAppsConnectionType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsConnectionType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsConnectionStatus(most_fi_tcl_e8_iAppsConnectionStatus& /*oe8_iAppsConnectionStatus*/)
{
}
tVoid most_fi_tcl_e8_iAppsConnectionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsConnectionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsConnectionBandwidth(most_fi_tcl_e8_iAppsConnectionBandwidth& /*oe8_iAppsConnectionBandwidth*/)
{
}
tVoid most_fi_tcl_e8_iAppsConnectionBandwidth::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsConnectionBandwidth(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsConnectionAvailabilityItem(most_fi_tcl_iAppsConnectionAvailabilityItem& /*oiAppsConnectionAvailabilityItem*/)
{
}
tVoid most_fi_tcl_iAppsConnectionAvailabilityItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsConnectionAvailabilityItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsConnectionAvailability(most_fi_tcl_iAppsConnectionAvailability& /*oiAppsConnectionAvailability*/)
{
}
tVoid most_fi_tcl_iAppsConnectionAvailability::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsConnectionAvailability(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsUpdateHTMLItem(most_fi_tcl_iAppsUpdateHTMLItem& /*oiAppsUpdateHTMLItem*/)
{
}
tVoid most_fi_tcl_iAppsUpdateHTMLItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsUpdateHTMLItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsUpdateHTML(most_fi_tcl_iAppsUpdateHTML& /*oiAppsUpdateHTML*/)
{
}
tVoid most_fi_tcl_iAppsUpdateHTML::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsUpdateHTML(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsMethod(most_fi_tcl_e8_iAppsMethod& /*oe8_iAppsMethod*/)
{
}
tVoid most_fi_tcl_e8_iAppsMethod::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsMethod(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsSyncrhonizationState(most_fi_tcl_e8_iAppsSyncrhonizationState& /*oe8_iAppsSyncrhonizationState*/)
{
}
tVoid most_fi_tcl_e8_iAppsSyncrhonizationState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsSyncrhonizationState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsSelectorButtonStreamItem(most_fi_tcl_iAppsSelectorButtonStreamItem& /*oiAppsSelectorButtonStreamItem*/)
{
}
tVoid most_fi_tcl_iAppsSelectorButtonStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsSelectorButtonStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsSelectorButtonStream(most_fi_tcl_iAppsSelectorButtonStream& /*oiAppsSelectorButtonStream*/)
{
}
tVoid most_fi_tcl_iAppsSelectorButtonStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsSelectorButtonStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsSelectorButtonState(most_fi_tcl_e8_iAppsSelectorButtonState& /*oe8_iAppsSelectorButtonState*/)
{
}
tVoid most_fi_tcl_e8_iAppsSelectorButtonState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsSelectorButtonState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsInternetApplicationSystemAction(most_fi_tcl_e8_iAppsInternetApplicationSystemAction& /*oe8_iAppsInternetApplicationSystemAction*/)
{
}
tVoid most_fi_tcl_e8_iAppsInternetApplicationSystemAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsInternetApplicationSystemAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsMessageHandle(most_fi_tcl_iAppsMessageHandle& /*oiAppsMessageHandle*/)
{
}
tVoid most_fi_tcl_iAppsMessageHandle::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsMessageHandle(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsButtonAction(most_fi_tcl_e8_iAppsButtonAction& /*oe8_iAppsButtonAction*/)
{
}
tVoid most_fi_tcl_e8_iAppsButtonAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsButtonAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsSortOrder(most_fi_tcl_e8_iAppsSortOrder& /*oe8_iAppsSortOrder*/)
{
}
tVoid most_fi_tcl_e8_iAppsSortOrder::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsSortOrder(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsAutocompleteResultList(most_fi_tcl_iAppsAutocompleteResultList& /*oiAppsAutocompleteResultList*/)
{
}
tVoid most_fi_tcl_iAppsAutocompleteResultList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsAutocompleteResultList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsPOIDistanceType(most_fi_tcl_e8_iAppsPOIDistanceType& /*oe8_iAppsPOIDistanceType*/)
{
}
tVoid most_fi_tcl_e8_iAppsPOIDistanceType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsPOIDistanceType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsDistanceUnits(most_fi_tcl_e8_iAppsDistanceUnits& /*oe8_iAppsDistanceUnits*/)
{
}
tVoid most_fi_tcl_e8_iAppsDistanceUnits::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsDistanceUnits(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsSearchResultListItem(most_fi_tcl_iAppsSearchResultListItem& /*oiAppsSearchResultListItem*/)
{
}
tVoid most_fi_tcl_iAppsSearchResultListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsSearchResultListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iAppsSearchResultList(most_fi_tcl_iAppsSearchResultList& /*oiAppsSearchResultList*/)
{
}
tVoid most_fi_tcl_iAppsSearchResultList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iAppsSearchResultList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iAppsImageFormat(most_fi_tcl_e8_iAppsImageFormat& /*oe8_iAppsImageFormat*/)
{
}
tVoid most_fi_tcl_e8_iAppsImageFormat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iAppsImageFormat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioListType(most_fi_tcl_e8_iRadioListType& /*oe8_iRadioListType*/)
{
}
tVoid most_fi_tcl_e8_iRadioListType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioListType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioFileFormat(most_fi_tcl_e8_iRadioFileFormat& /*oe8_iRadioFileFormat*/)
{
}
tVoid most_fi_tcl_e8_iRadioFileFormat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioFileFormat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioStationsItem(most_fi_tcl_iRadioStationsItem& /*oiRadioStationsItem*/)
{
}
tVoid most_fi_tcl_iRadioStationsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioStationsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioStations(most_fi_tcl_iRadioStations& /*oiRadioStations*/)
{
}
tVoid most_fi_tcl_iRadioStations::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioStations(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioChange(most_fi_tcl_e8_iRadioChange& /*oe8_iRadioChange*/)
{
}
tVoid most_fi_tcl_e8_iRadioChange::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioChange(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioItems(most_fi_tcl_iRadioItems& /*oiRadioItems*/)
{
}
tVoid most_fi_tcl_iRadioItems::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioItems(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioStationType(most_fi_tcl_e8_iRadioStationType& /*oe8_iRadioStationType*/)
{
}
tVoid most_fi_tcl_e8_iRadioStationType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioStationType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioStation(most_fi_tcl_iRadioStation& /*oiRadioStation*/)
{
}
tVoid most_fi_tcl_iRadioStation::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioStation(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioRating(most_fi_tcl_e8_iRadioRating& /*oe8_iRadioRating*/)
{
}
tVoid most_fi_tcl_e8_iRadioRating::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioRating(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioSong(most_fi_tcl_iRadioSong& /*oiRadioSong*/)
{
}
tVoid most_fi_tcl_iRadioSong::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioSong(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioAction(most_fi_tcl_e8_iRadioAction& /*oe8_iRadioAction*/)
{
}
tVoid most_fi_tcl_e8_iRadioAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioImageData(most_fi_tcl_iRadioImageData& /*oiRadioImageData*/)
{
}
tVoid most_fi_tcl_iRadioImageData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioImageData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioInternetRadioSource(most_fi_tcl_e8_iRadioInternetRadioSource& /*oe8_iRadioInternetRadioSource*/)
{
}
tVoid most_fi_tcl_e8_iRadioInternetRadioSource::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioInternetRadioSource(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioPlaybackState(most_fi_tcl_e8_iRadioPlaybackState& /*oe8_iRadioPlaybackState*/)
{
}
tVoid most_fi_tcl_e8_iRadioPlaybackState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioPlaybackState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioConnectionStatus(most_fi_tcl_e8_iRadioConnectionStatus& /*oe8_iRadioConnectionStatus*/)
{
}
tVoid most_fi_tcl_e8_iRadioConnectionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioConnectionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioSynchronizationState(most_fi_tcl_e8_iRadioSynchronizationState& /*oe8_iRadioSynchronizationState*/)
{
}
tVoid most_fi_tcl_e8_iRadioSynchronizationState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioSynchronizationState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_iRadioPandoraAccountStatus(most_fi_tcl_e8_iRadioPandoraAccountStatus& /*oe8_iRadioPandoraAccountStatus*/)
{
}
tVoid most_fi_tcl_e8_iRadioPandoraAccountStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_iRadioPandoraAccountStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioStationListItem(most_fi_tcl_iRadioStationListItem& /*oiRadioStationListItem*/)
{
}
tVoid most_fi_tcl_iRadioStationListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioStationListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_iRadioStationList(most_fi_tcl_iRadioStationList& /*oiRadioStationList*/)
{
}
tVoid most_fi_tcl_iRadioStationList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_iRadioStationList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_LVMRmtEnable(most_fi_tcl_e8_LVMRmtEnable& /*oe8_LVMRmtEnable*/)
{
}
tVoid most_fi_tcl_e8_LVMRmtEnable::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_LVMRmtEnable(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayListType(most_fi_tcl_e8_MPlayListType& /*oe8_MPlayListType*/)
{
}
tVoid most_fi_tcl_e8_MPlayListType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayListType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayCategoryType(most_fi_tcl_e8_MPlayCategoryType& /*oe8_MPlayCategoryType*/)
{
}
tVoid most_fi_tcl_e8_MPlayCategoryType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayCategoryType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayDeviceType(most_fi_tcl_e8_MPlayDeviceType& /*oe8_MPlayDeviceType*/)
{
}
tVoid most_fi_tcl_e8_MPlayDeviceType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayDeviceType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayFileFormat(most_fi_tcl_e8_MPlayFileFormat& /*oe8_MPlayFileFormat*/)
{
}
tVoid most_fi_tcl_e8_MPlayFileFormat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayFileFormat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayMediaType(most_fi_tcl_e8_MPlayMediaType& /*oe8_MPlayMediaType*/)
{
}
tVoid most_fi_tcl_e8_MPlayMediaType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayMediaType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayMediaObjectsItem(most_fi_tcl_MPlayMediaObjectsItem& /*oMPlayMediaObjectsItem*/)
{
}
tVoid most_fi_tcl_MPlayMediaObjectsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayMediaObjectsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayMediaObjects(most_fi_tcl_MPlayMediaObjects& /*oMPlayMediaObjects*/)
{
}
tVoid most_fi_tcl_MPlayMediaObjects::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayMediaObjects(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayChange(most_fi_tcl_e8_MPlayChange& /*oe8_MPlayChange*/)
{
}
tVoid most_fi_tcl_e8_MPlayChange::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayChange(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayItems(most_fi_tcl_MPlayItems& /*oMPlayItems*/)
{
}
tVoid most_fi_tcl_MPlayItems::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayItems(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayNowPlayingState(most_fi_tcl_e8_MPlayNowPlayingState& /*oe8_MPlayNowPlayingState*/)
{
}
tVoid most_fi_tcl_e8_MPlayNowPlayingState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayNowPlayingState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayMediaObject(most_fi_tcl_MPlayMediaObject& /*oMPlayMediaObject*/)
{
}
tVoid most_fi_tcl_MPlayMediaObject::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayMediaObject(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayState(most_fi_tcl_e8_MPlayState& /*oe8_MPlayState*/)
{
}
tVoid most_fi_tcl_e8_MPlayState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayMode(most_fi_tcl_e8_MPlayMode& /*oe8_MPlayMode*/)
{
}
tVoid most_fi_tcl_e8_MPlayMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayRepeat(most_fi_tcl_e8_MPlayRepeat& /*oe8_MPlayRepeat*/)
{
}
tVoid most_fi_tcl_e8_MPlayRepeat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayRepeat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayAction(most_fi_tcl_e8_MPlayAction& /*oe8_MPlayAction*/)
{
}
tVoid most_fi_tcl_e8_MPlayAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayPlaypointFormat(most_fi_tcl_e8_MPlayPlaypointFormat& /*oe8_MPlayPlaypointFormat*/)
{
}
tVoid most_fi_tcl_e8_MPlayPlaypointFormat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayPlaypointFormat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayDeviceIndexedState(most_fi_tcl_e8_MPlayDeviceIndexedState& /*oe8_MPlayDeviceIndexedState*/)
{
}
tVoid most_fi_tcl_e8_MPlayDeviceIndexedState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayDeviceIndexedState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayIndexingStateResultItem(most_fi_tcl_MPlayIndexingStateResultItem& /*oMPlayIndexingStateResultItem*/)
{
}
tVoid most_fi_tcl_MPlayIndexingStateResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayIndexingStateResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayIndexingStateResult(most_fi_tcl_MPlayIndexingStateResult& /*oMPlayIndexingStateResult*/)
{
}
tVoid most_fi_tcl_MPlayIndexingStateResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayIndexingStateResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayImageData(most_fi_tcl_MPlayImageData& /*oMPlayImageData*/)
{
}
tVoid most_fi_tcl_MPlayImageData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayImageData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlaySearchKeyboardListItem(most_fi_tcl_MPlaySearchKeyboardListItem& /*oMPlaySearchKeyboardListItem*/)
{
}
tVoid most_fi_tcl_MPlaySearchKeyboardListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlaySearchKeyboardListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlaySearchKeyboardList(most_fi_tcl_MPlaySearchKeyboardList& /*oMPlaySearchKeyboardList*/)
{
}
tVoid most_fi_tcl_MPlaySearchKeyboardList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlaySearchKeyboardList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayDeviceInfoItem(most_fi_tcl_MPlayDeviceInfoItem& /*oMPlayDeviceInfoItem*/)
{
}
tVoid most_fi_tcl_MPlayDeviceInfoItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayDeviceInfoItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayDeviceInfo(most_fi_tcl_MPlayDeviceInfo& /*oMPlayDeviceInfo*/)
{
}
tVoid most_fi_tcl_MPlayDeviceInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayDeviceInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayFileType(most_fi_tcl_e8_MPlayFileType& /*oe8_MPlayFileType*/)
{
}
tVoid most_fi_tcl_e8_MPlayFileType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayFileType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayFileListItem(most_fi_tcl_MPlayFileListItem& /*oMPlayFileListItem*/)
{
}
tVoid most_fi_tcl_MPlayFileListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayFileListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayFileList(most_fi_tcl_MPlayFileList& /*oMPlayFileList*/)
{
}
tVoid most_fi_tcl_MPlayFileList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayFileList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_MPlayTagTransferStatus(most_fi_tcl_e8_MPlayTagTransferStatus& /*oe8_MPlayTagTransferStatus*/)
{
}
tVoid most_fi_tcl_e8_MPlayTagTransferStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_MPlayTagTransferStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayTagTransferItem_1(most_fi_tcl_MPlayTagTransferItem_1& /*oMPlayTagTransferItem_1*/)
{
}
tVoid most_fi_tcl_MPlayTagTransferItem_1::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayTagTransferItem_1(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayTagTransfer_1(most_fi_tcl_MPlayTagTransfer_1& /*oMPlayTagTransfer_1*/)
{
}
tVoid most_fi_tcl_MPlayTagTransfer_1::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayTagTransfer_1(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayUntransferredTagStreamItem(most_fi_tcl_MPlayUntransferredTagStreamItem& /*oMPlayUntransferredTagStreamItem*/)
{
}
tVoid most_fi_tcl_MPlayUntransferredTagStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayUntransferredTagStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayUntransferredTagStream(most_fi_tcl_MPlayUntransferredTagStream& /*oMPlayUntransferredTagStream*/)
{
}
tVoid most_fi_tcl_MPlayUntransferredTagStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayUntransferredTagStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayTagTransferItem_2(most_fi_tcl_MPlayTagTransferItem_2& /*oMPlayTagTransferItem_2*/)
{
}
tVoid most_fi_tcl_MPlayTagTransferItem_2::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayTagTransferItem_2(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_MPlayTagTransfer_2(most_fi_tcl_MPlayTagTransfer_2& /*oMPlayTagTransfer_2*/)
{
}
tVoid most_fi_tcl_MPlayTagTransfer_2::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_MPlayTagTransfer_2(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_NavDistanceUnits(most_fi_tcl_e8_NavDistanceUnits& /*oe8_NavDistanceUnits*/)
{
}
tVoid most_fi_tcl_e8_NavDistanceUnits::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_NavDistanceUnits(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_NavManeuverEnumeration(most_fi_tcl_e8_NavManeuverEnumeration& /*oe8_NavManeuverEnumeration*/)
{
}
tVoid most_fi_tcl_e8_NavManeuverEnumeration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_NavManeuverEnumeration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_NavGuidanceStatus(most_fi_tcl_e8_NavGuidanceStatus& /*oe8_NavGuidanceStatus*/)
{
}
tVoid most_fi_tcl_e8_NavGuidanceStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_NavGuidanceStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavManeuverListStreamItem(most_fi_tcl_NavManeuverListStreamItem& /*oNavManeuverListStreamItem*/)
{
}
tVoid most_fi_tcl_NavManeuverListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavManeuverListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavManeuverListStream(most_fi_tcl_NavManeuverListStream& /*oNavManeuverListStream*/)
{
}
tVoid most_fi_tcl_NavManeuverListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavManeuverListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_NavPOIListTypeEnum(most_fi_tcl_e8_NavPOIListTypeEnum& /*oe8_NavPOIListTypeEnum*/)
{
}
tVoid most_fi_tcl_e8_NavPOIListTypeEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_NavPOIListTypeEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavPOI_ListItem(most_fi_tcl_NavPOI_ListItem& /*oNavPOI_ListItem*/)
{
}
tVoid most_fi_tcl_NavPOI_ListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavPOI_ListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavPOI_List(most_fi_tcl_NavPOI_List& /*oNavPOI_List*/)
{
}
tVoid most_fi_tcl_NavPOI_List::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavPOI_List(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_NavDestinationListTypeEnum(most_fi_tcl_e8_NavDestinationListTypeEnum& /*oe8_NavDestinationListTypeEnum*/)
{
}
tVoid most_fi_tcl_e8_NavDestinationListTypeEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_NavDestinationListTypeEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavDestinationInfoItem(most_fi_tcl_NavDestinationInfoItem& /*oNavDestinationInfoItem*/)
{
}
tVoid most_fi_tcl_NavDestinationInfoItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavDestinationInfoItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavDestinationInfo(most_fi_tcl_NavDestinationInfo& /*oNavDestinationInfo*/)
{
}
tVoid most_fi_tcl_NavDestinationInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavDestinationInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_NavListChangeType(most_fi_tcl_e8_NavListChangeType& /*oe8_NavListChangeType*/)
{
}
tVoid most_fi_tcl_e8_NavListChangeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_NavListChangeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavChangedItemIndexes(most_fi_tcl_NavChangedItemIndexes& /*oNavChangedItemIndexes*/)
{
}
tVoid most_fi_tcl_NavChangedItemIndexes::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavChangedItemIndexes(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavCurrentVehiclePositionStreamItem(most_fi_tcl_NavCurrentVehiclePositionStreamItem& /*oNavCurrentVehiclePositionStreamItem*/)
{
}
tVoid most_fi_tcl_NavCurrentVehiclePositionStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavCurrentVehiclePositionStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavCurrentVehiclePositionStream(most_fi_tcl_NavCurrentVehiclePositionStream& /*oNavCurrentVehiclePositionStream*/)
{
}
tVoid most_fi_tcl_NavCurrentVehiclePositionStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavCurrentVehiclePositionStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavManeuverExtendedListStreamItem(most_fi_tcl_NavManeuverExtendedListStreamItem& /*oNavManeuverExtendedListStreamItem*/)
{
}
tVoid most_fi_tcl_NavManeuverExtendedListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavManeuverExtendedListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_NavManeuverExtendedListStream(most_fi_tcl_NavManeuverExtendedListStream& /*oNavManeuverExtendedListStream*/)
{
}
tVoid most_fi_tcl_NavManeuverExtendedListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_NavManeuverExtendedListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_NavAddressDisplayFormat(most_fi_tcl_e8_NavAddressDisplayFormat& /*oe8_NavAddressDisplayFormat*/)
{
}
tVoid most_fi_tcl_e8_NavAddressDisplayFormat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_NavAddressDisplayFormat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsAudButtonEnum(most_fi_tcl_e8_OnsAudButtonEnum& /*oe8_OnsAudButtonEnum*/)
{
}
tVoid most_fi_tcl_e8_OnsAudButtonEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsAudButtonEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsAudButtonEvent(most_fi_tcl_e8_OnsAudButtonEvent& /*oe8_OnsAudButtonEvent*/)
{
}
tVoid most_fi_tcl_e8_OnsAudButtonEvent::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsAudButtonEvent(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatOnStarDataSettingsValidEnum(most_fi_tcl_e8_OnsDatOnStarDataSettingsValidEnum& /*oe8_OnsDatOnStarDataSettingsValidEnum*/)
{
}
tVoid most_fi_tcl_e8_OnsDatOnStarDataSettingsValidEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatOnStarDataSettingsValidEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatOnStarDataSettingsEventEnum(most_fi_tcl_e8_OnsDatOnStarDataSettingsEventEnum& /*oe8_OnsDatOnStarDataSettingsEventEnum*/)
{
}
tVoid most_fi_tcl_e8_OnsDatOnStarDataSettingsEventEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatOnStarDataSettingsEventEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatPlaceOnStarCallValue(most_fi_tcl_e8_OnsDatPlaceOnStarCallValue& /*oe8_OnsDatPlaceOnStarCallValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatPlaceOnStarCallValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatPlaceOnStarCallValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatButton1SelectedValue(most_fi_tcl_e8_OnsDatButton1SelectedValue& /*oe8_OnsDatButton1SelectedValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatButton1SelectedValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatButton1SelectedValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatButton2SelectedValue(most_fi_tcl_e8_OnsDatButton2SelectedValue& /*oe8_OnsDatButton2SelectedValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatButton2SelectedValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatButton2SelectedValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatBluetooth_InCallStatusValue(most_fi_tcl_e8_OnsDatBluetooth_InCallStatusValue& /*oe8_OnsDatBluetooth_InCallStatusValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatBluetooth_InCallStatusValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatBluetooth_InCallStatusValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatVoiceRecognitionStatusValue(most_fi_tcl_e8_OnsDatVoiceRecognitionStatusValue& /*oe8_OnsDatVoiceRecognitionStatusValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatVoiceRecognitionStatusValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatVoiceRecognitionStatusValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatOnStarCallTypeValue(most_fi_tcl_e8_OnsDatOnStarCallTypeValue& /*oe8_OnsDatOnStarCallTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatOnStarCallTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatOnStarCallTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatPacketConnectionTypeValue(most_fi_tcl_e8_OnsDatPacketConnectionTypeValue& /*oe8_OnsDatPacketConnectionTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatPacketConnectionTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatPacketConnectionTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatInVehicleAlertTypeValue(most_fi_tcl_e8_OnsDatInVehicleAlertTypeValue& /*oe8_OnsDatInVehicleAlertTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatInVehicleAlertTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatInVehicleAlertTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatOnStarLanguageSettingValue(most_fi_tcl_e8_OnsDatOnStarLanguageSettingValue& /*oe8_OnsDatOnStarLanguageSettingValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatOnStarLanguageSettingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatOnStarLanguageSettingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatSubmenuIndicator(most_fi_tcl_e8_OnsDatSubmenuIndicator& /*oe8_OnsDatSubmenuIndicator*/)
{
}
tVoid most_fi_tcl_e8_OnsDatSubmenuIndicator::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatSubmenuIndicator(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsDatMenuListValueItem(most_fi_tcl_OnsDatMenuListValueItem& /*oOnsDatMenuListValueItem*/)
{
}
tVoid most_fi_tcl_OnsDatMenuListValueItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsDatMenuListValueItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsDatMenuListValue(most_fi_tcl_OnsDatMenuListValue& /*oOnsDatMenuListValue*/)
{
}
tVoid most_fi_tcl_OnsDatMenuListValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsDatMenuListValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatTTYFunctionRestrictionTypeValue(most_fi_tcl_e8_OnsDatTTYFunctionRestrictionTypeValue& /*oe8_OnsDatTTYFunctionRestrictionTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatTTYFunctionRestrictionTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatTTYFunctionRestrictionTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatEmbeddedCellularRssiTypeValue(most_fi_tcl_e8_OnsDatEmbeddedCellularRssiTypeValue& /*oe8_OnsDatEmbeddedCellularRssiTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatEmbeddedCellularRssiTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatEmbeddedCellularRssiTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsDatEmbeddedCellularTechnologyTypeValue(most_fi_tcl_e8_OnsDatEmbeddedCellularTechnologyTypeValue& /*oe8_OnsDatEmbeddedCellularTechnologyTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsDatEmbeddedCellularTechnologyTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsDatEmbeddedCellularTechnologyTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalHandsFreePhoneEventEnum(most_fi_tcl_e8_OnsCalHandsFreePhoneEventEnum& /*oe8_OnsCalHandsFreePhoneEventEnum*/)
{
}
tVoid most_fi_tcl_e8_OnsCalHandsFreePhoneEventEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalHandsFreePhoneEventEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalRingTone_SelectValue(most_fi_tcl_e8_OnsCalRingTone_SelectValue& /*oe8_OnsCalRingTone_SelectValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalRingTone_SelectValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalRingTone_SelectValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalC1_CallStateValue(most_fi_tcl_e8_OnsCalC1_CallStateValue& /*oe8_OnsCalC1_CallStateValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalC1_CallStateValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalC1_CallStateValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalC1_NumberTypeValue(most_fi_tcl_e8_OnsCalC1_NumberTypeValue& /*oe8_OnsCalC1_NumberTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalC1_NumberTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalC1_NumberTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalC2_CallStateValue(most_fi_tcl_e8_OnsCalC2_CallStateValue& /*oe8_OnsCalC2_CallStateValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalC2_CallStateValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalC2_CallStateValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalC2_NumberTypeValue(most_fi_tcl_e8_OnsCalC2_NumberTypeValue& /*oe8_OnsCalC2_NumberTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalC2_NumberTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalC2_NumberTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalnumberType(most_fi_tcl_e8_OnsCalnumberType& /*oe8_OnsCalnumberType*/)
{
}
tVoid most_fi_tcl_e8_OnsCalnumberType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalnumberType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalCLT_IncomingValueItem(most_fi_tcl_OnsCalCLT_IncomingValueItem& /*oOnsCalCLT_IncomingValueItem*/)
{
}
tVoid most_fi_tcl_OnsCalCLT_IncomingValueItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalCLT_IncomingValueItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalCLT_IncomingValue(most_fi_tcl_OnsCalCLT_IncomingValue& /*oOnsCalCLT_IncomingValue*/)
{
}
tVoid most_fi_tcl_OnsCalCLT_IncomingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalCLT_IncomingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalCLT_MissedValueItem(most_fi_tcl_OnsCalCLT_MissedValueItem& /*oOnsCalCLT_MissedValueItem*/)
{
}
tVoid most_fi_tcl_OnsCalCLT_MissedValueItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalCLT_MissedValueItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalCLT_MissedValue(most_fi_tcl_OnsCalCLT_MissedValue& /*oOnsCalCLT_MissedValue*/)
{
}
tVoid most_fi_tcl_OnsCalCLT_MissedValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalCLT_MissedValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalCLT_OutgoingValueItem(most_fi_tcl_OnsCalCLT_OutgoingValueItem& /*oOnsCalCLT_OutgoingValueItem*/)
{
}
tVoid most_fi_tcl_OnsCalCLT_OutgoingValueItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalCLT_OutgoingValueItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalCLT_OutgoingValue(most_fi_tcl_OnsCalCLT_OutgoingValue& /*oOnsCalCLT_OutgoingValue*/)
{
}
tVoid most_fi_tcl_OnsCalCLT_OutgoingValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalCLT_OutgoingValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalConf_MembersValueItem(most_fi_tcl_OnsCalConf_MembersValueItem& /*oOnsCalConf_MembersValueItem*/)
{
}
tVoid most_fi_tcl_OnsCalConf_MembersValueItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalConf_MembersValueItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_OnsCalConf_MembersValue(most_fi_tcl_OnsCalConf_MembersValue& /*oOnsCalConf_MembersValue*/)
{
}
tVoid most_fi_tcl_OnsCalConf_MembersValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_OnsCalConf_MembersValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalEmergencyCall_CallStateValue(most_fi_tcl_e8_OnsCalEmergencyCall_CallStateValue& /*oe8_OnsCalEmergencyCall_CallStateValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalEmergencyCall_CallStateValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalEmergencyCall_CallStateValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalIn_NumberTypeValue(most_fi_tcl_e8_OnsCalIn_NumberTypeValue& /*oe8_OnsCalIn_NumberTypeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalIn_NumberTypeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalIn_NumberTypeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalNetwork_SignalStrengthValue(most_fi_tcl_e8_OnsCalNetwork_SignalStrengthValue& /*oe8_OnsCalNetwork_SignalStrengthValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalNetwork_SignalStrengthValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalNetwork_SignalStrengthValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalNetwork_StatusValue(most_fi_tcl_e8_OnsCalNetwork_StatusValue& /*oe8_OnsCalNetwork_StatusValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalNetwork_StatusValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalNetwork_StatusValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalPhone_FailureCodeValue(most_fi_tcl_e8_OnsCalPhone_FailureCodeValue& /*oe8_OnsCalPhone_FailureCodeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalPhone_FailureCodeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalPhone_FailureCodeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalRingToneValue(most_fi_tcl_e8_OnsCalRingToneValue& /*oe8_OnsCalRingToneValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalRingToneValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalRingToneValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalSecurity_FailureCodeValue(most_fi_tcl_e8_OnsCalSecurity_FailureCodeValue& /*oe8_OnsCalSecurity_FailureCodeValue*/)
{
}
tVoid most_fi_tcl_e8_OnsCalSecurity_FailureCodeValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalSecurity_FailureCodeValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsCalHandsFreePhoneValidEnum(most_fi_tcl_e8_OnsCalHandsFreePhoneValidEnum& /*oe8_OnsCalHandsFreePhoneValidEnum*/)
{
}
tVoid most_fi_tcl_e8_OnsCalHandsFreePhoneValidEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsCalHandsFreePhoneValidEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsNavTBTNavigationDisplayEventEnum(most_fi_tcl_e8_OnsNavTBTNavigationDisplayEventEnum& /*oe8_OnsNavTBTNavigationDisplayEventEnum*/)
{
}
tVoid most_fi_tcl_e8_OnsNavTBTNavigationDisplayEventEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsNavTBTNavigationDisplayEventEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsNavCurrentManeuverValue(most_fi_tcl_e8_OnsNavCurrentManeuverValue& /*oe8_OnsNavCurrentManeuverValue*/)
{
}
tVoid most_fi_tcl_e8_OnsNavCurrentManeuverValue::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsNavCurrentManeuverValue(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_OnsNavTBTNavigationDisplayValidEnum(most_fi_tcl_e8_OnsNavTBTNavigationDisplayValidEnum& /*oe8_OnsNavTBTNavigationDisplayValidEnum*/)
{
}
tVoid most_fi_tcl_e8_OnsNavTBTNavigationDisplayValidEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_OnsNavTBTNavigationDisplayValidEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasFileStatus(most_fi_tcl_e8_PrgMasFileStatus& /*oe8_PrgMasFileStatus*/)
{
}
tVoid most_fi_tcl_e8_PrgMasFileStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasFileStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasProgManFile(most_fi_tcl_PrgMasProgManFile& /*oPrgMasProgManFile*/)
{
}
tVoid most_fi_tcl_PrgMasProgManFile::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasProgManFile(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasMode(most_fi_tcl_e8_PrgMasMode& /*oe8_PrgMasMode*/)
{
}
tVoid most_fi_tcl_e8_PrgMasMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasFile(most_fi_tcl_PrgMasFile& /*oPrgMasFile*/)
{
}
tVoid most_fi_tcl_PrgMasFile::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasFile(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasUpdateType(most_fi_tcl_e8_PrgMasUpdateType& /*oe8_PrgMasUpdateType*/)
{
}
tVoid most_fi_tcl_e8_PrgMasUpdateType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasUpdateType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasLicFile(most_fi_tcl_PrgMasLicFile& /*oPrgMasLicFile*/)
{
}
tVoid most_fi_tcl_PrgMasLicFile::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasLicFile(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasMDFile(most_fi_tcl_PrgMasMDFile& /*oPrgMasMDFile*/)
{
}
tVoid most_fi_tcl_PrgMasMDFile::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasMDFile(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasProgModeStatus(most_fi_tcl_e8_PrgMasProgModeStatus& /*oe8_PrgMasProgModeStatus*/)
{
}
tVoid most_fi_tcl_e8_PrgMasProgModeStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasProgModeStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasFileAndDeviceNameStreamItem(most_fi_tcl_PrgMasFileAndDeviceNameStreamItem& /*oPrgMasFileAndDeviceNameStreamItem*/)
{
}
tVoid most_fi_tcl_PrgMasFileAndDeviceNameStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasFileAndDeviceNameStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasFileAndDeviceNameStream(most_fi_tcl_PrgMasFileAndDeviceNameStream& /*oPrgMasFileAndDeviceNameStream*/)
{
}
tVoid most_fi_tcl_PrgMasFileAndDeviceNameStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasFileAndDeviceNameStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasClientErrorMode(most_fi_tcl_e8_PrgMasClientErrorMode& /*oe8_PrgMasClientErrorMode*/)
{
}
tVoid most_fi_tcl_e8_PrgMasClientErrorMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasClientErrorMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasInvalidFileString(most_fi_tcl_PrgMasInvalidFileString& /*oPrgMasInvalidFileString*/)
{
}
tVoid most_fi_tcl_PrgMasInvalidFileString::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasInvalidFileString(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasOTAMsgType(most_fi_tcl_e8_PrgMasOTAMsgType& /*oe8_PrgMasOTAMsgType*/)
{
}
tVoid most_fi_tcl_e8_PrgMasOTAMsgType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasOTAMsgType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasManFileAndStatusStreamItem(most_fi_tcl_PrgMasManFileAndStatusStreamItem& /*oPrgMasManFileAndStatusStreamItem*/)
{
}
tVoid most_fi_tcl_PrgMasManFileAndStatusStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasManFileAndStatusStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_PrgMasManFileAndStatusStream(most_fi_tcl_PrgMasManFileAndStatusStream& /*oPrgMasManFileAndStatusStream*/)
{
}
tVoid most_fi_tcl_PrgMasManFileAndStatusStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_PrgMasManFileAndStatusStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasAsisResultScreenButton(most_fi_tcl_e8_PrgMasAsisResultScreenButton& /*oe8_PrgMasAsisResultScreenButton*/)
{
}
tVoid most_fi_tcl_e8_PrgMasAsisResultScreenButton::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasAsisResultScreenButton(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasAsIsSavingStatus(most_fi_tcl_e8_PrgMasAsIsSavingStatus& /*oe8_PrgMasAsIsSavingStatus*/)
{
}
tVoid most_fi_tcl_e8_PrgMasAsIsSavingStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasAsIsSavingStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasImmobilizationStatusIcon(most_fi_tcl_e8_PrgMasImmobilizationStatusIcon& /*oe8_PrgMasImmobilizationStatusIcon*/)
{
}
tVoid most_fi_tcl_e8_PrgMasImmobilizationStatusIcon::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasImmobilizationStatusIcon(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasTermsConditionsResponseStatus(most_fi_tcl_e8_PrgMasTermsConditionsResponseStatus& /*oe8_PrgMasTermsConditionsResponseStatus*/)
{
}
tVoid most_fi_tcl_e8_PrgMasTermsConditionsResponseStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasTermsConditionsResponseStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasInstallFailureResponseStatus(most_fi_tcl_e8_PrgMasInstallFailureResponseStatus& /*oe8_PrgMasInstallFailureResponseStatus*/)
{
}
tVoid most_fi_tcl_e8_PrgMasInstallFailureResponseStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasInstallFailureResponseStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_PrgMasFinalConfirmationResponseStatus(most_fi_tcl_e8_PrgMasFinalConfirmationResponseStatus& /*oe8_PrgMasFinalConfirmationResponseStatus*/)
{
}
tVoid most_fi_tcl_e8_PrgMasFinalConfirmationResponseStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_PrgMasFinalConfirmationResponseStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RSEFrontVideoState(most_fi_tcl_e8_RSEFrontVideoState& /*oe8_RSEFrontVideoState*/)
{
}
tVoid most_fi_tcl_e8_RSEFrontVideoState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RSEFrontVideoState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RSEFrontRSESources(most_fi_tcl_e8_RSEFrontRSESources& /*oe8_RSEFrontRSESources*/)
{
}
tVoid most_fi_tcl_e8_RSEFrontRSESources::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RSEFrontRSESources(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RSEDiskPlayState(most_fi_tcl_e8_RSEDiskPlayState& /*oe8_RSEDiskPlayState*/)
{
}
tVoid most_fi_tcl_e8_RSEDiskPlayState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RSEDiskPlayState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RSENextPreviousFlag(most_fi_tcl_e8_RSENextPreviousFlag& /*oe8_RSENextPreviousFlag*/)
{
}
tVoid most_fi_tcl_e8_RSENextPreviousFlag::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RSENextPreviousFlag(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RSEPlayPauseAction(most_fi_tcl_e8_RSEPlayPauseAction& /*oe8_RSEPlayPauseAction*/)
{
}
tVoid most_fi_tcl_e8_RSEPlayPauseAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RSEPlayPauseAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RSERSEAccessibilityModeSetting(most_fi_tcl_e8_RSERSEAccessibilityModeSetting& /*oe8_RSERSEAccessibilityModeSetting*/)
{
}
tVoid most_fi_tcl_e8_RSERSEAccessibilityModeSetting::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RSERSEAccessibilityModeSetting(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSCategoryListStreamItem(most_fi_tcl_SDARSCategoryListStreamItem& /*oSDARSCategoryListStreamItem*/)
{
}
tVoid most_fi_tcl_SDARSCategoryListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSCategoryListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSCategoryListStream(most_fi_tcl_SDARSCategoryListStream& /*oSDARSCategoryListStream*/)
{
}
tVoid most_fi_tcl_SDARSCategoryListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSCategoryListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SDARSChannelAdvisory(most_fi_tcl_e8_SDARSChannelAdvisory& /*oe8_SDARSChannelAdvisory*/)
{
}
tVoid most_fi_tcl_e8_SDARSChannelAdvisory::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SDARSChannelAdvisory(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SDARSSeekType(most_fi_tcl_e8_SDARSSeekType& /*oe8_SDARSSeekType*/)
{
}
tVoid most_fi_tcl_e8_SDARSSeekType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SDARSSeekType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SDARSSubscriptionStatus(most_fi_tcl_e8_SDARSSubscriptionStatus& /*oe8_SDARSSubscriptionStatus*/)
{
}
tVoid most_fi_tcl_e8_SDARSSubscriptionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SDARSSubscriptionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SDARSTSListType(most_fi_tcl_e8_SDARSTSListType& /*oe8_SDARSTSListType*/)
{
}
tVoid most_fi_tcl_e8_SDARSTSListType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SDARSTSListType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSTuneSelectListStreamItem(most_fi_tcl_SDARSTuneSelectListStreamItem& /*oSDARSTuneSelectListStreamItem*/)
{
}
tVoid most_fi_tcl_SDARSTuneSelectListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSTuneSelectListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSTuneSelectListStream(most_fi_tcl_SDARSTuneSelectListStream& /*oSDARSTuneSelectListStream*/)
{
}
tVoid most_fi_tcl_SDARSTuneSelectListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSTuneSelectListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSCategoryChannelListStreamItem(most_fi_tcl_SDARSCategoryChannelListStreamItem& /*oSDARSCategoryChannelListStreamItem*/)
{
}
tVoid most_fi_tcl_SDARSCategoryChannelListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSCategoryChannelListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSCategoryChannelListStream(most_fi_tcl_SDARSCategoryChannelListStream& /*oSDARSCategoryChannelListStream*/)
{
}
tVoid most_fi_tcl_SDARSCategoryChannelListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSCategoryChannelListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SDARSSXMAdvisory(most_fi_tcl_e8_SDARSSXMAdvisory& /*oe8_SDARSSXMAdvisory*/)
{
}
tVoid most_fi_tcl_e8_SDARSSXMAdvisory::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SDARSSXMAdvisory(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSChannelListDetailsItem(most_fi_tcl_SDARSChannelListDetailsItem& /*oSDARSChannelListDetailsItem*/)
{
}
tVoid most_fi_tcl_SDARSChannelListDetailsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSChannelListDetailsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSChannelListDetails(most_fi_tcl_SDARSChannelListDetails& /*oSDARSChannelListDetails*/)
{
}
tVoid most_fi_tcl_SDARSChannelListDetails::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSChannelListDetails(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSChannelListStreamItem(most_fi_tcl_SDARSChannelListStreamItem& /*oSDARSChannelListStreamItem*/)
{
}
tVoid most_fi_tcl_SDARSChannelListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSChannelListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSChannelListStream(most_fi_tcl_SDARSChannelListStream& /*oSDARSChannelListStream*/)
{
}
tVoid most_fi_tcl_SDARSChannelListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSChannelListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SDARSSDARSModuleType(most_fi_tcl_e8_SDARSSDARSModuleType& /*oe8_SDARSSDARSModuleType*/)
{
}
tVoid most_fi_tcl_e8_SDARSSDARSModuleType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SDARSSDARSModuleType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSExtendedChannelListStreamItem(most_fi_tcl_SDARSExtendedChannelListStreamItem& /*oSDARSExtendedChannelListStreamItem*/)
{
}
tVoid most_fi_tcl_SDARSExtendedChannelListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSExtendedChannelListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSExtendedChannelListStream(most_fi_tcl_SDARSExtendedChannelListStream& /*oSDARSExtendedChannelListStream*/)
{
}
tVoid most_fi_tcl_SDARSExtendedChannelListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSExtendedChannelListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SDARSDataAuthorization(most_fi_tcl_e8_SDARSDataAuthorization& /*oe8_SDARSDataAuthorization*/)
{
}
tVoid most_fi_tcl_e8_SDARSDataAuthorization::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SDARSDataAuthorization(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSSIDOnOffStreamItem(most_fi_tcl_SDARSSIDOnOffStreamItem& /*oSDARSSIDOnOffStreamItem*/)
{
}
tVoid most_fi_tcl_SDARSSIDOnOffStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSSIDOnOffStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SDARSSIDOnOffStream(most_fi_tcl_SDARSSIDOnOffStream& /*oSDARSSIDOnOffStream*/)
{
}
tVoid most_fi_tcl_SDARSSIDOnOffStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SDARSSIDOnOffStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TunHDAvailable(most_fi_tcl_e8_TunHDAvailable& /*oe8_TunHDAvailable*/)
{
}
tVoid most_fi_tcl_e8_TunHDAvailable::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TunHDAvailable(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TunRDSAvailable(most_fi_tcl_e8_TunRDSAvailable& /*oe8_TunRDSAvailable*/)
{
}
tVoid most_fi_tcl_e8_TunRDSAvailable::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TunRDSAvailable(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TunSeekType(most_fi_tcl_e8_TunSeekType& /*oe8_TunSeekType*/)
{
}
tVoid most_fi_tcl_e8_TunSeekType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TunSeekType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TunStationListUpdateStatus(most_fi_tcl_e8_TunStationListUpdateStatus& /*oe8_TunStationListUpdateStatus*/)
{
}
tVoid most_fi_tcl_e8_TunStationListUpdateStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TunStationListUpdateStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TunObjectIDList(most_fi_tcl_TunObjectIDList& /*oTunObjectIDList*/)
{
}
tVoid most_fi_tcl_TunObjectIDList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TunObjectIDList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TunStationListResultItem(most_fi_tcl_TunStationListResultItem& /*oTunStationListResultItem*/)
{
}
tVoid most_fi_tcl_TunStationListResultItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TunStationListResultItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TunStationListResult(most_fi_tcl_TunStationListResult& /*oTunStationListResult*/)
{
}
tVoid most_fi_tcl_TunStationListResult::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TunStationListResult(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TunStationListItem(most_fi_tcl_TunStationListItem& /*oTunStationListItem*/)
{
}
tVoid most_fi_tcl_TunStationListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TunStationListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TunStationList(most_fi_tcl_TunStationList& /*oTunStationList*/)
{
}
tVoid most_fi_tcl_TunStationList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TunStationList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskFileType(most_fi_tcl_e8_AudDskFileType& /*oe8_AudDskFileType*/)
{
}
tVoid most_fi_tcl_e8_AudDskFileType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskFileType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskFileFormat(most_fi_tcl_e8_AudDskFileFormat& /*oe8_AudDskFileFormat*/)
{
}
tVoid most_fi_tcl_e8_AudDskFileFormat::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskFileFormat(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudDskFileListItem(most_fi_tcl_AudDskFileListItem& /*oAudDskFileListItem*/)
{
}
tVoid most_fi_tcl_AudDskFileListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudDskFileListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudDskFileList(most_fi_tcl_AudDskFileList& /*oAudDskFileList*/)
{
}
tVoid most_fi_tcl_AudDskFileList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudDskFileList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskChange(most_fi_tcl_e8_AudDskChange& /*oe8_AudDskChange*/)
{
}
tVoid most_fi_tcl_e8_AudDskChange::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskChange(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudDskItems(most_fi_tcl_AudDskItems& /*oAudDskItems*/)
{
}
tVoid most_fi_tcl_AudDskItems::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudDskItems(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskDeckStatus(most_fi_tcl_e8_AudDskDeckStatus& /*oe8_AudDskDeckStatus*/)
{
}
tVoid most_fi_tcl_e8_AudDskDeckStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskDeckStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskDeckEvent(most_fi_tcl_e8_AudDskDeckEvent& /*oe8_AudDskDeckEvent*/)
{
}
tVoid most_fi_tcl_e8_AudDskDeckEvent::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskDeckEvent(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskDiskType(most_fi_tcl_e8_AudDskDiskType& /*oe8_AudDskDiskType*/)
{
}
tVoid most_fi_tcl_e8_AudDskDiskType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskDiskType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskPlaybackState(most_fi_tcl_e8_AudDskPlaybackState& /*oe8_AudDskPlaybackState*/)
{
}
tVoid most_fi_tcl_e8_AudDskPlaybackState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskPlaybackState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_AudDskNowPlaying(most_fi_tcl_AudDskNowPlaying& /*oAudDskNowPlaying*/)
{
}
tVoid most_fi_tcl_AudDskNowPlaying::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_AudDskNowPlaying(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskMediaEvent(most_fi_tcl_e8_AudDskMediaEvent& /*oe8_AudDskMediaEvent*/)
{
}
tVoid most_fi_tcl_e8_AudDskMediaEvent::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskMediaEvent(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskPlaybackAction(most_fi_tcl_e8_AudDskPlaybackAction& /*oe8_AudDskPlaybackAction*/)
{
}
tVoid most_fi_tcl_e8_AudDskPlaybackAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskPlaybackAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskRepeatState(most_fi_tcl_e8_AudDskRepeatState& /*oe8_AudDskRepeatState*/)
{
}
tVoid most_fi_tcl_e8_AudDskRepeatState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskRepeatState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_AudDskSeek(most_fi_tcl_e8_AudDskSeek& /*oe8_AudDskSeek*/)
{
}
tVoid most_fi_tcl_e8_AudDskSeek::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_AudDskSeek(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvAudioChannel(most_fi_tcl_e8_FavPrvAudioChannel& /*oe8_FavPrvAudioChannel*/)
{
}
tVoid most_fi_tcl_e8_FavPrvAudioChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvAudioChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvVideoChannel(most_fi_tcl_e8_FavPrvVideoChannel& /*oe8_FavPrvVideoChannel*/)
{
}
tVoid most_fi_tcl_e8_FavPrvVideoChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvVideoChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvFavoriteType(most_fi_tcl_e8_FavPrvFavoriteType& /*oe8_FavPrvFavoriteType*/)
{
}
tVoid most_fi_tcl_e8_FavPrvFavoriteType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvFavoriteType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavPrvFavoriteInfoItem(most_fi_tcl_FavPrvFavoriteInfoItem& /*oFavPrvFavoriteInfoItem*/)
{
}
tVoid most_fi_tcl_FavPrvFavoriteInfoItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavPrvFavoriteInfoItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavPrvFavoriteInfo(most_fi_tcl_FavPrvFavoriteInfo& /*oFavPrvFavoriteInfo*/)
{
}
tVoid most_fi_tcl_FavPrvFavoriteInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavPrvFavoriteInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_FavPrvListChangeType(most_fi_tcl_e8_FavPrvListChangeType& /*oe8_FavPrvListChangeType*/)
{
}
tVoid most_fi_tcl_e8_FavPrvListChangeType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_FavPrvListChangeType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_FavPrvChangedFavorites(most_fi_tcl_FavPrvChangedFavorites& /*oFavPrvChangedFavorites*/)
{
}
tVoid most_fi_tcl_FavPrvChangedFavorites::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_FavPrvChangedFavorites(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HDRadHDTuningStatus(most_fi_tcl_e8_HDRadHDTuningStatus& /*oe8_HDRadHDTuningStatus*/)
{
}
tVoid most_fi_tcl_e8_HDRadHDTuningStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HDRadHDTuningStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_HDRadPSD(most_fi_tcl_HDRadPSD& /*oHDRadPSD*/)
{
}
tVoid most_fi_tcl_HDRadPSD::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_HDRadPSD(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HDRadHDBandSelect(most_fi_tcl_e8_HDRadHDBandSelect& /*oe8_HDRadHDBandSelect*/)
{
}
tVoid most_fi_tcl_e8_HDRadHDBandSelect::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HDRadHDBandSelect(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_HDRadHDRcvrState(most_fi_tcl_e8_HDRadHDRcvrState& /*oe8_HDRadHDRcvrState*/)
{
}
tVoid most_fi_tcl_e8_HDRadHDRcvrState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_HDRadHDRcvrState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TrfARDSTuningState(most_fi_tcl_e8_TrfARDSTuningState& /*oe8_TrfARDSTuningState*/)
{
}
tVoid most_fi_tcl_e8_TrfARDSTuningState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TrfARDSTuningState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_b16_RDSMask(most_fi_tcl_b16_RDSMask& /*ob16_RDSMask*/)
{
}
tVoid most_fi_tcl_b16_RDSMask::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_b16_RDSMask(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_RDSFilterDataItem(most_fi_tcl_RDSFilterDataItem& /*oRDSFilterDataItem*/)
{
}
tVoid most_fi_tcl_RDSFilterDataItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_RDSFilterDataItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_RDSFilterData(most_fi_tcl_RDSFilterData& /*oRDSFilterData*/)
{
}
tVoid most_fi_tcl_RDSFilterData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_RDSFilterData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RDSGroupID(most_fi_tcl_e8_RDSGroupID& /*oe8_RDSGroupID*/)
{
}
tVoid most_fi_tcl_e8_RDSGroupID::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RDSGroupID(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RDSTunerSelection(most_fi_tcl_e8_RDSTunerSelection& /*oe8_RDSTunerSelection*/)
{
}
tVoid most_fi_tcl_e8_RDSTunerSelection::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RDSTunerSelection(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_RDSTMCMessage_(most_fi_tcl_RDSTMCMessage_& /*oRDSTMCMessage_*/)
{
}
tVoid most_fi_tcl_RDSTMCMessage_::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_RDSTMCMessage_(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_RDSTimeData(most_fi_tcl_RDSTimeData& /*oRDSTimeData*/)
{
}
tVoid most_fi_tcl_RDSTimeData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_RDSTimeData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_RDSRDSGroupMessage(most_fi_tcl_RDSRDSGroupMessage& /*oRDSRDSGroupMessage*/)
{
}
tVoid most_fi_tcl_RDSRDSGroupMessage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_RDSRDSGroupMessage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RDSBackgroundTMCStatusInfo(most_fi_tcl_e8_RDSBackgroundTMCStatusInfo& /*oe8_RDSBackgroundTMCStatusInfo*/)
{
}
tVoid most_fi_tcl_e8_RDSBackgroundTMCStatusInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RDSBackgroundTMCStatusInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RDSForegroundTMCStatusInfo(most_fi_tcl_e8_RDSForegroundTMCStatusInfo& /*oe8_RDSForegroundTMCStatusInfo*/)
{
}
tVoid most_fi_tcl_e8_RDSForegroundTMCStatusInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RDSForegroundTMCStatusInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_RDSTMCSenderNameInfo(most_fi_tcl_e8_RDSTMCSenderNameInfo& /*oe8_RDSTMCSenderNameInfo*/)
{
}
tVoid most_fi_tcl_e8_RDSTMCSenderNameInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_RDSTMCSenderNameInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_RDSTMCStationDataItem(most_fi_tcl_RDSTMCStationDataItem& /*oRDSTMCStationDataItem*/)
{
}
tVoid most_fi_tcl_RDSTMCStationDataItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_RDSTMCStationDataItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_RDSTMCStationData(most_fi_tcl_RDSTMCStationData& /*oRDSTMCStationData*/)
{
}
tVoid most_fi_tcl_RDSTMCStationData::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_RDSTMCStationData(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SnkAudioChannelName(most_fi_tcl_e8_SnkAudioChannelName& /*oe8_SnkAudioChannelName*/)
{
}
tVoid most_fi_tcl_e8_SnkAudioChannelName::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SnkAudioChannelName(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SnkContentProtection(most_fi_tcl_e8_SnkContentProtection& /*oe8_SnkContentProtection*/)
{
}
tVoid most_fi_tcl_e8_SnkContentProtection::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SnkContentProtection(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SnkContentType(most_fi_tcl_e8_SnkContentType& /*oe8_SnkContentType*/)
{
}
tVoid most_fi_tcl_e8_SnkContentType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SnkContentType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SnkTransmissionClass(most_fi_tcl_e8_SnkTransmissionClass& /*oe8_SnkTransmissionClass*/)
{
}
tVoid most_fi_tcl_e8_SnkTransmissionClass::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SnkTransmissionClass(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SnkAudioChannels_Resolution(most_fi_tcl_SnkAudioChannels_Resolution& /*oSnkAudioChannels_Resolution*/)
{
}
tVoid most_fi_tcl_SnkAudioChannels_Resolution::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SnkAudioChannels_Resolution(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SnkAudioChannelListItem(most_fi_tcl_SnkAudioChannelListItem& /*oSnkAudioChannelListItem*/)
{
}
tVoid most_fi_tcl_SnkAudioChannelListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SnkAudioChannelListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SnkAudioChannelList(most_fi_tcl_SnkAudioChannelList& /*oSnkAudioChannelList*/)
{
}
tVoid most_fi_tcl_SnkAudioChannelList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SnkAudioChannelList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SnkAudioChannels_AudioChannelList(most_fi_tcl_SnkAudioChannels_AudioChannelList& /*oSnkAudioChannels_AudioChannelList*/)
{
}
tVoid most_fi_tcl_SnkAudioChannels_AudioChannelList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SnkAudioChannels_AudioChannelList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SnkContentDescription(most_fi_tcl_SnkContentDescription& /*oSnkContentDescription*/)
{
}
tVoid most_fi_tcl_SnkContentDescription::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SnkContentDescription(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_VolVolumeListItem(most_fi_tcl_VolVolumeListItem& /*oVolVolumeListItem*/)
{
}
tVoid most_fi_tcl_VolVolumeListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_VolVolumeListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_VolVolumeList(most_fi_tcl_VolVolumeList& /*oVolVolumeList*/)
{
}
tVoid most_fi_tcl_VolVolumeList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_VolVolumeList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcAudioChannelName(most_fi_tcl_e8_SrcAudioChannelName& /*oe8_SrcAudioChannelName*/)
{
}
tVoid most_fi_tcl_e8_SrcAudioChannelName::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcAudioChannelName(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcContentProtection(most_fi_tcl_e8_SrcContentProtection& /*oe8_SrcContentProtection*/)
{
}
tVoid most_fi_tcl_e8_SrcContentProtection::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcContentProtection(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcContentType(most_fi_tcl_e8_SrcContentType& /*oe8_SrcContentType*/)
{
}
tVoid most_fi_tcl_e8_SrcContentType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcContentType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcTransmissionClass(most_fi_tcl_e8_SrcTransmissionClass& /*oe8_SrcTransmissionClass*/)
{
}
tVoid most_fi_tcl_e8_SrcTransmissionClass::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcTransmissionClass(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannels_Resolution(most_fi_tcl_SrcAudioChannels_Resolution& /*oSrcAudioChannels_Resolution*/)
{
}
tVoid most_fi_tcl_SrcAudioChannels_Resolution::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannels_Resolution(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannelListItem(most_fi_tcl_SrcAudioChannelListItem& /*oSrcAudioChannelListItem*/)
{
}
tVoid most_fi_tcl_SrcAudioChannelListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannelListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannelList(most_fi_tcl_SrcAudioChannelList& /*oSrcAudioChannelList*/)
{
}
tVoid most_fi_tcl_SrcAudioChannelList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannelList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcAudioChannels_AudioChannelList(most_fi_tcl_SrcAudioChannels_AudioChannelList& /*oSrcAudioChannels_AudioChannelList*/)
{
}
tVoid most_fi_tcl_SrcAudioChannels_AudioChannelList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcAudioChannels_AudioChannelList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SrcContentDescription(most_fi_tcl_SrcContentDescription& /*oSrcContentDescription*/)
{
}
tVoid most_fi_tcl_SrcContentDescription::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SrcContentDescription(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SrcActivity(most_fi_tcl_e8_SrcActivity& /*oe8_SrcActivity*/)
{
}
tVoid most_fi_tcl_e8_SrcActivity::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SrcActivity(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TShTimeShiftControlEnum(most_fi_tcl_e8_TShTimeShiftControlEnum& /*oe8_TShTimeShiftControlEnum*/)
{
}
tVoid most_fi_tcl_e8_TShTimeShiftControlEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TShTimeShiftControlEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TShTimeShiftStateEnum(most_fi_tcl_e8_TShTimeShiftStateEnum& /*oe8_TShTimeShiftStateEnum*/)
{
}
tVoid most_fi_tcl_e8_TShTimeShiftStateEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TShTimeShiftStateEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TchPadTouchDataListItem(most_fi_tcl_TchPadTouchDataListItem& /*oTchPadTouchDataListItem*/)
{
}
tVoid most_fi_tcl_TchPadTouchDataListItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TchPadTouchDataListItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TchPadTouchDataList(most_fi_tcl_TchPadTouchDataList& /*oTchPadTouchDataList*/)
{
}
tVoid most_fi_tcl_TchPadTouchDataList::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TchPadTouchDataList(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TchPadHapticFeedbackProfile(most_fi_tcl_e8_TchPadHapticFeedbackProfile& /*oe8_TchPadHapticFeedbackProfile*/)
{
}
tVoid most_fi_tcl_e8_TchPadHapticFeedbackProfile::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TchPadHapticFeedbackProfile(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TchPadProximityState(most_fi_tcl_e8_TchPadProximityState& /*oe8_TchPadProximityState*/)
{
}
tVoid most_fi_tcl_e8_TchPadProximityState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TchPadProximityState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TchPadButtonTypeEnum(most_fi_tcl_e8_TchPadButtonTypeEnum& /*oe8_TchPadButtonTypeEnum*/)
{
}
tVoid most_fi_tcl_e8_TchPadButtonTypeEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TchPadButtonTypeEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TchPadButtonStatesItem(most_fi_tcl_TchPadButtonStatesItem& /*oTchPadButtonStatesItem*/)
{
}
tVoid most_fi_tcl_TchPadButtonStatesItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TchPadButtonStatesItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TchPadButtonStates(most_fi_tcl_TchPadButtonStates& /*oTchPadButtonStates*/)
{
}
tVoid most_fi_tcl_TchPadButtonStates::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TchPadButtonStates(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMISRButton(most_fi_tcl_e8_SpcHMISRButton& /*oe8_SpcHMISRButton*/)
{
}
tVoid most_fi_tcl_e8_SpcHMISRButton::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMISRButton(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMISpeechWindow(most_fi_tcl_e8_SpcHMISpeechWindow& /*oe8_SpcHMISpeechWindow*/)
{
}
tVoid most_fi_tcl_e8_SpcHMISpeechWindow::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMISpeechWindow(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMISRStatus(most_fi_tcl_e8_SpcHMISRStatus& /*oe8_SpcHMISRStatus*/)
{
}
tVoid most_fi_tcl_e8_SpcHMISRStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMISRStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMIAction(most_fi_tcl_e8_SpcHMIAction& /*oe8_SpcHMIAction*/)
{
}
tVoid most_fi_tcl_e8_SpcHMIAction::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMIAction(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMINBestListStreamItem(most_fi_tcl_SpcHMINBestListStreamItem& /*oSpcHMINBestListStreamItem*/)
{
}
tVoid most_fi_tcl_SpcHMINBestListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMINBestListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMINBestListStream(most_fi_tcl_SpcHMINBestListStream& /*oSpcHMINBestListStream*/)
{
}
tVoid most_fi_tcl_SpcHMINBestListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMINBestListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMIExampleListStream(most_fi_tcl_SpcHMIExampleListStream& /*oSpcHMIExampleListStream*/)
{
}
tVoid most_fi_tcl_SpcHMIExampleListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMIExampleListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMISRLanguage(most_fi_tcl_e8_SpcHMISRLanguage& /*oe8_SpcHMISRLanguage*/)
{
}
tVoid most_fi_tcl_e8_SpcHMISRLanguage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMISRLanguage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMIDynamicControlTextStreamItem(most_fi_tcl_SpcHMIDynamicControlTextStreamItem& /*oSpcHMIDynamicControlTextStreamItem*/)
{
}
tVoid most_fi_tcl_SpcHMIDynamicControlTextStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMIDynamicControlTextStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMIDynamicControlTextStream(most_fi_tcl_SpcHMIDynamicControlTextStream& /*oSpcHMIDynamicControlTextStream*/)
{
}
tVoid most_fi_tcl_SpcHMIDynamicControlTextStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMIDynamicControlTextStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMIControlEnableState(most_fi_tcl_e8_SpcHMIControlEnableState& /*oe8_SpcHMIControlEnableState*/)
{
}
tVoid most_fi_tcl_e8_SpcHMIControlEnableState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMIControlEnableState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMIControlEnableStreamItem(most_fi_tcl_SpcHMIControlEnableStreamItem& /*oSpcHMIControlEnableStreamItem*/)
{
}
tVoid most_fi_tcl_SpcHMIControlEnableStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMIControlEnableStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMIControlEnableStream(most_fi_tcl_SpcHMIControlEnableStream& /*oSpcHMIControlEnableStream*/)
{
}
tVoid most_fi_tcl_SpcHMIControlEnableStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMIControlEnableStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMIDisplayEnum(most_fi_tcl_e8_SpcHMIDisplayEnum& /*oe8_SpcHMIDisplayEnum*/)
{
}
tVoid most_fi_tcl_e8_SpcHMIDisplayEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMIDisplayEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMIPromptVerboseness(most_fi_tcl_e8_SpcHMIPromptVerboseness& /*oe8_SpcHMIPromptVerboseness*/)
{
}
tVoid most_fi_tcl_e8_SpcHMIPromptVerboseness::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMIPromptVerboseness(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMIConfirmationLevel(most_fi_tcl_e8_SpcHMIConfirmationLevel& /*oe8_SpcHMIConfirmationLevel*/)
{
}
tVoid most_fi_tcl_e8_SpcHMIConfirmationLevel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMIConfirmationLevel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMISRLanguageStream(most_fi_tcl_SpcHMISRLanguageStream& /*oSpcHMISRLanguageStream*/)
{
}
tVoid most_fi_tcl_SpcHMISRLanguageStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMISRLanguageStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMISRDomain(most_fi_tcl_e8_SpcHMISRDomain& /*oe8_SpcHMISRDomain*/)
{
}
tVoid most_fi_tcl_e8_SpcHMISRDomain::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMISRDomain(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMISRDomainSpecificStatus(most_fi_tcl_e8_SpcHMISRDomainSpecificStatus& /*oe8_SpcHMISRDomainSpecificStatus*/)
{
}
tVoid most_fi_tcl_e8_SpcHMISRDomainSpecificStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMISRDomainSpecificStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SpcHMIDeviceTranscriptionState(most_fi_tcl_e8_SpcHMIDeviceTranscriptionState& /*oe8_SpcHMIDeviceTranscriptionState*/)
{
}
tVoid most_fi_tcl_e8_SpcHMIDeviceTranscriptionState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SpcHMIDeviceTranscriptionState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMISRDomainDynamicDataStatusItem(most_fi_tcl_SpcHMISRDomainDynamicDataStatusItem& /*oSpcHMISRDomainDynamicDataStatusItem*/)
{
}
tVoid most_fi_tcl_SpcHMISRDomainDynamicDataStatusItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMISRDomainDynamicDataStatusItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMISRDomainDynamicDataStatus(most_fi_tcl_SpcHMISRDomainDynamicDataStatus& /*oSpcHMISRDomainDynamicDataStatus*/)
{
}
tVoid most_fi_tcl_SpcHMISRDomainDynamicDataStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMISRDomainDynamicDataStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMISRDomainStatusListStreamItem(most_fi_tcl_SpcHMISRDomainStatusListStreamItem& /*oSpcHMISRDomainStatusListStreamItem*/)
{
}
tVoid most_fi_tcl_SpcHMISRDomainStatusListStreamItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMISRDomainStatusListStreamItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SpcHMISRDomainStatusListStream(most_fi_tcl_SpcHMISRDomainStatusListStream& /*oSpcHMISRDomainStatusListStream*/)
{
}
tVoid most_fi_tcl_SpcHMISRDomainStatusListStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SpcHMISRDomainStatusListStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SRecTParameterLoadStatus(most_fi_tcl_e8_SRecTParameterLoadStatus& /*oe8_SRecTParameterLoadStatus*/)
{
}
tVoid most_fi_tcl_e8_SRecTParameterLoadStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SRecTParameterLoadStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SRecTInterfaceEnable(most_fi_tcl_e8_SRecTInterfaceEnable& /*oe8_SRecTInterfaceEnable*/)
{
}
tVoid most_fi_tcl_e8_SRecTInterfaceEnable::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SRecTInterfaceEnable(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SRecTRecognitionError(most_fi_tcl_e8_SRecTRecognitionError& /*oe8_SRecTRecognitionError*/)
{
}
tVoid most_fi_tcl_e8_SRecTRecognitionError::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SRecTRecognitionError(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SRecTRecognitionResultsItem(most_fi_tcl_SRecTRecognitionResultsItem& /*oSRecTRecognitionResultsItem*/)
{
}
tVoid most_fi_tcl_SRecTRecognitionResultsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SRecTRecognitionResultsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SRecTRecognitionResults(most_fi_tcl_SRecTRecognitionResults& /*oSRecTRecognitionResults*/)
{
}
tVoid most_fi_tcl_SRecTRecognitionResults::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SRecTRecognitionResults(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SRecTNFSStatus(most_fi_tcl_e8_SRecTNFSStatus& /*oe8_SRecTNFSStatus*/)
{
}
tVoid most_fi_tcl_e8_SRecTNFSStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SRecTNFSStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SRecTRecordingsEnable(most_fi_tcl_e8_SRecTRecordingsEnable& /*oe8_SRecTRecordingsEnable*/)
{
}
tVoid most_fi_tcl_e8_SRecTRecordingsEnable::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SRecTRecordingsEnable(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SRecTConfidenceThresholdsItem(most_fi_tcl_SRecTConfidenceThresholdsItem& /*oSRecTConfidenceThresholdsItem*/)
{
}
tVoid most_fi_tcl_SRecTConfidenceThresholdsItem::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SRecTConfidenceThresholdsItem(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SRecTConfidenceThresholds(most_fi_tcl_SRecTConfidenceThresholds& /*oSRecTConfidenceThresholds*/)
{
}
tVoid most_fi_tcl_SRecTConfidenceThresholds::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SRecTConfidenceThresholds(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaAnimationState(most_fi_tcl_e8_SyStaAnimationState& /*oe8_SyStaAnimationState*/)
{
}
tVoid most_fi_tcl_e8_SyStaAnimationState::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaAnimationState(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaSystemStateEnumeration(most_fi_tcl_e8_SyStaSystemStateEnumeration& /*oe8_SyStaSystemStateEnumeration*/)
{
}
tVoid most_fi_tcl_e8_SyStaSystemStateEnumeration::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaSystemStateEnumeration(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaModuleLockReportingEnum(most_fi_tcl_e8_SyStaModuleLockReportingEnum& /*oe8_SyStaModuleLockReportingEnum*/)
{
}
tVoid most_fi_tcl_e8_SyStaModuleLockReportingEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaModuleLockReportingEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaNoVINStates(most_fi_tcl_e8_SyStaNoVINStates& /*oe8_SyStaNoVINStates*/)
{
}
tVoid most_fi_tcl_e8_SyStaNoVINStates::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaNoVINStates(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaNoCalibrationStates(most_fi_tcl_e8_SyStaNoCalibrationStates& /*oe8_SyStaNoCalibrationStates*/)
{
}
tVoid most_fi_tcl_e8_SyStaNoCalibrationStates::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaNoCalibrationStates(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaTheftLockStates(most_fi_tcl_e8_SyStaTheftLockStates& /*oe8_SyStaTheftLockStates*/)
{
}
tVoid most_fi_tcl_e8_SyStaTheftLockStates::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaTheftLockStates(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaDateFormatEnum(most_fi_tcl_e8_SyStaDateFormatEnum& /*oe8_SyStaDateFormatEnum*/)
{
}
tVoid most_fi_tcl_e8_SyStaDateFormatEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaDateFormatEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaCalendarMonth(most_fi_tcl_e8_SyStaCalendarMonth& /*oe8_SyStaCalendarMonth*/)
{
}
tVoid most_fi_tcl_e8_SyStaCalendarMonth::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaCalendarMonth(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_SyStaTimeOfDayStream(most_fi_tcl_SyStaTimeOfDayStream& /*oSyStaTimeOfDayStream*/)
{
}
tVoid most_fi_tcl_SyStaTimeOfDayStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_SyStaTimeOfDayStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaTimeDisplayFormatEnum(most_fi_tcl_e8_SyStaTimeDisplayFormatEnum& /*oe8_SyStaTimeDisplayFormatEnum*/)
{
}
tVoid most_fi_tcl_e8_SyStaTimeDisplayFormatEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaTimeDisplayFormatEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_SyStaAutoTimeUpdateSettingEnum(most_fi_tcl_e8_SyStaAutoTimeUpdateSettingEnum& /*oe8_SyStaAutoTimeUpdateSettingEnum*/)
{
}
tVoid most_fi_tcl_e8_SyStaAutoTimeUpdateSettingEnum::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_SyStaAutoTimeUpdateSettingEnum(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TestFBTestMode(most_fi_tcl_e8_TestFBTestMode& /*oe8_TestFBTestMode*/)
{
}
tVoid most_fi_tcl_e8_TestFBTestMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TestFBTestMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TestFBTestFIlenameOrBuffer(most_fi_tcl_TestFBTestFIlenameOrBuffer& /*oTestFBTestFIlenameOrBuffer*/)
{
}
tVoid most_fi_tcl_TestFBTestFIlenameOrBuffer::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TestFBTestFIlenameOrBuffer(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TestFBErrorInfo(most_fi_tcl_e8_TestFBErrorInfo& /*oe8_TestFBErrorInfo*/)
{
}
tVoid most_fi_tcl_e8_TestFBErrorInfo::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TestFBErrorInfo(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TestFBMostChannel(most_fi_tcl_e8_TestFBMostChannel& /*oe8_TestFBMostChannel*/)
{
}
tVoid most_fi_tcl_e8_TestFBMostChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TestFBMostChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSReadMode(most_fi_tcl_e8_TTSReadMode& /*oe8_TTSReadMode*/)
{
}
tVoid most_fi_tcl_e8_TTSReadMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSReadMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSLogicalAVChannel(most_fi_tcl_e8_TTSLogicalAVChannel& /*oe8_TTSLogicalAVChannel*/)
{
}
tVoid most_fi_tcl_e8_TTSLogicalAVChannel::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSLogicalAVChannel(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSMarkerMode(most_fi_tcl_e8_TTSMarkerMode& /*oe8_TTSMarkerMode*/)
{
}
tVoid most_fi_tcl_e8_TTSMarkerMode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSMarkerMode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSMarkerType(most_fi_tcl_e8_TTSMarkerType& /*oe8_TTSMarkerType*/)
{
}
tVoid most_fi_tcl_e8_TTSMarkerType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSMarkerType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSPriority(most_fi_tcl_e8_TTSPriority& /*oe8_TTSPriority*/)
{
}
tVoid most_fi_tcl_e8_TTSPriority::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSPriority(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSRequestStatus(most_fi_tcl_e8_TTSRequestStatus& /*oe8_TTSRequestStatus*/)
{
}
tVoid most_fi_tcl_e8_TTSRequestStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSRequestStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSTextType(most_fi_tcl_e8_TTSTextType& /*oe8_TTSTextType*/)
{
}
tVoid most_fi_tcl_e8_TTSTextType::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSTextType(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSTTSLanguage(most_fi_tcl_e8_TTSTTSLanguage& /*oe8_TTSTTSLanguage*/)
{
}
tVoid most_fi_tcl_e8_TTSTTSLanguage::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSTTSLanguage(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSPlaymode(most_fi_tcl_e8_TTSPlaymode& /*oe8_TTSPlaymode*/)
{
}
tVoid most_fi_tcl_e8_TTSPlaymode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSPlaymode(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_TTSAvailableTTSLanguageStream(most_fi_tcl_TTSAvailableTTSLanguageStream& /*oTTSAvailableTTSLanguageStream*/)
{
}
tVoid most_fi_tcl_TTSAvailableTTSLanguageStream::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_TTSAvailableTTSLanguageStream(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSRequestContinuousSessionStatus(most_fi_tcl_e8_TTSRequestContinuousSessionStatus& /*oe8_TTSRequestContinuousSessionStatus*/)
{
}
tVoid most_fi_tcl_e8_TTSRequestContinuousSessionStatus::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSRequestContinuousSessionStatus(*this);
}

tVoid most_fi_tclVisitorBase::vVisit_e8_TTSContinuousSessionPlaymode(most_fi_tcl_e8_TTSContinuousSessionPlaymode& /*oe8_TTSContinuousSessionPlaymode*/)
{
}
tVoid most_fi_tcl_e8_TTSContinuousSessionPlaymode::vTakeVisitor(most_fi_tclVisitorBase& rfoVisitor)
{
   rfoVisitor.vVisit_e8_TTSContinuousSessionPlaymode(*this);
}

