#ifndef MOST_FIVISITOR_HEADER
#define MOST_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class most_fi_tclOutput {
public:
   most_fi_tclOutput();
   virtual ~most_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class most_fi_tclFileOutput : public most_fi_tclOutput 
{
public:
   most_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   most_fi_tclFileOutput(); //lint !e1704
   most_fi_tclFileOutput& operator=(const most_fi_tclFileOutput& coRef);
   most_fi_tclFileOutput(const most_fi_tclFileOutput& coRef); //lint !e1704
};

class most_fi_tclMemOutput : public most_fi_tclOutput
{
public:
   most_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~most_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   most_fi_tclMemOutput(); //lint !e1704
   most_fi_tclMemOutput(const most_fi_tclMemOutput& coRef); //lint !e1704
   most_fi_tclMemOutput& operator=(const most_fi_tclMemOutput& coRef); //lint !e1704
};

///////////////////////////////////////////////////////////////////////////////
//
// special version including MOST compatible types
//
// implementation omitted intentionally for 
// bool, U8, U16, U24, U32, S8, S16, S24, S32, list and multilanguage string
//
///////////////////////////////////////////////////////////////////////////////

class MY_DECL most_fi_tclVisitorBase {
public:

   // --Konstruktor
   most_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~most_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(most_fi_tclU8& oU8);
   virtual tVoid vVisitS8(most_fi_tclS8& oS8);
   virtual tVoid vVisitU16(most_fi_tclU16& oU16);
   virtual tVoid vVisitS16(most_fi_tclS16& oS16);
   virtual tVoid vVisitU32(most_fi_tclU32& oU32);
   virtual tVoid vVisitS32(most_fi_tclS32& oS32);
   virtual tVoid vVisitBool(most_fi_tclBool& oBool);

   virtual tVoid vVisit_String(most_fi_tcl_String& oString);  // MOST-compatible String
   virtual tVoid vVisit_TrailingStream(most_fi_tcl_TrailingStream& oContainer);
   virtual tVoid vVisit_ShortStream(most_fi_tcl_ShortStream& oContainer);
   virtual tVoid vVisit_ClassifiedStream(most_fi_tcl_ClassifiedStream& oContainer);
   virtual tVoid vVisit_e8_ErrorCode(most_fi_tcl_e8_ErrorCode& oe8_ErrorCode);

   virtual tVoid vVisit_e8_AdPrAsObjectDetectionEventEnum(most_fi_tcl_e8_AdPrAsObjectDetectionEventEnum& oe8_AdPrAsObjectDetectionEventEnum);

   virtual tVoid vVisit_e8_AdPrAsParkInstructionValue(most_fi_tcl_e8_AdPrAsParkInstructionValue& oe8_AdPrAsParkInstructionValue);

   virtual tVoid vVisit_e8_AdPrAsParkInstructionAPA2Value(most_fi_tcl_e8_AdPrAsParkInstructionAPA2Value& oe8_AdPrAsParkInstructionAPA2Value);

   virtual tVoid vVisit_e8_AdPrAsHeaderIconLeftAPA2Value(most_fi_tcl_e8_AdPrAsHeaderIconLeftAPA2Value& oe8_AdPrAsHeaderIconLeftAPA2Value);

   virtual tVoid vVisit_e8_AdPrAsHeaderIconRightAPA2Value(most_fi_tcl_e8_AdPrAsHeaderIconRightAPA2Value& oe8_AdPrAsHeaderIconRightAPA2Value);

   virtual tVoid vVisit_e8_AdPrAsFooterTextAPA2Value(most_fi_tcl_e8_AdPrAsFooterTextAPA2Value& oe8_AdPrAsFooterTextAPA2Value);

   virtual tVoid vVisit_e8_AdPrAsInfotainmentSoftButtonFocusValue(most_fi_tcl_e8_AdPrAsInfotainmentSoftButtonFocusValue& oe8_AdPrAsInfotainmentSoftButtonFocusValue);

   virtual tVoid vVisit_e8_AtManDisplayType(most_fi_tcl_e8_AtManDisplayType& oe8_AtManDisplayType);

   virtual tVoid vVisit_e8_AtManAckType(most_fi_tcl_e8_AtManAckType& oe8_AtManAckType);

   virtual tVoid vVisit_e8_AtManPriority(most_fi_tcl_e8_AtManPriority& oe8_AtManPriority);

   virtual tVoid vVisit_e8_AtManButtonAction(most_fi_tcl_e8_AtManButtonAction& oe8_AtManButtonAction);

   virtual tVoid vVisit_AtManBluetooth_Call_Active_with_Known_Contact(most_fi_tcl_AtManBluetooth_Call_Active_with_Known_Contact& oAtManBluetooth_Call_Active_with_Known_Contact);

   virtual tVoid vVisit_AtManEmail_sent_successfully_alert(most_fi_tcl_AtManEmail_sent_successfully_alert& oAtManEmail_sent_successfully_alert);

   virtual tVoid vVisit_AtManNew_Email_received_alert(most_fi_tcl_AtManNew_Email_received_alert& oAtManNew_Email_received_alert);

   virtual tVoid vVisit_AtManNew_Text_Received_Alert(most_fi_tcl_AtManNew_Text_Received_Alert& oAtManNew_Text_Received_Alert);

   virtual tVoid vVisit_AtManCall_Ended_With_Known_Contact_Alert(most_fi_tcl_AtManCall_Ended_With_Known_Contact_Alert& oAtManCall_Ended_With_Known_Contact_Alert);

   virtual tVoid vVisit_AtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert(most_fi_tcl_AtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert& oAtManID_of_TrafficEvent_in_Traffic_Ahead_on_Route_alert);

   virtual tVoid vVisit_AtManID_of_TrafficEvent_in_Traffic_Ahead_alert(most_fi_tcl_AtManID_of_TrafficEvent_in_Traffic_Ahead_alert& oAtManID_of_TrafficEvent_in_Traffic_Ahead_alert);

   virtual tVoid vVisit_AtManID_of_weather_event__in_Weather_Advisory_alert(most_fi_tcl_AtManID_of_weather_event__in_Weather_Advisory_alert& oAtManID_of_weather_event__in_Weather_Advisory_alert);

   virtual tVoid vVisit_AtManText_Message_Sent_Successfully_Alert(most_fi_tcl_AtManText_Message_Sent_Successfully_Alert& oAtManText_Message_Sent_Successfully_Alert);

   virtual tVoid vVisit_AtManText_Message_Delivery_Failure_Alert(most_fi_tcl_AtManText_Message_Delivery_Failure_Alert& oAtManText_Message_Delivery_Failure_Alert);

   virtual tVoid vVisit_AtManEmail_Delivery_Failure_Alert(most_fi_tcl_AtManEmail_Delivery_Failure_Alert& oAtManEmail_Delivery_Failure_Alert);

   virtual tVoid vVisit_AtManAlertParameterDataStream(most_fi_tcl_AtManAlertParameterDataStream& oAtManAlertParameterDataStream);

   virtual tVoid vVisit_AtManButtonActionStream(most_fi_tcl_AtManButtonActionStream& oAtManButtonActionStream);

   virtual tVoid vVisit_AtManCurrentAlertStreamItem(most_fi_tcl_AtManCurrentAlertStreamItem& oAtManCurrentAlertStreamItem);

   virtual tVoid vVisit_AtManCurrentAlertStream(most_fi_tcl_AtManCurrentAlertStream& oAtManCurrentAlertStream);

   virtual tVoid vVisit_AtManAlertStreamItem(most_fi_tcl_AtManAlertStreamItem& oAtManAlertStreamItem);

   virtual tVoid vVisit_AtManAlertStream(most_fi_tcl_AtManAlertStream& oAtManAlertStream);

   virtual tVoid vVisit_e8_AtManAlertDisplayedEnum(most_fi_tcl_e8_AtManAlertDisplayedEnum& oe8_AtManAlertDisplayedEnum);

   virtual tVoid vVisit_AtManDisplayTypeStream(most_fi_tcl_AtManDisplayTypeStream& oAtManDisplayTypeStream);

   virtual tVoid vVisit_AtManAlertIDStreamItem(most_fi_tcl_AtManAlertIDStreamItem& oAtManAlertIDStreamItem);

   virtual tVoid vVisit_AtManAlertIDStream(most_fi_tcl_AtManAlertIDStream& oAtManAlertIDStream);

   virtual tVoid vVisit_e8_AmpATCConfiguration(most_fi_tcl_e8_AmpATCConfiguration& oe8_AmpATCConfiguration);

   virtual tVoid vVisit_AmpDSPModeEnabledStream(most_fi_tcl_AmpDSPModeEnabledStream& oAmpDSPModeEnabledStream);

   virtual tVoid vVisit_e8_AudCuCueTypeEnum(most_fi_tcl_e8_AudCuCueTypeEnum& oe8_AudCuCueTypeEnum);

   virtual tVoid vVisit_e8_AudCuCueCalibrationEnum(most_fi_tcl_e8_AudCuCueCalibrationEnum& oe8_AudCuCueCalibrationEnum);

   virtual tVoid vVisit_AudCuCueCalibrationStreamItem(most_fi_tcl_AudCuCueCalibrationStreamItem& oAudCuCueCalibrationStreamItem);

   virtual tVoid vVisit_AudCuCueCalibrationStream(most_fi_tcl_AudCuCueCalibrationStream& oAudCuCueCalibrationStream);

   virtual tVoid vVisit_e8_AudCuCueEnableEnum(most_fi_tcl_e8_AudCuCueEnableEnum& oe8_AudCuCueEnableEnum);

   virtual tVoid vVisit_AudCuCueEnableStreamItem(most_fi_tcl_AudCuCueEnableStreamItem& oAudCuCueEnableStreamItem);

   virtual tVoid vVisit_AudCuCueEnableStream(most_fi_tcl_AudCuCueEnableStream& oAudCuCueEnableStream);

   virtual tVoid vVisit_e8_AudCuPlayStatusEnum(most_fi_tcl_e8_AudCuPlayStatusEnum& oe8_AudCuPlayStatusEnum);

   virtual tVoid vVisit_e8_AudCuAudibleFeedbackType(most_fi_tcl_e8_AudCuAudibleFeedbackType& oe8_AudCuAudibleFeedbackType);

   virtual tVoid vVisit_AVManConnectionListItem(most_fi_tcl_AVManConnectionListItem& oAVManConnectionListItem);

   virtual tVoid vVisit_AVManConnectionList(most_fi_tcl_AVManConnectionList& oAVManConnectionList);

   virtual tVoid vVisit_e8_AVManLogicalAVChannel(most_fi_tcl_e8_AVManLogicalAVChannel& oe8_AVManLogicalAVChannel);

   virtual tVoid vVisit_e8_AVManRequestResult(most_fi_tcl_e8_AVManRequestResult& oe8_AVManRequestResult);

   virtual tVoid vVisit_e8_AVManChannelStatus(most_fi_tcl_e8_AVManChannelStatus& oe8_AVManChannelStatus);

   virtual tVoid vVisit_AVManBaseStatusItem(most_fi_tcl_AVManBaseStatusItem& oAVManBaseStatusItem);

   virtual tVoid vVisit_AVManBaseStatus(most_fi_tcl_AVManBaseStatus& oAVManBaseStatus);

   virtual tVoid vVisit_AVManRearStatusItem(most_fi_tcl_AVManRearStatusItem& oAVManRearStatusItem);

   virtual tVoid vVisit_AVManRearStatus(most_fi_tcl_AVManRearStatus& oAVManRearStatus);

   virtual tVoid vVisit_AVManHeadphoneStatusItem(most_fi_tcl_AVManHeadphoneStatusItem& oAVManHeadphoneStatusItem);

   virtual tVoid vVisit_AVManHeadphoneStatus(most_fi_tcl_AVManHeadphoneStatus& oAVManHeadphoneStatus);

   virtual tVoid vVisit_AVManVideoStatusItem(most_fi_tcl_AVManVideoStatusItem& oAVManVideoStatusItem);

   virtual tVoid vVisit_AVManVideoStatus(most_fi_tcl_AVManVideoStatus& oAVManVideoStatus);

   virtual tVoid vVisit_e8_AVManBaseVoiceMode(most_fi_tcl_e8_AVManBaseVoiceMode& oe8_AVManBaseVoiceMode);

   virtual tVoid vVisit_e8_AVManRearVoiceMode(most_fi_tcl_e8_AVManRearVoiceMode& oe8_AVManRearVoiceMode);

   virtual tVoid vVisit_e8_AVManVolumeGroup(most_fi_tcl_e8_AVManVolumeGroup& oe8_AVManVolumeGroup);

   virtual tVoid vVisit_e8_AVManAVCType(most_fi_tcl_e8_AVManAVCType& oe8_AVManAVCType);

   virtual tVoid vVisit_e8_AVManATCSetting(most_fi_tcl_e8_AVManATCSetting& oe8_AVManATCSetting);

   virtual tVoid vVisit_AVManVolumeGroupExtentStreamItem(most_fi_tcl_AVManVolumeGroupExtentStreamItem& oAVManVolumeGroupExtentStreamItem);

   virtual tVoid vVisit_AVManVolumeGroupExtentStream(most_fi_tcl_AVManVolumeGroupExtentStream& oAVManVolumeGroupExtentStream);

   virtual tVoid vVisit_e8_AVManRearVolumeGroup(most_fi_tcl_e8_AVManRearVolumeGroup& oe8_AVManRearVolumeGroup);

   virtual tVoid vVisit_AVManRearVolumeGroupExtentStreamItem(most_fi_tcl_AVManRearVolumeGroupExtentStreamItem& oAVManRearVolumeGroupExtentStreamItem);

   virtual tVoid vVisit_AVManRearVolumeGroupExtentStream(most_fi_tcl_AVManRearVolumeGroupExtentStream& oAVManRearVolumeGroupExtentStream);

   virtual tVoid vVisit_e8_AuxInInsertionStatus(most_fi_tcl_e8_AuxInInsertionStatus& oe8_AuxInInsertionStatus);

   virtual tVoid vVisit_e8_AuxTchProximityState(most_fi_tcl_e8_AuxTchProximityState& oe8_AuxTchProximityState);

   virtual tVoid vVisit_AuxTchInteractionInfoListItem(most_fi_tcl_AuxTchInteractionInfoListItem& oAuxTchInteractionInfoListItem);

   virtual tVoid vVisit_AuxTchInteractionInfoList(most_fi_tcl_AuxTchInteractionInfoList& oAuxTchInteractionInfoList);

   virtual tVoid vVisit_e8_CntStkSwipeApplication(most_fi_tcl_e8_CntStkSwipeApplication& oe8_CntStkSwipeApplication);

   virtual tVoid vVisit_e8_CntStkDayNightModeOverrideSetting(most_fi_tcl_e8_CntStkDayNightModeOverrideSetting& oe8_CntStkDayNightModeOverrideSetting);

   virtual tVoid vVisit_CntStkAppsItem(most_fi_tcl_CntStkAppsItem& oCntStkAppsItem);

   virtual tVoid vVisit_CntStkApps(most_fi_tcl_CntStkApps& oCntStkApps);

   virtual tVoid vVisit_e8_CntStkSearchResult(most_fi_tcl_e8_CntStkSearchResult& oe8_CntStkSearchResult);

   virtual tVoid vVisit_e8_CntStkAckType(most_fi_tcl_e8_CntStkAckType& oe8_CntStkAckType);

   virtual tVoid vVisit_CntStkButtonText(most_fi_tcl_CntStkButtonText& oCntStkButtonText);

   virtual tVoid vVisit_e8_CntStkApplicationID(most_fi_tcl_e8_CntStkApplicationID& oe8_CntStkApplicationID);

   virtual tVoid vVisit_e8_BCMSetApproachLightingValue(most_fi_tcl_e8_BCMSetApproachLightingValue& oe8_BCMSetApproachLightingValue);

   virtual tVoid vVisit_e8_BCMSetAutoReverseGearRearWiperSettingValue(most_fi_tcl_e8_BCMSetAutoReverseGearRearWiperSettingValue& oe8_BCMSetAutoReverseGearRearWiperSettingValue);

   virtual tVoid vVisit_e8_BCMSetDriverPersonalizationSettingValue(most_fi_tcl_e8_BCMSetDriverPersonalizationSettingValue& oe8_BCMSetDriverPersonalizationSettingValue);

   virtual tVoid vVisit_e8_BCMSetExitLightTimeSettingValue(most_fi_tcl_e8_BCMSetExitLightTimeSettingValue& oe8_BCMSetExitLightTimeSettingValue);

   virtual tVoid vVisit_e8_BCMSetRemoteStartSettingValue(most_fi_tcl_e8_BCMSetRemoteStartSettingValue& oe8_BCMSetRemoteStartSettingValue);

   virtual tVoid vVisit_e8_BCMSetRemoteStartCooledSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartCooledSeatSettingValue& oe8_BCMSetRemoteStartCooledSeatSettingValue);

   virtual tVoid vVisit_e8_BCMSetRemoteStartHeatedSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartHeatedSeatSettingValue& oe8_BCMSetRemoteStartHeatedSeatSettingValue);

   virtual tVoid vVisit_e8_BCMSetPowertrainPerformanceSettingValue(most_fi_tcl_e8_BCMSetPowertrainPerformanceSettingValue& oe8_BCMSetPowertrainPerformanceSettingValue);

   virtual tVoid vVisit_e8_BCMSetDaytimeTaillightsSettingValue(most_fi_tcl_e8_BCMSetDaytimeTaillightsSettingValue& oe8_BCMSetDaytimeTaillightsSettingValue);

   virtual tVoid vVisit_e8_BCMSetRemoteStartCooledDrPasSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartCooledDrPasSeatSettingValue& oe8_BCMSetRemoteStartCooledDrPasSeatSettingValue);

   virtual tVoid vVisit_e8_BCMSetRemoteStartHeatedDrPasSeatSettingValue(most_fi_tcl_e8_BCMSetRemoteStartHeatedDrPasSeatSettingValue& oe8_BCMSetRemoteStartHeatedDrPasSeatSettingValue);

   virtual tVoid vVisit_e8_BCMSetRainSenseWipersSettingValue(most_fi_tcl_e8_BCMSetRainSenseWipersSettingValue& oe8_BCMSetRainSenseWipersSettingValue);

   virtual tVoid vVisit_e8_BCMSetRemoteWindowOperationSettingValue(most_fi_tcl_e8_BCMSetRemoteWindowOperationSettingValue& oe8_BCMSetRemoteWindowOperationSettingValue);

   virtual tVoid vVisit_e8_BCMApproachLightingSettingValue(most_fi_tcl_e8_BCMApproachLightingSettingValue& oe8_BCMApproachLightingSettingValue);

   virtual tVoid vVisit_e8_BCMAutoReverseGearRearWiperSettingValue(most_fi_tcl_e8_BCMAutoReverseGearRearWiperSettingValue& oe8_BCMAutoReverseGearRearWiperSettingValue);

   virtual tVoid vVisit_e8_BCMDriverPersonalizationSettingValue(most_fi_tcl_e8_BCMDriverPersonalizationSettingValue& oe8_BCMDriverPersonalizationSettingValue);

   virtual tVoid vVisit_e8_BCMExitLightTimeSettingValue(most_fi_tcl_e8_BCMExitLightTimeSettingValue& oe8_BCMExitLightTimeSettingValue);

   virtual tVoid vVisit_e8_BCMRemoteStartSettingValue(most_fi_tcl_e8_BCMRemoteStartSettingValue& oe8_BCMRemoteStartSettingValue);

   virtual tVoid vVisit_e8_BCMRemoteStartCooledSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartCooledSeatSettingValue& oe8_BCMRemoteStartCooledSeatSettingValue);

   virtual tVoid vVisit_e8_BCMRemoteStartHeatedSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartHeatedSeatSettingValue& oe8_BCMRemoteStartHeatedSeatSettingValue);

   virtual tVoid vVisit_e8_BCMPowertrainPerformanceSettingValue(most_fi_tcl_e8_BCMPowertrainPerformanceSettingValue& oe8_BCMPowertrainPerformanceSettingValue);

   virtual tVoid vVisit_e8_BCMDaytimeTaillightsSettingValue(most_fi_tcl_e8_BCMDaytimeTaillightsSettingValue& oe8_BCMDaytimeTaillightsSettingValue);

   virtual tVoid vVisit_e8_BCMRemoteStartCooledDrPasSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartCooledDrPasSeatSettingValue& oe8_BCMRemoteStartCooledDrPasSeatSettingValue);

   virtual tVoid vVisit_e8_BCMRemoteStartHeatedDrPasSeatSettingValue(most_fi_tcl_e8_BCMRemoteStartHeatedDrPasSeatSettingValue& oe8_BCMRemoteStartHeatedDrPasSeatSettingValue);

   virtual tVoid vVisit_e8_BCMRainSenseWipersSettingValue(most_fi_tcl_e8_BCMRainSenseWipersSettingValue& oe8_BCMRainSenseWipersSettingValue);

   virtual tVoid vVisit_e8_BCMRemoteWindowOperationSettingValue(most_fi_tcl_e8_BCMRemoteWindowOperationSettingValue& oe8_BCMRemoteWindowOperationSettingValue);

   virtual tVoid vVisit_e8_DorLckSetAutoLockingSettingValue(most_fi_tcl_e8_DorLckSetAutoLockingSettingValue& oe8_DorLckSetAutoLockingSettingValue);

   virtual tVoid vVisit_e8_DorLckSetAutoUnlockingSettingValue(most_fi_tcl_e8_DorLckSetAutoUnlockingSettingValue& oe8_DorLckSetAutoUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckSetLastDoorClosedLockingSettingValue(most_fi_tcl_e8_DorLckSetLastDoorClosedLockingSettingValue& oe8_DorLckSetLastDoorClosedLockingSettingValue);

   virtual tVoid vVisit_e8_DorLckSetManualTransUnlockingSettingValue(most_fi_tcl_e8_DorLckSetManualTransUnlockingSettingValue& oe8_DorLckSetManualTransUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckSetPassiveLockingSettingValue(most_fi_tcl_e8_DorLckSetPassiveLockingSettingValue& oe8_DorLckSetPassiveLockingSettingValue);

   virtual tVoid vVisit_e8_DorLckSetPassiveUnlockingSettingValue(most_fi_tcl_e8_DorLckSetPassiveUnlockingSettingValue& oe8_DorLckSetPassiveUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckSetRelockRemoteDoorSettingValue(most_fi_tcl_e8_DorLckSetRelockRemoteDoorSettingValue& oe8_DorLckSetRelockRemoteDoorSettingValue);

   virtual tVoid vVisit_e8_DorLckSetRelockRemoteUnlockedDoorSettingValue(most_fi_tcl_e8_DorLckSetRelockRemoteUnlockedDoorSettingValue& oe8_DorLckSetRelockRemoteUnlockedDoorSettingValue);

   virtual tVoid vVisit_e8_DorLckSetRemoteInVehicleReminderSettingValue(most_fi_tcl_e8_DorLckSetRemoteInVehicleReminderSettingValue& oe8_DorLckSetRemoteInVehicleReminderSettingValue);

   virtual tVoid vVisit_e8_DorLckSetRemoteLockingFeedbackSettingValue(most_fi_tcl_e8_DorLckSetRemoteLockingFeedbackSettingValue& oe8_DorLckSetRemoteLockingFeedbackSettingValue);

   virtual tVoid vVisit_e8_DorLckSetRemoteSlidingDoorSettingValue(most_fi_tcl_e8_DorLckSetRemoteSlidingDoorSettingValue& oe8_DorLckSetRemoteSlidingDoorSettingValue);

   virtual tVoid vVisit_e8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue(most_fi_tcl_e8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue& oe8_DorLckSetRemoteUnlocklLightingFeedbackSettingValue);

   virtual tVoid vVisit_e8_DorLckSetSelectiveUnlockingSettingValue(most_fi_tcl_e8_DorLckSetSelectiveUnlockingSettingValue& oe8_DorLckSetSelectiveUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckSetOpenDoorAntiLockOutSettingValue(most_fi_tcl_e8_DorLckSetOpenDoorAntiLockOutSettingValue& oe8_DorLckSetOpenDoorAntiLockOutSettingValue);

   virtual tVoid vVisit_e8_DorLckAutoLockingSettingValue(most_fi_tcl_e8_DorLckAutoLockingSettingValue& oe8_DorLckAutoLockingSettingValue);

   virtual tVoid vVisit_e8_DorLckAutoUnlockingSettingValue(most_fi_tcl_e8_DorLckAutoUnlockingSettingValue& oe8_DorLckAutoUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckLastDoorClosedLockingSettingValue(most_fi_tcl_e8_DorLckLastDoorClosedLockingSettingValue& oe8_DorLckLastDoorClosedLockingSettingValue);

   virtual tVoid vVisit_e8_DorLckManualTransAutoUnlockingSettingValue(most_fi_tcl_e8_DorLckManualTransAutoUnlockingSettingValue& oe8_DorLckManualTransAutoUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckPassiveLockingSettingValue(most_fi_tcl_e8_DorLckPassiveLockingSettingValue& oe8_DorLckPassiveLockingSettingValue);

   virtual tVoid vVisit_e8_DorLckPassiveUnlockingSettingValue(most_fi_tcl_e8_DorLckPassiveUnlockingSettingValue& oe8_DorLckPassiveUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckRelockRemoteDoorSettingValue(most_fi_tcl_e8_DorLckRelockRemoteDoorSettingValue& oe8_DorLckRelockRemoteDoorSettingValue);

   virtual tVoid vVisit_e8_DorLckRelockRemoteUnlockedDoorSettingValue(most_fi_tcl_e8_DorLckRelockRemoteUnlockedDoorSettingValue& oe8_DorLckRelockRemoteUnlockedDoorSettingValue);

   virtual tVoid vVisit_e8_DorLckRemoteInVehicleReminderSettingValue(most_fi_tcl_e8_DorLckRemoteInVehicleReminderSettingValue& oe8_DorLckRemoteInVehicleReminderSettingValue);

   virtual tVoid vVisit_e8_DorLckRemoteLockingFeedbackSettingValue(most_fi_tcl_e8_DorLckRemoteLockingFeedbackSettingValue& oe8_DorLckRemoteLockingFeedbackSettingValue);

   virtual tVoid vVisit_e8_DorLckRemoteSlidingDoorSettingValue(most_fi_tcl_e8_DorLckRemoteSlidingDoorSettingValue& oe8_DorLckRemoteSlidingDoorSettingValue);

   virtual tVoid vVisit_e8_DorLckRemoteUnlockLightingFeedbackSettingValue(most_fi_tcl_e8_DorLckRemoteUnlockLightingFeedbackSettingValue& oe8_DorLckRemoteUnlockLightingFeedbackSettingValue);

   virtual tVoid vVisit_e8_DorLckSelectiveUnlockingSettingValue(most_fi_tcl_e8_DorLckSelectiveUnlockingSettingValue& oe8_DorLckSelectiveUnlockingSettingValue);

   virtual tVoid vVisit_e8_DorLckOpenDoorAntiLockOutSettingValue(most_fi_tcl_e8_DorLckOpenDoorAntiLockOutSettingValue& oe8_DorLckOpenDoorAntiLockOutSettingValue);

   virtual tVoid vVisit_e8_ECCSetAirQualitySensorSettingValue(most_fi_tcl_e8_ECCSetAirQualitySensorSettingValue& oe8_ECCSetAirQualitySensorSettingValue);

   virtual tVoid vVisit_e8_ECCSetAutoCoolSeatsSettingValue(most_fi_tcl_e8_ECCSetAutoCoolSeatsSettingValue& oe8_ECCSetAutoCoolSeatsSettingValue);

   virtual tVoid vVisit_e8_ECCSetAutoFanSettingValue(most_fi_tcl_e8_ECCSetAutoFanSettingValue& oe8_ECCSetAutoFanSettingValue);

   virtual tVoid vVisit_e8_ECCSetAutoHeatedSeatsSettingValue(most_fi_tcl_e8_ECCSetAutoHeatedSeatsSettingValue& oe8_ECCSetAutoHeatedSeatsSettingValue);

   virtual tVoid vVisit_e8_ECCSetAutoZoneTempSettingValue(most_fi_tcl_e8_ECCSetAutoZoneTempSettingValue& oe8_ECCSetAutoZoneTempSettingValue);

   virtual tVoid vVisit_e8_ECCSetHVACRemoteStartSettingSettingValue(most_fi_tcl_e8_ECCSetHVACRemoteStartSettingSettingValue& oe8_ECCSetHVACRemoteStartSettingSettingValue);

   virtual tVoid vVisit_e8_ECCSetACModeSettingValue(most_fi_tcl_e8_ECCSetACModeSettingValue& oe8_ECCSetACModeSettingValue);

   virtual tVoid vVisit_e8_ECCSetAutoDefogSettingValue(most_fi_tcl_e8_ECCSetAutoDefogSettingValue& oe8_ECCSetAutoDefogSettingValue);

   virtual tVoid vVisit_e8_ECCSetRearZoneStartupSettingsValue(most_fi_tcl_e8_ECCSetRearZoneStartupSettingsValue& oe8_ECCSetRearZoneStartupSettingsValue);

   virtual tVoid vVisit_e8_ECCSetRearDefogStartupSettingsValue(most_fi_tcl_e8_ECCSetRearDefogStartupSettingsValue& oe8_ECCSetRearDefogStartupSettingsValue);

   virtual tVoid vVisit_e8_ECCSetPollutionControlSettingsValue(most_fi_tcl_e8_ECCSetPollutionControlSettingsValue& oe8_ECCSetPollutionControlSettingsValue);

   virtual tVoid vVisit_e8_ECCSetIonizerSettingsValue(most_fi_tcl_e8_ECCSetIonizerSettingsValue& oe8_ECCSetIonizerSettingsValue);

   virtual tVoid vVisit_e8_ECCSetAutoAirDistrSettingsValue(most_fi_tcl_e8_ECCSetAutoAirDistrSettingsValue& oe8_ECCSetAutoAirDistrSettingsValue);

   virtual tVoid vVisit_e8_ECCAirQualitySensorSettingValue(most_fi_tcl_e8_ECCAirQualitySensorSettingValue& oe8_ECCAirQualitySensorSettingValue);

   virtual tVoid vVisit_e8_ECCAutoCoolSeatsSettingValue(most_fi_tcl_e8_ECCAutoCoolSeatsSettingValue& oe8_ECCAutoCoolSeatsSettingValue);

   virtual tVoid vVisit_e8_ECCAutoFanSettingValue(most_fi_tcl_e8_ECCAutoFanSettingValue& oe8_ECCAutoFanSettingValue);

   virtual tVoid vVisit_e8_ECCAutoHeatedSeatsSettingValue(most_fi_tcl_e8_ECCAutoHeatedSeatsSettingValue& oe8_ECCAutoHeatedSeatsSettingValue);

   virtual tVoid vVisit_e8_ECCAutoZoneTempSettingValue(most_fi_tcl_e8_ECCAutoZoneTempSettingValue& oe8_ECCAutoZoneTempSettingValue);

   virtual tVoid vVisit_e8_ECCHVACRemoteStartSettingValue(most_fi_tcl_e8_ECCHVACRemoteStartSettingValue& oe8_ECCHVACRemoteStartSettingValue);

   virtual tVoid vVisit_e8_ECCACModeSettingValue(most_fi_tcl_e8_ECCACModeSettingValue& oe8_ECCACModeSettingValue);

   virtual tVoid vVisit_e8_ECCAutoDefogSettingValue(most_fi_tcl_e8_ECCAutoDefogSettingValue& oe8_ECCAutoDefogSettingValue);

   virtual tVoid vVisit_e8_ECCRearZoneStartupSettingValue(most_fi_tcl_e8_ECCRearZoneStartupSettingValue& oe8_ECCRearZoneStartupSettingValue);

   virtual tVoid vVisit_e8_ECCRearDefogStartupSettingValue(most_fi_tcl_e8_ECCRearDefogStartupSettingValue& oe8_ECCRearDefogStartupSettingValue);

   virtual tVoid vVisit_e8_ECCPollutionControlSettingValue(most_fi_tcl_e8_ECCPollutionControlSettingValue& oe8_ECCPollutionControlSettingValue);

   virtual tVoid vVisit_e8_ECCIonizerSettingValue(most_fi_tcl_e8_ECCIonizerSettingValue& oe8_ECCIonizerSettingValue);

   virtual tVoid vVisit_e8_ECCAutoAirDistrSettingValue(most_fi_tcl_e8_ECCAutoAirDistrSettingValue& oe8_ECCAutoAirDistrSettingValue);

   virtual tVoid vVisit_e8_IPCSetSpeedScaleIlluminationSettingValue(most_fi_tcl_e8_IPCSetSpeedScaleIlluminationSettingValue& oe8_IPCSetSpeedScaleIlluminationSettingValue);

   virtual tVoid vVisit_e8_IPCSetSportModeBackLightingSettingValue(most_fi_tcl_e8_IPCSetSportModeBackLightingSettingValue& oe8_IPCSetSportModeBackLightingSettingValue);

   virtual tVoid vVisit_e8_IPCSetEcoModeTelltaleEnableSettingValue(most_fi_tcl_e8_IPCSetEcoModeTelltaleEnableSettingValue& oe8_IPCSetEcoModeTelltaleEnableSettingValue);

   virtual tVoid vVisit_e8_IPCSpeedScaleIlluminationSettingValue(most_fi_tcl_e8_IPCSpeedScaleIlluminationSettingValue& oe8_IPCSpeedScaleIlluminationSettingValue);

   virtual tVoid vVisit_e8_IPCSportModeBacklightingSettingValue(most_fi_tcl_e8_IPCSportModeBacklightingSettingValue& oe8_IPCSportModeBacklightingSettingValue);

   virtual tVoid vVisit_e8_IPCEcoModeTelltaleEnableSettingValue(most_fi_tcl_e8_IPCEcoModeTelltaleEnableSettingValue& oe8_IPCEcoModeTelltaleEnableSettingValue);

   virtual tVoid vVisit_e8_MemSetSetDriverSeatEasyExitSettingValue(most_fi_tcl_e8_MemSetSetDriverSeatEasyExitSettingValue& oe8_MemSetSetDriverSeatEasyExitSettingValue);

   virtual tVoid vVisit_e8_MemSetSetFoldingMirrorsSettingValue(most_fi_tcl_e8_MemSetSetFoldingMirrorsSettingValue& oe8_MemSetSetFoldingMirrorsSettingValue);

   virtual tVoid vVisit_e8_MemSetSetMemoryColumnSettingValue(most_fi_tcl_e8_MemSetSetMemoryColumnSettingValue& oe8_MemSetSetMemoryColumnSettingValue);

   virtual tVoid vVisit_e8_MemSetSetParkingTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetSetParkingTiltMirrorsSettingValue& oe8_MemSetSetParkingTiltMirrorsSettingValue);

   virtual tVoid vVisit_e8_MemSetSetRemoteMemoryUnlockRecallSettingValue(most_fi_tcl_e8_MemSetSetRemoteMemoryUnlockRecallSettingValue& oe8_MemSetSetRemoteMemoryUnlockRecallSettingValue);

   virtual tVoid vVisit_e8_MemSetSetMemoryTiltColumnSettingValue(most_fi_tcl_e8_MemSetSetMemoryTiltColumnSettingValue& oe8_MemSetSetMemoryTiltColumnSettingValue);

   virtual tVoid vVisit_e8_MemSetSetCrashAvoidanceAlertTypeSettingValue(most_fi_tcl_e8_MemSetSetCrashAvoidanceAlertTypeSettingValue& oe8_MemSetSetCrashAvoidanceAlertTypeSettingValue);

   virtual tVoid vVisit_e8_MemSetSetReverseTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetSetReverseTiltMirrorsSettingValue& oe8_MemSetSetReverseTiltMirrorsSettingValue);

   virtual tVoid vVisit_e8_MemSetSetEasyExitSettingValue(most_fi_tcl_e8_MemSetSetEasyExitSettingValue& oe8_MemSetSetEasyExitSettingValue);

   virtual tVoid vVisit_e8_MemSetSetMemoryRemoteRecallSettingValue(most_fi_tcl_e8_MemSetSetMemoryRemoteRecallSettingValue& oe8_MemSetSetMemoryRemoteRecallSettingValue);

   virtual tVoid vVisit_e8_MemSetDriverSeatEasyExitSettingValue(most_fi_tcl_e8_MemSetDriverSeatEasyExitSettingValue& oe8_MemSetDriverSeatEasyExitSettingValue);

   virtual tVoid vVisit_e8_MemSetFoldingMirrorsSettingValue(most_fi_tcl_e8_MemSetFoldingMirrorsSettingValue& oe8_MemSetFoldingMirrorsSettingValue);

   virtual tVoid vVisit_e8_MemSetMemoryColumnSettingValue(most_fi_tcl_e8_MemSetMemoryColumnSettingValue& oe8_MemSetMemoryColumnSettingValue);

   virtual tVoid vVisit_e8_MemSetParkingTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetParkingTiltMirrorsSettingValue& oe8_MemSetParkingTiltMirrorsSettingValue);

   virtual tVoid vVisit_e8_MemSetRemoteMemoryUnlockRecallSettingValue(most_fi_tcl_e8_MemSetRemoteMemoryUnlockRecallSettingValue& oe8_MemSetRemoteMemoryUnlockRecallSettingValue);

   virtual tVoid vVisit_e8_MemSetMemoryTiltColumnSettingValue(most_fi_tcl_e8_MemSetMemoryTiltColumnSettingValue& oe8_MemSetMemoryTiltColumnSettingValue);

   virtual tVoid vVisit_e8_MemSetCrashAvoidanceAlertTypeSettingValue(most_fi_tcl_e8_MemSetCrashAvoidanceAlertTypeSettingValue& oe8_MemSetCrashAvoidanceAlertTypeSettingValue);

   virtual tVoid vVisit_e8_MemSetReverseTiltMirrorsSettingValue(most_fi_tcl_e8_MemSetReverseTiltMirrorsSettingValue& oe8_MemSetReverseTiltMirrorsSettingValue);

   virtual tVoid vVisit_e8_MemSetEasyExitSettingValue(most_fi_tcl_e8_MemSetEasyExitSettingValue& oe8_MemSetEasyExitSettingValue);

   virtual tVoid vVisit_e8_MemSetMemoryRemoteRecallSettingValue(most_fi_tcl_e8_MemSetMemoryRemoteRecallSettingValue& oe8_MemSetMemoryRemoteRecallSettingValue);

   virtual tVoid vVisit_e8_ObjCmpSet24GHzRadarsSettingValue(most_fi_tcl_e8_ObjCmpSet24GHzRadarsSettingValue& oe8_ObjCmpSet24GHzRadarsSettingValue);

   virtual tVoid vVisit_e8_ObjCmp24GHzRadarsSettingValue(most_fi_tcl_e8_ObjCmp24GHzRadarsSettingValue& oe8_ObjCmp24GHzRadarsSettingValue);

   virtual tVoid vVisit_e8_PASetParkAssistSettingValue(most_fi_tcl_e8_PASetParkAssistSettingValue& oe8_PASetParkAssistSettingValue);

   virtual tVoid vVisit_e8_PASetParkAssistWithTowbarSettingValue(most_fi_tcl_e8_PASetParkAssistWithTowbarSettingValue& oe8_PASetParkAssistWithTowbarSettingValue);

   virtual tVoid vVisit_e8_PAParkAssistSettingValue(most_fi_tcl_e8_PAParkAssistSettingValue& oe8_PAParkAssistSettingValue);

   virtual tVoid vVisit_e8_PAParkAssistWithTowbarSettingValue(most_fi_tcl_e8_PAParkAssistWithTowbarSettingValue& oe8_PAParkAssistWithTowbarSettingValue);

   virtual tVoid vVisit_e8_SBZASetSideBlindZoneAlertSettingValue(most_fi_tcl_e8_SBZASetSideBlindZoneAlertSettingValue& oe8_SBZASetSideBlindZoneAlertSettingValue);

   virtual tVoid vVisit_e8_SBZASetRearCrossTrafficAlertSettingValue(most_fi_tcl_e8_SBZASetRearCrossTrafficAlertSettingValue& oe8_SBZASetRearCrossTrafficAlertSettingValue);

   virtual tVoid vVisit_e8_SBZASetLaneChangeAlertSettingValue(most_fi_tcl_e8_SBZASetLaneChangeAlertSettingValue& oe8_SBZASetLaneChangeAlertSettingValue);

   virtual tVoid vVisit_e8_SBZASideBlindZoneAlertSettingValue(most_fi_tcl_e8_SBZASideBlindZoneAlertSettingValue& oe8_SBZASideBlindZoneAlertSettingValue);

   virtual tVoid vVisit_e8_SBZARearCrossTrafficAlertSettingValue(most_fi_tcl_e8_SBZARearCrossTrafficAlertSettingValue& oe8_SBZARearCrossTrafficAlertSettingValue);

   virtual tVoid vVisit_e8_SBZALaneChangeAlertSettingValue(most_fi_tcl_e8_SBZALaneChangeAlertSettingValue& oe8_SBZALaneChangeAlertSettingValue);

   virtual tVoid vVisit_DABTunDABStationListItem(most_fi_tcl_DABTunDABStationListItem& oDABTunDABStationListItem);

   virtual tVoid vVisit_DABTunDABStationList(most_fi_tcl_DABTunDABStationList& oDABTunDABStationList);

   virtual tVoid vVisit_e8_DABTunServiceTypeFlag(most_fi_tcl_e8_DABTunServiceTypeFlag& oe8_DABTunServiceTypeFlag);

   virtual tVoid vVisit_DABTunDABStationListResultItem(most_fi_tcl_DABTunDABStationListResultItem& oDABTunDABStationListResultItem);

   virtual tVoid vVisit_DABTunDABStationListResult(most_fi_tcl_DABTunDABStationListResult& oDABTunDABStationListResult);

   virtual tVoid vVisit_DABTunDABObjectIDList(most_fi_tcl_DABTunDABObjectIDList& oDABTunDABObjectIDList);

   virtual tVoid vVisit_e8_DABTunBroadcastType(most_fi_tcl_e8_DABTunBroadcastType& oe8_DABTunBroadcastType);

   virtual tVoid vVisit_DABTunDynamicLabelPlusCmd(most_fi_tcl_DABTunDynamicLabelPlusCmd& oDABTunDynamicLabelPlusCmd);

   virtual tVoid vVisit_e8_DABTunDABTuningStatus(most_fi_tcl_e8_DABTunDABTuningStatus& oe8_DABTunDABTuningStatus);

   virtual tVoid vVisit_e8_DABTunDABWaveBandSwitch(most_fi_tcl_e8_DABTunDABWaveBandSwitch& oe8_DABTunDABWaveBandSwitch);

   virtual tVoid vVisit_e8_DABTunStationListUpdateStatus(most_fi_tcl_e8_DABTunStationListUpdateStatus& oe8_DABTunStationListUpdateStatus);

   virtual tVoid vVisit_b16_DABTunMask(most_fi_tcl_b16_DABTunMask& ob16_DABTunMask);

   virtual tVoid vVisit_DABTunFilterDataItem(most_fi_tcl_DABTunFilterDataItem& oDABTunFilterDataItem);

   virtual tVoid vVisit_DABTunFilterData(most_fi_tcl_DABTunFilterData& oDABTunFilterData);

   virtual tVoid vVisit_e8_DABTunGroupID(most_fi_tcl_e8_DABTunGroupID& oe8_DABTunGroupID);

   virtual tVoid vVisit_e8_DABTunTunerSelection(most_fi_tcl_e8_DABTunTunerSelection& oe8_DABTunTunerSelection);

   virtual tVoid vVisit_DABTunTMCMessage_(most_fi_tcl_DABTunTMCMessage_& oDABTunTMCMessage_);

   virtual tVoid vVisit_DABTunTimeData(most_fi_tcl_DABTunTimeData& oDABTunTimeData);

   virtual tVoid vVisit_DABTunDAB_RDSGroupMessage(most_fi_tcl_DABTunDAB_RDSGroupMessage& oDABTunDAB_RDSGroupMessage);

   virtual tVoid vVisit_e8_DABTunBackgroundTMCStatusInfo(most_fi_tcl_e8_DABTunBackgroundTMCStatusInfo& oe8_DABTunBackgroundTMCStatusInfo);

   virtual tVoid vVisit_e8_DABTunDABTMCStatusInfo(most_fi_tcl_e8_DABTunDABTMCStatusInfo& oe8_DABTunDABTMCStatusInfo);

   virtual tVoid vVisit_e8_DABTunForegroundTMCStatusInfo(most_fi_tcl_e8_DABTunForegroundTMCStatusInfo& oe8_DABTunForegroundTMCStatusInfo);

   virtual tVoid vVisit_e8_DABTunTMCSenderNameInfo(most_fi_tcl_e8_DABTunTMCSenderNameInfo& oe8_DABTunTMCSenderNameInfo);

   virtual tVoid vVisit_DABTunTMCStationDataItem(most_fi_tcl_DABTunTMCStationDataItem& oDABTunTMCStationDataItem);

   virtual tVoid vVisit_DABTunTMCStationData(most_fi_tcl_DABTunTMCStationData& oDABTunTMCStationData);

   virtual tVoid vVisit_DevCltInfoListItem(most_fi_tcl_DevCltInfoListItem& oDevCltInfoListItem);

   virtual tVoid vVisit_DevCltInfoList(most_fi_tcl_DevCltInfoList& oDevCltInfoList);

   virtual tVoid vVisit_e8_DevPrjDeviceType(most_fi_tcl_e8_DevPrjDeviceType& oe8_DevPrjDeviceType);

   virtual tVoid vVisit_e8_DevPrjDeviceInterfaceType(most_fi_tcl_e8_DevPrjDeviceInterfaceType& oe8_DevPrjDeviceInterfaceType);

   virtual tVoid vVisit_DevPrjDeviceListItem(most_fi_tcl_DevPrjDeviceListItem& oDevPrjDeviceListItem);

   virtual tVoid vVisit_DevPrjDeviceList(most_fi_tcl_DevPrjDeviceList& oDevPrjDeviceList);

   virtual tVoid vVisit_e8_DevPrjRequestedDisplayContext(most_fi_tcl_e8_DevPrjRequestedDisplayContext& oe8_DevPrjRequestedDisplayContext);

   virtual tVoid vVisit_e8_DevPrjDigitalIPodOutApplication(most_fi_tcl_e8_DevPrjDigitalIPodOutApplication& oe8_DevPrjDigitalIPodOutApplication);

   virtual tVoid vVisit_e8_DevPrjEchoCancellationNoiseReductionSetting(most_fi_tcl_e8_DevPrjEchoCancellationNoiseReductionSetting& oe8_DevPrjEchoCancellationNoiseReductionSetting);

   virtual tVoid vVisit_e8_DevPrjLaunchResult(most_fi_tcl_e8_DevPrjLaunchResult& oe8_DevPrjLaunchResult);

   virtual tVoid vVisit_e8_DevPrjApplicationCertificateType(most_fi_tcl_e8_DevPrjApplicationCertificateType& oe8_DevPrjApplicationCertificateType);

   virtual tVoid vVisit_e8_DevPrjAppActivityState(most_fi_tcl_e8_DevPrjAppActivityState& oe8_DevPrjAppActivityState);

   virtual tVoid vVisit_DevPrjApplicationListItem(most_fi_tcl_DevPrjApplicationListItem& oDevPrjApplicationListItem);

   virtual tVoid vVisit_DevPrjApplicationList(most_fi_tcl_DevPrjApplicationList& oDevPrjApplicationList);

   virtual tVoid vVisit_e8_DevPrjSwitchEnumeration(most_fi_tcl_e8_DevPrjSwitchEnumeration& oe8_DevPrjSwitchEnumeration);

   virtual tVoid vVisit_e8_DevPrjSwitchEventTypeEnumeration(most_fi_tcl_e8_DevPrjSwitchEventTypeEnumeration& oe8_DevPrjSwitchEventTypeEnumeration);

   virtual tVoid vVisit_e8_DevPrjButtonAction(most_fi_tcl_e8_DevPrjButtonAction& oe8_DevPrjButtonAction);

   virtual tVoid vVisit_e8_DevPrjSessionState(most_fi_tcl_e8_DevPrjSessionState& oe8_DevPrjSessionState);

   virtual tVoid vVisit_DevPrjConnectivityMappingItem(most_fi_tcl_DevPrjConnectivityMappingItem& oDevPrjConnectivityMappingItem);

   virtual tVoid vVisit_DevPrjConnectivityMapping(most_fi_tcl_DevPrjConnectivityMapping& oDevPrjConnectivityMapping);

   virtual tVoid vVisit_DevPrjDeviceUserParametersItem(most_fi_tcl_DevPrjDeviceUserParametersItem& oDevPrjDeviceUserParametersItem);

   virtual tVoid vVisit_DevPrjDeviceUserParameters(most_fi_tcl_DevPrjDeviceUserParameters& oDevPrjDeviceUserParameters);

   virtual tVoid vVisit_e8_DevPrjBTChangeInfo(most_fi_tcl_e8_DevPrjBTChangeInfo& oe8_DevPrjBTChangeInfo);

   virtual tVoid vVisit_e8_DevPrjNavigationAppState(most_fi_tcl_e8_DevPrjNavigationAppState& oe8_DevPrjNavigationAppState);

   virtual tVoid vVisit_e8_DevPrjPhoneAppState(most_fi_tcl_e8_DevPrjPhoneAppState& oe8_DevPrjPhoneAppState);

   virtual tVoid vVisit_e8_DevPrjSpeechAppState(most_fi_tcl_e8_DevPrjSpeechAppState& oe8_DevPrjSpeechAppState);

   virtual tVoid vVisit_e8_DiPOSwitchReqResponse(most_fi_tcl_e8_DiPOSwitchReqResponse& oe8_DiPOSwitchReqResponse);

   virtual tVoid vVisit_e8_PlaybackStopReason(most_fi_tcl_e8_PlaybackStopReason& oe8_PlaybackStopReason);

   virtual tVoid vVisit_e8_FavManAudioChannel(most_fi_tcl_e8_FavManAudioChannel& oe8_FavManAudioChannel);

   virtual tVoid vVisit_e8_FavManVideoChannel(most_fi_tcl_e8_FavManVideoChannel& oe8_FavManVideoChannel);

   virtual tVoid vVisit_e8_FavManFavoriteType(most_fi_tcl_e8_FavManFavoriteType& oe8_FavManFavoriteType);

   virtual tVoid vVisit_FavManFavoriteTypesList(most_fi_tcl_FavManFavoriteTypesList& oFavManFavoriteTypesList);

   virtual tVoid vVisit_FavManFavoriteHMIDataItem(most_fi_tcl_FavManFavoriteHMIDataItem& oFavManFavoriteHMIDataItem);

   virtual tVoid vVisit_FavManFavoriteHMIData(most_fi_tcl_FavManFavoriteHMIData& oFavManFavoriteHMIData);

   virtual tVoid vVisit_e8_FavManListChangeType(most_fi_tcl_e8_FavManListChangeType& oe8_FavManListChangeType);

   virtual tVoid vVisit_FavManChangeItems(most_fi_tcl_FavManChangeItems& oFavManChangeItems);

   virtual tVoid vVisit_FMTunImageData(most_fi_tcl_FMTunImageData& oFMTunImageData);

   virtual tVoid vVisit_e8_GMLnGWAPAIconDisplayRequest(most_fi_tcl_e8_GMLnGWAPAIconDisplayRequest& oe8_GMLnGWAPAIconDisplayRequest);

   virtual tVoid vVisit_e8_GMLnGWDrivelineCustomizationSettings(most_fi_tcl_e8_GMLnGWDrivelineCustomizationSettings& oe8_GMLnGWDrivelineCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWSteeringCustomizationSettings(most_fi_tcl_e8_GMLnGWSteeringCustomizationSettings& oe8_GMLnGWSteeringCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWSuspensionCustomizationSettings(most_fi_tcl_e8_GMLnGWSuspensionCustomizationSettings& oe8_GMLnGWSuspensionCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWForwardCollisionAlertCustomizationSettings(most_fi_tcl_e8_GMLnGWForwardCollisionAlertCustomizationSettings& oe8_GMLnGWForwardCollisionAlertCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWGoNotifierCustomizationSettings(most_fi_tcl_e8_GMLnGWGoNotifierCustomizationSettings& oe8_GMLnGWGoNotifierCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWCollisionPreparationSystemCustomizationSettings(most_fi_tcl_e8_GMLnGWCollisionPreparationSystemCustomizationSettings& oe8_GMLnGWCollisionPreparationSystemCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWLeftRightHandTrafficCustomizationSettings(most_fi_tcl_e8_GMLnGWLeftRightHandTrafficCustomizationSettings& oe8_GMLnGWLeftRightHandTrafficCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWSeatBeltTighteningCustomizationSettings(most_fi_tcl_e8_GMLnGWSeatBeltTighteningCustomizationSettings& oe8_GMLnGWSeatBeltTighteningCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting(most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting& oe8_GMLnGWAdaptiveForwardLightingWithGPSCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWAdaptiveForwardLightingCustomizationSetting(most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingCustomizationSetting& oe8_GMLnGWAdaptiveForwardLightingCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings(most_fi_tcl_e8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings& oe8_GMLnGWLeftRightHandTrafficWithGPSCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWAutoHighBeamAssistCustomizationSettings(most_fi_tcl_e8_GMLnGWAutoHighBeamAssistCustomizationSettings& oe8_GMLnGWAutoHighBeamAssistCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings(most_fi_tcl_e8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings& oe8_GMLnGWAutoHighBeamAssistWithSensitivityCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings(most_fi_tcl_e8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings& oe8_GMLnGWAdaptiveHighBeamAssistCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings(most_fi_tcl_e8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings& oe8_GMLnGWAdaptiveHighBeamAssistWithSensitivityCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWChargePowerLossAlertCustomizationSettings(most_fi_tcl_e8_GMLnGWChargePowerLossAlertCustomizationSettings& oe8_GMLnGWChargePowerLossAlertCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWChargeCordTheftAlertCustomizationSettings(most_fi_tcl_e8_GMLnGWChargeCordTheftAlertCustomizationSettings& oe8_GMLnGWChargeCordTheftAlertCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings(most_fi_tcl_e8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings& oe8_GMLnGWChargeSystemAudibleIndicationCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWDriverDrowsinessDetectionCustomizationSetting(most_fi_tcl_e8_GMLnGWDriverDrowsinessDetectionCustomizationSetting& oe8_GMLnGWDriverDrowsinessDetectionCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWPTOSetOneSpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOSetOneSpeedCustomizationSetting& oe8_GMLnGWPTOSetOneSpeedCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWPTOSetTwoSpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOSetTwoSpeedCustomizationSetting& oe8_GMLnGWPTOSetTwoSpeedCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWPTOEngineRunTimerCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOEngineRunTimerCustomizationSetting& oe8_GMLnGWPTOEngineRunTimerCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWPTOTapSetSpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOTapSetSpeedCustomizationSetting& oe8_GMLnGWPTOTapSetSpeedCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWPTOStandbySpeedCustomizationSetting(most_fi_tcl_e8_GMLnGWPTOStandbySpeedCustomizationSetting& oe8_GMLnGWPTOStandbySpeedCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWPerfModeDisplayCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeDisplayCustomizationSettings& oe8_GMLnGWPerfModeDisplayCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWPerfModeSoundCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeSoundCustomizationSettings& oe8_GMLnGWPerfModeSoundCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWPedestrianFriendlyAlertCustomizationSetting(most_fi_tcl_e8_GMLnGWPedestrianFriendlyAlertCustomizationSetting& oe8_GMLnGWPedestrianFriendlyAlertCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWEngineAssistedHeatingCustomizationSetting(most_fi_tcl_e8_GMLnGWEngineAssistedHeatingCustomizationSetting& oe8_GMLnGWEngineAssistedHeatingCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting(most_fi_tcl_e8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting& oe8_GMLnGWEngineAssistedHeatingPluggedInCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWElevatedIdleCustomizationSetting(most_fi_tcl_e8_GMLnGWElevatedIdleCustomizationSetting& oe8_GMLnGWElevatedIdleCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting(most_fi_tcl_e8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting& oe8_GMLnGWAdaptiveForwardLightingWithoutIntelligentLightDistCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWPerfModeMainMenuType(most_fi_tcl_e8_GMLnGWPerfModeMainMenuType& oe8_GMLnGWPerfModeMainMenuType);

   virtual tVoid vVisit_e8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings& oe8_GMLnGWPerfModeAdapCruiseControlCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWPerfModeDriverSeatControlCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeDriverSeatControlCustomizationSettings& oe8_GMLnGWPerfModeDriverSeatControlCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWPerfModePassengerSeatControlCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModePassengerSeatControlCustomizationSettings& oe8_GMLnGWPerfModePassengerSeatControlCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWPerfModeDrivingStyleCustomizationSettings(most_fi_tcl_e8_GMLnGWPerfModeDrivingStyleCustomizationSettings& oe8_GMLnGWPerfModeDrivingStyleCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_AdapCruiseControl(most_fi_tcl_e8_GMLnGWPerfModeVisualization_AdapCruiseControl& oe8_GMLnGWPerfModeVisualization_AdapCruiseControl);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Displays(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Displays& oe8_GMLnGWPerfModeVisualization_Displays);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Driveline(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Driveline& oe8_GMLnGWPerfModeVisualization_Driveline);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_DriverSeat(most_fi_tcl_e8_GMLnGWPerfModeVisualization_DriverSeat& oe8_GMLnGWPerfModeVisualization_DriverSeat);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Engine(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Engine& oe8_GMLnGWPerfModeVisualization_Engine);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Exhaust(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Exhaust& oe8_GMLnGWPerfModeVisualization_Exhaust);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_PassengerSeat(most_fi_tcl_e8_GMLnGWPerfModeVisualization_PassengerSeat& oe8_GMLnGWPerfModeVisualization_PassengerSeat);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Sound(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Sound& oe8_GMLnGWPerfModeVisualization_Sound);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Steering(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Steering& oe8_GMLnGWPerfModeVisualization_Steering);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Suspension(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Suspension& oe8_GMLnGWPerfModeVisualization_Suspension);

   virtual tVoid vVisit_e8_GMLnGWPerfModeVisualization_Trans(most_fi_tcl_e8_GMLnGWPerfModeVisualization_Trans& oe8_GMLnGWPerfModeVisualization_Trans);

   virtual tVoid vVisit_e8_GMLnGWExtendedHillStartAssistCustomizationSetting(most_fi_tcl_e8_GMLnGWExtendedHillStartAssistCustomizationSetting& oe8_GMLnGWExtendedHillStartAssistCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWRearPedestrianDetectionCustomizationSetting(most_fi_tcl_e8_GMLnGWRearPedestrianDetectionCustomizationSetting& oe8_GMLnGWRearPedestrianDetectionCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingCustomizationSetting(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomizationSetting& oe8_GMLnGWLocationBasedChargingCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWFrontPedestrianDetectionCustomizationSetting(most_fi_tcl_e8_GMLnGWFrontPedestrianDetectionCustomizationSetting& oe8_GMLnGWFrontPedestrianDetectionCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings(most_fi_tcl_e8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings& oe8_GMLnGWHandsfreeLiftgateOpenCloseCustomizationSettings);

   virtual tVoid vVisit_e8_GMLnGWRearSeatReminderCustomizationSetting(most_fi_tcl_e8_GMLnGWRearSeatReminderCustomizationSetting& oe8_GMLnGWRearSeatReminderCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWRunningBoardsCustomizationSetting(most_fi_tcl_e8_GMLnGWRunningBoardsCustomizationSetting& oe8_GMLnGWRunningBoardsCustomizationSetting);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode1Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode1Status& oe8_GMLnGWDriverSelectedMode1Status);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode2Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode2Status& oe8_GMLnGWDriverSelectedMode2Status);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode3Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode3Status& oe8_GMLnGWDriverSelectedMode3Status);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode4Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode4Status& oe8_GMLnGWDriverSelectedMode4Status);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode5Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode5Status& oe8_GMLnGWDriverSelectedMode5Status);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode6Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode6Status& oe8_GMLnGWDriverSelectedMode6Status);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode7Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode7Status& oe8_GMLnGWDriverSelectedMode7Status);

   virtual tVoid vVisit_e8_GMLnGWDriverSelectedMode8Status(most_fi_tcl_e8_GMLnGWDriverSelectedMode8Status& oe8_GMLnGWDriverSelectedMode8Status);

   virtual tVoid vVisit_e8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest& oe8_GMLnGWElectricParkBrakeSystemAudibleWarningRequest);

   virtual tVoid vVisit_e8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest& oe8_GMLnGWElectricParkBrakeSystemDisplayMessageRequest);

   virtual tVoid vVisit_e8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest& oe8_GMLnGWElectricParkBrakeSystemStatusIndicationRequest);

   virtual tVoid vVisit_e8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest(most_fi_tcl_e8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest& oe8_GMLnGWElectricParkBrakeSystemWarningIndicationRequest);

   virtual tVoid vVisit_e8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest(most_fi_tcl_e8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest& oe8_GMLnGWForwardObjectAlertVehicleAheadIndicationRequest);

   virtual tVoid vVisit_e8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest(most_fi_tcl_e8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest& oe8_GMLnGWForwardObjectAlertWarningChimeInhibitRequest);

   virtual tVoid vVisit_e8_GMLnGWForwardObjectAlertWarningIndicationRequest(most_fi_tcl_e8_GMLnGWForwardObjectAlertWarningIndicationRequest& oe8_GMLnGWForwardObjectAlertWarningIndicationRequest);

   virtual tVoid vVisit_GMLnGWForwardObjectAlertStream(most_fi_tcl_GMLnGWForwardObjectAlertStream& oGMLnGWForwardObjectAlertStream);

   virtual tVoid vVisit_e8_GMLnGWLaneDepartureWarningAudibleWarningLocation(most_fi_tcl_e8_GMLnGWLaneDepartureWarningAudibleWarningLocation& oe8_GMLnGWLaneDepartureWarningAudibleWarningLocation);

   virtual tVoid vVisit_e8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest(most_fi_tcl_e8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest& oe8_GMLnGWLaneDepartureWarningIndicationControlIndicationRequest);

   virtual tVoid vVisit_e8_GMLnGWLeftLaneDepartureWarningStatus(most_fi_tcl_e8_GMLnGWLeftLaneDepartureWarningStatus& oe8_GMLnGWLeftLaneDepartureWarningStatus);

   virtual tVoid vVisit_e8_GMLnGWRightLaneDepartureWarningStatus(most_fi_tcl_e8_GMLnGWRightLaneDepartureWarningStatus& oe8_GMLnGWRightLaneDepartureWarningStatus);

   virtual tVoid vVisit_e8_GMLnGWLaneKeepingAssistAudibleWarningLocation(most_fi_tcl_e8_GMLnGWLaneKeepingAssistAudibleWarningLocation& oe8_GMLnGWLaneKeepingAssistAudibleWarningLocation);

   virtual tVoid vVisit_e8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest(most_fi_tcl_e8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest& oe8_GMLnGWLaneKeepingAssistIndicationControlIndicationRequest);

   virtual tVoid vVisit_e8_GMLnGWLeftTurnLampActive(most_fi_tcl_e8_GMLnGWLeftTurnLampActive& oe8_GMLnGWLeftTurnLampActive);

   virtual tVoid vVisit_e8_GMLnGWRightTurnLampActive(most_fi_tcl_e8_GMLnGWRightTurnLampActive& oe8_GMLnGWRightTurnLampActive);

   virtual tVoid vVisit_GMLnGWExtendedLightingStatusStream(most_fi_tcl_GMLnGWExtendedLightingStatusStream& oGMLnGWExtendedLightingStatusStream);

   virtual tVoid vVisit_e8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication(most_fi_tcl_e8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication& oe8_GMLnGWHighVoltageBatteryLimitationDueToTemperatureIndication);

   virtual tVoid vVisit_e8_GMLnGWHighVoltageChargerSystemStatus(most_fi_tcl_e8_GMLnGWHighVoltageChargerSystemStatus& oe8_GMLnGWHighVoltageChargerSystemStatus);

   virtual tVoid vVisit_GMLnGWExtendedHMIHybridVehicleStatus(most_fi_tcl_GMLnGWExtendedHMIHybridVehicleStatus& oGMLnGWExtendedHMIHybridVehicleStatus);

   virtual tVoid vVisit_e8_GMLnGWHighVoltageChargerPowerLevel(most_fi_tcl_e8_GMLnGWHighVoltageChargerPowerLevel& oe8_GMLnGWHighVoltageChargerPowerLevel);

   virtual tVoid vVisit_GMLnGWPropulsionDisplayInfoStream(most_fi_tcl_GMLnGWPropulsionDisplayInfoStream& oGMLnGWPropulsionDisplayInfoStream);

   virtual tVoid vVisit_GMLnGWRedundantHighVoltageBatteryPackStream(most_fi_tcl_GMLnGWRedundantHighVoltageBatteryPackStream& oGMLnGWRedundantHighVoltageBatteryPackStream);

   virtual tVoid vVisit_GMLnGWAirbagImpactDataStream(most_fi_tcl_GMLnGWAirbagImpactDataStream& oGMLnGWAirbagImpactDataStream);

   virtual tVoid vVisit_e8_GMLnGWHillDescentControlSystemStatus(most_fi_tcl_e8_GMLnGWHillDescentControlSystemStatus& oe8_GMLnGWHillDescentControlSystemStatus);

   virtual tVoid vVisit_e8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel(most_fi_tcl_e8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel& oe8_GMLnGWVehicleAheadDistanceIndicationRequestIndicationLevel);

   virtual tVoid vVisit_e8_GMLnGWPedestrianWarningIndicationRequest(most_fi_tcl_e8_GMLnGWPedestrianWarningIndicationRequest& oe8_GMLnGWPedestrianWarningIndicationRequest);

   virtual tVoid vVisit_e8_GMLnGWSpeedLimiterSettingTypeActive(most_fi_tcl_e8_GMLnGWSpeedLimiterSettingTypeActive& oe8_GMLnGWSpeedLimiterSettingTypeActive);

   virtual tVoid vVisit_e8_GMLnGWSpeedLimitVisionFusedSpeedMask(most_fi_tcl_e8_GMLnGWSpeedLimitVisionFusedSpeedMask& oe8_GMLnGWSpeedLimitVisionFusedSpeedMask);

   virtual tVoid vVisit_e8_GMLnGWSpeedLimitVisionFusedSpeedUnit(most_fi_tcl_e8_GMLnGWSpeedLimitVisionFusedSpeedUnit& oe8_GMLnGWSpeedLimitVisionFusedSpeedUnit);

   virtual tVoid vVisit_GMLnGWSpeedLimitVisionFusedSpeedStream(most_fi_tcl_GMLnGWSpeedLimitVisionFusedSpeedStream& oGMLnGWSpeedLimitVisionFusedSpeedStream);

   virtual tVoid vVisit_e8_GMLnGWPhoneSpeedRecAudioPromptStatus(most_fi_tcl_e8_GMLnGWPhoneSpeedRecAudioPromptStatus& oe8_GMLnGWPhoneSpeedRecAudioPromptStatus);

   virtual tVoid vVisit_e8_GMLnGWTransmissionEngagedState(most_fi_tcl_e8_GMLnGWTransmissionEngagedState& oe8_GMLnGWTransmissionEngagedState);

   virtual tVoid vVisit_e8_GMLnGWVehicleStabilityEnhancementMode(most_fi_tcl_e8_GMLnGWVehicleStabilityEnhancementMode& oe8_GMLnGWVehicleStabilityEnhancementMode);

   virtual tVoid vVisit_e8_GMLnGWVehicleStabilityEnhancementStatus(most_fi_tcl_e8_GMLnGWVehicleStabilityEnhancementStatus& oe8_GMLnGWVehicleStabilityEnhancementStatus);

   virtual tVoid vVisit_GMLnGWVehicleStabilityInfoStream(most_fi_tcl_GMLnGWVehicleStabilityInfoStream& oGMLnGWVehicleStabilityInfoStream);

   virtual tVoid vVisit_e8_GMLnGWVehicleDisplayUnits(most_fi_tcl_e8_GMLnGWVehicleDisplayUnits& oe8_GMLnGWVehicleDisplayUnits);

   virtual tVoid vVisit_GMLnGWVINDigitStream(most_fi_tcl_GMLnGWVINDigitStream& oGMLnGWVINDigitStream);

   virtual tVoid vVisit_e8_GMLnGWTransmissionShiftLeverPosition(most_fi_tcl_e8_GMLnGWTransmissionShiftLeverPosition& oe8_GMLnGWTransmissionShiftLeverPosition);

   virtual tVoid vVisit_e8_GMLnGWTransmissionEstimatedGearPosition(most_fi_tcl_e8_GMLnGWTransmissionEstimatedGearPosition& oe8_GMLnGWTransmissionEstimatedGearPosition);

   virtual tVoid vVisit_e8_GMLnGWSWCSwitchState(most_fi_tcl_e8_GMLnGWSWCSwitchState& oe8_GMLnGWSWCSwitchState);

   virtual tVoid vVisit_e8_GMLnGWRearCrossTrafficAlertLeftIndicationControl(most_fi_tcl_e8_GMLnGWRearCrossTrafficAlertLeftIndicationControl& oe8_GMLnGWRearCrossTrafficAlertLeftIndicationControl);

   virtual tVoid vVisit_e8_GMLnGWRearCrossTrafficAlertRightIndicationControl(most_fi_tcl_e8_GMLnGWRearCrossTrafficAlertRightIndicationControl& oe8_GMLnGWRearCrossTrafficAlertRightIndicationControl);

   virtual tVoid vVisit_e8_GMLnGWParkAssistFrontRegion1ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion1ObjectStatus& oe8_GMLnGWParkAssistFrontRegion1ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistFrontRegion2ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion2ObjectStatus& oe8_GMLnGWParkAssistFrontRegion2ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistFrontRegion3ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion3ObjectStatus& oe8_GMLnGWParkAssistFrontRegion3ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistFrontRegion4ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontRegion4ObjectStatus& oe8_GMLnGWParkAssistFrontRegion4ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistFrontSystemStatus(most_fi_tcl_e8_GMLnGWParkAssistFrontSystemStatus& oe8_GMLnGWParkAssistFrontSystemStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistRearRegion1ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion1ObjectStatus& oe8_GMLnGWParkAssistRearRegion1ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistRearRegion2ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion2ObjectStatus& oe8_GMLnGWParkAssistRearRegion2ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistRearRegion3ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion3ObjectStatus& oe8_GMLnGWParkAssistRearRegion3ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistRearRegion4ObjectStatus(most_fi_tcl_e8_GMLnGWParkAssistRearRegion4ObjectStatus& oe8_GMLnGWParkAssistRearRegion4ObjectStatus);

   virtual tVoid vVisit_e8_GMLnGWParkAssistRearSystemStatus(most_fi_tcl_e8_GMLnGWParkAssistRearSystemStatus& oe8_GMLnGWParkAssistRearSystemStatus);

   virtual tVoid vVisit_e8_GMLnGWXMCurrentStationService(most_fi_tcl_e8_GMLnGWXMCurrentStationService& oe8_GMLnGWXMCurrentStationService);

   virtual tVoid vVisit_e8_GMLnGWXMRadioServiceProvider(most_fi_tcl_e8_GMLnGWXMRadioServiceProvider& oe8_GMLnGWXMRadioServiceProvider);

   virtual tVoid vVisit_e8_GMLnGWSpeedLimitUnits(most_fi_tcl_e8_GMLnGWSpeedLimitUnits& oe8_GMLnGWSpeedLimitUnits);

   virtual tVoid vVisit_e8_GMLnGWLanguageSelection(most_fi_tcl_e8_GMLnGWLanguageSelection& oe8_GMLnGWLanguageSelection);

   virtual tVoid vVisit_e8_GMLnGWFuelEconomyMetricDisplayUnits(most_fi_tcl_e8_GMLnGWFuelEconomyMetricDisplayUnits& oe8_GMLnGWFuelEconomyMetricDisplayUnits);

   virtual tVoid vVisit_e8_GMLnGWPowerConvertibleTopStatus(most_fi_tcl_e8_GMLnGWPowerConvertibleTopStatus& oe8_GMLnGWPowerConvertibleTopStatus);

   virtual tVoid vVisit_e8_GMLnGWEngineCylinderDeactivationMode(most_fi_tcl_e8_GMLnGWEngineCylinderDeactivationMode& oe8_GMLnGWEngineCylinderDeactivationMode);

   virtual tVoid vVisit_e8_GMLnGWVehicleMovementState(most_fi_tcl_e8_GMLnGWVehicleMovementState& oe8_GMLnGWVehicleMovementState);

   virtual tVoid vVisit_e8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus(most_fi_tcl_e8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus& oe8_GMLnGWFrontPassengerSeatbeltReminderOccupancyStatus);

   virtual tVoid vVisit_e8_GMLnGWFrontPassengerSeatOccupancyFaultStatus(most_fi_tcl_e8_GMLnGWFrontPassengerSeatOccupancyFaultStatus& oe8_GMLnGWFrontPassengerSeatOccupancyFaultStatus);

   virtual tVoid vVisit_e8_GMLnGWTargaTopState(most_fi_tcl_e8_GMLnGWTargaTopState& oe8_GMLnGWTargaTopState);

   virtual tVoid vVisit_e8_GMLnGWTargaTopStateValidity(most_fi_tcl_e8_GMLnGWTargaTopStateValidity& oe8_GMLnGWTargaTopStateValidity);

   virtual tVoid vVisit_e8_GMLnGWCompassOctantHeading(most_fi_tcl_e8_GMLnGWCompassOctantHeading& oe8_GMLnGWCompassOctantHeading);

   virtual tVoid vVisit_e8_GMLnGWFunctionalRoadClass(most_fi_tcl_e8_GMLnGWFunctionalRoadClass& oe8_GMLnGWFunctionalRoadClass);

   virtual tVoid vVisit_e8_GMLnGWInternationalStdAlphaCountryCodeChar1(most_fi_tcl_e8_GMLnGWInternationalStdAlphaCountryCodeChar1& oe8_GMLnGWInternationalStdAlphaCountryCodeChar1);

   virtual tVoid vVisit_e8_GMLnGWInternationalStdAlphaCountryCodeChar2(most_fi_tcl_e8_GMLnGWInternationalStdAlphaCountryCodeChar2& oe8_GMLnGWInternationalStdAlphaCountryCodeChar2);

   virtual tVoid vVisit_e8_GMLnGWLaneCategory(most_fi_tcl_e8_GMLnGWLaneCategory& oe8_GMLnGWLaneCategory);

   virtual tVoid vVisit_e8_GMLnGWRoadSpeedCategoryType(most_fi_tcl_e8_GMLnGWRoadSpeedCategoryType& oe8_GMLnGWRoadSpeedCategoryType);

   virtual tVoid vVisit_e8_GMLnGWDTCFaultType(most_fi_tcl_e8_GMLnGWDTCFaultType& oe8_GMLnGWDTCFaultType);

   virtual tVoid vVisit_e8_GMLnGWAutomaticBeamSelectStatus(most_fi_tcl_e8_GMLnGWAutomaticBeamSelectStatus& oe8_GMLnGWAutomaticBeamSelectStatus);

   virtual tVoid vVisit_e8_GMLnGWTractionControlSystemActive(most_fi_tcl_e8_GMLnGWTractionControlSystemActive& oe8_GMLnGWTractionControlSystemActive);

   virtual tVoid vVisit_e8_GMLnGWTractionControlSystemOperatingMode(most_fi_tcl_e8_GMLnGWTractionControlSystemOperatingMode& oe8_GMLnGWTractionControlSystemOperatingMode);

   virtual tVoid vVisit_e8_GMLnGWTractionControlSystemOperatingStatus(most_fi_tcl_e8_GMLnGWTractionControlSystemOperatingStatus& oe8_GMLnGWTractionControlSystemOperatingStatus);

   virtual tVoid vVisit_e8_GMLnGWTransmissionShiftModeStatus(most_fi_tcl_e8_GMLnGWTransmissionShiftModeStatus& oe8_GMLnGWTransmissionShiftModeStatus);

   virtual tVoid vVisit_e8_GMLnGWCruiseAndSpeedLimiterSwitchStatus(most_fi_tcl_e8_GMLnGWCruiseAndSpeedLimiterSwitchStatus& oe8_GMLnGWCruiseAndSpeedLimiterSwitchStatus);

   virtual tVoid vVisit_e8_GMLnGWCruiseControlActive(most_fi_tcl_e8_GMLnGWCruiseControlActive& oe8_GMLnGWCruiseControlActive);

   virtual tVoid vVisit_e8_GMLnGWCruiseControlEnabled(most_fi_tcl_e8_GMLnGWCruiseControlEnabled& oe8_GMLnGWCruiseControlEnabled);

   virtual tVoid vVisit_e8_GMLnGWAutomaticTransmissionCommandedGear(most_fi_tcl_e8_GMLnGWAutomaticTransmissionCommandedGear& oe8_GMLnGWAutomaticTransmissionCommandedGear);

   virtual tVoid vVisit_e8_GMLnGWVehicleTopSpeedLimitModeActive(most_fi_tcl_e8_GMLnGWVehicleTopSpeedLimitModeActive& oe8_GMLnGWVehicleTopSpeedLimitModeActive);

   virtual tVoid vVisit_e8_GMLnGWRemoteVehicleStartEngineRunning(most_fi_tcl_e8_GMLnGWRemoteVehicleStartEngineRunning& oe8_GMLnGWRemoteVehicleStartEngineRunning);

   virtual tVoid vVisit_e8_GMLnGWAirConditioningCompressorCommand(most_fi_tcl_e8_GMLnGWAirConditioningCompressorCommand& oe8_GMLnGWAirConditioningCompressorCommand);

   virtual tVoid vVisit_e8_GMLnGWFuelModeStatus(most_fi_tcl_e8_GMLnGWFuelModeStatus& oe8_GMLnGWFuelModeStatus);

   virtual tVoid vVisit_e8_GMLnGWAdaptiveCruiseControlActive(most_fi_tcl_e8_GMLnGWAdaptiveCruiseControlActive& oe8_GMLnGWAdaptiveCruiseControlActive);

   virtual tVoid vVisit_e8_GMLnGWCruiseControlDriverSelectedSpeedActive(most_fi_tcl_e8_GMLnGWCruiseControlDriverSelectedSpeedActive& oe8_GMLnGWCruiseControlDriverSelectedSpeedActive);

   virtual tVoid vVisit_e8_GMLnGWAntilockBrakeSystemActive(most_fi_tcl_e8_GMLnGWAntilockBrakeSystemActive& oe8_GMLnGWAntilockBrakeSystemActive);

   virtual tVoid vVisit_e8_GMLnGWDriverWindowPositionStatus(most_fi_tcl_e8_GMLnGWDriverWindowPositionStatus& oe8_GMLnGWDriverWindowPositionStatus);

   virtual tVoid vVisit_e8_GMLnGWLeftRearWindowPositionStatus(most_fi_tcl_e8_GMLnGWLeftRearWindowPositionStatus& oe8_GMLnGWLeftRearWindowPositionStatus);

   virtual tVoid vVisit_e8_GMLnGWPassengerWindowPositionStatus(most_fi_tcl_e8_GMLnGWPassengerWindowPositionStatus& oe8_GMLnGWPassengerWindowPositionStatus);

   virtual tVoid vVisit_e8_GMLnGWRightRearWindowPositionStatus(most_fi_tcl_e8_GMLnGWRightRearWindowPositionStatus& oe8_GMLnGWRightRearWindowPositionStatus);

   virtual tVoid vVisit_e8_GMLnGWBrakeLightsActive(most_fi_tcl_e8_GMLnGWBrakeLightsActive& oe8_GMLnGWBrakeLightsActive);

   virtual tVoid vVisit_e8_GMLnGWDaytimeRunningLampsActive(most_fi_tcl_e8_GMLnGWDaytimeRunningLampsActive& oe8_GMLnGWDaytimeRunningLampsActive);

   virtual tVoid vVisit_e8_GMLnGWHazardSwitchActive(most_fi_tcl_e8_GMLnGWHazardSwitchActive& oe8_GMLnGWHazardSwitchActive);

   virtual tVoid vVisit_e8_GMLnGWHeadlampBeamSelectStatus(most_fi_tcl_e8_GMLnGWHeadlampBeamSelectStatus& oe8_GMLnGWHeadlampBeamSelectStatus);

   virtual tVoid vVisit_e8_GMLnGWMainLightSwitch(most_fi_tcl_e8_GMLnGWMainLightSwitch& oe8_GMLnGWMainLightSwitch);

   virtual tVoid vVisit_e8_GMLnGWTurnSwitchActivation(most_fi_tcl_e8_GMLnGWTurnSwitchActivation& oe8_GMLnGWTurnSwitchActivation);

   virtual tVoid vVisit_e8_GMLnGWPowerLiftgateMotionStatus(most_fi_tcl_e8_GMLnGWPowerLiftgateMotionStatus& oe8_GMLnGWPowerLiftgateMotionStatus);

   virtual tVoid vVisit_e8_GMLnGWRearClosureObstacleDetected(most_fi_tcl_e8_GMLnGWRearClosureObstacleDetected& oe8_GMLnGWRearClosureObstacleDetected);

   virtual tVoid vVisit_e8_GMLnGWLeftSecondaryTurnIndicatorFailed(most_fi_tcl_e8_GMLnGWLeftSecondaryTurnIndicatorFailed& oe8_GMLnGWLeftSecondaryTurnIndicatorFailed);

   virtual tVoid vVisit_e8_GMLnGWRearLeftParkLampFailed(most_fi_tcl_e8_GMLnGWRearLeftParkLampFailed& oe8_GMLnGWRearLeftParkLampFailed);

   virtual tVoid vVisit_e8_GMLnGWRearRightParkLampFailed(most_fi_tcl_e8_GMLnGWRearRightParkLampFailed& oe8_GMLnGWRearRightParkLampFailed);

   virtual tVoid vVisit_e8_GMLnGWRightSecondaryTurnIndicatorFailed(most_fi_tcl_e8_GMLnGWRightSecondaryTurnIndicatorFailed& oe8_GMLnGWRightSecondaryTurnIndicatorFailed);

   virtual tVoid vVisit_e8_GMLnGWTrailerBrakeLightFailed(most_fi_tcl_e8_GMLnGWTrailerBrakeLightFailed& oe8_GMLnGWTrailerBrakeLightFailed);

   virtual tVoid vVisit_e8_GMLnGWTrailerFogLightFailed(most_fi_tcl_e8_GMLnGWTrailerFogLightFailed& oe8_GMLnGWTrailerFogLightFailed);

   virtual tVoid vVisit_e8_GMLnGWTrailerFogLightPresent(most_fi_tcl_e8_GMLnGWTrailerFogLightPresent& oe8_GMLnGWTrailerFogLightPresent);

   virtual tVoid vVisit_e8_GMLnGWTrailerHitchSwitchActive(most_fi_tcl_e8_GMLnGWTrailerHitchSwitchActive& oe8_GMLnGWTrailerHitchSwitchActive);

   virtual tVoid vVisit_e8_GMLnGWTrailerTailLightFailed(most_fi_tcl_e8_GMLnGWTrailerTailLightFailed& oe8_GMLnGWTrailerTailLightFailed);

   virtual tVoid vVisit_e8_GMLnGWSpareTireStatus(most_fi_tcl_e8_GMLnGWSpareTireStatus& oe8_GMLnGWSpareTireStatus);

   virtual tVoid vVisit_e8_GMLnGWTireInflationMonitoringSystemResetPerformed(most_fi_tcl_e8_GMLnGWTireInflationMonitoringSystemResetPerformed& oe8_GMLnGWTireInflationMonitoringSystemResetPerformed);

   virtual tVoid vVisit_e8_GMLnGWTirePressureMonitoringSystemFailed(most_fi_tcl_e8_GMLnGWTirePressureMonitoringSystemFailed& oe8_GMLnGWTirePressureMonitoringSystemFailed);

   virtual tVoid vVisit_e8_GMLnGWParkingAssistanceFunctionFailed(most_fi_tcl_e8_GMLnGWParkingAssistanceFunctionFailed& oe8_GMLnGWParkingAssistanceFunctionFailed);

   virtual tVoid vVisit_e8_GMLnGWWasherFluidLow(most_fi_tcl_e8_GMLnGWWasherFluidLow& oe8_GMLnGWWasherFluidLow);

   virtual tVoid vVisit_e8_GMLnGWWindshieldWiperActive(most_fi_tcl_e8_GMLnGWWindshieldWiperActive& oe8_GMLnGWWindshieldWiperActive);

   virtual tVoid vVisit_e8_GMLnGWHoodStatus(most_fi_tcl_e8_GMLnGWHoodStatus& oe8_GMLnGWHoodStatus);

   virtual tVoid vVisit_e8_GMLnGWWirelessChargingSystemChargingStatus(most_fi_tcl_e8_GMLnGWWirelessChargingSystemChargingStatus& oe8_GMLnGWWirelessChargingSystemChargingStatus);

   virtual tVoid vVisit_e8_GMLnGWDigitalMapConditionalSpeedLimit(most_fi_tcl_e8_GMLnGWDigitalMapConditionalSpeedLimit& oe8_GMLnGWDigitalMapConditionalSpeedLimit);

   virtual tVoid vVisit_e8_GMLnGWDigitalMapConditionalSpeedLimitType(most_fi_tcl_e8_GMLnGWDigitalMapConditionalSpeedLimitType& oe8_GMLnGWDigitalMapConditionalSpeedLimitType);

   virtual tVoid vVisit_e8_GMLnGWDigitalMapSpeedCategory(most_fi_tcl_e8_GMLnGWDigitalMapSpeedCategory& oe8_GMLnGWDigitalMapSpeedCategory);

   virtual tVoid vVisit_e8_GMLnGWDigitalMapVersionQuarter(most_fi_tcl_e8_GMLnGWDigitalMapVersionQuarter& oe8_GMLnGWDigitalMapVersionQuarter);

   virtual tVoid vVisit_e8_GMLnGWDigitalMapDrivingSide(most_fi_tcl_e8_GMLnGWDigitalMapDrivingSide& oe8_GMLnGWDigitalMapDrivingSide);

   virtual tVoid vVisit_e8_GMLnGWDigitalMapPassingRestriction(most_fi_tcl_e8_GMLnGWDigitalMapPassingRestriction& oe8_GMLnGWDigitalMapPassingRestriction);

   virtual tVoid vVisit_GMLnGWADASISLiteExtendedInfoStream(most_fi_tcl_GMLnGWADASISLiteExtendedInfoStream& oGMLnGWADASISLiteExtendedInfoStream);

   virtual tVoid vVisit_e8_GMLnGWElectricParkBrakeStatus(most_fi_tcl_e8_GMLnGWElectricParkBrakeStatus& oe8_GMLnGWElectricParkBrakeStatus);

   virtual tVoid vVisit_e8_GMLnGWGMLANGPSConfiguration(most_fi_tcl_e8_GMLnGWGMLANGPSConfiguration& oe8_GMLnGWGMLANGPSConfiguration);

   virtual tVoid vVisit_e8_GMLnGWCalendarMonth(most_fi_tcl_e8_GMLnGWCalendarMonth& oe8_GMLnGWCalendarMonth);

   virtual tVoid vVisit_e8_GMLnGWInteriorDimmingAnimationType(most_fi_tcl_e8_GMLnGWInteriorDimmingAnimationType& oe8_GMLnGWInteriorDimmingAnimationType);

   virtual tVoid vVisit_e8_GMLnGWInteriorDimmingColorType(most_fi_tcl_e8_GMLnGWInteriorDimmingColorType& oe8_GMLnGWInteriorDimmingColorType);

   virtual tVoid vVisit_e8_GMLnGWBatteryChargeCordAlert(most_fi_tcl_e8_GMLnGWBatteryChargeCordAlert& oe8_GMLnGWBatteryChargeCordAlert);

   virtual tVoid vVisit_e8_GMLnGWChargeDisplayStatus(most_fi_tcl_e8_GMLnGWChargeDisplayStatus& oe8_GMLnGWChargeDisplayStatus);

   virtual tVoid vVisit_e8_GMLnGWChargingPortDoorState(most_fi_tcl_e8_GMLnGWChargingPortDoorState& oe8_GMLnGWChargingPortDoorState);

   virtual tVoid vVisit_e8_GMLnGWLowPowerDayOfWeek(most_fi_tcl_e8_GMLnGWLowPowerDayOfWeek& oe8_GMLnGWLowPowerDayOfWeek);

   virtual tVoid vVisit_e8_GMLnGWHighPowerDayOfWeek(most_fi_tcl_e8_GMLnGWHighPowerDayOfWeek& oe8_GMLnGWHighPowerDayOfWeek);

   virtual tVoid vVisit_e8_GMLnGWStartTimeHighPowerDayOfWeek(most_fi_tcl_e8_GMLnGWStartTimeHighPowerDayOfWeek& oe8_GMLnGWStartTimeHighPowerDayOfWeek);

   virtual tVoid vVisit_e8_GMLnGWStartTimeLowPowerDayOfWeek(most_fi_tcl_e8_GMLnGWStartTimeLowPowerDayOfWeek& oe8_GMLnGWStartTimeLowPowerDayOfWeek);

   virtual tVoid vVisit_e8_GMLnGWMaintenanceModeDisplayRequest(most_fi_tcl_e8_GMLnGWMaintenanceModeDisplayRequest& oe8_GMLnGWMaintenanceModeDisplayRequest);

   virtual tVoid vVisit_e8_GMLnGWNextPlannedDepartureDayOfWeek(most_fi_tcl_e8_GMLnGWNextPlannedDepartureDayOfWeek& oe8_GMLnGWNextPlannedDepartureDayOfWeek);

   virtual tVoid vVisit_e8_GMLnGWHybridModeDisplayRequest(most_fi_tcl_e8_GMLnGWHybridModeDisplayRequest& oe8_GMLnGWHybridModeDisplayRequest);

   virtual tVoid vVisit_e8_GMLnGWTimeBasedChargingModeRequest(most_fi_tcl_e8_GMLnGWTimeBasedChargingModeRequest& oe8_GMLnGWTimeBasedChargingModeRequest);

   virtual tVoid vVisit_e8_GMLnGWTimeBasedChargingModeResponse(most_fi_tcl_e8_GMLnGWTimeBasedChargingModeResponse& oe8_GMLnGWTimeBasedChargingModeResponse);

   virtual tVoid vVisit_e8_GMLnGWChargeRateDaySetRequest(most_fi_tcl_e8_GMLnGWChargeRateDaySetRequest& oe8_GMLnGWChargeRateDaySetRequest);

   virtual tVoid vVisit_e8_GMLnGWChargeRateEnableSetRequest(most_fi_tcl_e8_GMLnGWChargeRateEnableSetRequest& oe8_GMLnGWChargeRateEnableSetRequest);

   virtual tVoid vVisit_e8_GMLnGWChargeRateSelectedSetRequest(most_fi_tcl_e8_GMLnGWChargeRateSelectedSetRequest& oe8_GMLnGWChargeRateSelectedSetRequest);

   virtual tVoid vVisit_e8_GMLnGWChargeRateDayStatus(most_fi_tcl_e8_GMLnGWChargeRateDayStatus& oe8_GMLnGWChargeRateDayStatus);

   virtual tVoid vVisit_e8_GMLnGWChargeRateEnableStatus(most_fi_tcl_e8_GMLnGWChargeRateEnableStatus& oe8_GMLnGWChargeRateEnableStatus);

   virtual tVoid vVisit_e8_GMLnGWChargeRateSelectedStatus(most_fi_tcl_e8_GMLnGWChargeRateSelectedStatus& oe8_GMLnGWChargeRateSelectedStatus);

   virtual tVoid vVisit_e8_GMLnGWDelayedChargingDay(most_fi_tcl_e8_GMLnGWDelayedChargingDay& oe8_GMLnGWDelayedChargingDay);

   virtual tVoid vVisit_e8_GMLnGWDelayedChargingSeason(most_fi_tcl_e8_GMLnGWDelayedChargingSeason& oe8_GMLnGWDelayedChargingSeason);

   virtual tVoid vVisit_e8_GMLnGWDelayedChargingSelected(most_fi_tcl_e8_GMLnGWDelayedChargingSelected& oe8_GMLnGWDelayedChargingSelected);

   virtual tVoid vVisit_e8_GMLnGWDelayedChargingDayStatus(most_fi_tcl_e8_GMLnGWDelayedChargingDayStatus& oe8_GMLnGWDelayedChargingDayStatus);

   virtual tVoid vVisit_e8_GMLnGWDelayedChargingSeasonStatus(most_fi_tcl_e8_GMLnGWDelayedChargingSeasonStatus& oe8_GMLnGWDelayedChargingSeasonStatus);

   virtual tVoid vVisit_e8_GMLnGWDelayedChargingSelectedStatus(most_fi_tcl_e8_GMLnGWDelayedChargingSelectedStatus& oe8_GMLnGWDelayedChargingSelectedStatus);

   virtual tVoid vVisit_e8_GMLnGWRateChargingDay(most_fi_tcl_e8_GMLnGWRateChargingDay& oe8_GMLnGWRateChargingDay);

   virtual tVoid vVisit_e8_GMLnGWRateChargingSeason(most_fi_tcl_e8_GMLnGWRateChargingSeason& oe8_GMLnGWRateChargingSeason);

   virtual tVoid vVisit_e8_GMLnGWRateChargingSelected(most_fi_tcl_e8_GMLnGWRateChargingSelected& oe8_GMLnGWRateChargingSelected);

   virtual tVoid vVisit_e8_GMLnGWRateChargingSelectedRate(most_fi_tcl_e8_GMLnGWRateChargingSelectedRate& oe8_GMLnGWRateChargingSelectedRate);

   virtual tVoid vVisit_e8_GMLnGWRateChargingDayStatus(most_fi_tcl_e8_GMLnGWRateChargingDayStatus& oe8_GMLnGWRateChargingDayStatus);

   virtual tVoid vVisit_e8_GMLnGWRateChargingSeasonStatus(most_fi_tcl_e8_GMLnGWRateChargingSeasonStatus& oe8_GMLnGWRateChargingSeasonStatus);

   virtual tVoid vVisit_e8_GMLnGWRateChargingSelectedRateStatus(most_fi_tcl_e8_GMLnGWRateChargingSelectedRateStatus& oe8_GMLnGWRateChargingSelectedRateStatus);

   virtual tVoid vVisit_e8_GMLnGWRateChargingSelectedStatus(most_fi_tcl_e8_GMLnGWRateChargingSelectedStatus& oe8_GMLnGWRateChargingSelectedStatus);

   virtual tVoid vVisit_e8_GMLnGWSeason(most_fi_tcl_e8_GMLnGWSeason& oe8_GMLnGWSeason);

   virtual tVoid vVisit_e8_GMLnGWSeasonMonth(most_fi_tcl_e8_GMLnGWSeasonMonth& oe8_GMLnGWSeasonMonth);

   virtual tVoid vVisit_e8_GMLnGWSeasonSelected(most_fi_tcl_e8_GMLnGWSeasonSelected& oe8_GMLnGWSeasonSelected);

   virtual tVoid vVisit_e8_GMLnGWSeasonMonthStatus(most_fi_tcl_e8_GMLnGWSeasonMonthStatus& oe8_GMLnGWSeasonMonthStatus);

   virtual tVoid vVisit_e8_GMLnGWSeasonSelectedStatus(most_fi_tcl_e8_GMLnGWSeasonSelectedStatus& oe8_GMLnGWSeasonSelectedStatus);

   virtual tVoid vVisit_e8_GMLnGWSeasonStatus(most_fi_tcl_e8_GMLnGWSeasonStatus& oe8_GMLnGWSeasonStatus);

   virtual tVoid vVisit_e8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive(most_fi_tcl_e8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive& oe8_GMLnGWSetTempOverrideNextPlannedDepartureAdtive);

   virtual tVoid vVisit_e8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek(most_fi_tcl_e8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek& oe8_GMLnGWTempOverrideNextPlannedDepartureDayOfWeek);

   virtual tVoid vVisit_e8_GMLnGWChargeLevelPreferenceStatus(most_fi_tcl_e8_GMLnGWChargeLevelPreferenceStatus& oe8_GMLnGWChargeLevelPreferenceStatus);

   virtual tVoid vVisit_e8_GMLnGWUserInterfaceType(most_fi_tcl_e8_GMLnGWUserInterfaceType& oe8_GMLnGWUserInterfaceType);

   virtual tVoid vVisit_e8_GMLnGWSetChargingSystemChargeLevelPreference(most_fi_tcl_e8_GMLnGWSetChargingSystemChargeLevelPreference& oe8_GMLnGWSetChargingSystemChargeLevelPreference);

   virtual tVoid vVisit_e8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus(most_fi_tcl_e8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus& oe8_GMLnGWTimeOfDayChargingDisplayTemporaryOverrideStatus);

   virtual tVoid vVisit_e8_GMLnGWJumpStartStatus(most_fi_tcl_e8_GMLnGWJumpStartStatus& oe8_GMLnGWJumpStartStatus);

   virtual tVoid vVisit_e8_GMLnGWHybridChargeModeState(most_fi_tcl_e8_GMLnGWHybridChargeModeState& oe8_GMLnGWHybridChargeModeState);

   virtual tVoid vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphMeasurement(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphMeasurement& oe8_GMLnGWEnergyConsumptionHistoryGraphMeasurement);

   virtual tVoid vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval& oe8_GMLnGWEnergyConsumptionHistoryGraphXAxisTickMarkInterval);

   virtual tVoid vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue& oe8_GMLnGWEnergyConsumptionHistoryGraphYAxisMaximumValue);

   virtual tVoid vVisit_GMLnGWEnergyEconomyDataStream(most_fi_tcl_GMLnGWEnergyEconomyDataStream& oGMLnGWEnergyEconomyDataStream);

   virtual tVoid vVisit_e8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest(most_fi_tcl_e8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest& oe8_GMLnGWRateBasedChargeCompletionTimePreferenceRequest);

   virtual tVoid vVisit_e8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse(most_fi_tcl_e8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse& oe8_GMLnGWRateBasedChargeCompletionTimePreferenceResponse);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest& oe8_GMLnGWLocationBasedChargingCustomerClearStoredPositionRequest);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber& oe8_GMLnGWLocationBasedChargingCustomerDataResetRequest_PositionNumber);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse& oe8_GMLnGWLocationBasedChargingCustomerClearStoredPositionResponse);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber(most_fi_tcl_e8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber& oe8_GMLnGWLocationBasedChargingCustomerDataResetResponse_PositionNumber);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingPositionStoreRequest(most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStoreRequest& oe8_GMLnGWLocationBasedChargingPositionStoreRequest);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus(most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus& oe8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdatedStatus);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation(most_fi_tcl_e8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation& oe8_GMLnGWLocationBasedChargingPositionStorage_PositionUpdateLocation);

   virtual tVoid vVisit_e8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation(most_fi_tcl_e8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation& oe8_GMLnGWLocationBasedChargingVehicleLocationStatus_GPSLocation);

   virtual tVoid vVisit_GMLnGWEnergyUsageScoreDataStream(most_fi_tcl_GMLnGWEnergyUsageScoreDataStream& oGMLnGWEnergyUsageScoreDataStream);

   virtual tVoid vVisit_GMLnGWEnergyUsageScoreScalingDataStream(most_fi_tcl_GMLnGWEnergyUsageScoreScalingDataStream& oGMLnGWEnergyUsageScoreScalingDataStream);

   virtual tVoid vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit& oe8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataMeasurementUnit);

   virtual tVoid vVisit_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval(most_fi_tcl_e8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval& oe8_GMLnGWEnergyConsumptionHistoryGraphConfigurationDataXAxisTickMarkInterval);

   virtual tVoid vVisit_e8_GMLnGWEnergyUsageScreenMeasurementUnits(most_fi_tcl_e8_GMLnGWEnergyUsageScreenMeasurementUnits& oe8_GMLnGWEnergyUsageScreenMeasurementUnits);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut& oe8_GMLnGWDriverSeatControlStatus_BackAndCushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_BackBolsterInOut& oe8_GMLnGWDriverSeatControlStatus_BackBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut& oe8_GMLnGWDriverSeatControlStatus_CushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust& oe8_GMLnGWDriverSeatControlStatus_CushionLengthAdjust);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_DisplaySize& oe8_GMLnGWDriverSeatControlStatus_DisplaySize);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd& oe8_GMLnGWDriverSeatControlStatus_HeadrestFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward& oe8_GMLnGWDriverSeatControlStatus_HeadrestTiltForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDown& oe8_GMLnGWDriverSeatControlStatus_HeadrestUpDown);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd& oe8_GMLnGWDriverSeatControlStatus_HeadrestUpDwnFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut& oe8_GMLnGWDriverSeatControlStatus_HeadrestWingsInOut);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward& oe8_GMLnGWDriverSeatControlStatus_LumbarForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarUpDown& oe8_GMLnGWDriverSeatControlStatus_LumbarUpDown);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward& oe8_GMLnGWDriverSeatControlStatus_LumbarUpDownForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_Massage& oe8_GMLnGWDriverSeatControlStatus_Massage);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_MassageIntensity& oe8_GMLnGWDriverSeatControlStatus_MassageIntensity);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_MassageType& oe8_GMLnGWDriverSeatControlStatus_MassageType);

   virtual tVoid vVisit_e8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward& oe8_GMLnGWDriverSeatControlStatus_UpperShoulderForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut& oe8_GMLnGWPassengerSeatControlStatus_BackAndCushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut& oe8_GMLnGWPassengerSeatControlStatus_BackBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut& oe8_GMLnGWPassengerSeatControlStatus_CushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust& oe8_GMLnGWPassengerSeatControlStatus_CushionLengthAdjust);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_DisplaySize& oe8_GMLnGWPassengerSeatControlStatus_DisplaySize);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd& oe8_GMLnGWPassengerSeatControlStatus_HeadrestFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward& oe8_GMLnGWPassengerSeatControlStatus_HeadrestTiltForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown& oe8_GMLnGWPassengerSeatControlStatus_HeadrestUpDown);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd& oe8_GMLnGWPassengerSeatControlStatus_HeadrestUpDwnFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut& oe8_GMLnGWPassengerSeatControlStatus_HeadrestWingsInOut);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward& oe8_GMLnGWPassengerSeatControlStatus_LumbarForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDown& oe8_GMLnGWPassengerSeatControlStatus_LumbarUpDown);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward& oe8_GMLnGWPassengerSeatControlStatus_LumbarUpDownForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_Massage& oe8_GMLnGWPassengerSeatControlStatus_Massage);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_MassageIntensity& oe8_GMLnGWPassengerSeatControlStatus_MassageIntensity);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_MassageType& oe8_GMLnGWPassengerSeatControlStatus_MassageType);

   virtual tVoid vVisit_e8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward& oe8_GMLnGWPassengerSeatControlStatus_UpperShoulderForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut& oe8_GMLnGWLeftRearSeatControlStatus_BackAndCushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut& oe8_GMLnGWLeftRearSeatControlStatus_BackBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut& oe8_GMLnGWLeftRearSeatControlStatus_CushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust& oe8_GMLnGWLeftRearSeatControlStatus_CushionLengthAdjust);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_DisplaySize& oe8_GMLnGWLeftRearSeatControlStatus_DisplaySize);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd& oe8_GMLnGWLeftRearSeatControlStatus_HeadrestFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward& oe8_GMLnGWLeftRearSeatControlStatus_HeadrestTiltForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown& oe8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDown);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd& oe8_GMLnGWLeftRearSeatControlStatus_HeadrestUpDwnFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut& oe8_GMLnGWLeftRearSeatControlStatus_HeadrestWingsInOut);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward& oe8_GMLnGWLeftRearSeatControlStatus_LumbarForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown& oe8_GMLnGWLeftRearSeatControlStatus_LumbarUpDown);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward& oe8_GMLnGWLeftRearSeatControlStatus_LumbarUpDownForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_Massage& oe8_GMLnGWLeftRearSeatControlStatus_Massage);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_MassageIntensity& oe8_GMLnGWLeftRearSeatControlStatus_MassageIntensity);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_MassageType& oe8_GMLnGWLeftRearSeatControlStatus_MassageType);

   virtual tVoid vVisit_e8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward& oe8_GMLnGWLeftRearSeatControlStatus_UpperShoulderForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut& oe8_GMLnGWRightRearSeatControlStatus_BackAndCushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut& oe8_GMLnGWRightRearSeatControlStatus_BackBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut& oe8_GMLnGWRightRearSeatControlStatus_CushionBolsterInOut);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust& oe8_GMLnGWRightRearSeatControlStatus_CushionLengthAdjust);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_DisplaySize(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_DisplaySize& oe8_GMLnGWRightRearSeatControlStatus_DisplaySize);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd& oe8_GMLnGWRightRearSeatControlStatus_HeadrestFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward& oe8_GMLnGWRightRearSeatControlStatus_HeadrestTiltForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown& oe8_GMLnGWRightRearSeatControlStatus_HeadrestUpDown);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd& oe8_GMLnGWRightRearSeatControlStatus_HeadrestUpDwnFwdRwd);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut& oe8_GMLnGWRightRearSeatControlStatus_HeadrestWingsInOut);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward& oe8_GMLnGWRightRearSeatControlStatus_LumbarForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDown(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDown& oe8_GMLnGWRightRearSeatControlStatus_LumbarUpDown);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward& oe8_GMLnGWRightRearSeatControlStatus_LumbarUpDownForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_Massage(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_Massage& oe8_GMLnGWRightRearSeatControlStatus_Massage);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_MassageIntensity(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_MassageIntensity& oe8_GMLnGWRightRearSeatControlStatus_MassageIntensity);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_MassageType(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_MassageType& oe8_GMLnGWRightRearSeatControlStatus_MassageType);

   virtual tVoid vVisit_e8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward(most_fi_tcl_e8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward& oe8_GMLnGWRightRearSeatControlStatus_UpperShoulderForwardRearward);

   virtual tVoid vVisit_e8_GMLnGWRearSeatKey(most_fi_tcl_e8_GMLnGWRearSeatKey& oe8_GMLnGWRearSeatKey);

   virtual tVoid vVisit_e8_GMLnGWTeenDriverRequest(most_fi_tcl_e8_GMLnGWTeenDriverRequest& oe8_GMLnGWTeenDriverRequest);

   virtual tVoid vVisit_e8_GMLnGWTeenDriverResponse(most_fi_tcl_e8_GMLnGWTeenDriverResponse& oe8_GMLnGWTeenDriverResponse);

   virtual tVoid vVisit_e8_GMLnGWSpeedLimitStatus(most_fi_tcl_e8_GMLnGWSpeedLimitStatus& oe8_GMLnGWSpeedLimitStatus);

   virtual tVoid vVisit_e8_GMLnGWOverspeedWarningCurrentStatus(most_fi_tcl_e8_GMLnGWOverspeedWarningCurrentStatus& oe8_GMLnGWOverspeedWarningCurrentStatus);

   virtual tVoid vVisit_GMLnGWVideoProcessingFeatureConfigurationStream(most_fi_tcl_GMLnGWVideoProcessingFeatureConfigurationStream& oGMLnGWVideoProcessingFeatureConfigurationStream);

   virtual tVoid vVisit_e8_GMLnGWTouchProximity(most_fi_tcl_e8_GMLnGWTouchProximity& oe8_GMLnGWTouchProximity);

   virtual tVoid vVisit_GMLnGWWifiSSIDDigits1_8(most_fi_tcl_GMLnGWWifiSSIDDigits1_8& oGMLnGWWifiSSIDDigits1_8);

   virtual tVoid vVisit_GMLnGWWifiSSIDDigits9_16(most_fi_tcl_GMLnGWWifiSSIDDigits9_16& oGMLnGWWifiSSIDDigits9_16);

   virtual tVoid vVisit_GMLnGWWifiSSIDDigits17_24(most_fi_tcl_GMLnGWWifiSSIDDigits17_24& oGMLnGWWifiSSIDDigits17_24);

   virtual tVoid vVisit_GMLnGWWifiPassPhraseDigits1_8(most_fi_tcl_GMLnGWWifiPassPhraseDigits1_8& oGMLnGWWifiPassPhraseDigits1_8);

   virtual tVoid vVisit_GMLnGWWifiPassPhraseDigits9_16(most_fi_tcl_GMLnGWWifiPassPhraseDigits9_16& oGMLnGWWifiPassPhraseDigits9_16);

   virtual tVoid vVisit_GMLnGWWifiPassPhraseDigits17_24(most_fi_tcl_GMLnGWWifiPassPhraseDigits17_24& oGMLnGWWifiPassPhraseDigits17_24);

   virtual tVoid vVisit_e8_GMLnGWInfotainmentWifiEnabled(most_fi_tcl_e8_GMLnGWInfotainmentWifiEnabled& oe8_GMLnGWInfotainmentWifiEnabled);

   virtual tVoid vVisit_e8_GMLnGWWifiEncryptionType(most_fi_tcl_e8_GMLnGWWifiEncryptionType& oe8_GMLnGWWifiEncryptionType);

   virtual tVoid vVisit_e8_GMLnGWWifiSecurityType(most_fi_tcl_e8_GMLnGWWifiSecurityType& oe8_GMLnGWWifiSecurityType);

   virtual tVoid vVisit_e8_GMLnGWWifiAssociationRequest(most_fi_tcl_e8_GMLnGWWifiAssociationRequest& oe8_GMLnGWWifiAssociationRequest);

   virtual tVoid vVisit_GMLnGWWifiStationMediaAccessControlAddress(most_fi_tcl_GMLnGWWifiStationMediaAccessControlAddress& oGMLnGWWifiStationMediaAccessControlAddress);

   virtual tVoid vVisit_e8_HVACHVACSettingsEventEnum(most_fi_tcl_e8_HVACHVACSettingsEventEnum& oe8_HVACHVACSettingsEventEnum);

   virtual tVoid vVisit_e8_HVACFanSpeedReductionValue(most_fi_tcl_e8_HVACFanSpeedReductionValue& oe8_HVACFanSpeedReductionValue);

   virtual tVoid vVisit_e8_HVACFront_BlowerModeValue(most_fi_tcl_e8_HVACFront_BlowerModeValue& oe8_HVACFront_BlowerModeValue);

   virtual tVoid vVisit_e8_HVACFront_FanSpeedValue(most_fi_tcl_e8_HVACFront_FanSpeedValue& oe8_HVACFront_FanSpeedValue);

   virtual tVoid vVisit_e8_HVACFront_LeftSetTempValue(most_fi_tcl_e8_HVACFront_LeftSetTempValue& oe8_HVACFront_LeftSetTempValue);

   virtual tVoid vVisit_e8_HVACFront_RightSetTempValue(most_fi_tcl_e8_HVACFront_RightSetTempValue& oe8_HVACFront_RightSetTempValue);

   virtual tVoid vVisit_e8_HVACRear_BlowerModeValue(most_fi_tcl_e8_HVACRear_BlowerModeValue& oe8_HVACRear_BlowerModeValue);

   virtual tVoid vVisit_e8_HVACRear_FanSpeedValue(most_fi_tcl_e8_HVACRear_FanSpeedValue& oe8_HVACRear_FanSpeedValue);

   virtual tVoid vVisit_e8_HVACRear_SetPointSetTempValue(most_fi_tcl_e8_HVACRear_SetPointSetTempValue& oe8_HVACRear_SetPointSetTempValue);

   virtual tVoid vVisit_e8_HVACZoneValue(most_fi_tcl_e8_HVACZoneValue& oe8_HVACZoneValue);

   virtual tVoid vVisit_e8_HVACAirQualitySensorValue(most_fi_tcl_e8_HVACAirQualitySensorValue& oe8_HVACAirQualitySensorValue);

   virtual tVoid vVisit_e8_HVACAutoDefogValue(most_fi_tcl_e8_HVACAutoDefogValue& oe8_HVACAutoDefogValue);

   virtual tVoid vVisit_e8_HVACAirConditionValue(most_fi_tcl_e8_HVACAirConditionValue& oe8_HVACAirConditionValue);

   virtual tVoid vVisit_e8_HVACAirInletValue(most_fi_tcl_e8_HVACAirInletValue& oe8_HVACAirInletValue);

   virtual tVoid vVisit_e8_HVACMaximum_Front_FanSpeedValue(most_fi_tcl_e8_HVACMaximum_Front_FanSpeedValue& oe8_HVACMaximum_Front_FanSpeedValue);

   virtual tVoid vVisit_e8_HVACFront_LeftThermalSeatValue(most_fi_tcl_e8_HVACFront_LeftThermalSeatValue& oe8_HVACFront_LeftThermalSeatValue);

   virtual tVoid vVisit_e8_HVACFront_RightThermalSeatValue(most_fi_tcl_e8_HVACFront_RightThermalSeatValue& oe8_HVACFront_RightThermalSeatValue);

   virtual tVoid vVisit_e8_HVACRear_DefogValue(most_fi_tcl_e8_HVACRear_DefogValue& oe8_HVACRear_DefogValue);

   virtual tVoid vVisit_e8_HVACHybridEconModeValue(most_fi_tcl_e8_HVACHybridEconModeValue& oe8_HVACHybridEconModeValue);

   virtual tVoid vVisit_e8_HVACHighVoltageHeaterValue(most_fi_tcl_e8_HVACHighVoltageHeaterValue& oe8_HVACHighVoltageHeaterValue);

   virtual tVoid vVisit_e8_HVACRear_PanelLockValue(most_fi_tcl_e8_HVACRear_PanelLockValue& oe8_HVACRear_PanelLockValue);

   virtual tVoid vVisit_e8_HVACRear_PanelSyncValue(most_fi_tcl_e8_HVACRear_PanelSyncValue& oe8_HVACRear_PanelSyncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_HybridFanOnlyValue(most_fi_tcl_e8_HVACFTouchButton_HybridFanOnlyValue& oe8_HVACFTouchButton_HybridFanOnlyValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_HybridEconValue(most_fi_tcl_e8_HVACFTouchButton_HybridEconValue& oe8_HVACFTouchButton_HybridEconValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_HybridComfortValue(most_fi_tcl_e8_HVACFTouchButton_HybridComfortValue& oe8_HVACFTouchButton_HybridComfortValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_LFAutoHeatedSeatValue(most_fi_tcl_e8_HVACFTouchButton_LFAutoHeatedSeatValue& oe8_HVACFTouchButton_LFAutoHeatedSeatValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RFAutoHeatedSeatValue(most_fi_tcl_e8_HVACFTouchButton_RFAutoHeatedSeatValue& oe8_HVACFTouchButton_RFAutoHeatedSeatValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_HybridHVHeaterValue(most_fi_tcl_e8_HVACFTouchButton_HybridHVHeaterValue& oe8_HVACFTouchButton_HybridHVHeaterValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_ACValue(most_fi_tcl_e8_HVACFTouchButton_ACValue& oe8_HVACFTouchButton_ACValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RecircValue(most_fi_tcl_e8_HVACFTouchButton_RecircValue& oe8_HVACFTouchButton_RecircValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_AutoRecircValue(most_fi_tcl_e8_HVACFTouchButton_AutoRecircValue& oe8_HVACFTouchButton_AutoRecircValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Mode_ACValue(most_fi_tcl_e8_HVACFTouchButton_Mode_ACValue& oe8_HVACFTouchButton_Mode_ACValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Mode_BiLevelValue(most_fi_tcl_e8_HVACFTouchButton_Mode_BiLevelValue& oe8_HVACFTouchButton_Mode_BiLevelValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Mode_HeaterDefrostValue(most_fi_tcl_e8_HVACFTouchButton_Mode_HeaterDefrostValue& oe8_HVACFTouchButton_Mode_HeaterDefrostValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Mode_HeaterValue(most_fi_tcl_e8_HVACFTouchButton_Mode_HeaterValue& oe8_HVACFTouchButton_Mode_HeaterValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_FrontFanIncValue(most_fi_tcl_e8_HVACFTouchButton_FrontFanIncValue& oe8_HVACFTouchButton_FrontFanIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_FrontFanDecValue(most_fi_tcl_e8_HVACFTouchButton_FrontFanDecValue& oe8_HVACFTouchButton_FrontFanDecValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_AutoValue(most_fi_tcl_e8_HVACFTouchButton_AutoValue& oe8_HVACFTouchButton_AutoValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_SyncValue(most_fi_tcl_e8_HVACFTouchButton_SyncValue& oe8_HVACFTouchButton_SyncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_ECOACValue(most_fi_tcl_e8_HVACFTouchButton_ECOACValue& oe8_HVACFTouchButton_ECOACValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_FreshAirValue(most_fi_tcl_e8_HVACFTouchButton_FreshAirValue& oe8_HVACFTouchButton_FreshAirValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Mode_WindshieldValue(most_fi_tcl_e8_HVACFTouchButton_Mode_WindshieldValue& oe8_HVACFTouchButton_Mode_WindshieldValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Mode_DefrostValue(most_fi_tcl_e8_HVACFTouchButton_Mode_DefrostValue& oe8_HVACFTouchButton_Mode_DefrostValue);

   virtual tVoid vVisit_e8_HVACACHeaterStateValue(most_fi_tcl_e8_HVACACHeaterStateValue& oe8_HVACACHeaterStateValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_LeftSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_LeftSetTempIncValue& oe8_HVACFTouchButton_LeftSetTempIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_LeftSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_LeftSetTempDecValue& oe8_HVACFTouchButton_LeftSetTempDecValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RightSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_RightSetTempIncValue& oe8_HVACFTouchButton_RightSetTempIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RightSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_RightSetTempDecValue& oe8_HVACFTouchButton_RightSetTempDecValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearDefogValue(most_fi_tcl_e8_HVACFTouchButton_RearDefogValue& oe8_HVACFTouchButton_RearDefogValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearMode_HeaterValue(most_fi_tcl_e8_HVACFTouchButton_RearMode_HeaterValue& oe8_HVACFTouchButton_RearMode_HeaterValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearMode_BiLevelValue(most_fi_tcl_e8_HVACFTouchButton_RearMode_BiLevelValue& oe8_HVACFTouchButton_RearMode_BiLevelValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearMode_ACValue(most_fi_tcl_e8_HVACFTouchButton_RearMode_ACValue& oe8_HVACFTouchButton_RearMode_ACValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearFanIncValue(most_fi_tcl_e8_HVACFTouchButton_RearFanIncValue& oe8_HVACFTouchButton_RearFanIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearFanDecValue(most_fi_tcl_e8_HVACFTouchButton_RearFanDecValue& oe8_HVACFTouchButton_RearFanDecValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_RearSetTempIncValue& oe8_HVACFTouchButton_RearSetTempIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_RearSetTempDecValue& oe8_HVACFTouchButton_RearSetTempDecValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearPanelLockIncValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelLockIncValue& oe8_HVACFTouchButton_RearPanelLockIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearPanelSyncValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelSyncValue& oe8_HVACFTouchButton_RearPanelSyncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearPanelPowerValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelPowerValue& oe8_HVACFTouchButton_RearPanelPowerValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearPanelAutoValue(most_fi_tcl_e8_HVACFTouchButton_RearPanelAutoValue& oe8_HVACFTouchButton_RearPanelAutoValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_ACIncValue(most_fi_tcl_e8_HVACFTouchButton_ACIncValue& oe8_HVACFTouchButton_ACIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RecircIncValue(most_fi_tcl_e8_HVACFTouchButton_RecircIncValue& oe8_HVACFTouchButton_RecircIncValue);

   virtual tVoid vVisit_e8_HVACMaximum_Rear_FanSpeedValue(most_fi_tcl_e8_HVACMaximum_Rear_FanSpeedValue& oe8_HVACMaximum_Rear_FanSpeedValue);

   virtual tVoid vVisit_e8_HVACMaximum_Front_SetTempsValue(most_fi_tcl_e8_HVACMaximum_Front_SetTempsValue& oe8_HVACMaximum_Front_SetTempsValue);

   virtual tVoid vVisit_e8_HVACMaximum_Rear_SetTempsValue(most_fi_tcl_e8_HVACMaximum_Rear_SetTempsValue& oe8_HVACMaximum_Rear_SetTempsValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_ClimateModeIncValue(most_fi_tcl_e8_HVACFTouchButton_ClimateModeIncValue& oe8_HVACFTouchButton_ClimateModeIncValue);

   virtual tVoid vVisit_e8_HVACFront_Right_BlowerModeValue(most_fi_tcl_e8_HVACFront_Right_BlowerModeValue& oe8_HVACFront_Right_BlowerModeValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Right_Mode_ACValue(most_fi_tcl_e8_HVACFTouchButton_Right_Mode_ACValue& oe8_HVACFTouchButton_Right_Mode_ACValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Right_Mode_BiLevelValue(most_fi_tcl_e8_HVACFTouchButton_Right_Mode_BiLevelValue& oe8_HVACFTouchButton_Right_Mode_BiLevelValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Right_Mode_HeaterValue(most_fi_tcl_e8_HVACFTouchButton_Right_Mode_HeaterValue& oe8_HVACFTouchButton_Right_Mode_HeaterValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Right_RearSetTempIncValue(most_fi_tcl_e8_HVACFTouchButton_Right_RearSetTempIncValue& oe8_HVACFTouchButton_Right_RearSetTempIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_Right_RearSetTempDecValue(most_fi_tcl_e8_HVACFTouchButton_Right_RearSetTempDecValue& oe8_HVACFTouchButton_Right_RearSetTempDecValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearModeIncValue(most_fi_tcl_e8_HVACFTouchButton_RearModeIncValue& oe8_HVACFTouchButton_RearModeIncValue);

   virtual tVoid vVisit_e8_HVACFTouchButton_RearModeDecValue(most_fi_tcl_e8_HVACFTouchButton_RearModeDecValue& oe8_HVACFTouchButton_RearModeDecValue);

   virtual tVoid vVisit_e8_HVACRight_Rear_SetPointSetTempValue(most_fi_tcl_e8_HVACRight_Rear_SetPointSetTempValue& oe8_HVACRight_Rear_SetPointSetTempValue);

   virtual tVoid vVisit_e8_HVACIonizerStateValue(most_fi_tcl_e8_HVACIonizerStateValue& oe8_HVACIonizerStateValue);

   virtual tVoid vVisit_e8_HVACHVACSettingsValidEnum(most_fi_tcl_e8_HVACHVACSettingsValidEnum& oe8_HVACHVACSettingsValidEnum);

   virtual tVoid vVisit_e8_ICSCtlSwitchEnumeration(most_fi_tcl_e8_ICSCtlSwitchEnumeration& oe8_ICSCtlSwitchEnumeration);

   virtual tVoid vVisit_e8_ICSCtlSwitchEventTypeEnumeration(most_fi_tcl_e8_ICSCtlSwitchEventTypeEnumeration& oe8_ICSCtlSwitchEventTypeEnumeration);

   virtual tVoid vVisit_e8_ICSCtlSliderProximity(most_fi_tcl_e8_ICSCtlSliderProximity& oe8_ICSCtlSliderProximity);

   virtual tVoid vVisit_e8_iAppsIBErrorCode(most_fi_tcl_e8_iAppsIBErrorCode& oe8_iAppsIBErrorCode);

   virtual tVoid vVisit_e8_iAppsListType(most_fi_tcl_e8_iAppsListType& oe8_iAppsListType);

   virtual tVoid vVisit_e8_iAppsActiveState(most_fi_tcl_e8_iAppsActiveState& oe8_iAppsActiveState);

   virtual tVoid vVisit_e8_iAppsSourceLocation(most_fi_tcl_e8_iAppsSourceLocation& oe8_iAppsSourceLocation);

   virtual tVoid vVisit_e8_iAppsAppConnectionRequired(most_fi_tcl_e8_iAppsAppConnectionRequired& oe8_iAppsAppConnectionRequired);

   virtual tVoid vVisit_e8_iAppsAppVehicleStateRequired(most_fi_tcl_e8_iAppsAppVehicleStateRequired& oe8_iAppsAppVehicleStateRequired);

   virtual tVoid vVisit_iAppsAppObjectsItem(most_fi_tcl_iAppsAppObjectsItem& oiAppsAppObjectsItem);

   virtual tVoid vVisit_iAppsAppObjects(most_fi_tcl_iAppsAppObjects& oiAppsAppObjects);

   virtual tVoid vVisit_e8_iAppsChange(most_fi_tcl_e8_iAppsChange& oe8_iAppsChange);

   virtual tVoid vVisit_iAppsItems(most_fi_tcl_iAppsItems& oiAppsItems);

   virtual tVoid vVisit_iAppsRendererPosition(most_fi_tcl_iAppsRendererPosition& oiAppsRendererPosition);

   virtual tVoid vVisit_iAppsActiveAppsItem(most_fi_tcl_iAppsActiveAppsItem& oiAppsActiveAppsItem);

   virtual tVoid vVisit_iAppsActiveApps(most_fi_tcl_iAppsActiveApps& oiAppsActiveApps);

   virtual tVoid vVisit_iAppsImageData(most_fi_tcl_iAppsImageData& oiAppsImageData);

   virtual tVoid vVisit_e8_iAppsConnectionType(most_fi_tcl_e8_iAppsConnectionType& oe8_iAppsConnectionType);

   virtual tVoid vVisit_e8_iAppsConnectionStatus(most_fi_tcl_e8_iAppsConnectionStatus& oe8_iAppsConnectionStatus);

   virtual tVoid vVisit_e8_iAppsConnectionBandwidth(most_fi_tcl_e8_iAppsConnectionBandwidth& oe8_iAppsConnectionBandwidth);

   virtual tVoid vVisit_iAppsConnectionAvailabilityItem(most_fi_tcl_iAppsConnectionAvailabilityItem& oiAppsConnectionAvailabilityItem);

   virtual tVoid vVisit_iAppsConnectionAvailability(most_fi_tcl_iAppsConnectionAvailability& oiAppsConnectionAvailability);

   virtual tVoid vVisit_iAppsUpdateHTMLItem(most_fi_tcl_iAppsUpdateHTMLItem& oiAppsUpdateHTMLItem);

   virtual tVoid vVisit_iAppsUpdateHTML(most_fi_tcl_iAppsUpdateHTML& oiAppsUpdateHTML);

   virtual tVoid vVisit_e8_iAppsMethod(most_fi_tcl_e8_iAppsMethod& oe8_iAppsMethod);

   virtual tVoid vVisit_e8_iAppsSyncrhonizationState(most_fi_tcl_e8_iAppsSyncrhonizationState& oe8_iAppsSyncrhonizationState);

   virtual tVoid vVisit_iAppsSelectorButtonStreamItem(most_fi_tcl_iAppsSelectorButtonStreamItem& oiAppsSelectorButtonStreamItem);

   virtual tVoid vVisit_iAppsSelectorButtonStream(most_fi_tcl_iAppsSelectorButtonStream& oiAppsSelectorButtonStream);

   virtual tVoid vVisit_e8_iAppsSelectorButtonState(most_fi_tcl_e8_iAppsSelectorButtonState& oe8_iAppsSelectorButtonState);

   virtual tVoid vVisit_e8_iAppsInternetApplicationSystemAction(most_fi_tcl_e8_iAppsInternetApplicationSystemAction& oe8_iAppsInternetApplicationSystemAction);

   virtual tVoid vVisit_iAppsMessageHandle(most_fi_tcl_iAppsMessageHandle& oiAppsMessageHandle);

   virtual tVoid vVisit_e8_iAppsButtonAction(most_fi_tcl_e8_iAppsButtonAction& oe8_iAppsButtonAction);

   virtual tVoid vVisit_e8_iAppsSortOrder(most_fi_tcl_e8_iAppsSortOrder& oe8_iAppsSortOrder);

   virtual tVoid vVisit_iAppsAutocompleteResultList(most_fi_tcl_iAppsAutocompleteResultList& oiAppsAutocompleteResultList);

   virtual tVoid vVisit_e8_iAppsPOIDistanceType(most_fi_tcl_e8_iAppsPOIDistanceType& oe8_iAppsPOIDistanceType);

   virtual tVoid vVisit_e8_iAppsDistanceUnits(most_fi_tcl_e8_iAppsDistanceUnits& oe8_iAppsDistanceUnits);

   virtual tVoid vVisit_iAppsSearchResultListItem(most_fi_tcl_iAppsSearchResultListItem& oiAppsSearchResultListItem);

   virtual tVoid vVisit_iAppsSearchResultList(most_fi_tcl_iAppsSearchResultList& oiAppsSearchResultList);

   virtual tVoid vVisit_e8_iAppsImageFormat(most_fi_tcl_e8_iAppsImageFormat& oe8_iAppsImageFormat);

   virtual tVoid vVisit_e8_iRadioListType(most_fi_tcl_e8_iRadioListType& oe8_iRadioListType);

   virtual tVoid vVisit_e8_iRadioFileFormat(most_fi_tcl_e8_iRadioFileFormat& oe8_iRadioFileFormat);

   virtual tVoid vVisit_iRadioStationsItem(most_fi_tcl_iRadioStationsItem& oiRadioStationsItem);

   virtual tVoid vVisit_iRadioStations(most_fi_tcl_iRadioStations& oiRadioStations);

   virtual tVoid vVisit_e8_iRadioChange(most_fi_tcl_e8_iRadioChange& oe8_iRadioChange);

   virtual tVoid vVisit_iRadioItems(most_fi_tcl_iRadioItems& oiRadioItems);

   virtual tVoid vVisit_e8_iRadioStationType(most_fi_tcl_e8_iRadioStationType& oe8_iRadioStationType);

   virtual tVoid vVisit_iRadioStation(most_fi_tcl_iRadioStation& oiRadioStation);

   virtual tVoid vVisit_e8_iRadioRating(most_fi_tcl_e8_iRadioRating& oe8_iRadioRating);

   virtual tVoid vVisit_iRadioSong(most_fi_tcl_iRadioSong& oiRadioSong);

   virtual tVoid vVisit_e8_iRadioAction(most_fi_tcl_e8_iRadioAction& oe8_iRadioAction);

   virtual tVoid vVisit_iRadioImageData(most_fi_tcl_iRadioImageData& oiRadioImageData);

   virtual tVoid vVisit_e8_iRadioInternetRadioSource(most_fi_tcl_e8_iRadioInternetRadioSource& oe8_iRadioInternetRadioSource);

   virtual tVoid vVisit_e8_iRadioPlaybackState(most_fi_tcl_e8_iRadioPlaybackState& oe8_iRadioPlaybackState);

   virtual tVoid vVisit_e8_iRadioConnectionStatus(most_fi_tcl_e8_iRadioConnectionStatus& oe8_iRadioConnectionStatus);

   virtual tVoid vVisit_e8_iRadioSynchronizationState(most_fi_tcl_e8_iRadioSynchronizationState& oe8_iRadioSynchronizationState);

   virtual tVoid vVisit_e8_iRadioPandoraAccountStatus(most_fi_tcl_e8_iRadioPandoraAccountStatus& oe8_iRadioPandoraAccountStatus);

   virtual tVoid vVisit_iRadioStationListItem(most_fi_tcl_iRadioStationListItem& oiRadioStationListItem);

   virtual tVoid vVisit_iRadioStationList(most_fi_tcl_iRadioStationList& oiRadioStationList);

   virtual tVoid vVisit_e8_LVMRmtEnable(most_fi_tcl_e8_LVMRmtEnable& oe8_LVMRmtEnable);

   virtual tVoid vVisit_e8_MPlayListType(most_fi_tcl_e8_MPlayListType& oe8_MPlayListType);

   virtual tVoid vVisit_e8_MPlayCategoryType(most_fi_tcl_e8_MPlayCategoryType& oe8_MPlayCategoryType);

   virtual tVoid vVisit_e8_MPlayDeviceType(most_fi_tcl_e8_MPlayDeviceType& oe8_MPlayDeviceType);

   virtual tVoid vVisit_e8_MPlayFileFormat(most_fi_tcl_e8_MPlayFileFormat& oe8_MPlayFileFormat);

   virtual tVoid vVisit_e8_MPlayMediaType(most_fi_tcl_e8_MPlayMediaType& oe8_MPlayMediaType);

   virtual tVoid vVisit_MPlayMediaObjectsItem(most_fi_tcl_MPlayMediaObjectsItem& oMPlayMediaObjectsItem);

   virtual tVoid vVisit_MPlayMediaObjects(most_fi_tcl_MPlayMediaObjects& oMPlayMediaObjects);

   virtual tVoid vVisit_e8_MPlayChange(most_fi_tcl_e8_MPlayChange& oe8_MPlayChange);

   virtual tVoid vVisit_MPlayItems(most_fi_tcl_MPlayItems& oMPlayItems);

   virtual tVoid vVisit_e8_MPlayNowPlayingState(most_fi_tcl_e8_MPlayNowPlayingState& oe8_MPlayNowPlayingState);

   virtual tVoid vVisit_MPlayMediaObject(most_fi_tcl_MPlayMediaObject& oMPlayMediaObject);

   virtual tVoid vVisit_e8_MPlayState(most_fi_tcl_e8_MPlayState& oe8_MPlayState);

   virtual tVoid vVisit_e8_MPlayMode(most_fi_tcl_e8_MPlayMode& oe8_MPlayMode);

   virtual tVoid vVisit_e8_MPlayRepeat(most_fi_tcl_e8_MPlayRepeat& oe8_MPlayRepeat);

   virtual tVoid vVisit_e8_MPlayAction(most_fi_tcl_e8_MPlayAction& oe8_MPlayAction);

   virtual tVoid vVisit_e8_MPlayPlaypointFormat(most_fi_tcl_e8_MPlayPlaypointFormat& oe8_MPlayPlaypointFormat);

   virtual tVoid vVisit_e8_MPlayDeviceIndexedState(most_fi_tcl_e8_MPlayDeviceIndexedState& oe8_MPlayDeviceIndexedState);

   virtual tVoid vVisit_MPlayIndexingStateResultItem(most_fi_tcl_MPlayIndexingStateResultItem& oMPlayIndexingStateResultItem);

   virtual tVoid vVisit_MPlayIndexingStateResult(most_fi_tcl_MPlayIndexingStateResult& oMPlayIndexingStateResult);

   virtual tVoid vVisit_MPlayImageData(most_fi_tcl_MPlayImageData& oMPlayImageData);

   virtual tVoid vVisit_MPlaySearchKeyboardListItem(most_fi_tcl_MPlaySearchKeyboardListItem& oMPlaySearchKeyboardListItem);

   virtual tVoid vVisit_MPlaySearchKeyboardList(most_fi_tcl_MPlaySearchKeyboardList& oMPlaySearchKeyboardList);

   virtual tVoid vVisit_MPlayDeviceInfoItem(most_fi_tcl_MPlayDeviceInfoItem& oMPlayDeviceInfoItem);

   virtual tVoid vVisit_MPlayDeviceInfo(most_fi_tcl_MPlayDeviceInfo& oMPlayDeviceInfo);

   virtual tVoid vVisit_e8_MPlayFileType(most_fi_tcl_e8_MPlayFileType& oe8_MPlayFileType);

   virtual tVoid vVisit_MPlayFileListItem(most_fi_tcl_MPlayFileListItem& oMPlayFileListItem);

   virtual tVoid vVisit_MPlayFileList(most_fi_tcl_MPlayFileList& oMPlayFileList);

   virtual tVoid vVisit_e8_MPlayTagTransferStatus(most_fi_tcl_e8_MPlayTagTransferStatus& oe8_MPlayTagTransferStatus);

   virtual tVoid vVisit_MPlayTagTransferItem_1(most_fi_tcl_MPlayTagTransferItem_1& oMPlayTagTransferItem_1);

   virtual tVoid vVisit_MPlayTagTransfer_1(most_fi_tcl_MPlayTagTransfer_1& oMPlayTagTransfer_1);

   virtual tVoid vVisit_MPlayUntransferredTagStreamItem(most_fi_tcl_MPlayUntransferredTagStreamItem& oMPlayUntransferredTagStreamItem);

   virtual tVoid vVisit_MPlayUntransferredTagStream(most_fi_tcl_MPlayUntransferredTagStream& oMPlayUntransferredTagStream);

   virtual tVoid vVisit_MPlayTagTransferItem_2(most_fi_tcl_MPlayTagTransferItem_2& oMPlayTagTransferItem_2);

   virtual tVoid vVisit_MPlayTagTransfer_2(most_fi_tcl_MPlayTagTransfer_2& oMPlayTagTransfer_2);

   virtual tVoid vVisit_e8_NavDistanceUnits(most_fi_tcl_e8_NavDistanceUnits& oe8_NavDistanceUnits);

   virtual tVoid vVisit_e8_NavManeuverEnumeration(most_fi_tcl_e8_NavManeuverEnumeration& oe8_NavManeuverEnumeration);

   virtual tVoid vVisit_e8_NavGuidanceStatus(most_fi_tcl_e8_NavGuidanceStatus& oe8_NavGuidanceStatus);

   virtual tVoid vVisit_NavManeuverListStreamItem(most_fi_tcl_NavManeuverListStreamItem& oNavManeuverListStreamItem);

   virtual tVoid vVisit_NavManeuverListStream(most_fi_tcl_NavManeuverListStream& oNavManeuverListStream);

   virtual tVoid vVisit_e8_NavPOIListTypeEnum(most_fi_tcl_e8_NavPOIListTypeEnum& oe8_NavPOIListTypeEnum);

   virtual tVoid vVisit_NavPOI_ListItem(most_fi_tcl_NavPOI_ListItem& oNavPOI_ListItem);

   virtual tVoid vVisit_NavPOI_List(most_fi_tcl_NavPOI_List& oNavPOI_List);

   virtual tVoid vVisit_e8_NavDestinationListTypeEnum(most_fi_tcl_e8_NavDestinationListTypeEnum& oe8_NavDestinationListTypeEnum);

   virtual tVoid vVisit_NavDestinationInfoItem(most_fi_tcl_NavDestinationInfoItem& oNavDestinationInfoItem);

   virtual tVoid vVisit_NavDestinationInfo(most_fi_tcl_NavDestinationInfo& oNavDestinationInfo);

   virtual tVoid vVisit_e8_NavListChangeType(most_fi_tcl_e8_NavListChangeType& oe8_NavListChangeType);

   virtual tVoid vVisit_NavChangedItemIndexes(most_fi_tcl_NavChangedItemIndexes& oNavChangedItemIndexes);

   virtual tVoid vVisit_NavCurrentVehiclePositionStreamItem(most_fi_tcl_NavCurrentVehiclePositionStreamItem& oNavCurrentVehiclePositionStreamItem);

   virtual tVoid vVisit_NavCurrentVehiclePositionStream(most_fi_tcl_NavCurrentVehiclePositionStream& oNavCurrentVehiclePositionStream);

   virtual tVoid vVisit_NavManeuverExtendedListStreamItem(most_fi_tcl_NavManeuverExtendedListStreamItem& oNavManeuverExtendedListStreamItem);

   virtual tVoid vVisit_NavManeuverExtendedListStream(most_fi_tcl_NavManeuverExtendedListStream& oNavManeuverExtendedListStream);

   virtual tVoid vVisit_e8_NavAddressDisplayFormat(most_fi_tcl_e8_NavAddressDisplayFormat& oe8_NavAddressDisplayFormat);

   virtual tVoid vVisit_e8_OnsAudButtonEnum(most_fi_tcl_e8_OnsAudButtonEnum& oe8_OnsAudButtonEnum);

   virtual tVoid vVisit_e8_OnsAudButtonEvent(most_fi_tcl_e8_OnsAudButtonEvent& oe8_OnsAudButtonEvent);

   virtual tVoid vVisit_e8_OnsDatOnStarDataSettingsValidEnum(most_fi_tcl_e8_OnsDatOnStarDataSettingsValidEnum& oe8_OnsDatOnStarDataSettingsValidEnum);

   virtual tVoid vVisit_e8_OnsDatOnStarDataSettingsEventEnum(most_fi_tcl_e8_OnsDatOnStarDataSettingsEventEnum& oe8_OnsDatOnStarDataSettingsEventEnum);

   virtual tVoid vVisit_e8_OnsDatPlaceOnStarCallValue(most_fi_tcl_e8_OnsDatPlaceOnStarCallValue& oe8_OnsDatPlaceOnStarCallValue);

   virtual tVoid vVisit_e8_OnsDatButton1SelectedValue(most_fi_tcl_e8_OnsDatButton1SelectedValue& oe8_OnsDatButton1SelectedValue);

   virtual tVoid vVisit_e8_OnsDatButton2SelectedValue(most_fi_tcl_e8_OnsDatButton2SelectedValue& oe8_OnsDatButton2SelectedValue);

   virtual tVoid vVisit_e8_OnsDatBluetooth_InCallStatusValue(most_fi_tcl_e8_OnsDatBluetooth_InCallStatusValue& oe8_OnsDatBluetooth_InCallStatusValue);

   virtual tVoid vVisit_e8_OnsDatVoiceRecognitionStatusValue(most_fi_tcl_e8_OnsDatVoiceRecognitionStatusValue& oe8_OnsDatVoiceRecognitionStatusValue);

   virtual tVoid vVisit_e8_OnsDatOnStarCallTypeValue(most_fi_tcl_e8_OnsDatOnStarCallTypeValue& oe8_OnsDatOnStarCallTypeValue);

   virtual tVoid vVisit_e8_OnsDatPacketConnectionTypeValue(most_fi_tcl_e8_OnsDatPacketConnectionTypeValue& oe8_OnsDatPacketConnectionTypeValue);

   virtual tVoid vVisit_e8_OnsDatInVehicleAlertTypeValue(most_fi_tcl_e8_OnsDatInVehicleAlertTypeValue& oe8_OnsDatInVehicleAlertTypeValue);

   virtual tVoid vVisit_e8_OnsDatOnStarLanguageSettingValue(most_fi_tcl_e8_OnsDatOnStarLanguageSettingValue& oe8_OnsDatOnStarLanguageSettingValue);

   virtual tVoid vVisit_e8_OnsDatSubmenuIndicator(most_fi_tcl_e8_OnsDatSubmenuIndicator& oe8_OnsDatSubmenuIndicator);

   virtual tVoid vVisit_OnsDatMenuListValueItem(most_fi_tcl_OnsDatMenuListValueItem& oOnsDatMenuListValueItem);

   virtual tVoid vVisit_OnsDatMenuListValue(most_fi_tcl_OnsDatMenuListValue& oOnsDatMenuListValue);

   virtual tVoid vVisit_e8_OnsDatTTYFunctionRestrictionTypeValue(most_fi_tcl_e8_OnsDatTTYFunctionRestrictionTypeValue& oe8_OnsDatTTYFunctionRestrictionTypeValue);

   virtual tVoid vVisit_e8_OnsDatEmbeddedCellularRssiTypeValue(most_fi_tcl_e8_OnsDatEmbeddedCellularRssiTypeValue& oe8_OnsDatEmbeddedCellularRssiTypeValue);

   virtual tVoid vVisit_e8_OnsDatEmbeddedCellularTechnologyTypeValue(most_fi_tcl_e8_OnsDatEmbeddedCellularTechnologyTypeValue& oe8_OnsDatEmbeddedCellularTechnologyTypeValue);

   virtual tVoid vVisit_e8_OnsCalHandsFreePhoneEventEnum(most_fi_tcl_e8_OnsCalHandsFreePhoneEventEnum& oe8_OnsCalHandsFreePhoneEventEnum);

   virtual tVoid vVisit_e8_OnsCalRingTone_SelectValue(most_fi_tcl_e8_OnsCalRingTone_SelectValue& oe8_OnsCalRingTone_SelectValue);

   virtual tVoid vVisit_e8_OnsCalC1_CallStateValue(most_fi_tcl_e8_OnsCalC1_CallStateValue& oe8_OnsCalC1_CallStateValue);

   virtual tVoid vVisit_e8_OnsCalC1_NumberTypeValue(most_fi_tcl_e8_OnsCalC1_NumberTypeValue& oe8_OnsCalC1_NumberTypeValue);

   virtual tVoid vVisit_e8_OnsCalC2_CallStateValue(most_fi_tcl_e8_OnsCalC2_CallStateValue& oe8_OnsCalC2_CallStateValue);

   virtual tVoid vVisit_e8_OnsCalC2_NumberTypeValue(most_fi_tcl_e8_OnsCalC2_NumberTypeValue& oe8_OnsCalC2_NumberTypeValue);

   virtual tVoid vVisit_e8_OnsCalnumberType(most_fi_tcl_e8_OnsCalnumberType& oe8_OnsCalnumberType);

   virtual tVoid vVisit_OnsCalCLT_IncomingValueItem(most_fi_tcl_OnsCalCLT_IncomingValueItem& oOnsCalCLT_IncomingValueItem);

   virtual tVoid vVisit_OnsCalCLT_IncomingValue(most_fi_tcl_OnsCalCLT_IncomingValue& oOnsCalCLT_IncomingValue);

   virtual tVoid vVisit_OnsCalCLT_MissedValueItem(most_fi_tcl_OnsCalCLT_MissedValueItem& oOnsCalCLT_MissedValueItem);

   virtual tVoid vVisit_OnsCalCLT_MissedValue(most_fi_tcl_OnsCalCLT_MissedValue& oOnsCalCLT_MissedValue);

   virtual tVoid vVisit_OnsCalCLT_OutgoingValueItem(most_fi_tcl_OnsCalCLT_OutgoingValueItem& oOnsCalCLT_OutgoingValueItem);

   virtual tVoid vVisit_OnsCalCLT_OutgoingValue(most_fi_tcl_OnsCalCLT_OutgoingValue& oOnsCalCLT_OutgoingValue);

   virtual tVoid vVisit_OnsCalConf_MembersValueItem(most_fi_tcl_OnsCalConf_MembersValueItem& oOnsCalConf_MembersValueItem);

   virtual tVoid vVisit_OnsCalConf_MembersValue(most_fi_tcl_OnsCalConf_MembersValue& oOnsCalConf_MembersValue);

   virtual tVoid vVisit_e8_OnsCalEmergencyCall_CallStateValue(most_fi_tcl_e8_OnsCalEmergencyCall_CallStateValue& oe8_OnsCalEmergencyCall_CallStateValue);

   virtual tVoid vVisit_e8_OnsCalIn_NumberTypeValue(most_fi_tcl_e8_OnsCalIn_NumberTypeValue& oe8_OnsCalIn_NumberTypeValue);

   virtual tVoid vVisit_e8_OnsCalNetwork_SignalStrengthValue(most_fi_tcl_e8_OnsCalNetwork_SignalStrengthValue& oe8_OnsCalNetwork_SignalStrengthValue);

   virtual tVoid vVisit_e8_OnsCalNetwork_StatusValue(most_fi_tcl_e8_OnsCalNetwork_StatusValue& oe8_OnsCalNetwork_StatusValue);

   virtual tVoid vVisit_e8_OnsCalPhone_FailureCodeValue(most_fi_tcl_e8_OnsCalPhone_FailureCodeValue& oe8_OnsCalPhone_FailureCodeValue);

   virtual tVoid vVisit_e8_OnsCalRingToneValue(most_fi_tcl_e8_OnsCalRingToneValue& oe8_OnsCalRingToneValue);

   virtual tVoid vVisit_e8_OnsCalSecurity_FailureCodeValue(most_fi_tcl_e8_OnsCalSecurity_FailureCodeValue& oe8_OnsCalSecurity_FailureCodeValue);

   virtual tVoid vVisit_e8_OnsCalHandsFreePhoneValidEnum(most_fi_tcl_e8_OnsCalHandsFreePhoneValidEnum& oe8_OnsCalHandsFreePhoneValidEnum);

   virtual tVoid vVisit_e8_OnsNavTBTNavigationDisplayEventEnum(most_fi_tcl_e8_OnsNavTBTNavigationDisplayEventEnum& oe8_OnsNavTBTNavigationDisplayEventEnum);

   virtual tVoid vVisit_e8_OnsNavCurrentManeuverValue(most_fi_tcl_e8_OnsNavCurrentManeuverValue& oe8_OnsNavCurrentManeuverValue);

   virtual tVoid vVisit_e8_OnsNavTBTNavigationDisplayValidEnum(most_fi_tcl_e8_OnsNavTBTNavigationDisplayValidEnum& oe8_OnsNavTBTNavigationDisplayValidEnum);

   virtual tVoid vVisit_e8_PrgMasFileStatus(most_fi_tcl_e8_PrgMasFileStatus& oe8_PrgMasFileStatus);

   virtual tVoid vVisit_PrgMasProgManFile(most_fi_tcl_PrgMasProgManFile& oPrgMasProgManFile);

   virtual tVoid vVisit_e8_PrgMasMode(most_fi_tcl_e8_PrgMasMode& oe8_PrgMasMode);

   virtual tVoid vVisit_PrgMasFile(most_fi_tcl_PrgMasFile& oPrgMasFile);

   virtual tVoid vVisit_e8_PrgMasUpdateType(most_fi_tcl_e8_PrgMasUpdateType& oe8_PrgMasUpdateType);

   virtual tVoid vVisit_PrgMasLicFile(most_fi_tcl_PrgMasLicFile& oPrgMasLicFile);

   virtual tVoid vVisit_PrgMasMDFile(most_fi_tcl_PrgMasMDFile& oPrgMasMDFile);

   virtual tVoid vVisit_e8_PrgMasProgModeStatus(most_fi_tcl_e8_PrgMasProgModeStatus& oe8_PrgMasProgModeStatus);

   virtual tVoid vVisit_PrgMasFileAndDeviceNameStreamItem(most_fi_tcl_PrgMasFileAndDeviceNameStreamItem& oPrgMasFileAndDeviceNameStreamItem);

   virtual tVoid vVisit_PrgMasFileAndDeviceNameStream(most_fi_tcl_PrgMasFileAndDeviceNameStream& oPrgMasFileAndDeviceNameStream);

   virtual tVoid vVisit_e8_PrgMasClientErrorMode(most_fi_tcl_e8_PrgMasClientErrorMode& oe8_PrgMasClientErrorMode);

   virtual tVoid vVisit_PrgMasInvalidFileString(most_fi_tcl_PrgMasInvalidFileString& oPrgMasInvalidFileString);

   virtual tVoid vVisit_e8_PrgMasOTAMsgType(most_fi_tcl_e8_PrgMasOTAMsgType& oe8_PrgMasOTAMsgType);

   virtual tVoid vVisit_PrgMasManFileAndStatusStreamItem(most_fi_tcl_PrgMasManFileAndStatusStreamItem& oPrgMasManFileAndStatusStreamItem);

   virtual tVoid vVisit_PrgMasManFileAndStatusStream(most_fi_tcl_PrgMasManFileAndStatusStream& oPrgMasManFileAndStatusStream);

   virtual tVoid vVisit_e8_PrgMasAsisResultScreenButton(most_fi_tcl_e8_PrgMasAsisResultScreenButton& oe8_PrgMasAsisResultScreenButton);

   virtual tVoid vVisit_e8_PrgMasAsIsSavingStatus(most_fi_tcl_e8_PrgMasAsIsSavingStatus& oe8_PrgMasAsIsSavingStatus);

   virtual tVoid vVisit_e8_PrgMasImmobilizationStatusIcon(most_fi_tcl_e8_PrgMasImmobilizationStatusIcon& oe8_PrgMasImmobilizationStatusIcon);

   virtual tVoid vVisit_e8_PrgMasTermsConditionsResponseStatus(most_fi_tcl_e8_PrgMasTermsConditionsResponseStatus& oe8_PrgMasTermsConditionsResponseStatus);

   virtual tVoid vVisit_e8_PrgMasInstallFailureResponseStatus(most_fi_tcl_e8_PrgMasInstallFailureResponseStatus& oe8_PrgMasInstallFailureResponseStatus);

   virtual tVoid vVisit_e8_PrgMasFinalConfirmationResponseStatus(most_fi_tcl_e8_PrgMasFinalConfirmationResponseStatus& oe8_PrgMasFinalConfirmationResponseStatus);

   virtual tVoid vVisit_e8_RSEFrontVideoState(most_fi_tcl_e8_RSEFrontVideoState& oe8_RSEFrontVideoState);

   virtual tVoid vVisit_e8_RSEFrontRSESources(most_fi_tcl_e8_RSEFrontRSESources& oe8_RSEFrontRSESources);

   virtual tVoid vVisit_e8_RSEDiskPlayState(most_fi_tcl_e8_RSEDiskPlayState& oe8_RSEDiskPlayState);

   virtual tVoid vVisit_e8_RSENextPreviousFlag(most_fi_tcl_e8_RSENextPreviousFlag& oe8_RSENextPreviousFlag);

   virtual tVoid vVisit_e8_RSEPlayPauseAction(most_fi_tcl_e8_RSEPlayPauseAction& oe8_RSEPlayPauseAction);

   virtual tVoid vVisit_e8_RSERSEAccessibilityModeSetting(most_fi_tcl_e8_RSERSEAccessibilityModeSetting& oe8_RSERSEAccessibilityModeSetting);

   virtual tVoid vVisit_SDARSCategoryListStreamItem(most_fi_tcl_SDARSCategoryListStreamItem& oSDARSCategoryListStreamItem);

   virtual tVoid vVisit_SDARSCategoryListStream(most_fi_tcl_SDARSCategoryListStream& oSDARSCategoryListStream);

   virtual tVoid vVisit_e8_SDARSChannelAdvisory(most_fi_tcl_e8_SDARSChannelAdvisory& oe8_SDARSChannelAdvisory);

   virtual tVoid vVisit_e8_SDARSSeekType(most_fi_tcl_e8_SDARSSeekType& oe8_SDARSSeekType);

   virtual tVoid vVisit_e8_SDARSSubscriptionStatus(most_fi_tcl_e8_SDARSSubscriptionStatus& oe8_SDARSSubscriptionStatus);

   virtual tVoid vVisit_e8_SDARSTSListType(most_fi_tcl_e8_SDARSTSListType& oe8_SDARSTSListType);

   virtual tVoid vVisit_SDARSTuneSelectListStreamItem(most_fi_tcl_SDARSTuneSelectListStreamItem& oSDARSTuneSelectListStreamItem);

   virtual tVoid vVisit_SDARSTuneSelectListStream(most_fi_tcl_SDARSTuneSelectListStream& oSDARSTuneSelectListStream);

   virtual tVoid vVisit_SDARSCategoryChannelListStreamItem(most_fi_tcl_SDARSCategoryChannelListStreamItem& oSDARSCategoryChannelListStreamItem);

   virtual tVoid vVisit_SDARSCategoryChannelListStream(most_fi_tcl_SDARSCategoryChannelListStream& oSDARSCategoryChannelListStream);

   virtual tVoid vVisit_e8_SDARSSXMAdvisory(most_fi_tcl_e8_SDARSSXMAdvisory& oe8_SDARSSXMAdvisory);

   virtual tVoid vVisit_SDARSChannelListDetailsItem(most_fi_tcl_SDARSChannelListDetailsItem& oSDARSChannelListDetailsItem);

   virtual tVoid vVisit_SDARSChannelListDetails(most_fi_tcl_SDARSChannelListDetails& oSDARSChannelListDetails);

   virtual tVoid vVisit_SDARSChannelListStreamItem(most_fi_tcl_SDARSChannelListStreamItem& oSDARSChannelListStreamItem);

   virtual tVoid vVisit_SDARSChannelListStream(most_fi_tcl_SDARSChannelListStream& oSDARSChannelListStream);

   virtual tVoid vVisit_e8_SDARSSDARSModuleType(most_fi_tcl_e8_SDARSSDARSModuleType& oe8_SDARSSDARSModuleType);

   virtual tVoid vVisit_SDARSExtendedChannelListStreamItem(most_fi_tcl_SDARSExtendedChannelListStreamItem& oSDARSExtendedChannelListStreamItem);

   virtual tVoid vVisit_SDARSExtendedChannelListStream(most_fi_tcl_SDARSExtendedChannelListStream& oSDARSExtendedChannelListStream);

   virtual tVoid vVisit_e8_SDARSDataAuthorization(most_fi_tcl_e8_SDARSDataAuthorization& oe8_SDARSDataAuthorization);

   virtual tVoid vVisit_SDARSSIDOnOffStreamItem(most_fi_tcl_SDARSSIDOnOffStreamItem& oSDARSSIDOnOffStreamItem);

   virtual tVoid vVisit_SDARSSIDOnOffStream(most_fi_tcl_SDARSSIDOnOffStream& oSDARSSIDOnOffStream);

   virtual tVoid vVisit_e8_TunHDAvailable(most_fi_tcl_e8_TunHDAvailable& oe8_TunHDAvailable);

   virtual tVoid vVisit_e8_TunRDSAvailable(most_fi_tcl_e8_TunRDSAvailable& oe8_TunRDSAvailable);

   virtual tVoid vVisit_e8_TunSeekType(most_fi_tcl_e8_TunSeekType& oe8_TunSeekType);

   virtual tVoid vVisit_e8_TunStationListUpdateStatus(most_fi_tcl_e8_TunStationListUpdateStatus& oe8_TunStationListUpdateStatus);

   virtual tVoid vVisit_TunObjectIDList(most_fi_tcl_TunObjectIDList& oTunObjectIDList);

   virtual tVoid vVisit_TunStationListResultItem(most_fi_tcl_TunStationListResultItem& oTunStationListResultItem);

   virtual tVoid vVisit_TunStationListResult(most_fi_tcl_TunStationListResult& oTunStationListResult);

   virtual tVoid vVisit_TunStationListItem(most_fi_tcl_TunStationListItem& oTunStationListItem);

   virtual tVoid vVisit_TunStationList(most_fi_tcl_TunStationList& oTunStationList);

   virtual tVoid vVisit_e8_AudDskFileType(most_fi_tcl_e8_AudDskFileType& oe8_AudDskFileType);

   virtual tVoid vVisit_e8_AudDskFileFormat(most_fi_tcl_e8_AudDskFileFormat& oe8_AudDskFileFormat);

   virtual tVoid vVisit_AudDskFileListItem(most_fi_tcl_AudDskFileListItem& oAudDskFileListItem);

   virtual tVoid vVisit_AudDskFileList(most_fi_tcl_AudDskFileList& oAudDskFileList);

   virtual tVoid vVisit_e8_AudDskChange(most_fi_tcl_e8_AudDskChange& oe8_AudDskChange);

   virtual tVoid vVisit_AudDskItems(most_fi_tcl_AudDskItems& oAudDskItems);

   virtual tVoid vVisit_e8_AudDskDeckStatus(most_fi_tcl_e8_AudDskDeckStatus& oe8_AudDskDeckStatus);

   virtual tVoid vVisit_e8_AudDskDeckEvent(most_fi_tcl_e8_AudDskDeckEvent& oe8_AudDskDeckEvent);

   virtual tVoid vVisit_e8_AudDskDiskType(most_fi_tcl_e8_AudDskDiskType& oe8_AudDskDiskType);

   virtual tVoid vVisit_e8_AudDskPlaybackState(most_fi_tcl_e8_AudDskPlaybackState& oe8_AudDskPlaybackState);

   virtual tVoid vVisit_AudDskNowPlaying(most_fi_tcl_AudDskNowPlaying& oAudDskNowPlaying);

   virtual tVoid vVisit_e8_AudDskMediaEvent(most_fi_tcl_e8_AudDskMediaEvent& oe8_AudDskMediaEvent);

   virtual tVoid vVisit_e8_AudDskPlaybackAction(most_fi_tcl_e8_AudDskPlaybackAction& oe8_AudDskPlaybackAction);

   virtual tVoid vVisit_e8_AudDskRepeatState(most_fi_tcl_e8_AudDskRepeatState& oe8_AudDskRepeatState);

   virtual tVoid vVisit_e8_AudDskSeek(most_fi_tcl_e8_AudDskSeek& oe8_AudDskSeek);

   virtual tVoid vVisit_e8_FavPrvAudioChannel(most_fi_tcl_e8_FavPrvAudioChannel& oe8_FavPrvAudioChannel);

   virtual tVoid vVisit_e8_FavPrvVideoChannel(most_fi_tcl_e8_FavPrvVideoChannel& oe8_FavPrvVideoChannel);

   virtual tVoid vVisit_e8_FavPrvFavoriteType(most_fi_tcl_e8_FavPrvFavoriteType& oe8_FavPrvFavoriteType);

   virtual tVoid vVisit_FavPrvFavoriteInfoItem(most_fi_tcl_FavPrvFavoriteInfoItem& oFavPrvFavoriteInfoItem);

   virtual tVoid vVisit_FavPrvFavoriteInfo(most_fi_tcl_FavPrvFavoriteInfo& oFavPrvFavoriteInfo);

   virtual tVoid vVisit_e8_FavPrvListChangeType(most_fi_tcl_e8_FavPrvListChangeType& oe8_FavPrvListChangeType);

   virtual tVoid vVisit_FavPrvChangedFavorites(most_fi_tcl_FavPrvChangedFavorites& oFavPrvChangedFavorites);

   virtual tVoid vVisit_e8_HDRadHDTuningStatus(most_fi_tcl_e8_HDRadHDTuningStatus& oe8_HDRadHDTuningStatus);

   virtual tVoid vVisit_HDRadPSD(most_fi_tcl_HDRadPSD& oHDRadPSD);

   virtual tVoid vVisit_e8_HDRadHDBandSelect(most_fi_tcl_e8_HDRadHDBandSelect& oe8_HDRadHDBandSelect);

   virtual tVoid vVisit_e8_HDRadHDRcvrState(most_fi_tcl_e8_HDRadHDRcvrState& oe8_HDRadHDRcvrState);

   virtual tVoid vVisit_e8_TrfARDSTuningState(most_fi_tcl_e8_TrfARDSTuningState& oe8_TrfARDSTuningState);

   virtual tVoid vVisit_b16_RDSMask(most_fi_tcl_b16_RDSMask& ob16_RDSMask);

   virtual tVoid vVisit_RDSFilterDataItem(most_fi_tcl_RDSFilterDataItem& oRDSFilterDataItem);

   virtual tVoid vVisit_RDSFilterData(most_fi_tcl_RDSFilterData& oRDSFilterData);

   virtual tVoid vVisit_e8_RDSGroupID(most_fi_tcl_e8_RDSGroupID& oe8_RDSGroupID);

   virtual tVoid vVisit_e8_RDSTunerSelection(most_fi_tcl_e8_RDSTunerSelection& oe8_RDSTunerSelection);

   virtual tVoid vVisit_RDSTMCMessage_(most_fi_tcl_RDSTMCMessage_& oRDSTMCMessage_);

   virtual tVoid vVisit_RDSTimeData(most_fi_tcl_RDSTimeData& oRDSTimeData);

   virtual tVoid vVisit_RDSRDSGroupMessage(most_fi_tcl_RDSRDSGroupMessage& oRDSRDSGroupMessage);

   virtual tVoid vVisit_e8_RDSBackgroundTMCStatusInfo(most_fi_tcl_e8_RDSBackgroundTMCStatusInfo& oe8_RDSBackgroundTMCStatusInfo);

   virtual tVoid vVisit_e8_RDSForegroundTMCStatusInfo(most_fi_tcl_e8_RDSForegroundTMCStatusInfo& oe8_RDSForegroundTMCStatusInfo);

   virtual tVoid vVisit_e8_RDSTMCSenderNameInfo(most_fi_tcl_e8_RDSTMCSenderNameInfo& oe8_RDSTMCSenderNameInfo);

   virtual tVoid vVisit_RDSTMCStationDataItem(most_fi_tcl_RDSTMCStationDataItem& oRDSTMCStationDataItem);

   virtual tVoid vVisit_RDSTMCStationData(most_fi_tcl_RDSTMCStationData& oRDSTMCStationData);

   virtual tVoid vVisit_e8_SnkAudioChannelName(most_fi_tcl_e8_SnkAudioChannelName& oe8_SnkAudioChannelName);

   virtual tVoid vVisit_e8_SnkContentProtection(most_fi_tcl_e8_SnkContentProtection& oe8_SnkContentProtection);

   virtual tVoid vVisit_e8_SnkContentType(most_fi_tcl_e8_SnkContentType& oe8_SnkContentType);

   virtual tVoid vVisit_e8_SnkTransmissionClass(most_fi_tcl_e8_SnkTransmissionClass& oe8_SnkTransmissionClass);

   virtual tVoid vVisit_SnkAudioChannels_Resolution(most_fi_tcl_SnkAudioChannels_Resolution& oSnkAudioChannels_Resolution);

   virtual tVoid vVisit_SnkAudioChannelListItem(most_fi_tcl_SnkAudioChannelListItem& oSnkAudioChannelListItem);

   virtual tVoid vVisit_SnkAudioChannelList(most_fi_tcl_SnkAudioChannelList& oSnkAudioChannelList);

   virtual tVoid vVisit_SnkAudioChannels_AudioChannelList(most_fi_tcl_SnkAudioChannels_AudioChannelList& oSnkAudioChannels_AudioChannelList);

   virtual tVoid vVisit_SnkContentDescription(most_fi_tcl_SnkContentDescription& oSnkContentDescription);

   virtual tVoid vVisit_VolVolumeListItem(most_fi_tcl_VolVolumeListItem& oVolVolumeListItem);

   virtual tVoid vVisit_VolVolumeList(most_fi_tcl_VolVolumeList& oVolVolumeList);

   virtual tVoid vVisit_e8_SrcAudioChannelName(most_fi_tcl_e8_SrcAudioChannelName& oe8_SrcAudioChannelName);

   virtual tVoid vVisit_e8_SrcContentProtection(most_fi_tcl_e8_SrcContentProtection& oe8_SrcContentProtection);

   virtual tVoid vVisit_e8_SrcContentType(most_fi_tcl_e8_SrcContentType& oe8_SrcContentType);

   virtual tVoid vVisit_e8_SrcTransmissionClass(most_fi_tcl_e8_SrcTransmissionClass& oe8_SrcTransmissionClass);

   virtual tVoid vVisit_SrcAudioChannels_Resolution(most_fi_tcl_SrcAudioChannels_Resolution& oSrcAudioChannels_Resolution);

   virtual tVoid vVisit_SrcAudioChannelListItem(most_fi_tcl_SrcAudioChannelListItem& oSrcAudioChannelListItem);

   virtual tVoid vVisit_SrcAudioChannelList(most_fi_tcl_SrcAudioChannelList& oSrcAudioChannelList);

   virtual tVoid vVisit_SrcAudioChannels_AudioChannelList(most_fi_tcl_SrcAudioChannels_AudioChannelList& oSrcAudioChannels_AudioChannelList);

   virtual tVoid vVisit_SrcContentDescription(most_fi_tcl_SrcContentDescription& oSrcContentDescription);

   virtual tVoid vVisit_e8_SrcActivity(most_fi_tcl_e8_SrcActivity& oe8_SrcActivity);

   virtual tVoid vVisit_e8_TShTimeShiftControlEnum(most_fi_tcl_e8_TShTimeShiftControlEnum& oe8_TShTimeShiftControlEnum);

   virtual tVoid vVisit_e8_TShTimeShiftStateEnum(most_fi_tcl_e8_TShTimeShiftStateEnum& oe8_TShTimeShiftStateEnum);

   virtual tVoid vVisit_TchPadTouchDataListItem(most_fi_tcl_TchPadTouchDataListItem& oTchPadTouchDataListItem);

   virtual tVoid vVisit_TchPadTouchDataList(most_fi_tcl_TchPadTouchDataList& oTchPadTouchDataList);

   virtual tVoid vVisit_e8_TchPadHapticFeedbackProfile(most_fi_tcl_e8_TchPadHapticFeedbackProfile& oe8_TchPadHapticFeedbackProfile);

   virtual tVoid vVisit_e8_TchPadProximityState(most_fi_tcl_e8_TchPadProximityState& oe8_TchPadProximityState);

   virtual tVoid vVisit_e8_TchPadButtonTypeEnum(most_fi_tcl_e8_TchPadButtonTypeEnum& oe8_TchPadButtonTypeEnum);

   virtual tVoid vVisit_TchPadButtonStatesItem(most_fi_tcl_TchPadButtonStatesItem& oTchPadButtonStatesItem);

   virtual tVoid vVisit_TchPadButtonStates(most_fi_tcl_TchPadButtonStates& oTchPadButtonStates);

   virtual tVoid vVisit_e8_SpcHMISRButton(most_fi_tcl_e8_SpcHMISRButton& oe8_SpcHMISRButton);

   virtual tVoid vVisit_e8_SpcHMISpeechWindow(most_fi_tcl_e8_SpcHMISpeechWindow& oe8_SpcHMISpeechWindow);

   virtual tVoid vVisit_e8_SpcHMISRStatus(most_fi_tcl_e8_SpcHMISRStatus& oe8_SpcHMISRStatus);

   virtual tVoid vVisit_e8_SpcHMIAction(most_fi_tcl_e8_SpcHMIAction& oe8_SpcHMIAction);

   virtual tVoid vVisit_SpcHMINBestListStreamItem(most_fi_tcl_SpcHMINBestListStreamItem& oSpcHMINBestListStreamItem);

   virtual tVoid vVisit_SpcHMINBestListStream(most_fi_tcl_SpcHMINBestListStream& oSpcHMINBestListStream);

   virtual tVoid vVisit_SpcHMIExampleListStream(most_fi_tcl_SpcHMIExampleListStream& oSpcHMIExampleListStream);

   virtual tVoid vVisit_e8_SpcHMISRLanguage(most_fi_tcl_e8_SpcHMISRLanguage& oe8_SpcHMISRLanguage);

   virtual tVoid vVisit_SpcHMIDynamicControlTextStreamItem(most_fi_tcl_SpcHMIDynamicControlTextStreamItem& oSpcHMIDynamicControlTextStreamItem);

   virtual tVoid vVisit_SpcHMIDynamicControlTextStream(most_fi_tcl_SpcHMIDynamicControlTextStream& oSpcHMIDynamicControlTextStream);

   virtual tVoid vVisit_e8_SpcHMIControlEnableState(most_fi_tcl_e8_SpcHMIControlEnableState& oe8_SpcHMIControlEnableState);

   virtual tVoid vVisit_SpcHMIControlEnableStreamItem(most_fi_tcl_SpcHMIControlEnableStreamItem& oSpcHMIControlEnableStreamItem);

   virtual tVoid vVisit_SpcHMIControlEnableStream(most_fi_tcl_SpcHMIControlEnableStream& oSpcHMIControlEnableStream);

   virtual tVoid vVisit_e8_SpcHMIDisplayEnum(most_fi_tcl_e8_SpcHMIDisplayEnum& oe8_SpcHMIDisplayEnum);

   virtual tVoid vVisit_e8_SpcHMIPromptVerboseness(most_fi_tcl_e8_SpcHMIPromptVerboseness& oe8_SpcHMIPromptVerboseness);

   virtual tVoid vVisit_e8_SpcHMIConfirmationLevel(most_fi_tcl_e8_SpcHMIConfirmationLevel& oe8_SpcHMIConfirmationLevel);

   virtual tVoid vVisit_SpcHMISRLanguageStream(most_fi_tcl_SpcHMISRLanguageStream& oSpcHMISRLanguageStream);

   virtual tVoid vVisit_e8_SpcHMISRDomain(most_fi_tcl_e8_SpcHMISRDomain& oe8_SpcHMISRDomain);

   virtual tVoid vVisit_e8_SpcHMISRDomainSpecificStatus(most_fi_tcl_e8_SpcHMISRDomainSpecificStatus& oe8_SpcHMISRDomainSpecificStatus);

   virtual tVoid vVisit_e8_SpcHMIDeviceTranscriptionState(most_fi_tcl_e8_SpcHMIDeviceTranscriptionState& oe8_SpcHMIDeviceTranscriptionState);

   virtual tVoid vVisit_SpcHMISRDomainDynamicDataStatusItem(most_fi_tcl_SpcHMISRDomainDynamicDataStatusItem& oSpcHMISRDomainDynamicDataStatusItem);

   virtual tVoid vVisit_SpcHMISRDomainDynamicDataStatus(most_fi_tcl_SpcHMISRDomainDynamicDataStatus& oSpcHMISRDomainDynamicDataStatus);

   virtual tVoid vVisit_SpcHMISRDomainStatusListStreamItem(most_fi_tcl_SpcHMISRDomainStatusListStreamItem& oSpcHMISRDomainStatusListStreamItem);

   virtual tVoid vVisit_SpcHMISRDomainStatusListStream(most_fi_tcl_SpcHMISRDomainStatusListStream& oSpcHMISRDomainStatusListStream);

   virtual tVoid vVisit_e8_SRecTParameterLoadStatus(most_fi_tcl_e8_SRecTParameterLoadStatus& oe8_SRecTParameterLoadStatus);

   virtual tVoid vVisit_e8_SRecTInterfaceEnable(most_fi_tcl_e8_SRecTInterfaceEnable& oe8_SRecTInterfaceEnable);

   virtual tVoid vVisit_e8_SRecTRecognitionError(most_fi_tcl_e8_SRecTRecognitionError& oe8_SRecTRecognitionError);

   virtual tVoid vVisit_SRecTRecognitionResultsItem(most_fi_tcl_SRecTRecognitionResultsItem& oSRecTRecognitionResultsItem);

   virtual tVoid vVisit_SRecTRecognitionResults(most_fi_tcl_SRecTRecognitionResults& oSRecTRecognitionResults);

   virtual tVoid vVisit_e8_SRecTNFSStatus(most_fi_tcl_e8_SRecTNFSStatus& oe8_SRecTNFSStatus);

   virtual tVoid vVisit_e8_SRecTRecordingsEnable(most_fi_tcl_e8_SRecTRecordingsEnable& oe8_SRecTRecordingsEnable);

   virtual tVoid vVisit_SRecTConfidenceThresholdsItem(most_fi_tcl_SRecTConfidenceThresholdsItem& oSRecTConfidenceThresholdsItem);

   virtual tVoid vVisit_SRecTConfidenceThresholds(most_fi_tcl_SRecTConfidenceThresholds& oSRecTConfidenceThresholds);

   virtual tVoid vVisit_e8_SyStaAnimationState(most_fi_tcl_e8_SyStaAnimationState& oe8_SyStaAnimationState);

   virtual tVoid vVisit_e8_SyStaSystemStateEnumeration(most_fi_tcl_e8_SyStaSystemStateEnumeration& oe8_SyStaSystemStateEnumeration);

   virtual tVoid vVisit_e8_SyStaModuleLockReportingEnum(most_fi_tcl_e8_SyStaModuleLockReportingEnum& oe8_SyStaModuleLockReportingEnum);

   virtual tVoid vVisit_e8_SyStaNoVINStates(most_fi_tcl_e8_SyStaNoVINStates& oe8_SyStaNoVINStates);

   virtual tVoid vVisit_e8_SyStaNoCalibrationStates(most_fi_tcl_e8_SyStaNoCalibrationStates& oe8_SyStaNoCalibrationStates);

   virtual tVoid vVisit_e8_SyStaTheftLockStates(most_fi_tcl_e8_SyStaTheftLockStates& oe8_SyStaTheftLockStates);

   virtual tVoid vVisit_e8_SyStaDateFormatEnum(most_fi_tcl_e8_SyStaDateFormatEnum& oe8_SyStaDateFormatEnum);

   virtual tVoid vVisit_e8_SyStaCalendarMonth(most_fi_tcl_e8_SyStaCalendarMonth& oe8_SyStaCalendarMonth);

   virtual tVoid vVisit_SyStaTimeOfDayStream(most_fi_tcl_SyStaTimeOfDayStream& oSyStaTimeOfDayStream);

   virtual tVoid vVisit_e8_SyStaTimeDisplayFormatEnum(most_fi_tcl_e8_SyStaTimeDisplayFormatEnum& oe8_SyStaTimeDisplayFormatEnum);

   virtual tVoid vVisit_e8_SyStaAutoTimeUpdateSettingEnum(most_fi_tcl_e8_SyStaAutoTimeUpdateSettingEnum& oe8_SyStaAutoTimeUpdateSettingEnum);

   virtual tVoid vVisit_e8_TestFBTestMode(most_fi_tcl_e8_TestFBTestMode& oe8_TestFBTestMode);

   virtual tVoid vVisit_TestFBTestFIlenameOrBuffer(most_fi_tcl_TestFBTestFIlenameOrBuffer& oTestFBTestFIlenameOrBuffer);

   virtual tVoid vVisit_e8_TestFBErrorInfo(most_fi_tcl_e8_TestFBErrorInfo& oe8_TestFBErrorInfo);

   virtual tVoid vVisit_e8_TestFBMostChannel(most_fi_tcl_e8_TestFBMostChannel& oe8_TestFBMostChannel);

   virtual tVoid vVisit_e8_TTSReadMode(most_fi_tcl_e8_TTSReadMode& oe8_TTSReadMode);

   virtual tVoid vVisit_e8_TTSLogicalAVChannel(most_fi_tcl_e8_TTSLogicalAVChannel& oe8_TTSLogicalAVChannel);

   virtual tVoid vVisit_e8_TTSMarkerMode(most_fi_tcl_e8_TTSMarkerMode& oe8_TTSMarkerMode);

   virtual tVoid vVisit_e8_TTSMarkerType(most_fi_tcl_e8_TTSMarkerType& oe8_TTSMarkerType);

   virtual tVoid vVisit_e8_TTSPriority(most_fi_tcl_e8_TTSPriority& oe8_TTSPriority);

   virtual tVoid vVisit_e8_TTSRequestStatus(most_fi_tcl_e8_TTSRequestStatus& oe8_TTSRequestStatus);

   virtual tVoid vVisit_e8_TTSTextType(most_fi_tcl_e8_TTSTextType& oe8_TTSTextType);

   virtual tVoid vVisit_e8_TTSTTSLanguage(most_fi_tcl_e8_TTSTTSLanguage& oe8_TTSTTSLanguage);

   virtual tVoid vVisit_e8_TTSPlaymode(most_fi_tcl_e8_TTSPlaymode& oe8_TTSPlaymode);

   virtual tVoid vVisit_TTSAvailableTTSLanguageStream(most_fi_tcl_TTSAvailableTTSLanguageStream& oTTSAvailableTTSLanguageStream);

   virtual tVoid vVisit_e8_TTSRequestContinuousSessionStatus(most_fi_tcl_e8_TTSRequestContinuousSessionStatus& oe8_TTSRequestContinuousSessionStatus);

   virtual tVoid vVisit_e8_TTSContinuousSessionPlaymode(most_fi_tcl_e8_TTSContinuousSessionPlaymode& oe8_TTSContinuousSessionPlaymode);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
