/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_TUNERMASTERFITYPES_HEADER
#define MIDW_TUNERMASTERFITYPES_HEADER


class midw_tunermasterfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_TUNERMASTER_FI message types

fi_tclMessageBase* midw_tunermasterfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_tunermasterfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_tunermasterfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b32_AnnoType b32Anno_Types;
   midw_fi_tcl_b8_SourceAnno Source;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_StopAnnouncements StopAnnouncements;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Band Band;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AntennaTest Antenna_Test;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclunmstr_RFAntenna Tunmstr_RF_Antenna;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool TestModeActive;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_WhichTuner WhichTuner;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_WhichTuner WhichTuner;
   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Band Band;
   tU32 Frequency;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Preset_Action Preset_Action;
   tU8 u8Element_ID;
   midw_fi_tcl_e8_List List;
   midw_fi_tcl_e8_Band Band;
   tU32 Frequency;
   tU32 PI;
   tU16 SecondaryPI;
   midw_fi_tclString Key;
   midw_fi_tcl_e8_PresetType PresetType;
   std::vector<tU8, std::allocator<tU8> > ElementIDList;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   midw_fi_tcl_e8_Source Source;
   midw_fi_tcl_e8_Action Action;
   midw_fi_tcl_e8_Preset_Action Preset_Action;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AutoStore_Start;
   midw_fi_tcl_e8_List List;
   midw_fi_tcl_e8_AST_Types AST_Type;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   midw_fi_tcl_e8_Source Source;
   midw_fi_tcl_e8_Action Action;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_ModeType Mode;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Frequency;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_StationSelection_Option Option;
   midw_fi_tcl_e8_Band Band;
   tU32 Frequency;
   tU8 u8Element_ID;
   midw_fi_tcl_e8_List List;
   tU32 PI;
   tU16 SecondaryPI;
   midw_fi_tcl_e8_ModulationType ModulationType;
   tU8 HDProgramNumber;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   midw_fi_tcl_e8_Source Source;
   midw_fi_tcl_e8_Action Action;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Enable;
   midw_fi_tcl_e8_Source Source;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TunMst_PresetListElement, std::allocator<midw_fi_tcl_TunMst_PresetListElement> > RadioProfile_PresetList;
   tBool RadioProfile_AMSwitch;
   midw_fi_tcl_e8_Preset_Option RadioProfile_Option;
   midw_fi_tcl_b8_RadioProfileSettingAction RadioProfileSettingAction;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunMstr_RadioSetting_StatusResponse RadioProfileSetting_Response;
   tU8 u8FailedPresetID;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_RadioProfileSettingAction RadioProfileSettingAction;
   std::vector<tU8, std::allocator<tU8> > PresetID;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   std::vector<midw_fi_tcl_TunMst_PresetListElement, std::allocator<midw_fi_tcl_TunMst_PresetListElement> > PresetList;
   tBool AMSwitch;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Preset_Action Preset_Action;
   tBool Status;
   std::vector<midw_fi_tcl_SXMPresetEntry, std::allocator<midw_fi_tcl_SXMPresetEntry> > PresetList;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU16, std::allocator<tU16> > SIDList;
   tU8 ChannelGraphicsType;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ChannelGraphicsType;
   std::vector<midw_fi_tcl_SXMChannelImagedata, std::allocator<midw_fi_tcl_SXMChannelImagedata> > ImageDataList;
   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ProfileResponse ProfileResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_PSFreeze_Mode e8Mode;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSrcState;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8PresetAutoCompare;
   tBool bUserPresetAction;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerMaster_StatusResponse TunerMaster_StatusResponse;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RequestAccepted;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool TA_ButtonStatus;
   midw_fi_tcl_e8_Source Source;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool TP_STATE;
   midw_fi_tcl_e8_Source TP_Source;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Source Source;
   midw_fi_tcl_e8_Action Action;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Band Band;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclunmstr_RFAntenna Tunmstr_RF_Antenna;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_PresetList, std::allocator<midw_fi_tcl_PresetList> > ListOfStations;
   midw_fi_tcl_e8_List List;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b32_AnnoType b32AnnouncementType;
   midw_fi_tcl_e8_Source Source;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Anno_Status;
   midw_fi_tcl_e8_Source Source;
   midw_fi_tcl_e8_AnnoTypes Anno_Types;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_TunerAvailability TunerAvailability;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Autostore_State;
   midw_fi_tcl_e8_AST_Types AST_Type;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_ModeType Mode;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_StationType StationType;
   tU32 Frequency;
   tU32 Station_ID;
   midw_fi_tclString StationNameFM;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Source Source;
   tBool Available;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_RadioProfileSettingAction RadioProfileSettingAction;
   std::vector<tU8, std::allocator<tU8> > PresetIndexList;
   tBool AMSwitch;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 PresetIndex;
   tU32 PresetBand;
   midw_fi_tcl_SXMPresetListEntry ChannelInfo;
   midw_fi_tcl_SXMChannelAttributes ChannelAttributes;
   tU32 LinearPresetIndex;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Preset_Action Preset_Action;
   tU8 PresetIndex;
   midw_fi_tclString Key;
   midw_fi_tcl_e8_PresetType PresetType;
   std::vector<tU8, std::allocator<tU8> > PresetIndexList;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_SXMSystemMessage SystemErrorType;
   tU16 CID;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_ProfileAction ProfileAction;
   midw_fi_tcl_ProfileStatus ProfileStatus;
   tU8 SourceID;
   tU8 DestinationID;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& coRef);
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PresetAutocompare;
   tBool bUserPresetAction;
   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg : public midw_tunermasterfi_tclMsgBaseMessage
{
public:

   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg();

   virtual ~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg();

   inline tBool operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};


#endif
