/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_TUNERMASTER_FI message types

fi_tclMessageBase* midw_tunermasterfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STOP_ANNOUNCEMENTMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STOP_ANNOUNCEMENTMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_BAND_CHANGEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_BAND_CHANGEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RF_ANTENNA_TESTMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RF_ANTENNA_TESTMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_TEST_MODEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_TEST_MODEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SRCCHG_TESTMODEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SRCCHG_TESTMODEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_ACTIVETUNER_INFOMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_ACTIVETUNER_INFOMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_HANDLINGMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_HANDLINGMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_AUTOSTOREMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_AUTOSTOREMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_MTC_SETMODEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_MTC_SETMODEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STATION_SELECTIONMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STATION_SELECTIONMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SOURCE_SETUP_OPTIONMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SOURCE_SETUP_OPTIONMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTINGMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTINGMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESET_RESPONSEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESET_RESPONSEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_SXMCHANNELART_LISTMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_SXMCHANNELART_LISTMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_SRCSTATEMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_SRCSTATEMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMETHODSTART:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMETHODRESULT:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SET_DTVANTENNAREGISTERSET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SET_DTVANTENNAREGISTERSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGEGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGEUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGERELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGESTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFOGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFOUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFORELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFOSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RF_ANTENNA_TESTUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RF_ANTENNA_TESTRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RF_ANTENNA_TESTSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_LISTUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_LISTRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_LISTSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATESTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATERELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_PRESET_HANDLINGSTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_PRESET_HANDLINGUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_PRESET_HANDLINGRELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGET:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGESTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGERELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_USERPROFILESTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_USERPROFILEUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_USERPROFILERELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_AUTOCOMPARESTATUS:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_AUTOCOMPAREUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg;

      case midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_AUTOCOMPARERELUPREG:
         return OSAL_NEW midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_tunermasterfifi messages

// common functions

tU16 midw_tunermasterfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_TUNERMASTERFI_C_U16_SERVICE_ID;
}

tU16 midw_tunermasterfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_tunermasterfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_tunermasterfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_tunermasterfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_tunermasterfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_tunermasterfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   b32Anno_Types = coRef.b32Anno_Types;
   Source = coRef.Source;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   b32Anno_Types = coRef.b32Anno_Types;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart()
:b32Anno_Types()
,Source()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b32Anno_Types);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b32Anno_Types);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b32Anno_Types == roRef.b32Anno_Types);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   StopAnnouncements = coRef.StopAnnouncements;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   StopAnnouncements = coRef.StopAnnouncements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart()
:StopAnnouncements()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STOP_ANNOUNCEMENTMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StopAnnouncements);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StopAnnouncements);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StopAnnouncements == roRef.StopAnnouncements);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STOP_ANNOUNCEMENTMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Band = coRef.Band;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Band = coRef.Band;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart()
:Band()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_BAND_CHANGEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Band);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Band);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Band == roRef.Band);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_BAND_CHANGEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Antenna_Test = coRef.Antenna_Test;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Antenna_Test = coRef.Antenna_Test;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart()
:Antenna_Test()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RF_ANTENNA_TESTMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Antenna_Test);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Antenna_Test);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Antenna_Test == roRef.Antenna_Test);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Tunmstr_RF_Antenna = coRef.Tunmstr_RF_Antenna;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Tunmstr_RF_Antenna = coRef.Tunmstr_RF_Antenna;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult()
:Tunmstr_RF_Antenna()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RF_ANTENNA_TESTMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Tunmstr_RF_Antenna);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Tunmstr_RF_Antenna);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Tunmstr_RF_Antenna == roRef.Tunmstr_RF_Antenna);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TestModeActive = coRef.TestModeActive;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestModeActive = coRef.TestModeActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart()
:TestModeActive(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_TEST_MODEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestModeActive);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestModeActive);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestModeActive == roRef.TestModeActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_TEST_MODEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   WhichTuner = coRef.WhichTuner;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   WhichTuner = coRef.WhichTuner;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart()
:WhichTuner()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SRCCHG_TESTMODEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WhichTuner);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WhichTuner);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WhichTuner == roRef.WhichTuner);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SRCCHG_TESTMODEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_ACTIVETUNER_INFOMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   WhichTuner = coRef.WhichTuner;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& coRef)
{
   if (this == &coRef) return *this;
   WhichTuner = coRef.WhichTuner;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult()
:WhichTuner()
,TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_ACTIVETUNER_INFOMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> WhichTuner);
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << WhichTuner);
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (WhichTuner == roRef.WhichTuner);
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Band = coRef.Band;
   Frequency = coRef.Frequency;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Band = coRef.Band;
   Frequency = coRef.Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart()
:Band()
,Frequency(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> Frequency);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Band);
   (tVoid) (oOut << Frequency);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (Frequency == roRef.Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Preset_Action = coRef.Preset_Action;
   u8Element_ID = coRef.u8Element_ID;
   List = coRef.List;
   Band = coRef.Band;
   Frequency = coRef.Frequency;
   PI = coRef.PI;
   SecondaryPI = coRef.SecondaryPI;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   ElementIDList = coRef.ElementIDList;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Preset_Action = coRef.Preset_Action;
   u8Element_ID = coRef.u8Element_ID;
   List = coRef.List;
   Band = coRef.Band;
   Frequency = coRef.Frequency;
   PI = coRef.PI;
   SecondaryPI = coRef.SecondaryPI;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   ElementIDList = coRef.ElementIDList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::vDestroy()
{
   Key.vDestroy();
   {
   ElementIDList.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart()
:Preset_Action()
,u8Element_ID(0)
,List()
,Band()
,Frequency(0)
,PI(0)
,SecondaryPI(0)
,Key()
,PresetType()

 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_HANDLINGMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 19+Key.u32GetSize(u16MajorVersion)+ static_cast<tU32>(ElementIDList.size()*1);
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Preset_Action);
   (tVoid) (oIn >> u8Element_ID);
   (tVoid) (oIn >> List);
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> PI);
   (tVoid) (oIn >> SecondaryPI);
   (tVoid) (oIn >> Key);
   (tVoid) (oIn >> PresetType);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ElementIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ElementIDList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Preset_Action);
   (tVoid) (oOut << u8Element_ID);
   (tVoid) (oOut << List);
   (tVoid) (oOut << Band);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << PI);
   (tVoid) (oOut << SecondaryPI);
   (tVoid) (oOut << Key);
   (tVoid) (oOut << PresetType);
   (tVoid) (oOut << (tU32)ElementIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ElementIDList.size(); ++u32Idx)
         (tVoid) (oOut << ElementIDList[u32Idx]);
   }
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Preset_Action == roRef.Preset_Action);
   bResult = bResult && (u8Element_ID == roRef.u8Element_ID);
   bResult = bResult && (List == roRef.List);
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (PI == roRef.PI);
   bResult = bResult && (SecondaryPI == roRef.SecondaryPI);
   bResult = bResult && (Key == roRef.Key);
   bResult = bResult && (PresetType == roRef.PresetType);
      bResult = bResult && (ElementIDList.size() == roRef.ElementIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ElementIDList.size()); ++u32Idx)
            bResult = bResult && (ElementIDList[u32Idx] == roRef.ElementIDList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   Source = coRef.Source;
   Action = coRef.Action;
   Preset_Action = coRef.Preset_Action;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   Source = coRef.Source;
   Action = coRef.Action;
   Preset_Action = coRef.Preset_Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult()
:TunerMaster_StatusResponse()
,Source()
,Action()
,Preset_Action()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_HANDLINGMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> Preset_Action);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Action);
   (tVoid) (oOut << Preset_Action);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (Preset_Action == roRef.Preset_Action);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   AutoStore_Start = coRef.AutoStore_Start;
   List = coRef.List;
   AST_Type = coRef.AST_Type;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& coRef)
{
   if (this == &coRef) return *this;
   AutoStore_Start = coRef.AutoStore_Start;
   List = coRef.List;
   AST_Type = coRef.AST_Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart()
:AutoStore_Start(0)
,List()
,AST_Type()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_AUTOSTOREMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AutoStore_Start);
   (tVoid) (oIn >> List);
   (tVoid) (oIn >> AST_Type);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AutoStore_Start);
   (tVoid) (oOut << List);
   (tVoid) (oOut << AST_Type);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AutoStore_Start == roRef.AutoStore_Start);
   bResult = bResult && (List == roRef.List);
   bResult = bResult && (AST_Type == roRef.AST_Type);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   Source = coRef.Source;
   Action = coRef.Action;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   Source = coRef.Source;
   Action = coRef.Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult()
:TunerMaster_StatusResponse()
,Source()
,Action()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_AUTOSTOREMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Action);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Action);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Action == roRef.Action);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Mode = coRef.Mode;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Mode = coRef.Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart()
:Mode()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_MTC_SETMODEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode == roRef.Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_MTC_SETMODEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   u32Frequency = coRef.u32Frequency;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u32Frequency = coRef.u32Frequency;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart()
:u32Frequency(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32Frequency);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32Frequency);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32Frequency == roRef.u32Frequency);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Option = coRef.Option;
   Band = coRef.Band;
   Frequency = coRef.Frequency;
   u8Element_ID = coRef.u8Element_ID;
   List = coRef.List;
   PI = coRef.PI;
   SecondaryPI = coRef.SecondaryPI;
   ModulationType = coRef.ModulationType;
   HDProgramNumber = coRef.HDProgramNumber;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Option = coRef.Option;
   Band = coRef.Band;
   Frequency = coRef.Frequency;
   u8Element_ID = coRef.u8Element_ID;
   List = coRef.List;
   PI = coRef.PI;
   SecondaryPI = coRef.SecondaryPI;
   ModulationType = coRef.ModulationType;
   HDProgramNumber = coRef.HDProgramNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart()
:Option()
,Band()
,Frequency(0)
,u8Element_ID(0)
,List()
,PI(0)
,SecondaryPI(0)
,ModulationType()
,HDProgramNumber(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STATION_SELECTIONMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Option);
   (tVoid) (oIn >> Band);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> u8Element_ID);
   (tVoid) (oIn >> List);
   (tVoid) (oIn >> PI);
   (tVoid) (oIn >> SecondaryPI);
   (tVoid) (oIn >> ModulationType);
   (tVoid) (oIn >> HDProgramNumber);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Option);
   (tVoid) (oOut << Band);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << u8Element_ID);
   (tVoid) (oOut << List);
   (tVoid) (oOut << PI);
   (tVoid) (oOut << SecondaryPI);
   (tVoid) (oOut << ModulationType);
   (tVoid) (oOut << HDProgramNumber);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Option == roRef.Option);
   bResult = bResult && (Band == roRef.Band);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (u8Element_ID == roRef.u8Element_ID);
   bResult = bResult && (List == roRef.List);
   bResult = bResult && (PI == roRef.PI);
   bResult = bResult && (SecondaryPI == roRef.SecondaryPI);
   bResult = bResult && (ModulationType == roRef.ModulationType);
   bResult = bResult && (HDProgramNumber == roRef.HDProgramNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   Source = coRef.Source;
   Action = coRef.Action;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   Source = coRef.Source;
   Action = coRef.Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult()
:TunerMaster_StatusResponse()
,Source()
,Action()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_STATION_SELECTIONMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Action);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Action);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Action == roRef.Action);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Enable = coRef.Enable;
   Source = coRef.Source;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Enable = coRef.Enable;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart()
:Enable(0)
,Source()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SOURCE_SETUP_OPTIONMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Enable);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Enable);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Enable == roRef.Enable);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SOURCE_SETUP_OPTIONMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   RadioProfile_PresetList = coRef.RadioProfile_PresetList;
   RadioProfile_AMSwitch = coRef.RadioProfile_AMSwitch;
   RadioProfile_Option = coRef.RadioProfile_Option;
   RadioProfileSettingAction = coRef.RadioProfileSettingAction;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RadioProfile_PresetList = coRef.RadioProfile_PresetList;
   RadioProfile_AMSwitch = coRef.RadioProfile_AMSwitch;
   RadioProfile_Option = coRef.RadioProfile_Option;
   RadioProfileSettingAction = coRef.RadioProfileSettingAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < RadioProfile_PresetList.size(); ++u32Idx)
         RadioProfile_PresetList[u32Idx].vDestroy();
   RadioProfile_PresetList.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart()

:RadioProfile_AMSwitch(0)
,RadioProfile_Option()
,RadioProfileSettingAction()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTINGMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < RadioProfile_PresetList.size(); ++u32ListIdx)
      u32DynamicSize += RadioProfile_PresetList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+7;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < RadioProfile_PresetList.size(); ++u32Idx)
      {
         RadioProfile_PresetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      RadioProfile_PresetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> RadioProfile_PresetList[u32Idx]);
      }
   }
   (tVoid) (oIn >> RadioProfile_AMSwitch);
   (tVoid) (oIn >> RadioProfile_Option);
   (tVoid) (oIn >> RadioProfileSettingAction);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)RadioProfile_PresetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < RadioProfile_PresetList.size(); ++u32Idx)
         (tVoid) (oOut << RadioProfile_PresetList[u32Idx]);
   }
   (tVoid) (oOut << RadioProfile_AMSwitch);
   (tVoid) (oOut << RadioProfile_Option);
   (tVoid) (oOut << RadioProfileSettingAction);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (RadioProfile_PresetList.size() == roRef.RadioProfile_PresetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < RadioProfile_PresetList.size()); ++u32Idx)
            bResult = bResult && (RadioProfile_PresetList[u32Idx] == roRef.RadioProfile_PresetList[u32Idx]);
      }
   bResult = bResult && (RadioProfile_AMSwitch == roRef.RadioProfile_AMSwitch);
   bResult = bResult && (RadioProfile_Option == roRef.RadioProfile_Option);
   bResult = bResult && (RadioProfileSettingAction == roRef.RadioProfileSettingAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   RadioProfileSetting_Response = coRef.RadioProfileSetting_Response;
   u8FailedPresetID = coRef.u8FailedPresetID;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& coRef)
{
   if (this == &coRef) return *this;
   RadioProfileSetting_Response = coRef.RadioProfileSetting_Response;
   u8FailedPresetID = coRef.u8FailedPresetID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult()
:RadioProfileSetting_Response()
,u8FailedPresetID(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTINGMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RadioProfileSetting_Response);
   (tVoid) (oIn >> u8FailedPresetID);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RadioProfileSetting_Response);
   (tVoid) (oOut << u8FailedPresetID);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RadioProfileSetting_Response == roRef.RadioProfileSetting_Response);
   bResult = bResult && (u8FailedPresetID == roRef.u8FailedPresetID);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   RadioProfileSettingAction = coRef.RadioProfileSettingAction;
   PresetID = coRef.PresetID;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   RadioProfileSettingAction = coRef.RadioProfileSettingAction;
   PresetID = coRef.PresetID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::vDestroy()
{
   {
   PresetID.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart()
:RadioProfileSettingAction()

 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(PresetID.size()*1);
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RadioProfileSettingAction);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PresetID.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetID[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RadioProfileSettingAction);
   (tVoid) (oOut << (tU32)PresetID.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetID.size(); ++u32Idx)
         (tVoid) (oOut << PresetID[u32Idx]);
   }
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RadioProfileSettingAction == roRef.RadioProfileSettingAction);
      bResult = bResult && (PresetID.size() == roRef.PresetID.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetID.size()); ++u32Idx)
            bResult = bResult && (PresetID[u32Idx] == roRef.PresetID[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   PresetList = coRef.PresetList;
   AMSwitch = coRef.AMSwitch;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   PresetList = coRef.PresetList;
   AMSwitch = coRef.AMSwitch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::vDestroy()
{
   TunerMaster_StatusResponse.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         PresetList[u32Idx].vDestroy();
   PresetList.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult()
:TunerMaster_StatusResponse()

,AMSwitch(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PresetList.size(); ++u32ListIdx)
      u32DynamicSize += PresetList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
      {
         PresetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PresetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetList[u32Idx]);
      }
   }
   (tVoid) (oIn >> AMSwitch);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   (tVoid) (oOut << (tU32)PresetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         (tVoid) (oOut << PresetList[u32Idx]);
   }
   (tVoid) (oOut << AMSwitch);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
      bResult = bResult && (PresetList.size() == roRef.PresetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetList.size()); ++u32Idx)
            bResult = bResult && (PresetList[u32Idx] == roRef.PresetList[u32Idx]);
      }
   bResult = bResult && (AMSwitch == roRef.AMSwitch);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Preset_Action = coRef.Preset_Action;
   Status = coRef.Status;
   PresetList = coRef.PresetList;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Preset_Action = coRef.Preset_Action;
   Status = coRef.Status;
   PresetList = coRef.PresetList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         PresetList[u32Idx].vDestroy();
   PresetList.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart()
:Preset_Action()
,Status(0)

 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESET_RESPONSEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < PresetList.size(); ++u32ListIdx)
      u32DynamicSize += PresetList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Preset_Action);
   (tVoid) (oIn >> Status);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
      {
         PresetList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      PresetList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Preset_Action);
   (tVoid) (oOut << Status);
   (tVoid) (oOut << (tU32)PresetList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetList.size(); ++u32Idx)
         (tVoid) (oOut << PresetList[u32Idx]);
   }
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Preset_Action == roRef.Preset_Action);
   bResult = bResult && (Status == roRef.Status);
      bResult = bResult && (PresetList.size() == roRef.PresetList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetList.size()); ++u32Idx)
            bResult = bResult && (PresetList[u32Idx] == roRef.PresetList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESET_RESPONSEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   SIDList = coRef.SIDList;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SIDList = coRef.SIDList;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::vDestroy()
{
   {
   SIDList.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart()

:ChannelGraphicsType(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_SXMCHANNELART_LISTMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(SIDList.size()*2);
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      SIDList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SIDList[u32Idx]);
      }
   }
   (tVoid) (oIn >> ChannelGraphicsType);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SIDList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SIDList.size(); ++u32Idx)
         (tVoid) (oOut << SIDList[u32Idx]);
   }
   (tVoid) (oOut << ChannelGraphicsType);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SIDList.size() == roRef.SIDList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SIDList.size()); ++u32Idx)
            bResult = bResult && (SIDList[u32Idx] == roRef.SIDList[u32Idx]);
      }
   bResult = bResult && (ChannelGraphicsType == roRef.ChannelGraphicsType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   ImageDataList = coRef.ImageDataList;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ChannelGraphicsType = coRef.ChannelGraphicsType;
   ImageDataList = coRef.ImageDataList;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ImageDataList.size(); ++u32Idx)
         ImageDataList[u32Idx].vDestroy();
   ImageDataList.clear();
   }
   TunerMaster_StatusResponse.vDestroy(); 
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult()
:ChannelGraphicsType(0)

,TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_GET_SXMCHANNELART_LISTMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ImageDataList.size(); ++u32ListIdx)
      u32DynamicSize += ImageDataList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+6;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelGraphicsType);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ImageDataList.size(); ++u32Idx)
      {
         ImageDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ImageDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ImageDataList[u32Idx]);
      }
   }
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelGraphicsType);
   (tVoid) (oOut << (tU32)ImageDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ImageDataList.size(); ++u32Idx)
         (tVoid) (oOut << ImageDataList[u32Idx]);
   }
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelGraphicsType == roRef.ChannelGraphicsType);
      bResult = bResult && (ImageDataList.size() == roRef.ImageDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ImageDataList.size()); ++u32Idx)
            bResult = bResult && (ImageDataList[u32Idx] == roRef.ImageDataList[u32Idx]);
      }
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   ProfileResponse = coRef.ProfileResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ProfileResponse = coRef.ProfileResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart()
:ProfileResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProfileResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProfileResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProfileResponse == roRef.ProfileResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   e8Mode = coRef.e8Mode;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8Mode = coRef.e8Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart()
:e8Mode()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Mode);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Mode);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Mode == roRef.e8Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   bSrcState = coRef.bSrcState;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bSrcState = coRef.bSrcState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart()
:bSrcState(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_SRCSTATEMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSrcState);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSrcState);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSrcState == roRef.bSrcState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_SRCSTATEMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   u8PresetAutoCompare = coRef.u8PresetAutoCompare;
   bUserPresetAction = coRef.bUserPresetAction;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8PresetAutoCompare = coRef.u8PresetAutoCompare;
   bUserPresetAction = coRef.bUserPresetAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart()
:u8PresetAutoCompare(0)
,bUserPresetAction(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMETHODSTART;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8PresetAutoCompare);
   (tVoid) (oIn >> bUserPresetAction);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8PresetAutoCompare);
   (tVoid) (oOut << bUserPresetAction);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8PresetAutoCompare == roRef.u8PresetAutoCompare);
   bResult = bResult && (bUserPresetAction == roRef.bUserPresetAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunerMaster_StatusResponse = coRef.TunerMaster_StatusResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult()
:TunerMaster_StatusResponse()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMETHODRESULT;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::~midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerMaster_StatusResponse);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerMaster_StatusResponse);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerMaster_StatusResponse == roRef.TunerMaster_StatusResponse);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SET_DTVANTENNAREGISTERSET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   RequestAccepted = coRef.RequestAccepted;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& coRef)
{
   if (this == &coRef) return *this;
   RequestAccepted = coRef.RequestAccepted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus()
:RequestAccepted(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SET_DTVANTENNAREGISTERSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RequestAccepted);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RequestAccepted);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RequestAccepted == roRef.RequestAccepted);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TA_ButtonStatus = coRef.TA_ButtonStatus;
   Source = coRef.Source;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   TA_ButtonStatus = coRef.TA_ButtonStatus;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus()
:TA_ButtonStatus(0)
,Source()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TA_STATUSSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TA_ButtonStatus);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TA_ButtonStatus);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TA_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TA_ButtonStatus == roRef.TA_ButtonStatus);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TP_STATE = coRef.TP_STATE;
   TP_Source = coRef.TP_Source;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   TP_STATE = coRef.TP_STATE;
   TP_Source = coRef.TP_Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus()
:TP_STATE(0)
,TP_Source()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TP_STATUSSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TP_STATE);
   (tVoid) (oIn >> TP_Source);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TP_STATE);
   (tVoid) (oOut << TP_Source);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TP_STATE == roRef.TP_STATE);
   bResult = bResult && (TP_Source == roRef.TP_Source);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGEGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGEUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGERELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Source = coRef.Source;
   Action = coRef.Action;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& coRef)
{
   if (this == &coRef) return *this;
   Source = coRef.Source;
   Action = coRef.Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus()
:Source()
,Action()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SOURCE_CHANGESTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Action);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Action);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Action == roRef.Action);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFOGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFOUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFORELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFORelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Band = coRef.Band;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& coRef)
{
   if (this == &coRef) return *this;
   Band = coRef.Band;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus()
:Band()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_BAND_INFOSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Band);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Band);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Band == roRef.Band);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RF_ANTENNA_TESTUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RF_ANTENNA_TESTRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Tunmstr_RF_Antenna = coRef.Tunmstr_RF_Antenna;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& coRef)
{
   if (this == &coRef) return *this;
   Tunmstr_RF_Antenna = coRef.Tunmstr_RF_Antenna;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus()
:Tunmstr_RF_Antenna()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RF_ANTENNA_TESTSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Tunmstr_RF_Antenna);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Tunmstr_RF_Antenna);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Tunmstr_RF_Antenna == roRef.Tunmstr_RF_Antenna);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_LISTUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_LISTRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   ListOfStations = coRef.ListOfStations;
   List = coRef.List;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfStations = coRef.ListOfStations;
   List = coRef.List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfStations.size(); ++u32Idx)
         ListOfStations[u32Idx].vDestroy();
   ListOfStations.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus()

:List()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_LISTSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfStations.size(); ++u32ListIdx)
      u32DynamicSize += ListOfStations[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfStations.size(); ++u32Idx)
      {
         ListOfStations[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListOfStations.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfStations[u32Idx]);
      }
   }
   (tVoid) (oIn >> List);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListOfStations.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfStations.size(); ++u32Idx)
         (tVoid) (oOut << ListOfStations[u32Idx]);
   }
   (tVoid) (oOut << List);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfStations.size() == roRef.ListOfStations.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfStations.size()); ++u32Idx)
            bResult = bResult && (ListOfStations[u32Idx] == roRef.ListOfStations[u32Idx]);
      }
   bResult = bResult && (List == roRef.List);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   b32AnnouncementType = coRef.b32AnnouncementType;
   Source = coRef.Source;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   b32AnnouncementType = coRef.b32AnnouncementType;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus()
:b32AnnouncementType()
,Source()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNO_BUTTON_STATUSSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> b32AnnouncementType);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << b32AnnouncementType);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (b32AnnouncementType == roRef.b32AnnouncementType);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Anno_Status = coRef.Anno_Status;
   Source = coRef.Source;
   Anno_Types = coRef.Anno_Types;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   Anno_Status = coRef.Anno_Status;
   Source = coRef.Source;
   Anno_Types = coRef.Anno_Types;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus()
:Anno_Status(0)
,Source()
,Anno_Types()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_ANNOUNCEMENT_STATUSSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Anno_Status);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Anno_Types);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Anno_Status);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Anno_Types);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Anno_Status == roRef.Anno_Status);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Anno_Types == roRef.Anno_Types);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   TunerAvailability = coRef.TunerAvailability;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerAvailability = coRef.TunerAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus()
:TunerAvailability()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerAvailability);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerAvailability);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerAvailability == roRef.TunerAvailability);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Autostore_State = coRef.Autostore_State;
   AST_Type = coRef.AST_Type;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   Autostore_State = coRef.Autostore_State;
   AST_Type = coRef.AST_Type;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus()
:Autostore_State(0)
,AST_Type()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_GET_AUTOSTORE_STATUSSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Autostore_State);
   (tVoid) (oIn >> AST_Type);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Autostore_State);
   (tVoid) (oOut << AST_Type);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Autostore_State == roRef.Autostore_State);
   bResult = bResult && (AST_Type == roRef.AST_Type);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Mode = coRef.Mode;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   Mode = coRef.Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus()
:Mode()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SETMODE_STATUSSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode == roRef.Mode);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   StationType = coRef.StationType;
   Frequency = coRef.Frequency;
   Station_ID = coRef.Station_ID;
   StationNameFM = coRef.StationNameFM;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& coRef)
{
   if (this == &coRef) return *this;
   StationType = coRef.StationType;
   Frequency = coRef.Frequency;
   Station_ID = coRef.Station_ID;
   StationNameFM = coRef.StationNameFM;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::vDestroy()
{
   StationNameFM.vDestroy();
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus()
:StationType()
,Frequency(0)
,Station_ID(0)
,StationNameFM()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 9+StationNameFM.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StationType);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> Station_ID);
   (tVoid) (oIn >> StationNameFM);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StationType);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << Station_ID);
   (tVoid) (oOut << StationNameFM);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StationType == roRef.StationType);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (Station_ID == roRef.Station_ID);
   bResult = bResult && (StationNameFM == roRef.StationNameFM);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Source = coRef.Source;
   Available = coRef.Available;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& coRef)
{
   if (this == &coRef) return *this;
   Source = coRef.Source;
   Available = coRef.Available;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus()
:Source()
,Available(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Available);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Available);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Available == roRef.Available);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   RadioProfileSettingAction = coRef.RadioProfileSettingAction;
   PresetIndexList = coRef.PresetIndexList;
   AMSwitch = coRef.AMSwitch;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& coRef)
{
   if (this == &coRef) return *this;
   RadioProfileSettingAction = coRef.RadioProfileSettingAction;
   PresetIndexList = coRef.PresetIndexList;
   AMSwitch = coRef.AMSwitch;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::vDestroy()
{
   {
   PresetIndexList.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus()
:RadioProfileSettingAction()

,AMSwitch(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(PresetIndexList.size()*1);
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RadioProfileSettingAction);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PresetIndexList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetIndexList[u32Idx]);
      }
   }
   (tVoid) (oIn >> AMSwitch);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RadioProfileSettingAction);
   (tVoid) (oOut << (tU32)PresetIndexList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetIndexList.size(); ++u32Idx)
         (tVoid) (oOut << PresetIndexList[u32Idx]);
   }
   (tVoid) (oOut << AMSwitch);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RadioProfileSettingAction == roRef.RadioProfileSettingAction);
      bResult = bResult && (PresetIndexList.size() == roRef.PresetIndexList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetIndexList.size()); ++u32Idx)
            bResult = bResult && (PresetIndexList[u32Idx] == roRef.PresetIndexList[u32Idx]);
      }
   bResult = bResult && (AMSwitch == roRef.AMSwitch);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   PresetIndex = coRef.PresetIndex;
   PresetBand = coRef.PresetBand;
   ChannelInfo = coRef.ChannelInfo;
   ChannelAttributes = coRef.ChannelAttributes;
   LinearPresetIndex = coRef.LinearPresetIndex;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& coRef)
{
   if (this == &coRef) return *this;
   PresetIndex = coRef.PresetIndex;
   PresetBand = coRef.PresetBand;
   ChannelInfo = coRef.ChannelInfo;
   ChannelAttributes = coRef.ChannelAttributes;
   LinearPresetIndex = coRef.LinearPresetIndex;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::vDestroy()
{
   ChannelInfo.vDestroy(); 
   ChannelAttributes.vDestroy(); 
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus()
:PresetIndex(0)
,PresetBand(0)
,ChannelInfo()
,ChannelAttributes()
,LinearPresetIndex(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATESTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 12+ChannelInfo.u32GetSize(u16MajorVersion)+ChannelAttributes.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetIndex);
   (tVoid) (oIn >> PresetBand);
   (tVoid) (oIn >> ChannelInfo);
   (tVoid) (oIn >> ChannelAttributes);
   (tVoid) (oIn >> LinearPresetIndex);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetIndex);
   (tVoid) (oOut << PresetBand);
   (tVoid) (oOut << ChannelInfo);
   (tVoid) (oOut << ChannelAttributes);
   (tVoid) (oOut << LinearPresetIndex);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetIndex == roRef.PresetIndex);
   bResult = bResult && (PresetBand == roRef.PresetBand);
   bResult = bResult && (ChannelInfo == roRef.ChannelInfo);
   bResult = bResult && (ChannelAttributes == roRef.ChannelAttributes);
   bResult = bResult && (LinearPresetIndex == roRef.LinearPresetIndex);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATERELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   Preset_Action = coRef.Preset_Action;
   PresetIndex = coRef.PresetIndex;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   PresetIndexList = coRef.PresetIndexList;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& coRef)
{
   if (this == &coRef) return *this;
   Preset_Action = coRef.Preset_Action;
   PresetIndex = coRef.PresetIndex;
   Key = coRef.Key;
   PresetType = coRef.PresetType;
   PresetIndexList = coRef.PresetIndexList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::vDestroy()
{
   Key.vDestroy();
   {
   PresetIndexList.clear();
   }
}

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus()
:Preset_Action()
,PresetIndex(0)
,Key()
,PresetType()

 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_PRESET_HANDLINGSTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 7+Key.u32GetSize(u16MajorVersion)+ static_cast<tU32>(PresetIndexList.size()*1);
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Preset_Action);
   (tVoid) (oIn >> PresetIndex);
   (tVoid) (oIn >> Key);
   (tVoid) (oIn >> PresetType);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      PresetIndexList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> PresetIndexList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Preset_Action);
   (tVoid) (oOut << PresetIndex);
   (tVoid) (oOut << Key);
   (tVoid) (oOut << PresetType);
   (tVoid) (oOut << (tU32)PresetIndexList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < PresetIndexList.size(); ++u32Idx)
         (tVoid) (oOut << PresetIndexList[u32Idx]);
   }
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Preset_Action == roRef.Preset_Action);
   bResult = bResult && (PresetIndex == roRef.PresetIndex);
   bResult = bResult && (Key == roRef.Key);
   bResult = bResult && (PresetType == roRef.PresetType);
      bResult = bResult && (PresetIndexList.size() == roRef.PresetIndexList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < PresetIndexList.size()); ++u32Idx)
            bResult = bResult && (PresetIndexList[u32Idx] == roRef.PresetIndexList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_PRESET_HANDLINGUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_PRESET_HANDLINGRELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGRelUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGET;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   SystemErrorType = coRef.SystemErrorType;
   CID = coRef.CID;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& coRef)
{
   if (this == &coRef) return *this;
   SystemErrorType = coRef.SystemErrorType;
   CID = coRef.CID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus()
:SystemErrorType()
,CID(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGESTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SystemErrorType);
   (tVoid) (oIn >> CID);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SystemErrorType);
   (tVoid) (oOut << CID);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SystemErrorType == roRef.SystemErrorType);
   bResult = bResult && (CID == roRef.CID);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGERELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
   SourceID = coRef.SourceID;
   DestinationID = coRef.DestinationID;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& coRef)
{
   if (this == &coRef) return *this;
   ProfileAction = coRef.ProfileAction;
   ProfileStatus = coRef.ProfileStatus;
   SourceID = coRef.SourceID;
   DestinationID = coRef.DestinationID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus()
:ProfileAction()
,ProfileStatus()
,SourceID(0)
,DestinationID(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_USERPROFILESTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProfileAction);
   (tVoid) (oIn >> ProfileStatus);
   (tVoid) (oIn >> SourceID);
   (tVoid) (oIn >> DestinationID);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProfileAction);
   (tVoid) (oOut << ProfileStatus);
   (tVoid) (oOut << SourceID);
   (tVoid) (oOut << DestinationID);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProfileAction == roRef.ProfileAction);
   bResult = bResult && (ProfileStatus == roRef.ProfileStatus);
   bResult = bResult && (SourceID == roRef.SourceID);
   bResult = bResult && (DestinationID == roRef.DestinationID);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_USERPROFILEUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_SXM_USERPROFILERELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILERelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& coRef)
   : midw_tunermasterfi_tclMsgBaseMessage(coRef)
{
   PresetAutocompare = coRef.PresetAutocompare;
   bUserPresetAction = coRef.bUserPresetAction;
}
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::operator=(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& coRef)
{
   if (this == &coRef) return *this;
   PresetAutocompare = coRef.PresetAutocompare;
   bUserPresetAction = coRef.bUserPresetAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus()
:PresetAutocompare(0)
,bUserPresetAction(0)
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_AUTOCOMPARESTATUS;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus()
{}

tU32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PresetAutocompare);
   (tVoid) (oIn >> bUserPresetAction);
   return oIn;
}

fi_tclOutContext& midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PresetAutocompare);
   (tVoid) (oOut << bUserPresetAction);
   return oOut;
}

tBool midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus::operator==(const midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PresetAutocompare == roRef.PresetAutocompare);
   bResult = bResult && (bUserPresetAction == roRef.bUserPresetAction);
   return bResult;
}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_AUTOCOMPAREUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREUpReg()
{}

//=============================================================================

midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg::midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg()
 {}

tS32 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg::s32GetTypeId() const
{
   return (tS32) midw_tunermasterfi_tclToken::EN_MSG_FID_TUNMSTR_G_PRESET_AUTOCOMPARERELUPREG;
}


midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg::~midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPARERelUpReg()
{}

