/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_TUNERFITYPES_HEADER
#define MIDW_TUNERFITYPES_HEADER


class midw_tunerfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_TUNER_FI message types

fi_tclMessageBase* midw_tunerfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_tunerfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_tunerfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment;
   midw_fi_tcl_e8_Tun_TunerHeader TunerHeader;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCY_WITH_TUNERHEADERMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerHeader TunerHeader;
   midw_fi_tcl_TunerManualSingleStep TunerManualSingleStep;
   midw_fi_tcl_e8_Tun_AcceptAF u8AcceptAF;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATFREQUENCYMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerSeek u8TunerSeek;
   midw_fi_tcl_e8_Tun_TunerHeader u8TunerHeader;
   tU32 u32Frequency;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart();

   virtual ~midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& operator=(const midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& coRef);
   midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult(const midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Tuner_Field_Strength;
   virtual ~midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_S_TUN_GET_FIELD_STRENGTHMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ListID e8ListID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerFeature TunerFeature;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_FEATUREMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8AbsVal;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HICUTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Notification u8Notification;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AFLIST_V2MethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_PhysicalTuner u8PhysicalTunerId;
   midw_fi_tcl_e8_Tun_TestTuneFrequencyMode u8Mode;
   tU32 u32Frequency;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_ELEMENT_FROM_AFLIST_V2MethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Frequency;
   midw_fi_tcl_e8_Tun_TunerBand u8Band;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bStatus;
   midw_fi_tcl_e8_Tun_ListID e8ListID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Sel_List_Elem Sel_List_Elem;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Tun_MakeConfigList TunMakeConfigList;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_MakeConfigListElem TunMakeConfigListElem;
   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Aud_FGBG_New TunAudFGBGNew;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   midw_fi_tcl_AudFGBGStatus TunAudioFgBgStatus;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Tun_Set_PI TunSetPIPara;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SharxStep;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_SHARXLEVELMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ListID e8ListID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DDADDS_Mode DDADDS_Mode;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SETUP_DDADDSMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_PresetAction e8Action;
   tU8 u8ListElementID;
   midw_fi_tcl_e8_Tun_ListID e8ListID;
   tU32 u32Frequency;
   tU16 u16PI;
   tU16 u16SecondaryPI;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_PresetAction e8Action;
   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bPSFreeze;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PS_FREEZEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Tun_AutoCompParam TunAutoCompParam;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUTOCOMP_PARAMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumOfRDBID;
   std::vector<midw_fi_tcl_Tun_RDBID_Value, std::allocator<midw_fi_tcl_Tun_RDBID_Value> > TunRDBID_Value;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_Tun_RDBID_Value, std::allocator<midw_fi_tcl_Tun_RDBID_Value> > TunRDBID_Value;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_RDBIDMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart();

   virtual ~midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_CALIBRATION_DATAMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart();

   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_PhysicalTuner u8_PhysicalTuner;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID;
   tBool bFrozenList;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_STATIONLIST_EXITMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bSurveilTP;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SURVEIL_TPMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Engg_Param_ID e8ParameterID;
   tU32 u32ParameterValue;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_ENGG_PARAMETERMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_AnnoTypes b8AnnoType;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_AnnoTypes e8AnnoType;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_PS_Freeze_Mode e8Mode;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Speed;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SPEED_INFOMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart();

   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID;
   tBool bStatus;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_CONFIGLIST_UPDATEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_DefaultSettingOption e8DefaultSettingOption;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DEFAULT_SETTINGMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_Tun_DemodSwitch DemodulationSwitch;
   midw_fi_tcl_b8_Tun_DemodSwitch b8DemodulationSwitchMask;
   midw_fi_tcl_b8_Tun_DemodSwitch b8DemodulationSwitchValue;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Frequency;
   tU32 u32DRMServiceId;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_DRM_AUDIOPRGMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sDRMAudioSinkName;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_DRMSourceActivity e8DRMSourceActivity;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TestModeSource e8TestModeSource;
   midw_fi_tcl_e8_Tun_TestModeActivity e8TestModeActivity;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_SelectMode SelectMode;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioPrg;
   midw_fi_tcl_e8_Tun_RelativeDirection e8Direction;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SELECT_HD_AUDIOPRGMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32Frequency;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioPrg;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart();

   virtual ~midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult();

   virtual ~midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_AudioSplitMode e8ParameterValue;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Tun_ParameterID e16Parameter_ID;
   tS8 s8ParameterValue;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_DRMTestModeActivity e8DRMTestModeActivity;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DRM_TESTMODEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart();

   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_Tun_AFSwitch b8AFSwitchMask;
   midw_fi_tcl_b8_Tun_AFSwitch b8AFSwitch;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_StationSelectionOption Option;
   midw_fi_tcl_e8_Tun_TunerBand Band;
   tU32 Frequency;
   tU8 u8Element_ID;
   midw_fi_tcl_e8_Tun_ListID e8ListID;
   tU32 PI;
   tU8 HDProgramNumber;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart();

   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DARC_NO_VICS_DATA_AVAILABLEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u32FrequencyList FrequencyData;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Japan_Region e8SelectedRegion;
   tBool bAreaSelectionMode;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SET_AREAMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ChangeStationMode e8ChangeStationMode;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Language e8Language;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_SelectMode e8SelectMode;
   midw_fi_tcl_e8_Tun_RelativeDirection e8Direction;
   tU16 u16ElementID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Tun_UserProfileAction Action;
   tU8 UserID;
   tU8 DestinationUserID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Tun_UserProfileAction Action;
   tU8 ActiveUserID;
   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 UserID;
   midw_fi_tcl_TunerListElementList Tun_ListElements;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerBand u8Band;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& operator=(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& coRef);
   midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerServer_StatusResponse TunerServer_StatusResponse;
   virtual ~midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u16CalibrationData CalibrationData;
   midw_fi_tcl_CalibrationData CalibrationDataValues;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATURERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b32_Tun_Features b32_Features;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8AbsVal;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_HICUTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2UpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2RelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Get& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& operator=(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8LengthOfAFList;
   std::vector<midw_fi_tcl_TunerAFList, std::allocator<midw_fi_tcl_TunerAFList> > TunerAFList;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AFLIST_V2Status& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID;
   midw_fi_tcl_TunerConfigListElementList Tun_ConfigListElements;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_CONFIG_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8SharxStep;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_SHARXLEVELStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DDA;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_DDAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8AF;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_AFStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Measuremode;
   midw_fi_tcl_e8_Tun_PhysicalTuner e8PhysicalTunerId;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_MEASUREMODEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8RDSreg;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSREGStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NumofElementsinList;
   midw_fi_tcl_e8_Tun_ListID e8ListID;
   midw_fi_tcl_TunerStaticListElementList Tun_StaticListElements;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PICode;
   midw_fi_tcl_TunerRadioText TunerRadioText;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RADIO_TEXTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerBandAndStationInfo TunerBandAndStationInfo;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_BAND_PLUS_STATION_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DDADDS_Mode DDADDS_Mode;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SETUP_DDADDSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerTestModeData_DDADDS TunerTestModeData;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 bTMCAvailableFlag;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_TMC_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TrafficInfo, std::allocator<midw_fi_tcl_TrafficInfo> > ListOfTrafficInfo;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TMCStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Atstationinfo Atstationinfo;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_TunerSeek e8SeekState;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATSEEKStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bRemoteCtrl;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TunerRdbId, std::allocator<midw_fi_tcl_TunerRdbId> > ListOfRdbIds;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_RdbIdActualListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8RDS;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_RDSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Engg_Param_ID e8ParameterID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Engg_Param_ID e8ParameterID;
   tU32 u32ParameterValue;
   std::vector<midw_fi_tcl_Tun_Engg_Param_List_Elem, std::allocator<midw_fi_tcl_Tun_Engg_Param_List_Elem> > ListOfEnggParamValues;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_ENGG_PARAMETERStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigParam_Type e8ConfigParamType;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TuningActionConfigParam, std::allocator<midw_fi_tcl_TuningActionConfigParam> > ListOfTuningActionConfigParameters;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SET_TUNING_ACTION_CONFIGStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Anno_Message e8AnnoMessage;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_AnnoInfostatus AnnoInfoStatus;
   midw_fi_tcl_b8_Anno_Message b8AnnoTypes;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bTPState;
   tBool bPTYState;
   tBool bWeatherAlertState;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16PI;
   midw_fi_tclString sPSName;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_PI_PS_RELATIONStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32AvailableBands;
   midw_fi_tcl_AvailableBandInfoList TunerAvailableBandInfoList;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AVAILABLE_BAND_RANGEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMute;
   tU8 u8Attenuation;
   tBool bMute_Interrupt;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8FreqPerc;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sDRMRadioText;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_PISearch_Status e8PISearchStatus;
   tU16 u16PI;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_ATPISEARCHStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioPrgNo;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AUDIOPRGMStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunPSDData TunPSDData;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_PSD_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_TunerHDTestModeData TunerHDTestModeData;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_TEST_MODE_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFORelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_HDAdvisoryInfo e8HDAdvisoryInfo;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_AVISORY_INFOStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_Tun_DemodSwitch DemodulationSwitch;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DEMODULATION_SWITCH_STATUSStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_AudioSplitMode e8ParameterValue;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Tun_ParameterID e16Parameter_ID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_Tun_ParameterID e16Parameter_ID;
   tS8 s8ParameterValue;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8TunerInfo;
   tU32 u32Frequency;
   tU8 u8FieldStrength;
   tU8 u8SyncStatus;
   tU8 u8RobustnessMode;
   tU32 u32ChannelParams;
   std::vector<tU8, std::allocator<tU8> > tU8ListDRMService;
   midw_fi_tclString sDRMServiceLabelData;
   tU32 u32AudioConfig;
   tU8 u8ProtectionLevels;
   tS32 s32MSC_BER;
   tU8 u8AudioCRCFails;
   tU8 u8AudioMute;
   tU8 u8ServiceQuality;
   tU16 u16FAC_ERRS;
   tU8 u8FAC_CRC_Fails;
   tU16 u16SDC_ERRS;
   tU8 u8SDC_CRC_Fails;
   tU16 u16MuteCounter;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32HDStationId;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioProgram;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32HDStationId;
   midw_fi_tcl_e8_Tun_HDAudioProgram e8HDAudioProgram;
   midw_fi_tclString sHDLongName;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bDisplayImage;
   midw_fi_tcl_ImageFileInfo ImageFileInfo;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bTimer;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_HD_SIGNALLOST_TIMERUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATERelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ConfigListID e8ConfigListID;
   midw_fi_tcl_TunerConfigListElementList Tun_ConfigListElements;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bListUpdate;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_LISTUPDATE_NOTIFICATIONStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 Frequency;
   midw_fi_tcl_DARCDataBlockList DARCData;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREARelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_Japan_Region e8SelectedRegion;
   tBool bAreaSelectionMode;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Tun_ListID FMPresetListID;
   midw_fi_tcl_e8_Tun_ListID AMPresetListID;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_GET_ACTIVE_PRESETLISTIDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8JapanStationCount;
   midw_fi_tcl_TunerJapanStationNameList JapanStationNamesList;
   tU16 u16SelectedElement;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg();

   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg();

   inline tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus : public midw_tunerfi_tclMsgBaseMessage
{
public:

   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& operator=(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& coRef);
   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_Tun_SwitchingFrequency b8SwitchingFrequencyMask;
   virtual ~midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
