#ifndef MIDW_TUNERFILANGUAGE_HEADER
#define MIDW_TUNERFILANGUAGE_HEADER

class midw_tunerfi_tclInContext;
class midw_tunerfi_tclOutContext;
class midw_tunerfi_tclVisitorBase;

class MY_DECL midw_tunerfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  midw_tunerfi_tclDescription(fi_tclInContext* poIn, midw_tunerfi_tclVisitorBase* poVisit);
  midw_tunerfi_tclDescription(fi_tclOutContext* poOut, midw_tunerfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(midw_tunerfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(midw_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ midw_tunerfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  midw_tunerfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<midw_tunerfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<midw_tunerfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline midw_tunerfi_tclDescription::midw_tunerfi_tclDescription(fi_tclInContext* poIn, midw_tunerfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline midw_tunerfi_tclDescription::midw_tunerfi_tclDescription(fi_tclOutContext* poOut, midw_tunerfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

