/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_TUNDIAGFITYPES_HEADER
#define MIDW_TUNDIAGFITYPES_HEADER


class midw_tundiagfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_TUNDIAG_FI message types

fi_tclMessageBase* midw_tundiagfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_tundiagfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_tundiagfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart : public midw_tundiagfi_tclMsgBaseMessage
{
public:

   midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& operator=(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& coRef);
   midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8DataLength;
   std::vector<tU8, std::allocator<tU8> > GenericBytes;
   virtual ~midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult : public midw_tundiagfi_tclMsgBaseMessage
{
public:

   midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& operator=(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& coRef);
   midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_u8Result u8AdrContainerResult;
   virtual ~midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
