/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_TUNDIAG_FI message types

fi_tclMessageBase* midw_tundiagfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_tundiagfi_tclToken::EN_MSG_FID_TUN_S_ADR_CONTAINERMETHODSTART:
         return OSAL_NEW midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart;

      case midw_tundiagfi_tclToken::EN_MSG_FID_TUN_S_ADR_CONTAINERMETHODRESULT:
         return OSAL_NEW midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_tundiagfifi messages

// common functions

tU16 midw_tundiagfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_TUNDIAGFI_C_U16_SERVICE_ID;
}

tU16 midw_tundiagfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_tundiagfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_tundiagfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_tundiagfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_tundiagfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_tundiagfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_tundiagfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& coRef)
   : midw_tundiagfi_tclMsgBaseMessage(coRef)
{
   u8DataLength = coRef.u8DataLength;
   GenericBytes = coRef.GenericBytes;
}
midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::operator=(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8DataLength = coRef.u8DataLength;
   GenericBytes = coRef.GenericBytes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::vDestroy()
{
   {
   GenericBytes.clear();
   }
}

midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart()
:u8DataLength(0)

 {}

tS32 midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::s32GetTypeId() const
{
   return (tS32) midw_tundiagfi_tclToken::EN_MSG_FID_TUN_S_ADR_CONTAINERMETHODSTART;
}


midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::~midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(GenericBytes.size()*1);
}

fi_tclInContext& midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8DataLength);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      GenericBytes.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GenericBytes[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8DataLength);
   (tVoid) (oOut << (tU32)GenericBytes.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GenericBytes.size(); ++u32Idx)
         (tVoid) (oOut << GenericBytes[u32Idx]);
   }
   return oOut;
}

tBool midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart::operator==(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8DataLength == roRef.u8DataLength);
      bResult = bResult && (GenericBytes.size() == roRef.GenericBytes.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GenericBytes.size()); ++u32Idx)
            bResult = bResult && (GenericBytes[u32Idx] == roRef.GenericBytes[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& coRef)
   : midw_tundiagfi_tclMsgBaseMessage(coRef)
{
   u8AdrContainerResult = coRef.u8AdrContainerResult;
}
midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::operator=(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& coRef)
{
   if (this == &coRef) return *this;
   u8AdrContainerResult = coRef.u8AdrContainerResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::vDestroy()
{
   u8AdrContainerResult.vDestroy(); 
}

midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult()
:u8AdrContainerResult()
 {}

tS32 midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::s32GetTypeId() const
{
   return (tS32) midw_tundiagfi_tclToken::EN_MSG_FID_TUN_S_ADR_CONTAINERMETHODRESULT;
}


midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::~midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+u8AdrContainerResult.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8AdrContainerResult);
   return oIn;
}

fi_tclOutContext& midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8AdrContainerResult);
   return oOut;
}

tBool midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult::operator==(const midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8AdrContainerResult == roRef.u8AdrContainerResult);
   return bResult;
}

