/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TRAFFICFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TRAFFICFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TRAFFICFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_TRAFFIC_FI message types

fi_tclMessageBase* midw_trafficfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODSTART:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODRESULT:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODSTART:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODRESULT:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODSTART:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODRESULT:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTGET:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTRELUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTSTATUS:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFORELUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOGET:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOSTATUS:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATAUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATARELUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATASTATUS:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATARELUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAGET:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATASTATUS:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEGET:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODERELUPREG:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg;

      case midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODESTATUS:
         return OSAL_NEW midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_trafficfifi messages

// common functions

tU16 midw_trafficfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_TRAFFICFI_C_U16_SERVICE_ID;
}

tU16 midw_trafficfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_trafficfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_trafficfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_trafficfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_trafficfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_trafficfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_trafficfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   u8NumOfRDBID = coRef.u8NumOfRDBID;
   TunRDBID_Value = coRef.TunRDBID_Value;
}
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8NumOfRDBID = coRef.u8NumOfRDBID;
   TunRDBID_Value = coRef.TunRDBID_Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         TunRDBID_Value[u32Idx].vDestroy();
   TunRDBID_Value.clear();
   }
}

midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart()
:u8NumOfRDBID(0)

 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODSTART;
}


midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(TunRDBID_Value.size()*6);
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumOfRDBID);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
      {
         TunRDBID_Value[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunRDBID_Value.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunRDBID_Value[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumOfRDBID);
   (tVoid) (oOut << (tU32)TunRDBID_Value.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         (tVoid) (oOut << TunRDBID_Value[u32Idx]);
   }
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumOfRDBID == roRef.u8NumOfRDBID);
      bResult = bResult && (TunRDBID_Value.size() == roRef.TunRDBID_Value.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunRDBID_Value.size()); ++u32Idx)
            bResult = bResult && (TunRDBID_Value[u32Idx] == roRef.TunRDBID_Value[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   TunRDBID_Value = coRef.TunRDBID_Value;
}
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& coRef)
{
   if (this == &coRef) return *this;
   TunRDBID_Value = coRef.TunRDBID_Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         TunRDBID_Value[u32Idx].vDestroy();
   TunRDBID_Value.clear();
   }
}

midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult()

 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETRDBIDMETHODRESULT;
}


midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TunRDBID_Value.size()*6);
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
      {
         TunRDBID_Value[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TunRDBID_Value.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TunRDBID_Value[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TunRDBID_Value.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TunRDBID_Value.size(); ++u32Idx)
         (tVoid) (oOut << TunRDBID_Value[u32Idx]);
   }
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetRdbidMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TunRDBID_Value.size() == roRef.TunRDBID_Value.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TunRDBID_Value.size()); ++u32Idx)
            bResult = bResult && (TunRDBID_Value[u32Idx] == roRef.TunRDBID_Value[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   u8NumberOfElements = coRef.u8NumberOfElements;
}
midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& coRef)
{
   if (this == &coRef) return *this;
   u8NumberOfElements = coRef.u8NumberOfElements;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart()
:u8NumberOfElements(0)
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODSTART;
}


midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::~midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart()
{}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NumberOfElements);
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NumberOfElements);
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NumberOfElements == roRef.u8NumberOfElements);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
   TpegUriChannelList = coRef.TpegUriChannelList;
}
midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   TpegUriChannelList = coRef.TpegUriChannelList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
         TpegUriChannelList[u32Idx].vDestroy();
   TpegUriChannelList.clear();
   }
}

midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult()
:e8MethodResult()

 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_TPEGURILISTMETHODRESULT;
}


midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::~midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TpegUriChannelList.size(); ++u32ListIdx)
      u32DynamicSize += TpegUriChannelList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+5;
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
      {
         TpegUriChannelList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TpegUriChannelList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TpegUriChannelList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   (tVoid) (oOut << (tU32)TpegUriChannelList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TpegUriChannelList.size(); ++u32Idx)
         (tVoid) (oOut << TpegUriChannelList[u32Idx]);
   }
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_TpegUriListMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
      bResult = bResult && (TpegUriChannelList.size() == roRef.TpegUriChannelList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TpegUriChannelList.size()); ++u32Idx)
            bResult = bResult && (TpegUriChannelList[u32Idx] == roRef.TpegUriChannelList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   bActive = coRef.bActive;
   sTpegUriChn = coRef.sTpegUriChn;
}
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bActive = coRef.bActive;
   sTpegUriChn = coRef.sTpegUriChn;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::vDestroy()
{
   sTpegUriChn.vDestroy(); 
}

midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart()
:bActive(0)
,sTpegUriChn()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODSTART;
}


midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+sTpegUriChn.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bActive);
   (tVoid) (oIn >> sTpegUriChn);
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bActive);
   (tVoid) (oOut << sTpegUriChn);
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bActive == roRef.bActive);
   bResult = bResult && (sTpegUriChn == roRef.sTpegUriChn);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult()
:e8MethodResult()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_S_SETTPEGCHNMETHODRESULT;
}


midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::~midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult()
{}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_S_SetTpegChnMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet::midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTGET;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet::~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListGet()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListUpReg()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTRELUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   ReceptionState = coRef.ReceptionState;
   ListOfRdbIds = coRef.ListOfRdbIds;
}
midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& coRef)
{
   if (this == &coRef) return *this;
   ReceptionState = coRef.ReceptionState;
   ListOfRdbIds = coRef.ListOfRdbIds;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         ListOfRdbIds[u32Idx].vDestroy();
   ListOfRdbIds.clear();
   }
}

midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus()
:ReceptionState()

 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_RDBIDACTUALLISTSTATUS;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::~midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(ListOfRdbIds.size()*6);
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReceptionState);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
      {
         ListOfRdbIds[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListOfRdbIds.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfRdbIds[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReceptionState);
   (tVoid) (oOut << (tU32)ListOfRdbIds.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfRdbIds.size(); ++u32Idx)
         (tVoid) (oOut << ListOfRdbIds[u32Idx]);
   }
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_RdbIdActualListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReceptionState == roRef.ReceptionState);
      bResult = bResult && (ListOfRdbIds.size() == roRef.ListOfRdbIds.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfRdbIds.size()); ++u32Idx)
            bResult = bResult && (ListOfRdbIds[u32Idx] == roRef.ListOfRdbIds[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoUpReg()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFORELUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoRelUpReg()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOGET;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   bTMCAvailableFlag = coRef.bTMCAvailableFlag;
}
midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   bTMCAvailableFlag = coRef.bTMCAvailableFlag;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus()
:bTMCAvailableFlag(0)
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCINFOSTATUS;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus()
{}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bTMCAvailableFlag);
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bTMCAvailableFlag);
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bTMCAvailableFlag == roRef.bTMCAvailableFlag);
   return bResult;
}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATAUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataUpReg()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATARELUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   TpegData = coRef.TpegData;
}
midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& coRef)
{
   if (this == &coRef) return *this;
   TpegData = coRef.TpegData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TpegData.size(); ++u32Idx)
         TpegData[u32Idx].vDestroy();
   TpegData.clear();
   }
}

midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus()

 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TPEGDATASTATUS;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TpegData.size(); ++u32ListIdx)
      u32DynamicSize += TpegData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TpegData.size(); ++u32Idx)
      {
         TpegData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TpegData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TpegData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TpegData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TpegData.size(); ++u32Idx)
         (tVoid) (oOut << TpegData[u32Idx]);
   }
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TpegDataStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TpegData.size() == roRef.TpegData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TpegData.size()); ++u32Idx)
            bResult = bResult && (TpegData[u32Idx] == roRef.TpegData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataUpReg()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATARELUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataRelUpReg()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATAGET;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   ListOfTrafficInfo = coRef.ListOfTrafficInfo;
   CycleStart = coRef.CycleStart;
   RDBId = coRef.RDBId;
   DataForRdbIdComplete = coRef.DataForRdbIdComplete;
   Duplicate = coRef.Duplicate;
}
midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& coRef)
{
   if (this == &coRef) return *this;
   ListOfTrafficInfo = coRef.ListOfTrafficInfo;
   CycleStart = coRef.CycleStart;
   RDBId = coRef.RDBId;
   DataForRdbIdComplete = coRef.DataForRdbIdComplete;
   Duplicate = coRef.Duplicate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
         ListOfTrafficInfo[u32Idx].vDestroy();
   ListOfTrafficInfo.clear();
   }
   RDBId.vDestroy(); 
}

midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus()

:CycleStart(0)
,RDBId()
,DataForRdbIdComplete(0)
,Duplicate(0)
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TMCDATASTATUS;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ListOfTrafficInfo.size(); ++u32ListIdx)
      u32DynamicSize += ListOfTrafficInfo[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+13;
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
      {
         ListOfTrafficInfo[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ListOfTrafficInfo.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ListOfTrafficInfo[u32Idx]);
      }
   }
   (tVoid) (oIn >> CycleStart);
   (tVoid) (oIn >> RDBId);
   (tVoid) (oIn >> DataForRdbIdComplete);
   (tVoid) (oIn >> Duplicate);
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ListOfTrafficInfo.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ListOfTrafficInfo.size(); ++u32Idx)
         (tVoid) (oOut << ListOfTrafficInfo[u32Idx]);
   }
   (tVoid) (oOut << CycleStart);
   (tVoid) (oOut << RDBId);
   (tVoid) (oOut << DataForRdbIdComplete);
   (tVoid) (oOut << Duplicate);
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TmcDataStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ListOfTrafficInfo.size() == roRef.ListOfTrafficInfo.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ListOfTrafficInfo.size()); ++u32Idx)
            bResult = bResult && (ListOfTrafficInfo[u32Idx] == roRef.ListOfTrafficInfo[u32Idx]);
      }
   bResult = bResult && (CycleStart == roRef.CycleStart);
   bResult = bResult && (RDBId == roRef.RDBId);
   bResult = bResult && (DataForRdbIdComplete == roRef.DataForRdbIdComplete);
   bResult = bResult && (Duplicate == roRef.Duplicate);
   return bResult;
}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet::midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEGET;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeGet()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODEUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeUpReg()
{}

//=============================================================================

midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg::midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODERELUPREG;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& coRef)
   : midw_trafficfi_tclMsgBaseMessage(coRef)
{
   TunerState = coRef.TunerState;
   OperationMode = coRef.OperationMode;
   Message = coRef.Message;
}
midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::operator=(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& coRef)
{
   if (this == &coRef) return *this;
   TunerState = coRef.TunerState;
   OperationMode = coRef.OperationMode;
   Message = coRef.Message;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::vDestroy()
{
   Message.vDestroy();
}

midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus()
:TunerState()
,OperationMode()
,Message()
 {}

tS32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::s32GetTypeId() const
{
   return (tS32) midw_trafficfi_tclToken::EN_MSG_FID_TRAFFIC_G_TUNERSTATEANDMODESTATUS;
}


midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::~midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Message.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TunerState);
   (tVoid) (oIn >> OperationMode);
   (tVoid) (oIn >> Message);
   return oIn;
}

fi_tclOutContext& midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TunerState);
   (tVoid) (oOut << OperationMode);
   (tVoid) (oOut << Message);
   return oOut;
}

tBool midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus::operator==(const midw_trafficfi_tclMsgFID_TRAFFIC_G_TunerStateAndModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TunerState == roRef.TunerState);
   bResult = bResult && (OperationMode == roRef.OperationMode);
   bResult = bResult && (Message == roRef.Message);
   return bResult;
}

