/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_TPEGFITYPES_HEADER
#define MIDW_TPEGFITYPES_HEADER


class midw_tpegfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for MIDW_TPEG_FI message types

fi_tclMessageBase* midw_tpegfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_tpegfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_tpegfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_tpegfi_tclMsgStreamInformationGet : public midw_tpegfi_tclMsgBaseMessage
{
public:

   midw_tpegfi_tclMsgStreamInformationGet();

   virtual ~midw_tpegfi_tclMsgStreamInformationGet();

   inline tBool operator==(const midw_tpegfi_tclMsgStreamInformationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tpegfi_tclMsgStreamInformationUpReg : public midw_tpegfi_tclMsgBaseMessage
{
public:

   midw_tpegfi_tclMsgStreamInformationUpReg();

   virtual ~midw_tpegfi_tclMsgStreamInformationUpReg();

   inline tBool operator==(const midw_tpegfi_tclMsgStreamInformationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tpegfi_tclMsgStreamInformationRelUpReg : public midw_tpegfi_tclMsgBaseMessage
{
public:

   midw_tpegfi_tclMsgStreamInformationRelUpReg();

   virtual ~midw_tpegfi_tclMsgStreamInformationRelUpReg();

   inline tBool operator==(const midw_tpegfi_tclMsgStreamInformationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_tpegfi_tclMsgStreamInformationStatus : public midw_tpegfi_tclMsgBaseMessage
{
public:

   midw_tpegfi_tclMsgStreamInformationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_tpegfi_tclMsgStreamInformationStatus& operator=(const midw_tpegfi_tclMsgStreamInformationStatus& coRef);
   midw_tpegfi_tclMsgStreamInformationStatus(const midw_tpegfi_tclMsgStreamInformationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_TpegStreamInfo, std::allocator<midw_fi_tcl_TpegStreamInfo> > listOfStreamInfo;
   tU32 MsgsPerFrame;
   tU32 ACIDPerFrame;
   virtual ~midw_tpegfi_tclMsgStreamInformationStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_tpegfi_tclMsgStreamInformationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
