/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_STREAMROUTERFITYPES_HEADER
#define MIDW_STREAMROUTERFITYPES_HEADER


class midw_streamrouterfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_streamrouter_fi message types

fi_tclMessageBase* midw_streamrouterfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_streamrouterfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_streamrouterfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_streamrouterfi_tclMsgAllocateRouteMethodStart : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgAllocateRouteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgAllocateRouteMethodStart& operator=(const midw_streamrouterfi_tclMsgAllocateRouteMethodStart& coRef);
   midw_streamrouterfi_tclMsgAllocateRouteMethodStart(const midw_streamrouterfi_tclMsgAllocateRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   tS32 s32STM_MsgBufID;
   tU16 u16Sink;
   virtual ~midw_streamrouterfi_tclMsgAllocateRouteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgAllocateRouteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgAllocateRouteMethodResult : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgAllocateRouteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgAllocateRouteMethodResult& operator=(const midw_streamrouterfi_tclMsgAllocateRouteMethodResult& coRef);
   midw_streamrouterfi_tclMsgAllocateRouteMethodResult(const midw_streamrouterfi_tclMsgAllocateRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   tU32 u32STM_MsgBufID;
   tU16 u16MOSTConnectionLabel;
   tU16 u16MLBChannelAddress;
   tU8 u8BlkWidth;
   tU32 u32SmHandle;
   midw_fi_tcl_streamrouter_device_list listInputDev;
   midw_fi_tcl_streamrouter_device_list listOutputDev;
   virtual ~midw_streamrouterfi_tclMsgAllocateRouteMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgAllocateRouteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& operator=(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& coRef);
   midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   virtual ~midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& operator=(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& coRef);
   midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   virtual ~midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgDeAllocateRouteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgSetPlayMethodStart : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgSetPlayMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgSetPlayMethodStart& operator=(const midw_streamrouterfi_tclMsgSetPlayMethodStart& coRef);
   midw_streamrouterfi_tclMsgSetPlayMethodStart(const midw_streamrouterfi_tclMsgSetPlayMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   midw_fi_tcl_e8_streamrouter_ramptype eRampType;
   virtual ~midw_streamrouterfi_tclMsgSetPlayMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgSetPlayMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgSetPlayMethodResult : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgSetPlayMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgSetPlayMethodResult& operator=(const midw_streamrouterfi_tclMsgSetPlayMethodResult& coRef);
   midw_streamrouterfi_tclMsgSetPlayMethodResult(const midw_streamrouterfi_tclMsgSetPlayMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   virtual ~midw_streamrouterfi_tclMsgSetPlayMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgSetPlayMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgSetStopMethodStart : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgSetStopMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgSetStopMethodStart& operator=(const midw_streamrouterfi_tclMsgSetStopMethodStart& coRef);
   midw_streamrouterfi_tclMsgSetStopMethodStart(const midw_streamrouterfi_tclMsgSetStopMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   midw_fi_tcl_e8_streamrouter_ramptype eRampType;
   virtual ~midw_streamrouterfi_tclMsgSetStopMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgSetStopMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgSetStopMethodResult : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgSetStopMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgSetStopMethodResult& operator=(const midw_streamrouterfi_tclMsgSetStopMethodResult& coRef);
   midw_streamrouterfi_tclMsgSetStopMethodResult(const midw_streamrouterfi_tclMsgSetStopMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   virtual ~midw_streamrouterfi_tclMsgSetStopMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgSetStopMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgSendFGCommandMethodStart : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgSendFGCommandMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgSendFGCommandMethodStart& operator=(const midw_streamrouterfi_tclMsgSendFGCommandMethodStart& coRef);
   midw_streamrouterfi_tclMsgSendFGCommandMethodStart(const midw_streamrouterfi_tclMsgSendFGCommandMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   tU16 u16FGRouteID;
   midw_fi_tcl_e8_streamrouter_fgcommand eCmd;
   virtual ~midw_streamrouterfi_tclMsgSendFGCommandMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgSendFGCommandMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgSendFGCommandMethodResult : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgSendFGCommandMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgSendFGCommandMethodResult& operator=(const midw_streamrouterfi_tclMsgSendFGCommandMethodResult& coRef);
   midw_streamrouterfi_tclMsgSendFGCommandMethodResult(const midw_streamrouterfi_tclMsgSendFGCommandMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16UCID;
   virtual ~midw_streamrouterfi_tclMsgSendFGCommandMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgSendFGCommandMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgRoutingStateUpReg : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgRoutingStateUpReg();

   virtual ~midw_streamrouterfi_tclMsgRoutingStateUpReg();

   inline tBool operator==(const midw_streamrouterfi_tclMsgRoutingStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgRoutingStateRelUpReg : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgRoutingStateRelUpReg();

   virtual ~midw_streamrouterfi_tclMsgRoutingStateRelUpReg();

   inline tBool operator==(const midw_streamrouterfi_tclMsgRoutingStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgRoutingStateGet : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgRoutingStateGet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgRoutingStateGet& operator=(const midw_streamrouterfi_tclMsgRoutingStateGet& coRef);
   midw_streamrouterfi_tclMsgRoutingStateGet(const midw_streamrouterfi_tclMsgRoutingStateGet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 s32UCID;
   virtual ~midw_streamrouterfi_tclMsgRoutingStateGet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgRoutingStateGet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_streamrouterfi_tclMsgRoutingStateStatus : public midw_streamrouterfi_tclMsgBaseMessage
{
public:

   midw_streamrouterfi_tclMsgRoutingStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_streamrouterfi_tclMsgRoutingStateStatus& operator=(const midw_streamrouterfi_tclMsgRoutingStateStatus& coRef);
   midw_streamrouterfi_tclMsgRoutingStateStatus(const midw_streamrouterfi_tclMsgRoutingStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_streamrouter_routing_list routing_list;
   virtual ~midw_streamrouterfi_tclMsgRoutingStateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_streamrouterfi_tclMsgRoutingStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
