/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_MASCFFITYPES_HEADER
#define MIDW_MASCFFITYPES_HEADER


class midw_mascffi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_mascf_fi message types

fi_tclMessageBase* midw_mascffi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_mascffi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_mascffi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_mascffi_tclMsgVolumeModeMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeModeMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeModeMethodStart& operator=(const midw_mascffi_tclMsgVolumeModeMethodStart& coRef);
   midw_mascffi_tclMsgVolumeModeMethodStart(const midw_mascffi_tclMsgVolumeModeMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VolumeMode VolumeMode;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgVolumeModeMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeModeMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeModeMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeModeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeModeMethodResult& operator=(const midw_mascffi_tclMsgVolumeModeMethodResult& coRef);
   midw_mascffi_tclMsgVolumeModeMethodResult(const midw_mascffi_tclMsgVolumeModeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~midw_mascffi_tclMsgVolumeModeMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeModeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBeepMethodStart& operator=(const midw_mascffi_tclMsgBeepMethodStart& coRef);
   midw_mascffi_tclMsgBeepMethodStart(const midw_mascffi_tclMsgBeepMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioBeepType BeepType;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgBeepMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBeepMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBeepMethodResult& operator=(const midw_mascffi_tclMsgBeepMethodResult& coRef);
   midw_mascffi_tclMsgBeepMethodResult(const midw_mascffi_tclMsgBeepMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~midw_mascffi_tclMsgBeepMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBeepMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepFileMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepFileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBeepFileMethodStart& operator=(const midw_mascffi_tclMsgBeepFileMethodStart& coRef);
   midw_mascffi_tclMsgBeepFileMethodStart(const midw_mascffi_tclMsgBeepFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sFilePath;
   midw_fi_tcl_BeepConfig oConfig;
   virtual ~midw_mascffi_tclMsgBeepFileMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBeepFileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepFileMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepFileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBeepFileMethodResult& operator=(const midw_mascffi_tclMsgBeepFileMethodResult& coRef);
   midw_mascffi_tclMsgBeepFileMethodResult(const midw_mascffi_tclMsgBeepFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   tU32 u32Token;
   virtual ~midw_mascffi_tclMsgBeepFileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBeepFileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& operator=(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& coRef);
   midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString sFilePath;
   midw_fi_tcl_BeepConfig oConfig;
   tU8 u8BeepAction;
   virtual ~midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& operator=(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& coRef);
   midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   tU32 u32Token;
   virtual ~midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMuteMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMuteMethodStart& operator=(const midw_mascffi_tclMsgMuteMethodStart& coRef);
   midw_mascffi_tclMsgMuteMethodStart(const midw_mascffi_tclMsgMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MuteRequester Requester;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8MuteAction State;
   midw_fi_tcl_b32MuteReason Reason;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMuteMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMuteMethodResult& operator=(const midw_mascffi_tclMsgMuteMethodResult& coRef);
   midw_mascffi_tclMsgMuteMethodResult(const midw_mascffi_tclMsgMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MuteRequester Requester;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_MuteState State;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSet_Mute_RampMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSet_Mute_RampMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSet_Mute_RampMethodStart& operator=(const midw_mascffi_tclMsgSet_Mute_RampMethodStart& coRef);
   midw_mascffi_tclMsgSet_Mute_RampMethodStart(const midw_mascffi_tclMsgSet_Mute_RampMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8MuteSpeed State;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgSet_Mute_RampMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSet_Mute_RampMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSet_Mute_RampMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSet_Mute_RampMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSet_Mute_RampMethodResult& operator=(const midw_mascffi_tclMsgSet_Mute_RampMethodResult& coRef);
   midw_mascffi_tclMsgSet_Mute_RampMethodResult(const midw_mascffi_tclMsgSet_Mute_RampMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~midw_mascffi_tclMsgSet_Mute_RampMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSet_Mute_RampMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioSourceMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioSourceMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioSourceMethodStart& operator=(const midw_mascffi_tclMsgAudioSourceMethodStart& coRef);
   midw_mascffi_tclMsgAudioSourceMethodStart(const midw_mascffi_tclMsgAudioSourceMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudSource Source;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgAudioSourceMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioSourceMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioSourceMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioSourceMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioSourceMethodResult& operator=(const midw_mascffi_tclMsgAudioSourceMethodResult& coRef);
   midw_mascffi_tclMsgAudioSourceMethodResult(const midw_mascffi_tclMsgAudioSourceMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~midw_mascffi_tclMsgAudioSourceMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioSourceMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& operator=(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& coRef);
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   midw_fi_tcl_e8_RouteNo Source;
   midw_fi_tclString AudProcAdev;
   tU32 MsgHandle;
   midw_fi_tcl_e8_OnGoingAction Action;
   virtual ~midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& operator=(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& coRef);
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   tU32 MsgHandle;
   virtual ~midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioTestToneMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioTestToneMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioTestToneMethodStart& operator=(const midw_mascffi_tclMsgAudioTestToneMethodStart& coRef);
   midw_mascffi_tclMsgAudioTestToneMethodStart(const midw_mascffi_tclMsgAudioTestToneMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_ChannelSelect ChannelSelect;
   tU32 Frequency;
   midw_fi_tcl_Volume Volume;
   virtual ~midw_mascffi_tclMsgAudioTestToneMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioTestToneMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioTestToneMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioTestToneMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioTestToneMethodResult& operator=(const midw_mascffi_tclMsgAudioTestToneMethodResult& coRef);
   midw_mascffi_tclMsgAudioTestToneMethodResult(const midw_mascffi_tclMsgAudioTestToneMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_b8_ChannelSelect ChannelSelect;
   midw_fi_tcl_e8_Aud_TestToneControl Status;
   virtual ~midw_mascffi_tclMsgAudioTestToneMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioTestToneMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgCueStateMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgCueStateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgCueStateMethodStart& operator=(const midw_mascffi_tclMsgCueStateMethodStart& coRef);
   midw_mascffi_tclMsgCueStateMethodStart(const midw_mascffi_tclMsgCueStateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_State State;
   midw_fi_tcl_e8_AudSource Source;
   virtual ~midw_mascffi_tclMsgCueStateMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgCueStateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgCueStateMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgCueStateMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgCueStateMethodResult& operator=(const midw_mascffi_tclMsgCueStateMethodResult& coRef);
   midw_mascffi_tclMsgCueStateMethodResult(const midw_mascffi_tclMsgCueStateMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~midw_mascffi_tclMsgCueStateMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgCueStateMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart();

   virtual ~midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart();

   inline tBool operator==(const midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& operator=(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& coRef);
   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagMode DC_Mode;
   midw_fi_tcl_e8_DiagMode AC_Mode;
   virtual ~midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& operator=(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& coRef);
   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagState Status;
   virtual ~midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSystemMuteMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSystemMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSystemMuteMethodStart& operator=(const midw_mascffi_tclMsgSystemMuteMethodStart& coRef);
   midw_mascffi_tclMsgSystemMuteMethodStart(const midw_mascffi_tclMsgSystemMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MuteRequester Requester;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8MuteAction State;
   midw_fi_tcl_b32MuteReason Reason;
   virtual ~midw_mascffi_tclMsgSystemMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSystemMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSystemMuteMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSystemMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSystemMuteMethodResult& operator=(const midw_mascffi_tclMsgSystemMuteMethodResult& coRef);
   midw_mascffi_tclMsgSystemMuteMethodResult(const midw_mascffi_tclMsgSystemMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MuteRequester Requester;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_MuteState State;
   virtual ~midw_mascffi_tclMsgSystemMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSystemMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_SettingSoundMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_SettingSoundMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_SettingSoundMethodStart& operator=(const midw_mascffi_tclMsgADAS_SettingSoundMethodStart& coRef);
   midw_mascffi_tclMsgADAS_SettingSoundMethodStart(const midw_mascffi_tclMsgADAS_SettingSoundMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ADAS_Setting_Sound SettingSound;
   virtual ~midw_mascffi_tclMsgADAS_SettingSoundMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_SettingSoundMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_SettingSoundMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_SettingSoundMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_SettingSoundMethodResult& operator=(const midw_mascffi_tclMsgADAS_SettingSoundMethodResult& coRef);
   midw_mascffi_tclMsgADAS_SettingSoundMethodResult(const midw_mascffi_tclMsgADAS_SettingSoundMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioServiceStatus ServiceStatus;
   virtual ~midw_mascffi_tclMsgADAS_SettingSoundMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_SettingSoundMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEntertainmentMuteMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEntertainmentMuteMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEntertainmentMuteMethodStart& operator=(const midw_mascffi_tclMsgEntertainmentMuteMethodStart& coRef);
   midw_mascffi_tclMsgEntertainmentMuteMethodStart(const midw_mascffi_tclMsgEntertainmentMuteMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MuteRequester Requester;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8MuteAction State;
   midw_fi_tcl_b32MuteReason Reason;
   virtual ~midw_mascffi_tclMsgEntertainmentMuteMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEntertainmentMuteMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEntertainmentMuteMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEntertainmentMuteMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEntertainmentMuteMethodResult& operator=(const midw_mascffi_tclMsgEntertainmentMuteMethodResult& coRef);
   midw_mascffi_tclMsgEntertainmentMuteMethodResult(const midw_mascffi_tclMsgEntertainmentMuteMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_MuteRequester Requester;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_MuteState State;
   virtual ~midw_mascffi_tclMsgEntertainmentMuteMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEntertainmentMuteMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart();

   virtual ~midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart();

   inline tBool operator==(const midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult();

   virtual ~midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult();

   inline tBool operator==(const midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeModeStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeModeStatusUpReg();

   virtual ~midw_mascffi_tclMsgVolumeModeStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeModeStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeModeStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeModeStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgVolumeModeStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeModeStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeModeStatusGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeModeStatusGet();

   virtual ~midw_mascffi_tclMsgVolumeModeStatusGet();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeModeStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeModeStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeModeStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeModeStatusStatus& operator=(const midw_mascffi_tclMsgVolumeModeStatusStatus& coRef);
   midw_mascffi_tclMsgVolumeModeStatusStatus(const midw_mascffi_tclMsgVolumeModeStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VolumeMode VolumeMode;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgVolumeModeStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeModeStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeUpReg();

   virtual ~midw_mascffi_tclMsgVolumeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeRelUpReg();

   virtual ~midw_mascffi_tclMsgVolumeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeGet();

   virtual ~midw_mascffi_tclMsgVolumeGet();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeSet& operator=(const midw_mascffi_tclMsgVolumeSet& coRef);
   midw_mascffi_tclMsgVolumeSet(const midw_mascffi_tclMsgVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioVolumeType VolumeType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tU8 Volume;
   virtual ~midw_mascffi_tclMsgVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeStatus& operator=(const midw_mascffi_tclMsgVolumeStatus& coRef);
   midw_mascffi_tclMsgVolumeStatus(const midw_mascffi_tclMsgVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VolumeMode VolumeMode;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   tU8 Volume;
   midw_fi_tcl_e8_AudSource Source;
   virtual ~midw_mascffi_tclMsgVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepStatusUpReg();

   virtual ~midw_mascffi_tclMsgBeepStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBeepStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgBeepStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBeepStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBeepStatusStatus& operator=(const midw_mascffi_tclMsgBeepStatusStatus& coRef);
   midw_mascffi_tclMsgBeepStatusStatus(const midw_mascffi_tclMsgBeepStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioBeepStatus BeepStatus;
   tU32 u32Token;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgBeepStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBeepStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGalaUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGalaUpReg();

   virtual ~midw_mascffi_tclMsgGalaUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgGalaUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGalaRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGalaRelUpReg();

   virtual ~midw_mascffi_tclMsgGalaRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgGalaRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGalaGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGalaGet();

   virtual ~midw_mascffi_tclMsgGalaGet();

   inline tBool operator==(const midw_mascffi_tclMsgGalaGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGalaSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGalaSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgGalaSet& operator=(const midw_mascffi_tclMsgGalaSet& coRef);
   midw_mascffi_tclMsgGalaSet(const midw_mascffi_tclMsgGalaSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_GalaLevel GalaLevel;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgGalaSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgGalaSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGalaStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGalaStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgGalaStatus& operator=(const midw_mascffi_tclMsgGalaStatus& coRef);
   midw_mascffi_tclMsgGalaStatus(const midw_mascffi_tclMsgGalaStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_GalaLevel GalaLevel;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgGalaStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgGalaStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRemoveWelcomeSoundUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRemoveWelcomeSoundUpReg();

   virtual ~midw_mascffi_tclMsgRemoveWelcomeSoundUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRemoveWelcomeSoundUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRemoveWelcomeSoundGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRemoveWelcomeSoundGet();

   virtual ~midw_mascffi_tclMsgRemoveWelcomeSoundGet();

   inline tBool operator==(const midw_mascffi_tclMsgRemoveWelcomeSoundGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRemoveWelcomeSoundSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRemoveWelcomeSoundSet();

   virtual ~midw_mascffi_tclMsgRemoveWelcomeSoundSet();

   inline tBool operator==(const midw_mascffi_tclMsgRemoveWelcomeSoundSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRemoveWelcomeSoundStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRemoveWelcomeSoundStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRemoveWelcomeSoundStatus& operator=(const midw_mascffi_tclMsgRemoveWelcomeSoundStatus& coRef);
   midw_mascffi_tclMsgRemoveWelcomeSoundStatus(const midw_mascffi_tclMsgRemoveWelcomeSoundStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 updatestatus;
   virtual ~midw_mascffi_tclMsgRemoveWelcomeSoundStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRemoveWelcomeSoundStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBalanceUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBalanceUpReg();

   virtual ~midw_mascffi_tclMsgBalanceUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBalanceUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBalanceRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBalanceRelUpReg();

   virtual ~midw_mascffi_tclMsgBalanceRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBalanceRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBalanceGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBalanceGet();

   virtual ~midw_mascffi_tclMsgBalanceGet();

   inline tBool operator==(const midw_mascffi_tclMsgBalanceGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBalanceSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBalanceSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBalanceSet& operator=(const midw_mascffi_tclMsgBalanceSet& coRef);
   midw_mascffi_tclMsgBalanceSet(const midw_mascffi_tclMsgBalanceSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS8 Balance;
   virtual ~midw_mascffi_tclMsgBalanceSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBalanceSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBalanceStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBalanceStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBalanceStatus& operator=(const midw_mascffi_tclMsgBalanceStatus& coRef);
   midw_mascffi_tclMsgBalanceStatus(const midw_mascffi_tclMsgBalanceStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Balance;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgBalanceStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBalanceStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLoudnessUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLoudnessUpReg();

   virtual ~midw_mascffi_tclMsgLoudnessUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgLoudnessUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLoudnessRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLoudnessRelUpReg();

   virtual ~midw_mascffi_tclMsgLoudnessRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgLoudnessRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLoudnessGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLoudnessGet();

   virtual ~midw_mascffi_tclMsgLoudnessGet();

   inline tBool operator==(const midw_mascffi_tclMsgLoudnessGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLoudnessSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLoudnessSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgLoudnessSet& operator=(const midw_mascffi_tclMsgLoudnessSet& coRef);
   midw_mascffi_tclMsgLoudnessSet(const midw_mascffi_tclMsgLoudnessSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tU8 Loudness;
   virtual ~midw_mascffi_tclMsgLoudnessSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgLoudnessSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLoudnessStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLoudnessStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgLoudnessStatus& operator=(const midw_mascffi_tclMsgLoudnessStatus& coRef);
   midw_mascffi_tclMsgLoudnessStatus(const midw_mascffi_tclMsgLoudnessStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Loudness;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgLoudnessStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgLoudnessStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBassUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBassUpReg();

   virtual ~midw_mascffi_tclMsgBassUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBassUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBassRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBassRelUpReg();

   virtual ~midw_mascffi_tclMsgBassRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBassRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBassGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBassGet();

   virtual ~midw_mascffi_tclMsgBassGet();

   inline tBool operator==(const midw_mascffi_tclMsgBassGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBassSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBassSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBassSet& operator=(const midw_mascffi_tclMsgBassSet& coRef);
   midw_mascffi_tclMsgBassSet(const midw_mascffi_tclMsgBassSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS8 Bass;
   virtual ~midw_mascffi_tclMsgBassSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBassSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBassStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBassStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBassStatus& operator=(const midw_mascffi_tclMsgBassStatus& coRef);
   midw_mascffi_tclMsgBassStatus(const midw_mascffi_tclMsgBassStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Bass;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgBassStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBassStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgTrebleUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgTrebleUpReg();

   virtual ~midw_mascffi_tclMsgTrebleUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgTrebleUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgTrebleRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgTrebleRelUpReg();

   virtual ~midw_mascffi_tclMsgTrebleRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgTrebleRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgTrebleGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgTrebleGet();

   virtual ~midw_mascffi_tclMsgTrebleGet();

   inline tBool operator==(const midw_mascffi_tclMsgTrebleGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgTrebleSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgTrebleSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgTrebleSet& operator=(const midw_mascffi_tclMsgTrebleSet& coRef);
   midw_mascffi_tclMsgTrebleSet(const midw_mascffi_tclMsgTrebleSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS8 Treble;
   virtual ~midw_mascffi_tclMsgTrebleSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgTrebleSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgTrebleStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgTrebleStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgTrebleStatus& operator=(const midw_mascffi_tclMsgTrebleStatus& coRef);
   midw_mascffi_tclMsgTrebleStatus(const midw_mascffi_tclMsgTrebleStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Treble;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgTrebleStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgTrebleStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderUpReg();

   virtual ~midw_mascffi_tclMsgFaderUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgFaderUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderRelUpReg();

   virtual ~midw_mascffi_tclMsgFaderRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgFaderRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderGet();

   virtual ~midw_mascffi_tclMsgFaderGet();

   inline tBool operator==(const midw_mascffi_tclMsgFaderGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgFaderSet& operator=(const midw_mascffi_tclMsgFaderSet& coRef);
   midw_mascffi_tclMsgFaderSet(const midw_mascffi_tclMsgFaderSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS8 Fader;
   virtual ~midw_mascffi_tclMsgFaderSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgFaderSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgFaderStatus& operator=(const midw_mascffi_tclMsgFaderStatus& coRef);
   midw_mascffi_tclMsgFaderStatus(const midw_mascffi_tclMsgFaderStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Fader;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgFaderStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgFaderStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMidRangeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMidRangeUpReg();

   virtual ~midw_mascffi_tclMsgMidRangeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMidRangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMidRangeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMidRangeRelUpReg();

   virtual ~midw_mascffi_tclMsgMidRangeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMidRangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMidRangeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMidRangeGet();

   virtual ~midw_mascffi_tclMsgMidRangeGet();

   inline tBool operator==(const midw_mascffi_tclMsgMidRangeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMidRangeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMidRangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMidRangeSet& operator=(const midw_mascffi_tclMsgMidRangeSet& coRef);
   midw_mascffi_tclMsgMidRangeSet(const midw_mascffi_tclMsgMidRangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS8 MidRange;
   virtual ~midw_mascffi_tclMsgMidRangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMidRangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMidRangeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMidRangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMidRangeStatus& operator=(const midw_mascffi_tclMsgMidRangeStatus& coRef);
   midw_mascffi_tclMsgMidRangeStatus(const midw_mascffi_tclMsgMidRangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 MidRange;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgMidRangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMidRangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMemSoundUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMemSoundUpReg();

   virtual ~midw_mascffi_tclMsgMemSoundUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMemSoundUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMemSoundRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMemSoundRelUpReg();

   virtual ~midw_mascffi_tclMsgMemSoundRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMemSoundRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMemSoundSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMemSoundSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMemSoundSet& operator=(const midw_mascffi_tclMsgMemSoundSet& coRef);
   midw_mascffi_tclMsgMemSoundSet(const midw_mascffi_tclMsgMemSoundSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Sound Sound;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgMemSoundSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMemSoundSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMemSoundStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMemSoundStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMemSoundStatus& operator=(const midw_mascffi_tclMsgMemSoundStatus& coRef);
   midw_mascffi_tclMsgMemSoundStatus(const midw_mascffi_tclMsgMemSoundStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Sound Sound;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_MemStatus MemStatus;
   virtual ~midw_mascffi_tclMsgMemSoundStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMemSoundStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderActivationStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderActivationStatusUpReg();

   virtual ~midw_mascffi_tclMsgFaderActivationStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgFaderActivationStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderActivationStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderActivationStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgFaderActivationStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgFaderActivationStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderActivationStatusGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderActivationStatusGet();

   virtual ~midw_mascffi_tclMsgFaderActivationStatusGet();

   inline tBool operator==(const midw_mascffi_tclMsgFaderActivationStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFaderActivationStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFaderActivationStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgFaderActivationStatusStatus& operator=(const midw_mascffi_tclMsgFaderActivationStatusStatus& coRef);
   midw_mascffi_tclMsgFaderActivationStatusStatus(const midw_mascffi_tclMsgFaderActivationStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_FaderStatus FaderStatus;
   virtual ~midw_mascffi_tclMsgFaderActivationStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgFaderActivationStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDynamicCompressionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDynamicCompressionUpReg();

   virtual ~midw_mascffi_tclMsgDynamicCompressionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDynamicCompressionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDynamicCompressionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDynamicCompressionRelUpReg();

   virtual ~midw_mascffi_tclMsgDynamicCompressionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDynamicCompressionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDynamicCompressionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDynamicCompressionGet();

   virtual ~midw_mascffi_tclMsgDynamicCompressionGet();

   inline tBool operator==(const midw_mascffi_tclMsgDynamicCompressionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDynamicCompressionSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDynamicCompressionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgDynamicCompressionSet& operator=(const midw_mascffi_tclMsgDynamicCompressionSet& coRef);
   midw_mascffi_tclMsgDynamicCompressionSet(const midw_mascffi_tclMsgDynamicCompressionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DynCompression DynComp;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgDynamicCompressionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgDynamicCompressionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDynamicCompressionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDynamicCompressionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgDynamicCompressionStatus& operator=(const midw_mascffi_tclMsgDynamicCompressionStatus& coRef);
   midw_mascffi_tclMsgDynamicCompressionStatus(const midw_mascffi_tclMsgDynamicCompressionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DynCompression DynCompression;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgDynamicCompressionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgDynamicCompressionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOptimizationUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOptimizationUpReg();

   virtual ~midw_mascffi_tclMsgOptimizationUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgOptimizationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOptimizationRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOptimizationRelUpReg();

   virtual ~midw_mascffi_tclMsgOptimizationRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgOptimizationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOptimizationGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOptimizationGet();

   virtual ~midw_mascffi_tclMsgOptimizationGet();

   inline tBool operator==(const midw_mascffi_tclMsgOptimizationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOptimizationSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOptimizationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgOptimizationSet& operator=(const midw_mascffi_tclMsgOptimizationSet& coRef);
   midw_mascffi_tclMsgOptimizationSet(const midw_mascffi_tclMsgOptimizationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Optimization Optimization;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgOptimizationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgOptimizationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOptimizationStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOptimizationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgOptimizationStatus& operator=(const midw_mascffi_tclMsgOptimizationStatus& coRef);
   midw_mascffi_tclMsgOptimizationStatus(const midw_mascffi_tclMsgOptimizationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Optimization Optimization;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgOptimizationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgOptimizationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEqualiserPresetUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEqualiserPresetUpReg();

   virtual ~midw_mascffi_tclMsgEqualiserPresetUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgEqualiserPresetUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEqualiserPresetRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEqualiserPresetRelUpReg();

   virtual ~midw_mascffi_tclMsgEqualiserPresetRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgEqualiserPresetRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEqualiserPresetGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEqualiserPresetGet();

   virtual ~midw_mascffi_tclMsgEqualiserPresetGet();

   inline tBool operator==(const midw_mascffi_tclMsgEqualiserPresetGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEqualiserPresetSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEqualiserPresetSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEqualiserPresetSet& operator=(const midw_mascffi_tclMsgEqualiserPresetSet& coRef);
   midw_mascffi_tclMsgEqualiserPresetSet(const midw_mascffi_tclMsgEqualiserPresetSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EquPresets EquPreset;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgEqualiserPresetSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEqualiserPresetSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEqualiserPresetStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEqualiserPresetStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEqualiserPresetStatus& operator=(const midw_mascffi_tclMsgEqualiserPresetStatus& coRef);
   midw_mascffi_tclMsgEqualiserPresetStatus(const midw_mascffi_tclMsgEqualiserPresetStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_EquPresets EquPreset;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgEqualiserPresetStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEqualiserPresetStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagAudModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagAudModeUpReg();

   virtual ~midw_mascffi_tclMsgDiagAudModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDiagAudModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagAudModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagAudModeRelUpReg();

   virtual ~midw_mascffi_tclMsgDiagAudModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDiagAudModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagAudModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagAudModeGet();

   virtual ~midw_mascffi_tclMsgDiagAudModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgDiagAudModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagAudModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagAudModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgDiagAudModeSet& operator=(const midw_mascffi_tclMsgDiagAudModeSet& coRef);
   midw_mascffi_tclMsgDiagAudModeSet(const midw_mascffi_tclMsgDiagAudModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagAudMode DiagAudMode;
   midw_fi_tcl_e8_GenericDiagAudMode OnVolLimiterMode;
   midw_fi_tcl_e8_GenericDiagAudMode MuteRampMode;
   midw_fi_tcl_e8_GenericDiagAudMode VolumeRampMode;
   midw_fi_tcl_e8_GenericDiagAudMode clippingMode;
   midw_fi_tcl_e8_GenericDiagAudMode PresetMode;
   virtual ~midw_mascffi_tclMsgDiagAudModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgDiagAudModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagAudModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagAudModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgDiagAudModeStatus& operator=(const midw_mascffi_tclMsgDiagAudModeStatus& coRef);
   midw_mascffi_tclMsgDiagAudModeStatus(const midw_mascffi_tclMsgDiagAudModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_DiagAudMode DiagAudMode;
   midw_fi_tcl_e8_GenericDiagAudMode OnVolLimiterMode;
   midw_fi_tcl_e8_GenericDiagAudMode MuteRampMode;
   midw_fi_tcl_e8_GenericDiagAudMode VolumeRampMode;
   midw_fi_tcl_e8_GenericDiagAudMode clippingMode;
   midw_fi_tcl_e8_GenericDiagAudMode PresetMode;
   virtual ~midw_mascffi_tclMsgDiagAudModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgDiagAudModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAuxInLevelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAuxInLevelUpReg();

   virtual ~midw_mascffi_tclMsgAuxInLevelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAuxInLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAuxInLevelRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAuxInLevelRelUpReg();

   virtual ~midw_mascffi_tclMsgAuxInLevelRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAuxInLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAuxInLevelGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAuxInLevelGet();

   virtual ~midw_mascffi_tclMsgAuxInLevelGet();

   inline tBool operator==(const midw_mascffi_tclMsgAuxInLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAuxInLevelSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAuxInLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAuxInLevelSet& operator=(const midw_mascffi_tclMsgAuxInLevelSet& coRef);
   midw_mascffi_tclMsgAuxInLevelSet(const midw_mascffi_tclMsgAuxInLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AuxInLevel AuxInLevel;
   virtual ~midw_mascffi_tclMsgAuxInLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAuxInLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAuxInLevelStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAuxInLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAuxInLevelStatus& operator=(const midw_mascffi_tclMsgAuxInLevelStatus& coRef);
   midw_mascffi_tclMsgAuxInLevelStatus(const midw_mascffi_tclMsgAuxInLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AuxInLevel AuxInLevel;
   virtual ~midw_mascffi_tclMsgAuxInLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAuxInLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepLevelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepLevelUpReg();

   virtual ~midw_mascffi_tclMsgBeepLevelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBeepLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepLevelRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepLevelRelUpReg();

   virtual ~midw_mascffi_tclMsgBeepLevelRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBeepLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepLevelGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepLevelGet();

   virtual ~midw_mascffi_tclMsgBeepLevelGet();

   inline tBool operator==(const midw_mascffi_tclMsgBeepLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepLevelSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBeepLevelSet& operator=(const midw_mascffi_tclMsgBeepLevelSet& coRef);
   midw_mascffi_tclMsgBeepLevelSet(const midw_mascffi_tclMsgBeepLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_BeepLevel BeepLevel;
   virtual ~midw_mascffi_tclMsgBeepLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBeepLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBeepLevelStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBeepLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBeepLevelStatus& operator=(const midw_mascffi_tclMsgBeepLevelStatus& coRef);
   midw_mascffi_tclMsgBeepLevelStatus(const midw_mascffi_tclMsgBeepLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_BeepLevel BeepLevel;
   virtual ~midw_mascffi_tclMsgBeepLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBeepLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRear_MuteUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRear_MuteUpReg();

   virtual ~midw_mascffi_tclMsgRear_MuteUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRear_MuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRear_MuteRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRear_MuteRelUpReg();

   virtual ~midw_mascffi_tclMsgRear_MuteRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRear_MuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRear_MuteGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRear_MuteGet();

   virtual ~midw_mascffi_tclMsgRear_MuteGet();

   inline tBool operator==(const midw_mascffi_tclMsgRear_MuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRear_MuteSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRear_MuteSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRear_MuteSet& operator=(const midw_mascffi_tclMsgRear_MuteSet& coRef);
   midw_mascffi_tclMsgRear_MuteSet(const midw_mascffi_tclMsgRear_MuteSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Rear_Mute Rear_Mute;
   virtual ~midw_mascffi_tclMsgRear_MuteSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRear_MuteSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRear_MuteStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRear_MuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRear_MuteStatus& operator=(const midw_mascffi_tclMsgRear_MuteStatus& coRef);
   midw_mascffi_tclMsgRear_MuteStatus(const midw_mascffi_tclMsgRear_MuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Rear_Mute Rear_Mute;
   virtual ~midw_mascffi_tclMsgRear_MuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRear_MuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeometry_ModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeometry_ModeUpReg();

   virtual ~midw_mascffi_tclMsgGeometry_ModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgGeometry_ModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeometry_ModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeometry_ModeRelUpReg();

   virtual ~midw_mascffi_tclMsgGeometry_ModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgGeometry_ModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeometry_ModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeometry_ModeGet();

   virtual ~midw_mascffi_tclMsgGeometry_ModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgGeometry_ModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeometry_ModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeometry_ModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgGeometry_ModeSet& operator=(const midw_mascffi_tclMsgGeometry_ModeSet& coRef);
   midw_mascffi_tclMsgGeometry_ModeSet(const midw_mascffi_tclMsgGeometry_ModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Geometry_Mode Geometry_Mode;
   virtual ~midw_mascffi_tclMsgGeometry_ModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgGeometry_ModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeometry_ModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeometry_ModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgGeometry_ModeStatus& operator=(const midw_mascffi_tclMsgGeometry_ModeStatus& coRef);
   midw_mascffi_tclMsgGeometry_ModeStatus(const midw_mascffi_tclMsgGeometry_ModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_Geometry_Mode Geometry_Mode;
   virtual ~midw_mascffi_tclMsgGeometry_ModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgGeometry_ModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLSValueStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLSValueStatusUpReg();

   virtual ~midw_mascffi_tclMsgLSValueStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgLSValueStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLSValueStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLSValueStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgLSValueStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgLSValueStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLSValueStatusGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLSValueStatusGet();

   virtual ~midw_mascffi_tclMsgLSValueStatusGet();

   inline tBool operator==(const midw_mascffi_tclMsgLSValueStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgLSValueStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgLSValueStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgLSValueStatusStatus& operator=(const midw_mascffi_tclMsgLSValueStatusStatus& coRef);
   midw_mascffi_tclMsgLSValueStatusStatus(const midw_mascffi_tclMsgLSValueStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8NaviSetupLs;
   virtual ~midw_mascffi_tclMsgLSValueStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgLSValueStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationLevelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationLevelUpReg();

   virtual ~midw_mascffi_tclMsgPDCAttenuationLevelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgPDCAttenuationLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg();

   virtual ~midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationLevelGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationLevelGet();

   virtual ~midw_mascffi_tclMsgPDCAttenuationLevelGet();

   inline tBool operator==(const midw_mascffi_tclMsgPDCAttenuationLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationLevelSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgPDCAttenuationLevelSet& operator=(const midw_mascffi_tclMsgPDCAttenuationLevelSet& coRef);
   midw_mascffi_tclMsgPDCAttenuationLevelSet(const midw_mascffi_tclMsgPDCAttenuationLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PDCAttenutionLevel;
   virtual ~midw_mascffi_tclMsgPDCAttenuationLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgPDCAttenuationLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationLevelStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgPDCAttenuationLevelStatus& operator=(const midw_mascffi_tclMsgPDCAttenuationLevelStatus& coRef);
   midw_mascffi_tclMsgPDCAttenuationLevelStatus(const midw_mascffi_tclMsgPDCAttenuationLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 PDCAttenuationLevel;
   virtual ~midw_mascffi_tclMsgPDCAttenuationLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgPDCAttenuationLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationUpReg();

   virtual ~midw_mascffi_tclMsgPDCAttenuationUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgPDCAttenuationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationRelUpReg();

   virtual ~midw_mascffi_tclMsgPDCAttenuationRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgPDCAttenuationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationGet();

   virtual ~midw_mascffi_tclMsgPDCAttenuationGet();

   inline tBool operator==(const midw_mascffi_tclMsgPDCAttenuationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgPDCAttenuationSet& operator=(const midw_mascffi_tclMsgPDCAttenuationSet& coRef);
   midw_mascffi_tclMsgPDCAttenuationSet(const midw_mascffi_tclMsgPDCAttenuationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_PDCAttenuation PDCAttenuationCommand;
   virtual ~midw_mascffi_tclMsgPDCAttenuationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgPDCAttenuationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPDCAttenuationStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPDCAttenuationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgPDCAttenuationStatus& operator=(const midw_mascffi_tclMsgPDCAttenuationStatus& coRef);
   midw_mascffi_tclMsgPDCAttenuationStatus(const midw_mascffi_tclMsgPDCAttenuationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_PDCAttenuation PDCAttenuation;
   virtual ~midw_mascffi_tclMsgPDCAttenuationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgPDCAttenuationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioDeviceStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioDeviceStatusUpReg();

   virtual ~midw_mascffi_tclMsgAudioDeviceStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioDeviceStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioDeviceStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioDeviceStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgAudioDeviceStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioDeviceStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioDeviceStatusGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioDeviceStatusGet();

   virtual ~midw_mascffi_tclMsgAudioDeviceStatusGet();

   inline tBool operator==(const midw_mascffi_tclMsgAudioDeviceStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioDeviceStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioDeviceStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioDeviceStatusStatus& operator=(const midw_mascffi_tclMsgAudioDeviceStatusStatus& coRef);
   midw_mascffi_tclMsgAudioDeviceStatusStatus(const midw_mascffi_tclMsgAudioDeviceStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioDevice_Availability AudioDeviceAvailability;
   virtual ~midw_mascffi_tclMsgAudioDeviceStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioDeviceStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempReductionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempReductionUpReg();

   virtual ~midw_mascffi_tclMsgOverTempReductionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgOverTempReductionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempReductionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempReductionRelUpReg();

   virtual ~midw_mascffi_tclMsgOverTempReductionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgOverTempReductionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempReductionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempReductionGet();

   virtual ~midw_mascffi_tclMsgOverTempReductionGet();

   inline tBool operator==(const midw_mascffi_tclMsgOverTempReductionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempReductionSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempReductionSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgOverTempReductionSet& operator=(const midw_mascffi_tclMsgOverTempReductionSet& coRef);
   midw_mascffi_tclMsgOverTempReductionSet(const midw_mascffi_tclMsgOverTempReductionSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DownScaling_Active;
   tU8 ReductionInterval;
   virtual ~midw_mascffi_tclMsgOverTempReductionSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgOverTempReductionSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempReductionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempReductionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgOverTempReductionStatus& operator=(const midw_mascffi_tclMsgOverTempReductionStatus& coRef);
   midw_mascffi_tclMsgOverTempReductionStatus(const midw_mascffi_tclMsgOverTempReductionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ActiveByCommand;
   tBool ActiveByAmplifier;
   tU8 CurrentFactor;
   tU8 ReductionInterval;
   virtual ~midw_mascffi_tclMsgOverTempReductionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgOverTempReductionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempAmplifierStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempAmplifierStatusUpReg();

   virtual ~midw_mascffi_tclMsgOverTempAmplifierStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgOverTempAmplifierStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempAmplifierStatusGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempAmplifierStatusGet();

   virtual ~midw_mascffi_tclMsgOverTempAmplifierStatusGet();

   inline tBool operator==(const midw_mascffi_tclMsgOverTempAmplifierStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgOverTempAmplifierStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgOverTempAmplifierStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgOverTempAmplifierStatusStatus& operator=(const midw_mascffi_tclMsgOverTempAmplifierStatusStatus& coRef);
   midw_mascffi_tclMsgOverTempAmplifierStatusStatus(const midw_mascffi_tclMsgOverTempAmplifierStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AmpTemperatureLevel AmpTemperatureLevel;
   virtual ~midw_mascffi_tclMsgOverTempAmplifierStatusStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgOverTempAmplifierStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgReadMeasurementResultUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgReadMeasurementResultUpReg();

   virtual ~midw_mascffi_tclMsgReadMeasurementResultUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgReadMeasurementResultUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgReadMeasurementResultRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgReadMeasurementResultRelUpReg();

   virtual ~midw_mascffi_tclMsgReadMeasurementResultRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgReadMeasurementResultRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgReadMeasurementResultGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgReadMeasurementResultGet();

   virtual ~midw_mascffi_tclMsgReadMeasurementResultGet();

   inline tBool operator==(const midw_mascffi_tclMsgReadMeasurementResultGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgReadMeasurementResultStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgReadMeasurementResultStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgReadMeasurementResultStatus& operator=(const midw_mascffi_tclMsgReadMeasurementResultStatus& coRef);
   midw_mascffi_tclMsgReadMeasurementResultStatus(const midw_mascffi_tclMsgReadMeasurementResultStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_Aud_MeasurementResultItem, std::allocator<midw_fi_tcl_Aud_MeasurementResultItem> > MeasurementResultList;
   virtual ~midw_mascffi_tclMsgReadMeasurementResultStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgReadMeasurementResultStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgCenterUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgCenterUpReg();

   virtual ~midw_mascffi_tclMsgCenterUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgCenterUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgCenterRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgCenterRelUpReg();

   virtual ~midw_mascffi_tclMsgCenterRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgCenterRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgCenterGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgCenterGet();

   virtual ~midw_mascffi_tclMsgCenterGet();

   inline tBool operator==(const midw_mascffi_tclMsgCenterGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgCenterSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgCenterSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgCenterSet& operator=(const midw_mascffi_tclMsgCenterSet& coRef);
   midw_mascffi_tclMsgCenterSet(const midw_mascffi_tclMsgCenterSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS16 Center;
   virtual ~midw_mascffi_tclMsgCenterSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgCenterSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgCenterStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgCenterStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgCenterStatus& operator=(const midw_mascffi_tclMsgCenterStatus& coRef);
   midw_mascffi_tclMsgCenterStatus(const midw_mascffi_tclMsgCenterStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 Center;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgCenterStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgCenterStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSubWooferUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSubWooferUpReg();

   virtual ~midw_mascffi_tclMsgSubWooferUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSubWooferUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSubWooferRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSubWooferRelUpReg();

   virtual ~midw_mascffi_tclMsgSubWooferRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSubWooferRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSubWooferGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSubWooferGet();

   virtual ~midw_mascffi_tclMsgSubWooferGet();

   inline tBool operator==(const midw_mascffi_tclMsgSubWooferGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSubWooferSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSubWooferSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSubWooferSet& operator=(const midw_mascffi_tclMsgSubWooferSet& coRef);
   midw_mascffi_tclMsgSubWooferSet(const midw_mascffi_tclMsgSubWooferSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS16 SubWoofer;
   virtual ~midw_mascffi_tclMsgSubWooferSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSubWooferSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSubWooferStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSubWooferStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSubWooferStatus& operator=(const midw_mascffi_tclMsgSubWooferStatus& coRef);
   midw_mascffi_tclMsgSubWooferStatus(const midw_mascffi_tclMsgSubWooferStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 SubWoofer;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgSubWooferStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSubWooferStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg();

   virtual ~midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg();

   virtual ~midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgExternalAmplifierConnectionStateGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgExternalAmplifierConnectionStateGet();

   virtual ~midw_mascffi_tclMsgExternalAmplifierConnectionStateGet();

   inline tBool operator==(const midw_mascffi_tclMsgExternalAmplifierConnectionStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& operator=(const midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& coRef);
   midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus(const midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool ConnectionState;
   virtual ~midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeneralSpeakerTestUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeneralSpeakerTestUpReg();

   virtual ~midw_mascffi_tclMsgGeneralSpeakerTestUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgGeneralSpeakerTestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg();

   virtual ~midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeneralSpeakerTestGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeneralSpeakerTestGet();

   virtual ~midw_mascffi_tclMsgGeneralSpeakerTestGet();

   inline tBool operator==(const midw_mascffi_tclMsgGeneralSpeakerTestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeneralSpeakerTestSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeneralSpeakerTestSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgGeneralSpeakerTestSet& operator=(const midw_mascffi_tclMsgGeneralSpeakerTestSet& coRef);
   midw_mascffi_tclMsgGeneralSpeakerTestSet(const midw_mascffi_tclMsgGeneralSpeakerTestSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Request;
   virtual ~midw_mascffi_tclMsgGeneralSpeakerTestSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgGeneralSpeakerTestSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgGeneralSpeakerTestStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgGeneralSpeakerTestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgGeneralSpeakerTestStatus& operator=(const midw_mascffi_tclMsgGeneralSpeakerTestStatus& coRef);
   midw_mascffi_tclMsgGeneralSpeakerTestStatus(const midw_mascffi_tclMsgGeneralSpeakerTestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SpeakerValue_1;
   tU8 SpeakerValue_2;
   tU8 SpeakerValue_3;
   tU8 SpeakerValue_4;
   tU8 SpeakerValue_5;
   virtual ~midw_mascffi_tclMsgGeneralSpeakerTestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgGeneralSpeakerTestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCSWVersionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCSWVersionUpReg();

   virtual ~midw_mascffi_tclMsgANCSWVersionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCSWVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCSWVersionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCSWVersionRelUpReg();

   virtual ~midw_mascffi_tclMsgANCSWVersionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCSWVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCSWVersionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCSWVersionGet();

   virtual ~midw_mascffi_tclMsgANCSWVersionGet();

   inline tBool operator==(const midw_mascffi_tclMsgANCSWVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCSWVersionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCSWVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgANCSWVersionStatus& operator=(const midw_mascffi_tclMsgANCSWVersionStatus& coRef);
   midw_mascffi_tclMsgANCSWVersionStatus(const midw_mascffi_tclMsgANCSWVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LargeVersion;
   tU8 MiddleVersion;
   tU8 SmallVersion;
   virtual ~midw_mascffi_tclMsgANCSWVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgANCSWVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgASCSWVersionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgASCSWVersionUpReg();

   virtual ~midw_mascffi_tclMsgASCSWVersionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgASCSWVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgASCSWVersionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgASCSWVersionRelUpReg();

   virtual ~midw_mascffi_tclMsgASCSWVersionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgASCSWVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgASCSWVersionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgASCSWVersionGet();

   virtual ~midw_mascffi_tclMsgASCSWVersionGet();

   inline tBool operator==(const midw_mascffi_tclMsgASCSWVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgASCSWVersionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgASCSWVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgASCSWVersionStatus& operator=(const midw_mascffi_tclMsgASCSWVersionStatus& coRef);
   midw_mascffi_tclMsgASCSWVersionStatus(const midw_mascffi_tclMsgASCSWVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LargeVersion;
   tU8 MiddleVersion;
   tU8 SmallVersion;
   virtual ~midw_mascffi_tclMsgASCSWVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgASCSWVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSettingUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSettingUpReg();

   virtual ~midw_mascffi_tclMsgANCASCSettingUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSettingRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSettingRelUpReg();

   virtual ~midw_mascffi_tclMsgANCASCSettingRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSettingGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSettingGet();

   virtual ~midw_mascffi_tclMsgANCASCSettingGet();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSettingSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgANCASCSettingSet& operator=(const midw_mascffi_tclMsgANCASCSettingSet& coRef);
   midw_mascffi_tclMsgANCASCSettingSet(const midw_mascffi_tclMsgANCASCSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ANCAvailability;
   tU8 ASCAvailability;
   virtual ~midw_mascffi_tclMsgANCASCSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgANCASCSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSettingStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgANCASCSettingStatus& operator=(const midw_mascffi_tclMsgANCASCSettingStatus& coRef);
   midw_mascffi_tclMsgANCASCSettingStatus(const midw_mascffi_tclMsgANCASCSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 ANCAvailability;
   tU8 ASCAvailability;
   virtual ~midw_mascffi_tclMsgANCASCSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgANCASCSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpSoftwareVersionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpSoftwareVersionUpReg();

   virtual ~midw_mascffi_tclMsgAmpSoftwareVersionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpSoftwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg();

   virtual ~midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpSoftwareVersionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpSoftwareVersionGet();

   virtual ~midw_mascffi_tclMsgAmpSoftwareVersionGet();

   inline tBool operator==(const midw_mascffi_tclMsgAmpSoftwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpSoftwareVersionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpSoftwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpSoftwareVersionStatus& operator=(const midw_mascffi_tclMsgAmpSoftwareVersionStatus& coRef);
   midw_mascffi_tclMsgAmpSoftwareVersionStatus(const midw_mascffi_tclMsgAmpSoftwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LowerVersion;
   tU8 MiddleVersion;
   tU8 HigherVersion;
   virtual ~midw_mascffi_tclMsgAmpSoftwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpSoftwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpParameterVersionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpParameterVersionUpReg();

   virtual ~midw_mascffi_tclMsgAmpParameterVersionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpParameterVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpParameterVersionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpParameterVersionRelUpReg();

   virtual ~midw_mascffi_tclMsgAmpParameterVersionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpParameterVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpParameterVersionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpParameterVersionGet();

   virtual ~midw_mascffi_tclMsgAmpParameterVersionGet();

   inline tBool operator==(const midw_mascffi_tclMsgAmpParameterVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpParameterVersionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpParameterVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpParameterVersionStatus& operator=(const midw_mascffi_tclMsgAmpParameterVersionStatus& coRef);
   midw_mascffi_tclMsgAmpParameterVersionStatus(const midw_mascffi_tclMsgAmpParameterVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LowerVersion;
   tU8 MiddleVersion;
   tU8 HigherVersion;
   virtual ~midw_mascffi_tclMsgAmpParameterVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpParameterVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpHardwareVersionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpHardwareVersionUpReg();

   virtual ~midw_mascffi_tclMsgAmpHardwareVersionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpHardwareVersionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpHardwareVersionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpHardwareVersionRelUpReg();

   virtual ~midw_mascffi_tclMsgAmpHardwareVersionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpHardwareVersionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpHardwareVersionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpHardwareVersionGet();

   virtual ~midw_mascffi_tclMsgAmpHardwareVersionGet();

   inline tBool operator==(const midw_mascffi_tclMsgAmpHardwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpHardwareVersionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpHardwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpHardwareVersionStatus& operator=(const midw_mascffi_tclMsgAmpHardwareVersionStatus& coRef);
   midw_mascffi_tclMsgAmpHardwareVersionStatus(const midw_mascffi_tclMsgAmpHardwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LowerVersion;
   tU8 MiddleVersion;
   tU8 HigherVersion;
   virtual ~midw_mascffi_tclMsgAmpHardwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpHardwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundVolUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundVolUpReg();

   virtual ~midw_mascffi_tclMsgSurroundVolUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundVolUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundVolRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundVolRelUpReg();

   virtual ~midw_mascffi_tclMsgSurroundVolRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundVolRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundVolGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundVolGet();

   virtual ~midw_mascffi_tclMsgSurroundVolGet();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundVolGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundVolSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundVolSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSurroundVolSet& operator=(const midw_mascffi_tclMsgSurroundVolSet& coRef);
   midw_mascffi_tclMsgSurroundVolSet(const midw_mascffi_tclMsgSurroundVolSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioSoundType SoundType;
   midw_fi_tcl_e8_ResourceNo Resource;
   tS8 SurroundVol;
   virtual ~midw_mascffi_tclMsgSurroundVolSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSurroundVolSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundVolStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundVolStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSurroundVolStatus& operator=(const midw_mascffi_tclMsgSurroundVolStatus& coRef);
   midw_mascffi_tclMsgSurroundVolStatus(const midw_mascffi_tclMsgSurroundVolStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 SurroundVol;
   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_e8_AudioChannel Channel;
   virtual ~midw_mascffi_tclMsgSurroundVolStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSurroundVolStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotModeUpReg();

   virtual ~midw_mascffi_tclMsgAudioPilotModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioPilotModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotModeRelUpReg();

   virtual ~midw_mascffi_tclMsgAudioPilotModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioPilotModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotModeGet();

   virtual ~midw_mascffi_tclMsgAudioPilotModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgAudioPilotModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioPilotModeSet& operator=(const midw_mascffi_tclMsgAudioPilotModeSet& coRef);
   midw_mascffi_tclMsgAudioPilotModeSet(const midw_mascffi_tclMsgAudioPilotModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AudPilotMode;
   virtual ~midw_mascffi_tclMsgAudioPilotModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioPilotModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioPilotModeStatus& operator=(const midw_mascffi_tclMsgAudioPilotModeStatus& coRef);
   midw_mascffi_tclMsgAudioPilotModeStatus(const midw_mascffi_tclMsgAudioPilotModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AudPilotMode;
   virtual ~midw_mascffi_tclMsgAudioPilotModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioPilotModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundModeUpReg();

   virtual ~midw_mascffi_tclMsgSurroundModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundModeRelUpReg();

   virtual ~midw_mascffi_tclMsgSurroundModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundModeGet();

   virtual ~midw_mascffi_tclMsgSurroundModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSurroundModeSet& operator=(const midw_mascffi_tclMsgSurroundModeSet& coRef);
   midw_mascffi_tclMsgSurroundModeSet(const midw_mascffi_tclMsgSurroundModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SurroundMode;
   virtual ~midw_mascffi_tclMsgSurroundModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSurroundModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSurroundModeStatus& operator=(const midw_mascffi_tclMsgSurroundModeStatus& coRef);
   midw_mascffi_tclMsgSurroundModeStatus(const midw_mascffi_tclMsgSurroundModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SurroundMode;
   virtual ~midw_mascffi_tclMsgSurroundModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSurroundModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpDownMixModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpDownMixModeUpReg();

   virtual ~midw_mascffi_tclMsgAmpDownMixModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpDownMixModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpDownMixModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpDownMixModeRelUpReg();

   virtual ~midw_mascffi_tclMsgAmpDownMixModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpDownMixModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpDownMixModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpDownMixModeGet();

   virtual ~midw_mascffi_tclMsgAmpDownMixModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgAmpDownMixModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpDownMixModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpDownMixModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpDownMixModeSet& operator=(const midw_mascffi_tclMsgAmpDownMixModeSet& coRef);
   midw_mascffi_tclMsgAmpDownMixModeSet(const midw_mascffi_tclMsgAmpDownMixModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AmpDownMixMode;
   virtual ~midw_mascffi_tclMsgAmpDownMixModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpDownMixModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpDownMixModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpDownMixModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpDownMixModeStatus& operator=(const midw_mascffi_tclMsgAmpDownMixModeStatus& coRef);
   midw_mascffi_tclMsgAmpDownMixModeStatus(const midw_mascffi_tclMsgAmpDownMixModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AmpDownMixMode;
   virtual ~midw_mascffi_tclMsgAmpDownMixModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpDownMixModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDriverSoundModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDriverSoundModeUpReg();

   virtual ~midw_mascffi_tclMsgDriverSoundModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDriverSoundModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDriverSoundModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDriverSoundModeRelUpReg();

   virtual ~midw_mascffi_tclMsgDriverSoundModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDriverSoundModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDriverSoundModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDriverSoundModeGet();

   virtual ~midw_mascffi_tclMsgDriverSoundModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgDriverSoundModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDriverSoundModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDriverSoundModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgDriverSoundModeSet& operator=(const midw_mascffi_tclMsgDriverSoundModeSet& coRef);
   midw_mascffi_tclMsgDriverSoundModeSet(const midw_mascffi_tclMsgDriverSoundModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DriverMode;
   virtual ~midw_mascffi_tclMsgDriverSoundModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgDriverSoundModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDriverSoundModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDriverSoundModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgDriverSoundModeStatus& operator=(const midw_mascffi_tclMsgDriverSoundModeStatus& coRef);
   midw_mascffi_tclMsgDriverSoundModeStatus(const midw_mascffi_tclMsgDriverSoundModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool DriverMode;
   virtual ~midw_mascffi_tclMsgDriverSoundModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgDriverSoundModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRearSoundModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRearSoundModeUpReg();

   virtual ~midw_mascffi_tclMsgRearSoundModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRearSoundModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRearSoundModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRearSoundModeRelUpReg();

   virtual ~midw_mascffi_tclMsgRearSoundModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRearSoundModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRearSoundModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRearSoundModeGet();

   virtual ~midw_mascffi_tclMsgRearSoundModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgRearSoundModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRearSoundModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRearSoundModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRearSoundModeSet& operator=(const midw_mascffi_tclMsgRearSoundModeSet& coRef);
   midw_mascffi_tclMsgRearSoundModeSet(const midw_mascffi_tclMsgRearSoundModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RearMode;
   virtual ~midw_mascffi_tclMsgRearSoundModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRearSoundModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRearSoundModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRearSoundModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRearSoundModeStatus& operator=(const midw_mascffi_tclMsgRearSoundModeStatus& coRef);
   midw_mascffi_tclMsgRearSoundModeStatus(const midw_mascffi_tclMsgRearSoundModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RearMode;
   virtual ~midw_mascffi_tclMsgRearSoundModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRearSoundModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioOFFMuteStateUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioOFFMuteStateUpReg();

   virtual ~midw_mascffi_tclMsgAudioOFFMuteStateUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioOFFMuteStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg();

   virtual ~midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioOFFMuteStateSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioOFFMuteStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioOFFMuteStateSet& operator=(const midw_mascffi_tclMsgAudioOFFMuteStateSet& coRef);
   midw_mascffi_tclMsgAudioOFFMuteStateSet(const midw_mascffi_tclMsgAudioOFFMuteStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MuteState;
   virtual ~midw_mascffi_tclMsgAudioOFFMuteStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioOFFMuteStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioOFFMuteStateStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioOFFMuteStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioOFFMuteStateStatus& operator=(const midw_mascffi_tclMsgAudioOFFMuteStateStatus& coRef);
   midw_mascffi_tclMsgAudioOFFMuteStateStatus(const midw_mascffi_tclMsgAudioOFFMuteStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MuteState;
   virtual ~midw_mascffi_tclMsgAudioOFFMuteStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioOFFMuteStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg();

   virtual ~midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMicrophoneConnectionStatusGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMicrophoneConnectionStatusGet();

   virtual ~midw_mascffi_tclMsgMicrophoneConnectionStatusGet();

   inline tBool operator==(const midw_mascffi_tclMsgMicrophoneConnectionStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMicrophoneConnectionStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMicrophoneConnectionStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& operator=(const midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& coRef);
   midw_mascffi_tclMsgMicrophoneConnectionStatusStatus(const midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_MicrophoneConnectionStatusList MicrophoneConnectionStatusList;
   virtual ~midw_mascffi_tclMsgMicrophoneConnectionStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgConnectionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgConnectionUpReg();

   virtual ~midw_mascffi_tclMsgConnectionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgConnectionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgConnectionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgConnectionRelUpReg();

   virtual ~midw_mascffi_tclMsgConnectionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgConnectionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgConnectionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgConnectionGet();

   virtual ~midw_mascffi_tclMsgConnectionGet();

   inline tBool operator==(const midw_mascffi_tclMsgConnectionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgConnectionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgConnectionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgConnectionStatus& operator=(const midw_mascffi_tclMsgConnectionStatus& coRef);
   midw_mascffi_tclMsgConnectionStatus(const midw_mascffi_tclMsgConnectionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<midw_fi_tcl_BOSE_UnitConnectionStatus, std::allocator<midw_fi_tcl_BOSE_UnitConnectionStatus> > arConnectionStatusList;
   virtual ~midw_mascffi_tclMsgConnectionStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgConnectionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeListUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeListUpReg();

   virtual ~midw_mascffi_tclMsgVolumeListUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeListUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeListRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeListRelUpReg();

   virtual ~midw_mascffi_tclMsgVolumeListRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeListRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeListGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeListGet();

   virtual ~midw_mascffi_tclMsgVolumeListGet();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeListGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeListSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeListSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeListSet& operator=(const midw_mascffi_tclMsgVolumeListSet& coRef);
   midw_mascffi_tclMsgVolumeListSet(const midw_mascffi_tclMsgVolumeListSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Aud_VolumeStatusList AudVolumeList;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgVolumeListSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeListSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeListStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeListStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeListStatus& operator=(const midw_mascffi_tclMsgVolumeListStatus& coRef);
   midw_mascffi_tclMsgVolumeListStatus(const midw_mascffi_tclMsgVolumeListStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ResourceNo Resource;
   midw_fi_tcl_Aud_VolumeStatusList AudVolumeList;
   virtual ~midw_mascffi_tclMsgVolumeListStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeListStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBTAudioInLevelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBTAudioInLevelUpReg();

   virtual ~midw_mascffi_tclMsgBTAudioInLevelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBTAudioInLevelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBTAudioInLevelRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBTAudioInLevelRelUpReg();

   virtual ~midw_mascffi_tclMsgBTAudioInLevelRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgBTAudioInLevelRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBTAudioInLevelGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBTAudioInLevelGet();

   virtual ~midw_mascffi_tclMsgBTAudioInLevelGet();

   inline tBool operator==(const midw_mascffi_tclMsgBTAudioInLevelGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBTAudioInLevelSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBTAudioInLevelSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBTAudioInLevelSet& operator=(const midw_mascffi_tclMsgBTAudioInLevelSet& coRef);
   midw_mascffi_tclMsgBTAudioInLevelSet(const midw_mascffi_tclMsgBTAudioInLevelSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_BTAudioInLevel BTAudioInLevel;
   virtual ~midw_mascffi_tclMsgBTAudioInLevelSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBTAudioInLevelSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgBTAudioInLevelStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgBTAudioInLevelStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgBTAudioInLevelStatus& operator=(const midw_mascffi_tclMsgBTAudioInLevelStatus& coRef);
   midw_mascffi_tclMsgBTAudioInLevelStatus(const midw_mascffi_tclMsgBTAudioInLevelStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_BTAudioInLevel BTAudioInLevel;
   virtual ~midw_mascffi_tclMsgBTAudioInLevelStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgBTAudioInLevelStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEngineeringDataUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEngineeringDataUpReg();

   virtual ~midw_mascffi_tclMsgEngineeringDataUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgEngineeringDataUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEngineeringDataRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEngineeringDataRelUpReg();

   virtual ~midw_mascffi_tclMsgEngineeringDataRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgEngineeringDataRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEngineeringDataGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEngineeringDataGet();

   virtual ~midw_mascffi_tclMsgEngineeringDataGet();

   inline tBool operator==(const midw_mascffi_tclMsgEngineeringDataGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEngineeringDataSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEngineeringDataSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEngineeringDataSet& operator=(const midw_mascffi_tclMsgEngineeringDataSet& coRef);
   midw_mascffi_tclMsgEngineeringDataSet(const midw_mascffi_tclMsgEngineeringDataSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Aud_EDStatusList EngineeringDataList;
   virtual ~midw_mascffi_tclMsgEngineeringDataSet();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEngineeringDataSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEngineeringDataStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEngineeringDataStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEngineeringDataStatus& operator=(const midw_mascffi_tclMsgEngineeringDataStatus& coRef);
   midw_mascffi_tclMsgEngineeringDataStatus(const midw_mascffi_tclMsgEngineeringDataStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_Aud_EDStatusList EngineeringDataList;
   virtual ~midw_mascffi_tclMsgEngineeringDataStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEngineeringDataStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundSettingUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundSettingUpReg();

   virtual ~midw_mascffi_tclMsgSurroundSettingUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundSettingUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundSettingRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundSettingRelUpReg();

   virtual ~midw_mascffi_tclMsgSurroundSettingRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundSettingRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundSettingGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundSettingGet();

   virtual ~midw_mascffi_tclMsgSurroundSettingGet();

   inline tBool operator==(const midw_mascffi_tclMsgSurroundSettingGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundSettingSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundSettingSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSurroundSettingSet& operator=(const midw_mascffi_tclMsgSurroundSettingSet& coRef);
   midw_mascffi_tclMsgSurroundSettingSet(const midw_mascffi_tclMsgSurroundSettingSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_SurroundSetting Surround;
   virtual ~midw_mascffi_tclMsgSurroundSettingSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSurroundSettingSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSurroundSettingStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSurroundSettingStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSurroundSettingStatus& operator=(const midw_mascffi_tclMsgSurroundSettingStatus& coRef);
   midw_mascffi_tclMsgSurroundSettingStatus(const midw_mascffi_tclMsgSurroundSettingStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_SurroundSetting Surround;
   virtual ~midw_mascffi_tclMsgSurroundSettingStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSurroundSettingStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeLockUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeLockUpReg();

   virtual ~midw_mascffi_tclMsgVolumeLockUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeLockUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeLockRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeLockRelUpReg();

   virtual ~midw_mascffi_tclMsgVolumeLockRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeLockRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeLockGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeLockGet();

   virtual ~midw_mascffi_tclMsgVolumeLockGet();

   inline tBool operator==(const midw_mascffi_tclMsgVolumeLockGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeLockSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeLockSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeLockSet& operator=(const midw_mascffi_tclMsgVolumeLockSet& coRef);
   midw_mascffi_tclMsgVolumeLockSet(const midw_mascffi_tclMsgVolumeLockSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VolumeLock VolumeLockType;
   midw_fi_tcl_e8_Requester Requester;
   virtual ~midw_mascffi_tclMsgVolumeLockSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeLockSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgVolumeLockStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgVolumeLockStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgVolumeLockStatus& operator=(const midw_mascffi_tclMsgVolumeLockStatus& coRef);
   midw_mascffi_tclMsgVolumeLockStatus(const midw_mascffi_tclMsgVolumeLockStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_VolumeLock VolumeLockType;
   midw_fi_tcl_e8_Requester Requester;
   virtual ~midw_mascffi_tclMsgVolumeLockStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgVolumeLockStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpAvailFunctionUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpAvailFunctionUpReg();

   virtual ~midw_mascffi_tclMsgAmpAvailFunctionUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpAvailFunctionUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpAvailFunctionRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpAvailFunctionRelUpReg();

   virtual ~midw_mascffi_tclMsgAmpAvailFunctionRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAmpAvailFunctionRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpAvailFunctionGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpAvailFunctionGet();

   virtual ~midw_mascffi_tclMsgAmpAvailFunctionGet();

   inline tBool operator==(const midw_mascffi_tclMsgAmpAvailFunctionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAmpAvailFunctionStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAmpAvailFunctionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAmpAvailFunctionStatus& operator=(const midw_mascffi_tclMsgAmpAvailFunctionStatus& coRef);
   midw_mascffi_tclMsgAmpAvailFunctionStatus(const midw_mascffi_tclMsgAmpAvailFunctionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool Bass;
   tBool Middle;
   tBool Treble;
   tBool Balance;
   tBool Fader;
   tBool AudioPilot;
   tBool Gala;
   tBool SurroundMode;
   tBool SubWoofer;
   tBool Staging;
   tBool RoomEffect;
   tBool Loudness;
   tBool AGC;
   tBool AmpDownMix;
   tBool SurroundVol;
   tBool RearSoundMode;
   tBool DriverSoundMode;
   tBool ANC;
   tBool ASC;
   tBool SoundAmbiance;
   tBool ESE;
   virtual ~midw_mascffi_tclMsgAmpAvailFunctionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAmpAvailFunctionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSetAudioPropertyUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSetAudioPropertyUpReg();

   virtual ~midw_mascffi_tclMsgSetAudioPropertyUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSetAudioPropertyUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSetAudioPropertyRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSetAudioPropertyRelUpReg();

   virtual ~midw_mascffi_tclMsgSetAudioPropertyRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSetAudioPropertyRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSetAudioPropertyGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSetAudioPropertyGet();

   virtual ~midw_mascffi_tclMsgSetAudioPropertyGet();

   inline tBool operator==(const midw_mascffi_tclMsgSetAudioPropertyGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSetAudioPropertySet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSetAudioPropertySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSetAudioPropertySet& operator=(const midw_mascffi_tclMsgSetAudioPropertySet& coRef);
   midw_mascffi_tclMsgSetAudioPropertySet(const midw_mascffi_tclMsgSetAudioPropertySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   midw_fi_tcl_e8_AudioProperty u8Property;
   tS32 s32PropValue;
   virtual ~midw_mascffi_tclMsgSetAudioPropertySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSetAudioPropertySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSetAudioPropertyStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSetAudioPropertyStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSetAudioPropertyStatus& operator=(const midw_mascffi_tclMsgSetAudioPropertyStatus& coRef);
   midw_mascffi_tclMsgSetAudioPropertyStatus(const midw_mascffi_tclMsgSetAudioPropertyStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudSource u8Source;
   midw_fi_tcl_e8_AudioProperty u8Property;
   tS32 s32PropValue;
   virtual ~midw_mascffi_tclMsgSetAudioPropertyStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSetAudioPropertyStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEntOnVolumeSetupUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEntOnVolumeSetupUpReg();

   virtual ~midw_mascffi_tclMsgEntOnVolumeSetupUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgEntOnVolumeSetupUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg();

   virtual ~midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEntOnVolumeSetupSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEntOnVolumeSetupSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEntOnVolumeSetupSet& operator=(const midw_mascffi_tclMsgEntOnVolumeSetupSet& coRef);
   midw_mascffi_tclMsgEntOnVolumeSetupSet(const midw_mascffi_tclMsgEntOnVolumeSetupSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LimitValue;
   midw_fi_tcl_e8_AudioSoundType SoundType;
   virtual ~midw_mascffi_tclMsgEntOnVolumeSetupSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEntOnVolumeSetupSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgEntOnVolumeSetupStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgEntOnVolumeSetupStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgEntOnVolumeSetupStatus& operator=(const midw_mascffi_tclMsgEntOnVolumeSetupStatus& coRef);
   midw_mascffi_tclMsgEntOnVolumeSetupStatus(const midw_mascffi_tclMsgEntOnVolumeSetupStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LimitValue;
   virtual ~midw_mascffi_tclMsgEntOnVolumeSetupStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgEntOnVolumeSetupStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg();

   virtual ~midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg();

   virtual ~midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMinimumOnVolumeSetupSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMinimumOnVolumeSetupSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMinimumOnVolumeSetupSet& operator=(const midw_mascffi_tclMsgMinimumOnVolumeSetupSet& coRef);
   midw_mascffi_tclMsgMinimumOnVolumeSetupSet(const midw_mascffi_tclMsgMinimumOnVolumeSetupSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LimitValue;
   midw_fi_tcl_e8_AudioSoundType SoundType;
   virtual ~midw_mascffi_tclMsgMinimumOnVolumeSetupSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMinimumOnVolumeSetupSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMinimumOnVolumeSetupStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMinimumOnVolumeSetupStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& operator=(const midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& coRef);
   midw_mascffi_tclMsgMinimumOnVolumeSetupStatus(const midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 LimitValue;
   virtual ~midw_mascffi_tclMsgMinimumOnVolumeSetupStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRoomEffectUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRoomEffectUpReg();

   virtual ~midw_mascffi_tclMsgRoomEffectUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRoomEffectUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRoomEffectRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRoomEffectRelUpReg();

   virtual ~midw_mascffi_tclMsgRoomEffectRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRoomEffectRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRoomEffectGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRoomEffectGet();

   virtual ~midw_mascffi_tclMsgRoomEffectGet();

   inline tBool operator==(const midw_mascffi_tclMsgRoomEffectGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRoomEffectSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRoomEffectSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRoomEffectSet& operator=(const midw_mascffi_tclMsgRoomEffectSet& coRef);
   midw_mascffi_tclMsgRoomEffectSet(const midw_mascffi_tclMsgRoomEffectSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_RoomEffect RoomEffect;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgRoomEffectSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRoomEffectSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRoomEffectStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRoomEffectStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRoomEffectStatus& operator=(const midw_mascffi_tclMsgRoomEffectStatus& coRef);
   midw_mascffi_tclMsgRoomEffectStatus(const midw_mascffi_tclMsgRoomEffectStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_RoomEffect RoomEffect;
   midw_fi_tcl_e8_ResourceNo Resource;
   virtual ~midw_mascffi_tclMsgRoomEffectStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRoomEffectStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFMEnhancerModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFMEnhancerModeUpReg();

   virtual ~midw_mascffi_tclMsgFMEnhancerModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgFMEnhancerModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFMEnhancerModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFMEnhancerModeRelUpReg();

   virtual ~midw_mascffi_tclMsgFMEnhancerModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgFMEnhancerModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFMEnhancerModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFMEnhancerModeGet();

   virtual ~midw_mascffi_tclMsgFMEnhancerModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgFMEnhancerModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFMEnhancerModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFMEnhancerModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgFMEnhancerModeSet& operator=(const midw_mascffi_tclMsgFMEnhancerModeSet& coRef);
   midw_mascffi_tclMsgFMEnhancerModeSet(const midw_mascffi_tclMsgFMEnhancerModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool FMEnhancer;
   virtual ~midw_mascffi_tclMsgFMEnhancerModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgFMEnhancerModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgFMEnhancerModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgFMEnhancerModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgFMEnhancerModeStatus& operator=(const midw_mascffi_tclMsgFMEnhancerModeStatus& coRef);
   midw_mascffi_tclMsgFMEnhancerModeStatus(const midw_mascffi_tclMsgFMEnhancerModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool FMEnhancer;
   virtual ~midw_mascffi_tclMsgFMEnhancerModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgFMEnhancerModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagDefSetPhaseUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagDefSetPhaseUpReg();

   virtual ~midw_mascffi_tclMsgDiagDefSetPhaseUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDiagDefSetPhaseUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg();

   virtual ~midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagDefSetPhaseGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagDefSetPhaseGet();

   virtual ~midw_mascffi_tclMsgDiagDefSetPhaseGet();

   inline tBool operator==(const midw_mascffi_tclMsgDiagDefSetPhaseGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgDiagDefSetPhaseStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgDiagDefSetPhaseStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgDiagDefSetPhaseStatus& operator=(const midw_mascffi_tclMsgDiagDefSetPhaseStatus& coRef);
   midw_mascffi_tclMsgDiagDefSetPhaseStatus(const midw_mascffi_tclMsgDiagDefSetPhaseStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudDiagDefSetPhase DefSetPhase;
   virtual ~midw_mascffi_tclMsgDiagDefSetPhaseStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgDiagDefSetPhaseStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESESoundTypeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESESoundTypeUpReg();

   virtual ~midw_mascffi_tclMsgESESoundTypeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgESESoundTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESESoundTypeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESESoundTypeRelUpReg();

   virtual ~midw_mascffi_tclMsgESESoundTypeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgESESoundTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESESoundTypeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESESoundTypeGet();

   virtual ~midw_mascffi_tclMsgESESoundTypeGet();

   inline tBool operator==(const midw_mascffi_tclMsgESESoundTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESESoundTypeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESESoundTypeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgESESoundTypeSet& operator=(const midw_mascffi_tclMsgESESoundTypeSet& coRef);
   midw_mascffi_tclMsgESESoundTypeSet(const midw_mascffi_tclMsgESESoundTypeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SoundType;
   virtual ~midw_mascffi_tclMsgESESoundTypeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgESESoundTypeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESESoundTypeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESESoundTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgESESoundTypeStatus& operator=(const midw_mascffi_tclMsgESESoundTypeStatus& coRef);
   midw_mascffi_tclMsgESESoundTypeStatus(const midw_mascffi_tclMsgESESoundTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 SoundType;
   virtual ~midw_mascffi_tclMsgESESoundTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgESESoundTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEVolumeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEVolumeUpReg();

   virtual ~midw_mascffi_tclMsgESEVolumeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgESEVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEVolumeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEVolumeRelUpReg();

   virtual ~midw_mascffi_tclMsgESEVolumeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgESEVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEVolumeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEVolumeGet();

   virtual ~midw_mascffi_tclMsgESEVolumeGet();

   inline tBool operator==(const midw_mascffi_tclMsgESEVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEVolumeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgESEVolumeSet& operator=(const midw_mascffi_tclMsgESEVolumeSet& coRef);
   midw_mascffi_tclMsgESEVolumeSet(const midw_mascffi_tclMsgESEVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~midw_mascffi_tclMsgESEVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgESEVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEVolumeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgESEVolumeStatus& operator=(const midw_mascffi_tclMsgESEVolumeStatus& coRef);
   midw_mascffi_tclMsgESEVolumeStatus(const midw_mascffi_tclMsgESEVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~midw_mascffi_tclMsgESEVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgESEVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundOnOffUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundOnOffUpReg();

   virtual ~midw_mascffi_tclMsgRSoundOnOffUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundOnOffUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundOnOffRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundOnOffRelUpReg();

   virtual ~midw_mascffi_tclMsgRSoundOnOffRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundOnOffRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundOnOffGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundOnOffGet();

   virtual ~midw_mascffi_tclMsgRSoundOnOffGet();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundOnOffGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundOnOffSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundOnOffSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundOnOffSet& operator=(const midw_mascffi_tclMsgRSoundOnOffSet& coRef);
   midw_mascffi_tclMsgRSoundOnOffSet(const midw_mascffi_tclMsgRSoundOnOffSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSound;
   virtual ~midw_mascffi_tclMsgRSoundOnOffSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundOnOffSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundOnOffStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundOnOffStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundOnOffStatus& operator=(const midw_mascffi_tclMsgRSoundOnOffStatus& coRef);
   midw_mascffi_tclMsgRSoundOnOffStatus(const midw_mascffi_tclMsgRSoundOnOffStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSound;
   virtual ~midw_mascffi_tclMsgRSoundOnOffStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundOnOffStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundSoundTypeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundSoundTypeUpReg();

   virtual ~midw_mascffi_tclMsgRSoundSoundTypeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundSoundTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundSoundTypeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundSoundTypeRelUpReg();

   virtual ~midw_mascffi_tclMsgRSoundSoundTypeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundSoundTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundSoundTypeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundSoundTypeGet();

   virtual ~midw_mascffi_tclMsgRSoundSoundTypeGet();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundSoundTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundSoundTypeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundSoundTypeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundSoundTypeSet& operator=(const midw_mascffi_tclMsgRSoundSoundTypeSet& coRef);
   midw_mascffi_tclMsgRSoundSoundTypeSet(const midw_mascffi_tclMsgRSoundSoundTypeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RSoundType;
   virtual ~midw_mascffi_tclMsgRSoundSoundTypeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundSoundTypeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundSoundTypeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundSoundTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundSoundTypeStatus& operator=(const midw_mascffi_tclMsgRSoundSoundTypeStatus& coRef);
   midw_mascffi_tclMsgRSoundSoundTypeStatus(const midw_mascffi_tclMsgRSoundSoundTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 RSoundType;
   virtual ~midw_mascffi_tclMsgRSoundSoundTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundSoundTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundVolumeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundVolumeUpReg();

   virtual ~midw_mascffi_tclMsgRSoundVolumeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundVolumeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundVolumeRelUpReg();

   virtual ~midw_mascffi_tclMsgRSoundVolumeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundVolumeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundVolumeGet();

   virtual ~midw_mascffi_tclMsgRSoundVolumeGet();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundVolumeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundVolumeSet& operator=(const midw_mascffi_tclMsgRSoundVolumeSet& coRef);
   midw_mascffi_tclMsgRSoundVolumeSet(const midw_mascffi_tclMsgRSoundVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~midw_mascffi_tclMsgRSoundVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundVolumeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundVolumeStatus& operator=(const midw_mascffi_tclMsgRSoundVolumeStatus& coRef);
   midw_mascffi_tclMsgRSoundVolumeStatus(const midw_mascffi_tclMsgRSoundVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Volume;
   virtual ~midw_mascffi_tclMsgRSoundVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEDriveModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEDriveModeUpReg();

   virtual ~midw_mascffi_tclMsgESEDriveModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgESEDriveModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEDriveModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEDriveModeRelUpReg();

   virtual ~midw_mascffi_tclMsgESEDriveModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgESEDriveModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEDriveModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEDriveModeGet();

   virtual ~midw_mascffi_tclMsgESEDriveModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgESEDriveModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEDriveModeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEDriveModeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgESEDriveModeSet& operator=(const midw_mascffi_tclMsgESEDriveModeSet& coRef);
   midw_mascffi_tclMsgESEDriveModeSet(const midw_mascffi_tclMsgESEDriveModeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DriveMode;
   virtual ~midw_mascffi_tclMsgESEDriveModeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgESEDriveModeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgESEDriveModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgESEDriveModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgESEDriveModeStatus& operator=(const midw_mascffi_tclMsgESEDriveModeStatus& coRef);
   midw_mascffi_tclMsgESEDriveModeStatus(const midw_mascffi_tclMsgESEDriveModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DriveMode;
   virtual ~midw_mascffi_tclMsgESEDriveModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgESEDriveModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioModeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioModeUpReg();

   virtual ~midw_mascffi_tclMsgAudioModeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioModeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioModeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioModeRelUpReg();

   virtual ~midw_mascffi_tclMsgAudioModeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioModeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioModeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioModeGet();

   virtual ~midw_mascffi_tclMsgAudioModeGet();

   inline tBool operator==(const midw_mascffi_tclMsgAudioModeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioModeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioModeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioModeStatus& operator=(const midw_mascffi_tclMsgAudioModeStatus& coRef);
   midw_mascffi_tclMsgAudioModeStatus(const midw_mascffi_tclMsgAudioModeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioMode AudioMode;
   virtual ~midw_mascffi_tclMsgAudioModeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioModeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPASoundTypeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPASoundTypeUpReg();

   virtual ~midw_mascffi_tclMsgADAS_UPASoundTypeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_UPASoundTypeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg();

   virtual ~midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPASoundTypeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPASoundTypeGet();

   virtual ~midw_mascffi_tclMsgADAS_UPASoundTypeGet();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_UPASoundTypeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPASoundTypeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPASoundTypeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_UPASoundTypeSet& operator=(const midw_mascffi_tclMsgADAS_UPASoundTypeSet& coRef);
   midw_mascffi_tclMsgADAS_UPASoundTypeSet(const midw_mascffi_tclMsgADAS_UPASoundTypeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ADAS_UPA_SoundType SoundType;
   virtual ~midw_mascffi_tclMsgADAS_UPASoundTypeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_UPASoundTypeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPASoundTypeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPASoundTypeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_UPASoundTypeStatus& operator=(const midw_mascffi_tclMsgADAS_UPASoundTypeStatus& coRef);
   midw_mascffi_tclMsgADAS_UPASoundTypeStatus(const midw_mascffi_tclMsgADAS_UPASoundTypeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ADAS_UPA_SoundType SoundType;
   virtual ~midw_mascffi_tclMsgADAS_UPASoundTypeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_UPASoundTypeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg();

   virtual ~midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg();

   virtual ~midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_ParkAssistVolumeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_ParkAssistVolumeGet();

   virtual ~midw_mascffi_tclMsgADAS_ParkAssistVolumeGet();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_ParkAssistVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_ParkAssistVolumeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_ParkAssistVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& operator=(const midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& coRef);
   midw_mascffi_tclMsgADAS_ParkAssistVolumeSet(const midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ADAS_ParkAssist_Volume VolumeLevel;
   virtual ~midw_mascffi_tclMsgADAS_ParkAssistVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& operator=(const midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& coRef);
   midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus(const midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ADAS_ParkAssist_Volume VolumeLevel;
   virtual ~midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPAMuteUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPAMuteUpReg();

   virtual ~midw_mascffi_tclMsgADAS_UPAMuteUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_UPAMuteUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPAMuteRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPAMuteRelUpReg();

   virtual ~midw_mascffi_tclMsgADAS_UPAMuteRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_UPAMuteRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPAMuteGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPAMuteGet();

   virtual ~midw_mascffi_tclMsgADAS_UPAMuteGet();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_UPAMuteGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPAMuteSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPAMuteSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_UPAMuteSet& operator=(const midw_mascffi_tclMsgADAS_UPAMuteSet& coRef);
   midw_mascffi_tclMsgADAS_UPAMuteSet(const midw_mascffi_tclMsgADAS_UPAMuteSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMute;
   virtual ~midw_mascffi_tclMsgADAS_UPAMuteSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_UPAMuteSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_UPAMuteStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_UPAMuteStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_UPAMuteStatus& operator=(const midw_mascffi_tclMsgADAS_UPAMuteStatus& coRef);
   midw_mascffi_tclMsgADAS_UPAMuteStatus(const midw_mascffi_tclMsgADAS_UPAMuteStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bMuted;
   virtual ~midw_mascffi_tclMsgADAS_UPAMuteStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_UPAMuteStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAutomaticGainControlUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAutomaticGainControlUpReg();

   virtual ~midw_mascffi_tclMsgAutomaticGainControlUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAutomaticGainControlUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAutomaticGainControlRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAutomaticGainControlRelUpReg();

   virtual ~midw_mascffi_tclMsgAutomaticGainControlRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAutomaticGainControlRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAutomaticGainControlGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAutomaticGainControlGet();

   virtual ~midw_mascffi_tclMsgAutomaticGainControlGet();

   inline tBool operator==(const midw_mascffi_tclMsgAutomaticGainControlGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAutomaticGainControlSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAutomaticGainControlSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAutomaticGainControlSet& operator=(const midw_mascffi_tclMsgAutomaticGainControlSet& coRef);
   midw_mascffi_tclMsgAutomaticGainControlSet(const midw_mascffi_tclMsgAutomaticGainControlSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AutomaticGainControl;
   virtual ~midw_mascffi_tclMsgAutomaticGainControlSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAutomaticGainControlSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAutomaticGainControlStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAutomaticGainControlStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAutomaticGainControlStatus& operator=(const midw_mascffi_tclMsgAutomaticGainControlStatus& coRef);
   midw_mascffi_tclMsgAutomaticGainControlStatus(const midw_mascffi_tclMsgAutomaticGainControlStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool AutomaticGainControl;
   virtual ~midw_mascffi_tclMsgAutomaticGainControlStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAutomaticGainControlStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg();

   virtual ~midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg();

   virtual ~midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_LDW_UserVolumeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_LDW_UserVolumeGet();

   virtual ~midw_mascffi_tclMsgADAS_LDW_UserVolumeGet();

   inline tBool operator==(const midw_mascffi_tclMsgADAS_LDW_UserVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_LDW_UserVolumeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_LDW_UserVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& operator=(const midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& coRef);
   midw_mascffi_tclMsgADAS_LDW_UserVolumeSet(const midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ADAS_LDW_UserVolume VolumeLevel;
   virtual ~midw_mascffi_tclMsgADAS_LDW_UserVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& operator=(const midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& coRef);
   midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus(const midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_ADAS_LDW_UserVolume VolumeLevel;
   virtual ~midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundActivationUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundActivationUpReg();

   virtual ~midw_mascffi_tclMsgRSoundActivationUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundActivationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundActivationRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundActivationRelUpReg();

   virtual ~midw_mascffi_tclMsgRSoundActivationRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundActivationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundActivationGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundActivationGet();

   virtual ~midw_mascffi_tclMsgRSoundActivationGet();

   inline tBool operator==(const midw_mascffi_tclMsgRSoundActivationGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundActivationSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundActivationSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundActivationSet& operator=(const midw_mascffi_tclMsgRSoundActivationSet& coRef);
   midw_mascffi_tclMsgRSoundActivationSet(const midw_mascffi_tclMsgRSoundActivationSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSoundActive;
   virtual ~midw_mascffi_tclMsgRSoundActivationSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundActivationSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgRSoundActivationStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgRSoundActivationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgRSoundActivationStatus& operator=(const midw_mascffi_tclMsgRSoundActivationStatus& coRef);
   midw_mascffi_tclMsgRSoundActivationStatus(const midw_mascffi_tclMsgRSoundActivationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool RSoundActive;
   virtual ~midw_mascffi_tclMsgRSoundActivationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgRSoundActivationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCActiveTestUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCActiveTestUpReg();

   virtual ~midw_mascffi_tclMsgANCASCActiveTestUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCActiveTestUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCActiveTestRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCActiveTestRelUpReg();

   virtual ~midw_mascffi_tclMsgANCASCActiveTestRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCActiveTestRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCActiveTestGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCActiveTestGet();

   virtual ~midw_mascffi_tclMsgANCASCActiveTestGet();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCActiveTestGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCActiveTestSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCActiveTestSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgANCASCActiveTestSet& operator=(const midw_mascffi_tclMsgANCASCActiveTestSet& coRef);
   midw_mascffi_tclMsgANCASCActiveTestSet(const midw_mascffi_tclMsgANCASCActiveTestSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 Request;
   virtual ~midw_mascffi_tclMsgANCASCActiveTestSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgANCASCActiveTestSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCActiveTestStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCActiveTestStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgANCASCActiveTestStatus& operator=(const midw_mascffi_tclMsgANCASCActiveTestStatus& coRef);
   midw_mascffi_tclMsgANCASCActiveTestStatus(const midw_mascffi_tclMsgANCASCActiveTestStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 TestStatus;
   virtual ~midw_mascffi_tclMsgANCASCActiveTestStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgANCASCActiveTestStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg();

   virtual ~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg();

   virtual ~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet();

   virtual ~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet();

   virtual ~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet();

   inline tBool operator==(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& operator=(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef);
   midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 DiagResultSummary;
   midw_fi_tcl_MicrophoneResult MicrophoneResult;
   tU8 EnginePulse;
   tU8 DoorOpenClose;
   midw_fi_tclString ConfigInformation;
   virtual ~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgUserProfileChangeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgUserProfileChangeUpReg();

   virtual ~midw_mascffi_tclMsgUserProfileChangeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgUserProfileChangeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgUserProfileChangeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgUserProfileChangeRelUpReg();

   virtual ~midw_mascffi_tclMsgUserProfileChangeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgUserProfileChangeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgUserProfileChangeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgUserProfileChangeGet();

   virtual ~midw_mascffi_tclMsgUserProfileChangeGet();

   inline tBool operator==(const midw_mascffi_tclMsgUserProfileChangeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgUserProfileChangeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgUserProfileChangeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgUserProfileChangeSet& operator=(const midw_mascffi_tclMsgUserProfileChangeSet& coRef);
   midw_mascffi_tclMsgUserProfileChangeSet(const midw_mascffi_tclMsgUserProfileChangeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool UserProfileChange;
   virtual ~midw_mascffi_tclMsgUserProfileChangeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgUserProfileChangeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgUserProfileChangeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgUserProfileChangeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgUserProfileChangeStatus& operator=(const midw_mascffi_tclMsgUserProfileChangeStatus& coRef);
   midw_mascffi_tclMsgUserProfileChangeStatus(const midw_mascffi_tclMsgUserProfileChangeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool UserProfileChange;
   virtual ~midw_mascffi_tclMsgUserProfileChangeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgUserProfileChangeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSRSoundNotificationStateUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSRSoundNotificationStateUpReg();

   virtual ~midw_mascffi_tclMsgSRSoundNotificationStateUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSRSoundNotificationStateUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg();

   virtual ~midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSRSoundNotificationStateGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSRSoundNotificationStateGet();

   virtual ~midw_mascffi_tclMsgSRSoundNotificationStateGet();

   inline tBool operator==(const midw_mascffi_tclMsgSRSoundNotificationStateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSRSoundNotificationStateSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSRSoundNotificationStateSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSRSoundNotificationStateSet& operator=(const midw_mascffi_tclMsgSRSoundNotificationStateSet& coRef);
   midw_mascffi_tclMsgSRSoundNotificationStateSet(const midw_mascffi_tclMsgSRSoundNotificationStateSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SR_SoundNotification_State;
   virtual ~midw_mascffi_tclMsgSRSoundNotificationStateSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSRSoundNotificationStateSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgSRSoundNotificationStateStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgSRSoundNotificationStateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgSRSoundNotificationStateStatus& operator=(const midw_mascffi_tclMsgSRSoundNotificationStateStatus& coRef);
   midw_mascffi_tclMsgSRSoundNotificationStateStatus(const midw_mascffi_tclMsgSRSoundNotificationStateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool SR_SoundNotification_State;
   virtual ~midw_mascffi_tclMsgSRSoundNotificationStateStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgSRSoundNotificationStateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotIntensityUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotIntensityUpReg();

   virtual ~midw_mascffi_tclMsgAudioPilotIntensityUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioPilotIntensityUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotIntensityRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotIntensityRelUpReg();

   virtual ~midw_mascffi_tclMsgAudioPilotIntensityRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgAudioPilotIntensityRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotIntensityGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotIntensityGet();

   virtual ~midw_mascffi_tclMsgAudioPilotIntensityGet();

   inline tBool operator==(const midw_mascffi_tclMsgAudioPilotIntensityGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotIntensitySet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotIntensitySet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioPilotIntensitySet& operator=(const midw_mascffi_tclMsgAudioPilotIntensitySet& coRef);
   midw_mascffi_tclMsgAudioPilotIntensitySet(const midw_mascffi_tclMsgAudioPilotIntensitySet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioPilotIntensity Audio_Pilot_Intensity;
   virtual ~midw_mascffi_tclMsgAudioPilotIntensitySet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioPilotIntensitySet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgAudioPilotIntensityStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgAudioPilotIntensityStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgAudioPilotIntensityStatus& operator=(const midw_mascffi_tclMsgAudioPilotIntensityStatus& coRef);
   midw_mascffi_tclMsgAudioPilotIntensityStatus(const midw_mascffi_tclMsgAudioPilotIntensityStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e8_AudioPilotIntensity Audio_Pilot_Intensity;
   virtual ~midw_mascffi_tclMsgAudioPilotIntensityStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgAudioPilotIntensityStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMainAudioAttenuationUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMainAudioAttenuationUpReg();

   virtual ~midw_mascffi_tclMsgMainAudioAttenuationUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMainAudioAttenuationUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMainAudioAttenuationRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMainAudioAttenuationRelUpReg();

   virtual ~midw_mascffi_tclMsgMainAudioAttenuationRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgMainAudioAttenuationRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgMainAudioAttenuationStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgMainAudioAttenuationStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgMainAudioAttenuationStatus& operator=(const midw_mascffi_tclMsgMainAudioAttenuationStatus& coRef);
   midw_mascffi_tclMsgMainAudioAttenuationStatus(const midw_mascffi_tclMsgMainAudioAttenuationStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS8 Attenuation_Value;
   virtual ~midw_mascffi_tclMsgMainAudioAttenuationStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgMainAudioAttenuationStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPrivateModeMixVolumeUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPrivateModeMixVolumeUpReg();

   virtual ~midw_mascffi_tclMsgPrivateModeMixVolumeUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgPrivateModeMixVolumeUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg();

   virtual ~midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg();

   inline tBool operator==(const midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPrivateModeMixVolumeGet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPrivateModeMixVolumeGet();

   virtual ~midw_mascffi_tclMsgPrivateModeMixVolumeGet();

   inline tBool operator==(const midw_mascffi_tclMsgPrivateModeMixVolumeGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPrivateModeMixVolumeSet : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPrivateModeMixVolumeSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgPrivateModeMixVolumeSet& operator=(const midw_mascffi_tclMsgPrivateModeMixVolumeSet& coRef);
   midw_mascffi_tclMsgPrivateModeMixVolumeSet(const midw_mascffi_tclMsgPrivateModeMixVolumeSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 PMMixVolume;
   virtual ~midw_mascffi_tclMsgPrivateModeMixVolumeSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgPrivateModeMixVolumeSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_mascffi_tclMsgPrivateModeMixVolumeStatus : public midw_mascffi_tclMsgBaseMessage
{
public:

   midw_mascffi_tclMsgPrivateModeMixVolumeStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_mascffi_tclMsgPrivateModeMixVolumeStatus& operator=(const midw_mascffi_tclMsgPrivateModeMixVolumeStatus& coRef);
   midw_mascffi_tclMsgPrivateModeMixVolumeStatus(const midw_mascffi_tclMsgPrivateModeMixVolumeStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS16 PMMixVolume;
   virtual ~midw_mascffi_tclMsgPrivateModeMixVolumeStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_mascffi_tclMsgPrivateModeMixVolumeStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
