/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_mascf_fi message types

fi_tclMessageBase* midw_mascffi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_mascffi_tclToken::EN_MSG_VOLUMEMODEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgVolumeModeMethodStart;

      case midw_mascffi_tclToken::EN_MSG_VOLUMEMODEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgVolumeModeMethodResult;

      case midw_mascffi_tclToken::EN_MSG_BEEPMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgBeepMethodStart;

      case midw_mascffi_tclToken::EN_MSG_BEEPMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgBeepMethodResult;

      case midw_mascffi_tclToken::EN_MSG_BEEPFILEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgBeepFileMethodStart;

      case midw_mascffi_tclToken::EN_MSG_BEEPFILEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgBeepFileMethodResult;

      case midw_mascffi_tclToken::EN_MSG_WELCOMESOUNDBEEPFILEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart;

      case midw_mascffi_tclToken::EN_MSG_WELCOMESOUNDBEEPFILEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult;

      case midw_mascffi_tclToken::EN_MSG_MUTEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgMuteMethodStart;

      case midw_mascffi_tclToken::EN_MSG_MUTEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgMuteMethodResult;

      case midw_mascffi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgSet_Mute_RampMethodStart;

      case midw_mascffi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgSet_Mute_RampMethodResult;

      case midw_mascffi_tclToken::EN_MSG_AUDIOSOURCEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgAudioSourceMethodStart;

      case midw_mascffi_tclToken::EN_MSG_AUDIOSOURCEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgAudioSourceMethodResult;

      case midw_mascffi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart;

      case midw_mascffi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult;

      case midw_mascffi_tclToken::EN_MSG_AUDIOTESTTONEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgAudioTestToneMethodStart;

      case midw_mascffi_tclToken::EN_MSG_AUDIOTESTTONEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgAudioTestToneMethodResult;

      case midw_mascffi_tclToken::EN_MSG_CUESTATEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgCueStateMethodStart;

      case midw_mascffi_tclToken::EN_MSG_CUESTATEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgCueStateMethodResult;

      case midw_mascffi_tclToken::EN_MSG_PERFORMONVOLUMELIMITMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart;

      case midw_mascffi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart;

      case midw_mascffi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult;

      case midw_mascffi_tclToken::EN_MSG_SYSTEMMUTEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgSystemMuteMethodStart;

      case midw_mascffi_tclToken::EN_MSG_SYSTEMMUTEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgSystemMuteMethodResult;

      case midw_mascffi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgADAS_SettingSoundMethodStart;

      case midw_mascffi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgADAS_SettingSoundMethodResult;

      case midw_mascffi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgEntertainmentMuteMethodStart;

      case midw_mascffi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgEntertainmentMuteMethodResult;

      case midw_mascffi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODSTART:
         return OSAL_NEW midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart;

      case midw_mascffi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODRESULT:
         return OSAL_NEW midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult;

      case midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeModeStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeModeStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSGET:
         return OSAL_NEW midw_mascffi_tclMsgVolumeModeStatusGet;

      case midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgVolumeModeStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_VOLUMEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMEGET:
         return OSAL_NEW midw_mascffi_tclMsgVolumeGet;

      case midw_mascffi_tclToken::EN_MSG_VOLUMESET:
         return OSAL_NEW midw_mascffi_tclMsgVolumeSet;

      case midw_mascffi_tclToken::EN_MSG_VOLUMESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgVolumeStatus;

      case midw_mascffi_tclToken::EN_MSG_BEEPSTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBeepStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_BEEPSTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBeepStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_BEEPSTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgBeepStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_GALAUPREG:
         return OSAL_NEW midw_mascffi_tclMsgGalaUpReg;

      case midw_mascffi_tclToken::EN_MSG_GALARELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgGalaRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_GALAGET:
         return OSAL_NEW midw_mascffi_tclMsgGalaGet;

      case midw_mascffi_tclToken::EN_MSG_GALASET:
         return OSAL_NEW midw_mascffi_tclMsgGalaSet;

      case midw_mascffi_tclToken::EN_MSG_GALASTATUS:
         return OSAL_NEW midw_mascffi_tclMsgGalaStatus;

      case midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRemoveWelcomeSoundUpReg;

      case midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDGET:
         return OSAL_NEW midw_mascffi_tclMsgRemoveWelcomeSoundGet;

      case midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDSET:
         return OSAL_NEW midw_mascffi_tclMsgRemoveWelcomeSoundSet;

      case midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRemoveWelcomeSoundStatus;

      case midw_mascffi_tclToken::EN_MSG_BALANCEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBalanceUpReg;

      case midw_mascffi_tclToken::EN_MSG_BALANCERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBalanceRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_BALANCEGET:
         return OSAL_NEW midw_mascffi_tclMsgBalanceGet;

      case midw_mascffi_tclToken::EN_MSG_BALANCESET:
         return OSAL_NEW midw_mascffi_tclMsgBalanceSet;

      case midw_mascffi_tclToken::EN_MSG_BALANCESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgBalanceStatus;

      case midw_mascffi_tclToken::EN_MSG_LOUDNESSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgLoudnessUpReg;

      case midw_mascffi_tclToken::EN_MSG_LOUDNESSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgLoudnessRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_LOUDNESSGET:
         return OSAL_NEW midw_mascffi_tclMsgLoudnessGet;

      case midw_mascffi_tclToken::EN_MSG_LOUDNESSSET:
         return OSAL_NEW midw_mascffi_tclMsgLoudnessSet;

      case midw_mascffi_tclToken::EN_MSG_LOUDNESSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgLoudnessStatus;

      case midw_mascffi_tclToken::EN_MSG_BASSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBassUpReg;

      case midw_mascffi_tclToken::EN_MSG_BASSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBassRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_BASSGET:
         return OSAL_NEW midw_mascffi_tclMsgBassGet;

      case midw_mascffi_tclToken::EN_MSG_BASSSET:
         return OSAL_NEW midw_mascffi_tclMsgBassSet;

      case midw_mascffi_tclToken::EN_MSG_BASSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgBassStatus;

      case midw_mascffi_tclToken::EN_MSG_TREBLEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgTrebleUpReg;

      case midw_mascffi_tclToken::EN_MSG_TREBLERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgTrebleRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_TREBLEGET:
         return OSAL_NEW midw_mascffi_tclMsgTrebleGet;

      case midw_mascffi_tclToken::EN_MSG_TREBLESET:
         return OSAL_NEW midw_mascffi_tclMsgTrebleSet;

      case midw_mascffi_tclToken::EN_MSG_TREBLESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgTrebleStatus;

      case midw_mascffi_tclToken::EN_MSG_FADERUPREG:
         return OSAL_NEW midw_mascffi_tclMsgFaderUpReg;

      case midw_mascffi_tclToken::EN_MSG_FADERRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgFaderRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_FADERGET:
         return OSAL_NEW midw_mascffi_tclMsgFaderGet;

      case midw_mascffi_tclToken::EN_MSG_FADERSET:
         return OSAL_NEW midw_mascffi_tclMsgFaderSet;

      case midw_mascffi_tclToken::EN_MSG_FADERSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgFaderStatus;

      case midw_mascffi_tclToken::EN_MSG_MIDRANGEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMidRangeUpReg;

      case midw_mascffi_tclToken::EN_MSG_MIDRANGERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMidRangeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_MIDRANGEGET:
         return OSAL_NEW midw_mascffi_tclMsgMidRangeGet;

      case midw_mascffi_tclToken::EN_MSG_MIDRANGESET:
         return OSAL_NEW midw_mascffi_tclMsgMidRangeSet;

      case midw_mascffi_tclToken::EN_MSG_MIDRANGESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgMidRangeStatus;

      case midw_mascffi_tclToken::EN_MSG_MEMSOUNDUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMemSoundUpReg;

      case midw_mascffi_tclToken::EN_MSG_MEMSOUNDRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMemSoundRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_MEMSOUNDSET:
         return OSAL_NEW midw_mascffi_tclMsgMemSoundSet;

      case midw_mascffi_tclToken::EN_MSG_MEMSOUNDSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgMemSoundStatus;

      case midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgFaderActivationStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgFaderActivationStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSGET:
         return OSAL_NEW midw_mascffi_tclMsgFaderActivationStatusGet;

      case midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgFaderActivationStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDynamicCompressionUpReg;

      case midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDynamicCompressionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONGET:
         return OSAL_NEW midw_mascffi_tclMsgDynamicCompressionGet;

      case midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSET:
         return OSAL_NEW midw_mascffi_tclMsgDynamicCompressionSet;

      case midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgDynamicCompressionStatus;

      case midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgOptimizationUpReg;

      case midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgOptimizationRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONGET:
         return OSAL_NEW midw_mascffi_tclMsgOptimizationGet;

      case midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONSET:
         return OSAL_NEW midw_mascffi_tclMsgOptimizationSet;

      case midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgOptimizationStatus;

      case midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETUPREG:
         return OSAL_NEW midw_mascffi_tclMsgEqualiserPresetUpReg;

      case midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgEqualiserPresetRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETGET:
         return OSAL_NEW midw_mascffi_tclMsgEqualiserPresetGet;

      case midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETSET:
         return OSAL_NEW midw_mascffi_tclMsgEqualiserPresetSet;

      case midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgEqualiserPresetStatus;

      case midw_mascffi_tclToken::EN_MSG_DIAGAUDMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDiagAudModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_DIAGAUDMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDiagAudModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_DIAGAUDMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgDiagAudModeGet;

      case midw_mascffi_tclToken::EN_MSG_DIAGAUDMODESET:
         return OSAL_NEW midw_mascffi_tclMsgDiagAudModeSet;

      case midw_mascffi_tclToken::EN_MSG_DIAGAUDMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgDiagAudModeStatus;

      case midw_mascffi_tclToken::EN_MSG_AUXINLEVELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAuxInLevelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUXINLEVELRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAuxInLevelRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUXINLEVELGET:
         return OSAL_NEW midw_mascffi_tclMsgAuxInLevelGet;

      case midw_mascffi_tclToken::EN_MSG_AUXINLEVELSET:
         return OSAL_NEW midw_mascffi_tclMsgAuxInLevelSet;

      case midw_mascffi_tclToken::EN_MSG_AUXINLEVELSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAuxInLevelStatus;

      case midw_mascffi_tclToken::EN_MSG_BEEPLEVELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBeepLevelUpReg;

      case midw_mascffi_tclToken::EN_MSG_BEEPLEVELRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBeepLevelRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_BEEPLEVELGET:
         return OSAL_NEW midw_mascffi_tclMsgBeepLevelGet;

      case midw_mascffi_tclToken::EN_MSG_BEEPLEVELSET:
         return OSAL_NEW midw_mascffi_tclMsgBeepLevelSet;

      case midw_mascffi_tclToken::EN_MSG_BEEPLEVELSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgBeepLevelStatus;

      case midw_mascffi_tclToken::EN_MSG_REAR_MUTEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRear_MuteUpReg;

      case midw_mascffi_tclToken::EN_MSG_REAR_MUTERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRear_MuteRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_REAR_MUTEGET:
         return OSAL_NEW midw_mascffi_tclMsgRear_MuteGet;

      case midw_mascffi_tclToken::EN_MSG_REAR_MUTESET:
         return OSAL_NEW midw_mascffi_tclMsgRear_MuteSet;

      case midw_mascffi_tclToken::EN_MSG_REAR_MUTESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRear_MuteStatus;

      case midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgGeometry_ModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgGeometry_ModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODEGET:
         return OSAL_NEW midw_mascffi_tclMsgGeometry_ModeGet;

      case midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODESET:
         return OSAL_NEW midw_mascffi_tclMsgGeometry_ModeSet;

      case midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgGeometry_ModeStatus;

      case midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgLSValueStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgLSValueStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSGET:
         return OSAL_NEW midw_mascffi_tclMsgLSValueStatusGet;

      case midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgLSValueStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationLevelUpReg;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELGET:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationLevelGet;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELSET:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationLevelSet;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationLevelStatus;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationUpReg;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONGET:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationGet;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONSET:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationSet;

      case midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgPDCAttenuationStatus;

      case midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioDeviceStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioDeviceStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSGET:
         return OSAL_NEW midw_mascffi_tclMsgAudioDeviceStatusGet;

      case midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAudioDeviceStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgOverTempReductionUpReg;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgOverTempReductionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONGET:
         return OSAL_NEW midw_mascffi_tclMsgOverTempReductionGet;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONSET:
         return OSAL_NEW midw_mascffi_tclMsgOverTempReductionSet;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgOverTempReductionStatus;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgOverTempAmplifierStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSGET:
         return OSAL_NEW midw_mascffi_tclMsgOverTempAmplifierStatusGet;

      case midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgOverTempAmplifierStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTUPREG:
         return OSAL_NEW midw_mascffi_tclMsgReadMeasurementResultUpReg;

      case midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgReadMeasurementResultRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTGET:
         return OSAL_NEW midw_mascffi_tclMsgReadMeasurementResultGet;

      case midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgReadMeasurementResultStatus;

      case midw_mascffi_tclToken::EN_MSG_CENTERUPREG:
         return OSAL_NEW midw_mascffi_tclMsgCenterUpReg;

      case midw_mascffi_tclToken::EN_MSG_CENTERRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgCenterRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_CENTERGET:
         return OSAL_NEW midw_mascffi_tclMsgCenterGet;

      case midw_mascffi_tclToken::EN_MSG_CENTERSET:
         return OSAL_NEW midw_mascffi_tclMsgCenterSet;

      case midw_mascffi_tclToken::EN_MSG_CENTERSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgCenterStatus;

      case midw_mascffi_tclToken::EN_MSG_SUBWOOFERUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSubWooferUpReg;

      case midw_mascffi_tclToken::EN_MSG_SUBWOOFERRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSubWooferRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_SUBWOOFERGET:
         return OSAL_NEW midw_mascffi_tclMsgSubWooferGet;

      case midw_mascffi_tclToken::EN_MSG_SUBWOOFERSET:
         return OSAL_NEW midw_mascffi_tclMsgSubWooferSet;

      case midw_mascffi_tclToken::EN_MSG_SUBWOOFERSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgSubWooferStatus;

      case midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg;

      case midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEGET:
         return OSAL_NEW midw_mascffi_tclMsgExternalAmplifierConnectionStateGet;

      case midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus;

      case midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTUPREG:
         return OSAL_NEW midw_mascffi_tclMsgGeneralSpeakerTestUpReg;

      case midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTGET:
         return OSAL_NEW midw_mascffi_tclMsgGeneralSpeakerTestGet;

      case midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTSET:
         return OSAL_NEW midw_mascffi_tclMsgGeneralSpeakerTestSet;

      case midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgGeneralSpeakerTestStatus;

      case midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCSWVersionUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCSWVersionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONGET:
         return OSAL_NEW midw_mascffi_tclMsgANCSWVersionGet;

      case midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgANCSWVersionStatus;

      case midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgASCSWVersionUpReg;

      case midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgASCSWVersionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONGET:
         return OSAL_NEW midw_mascffi_tclMsgASCSWVersionGet;

      case midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgASCSWVersionStatus;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSettingUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSettingRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGGET:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSettingGet;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGSET:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSettingSet;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSettingStatus;

      case midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpSoftwareVersionUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONGET:
         return OSAL_NEW midw_mascffi_tclMsgAmpSoftwareVersionGet;

      case midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAmpSoftwareVersionStatus;

      case midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpParameterVersionUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpParameterVersionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONGET:
         return OSAL_NEW midw_mascffi_tclMsgAmpParameterVersionGet;

      case midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAmpParameterVersionStatus;

      case midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpHardwareVersionUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpHardwareVersionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONGET:
         return OSAL_NEW midw_mascffi_tclMsgAmpHardwareVersionGet;

      case midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAmpHardwareVersionStatus;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDVOLUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSurroundVolUpReg;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDVOLRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSurroundVolRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDVOLGET:
         return OSAL_NEW midw_mascffi_tclMsgSurroundVolGet;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDVOLSET:
         return OSAL_NEW midw_mascffi_tclMsgSurroundVolSet;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDVOLSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgSurroundVolStatus;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotModeGet;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODESET:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotModeSet;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotModeStatus;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSurroundModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSurroundModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgSurroundModeGet;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDMODESET:
         return OSAL_NEW midw_mascffi_tclMsgSurroundModeSet;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgSurroundModeStatus;

      case midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpDownMixModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpDownMixModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgAmpDownMixModeGet;

      case midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODESET:
         return OSAL_NEW midw_mascffi_tclMsgAmpDownMixModeSet;

      case midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAmpDownMixModeStatus;

      case midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDriverSoundModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDriverSoundModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgDriverSoundModeGet;

      case midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODESET:
         return OSAL_NEW midw_mascffi_tclMsgDriverSoundModeSet;

      case midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgDriverSoundModeStatus;

      case midw_mascffi_tclToken::EN_MSG_REARSOUNDMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRearSoundModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_REARSOUNDMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRearSoundModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_REARSOUNDMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgRearSoundModeGet;

      case midw_mascffi_tclToken::EN_MSG_REARSOUNDMODESET:
         return OSAL_NEW midw_mascffi_tclMsgRearSoundModeSet;

      case midw_mascffi_tclToken::EN_MSG_REARSOUNDMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRearSoundModeStatus;

      case midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioOFFMuteStateUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATESET:
         return OSAL_NEW midw_mascffi_tclMsgAudioOFFMuteStateSet;

      case midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAudioOFFMuteStateStatus;

      case midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSGET:
         return OSAL_NEW midw_mascffi_tclMsgMicrophoneConnectionStatusGet;

      case midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgMicrophoneConnectionStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_CONNECTIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgConnectionUpReg;

      case midw_mascffi_tclToken::EN_MSG_CONNECTIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgConnectionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_CONNECTIONGET:
         return OSAL_NEW midw_mascffi_tclMsgConnectionGet;

      case midw_mascffi_tclToken::EN_MSG_CONNECTIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgConnectionStatus;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELISTUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeListUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELISTRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeListRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELISTGET:
         return OSAL_NEW midw_mascffi_tclMsgVolumeListGet;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELISTSET:
         return OSAL_NEW midw_mascffi_tclMsgVolumeListSet;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELISTSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgVolumeListStatus;

      case midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBTAudioInLevelUpReg;

      case midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgBTAudioInLevelRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELGET:
         return OSAL_NEW midw_mascffi_tclMsgBTAudioInLevelGet;

      case midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELSET:
         return OSAL_NEW midw_mascffi_tclMsgBTAudioInLevelSet;

      case midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgBTAudioInLevelStatus;

      case midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATAUPREG:
         return OSAL_NEW midw_mascffi_tclMsgEngineeringDataUpReg;

      case midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATARELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgEngineeringDataRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATAGET:
         return OSAL_NEW midw_mascffi_tclMsgEngineeringDataGet;

      case midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATASET:
         return OSAL_NEW midw_mascffi_tclMsgEngineeringDataSet;

      case midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATASTATUS:
         return OSAL_NEW midw_mascffi_tclMsgEngineeringDataStatus;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSurroundSettingUpReg;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSurroundSettingRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGGET:
         return OSAL_NEW midw_mascffi_tclMsgSurroundSettingGet;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGSET:
         return OSAL_NEW midw_mascffi_tclMsgSurroundSettingSet;

      case midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgSurroundSettingStatus;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELOCKUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeLockUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELOCKRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgVolumeLockRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELOCKGET:
         return OSAL_NEW midw_mascffi_tclMsgVolumeLockGet;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELOCKSET:
         return OSAL_NEW midw_mascffi_tclMsgVolumeLockSet;

      case midw_mascffi_tclToken::EN_MSG_VOLUMELOCKSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgVolumeLockStatus;

      case midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpAvailFunctionUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAmpAvailFunctionRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONGET:
         return OSAL_NEW midw_mascffi_tclMsgAmpAvailFunctionGet;

      case midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAmpAvailFunctionStatus;

      case midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSetAudioPropertyUpReg;

      case midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSetAudioPropertyRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYGET:
         return OSAL_NEW midw_mascffi_tclMsgSetAudioPropertyGet;

      case midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYSET:
         return OSAL_NEW midw_mascffi_tclMsgSetAudioPropertySet;

      case midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgSetAudioPropertyStatus;

      case midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPUPREG:
         return OSAL_NEW midw_mascffi_tclMsgEntOnVolumeSetupUpReg;

      case midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPSET:
         return OSAL_NEW midw_mascffi_tclMsgEntOnVolumeSetupSet;

      case midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgEntOnVolumeSetupStatus;

      case midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg;

      case midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPSET:
         return OSAL_NEW midw_mascffi_tclMsgMinimumOnVolumeSetupSet;

      case midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgMinimumOnVolumeSetupStatus;

      case midw_mascffi_tclToken::EN_MSG_ROOMEFFECTUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRoomEffectUpReg;

      case midw_mascffi_tclToken::EN_MSG_ROOMEFFECTRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRoomEffectRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ROOMEFFECTGET:
         return OSAL_NEW midw_mascffi_tclMsgRoomEffectGet;

      case midw_mascffi_tclToken::EN_MSG_ROOMEFFECTSET:
         return OSAL_NEW midw_mascffi_tclMsgRoomEffectSet;

      case midw_mascffi_tclToken::EN_MSG_ROOMEFFECTSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRoomEffectStatus;

      case midw_mascffi_tclToken::EN_MSG_FMENHANCERMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgFMEnhancerModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_FMENHANCERMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgFMEnhancerModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_FMENHANCERMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgFMEnhancerModeGet;

      case midw_mascffi_tclToken::EN_MSG_FMENHANCERMODESET:
         return OSAL_NEW midw_mascffi_tclMsgFMEnhancerModeSet;

      case midw_mascffi_tclToken::EN_MSG_FMENHANCERMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgFMEnhancerModeStatus;

      case midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDiagDefSetPhaseUpReg;

      case midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASEGET:
         return OSAL_NEW midw_mascffi_tclMsgDiagDefSetPhaseGet;

      case midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgDiagDefSetPhaseStatus;

      case midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgESESoundTypeUpReg;

      case midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgESESoundTypeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPEGET:
         return OSAL_NEW midw_mascffi_tclMsgESESoundTypeGet;

      case midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPESET:
         return OSAL_NEW midw_mascffi_tclMsgESESoundTypeSet;

      case midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgESESoundTypeStatus;

      case midw_mascffi_tclToken::EN_MSG_ESEVOLUMEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgESEVolumeUpReg;

      case midw_mascffi_tclToken::EN_MSG_ESEVOLUMERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgESEVolumeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ESEVOLUMEGET:
         return OSAL_NEW midw_mascffi_tclMsgESEVolumeGet;

      case midw_mascffi_tclToken::EN_MSG_ESEVOLUMESET:
         return OSAL_NEW midw_mascffi_tclMsgESEVolumeSet;

      case midw_mascffi_tclToken::EN_MSG_ESEVOLUMESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgESEVolumeStatus;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundOnOffUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundOnOffRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFGET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundOnOffGet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFSET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundOnOffSet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRSoundOnOffStatus;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundSoundTypeUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundSoundTypeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPEGET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundSoundTypeGet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPESET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundSoundTypeSet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRSoundSoundTypeStatus;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundVolumeUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundVolumeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMEGET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundVolumeGet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMESET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundVolumeSet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRSoundVolumeStatus;

      case midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgESEDriveModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgESEDriveModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgESEDriveModeGet;

      case midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODESET:
         return OSAL_NEW midw_mascffi_tclMsgESEDriveModeSet;

      case midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgESEDriveModeStatus;

      case midw_mascffi_tclToken::EN_MSG_AUDIOMODEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioModeUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOMODERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioModeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOMODEGET:
         return OSAL_NEW midw_mascffi_tclMsgAudioModeGet;

      case midw_mascffi_tclToken::EN_MSG_AUDIOMODESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAudioModeStatus;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPASoundTypeUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEGET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPASoundTypeGet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPASoundTypeSet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPASoundTypeStatus;

      case midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEGET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_ParkAssistVolumeGet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_ParkAssistVolumeSet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPAMuteUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPAMuteRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTEGET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPAMuteGet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTESET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPAMuteSet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgADAS_UPAMuteStatus;

      case midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAutomaticGainControlUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAutomaticGainControlRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLGET:
         return OSAL_NEW midw_mascffi_tclMsgAutomaticGainControlGet;

      case midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSET:
         return OSAL_NEW midw_mascffi_tclMsgAutomaticGainControlSet;

      case midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAutomaticGainControlStatus;

      case midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEGET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_LDW_UserVolumeGet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESET:
         return OSAL_NEW midw_mascffi_tclMsgADAS_LDW_UserVolumeSet;

      case midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundActivationUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgRSoundActivationRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONGET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundActivationGet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONSET:
         return OSAL_NEW midw_mascffi_tclMsgRSoundActivationSet;

      case midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgRSoundActivationStatus;

      case midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCASCActiveTestUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCASCActiveTestRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTGET:
         return OSAL_NEW midw_mascffi_tclMsgANCASCActiveTestGet;

      case midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTSET:
         return OSAL_NEW midw_mascffi_tclMsgANCASCActiveTestSet;

      case midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgANCASCActiveTestStatus;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSGET:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSET:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet;

      case midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus;

      case midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgUserProfileChangeUpReg;

      case midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgUserProfileChangeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGEGET:
         return OSAL_NEW midw_mascffi_tclMsgUserProfileChangeGet;

      case midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGESET:
         return OSAL_NEW midw_mascffi_tclMsgUserProfileChangeSet;

      case midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgUserProfileChangeStatus;

      case midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSRSoundNotificationStateUpReg;

      case midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEGET:
         return OSAL_NEW midw_mascffi_tclMsgSRSoundNotificationStateGet;

      case midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESET:
         return OSAL_NEW midw_mascffi_tclMsgSRSoundNotificationStateSet;

      case midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgSRSoundNotificationStateStatus;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotIntensityUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotIntensityRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYGET:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotIntensityGet;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSET:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotIntensitySet;

      case midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgAudioPilotIntensityStatus;

      case midw_mascffi_tclToken::EN_MSG_MAINAUDIOATTENUATIONUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMainAudioAttenuationUpReg;

      case midw_mascffi_tclToken::EN_MSG_MAINAUDIOATTENUATIONRELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgMainAudioAttenuationRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_MAINAUDIOATTENUATIONSTATUS:
         return OSAL_NEW midw_mascffi_tclMsgMainAudioAttenuationStatus;

      case midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMEUPREG:
         return OSAL_NEW midw_mascffi_tclMsgPrivateModeMixVolumeUpReg;

      case midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMERELUPREG:
         return OSAL_NEW midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg;

      case midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMEGET:
         return OSAL_NEW midw_mascffi_tclMsgPrivateModeMixVolumeGet;

      case midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMESET:
         return OSAL_NEW midw_mascffi_tclMsgPrivateModeMixVolumeSet;

      case midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMESTATUS:
         return OSAL_NEW midw_mascffi_tclMsgPrivateModeMixVolumeStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_mascffifi messages

// common functions

tU16 midw_mascffi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_MASCFFI_C_U16_SERVICE_ID;
}

tU16 midw_mascffi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_mascffi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_mascffi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_mascffi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_mascffi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_mascffi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_mascffi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeModeMethodStart::midw_mascffi_tclMsgVolumeModeMethodStart(const midw_mascffi_tclMsgVolumeModeMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgVolumeModeMethodStart& midw_mascffi_tclMsgVolumeModeMethodStart::operator=(const midw_mascffi_tclMsgVolumeModeMethodStart& coRef)
{
   if (this == &coRef) return *this;
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgVolumeModeMethodStart::midw_mascffi_tclMsgVolumeModeMethodStart()
:VolumeMode()
,Resource()
 {}

tS32 midw_mascffi_tclMsgVolumeModeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEMODEMETHODSTART;
}


midw_mascffi_tclMsgVolumeModeMethodStart::~midw_mascffi_tclMsgVolumeModeMethodStart()
{}

tU32 midw_mascffi_tclMsgVolumeModeMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgVolumeModeMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeMode);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeModeMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeMode);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeModeMethodStart::operator==(const midw_mascffi_tclMsgVolumeModeMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeMode == roRef.VolumeMode);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeModeMethodResult::midw_mascffi_tclMsgVolumeModeMethodResult(const midw_mascffi_tclMsgVolumeModeMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_mascffi_tclMsgVolumeModeMethodResult& midw_mascffi_tclMsgVolumeModeMethodResult::operator=(const midw_mascffi_tclMsgVolumeModeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgVolumeModeMethodResult::midw_mascffi_tclMsgVolumeModeMethodResult()
:ServiceStatus()
 {}

tS32 midw_mascffi_tclMsgVolumeModeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEMODEMETHODRESULT;
}


midw_mascffi_tclMsgVolumeModeMethodResult::~midw_mascffi_tclMsgVolumeModeMethodResult()
{}

tU32 midw_mascffi_tclMsgVolumeModeMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgVolumeModeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeModeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeModeMethodResult::operator==(const midw_mascffi_tclMsgVolumeModeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBeepMethodStart::midw_mascffi_tclMsgBeepMethodStart(const midw_mascffi_tclMsgBeepMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   BeepType = coRef.BeepType;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgBeepMethodStart& midw_mascffi_tclMsgBeepMethodStart::operator=(const midw_mascffi_tclMsgBeepMethodStart& coRef)
{
   if (this == &coRef) return *this;
   BeepType = coRef.BeepType;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBeepMethodStart::midw_mascffi_tclMsgBeepMethodStart()
:BeepType()
,Resource()
 {}

tS32 midw_mascffi_tclMsgBeepMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPMETHODSTART;
}


midw_mascffi_tclMsgBeepMethodStart::~midw_mascffi_tclMsgBeepMethodStart()
{}

tU32 midw_mascffi_tclMsgBeepMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgBeepMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepType);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBeepMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepType);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgBeepMethodStart::operator==(const midw_mascffi_tclMsgBeepMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepType == roRef.BeepType);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBeepMethodResult::midw_mascffi_tclMsgBeepMethodResult(const midw_mascffi_tclMsgBeepMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_mascffi_tclMsgBeepMethodResult& midw_mascffi_tclMsgBeepMethodResult::operator=(const midw_mascffi_tclMsgBeepMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBeepMethodResult::midw_mascffi_tclMsgBeepMethodResult()
:ServiceStatus()
 {}

tS32 midw_mascffi_tclMsgBeepMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPMETHODRESULT;
}


midw_mascffi_tclMsgBeepMethodResult::~midw_mascffi_tclMsgBeepMethodResult()
{}

tU32 midw_mascffi_tclMsgBeepMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgBeepMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBeepMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgBeepMethodResult::operator==(const midw_mascffi_tclMsgBeepMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBeepFileMethodStart::midw_mascffi_tclMsgBeepFileMethodStart(const midw_mascffi_tclMsgBeepFileMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   sFilePath = coRef.sFilePath;
   oConfig = coRef.oConfig;
}
midw_mascffi_tclMsgBeepFileMethodStart& midw_mascffi_tclMsgBeepFileMethodStart::operator=(const midw_mascffi_tclMsgBeepFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sFilePath = coRef.sFilePath;
   oConfig = coRef.oConfig;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgBeepFileMethodStart::vDestroy()
{
   sFilePath.vDestroy();
   oConfig.vDestroy(); 
}

midw_mascffi_tclMsgBeepFileMethodStart::midw_mascffi_tclMsgBeepFileMethodStart()
:sFilePath()
,oConfig()
 {}

tS32 midw_mascffi_tclMsgBeepFileMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPFILEMETHODSTART;
}


midw_mascffi_tclMsgBeepFileMethodStart::~midw_mascffi_tclMsgBeepFileMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgBeepFileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 3+sFilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgBeepFileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilePath);
   (tVoid) (oIn >> oConfig);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBeepFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilePath);
   (tVoid) (oOut << oConfig);
   return oOut;
}

tBool midw_mascffi_tclMsgBeepFileMethodStart::operator==(const midw_mascffi_tclMsgBeepFileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilePath == roRef.sFilePath);
   bResult = bResult && (oConfig == roRef.oConfig);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBeepFileMethodResult::midw_mascffi_tclMsgBeepFileMethodResult(const midw_mascffi_tclMsgBeepFileMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
   u32Token = coRef.u32Token;
}
midw_mascffi_tclMsgBeepFileMethodResult& midw_mascffi_tclMsgBeepFileMethodResult::operator=(const midw_mascffi_tclMsgBeepFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   u32Token = coRef.u32Token;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBeepFileMethodResult::midw_mascffi_tclMsgBeepFileMethodResult()
:ServiceStatus()
,u32Token(0)
 {}

tS32 midw_mascffi_tclMsgBeepFileMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPFILEMETHODRESULT;
}


midw_mascffi_tclMsgBeepFileMethodResult::~midw_mascffi_tclMsgBeepFileMethodResult()
{}

tU32 midw_mascffi_tclMsgBeepFileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_mascffi_tclMsgBeepFileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   (tVoid) (oIn >> u32Token);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBeepFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   (tVoid) (oOut << u32Token);
   return oOut;
}

tBool midw_mascffi_tclMsgBeepFileMethodResult::operator==(const midw_mascffi_tclMsgBeepFileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   bResult = bResult && (u32Token == roRef.u32Token);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   sFilePath = coRef.sFilePath;
   oConfig = coRef.oConfig;
   u8BeepAction = coRef.u8BeepAction;
}
midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::operator=(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& coRef)
{
   if (this == &coRef) return *this;
   sFilePath = coRef.sFilePath;
   oConfig = coRef.oConfig;
   u8BeepAction = coRef.u8BeepAction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::vDestroy()
{
   sFilePath.vDestroy();
   oConfig.vDestroy(); 
}

midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart()
:sFilePath()
,oConfig()
,u8BeepAction(1)
 {}

tS32 midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_WELCOMESOUNDBEEPFILEMETHODSTART;
}


midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::~midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 4+sFilePath.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> sFilePath);
   (tVoid) (oIn >> oConfig);
   (tVoid) (oIn >> u8BeepAction);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << sFilePath);
   (tVoid) (oOut << oConfig);
   (tVoid) (oOut << u8BeepAction);
   return oOut;
}

tBool midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart::operator==(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (sFilePath == roRef.sFilePath);
   bResult = bResult && (oConfig == roRef.oConfig);
   bResult = bResult && (u8BeepAction == roRef.u8BeepAction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
   u32Token = coRef.u32Token;
}
midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::operator=(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   u32Token = coRef.u32Token;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult()
:ServiceStatus()
,u32Token(0)
 {}

tS32 midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_WELCOMESOUNDBEEPFILEMETHODRESULT;
}


midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::~midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult()
{}

tU32 midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   (tVoid) (oIn >> u32Token);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   (tVoid) (oOut << u32Token);
   return oOut;
}

tBool midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult::operator==(const midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   bResult = bResult && (u32Token == roRef.u32Token);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMuteMethodStart::midw_mascffi_tclMsgMuteMethodStart(const midw_mascffi_tclMsgMuteMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgMuteMethodStart& midw_mascffi_tclMsgMuteMethodStart::operator=(const midw_mascffi_tclMsgMuteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMuteMethodStart::midw_mascffi_tclMsgMuteMethodStart()
:Requester()
,Resource()
,State()
,Reason()
,Channel()
 {}

tS32 midw_mascffi_tclMsgMuteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MUTEMETHODSTART;
}


midw_mascffi_tclMsgMuteMethodStart::~midw_mascffi_tclMsgMuteMethodStart()
{}

tU32 midw_mascffi_tclMsgMuteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_mascffi_tclMsgMuteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Reason);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMuteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Reason);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgMuteMethodStart::operator==(const midw_mascffi_tclMsgMuteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Reason == roRef.Reason);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMuteMethodResult::midw_mascffi_tclMsgMuteMethodResult(const midw_mascffi_tclMsgMuteMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgMuteMethodResult& midw_mascffi_tclMsgMuteMethodResult::operator=(const midw_mascffi_tclMsgMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMuteMethodResult::midw_mascffi_tclMsgMuteMethodResult()
:Requester()
,Resource()
,State()
,Channel()
 {}

tS32 midw_mascffi_tclMsgMuteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MUTEMETHODRESULT;
}


midw_mascffi_tclMsgMuteMethodResult::~midw_mascffi_tclMsgMuteMethodResult()
{}

tU32 midw_mascffi_tclMsgMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_mascffi_tclMsgMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgMuteMethodResult::operator==(const midw_mascffi_tclMsgMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSet_Mute_RampMethodStart::midw_mascffi_tclMsgSet_Mute_RampMethodStart(const midw_mascffi_tclMsgSet_Mute_RampMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgSet_Mute_RampMethodStart& midw_mascffi_tclMsgSet_Mute_RampMethodStart::operator=(const midw_mascffi_tclMsgSet_Mute_RampMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Resource = coRef.Resource;
   State = coRef.State;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSet_Mute_RampMethodStart::midw_mascffi_tclMsgSet_Mute_RampMethodStart()
:Resource()
,State()
,Channel()
 {}

tS32 midw_mascffi_tclMsgSet_Mute_RampMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODSTART;
}


midw_mascffi_tclMsgSet_Mute_RampMethodStart::~midw_mascffi_tclMsgSet_Mute_RampMethodStart()
{}

tU32 midw_mascffi_tclMsgSet_Mute_RampMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgSet_Mute_RampMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSet_Mute_RampMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgSet_Mute_RampMethodStart::operator==(const midw_mascffi_tclMsgSet_Mute_RampMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSet_Mute_RampMethodResult::midw_mascffi_tclMsgSet_Mute_RampMethodResult(const midw_mascffi_tclMsgSet_Mute_RampMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_mascffi_tclMsgSet_Mute_RampMethodResult& midw_mascffi_tclMsgSet_Mute_RampMethodResult::operator=(const midw_mascffi_tclMsgSet_Mute_RampMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSet_Mute_RampMethodResult::midw_mascffi_tclMsgSet_Mute_RampMethodResult()
:ServiceStatus()
 {}

tS32 midw_mascffi_tclMsgSet_Mute_RampMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SET_MUTE_RAMPMETHODRESULT;
}


midw_mascffi_tclMsgSet_Mute_RampMethodResult::~midw_mascffi_tclMsgSet_Mute_RampMethodResult()
{}

tU32 midw_mascffi_tclMsgSet_Mute_RampMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSet_Mute_RampMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSet_Mute_RampMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgSet_Mute_RampMethodResult::operator==(const midw_mascffi_tclMsgSet_Mute_RampMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioSourceMethodStart::midw_mascffi_tclMsgAudioSourceMethodStart(const midw_mascffi_tclMsgAudioSourceMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Resource = coRef.Resource;
   Source = coRef.Source;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgAudioSourceMethodStart& midw_mascffi_tclMsgAudioSourceMethodStart::operator=(const midw_mascffi_tclMsgAudioSourceMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Resource = coRef.Resource;
   Source = coRef.Source;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioSourceMethodStart::midw_mascffi_tclMsgAudioSourceMethodStart()
:Resource()
,Source()
,Channel()
 {}

tS32 midw_mascffi_tclMsgAudioSourceMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOSOURCEMETHODSTART;
}


midw_mascffi_tclMsgAudioSourceMethodStart::~midw_mascffi_tclMsgAudioSourceMethodStart()
{}

tU32 midw_mascffi_tclMsgAudioSourceMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgAudioSourceMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioSourceMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioSourceMethodStart::operator==(const midw_mascffi_tclMsgAudioSourceMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioSourceMethodResult::midw_mascffi_tclMsgAudioSourceMethodResult(const midw_mascffi_tclMsgAudioSourceMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_mascffi_tclMsgAudioSourceMethodResult& midw_mascffi_tclMsgAudioSourceMethodResult::operator=(const midw_mascffi_tclMsgAudioSourceMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioSourceMethodResult::midw_mascffi_tclMsgAudioSourceMethodResult()
:ServiceStatus()
 {}

tS32 midw_mascffi_tclMsgAudioSourceMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOSOURCEMETHODRESULT;
}


midw_mascffi_tclMsgAudioSourceMethodResult::~midw_mascffi_tclMsgAudioSourceMethodResult()
{}

tU32 midw_mascffi_tclMsgAudioSourceMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioSourceMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioSourceMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioSourceMethodResult::operator==(const midw_mascffi_tclMsgAudioSourceMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Source = coRef.Source;
   AudProcAdev = coRef.AudProcAdev;
   MsgHandle = coRef.MsgHandle;
   Action = coRef.Action;
}
midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::operator=(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Source = coRef.Source;
   AudProcAdev = coRef.AudProcAdev;
   MsgHandle = coRef.MsgHandle;
   Action = coRef.Action;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::vDestroy()
{
   AudProcAdev.vDestroy();
}

midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart()
:Resource()
,Channel()
,Source()
,AudProcAdev()
,MsgHandle(0)
,Action()
 {}

tS32 midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODSTART;
}


midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::~midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 8+AudProcAdev.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   (tVoid) (oIn >> Source);
   (tVoid) (oIn >> AudProcAdev);
   (tVoid) (oIn >> MsgHandle);
   (tVoid) (oIn >> Action);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   (tVoid) (oOut << Source);
   (tVoid) (oOut << AudProcAdev);
   (tVoid) (oOut << MsgHandle);
   (tVoid) (oOut << Action);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart::operator==(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   bResult = bResult && (Source == roRef.Source);
   bResult = bResult && (AudProcAdev == roRef.AudProcAdev);
   bResult = bResult && (MsgHandle == roRef.MsgHandle);
   bResult = bResult && (Action == roRef.Action);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
   MsgHandle = coRef.MsgHandle;
}
midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::operator=(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   MsgHandle = coRef.MsgHandle;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult()
:ServiceStatus()
,MsgHandle(0)
 {}

tS32 midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPDEVICEAUDIOROUTEMETHODRESULT;
}


midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::~midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult()
{}

tU32 midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   (tVoid) (oIn >> MsgHandle);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   (tVoid) (oOut << MsgHandle);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult::operator==(const midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   bResult = bResult && (MsgHandle == roRef.MsgHandle);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioTestToneMethodStart::midw_mascffi_tclMsgAudioTestToneMethodStart(const midw_mascffi_tclMsgAudioTestToneMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ChannelSelect = coRef.ChannelSelect;
   Frequency = coRef.Frequency;
   Volume = coRef.Volume;
}
midw_mascffi_tclMsgAudioTestToneMethodStart& midw_mascffi_tclMsgAudioTestToneMethodStart::operator=(const midw_mascffi_tclMsgAudioTestToneMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ChannelSelect = coRef.ChannelSelect;
   Frequency = coRef.Frequency;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioTestToneMethodStart::midw_mascffi_tclMsgAudioTestToneMethodStart()
:ChannelSelect()
,Frequency(0)
,Volume()
 {}

tS32 midw_mascffi_tclMsgAudioTestToneMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOTESTTONEMETHODSTART;
}


midw_mascffi_tclMsgAudioTestToneMethodStart::~midw_mascffi_tclMsgAudioTestToneMethodStart()
{}

tU32 midw_mascffi_tclMsgAudioTestToneMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& midw_mascffi_tclMsgAudioTestToneMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelSelect);
   (tVoid) (oIn >> Frequency);
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioTestToneMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelSelect);
   (tVoid) (oOut << Frequency);
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioTestToneMethodStart::operator==(const midw_mascffi_tclMsgAudioTestToneMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelSelect == roRef.ChannelSelect);
   bResult = bResult && (Frequency == roRef.Frequency);
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioTestToneMethodResult::midw_mascffi_tclMsgAudioTestToneMethodResult(const midw_mascffi_tclMsgAudioTestToneMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ChannelSelect = coRef.ChannelSelect;
   Status = coRef.Status;
}
midw_mascffi_tclMsgAudioTestToneMethodResult& midw_mascffi_tclMsgAudioTestToneMethodResult::operator=(const midw_mascffi_tclMsgAudioTestToneMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ChannelSelect = coRef.ChannelSelect;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioTestToneMethodResult::midw_mascffi_tclMsgAudioTestToneMethodResult()
:ChannelSelect()
,Status()
 {}

tS32 midw_mascffi_tclMsgAudioTestToneMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOTESTTONEMETHODRESULT;
}


midw_mascffi_tclMsgAudioTestToneMethodResult::~midw_mascffi_tclMsgAudioTestToneMethodResult()
{}

tU32 midw_mascffi_tclMsgAudioTestToneMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgAudioTestToneMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelSelect);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioTestToneMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelSelect);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioTestToneMethodResult::operator==(const midw_mascffi_tclMsgAudioTestToneMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelSelect == roRef.ChannelSelect);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgCueStateMethodStart::midw_mascffi_tclMsgCueStateMethodStart(const midw_mascffi_tclMsgCueStateMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   State = coRef.State;
   Source = coRef.Source;
}
midw_mascffi_tclMsgCueStateMethodStart& midw_mascffi_tclMsgCueStateMethodStart::operator=(const midw_mascffi_tclMsgCueStateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgCueStateMethodStart::midw_mascffi_tclMsgCueStateMethodStart()
:State()
,Source()
 {}

tS32 midw_mascffi_tclMsgCueStateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CUESTATEMETHODSTART;
}


midw_mascffi_tclMsgCueStateMethodStart::~midw_mascffi_tclMsgCueStateMethodStart()
{}

tU32 midw_mascffi_tclMsgCueStateMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgCueStateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgCueStateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool midw_mascffi_tclMsgCueStateMethodStart::operator==(const midw_mascffi_tclMsgCueStateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgCueStateMethodResult::midw_mascffi_tclMsgCueStateMethodResult(const midw_mascffi_tclMsgCueStateMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_mascffi_tclMsgCueStateMethodResult& midw_mascffi_tclMsgCueStateMethodResult::operator=(const midw_mascffi_tclMsgCueStateMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgCueStateMethodResult::midw_mascffi_tclMsgCueStateMethodResult()
:ServiceStatus()
 {}

tS32 midw_mascffi_tclMsgCueStateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CUESTATEMETHODRESULT;
}


midw_mascffi_tclMsgCueStateMethodResult::~midw_mascffi_tclMsgCueStateMethodResult()
{}

tU32 midw_mascffi_tclMsgCueStateMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgCueStateMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgCueStateMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgCueStateMethodResult::operator==(const midw_mascffi_tclMsgCueStateMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart::midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart()
 {}

tS32 midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PERFORMONVOLUMELIMITMETHODSTART;
}


midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart::~midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DC_Mode = coRef.DC_Mode;
   AC_Mode = coRef.AC_Mode;
}
midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::operator=(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DC_Mode = coRef.DC_Mode;
   AC_Mode = coRef.AC_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart()
:DC_Mode()
,AC_Mode()
 {}

tS32 midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODSTART;
}


midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::~midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart()
{}

tU32 midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DC_Mode);
   (tVoid) (oIn >> AC_Mode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DC_Mode);
   (tVoid) (oOut << AC_Mode);
   return oOut;
}

tBool midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart::operator==(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DC_Mode == roRef.DC_Mode);
   bResult = bResult && (AC_Mode == roRef.AC_Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::operator=(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult()
:Status()
 {}

tS32 midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SPEAKERDIAGNOSISSTARTMETHODRESULT;
}


midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::~midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult()
{}

tU32 midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult::operator==(const midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSystemMuteMethodStart::midw_mascffi_tclMsgSystemMuteMethodStart(const midw_mascffi_tclMsgSystemMuteMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
}
midw_mascffi_tclMsgSystemMuteMethodStart& midw_mascffi_tclMsgSystemMuteMethodStart::operator=(const midw_mascffi_tclMsgSystemMuteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSystemMuteMethodStart::midw_mascffi_tclMsgSystemMuteMethodStart()
:Requester()
,Resource()
,State()
,Reason()
 {}

tS32 midw_mascffi_tclMsgSystemMuteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SYSTEMMUTEMETHODSTART;
}


midw_mascffi_tclMsgSystemMuteMethodStart::~midw_mascffi_tclMsgSystemMuteMethodStart()
{}

tU32 midw_mascffi_tclMsgSystemMuteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_mascffi_tclMsgSystemMuteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Reason);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSystemMuteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Reason);
   return oOut;
}

tBool midw_mascffi_tclMsgSystemMuteMethodStart::operator==(const midw_mascffi_tclMsgSystemMuteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Reason == roRef.Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSystemMuteMethodResult::midw_mascffi_tclMsgSystemMuteMethodResult(const midw_mascffi_tclMsgSystemMuteMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
}
midw_mascffi_tclMsgSystemMuteMethodResult& midw_mascffi_tclMsgSystemMuteMethodResult::operator=(const midw_mascffi_tclMsgSystemMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSystemMuteMethodResult::midw_mascffi_tclMsgSystemMuteMethodResult()
:Requester()
,Resource()
,State()
 {}

tS32 midw_mascffi_tclMsgSystemMuteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SYSTEMMUTEMETHODRESULT;
}


midw_mascffi_tclMsgSystemMuteMethodResult::~midw_mascffi_tclMsgSystemMuteMethodResult()
{}

tU32 midw_mascffi_tclMsgSystemMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgSystemMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSystemMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   return oOut;
}

tBool midw_mascffi_tclMsgSystemMuteMethodResult::operator==(const midw_mascffi_tclMsgSystemMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_SettingSoundMethodStart::midw_mascffi_tclMsgADAS_SettingSoundMethodStart(const midw_mascffi_tclMsgADAS_SettingSoundMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SettingSound = coRef.SettingSound;
}
midw_mascffi_tclMsgADAS_SettingSoundMethodStart& midw_mascffi_tclMsgADAS_SettingSoundMethodStart::operator=(const midw_mascffi_tclMsgADAS_SettingSoundMethodStart& coRef)
{
   if (this == &coRef) return *this;
   SettingSound = coRef.SettingSound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_SettingSoundMethodStart::midw_mascffi_tclMsgADAS_SettingSoundMethodStart()
:SettingSound()
 {}

tS32 midw_mascffi_tclMsgADAS_SettingSoundMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODSTART;
}


midw_mascffi_tclMsgADAS_SettingSoundMethodStart::~midw_mascffi_tclMsgADAS_SettingSoundMethodStart()
{}

tU32 midw_mascffi_tclMsgADAS_SettingSoundMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_SettingSoundMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SettingSound);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_SettingSoundMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SettingSound);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_SettingSoundMethodStart::operator==(const midw_mascffi_tclMsgADAS_SettingSoundMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SettingSound == roRef.SettingSound);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_SettingSoundMethodResult::midw_mascffi_tclMsgADAS_SettingSoundMethodResult(const midw_mascffi_tclMsgADAS_SettingSoundMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ServiceStatus = coRef.ServiceStatus;
}
midw_mascffi_tclMsgADAS_SettingSoundMethodResult& midw_mascffi_tclMsgADAS_SettingSoundMethodResult::operator=(const midw_mascffi_tclMsgADAS_SettingSoundMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ServiceStatus = coRef.ServiceStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_SettingSoundMethodResult::midw_mascffi_tclMsgADAS_SettingSoundMethodResult()
:ServiceStatus()
 {}

tS32 midw_mascffi_tclMsgADAS_SettingSoundMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_SETTINGSOUNDMETHODRESULT;
}


midw_mascffi_tclMsgADAS_SettingSoundMethodResult::~midw_mascffi_tclMsgADAS_SettingSoundMethodResult()
{}

tU32 midw_mascffi_tclMsgADAS_SettingSoundMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_SettingSoundMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ServiceStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_SettingSoundMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ServiceStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_SettingSoundMethodResult::operator==(const midw_mascffi_tclMsgADAS_SettingSoundMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ServiceStatus == roRef.ServiceStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEntertainmentMuteMethodStart::midw_mascffi_tclMsgEntertainmentMuteMethodStart(const midw_mascffi_tclMsgEntertainmentMuteMethodStart& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
}
midw_mascffi_tclMsgEntertainmentMuteMethodStart& midw_mascffi_tclMsgEntertainmentMuteMethodStart::operator=(const midw_mascffi_tclMsgEntertainmentMuteMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   Reason = coRef.Reason;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgEntertainmentMuteMethodStart::midw_mascffi_tclMsgEntertainmentMuteMethodStart()
:Requester()
,Resource()
,State()
,Reason()
 {}

tS32 midw_mascffi_tclMsgEntertainmentMuteMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODSTART;
}


midw_mascffi_tclMsgEntertainmentMuteMethodStart::~midw_mascffi_tclMsgEntertainmentMuteMethodStart()
{}

tU32 midw_mascffi_tclMsgEntertainmentMuteMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_mascffi_tclMsgEntertainmentMuteMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Reason);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEntertainmentMuteMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   (tVoid) (oOut << Reason);
   return oOut;
}

tBool midw_mascffi_tclMsgEntertainmentMuteMethodStart::operator==(const midw_mascffi_tclMsgEntertainmentMuteMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Reason == roRef.Reason);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEntertainmentMuteMethodResult::midw_mascffi_tclMsgEntertainmentMuteMethodResult(const midw_mascffi_tclMsgEntertainmentMuteMethodResult& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
}
midw_mascffi_tclMsgEntertainmentMuteMethodResult& midw_mascffi_tclMsgEntertainmentMuteMethodResult::operator=(const midw_mascffi_tclMsgEntertainmentMuteMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Requester = coRef.Requester;
   Resource = coRef.Resource;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgEntertainmentMuteMethodResult::midw_mascffi_tclMsgEntertainmentMuteMethodResult()
:Requester()
,Resource()
,State()
 {}

tS32 midw_mascffi_tclMsgEntertainmentMuteMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENTERTAINMENTMUTEMETHODRESULT;
}


midw_mascffi_tclMsgEntertainmentMuteMethodResult::~midw_mascffi_tclMsgEntertainmentMuteMethodResult()
{}

tU32 midw_mascffi_tclMsgEntertainmentMuteMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgEntertainmentMuteMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Requester);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEntertainmentMuteMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Requester);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << State);
   return oOut;
}

tBool midw_mascffi_tclMsgEntertainmentMuteMethodResult::operator==(const midw_mascffi_tclMsgEntertainmentMuteMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Requester == roRef.Requester);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart::midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart()
 {}

tS32 midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODSTART;
}


midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart::~midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodStart()
{}

//=============================================================================

midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult::midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult()
 {}

tS32 midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MCANBOSEAMP_VERSIONINFOMETHODRESULT;
}


midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult::~midw_mascffi_tclMsgMCANBoseAmp_VersionInfoMethodResult()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeModeStatusUpReg::midw_mascffi_tclMsgVolumeModeStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeModeStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSUPREG;
}


midw_mascffi_tclMsgVolumeModeStatusUpReg::~midw_mascffi_tclMsgVolumeModeStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeModeStatusRelUpReg::midw_mascffi_tclMsgVolumeModeStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeModeStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSRELUPREG;
}


midw_mascffi_tclMsgVolumeModeStatusRelUpReg::~midw_mascffi_tclMsgVolumeModeStatusRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeModeStatusGet::midw_mascffi_tclMsgVolumeModeStatusGet()
 {}

tS32 midw_mascffi_tclMsgVolumeModeStatusGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSGET;
}


midw_mascffi_tclMsgVolumeModeStatusGet::~midw_mascffi_tclMsgVolumeModeStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeModeStatusStatus::midw_mascffi_tclMsgVolumeModeStatusStatus(const midw_mascffi_tclMsgVolumeModeStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgVolumeModeStatusStatus& midw_mascffi_tclMsgVolumeModeStatusStatus::operator=(const midw_mascffi_tclMsgVolumeModeStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgVolumeModeStatusStatus::midw_mascffi_tclMsgVolumeModeStatusStatus()
:VolumeMode()
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgVolumeModeStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEMODESTATUSSTATUS;
}


midw_mascffi_tclMsgVolumeModeStatusStatus::~midw_mascffi_tclMsgVolumeModeStatusStatus()
{}

tU32 midw_mascffi_tclMsgVolumeModeStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgVolumeModeStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeMode);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeModeStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeMode);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeModeStatusStatus::operator==(const midw_mascffi_tclMsgVolumeModeStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeMode == roRef.VolumeMode);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgVolumeUpReg::midw_mascffi_tclMsgVolumeUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEUPREG;
}


midw_mascffi_tclMsgVolumeUpReg::~midw_mascffi_tclMsgVolumeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeRelUpReg::midw_mascffi_tclMsgVolumeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMERELUPREG;
}


midw_mascffi_tclMsgVolumeRelUpReg::~midw_mascffi_tclMsgVolumeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeGet::midw_mascffi_tclMsgVolumeGet()
 {}

tS32 midw_mascffi_tclMsgVolumeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMEGET;
}


midw_mascffi_tclMsgVolumeGet::~midw_mascffi_tclMsgVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeSet::midw_mascffi_tclMsgVolumeSet(const midw_mascffi_tclMsgVolumeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeType = coRef.VolumeType;
   Resource = coRef.Resource;
   Volume = coRef.Volume;
}
midw_mascffi_tclMsgVolumeSet& midw_mascffi_tclMsgVolumeSet::operator=(const midw_mascffi_tclMsgVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeType = coRef.VolumeType;
   Resource = coRef.Resource;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgVolumeSet::midw_mascffi_tclMsgVolumeSet()
:VolumeType()
,Resource()
,Volume(0)
 {}

tS32 midw_mascffi_tclMsgVolumeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMESET;
}


midw_mascffi_tclMsgVolumeSet::~midw_mascffi_tclMsgVolumeSet()
{}

tU32 midw_mascffi_tclMsgVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeSet::operator==(const midw_mascffi_tclMsgVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeType == roRef.VolumeType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeStatus::midw_mascffi_tclMsgVolumeStatus(const midw_mascffi_tclMsgVolumeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Volume = coRef.Volume;
   Source = coRef.Source;
}
midw_mascffi_tclMsgVolumeStatus& midw_mascffi_tclMsgVolumeStatus::operator=(const midw_mascffi_tclMsgVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeMode = coRef.VolumeMode;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   Volume = coRef.Volume;
   Source = coRef.Source;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgVolumeStatus::midw_mascffi_tclMsgVolumeStatus()
:VolumeMode()
,Resource()
,Channel()
,Volume(0)
,Source()
 {}

tS32 midw_mascffi_tclMsgVolumeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMESTATUS;
}


midw_mascffi_tclMsgVolumeStatus::~midw_mascffi_tclMsgVolumeStatus()
{}

tU32 midw_mascffi_tclMsgVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_mascffi_tclMsgVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeMode);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   (tVoid) (oIn >> Volume);
   (tVoid) (oIn >> Source);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeMode);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   (tVoid) (oOut << Volume);
   (tVoid) (oOut << Source);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeStatus::operator==(const midw_mascffi_tclMsgVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeMode == roRef.VolumeMode);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   bResult = bResult && (Volume == roRef.Volume);
   bResult = bResult && (Source == roRef.Source);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgBeepStatusUpReg::midw_mascffi_tclMsgBeepStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgBeepStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPSTATUSUPREG;
}


midw_mascffi_tclMsgBeepStatusUpReg::~midw_mascffi_tclMsgBeepStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBeepStatusRelUpReg::midw_mascffi_tclMsgBeepStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgBeepStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPSTATUSRELUPREG;
}


midw_mascffi_tclMsgBeepStatusRelUpReg::~midw_mascffi_tclMsgBeepStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBeepStatusStatus::midw_mascffi_tclMsgBeepStatusStatus(const midw_mascffi_tclMsgBeepStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   BeepStatus = coRef.BeepStatus;
   u32Token = coRef.u32Token;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgBeepStatusStatus& midw_mascffi_tclMsgBeepStatusStatus::operator=(const midw_mascffi_tclMsgBeepStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   BeepStatus = coRef.BeepStatus;
   u32Token = coRef.u32Token;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBeepStatusStatus::midw_mascffi_tclMsgBeepStatusStatus()
:BeepStatus()
,u32Token(0)
,Resource()
 {}

tS32 midw_mascffi_tclMsgBeepStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPSTATUSSTATUS;
}


midw_mascffi_tclMsgBeepStatusStatus::~midw_mascffi_tclMsgBeepStatusStatus()
{}

tU32 midw_mascffi_tclMsgBeepStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_mascffi_tclMsgBeepStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepStatus);
   (tVoid) (oIn >> u32Token);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBeepStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepStatus);
   (tVoid) (oOut << u32Token);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgBeepStatusStatus::operator==(const midw_mascffi_tclMsgBeepStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepStatus == roRef.BeepStatus);
   bResult = bResult && (u32Token == roRef.u32Token);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgGalaUpReg::midw_mascffi_tclMsgGalaUpReg()
 {}

tS32 midw_mascffi_tclMsgGalaUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GALAUPREG;
}


midw_mascffi_tclMsgGalaUpReg::~midw_mascffi_tclMsgGalaUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgGalaRelUpReg::midw_mascffi_tclMsgGalaRelUpReg()
 {}

tS32 midw_mascffi_tclMsgGalaRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GALARELUPREG;
}


midw_mascffi_tclMsgGalaRelUpReg::~midw_mascffi_tclMsgGalaRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgGalaGet::midw_mascffi_tclMsgGalaGet()
 {}

tS32 midw_mascffi_tclMsgGalaGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GALAGET;
}


midw_mascffi_tclMsgGalaGet::~midw_mascffi_tclMsgGalaGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgGalaSet::midw_mascffi_tclMsgGalaSet(const midw_mascffi_tclMsgGalaSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgGalaSet& midw_mascffi_tclMsgGalaSet::operator=(const midw_mascffi_tclMsgGalaSet& coRef)
{
   if (this == &coRef) return *this;
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgGalaSet::midw_mascffi_tclMsgGalaSet()
:GalaLevel()
,Resource()
 {}

tS32 midw_mascffi_tclMsgGalaSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GALASET;
}


midw_mascffi_tclMsgGalaSet::~midw_mascffi_tclMsgGalaSet()
{}

tU32 midw_mascffi_tclMsgGalaSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgGalaSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GalaLevel);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgGalaSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GalaLevel);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgGalaSet::operator==(const midw_mascffi_tclMsgGalaSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GalaLevel == roRef.GalaLevel);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgGalaStatus::midw_mascffi_tclMsgGalaStatus(const midw_mascffi_tclMsgGalaStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgGalaStatus& midw_mascffi_tclMsgGalaStatus::operator=(const midw_mascffi_tclMsgGalaStatus& coRef)
{
   if (this == &coRef) return *this;
   GalaLevel = coRef.GalaLevel;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgGalaStatus::midw_mascffi_tclMsgGalaStatus()
:GalaLevel()
,Resource()
 {}

tS32 midw_mascffi_tclMsgGalaStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GALASTATUS;
}


midw_mascffi_tclMsgGalaStatus::~midw_mascffi_tclMsgGalaStatus()
{}

tU32 midw_mascffi_tclMsgGalaStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgGalaStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GalaLevel);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgGalaStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GalaLevel);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgGalaStatus::operator==(const midw_mascffi_tclMsgGalaStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GalaLevel == roRef.GalaLevel);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRemoveWelcomeSoundUpReg::midw_mascffi_tclMsgRemoveWelcomeSoundUpReg()
 {}

tS32 midw_mascffi_tclMsgRemoveWelcomeSoundUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDUPREG;
}


midw_mascffi_tclMsgRemoveWelcomeSoundUpReg::~midw_mascffi_tclMsgRemoveWelcomeSoundUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRemoveWelcomeSoundGet::midw_mascffi_tclMsgRemoveWelcomeSoundGet()
 {}

tS32 midw_mascffi_tclMsgRemoveWelcomeSoundGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDGET;
}


midw_mascffi_tclMsgRemoveWelcomeSoundGet::~midw_mascffi_tclMsgRemoveWelcomeSoundGet()
{}

//=============================================================================

midw_mascffi_tclMsgRemoveWelcomeSoundSet::midw_mascffi_tclMsgRemoveWelcomeSoundSet()
 {}

tS32 midw_mascffi_tclMsgRemoveWelcomeSoundSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDSET;
}


midw_mascffi_tclMsgRemoveWelcomeSoundSet::~midw_mascffi_tclMsgRemoveWelcomeSoundSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRemoveWelcomeSoundStatus::midw_mascffi_tclMsgRemoveWelcomeSoundStatus(const midw_mascffi_tclMsgRemoveWelcomeSoundStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   updatestatus = coRef.updatestatus;
}
midw_mascffi_tclMsgRemoveWelcomeSoundStatus& midw_mascffi_tclMsgRemoveWelcomeSoundStatus::operator=(const midw_mascffi_tclMsgRemoveWelcomeSoundStatus& coRef)
{
   if (this == &coRef) return *this;
   updatestatus = coRef.updatestatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRemoveWelcomeSoundStatus::midw_mascffi_tclMsgRemoveWelcomeSoundStatus()
:updatestatus(0)
 {}

tS32 midw_mascffi_tclMsgRemoveWelcomeSoundStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REMOVEWELCOMESOUNDSTATUS;
}


midw_mascffi_tclMsgRemoveWelcomeSoundStatus::~midw_mascffi_tclMsgRemoveWelcomeSoundStatus()
{}

tU32 midw_mascffi_tclMsgRemoveWelcomeSoundStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRemoveWelcomeSoundStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> updatestatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRemoveWelcomeSoundStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << updatestatus);
   return oOut;
}

tBool midw_mascffi_tclMsgRemoveWelcomeSoundStatus::operator==(const midw_mascffi_tclMsgRemoveWelcomeSoundStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (updatestatus == roRef.updatestatus);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgBalanceUpReg::midw_mascffi_tclMsgBalanceUpReg()
 {}

tS32 midw_mascffi_tclMsgBalanceUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BALANCEUPREG;
}


midw_mascffi_tclMsgBalanceUpReg::~midw_mascffi_tclMsgBalanceUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBalanceRelUpReg::midw_mascffi_tclMsgBalanceRelUpReg()
 {}

tS32 midw_mascffi_tclMsgBalanceRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BALANCERELUPREG;
}


midw_mascffi_tclMsgBalanceRelUpReg::~midw_mascffi_tclMsgBalanceRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBalanceGet::midw_mascffi_tclMsgBalanceGet()
 {}

tS32 midw_mascffi_tclMsgBalanceGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BALANCEGET;
}


midw_mascffi_tclMsgBalanceGet::~midw_mascffi_tclMsgBalanceGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBalanceSet::midw_mascffi_tclMsgBalanceSet(const midw_mascffi_tclMsgBalanceSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Balance = coRef.Balance;
}
midw_mascffi_tclMsgBalanceSet& midw_mascffi_tclMsgBalanceSet::operator=(const midw_mascffi_tclMsgBalanceSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Balance = coRef.Balance;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBalanceSet::midw_mascffi_tclMsgBalanceSet()
:SoundType()
,Resource()
,Balance(0)
 {}

tS32 midw_mascffi_tclMsgBalanceSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BALANCESET;
}


midw_mascffi_tclMsgBalanceSet::~midw_mascffi_tclMsgBalanceSet()
{}

tU32 midw_mascffi_tclMsgBalanceSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgBalanceSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Balance);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBalanceSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Balance);
   return oOut;
}

tBool midw_mascffi_tclMsgBalanceSet::operator==(const midw_mascffi_tclMsgBalanceSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Balance == roRef.Balance);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBalanceStatus::midw_mascffi_tclMsgBalanceStatus(const midw_mascffi_tclMsgBalanceStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Balance = coRef.Balance;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgBalanceStatus& midw_mascffi_tclMsgBalanceStatus::operator=(const midw_mascffi_tclMsgBalanceStatus& coRef)
{
   if (this == &coRef) return *this;
   Balance = coRef.Balance;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBalanceStatus::midw_mascffi_tclMsgBalanceStatus()
:Balance(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgBalanceStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BALANCESTATUS;
}


midw_mascffi_tclMsgBalanceStatus::~midw_mascffi_tclMsgBalanceStatus()
{}

tU32 midw_mascffi_tclMsgBalanceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgBalanceStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Balance);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBalanceStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Balance);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgBalanceStatus::operator==(const midw_mascffi_tclMsgBalanceStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Balance == roRef.Balance);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgLoudnessUpReg::midw_mascffi_tclMsgLoudnessUpReg()
 {}

tS32 midw_mascffi_tclMsgLoudnessUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LOUDNESSUPREG;
}


midw_mascffi_tclMsgLoudnessUpReg::~midw_mascffi_tclMsgLoudnessUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgLoudnessRelUpReg::midw_mascffi_tclMsgLoudnessRelUpReg()
 {}

tS32 midw_mascffi_tclMsgLoudnessRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LOUDNESSRELUPREG;
}


midw_mascffi_tclMsgLoudnessRelUpReg::~midw_mascffi_tclMsgLoudnessRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgLoudnessGet::midw_mascffi_tclMsgLoudnessGet()
 {}

tS32 midw_mascffi_tclMsgLoudnessGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LOUDNESSGET;
}


midw_mascffi_tclMsgLoudnessGet::~midw_mascffi_tclMsgLoudnessGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgLoudnessSet::midw_mascffi_tclMsgLoudnessSet(const midw_mascffi_tclMsgLoudnessSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Loudness = coRef.Loudness;
}
midw_mascffi_tclMsgLoudnessSet& midw_mascffi_tclMsgLoudnessSet::operator=(const midw_mascffi_tclMsgLoudnessSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Loudness = coRef.Loudness;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgLoudnessSet::midw_mascffi_tclMsgLoudnessSet()
:SoundType()
,Resource()
,Loudness(0)
 {}

tS32 midw_mascffi_tclMsgLoudnessSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LOUDNESSSET;
}


midw_mascffi_tclMsgLoudnessSet::~midw_mascffi_tclMsgLoudnessSet()
{}

tU32 midw_mascffi_tclMsgLoudnessSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgLoudnessSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Loudness);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgLoudnessSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Loudness);
   return oOut;
}

tBool midw_mascffi_tclMsgLoudnessSet::operator==(const midw_mascffi_tclMsgLoudnessSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Loudness == roRef.Loudness);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgLoudnessStatus::midw_mascffi_tclMsgLoudnessStatus(const midw_mascffi_tclMsgLoudnessStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Loudness = coRef.Loudness;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgLoudnessStatus& midw_mascffi_tclMsgLoudnessStatus::operator=(const midw_mascffi_tclMsgLoudnessStatus& coRef)
{
   if (this == &coRef) return *this;
   Loudness = coRef.Loudness;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgLoudnessStatus::midw_mascffi_tclMsgLoudnessStatus()
:Loudness(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgLoudnessStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LOUDNESSSTATUS;
}


midw_mascffi_tclMsgLoudnessStatus::~midw_mascffi_tclMsgLoudnessStatus()
{}

tU32 midw_mascffi_tclMsgLoudnessStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgLoudnessStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Loudness);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgLoudnessStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Loudness);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgLoudnessStatus::operator==(const midw_mascffi_tclMsgLoudnessStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Loudness == roRef.Loudness);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgBassUpReg::midw_mascffi_tclMsgBassUpReg()
 {}

tS32 midw_mascffi_tclMsgBassUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BASSUPREG;
}


midw_mascffi_tclMsgBassUpReg::~midw_mascffi_tclMsgBassUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBassRelUpReg::midw_mascffi_tclMsgBassRelUpReg()
 {}

tS32 midw_mascffi_tclMsgBassRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BASSRELUPREG;
}


midw_mascffi_tclMsgBassRelUpReg::~midw_mascffi_tclMsgBassRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBassGet::midw_mascffi_tclMsgBassGet()
 {}

tS32 midw_mascffi_tclMsgBassGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BASSGET;
}


midw_mascffi_tclMsgBassGet::~midw_mascffi_tclMsgBassGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBassSet::midw_mascffi_tclMsgBassSet(const midw_mascffi_tclMsgBassSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Bass = coRef.Bass;
}
midw_mascffi_tclMsgBassSet& midw_mascffi_tclMsgBassSet::operator=(const midw_mascffi_tclMsgBassSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Bass = coRef.Bass;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBassSet::midw_mascffi_tclMsgBassSet()
:SoundType()
,Resource()
,Bass(0)
 {}

tS32 midw_mascffi_tclMsgBassSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BASSSET;
}


midw_mascffi_tclMsgBassSet::~midw_mascffi_tclMsgBassSet()
{}

tU32 midw_mascffi_tclMsgBassSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgBassSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Bass);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBassSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Bass);
   return oOut;
}

tBool midw_mascffi_tclMsgBassSet::operator==(const midw_mascffi_tclMsgBassSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Bass == roRef.Bass);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBassStatus::midw_mascffi_tclMsgBassStatus(const midw_mascffi_tclMsgBassStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Bass = coRef.Bass;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgBassStatus& midw_mascffi_tclMsgBassStatus::operator=(const midw_mascffi_tclMsgBassStatus& coRef)
{
   if (this == &coRef) return *this;
   Bass = coRef.Bass;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBassStatus::midw_mascffi_tclMsgBassStatus()
:Bass(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgBassStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BASSSTATUS;
}


midw_mascffi_tclMsgBassStatus::~midw_mascffi_tclMsgBassStatus()
{}

tU32 midw_mascffi_tclMsgBassStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgBassStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Bass);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBassStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Bass);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgBassStatus::operator==(const midw_mascffi_tclMsgBassStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Bass == roRef.Bass);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgTrebleUpReg::midw_mascffi_tclMsgTrebleUpReg()
 {}

tS32 midw_mascffi_tclMsgTrebleUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_TREBLEUPREG;
}


midw_mascffi_tclMsgTrebleUpReg::~midw_mascffi_tclMsgTrebleUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgTrebleRelUpReg::midw_mascffi_tclMsgTrebleRelUpReg()
 {}

tS32 midw_mascffi_tclMsgTrebleRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_TREBLERELUPREG;
}


midw_mascffi_tclMsgTrebleRelUpReg::~midw_mascffi_tclMsgTrebleRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgTrebleGet::midw_mascffi_tclMsgTrebleGet()
 {}

tS32 midw_mascffi_tclMsgTrebleGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_TREBLEGET;
}


midw_mascffi_tclMsgTrebleGet::~midw_mascffi_tclMsgTrebleGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgTrebleSet::midw_mascffi_tclMsgTrebleSet(const midw_mascffi_tclMsgTrebleSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Treble = coRef.Treble;
}
midw_mascffi_tclMsgTrebleSet& midw_mascffi_tclMsgTrebleSet::operator=(const midw_mascffi_tclMsgTrebleSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Treble = coRef.Treble;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgTrebleSet::midw_mascffi_tclMsgTrebleSet()
:SoundType()
,Resource()
,Treble(0)
 {}

tS32 midw_mascffi_tclMsgTrebleSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_TREBLESET;
}


midw_mascffi_tclMsgTrebleSet::~midw_mascffi_tclMsgTrebleSet()
{}

tU32 midw_mascffi_tclMsgTrebleSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgTrebleSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Treble);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgTrebleSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Treble);
   return oOut;
}

tBool midw_mascffi_tclMsgTrebleSet::operator==(const midw_mascffi_tclMsgTrebleSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Treble == roRef.Treble);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgTrebleStatus::midw_mascffi_tclMsgTrebleStatus(const midw_mascffi_tclMsgTrebleStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Treble = coRef.Treble;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgTrebleStatus& midw_mascffi_tclMsgTrebleStatus::operator=(const midw_mascffi_tclMsgTrebleStatus& coRef)
{
   if (this == &coRef) return *this;
   Treble = coRef.Treble;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgTrebleStatus::midw_mascffi_tclMsgTrebleStatus()
:Treble(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgTrebleStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_TREBLESTATUS;
}


midw_mascffi_tclMsgTrebleStatus::~midw_mascffi_tclMsgTrebleStatus()
{}

tU32 midw_mascffi_tclMsgTrebleStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgTrebleStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Treble);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgTrebleStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Treble);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgTrebleStatus::operator==(const midw_mascffi_tclMsgTrebleStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Treble == roRef.Treble);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgFaderUpReg::midw_mascffi_tclMsgFaderUpReg()
 {}

tS32 midw_mascffi_tclMsgFaderUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERUPREG;
}


midw_mascffi_tclMsgFaderUpReg::~midw_mascffi_tclMsgFaderUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgFaderRelUpReg::midw_mascffi_tclMsgFaderRelUpReg()
 {}

tS32 midw_mascffi_tclMsgFaderRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERRELUPREG;
}


midw_mascffi_tclMsgFaderRelUpReg::~midw_mascffi_tclMsgFaderRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgFaderGet::midw_mascffi_tclMsgFaderGet()
 {}

tS32 midw_mascffi_tclMsgFaderGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERGET;
}


midw_mascffi_tclMsgFaderGet::~midw_mascffi_tclMsgFaderGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgFaderSet::midw_mascffi_tclMsgFaderSet(const midw_mascffi_tclMsgFaderSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Fader = coRef.Fader;
}
midw_mascffi_tclMsgFaderSet& midw_mascffi_tclMsgFaderSet::operator=(const midw_mascffi_tclMsgFaderSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Fader = coRef.Fader;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgFaderSet::midw_mascffi_tclMsgFaderSet()
:SoundType()
,Resource()
,Fader(0)
 {}

tS32 midw_mascffi_tclMsgFaderSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERSET;
}


midw_mascffi_tclMsgFaderSet::~midw_mascffi_tclMsgFaderSet()
{}

tU32 midw_mascffi_tclMsgFaderSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgFaderSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Fader);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgFaderSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Fader);
   return oOut;
}

tBool midw_mascffi_tclMsgFaderSet::operator==(const midw_mascffi_tclMsgFaderSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Fader == roRef.Fader);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgFaderStatus::midw_mascffi_tclMsgFaderStatus(const midw_mascffi_tclMsgFaderStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Fader = coRef.Fader;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgFaderStatus& midw_mascffi_tclMsgFaderStatus::operator=(const midw_mascffi_tclMsgFaderStatus& coRef)
{
   if (this == &coRef) return *this;
   Fader = coRef.Fader;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgFaderStatus::midw_mascffi_tclMsgFaderStatus()
:Fader(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgFaderStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERSTATUS;
}


midw_mascffi_tclMsgFaderStatus::~midw_mascffi_tclMsgFaderStatus()
{}

tU32 midw_mascffi_tclMsgFaderStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgFaderStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Fader);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgFaderStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Fader);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgFaderStatus::operator==(const midw_mascffi_tclMsgFaderStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Fader == roRef.Fader);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgMidRangeUpReg::midw_mascffi_tclMsgMidRangeUpReg()
 {}

tS32 midw_mascffi_tclMsgMidRangeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MIDRANGEUPREG;
}


midw_mascffi_tclMsgMidRangeUpReg::~midw_mascffi_tclMsgMidRangeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgMidRangeRelUpReg::midw_mascffi_tclMsgMidRangeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgMidRangeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MIDRANGERELUPREG;
}


midw_mascffi_tclMsgMidRangeRelUpReg::~midw_mascffi_tclMsgMidRangeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgMidRangeGet::midw_mascffi_tclMsgMidRangeGet()
 {}

tS32 midw_mascffi_tclMsgMidRangeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MIDRANGEGET;
}


midw_mascffi_tclMsgMidRangeGet::~midw_mascffi_tclMsgMidRangeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMidRangeSet::midw_mascffi_tclMsgMidRangeSet(const midw_mascffi_tclMsgMidRangeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   MidRange = coRef.MidRange;
}
midw_mascffi_tclMsgMidRangeSet& midw_mascffi_tclMsgMidRangeSet::operator=(const midw_mascffi_tclMsgMidRangeSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   MidRange = coRef.MidRange;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMidRangeSet::midw_mascffi_tclMsgMidRangeSet()
:SoundType()
,Resource()
,MidRange(0)
 {}

tS32 midw_mascffi_tclMsgMidRangeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MIDRANGESET;
}


midw_mascffi_tclMsgMidRangeSet::~midw_mascffi_tclMsgMidRangeSet()
{}

tU32 midw_mascffi_tclMsgMidRangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgMidRangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> MidRange);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMidRangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << MidRange);
   return oOut;
}

tBool midw_mascffi_tclMsgMidRangeSet::operator==(const midw_mascffi_tclMsgMidRangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (MidRange == roRef.MidRange);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMidRangeStatus::midw_mascffi_tclMsgMidRangeStatus(const midw_mascffi_tclMsgMidRangeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   MidRange = coRef.MidRange;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgMidRangeStatus& midw_mascffi_tclMsgMidRangeStatus::operator=(const midw_mascffi_tclMsgMidRangeStatus& coRef)
{
   if (this == &coRef) return *this;
   MidRange = coRef.MidRange;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMidRangeStatus::midw_mascffi_tclMsgMidRangeStatus()
:MidRange(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgMidRangeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MIDRANGESTATUS;
}


midw_mascffi_tclMsgMidRangeStatus::~midw_mascffi_tclMsgMidRangeStatus()
{}

tU32 midw_mascffi_tclMsgMidRangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgMidRangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MidRange);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMidRangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MidRange);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgMidRangeStatus::operator==(const midw_mascffi_tclMsgMidRangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MidRange == roRef.MidRange);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgMemSoundUpReg::midw_mascffi_tclMsgMemSoundUpReg()
 {}

tS32 midw_mascffi_tclMsgMemSoundUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MEMSOUNDUPREG;
}


midw_mascffi_tclMsgMemSoundUpReg::~midw_mascffi_tclMsgMemSoundUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgMemSoundRelUpReg::midw_mascffi_tclMsgMemSoundRelUpReg()
 {}

tS32 midw_mascffi_tclMsgMemSoundRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MEMSOUNDRELUPREG;
}


midw_mascffi_tclMsgMemSoundRelUpReg::~midw_mascffi_tclMsgMemSoundRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMemSoundSet::midw_mascffi_tclMsgMemSoundSet(const midw_mascffi_tclMsgMemSoundSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Sound = coRef.Sound;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgMemSoundSet& midw_mascffi_tclMsgMemSoundSet::operator=(const midw_mascffi_tclMsgMemSoundSet& coRef)
{
   if (this == &coRef) return *this;
   Sound = coRef.Sound;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMemSoundSet::midw_mascffi_tclMsgMemSoundSet()
:Sound()
,Resource()
 {}

tS32 midw_mascffi_tclMsgMemSoundSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MEMSOUNDSET;
}


midw_mascffi_tclMsgMemSoundSet::~midw_mascffi_tclMsgMemSoundSet()
{}

tU32 midw_mascffi_tclMsgMemSoundSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgMemSoundSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sound);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMemSoundSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sound);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgMemSoundSet::operator==(const midw_mascffi_tclMsgMemSoundSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sound == roRef.Sound);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMemSoundStatus::midw_mascffi_tclMsgMemSoundStatus(const midw_mascffi_tclMsgMemSoundStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Sound = coRef.Sound;
   Resource = coRef.Resource;
   MemStatus = coRef.MemStatus;
}
midw_mascffi_tclMsgMemSoundStatus& midw_mascffi_tclMsgMemSoundStatus::operator=(const midw_mascffi_tclMsgMemSoundStatus& coRef)
{
   if (this == &coRef) return *this;
   Sound = coRef.Sound;
   Resource = coRef.Resource;
   MemStatus = coRef.MemStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMemSoundStatus::midw_mascffi_tclMsgMemSoundStatus()
:Sound()
,Resource()
,MemStatus()
 {}

tS32 midw_mascffi_tclMsgMemSoundStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MEMSOUNDSTATUS;
}


midw_mascffi_tclMsgMemSoundStatus::~midw_mascffi_tclMsgMemSoundStatus()
{}

tU32 midw_mascffi_tclMsgMemSoundStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgMemSoundStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Sound);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> MemStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMemSoundStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Sound);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << MemStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgMemSoundStatus::operator==(const midw_mascffi_tclMsgMemSoundStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Sound == roRef.Sound);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (MemStatus == roRef.MemStatus);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgFaderActivationStatusUpReg::midw_mascffi_tclMsgFaderActivationStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgFaderActivationStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSUPREG;
}


midw_mascffi_tclMsgFaderActivationStatusUpReg::~midw_mascffi_tclMsgFaderActivationStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgFaderActivationStatusRelUpReg::midw_mascffi_tclMsgFaderActivationStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgFaderActivationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSRELUPREG;
}


midw_mascffi_tclMsgFaderActivationStatusRelUpReg::~midw_mascffi_tclMsgFaderActivationStatusRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgFaderActivationStatusGet::midw_mascffi_tclMsgFaderActivationStatusGet()
 {}

tS32 midw_mascffi_tclMsgFaderActivationStatusGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSGET;
}


midw_mascffi_tclMsgFaderActivationStatusGet::~midw_mascffi_tclMsgFaderActivationStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgFaderActivationStatusStatus::midw_mascffi_tclMsgFaderActivationStatusStatus(const midw_mascffi_tclMsgFaderActivationStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   FaderStatus = coRef.FaderStatus;
}
midw_mascffi_tclMsgFaderActivationStatusStatus& midw_mascffi_tclMsgFaderActivationStatusStatus::operator=(const midw_mascffi_tclMsgFaderActivationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   FaderStatus = coRef.FaderStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgFaderActivationStatusStatus::midw_mascffi_tclMsgFaderActivationStatusStatus()
:FaderStatus()
 {}

tS32 midw_mascffi_tclMsgFaderActivationStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FADERACTIVATIONSTATUSSTATUS;
}


midw_mascffi_tclMsgFaderActivationStatusStatus::~midw_mascffi_tclMsgFaderActivationStatusStatus()
{}

tU32 midw_mascffi_tclMsgFaderActivationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgFaderActivationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FaderStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgFaderActivationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FaderStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgFaderActivationStatusStatus::operator==(const midw_mascffi_tclMsgFaderActivationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FaderStatus == roRef.FaderStatus);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgDynamicCompressionUpReg::midw_mascffi_tclMsgDynamicCompressionUpReg()
 {}

tS32 midw_mascffi_tclMsgDynamicCompressionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONUPREG;
}


midw_mascffi_tclMsgDynamicCompressionUpReg::~midw_mascffi_tclMsgDynamicCompressionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDynamicCompressionRelUpReg::midw_mascffi_tclMsgDynamicCompressionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgDynamicCompressionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONRELUPREG;
}


midw_mascffi_tclMsgDynamicCompressionRelUpReg::~midw_mascffi_tclMsgDynamicCompressionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDynamicCompressionGet::midw_mascffi_tclMsgDynamicCompressionGet()
 {}

tS32 midw_mascffi_tclMsgDynamicCompressionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONGET;
}


midw_mascffi_tclMsgDynamicCompressionGet::~midw_mascffi_tclMsgDynamicCompressionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgDynamicCompressionSet::midw_mascffi_tclMsgDynamicCompressionSet(const midw_mascffi_tclMsgDynamicCompressionSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DynComp = coRef.DynComp;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgDynamicCompressionSet& midw_mascffi_tclMsgDynamicCompressionSet::operator=(const midw_mascffi_tclMsgDynamicCompressionSet& coRef)
{
   if (this == &coRef) return *this;
   DynComp = coRef.DynComp;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgDynamicCompressionSet::midw_mascffi_tclMsgDynamicCompressionSet()
:DynComp()
,Resource()
 {}

tS32 midw_mascffi_tclMsgDynamicCompressionSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSET;
}


midw_mascffi_tclMsgDynamicCompressionSet::~midw_mascffi_tclMsgDynamicCompressionSet()
{}

tU32 midw_mascffi_tclMsgDynamicCompressionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgDynamicCompressionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DynComp);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgDynamicCompressionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DynComp);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgDynamicCompressionSet::operator==(const midw_mascffi_tclMsgDynamicCompressionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DynComp == roRef.DynComp);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgDynamicCompressionStatus::midw_mascffi_tclMsgDynamicCompressionStatus(const midw_mascffi_tclMsgDynamicCompressionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DynCompression = coRef.DynCompression;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgDynamicCompressionStatus& midw_mascffi_tclMsgDynamicCompressionStatus::operator=(const midw_mascffi_tclMsgDynamicCompressionStatus& coRef)
{
   if (this == &coRef) return *this;
   DynCompression = coRef.DynCompression;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgDynamicCompressionStatus::midw_mascffi_tclMsgDynamicCompressionStatus()
:DynCompression()
,Resource()
 {}

tS32 midw_mascffi_tclMsgDynamicCompressionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DYNAMICCOMPRESSIONSTATUS;
}


midw_mascffi_tclMsgDynamicCompressionStatus::~midw_mascffi_tclMsgDynamicCompressionStatus()
{}

tU32 midw_mascffi_tclMsgDynamicCompressionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgDynamicCompressionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DynCompression);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgDynamicCompressionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DynCompression);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgDynamicCompressionStatus::operator==(const midw_mascffi_tclMsgDynamicCompressionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DynCompression == roRef.DynCompression);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgOptimizationUpReg::midw_mascffi_tclMsgOptimizationUpReg()
 {}

tS32 midw_mascffi_tclMsgOptimizationUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONUPREG;
}


midw_mascffi_tclMsgOptimizationUpReg::~midw_mascffi_tclMsgOptimizationUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgOptimizationRelUpReg::midw_mascffi_tclMsgOptimizationRelUpReg()
 {}

tS32 midw_mascffi_tclMsgOptimizationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONRELUPREG;
}


midw_mascffi_tclMsgOptimizationRelUpReg::~midw_mascffi_tclMsgOptimizationRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgOptimizationGet::midw_mascffi_tclMsgOptimizationGet()
 {}

tS32 midw_mascffi_tclMsgOptimizationGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONGET;
}


midw_mascffi_tclMsgOptimizationGet::~midw_mascffi_tclMsgOptimizationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgOptimizationSet::midw_mascffi_tclMsgOptimizationSet(const midw_mascffi_tclMsgOptimizationSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgOptimizationSet& midw_mascffi_tclMsgOptimizationSet::operator=(const midw_mascffi_tclMsgOptimizationSet& coRef)
{
   if (this == &coRef) return *this;
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgOptimizationSet::midw_mascffi_tclMsgOptimizationSet()
:Optimization()
,Resource()
 {}

tS32 midw_mascffi_tclMsgOptimizationSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONSET;
}


midw_mascffi_tclMsgOptimizationSet::~midw_mascffi_tclMsgOptimizationSet()
{}

tU32 midw_mascffi_tclMsgOptimizationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgOptimizationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Optimization);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgOptimizationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Optimization);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgOptimizationSet::operator==(const midw_mascffi_tclMsgOptimizationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Optimization == roRef.Optimization);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgOptimizationStatus::midw_mascffi_tclMsgOptimizationStatus(const midw_mascffi_tclMsgOptimizationStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgOptimizationStatus& midw_mascffi_tclMsgOptimizationStatus::operator=(const midw_mascffi_tclMsgOptimizationStatus& coRef)
{
   if (this == &coRef) return *this;
   Optimization = coRef.Optimization;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgOptimizationStatus::midw_mascffi_tclMsgOptimizationStatus()
:Optimization()
,Resource()
 {}

tS32 midw_mascffi_tclMsgOptimizationStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OPTIMIZATIONSTATUS;
}


midw_mascffi_tclMsgOptimizationStatus::~midw_mascffi_tclMsgOptimizationStatus()
{}

tU32 midw_mascffi_tclMsgOptimizationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgOptimizationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Optimization);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgOptimizationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Optimization);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgOptimizationStatus::operator==(const midw_mascffi_tclMsgOptimizationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Optimization == roRef.Optimization);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgEqualiserPresetUpReg::midw_mascffi_tclMsgEqualiserPresetUpReg()
 {}

tS32 midw_mascffi_tclMsgEqualiserPresetUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETUPREG;
}


midw_mascffi_tclMsgEqualiserPresetUpReg::~midw_mascffi_tclMsgEqualiserPresetUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgEqualiserPresetRelUpReg::midw_mascffi_tclMsgEqualiserPresetRelUpReg()
 {}

tS32 midw_mascffi_tclMsgEqualiserPresetRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETRELUPREG;
}


midw_mascffi_tclMsgEqualiserPresetRelUpReg::~midw_mascffi_tclMsgEqualiserPresetRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgEqualiserPresetGet::midw_mascffi_tclMsgEqualiserPresetGet()
 {}

tS32 midw_mascffi_tclMsgEqualiserPresetGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETGET;
}


midw_mascffi_tclMsgEqualiserPresetGet::~midw_mascffi_tclMsgEqualiserPresetGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEqualiserPresetSet::midw_mascffi_tclMsgEqualiserPresetSet(const midw_mascffi_tclMsgEqualiserPresetSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgEqualiserPresetSet& midw_mascffi_tclMsgEqualiserPresetSet::operator=(const midw_mascffi_tclMsgEqualiserPresetSet& coRef)
{
   if (this == &coRef) return *this;
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgEqualiserPresetSet::midw_mascffi_tclMsgEqualiserPresetSet()
:EquPreset()
,Resource()
 {}

tS32 midw_mascffi_tclMsgEqualiserPresetSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETSET;
}


midw_mascffi_tclMsgEqualiserPresetSet::~midw_mascffi_tclMsgEqualiserPresetSet()
{}

tU32 midw_mascffi_tclMsgEqualiserPresetSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgEqualiserPresetSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EquPreset);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEqualiserPresetSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EquPreset);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgEqualiserPresetSet::operator==(const midw_mascffi_tclMsgEqualiserPresetSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EquPreset == roRef.EquPreset);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEqualiserPresetStatus::midw_mascffi_tclMsgEqualiserPresetStatus(const midw_mascffi_tclMsgEqualiserPresetStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgEqualiserPresetStatus& midw_mascffi_tclMsgEqualiserPresetStatus::operator=(const midw_mascffi_tclMsgEqualiserPresetStatus& coRef)
{
   if (this == &coRef) return *this;
   EquPreset = coRef.EquPreset;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgEqualiserPresetStatus::midw_mascffi_tclMsgEqualiserPresetStatus()
:EquPreset()
,Resource()
 {}

tS32 midw_mascffi_tclMsgEqualiserPresetStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EQUALISERPRESETSTATUS;
}


midw_mascffi_tclMsgEqualiserPresetStatus::~midw_mascffi_tclMsgEqualiserPresetStatus()
{}

tU32 midw_mascffi_tclMsgEqualiserPresetStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgEqualiserPresetStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EquPreset);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEqualiserPresetStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EquPreset);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgEqualiserPresetStatus::operator==(const midw_mascffi_tclMsgEqualiserPresetStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EquPreset == roRef.EquPreset);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgDiagAudModeUpReg::midw_mascffi_tclMsgDiagAudModeUpReg()
 {}

tS32 midw_mascffi_tclMsgDiagAudModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGAUDMODEUPREG;
}


midw_mascffi_tclMsgDiagAudModeUpReg::~midw_mascffi_tclMsgDiagAudModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDiagAudModeRelUpReg::midw_mascffi_tclMsgDiagAudModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgDiagAudModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGAUDMODERELUPREG;
}


midw_mascffi_tclMsgDiagAudModeRelUpReg::~midw_mascffi_tclMsgDiagAudModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDiagAudModeGet::midw_mascffi_tclMsgDiagAudModeGet()
 {}

tS32 midw_mascffi_tclMsgDiagAudModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGAUDMODEGET;
}


midw_mascffi_tclMsgDiagAudModeGet::~midw_mascffi_tclMsgDiagAudModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgDiagAudModeSet::midw_mascffi_tclMsgDiagAudModeSet(const midw_mascffi_tclMsgDiagAudModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
}
midw_mascffi_tclMsgDiagAudModeSet& midw_mascffi_tclMsgDiagAudModeSet::operator=(const midw_mascffi_tclMsgDiagAudModeSet& coRef)
{
   if (this == &coRef) return *this;
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgDiagAudModeSet::midw_mascffi_tclMsgDiagAudModeSet()
:DiagAudMode()
,OnVolLimiterMode()
,MuteRampMode()
,VolumeRampMode()
,clippingMode()
,PresetMode()
 {}

tS32 midw_mascffi_tclMsgDiagAudModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGAUDMODESET;
}


midw_mascffi_tclMsgDiagAudModeSet::~midw_mascffi_tclMsgDiagAudModeSet()
{}

tU32 midw_mascffi_tclMsgDiagAudModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_mascffi_tclMsgDiagAudModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagAudMode);
   (tVoid) (oIn >> OnVolLimiterMode);
   (tVoid) (oIn >> MuteRampMode);
   (tVoid) (oIn >> VolumeRampMode);
   (tVoid) (oIn >> clippingMode);
   (tVoid) (oIn >> PresetMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgDiagAudModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagAudMode);
   (tVoid) (oOut << OnVolLimiterMode);
   (tVoid) (oOut << MuteRampMode);
   (tVoid) (oOut << VolumeRampMode);
   (tVoid) (oOut << clippingMode);
   (tVoid) (oOut << PresetMode);
   return oOut;
}

tBool midw_mascffi_tclMsgDiagAudModeSet::operator==(const midw_mascffi_tclMsgDiagAudModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagAudMode == roRef.DiagAudMode);
   bResult = bResult && (OnVolLimiterMode == roRef.OnVolLimiterMode);
   bResult = bResult && (MuteRampMode == roRef.MuteRampMode);
   bResult = bResult && (VolumeRampMode == roRef.VolumeRampMode);
   bResult = bResult && (clippingMode == roRef.clippingMode);
   bResult = bResult && (PresetMode == roRef.PresetMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgDiagAudModeStatus::midw_mascffi_tclMsgDiagAudModeStatus(const midw_mascffi_tclMsgDiagAudModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
}
midw_mascffi_tclMsgDiagAudModeStatus& midw_mascffi_tclMsgDiagAudModeStatus::operator=(const midw_mascffi_tclMsgDiagAudModeStatus& coRef)
{
   if (this == &coRef) return *this;
   DiagAudMode = coRef.DiagAudMode;
   OnVolLimiterMode = coRef.OnVolLimiterMode;
   MuteRampMode = coRef.MuteRampMode;
   VolumeRampMode = coRef.VolumeRampMode;
   clippingMode = coRef.clippingMode;
   PresetMode = coRef.PresetMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgDiagAudModeStatus::midw_mascffi_tclMsgDiagAudModeStatus()
:DiagAudMode()
,OnVolLimiterMode()
,MuteRampMode()
,VolumeRampMode()
,clippingMode()
,PresetMode()
 {}

tS32 midw_mascffi_tclMsgDiagAudModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGAUDMODESTATUS;
}


midw_mascffi_tclMsgDiagAudModeStatus::~midw_mascffi_tclMsgDiagAudModeStatus()
{}

tU32 midw_mascffi_tclMsgDiagAudModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_mascffi_tclMsgDiagAudModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagAudMode);
   (tVoid) (oIn >> OnVolLimiterMode);
   (tVoid) (oIn >> MuteRampMode);
   (tVoid) (oIn >> VolumeRampMode);
   (tVoid) (oIn >> clippingMode);
   (tVoid) (oIn >> PresetMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgDiagAudModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagAudMode);
   (tVoid) (oOut << OnVolLimiterMode);
   (tVoid) (oOut << MuteRampMode);
   (tVoid) (oOut << VolumeRampMode);
   (tVoid) (oOut << clippingMode);
   (tVoid) (oOut << PresetMode);
   return oOut;
}

tBool midw_mascffi_tclMsgDiagAudModeStatus::operator==(const midw_mascffi_tclMsgDiagAudModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagAudMode == roRef.DiagAudMode);
   bResult = bResult && (OnVolLimiterMode == roRef.OnVolLimiterMode);
   bResult = bResult && (MuteRampMode == roRef.MuteRampMode);
   bResult = bResult && (VolumeRampMode == roRef.VolumeRampMode);
   bResult = bResult && (clippingMode == roRef.clippingMode);
   bResult = bResult && (PresetMode == roRef.PresetMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAuxInLevelUpReg::midw_mascffi_tclMsgAuxInLevelUpReg()
 {}

tS32 midw_mascffi_tclMsgAuxInLevelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUXINLEVELUPREG;
}


midw_mascffi_tclMsgAuxInLevelUpReg::~midw_mascffi_tclMsgAuxInLevelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAuxInLevelRelUpReg::midw_mascffi_tclMsgAuxInLevelRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAuxInLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUXINLEVELRELUPREG;
}


midw_mascffi_tclMsgAuxInLevelRelUpReg::~midw_mascffi_tclMsgAuxInLevelRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAuxInLevelGet::midw_mascffi_tclMsgAuxInLevelGet()
 {}

tS32 midw_mascffi_tclMsgAuxInLevelGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUXINLEVELGET;
}


midw_mascffi_tclMsgAuxInLevelGet::~midw_mascffi_tclMsgAuxInLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAuxInLevelSet::midw_mascffi_tclMsgAuxInLevelSet(const midw_mascffi_tclMsgAuxInLevelSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AuxInLevel = coRef.AuxInLevel;
}
midw_mascffi_tclMsgAuxInLevelSet& midw_mascffi_tclMsgAuxInLevelSet::operator=(const midw_mascffi_tclMsgAuxInLevelSet& coRef)
{
   if (this == &coRef) return *this;
   AuxInLevel = coRef.AuxInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAuxInLevelSet::midw_mascffi_tclMsgAuxInLevelSet()
:AuxInLevel()
 {}

tS32 midw_mascffi_tclMsgAuxInLevelSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUXINLEVELSET;
}


midw_mascffi_tclMsgAuxInLevelSet::~midw_mascffi_tclMsgAuxInLevelSet()
{}

tU32 midw_mascffi_tclMsgAuxInLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAuxInLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AuxInLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAuxInLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AuxInLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgAuxInLevelSet::operator==(const midw_mascffi_tclMsgAuxInLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AuxInLevel == roRef.AuxInLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAuxInLevelStatus::midw_mascffi_tclMsgAuxInLevelStatus(const midw_mascffi_tclMsgAuxInLevelStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AuxInLevel = coRef.AuxInLevel;
}
midw_mascffi_tclMsgAuxInLevelStatus& midw_mascffi_tclMsgAuxInLevelStatus::operator=(const midw_mascffi_tclMsgAuxInLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   AuxInLevel = coRef.AuxInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAuxInLevelStatus::midw_mascffi_tclMsgAuxInLevelStatus()
:AuxInLevel()
 {}

tS32 midw_mascffi_tclMsgAuxInLevelStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUXINLEVELSTATUS;
}


midw_mascffi_tclMsgAuxInLevelStatus::~midw_mascffi_tclMsgAuxInLevelStatus()
{}

tU32 midw_mascffi_tclMsgAuxInLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAuxInLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AuxInLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAuxInLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AuxInLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgAuxInLevelStatus::operator==(const midw_mascffi_tclMsgAuxInLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AuxInLevel == roRef.AuxInLevel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgBeepLevelUpReg::midw_mascffi_tclMsgBeepLevelUpReg()
 {}

tS32 midw_mascffi_tclMsgBeepLevelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPLEVELUPREG;
}


midw_mascffi_tclMsgBeepLevelUpReg::~midw_mascffi_tclMsgBeepLevelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBeepLevelRelUpReg::midw_mascffi_tclMsgBeepLevelRelUpReg()
 {}

tS32 midw_mascffi_tclMsgBeepLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPLEVELRELUPREG;
}


midw_mascffi_tclMsgBeepLevelRelUpReg::~midw_mascffi_tclMsgBeepLevelRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBeepLevelGet::midw_mascffi_tclMsgBeepLevelGet()
 {}

tS32 midw_mascffi_tclMsgBeepLevelGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPLEVELGET;
}


midw_mascffi_tclMsgBeepLevelGet::~midw_mascffi_tclMsgBeepLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBeepLevelSet::midw_mascffi_tclMsgBeepLevelSet(const midw_mascffi_tclMsgBeepLevelSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   BeepLevel = coRef.BeepLevel;
}
midw_mascffi_tclMsgBeepLevelSet& midw_mascffi_tclMsgBeepLevelSet::operator=(const midw_mascffi_tclMsgBeepLevelSet& coRef)
{
   if (this == &coRef) return *this;
   BeepLevel = coRef.BeepLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBeepLevelSet::midw_mascffi_tclMsgBeepLevelSet()
:BeepLevel()
 {}

tS32 midw_mascffi_tclMsgBeepLevelSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPLEVELSET;
}


midw_mascffi_tclMsgBeepLevelSet::~midw_mascffi_tclMsgBeepLevelSet()
{}

tU32 midw_mascffi_tclMsgBeepLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgBeepLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBeepLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgBeepLevelSet::operator==(const midw_mascffi_tclMsgBeepLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepLevel == roRef.BeepLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBeepLevelStatus::midw_mascffi_tclMsgBeepLevelStatus(const midw_mascffi_tclMsgBeepLevelStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   BeepLevel = coRef.BeepLevel;
}
midw_mascffi_tclMsgBeepLevelStatus& midw_mascffi_tclMsgBeepLevelStatus::operator=(const midw_mascffi_tclMsgBeepLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BeepLevel = coRef.BeepLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBeepLevelStatus::midw_mascffi_tclMsgBeepLevelStatus()
:BeepLevel()
 {}

tS32 midw_mascffi_tclMsgBeepLevelStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BEEPLEVELSTATUS;
}


midw_mascffi_tclMsgBeepLevelStatus::~midw_mascffi_tclMsgBeepLevelStatus()
{}

tU32 midw_mascffi_tclMsgBeepLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgBeepLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BeepLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBeepLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BeepLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgBeepLevelStatus::operator==(const midw_mascffi_tclMsgBeepLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BeepLevel == roRef.BeepLevel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRear_MuteUpReg::midw_mascffi_tclMsgRear_MuteUpReg()
 {}

tS32 midw_mascffi_tclMsgRear_MuteUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REAR_MUTEUPREG;
}


midw_mascffi_tclMsgRear_MuteUpReg::~midw_mascffi_tclMsgRear_MuteUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRear_MuteRelUpReg::midw_mascffi_tclMsgRear_MuteRelUpReg()
 {}

tS32 midw_mascffi_tclMsgRear_MuteRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REAR_MUTERELUPREG;
}


midw_mascffi_tclMsgRear_MuteRelUpReg::~midw_mascffi_tclMsgRear_MuteRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRear_MuteGet::midw_mascffi_tclMsgRear_MuteGet()
 {}

tS32 midw_mascffi_tclMsgRear_MuteGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REAR_MUTEGET;
}


midw_mascffi_tclMsgRear_MuteGet::~midw_mascffi_tclMsgRear_MuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRear_MuteSet::midw_mascffi_tclMsgRear_MuteSet(const midw_mascffi_tclMsgRear_MuteSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Rear_Mute = coRef.Rear_Mute;
}
midw_mascffi_tclMsgRear_MuteSet& midw_mascffi_tclMsgRear_MuteSet::operator=(const midw_mascffi_tclMsgRear_MuteSet& coRef)
{
   if (this == &coRef) return *this;
   Rear_Mute = coRef.Rear_Mute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRear_MuteSet::midw_mascffi_tclMsgRear_MuteSet()
:Rear_Mute()
 {}

tS32 midw_mascffi_tclMsgRear_MuteSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REAR_MUTESET;
}


midw_mascffi_tclMsgRear_MuteSet::~midw_mascffi_tclMsgRear_MuteSet()
{}

tU32 midw_mascffi_tclMsgRear_MuteSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRear_MuteSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Rear_Mute);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRear_MuteSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Rear_Mute);
   return oOut;
}

tBool midw_mascffi_tclMsgRear_MuteSet::operator==(const midw_mascffi_tclMsgRear_MuteSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Rear_Mute == roRef.Rear_Mute);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRear_MuteStatus::midw_mascffi_tclMsgRear_MuteStatus(const midw_mascffi_tclMsgRear_MuteStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Rear_Mute = coRef.Rear_Mute;
}
midw_mascffi_tclMsgRear_MuteStatus& midw_mascffi_tclMsgRear_MuteStatus::operator=(const midw_mascffi_tclMsgRear_MuteStatus& coRef)
{
   if (this == &coRef) return *this;
   Rear_Mute = coRef.Rear_Mute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRear_MuteStatus::midw_mascffi_tclMsgRear_MuteStatus()
:Rear_Mute()
 {}

tS32 midw_mascffi_tclMsgRear_MuteStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REAR_MUTESTATUS;
}


midw_mascffi_tclMsgRear_MuteStatus::~midw_mascffi_tclMsgRear_MuteStatus()
{}

tU32 midw_mascffi_tclMsgRear_MuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRear_MuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Rear_Mute);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRear_MuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Rear_Mute);
   return oOut;
}

tBool midw_mascffi_tclMsgRear_MuteStatus::operator==(const midw_mascffi_tclMsgRear_MuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Rear_Mute == roRef.Rear_Mute);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgGeometry_ModeUpReg::midw_mascffi_tclMsgGeometry_ModeUpReg()
 {}

tS32 midw_mascffi_tclMsgGeometry_ModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODEUPREG;
}


midw_mascffi_tclMsgGeometry_ModeUpReg::~midw_mascffi_tclMsgGeometry_ModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgGeometry_ModeRelUpReg::midw_mascffi_tclMsgGeometry_ModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgGeometry_ModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODERELUPREG;
}


midw_mascffi_tclMsgGeometry_ModeRelUpReg::~midw_mascffi_tclMsgGeometry_ModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgGeometry_ModeGet::midw_mascffi_tclMsgGeometry_ModeGet()
 {}

tS32 midw_mascffi_tclMsgGeometry_ModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODEGET;
}


midw_mascffi_tclMsgGeometry_ModeGet::~midw_mascffi_tclMsgGeometry_ModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgGeometry_ModeSet::midw_mascffi_tclMsgGeometry_ModeSet(const midw_mascffi_tclMsgGeometry_ModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Geometry_Mode = coRef.Geometry_Mode;
}
midw_mascffi_tclMsgGeometry_ModeSet& midw_mascffi_tclMsgGeometry_ModeSet::operator=(const midw_mascffi_tclMsgGeometry_ModeSet& coRef)
{
   if (this == &coRef) return *this;
   Geometry_Mode = coRef.Geometry_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgGeometry_ModeSet::midw_mascffi_tclMsgGeometry_ModeSet()
:Geometry_Mode()
 {}

tS32 midw_mascffi_tclMsgGeometry_ModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODESET;
}


midw_mascffi_tclMsgGeometry_ModeSet::~midw_mascffi_tclMsgGeometry_ModeSet()
{}

tU32 midw_mascffi_tclMsgGeometry_ModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgGeometry_ModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Geometry_Mode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgGeometry_ModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Geometry_Mode);
   return oOut;
}

tBool midw_mascffi_tclMsgGeometry_ModeSet::operator==(const midw_mascffi_tclMsgGeometry_ModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Geometry_Mode == roRef.Geometry_Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgGeometry_ModeStatus::midw_mascffi_tclMsgGeometry_ModeStatus(const midw_mascffi_tclMsgGeometry_ModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Geometry_Mode = coRef.Geometry_Mode;
}
midw_mascffi_tclMsgGeometry_ModeStatus& midw_mascffi_tclMsgGeometry_ModeStatus::operator=(const midw_mascffi_tclMsgGeometry_ModeStatus& coRef)
{
   if (this == &coRef) return *this;
   Geometry_Mode = coRef.Geometry_Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgGeometry_ModeStatus::midw_mascffi_tclMsgGeometry_ModeStatus()
:Geometry_Mode()
 {}

tS32 midw_mascffi_tclMsgGeometry_ModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GEOMETRY_MODESTATUS;
}


midw_mascffi_tclMsgGeometry_ModeStatus::~midw_mascffi_tclMsgGeometry_ModeStatus()
{}

tU32 midw_mascffi_tclMsgGeometry_ModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgGeometry_ModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Geometry_Mode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgGeometry_ModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Geometry_Mode);
   return oOut;
}

tBool midw_mascffi_tclMsgGeometry_ModeStatus::operator==(const midw_mascffi_tclMsgGeometry_ModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Geometry_Mode == roRef.Geometry_Mode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgLSValueStatusUpReg::midw_mascffi_tclMsgLSValueStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgLSValueStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSUPREG;
}


midw_mascffi_tclMsgLSValueStatusUpReg::~midw_mascffi_tclMsgLSValueStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgLSValueStatusRelUpReg::midw_mascffi_tclMsgLSValueStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgLSValueStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSRELUPREG;
}


midw_mascffi_tclMsgLSValueStatusRelUpReg::~midw_mascffi_tclMsgLSValueStatusRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgLSValueStatusGet::midw_mascffi_tclMsgLSValueStatusGet()
 {}

tS32 midw_mascffi_tclMsgLSValueStatusGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSGET;
}


midw_mascffi_tclMsgLSValueStatusGet::~midw_mascffi_tclMsgLSValueStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgLSValueStatusStatus::midw_mascffi_tclMsgLSValueStatusStatus(const midw_mascffi_tclMsgLSValueStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   u8NaviSetupLs = coRef.u8NaviSetupLs;
}
midw_mascffi_tclMsgLSValueStatusStatus& midw_mascffi_tclMsgLSValueStatusStatus::operator=(const midw_mascffi_tclMsgLSValueStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   u8NaviSetupLs = coRef.u8NaviSetupLs;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgLSValueStatusStatus::midw_mascffi_tclMsgLSValueStatusStatus()
:u8NaviSetupLs(0)
 {}

tS32 midw_mascffi_tclMsgLSValueStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_LSVALUESTATUSSTATUS;
}


midw_mascffi_tclMsgLSValueStatusStatus::~midw_mascffi_tclMsgLSValueStatusStatus()
{}

tU32 midw_mascffi_tclMsgLSValueStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgLSValueStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8NaviSetupLs);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgLSValueStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8NaviSetupLs);
   return oOut;
}

tBool midw_mascffi_tclMsgLSValueStatusStatus::operator==(const midw_mascffi_tclMsgLSValueStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8NaviSetupLs == roRef.u8NaviSetupLs);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgPDCAttenuationLevelUpReg::midw_mascffi_tclMsgPDCAttenuationLevelUpReg()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationLevelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELUPREG;
}


midw_mascffi_tclMsgPDCAttenuationLevelUpReg::~midw_mascffi_tclMsgPDCAttenuationLevelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg::midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELRELUPREG;
}


midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg::~midw_mascffi_tclMsgPDCAttenuationLevelRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgPDCAttenuationLevelGet::midw_mascffi_tclMsgPDCAttenuationLevelGet()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationLevelGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELGET;
}


midw_mascffi_tclMsgPDCAttenuationLevelGet::~midw_mascffi_tclMsgPDCAttenuationLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgPDCAttenuationLevelSet::midw_mascffi_tclMsgPDCAttenuationLevelSet(const midw_mascffi_tclMsgPDCAttenuationLevelSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   PDCAttenutionLevel = coRef.PDCAttenutionLevel;
}
midw_mascffi_tclMsgPDCAttenuationLevelSet& midw_mascffi_tclMsgPDCAttenuationLevelSet::operator=(const midw_mascffi_tclMsgPDCAttenuationLevelSet& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenutionLevel = coRef.PDCAttenutionLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgPDCAttenuationLevelSet::midw_mascffi_tclMsgPDCAttenuationLevelSet()
:PDCAttenutionLevel(0)
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationLevelSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELSET;
}


midw_mascffi_tclMsgPDCAttenuationLevelSet::~midw_mascffi_tclMsgPDCAttenuationLevelSet()
{}

tU32 midw_mascffi_tclMsgPDCAttenuationLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgPDCAttenuationLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenutionLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgPDCAttenuationLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenutionLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgPDCAttenuationLevelSet::operator==(const midw_mascffi_tclMsgPDCAttenuationLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenutionLevel == roRef.PDCAttenutionLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgPDCAttenuationLevelStatus::midw_mascffi_tclMsgPDCAttenuationLevelStatus(const midw_mascffi_tclMsgPDCAttenuationLevelStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   PDCAttenuationLevel = coRef.PDCAttenuationLevel;
}
midw_mascffi_tclMsgPDCAttenuationLevelStatus& midw_mascffi_tclMsgPDCAttenuationLevelStatus::operator=(const midw_mascffi_tclMsgPDCAttenuationLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenuationLevel = coRef.PDCAttenuationLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgPDCAttenuationLevelStatus::midw_mascffi_tclMsgPDCAttenuationLevelStatus()
:PDCAttenuationLevel(0)
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationLevelStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONLEVELSTATUS;
}


midw_mascffi_tclMsgPDCAttenuationLevelStatus::~midw_mascffi_tclMsgPDCAttenuationLevelStatus()
{}

tU32 midw_mascffi_tclMsgPDCAttenuationLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgPDCAttenuationLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenuationLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgPDCAttenuationLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenuationLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgPDCAttenuationLevelStatus::operator==(const midw_mascffi_tclMsgPDCAttenuationLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenuationLevel == roRef.PDCAttenuationLevel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgPDCAttenuationUpReg::midw_mascffi_tclMsgPDCAttenuationUpReg()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONUPREG;
}


midw_mascffi_tclMsgPDCAttenuationUpReg::~midw_mascffi_tclMsgPDCAttenuationUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgPDCAttenuationRelUpReg::midw_mascffi_tclMsgPDCAttenuationRelUpReg()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONRELUPREG;
}


midw_mascffi_tclMsgPDCAttenuationRelUpReg::~midw_mascffi_tclMsgPDCAttenuationRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgPDCAttenuationGet::midw_mascffi_tclMsgPDCAttenuationGet()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONGET;
}


midw_mascffi_tclMsgPDCAttenuationGet::~midw_mascffi_tclMsgPDCAttenuationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgPDCAttenuationSet::midw_mascffi_tclMsgPDCAttenuationSet(const midw_mascffi_tclMsgPDCAttenuationSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   PDCAttenuationCommand = coRef.PDCAttenuationCommand;
}
midw_mascffi_tclMsgPDCAttenuationSet& midw_mascffi_tclMsgPDCAttenuationSet::operator=(const midw_mascffi_tclMsgPDCAttenuationSet& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenuationCommand = coRef.PDCAttenuationCommand;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgPDCAttenuationSet::midw_mascffi_tclMsgPDCAttenuationSet()
:PDCAttenuationCommand()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONSET;
}


midw_mascffi_tclMsgPDCAttenuationSet::~midw_mascffi_tclMsgPDCAttenuationSet()
{}

tU32 midw_mascffi_tclMsgPDCAttenuationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgPDCAttenuationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenuationCommand);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgPDCAttenuationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenuationCommand);
   return oOut;
}

tBool midw_mascffi_tclMsgPDCAttenuationSet::operator==(const midw_mascffi_tclMsgPDCAttenuationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenuationCommand == roRef.PDCAttenuationCommand);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgPDCAttenuationStatus::midw_mascffi_tclMsgPDCAttenuationStatus(const midw_mascffi_tclMsgPDCAttenuationStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   PDCAttenuation = coRef.PDCAttenuation;
}
midw_mascffi_tclMsgPDCAttenuationStatus& midw_mascffi_tclMsgPDCAttenuationStatus::operator=(const midw_mascffi_tclMsgPDCAttenuationStatus& coRef)
{
   if (this == &coRef) return *this;
   PDCAttenuation = coRef.PDCAttenuation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgPDCAttenuationStatus::midw_mascffi_tclMsgPDCAttenuationStatus()
:PDCAttenuation()
 {}

tS32 midw_mascffi_tclMsgPDCAttenuationStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PDCATTENUATIONSTATUS;
}


midw_mascffi_tclMsgPDCAttenuationStatus::~midw_mascffi_tclMsgPDCAttenuationStatus()
{}

tU32 midw_mascffi_tclMsgPDCAttenuationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgPDCAttenuationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PDCAttenuation);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgPDCAttenuationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PDCAttenuation);
   return oOut;
}

tBool midw_mascffi_tclMsgPDCAttenuationStatus::operator==(const midw_mascffi_tclMsgPDCAttenuationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PDCAttenuation == roRef.PDCAttenuation);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAudioDeviceStatusUpReg::midw_mascffi_tclMsgAudioDeviceStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioDeviceStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSUPREG;
}


midw_mascffi_tclMsgAudioDeviceStatusUpReg::~midw_mascffi_tclMsgAudioDeviceStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioDeviceStatusRelUpReg::midw_mascffi_tclMsgAudioDeviceStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioDeviceStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSRELUPREG;
}


midw_mascffi_tclMsgAudioDeviceStatusRelUpReg::~midw_mascffi_tclMsgAudioDeviceStatusRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioDeviceStatusGet::midw_mascffi_tclMsgAudioDeviceStatusGet()
 {}

tS32 midw_mascffi_tclMsgAudioDeviceStatusGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSGET;
}


midw_mascffi_tclMsgAudioDeviceStatusGet::~midw_mascffi_tclMsgAudioDeviceStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioDeviceStatusStatus::midw_mascffi_tclMsgAudioDeviceStatusStatus(const midw_mascffi_tclMsgAudioDeviceStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AudioDeviceAvailability = coRef.AudioDeviceAvailability;
}
midw_mascffi_tclMsgAudioDeviceStatusStatus& midw_mascffi_tclMsgAudioDeviceStatusStatus::operator=(const midw_mascffi_tclMsgAudioDeviceStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   AudioDeviceAvailability = coRef.AudioDeviceAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioDeviceStatusStatus::midw_mascffi_tclMsgAudioDeviceStatusStatus()
:AudioDeviceAvailability()
 {}

tS32 midw_mascffi_tclMsgAudioDeviceStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIODEVICESTATUSSTATUS;
}


midw_mascffi_tclMsgAudioDeviceStatusStatus::~midw_mascffi_tclMsgAudioDeviceStatusStatus()
{}

tU32 midw_mascffi_tclMsgAudioDeviceStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioDeviceStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioDeviceAvailability);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioDeviceStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioDeviceAvailability);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioDeviceStatusStatus::operator==(const midw_mascffi_tclMsgAudioDeviceStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioDeviceAvailability == roRef.AudioDeviceAvailability);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgOverTempReductionUpReg::midw_mascffi_tclMsgOverTempReductionUpReg()
 {}

tS32 midw_mascffi_tclMsgOverTempReductionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONUPREG;
}


midw_mascffi_tclMsgOverTempReductionUpReg::~midw_mascffi_tclMsgOverTempReductionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgOverTempReductionRelUpReg::midw_mascffi_tclMsgOverTempReductionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgOverTempReductionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONRELUPREG;
}


midw_mascffi_tclMsgOverTempReductionRelUpReg::~midw_mascffi_tclMsgOverTempReductionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgOverTempReductionGet::midw_mascffi_tclMsgOverTempReductionGet()
 {}

tS32 midw_mascffi_tclMsgOverTempReductionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONGET;
}


midw_mascffi_tclMsgOverTempReductionGet::~midw_mascffi_tclMsgOverTempReductionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgOverTempReductionSet::midw_mascffi_tclMsgOverTempReductionSet(const midw_mascffi_tclMsgOverTempReductionSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DownScaling_Active = coRef.DownScaling_Active;
   ReductionInterval = coRef.ReductionInterval;
}
midw_mascffi_tclMsgOverTempReductionSet& midw_mascffi_tclMsgOverTempReductionSet::operator=(const midw_mascffi_tclMsgOverTempReductionSet& coRef)
{
   if (this == &coRef) return *this;
   DownScaling_Active = coRef.DownScaling_Active;
   ReductionInterval = coRef.ReductionInterval;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgOverTempReductionSet::midw_mascffi_tclMsgOverTempReductionSet()
:DownScaling_Active(0)
,ReductionInterval(0)
 {}

tS32 midw_mascffi_tclMsgOverTempReductionSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONSET;
}


midw_mascffi_tclMsgOverTempReductionSet::~midw_mascffi_tclMsgOverTempReductionSet()
{}

tU32 midw_mascffi_tclMsgOverTempReductionSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgOverTempReductionSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DownScaling_Active);
   (tVoid) (oIn >> ReductionInterval);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgOverTempReductionSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DownScaling_Active);
   (tVoid) (oOut << ReductionInterval);
   return oOut;
}

tBool midw_mascffi_tclMsgOverTempReductionSet::operator==(const midw_mascffi_tclMsgOverTempReductionSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DownScaling_Active == roRef.DownScaling_Active);
   bResult = bResult && (ReductionInterval == roRef.ReductionInterval);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgOverTempReductionStatus::midw_mascffi_tclMsgOverTempReductionStatus(const midw_mascffi_tclMsgOverTempReductionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ActiveByCommand = coRef.ActiveByCommand;
   ActiveByAmplifier = coRef.ActiveByAmplifier;
   CurrentFactor = coRef.CurrentFactor;
   ReductionInterval = coRef.ReductionInterval;
}
midw_mascffi_tclMsgOverTempReductionStatus& midw_mascffi_tclMsgOverTempReductionStatus::operator=(const midw_mascffi_tclMsgOverTempReductionStatus& coRef)
{
   if (this == &coRef) return *this;
   ActiveByCommand = coRef.ActiveByCommand;
   ActiveByAmplifier = coRef.ActiveByAmplifier;
   CurrentFactor = coRef.CurrentFactor;
   ReductionInterval = coRef.ReductionInterval;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgOverTempReductionStatus::midw_mascffi_tclMsgOverTempReductionStatus()
:ActiveByCommand(0)
,ActiveByAmplifier(0)
,CurrentFactor(0)
,ReductionInterval(0)
 {}

tS32 midw_mascffi_tclMsgOverTempReductionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPREDUCTIONSTATUS;
}


midw_mascffi_tclMsgOverTempReductionStatus::~midw_mascffi_tclMsgOverTempReductionStatus()
{}

tU32 midw_mascffi_tclMsgOverTempReductionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_mascffi_tclMsgOverTempReductionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActiveByCommand);
   (tVoid) (oIn >> ActiveByAmplifier);
   (tVoid) (oIn >> CurrentFactor);
   (tVoid) (oIn >> ReductionInterval);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgOverTempReductionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActiveByCommand);
   (tVoid) (oOut << ActiveByAmplifier);
   (tVoid) (oOut << CurrentFactor);
   (tVoid) (oOut << ReductionInterval);
   return oOut;
}

tBool midw_mascffi_tclMsgOverTempReductionStatus::operator==(const midw_mascffi_tclMsgOverTempReductionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActiveByCommand == roRef.ActiveByCommand);
   bResult = bResult && (ActiveByAmplifier == roRef.ActiveByAmplifier);
   bResult = bResult && (CurrentFactor == roRef.CurrentFactor);
   bResult = bResult && (ReductionInterval == roRef.ReductionInterval);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgOverTempAmplifierStatusUpReg::midw_mascffi_tclMsgOverTempAmplifierStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgOverTempAmplifierStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSUPREG;
}


midw_mascffi_tclMsgOverTempAmplifierStatusUpReg::~midw_mascffi_tclMsgOverTempAmplifierStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg::midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSRELUPREG;
}


midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg::~midw_mascffi_tclMsgOverTempAmplifierStatusRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgOverTempAmplifierStatusGet::midw_mascffi_tclMsgOverTempAmplifierStatusGet()
 {}

tS32 midw_mascffi_tclMsgOverTempAmplifierStatusGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSGET;
}


midw_mascffi_tclMsgOverTempAmplifierStatusGet::~midw_mascffi_tclMsgOverTempAmplifierStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgOverTempAmplifierStatusStatus::midw_mascffi_tclMsgOverTempAmplifierStatusStatus(const midw_mascffi_tclMsgOverTempAmplifierStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AmpTemperatureLevel = coRef.AmpTemperatureLevel;
}
midw_mascffi_tclMsgOverTempAmplifierStatusStatus& midw_mascffi_tclMsgOverTempAmplifierStatusStatus::operator=(const midw_mascffi_tclMsgOverTempAmplifierStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   AmpTemperatureLevel = coRef.AmpTemperatureLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgOverTempAmplifierStatusStatus::midw_mascffi_tclMsgOverTempAmplifierStatusStatus()
:AmpTemperatureLevel()
 {}

tS32 midw_mascffi_tclMsgOverTempAmplifierStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_OVERTEMPAMPLIFIERSTATUSSTATUS;
}


midw_mascffi_tclMsgOverTempAmplifierStatusStatus::~midw_mascffi_tclMsgOverTempAmplifierStatusStatus()
{}

tU32 midw_mascffi_tclMsgOverTempAmplifierStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgOverTempAmplifierStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AmpTemperatureLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgOverTempAmplifierStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AmpTemperatureLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgOverTempAmplifierStatusStatus::operator==(const midw_mascffi_tclMsgOverTempAmplifierStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AmpTemperatureLevel == roRef.AmpTemperatureLevel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgReadMeasurementResultUpReg::midw_mascffi_tclMsgReadMeasurementResultUpReg()
 {}

tS32 midw_mascffi_tclMsgReadMeasurementResultUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTUPREG;
}


midw_mascffi_tclMsgReadMeasurementResultUpReg::~midw_mascffi_tclMsgReadMeasurementResultUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgReadMeasurementResultRelUpReg::midw_mascffi_tclMsgReadMeasurementResultRelUpReg()
 {}

tS32 midw_mascffi_tclMsgReadMeasurementResultRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTRELUPREG;
}


midw_mascffi_tclMsgReadMeasurementResultRelUpReg::~midw_mascffi_tclMsgReadMeasurementResultRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgReadMeasurementResultGet::midw_mascffi_tclMsgReadMeasurementResultGet()
 {}

tS32 midw_mascffi_tclMsgReadMeasurementResultGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTGET;
}


midw_mascffi_tclMsgReadMeasurementResultGet::~midw_mascffi_tclMsgReadMeasurementResultGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgReadMeasurementResultStatus::midw_mascffi_tclMsgReadMeasurementResultStatus(const midw_mascffi_tclMsgReadMeasurementResultStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   MeasurementResultList = coRef.MeasurementResultList;
}
midw_mascffi_tclMsgReadMeasurementResultStatus& midw_mascffi_tclMsgReadMeasurementResultStatus::operator=(const midw_mascffi_tclMsgReadMeasurementResultStatus& coRef)
{
   if (this == &coRef) return *this;
   MeasurementResultList = coRef.MeasurementResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgReadMeasurementResultStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < MeasurementResultList.size(); ++u32Idx)
         MeasurementResultList[u32Idx].vDestroy();
   MeasurementResultList.clear();
   }
}

midw_mascffi_tclMsgReadMeasurementResultStatus::midw_mascffi_tclMsgReadMeasurementResultStatus()

 {}

tS32 midw_mascffi_tclMsgReadMeasurementResultStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_READMEASUREMENTRESULTSTATUS;
}


midw_mascffi_tclMsgReadMeasurementResultStatus::~midw_mascffi_tclMsgReadMeasurementResultStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgReadMeasurementResultStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MeasurementResultList.size()*5);
}

fi_tclInContext& midw_mascffi_tclMsgReadMeasurementResultStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < MeasurementResultList.size(); ++u32Idx)
      {
         MeasurementResultList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      MeasurementResultList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MeasurementResultList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgReadMeasurementResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MeasurementResultList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MeasurementResultList.size(); ++u32Idx)
         (tVoid) (oOut << MeasurementResultList[u32Idx]);
   }
   return oOut;
}

tBool midw_mascffi_tclMsgReadMeasurementResultStatus::operator==(const midw_mascffi_tclMsgReadMeasurementResultStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MeasurementResultList.size() == roRef.MeasurementResultList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MeasurementResultList.size()); ++u32Idx)
            bResult = bResult && (MeasurementResultList[u32Idx] == roRef.MeasurementResultList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgCenterUpReg::midw_mascffi_tclMsgCenterUpReg()
 {}

tS32 midw_mascffi_tclMsgCenterUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CENTERUPREG;
}


midw_mascffi_tclMsgCenterUpReg::~midw_mascffi_tclMsgCenterUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgCenterRelUpReg::midw_mascffi_tclMsgCenterRelUpReg()
 {}

tS32 midw_mascffi_tclMsgCenterRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CENTERRELUPREG;
}


midw_mascffi_tclMsgCenterRelUpReg::~midw_mascffi_tclMsgCenterRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgCenterGet::midw_mascffi_tclMsgCenterGet()
 {}

tS32 midw_mascffi_tclMsgCenterGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CENTERGET;
}


midw_mascffi_tclMsgCenterGet::~midw_mascffi_tclMsgCenterGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgCenterSet::midw_mascffi_tclMsgCenterSet(const midw_mascffi_tclMsgCenterSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Center = coRef.Center;
}
midw_mascffi_tclMsgCenterSet& midw_mascffi_tclMsgCenterSet::operator=(const midw_mascffi_tclMsgCenterSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   Center = coRef.Center;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgCenterSet::midw_mascffi_tclMsgCenterSet()
:SoundType()
,Resource()
,Center(0)
 {}

tS32 midw_mascffi_tclMsgCenterSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CENTERSET;
}


midw_mascffi_tclMsgCenterSet::~midw_mascffi_tclMsgCenterSet()
{}

tU32 midw_mascffi_tclMsgCenterSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_mascffi_tclMsgCenterSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Center);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgCenterSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Center);
   return oOut;
}

tBool midw_mascffi_tclMsgCenterSet::operator==(const midw_mascffi_tclMsgCenterSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Center == roRef.Center);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgCenterStatus::midw_mascffi_tclMsgCenterStatus(const midw_mascffi_tclMsgCenterStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Center = coRef.Center;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgCenterStatus& midw_mascffi_tclMsgCenterStatus::operator=(const midw_mascffi_tclMsgCenterStatus& coRef)
{
   if (this == &coRef) return *this;
   Center = coRef.Center;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgCenterStatus::midw_mascffi_tclMsgCenterStatus()
:Center(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgCenterStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CENTERSTATUS;
}


midw_mascffi_tclMsgCenterStatus::~midw_mascffi_tclMsgCenterStatus()
{}

tU32 midw_mascffi_tclMsgCenterStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_mascffi_tclMsgCenterStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Center);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgCenterStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Center);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgCenterStatus::operator==(const midw_mascffi_tclMsgCenterStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Center == roRef.Center);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgSubWooferUpReg::midw_mascffi_tclMsgSubWooferUpReg()
 {}

tS32 midw_mascffi_tclMsgSubWooferUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SUBWOOFERUPREG;
}


midw_mascffi_tclMsgSubWooferUpReg::~midw_mascffi_tclMsgSubWooferUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSubWooferRelUpReg::midw_mascffi_tclMsgSubWooferRelUpReg()
 {}

tS32 midw_mascffi_tclMsgSubWooferRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SUBWOOFERRELUPREG;
}


midw_mascffi_tclMsgSubWooferRelUpReg::~midw_mascffi_tclMsgSubWooferRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSubWooferGet::midw_mascffi_tclMsgSubWooferGet()
 {}

tS32 midw_mascffi_tclMsgSubWooferGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SUBWOOFERGET;
}


midw_mascffi_tclMsgSubWooferGet::~midw_mascffi_tclMsgSubWooferGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSubWooferSet::midw_mascffi_tclMsgSubWooferSet(const midw_mascffi_tclMsgSubWooferSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SubWoofer = coRef.SubWoofer;
}
midw_mascffi_tclMsgSubWooferSet& midw_mascffi_tclMsgSubWooferSet::operator=(const midw_mascffi_tclMsgSubWooferSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SubWoofer = coRef.SubWoofer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSubWooferSet::midw_mascffi_tclMsgSubWooferSet()
:SoundType()
,Resource()
,SubWoofer(0)
 {}

tS32 midw_mascffi_tclMsgSubWooferSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SUBWOOFERSET;
}


midw_mascffi_tclMsgSubWooferSet::~midw_mascffi_tclMsgSubWooferSet()
{}

tU32 midw_mascffi_tclMsgSubWooferSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_mascffi_tclMsgSubWooferSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> SubWoofer);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSubWooferSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << SubWoofer);
   return oOut;
}

tBool midw_mascffi_tclMsgSubWooferSet::operator==(const midw_mascffi_tclMsgSubWooferSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (SubWoofer == roRef.SubWoofer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSubWooferStatus::midw_mascffi_tclMsgSubWooferStatus(const midw_mascffi_tclMsgSubWooferStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SubWoofer = coRef.SubWoofer;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgSubWooferStatus& midw_mascffi_tclMsgSubWooferStatus::operator=(const midw_mascffi_tclMsgSubWooferStatus& coRef)
{
   if (this == &coRef) return *this;
   SubWoofer = coRef.SubWoofer;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSubWooferStatus::midw_mascffi_tclMsgSubWooferStatus()
:SubWoofer(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgSubWooferStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SUBWOOFERSTATUS;
}


midw_mascffi_tclMsgSubWooferStatus::~midw_mascffi_tclMsgSubWooferStatus()
{}

tU32 midw_mascffi_tclMsgSubWooferStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_mascffi_tclMsgSubWooferStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SubWoofer);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSubWooferStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SubWoofer);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgSubWooferStatus::operator==(const midw_mascffi_tclMsgSubWooferStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SubWoofer == roRef.SubWoofer);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg::midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg()
 {}

tS32 midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEUPREG;
}


midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg::~midw_mascffi_tclMsgExternalAmplifierConnectionStateUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg::midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg()
 {}

tS32 midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATERELUPREG;
}


midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg::~midw_mascffi_tclMsgExternalAmplifierConnectionStateRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgExternalAmplifierConnectionStateGet::midw_mascffi_tclMsgExternalAmplifierConnectionStateGet()
 {}

tS32 midw_mascffi_tclMsgExternalAmplifierConnectionStateGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATEGET;
}


midw_mascffi_tclMsgExternalAmplifierConnectionStateGet::~midw_mascffi_tclMsgExternalAmplifierConnectionStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus(const midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ConnectionState = coRef.ConnectionState;
}
midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::operator=(const midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& coRef)
{
   if (this == &coRef) return *this;
   ConnectionState = coRef.ConnectionState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus()
:ConnectionState(0)
 {}

tS32 midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_EXTERNALAMPLIFIERCONNECTIONSTATESTATUS;
}


midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::~midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus()
{}

tU32 midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ConnectionState);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ConnectionState);
   return oOut;
}

tBool midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus::operator==(const midw_mascffi_tclMsgExternalAmplifierConnectionStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ConnectionState == roRef.ConnectionState);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgGeneralSpeakerTestUpReg::midw_mascffi_tclMsgGeneralSpeakerTestUpReg()
 {}

tS32 midw_mascffi_tclMsgGeneralSpeakerTestUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTUPREG;
}


midw_mascffi_tclMsgGeneralSpeakerTestUpReg::~midw_mascffi_tclMsgGeneralSpeakerTestUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg::midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg()
 {}

tS32 midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTRELUPREG;
}


midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg::~midw_mascffi_tclMsgGeneralSpeakerTestRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgGeneralSpeakerTestGet::midw_mascffi_tclMsgGeneralSpeakerTestGet()
 {}

tS32 midw_mascffi_tclMsgGeneralSpeakerTestGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTGET;
}


midw_mascffi_tclMsgGeneralSpeakerTestGet::~midw_mascffi_tclMsgGeneralSpeakerTestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgGeneralSpeakerTestSet::midw_mascffi_tclMsgGeneralSpeakerTestSet(const midw_mascffi_tclMsgGeneralSpeakerTestSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Request = coRef.Request;
}
midw_mascffi_tclMsgGeneralSpeakerTestSet& midw_mascffi_tclMsgGeneralSpeakerTestSet::operator=(const midw_mascffi_tclMsgGeneralSpeakerTestSet& coRef)
{
   if (this == &coRef) return *this;
   Request = coRef.Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgGeneralSpeakerTestSet::midw_mascffi_tclMsgGeneralSpeakerTestSet()
:Request(0)
 {}

tS32 midw_mascffi_tclMsgGeneralSpeakerTestSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTSET;
}


midw_mascffi_tclMsgGeneralSpeakerTestSet::~midw_mascffi_tclMsgGeneralSpeakerTestSet()
{}

tU32 midw_mascffi_tclMsgGeneralSpeakerTestSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgGeneralSpeakerTestSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Request);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgGeneralSpeakerTestSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Request);
   return oOut;
}

tBool midw_mascffi_tclMsgGeneralSpeakerTestSet::operator==(const midw_mascffi_tclMsgGeneralSpeakerTestSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Request == roRef.Request);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgGeneralSpeakerTestStatus::midw_mascffi_tclMsgGeneralSpeakerTestStatus(const midw_mascffi_tclMsgGeneralSpeakerTestStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SpeakerValue_1 = coRef.SpeakerValue_1;
   SpeakerValue_2 = coRef.SpeakerValue_2;
   SpeakerValue_3 = coRef.SpeakerValue_3;
   SpeakerValue_4 = coRef.SpeakerValue_4;
   SpeakerValue_5 = coRef.SpeakerValue_5;
}
midw_mascffi_tclMsgGeneralSpeakerTestStatus& midw_mascffi_tclMsgGeneralSpeakerTestStatus::operator=(const midw_mascffi_tclMsgGeneralSpeakerTestStatus& coRef)
{
   if (this == &coRef) return *this;
   SpeakerValue_1 = coRef.SpeakerValue_1;
   SpeakerValue_2 = coRef.SpeakerValue_2;
   SpeakerValue_3 = coRef.SpeakerValue_3;
   SpeakerValue_4 = coRef.SpeakerValue_4;
   SpeakerValue_5 = coRef.SpeakerValue_5;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgGeneralSpeakerTestStatus::midw_mascffi_tclMsgGeneralSpeakerTestStatus()
:SpeakerValue_1(0)
,SpeakerValue_2(0)
,SpeakerValue_3(0)
,SpeakerValue_4(0)
,SpeakerValue_5(0)
 {}

tS32 midw_mascffi_tclMsgGeneralSpeakerTestStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_GENERALSPEAKERTESTSTATUS;
}


midw_mascffi_tclMsgGeneralSpeakerTestStatus::~midw_mascffi_tclMsgGeneralSpeakerTestStatus()
{}

tU32 midw_mascffi_tclMsgGeneralSpeakerTestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_mascffi_tclMsgGeneralSpeakerTestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeakerValue_1);
   (tVoid) (oIn >> SpeakerValue_2);
   (tVoid) (oIn >> SpeakerValue_3);
   (tVoid) (oIn >> SpeakerValue_4);
   (tVoid) (oIn >> SpeakerValue_5);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgGeneralSpeakerTestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeakerValue_1);
   (tVoid) (oOut << SpeakerValue_2);
   (tVoid) (oOut << SpeakerValue_3);
   (tVoid) (oOut << SpeakerValue_4);
   (tVoid) (oOut << SpeakerValue_5);
   return oOut;
}

tBool midw_mascffi_tclMsgGeneralSpeakerTestStatus::operator==(const midw_mascffi_tclMsgGeneralSpeakerTestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeakerValue_1 == roRef.SpeakerValue_1);
   bResult = bResult && (SpeakerValue_2 == roRef.SpeakerValue_2);
   bResult = bResult && (SpeakerValue_3 == roRef.SpeakerValue_3);
   bResult = bResult && (SpeakerValue_4 == roRef.SpeakerValue_4);
   bResult = bResult && (SpeakerValue_5 == roRef.SpeakerValue_5);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgANCSWVersionUpReg::midw_mascffi_tclMsgANCSWVersionUpReg()
 {}

tS32 midw_mascffi_tclMsgANCSWVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONUPREG;
}


midw_mascffi_tclMsgANCSWVersionUpReg::~midw_mascffi_tclMsgANCSWVersionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCSWVersionRelUpReg::midw_mascffi_tclMsgANCSWVersionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgANCSWVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONRELUPREG;
}


midw_mascffi_tclMsgANCSWVersionRelUpReg::~midw_mascffi_tclMsgANCSWVersionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCSWVersionGet::midw_mascffi_tclMsgANCSWVersionGet()
 {}

tS32 midw_mascffi_tclMsgANCSWVersionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONGET;
}


midw_mascffi_tclMsgANCSWVersionGet::~midw_mascffi_tclMsgANCSWVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgANCSWVersionStatus::midw_mascffi_tclMsgANCSWVersionStatus(const midw_mascffi_tclMsgANCSWVersionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
}
midw_mascffi_tclMsgANCSWVersionStatus& midw_mascffi_tclMsgANCSWVersionStatus::operator=(const midw_mascffi_tclMsgANCSWVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgANCSWVersionStatus::midw_mascffi_tclMsgANCSWVersionStatus()
:LargeVersion(0)
,MiddleVersion(0)
,SmallVersion(0)
 {}

tS32 midw_mascffi_tclMsgANCSWVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCSWVERSIONSTATUS;
}


midw_mascffi_tclMsgANCSWVersionStatus::~midw_mascffi_tclMsgANCSWVersionStatus()
{}

tU32 midw_mascffi_tclMsgANCSWVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgANCSWVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LargeVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> SmallVersion);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgANCSWVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LargeVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << SmallVersion);
   return oOut;
}

tBool midw_mascffi_tclMsgANCSWVersionStatus::operator==(const midw_mascffi_tclMsgANCSWVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LargeVersion == roRef.LargeVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (SmallVersion == roRef.SmallVersion);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgASCSWVersionUpReg::midw_mascffi_tclMsgASCSWVersionUpReg()
 {}

tS32 midw_mascffi_tclMsgASCSWVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONUPREG;
}


midw_mascffi_tclMsgASCSWVersionUpReg::~midw_mascffi_tclMsgASCSWVersionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgASCSWVersionRelUpReg::midw_mascffi_tclMsgASCSWVersionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgASCSWVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONRELUPREG;
}


midw_mascffi_tclMsgASCSWVersionRelUpReg::~midw_mascffi_tclMsgASCSWVersionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgASCSWVersionGet::midw_mascffi_tclMsgASCSWVersionGet()
 {}

tS32 midw_mascffi_tclMsgASCSWVersionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONGET;
}


midw_mascffi_tclMsgASCSWVersionGet::~midw_mascffi_tclMsgASCSWVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgASCSWVersionStatus::midw_mascffi_tclMsgASCSWVersionStatus(const midw_mascffi_tclMsgASCSWVersionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
}
midw_mascffi_tclMsgASCSWVersionStatus& midw_mascffi_tclMsgASCSWVersionStatus::operator=(const midw_mascffi_tclMsgASCSWVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LargeVersion = coRef.LargeVersion;
   MiddleVersion = coRef.MiddleVersion;
   SmallVersion = coRef.SmallVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgASCSWVersionStatus::midw_mascffi_tclMsgASCSWVersionStatus()
:LargeVersion(0)
,MiddleVersion(0)
,SmallVersion(0)
 {}

tS32 midw_mascffi_tclMsgASCSWVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ASCSWVERSIONSTATUS;
}


midw_mascffi_tclMsgASCSWVersionStatus::~midw_mascffi_tclMsgASCSWVersionStatus()
{}

tU32 midw_mascffi_tclMsgASCSWVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgASCSWVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LargeVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> SmallVersion);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgASCSWVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LargeVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << SmallVersion);
   return oOut;
}

tBool midw_mascffi_tclMsgASCSWVersionStatus::operator==(const midw_mascffi_tclMsgASCSWVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LargeVersion == roRef.LargeVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (SmallVersion == roRef.SmallVersion);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgANCASCSettingUpReg::midw_mascffi_tclMsgANCASCSettingUpReg()
 {}

tS32 midw_mascffi_tclMsgANCASCSettingUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGUPREG;
}


midw_mascffi_tclMsgANCASCSettingUpReg::~midw_mascffi_tclMsgANCASCSettingUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCASCSettingRelUpReg::midw_mascffi_tclMsgANCASCSettingRelUpReg()
 {}

tS32 midw_mascffi_tclMsgANCASCSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGRELUPREG;
}


midw_mascffi_tclMsgANCASCSettingRelUpReg::~midw_mascffi_tclMsgANCASCSettingRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCASCSettingGet::midw_mascffi_tclMsgANCASCSettingGet()
 {}

tS32 midw_mascffi_tclMsgANCASCSettingGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGGET;
}


midw_mascffi_tclMsgANCASCSettingGet::~midw_mascffi_tclMsgANCASCSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgANCASCSettingSet::midw_mascffi_tclMsgANCASCSettingSet(const midw_mascffi_tclMsgANCASCSettingSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
}
midw_mascffi_tclMsgANCASCSettingSet& midw_mascffi_tclMsgANCASCSettingSet::operator=(const midw_mascffi_tclMsgANCASCSettingSet& coRef)
{
   if (this == &coRef) return *this;
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgANCASCSettingSet::midw_mascffi_tclMsgANCASCSettingSet()
:ANCAvailability(0)
,ASCAvailability(0)
 {}

tS32 midw_mascffi_tclMsgANCASCSettingSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGSET;
}


midw_mascffi_tclMsgANCASCSettingSet::~midw_mascffi_tclMsgANCASCSettingSet()
{}

tU32 midw_mascffi_tclMsgANCASCSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgANCASCSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ANCAvailability);
   (tVoid) (oIn >> ASCAvailability);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgANCASCSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ANCAvailability);
   (tVoid) (oOut << ASCAvailability);
   return oOut;
}

tBool midw_mascffi_tclMsgANCASCSettingSet::operator==(const midw_mascffi_tclMsgANCASCSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ANCAvailability == roRef.ANCAvailability);
   bResult = bResult && (ASCAvailability == roRef.ASCAvailability);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgANCASCSettingStatus::midw_mascffi_tclMsgANCASCSettingStatus(const midw_mascffi_tclMsgANCASCSettingStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
}
midw_mascffi_tclMsgANCASCSettingStatus& midw_mascffi_tclMsgANCASCSettingStatus::operator=(const midw_mascffi_tclMsgANCASCSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   ANCAvailability = coRef.ANCAvailability;
   ASCAvailability = coRef.ASCAvailability;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgANCASCSettingStatus::midw_mascffi_tclMsgANCASCSettingStatus()
:ANCAvailability(0)
,ASCAvailability(0)
 {}

tS32 midw_mascffi_tclMsgANCASCSettingStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSETTINGSTATUS;
}


midw_mascffi_tclMsgANCASCSettingStatus::~midw_mascffi_tclMsgANCASCSettingStatus()
{}

tU32 midw_mascffi_tclMsgANCASCSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgANCASCSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ANCAvailability);
   (tVoid) (oIn >> ASCAvailability);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgANCASCSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ANCAvailability);
   (tVoid) (oOut << ASCAvailability);
   return oOut;
}

tBool midw_mascffi_tclMsgANCASCSettingStatus::operator==(const midw_mascffi_tclMsgANCASCSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ANCAvailability == roRef.ANCAvailability);
   bResult = bResult && (ASCAvailability == roRef.ASCAvailability);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAmpSoftwareVersionUpReg::midw_mascffi_tclMsgAmpSoftwareVersionUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpSoftwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONUPREG;
}


midw_mascffi_tclMsgAmpSoftwareVersionUpReg::~midw_mascffi_tclMsgAmpSoftwareVersionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg::midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONRELUPREG;
}


midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg::~midw_mascffi_tclMsgAmpSoftwareVersionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpSoftwareVersionGet::midw_mascffi_tclMsgAmpSoftwareVersionGet()
 {}

tS32 midw_mascffi_tclMsgAmpSoftwareVersionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONGET;
}


midw_mascffi_tclMsgAmpSoftwareVersionGet::~midw_mascffi_tclMsgAmpSoftwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpSoftwareVersionStatus::midw_mascffi_tclMsgAmpSoftwareVersionStatus(const midw_mascffi_tclMsgAmpSoftwareVersionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
}
midw_mascffi_tclMsgAmpSoftwareVersionStatus& midw_mascffi_tclMsgAmpSoftwareVersionStatus::operator=(const midw_mascffi_tclMsgAmpSoftwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAmpSoftwareVersionStatus::midw_mascffi_tclMsgAmpSoftwareVersionStatus()
:LowerVersion(0)
,MiddleVersion(0)
,HigherVersion(0)
 {}

tS32 midw_mascffi_tclMsgAmpSoftwareVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPSOFTWAREVERSIONSTATUS;
}


midw_mascffi_tclMsgAmpSoftwareVersionStatus::~midw_mascffi_tclMsgAmpSoftwareVersionStatus()
{}

tU32 midw_mascffi_tclMsgAmpSoftwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgAmpSoftwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LowerVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> HigherVersion);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpSoftwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LowerVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << HigherVersion);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpSoftwareVersionStatus::operator==(const midw_mascffi_tclMsgAmpSoftwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LowerVersion == roRef.LowerVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (HigherVersion == roRef.HigherVersion);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAmpParameterVersionUpReg::midw_mascffi_tclMsgAmpParameterVersionUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpParameterVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONUPREG;
}


midw_mascffi_tclMsgAmpParameterVersionUpReg::~midw_mascffi_tclMsgAmpParameterVersionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpParameterVersionRelUpReg::midw_mascffi_tclMsgAmpParameterVersionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpParameterVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONRELUPREG;
}


midw_mascffi_tclMsgAmpParameterVersionRelUpReg::~midw_mascffi_tclMsgAmpParameterVersionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpParameterVersionGet::midw_mascffi_tclMsgAmpParameterVersionGet()
 {}

tS32 midw_mascffi_tclMsgAmpParameterVersionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONGET;
}


midw_mascffi_tclMsgAmpParameterVersionGet::~midw_mascffi_tclMsgAmpParameterVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpParameterVersionStatus::midw_mascffi_tclMsgAmpParameterVersionStatus(const midw_mascffi_tclMsgAmpParameterVersionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
}
midw_mascffi_tclMsgAmpParameterVersionStatus& midw_mascffi_tclMsgAmpParameterVersionStatus::operator=(const midw_mascffi_tclMsgAmpParameterVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAmpParameterVersionStatus::midw_mascffi_tclMsgAmpParameterVersionStatus()
:LowerVersion(0)
,MiddleVersion(0)
,HigherVersion(0)
 {}

tS32 midw_mascffi_tclMsgAmpParameterVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPPARAMETERVERSIONSTATUS;
}


midw_mascffi_tclMsgAmpParameterVersionStatus::~midw_mascffi_tclMsgAmpParameterVersionStatus()
{}

tU32 midw_mascffi_tclMsgAmpParameterVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgAmpParameterVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LowerVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> HigherVersion);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpParameterVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LowerVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << HigherVersion);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpParameterVersionStatus::operator==(const midw_mascffi_tclMsgAmpParameterVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LowerVersion == roRef.LowerVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (HigherVersion == roRef.HigherVersion);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAmpHardwareVersionUpReg::midw_mascffi_tclMsgAmpHardwareVersionUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpHardwareVersionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONUPREG;
}


midw_mascffi_tclMsgAmpHardwareVersionUpReg::~midw_mascffi_tclMsgAmpHardwareVersionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpHardwareVersionRelUpReg::midw_mascffi_tclMsgAmpHardwareVersionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpHardwareVersionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONRELUPREG;
}


midw_mascffi_tclMsgAmpHardwareVersionRelUpReg::~midw_mascffi_tclMsgAmpHardwareVersionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpHardwareVersionGet::midw_mascffi_tclMsgAmpHardwareVersionGet()
 {}

tS32 midw_mascffi_tclMsgAmpHardwareVersionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONGET;
}


midw_mascffi_tclMsgAmpHardwareVersionGet::~midw_mascffi_tclMsgAmpHardwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpHardwareVersionStatus::midw_mascffi_tclMsgAmpHardwareVersionStatus(const midw_mascffi_tclMsgAmpHardwareVersionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
}
midw_mascffi_tclMsgAmpHardwareVersionStatus& midw_mascffi_tclMsgAmpHardwareVersionStatus::operator=(const midw_mascffi_tclMsgAmpHardwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   LowerVersion = coRef.LowerVersion;
   MiddleVersion = coRef.MiddleVersion;
   HigherVersion = coRef.HigherVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAmpHardwareVersionStatus::midw_mascffi_tclMsgAmpHardwareVersionStatus()
:LowerVersion(0)
,MiddleVersion(0)
,HigherVersion(0)
 {}

tS32 midw_mascffi_tclMsgAmpHardwareVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPHARDWAREVERSIONSTATUS;
}


midw_mascffi_tclMsgAmpHardwareVersionStatus::~midw_mascffi_tclMsgAmpHardwareVersionStatus()
{}

tU32 midw_mascffi_tclMsgAmpHardwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgAmpHardwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LowerVersion);
   (tVoid) (oIn >> MiddleVersion);
   (tVoid) (oIn >> HigherVersion);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpHardwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LowerVersion);
   (tVoid) (oOut << MiddleVersion);
   (tVoid) (oOut << HigherVersion);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpHardwareVersionStatus::operator==(const midw_mascffi_tclMsgAmpHardwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LowerVersion == roRef.LowerVersion);
   bResult = bResult && (MiddleVersion == roRef.MiddleVersion);
   bResult = bResult && (HigherVersion == roRef.HigherVersion);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgSurroundVolUpReg::midw_mascffi_tclMsgSurroundVolUpReg()
 {}

tS32 midw_mascffi_tclMsgSurroundVolUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDVOLUPREG;
}


midw_mascffi_tclMsgSurroundVolUpReg::~midw_mascffi_tclMsgSurroundVolUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSurroundVolRelUpReg::midw_mascffi_tclMsgSurroundVolRelUpReg()
 {}

tS32 midw_mascffi_tclMsgSurroundVolRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDVOLRELUPREG;
}


midw_mascffi_tclMsgSurroundVolRelUpReg::~midw_mascffi_tclMsgSurroundVolRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSurroundVolGet::midw_mascffi_tclMsgSurroundVolGet()
 {}

tS32 midw_mascffi_tclMsgSurroundVolGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDVOLGET;
}


midw_mascffi_tclMsgSurroundVolGet::~midw_mascffi_tclMsgSurroundVolGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSurroundVolSet::midw_mascffi_tclMsgSurroundVolSet(const midw_mascffi_tclMsgSurroundVolSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SurroundVol = coRef.SurroundVol;
}
midw_mascffi_tclMsgSurroundVolSet& midw_mascffi_tclMsgSurroundVolSet::operator=(const midw_mascffi_tclMsgSurroundVolSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   Resource = coRef.Resource;
   SurroundVol = coRef.SurroundVol;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSurroundVolSet::midw_mascffi_tclMsgSurroundVolSet()
:SoundType()
,Resource()
,SurroundVol(0)
 {}

tS32 midw_mascffi_tclMsgSurroundVolSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDVOLSET;
}


midw_mascffi_tclMsgSurroundVolSet::~midw_mascffi_tclMsgSurroundVolSet()
{}

tU32 midw_mascffi_tclMsgSurroundVolSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgSurroundVolSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> SurroundVol);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSurroundVolSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << SurroundVol);
   return oOut;
}

tBool midw_mascffi_tclMsgSurroundVolSet::operator==(const midw_mascffi_tclMsgSurroundVolSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (SurroundVol == roRef.SurroundVol);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSurroundVolStatus::midw_mascffi_tclMsgSurroundVolStatus(const midw_mascffi_tclMsgSurroundVolStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SurroundVol = coRef.SurroundVol;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
}
midw_mascffi_tclMsgSurroundVolStatus& midw_mascffi_tclMsgSurroundVolStatus::operator=(const midw_mascffi_tclMsgSurroundVolStatus& coRef)
{
   if (this == &coRef) return *this;
   SurroundVol = coRef.SurroundVol;
   Resource = coRef.Resource;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSurroundVolStatus::midw_mascffi_tclMsgSurroundVolStatus()
:SurroundVol(0)
,Resource()
,Channel()
 {}

tS32 midw_mascffi_tclMsgSurroundVolStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDVOLSTATUS;
}


midw_mascffi_tclMsgSurroundVolStatus::~midw_mascffi_tclMsgSurroundVolStatus()
{}

tU32 midw_mascffi_tclMsgSurroundVolStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_mascffi_tclMsgSurroundVolStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SurroundVol);
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> Channel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSurroundVolStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SurroundVol);
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << Channel);
   return oOut;
}

tBool midw_mascffi_tclMsgSurroundVolStatus::operator==(const midw_mascffi_tclMsgSurroundVolStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SurroundVol == roRef.SurroundVol);
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (Channel == roRef.Channel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAudioPilotModeUpReg::midw_mascffi_tclMsgAudioPilotModeUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioPilotModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODEUPREG;
}


midw_mascffi_tclMsgAudioPilotModeUpReg::~midw_mascffi_tclMsgAudioPilotModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioPilotModeRelUpReg::midw_mascffi_tclMsgAudioPilotModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioPilotModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODERELUPREG;
}


midw_mascffi_tclMsgAudioPilotModeRelUpReg::~midw_mascffi_tclMsgAudioPilotModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioPilotModeGet::midw_mascffi_tclMsgAudioPilotModeGet()
 {}

tS32 midw_mascffi_tclMsgAudioPilotModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODEGET;
}


midw_mascffi_tclMsgAudioPilotModeGet::~midw_mascffi_tclMsgAudioPilotModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioPilotModeSet::midw_mascffi_tclMsgAudioPilotModeSet(const midw_mascffi_tclMsgAudioPilotModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AudPilotMode = coRef.AudPilotMode;
}
midw_mascffi_tclMsgAudioPilotModeSet& midw_mascffi_tclMsgAudioPilotModeSet::operator=(const midw_mascffi_tclMsgAudioPilotModeSet& coRef)
{
   if (this == &coRef) return *this;
   AudPilotMode = coRef.AudPilotMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioPilotModeSet::midw_mascffi_tclMsgAudioPilotModeSet()
:AudPilotMode(0)
 {}

tS32 midw_mascffi_tclMsgAudioPilotModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODESET;
}


midw_mascffi_tclMsgAudioPilotModeSet::~midw_mascffi_tclMsgAudioPilotModeSet()
{}

tU32 midw_mascffi_tclMsgAudioPilotModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioPilotModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudPilotMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioPilotModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudPilotMode);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioPilotModeSet::operator==(const midw_mascffi_tclMsgAudioPilotModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudPilotMode == roRef.AudPilotMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioPilotModeStatus::midw_mascffi_tclMsgAudioPilotModeStatus(const midw_mascffi_tclMsgAudioPilotModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AudPilotMode = coRef.AudPilotMode;
}
midw_mascffi_tclMsgAudioPilotModeStatus& midw_mascffi_tclMsgAudioPilotModeStatus::operator=(const midw_mascffi_tclMsgAudioPilotModeStatus& coRef)
{
   if (this == &coRef) return *this;
   AudPilotMode = coRef.AudPilotMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioPilotModeStatus::midw_mascffi_tclMsgAudioPilotModeStatus()
:AudPilotMode(0)
 {}

tS32 midw_mascffi_tclMsgAudioPilotModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTMODESTATUS;
}


midw_mascffi_tclMsgAudioPilotModeStatus::~midw_mascffi_tclMsgAudioPilotModeStatus()
{}

tU32 midw_mascffi_tclMsgAudioPilotModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioPilotModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudPilotMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioPilotModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudPilotMode);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioPilotModeStatus::operator==(const midw_mascffi_tclMsgAudioPilotModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudPilotMode == roRef.AudPilotMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgSurroundModeUpReg::midw_mascffi_tclMsgSurroundModeUpReg()
 {}

tS32 midw_mascffi_tclMsgSurroundModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDMODEUPREG;
}


midw_mascffi_tclMsgSurroundModeUpReg::~midw_mascffi_tclMsgSurroundModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSurroundModeRelUpReg::midw_mascffi_tclMsgSurroundModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgSurroundModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDMODERELUPREG;
}


midw_mascffi_tclMsgSurroundModeRelUpReg::~midw_mascffi_tclMsgSurroundModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSurroundModeGet::midw_mascffi_tclMsgSurroundModeGet()
 {}

tS32 midw_mascffi_tclMsgSurroundModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDMODEGET;
}


midw_mascffi_tclMsgSurroundModeGet::~midw_mascffi_tclMsgSurroundModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSurroundModeSet::midw_mascffi_tclMsgSurroundModeSet(const midw_mascffi_tclMsgSurroundModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SurroundMode = coRef.SurroundMode;
}
midw_mascffi_tclMsgSurroundModeSet& midw_mascffi_tclMsgSurroundModeSet::operator=(const midw_mascffi_tclMsgSurroundModeSet& coRef)
{
   if (this == &coRef) return *this;
   SurroundMode = coRef.SurroundMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSurroundModeSet::midw_mascffi_tclMsgSurroundModeSet()
:SurroundMode(0)
 {}

tS32 midw_mascffi_tclMsgSurroundModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDMODESET;
}


midw_mascffi_tclMsgSurroundModeSet::~midw_mascffi_tclMsgSurroundModeSet()
{}

tU32 midw_mascffi_tclMsgSurroundModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSurroundModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SurroundMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSurroundModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SurroundMode);
   return oOut;
}

tBool midw_mascffi_tclMsgSurroundModeSet::operator==(const midw_mascffi_tclMsgSurroundModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SurroundMode == roRef.SurroundMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSurroundModeStatus::midw_mascffi_tclMsgSurroundModeStatus(const midw_mascffi_tclMsgSurroundModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SurroundMode = coRef.SurroundMode;
}
midw_mascffi_tclMsgSurroundModeStatus& midw_mascffi_tclMsgSurroundModeStatus::operator=(const midw_mascffi_tclMsgSurroundModeStatus& coRef)
{
   if (this == &coRef) return *this;
   SurroundMode = coRef.SurroundMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSurroundModeStatus::midw_mascffi_tclMsgSurroundModeStatus()
:SurroundMode(0)
 {}

tS32 midw_mascffi_tclMsgSurroundModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDMODESTATUS;
}


midw_mascffi_tclMsgSurroundModeStatus::~midw_mascffi_tclMsgSurroundModeStatus()
{}

tU32 midw_mascffi_tclMsgSurroundModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSurroundModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SurroundMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSurroundModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SurroundMode);
   return oOut;
}

tBool midw_mascffi_tclMsgSurroundModeStatus::operator==(const midw_mascffi_tclMsgSurroundModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SurroundMode == roRef.SurroundMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAmpDownMixModeUpReg::midw_mascffi_tclMsgAmpDownMixModeUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpDownMixModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODEUPREG;
}


midw_mascffi_tclMsgAmpDownMixModeUpReg::~midw_mascffi_tclMsgAmpDownMixModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpDownMixModeRelUpReg::midw_mascffi_tclMsgAmpDownMixModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpDownMixModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODERELUPREG;
}


midw_mascffi_tclMsgAmpDownMixModeRelUpReg::~midw_mascffi_tclMsgAmpDownMixModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpDownMixModeGet::midw_mascffi_tclMsgAmpDownMixModeGet()
 {}

tS32 midw_mascffi_tclMsgAmpDownMixModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODEGET;
}


midw_mascffi_tclMsgAmpDownMixModeGet::~midw_mascffi_tclMsgAmpDownMixModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpDownMixModeSet::midw_mascffi_tclMsgAmpDownMixModeSet(const midw_mascffi_tclMsgAmpDownMixModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AmpDownMixMode = coRef.AmpDownMixMode;
}
midw_mascffi_tclMsgAmpDownMixModeSet& midw_mascffi_tclMsgAmpDownMixModeSet::operator=(const midw_mascffi_tclMsgAmpDownMixModeSet& coRef)
{
   if (this == &coRef) return *this;
   AmpDownMixMode = coRef.AmpDownMixMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAmpDownMixModeSet::midw_mascffi_tclMsgAmpDownMixModeSet()
:AmpDownMixMode(0)
 {}

tS32 midw_mascffi_tclMsgAmpDownMixModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODESET;
}


midw_mascffi_tclMsgAmpDownMixModeSet::~midw_mascffi_tclMsgAmpDownMixModeSet()
{}

tU32 midw_mascffi_tclMsgAmpDownMixModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAmpDownMixModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AmpDownMixMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpDownMixModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AmpDownMixMode);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpDownMixModeSet::operator==(const midw_mascffi_tclMsgAmpDownMixModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AmpDownMixMode == roRef.AmpDownMixMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpDownMixModeStatus::midw_mascffi_tclMsgAmpDownMixModeStatus(const midw_mascffi_tclMsgAmpDownMixModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AmpDownMixMode = coRef.AmpDownMixMode;
}
midw_mascffi_tclMsgAmpDownMixModeStatus& midw_mascffi_tclMsgAmpDownMixModeStatus::operator=(const midw_mascffi_tclMsgAmpDownMixModeStatus& coRef)
{
   if (this == &coRef) return *this;
   AmpDownMixMode = coRef.AmpDownMixMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAmpDownMixModeStatus::midw_mascffi_tclMsgAmpDownMixModeStatus()
:AmpDownMixMode(0)
 {}

tS32 midw_mascffi_tclMsgAmpDownMixModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPDOWNMIXMODESTATUS;
}


midw_mascffi_tclMsgAmpDownMixModeStatus::~midw_mascffi_tclMsgAmpDownMixModeStatus()
{}

tU32 midw_mascffi_tclMsgAmpDownMixModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAmpDownMixModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AmpDownMixMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpDownMixModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AmpDownMixMode);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpDownMixModeStatus::operator==(const midw_mascffi_tclMsgAmpDownMixModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AmpDownMixMode == roRef.AmpDownMixMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgDriverSoundModeUpReg::midw_mascffi_tclMsgDriverSoundModeUpReg()
 {}

tS32 midw_mascffi_tclMsgDriverSoundModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODEUPREG;
}


midw_mascffi_tclMsgDriverSoundModeUpReg::~midw_mascffi_tclMsgDriverSoundModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDriverSoundModeRelUpReg::midw_mascffi_tclMsgDriverSoundModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgDriverSoundModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODERELUPREG;
}


midw_mascffi_tclMsgDriverSoundModeRelUpReg::~midw_mascffi_tclMsgDriverSoundModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDriverSoundModeGet::midw_mascffi_tclMsgDriverSoundModeGet()
 {}

tS32 midw_mascffi_tclMsgDriverSoundModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODEGET;
}


midw_mascffi_tclMsgDriverSoundModeGet::~midw_mascffi_tclMsgDriverSoundModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgDriverSoundModeSet::midw_mascffi_tclMsgDriverSoundModeSet(const midw_mascffi_tclMsgDriverSoundModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DriverMode = coRef.DriverMode;
}
midw_mascffi_tclMsgDriverSoundModeSet& midw_mascffi_tclMsgDriverSoundModeSet::operator=(const midw_mascffi_tclMsgDriverSoundModeSet& coRef)
{
   if (this == &coRef) return *this;
   DriverMode = coRef.DriverMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgDriverSoundModeSet::midw_mascffi_tclMsgDriverSoundModeSet()
:DriverMode(0)
 {}

tS32 midw_mascffi_tclMsgDriverSoundModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODESET;
}


midw_mascffi_tclMsgDriverSoundModeSet::~midw_mascffi_tclMsgDriverSoundModeSet()
{}

tU32 midw_mascffi_tclMsgDriverSoundModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgDriverSoundModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriverMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgDriverSoundModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriverMode);
   return oOut;
}

tBool midw_mascffi_tclMsgDriverSoundModeSet::operator==(const midw_mascffi_tclMsgDriverSoundModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriverMode == roRef.DriverMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgDriverSoundModeStatus::midw_mascffi_tclMsgDriverSoundModeStatus(const midw_mascffi_tclMsgDriverSoundModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DriverMode = coRef.DriverMode;
}
midw_mascffi_tclMsgDriverSoundModeStatus& midw_mascffi_tclMsgDriverSoundModeStatus::operator=(const midw_mascffi_tclMsgDriverSoundModeStatus& coRef)
{
   if (this == &coRef) return *this;
   DriverMode = coRef.DriverMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgDriverSoundModeStatus::midw_mascffi_tclMsgDriverSoundModeStatus()
:DriverMode(0)
 {}

tS32 midw_mascffi_tclMsgDriverSoundModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DRIVERSOUNDMODESTATUS;
}


midw_mascffi_tclMsgDriverSoundModeStatus::~midw_mascffi_tclMsgDriverSoundModeStatus()
{}

tU32 midw_mascffi_tclMsgDriverSoundModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgDriverSoundModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriverMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgDriverSoundModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriverMode);
   return oOut;
}

tBool midw_mascffi_tclMsgDriverSoundModeStatus::operator==(const midw_mascffi_tclMsgDriverSoundModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriverMode == roRef.DriverMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRearSoundModeUpReg::midw_mascffi_tclMsgRearSoundModeUpReg()
 {}

tS32 midw_mascffi_tclMsgRearSoundModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REARSOUNDMODEUPREG;
}


midw_mascffi_tclMsgRearSoundModeUpReg::~midw_mascffi_tclMsgRearSoundModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRearSoundModeRelUpReg::midw_mascffi_tclMsgRearSoundModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgRearSoundModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REARSOUNDMODERELUPREG;
}


midw_mascffi_tclMsgRearSoundModeRelUpReg::~midw_mascffi_tclMsgRearSoundModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRearSoundModeGet::midw_mascffi_tclMsgRearSoundModeGet()
 {}

tS32 midw_mascffi_tclMsgRearSoundModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REARSOUNDMODEGET;
}


midw_mascffi_tclMsgRearSoundModeGet::~midw_mascffi_tclMsgRearSoundModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRearSoundModeSet::midw_mascffi_tclMsgRearSoundModeSet(const midw_mascffi_tclMsgRearSoundModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RearMode = coRef.RearMode;
}
midw_mascffi_tclMsgRearSoundModeSet& midw_mascffi_tclMsgRearSoundModeSet::operator=(const midw_mascffi_tclMsgRearSoundModeSet& coRef)
{
   if (this == &coRef) return *this;
   RearMode = coRef.RearMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRearSoundModeSet::midw_mascffi_tclMsgRearSoundModeSet()
:RearMode(0)
 {}

tS32 midw_mascffi_tclMsgRearSoundModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REARSOUNDMODESET;
}


midw_mascffi_tclMsgRearSoundModeSet::~midw_mascffi_tclMsgRearSoundModeSet()
{}

tU32 midw_mascffi_tclMsgRearSoundModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRearSoundModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RearMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRearSoundModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RearMode);
   return oOut;
}

tBool midw_mascffi_tclMsgRearSoundModeSet::operator==(const midw_mascffi_tclMsgRearSoundModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RearMode == roRef.RearMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRearSoundModeStatus::midw_mascffi_tclMsgRearSoundModeStatus(const midw_mascffi_tclMsgRearSoundModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RearMode = coRef.RearMode;
}
midw_mascffi_tclMsgRearSoundModeStatus& midw_mascffi_tclMsgRearSoundModeStatus::operator=(const midw_mascffi_tclMsgRearSoundModeStatus& coRef)
{
   if (this == &coRef) return *this;
   RearMode = coRef.RearMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRearSoundModeStatus::midw_mascffi_tclMsgRearSoundModeStatus()
:RearMode(0)
 {}

tS32 midw_mascffi_tclMsgRearSoundModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_REARSOUNDMODESTATUS;
}


midw_mascffi_tclMsgRearSoundModeStatus::~midw_mascffi_tclMsgRearSoundModeStatus()
{}

tU32 midw_mascffi_tclMsgRearSoundModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRearSoundModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RearMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRearSoundModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RearMode);
   return oOut;
}

tBool midw_mascffi_tclMsgRearSoundModeStatus::operator==(const midw_mascffi_tclMsgRearSoundModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RearMode == roRef.RearMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAudioOFFMuteStateUpReg::midw_mascffi_tclMsgAudioOFFMuteStateUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioOFFMuteStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATEUPREG;
}


midw_mascffi_tclMsgAudioOFFMuteStateUpReg::~midw_mascffi_tclMsgAudioOFFMuteStateUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg::midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATERELUPREG;
}


midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg::~midw_mascffi_tclMsgAudioOFFMuteStateRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioOFFMuteStateSet::midw_mascffi_tclMsgAudioOFFMuteStateSet(const midw_mascffi_tclMsgAudioOFFMuteStateSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   MuteState = coRef.MuteState;
}
midw_mascffi_tclMsgAudioOFFMuteStateSet& midw_mascffi_tclMsgAudioOFFMuteStateSet::operator=(const midw_mascffi_tclMsgAudioOFFMuteStateSet& coRef)
{
   if (this == &coRef) return *this;
   MuteState = coRef.MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioOFFMuteStateSet::midw_mascffi_tclMsgAudioOFFMuteStateSet()
:MuteState(0)
 {}

tS32 midw_mascffi_tclMsgAudioOFFMuteStateSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATESET;
}


midw_mascffi_tclMsgAudioOFFMuteStateSet::~midw_mascffi_tclMsgAudioOFFMuteStateSet()
{}

tU32 midw_mascffi_tclMsgAudioOFFMuteStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioOFFMuteStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MuteState);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioOFFMuteStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MuteState);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioOFFMuteStateSet::operator==(const midw_mascffi_tclMsgAudioOFFMuteStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MuteState == roRef.MuteState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioOFFMuteStateStatus::midw_mascffi_tclMsgAudioOFFMuteStateStatus(const midw_mascffi_tclMsgAudioOFFMuteStateStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   MuteState = coRef.MuteState;
}
midw_mascffi_tclMsgAudioOFFMuteStateStatus& midw_mascffi_tclMsgAudioOFFMuteStateStatus::operator=(const midw_mascffi_tclMsgAudioOFFMuteStateStatus& coRef)
{
   if (this == &coRef) return *this;
   MuteState = coRef.MuteState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioOFFMuteStateStatus::midw_mascffi_tclMsgAudioOFFMuteStateStatus()
:MuteState(0)
 {}

tS32 midw_mascffi_tclMsgAudioOFFMuteStateStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOOFFMUTESTATESTATUS;
}


midw_mascffi_tclMsgAudioOFFMuteStateStatus::~midw_mascffi_tclMsgAudioOFFMuteStateStatus()
{}

tU32 midw_mascffi_tclMsgAudioOFFMuteStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioOFFMuteStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MuteState);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioOFFMuteStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MuteState);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioOFFMuteStateStatus::operator==(const midw_mascffi_tclMsgAudioOFFMuteStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MuteState == roRef.MuteState);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg::midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSUPREG;
}


midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg::~midw_mascffi_tclMsgMicrophoneConnectionStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg::midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSRELUPREG;
}


midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg::~midw_mascffi_tclMsgMicrophoneConnectionStatusRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgMicrophoneConnectionStatusGet::midw_mascffi_tclMsgMicrophoneConnectionStatusGet()
 {}

tS32 midw_mascffi_tclMsgMicrophoneConnectionStatusGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSGET;
}


midw_mascffi_tclMsgMicrophoneConnectionStatusGet::~midw_mascffi_tclMsgMicrophoneConnectionStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::midw_mascffi_tclMsgMicrophoneConnectionStatusStatus(const midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
}
midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::operator=(const midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   MicrophoneConnectionStatusList = coRef.MicrophoneConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::vDestroy()
{
   MicrophoneConnectionStatusList.vDestroy(); 
}

midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::midw_mascffi_tclMsgMicrophoneConnectionStatusStatus()
:MicrophoneConnectionStatusList()
 {}

tS32 midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MICROPHONECONNECTIONSTATUSSTATUS;
}


midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::~midw_mascffi_tclMsgMicrophoneConnectionStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+MicrophoneConnectionStatusList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MicrophoneConnectionStatusList);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MicrophoneConnectionStatusList);
   return oOut;
}

tBool midw_mascffi_tclMsgMicrophoneConnectionStatusStatus::operator==(const midw_mascffi_tclMsgMicrophoneConnectionStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MicrophoneConnectionStatusList == roRef.MicrophoneConnectionStatusList);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgConnectionUpReg::midw_mascffi_tclMsgConnectionUpReg()
 {}

tS32 midw_mascffi_tclMsgConnectionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CONNECTIONUPREG;
}


midw_mascffi_tclMsgConnectionUpReg::~midw_mascffi_tclMsgConnectionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgConnectionRelUpReg::midw_mascffi_tclMsgConnectionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgConnectionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CONNECTIONRELUPREG;
}


midw_mascffi_tclMsgConnectionRelUpReg::~midw_mascffi_tclMsgConnectionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgConnectionGet::midw_mascffi_tclMsgConnectionGet()
 {}

tS32 midw_mascffi_tclMsgConnectionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CONNECTIONGET;
}


midw_mascffi_tclMsgConnectionGet::~midw_mascffi_tclMsgConnectionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgConnectionStatus::midw_mascffi_tclMsgConnectionStatus(const midw_mascffi_tclMsgConnectionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   arConnectionStatusList = coRef.arConnectionStatusList;
}
midw_mascffi_tclMsgConnectionStatus& midw_mascffi_tclMsgConnectionStatus::operator=(const midw_mascffi_tclMsgConnectionStatus& coRef)
{
   if (this == &coRef) return *this;
   arConnectionStatusList = coRef.arConnectionStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgConnectionStatus::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
         arConnectionStatusList[u32Idx].vDestroy();
   arConnectionStatusList.clear();
   }
}

midw_mascffi_tclMsgConnectionStatus::midw_mascffi_tclMsgConnectionStatus()

 {}

tS32 midw_mascffi_tclMsgConnectionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_CONNECTIONSTATUS;
}


midw_mascffi_tclMsgConnectionStatus::~midw_mascffi_tclMsgConnectionStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgConnectionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(arConnectionStatusList.size()*4);
}

fi_tclInContext& midw_mascffi_tclMsgConnectionStatus::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
      {
         arConnectionStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      arConnectionStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> arConnectionStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgConnectionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)arConnectionStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < arConnectionStatusList.size(); ++u32Idx)
         (tVoid) (oOut << arConnectionStatusList[u32Idx]);
   }
   return oOut;
}

tBool midw_mascffi_tclMsgConnectionStatus::operator==(const midw_mascffi_tclMsgConnectionStatus& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (arConnectionStatusList.size() == roRef.arConnectionStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < arConnectionStatusList.size()); ++u32Idx)
            bResult = bResult && (arConnectionStatusList[u32Idx] == roRef.arConnectionStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgVolumeListUpReg::midw_mascffi_tclMsgVolumeListUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeListUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELISTUPREG;
}


midw_mascffi_tclMsgVolumeListUpReg::~midw_mascffi_tclMsgVolumeListUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeListRelUpReg::midw_mascffi_tclMsgVolumeListRelUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeListRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELISTRELUPREG;
}


midw_mascffi_tclMsgVolumeListRelUpReg::~midw_mascffi_tclMsgVolumeListRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeListGet::midw_mascffi_tclMsgVolumeListGet()
 {}

tS32 midw_mascffi_tclMsgVolumeListGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELISTGET;
}


midw_mascffi_tclMsgVolumeListGet::~midw_mascffi_tclMsgVolumeListGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeListSet::midw_mascffi_tclMsgVolumeListSet(const midw_mascffi_tclMsgVolumeListSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AudVolumeList = coRef.AudVolumeList;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgVolumeListSet& midw_mascffi_tclMsgVolumeListSet::operator=(const midw_mascffi_tclMsgVolumeListSet& coRef)
{
   if (this == &coRef) return *this;
   AudVolumeList = coRef.AudVolumeList;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgVolumeListSet::vDestroy()
{
   AudVolumeList.vDestroy(); 
}

midw_mascffi_tclMsgVolumeListSet::midw_mascffi_tclMsgVolumeListSet()
:AudVolumeList()
,Resource()
 {}

tS32 midw_mascffi_tclMsgVolumeListSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELISTSET;
}


midw_mascffi_tclMsgVolumeListSet::~midw_mascffi_tclMsgVolumeListSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgVolumeListSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+AudVolumeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgVolumeListSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudVolumeList);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeListSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudVolumeList);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeListSet::operator==(const midw_mascffi_tclMsgVolumeListSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudVolumeList == roRef.AudVolumeList);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeListStatus::midw_mascffi_tclMsgVolumeListStatus(const midw_mascffi_tclMsgVolumeListStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Resource = coRef.Resource;
   AudVolumeList = coRef.AudVolumeList;
}
midw_mascffi_tclMsgVolumeListStatus& midw_mascffi_tclMsgVolumeListStatus::operator=(const midw_mascffi_tclMsgVolumeListStatus& coRef)
{
   if (this == &coRef) return *this;
   Resource = coRef.Resource;
   AudVolumeList = coRef.AudVolumeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgVolumeListStatus::vDestroy()
{
   AudVolumeList.vDestroy(); 
}

midw_mascffi_tclMsgVolumeListStatus::midw_mascffi_tclMsgVolumeListStatus()
:Resource()
,AudVolumeList()
 {}

tS32 midw_mascffi_tclMsgVolumeListStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELISTSTATUS;
}


midw_mascffi_tclMsgVolumeListStatus::~midw_mascffi_tclMsgVolumeListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgVolumeListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+AudVolumeList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgVolumeListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Resource);
   (tVoid) (oIn >> AudVolumeList);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Resource);
   (tVoid) (oOut << AudVolumeList);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeListStatus::operator==(const midw_mascffi_tclMsgVolumeListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Resource == roRef.Resource);
   bResult = bResult && (AudVolumeList == roRef.AudVolumeList);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgBTAudioInLevelUpReg::midw_mascffi_tclMsgBTAudioInLevelUpReg()
 {}

tS32 midw_mascffi_tclMsgBTAudioInLevelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELUPREG;
}


midw_mascffi_tclMsgBTAudioInLevelUpReg::~midw_mascffi_tclMsgBTAudioInLevelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBTAudioInLevelRelUpReg::midw_mascffi_tclMsgBTAudioInLevelRelUpReg()
 {}

tS32 midw_mascffi_tclMsgBTAudioInLevelRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELRELUPREG;
}


midw_mascffi_tclMsgBTAudioInLevelRelUpReg::~midw_mascffi_tclMsgBTAudioInLevelRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgBTAudioInLevelGet::midw_mascffi_tclMsgBTAudioInLevelGet()
 {}

tS32 midw_mascffi_tclMsgBTAudioInLevelGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELGET;
}


midw_mascffi_tclMsgBTAudioInLevelGet::~midw_mascffi_tclMsgBTAudioInLevelGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBTAudioInLevelSet::midw_mascffi_tclMsgBTAudioInLevelSet(const midw_mascffi_tclMsgBTAudioInLevelSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   BTAudioInLevel = coRef.BTAudioInLevel;
}
midw_mascffi_tclMsgBTAudioInLevelSet& midw_mascffi_tclMsgBTAudioInLevelSet::operator=(const midw_mascffi_tclMsgBTAudioInLevelSet& coRef)
{
   if (this == &coRef) return *this;
   BTAudioInLevel = coRef.BTAudioInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBTAudioInLevelSet::midw_mascffi_tclMsgBTAudioInLevelSet()
:BTAudioInLevel()
 {}

tS32 midw_mascffi_tclMsgBTAudioInLevelSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELSET;
}


midw_mascffi_tclMsgBTAudioInLevelSet::~midw_mascffi_tclMsgBTAudioInLevelSet()
{}

tU32 midw_mascffi_tclMsgBTAudioInLevelSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgBTAudioInLevelSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTAudioInLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBTAudioInLevelSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTAudioInLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgBTAudioInLevelSet::operator==(const midw_mascffi_tclMsgBTAudioInLevelSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTAudioInLevel == roRef.BTAudioInLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgBTAudioInLevelStatus::midw_mascffi_tclMsgBTAudioInLevelStatus(const midw_mascffi_tclMsgBTAudioInLevelStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   BTAudioInLevel = coRef.BTAudioInLevel;
}
midw_mascffi_tclMsgBTAudioInLevelStatus& midw_mascffi_tclMsgBTAudioInLevelStatus::operator=(const midw_mascffi_tclMsgBTAudioInLevelStatus& coRef)
{
   if (this == &coRef) return *this;
   BTAudioInLevel = coRef.BTAudioInLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgBTAudioInLevelStatus::midw_mascffi_tclMsgBTAudioInLevelStatus()
:BTAudioInLevel()
 {}

tS32 midw_mascffi_tclMsgBTAudioInLevelStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_BTAUDIOINLEVELSTATUS;
}


midw_mascffi_tclMsgBTAudioInLevelStatus::~midw_mascffi_tclMsgBTAudioInLevelStatus()
{}

tU32 midw_mascffi_tclMsgBTAudioInLevelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgBTAudioInLevelStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> BTAudioInLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgBTAudioInLevelStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << BTAudioInLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgBTAudioInLevelStatus::operator==(const midw_mascffi_tclMsgBTAudioInLevelStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (BTAudioInLevel == roRef.BTAudioInLevel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgEngineeringDataUpReg::midw_mascffi_tclMsgEngineeringDataUpReg()
 {}

tS32 midw_mascffi_tclMsgEngineeringDataUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATAUPREG;
}


midw_mascffi_tclMsgEngineeringDataUpReg::~midw_mascffi_tclMsgEngineeringDataUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgEngineeringDataRelUpReg::midw_mascffi_tclMsgEngineeringDataRelUpReg()
 {}

tS32 midw_mascffi_tclMsgEngineeringDataRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATARELUPREG;
}


midw_mascffi_tclMsgEngineeringDataRelUpReg::~midw_mascffi_tclMsgEngineeringDataRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgEngineeringDataGet::midw_mascffi_tclMsgEngineeringDataGet()
 {}

tS32 midw_mascffi_tclMsgEngineeringDataGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATAGET;
}


midw_mascffi_tclMsgEngineeringDataGet::~midw_mascffi_tclMsgEngineeringDataGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEngineeringDataSet::midw_mascffi_tclMsgEngineeringDataSet(const midw_mascffi_tclMsgEngineeringDataSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   EngineeringDataList = coRef.EngineeringDataList;
}
midw_mascffi_tclMsgEngineeringDataSet& midw_mascffi_tclMsgEngineeringDataSet::operator=(const midw_mascffi_tclMsgEngineeringDataSet& coRef)
{
   if (this == &coRef) return *this;
   EngineeringDataList = coRef.EngineeringDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgEngineeringDataSet::vDestroy()
{
   EngineeringDataList.vDestroy(); 
}

midw_mascffi_tclMsgEngineeringDataSet::midw_mascffi_tclMsgEngineeringDataSet()
:EngineeringDataList()
 {}

tS32 midw_mascffi_tclMsgEngineeringDataSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATASET;
}


midw_mascffi_tclMsgEngineeringDataSet::~midw_mascffi_tclMsgEngineeringDataSet()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgEngineeringDataSet::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+EngineeringDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgEngineeringDataSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EngineeringDataList);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEngineeringDataSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EngineeringDataList);
   return oOut;
}

tBool midw_mascffi_tclMsgEngineeringDataSet::operator==(const midw_mascffi_tclMsgEngineeringDataSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EngineeringDataList == roRef.EngineeringDataList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEngineeringDataStatus::midw_mascffi_tclMsgEngineeringDataStatus(const midw_mascffi_tclMsgEngineeringDataStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   EngineeringDataList = coRef.EngineeringDataList;
}
midw_mascffi_tclMsgEngineeringDataStatus& midw_mascffi_tclMsgEngineeringDataStatus::operator=(const midw_mascffi_tclMsgEngineeringDataStatus& coRef)
{
   if (this == &coRef) return *this;
   EngineeringDataList = coRef.EngineeringDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgEngineeringDataStatus::vDestroy()
{
   EngineeringDataList.vDestroy(); 
}

midw_mascffi_tclMsgEngineeringDataStatus::midw_mascffi_tclMsgEngineeringDataStatus()
:EngineeringDataList()
 {}

tS32 midw_mascffi_tclMsgEngineeringDataStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENGINEERINGDATASTATUS;
}


midw_mascffi_tclMsgEngineeringDataStatus::~midw_mascffi_tclMsgEngineeringDataStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgEngineeringDataStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+EngineeringDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgEngineeringDataStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EngineeringDataList);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEngineeringDataStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EngineeringDataList);
   return oOut;
}

tBool midw_mascffi_tclMsgEngineeringDataStatus::operator==(const midw_mascffi_tclMsgEngineeringDataStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EngineeringDataList == roRef.EngineeringDataList);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgSurroundSettingUpReg::midw_mascffi_tclMsgSurroundSettingUpReg()
 {}

tS32 midw_mascffi_tclMsgSurroundSettingUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGUPREG;
}


midw_mascffi_tclMsgSurroundSettingUpReg::~midw_mascffi_tclMsgSurroundSettingUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSurroundSettingRelUpReg::midw_mascffi_tclMsgSurroundSettingRelUpReg()
 {}

tS32 midw_mascffi_tclMsgSurroundSettingRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGRELUPREG;
}


midw_mascffi_tclMsgSurroundSettingRelUpReg::~midw_mascffi_tclMsgSurroundSettingRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSurroundSettingGet::midw_mascffi_tclMsgSurroundSettingGet()
 {}

tS32 midw_mascffi_tclMsgSurroundSettingGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGGET;
}


midw_mascffi_tclMsgSurroundSettingGet::~midw_mascffi_tclMsgSurroundSettingGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSurroundSettingSet::midw_mascffi_tclMsgSurroundSettingSet(const midw_mascffi_tclMsgSurroundSettingSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Surround = coRef.Surround;
}
midw_mascffi_tclMsgSurroundSettingSet& midw_mascffi_tclMsgSurroundSettingSet::operator=(const midw_mascffi_tclMsgSurroundSettingSet& coRef)
{
   if (this == &coRef) return *this;
   Surround = coRef.Surround;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSurroundSettingSet::midw_mascffi_tclMsgSurroundSettingSet()
:Surround()
 {}

tS32 midw_mascffi_tclMsgSurroundSettingSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGSET;
}


midw_mascffi_tclMsgSurroundSettingSet::~midw_mascffi_tclMsgSurroundSettingSet()
{}

tU32 midw_mascffi_tclMsgSurroundSettingSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSurroundSettingSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Surround);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSurroundSettingSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Surround);
   return oOut;
}

tBool midw_mascffi_tclMsgSurroundSettingSet::operator==(const midw_mascffi_tclMsgSurroundSettingSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Surround == roRef.Surround);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSurroundSettingStatus::midw_mascffi_tclMsgSurroundSettingStatus(const midw_mascffi_tclMsgSurroundSettingStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Surround = coRef.Surround;
}
midw_mascffi_tclMsgSurroundSettingStatus& midw_mascffi_tclMsgSurroundSettingStatus::operator=(const midw_mascffi_tclMsgSurroundSettingStatus& coRef)
{
   if (this == &coRef) return *this;
   Surround = coRef.Surround;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSurroundSettingStatus::midw_mascffi_tclMsgSurroundSettingStatus()
:Surround()
 {}

tS32 midw_mascffi_tclMsgSurroundSettingStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SURROUNDSETTINGSTATUS;
}


midw_mascffi_tclMsgSurroundSettingStatus::~midw_mascffi_tclMsgSurroundSettingStatus()
{}

tU32 midw_mascffi_tclMsgSurroundSettingStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSurroundSettingStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Surround);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSurroundSettingStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Surround);
   return oOut;
}

tBool midw_mascffi_tclMsgSurroundSettingStatus::operator==(const midw_mascffi_tclMsgSurroundSettingStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Surround == roRef.Surround);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgVolumeLockUpReg::midw_mascffi_tclMsgVolumeLockUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeLockUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELOCKUPREG;
}


midw_mascffi_tclMsgVolumeLockUpReg::~midw_mascffi_tclMsgVolumeLockUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeLockRelUpReg::midw_mascffi_tclMsgVolumeLockRelUpReg()
 {}

tS32 midw_mascffi_tclMsgVolumeLockRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELOCKRELUPREG;
}


midw_mascffi_tclMsgVolumeLockRelUpReg::~midw_mascffi_tclMsgVolumeLockRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgVolumeLockGet::midw_mascffi_tclMsgVolumeLockGet()
 {}

tS32 midw_mascffi_tclMsgVolumeLockGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELOCKGET;
}


midw_mascffi_tclMsgVolumeLockGet::~midw_mascffi_tclMsgVolumeLockGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeLockSet::midw_mascffi_tclMsgVolumeLockSet(const midw_mascffi_tclMsgVolumeLockSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
}
midw_mascffi_tclMsgVolumeLockSet& midw_mascffi_tclMsgVolumeLockSet::operator=(const midw_mascffi_tclMsgVolumeLockSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgVolumeLockSet::midw_mascffi_tclMsgVolumeLockSet()
:VolumeLockType()
,Requester()
 {}

tS32 midw_mascffi_tclMsgVolumeLockSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELOCKSET;
}


midw_mascffi_tclMsgVolumeLockSet::~midw_mascffi_tclMsgVolumeLockSet()
{}

tU32 midw_mascffi_tclMsgVolumeLockSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgVolumeLockSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLockType);
   (tVoid) (oIn >> Requester);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeLockSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLockType);
   (tVoid) (oOut << Requester);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeLockSet::operator==(const midw_mascffi_tclMsgVolumeLockSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLockType == roRef.VolumeLockType);
   bResult = bResult && (Requester == roRef.Requester);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgVolumeLockStatus::midw_mascffi_tclMsgVolumeLockStatus(const midw_mascffi_tclMsgVolumeLockStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
}
midw_mascffi_tclMsgVolumeLockStatus& midw_mascffi_tclMsgVolumeLockStatus::operator=(const midw_mascffi_tclMsgVolumeLockStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeLockType = coRef.VolumeLockType;
   Requester = coRef.Requester;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgVolumeLockStatus::midw_mascffi_tclMsgVolumeLockStatus()
:VolumeLockType()
,Requester()
 {}

tS32 midw_mascffi_tclMsgVolumeLockStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_VOLUMELOCKSTATUS;
}


midw_mascffi_tclMsgVolumeLockStatus::~midw_mascffi_tclMsgVolumeLockStatus()
{}

tU32 midw_mascffi_tclMsgVolumeLockStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgVolumeLockStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLockType);
   (tVoid) (oIn >> Requester);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgVolumeLockStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLockType);
   (tVoid) (oOut << Requester);
   return oOut;
}

tBool midw_mascffi_tclMsgVolumeLockStatus::operator==(const midw_mascffi_tclMsgVolumeLockStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLockType == roRef.VolumeLockType);
   bResult = bResult && (Requester == roRef.Requester);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAmpAvailFunctionUpReg::midw_mascffi_tclMsgAmpAvailFunctionUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpAvailFunctionUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONUPREG;
}


midw_mascffi_tclMsgAmpAvailFunctionUpReg::~midw_mascffi_tclMsgAmpAvailFunctionUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpAvailFunctionRelUpReg::midw_mascffi_tclMsgAmpAvailFunctionRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAmpAvailFunctionRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONRELUPREG;
}


midw_mascffi_tclMsgAmpAvailFunctionRelUpReg::~midw_mascffi_tclMsgAmpAvailFunctionRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAmpAvailFunctionGet::midw_mascffi_tclMsgAmpAvailFunctionGet()
 {}

tS32 midw_mascffi_tclMsgAmpAvailFunctionGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONGET;
}


midw_mascffi_tclMsgAmpAvailFunctionGet::~midw_mascffi_tclMsgAmpAvailFunctionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAmpAvailFunctionStatus::midw_mascffi_tclMsgAmpAvailFunctionStatus(const midw_mascffi_tclMsgAmpAvailFunctionStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Bass = coRef.Bass;
   Middle = coRef.Middle;
   Treble = coRef.Treble;
   Balance = coRef.Balance;
   Fader = coRef.Fader;
   AudioPilot = coRef.AudioPilot;
   Gala = coRef.Gala;
   SurroundMode = coRef.SurroundMode;
   SubWoofer = coRef.SubWoofer;
   Staging = coRef.Staging;
   RoomEffect = coRef.RoomEffect;
   Loudness = coRef.Loudness;
   AGC = coRef.AGC;
   AmpDownMix = coRef.AmpDownMix;
   SurroundVol = coRef.SurroundVol;
   RearSoundMode = coRef.RearSoundMode;
   DriverSoundMode = coRef.DriverSoundMode;
   ANC = coRef.ANC;
   ASC = coRef.ASC;
   SoundAmbiance = coRef.SoundAmbiance;
   ESE = coRef.ESE;
}
midw_mascffi_tclMsgAmpAvailFunctionStatus& midw_mascffi_tclMsgAmpAvailFunctionStatus::operator=(const midw_mascffi_tclMsgAmpAvailFunctionStatus& coRef)
{
   if (this == &coRef) return *this;
   Bass = coRef.Bass;
   Middle = coRef.Middle;
   Treble = coRef.Treble;
   Balance = coRef.Balance;
   Fader = coRef.Fader;
   AudioPilot = coRef.AudioPilot;
   Gala = coRef.Gala;
   SurroundMode = coRef.SurroundMode;
   SubWoofer = coRef.SubWoofer;
   Staging = coRef.Staging;
   RoomEffect = coRef.RoomEffect;
   Loudness = coRef.Loudness;
   AGC = coRef.AGC;
   AmpDownMix = coRef.AmpDownMix;
   SurroundVol = coRef.SurroundVol;
   RearSoundMode = coRef.RearSoundMode;
   DriverSoundMode = coRef.DriverSoundMode;
   ANC = coRef.ANC;
   ASC = coRef.ASC;
   SoundAmbiance = coRef.SoundAmbiance;
   ESE = coRef.ESE;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAmpAvailFunctionStatus::midw_mascffi_tclMsgAmpAvailFunctionStatus()
:Bass(0)
,Middle(0)
,Treble(0)
,Balance(0)
,Fader(0)
,AudioPilot(0)
,Gala(0)
,SurroundMode(0)
,SubWoofer(0)
,Staging(0)
,RoomEffect(0)
,Loudness(0)
,AGC(0)
,AmpDownMix(0)
,SurroundVol(0)
,RearSoundMode(0)
,DriverSoundMode(0)
,ANC(0)
,ASC(0)
,SoundAmbiance(0)
,ESE(0)
 {}

tS32 midw_mascffi_tclMsgAmpAvailFunctionStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AMPAVAILFUNCTIONSTATUS;
}


midw_mascffi_tclMsgAmpAvailFunctionStatus::~midw_mascffi_tclMsgAmpAvailFunctionStatus()
{}

tU32 midw_mascffi_tclMsgAmpAvailFunctionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 21;
}

fi_tclInContext& midw_mascffi_tclMsgAmpAvailFunctionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Bass);
   (tVoid) (oIn >> Middle);
   (tVoid) (oIn >> Treble);
   (tVoid) (oIn >> Balance);
   (tVoid) (oIn >> Fader);
   (tVoid) (oIn >> AudioPilot);
   (tVoid) (oIn >> Gala);
   (tVoid) (oIn >> SurroundMode);
   (tVoid) (oIn >> SubWoofer);
   (tVoid) (oIn >> Staging);
   (tVoid) (oIn >> RoomEffect);
   (tVoid) (oIn >> Loudness);
   (tVoid) (oIn >> AGC);
   (tVoid) (oIn >> AmpDownMix);
   (tVoid) (oIn >> SurroundVol);
   (tVoid) (oIn >> RearSoundMode);
   (tVoid) (oIn >> DriverSoundMode);
   (tVoid) (oIn >> ANC);
   (tVoid) (oIn >> ASC);
   (tVoid) (oIn >> SoundAmbiance);
   (tVoid) (oIn >> ESE);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAmpAvailFunctionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Bass);
   (tVoid) (oOut << Middle);
   (tVoid) (oOut << Treble);
   (tVoid) (oOut << Balance);
   (tVoid) (oOut << Fader);
   (tVoid) (oOut << AudioPilot);
   (tVoid) (oOut << Gala);
   (tVoid) (oOut << SurroundMode);
   (tVoid) (oOut << SubWoofer);
   (tVoid) (oOut << Staging);
   (tVoid) (oOut << RoomEffect);
   (tVoid) (oOut << Loudness);
   (tVoid) (oOut << AGC);
   (tVoid) (oOut << AmpDownMix);
   (tVoid) (oOut << SurroundVol);
   (tVoid) (oOut << RearSoundMode);
   (tVoid) (oOut << DriverSoundMode);
   (tVoid) (oOut << ANC);
   (tVoid) (oOut << ASC);
   (tVoid) (oOut << SoundAmbiance);
   (tVoid) (oOut << ESE);
   return oOut;
}

tBool midw_mascffi_tclMsgAmpAvailFunctionStatus::operator==(const midw_mascffi_tclMsgAmpAvailFunctionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Bass == roRef.Bass);
   bResult = bResult && (Middle == roRef.Middle);
   bResult = bResult && (Treble == roRef.Treble);
   bResult = bResult && (Balance == roRef.Balance);
   bResult = bResult && (Fader == roRef.Fader);
   bResult = bResult && (AudioPilot == roRef.AudioPilot);
   bResult = bResult && (Gala == roRef.Gala);
   bResult = bResult && (SurroundMode == roRef.SurroundMode);
   bResult = bResult && (SubWoofer == roRef.SubWoofer);
   bResult = bResult && (Staging == roRef.Staging);
   bResult = bResult && (RoomEffect == roRef.RoomEffect);
   bResult = bResult && (Loudness == roRef.Loudness);
   bResult = bResult && (AGC == roRef.AGC);
   bResult = bResult && (AmpDownMix == roRef.AmpDownMix);
   bResult = bResult && (SurroundVol == roRef.SurroundVol);
   bResult = bResult && (RearSoundMode == roRef.RearSoundMode);
   bResult = bResult && (DriverSoundMode == roRef.DriverSoundMode);
   bResult = bResult && (ANC == roRef.ANC);
   bResult = bResult && (ASC == roRef.ASC);
   bResult = bResult && (SoundAmbiance == roRef.SoundAmbiance);
   bResult = bResult && (ESE == roRef.ESE);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgSetAudioPropertyUpReg::midw_mascffi_tclMsgSetAudioPropertyUpReg()
 {}

tS32 midw_mascffi_tclMsgSetAudioPropertyUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYUPREG;
}


midw_mascffi_tclMsgSetAudioPropertyUpReg::~midw_mascffi_tclMsgSetAudioPropertyUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSetAudioPropertyRelUpReg::midw_mascffi_tclMsgSetAudioPropertyRelUpReg()
 {}

tS32 midw_mascffi_tclMsgSetAudioPropertyRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYRELUPREG;
}


midw_mascffi_tclMsgSetAudioPropertyRelUpReg::~midw_mascffi_tclMsgSetAudioPropertyRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSetAudioPropertyGet::midw_mascffi_tclMsgSetAudioPropertyGet()
 {}

tS32 midw_mascffi_tclMsgSetAudioPropertyGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYGET;
}


midw_mascffi_tclMsgSetAudioPropertyGet::~midw_mascffi_tclMsgSetAudioPropertyGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSetAudioPropertySet::midw_mascffi_tclMsgSetAudioPropertySet(const midw_mascffi_tclMsgSetAudioPropertySet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
}
midw_mascffi_tclMsgSetAudioPropertySet& midw_mascffi_tclMsgSetAudioPropertySet::operator=(const midw_mascffi_tclMsgSetAudioPropertySet& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSetAudioPropertySet::midw_mascffi_tclMsgSetAudioPropertySet()
:u8Source()
,u8Property()
,s32PropValue(0)
 {}

tS32 midw_mascffi_tclMsgSetAudioPropertySet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYSET;
}


midw_mascffi_tclMsgSetAudioPropertySet::~midw_mascffi_tclMsgSetAudioPropertySet()
{}

tU32 midw_mascffi_tclMsgSetAudioPropertySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_mascffi_tclMsgSetAudioPropertySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8Property);
   (tVoid) (oIn >> s32PropValue);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSetAudioPropertySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8Property);
   (tVoid) (oOut << s32PropValue);
   return oOut;
}

tBool midw_mascffi_tclMsgSetAudioPropertySet::operator==(const midw_mascffi_tclMsgSetAudioPropertySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8Property == roRef.u8Property);
   bResult = bResult && (s32PropValue == roRef.s32PropValue);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSetAudioPropertyStatus::midw_mascffi_tclMsgSetAudioPropertyStatus(const midw_mascffi_tclMsgSetAudioPropertyStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
}
midw_mascffi_tclMsgSetAudioPropertyStatus& midw_mascffi_tclMsgSetAudioPropertyStatus::operator=(const midw_mascffi_tclMsgSetAudioPropertyStatus& coRef)
{
   if (this == &coRef) return *this;
   u8Source = coRef.u8Source;
   u8Property = coRef.u8Property;
   s32PropValue = coRef.s32PropValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSetAudioPropertyStatus::midw_mascffi_tclMsgSetAudioPropertyStatus()
:u8Source()
,u8Property()
,s32PropValue(0)
 {}

tS32 midw_mascffi_tclMsgSetAudioPropertyStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SETAUDIOPROPERTYSTATUS;
}


midw_mascffi_tclMsgSetAudioPropertyStatus::~midw_mascffi_tclMsgSetAudioPropertyStatus()
{}

tU32 midw_mascffi_tclMsgSetAudioPropertyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& midw_mascffi_tclMsgSetAudioPropertyStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8Source);
   (tVoid) (oIn >> u8Property);
   (tVoid) (oIn >> s32PropValue);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSetAudioPropertyStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8Source);
   (tVoid) (oOut << u8Property);
   (tVoid) (oOut << s32PropValue);
   return oOut;
}

tBool midw_mascffi_tclMsgSetAudioPropertyStatus::operator==(const midw_mascffi_tclMsgSetAudioPropertyStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8Source == roRef.u8Source);
   bResult = bResult && (u8Property == roRef.u8Property);
   bResult = bResult && (s32PropValue == roRef.s32PropValue);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgEntOnVolumeSetupUpReg::midw_mascffi_tclMsgEntOnVolumeSetupUpReg()
 {}

tS32 midw_mascffi_tclMsgEntOnVolumeSetupUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPUPREG;
}


midw_mascffi_tclMsgEntOnVolumeSetupUpReg::~midw_mascffi_tclMsgEntOnVolumeSetupUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg::midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg()
 {}

tS32 midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPRELUPREG;
}


midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg::~midw_mascffi_tclMsgEntOnVolumeSetupRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEntOnVolumeSetupSet::midw_mascffi_tclMsgEntOnVolumeSetupSet(const midw_mascffi_tclMsgEntOnVolumeSetupSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LimitValue = coRef.LimitValue;
   SoundType = coRef.SoundType;
}
midw_mascffi_tclMsgEntOnVolumeSetupSet& midw_mascffi_tclMsgEntOnVolumeSetupSet::operator=(const midw_mascffi_tclMsgEntOnVolumeSetupSet& coRef)
{
   if (this == &coRef) return *this;
   LimitValue = coRef.LimitValue;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgEntOnVolumeSetupSet::midw_mascffi_tclMsgEntOnVolumeSetupSet()
:LimitValue(0)
,SoundType()
 {}

tS32 midw_mascffi_tclMsgEntOnVolumeSetupSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPSET;
}


midw_mascffi_tclMsgEntOnVolumeSetupSet::~midw_mascffi_tclMsgEntOnVolumeSetupSet()
{}

tU32 midw_mascffi_tclMsgEntOnVolumeSetupSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgEntOnVolumeSetupSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LimitValue);
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEntOnVolumeSetupSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LimitValue);
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgEntOnVolumeSetupSet::operator==(const midw_mascffi_tclMsgEntOnVolumeSetupSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LimitValue == roRef.LimitValue);
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgEntOnVolumeSetupStatus::midw_mascffi_tclMsgEntOnVolumeSetupStatus(const midw_mascffi_tclMsgEntOnVolumeSetupStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LimitValue = coRef.LimitValue;
}
midw_mascffi_tclMsgEntOnVolumeSetupStatus& midw_mascffi_tclMsgEntOnVolumeSetupStatus::operator=(const midw_mascffi_tclMsgEntOnVolumeSetupStatus& coRef)
{
   if (this == &coRef) return *this;
   LimitValue = coRef.LimitValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgEntOnVolumeSetupStatus::midw_mascffi_tclMsgEntOnVolumeSetupStatus()
:LimitValue(0)
 {}

tS32 midw_mascffi_tclMsgEntOnVolumeSetupStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ENTONVOLUMESETUPSTATUS;
}


midw_mascffi_tclMsgEntOnVolumeSetupStatus::~midw_mascffi_tclMsgEntOnVolumeSetupStatus()
{}

tU32 midw_mascffi_tclMsgEntOnVolumeSetupStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgEntOnVolumeSetupStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LimitValue);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgEntOnVolumeSetupStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LimitValue);
   return oOut;
}

tBool midw_mascffi_tclMsgEntOnVolumeSetupStatus::operator==(const midw_mascffi_tclMsgEntOnVolumeSetupStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LimitValue == roRef.LimitValue);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg::midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg()
 {}

tS32 midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPUPREG;
}


midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg::~midw_mascffi_tclMsgMinimumOnVolumeSetupUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg::midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg()
 {}

tS32 midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPRELUPREG;
}


midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg::~midw_mascffi_tclMsgMinimumOnVolumeSetupRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMinimumOnVolumeSetupSet::midw_mascffi_tclMsgMinimumOnVolumeSetupSet(const midw_mascffi_tclMsgMinimumOnVolumeSetupSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LimitValue = coRef.LimitValue;
   SoundType = coRef.SoundType;
}
midw_mascffi_tclMsgMinimumOnVolumeSetupSet& midw_mascffi_tclMsgMinimumOnVolumeSetupSet::operator=(const midw_mascffi_tclMsgMinimumOnVolumeSetupSet& coRef)
{
   if (this == &coRef) return *this;
   LimitValue = coRef.LimitValue;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMinimumOnVolumeSetupSet::midw_mascffi_tclMsgMinimumOnVolumeSetupSet()
:LimitValue(0)
,SoundType()
 {}

tS32 midw_mascffi_tclMsgMinimumOnVolumeSetupSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPSET;
}


midw_mascffi_tclMsgMinimumOnVolumeSetupSet::~midw_mascffi_tclMsgMinimumOnVolumeSetupSet()
{}

tU32 midw_mascffi_tclMsgMinimumOnVolumeSetupSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgMinimumOnVolumeSetupSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LimitValue);
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMinimumOnVolumeSetupSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LimitValue);
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgMinimumOnVolumeSetupSet::operator==(const midw_mascffi_tclMsgMinimumOnVolumeSetupSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LimitValue == roRef.LimitValue);
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::midw_mascffi_tclMsgMinimumOnVolumeSetupStatus(const midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   LimitValue = coRef.LimitValue;
}
midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::operator=(const midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& coRef)
{
   if (this == &coRef) return *this;
   LimitValue = coRef.LimitValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::midw_mascffi_tclMsgMinimumOnVolumeSetupStatus()
:LimitValue(0)
 {}

tS32 midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MINIMUMONVOLUMESETUPSTATUS;
}


midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::~midw_mascffi_tclMsgMinimumOnVolumeSetupStatus()
{}

tU32 midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LimitValue);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LimitValue);
   return oOut;
}

tBool midw_mascffi_tclMsgMinimumOnVolumeSetupStatus::operator==(const midw_mascffi_tclMsgMinimumOnVolumeSetupStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LimitValue == roRef.LimitValue);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRoomEffectUpReg::midw_mascffi_tclMsgRoomEffectUpReg()
 {}

tS32 midw_mascffi_tclMsgRoomEffectUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ROOMEFFECTUPREG;
}


midw_mascffi_tclMsgRoomEffectUpReg::~midw_mascffi_tclMsgRoomEffectUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRoomEffectRelUpReg::midw_mascffi_tclMsgRoomEffectRelUpReg()
 {}

tS32 midw_mascffi_tclMsgRoomEffectRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ROOMEFFECTRELUPREG;
}


midw_mascffi_tclMsgRoomEffectRelUpReg::~midw_mascffi_tclMsgRoomEffectRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRoomEffectGet::midw_mascffi_tclMsgRoomEffectGet()
 {}

tS32 midw_mascffi_tclMsgRoomEffectGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ROOMEFFECTGET;
}


midw_mascffi_tclMsgRoomEffectGet::~midw_mascffi_tclMsgRoomEffectGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRoomEffectSet::midw_mascffi_tclMsgRoomEffectSet(const midw_mascffi_tclMsgRoomEffectSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgRoomEffectSet& midw_mascffi_tclMsgRoomEffectSet::operator=(const midw_mascffi_tclMsgRoomEffectSet& coRef)
{
   if (this == &coRef) return *this;
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRoomEffectSet::midw_mascffi_tclMsgRoomEffectSet()
:RoomEffect()
,Resource()
 {}

tS32 midw_mascffi_tclMsgRoomEffectSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ROOMEFFECTSET;
}


midw_mascffi_tclMsgRoomEffectSet::~midw_mascffi_tclMsgRoomEffectSet()
{}

tU32 midw_mascffi_tclMsgRoomEffectSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgRoomEffectSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoomEffect);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRoomEffectSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoomEffect);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgRoomEffectSet::operator==(const midw_mascffi_tclMsgRoomEffectSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoomEffect == roRef.RoomEffect);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRoomEffectStatus::midw_mascffi_tclMsgRoomEffectStatus(const midw_mascffi_tclMsgRoomEffectStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
}
midw_mascffi_tclMsgRoomEffectStatus& midw_mascffi_tclMsgRoomEffectStatus::operator=(const midw_mascffi_tclMsgRoomEffectStatus& coRef)
{
   if (this == &coRef) return *this;
   RoomEffect = coRef.RoomEffect;
   Resource = coRef.Resource;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRoomEffectStatus::midw_mascffi_tclMsgRoomEffectStatus()
:RoomEffect()
,Resource()
 {}

tS32 midw_mascffi_tclMsgRoomEffectStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ROOMEFFECTSTATUS;
}


midw_mascffi_tclMsgRoomEffectStatus::~midw_mascffi_tclMsgRoomEffectStatus()
{}

tU32 midw_mascffi_tclMsgRoomEffectStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgRoomEffectStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RoomEffect);
   (tVoid) (oIn >> Resource);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRoomEffectStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RoomEffect);
   (tVoid) (oOut << Resource);
   return oOut;
}

tBool midw_mascffi_tclMsgRoomEffectStatus::operator==(const midw_mascffi_tclMsgRoomEffectStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RoomEffect == roRef.RoomEffect);
   bResult = bResult && (Resource == roRef.Resource);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgFMEnhancerModeUpReg::midw_mascffi_tclMsgFMEnhancerModeUpReg()
 {}

tS32 midw_mascffi_tclMsgFMEnhancerModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FMENHANCERMODEUPREG;
}


midw_mascffi_tclMsgFMEnhancerModeUpReg::~midw_mascffi_tclMsgFMEnhancerModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgFMEnhancerModeRelUpReg::midw_mascffi_tclMsgFMEnhancerModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgFMEnhancerModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FMENHANCERMODERELUPREG;
}


midw_mascffi_tclMsgFMEnhancerModeRelUpReg::~midw_mascffi_tclMsgFMEnhancerModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgFMEnhancerModeGet::midw_mascffi_tclMsgFMEnhancerModeGet()
 {}

tS32 midw_mascffi_tclMsgFMEnhancerModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FMENHANCERMODEGET;
}


midw_mascffi_tclMsgFMEnhancerModeGet::~midw_mascffi_tclMsgFMEnhancerModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgFMEnhancerModeSet::midw_mascffi_tclMsgFMEnhancerModeSet(const midw_mascffi_tclMsgFMEnhancerModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   FMEnhancer = coRef.FMEnhancer;
}
midw_mascffi_tclMsgFMEnhancerModeSet& midw_mascffi_tclMsgFMEnhancerModeSet::operator=(const midw_mascffi_tclMsgFMEnhancerModeSet& coRef)
{
   if (this == &coRef) return *this;
   FMEnhancer = coRef.FMEnhancer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgFMEnhancerModeSet::midw_mascffi_tclMsgFMEnhancerModeSet()
:FMEnhancer(0)
 {}

tS32 midw_mascffi_tclMsgFMEnhancerModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FMENHANCERMODESET;
}


midw_mascffi_tclMsgFMEnhancerModeSet::~midw_mascffi_tclMsgFMEnhancerModeSet()
{}

tU32 midw_mascffi_tclMsgFMEnhancerModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgFMEnhancerModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FMEnhancer);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgFMEnhancerModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FMEnhancer);
   return oOut;
}

tBool midw_mascffi_tclMsgFMEnhancerModeSet::operator==(const midw_mascffi_tclMsgFMEnhancerModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FMEnhancer == roRef.FMEnhancer);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgFMEnhancerModeStatus::midw_mascffi_tclMsgFMEnhancerModeStatus(const midw_mascffi_tclMsgFMEnhancerModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   FMEnhancer = coRef.FMEnhancer;
}
midw_mascffi_tclMsgFMEnhancerModeStatus& midw_mascffi_tclMsgFMEnhancerModeStatus::operator=(const midw_mascffi_tclMsgFMEnhancerModeStatus& coRef)
{
   if (this == &coRef) return *this;
   FMEnhancer = coRef.FMEnhancer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgFMEnhancerModeStatus::midw_mascffi_tclMsgFMEnhancerModeStatus()
:FMEnhancer(0)
 {}

tS32 midw_mascffi_tclMsgFMEnhancerModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_FMENHANCERMODESTATUS;
}


midw_mascffi_tclMsgFMEnhancerModeStatus::~midw_mascffi_tclMsgFMEnhancerModeStatus()
{}

tU32 midw_mascffi_tclMsgFMEnhancerModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgFMEnhancerModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FMEnhancer);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgFMEnhancerModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FMEnhancer);
   return oOut;
}

tBool midw_mascffi_tclMsgFMEnhancerModeStatus::operator==(const midw_mascffi_tclMsgFMEnhancerModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FMEnhancer == roRef.FMEnhancer);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgDiagDefSetPhaseUpReg::midw_mascffi_tclMsgDiagDefSetPhaseUpReg()
 {}

tS32 midw_mascffi_tclMsgDiagDefSetPhaseUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASEUPREG;
}


midw_mascffi_tclMsgDiagDefSetPhaseUpReg::~midw_mascffi_tclMsgDiagDefSetPhaseUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg::midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg()
 {}

tS32 midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASERELUPREG;
}


midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg::~midw_mascffi_tclMsgDiagDefSetPhaseRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgDiagDefSetPhaseGet::midw_mascffi_tclMsgDiagDefSetPhaseGet()
 {}

tS32 midw_mascffi_tclMsgDiagDefSetPhaseGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASEGET;
}


midw_mascffi_tclMsgDiagDefSetPhaseGet::~midw_mascffi_tclMsgDiagDefSetPhaseGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgDiagDefSetPhaseStatus::midw_mascffi_tclMsgDiagDefSetPhaseStatus(const midw_mascffi_tclMsgDiagDefSetPhaseStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DefSetPhase = coRef.DefSetPhase;
}
midw_mascffi_tclMsgDiagDefSetPhaseStatus& midw_mascffi_tclMsgDiagDefSetPhaseStatus::operator=(const midw_mascffi_tclMsgDiagDefSetPhaseStatus& coRef)
{
   if (this == &coRef) return *this;
   DefSetPhase = coRef.DefSetPhase;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgDiagDefSetPhaseStatus::midw_mascffi_tclMsgDiagDefSetPhaseStatus()
:DefSetPhase()
 {}

tS32 midw_mascffi_tclMsgDiagDefSetPhaseStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_DIAGDEFSETPHASESTATUS;
}


midw_mascffi_tclMsgDiagDefSetPhaseStatus::~midw_mascffi_tclMsgDiagDefSetPhaseStatus()
{}

tU32 midw_mascffi_tclMsgDiagDefSetPhaseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgDiagDefSetPhaseStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetPhase);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgDiagDefSetPhaseStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetPhase);
   return oOut;
}

tBool midw_mascffi_tclMsgDiagDefSetPhaseStatus::operator==(const midw_mascffi_tclMsgDiagDefSetPhaseStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetPhase == roRef.DefSetPhase);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgESESoundTypeUpReg::midw_mascffi_tclMsgESESoundTypeUpReg()
 {}

tS32 midw_mascffi_tclMsgESESoundTypeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPEUPREG;
}


midw_mascffi_tclMsgESESoundTypeUpReg::~midw_mascffi_tclMsgESESoundTypeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgESESoundTypeRelUpReg::midw_mascffi_tclMsgESESoundTypeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgESESoundTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPERELUPREG;
}


midw_mascffi_tclMsgESESoundTypeRelUpReg::~midw_mascffi_tclMsgESESoundTypeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgESESoundTypeGet::midw_mascffi_tclMsgESESoundTypeGet()
 {}

tS32 midw_mascffi_tclMsgESESoundTypeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPEGET;
}


midw_mascffi_tclMsgESESoundTypeGet::~midw_mascffi_tclMsgESESoundTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgESESoundTypeSet::midw_mascffi_tclMsgESESoundTypeSet(const midw_mascffi_tclMsgESESoundTypeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
midw_mascffi_tclMsgESESoundTypeSet& midw_mascffi_tclMsgESESoundTypeSet::operator=(const midw_mascffi_tclMsgESESoundTypeSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgESESoundTypeSet::midw_mascffi_tclMsgESESoundTypeSet()
:SoundType(0)
 {}

tS32 midw_mascffi_tclMsgESESoundTypeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPESET;
}


midw_mascffi_tclMsgESESoundTypeSet::~midw_mascffi_tclMsgESESoundTypeSet()
{}

tU32 midw_mascffi_tclMsgESESoundTypeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgESESoundTypeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgESESoundTypeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgESESoundTypeSet::operator==(const midw_mascffi_tclMsgESESoundTypeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgESESoundTypeStatus::midw_mascffi_tclMsgESESoundTypeStatus(const midw_mascffi_tclMsgESESoundTypeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
midw_mascffi_tclMsgESESoundTypeStatus& midw_mascffi_tclMsgESESoundTypeStatus::operator=(const midw_mascffi_tclMsgESESoundTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgESESoundTypeStatus::midw_mascffi_tclMsgESESoundTypeStatus()
:SoundType(0)
 {}

tS32 midw_mascffi_tclMsgESESoundTypeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESESOUNDTYPESTATUS;
}


midw_mascffi_tclMsgESESoundTypeStatus::~midw_mascffi_tclMsgESESoundTypeStatus()
{}

tU32 midw_mascffi_tclMsgESESoundTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgESESoundTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgESESoundTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgESESoundTypeStatus::operator==(const midw_mascffi_tclMsgESESoundTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgESEVolumeUpReg::midw_mascffi_tclMsgESEVolumeUpReg()
 {}

tS32 midw_mascffi_tclMsgESEVolumeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEVOLUMEUPREG;
}


midw_mascffi_tclMsgESEVolumeUpReg::~midw_mascffi_tclMsgESEVolumeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgESEVolumeRelUpReg::midw_mascffi_tclMsgESEVolumeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgESEVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEVOLUMERELUPREG;
}


midw_mascffi_tclMsgESEVolumeRelUpReg::~midw_mascffi_tclMsgESEVolumeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgESEVolumeGet::midw_mascffi_tclMsgESEVolumeGet()
 {}

tS32 midw_mascffi_tclMsgESEVolumeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEVOLUMEGET;
}


midw_mascffi_tclMsgESEVolumeGet::~midw_mascffi_tclMsgESEVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgESEVolumeSet::midw_mascffi_tclMsgESEVolumeSet(const midw_mascffi_tclMsgESEVolumeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
midw_mascffi_tclMsgESEVolumeSet& midw_mascffi_tclMsgESEVolumeSet::operator=(const midw_mascffi_tclMsgESEVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgESEVolumeSet::midw_mascffi_tclMsgESEVolumeSet()
:Volume(0)
 {}

tS32 midw_mascffi_tclMsgESEVolumeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEVOLUMESET;
}


midw_mascffi_tclMsgESEVolumeSet::~midw_mascffi_tclMsgESEVolumeSet()
{}

tU32 midw_mascffi_tclMsgESEVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgESEVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgESEVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool midw_mascffi_tclMsgESEVolumeSet::operator==(const midw_mascffi_tclMsgESEVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgESEVolumeStatus::midw_mascffi_tclMsgESEVolumeStatus(const midw_mascffi_tclMsgESEVolumeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
midw_mascffi_tclMsgESEVolumeStatus& midw_mascffi_tclMsgESEVolumeStatus::operator=(const midw_mascffi_tclMsgESEVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgESEVolumeStatus::midw_mascffi_tclMsgESEVolumeStatus()
:Volume(0)
 {}

tS32 midw_mascffi_tclMsgESEVolumeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEVOLUMESTATUS;
}


midw_mascffi_tclMsgESEVolumeStatus::~midw_mascffi_tclMsgESEVolumeStatus()
{}

tU32 midw_mascffi_tclMsgESEVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgESEVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgESEVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool midw_mascffi_tclMsgESEVolumeStatus::operator==(const midw_mascffi_tclMsgESEVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRSoundOnOffUpReg::midw_mascffi_tclMsgRSoundOnOffUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundOnOffUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFUPREG;
}


midw_mascffi_tclMsgRSoundOnOffUpReg::~midw_mascffi_tclMsgRSoundOnOffUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundOnOffRelUpReg::midw_mascffi_tclMsgRSoundOnOffRelUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundOnOffRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFRELUPREG;
}


midw_mascffi_tclMsgRSoundOnOffRelUpReg::~midw_mascffi_tclMsgRSoundOnOffRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundOnOffGet::midw_mascffi_tclMsgRSoundOnOffGet()
 {}

tS32 midw_mascffi_tclMsgRSoundOnOffGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFGET;
}


midw_mascffi_tclMsgRSoundOnOffGet::~midw_mascffi_tclMsgRSoundOnOffGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundOnOffSet::midw_mascffi_tclMsgRSoundOnOffSet(const midw_mascffi_tclMsgRSoundOnOffSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RSound = coRef.RSound;
}
midw_mascffi_tclMsgRSoundOnOffSet& midw_mascffi_tclMsgRSoundOnOffSet::operator=(const midw_mascffi_tclMsgRSoundOnOffSet& coRef)
{
   if (this == &coRef) return *this;
   RSound = coRef.RSound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundOnOffSet::midw_mascffi_tclMsgRSoundOnOffSet()
:RSound(0)
 {}

tS32 midw_mascffi_tclMsgRSoundOnOffSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFSET;
}


midw_mascffi_tclMsgRSoundOnOffSet::~midw_mascffi_tclMsgRSoundOnOffSet()
{}

tU32 midw_mascffi_tclMsgRSoundOnOffSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundOnOffSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSound);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundOnOffSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSound);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundOnOffSet::operator==(const midw_mascffi_tclMsgRSoundOnOffSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSound == roRef.RSound);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundOnOffStatus::midw_mascffi_tclMsgRSoundOnOffStatus(const midw_mascffi_tclMsgRSoundOnOffStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RSound = coRef.RSound;
}
midw_mascffi_tclMsgRSoundOnOffStatus& midw_mascffi_tclMsgRSoundOnOffStatus::operator=(const midw_mascffi_tclMsgRSoundOnOffStatus& coRef)
{
   if (this == &coRef) return *this;
   RSound = coRef.RSound;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundOnOffStatus::midw_mascffi_tclMsgRSoundOnOffStatus()
:RSound(0)
 {}

tS32 midw_mascffi_tclMsgRSoundOnOffStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDONOFFSTATUS;
}


midw_mascffi_tclMsgRSoundOnOffStatus::~midw_mascffi_tclMsgRSoundOnOffStatus()
{}

tU32 midw_mascffi_tclMsgRSoundOnOffStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundOnOffStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSound);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundOnOffStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSound);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundOnOffStatus::operator==(const midw_mascffi_tclMsgRSoundOnOffStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSound == roRef.RSound);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRSoundSoundTypeUpReg::midw_mascffi_tclMsgRSoundSoundTypeUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundSoundTypeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPEUPREG;
}


midw_mascffi_tclMsgRSoundSoundTypeUpReg::~midw_mascffi_tclMsgRSoundSoundTypeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundSoundTypeRelUpReg::midw_mascffi_tclMsgRSoundSoundTypeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundSoundTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPERELUPREG;
}


midw_mascffi_tclMsgRSoundSoundTypeRelUpReg::~midw_mascffi_tclMsgRSoundSoundTypeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundSoundTypeGet::midw_mascffi_tclMsgRSoundSoundTypeGet()
 {}

tS32 midw_mascffi_tclMsgRSoundSoundTypeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPEGET;
}


midw_mascffi_tclMsgRSoundSoundTypeGet::~midw_mascffi_tclMsgRSoundSoundTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundSoundTypeSet::midw_mascffi_tclMsgRSoundSoundTypeSet(const midw_mascffi_tclMsgRSoundSoundTypeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RSoundType = coRef.RSoundType;
}
midw_mascffi_tclMsgRSoundSoundTypeSet& midw_mascffi_tclMsgRSoundSoundTypeSet::operator=(const midw_mascffi_tclMsgRSoundSoundTypeSet& coRef)
{
   if (this == &coRef) return *this;
   RSoundType = coRef.RSoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundSoundTypeSet::midw_mascffi_tclMsgRSoundSoundTypeSet()
:RSoundType(0)
 {}

tS32 midw_mascffi_tclMsgRSoundSoundTypeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPESET;
}


midw_mascffi_tclMsgRSoundSoundTypeSet::~midw_mascffi_tclMsgRSoundSoundTypeSet()
{}

tU32 midw_mascffi_tclMsgRSoundSoundTypeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundSoundTypeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundSoundTypeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundSoundTypeSet::operator==(const midw_mascffi_tclMsgRSoundSoundTypeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundType == roRef.RSoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundSoundTypeStatus::midw_mascffi_tclMsgRSoundSoundTypeStatus(const midw_mascffi_tclMsgRSoundSoundTypeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RSoundType = coRef.RSoundType;
}
midw_mascffi_tclMsgRSoundSoundTypeStatus& midw_mascffi_tclMsgRSoundSoundTypeStatus::operator=(const midw_mascffi_tclMsgRSoundSoundTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   RSoundType = coRef.RSoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundSoundTypeStatus::midw_mascffi_tclMsgRSoundSoundTypeStatus()
:RSoundType(0)
 {}

tS32 midw_mascffi_tclMsgRSoundSoundTypeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDSOUNDTYPESTATUS;
}


midw_mascffi_tclMsgRSoundSoundTypeStatus::~midw_mascffi_tclMsgRSoundSoundTypeStatus()
{}

tU32 midw_mascffi_tclMsgRSoundSoundTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundSoundTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundSoundTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundSoundTypeStatus::operator==(const midw_mascffi_tclMsgRSoundSoundTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundType == roRef.RSoundType);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRSoundVolumeUpReg::midw_mascffi_tclMsgRSoundVolumeUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundVolumeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMEUPREG;
}


midw_mascffi_tclMsgRSoundVolumeUpReg::~midw_mascffi_tclMsgRSoundVolumeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundVolumeRelUpReg::midw_mascffi_tclMsgRSoundVolumeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMERELUPREG;
}


midw_mascffi_tclMsgRSoundVolumeRelUpReg::~midw_mascffi_tclMsgRSoundVolumeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundVolumeGet::midw_mascffi_tclMsgRSoundVolumeGet()
 {}

tS32 midw_mascffi_tclMsgRSoundVolumeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMEGET;
}


midw_mascffi_tclMsgRSoundVolumeGet::~midw_mascffi_tclMsgRSoundVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundVolumeSet::midw_mascffi_tclMsgRSoundVolumeSet(const midw_mascffi_tclMsgRSoundVolumeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
midw_mascffi_tclMsgRSoundVolumeSet& midw_mascffi_tclMsgRSoundVolumeSet::operator=(const midw_mascffi_tclMsgRSoundVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundVolumeSet::midw_mascffi_tclMsgRSoundVolumeSet()
:Volume(0)
 {}

tS32 midw_mascffi_tclMsgRSoundVolumeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMESET;
}


midw_mascffi_tclMsgRSoundVolumeSet::~midw_mascffi_tclMsgRSoundVolumeSet()
{}

tU32 midw_mascffi_tclMsgRSoundVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundVolumeSet::operator==(const midw_mascffi_tclMsgRSoundVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundVolumeStatus::midw_mascffi_tclMsgRSoundVolumeStatus(const midw_mascffi_tclMsgRSoundVolumeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Volume = coRef.Volume;
}
midw_mascffi_tclMsgRSoundVolumeStatus& midw_mascffi_tclMsgRSoundVolumeStatus::operator=(const midw_mascffi_tclMsgRSoundVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   Volume = coRef.Volume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundVolumeStatus::midw_mascffi_tclMsgRSoundVolumeStatus()
:Volume(0)
 {}

tS32 midw_mascffi_tclMsgRSoundVolumeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDVOLUMESTATUS;
}


midw_mascffi_tclMsgRSoundVolumeStatus::~midw_mascffi_tclMsgRSoundVolumeStatus()
{}

tU32 midw_mascffi_tclMsgRSoundVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Volume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Volume);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundVolumeStatus::operator==(const midw_mascffi_tclMsgRSoundVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Volume == roRef.Volume);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgESEDriveModeUpReg::midw_mascffi_tclMsgESEDriveModeUpReg()
 {}

tS32 midw_mascffi_tclMsgESEDriveModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODEUPREG;
}


midw_mascffi_tclMsgESEDriveModeUpReg::~midw_mascffi_tclMsgESEDriveModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgESEDriveModeRelUpReg::midw_mascffi_tclMsgESEDriveModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgESEDriveModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODERELUPREG;
}


midw_mascffi_tclMsgESEDriveModeRelUpReg::~midw_mascffi_tclMsgESEDriveModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgESEDriveModeGet::midw_mascffi_tclMsgESEDriveModeGet()
 {}

tS32 midw_mascffi_tclMsgESEDriveModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODEGET;
}


midw_mascffi_tclMsgESEDriveModeGet::~midw_mascffi_tclMsgESEDriveModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgESEDriveModeSet::midw_mascffi_tclMsgESEDriveModeSet(const midw_mascffi_tclMsgESEDriveModeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DriveMode = coRef.DriveMode;
}
midw_mascffi_tclMsgESEDriveModeSet& midw_mascffi_tclMsgESEDriveModeSet::operator=(const midw_mascffi_tclMsgESEDriveModeSet& coRef)
{
   if (this == &coRef) return *this;
   DriveMode = coRef.DriveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgESEDriveModeSet::midw_mascffi_tclMsgESEDriveModeSet()
:DriveMode(0)
 {}

tS32 midw_mascffi_tclMsgESEDriveModeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODESET;
}


midw_mascffi_tclMsgESEDriveModeSet::~midw_mascffi_tclMsgESEDriveModeSet()
{}

tU32 midw_mascffi_tclMsgESEDriveModeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgESEDriveModeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgESEDriveModeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveMode);
   return oOut;
}

tBool midw_mascffi_tclMsgESEDriveModeSet::operator==(const midw_mascffi_tclMsgESEDriveModeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveMode == roRef.DriveMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgESEDriveModeStatus::midw_mascffi_tclMsgESEDriveModeStatus(const midw_mascffi_tclMsgESEDriveModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DriveMode = coRef.DriveMode;
}
midw_mascffi_tclMsgESEDriveModeStatus& midw_mascffi_tclMsgESEDriveModeStatus::operator=(const midw_mascffi_tclMsgESEDriveModeStatus& coRef)
{
   if (this == &coRef) return *this;
   DriveMode = coRef.DriveMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgESEDriveModeStatus::midw_mascffi_tclMsgESEDriveModeStatus()
:DriveMode(0)
 {}

tS32 midw_mascffi_tclMsgESEDriveModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ESEDRIVEMODESTATUS;
}


midw_mascffi_tclMsgESEDriveModeStatus::~midw_mascffi_tclMsgESEDriveModeStatus()
{}

tU32 midw_mascffi_tclMsgESEDriveModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgESEDriveModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DriveMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgESEDriveModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DriveMode);
   return oOut;
}

tBool midw_mascffi_tclMsgESEDriveModeStatus::operator==(const midw_mascffi_tclMsgESEDriveModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DriveMode == roRef.DriveMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAudioModeUpReg::midw_mascffi_tclMsgAudioModeUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioModeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOMODEUPREG;
}


midw_mascffi_tclMsgAudioModeUpReg::~midw_mascffi_tclMsgAudioModeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioModeRelUpReg::midw_mascffi_tclMsgAudioModeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioModeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOMODERELUPREG;
}


midw_mascffi_tclMsgAudioModeRelUpReg::~midw_mascffi_tclMsgAudioModeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioModeGet::midw_mascffi_tclMsgAudioModeGet()
 {}

tS32 midw_mascffi_tclMsgAudioModeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOMODEGET;
}


midw_mascffi_tclMsgAudioModeGet::~midw_mascffi_tclMsgAudioModeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioModeStatus::midw_mascffi_tclMsgAudioModeStatus(const midw_mascffi_tclMsgAudioModeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AudioMode = coRef.AudioMode;
}
midw_mascffi_tclMsgAudioModeStatus& midw_mascffi_tclMsgAudioModeStatus::operator=(const midw_mascffi_tclMsgAudioModeStatus& coRef)
{
   if (this == &coRef) return *this;
   AudioMode = coRef.AudioMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioModeStatus::midw_mascffi_tclMsgAudioModeStatus()
:AudioMode()
 {}

tS32 midw_mascffi_tclMsgAudioModeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOMODESTATUS;
}


midw_mascffi_tclMsgAudioModeStatus::~midw_mascffi_tclMsgAudioModeStatus()
{}

tU32 midw_mascffi_tclMsgAudioModeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioModeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AudioMode);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioModeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AudioMode);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioModeStatus::operator==(const midw_mascffi_tclMsgAudioModeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AudioMode == roRef.AudioMode);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgADAS_UPASoundTypeUpReg::midw_mascffi_tclMsgADAS_UPASoundTypeUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_UPASoundTypeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEUPREG;
}


midw_mascffi_tclMsgADAS_UPASoundTypeUpReg::~midw_mascffi_tclMsgADAS_UPASoundTypeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg::midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPERELUPREG;
}


midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg::~midw_mascffi_tclMsgADAS_UPASoundTypeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_UPASoundTypeGet::midw_mascffi_tclMsgADAS_UPASoundTypeGet()
 {}

tS32 midw_mascffi_tclMsgADAS_UPASoundTypeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPEGET;
}


midw_mascffi_tclMsgADAS_UPASoundTypeGet::~midw_mascffi_tclMsgADAS_UPASoundTypeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_UPASoundTypeSet::midw_mascffi_tclMsgADAS_UPASoundTypeSet(const midw_mascffi_tclMsgADAS_UPASoundTypeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
midw_mascffi_tclMsgADAS_UPASoundTypeSet& midw_mascffi_tclMsgADAS_UPASoundTypeSet::operator=(const midw_mascffi_tclMsgADAS_UPASoundTypeSet& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_UPASoundTypeSet::midw_mascffi_tclMsgADAS_UPASoundTypeSet()
:SoundType()
 {}

tS32 midw_mascffi_tclMsgADAS_UPASoundTypeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESET;
}


midw_mascffi_tclMsgADAS_UPASoundTypeSet::~midw_mascffi_tclMsgADAS_UPASoundTypeSet()
{}

tU32 midw_mascffi_tclMsgADAS_UPASoundTypeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_UPASoundTypeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_UPASoundTypeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_UPASoundTypeSet::operator==(const midw_mascffi_tclMsgADAS_UPASoundTypeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_UPASoundTypeStatus::midw_mascffi_tclMsgADAS_UPASoundTypeStatus(const midw_mascffi_tclMsgADAS_UPASoundTypeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SoundType = coRef.SoundType;
}
midw_mascffi_tclMsgADAS_UPASoundTypeStatus& midw_mascffi_tclMsgADAS_UPASoundTypeStatus::operator=(const midw_mascffi_tclMsgADAS_UPASoundTypeStatus& coRef)
{
   if (this == &coRef) return *this;
   SoundType = coRef.SoundType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_UPASoundTypeStatus::midw_mascffi_tclMsgADAS_UPASoundTypeStatus()
:SoundType()
 {}

tS32 midw_mascffi_tclMsgADAS_UPASoundTypeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPASOUNDTYPESTATUS;
}


midw_mascffi_tclMsgADAS_UPASoundTypeStatus::~midw_mascffi_tclMsgADAS_UPASoundTypeStatus()
{}

tU32 midw_mascffi_tclMsgADAS_UPASoundTypeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_UPASoundTypeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SoundType);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_UPASoundTypeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SoundType);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_UPASoundTypeStatus::operator==(const midw_mascffi_tclMsgADAS_UPASoundTypeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SoundType == roRef.SoundType);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg::midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEUPREG;
}


midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg::~midw_mascffi_tclMsgADAS_ParkAssistVolumeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg::midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMERELUPREG;
}


midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg::~midw_mascffi_tclMsgADAS_ParkAssistVolumeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_ParkAssistVolumeGet::midw_mascffi_tclMsgADAS_ParkAssistVolumeGet()
 {}

tS32 midw_mascffi_tclMsgADAS_ParkAssistVolumeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMEGET;
}


midw_mascffi_tclMsgADAS_ParkAssistVolumeGet::~midw_mascffi_tclMsgADAS_ParkAssistVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::midw_mascffi_tclMsgADAS_ParkAssistVolumeSet(const midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::operator=(const midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::midw_mascffi_tclMsgADAS_ParkAssistVolumeSet()
:VolumeLevel()
 {}

tS32 midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESET;
}


midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::~midw_mascffi_tclMsgADAS_ParkAssistVolumeSet()
{}

tU32 midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_ParkAssistVolumeSet::operator==(const midw_mascffi_tclMsgADAS_ParkAssistVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus(const midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::operator=(const midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus()
:VolumeLevel()
 {}

tS32 midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_PARKASSISTVOLUMESTATUS;
}


midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::~midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus()
{}

tU32 midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus::operator==(const midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgADAS_UPAMuteUpReg::midw_mascffi_tclMsgADAS_UPAMuteUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_UPAMuteUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTEUPREG;
}


midw_mascffi_tclMsgADAS_UPAMuteUpReg::~midw_mascffi_tclMsgADAS_UPAMuteUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_UPAMuteRelUpReg::midw_mascffi_tclMsgADAS_UPAMuteRelUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_UPAMuteRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTERELUPREG;
}


midw_mascffi_tclMsgADAS_UPAMuteRelUpReg::~midw_mascffi_tclMsgADAS_UPAMuteRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_UPAMuteGet::midw_mascffi_tclMsgADAS_UPAMuteGet()
 {}

tS32 midw_mascffi_tclMsgADAS_UPAMuteGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTEGET;
}


midw_mascffi_tclMsgADAS_UPAMuteGet::~midw_mascffi_tclMsgADAS_UPAMuteGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_UPAMuteSet::midw_mascffi_tclMsgADAS_UPAMuteSet(const midw_mascffi_tclMsgADAS_UPAMuteSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   bMute = coRef.bMute;
}
midw_mascffi_tclMsgADAS_UPAMuteSet& midw_mascffi_tclMsgADAS_UPAMuteSet::operator=(const midw_mascffi_tclMsgADAS_UPAMuteSet& coRef)
{
   if (this == &coRef) return *this;
   bMute = coRef.bMute;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_UPAMuteSet::midw_mascffi_tclMsgADAS_UPAMuteSet()
:bMute(0)
 {}

tS32 midw_mascffi_tclMsgADAS_UPAMuteSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTESET;
}


midw_mascffi_tclMsgADAS_UPAMuteSet::~midw_mascffi_tclMsgADAS_UPAMuteSet()
{}

tU32 midw_mascffi_tclMsgADAS_UPAMuteSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_UPAMuteSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMute);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_UPAMuteSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMute);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_UPAMuteSet::operator==(const midw_mascffi_tclMsgADAS_UPAMuteSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMute == roRef.bMute);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_UPAMuteStatus::midw_mascffi_tclMsgADAS_UPAMuteStatus(const midw_mascffi_tclMsgADAS_UPAMuteStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   bMuted = coRef.bMuted;
}
midw_mascffi_tclMsgADAS_UPAMuteStatus& midw_mascffi_tclMsgADAS_UPAMuteStatus::operator=(const midw_mascffi_tclMsgADAS_UPAMuteStatus& coRef)
{
   if (this == &coRef) return *this;
   bMuted = coRef.bMuted;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_UPAMuteStatus::midw_mascffi_tclMsgADAS_UPAMuteStatus()
:bMuted(0)
 {}

tS32 midw_mascffi_tclMsgADAS_UPAMuteStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_UPAMUTESTATUS;
}


midw_mascffi_tclMsgADAS_UPAMuteStatus::~midw_mascffi_tclMsgADAS_UPAMuteStatus()
{}

tU32 midw_mascffi_tclMsgADAS_UPAMuteStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_UPAMuteStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bMuted);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_UPAMuteStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bMuted);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_UPAMuteStatus::operator==(const midw_mascffi_tclMsgADAS_UPAMuteStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bMuted == roRef.bMuted);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAutomaticGainControlUpReg::midw_mascffi_tclMsgAutomaticGainControlUpReg()
 {}

tS32 midw_mascffi_tclMsgAutomaticGainControlUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLUPREG;
}


midw_mascffi_tclMsgAutomaticGainControlUpReg::~midw_mascffi_tclMsgAutomaticGainControlUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAutomaticGainControlRelUpReg::midw_mascffi_tclMsgAutomaticGainControlRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAutomaticGainControlRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLRELUPREG;
}


midw_mascffi_tclMsgAutomaticGainControlRelUpReg::~midw_mascffi_tclMsgAutomaticGainControlRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAutomaticGainControlGet::midw_mascffi_tclMsgAutomaticGainControlGet()
 {}

tS32 midw_mascffi_tclMsgAutomaticGainControlGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLGET;
}


midw_mascffi_tclMsgAutomaticGainControlGet::~midw_mascffi_tclMsgAutomaticGainControlGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAutomaticGainControlSet::midw_mascffi_tclMsgAutomaticGainControlSet(const midw_mascffi_tclMsgAutomaticGainControlSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AutomaticGainControl = coRef.AutomaticGainControl;
}
midw_mascffi_tclMsgAutomaticGainControlSet& midw_mascffi_tclMsgAutomaticGainControlSet::operator=(const midw_mascffi_tclMsgAutomaticGainControlSet& coRef)
{
   if (this == &coRef) return *this;
   AutomaticGainControl = coRef.AutomaticGainControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAutomaticGainControlSet::midw_mascffi_tclMsgAutomaticGainControlSet()
:AutomaticGainControl(0)
 {}

tS32 midw_mascffi_tclMsgAutomaticGainControlSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSET;
}


midw_mascffi_tclMsgAutomaticGainControlSet::~midw_mascffi_tclMsgAutomaticGainControlSet()
{}

tU32 midw_mascffi_tclMsgAutomaticGainControlSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAutomaticGainControlSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AutomaticGainControl);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAutomaticGainControlSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AutomaticGainControl);
   return oOut;
}

tBool midw_mascffi_tclMsgAutomaticGainControlSet::operator==(const midw_mascffi_tclMsgAutomaticGainControlSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AutomaticGainControl == roRef.AutomaticGainControl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAutomaticGainControlStatus::midw_mascffi_tclMsgAutomaticGainControlStatus(const midw_mascffi_tclMsgAutomaticGainControlStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   AutomaticGainControl = coRef.AutomaticGainControl;
}
midw_mascffi_tclMsgAutomaticGainControlStatus& midw_mascffi_tclMsgAutomaticGainControlStatus::operator=(const midw_mascffi_tclMsgAutomaticGainControlStatus& coRef)
{
   if (this == &coRef) return *this;
   AutomaticGainControl = coRef.AutomaticGainControl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAutomaticGainControlStatus::midw_mascffi_tclMsgAutomaticGainControlStatus()
:AutomaticGainControl(0)
 {}

tS32 midw_mascffi_tclMsgAutomaticGainControlStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUTOMATICGAINCONTROLSTATUS;
}


midw_mascffi_tclMsgAutomaticGainControlStatus::~midw_mascffi_tclMsgAutomaticGainControlStatus()
{}

tU32 midw_mascffi_tclMsgAutomaticGainControlStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAutomaticGainControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AutomaticGainControl);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAutomaticGainControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AutomaticGainControl);
   return oOut;
}

tBool midw_mascffi_tclMsgAutomaticGainControlStatus::operator==(const midw_mascffi_tclMsgAutomaticGainControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AutomaticGainControl == roRef.AutomaticGainControl);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg::midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEUPREG;
}


midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg::~midw_mascffi_tclMsgADAS_LDW_UserVolumeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg::midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMERELUPREG;
}


midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg::~midw_mascffi_tclMsgADAS_LDW_UserVolumeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgADAS_LDW_UserVolumeGet::midw_mascffi_tclMsgADAS_LDW_UserVolumeGet()
 {}

tS32 midw_mascffi_tclMsgADAS_LDW_UserVolumeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMEGET;
}


midw_mascffi_tclMsgADAS_LDW_UserVolumeGet::~midw_mascffi_tclMsgADAS_LDW_UserVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::midw_mascffi_tclMsgADAS_LDW_UserVolumeSet(const midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::operator=(const midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::midw_mascffi_tclMsgADAS_LDW_UserVolumeSet()
:VolumeLevel()
 {}

tS32 midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESET;
}


midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::~midw_mascffi_tclMsgADAS_LDW_UserVolumeSet()
{}

tU32 midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_LDW_UserVolumeSet::operator==(const midw_mascffi_tclMsgADAS_LDW_UserVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus(const midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   VolumeLevel = coRef.VolumeLevel;
}
midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::operator=(const midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   VolumeLevel = coRef.VolumeLevel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus()
:VolumeLevel()
 {}

tS32 midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ADAS_LDW_USERVOLUMESTATUS;
}


midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::~midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus()
{}

tU32 midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VolumeLevel);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VolumeLevel);
   return oOut;
}

tBool midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus::operator==(const midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VolumeLevel == roRef.VolumeLevel);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgRSoundActivationUpReg::midw_mascffi_tclMsgRSoundActivationUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundActivationUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONUPREG;
}


midw_mascffi_tclMsgRSoundActivationUpReg::~midw_mascffi_tclMsgRSoundActivationUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundActivationRelUpReg::midw_mascffi_tclMsgRSoundActivationRelUpReg()
 {}

tS32 midw_mascffi_tclMsgRSoundActivationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONRELUPREG;
}


midw_mascffi_tclMsgRSoundActivationRelUpReg::~midw_mascffi_tclMsgRSoundActivationRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgRSoundActivationGet::midw_mascffi_tclMsgRSoundActivationGet()
 {}

tS32 midw_mascffi_tclMsgRSoundActivationGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONGET;
}


midw_mascffi_tclMsgRSoundActivationGet::~midw_mascffi_tclMsgRSoundActivationGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundActivationSet::midw_mascffi_tclMsgRSoundActivationSet(const midw_mascffi_tclMsgRSoundActivationSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RSoundActive = coRef.RSoundActive;
}
midw_mascffi_tclMsgRSoundActivationSet& midw_mascffi_tclMsgRSoundActivationSet::operator=(const midw_mascffi_tclMsgRSoundActivationSet& coRef)
{
   if (this == &coRef) return *this;
   RSoundActive = coRef.RSoundActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundActivationSet::midw_mascffi_tclMsgRSoundActivationSet()
:RSoundActive(0)
 {}

tS32 midw_mascffi_tclMsgRSoundActivationSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONSET;
}


midw_mascffi_tclMsgRSoundActivationSet::~midw_mascffi_tclMsgRSoundActivationSet()
{}

tU32 midw_mascffi_tclMsgRSoundActivationSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundActivationSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundActive);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundActivationSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundActive);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundActivationSet::operator==(const midw_mascffi_tclMsgRSoundActivationSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundActive == roRef.RSoundActive);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgRSoundActivationStatus::midw_mascffi_tclMsgRSoundActivationStatus(const midw_mascffi_tclMsgRSoundActivationStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   RSoundActive = coRef.RSoundActive;
}
midw_mascffi_tclMsgRSoundActivationStatus& midw_mascffi_tclMsgRSoundActivationStatus::operator=(const midw_mascffi_tclMsgRSoundActivationStatus& coRef)
{
   if (this == &coRef) return *this;
   RSoundActive = coRef.RSoundActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgRSoundActivationStatus::midw_mascffi_tclMsgRSoundActivationStatus()
:RSoundActive(0)
 {}

tS32 midw_mascffi_tclMsgRSoundActivationStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_RSOUNDACTIVATIONSTATUS;
}


midw_mascffi_tclMsgRSoundActivationStatus::~midw_mascffi_tclMsgRSoundActivationStatus()
{}

tU32 midw_mascffi_tclMsgRSoundActivationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgRSoundActivationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RSoundActive);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgRSoundActivationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RSoundActive);
   return oOut;
}

tBool midw_mascffi_tclMsgRSoundActivationStatus::operator==(const midw_mascffi_tclMsgRSoundActivationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RSoundActive == roRef.RSoundActive);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgANCASCActiveTestUpReg::midw_mascffi_tclMsgANCASCActiveTestUpReg()
 {}

tS32 midw_mascffi_tclMsgANCASCActiveTestUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTUPREG;
}


midw_mascffi_tclMsgANCASCActiveTestUpReg::~midw_mascffi_tclMsgANCASCActiveTestUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCASCActiveTestRelUpReg::midw_mascffi_tclMsgANCASCActiveTestRelUpReg()
 {}

tS32 midw_mascffi_tclMsgANCASCActiveTestRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTRELUPREG;
}


midw_mascffi_tclMsgANCASCActiveTestRelUpReg::~midw_mascffi_tclMsgANCASCActiveTestRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCASCActiveTestGet::midw_mascffi_tclMsgANCASCActiveTestGet()
 {}

tS32 midw_mascffi_tclMsgANCASCActiveTestGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTGET;
}


midw_mascffi_tclMsgANCASCActiveTestGet::~midw_mascffi_tclMsgANCASCActiveTestGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgANCASCActiveTestSet::midw_mascffi_tclMsgANCASCActiveTestSet(const midw_mascffi_tclMsgANCASCActiveTestSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Request = coRef.Request;
}
midw_mascffi_tclMsgANCASCActiveTestSet& midw_mascffi_tclMsgANCASCActiveTestSet::operator=(const midw_mascffi_tclMsgANCASCActiveTestSet& coRef)
{
   if (this == &coRef) return *this;
   Request = coRef.Request;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgANCASCActiveTestSet::midw_mascffi_tclMsgANCASCActiveTestSet()
:Request(0)
 {}

tS32 midw_mascffi_tclMsgANCASCActiveTestSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTSET;
}


midw_mascffi_tclMsgANCASCActiveTestSet::~midw_mascffi_tclMsgANCASCActiveTestSet()
{}

tU32 midw_mascffi_tclMsgANCASCActiveTestSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgANCASCActiveTestSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Request);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgANCASCActiveTestSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Request);
   return oOut;
}

tBool midw_mascffi_tclMsgANCASCActiveTestSet::operator==(const midw_mascffi_tclMsgANCASCActiveTestSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Request == roRef.Request);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgANCASCActiveTestStatus::midw_mascffi_tclMsgANCASCActiveTestStatus(const midw_mascffi_tclMsgANCASCActiveTestStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   TestStatus = coRef.TestStatus;
}
midw_mascffi_tclMsgANCASCActiveTestStatus& midw_mascffi_tclMsgANCASCActiveTestStatus::operator=(const midw_mascffi_tclMsgANCASCActiveTestStatus& coRef)
{
   if (this == &coRef) return *this;
   TestStatus = coRef.TestStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgANCASCActiveTestStatus::midw_mascffi_tclMsgANCASCActiveTestStatus()
:TestStatus(0)
 {}

tS32 midw_mascffi_tclMsgANCASCActiveTestStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCACTIVETESTSTATUS;
}


midw_mascffi_tclMsgANCASCActiveTestStatus::~midw_mascffi_tclMsgANCASCActiveTestStatus()
{}

tU32 midw_mascffi_tclMsgANCASCActiveTestStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgANCASCActiveTestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestStatus);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgANCASCActiveTestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestStatus);
   return oOut;
}

tBool midw_mascffi_tclMsgANCASCActiveTestStatus::operator==(const midw_mascffi_tclMsgANCASCActiveTestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestStatus == roRef.TestStatus);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg::midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg()
 {}

tS32 midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSUPREG;
}


midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg::~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg::midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg()
 {}

tS32 midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSRELUPREG;
}


midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg::~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet::midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet()
 {}

tS32 midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSGET;
}


midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet::~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusGet()
{}

//=============================================================================

midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet::midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet()
 {}

tS32 midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSET;
}


midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet::~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusSet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   DiagResultSummary = coRef.DiagResultSummary;
   MicrophoneResult = coRef.MicrophoneResult;
   EnginePulse = coRef.EnginePulse;
   DoorOpenClose = coRef.DoorOpenClose;
   ConfigInformation = coRef.ConfigInformation;
}
midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::operator=(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   DiagResultSummary = coRef.DiagResultSummary;
   MicrophoneResult = coRef.MicrophoneResult;
   EnginePulse = coRef.EnginePulse;
   DoorOpenClose = coRef.DoorOpenClose;
   ConfigInformation = coRef.ConfigInformation;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::vDestroy()
{
   MicrophoneResult.vDestroy(); 
   ConfigInformation.vDestroy();
}

midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus()
:DiagResultSummary(0)
,MicrophoneResult()
,EnginePulse(0)
,DoorOpenClose(0)
,ConfigInformation()
 {}

tS32 midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_ANCASCSELFDIAGNOSTICSTATUSSTATUS;
}


midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::~midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 11+ConfigInformation.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DiagResultSummary);
   (tVoid) (oIn >> MicrophoneResult);
   (tVoid) (oIn >> EnginePulse);
   (tVoid) (oIn >> DoorOpenClose);
   (tVoid) (oIn >> ConfigInformation);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DiagResultSummary);
   (tVoid) (oOut << MicrophoneResult);
   (tVoid) (oOut << EnginePulse);
   (tVoid) (oOut << DoorOpenClose);
   (tVoid) (oOut << ConfigInformation);
   return oOut;
}

tBool midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus::operator==(const midw_mascffi_tclMsgANCASCSelfDiagnosticStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DiagResultSummary == roRef.DiagResultSummary);
   bResult = bResult && (MicrophoneResult == roRef.MicrophoneResult);
   bResult = bResult && (EnginePulse == roRef.EnginePulse);
   bResult = bResult && (DoorOpenClose == roRef.DoorOpenClose);
   bResult = bResult && (ConfigInformation == roRef.ConfigInformation);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgUserProfileChangeUpReg::midw_mascffi_tclMsgUserProfileChangeUpReg()
 {}

tS32 midw_mascffi_tclMsgUserProfileChangeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGEUPREG;
}


midw_mascffi_tclMsgUserProfileChangeUpReg::~midw_mascffi_tclMsgUserProfileChangeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgUserProfileChangeRelUpReg::midw_mascffi_tclMsgUserProfileChangeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgUserProfileChangeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGERELUPREG;
}


midw_mascffi_tclMsgUserProfileChangeRelUpReg::~midw_mascffi_tclMsgUserProfileChangeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgUserProfileChangeGet::midw_mascffi_tclMsgUserProfileChangeGet()
 {}

tS32 midw_mascffi_tclMsgUserProfileChangeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGEGET;
}


midw_mascffi_tclMsgUserProfileChangeGet::~midw_mascffi_tclMsgUserProfileChangeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgUserProfileChangeSet::midw_mascffi_tclMsgUserProfileChangeSet(const midw_mascffi_tclMsgUserProfileChangeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   UserProfileChange = coRef.UserProfileChange;
}
midw_mascffi_tclMsgUserProfileChangeSet& midw_mascffi_tclMsgUserProfileChangeSet::operator=(const midw_mascffi_tclMsgUserProfileChangeSet& coRef)
{
   if (this == &coRef) return *this;
   UserProfileChange = coRef.UserProfileChange;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgUserProfileChangeSet::midw_mascffi_tclMsgUserProfileChangeSet()
:UserProfileChange(0)
 {}

tS32 midw_mascffi_tclMsgUserProfileChangeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGESET;
}


midw_mascffi_tclMsgUserProfileChangeSet::~midw_mascffi_tclMsgUserProfileChangeSet()
{}

tU32 midw_mascffi_tclMsgUserProfileChangeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgUserProfileChangeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserProfileChange);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgUserProfileChangeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserProfileChange);
   return oOut;
}

tBool midw_mascffi_tclMsgUserProfileChangeSet::operator==(const midw_mascffi_tclMsgUserProfileChangeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserProfileChange == roRef.UserProfileChange);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgUserProfileChangeStatus::midw_mascffi_tclMsgUserProfileChangeStatus(const midw_mascffi_tclMsgUserProfileChangeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   UserProfileChange = coRef.UserProfileChange;
}
midw_mascffi_tclMsgUserProfileChangeStatus& midw_mascffi_tclMsgUserProfileChangeStatus::operator=(const midw_mascffi_tclMsgUserProfileChangeStatus& coRef)
{
   if (this == &coRef) return *this;
   UserProfileChange = coRef.UserProfileChange;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgUserProfileChangeStatus::midw_mascffi_tclMsgUserProfileChangeStatus()
:UserProfileChange(0)
 {}

tS32 midw_mascffi_tclMsgUserProfileChangeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_USERPROFILECHANGESTATUS;
}


midw_mascffi_tclMsgUserProfileChangeStatus::~midw_mascffi_tclMsgUserProfileChangeStatus()
{}

tU32 midw_mascffi_tclMsgUserProfileChangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgUserProfileChangeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> UserProfileChange);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgUserProfileChangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << UserProfileChange);
   return oOut;
}

tBool midw_mascffi_tclMsgUserProfileChangeStatus::operator==(const midw_mascffi_tclMsgUserProfileChangeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (UserProfileChange == roRef.UserProfileChange);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgSRSoundNotificationStateUpReg::midw_mascffi_tclMsgSRSoundNotificationStateUpReg()
 {}

tS32 midw_mascffi_tclMsgSRSoundNotificationStateUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEUPREG;
}


midw_mascffi_tclMsgSRSoundNotificationStateUpReg::~midw_mascffi_tclMsgSRSoundNotificationStateUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg::midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg()
 {}

tS32 midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATERELUPREG;
}


midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg::~midw_mascffi_tclMsgSRSoundNotificationStateRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgSRSoundNotificationStateGet::midw_mascffi_tclMsgSRSoundNotificationStateGet()
 {}

tS32 midw_mascffi_tclMsgSRSoundNotificationStateGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATEGET;
}


midw_mascffi_tclMsgSRSoundNotificationStateGet::~midw_mascffi_tclMsgSRSoundNotificationStateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSRSoundNotificationStateSet::midw_mascffi_tclMsgSRSoundNotificationStateSet(const midw_mascffi_tclMsgSRSoundNotificationStateSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
}
midw_mascffi_tclMsgSRSoundNotificationStateSet& midw_mascffi_tclMsgSRSoundNotificationStateSet::operator=(const midw_mascffi_tclMsgSRSoundNotificationStateSet& coRef)
{
   if (this == &coRef) return *this;
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSRSoundNotificationStateSet::midw_mascffi_tclMsgSRSoundNotificationStateSet()
:SR_SoundNotification_State(0)
 {}

tS32 midw_mascffi_tclMsgSRSoundNotificationStateSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESET;
}


midw_mascffi_tclMsgSRSoundNotificationStateSet::~midw_mascffi_tclMsgSRSoundNotificationStateSet()
{}

tU32 midw_mascffi_tclMsgSRSoundNotificationStateSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSRSoundNotificationStateSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SR_SoundNotification_State);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSRSoundNotificationStateSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SR_SoundNotification_State);
   return oOut;
}

tBool midw_mascffi_tclMsgSRSoundNotificationStateSet::operator==(const midw_mascffi_tclMsgSRSoundNotificationStateSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SR_SoundNotification_State == roRef.SR_SoundNotification_State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgSRSoundNotificationStateStatus::midw_mascffi_tclMsgSRSoundNotificationStateStatus(const midw_mascffi_tclMsgSRSoundNotificationStateStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
}
midw_mascffi_tclMsgSRSoundNotificationStateStatus& midw_mascffi_tclMsgSRSoundNotificationStateStatus::operator=(const midw_mascffi_tclMsgSRSoundNotificationStateStatus& coRef)
{
   if (this == &coRef) return *this;
   SR_SoundNotification_State = coRef.SR_SoundNotification_State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgSRSoundNotificationStateStatus::midw_mascffi_tclMsgSRSoundNotificationStateStatus()
:SR_SoundNotification_State(0)
 {}

tS32 midw_mascffi_tclMsgSRSoundNotificationStateStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_SRSOUNDNOTIFICATIONSTATESTATUS;
}


midw_mascffi_tclMsgSRSoundNotificationStateStatus::~midw_mascffi_tclMsgSRSoundNotificationStateStatus()
{}

tU32 midw_mascffi_tclMsgSRSoundNotificationStateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgSRSoundNotificationStateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SR_SoundNotification_State);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgSRSoundNotificationStateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SR_SoundNotification_State);
   return oOut;
}

tBool midw_mascffi_tclMsgSRSoundNotificationStateStatus::operator==(const midw_mascffi_tclMsgSRSoundNotificationStateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SR_SoundNotification_State == roRef.SR_SoundNotification_State);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgAudioPilotIntensityUpReg::midw_mascffi_tclMsgAudioPilotIntensityUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioPilotIntensityUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYUPREG;
}


midw_mascffi_tclMsgAudioPilotIntensityUpReg::~midw_mascffi_tclMsgAudioPilotIntensityUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioPilotIntensityRelUpReg::midw_mascffi_tclMsgAudioPilotIntensityRelUpReg()
 {}

tS32 midw_mascffi_tclMsgAudioPilotIntensityRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYRELUPREG;
}


midw_mascffi_tclMsgAudioPilotIntensityRelUpReg::~midw_mascffi_tclMsgAudioPilotIntensityRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgAudioPilotIntensityGet::midw_mascffi_tclMsgAudioPilotIntensityGet()
 {}

tS32 midw_mascffi_tclMsgAudioPilotIntensityGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYGET;
}


midw_mascffi_tclMsgAudioPilotIntensityGet::~midw_mascffi_tclMsgAudioPilotIntensityGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioPilotIntensitySet::midw_mascffi_tclMsgAudioPilotIntensitySet(const midw_mascffi_tclMsgAudioPilotIntensitySet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
}
midw_mascffi_tclMsgAudioPilotIntensitySet& midw_mascffi_tclMsgAudioPilotIntensitySet::operator=(const midw_mascffi_tclMsgAudioPilotIntensitySet& coRef)
{
   if (this == &coRef) return *this;
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioPilotIntensitySet::midw_mascffi_tclMsgAudioPilotIntensitySet()
:Audio_Pilot_Intensity()
 {}

tS32 midw_mascffi_tclMsgAudioPilotIntensitySet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSET;
}


midw_mascffi_tclMsgAudioPilotIntensitySet::~midw_mascffi_tclMsgAudioPilotIntensitySet()
{}

tU32 midw_mascffi_tclMsgAudioPilotIntensitySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioPilotIntensitySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Audio_Pilot_Intensity);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioPilotIntensitySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Audio_Pilot_Intensity);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioPilotIntensitySet::operator==(const midw_mascffi_tclMsgAudioPilotIntensitySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Audio_Pilot_Intensity == roRef.Audio_Pilot_Intensity);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgAudioPilotIntensityStatus::midw_mascffi_tclMsgAudioPilotIntensityStatus(const midw_mascffi_tclMsgAudioPilotIntensityStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
}
midw_mascffi_tclMsgAudioPilotIntensityStatus& midw_mascffi_tclMsgAudioPilotIntensityStatus::operator=(const midw_mascffi_tclMsgAudioPilotIntensityStatus& coRef)
{
   if (this == &coRef) return *this;
   Audio_Pilot_Intensity = coRef.Audio_Pilot_Intensity;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgAudioPilotIntensityStatus::midw_mascffi_tclMsgAudioPilotIntensityStatus()
:Audio_Pilot_Intensity()
 {}

tS32 midw_mascffi_tclMsgAudioPilotIntensityStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_AUDIOPILOTINTENSITYSTATUS;
}


midw_mascffi_tclMsgAudioPilotIntensityStatus::~midw_mascffi_tclMsgAudioPilotIntensityStatus()
{}

tU32 midw_mascffi_tclMsgAudioPilotIntensityStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgAudioPilotIntensityStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Audio_Pilot_Intensity);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgAudioPilotIntensityStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Audio_Pilot_Intensity);
   return oOut;
}

tBool midw_mascffi_tclMsgAudioPilotIntensityStatus::operator==(const midw_mascffi_tclMsgAudioPilotIntensityStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Audio_Pilot_Intensity == roRef.Audio_Pilot_Intensity);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgMainAudioAttenuationUpReg::midw_mascffi_tclMsgMainAudioAttenuationUpReg()
 {}

tS32 midw_mascffi_tclMsgMainAudioAttenuationUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MAINAUDIOATTENUATIONUPREG;
}


midw_mascffi_tclMsgMainAudioAttenuationUpReg::~midw_mascffi_tclMsgMainAudioAttenuationUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgMainAudioAttenuationRelUpReg::midw_mascffi_tclMsgMainAudioAttenuationRelUpReg()
 {}

tS32 midw_mascffi_tclMsgMainAudioAttenuationRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MAINAUDIOATTENUATIONRELUPREG;
}


midw_mascffi_tclMsgMainAudioAttenuationRelUpReg::~midw_mascffi_tclMsgMainAudioAttenuationRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgMainAudioAttenuationStatus::midw_mascffi_tclMsgMainAudioAttenuationStatus(const midw_mascffi_tclMsgMainAudioAttenuationStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   Attenuation_Value = coRef.Attenuation_Value;
}
midw_mascffi_tclMsgMainAudioAttenuationStatus& midw_mascffi_tclMsgMainAudioAttenuationStatus::operator=(const midw_mascffi_tclMsgMainAudioAttenuationStatus& coRef)
{
   if (this == &coRef) return *this;
   Attenuation_Value = coRef.Attenuation_Value;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgMainAudioAttenuationStatus::midw_mascffi_tclMsgMainAudioAttenuationStatus()
:Attenuation_Value(0)
 {}

tS32 midw_mascffi_tclMsgMainAudioAttenuationStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_MAINAUDIOATTENUATIONSTATUS;
}


midw_mascffi_tclMsgMainAudioAttenuationStatus::~midw_mascffi_tclMsgMainAudioAttenuationStatus()
{}

tU32 midw_mascffi_tclMsgMainAudioAttenuationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_mascffi_tclMsgMainAudioAttenuationStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Attenuation_Value);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgMainAudioAttenuationStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Attenuation_Value);
   return oOut;
}

tBool midw_mascffi_tclMsgMainAudioAttenuationStatus::operator==(const midw_mascffi_tclMsgMainAudioAttenuationStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Attenuation_Value == roRef.Attenuation_Value);
   return bResult;
}

//=============================================================================

midw_mascffi_tclMsgPrivateModeMixVolumeUpReg::midw_mascffi_tclMsgPrivateModeMixVolumeUpReg()
 {}

tS32 midw_mascffi_tclMsgPrivateModeMixVolumeUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMEUPREG;
}


midw_mascffi_tclMsgPrivateModeMixVolumeUpReg::~midw_mascffi_tclMsgPrivateModeMixVolumeUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg::midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg()
 {}

tS32 midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMERELUPREG;
}


midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg::~midw_mascffi_tclMsgPrivateModeMixVolumeRelUpReg()
{}

//=============================================================================

midw_mascffi_tclMsgPrivateModeMixVolumeGet::midw_mascffi_tclMsgPrivateModeMixVolumeGet()
 {}

tS32 midw_mascffi_tclMsgPrivateModeMixVolumeGet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMEGET;
}


midw_mascffi_tclMsgPrivateModeMixVolumeGet::~midw_mascffi_tclMsgPrivateModeMixVolumeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgPrivateModeMixVolumeSet::midw_mascffi_tclMsgPrivateModeMixVolumeSet(const midw_mascffi_tclMsgPrivateModeMixVolumeSet& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   PMMixVolume = coRef.PMMixVolume;
}
midw_mascffi_tclMsgPrivateModeMixVolumeSet& midw_mascffi_tclMsgPrivateModeMixVolumeSet::operator=(const midw_mascffi_tclMsgPrivateModeMixVolumeSet& coRef)
{
   if (this == &coRef) return *this;
   PMMixVolume = coRef.PMMixVolume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgPrivateModeMixVolumeSet::midw_mascffi_tclMsgPrivateModeMixVolumeSet()
:PMMixVolume(0)
 {}

tS32 midw_mascffi_tclMsgPrivateModeMixVolumeSet::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMESET;
}


midw_mascffi_tclMsgPrivateModeMixVolumeSet::~midw_mascffi_tclMsgPrivateModeMixVolumeSet()
{}

tU32 midw_mascffi_tclMsgPrivateModeMixVolumeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgPrivateModeMixVolumeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PMMixVolume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgPrivateModeMixVolumeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PMMixVolume);
   return oOut;
}

tBool midw_mascffi_tclMsgPrivateModeMixVolumeSet::operator==(const midw_mascffi_tclMsgPrivateModeMixVolumeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PMMixVolume == roRef.PMMixVolume);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_mascffi_tclMsgPrivateModeMixVolumeStatus::midw_mascffi_tclMsgPrivateModeMixVolumeStatus(const midw_mascffi_tclMsgPrivateModeMixVolumeStatus& coRef)
   : midw_mascffi_tclMsgBaseMessage(coRef)
{
   PMMixVolume = coRef.PMMixVolume;
}
midw_mascffi_tclMsgPrivateModeMixVolumeStatus& midw_mascffi_tclMsgPrivateModeMixVolumeStatus::operator=(const midw_mascffi_tclMsgPrivateModeMixVolumeStatus& coRef)
{
   if (this == &coRef) return *this;
   PMMixVolume = coRef.PMMixVolume;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_mascffi_tclMsgPrivateModeMixVolumeStatus::midw_mascffi_tclMsgPrivateModeMixVolumeStatus()
:PMMixVolume(0)
 {}

tS32 midw_mascffi_tclMsgPrivateModeMixVolumeStatus::s32GetTypeId() const
{
   return (tS32) midw_mascffi_tclToken::EN_MSG_PRIVATEMODEMIXVOLUMESTATUS;
}


midw_mascffi_tclMsgPrivateModeMixVolumeStatus::~midw_mascffi_tclMsgPrivateModeMixVolumeStatus()
{}

tU32 midw_mascffi_tclMsgPrivateModeMixVolumeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_mascffi_tclMsgPrivateModeMixVolumeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PMMixVolume);
   return oIn;
}

fi_tclOutContext& midw_mascffi_tclMsgPrivateModeMixVolumeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PMMixVolume);
   return oOut;
}

tBool midw_mascffi_tclMsgPrivateModeMixVolumeStatus::operator==(const midw_mascffi_tclMsgPrivateModeMixVolumeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PMMixVolume == roRef.PMMixVolume);
   return bResult;
}

