#ifndef __MIDW_MASCFFIDEBUGVISITOR_H__
#define __MIDW_MASCFFIDEBUGVISITOR_H__

class MY_DECL midw_mascffi_tclPrintVisitor : public midw_mascffi_tclVisitorBase {

private:
   /* default constructor */ midw_mascffi_tclPrintVisitor();  //lint !e1704   // use constructor with parameter

public:
   midw_mascffi_tclPrintVisitor(midw_fi_tclOutput* poOut):poOutput(poOut) { line[0] = '\0'; }

   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(midw_fi_tclU8& oU8);
   virtual tVoid vVisitS8(midw_fi_tclS8& oS8);
   virtual tVoid vVisitU16(midw_fi_tclU16& oU16);
   virtual tVoid vVisitS16(midw_fi_tclS16& oS16);
   virtual tVoid vVisitU24(midw_fi_tclU24& oU24);
   virtual tVoid vVisitS24(midw_fi_tclS24& oS24);
   virtual tVoid vVisitU32(midw_fi_tclU32& oU32);
   virtual tVoid vVisitS32(midw_fi_tclS32& oS32);
   virtual tVoid vVisitU64(midw_fi_tclU64& oU64);
   virtual tVoid vVisitS64(midw_fi_tclS64& oS64);
   virtual tVoid vVisitBool(midw_fi_tclBool& oBool);
   virtual tVoid vVisitString(midw_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(midw_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(midw_fi_tclList& oList);

   // Besuche die generierten Typen
   virtual tBool bDoExpand_BinContainer(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_Aud_TestToneControl(midw_fi_tcl_e8_Aud_TestToneControl& o_e8_Aud_TestToneControl);
   virtual tVoid vVisit_e8_MicrophoneNumber(midw_fi_tcl_e8_MicrophoneNumber& o_e8_MicrophoneNumber);
   virtual tVoid vVisit_e8_MicrophoneConnectionStatus(midw_fi_tcl_e8_MicrophoneConnectionStatus& o_e8_MicrophoneConnectionStatus);
   virtual tVoid vVisit_e8_MicrophoneDetection(midw_fi_tcl_e8_MicrophoneDetection& o_e8_MicrophoneDetection);
   virtual tBool bDoExpand_MicrophoneConnectionStatus(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MicrophoneConnectionStatusList(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_ResourceNo(midw_fi_tcl_e8_ResourceNo& o_e8_ResourceNo);
   virtual tVoid vVisit_e8_AudioServiceStatus(midw_fi_tcl_e8_AudioServiceStatus& o_e8_AudioServiceStatus);
   virtual tVoid vVisit_e8_GalaLevel(midw_fi_tcl_e8_GalaLevel& o_e8_GalaLevel);
   virtual tVoid vVisit_e8_AudioChannel(midw_fi_tcl_e8_AudioChannel& o_e8_AudioChannel);
   virtual tVoid vVisit_e8_AudioVolumeType(midw_fi_tcl_e8_AudioVolumeType& o_e8_AudioVolumeType);
   virtual tVoid vVisit_e8_AudioSoundType(midw_fi_tcl_e8_AudioSoundType& o_e8_AudioSoundType);
   virtual tVoid vVisit_e8_AudioBeepType(midw_fi_tcl_e8_AudioBeepType& o_e8_AudioBeepType);
   virtual tVoid vVisit_e8_AudioBeepStatus(midw_fi_tcl_e8_AudioBeepStatus& o_e8_AudioBeepStatus);
   virtual tVoid vVisit_e8_VolumeMode(midw_fi_tcl_e8_VolumeMode& o_e8_VolumeMode);
   virtual tVoid vVisit_e8_RouteNo(midw_fi_tcl_e8_RouteNo& o_e8_RouteNo);
   virtual tVoid vVisit_e8_Sound(midw_fi_tcl_e8_Sound& o_e8_Sound);
   virtual tVoid vVisit_e8_MemStatus(midw_fi_tcl_e8_MemStatus& o_e8_MemStatus);
   virtual tVoid vVisit_e8_FaderStatus(midw_fi_tcl_e8_FaderStatus& o_e8_FaderStatus);
   virtual tVoid vVisit_e8_DynCompression(midw_fi_tcl_e8_DynCompression& o_e8_DynCompression);
   virtual tVoid vVisit_e8_Optimization(midw_fi_tcl_e8_Optimization& o_e8_Optimization);
   virtual tVoid vVisit_e8_EquPresets(midw_fi_tcl_e8_EquPresets& o_e8_EquPresets);
   virtual tVoid vVisit_e8_DiagAudMode(midw_fi_tcl_e8_DiagAudMode& o_e8_DiagAudMode);
   virtual tVoid vVisit_e8_GenericDiagAudMode(midw_fi_tcl_e8_GenericDiagAudMode& o_e8_GenericDiagAudMode);
   virtual tVoid vVisit_e8_AuxInLevel(midw_fi_tcl_e8_AuxInLevel& o_e8_AuxInLevel);
   virtual tVoid vVisit_e8_BeepLevel(midw_fi_tcl_e8_BeepLevel& o_e8_BeepLevel);
   virtual tVoid vVisit_e8_Rear_Mute(midw_fi_tcl_e8_Rear_Mute& o_e8_Rear_Mute);
   virtual tVoid vVisit_e8_Geometry_Mode(midw_fi_tcl_e8_Geometry_Mode& o_e8_Geometry_Mode);
   virtual tVoid vVisit_e8_PDCAttenuation(midw_fi_tcl_e8_PDCAttenuation& o_e8_PDCAttenuation);
   virtual tVoid vVisit_e8_VolumeType(midw_fi_tcl_e8_VolumeType& o_e8_VolumeType);
   virtual tBool bDoExpand_Volume(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_b8_ChannelSelect(midw_fi_tcl_b8_ChannelSelect& o_b8_ChannelSelect);
   virtual tVoid vVisit_e8_Aud_Beep_Vol_Type(midw_fi_tcl_e8_Aud_Beep_Vol_Type& o_e8_Aud_Beep_Vol_Type);
   virtual tBool bDoExpand_BeepConfig(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AudioDevice_Availability(midw_fi_tcl_e8_AudioDevice_Availability& o_e8_AudioDevice_Availability);
   virtual tVoid vVisit_e8_State(midw_fi_tcl_e8_State& o_e8_State);
   virtual tVoid vVisit_e8_Aud_VolumeType(midw_fi_tcl_e8_Aud_VolumeType& o_e8_Aud_VolumeType);
   virtual tBool bDoExpand_Aud_VolumeStatus(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Aud_VolumeStatusList(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_BTAudioInLevel(midw_fi_tcl_e8_BTAudioInLevel& o_e8_BTAudioInLevel);
   virtual tVoid vVisit_e8_Aud_EDType(midw_fi_tcl_e8_Aud_EDType& o_e8_Aud_EDType);
   virtual tBool bDoExpand_Aud_EDStatus(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_Aud_EDStatusList(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_SurroundSetting(midw_fi_tcl_e8_SurroundSetting& o_e8_SurroundSetting);
   virtual tVoid vVisit_e8_AmpTemperatureLevel(midw_fi_tcl_e8_AmpTemperatureLevel& o_e8_AmpTemperatureLevel);
   virtual tVoid vVisit_e8_DiagMode(midw_fi_tcl_e8_DiagMode& o_e8_DiagMode);
   virtual tVoid vVisit_e8_DiagState(midw_fi_tcl_e8_DiagState& o_e8_DiagState);
   virtual tVoid vVisit_e8_Aud_DataId(midw_fi_tcl_e8_Aud_DataId& o_e8_Aud_DataId);
   virtual tVoid vVisit_b32_MeasurementResult(midw_fi_tcl_b32_MeasurementResult& o_b32_MeasurementResult);
   virtual tBool bDoExpand_Aud_MeasurementResultItem(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_VolumeLock(midw_fi_tcl_e8_VolumeLock& o_e8_VolumeLock);
   virtual tVoid vVisit_e8_Requester(midw_fi_tcl_e8_Requester& o_e8_Requester);
   virtual tVoid vVisit_e8_RoomEffect(midw_fi_tcl_e8_RoomEffect& o_e8_RoomEffect);
   virtual tVoid vVisit_e8_AudDiagDefSetPhase(midw_fi_tcl_e8_AudDiagDefSetPhase& o_e8_AudDiagDefSetPhase);
   virtual tVoid vVisit_e8_AudioMode(midw_fi_tcl_e8_AudioMode& o_e8_AudioMode);
   virtual tVoid vVisit_e8_ADAS_UPA_SoundType(midw_fi_tcl_e8_ADAS_UPA_SoundType& o_e8_ADAS_UPA_SoundType);
   virtual tVoid vVisit_e8_ADAS_ParkAssist_Volume(midw_fi_tcl_e8_ADAS_ParkAssist_Volume& o_e8_ADAS_ParkAssist_Volume);
   virtual tVoid vVisit_e8_ADAS_LDW_UserVolume(midw_fi_tcl_e8_ADAS_LDW_UserVolume& o_e8_ADAS_LDW_UserVolume);
   virtual tVoid vVisit_e8_ADAS_Setting_Sound(midw_fi_tcl_e8_ADAS_Setting_Sound& o_e8_ADAS_Setting_Sound);
   virtual tVoid vVisit_e8_OnGoingAction(midw_fi_tcl_e8_OnGoingAction& o_e8_OnGoingAction);
   virtual tVoid vVisit_e8_BOSE_UnitType(midw_fi_tcl_e8_BOSE_UnitType& o_e8_BOSE_UnitType);
   virtual tBool bDoExpand_BOSE_UnitConnectionStatus(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_MicConnection(midw_fi_tcl_e8_MicConnection& o_e8_MicConnection);
   virtual tVoid vVisit_e8_MicResult(midw_fi_tcl_e8_MicResult& o_e8_MicResult);
   virtual tBool bDoExpand_MicrophoneStatus(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tBool bDoExpand_MicrophoneResult(midw_mascffi_tclSemanticDomain::tenType enSemantic);
   virtual tVoid vVisit_e8_AudioPilotIntensity(midw_fi_tcl_e8_AudioPilotIntensity& o_e8_AudioPilotIntensity);
   virtual tVoid vVisit_e8_AudSource(midw_fi_tcl_e8_AudSource& o_e8_AudSource);
   virtual tVoid vVisit_e8MuteAction(midw_fi_tcl_e8MuteAction& o_e8MuteAction);
   virtual tVoid vVisit_e8_AudioProperty(midw_fi_tcl_e8_AudioProperty& o_e8_AudioProperty);
   virtual tVoid vVisit_b32MuteReason(midw_fi_tcl_b32MuteReason& o_b32MuteReason);
   virtual tVoid vVisit_e8_MuteState(midw_fi_tcl_e8_MuteState& o_e8_MuteState);
   virtual tVoid vVisit_e8_MuteRequester(midw_fi_tcl_e8_MuteRequester& o_e8_MuteRequester);
   virtual tVoid vVisit_e8MuteSpeed(midw_fi_tcl_e8MuteSpeed& o_e8MuteSpeed);
private:
	// ostream& oOut;
   tChar line[256];
   /*
	OSAL_tIODescriptor fd;
   char *ps8PrintBuf;
   tU32 u32BufSize;
   static const tU32 C_U32_MAXLINELENGTH;
   */
   midw_fi_tclOutput* poOutput;
};


class MY_DECL midw_mascffi_tclRandomInitVisitor : public midw_mascffi_tclVisitorBase {
public:

   midw_mascffi_tclRandomInitVisitor(tU32 u32Seed=1):u32ListSize(3) { srand(u32Seed); }
   tVoid vSetSeed(tU32 u32Seed) const { srand(u32Seed); }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(midw_fi_tclU8& oU8);
   virtual tVoid vVisitS8(midw_fi_tclS8& oS8);
   virtual tVoid vVisitU16(midw_fi_tclU16& oU16);
   virtual tVoid vVisitS16(midw_fi_tclS16& oS16);
   virtual tVoid vVisitU24(midw_fi_tclU24& oU24);
   virtual tVoid vVisitS24(midw_fi_tclS24& oS24);
   virtual tVoid vVisitU32(midw_fi_tclU32& oU32);
   virtual tVoid vVisitS32(midw_fi_tclS32& oS32);
   virtual tVoid vVisitU64(midw_fi_tclU64& oU64);
   virtual tVoid vVisitS64(midw_fi_tclS64& oS64);
   virtual tVoid vVisitBool(midw_fi_tclBool& oBool);
   virtual tVoid vVisitString(midw_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(midw_fi_tclMultiLanguageString& oString);
   virtual tVoid vVisitList(midw_fi_tclList& oList);

	// Besuche die generierten Typen
   virtual tVoid vVisit_e8_Aud_TestToneControl(midw_fi_tcl_e8_Aud_TestToneControl& o_e8_Aud_TestToneControl);
   virtual tVoid vVisit_e8_MicrophoneNumber(midw_fi_tcl_e8_MicrophoneNumber& o_e8_MicrophoneNumber);
   virtual tVoid vVisit_e8_MicrophoneConnectionStatus(midw_fi_tcl_e8_MicrophoneConnectionStatus& o_e8_MicrophoneConnectionStatus);
   virtual tVoid vVisit_e8_MicrophoneDetection(midw_fi_tcl_e8_MicrophoneDetection& o_e8_MicrophoneDetection);
   virtual tVoid vVisit_e8_ResourceNo(midw_fi_tcl_e8_ResourceNo& o_e8_ResourceNo);
   virtual tVoid vVisit_e8_AudioServiceStatus(midw_fi_tcl_e8_AudioServiceStatus& o_e8_AudioServiceStatus);
   virtual tVoid vVisit_e8_GalaLevel(midw_fi_tcl_e8_GalaLevel& o_e8_GalaLevel);
   virtual tVoid vVisit_e8_AudioChannel(midw_fi_tcl_e8_AudioChannel& o_e8_AudioChannel);
   virtual tVoid vVisit_e8_AudioVolumeType(midw_fi_tcl_e8_AudioVolumeType& o_e8_AudioVolumeType);
   virtual tVoid vVisit_e8_AudioSoundType(midw_fi_tcl_e8_AudioSoundType& o_e8_AudioSoundType);
   virtual tVoid vVisit_e8_AudioBeepType(midw_fi_tcl_e8_AudioBeepType& o_e8_AudioBeepType);
   virtual tVoid vVisit_e8_AudioBeepStatus(midw_fi_tcl_e8_AudioBeepStatus& o_e8_AudioBeepStatus);
   virtual tVoid vVisit_e8_VolumeMode(midw_fi_tcl_e8_VolumeMode& o_e8_VolumeMode);
   virtual tVoid vVisit_e8_RouteNo(midw_fi_tcl_e8_RouteNo& o_e8_RouteNo);
   virtual tVoid vVisit_e8_Sound(midw_fi_tcl_e8_Sound& o_e8_Sound);
   virtual tVoid vVisit_e8_MemStatus(midw_fi_tcl_e8_MemStatus& o_e8_MemStatus);
   virtual tVoid vVisit_e8_FaderStatus(midw_fi_tcl_e8_FaderStatus& o_e8_FaderStatus);
   virtual tVoid vVisit_e8_DynCompression(midw_fi_tcl_e8_DynCompression& o_e8_DynCompression);
   virtual tVoid vVisit_e8_Optimization(midw_fi_tcl_e8_Optimization& o_e8_Optimization);
   virtual tVoid vVisit_e8_EquPresets(midw_fi_tcl_e8_EquPresets& o_e8_EquPresets);
   virtual tVoid vVisit_e8_DiagAudMode(midw_fi_tcl_e8_DiagAudMode& o_e8_DiagAudMode);
   virtual tVoid vVisit_e8_GenericDiagAudMode(midw_fi_tcl_e8_GenericDiagAudMode& o_e8_GenericDiagAudMode);
   virtual tVoid vVisit_e8_AuxInLevel(midw_fi_tcl_e8_AuxInLevel& o_e8_AuxInLevel);
   virtual tVoid vVisit_e8_BeepLevel(midw_fi_tcl_e8_BeepLevel& o_e8_BeepLevel);
   virtual tVoid vVisit_e8_Rear_Mute(midw_fi_tcl_e8_Rear_Mute& o_e8_Rear_Mute);
   virtual tVoid vVisit_e8_Geometry_Mode(midw_fi_tcl_e8_Geometry_Mode& o_e8_Geometry_Mode);
   virtual tVoid vVisit_e8_PDCAttenuation(midw_fi_tcl_e8_PDCAttenuation& o_e8_PDCAttenuation);
   virtual tVoid vVisit_e8_VolumeType(midw_fi_tcl_e8_VolumeType& o_e8_VolumeType);
   virtual tVoid vVisit_b8_ChannelSelect(midw_fi_tcl_b8_ChannelSelect& o_b8_ChannelSelect);
   virtual tVoid vVisit_e8_Aud_Beep_Vol_Type(midw_fi_tcl_e8_Aud_Beep_Vol_Type& o_e8_Aud_Beep_Vol_Type);
   virtual tVoid vVisit_e8_AudioDevice_Availability(midw_fi_tcl_e8_AudioDevice_Availability& o_e8_AudioDevice_Availability);
   virtual tVoid vVisit_e8_State(midw_fi_tcl_e8_State& o_e8_State);
   virtual tVoid vVisit_e8_Aud_VolumeType(midw_fi_tcl_e8_Aud_VolumeType& o_e8_Aud_VolumeType);
   virtual tVoid vVisit_e8_BTAudioInLevel(midw_fi_tcl_e8_BTAudioInLevel& o_e8_BTAudioInLevel);
   virtual tVoid vVisit_e8_Aud_EDType(midw_fi_tcl_e8_Aud_EDType& o_e8_Aud_EDType);
   virtual tVoid vVisit_e8_SurroundSetting(midw_fi_tcl_e8_SurroundSetting& o_e8_SurroundSetting);
   virtual tVoid vVisit_e8_AmpTemperatureLevel(midw_fi_tcl_e8_AmpTemperatureLevel& o_e8_AmpTemperatureLevel);
   virtual tVoid vVisit_e8_DiagMode(midw_fi_tcl_e8_DiagMode& o_e8_DiagMode);
   virtual tVoid vVisit_e8_DiagState(midw_fi_tcl_e8_DiagState& o_e8_DiagState);
   virtual tVoid vVisit_e8_Aud_DataId(midw_fi_tcl_e8_Aud_DataId& o_e8_Aud_DataId);
   virtual tVoid vVisit_b32_MeasurementResult(midw_fi_tcl_b32_MeasurementResult& o_b32_MeasurementResult);
   virtual tVoid vVisit_e8_VolumeLock(midw_fi_tcl_e8_VolumeLock& o_e8_VolumeLock);
   virtual tVoid vVisit_e8_Requester(midw_fi_tcl_e8_Requester& o_e8_Requester);
   virtual tVoid vVisit_e8_RoomEffect(midw_fi_tcl_e8_RoomEffect& o_e8_RoomEffect);
   virtual tVoid vVisit_e8_AudDiagDefSetPhase(midw_fi_tcl_e8_AudDiagDefSetPhase& o_e8_AudDiagDefSetPhase);
   virtual tVoid vVisit_e8_AudioMode(midw_fi_tcl_e8_AudioMode& o_e8_AudioMode);
   virtual tVoid vVisit_e8_ADAS_UPA_SoundType(midw_fi_tcl_e8_ADAS_UPA_SoundType& o_e8_ADAS_UPA_SoundType);
   virtual tVoid vVisit_e8_ADAS_ParkAssist_Volume(midw_fi_tcl_e8_ADAS_ParkAssist_Volume& o_e8_ADAS_ParkAssist_Volume);
   virtual tVoid vVisit_e8_ADAS_LDW_UserVolume(midw_fi_tcl_e8_ADAS_LDW_UserVolume& o_e8_ADAS_LDW_UserVolume);
   virtual tVoid vVisit_e8_ADAS_Setting_Sound(midw_fi_tcl_e8_ADAS_Setting_Sound& o_e8_ADAS_Setting_Sound);
   virtual tVoid vVisit_e8_OnGoingAction(midw_fi_tcl_e8_OnGoingAction& o_e8_OnGoingAction);
   virtual tVoid vVisit_e8_BOSE_UnitType(midw_fi_tcl_e8_BOSE_UnitType& o_e8_BOSE_UnitType);
   virtual tVoid vVisit_e8_MicConnection(midw_fi_tcl_e8_MicConnection& o_e8_MicConnection);
   virtual tVoid vVisit_e8_MicResult(midw_fi_tcl_e8_MicResult& o_e8_MicResult);
   virtual tVoid vVisit_e8_AudioPilotIntensity(midw_fi_tcl_e8_AudioPilotIntensity& o_e8_AudioPilotIntensity);
   virtual tVoid vVisit_e8_AudSource(midw_fi_tcl_e8_AudSource& o_e8_AudSource);
   virtual tVoid vVisit_e8MuteAction(midw_fi_tcl_e8MuteAction& o_e8MuteAction);
   virtual tVoid vVisit_e8_AudioProperty(midw_fi_tcl_e8_AudioProperty& o_e8_AudioProperty);
   virtual tVoid vVisit_b32MuteReason(midw_fi_tcl_b32MuteReason& o_b32MuteReason);
   virtual tVoid vVisit_e8_MuteState(midw_fi_tcl_e8_MuteState& o_e8_MuteState);
   virtual tVoid vVisit_e8_MuteRequester(midw_fi_tcl_e8_MuteRequester& o_e8_MuteRequester);
   virtual tVoid vVisit_e8MuteSpeed(midw_fi_tcl_e8MuteSpeed& o_e8MuteSpeed);
	tU32 u32ListSize;
};

#endif
