/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_KBDFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_KBDFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_KBDFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for MIDW_KBD_FI message types

fi_tclMessageBase* midw_kbdfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODSTART:
         return OSAL_NEW midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart;

      case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODABORT:
         return OSAL_NEW midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort;

      case midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODRESULT:
         return OSAL_NEW midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult;

      case midw_kbdfi_tclToken::EN_MSG_KEYINFOUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgKeyInfoUpReg;

      case midw_kbdfi_tclToken::EN_MSG_KEYINFORELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgKeyInfoRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_KEYINFOSET:
         return OSAL_NEW midw_kbdfi_tclMsgKeyInfoSet;

      case midw_kbdfi_tclToken::EN_MSG_KEYINFOSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgKeyInfoStatus;

      case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgKeyInfoEjectUpReg;

      case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgKeyInfoEjectRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgKeyInfoEjectStatus;

      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgEncoderInfoUpReg;

      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFORELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgEncoderInfoRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSET:
         return OSAL_NEW midw_kbdfi_tclMsgEncoderInfoSet;

      case midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgEncoderInfoStatus;

      case midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSET:
         return OSAL_NEW midw_kbdfi_tclMsgSetCalibrationPointsSet;

      case midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgSetCalibrationPointsStatus;

      case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGEUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDrawCalibrationPageUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGERELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGESTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgDrawCalibrationPageStatus;

      case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgCalibrationStatusUpReg;

      case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgCalibrationStatusRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgCalibrationStatusStatus;

      case midw_kbdfi_tclToken::EN_MSG_FASCIAIDUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgFasciaIdUpReg;

      case midw_kbdfi_tclToken::EN_MSG_FASCIAIDRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgFasciaIdRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_FASCIAIDSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgFasciaIdStatus;

      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgTouchInfoUpReg;

      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFORELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgTouchInfoRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOGET:
         return OSAL_NEW midw_kbdfi_tclMsgTouchInfoGet;

      case midw_kbdfi_tclToken::EN_MSG_TOUCHINFOSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgTouchInfoStatus;

      case midw_kbdfi_tclToken::EN_MSG_AUXININFOUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgAuxInInfoUpReg;

      case midw_kbdfi_tclToken::EN_MSG_AUXININFORELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgAuxInInfoRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_AUXININFOGET:
         return OSAL_NEW midw_kbdfi_tclMsgAuxInInfoGet;

      case midw_kbdfi_tclToken::EN_MSG_AUXININFOSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgAuxInInfoStatus;

      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgKeyRepeatTimeUpReg;

      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMERELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESET:
         return OSAL_NEW midw_kbdfi_tclMsgKeyRepeatTimeSet;

      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEGET:
         return OSAL_NEW midw_kbdfi_tclMsgKeyRepeatTimeGet;

      case midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgKeyRepeatTimeStatus;

      case midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYGET:
         return OSAL_NEW midw_kbdfi_tclMsgLastReleasedKeyGet;

      case midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgLastReleasedKeyStatus;

      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERGET:
         return OSAL_NEW midw_kbdfi_tclMsgLastUsedEncoderGet;

      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgLastUsedEncoderStatus;

      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOGET:
         return OSAL_NEW midw_kbdfi_tclMsgLastUsedEncoderInfoGet;

      case midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgLastUsedEncoderInfoStatus;

      case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYGET:
         return OSAL_NEW midw_kbdfi_tclMsgLastPressedKeyGet;

      case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSET:
         return OSAL_NEW midw_kbdfi_tclMsgLastPressedKeySet;

      case midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgLastPressedKeyStatus;

      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSGET:
         return OSAL_NEW midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet;

      case midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedKeysUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedKeysRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSGET:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedKeysGet;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedKeysStatus;

      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagEncoderStatusUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSGET:
         return OSAL_NEW midw_kbdfi_tclMsgDiagEncoderStatusGet;

      case midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgDiagEncoderStatusStatus;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSGET:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedTouchPositionsGet;

      case midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlUpReg;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlStatus;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSET:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlSet;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYRELUPREG:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSTATUS:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlSelectListEntryStatus;

      case midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSET:
         return OSAL_NEW midw_kbdfi_tclMsgAudioControlSelectListEntrySet;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_kbdfifi messages

// common functions

tU16 midw_kbdfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_KBDFI_C_U16_SERVICE_ID;
}

tU16 midw_kbdfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_kbdfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_kbdfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_kbdfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_kbdfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_kbdfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_kbdfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   e8CalibrationType = coRef.e8CalibrationType;
}
midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::operator=(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   e8CalibrationType = coRef.e8CalibrationType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart()
:e8CalibrationType()
 {}

tS32 midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODSTART;
}


midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::~midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart()
{}

tU32 midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CalibrationType);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CalibrationType);
   return oOut;
}

tBool midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart::operator==(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CalibrationType == roRef.e8CalibrationType);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort::midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort()
 {}

tS32 midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODABORT;
}


midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort::~midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodAbort()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   e8MethodResult = coRef.e8MethodResult;
}
midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::operator=(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   e8MethodResult = coRef.e8MethodResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult()
:e8MethodResult()
 {}

tS32 midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_STARTTOUCHSCREENCALIBRATIONMETHODRESULT;
}


midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::~midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult()
{}

tU32 midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8MethodResult);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8MethodResult);
   return oOut;
}

tBool midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult::operator==(const midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8MethodResult == roRef.e8MethodResult);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgKeyInfoUpReg::midw_kbdfi_tclMsgKeyInfoUpReg()
 {}

tS32 midw_kbdfi_tclMsgKeyInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYINFOUPREG;
}


midw_kbdfi_tclMsgKeyInfoUpReg::~midw_kbdfi_tclMsgKeyInfoUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgKeyInfoRelUpReg::midw_kbdfi_tclMsgKeyInfoRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgKeyInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYINFORELUPREG;
}


midw_kbdfi_tclMsgKeyInfoRelUpReg::~midw_kbdfi_tclMsgKeyInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgKeyInfoSet::midw_kbdfi_tclMsgKeyInfoSet(const midw_kbdfi_tclMsgKeyInfoSet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   SimulatedKeyData = coRef.SimulatedKeyData;
}
midw_kbdfi_tclMsgKeyInfoSet& midw_kbdfi_tclMsgKeyInfoSet::operator=(const midw_kbdfi_tclMsgKeyInfoSet& coRef)
{
   if (this == &coRef) return *this;
   SimulatedKeyData = coRef.SimulatedKeyData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgKeyInfoSet::midw_kbdfi_tclMsgKeyInfoSet()
:SimulatedKeyData()
 {}

tS32 midw_kbdfi_tclMsgKeyInfoSet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYINFOSET;
}


midw_kbdfi_tclMsgKeyInfoSet::~midw_kbdfi_tclMsgKeyInfoSet()
{}

tU32 midw_kbdfi_tclMsgKeyInfoSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_kbdfi_tclMsgKeyInfoSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SimulatedKeyData);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgKeyInfoSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SimulatedKeyData);
   return oOut;
}

tBool midw_kbdfi_tclMsgKeyInfoSet::operator==(const midw_kbdfi_tclMsgKeyInfoSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SimulatedKeyData == roRef.SimulatedKeyData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgKeyInfoStatus::midw_kbdfi_tclMsgKeyInfoStatus(const midw_kbdfi_tclMsgKeyInfoStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   KeyInfo = coRef.KeyInfo;
}
midw_kbdfi_tclMsgKeyInfoStatus& midw_kbdfi_tclMsgKeyInfoStatus::operator=(const midw_kbdfi_tclMsgKeyInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyInfo = coRef.KeyInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgKeyInfoStatus::midw_kbdfi_tclMsgKeyInfoStatus()
:KeyInfo()
 {}

tS32 midw_kbdfi_tclMsgKeyInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYINFOSTATUS;
}


midw_kbdfi_tclMsgKeyInfoStatus::~midw_kbdfi_tclMsgKeyInfoStatus()
{}

tU32 midw_kbdfi_tclMsgKeyInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_kbdfi_tclMsgKeyInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyInfo);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgKeyInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyInfo);
   return oOut;
}

tBool midw_kbdfi_tclMsgKeyInfoStatus::operator==(const midw_kbdfi_tclMsgKeyInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyInfo == roRef.KeyInfo);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgKeyInfoEjectUpReg::midw_kbdfi_tclMsgKeyInfoEjectUpReg()
 {}

tS32 midw_kbdfi_tclMsgKeyInfoEjectUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTUPREG;
}


midw_kbdfi_tclMsgKeyInfoEjectUpReg::~midw_kbdfi_tclMsgKeyInfoEjectUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgKeyInfoEjectRelUpReg::midw_kbdfi_tclMsgKeyInfoEjectRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgKeyInfoEjectRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTRELUPREG;
}


midw_kbdfi_tclMsgKeyInfoEjectRelUpReg::~midw_kbdfi_tclMsgKeyInfoEjectRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgKeyInfoEjectStatus::midw_kbdfi_tclMsgKeyInfoEjectStatus(const midw_kbdfi_tclMsgKeyInfoEjectStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   e8KeyAttr = coRef.e8KeyAttr;
}
midw_kbdfi_tclMsgKeyInfoEjectStatus& midw_kbdfi_tclMsgKeyInfoEjectStatus::operator=(const midw_kbdfi_tclMsgKeyInfoEjectStatus& coRef)
{
   if (this == &coRef) return *this;
   e8KeyAttr = coRef.e8KeyAttr;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgKeyInfoEjectStatus::midw_kbdfi_tclMsgKeyInfoEjectStatus()
:e8KeyAttr()
 {}

tS32 midw_kbdfi_tclMsgKeyInfoEjectStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYINFOEJECTSTATUS;
}


midw_kbdfi_tclMsgKeyInfoEjectStatus::~midw_kbdfi_tclMsgKeyInfoEjectStatus()
{}

tU32 midw_kbdfi_tclMsgKeyInfoEjectStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgKeyInfoEjectStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8KeyAttr);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgKeyInfoEjectStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8KeyAttr);
   return oOut;
}

tBool midw_kbdfi_tclMsgKeyInfoEjectStatus::operator==(const midw_kbdfi_tclMsgKeyInfoEjectStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8KeyAttr == roRef.e8KeyAttr);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgEncoderInfoUpReg::midw_kbdfi_tclMsgEncoderInfoUpReg()
 {}

tS32 midw_kbdfi_tclMsgEncoderInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_ENCODERINFOUPREG;
}


midw_kbdfi_tclMsgEncoderInfoUpReg::~midw_kbdfi_tclMsgEncoderInfoUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgEncoderInfoRelUpReg::midw_kbdfi_tclMsgEncoderInfoRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgEncoderInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_ENCODERINFORELUPREG;
}


midw_kbdfi_tclMsgEncoderInfoRelUpReg::~midw_kbdfi_tclMsgEncoderInfoRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgEncoderInfoSet::midw_kbdfi_tclMsgEncoderInfoSet(const midw_kbdfi_tclMsgEncoderInfoSet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   SimulatedKeyData = coRef.SimulatedKeyData;
}
midw_kbdfi_tclMsgEncoderInfoSet& midw_kbdfi_tclMsgEncoderInfoSet::operator=(const midw_kbdfi_tclMsgEncoderInfoSet& coRef)
{
   if (this == &coRef) return *this;
   SimulatedKeyData = coRef.SimulatedKeyData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgEncoderInfoSet::midw_kbdfi_tclMsgEncoderInfoSet()
:SimulatedKeyData()
 {}

tS32 midw_kbdfi_tclMsgEncoderInfoSet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSET;
}


midw_kbdfi_tclMsgEncoderInfoSet::~midw_kbdfi_tclMsgEncoderInfoSet()
{}

tU32 midw_kbdfi_tclMsgEncoderInfoSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_kbdfi_tclMsgEncoderInfoSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SimulatedKeyData);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgEncoderInfoSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SimulatedKeyData);
   return oOut;
}

tBool midw_kbdfi_tclMsgEncoderInfoSet::operator==(const midw_kbdfi_tclMsgEncoderInfoSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SimulatedKeyData == roRef.SimulatedKeyData);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgEncoderInfoStatus::midw_kbdfi_tclMsgEncoderInfoStatus(const midw_kbdfi_tclMsgEncoderInfoStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   KeyEncoder = coRef.KeyEncoder;
}
midw_kbdfi_tclMsgEncoderInfoStatus& midw_kbdfi_tclMsgEncoderInfoStatus::operator=(const midw_kbdfi_tclMsgEncoderInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyEncoder = coRef.KeyEncoder;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgEncoderInfoStatus::midw_kbdfi_tclMsgEncoderInfoStatus()
:KeyEncoder()
 {}

tS32 midw_kbdfi_tclMsgEncoderInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_ENCODERINFOSTATUS;
}


midw_kbdfi_tclMsgEncoderInfoStatus::~midw_kbdfi_tclMsgEncoderInfoStatus()
{}

tU32 midw_kbdfi_tclMsgEncoderInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_kbdfi_tclMsgEncoderInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyEncoder);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgEncoderInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyEncoder);
   return oOut;
}

tBool midw_kbdfi_tclMsgEncoderInfoStatus::operator==(const midw_kbdfi_tclMsgEncoderInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyEncoder == roRef.KeyEncoder);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgSetCalibrationPointsSet::midw_kbdfi_tclMsgSetCalibrationPointsSet(const midw_kbdfi_tclMsgSetCalibrationPointsSet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   oCalibrationPoint = coRef.oCalibrationPoint;
}
midw_kbdfi_tclMsgSetCalibrationPointsSet& midw_kbdfi_tclMsgSetCalibrationPointsSet::operator=(const midw_kbdfi_tclMsgSetCalibrationPointsSet& coRef)
{
   if (this == &coRef) return *this;
   oCalibrationPoint = coRef.oCalibrationPoint;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgSetCalibrationPointsSet::midw_kbdfi_tclMsgSetCalibrationPointsSet()
:oCalibrationPoint()
 {}

tS32 midw_kbdfi_tclMsgSetCalibrationPointsSet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSET;
}


midw_kbdfi_tclMsgSetCalibrationPointsSet::~midw_kbdfi_tclMsgSetCalibrationPointsSet()
{}

tU32 midw_kbdfi_tclMsgSetCalibrationPointsSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& midw_kbdfi_tclMsgSetCalibrationPointsSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> oCalibrationPoint);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgSetCalibrationPointsSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << oCalibrationPoint);
   return oOut;
}

tBool midw_kbdfi_tclMsgSetCalibrationPointsSet::operator==(const midw_kbdfi_tclMsgSetCalibrationPointsSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (oCalibrationPoint == roRef.oCalibrationPoint);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgSetCalibrationPointsStatus::midw_kbdfi_tclMsgSetCalibrationPointsStatus(const midw_kbdfi_tclMsgSetCalibrationPointsStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   bSetSuccess = coRef.bSetSuccess;
}
midw_kbdfi_tclMsgSetCalibrationPointsStatus& midw_kbdfi_tclMsgSetCalibrationPointsStatus::operator=(const midw_kbdfi_tclMsgSetCalibrationPointsStatus& coRef)
{
   if (this == &coRef) return *this;
   bSetSuccess = coRef.bSetSuccess;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgSetCalibrationPointsStatus::midw_kbdfi_tclMsgSetCalibrationPointsStatus()
:bSetSuccess(0)
 {}

tS32 midw_kbdfi_tclMsgSetCalibrationPointsStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_SETCALIBRATIONPOINTSSTATUS;
}


midw_kbdfi_tclMsgSetCalibrationPointsStatus::~midw_kbdfi_tclMsgSetCalibrationPointsStatus()
{}

tU32 midw_kbdfi_tclMsgSetCalibrationPointsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgSetCalibrationPointsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bSetSuccess);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgSetCalibrationPointsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bSetSuccess);
   return oOut;
}

tBool midw_kbdfi_tclMsgSetCalibrationPointsStatus::operator==(const midw_kbdfi_tclMsgSetCalibrationPointsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bSetSuccess == roRef.bSetSuccess);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgDrawCalibrationPageUpReg::midw_kbdfi_tclMsgDrawCalibrationPageUpReg()
 {}

tS32 midw_kbdfi_tclMsgDrawCalibrationPageUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGEUPREG;
}


midw_kbdfi_tclMsgDrawCalibrationPageUpReg::~midw_kbdfi_tclMsgDrawCalibrationPageUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg::midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGERELUPREG;
}


midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg::~midw_kbdfi_tclMsgDrawCalibrationPageRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgDrawCalibrationPageStatus::midw_kbdfi_tclMsgDrawCalibrationPageStatus(const midw_kbdfi_tclMsgDrawCalibrationPageStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   e8Page = coRef.e8Page;
}
midw_kbdfi_tclMsgDrawCalibrationPageStatus& midw_kbdfi_tclMsgDrawCalibrationPageStatus::operator=(const midw_kbdfi_tclMsgDrawCalibrationPageStatus& coRef)
{
   if (this == &coRef) return *this;
   e8Page = coRef.e8Page;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgDrawCalibrationPageStatus::midw_kbdfi_tclMsgDrawCalibrationPageStatus()
:e8Page()
 {}

tS32 midw_kbdfi_tclMsgDrawCalibrationPageStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DRAWCALIBRATIONPAGESTATUS;
}


midw_kbdfi_tclMsgDrawCalibrationPageStatus::~midw_kbdfi_tclMsgDrawCalibrationPageStatus()
{}

tU32 midw_kbdfi_tclMsgDrawCalibrationPageStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgDrawCalibrationPageStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8Page);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgDrawCalibrationPageStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8Page);
   return oOut;
}

tBool midw_kbdfi_tclMsgDrawCalibrationPageStatus::operator==(const midw_kbdfi_tclMsgDrawCalibrationPageStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8Page == roRef.e8Page);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgCalibrationStatusUpReg::midw_kbdfi_tclMsgCalibrationStatusUpReg()
 {}

tS32 midw_kbdfi_tclMsgCalibrationStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSUPREG;
}


midw_kbdfi_tclMsgCalibrationStatusUpReg::~midw_kbdfi_tclMsgCalibrationStatusUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgCalibrationStatusRelUpReg::midw_kbdfi_tclMsgCalibrationStatusRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgCalibrationStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSRELUPREG;
}


midw_kbdfi_tclMsgCalibrationStatusRelUpReg::~midw_kbdfi_tclMsgCalibrationStatusRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgCalibrationStatusStatus::midw_kbdfi_tclMsgCalibrationStatusStatus(const midw_kbdfi_tclMsgCalibrationStatusStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   e8CalibrationStsToHMI = coRef.e8CalibrationStsToHMI;
}
midw_kbdfi_tclMsgCalibrationStatusStatus& midw_kbdfi_tclMsgCalibrationStatusStatus::operator=(const midw_kbdfi_tclMsgCalibrationStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   e8CalibrationStsToHMI = coRef.e8CalibrationStsToHMI;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgCalibrationStatusStatus::midw_kbdfi_tclMsgCalibrationStatusStatus()
:e8CalibrationStsToHMI()
 {}

tS32 midw_kbdfi_tclMsgCalibrationStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_CALIBRATIONSTATUSSTATUS;
}


midw_kbdfi_tclMsgCalibrationStatusStatus::~midw_kbdfi_tclMsgCalibrationStatusStatus()
{}

tU32 midw_kbdfi_tclMsgCalibrationStatusStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgCalibrationStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> e8CalibrationStsToHMI);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgCalibrationStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << e8CalibrationStsToHMI);
   return oOut;
}

tBool midw_kbdfi_tclMsgCalibrationStatusStatus::operator==(const midw_kbdfi_tclMsgCalibrationStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (e8CalibrationStsToHMI == roRef.e8CalibrationStsToHMI);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgFasciaIdUpReg::midw_kbdfi_tclMsgFasciaIdUpReg()
 {}

tS32 midw_kbdfi_tclMsgFasciaIdUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_FASCIAIDUPREG;
}


midw_kbdfi_tclMsgFasciaIdUpReg::~midw_kbdfi_tclMsgFasciaIdUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgFasciaIdRelUpReg::midw_kbdfi_tclMsgFasciaIdRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgFasciaIdRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_FASCIAIDRELUPREG;
}


midw_kbdfi_tclMsgFasciaIdRelUpReg::~midw_kbdfi_tclMsgFasciaIdRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgFasciaIdStatus::midw_kbdfi_tclMsgFasciaIdStatus(const midw_kbdfi_tclMsgFasciaIdStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   tSfasciaId = coRef.tSfasciaId;
}
midw_kbdfi_tclMsgFasciaIdStatus& midw_kbdfi_tclMsgFasciaIdStatus::operator=(const midw_kbdfi_tclMsgFasciaIdStatus& coRef)
{
   if (this == &coRef) return *this;
   tSfasciaId = coRef.tSfasciaId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_kbdfi_tclMsgFasciaIdStatus::vDestroy()
{
   tSfasciaId.vDestroy();
}

midw_kbdfi_tclMsgFasciaIdStatus::midw_kbdfi_tclMsgFasciaIdStatus()
:tSfasciaId()
 {}

tS32 midw_kbdfi_tclMsgFasciaIdStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_FASCIAIDSTATUS;
}


midw_kbdfi_tclMsgFasciaIdStatus::~midw_kbdfi_tclMsgFasciaIdStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_kbdfi_tclMsgFasciaIdStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+tSfasciaId.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_kbdfi_tclMsgFasciaIdStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> tSfasciaId);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgFasciaIdStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << tSfasciaId);
   return oOut;
}

tBool midw_kbdfi_tclMsgFasciaIdStatus::operator==(const midw_kbdfi_tclMsgFasciaIdStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (tSfasciaId == roRef.tSfasciaId);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgTouchInfoUpReg::midw_kbdfi_tclMsgTouchInfoUpReg()
 {}

tS32 midw_kbdfi_tclMsgTouchInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_TOUCHINFOUPREG;
}


midw_kbdfi_tclMsgTouchInfoUpReg::~midw_kbdfi_tclMsgTouchInfoUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgTouchInfoRelUpReg::midw_kbdfi_tclMsgTouchInfoRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgTouchInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_TOUCHINFORELUPREG;
}


midw_kbdfi_tclMsgTouchInfoRelUpReg::~midw_kbdfi_tclMsgTouchInfoRelUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgTouchInfoGet::midw_kbdfi_tclMsgTouchInfoGet()
 {}

tS32 midw_kbdfi_tclMsgTouchInfoGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_TOUCHINFOGET;
}


midw_kbdfi_tclMsgTouchInfoGet::~midw_kbdfi_tclMsgTouchInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgTouchInfoStatus::midw_kbdfi_tclMsgTouchInfoStatus(const midw_kbdfi_tclMsgTouchInfoStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   TouchInfo = coRef.TouchInfo;
}
midw_kbdfi_tclMsgTouchInfoStatus& midw_kbdfi_tclMsgTouchInfoStatus::operator=(const midw_kbdfi_tclMsgTouchInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   TouchInfo = coRef.TouchInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgTouchInfoStatus::midw_kbdfi_tclMsgTouchInfoStatus()
:TouchInfo()
 {}

tS32 midw_kbdfi_tclMsgTouchInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_TOUCHINFOSTATUS;
}


midw_kbdfi_tclMsgTouchInfoStatus::~midw_kbdfi_tclMsgTouchInfoStatus()
{}

tU32 midw_kbdfi_tclMsgTouchInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_kbdfi_tclMsgTouchInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TouchInfo);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgTouchInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TouchInfo);
   return oOut;
}

tBool midw_kbdfi_tclMsgTouchInfoStatus::operator==(const midw_kbdfi_tclMsgTouchInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TouchInfo == roRef.TouchInfo);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgAuxInInfoUpReg::midw_kbdfi_tclMsgAuxInInfoUpReg()
 {}

tS32 midw_kbdfi_tclMsgAuxInInfoUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUXININFOUPREG;
}


midw_kbdfi_tclMsgAuxInInfoUpReg::~midw_kbdfi_tclMsgAuxInInfoUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgAuxInInfoRelUpReg::midw_kbdfi_tclMsgAuxInInfoRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgAuxInInfoRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUXININFORELUPREG;
}


midw_kbdfi_tclMsgAuxInInfoRelUpReg::~midw_kbdfi_tclMsgAuxInInfoRelUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgAuxInInfoGet::midw_kbdfi_tclMsgAuxInInfoGet()
 {}

tS32 midw_kbdfi_tclMsgAuxInInfoGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUXININFOGET;
}


midw_kbdfi_tclMsgAuxInInfoGet::~midw_kbdfi_tclMsgAuxInInfoGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgAuxInInfoStatus::midw_kbdfi_tclMsgAuxInInfoStatus(const midw_kbdfi_tclMsgAuxInInfoStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   AuxInInfo = coRef.AuxInInfo;
}
midw_kbdfi_tclMsgAuxInInfoStatus& midw_kbdfi_tclMsgAuxInInfoStatus::operator=(const midw_kbdfi_tclMsgAuxInInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   AuxInInfo = coRef.AuxInInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgAuxInInfoStatus::midw_kbdfi_tclMsgAuxInInfoStatus()
:AuxInInfo()
 {}

tS32 midw_kbdfi_tclMsgAuxInInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUXININFOSTATUS;
}


midw_kbdfi_tclMsgAuxInInfoStatus::~midw_kbdfi_tclMsgAuxInInfoStatus()
{}

tU32 midw_kbdfi_tclMsgAuxInInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgAuxInInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AuxInInfo);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgAuxInInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AuxInInfo);
   return oOut;
}

tBool midw_kbdfi_tclMsgAuxInInfoStatus::operator==(const midw_kbdfi_tclMsgAuxInInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AuxInInfo == roRef.AuxInInfo);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgKeyRepeatTimeUpReg::midw_kbdfi_tclMsgKeyRepeatTimeUpReg()
 {}

tS32 midw_kbdfi_tclMsgKeyRepeatTimeUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEUPREG;
}


midw_kbdfi_tclMsgKeyRepeatTimeUpReg::~midw_kbdfi_tclMsgKeyRepeatTimeUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg::midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMERELUPREG;
}


midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg::~midw_kbdfi_tclMsgKeyRepeatTimeRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgKeyRepeatTimeSet::midw_kbdfi_tclMsgKeyRepeatTimeSet(const midw_kbdfi_tclMsgKeyRepeatTimeSet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   RepeatTime = coRef.RepeatTime;
}
midw_kbdfi_tclMsgKeyRepeatTimeSet& midw_kbdfi_tclMsgKeyRepeatTimeSet::operator=(const midw_kbdfi_tclMsgKeyRepeatTimeSet& coRef)
{
   if (this == &coRef) return *this;
   RepeatTime = coRef.RepeatTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgKeyRepeatTimeSet::midw_kbdfi_tclMsgKeyRepeatTimeSet()
:RepeatTime(0)
 {}

tS32 midw_kbdfi_tclMsgKeyRepeatTimeSet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESET;
}


midw_kbdfi_tclMsgKeyRepeatTimeSet::~midw_kbdfi_tclMsgKeyRepeatTimeSet()
{}

tU32 midw_kbdfi_tclMsgKeyRepeatTimeSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgKeyRepeatTimeSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RepeatTime);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgKeyRepeatTimeSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RepeatTime);
   return oOut;
}

tBool midw_kbdfi_tclMsgKeyRepeatTimeSet::operator==(const midw_kbdfi_tclMsgKeyRepeatTimeSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RepeatTime == roRef.RepeatTime);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgKeyRepeatTimeGet::midw_kbdfi_tclMsgKeyRepeatTimeGet()
 {}

tS32 midw_kbdfi_tclMsgKeyRepeatTimeGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMEGET;
}


midw_kbdfi_tclMsgKeyRepeatTimeGet::~midw_kbdfi_tclMsgKeyRepeatTimeGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgKeyRepeatTimeStatus::midw_kbdfi_tclMsgKeyRepeatTimeStatus(const midw_kbdfi_tclMsgKeyRepeatTimeStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   RepeatTime = coRef.RepeatTime;
}
midw_kbdfi_tclMsgKeyRepeatTimeStatus& midw_kbdfi_tclMsgKeyRepeatTimeStatus::operator=(const midw_kbdfi_tclMsgKeyRepeatTimeStatus& coRef)
{
   if (this == &coRef) return *this;
   RepeatTime = coRef.RepeatTime;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgKeyRepeatTimeStatus::midw_kbdfi_tclMsgKeyRepeatTimeStatus()
:RepeatTime(0)
 {}

tS32 midw_kbdfi_tclMsgKeyRepeatTimeStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_KEYREPEATTIMESTATUS;
}


midw_kbdfi_tclMsgKeyRepeatTimeStatus::~midw_kbdfi_tclMsgKeyRepeatTimeStatus()
{}

tU32 midw_kbdfi_tclMsgKeyRepeatTimeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgKeyRepeatTimeStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RepeatTime);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgKeyRepeatTimeStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RepeatTime);
   return oOut;
}

tBool midw_kbdfi_tclMsgKeyRepeatTimeStatus::operator==(const midw_kbdfi_tclMsgKeyRepeatTimeStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RepeatTime == roRef.RepeatTime);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgLastReleasedKeyGet::midw_kbdfi_tclMsgLastReleasedKeyGet()
 {}

tS32 midw_kbdfi_tclMsgLastReleasedKeyGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYGET;
}


midw_kbdfi_tclMsgLastReleasedKeyGet::~midw_kbdfi_tclMsgLastReleasedKeyGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgLastReleasedKeyStatus::midw_kbdfi_tclMsgLastReleasedKeyStatus(const midw_kbdfi_tclMsgLastReleasedKeyStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   LastReleasedKeyCode = coRef.LastReleasedKeyCode;
}
midw_kbdfi_tclMsgLastReleasedKeyStatus& midw_kbdfi_tclMsgLastReleasedKeyStatus::operator=(const midw_kbdfi_tclMsgLastReleasedKeyStatus& coRef)
{
   if (this == &coRef) return *this;
   LastReleasedKeyCode = coRef.LastReleasedKeyCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgLastReleasedKeyStatus::midw_kbdfi_tclMsgLastReleasedKeyStatus()
:LastReleasedKeyCode()
 {}

tS32 midw_kbdfi_tclMsgLastReleasedKeyStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTRELEASEDKEYSTATUS;
}


midw_kbdfi_tclMsgLastReleasedKeyStatus::~midw_kbdfi_tclMsgLastReleasedKeyStatus()
{}

tU32 midw_kbdfi_tclMsgLastReleasedKeyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgLastReleasedKeyStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LastReleasedKeyCode);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgLastReleasedKeyStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LastReleasedKeyCode);
   return oOut;
}

tBool midw_kbdfi_tclMsgLastReleasedKeyStatus::operator==(const midw_kbdfi_tclMsgLastReleasedKeyStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LastReleasedKeyCode == roRef.LastReleasedKeyCode);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgLastUsedEncoderGet::midw_kbdfi_tclMsgLastUsedEncoderGet()
 {}

tS32 midw_kbdfi_tclMsgLastUsedEncoderGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERGET;
}


midw_kbdfi_tclMsgLastUsedEncoderGet::~midw_kbdfi_tclMsgLastUsedEncoderGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgLastUsedEncoderStatus::midw_kbdfi_tclMsgLastUsedEncoderStatus(const midw_kbdfi_tclMsgLastUsedEncoderStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   LastUsedEncoderCode = coRef.LastUsedEncoderCode;
}
midw_kbdfi_tclMsgLastUsedEncoderStatus& midw_kbdfi_tclMsgLastUsedEncoderStatus::operator=(const midw_kbdfi_tclMsgLastUsedEncoderStatus& coRef)
{
   if (this == &coRef) return *this;
   LastUsedEncoderCode = coRef.LastUsedEncoderCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgLastUsedEncoderStatus::midw_kbdfi_tclMsgLastUsedEncoderStatus()
:LastUsedEncoderCode()
 {}

tS32 midw_kbdfi_tclMsgLastUsedEncoderStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERSTATUS;
}


midw_kbdfi_tclMsgLastUsedEncoderStatus::~midw_kbdfi_tclMsgLastUsedEncoderStatus()
{}

tU32 midw_kbdfi_tclMsgLastUsedEncoderStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgLastUsedEncoderStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LastUsedEncoderCode);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgLastUsedEncoderStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LastUsedEncoderCode);
   return oOut;
}

tBool midw_kbdfi_tclMsgLastUsedEncoderStatus::operator==(const midw_kbdfi_tclMsgLastUsedEncoderStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LastUsedEncoderCode == roRef.LastUsedEncoderCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgLastUsedEncoderInfoGet::midw_kbdfi_tclMsgLastUsedEncoderInfoGet(const midw_kbdfi_tclMsgLastUsedEncoderInfoGet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   KeyEncoder = coRef.KeyEncoder;
}
midw_kbdfi_tclMsgLastUsedEncoderInfoGet& midw_kbdfi_tclMsgLastUsedEncoderInfoGet::operator=(const midw_kbdfi_tclMsgLastUsedEncoderInfoGet& coRef)
{
   if (this == &coRef) return *this;
   KeyEncoder = coRef.KeyEncoder;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgLastUsedEncoderInfoGet::midw_kbdfi_tclMsgLastUsedEncoderInfoGet()
:KeyEncoder()
 {}

tS32 midw_kbdfi_tclMsgLastUsedEncoderInfoGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOGET;
}


midw_kbdfi_tclMsgLastUsedEncoderInfoGet::~midw_kbdfi_tclMsgLastUsedEncoderInfoGet()
{}

tU32 midw_kbdfi_tclMsgLastUsedEncoderInfoGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_kbdfi_tclMsgLastUsedEncoderInfoGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyEncoder);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgLastUsedEncoderInfoGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyEncoder);
   return oOut;
}

tBool midw_kbdfi_tclMsgLastUsedEncoderInfoGet::operator==(const midw_kbdfi_tclMsgLastUsedEncoderInfoGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyEncoder == roRef.KeyEncoder);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::midw_kbdfi_tclMsgLastUsedEncoderInfoStatus(const midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   KeyEncoder = coRef.KeyEncoder;
}
midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::operator=(const midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyEncoder = coRef.KeyEncoder;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::midw_kbdfi_tclMsgLastUsedEncoderInfoStatus()
:KeyEncoder()
 {}

tS32 midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTUSEDENCODERINFOSTATUS;
}


midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::~midw_kbdfi_tclMsgLastUsedEncoderInfoStatus()
{}

tU32 midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyEncoder);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyEncoder);
   return oOut;
}

tBool midw_kbdfi_tclMsgLastUsedEncoderInfoStatus::operator==(const midw_kbdfi_tclMsgLastUsedEncoderInfoStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyEncoder == roRef.KeyEncoder);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgLastPressedKeyGet::midw_kbdfi_tclMsgLastPressedKeyGet()
 {}

tS32 midw_kbdfi_tclMsgLastPressedKeyGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYGET;
}


midw_kbdfi_tclMsgLastPressedKeyGet::~midw_kbdfi_tclMsgLastPressedKeyGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgLastPressedKeySet::midw_kbdfi_tclMsgLastPressedKeySet(const midw_kbdfi_tclMsgLastPressedKeySet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   KeyCode = coRef.KeyCode;
}
midw_kbdfi_tclMsgLastPressedKeySet& midw_kbdfi_tclMsgLastPressedKeySet::operator=(const midw_kbdfi_tclMsgLastPressedKeySet& coRef)
{
   if (this == &coRef) return *this;
   KeyCode = coRef.KeyCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgLastPressedKeySet::midw_kbdfi_tclMsgLastPressedKeySet()
:KeyCode()
 {}

tS32 midw_kbdfi_tclMsgLastPressedKeySet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSET;
}


midw_kbdfi_tclMsgLastPressedKeySet::~midw_kbdfi_tclMsgLastPressedKeySet()
{}

tU32 midw_kbdfi_tclMsgLastPressedKeySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgLastPressedKeySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyCode);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgLastPressedKeySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyCode);
   return oOut;
}

tBool midw_kbdfi_tclMsgLastPressedKeySet::operator==(const midw_kbdfi_tclMsgLastPressedKeySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyCode == roRef.KeyCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgLastPressedKeyStatus::midw_kbdfi_tclMsgLastPressedKeyStatus(const midw_kbdfi_tclMsgLastPressedKeyStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   LastPressedKeyCode = coRef.LastPressedKeyCode;
}
midw_kbdfi_tclMsgLastPressedKeyStatus& midw_kbdfi_tclMsgLastPressedKeyStatus::operator=(const midw_kbdfi_tclMsgLastPressedKeyStatus& coRef)
{
   if (this == &coRef) return *this;
   LastPressedKeyCode = coRef.LastPressedKeyCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgLastPressedKeyStatus::midw_kbdfi_tclMsgLastPressedKeyStatus()
:LastPressedKeyCode()
 {}

tS32 midw_kbdfi_tclMsgLastPressedKeyStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_LASTPRESSEDKEYSTATUS;
}


midw_kbdfi_tclMsgLastPressedKeyStatus::~midw_kbdfi_tclMsgLastPressedKeyStatus()
{}

tU32 midw_kbdfi_tclMsgLastPressedKeyStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_kbdfi_tclMsgLastPressedKeyStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LastPressedKeyCode);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgLastPressedKeyStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LastPressedKeyCode);
   return oOut;
}

tBool midw_kbdfi_tclMsgLastPressedKeyStatus::operator==(const midw_kbdfi_tclMsgLastPressedKeyStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LastPressedKeyCode == roRef.LastPressedKeyCode);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg::midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSUPREG;
}


midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg::~midw_kbdfi_tclMsgDiagActKeyEncoderStatusUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg::midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSRELUPREG;
}


midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg::~midw_kbdfi_tclMsgDiagActKeyEncoderStatusRelUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet::midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet()
 {}

tS32 midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSGET;
}


midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet::~midw_kbdfi_tclMsgDiagActKeyEncoderStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   KeyList = coRef.KeyList;
   EncoderStatusList = coRef.EncoderStatusList;
   LastCANStatus = coRef.LastCANStatus;
   LastCradleStatus = coRef.LastCradleStatus;
   OnTipperStatus = coRef.OnTipperStatus;
}
midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::operator=(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyList = coRef.KeyList;
   EncoderStatusList = coRef.EncoderStatusList;
   LastCANStatus = coRef.LastCANStatus;
   LastCradleStatus = coRef.LastCradleStatus;
   OnTipperStatus = coRef.OnTipperStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::vDestroy()
{
   KeyList.vDestroy(); 
   EncoderStatusList.vDestroy(); 
   LastCANStatus.vDestroy(); 
}

midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus()
:KeyList()
,EncoderStatusList()
,LastCANStatus()
,LastCradleStatus(0)
,OnTipperStatus()
 {}

tS32 midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGACTKEYENCODERSTATUSSTATUS;
}


midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::~midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 10+KeyList.u32GetSize(u16MajorVersion)+EncoderStatusList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyList);
   (tVoid) (oIn >> EncoderStatusList);
   (tVoid) (oIn >> LastCANStatus);
   (tVoid) (oIn >> LastCradleStatus);
   (tVoid) (oIn >> OnTipperStatus);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyList);
   (tVoid) (oOut << EncoderStatusList);
   (tVoid) (oOut << LastCANStatus);
   (tVoid) (oOut << LastCradleStatus);
   (tVoid) (oOut << OnTipperStatus);
   return oOut;
}

tBool midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus::operator==(const midw_kbdfi_tclMsgDiagActKeyEncoderStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyList == roRef.KeyList);
   bResult = bResult && (EncoderStatusList == roRef.EncoderStatusList);
   bResult = bResult && (LastCANStatus == roRef.LastCANStatus);
   bResult = bResult && (LastCradleStatus == roRef.LastCradleStatus);
   bResult = bResult && (OnTipperStatus == roRef.OnTipperStatus);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgDiagPressedKeysUpReg::midw_kbdfi_tclMsgDiagPressedKeysUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedKeysUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSUPREG;
}


midw_kbdfi_tclMsgDiagPressedKeysUpReg::~midw_kbdfi_tclMsgDiagPressedKeysUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagPressedKeysRelUpReg::midw_kbdfi_tclMsgDiagPressedKeysRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedKeysRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSRELUPREG;
}


midw_kbdfi_tclMsgDiagPressedKeysRelUpReg::~midw_kbdfi_tclMsgDiagPressedKeysRelUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagPressedKeysGet::midw_kbdfi_tclMsgDiagPressedKeysGet()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedKeysGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSGET;
}


midw_kbdfi_tclMsgDiagPressedKeysGet::~midw_kbdfi_tclMsgDiagPressedKeysGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgDiagPressedKeysStatus::midw_kbdfi_tclMsgDiagPressedKeysStatus(const midw_kbdfi_tclMsgDiagPressedKeysStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   KeyList = coRef.KeyList;
}
midw_kbdfi_tclMsgDiagPressedKeysStatus& midw_kbdfi_tclMsgDiagPressedKeysStatus::operator=(const midw_kbdfi_tclMsgDiagPressedKeysStatus& coRef)
{
   if (this == &coRef) return *this;
   KeyList = coRef.KeyList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_kbdfi_tclMsgDiagPressedKeysStatus::vDestroy()
{
   KeyList.vDestroy(); 
}

midw_kbdfi_tclMsgDiagPressedKeysStatus::midw_kbdfi_tclMsgDiagPressedKeysStatus()
:KeyList()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedKeysStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDKEYSSTATUS;
}


midw_kbdfi_tclMsgDiagPressedKeysStatus::~midw_kbdfi_tclMsgDiagPressedKeysStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_kbdfi_tclMsgDiagPressedKeysStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+KeyList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_kbdfi_tclMsgDiagPressedKeysStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> KeyList);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgDiagPressedKeysStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << KeyList);
   return oOut;
}

tBool midw_kbdfi_tclMsgDiagPressedKeysStatus::operator==(const midw_kbdfi_tclMsgDiagPressedKeysStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (KeyList == roRef.KeyList);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgDiagEncoderStatusUpReg::midw_kbdfi_tclMsgDiagEncoderStatusUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagEncoderStatusUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSUPREG;
}


midw_kbdfi_tclMsgDiagEncoderStatusUpReg::~midw_kbdfi_tclMsgDiagEncoderStatusUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg::midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSRELUPREG;
}


midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg::~midw_kbdfi_tclMsgDiagEncoderStatusRelUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagEncoderStatusGet::midw_kbdfi_tclMsgDiagEncoderStatusGet()
 {}

tS32 midw_kbdfi_tclMsgDiagEncoderStatusGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSGET;
}


midw_kbdfi_tclMsgDiagEncoderStatusGet::~midw_kbdfi_tclMsgDiagEncoderStatusGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgDiagEncoderStatusStatus::midw_kbdfi_tclMsgDiagEncoderStatusStatus(const midw_kbdfi_tclMsgDiagEncoderStatusStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   EncoderValuesList = coRef.EncoderValuesList;
}
midw_kbdfi_tclMsgDiagEncoderStatusStatus& midw_kbdfi_tclMsgDiagEncoderStatusStatus::operator=(const midw_kbdfi_tclMsgDiagEncoderStatusStatus& coRef)
{
   if (this == &coRef) return *this;
   EncoderValuesList = coRef.EncoderValuesList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_kbdfi_tclMsgDiagEncoderStatusStatus::vDestroy()
{
   EncoderValuesList.vDestroy(); 
}

midw_kbdfi_tclMsgDiagEncoderStatusStatus::midw_kbdfi_tclMsgDiagEncoderStatusStatus()
:EncoderValuesList()
 {}

tS32 midw_kbdfi_tclMsgDiagEncoderStatusStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGENCODERSTATUSSTATUS;
}


midw_kbdfi_tclMsgDiagEncoderStatusStatus::~midw_kbdfi_tclMsgDiagEncoderStatusStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_kbdfi_tclMsgDiagEncoderStatusStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+EncoderValuesList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_kbdfi_tclMsgDiagEncoderStatusStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> EncoderValuesList);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgDiagEncoderStatusStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << EncoderValuesList);
   return oOut;
}

tBool midw_kbdfi_tclMsgDiagEncoderStatusStatus::operator==(const midw_kbdfi_tclMsgDiagEncoderStatusStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (EncoderValuesList == roRef.EncoderValuesList);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg::midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSUPREG;
}


midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg::~midw_kbdfi_tclMsgDiagPressedTouchPositionsUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg::midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSRELUPREG;
}


midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg::~midw_kbdfi_tclMsgDiagPressedTouchPositionsRelUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgDiagPressedTouchPositionsGet::midw_kbdfi_tclMsgDiagPressedTouchPositionsGet()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedTouchPositionsGet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSGET;
}


midw_kbdfi_tclMsgDiagPressedTouchPositionsGet::~midw_kbdfi_tclMsgDiagPressedTouchPositionsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus(const midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   TouchCoordinateList = coRef.TouchCoordinateList;
}
midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::operator=(const midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& coRef)
{
   if (this == &coRef) return *this;
   TouchCoordinateList = coRef.TouchCoordinateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::vDestroy()
{
   TouchCoordinateList.vDestroy(); 
}

midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus()
:TouchCoordinateList()
 {}

tS32 midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_DIAGPRESSEDTOUCHPOSITIONSSTATUS;
}


midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::~midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TouchCoordinateList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TouchCoordinateList);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TouchCoordinateList);
   return oOut;
}

tBool midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus::operator==(const midw_kbdfi_tclMsgDiagPressedTouchPositionsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TouchCoordinateList == roRef.TouchCoordinateList);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgAudioControlUpReg::midw_kbdfi_tclMsgAudioControlUpReg()
 {}

tS32 midw_kbdfi_tclMsgAudioControlUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLUPREG;
}


midw_kbdfi_tclMsgAudioControlUpReg::~midw_kbdfi_tclMsgAudioControlUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgAudioControlRelUpReg::midw_kbdfi_tclMsgAudioControlRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgAudioControlRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLRELUPREG;
}


midw_kbdfi_tclMsgAudioControlRelUpReg::~midw_kbdfi_tclMsgAudioControlRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgAudioControlStatus::midw_kbdfi_tclMsgAudioControlStatus(const midw_kbdfi_tclMsgAudioControlStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   ControlType = coRef.ControlType;
}
midw_kbdfi_tclMsgAudioControlStatus& midw_kbdfi_tclMsgAudioControlStatus::operator=(const midw_kbdfi_tclMsgAudioControlStatus& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   ControlType = coRef.ControlType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgAudioControlStatus::midw_kbdfi_tclMsgAudioControlStatus()
:Action()
,ControlType()
 {}

tS32 midw_kbdfi_tclMsgAudioControlStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSTATUS;
}


midw_kbdfi_tclMsgAudioControlStatus::~midw_kbdfi_tclMsgAudioControlStatus()
{}

tU32 midw_kbdfi_tclMsgAudioControlStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_kbdfi_tclMsgAudioControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> ControlType);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgAudioControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << ControlType);
   return oOut;
}

tBool midw_kbdfi_tclMsgAudioControlStatus::operator==(const midw_kbdfi_tclMsgAudioControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (ControlType == roRef.ControlType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgAudioControlSet::midw_kbdfi_tclMsgAudioControlSet(const midw_kbdfi_tclMsgAudioControlSet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   Reason = coRef.Reason;
   DataValid = coRef.DataValid;
   ControlResult = coRef.ControlResult;
}
midw_kbdfi_tclMsgAudioControlSet& midw_kbdfi_tclMsgAudioControlSet::operator=(const midw_kbdfi_tclMsgAudioControlSet& coRef)
{
   if (this == &coRef) return *this;
   Reason = coRef.Reason;
   DataValid = coRef.DataValid;
   ControlResult = coRef.ControlResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgAudioControlSet::midw_kbdfi_tclMsgAudioControlSet()
:Reason()
,DataValid(0)
,ControlResult()
 {}

tS32 midw_kbdfi_tclMsgAudioControlSet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSET;
}


midw_kbdfi_tclMsgAudioControlSet::~midw_kbdfi_tclMsgAudioControlSet()
{}

tU32 midw_kbdfi_tclMsgAudioControlSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_kbdfi_tclMsgAudioControlSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Reason);
   (tVoid) (oIn >> DataValid);
   (tVoid) (oIn >> ControlResult);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgAudioControlSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Reason);
   (tVoid) (oOut << DataValid);
   (tVoid) (oOut << ControlResult);
   return oOut;
}

tBool midw_kbdfi_tclMsgAudioControlSet::operator==(const midw_kbdfi_tclMsgAudioControlSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Reason == roRef.Reason);
   bResult = bResult && (DataValid == roRef.DataValid);
   bResult = bResult && (ControlResult == roRef.ControlResult);
   return bResult;
}

//=============================================================================

midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg::midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg()
 {}

tS32 midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYUPREG;
}


midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg::~midw_kbdfi_tclMsgAudioControlSelectListEntryUpReg()
{}

//=============================================================================

midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg::midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg()
 {}

tS32 midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYRELUPREG;
}


midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg::~midw_kbdfi_tclMsgAudioControlSelectListEntryRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::midw_kbdfi_tclMsgAudioControlSelectListEntryStatus(const midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   Action = coRef.Action;
   UniqueListID = coRef.UniqueListID;
   ListSelection = coRef.ListSelection;
}
midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::operator=(const midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& coRef)
{
   if (this == &coRef) return *this;
   Action = coRef.Action;
   UniqueListID = coRef.UniqueListID;
   ListSelection = coRef.ListSelection;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::midw_kbdfi_tclMsgAudioControlSelectListEntryStatus()
:Action()
,UniqueListID(0)
,ListSelection(0)
 {}

tS32 midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSTATUS;
}


midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::~midw_kbdfi_tclMsgAudioControlSelectListEntryStatus()
{}

tU32 midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Action);
   (tVoid) (oIn >> UniqueListID);
   (tVoid) (oIn >> ListSelection);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Action);
   (tVoid) (oOut << UniqueListID);
   (tVoid) (oOut << ListSelection);
   return oOut;
}

tBool midw_kbdfi_tclMsgAudioControlSelectListEntryStatus::operator==(const midw_kbdfi_tclMsgAudioControlSelectListEntryStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Action == roRef.Action);
   bResult = bResult && (UniqueListID == roRef.UniqueListID);
   bResult = bResult && (ListSelection == roRef.ListSelection);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_kbdfi_tclMsgAudioControlSelectListEntrySet::midw_kbdfi_tclMsgAudioControlSelectListEntrySet(const midw_kbdfi_tclMsgAudioControlSelectListEntrySet& coRef)
   : midw_kbdfi_tclMsgBaseMessage(coRef)
{
   Reason = coRef.Reason;
   DataValid = coRef.DataValid;
   Result = coRef.Result;
}
midw_kbdfi_tclMsgAudioControlSelectListEntrySet& midw_kbdfi_tclMsgAudioControlSelectListEntrySet::operator=(const midw_kbdfi_tclMsgAudioControlSelectListEntrySet& coRef)
{
   if (this == &coRef) return *this;
   Reason = coRef.Reason;
   DataValid = coRef.DataValid;
   Result = coRef.Result;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_kbdfi_tclMsgAudioControlSelectListEntrySet::midw_kbdfi_tclMsgAudioControlSelectListEntrySet()
:Reason()
,DataValid(0)
,Result(0)
 {}

tS32 midw_kbdfi_tclMsgAudioControlSelectListEntrySet::s32GetTypeId() const
{
   return (tS32) midw_kbdfi_tclToken::EN_MSG_AUDIOCONTROLSELECTLISTENTRYSET;
}


midw_kbdfi_tclMsgAudioControlSelectListEntrySet::~midw_kbdfi_tclMsgAudioControlSelectListEntrySet()
{}

tU32 midw_kbdfi_tclMsgAudioControlSelectListEntrySet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& midw_kbdfi_tclMsgAudioControlSelectListEntrySet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Reason);
   (tVoid) (oIn >> DataValid);
   (tVoid) (oIn >> Result);
   return oIn;
}

fi_tclOutContext& midw_kbdfi_tclMsgAudioControlSelectListEntrySet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Reason);
   (tVoid) (oOut << DataValid);
   (tVoid) (oOut << Result);
   return oOut;
}

tBool midw_kbdfi_tclMsgAudioControlSelectListEntrySet::operator==(const midw_kbdfi_tclMsgAudioControlSelectListEntrySet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Reason == roRef.Reason);
   bResult = bResult && (DataValid == roRef.DataValid);
   bResult = bResult && (Result == roRef.Result);
   return bResult;
}

