/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_IPODAUTHFITYPES_HEADER
#define MIDW_IPODAUTHFITYPES_HEADER


class midw_ipodauthfi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_ipodauth_fi message types

fi_tclMessageBase* midw_ipodauthfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_ipodauthfi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_ipodauthfi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_ipodauthfi_tclMsgAuthenticationInitMethodStart : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgAuthenticationInitMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& operator=(const midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& coRef);
   midw_ipodauthfi_tclMsgAuthenticationInitMethodStart(const midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tBool bInit;
   virtual ~midw_ipodauthfi_tclMsgAuthenticationInitMethodStart();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgAuthenticationInitMethodResult : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgAuthenticationInitMethodResult();

   virtual ~midw_ipodauthfi_tclMsgAuthenticationInitMethodResult();

   inline tBool operator==(const midw_ipodauthfi_tclMsgAuthenticationInitMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgGenSignatureMethodStart : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgGenSignatureMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgGenSignatureMethodStart& operator=(const midw_ipodauthfi_tclMsgGenSignatureMethodStart& coRef);
   midw_ipodauthfi_tclMsgGenSignatureMethodStart(const midw_ipodauthfi_tclMsgGenSignatureMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_BinContainer iPodChallenge;
   virtual ~midw_ipodauthfi_tclMsgGenSignatureMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgGenSignatureMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgGenSignatureMethodResult : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgGenSignatureMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgGenSignatureMethodResult& operator=(const midw_ipodauthfi_tclMsgGenSignatureMethodResult& coRef);
   midw_ipodauthfi_tclMsgGenSignatureMethodResult(const midw_ipodauthfi_tclMsgGenSignatureMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_BinContainer Signature;
   virtual ~midw_ipodauthfi_tclMsgGenSignatureMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgGenSignatureMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgSetSignatureMethodStart : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgSetSignatureMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgSetSignatureMethodStart& operator=(const midw_ipodauthfi_tclMsgSetSignatureMethodStart& coRef);
   midw_ipodauthfi_tclMsgSetSignatureMethodStart(const midw_ipodauthfi_tclMsgSetSignatureMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_BinContainer Signature;
   virtual ~midw_ipodauthfi_tclMsgSetSignatureMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgSetSignatureMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgSetSignatureMethodResult : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgSetSignatureMethodResult();

   virtual ~midw_ipodauthfi_tclMsgSetSignatureMethodResult();

   inline tBool operator==(const midw_ipodauthfi_tclMsgSetSignatureMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgGetChallengeMethodStart : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgGetChallengeMethodStart();

   virtual ~midw_ipodauthfi_tclMsgGetChallengeMethodStart();

   inline tBool operator==(const midw_ipodauthfi_tclMsgGetChallengeMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgGetChallengeMethodResult : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgGetChallengeMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgGetChallengeMethodResult& operator=(const midw_ipodauthfi_tclMsgGetChallengeMethodResult& coRef);
   midw_ipodauthfi_tclMsgGetChallengeMethodResult(const midw_ipodauthfi_tclMsgGetChallengeMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_BinContainer CPChallenge;
   virtual ~midw_ipodauthfi_tclMsgGetChallengeMethodResult();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgGetChallengeMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgiPodCertificateMethodStart : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgiPodCertificateMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgiPodCertificateMethodStart& operator=(const midw_ipodauthfi_tclMsgiPodCertificateMethodStart& coRef);
   midw_ipodauthfi_tclMsgiPodCertificateMethodStart(const midw_ipodauthfi_tclMsgiPodCertificateMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_BinContainer Certificate;
   virtual ~midw_ipodauthfi_tclMsgiPodCertificateMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgiPodCertificateMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgiPodCertificateMethodResult : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgiPodCertificateMethodResult();

   virtual ~midw_ipodauthfi_tclMsgiPodCertificateMethodResult();

   inline tBool operator==(const midw_ipodauthfi_tclMsgiPodCertificateMethodResult& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart();

   virtual ~midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart();

   inline tBool operator==(const midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& operator=(const midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef);
   midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult(const midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e16_iPodAuthSelfTestResult enResult;
   virtual ~midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgFirmwareVersionGet : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgFirmwareVersionGet();

   virtual ~midw_ipodauthfi_tclMsgFirmwareVersionGet();

   inline tBool operator==(const midw_ipodauthfi_tclMsgFirmwareVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgFirmwareVersionStatus : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgFirmwareVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgFirmwareVersionStatus& operator=(const midw_ipodauthfi_tclMsgFirmwareVersionStatus& coRef);
   midw_ipodauthfi_tclMsgFirmwareVersionStatus(const midw_ipodauthfi_tclMsgFirmwareVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8MajorVersion;
   tU8 u8MinorVersion;
   virtual ~midw_ipodauthfi_tclMsgFirmwareVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgFirmwareVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet();

   virtual ~midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet();

   inline tBool operator==(const midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& operator=(const midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& coRef);
   midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus(const midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8MajorVersion;
   tU8 u8MinorVersion;
   virtual ~midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgDeviceIDGet : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgDeviceIDGet();

   virtual ~midw_ipodauthfi_tclMsgDeviceIDGet();

   inline tBool operator==(const midw_ipodauthfi_tclMsgDeviceIDGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgDeviceIDStatus : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgDeviceIDStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgDeviceIDStatus& operator=(const midw_ipodauthfi_tclMsgDeviceIDStatus& coRef);
   midw_ipodauthfi_tclMsgDeviceIDStatus(const midw_ipodauthfi_tclMsgDeviceIDStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU32 u32DeviceID;
   virtual ~midw_ipodauthfi_tclMsgDeviceIDStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgDeviceIDStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgAccessoryCertificateGet : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgAccessoryCertificateGet();

   virtual ~midw_ipodauthfi_tclMsgAccessoryCertificateGet();

   inline tBool operator==(const midw_ipodauthfi_tclMsgAccessoryCertificateGet& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_ipodauthfi_tclMsgAccessoryCertificateStatus : public midw_ipodauthfi_tclMsgBaseMessage
{
public:

   midw_ipodauthfi_tclMsgAccessoryCertificateStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_ipodauthfi_tclMsgAccessoryCertificateStatus& operator=(const midw_ipodauthfi_tclMsgAccessoryCertificateStatus& coRef);
   midw_ipodauthfi_tclMsgAccessoryCertificateStatus(const midw_ipodauthfi_tclMsgAccessoryCertificateStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_BinContainer Certificate;
   virtual ~midw_ipodauthfi_tclMsgAccessoryCertificateStatus();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_ipodauthfi_tclMsgAccessoryCertificateStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
