/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_IPODAUTHFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_IPODAUTHFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_IPODAUTHFI_SERVICEINFO
#include "midw_fi_gen_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for midw_ipodauth_fi message types

fi_tclMessageBase* midw_ipodauthfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONINITMETHODSTART:
         return OSAL_NEW midw_ipodauthfi_tclMsgAuthenticationInitMethodStart;

      case midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONINITMETHODRESULT:
         return OSAL_NEW midw_ipodauthfi_tclMsgAuthenticationInitMethodResult;

      case midw_ipodauthfi_tclToken::EN_MSG_GENSIGNATUREMETHODSTART:
         return OSAL_NEW midw_ipodauthfi_tclMsgGenSignatureMethodStart;

      case midw_ipodauthfi_tclToken::EN_MSG_GENSIGNATUREMETHODRESULT:
         return OSAL_NEW midw_ipodauthfi_tclMsgGenSignatureMethodResult;

      case midw_ipodauthfi_tclToken::EN_MSG_SETSIGNATUREMETHODSTART:
         return OSAL_NEW midw_ipodauthfi_tclMsgSetSignatureMethodStart;

      case midw_ipodauthfi_tclToken::EN_MSG_SETSIGNATUREMETHODRESULT:
         return OSAL_NEW midw_ipodauthfi_tclMsgSetSignatureMethodResult;

      case midw_ipodauthfi_tclToken::EN_MSG_GETCHALLENGEMETHODSTART:
         return OSAL_NEW midw_ipodauthfi_tclMsgGetChallengeMethodStart;

      case midw_ipodauthfi_tclToken::EN_MSG_GETCHALLENGEMETHODRESULT:
         return OSAL_NEW midw_ipodauthfi_tclMsgGetChallengeMethodResult;

      case midw_ipodauthfi_tclToken::EN_MSG_IPODCERTIFICATEMETHODSTART:
         return OSAL_NEW midw_ipodauthfi_tclMsgiPodCertificateMethodStart;

      case midw_ipodauthfi_tclToken::EN_MSG_IPODCERTIFICATEMETHODRESULT:
         return OSAL_NEW midw_ipodauthfi_tclMsgiPodCertificateMethodResult;

      case midw_ipodauthfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODSTART:
         return OSAL_NEW midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart;

      case midw_ipodauthfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODRESULT:
         return OSAL_NEW midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult;

      case midw_ipodauthfi_tclToken::EN_MSG_FIRMWAREVERSIONGET:
         return OSAL_NEW midw_ipodauthfi_tclMsgFirmwareVersionGet;

      case midw_ipodauthfi_tclToken::EN_MSG_FIRMWAREVERSIONSTATUS:
         return OSAL_NEW midw_ipodauthfi_tclMsgFirmwareVersionStatus;

      case midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONPROTOCOLVERSIONGET:
         return OSAL_NEW midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet;

      case midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONPROTOCOLVERSIONSTATUS:
         return OSAL_NEW midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus;

      case midw_ipodauthfi_tclToken::EN_MSG_DEVICEIDGET:
         return OSAL_NEW midw_ipodauthfi_tclMsgDeviceIDGet;

      case midw_ipodauthfi_tclToken::EN_MSG_DEVICEIDSTATUS:
         return OSAL_NEW midw_ipodauthfi_tclMsgDeviceIDStatus;

      case midw_ipodauthfi_tclToken::EN_MSG_ACCESSORYCERTIFICATEGET:
         return OSAL_NEW midw_ipodauthfi_tclMsgAccessoryCertificateGet;

      case midw_ipodauthfi_tclToken::EN_MSG_ACCESSORYCERTIFICATESTATUS:
         return OSAL_NEW midw_ipodauthfi_tclMsgAccessoryCertificateStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all midw_ipodauthfifi messages

// common functions

tU16 midw_ipodauthfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return MIDW_IPODAUTHFI_C_U16_SERVICE_ID;
}

tU16 midw_ipodauthfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 midw_ipodauthfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& midw_ipodauthfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& midw_ipodauthfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 midw_ipodauthfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& midw_ipodauthfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::midw_ipodauthfi_tclMsgAuthenticationInitMethodStart(const midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   bInit = coRef.bInit;
}
midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::operator=(const midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& coRef)
{
   if (this == &coRef) return *this;
   bInit = coRef.bInit;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::midw_ipodauthfi_tclMsgAuthenticationInitMethodStart()
:bInit(0)
 {}

tS32 midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONINITMETHODSTART;
}


midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::~midw_ipodauthfi_tclMsgAuthenticationInitMethodStart()
{}

tU32 midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bInit);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bInit);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgAuthenticationInitMethodStart::operator==(const midw_ipodauthfi_tclMsgAuthenticationInitMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bInit == roRef.bInit);
   return bResult;
}

//=============================================================================

midw_ipodauthfi_tclMsgAuthenticationInitMethodResult::midw_ipodauthfi_tclMsgAuthenticationInitMethodResult()
 {}

tS32 midw_ipodauthfi_tclMsgAuthenticationInitMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONINITMETHODRESULT;
}


midw_ipodauthfi_tclMsgAuthenticationInitMethodResult::~midw_ipodauthfi_tclMsgAuthenticationInitMethodResult()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgGenSignatureMethodStart::midw_ipodauthfi_tclMsgGenSignatureMethodStart(const midw_ipodauthfi_tclMsgGenSignatureMethodStart& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   iPodChallenge = coRef.iPodChallenge;
}
midw_ipodauthfi_tclMsgGenSignatureMethodStart& midw_ipodauthfi_tclMsgGenSignatureMethodStart::operator=(const midw_ipodauthfi_tclMsgGenSignatureMethodStart& coRef)
{
   if (this == &coRef) return *this;
   iPodChallenge = coRef.iPodChallenge;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ipodauthfi_tclMsgGenSignatureMethodStart::vDestroy()
{
   iPodChallenge.vDestroy(); 
}

midw_ipodauthfi_tclMsgGenSignatureMethodStart::midw_ipodauthfi_tclMsgGenSignatureMethodStart()
:iPodChallenge()
 {}

tS32 midw_ipodauthfi_tclMsgGenSignatureMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_GENSIGNATUREMETHODSTART;
}


midw_ipodauthfi_tclMsgGenSignatureMethodStart::~midw_ipodauthfi_tclMsgGenSignatureMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ipodauthfi_tclMsgGenSignatureMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+iPodChallenge.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ipodauthfi_tclMsgGenSignatureMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> iPodChallenge);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgGenSignatureMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << iPodChallenge);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgGenSignatureMethodStart::operator==(const midw_ipodauthfi_tclMsgGenSignatureMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (iPodChallenge == roRef.iPodChallenge);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgGenSignatureMethodResult::midw_ipodauthfi_tclMsgGenSignatureMethodResult(const midw_ipodauthfi_tclMsgGenSignatureMethodResult& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   Signature = coRef.Signature;
}
midw_ipodauthfi_tclMsgGenSignatureMethodResult& midw_ipodauthfi_tclMsgGenSignatureMethodResult::operator=(const midw_ipodauthfi_tclMsgGenSignatureMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Signature = coRef.Signature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ipodauthfi_tclMsgGenSignatureMethodResult::vDestroy()
{
   Signature.vDestroy(); 
}

midw_ipodauthfi_tclMsgGenSignatureMethodResult::midw_ipodauthfi_tclMsgGenSignatureMethodResult()
:Signature()
 {}

tS32 midw_ipodauthfi_tclMsgGenSignatureMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_GENSIGNATUREMETHODRESULT;
}


midw_ipodauthfi_tclMsgGenSignatureMethodResult::~midw_ipodauthfi_tclMsgGenSignatureMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ipodauthfi_tclMsgGenSignatureMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Signature.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ipodauthfi_tclMsgGenSignatureMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Signature);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgGenSignatureMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Signature);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgGenSignatureMethodResult::operator==(const midw_ipodauthfi_tclMsgGenSignatureMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Signature == roRef.Signature);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgSetSignatureMethodStart::midw_ipodauthfi_tclMsgSetSignatureMethodStart(const midw_ipodauthfi_tclMsgSetSignatureMethodStart& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   Signature = coRef.Signature;
}
midw_ipodauthfi_tclMsgSetSignatureMethodStart& midw_ipodauthfi_tclMsgSetSignatureMethodStart::operator=(const midw_ipodauthfi_tclMsgSetSignatureMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Signature = coRef.Signature;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ipodauthfi_tclMsgSetSignatureMethodStart::vDestroy()
{
   Signature.vDestroy(); 
}

midw_ipodauthfi_tclMsgSetSignatureMethodStart::midw_ipodauthfi_tclMsgSetSignatureMethodStart()
:Signature()
 {}

tS32 midw_ipodauthfi_tclMsgSetSignatureMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_SETSIGNATUREMETHODSTART;
}


midw_ipodauthfi_tclMsgSetSignatureMethodStart::~midw_ipodauthfi_tclMsgSetSignatureMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ipodauthfi_tclMsgSetSignatureMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Signature.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ipodauthfi_tclMsgSetSignatureMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Signature);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgSetSignatureMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Signature);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgSetSignatureMethodStart::operator==(const midw_ipodauthfi_tclMsgSetSignatureMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Signature == roRef.Signature);
   return bResult;
}

//=============================================================================

midw_ipodauthfi_tclMsgSetSignatureMethodResult::midw_ipodauthfi_tclMsgSetSignatureMethodResult()
 {}

tS32 midw_ipodauthfi_tclMsgSetSignatureMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_SETSIGNATUREMETHODRESULT;
}


midw_ipodauthfi_tclMsgSetSignatureMethodResult::~midw_ipodauthfi_tclMsgSetSignatureMethodResult()
{}

//=============================================================================

midw_ipodauthfi_tclMsgGetChallengeMethodStart::midw_ipodauthfi_tclMsgGetChallengeMethodStart()
 {}

tS32 midw_ipodauthfi_tclMsgGetChallengeMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_GETCHALLENGEMETHODSTART;
}


midw_ipodauthfi_tclMsgGetChallengeMethodStart::~midw_ipodauthfi_tclMsgGetChallengeMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgGetChallengeMethodResult::midw_ipodauthfi_tclMsgGetChallengeMethodResult(const midw_ipodauthfi_tclMsgGetChallengeMethodResult& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   CPChallenge = coRef.CPChallenge;
}
midw_ipodauthfi_tclMsgGetChallengeMethodResult& midw_ipodauthfi_tclMsgGetChallengeMethodResult::operator=(const midw_ipodauthfi_tclMsgGetChallengeMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CPChallenge = coRef.CPChallenge;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ipodauthfi_tclMsgGetChallengeMethodResult::vDestroy()
{
   CPChallenge.vDestroy(); 
}

midw_ipodauthfi_tclMsgGetChallengeMethodResult::midw_ipodauthfi_tclMsgGetChallengeMethodResult()
:CPChallenge()
 {}

tS32 midw_ipodauthfi_tclMsgGetChallengeMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_GETCHALLENGEMETHODRESULT;
}


midw_ipodauthfi_tclMsgGetChallengeMethodResult::~midw_ipodauthfi_tclMsgGetChallengeMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ipodauthfi_tclMsgGetChallengeMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+CPChallenge.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ipodauthfi_tclMsgGetChallengeMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CPChallenge);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgGetChallengeMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CPChallenge);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgGetChallengeMethodResult::operator==(const midw_ipodauthfi_tclMsgGetChallengeMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CPChallenge == roRef.CPChallenge);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgiPodCertificateMethodStart::midw_ipodauthfi_tclMsgiPodCertificateMethodStart(const midw_ipodauthfi_tclMsgiPodCertificateMethodStart& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   Certificate = coRef.Certificate;
}
midw_ipodauthfi_tclMsgiPodCertificateMethodStart& midw_ipodauthfi_tclMsgiPodCertificateMethodStart::operator=(const midw_ipodauthfi_tclMsgiPodCertificateMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Certificate = coRef.Certificate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ipodauthfi_tclMsgiPodCertificateMethodStart::vDestroy()
{
   Certificate.vDestroy(); 
}

midw_ipodauthfi_tclMsgiPodCertificateMethodStart::midw_ipodauthfi_tclMsgiPodCertificateMethodStart()
:Certificate()
 {}

tS32 midw_ipodauthfi_tclMsgiPodCertificateMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_IPODCERTIFICATEMETHODSTART;
}


midw_ipodauthfi_tclMsgiPodCertificateMethodStart::~midw_ipodauthfi_tclMsgiPodCertificateMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ipodauthfi_tclMsgiPodCertificateMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Certificate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ipodauthfi_tclMsgiPodCertificateMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Certificate);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgiPodCertificateMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Certificate);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgiPodCertificateMethodStart::operator==(const midw_ipodauthfi_tclMsgiPodCertificateMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Certificate == roRef.Certificate);
   return bResult;
}

//=============================================================================

midw_ipodauthfi_tclMsgiPodCertificateMethodResult::midw_ipodauthfi_tclMsgiPodCertificateMethodResult()
 {}

tS32 midw_ipodauthfi_tclMsgiPodCertificateMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_IPODCERTIFICATEMETHODRESULT;
}


midw_ipodauthfi_tclMsgiPodCertificateMethodResult::~midw_ipodauthfi_tclMsgiPodCertificateMethodResult()
{}

//=============================================================================

midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart::midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart()
 {}

tS32 midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODSTART;
}


midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart::~midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult(const midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   enResult = coRef.enResult;
}
midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::operator=(const midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   enResult = coRef.enResult;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult()
:enResult()
 {}

tS32 midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_IPODAUTHENTICATIONSELFTESTMETHODRESULT;
}


midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::~midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult()
{}

tU32 midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> enResult);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << enResult);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult::operator==(const midw_ipodauthfi_tclMsgiPodAuthenticationSelftestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (enResult == roRef.enResult);
   return bResult;
}

//=============================================================================

midw_ipodauthfi_tclMsgFirmwareVersionGet::midw_ipodauthfi_tclMsgFirmwareVersionGet()
 {}

tS32 midw_ipodauthfi_tclMsgFirmwareVersionGet::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_FIRMWAREVERSIONGET;
}


midw_ipodauthfi_tclMsgFirmwareVersionGet::~midw_ipodauthfi_tclMsgFirmwareVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgFirmwareVersionStatus::midw_ipodauthfi_tclMsgFirmwareVersionStatus(const midw_ipodauthfi_tclMsgFirmwareVersionStatus& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   u8MajorVersion = coRef.u8MajorVersion;
   u8MinorVersion = coRef.u8MinorVersion;
}
midw_ipodauthfi_tclMsgFirmwareVersionStatus& midw_ipodauthfi_tclMsgFirmwareVersionStatus::operator=(const midw_ipodauthfi_tclMsgFirmwareVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   u8MajorVersion = coRef.u8MajorVersion;
   u8MinorVersion = coRef.u8MinorVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ipodauthfi_tclMsgFirmwareVersionStatus::midw_ipodauthfi_tclMsgFirmwareVersionStatus()
:u8MajorVersion(0)
,u8MinorVersion(0)
 {}

tS32 midw_ipodauthfi_tclMsgFirmwareVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_FIRMWAREVERSIONSTATUS;
}


midw_ipodauthfi_tclMsgFirmwareVersionStatus::~midw_ipodauthfi_tclMsgFirmwareVersionStatus()
{}

tU32 midw_ipodauthfi_tclMsgFirmwareVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ipodauthfi_tclMsgFirmwareVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8MajorVersion);
   (tVoid) (oIn >> u8MinorVersion);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgFirmwareVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8MajorVersion);
   (tVoid) (oOut << u8MinorVersion);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgFirmwareVersionStatus::operator==(const midw_ipodauthfi_tclMsgFirmwareVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8MajorVersion == roRef.u8MajorVersion);
   bResult = bResult && (u8MinorVersion == roRef.u8MinorVersion);
   return bResult;
}

//=============================================================================

midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet::midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet()
 {}

tS32 midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONPROTOCOLVERSIONGET;
}


midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet::~midw_ipodauthfi_tclMsgAuthenticationProtocolVersionGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus(const midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   u8MajorVersion = coRef.u8MajorVersion;
   u8MinorVersion = coRef.u8MinorVersion;
}
midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::operator=(const midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& coRef)
{
   if (this == &coRef) return *this;
   u8MajorVersion = coRef.u8MajorVersion;
   u8MinorVersion = coRef.u8MinorVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus()
:u8MajorVersion(0)
,u8MinorVersion(0)
 {}

tS32 midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_AUTHENTICATIONPROTOCOLVERSIONSTATUS;
}


midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::~midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus()
{}

tU32 midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u8MajorVersion);
   (tVoid) (oIn >> u8MinorVersion);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u8MajorVersion);
   (tVoid) (oOut << u8MinorVersion);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus::operator==(const midw_ipodauthfi_tclMsgAuthenticationProtocolVersionStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u8MajorVersion == roRef.u8MajorVersion);
   bResult = bResult && (u8MinorVersion == roRef.u8MinorVersion);
   return bResult;
}

//=============================================================================

midw_ipodauthfi_tclMsgDeviceIDGet::midw_ipodauthfi_tclMsgDeviceIDGet()
 {}

tS32 midw_ipodauthfi_tclMsgDeviceIDGet::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_DEVICEIDGET;
}


midw_ipodauthfi_tclMsgDeviceIDGet::~midw_ipodauthfi_tclMsgDeviceIDGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgDeviceIDStatus::midw_ipodauthfi_tclMsgDeviceIDStatus(const midw_ipodauthfi_tclMsgDeviceIDStatus& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   u32DeviceID = coRef.u32DeviceID;
}
midw_ipodauthfi_tclMsgDeviceIDStatus& midw_ipodauthfi_tclMsgDeviceIDStatus::operator=(const midw_ipodauthfi_tclMsgDeviceIDStatus& coRef)
{
   if (this == &coRef) return *this;
   u32DeviceID = coRef.u32DeviceID;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

midw_ipodauthfi_tclMsgDeviceIDStatus::midw_ipodauthfi_tclMsgDeviceIDStatus()
:u32DeviceID(0)
 {}

tS32 midw_ipodauthfi_tclMsgDeviceIDStatus::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_DEVICEIDSTATUS;
}


midw_ipodauthfi_tclMsgDeviceIDStatus::~midw_ipodauthfi_tclMsgDeviceIDStatus()
{}

tU32 midw_ipodauthfi_tclMsgDeviceIDStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& midw_ipodauthfi_tclMsgDeviceIDStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u32DeviceID);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgDeviceIDStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u32DeviceID);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgDeviceIDStatus::operator==(const midw_ipodauthfi_tclMsgDeviceIDStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (u32DeviceID == roRef.u32DeviceID);
   return bResult;
}

//=============================================================================

midw_ipodauthfi_tclMsgAccessoryCertificateGet::midw_ipodauthfi_tclMsgAccessoryCertificateGet()
 {}

tS32 midw_ipodauthfi_tclMsgAccessoryCertificateGet::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_ACCESSORYCERTIFICATEGET;
}


midw_ipodauthfi_tclMsgAccessoryCertificateGet::~midw_ipodauthfi_tclMsgAccessoryCertificateGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
midw_ipodauthfi_tclMsgAccessoryCertificateStatus::midw_ipodauthfi_tclMsgAccessoryCertificateStatus(const midw_ipodauthfi_tclMsgAccessoryCertificateStatus& coRef)
   : midw_ipodauthfi_tclMsgBaseMessage(coRef)
{
   Certificate = coRef.Certificate;
}
midw_ipodauthfi_tclMsgAccessoryCertificateStatus& midw_ipodauthfi_tclMsgAccessoryCertificateStatus::operator=(const midw_ipodauthfi_tclMsgAccessoryCertificateStatus& coRef)
{
   if (this == &coRef) return *this;
   Certificate = coRef.Certificate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid midw_ipodauthfi_tclMsgAccessoryCertificateStatus::vDestroy()
{
   Certificate.vDestroy(); 
}

midw_ipodauthfi_tclMsgAccessoryCertificateStatus::midw_ipodauthfi_tclMsgAccessoryCertificateStatus()
:Certificate()
 {}

tS32 midw_ipodauthfi_tclMsgAccessoryCertificateStatus::s32GetTypeId() const
{
   return (tS32) midw_ipodauthfi_tclToken::EN_MSG_ACCESSORYCERTIFICATESTATUS;
}


midw_ipodauthfi_tclMsgAccessoryCertificateStatus::~midw_ipodauthfi_tclMsgAccessoryCertificateStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 midw_ipodauthfi_tclMsgAccessoryCertificateStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+Certificate.u32GetSize(u16MajorVersion);
}

fi_tclInContext& midw_ipodauthfi_tclMsgAccessoryCertificateStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Certificate);
   return oIn;
}

fi_tclOutContext& midw_ipodauthfi_tclMsgAccessoryCertificateStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Certificate);
   return oOut;
}

tBool midw_ipodauthfi_tclMsgAccessoryCertificateStatus::operator==(const midw_ipodauthfi_tclMsgAccessoryCertificateStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Certificate == roRef.Certificate);
   return bResult;
}

