/************************************************************************
 
 *FILE:           navifitypes.h
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer NachrichtenStrukturTypdefinitionen des navifi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           (t.b.a)
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef MIDW_HMI_GESTUREFITYPES_HEADER
#define MIDW_HMI_GESTUREFITYPES_HEADER


class midw_hmi_gesturefi_tclVisitorBase;

/* --NaviFI-MessageStrukturtypen --*/

// factory for midw_hmi_gesture_fi message types

fi_tclMessageBase* midw_hmi_gesturefi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode);

// base class for all ampfi messages

class midw_hmi_gesturefi_tclMsgBaseMessage : public midw_fi_tclVisitableTypeBase, public fi_tclMessageBase
{
public:
   // common functions
   virtual tU16 u16GetServiceID() const;
   virtual tU16 u16GetFunctionID() const;
   virtual tU8 u8GetOpCode() const;
   virtual const fi_tclTypeBase& corfoGetTypeBase() const;
   virtual fi_tclTypeBase& rfoGetTypeBase();

   // default implementation directly applicable to all messages without paramenters
   midw_hmi_gesturefi_tclMsgBaseMessage() { };
   virtual tU32 u32GetSize(tU16 u16MajorVersion) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
};

class midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& operator=(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& coRef);
   midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tclString szText;
   virtual ~midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart();
   virtual tVoid vDestroy();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodStart& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& operator=(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& coRef);
   midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 u8Result;
   virtual ~midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_gesturefi_tclMsgSetCharRecTextMethodResult& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgGestureEventUpReg : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgGestureEventUpReg();

   virtual ~midw_hmi_gesturefi_tclMsgGestureEventUpReg();

   inline tBool operator==(const midw_hmi_gesturefi_tclMsgGestureEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgGestureEventRelUpReg : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgGestureEventRelUpReg();

   virtual ~midw_hmi_gesturefi_tclMsgGestureEventRelUpReg();

   inline tBool operator==(const midw_hmi_gesturefi_tclMsgGestureEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgGestureEventSet : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgGestureEventSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_gesturefi_tclMsgGestureEventSet& operator=(const midw_hmi_gesturefi_tclMsgGestureEventSet& coRef);
   midw_hmi_gesturefi_tclMsgGestureEventSet(const midw_hmi_gesturefi_tclMsgGestureEventSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_Gesture_Type enGestureType;
   midw_fi_tcl_e32_HMI_Gesture_Event enGestureEvent;
   midw_fi_tcl_e32_HMI_Gesture_Direction enGestureDirection;
   midw_fi_tcl_HMI_GUI_Point rGesturePoint1;
   tBool bPoint1Valid;
   midw_fi_tcl_HMI_GUI_Point rGesturePoint2;
   tBool bPoint2Valid;
   virtual ~midw_hmi_gesturefi_tclMsgGestureEventSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_gesturefi_tclMsgGestureEventSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg();

   virtual ~midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg();

   inline tBool operator==(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg();

   virtual ~midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg();

   inline tBool operator==(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& operator=(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& coRef);
   midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_Touchpad_Gesture_Type enGestureType;
   midw_fi_tcl_e32_HMI_Gesture_Event enGestureEvent;
   midw_fi_tcl_e32_HMI_Gesture_Direction enGestureDirection;
   midw_fi_tcl_HMI_GUI_Point rGesturePoint1;
   tBool bPoint1Valid;
   midw_fi_tcl_HMI_GUI_Point rGesturePoint2;
   tBool bPoint2Valid;
   midw_fi_tcl_HMI_GUI_Point rGesturePoint3;
   tBool bPoint3Valid;
   virtual ~midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_gesturefi_tclMsgTouchpadGestureEventSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgEnableCharRecUpReg : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgEnableCharRecUpReg();

   virtual ~midw_hmi_gesturefi_tclMsgEnableCharRecUpReg();

   inline tBool operator==(const midw_hmi_gesturefi_tclMsgEnableCharRecUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg();

   virtual ~midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg();

   inline tBool operator==(const midw_hmi_gesturefi_tclMsgEnableCharRecRelUpReg& /* roRef */) const
      {  return true; }
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgEnableCharRecStatus : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgEnableCharRecStatus();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_gesturefi_tclMsgEnableCharRecStatus& operator=(const midw_hmi_gesturefi_tclMsgEnableCharRecStatus& coRef);
   midw_hmi_gesturefi_tclMsgEnableCharRecStatus(const midw_hmi_gesturefi_tclMsgEnableCharRecStatus& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_CharRecActionStatus enActionStatus;
   virtual ~midw_hmi_gesturefi_tclMsgEnableCharRecStatus();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_gesturefi_tclMsgEnableCharRecStatus& roRef) const;
   virtual tS32 s32GetTypeId() const;
};

class midw_hmi_gesturefi_tclMsgEnableCharRecSet : public midw_hmi_gesturefi_tclMsgBaseMessage
{
public:

   midw_hmi_gesturefi_tclMsgEnableCharRecSet();

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   midw_hmi_gesturefi_tclMsgEnableCharRecSet& operator=(const midw_hmi_gesturefi_tclMsgEnableCharRecSet& coRef);
   midw_hmi_gesturefi_tclMsgEnableCharRecSet(const midw_hmi_gesturefi_tclMsgEnableCharRecSet& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   midw_fi_tcl_e32_HMI_CharRecAction enAction;
   virtual ~midw_hmi_gesturefi_tclMsgEnableCharRecSet();

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   tBool operator==(const midw_hmi_gesturefi_tclMsgEnableCharRecSet& roRef) const;
   virtual tS32 s32GetTypeId() const;
};


#endif
